//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// バックバッファが BitmapRGBX なパネル
//

#pragma once

#include "wxnono.h"
#include "bitmap.h"

class WXBitmapPanel : public wxPanel
{
	using inherited = wxPanel;
 public:
	WXBitmapPanel(wxWindow *parent,
		const wxPoint& position = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = wxTAB_TRAVERSAL);
	WXBitmapPanel(wxWindow *parent, wxWindowID id,
		const wxPoint& position = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = wxTAB_TRAVERSAL);
	~WXBitmapPanel() override;

	// 背景色を設定する
	void SetBitmapBGColor(Color c);

	// 背景色で塗りつぶす
	void Fill();

	// サイズ固定。
	// バックバッファのサイズは通常ウィンドウのクライアントサイズから決まるが
	// 実画面に収まらないサイズのウィンドウを表示しようとすると、ウィンドウ
	// サイズは実画面でクリップされるため、バックバッファもこの大きさでクリップ
	// される。しかし、Bitmap クラスは範囲外への描画を自動クリップする機能を
	// 持っていないため、このままでは1文字の描画の途中で画像をはみ出るなどの
	// 問題が起きる。このようなケースのため、ウィンドウサイズとは関係なく
	// バックバッファを一定のサイズで確保したいための機能。
	// バックバッファより小さいウィンドウへの描画は問題なく行えるっぽい?。
	// 指定サイズを制約なく受け入れる場合は (0, 0) を指定する (デフォルト)。
	void SetMinBitmapSize(const wxSize& size);

 protected:
	void OnSize(wxSizeEvent&);
	void OnPaint(wxPaintEvent&);

	virtual void Draw();

	BitmapRGBX bitmap {};

	// 固定サイズ指定
	wxSize fixedsize {};

 private:
	BitmapRGB bitmap24 {};

	Color bitmap_bgcolor;

	wxDECLARE_EVENT_TABLE();
};
