//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// VirtIO エントロピーデバイス
//

#include "virtio_entropy.h"
#include "virtio_def.h"
#include "monitor.h"

// コンストラクタ
VirtIOEntropyDevice::VirtIOEntropyDevice(uint slot_)
	: inherited(OBJ_VIRTIO_ENTROPY, slot_)
{
	// 短縮形
	AddAlias("vent");

	device_id = VirtIO::DEVICE_ID_ENTROPY;
	int num_max = 4;
	vqueues.emplace_back(this, 0, "RequestQ", num_max);

	// 割り込み名
	strlcpy(intrname, "VIOEnt", sizeof(intrname));
	// 完了通知メッセージ
	msgid = MessageID::VIRTIO_ENTROPY_DONE;

	monitor = gMonitorManager->Regist(ID_MONITOR_VIRTIO_ENTROPY, this);
	monitor->SetCallback(&VirtIOEntropyDevice::MonitorScreen);
	monitor->SetSize(MONITOR_WIDTH, 2 + 4 * 1 + num_max + 3);
}

// デストラクタ
VirtIOEntropyDevice::~VirtIOEntropyDevice()
{
}

void
VirtIOEntropyDevice::MonitorScreen(Monitor *, TextScreen& screen)
{
	int y = 0;

	screen.Clear();

	y = MonitorScreenDev(screen, y);
	y++;
	y = MonitorScreenVirtQueue(screen, y, vqueues[0]);
	y++;
	y = MonitorScreenVirtQDesc(screen, y, vqueues[0]);
}

// ディスクリプタを一つ処理する。
void
VirtIOEntropyDevice::ProcessDesc(VirtIOReq& req)
{
	std::vector<uint32> buf(roundup(req.wlen, 4));

	for (auto&& d : buf) {
		d = rnd();
	}
	ReqWriteRegion(req, (const uint8 *)buf.data(), req.wlen);
}
