//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// メインバス (virt-m68k)
//

#pragma once

#include "mainbus.h"

class Virt68kMainbus : public MainbusDevice
{
	using inherited = MainbusDevice;
 public:
	Virt68kMainbus();
	~Virt68kMainbus() override;

	bool InitMainbus() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata ReadBurst16(busaddr addr, uint32 *dst) override;
	busdata WriteBurst16(busaddr addr, const uint32 *dst) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

 private:
	inline IODevice *Decoder(uint32) const;

	// ブートページを切り替える。
	void SwitchBootPage(bool isrom) override;

	std::unique_ptr<IODevice> pBusErr {};
	std::unique_ptr<IODevice> pInterrupt {};
	std::unique_ptr<IODevice> pMainRAM {};
	std::unique_ptr<IODevice> pV68kIO {};

	uint32 ramsize {};
};
