//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// エリアセット
//

#include "areaset.h"
#include "event.h"
#include "mpu.h"
#include "x68kio.h"

// コンストラクタ
AreaSetDevice::AreaSetDevice()
	: inherited(OBJ_AREASET)
{
}

// デストラクタ
AreaSetDevice::~AreaSetDevice()
{
}

// 初期化
bool
AreaSetDevice::Init()
{
	x68kio = GetX68kIODevice();

	return true;
}

// リセット
void
AreaSetDevice::ResetHard(bool poweron)
{
	// リセットでどうなるかは分からないけど、
	// さすがに不定ではないだろう。
	x68kio->SetAreaset(0);
}

busdata
AreaSetDevice::ReadPort(uint32 offset)
{
	putlog(2, "Read $%06x (BusErr)", mpu->GetPaddr());
	return BusData::BusErr;
}


busdata
AreaSetDevice::WritePort(uint32 offset, uint32 data)
{
	putlog(1, "Write $%06x <- $%02x", mpu->GetPaddr(), data);
	x68kio->SetAreaset(data);

	const busdata wait = busdata::Wait(7 * 40_nsec);
	busdata r = wait;
	r |= BusData::Size1;
	return r;
}

busdata
AreaSetDevice::PeekPort(uint32 offset)
{
	return BusData::BusErr;
}

bool
AreaSetDevice::PokePort(uint32 offset, uint32 data)
{
	// とりあえず
	return false;
}
