//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

#pragma once

#include "disasm.h"

class m88100disasm final : public DisasmLine
{
	using inherited = DisasmLine;
 public:
	m88100disasm();
	~m88100disasm() override;

	// 逆アセンブルを実行
	bool Exec(DebuggerMemoryStream *mem_) override;

	// 別ニーモニックを使うなら true (グローバル)
	static bool use_altname;

 private:
	uint32 xip {};

	uint32 opX  {};
	std::string name {};
	std::string arg0 {};
	std::string arg1 {};
	std::string arg2 {};
	// 別名用
	std::string altname {};
	std::string altarg0 {};
	std::string altarg1 {};
	std::string altarg2 {};

	std::string rd();
	std::string rs1();
	std::string rs2();
	std::string imm16();
	std::string d16();
	std::string d26();
	std::string crs();
	std::string fcrs();
	std::string fsize(uint32 t);
	std::string fsize();
	std::string wo5();
	uint32      wo5mask();
	std::string cio();
	std::string b5();
	std::string m5();
	std::string alt_m5();
	std::string vec9();

	void ops_bb(std::string namebase);
	void ops_bcnd(std::string n);
	void ops_tb(std::string namebase);
	void ops_ldst_imm(const std::string& namebase);
	void ops_ldst_reg(const std::string& namebase, std::string suffix);

	void op_unimpl();

#define OP_PROTO(name)	void __CONCAT(op_,name)()
#include "m88100ops.h"
#undef OP_PROTO
};
