//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ホストネットワークのドライバ (基本クラス)
//

#pragma once

#include "driver.h"
#include "autofd.h"

class NetPacket;

class NetDriver : public Driver
{
	using inherited = Driver;

 protected:
	NetDriver(HostDevice *hostdev_, const char *drivername_);
 public:
	~NetDriver() override;

	// パケットを外部から受信する。
	// VM に送り込むパケットがなければ負数(NODATA)を返す。
	// VM に送り込むパケットがあれば p に書き戻して、ドライバ側のバッファに
	// 残っているパケット数 (といっても 0 か 1以上) を返す。
	virtual int Read(NetPacket *p) = 0;

	// パケットを外部に送信する。
	virtual void Write(const void *buf, int buflen) = 0;

 protected:
	// ifup/ifdown スクリプト実行
	bool Run_ifup();
	bool Run_ifdown();

	std::string ifname {};		// (あれば)作成したインタフェース名

	// デバイスディスクリプタ。
	// ディスクリプタを持つというのは共通なのでディスクリプタはここに置くが
	// これを Open(), Close() するのはあくまで継承側の仕事で、こちらでは
	// 初期化と IsOpen() だけ受け持つ。ちょっと責任分界点が気持ち悪いけど。
	autofd fd {};

 private:
	bool RunScript(const char *filename);
};
