/*	$NetBSD$	*/

/*
 * Copyright (C) 2019 Y.Sugahara (moveccr). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "fpu_emulate.h"

struct fpn *
fpu_cmp(struct fpemu *fe)
{
	struct fpn *x = &fe->fe_f1, *y = &fe->fe_f2;
	int N;
	int Z;

	N = x->fp_sign;
	Z = 0;

	if (ISNAN(x)) {
		return x;
	} else if (ISNAN(y)) {
		return y;
	} else if (ISINF(x)) {
		/* dst:INF src:NUM,ZERO,INF */
		Z = ISINF(y) && (x->fp_sign == y->fp_sign);
	} else if (ISINF(y)) {
		/* dst:NUM,ZERO src:INF */
		N = !y->fp_sign;
	} else if (ISZERO(x)) {
		/* dst:ZERO src:NUM,ZERO */
		if (ISZERO(y)) {
			Z = 1;
		} else {
			N = !y->fp_sign;
		}
	} else if (ISZERO(y)) {
		/* dst:NUM src:ZERO */
		/* nop. done by initial */
	} else {
		/* dst:NUM src:NUM */
		if (x->fp_sign != y->fp_sign) {
			/* dst:+ src:- or dst:- src:+ */
			/* nop. done by initial */
		} else {
			/* dst:+ src:+ or dst:- src:- */
			if (x->fp_exp > y->fp_exp) {
				/* nop. done by initial */
			} else if (x->fp_exp < y->fp_exp) {
				N = !N;
			} else {
				/* if block when nop, done by initial */
				if (x->fp_mant[0] > y->fp_mant[0]) {
				} else if (x->fp_mant[0] < y->fp_mant[0]) {
					N = !N;
				} else if (x->fp_mant[1] > y->fp_mant[1]) {
				} else if (x->fp_mant[1] < y->fp_mant[1]) {
					N = !N;
				} else if (x->fp_mant[2] > y->fp_mant[2]) {
				} else if (x->fp_mant[2] < y->fp_mant[2]) {
					N = !N;
				} else {
					Z = 1;
				}
			}
		}
	}
	if (Z) {
		x->fp_class = FPC_ZERO;
	} else {
		/* Any non-zero value */
		x->fp_class = FPC_NUM;
		x->fp_exp = 0;
		x->fp_mant[0] = FP_1;
		x->fp_mant[1] = 0;
		x->fp_mant[2] = 0;
	}
	x->fp_sign = N;

	return x;
}
