---
title: Users
...

# Notable projects and organizations using Meson

If you're aware of a notable project that uses Meson, please
[file a pull-request](https://github.com/mesonbuild/meson/edit/master/docs/markdown/Users.md)
for it. For other projects using Meson, you may be interested in this
[GitHub search](https://github.com/search?q=path%3A%2F%28%5E%7C%5C%2F%29meson%5C.build%24%2F&type=code).
Some additional projects are listed in the [`meson` GitHub
topic](https://github.com/topics/meson).

## [Xorg](https://www.x.org)

 - [Xserver](https://gitlab.freedesktop.org/xorg/xserver), the X.org display server

## [Gnome](https://www.gnome.org)

 - [GTK](https://gitlab.gnome.org/GNOME/gtk), the multi-platform toolkit used by GNOME
 - [GLib](https://gitlab.gnome.org/GNOME/glib), cross-platform C library used by GTK+ and GStreamer

## [Enlightenment](https://www.enlightenment.org/)

 - [EFL](https://www.enlightenment.org/about-efl), multiplatform set of libraries, used by the Enlightenment windows manager and other projects

## [Elementary OS](https://github.com/elementary/)

## [cinnamon-desktop](https://github.com/linuxmint/cinnamon-desktop)

 - [Nemo](https://github.com/linuxmint/nemo), the file manager for the Cinnamon desktop environment

## [Budgie Desktop](https://github.com/budgie-desktop/budgie-desktop)

## Other Notable projects

 - [FreeType](https://freetype.org/), widely used open source font rendering engine
 - [GIMP](https://gitlab.gnome.org/GNOME/gimp), an image manipulation program (master branch)
 - [GStreamer](https://gitlab.freedesktop.org/gstreamer/gstreamer), multimedia framework
 - [Git](https://git-scm.com/), ["the information manager from hell"](https://github.com/git/git/commit/e83c5163316f89bfbde7d9ab23ca2e25604af290)
 - [HarfBuzz](https://github.com/harfbuzz/harfbuzz), a text shaping engine
 - [HexChat](https://github.com/hexchat/hexchat), a cross-platform IRC client in C
 - [LXC](https://github.com/lxc/lxc), Linux container runtime
 - [Linux PAM](https://github.com/linux-pam/linux-pam), The Pluggable Authentication Modules project for Linux
 - [Mesa](https://mesa3d.org/), an open source graphics driver project
 - [mpv](https://github.com/mpv-player/mpv), a free, open source, and cross-platform media player
 - [NumPy](https://numpy.org/), a Python package for scientific computing
 - [OpenH264](https://github.com/cisco/openh264), open source H.264 codec
 - [OpenRC](https://github.com/OpenRC/openrc), an init system for Unix-like operating systems
 - [Pacman](https://gitlab.archlinux.org/pacman/pacman.git), a package manager for Arch Linux
 - [PicoLibc](https://github.com/keith-packard/picolibc), a standard C library for small embedded systems with limited RAM
 - [PipeWire](https://github.com/PipeWire/pipewire), a framework for video and audio for containerized applications
 - [PostgreSQL](https://www.postgresql.org/), an advanced open source relational database
 - [QEMU](https://qemu.org), a processor emulator and virtualizer
 - [SciPy](https://scipy.org/), an open-source software for mathematics, science, and engineering
 - [systemd](https://github.com/systemd/systemd), the init system
 - [Wayland](https://gitlab.freedesktop.org/wayland/wayland), common display protocol
