/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOUtils {
    private static IOUtils instance;
    private static final Log logger;

    private IOUtils() {
    }

    public static synchronized IOUtils getInstance() {
        if (instance == null) {
            instance = new IOUtils();
        }
        return instance;
    }

    private boolean isFileStyleProtocol(URL url) {
        if (url == null) {
            throw new NullPointerException();
        }
        String protocol = url.getProtocol();
        if ("http".equals(protocol)) {
            return true;
        }
        if ("https".equals(protocol)) {
            return true;
        }
        if ("ftp".equals(protocol)) {
            return true;
        }
        if ("file".equals(protocol)) {
            return true;
        }
        return "jar".equals(protocol);
    }

    private List parseName(String name) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer strTok = new StringTokenizer(name, "/");
        while (strTok.hasMoreElements()) {
            String s = (String)strTok.nextElement();
            if (s.length() == 0) continue;
            list.add(s);
        }
        return list;
    }

    private String formatName(List name, String query) {
        StringBuffer b = new StringBuffer(128);
        Iterator it = name.iterator();
        while (it.hasNext()) {
            b.append(it.next());
            if (!it.hasNext()) continue;
            b.append('/');
        }
        if (query != null) {
            b.append('?');
            b.append(query);
        }
        return b.toString();
    }

    private int startsWithUntil(List baseName, List urlName) {
        int minIdx = Math.min(urlName.size(), baseName.size());
        for (int i = 0; i < minIdx; ++i) {
            String urlToken;
            String baseToken = (String)baseName.get(i);
            if (baseToken.equals(urlToken = (String)urlName.get(i))) continue;
            return i;
        }
        return minIdx;
    }

    private boolean isSameService(URL url, URL baseUrl) {
        if (!url.getProtocol().equals(baseUrl.getProtocol())) {
            return false;
        }
        if (!url.getHost().equals(baseUrl.getHost())) {
            return false;
        }
        return url.getPort() == baseUrl.getPort();
    }

    public String createRelativePath(String targetFile, String baseFile) {
        if (targetFile == null) {
            throw new NullPointerException("targetFile must not be null.");
        }
        if (baseFile == null) {
            throw new NullPointerException("baseFile must not be null.");
        }
        List baseName = this.parseName(baseFile);
        if (baseName.isEmpty()) {
            return targetFile;
        }
        List urlName = this.parseName(targetFile);
        if (urlName.isEmpty()) {
            return targetFile;
        }
        if (!(baseFile.length() > 0 && baseFile.charAt(baseFile.length() - 1) == '/')) {
            baseName.remove(baseName.size() - 1);
        }
        if (baseFile.equals(targetFile)) {
            return (String)urlName.get(urlName.size() - 1);
        }
        int commonIndex = this.startsWithUntil(urlName, baseName);
        if (commonIndex == 0) {
            return targetFile;
        }
        if (commonIndex == urlName.size()) {
            --commonIndex;
        }
        ArrayList<String> retval = new ArrayList<String>();
        if (baseName.size() + 1 != urlName.size()) {
            int levels = baseName.size() - commonIndex;
            for (int i = 0; i < levels; ++i) {
                retval.add("..");
            }
        }
        retval.addAll(urlName.subList(commonIndex, urlName.size()));
        return this.formatName(retval, null);
    }

    public String createRelativeURL(URL url, URL baseURL) {
        if (url == null) {
            throw new NullPointerException("content url must not be null.");
        }
        if (baseURL == null) {
            throw new NullPointerException("baseURL must not be null.");
        }
        if (this.isFileStyleProtocol(url) && this.isSameService(url, baseURL)) {
            List urlName = this.parseName(this.getPath(url));
            List baseName = this.parseName(this.getPath(baseURL));
            String query = this.getQuery(url);
            if (!this.isPath(baseURL)) {
                baseName.remove(baseName.size() - 1);
            }
            if (String.valueOf(url).equals(String.valueOf(baseURL))) {
                return (String)urlName.get(urlName.size() - 1);
            }
            int commonIndex = this.startsWithUntil(urlName, baseName);
            if (commonIndex == 0) {
                return url.toExternalForm();
            }
            if (commonIndex == urlName.size()) {
                --commonIndex;
            }
            ArrayList<String> retval = new ArrayList<String>();
            if (baseName.size() != urlName.size()) {
                int levels = baseName.size() - commonIndex;
                for (int i = 0; i < levels; ++i) {
                    retval.add("..");
                }
            }
            retval.addAll(urlName.subList(commonIndex, urlName.size()));
            return this.formatName(retval, query);
        }
        return url.toExternalForm();
    }

    private boolean isPath(URL baseURL) {
        String path = this.getPath(baseURL);
        if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            return true;
        }
        if ("file".equals(baseURL.getProtocol())) {
            File f = new File(path);
            try {
                if (f.isDirectory()) {
                    return true;
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        return false;
    }

    private String getQuery(URL url) {
        String file = url.getFile();
        int queryIndex = file.indexOf(63);
        if (queryIndex == -1) {
            return null;
        }
        return file.substring(queryIndex + 1);
    }

    private String getPath(URL url) {
        String file = url.getFile();
        int queryIndex = file.indexOf(63);
        if (queryIndex == -1) {
            return file;
        }
        return file.substring(0, queryIndex);
    }

    public void copyStreams(InputStream in, OutputStream out) throws IOException {
        this.copyStreams(in, out, 4096);
    }

    public void copyStreams(InputStream in, OutputStream out, int buffersize) throws IOException {
        byte[] bytes = new byte[buffersize];
        int bytesRead = in.read(bytes);
        while (bytesRead > -1) {
            out.write(bytes, 0, bytesRead);
            bytesRead = in.read(bytes);
        }
    }

    public void copyWriter(Reader in, Writer out) throws IOException {
        this.copyWriter(in, out, 4096);
    }

    public void copyWriter(Reader in, Writer out, int buffersize) throws IOException {
        char[] bytes = new char[buffersize];
        int bytesRead = in.read(bytes);
        while (bytesRead > -1) {
            out.write(bytes, 0, bytesRead);
            bytesRead = in.read(bytes);
        }
    }

    public void readFully(InputStream in, byte[] data, int offset, int length) throws IOException {
        int size;
        int bytesToRead = length;
        int bytesRead = 0;
        do {
            if ((size = in.read(data, offset + bytesRead, bytesToRead)) == -1) {
                throw new IOException("End-Of-File reached");
            }
            bytesRead += size;
        } while ((bytesToRead -= size) > 0);
    }

    public int readSafely(InputStream in, byte[] data, int offset, int length) throws IOException {
        int size;
        int bytesToRead = length;
        int bytesRead = 0;
        do {
            if ((size = in.read(data, offset + bytesRead, bytesToRead)) == -1) {
                return bytesRead;
            }
            bytesRead += size;
        } while ((bytesToRead -= size) > 0);
        return 0;
    }

    public String getFileName(URL url) {
        String fileRaw = url.getFile();
        int query = fileRaw.lastIndexOf(63);
        String file = query == -1 ? fileRaw : fileRaw.substring(0, query);
        return this.getFileName(file);
    }

    public String getFileName(String path) {
        int last = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (last < 0) {
            return path;
        }
        return path.substring(last + 1);
    }

    public String stripFileExtension(String file) {
        int idx = file.lastIndexOf(46);
        if (idx < 1) {
            return file;
        }
        return file.substring(0, idx);
    }

    public String getFileExtension(String file) {
        int idx = file.lastIndexOf(46);
        if (idx < 1) {
            return "";
        }
        return file.substring(idx);
    }

    public boolean isSubDirectory(File base, File child) throws IOException {
        base = base.getCanonicalFile();
        for (File parentFile = child = child.getCanonicalFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!base.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    public File findFileOnClassPath(String name) throws SecurityException {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File target;
            String pathElement = tokenizer.nextToken();
            File directoryOrJar = new File(pathElement);
            File absoluteDirectoryOrJar = directoryOrJar.getAbsoluteFile();
            if (!(absoluteDirectoryOrJar.isFile() ? (target = new File(absoluteDirectoryOrJar.getParent(), name)).exists() : (target = new File(directoryOrJar, name)).exists())) continue;
            return target;
        }
        return null;
    }

    public String getAbsolutePath(String targetFile, String baseFile) {
        if (targetFile == null) {
            throw new NullPointerException("targetFile must not be null.");
        }
        if (baseFile == null || "".equals(baseFile)) {
            return this.stripNavigationPaths(targetFile);
        }
        if (targetFile.length() > 0 && targetFile.charAt(0) == '/') {
            return this.stripNavigationPaths(targetFile.substring(1));
        }
        List baseName = this.parseName(baseFile);
        if (baseName.isEmpty()) {
            return this.stripNavigationPaths(targetFile);
        }
        List urlName = this.parseName(targetFile);
        if (urlName.isEmpty()) {
            return this.stripNavigationPaths(baseFile);
        }
        if (!(baseFile.length() > 0 && baseFile.charAt(baseFile.length() - 1) == '/')) {
            baseName.remove(baseName.size() - 1);
            if (baseName.isEmpty()) {
                return this.stripNavigationPaths(targetFile);
            }
        }
        for (int i = 0; i < urlName.size(); ++i) {
            String pathElement = (String)urlName.get(i);
            if ("".equals(pathElement) || pathElement == null || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (baseName.isEmpty()) continue;
                baseName.remove(baseName.size() - 1);
                continue;
            }
            baseName.add(pathElement);
        }
        String s = this.formatName(baseName, null);
        if (targetFile.length() > 0 && targetFile.charAt(targetFile.length() - 1) == '/') {
            return s + '/';
        }
        return s;
    }

    private String stripNavigationPaths(String targetFile) {
        List list = this.parseName(targetFile);
        int capacity = list.size();
        ArrayList<String> path = new ArrayList<String>(capacity);
        for (int i = 0; i < capacity; ++i) {
            String pathElement = (String)list.get(i);
            if ("".equals(pathElement) || pathElement == null || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (path.isEmpty()) continue;
                path.remove(path.size() - 1);
                continue;
            }
            path.add(pathElement);
        }
        String s = this.formatName(path, null);
        if (targetFile.length() > 0 && targetFile.charAt(targetFile.length() - 1) == '/') {
            return s + '/';
        }
        return s;
    }

    public String getPath(String path) {
        int last = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (last < 0) {
            return "";
        }
        return path.substring(0, last);
    }

    public String readClob(Clob clob) {
        try {
            long length = clob.length();
            if (length > Integer.MAX_VALUE) {
                logger.warn((Object)"This CLOB contains more than 2^31 characters. We cannot handle that.");
                return null;
            }
            Reader inStream = clob.getCharacterStream();
            StringWriter outStream = new StringWriter((int)length);
            try {
                IOUtils.getInstance().copyWriter(inStream, outStream);
            }
            catch (IOException e) {
                logger.warn((Object)"Copying the stream failed.", (Throwable)e);
            }
            try {
                inStream.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close input stream. No worries, we will be alright anyway.", (Throwable)e);
            }
            return outStream.toString();
        }
        catch (SQLException e) {
            return null;
        }
    }

    public byte[] readBlob(Blob clob) throws SQLException {
        long length = clob.length();
        if (length > Integer.MAX_VALUE) {
            logger.warn((Object)"This CLOB contains more than 2^31 characters. We cannot handle that.");
            return null;
        }
        InputStream inStream = clob.getBinaryStream();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream((int)length);
        try {
            IOUtils.getInstance().copyStreams(inStream, outStream);
        }
        catch (IOException e) {
            logger.warn((Object)"Copying the stream failed.", (Throwable)e);
        }
        try {
            inStream.close();
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to close input stream. No worries, we will be alright anyway.", (Throwable)e);
        }
        return outStream.toByteArray();
    }

    static {
        logger = LogFactory.getLog(IOUtils.class);
    }
}

