/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.client.internal.util.Check;
import org.sonatype.nexus.client.rest.AuthenticationInfo;
import org.sonatype.nexus.client.rest.BaseUrl;
import org.sonatype.nexus.client.rest.Protocol;
import org.sonatype.nexus.client.rest.ProxyInfo;

public class ConnectionInfo {
    private final BaseUrl baseUrl;
    private final AuthenticationInfo authenticationInfo;
    private final Map<Protocol, ProxyInfo> proxyInfos;
    private final ValidationLevel sslCertificateValidation;
    private final ValidationLevel sslCertificateHostnameValidation;

    public ConnectionInfo(BaseUrl baseUrl, AuthenticationInfo authenticationInfo, Map<Protocol, ProxyInfo> proxyInfos) {
        this(baseUrl, authenticationInfo, proxyInfos, ValidationLevel.STRICT, ValidationLevel.LAX);
    }

    public ConnectionInfo(BaseUrl baseUrl, AuthenticationInfo authenticationInfo, Map<Protocol, ProxyInfo> proxyInfos, ValidationLevel sslCertificateValidation, ValidationLevel sslCertificateHostnameValidation) {
        this.baseUrl = Check.notNull(baseUrl, "Base URL is null!");
        this.authenticationInfo = authenticationInfo;
        HashMap<Protocol, ProxyInfo> proxies = new HashMap<Protocol, ProxyInfo>();
        if (proxyInfos != null) {
            proxies.putAll(proxyInfos);
        }
        this.proxyInfos = Collections.unmodifiableMap(proxies);
        this.sslCertificateValidation = Check.notNull(sslCertificateValidation, "sslCertificateValidation is null!");
        this.sslCertificateHostnameValidation = Check.notNull(sslCertificateHostnameValidation, "sslCertificateHostnameValidation is null");
    }

    public BaseUrl getBaseUrl() {
        return this.baseUrl;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public Map<Protocol, ProxyInfo> getProxyInfos() {
        return this.proxyInfos;
    }

    public ValidationLevel getSslCertificateValidation() {
        return this.sslCertificateValidation;
    }

    public ValidationLevel getSslCertificateHostnameValidation() {
        return this.sslCertificateHostnameValidation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        sb.append("url=").append(this.getBaseUrl());
        if (this.getAuthenticationInfo() != null) {
            sb.append(",authc=").append(this.getAuthenticationInfo());
        }
        if (!this.getProxyInfos().isEmpty()) {
            sb.append(",proxy=").append(this.getProxyInfos());
        }
        sb.append(",sslCertificateValidation=").append((Object)this.getSslCertificateValidation());
        sb.append(",sslCertificateHostnameValidation=").append((Object)this.getSslCertificateHostnameValidation());
        sb.append(")");
        return sb.toString();
    }

    public static enum ValidationLevel {
        NONE,
        LAX,
        STRICT;

    }
}

