/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.version.VersionConstraint;
import org.sonatype.aether.version.VersionRange;

@Component(role=DependencyGraphBuilder.class, hint="maven3")
public class Maven3DependencyGraphBuilder
implements DependencyGraphBuilder {
    @Requirement
    private ProjectDependenciesResolver resolver;
    @Requirement
    private ArtifactFactory factory;

    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter) throws DependencyGraphBuilderException {
        try {
            ProjectBuildingRequest projectBuildingRequest = (ProjectBuildingRequest)this.invoke(project, "getProjectBuildingRequest");
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, projectBuildingRequest.getRepositorySession());
            DependencyResolutionResult result = this.resolver.resolve((DependencyResolutionRequest)request);
            return this.buildDependencyNode(null, result.getDependencyGraph(), project.getArtifact(), filter);
        }
        catch (DependencyResolutionException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
    }

    private Object invoke(Object object, String method) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return object.getClass().getMethod(method, new Class[0]).invoke(object, new Object[0]);
    }

    private org.apache.maven.artifact.Artifact getDependencyArtifact(Dependency dep) {
        Artifact artifact = dep.getArtifact();
        return this.factory.createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), org.apache.maven.artifact.versioning.VersionRange.createFromVersion((String)artifact.getVersion()), artifact.getProperty("type", artifact.getExtension()), artifact.getClassifier(), dep.getScope(), dep.isOptional());
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.sonatype.aether.graph.DependencyNode node, org.apache.maven.artifact.Artifact artifact, ArtifactFilter filter) {
        DefaultDependencyNode current = new DefaultDependencyNode(parent, artifact, null, null, this.getVersionSelectedFromRange(node.getVersionConstraint()));
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.sonatype.aether.graph.DependencyNode child : node.getChildren()) {
            org.apache.maven.artifact.Artifact childArtifact = this.getDependencyArtifact(child.getDependency());
            if (filter != null && !filter.include(childArtifact)) continue;
            nodes.add(this.buildDependencyNode(current, child, childArtifact, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }

    private String getVersionSelectedFromRange(VersionConstraint constraint) {
        if (constraint == null || constraint.getVersion() != null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (VersionRange range : constraint.getRanges()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(range);
        }
        return sb.toString();
    }
}

