/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.BiProperty;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.booter.DumpErrorSingleton;
import org.apache.maven.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.booter.MasterProcessCommand;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.provider.CommandChainReader;
import org.apache.maven.surefire.api.provider.CommandListener;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.shared.utils.StringUtils;

public final class CommandReader
implements CommandChainReader {
    private static final String LAST_TEST_SYMBOL = "";
    private final Queue<BiProperty<MasterProcessCommand, CommandListener>> listeners = new ConcurrentLinkedQueue<BiProperty<MasterProcessCommand, CommandListener>>();
    private final Thread commandThread = DaemonThreadFactory.newDaemonThread((Runnable)new CommandRunnable(), (String)"surefire-forkedjvm-command-thread");
    private final AtomicReference<Thread.State> state = new AtomicReference<Thread.State>(Thread.State.NEW);
    private final CountDownLatch startMonitor = new CountDownLatch(1);
    private final Semaphore nextCommandNotifier = new Semaphore(0);
    private final CopyOnWriteArrayList<String> testClasses = new CopyOnWriteArrayList();
    private final MasterProcessChannelDecoder decoder;
    private final Shutdown shutdown;
    private final ConsoleLogger logger;
    private int iteratedCount;

    public CommandReader(MasterProcessChannelDecoder decoder, Shutdown shutdown, ConsoleLogger logger) {
        this.decoder = Objects.requireNonNull(decoder, "null decoder");
        this.shutdown = Objects.requireNonNull(shutdown, "null Shutdown config");
        this.logger = Objects.requireNonNull(logger, "null logger");
        this.state.set(Thread.State.RUNNABLE);
        this.commandThread.start();
    }

    public boolean awaitStarted() throws TestSetFailedException {
        if (this.state.get() == Thread.State.RUNNABLE) {
            try {
                this.startMonitor.await();
                return true;
            }
            catch (InterruptedException e) {
                DumpErrorSingleton.getSingleton().dumpException((Throwable)e);
                throw new TestSetFailedException(e.getLocalizedMessage());
            }
        }
        return false;
    }

    public void addSkipNextTestsListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.SKIP_SINCE_NEXT_TEST, listener);
    }

    public void addShutdownListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.SHUTDOWN, listener);
    }

    public void addNoopListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.NOOP, listener);
    }

    public void addByeAckListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.BYE_ACK, listener);
    }

    private void addListener(MasterProcessCommand cmd, CommandListener listener) {
        this.listeners.add((BiProperty<MasterProcessCommand, CommandListener>)new BiProperty((Object)cmd, (Object)listener));
    }

    Iterator<String> iterated() {
        return this.testClasses.subList(0, this.iteratedCount).iterator();
    }

    Iterable<String> getIterableClasses(MasterProcessChannelEncoder eventChannel) {
        return new ClassesIterable(eventChannel);
    }

    public void stop() {
        if (!this.isStopped()) {
            this.state.set(Thread.State.TERMINATED);
            this.makeQueueFull();
            this.listeners.clear();
            this.commandThread.interrupt();
        }
    }

    private boolean isStopped() {
        return this.state.get() == Thread.State.TERMINATED;
    }

    private boolean isQueueFull() {
        int searchFrom = StrictMath.max(0, this.testClasses.size() - 1);
        return this.testClasses.indexOf(LAST_TEST_SYMBOL, searchFrom) != -1;
    }

    private void makeQueueFull() {
        this.testClasses.addIfAbsent(LAST_TEST_SYMBOL);
    }

    private boolean insertToQueue(String test) {
        return StringUtils.isNotBlank((String)test) && !this.isQueueFull() && this.testClasses.add(test);
    }

    private void awaitNextTest() {
        this.nextCommandNotifier.acquireUninterruptibly();
    }

    private void wakeupIterator() {
        this.nextCommandNotifier.release();
    }

    private final class CommandRunnable
    implements Runnable {
        private CommandRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            CommandReader.this.startMonitor.countDown();
            boolean isTestSetFinished = false;
            try (MasterProcessChannelDecoder commandReader = CommandReader.this.decoder;){
                block22: while (CommandReader.this.state.get() == Thread.State.RUNNABLE) {
                    Command command = commandReader.decode();
                    switch (command.getCommandType()) {
                        case RUN_CLASS: {
                            String test = command.getData();
                            boolean inserted = CommandReader.this.insertToQueue(test);
                            if (!inserted) continue block22;
                            CommandReader.this.wakeupIterator();
                            this.callListeners(command);
                            continue block22;
                        }
                        case TEST_SET_FINISHED: {
                            CommandReader.this.makeQueueFull();
                            isTestSetFinished = true;
                            CommandReader.this.wakeupIterator();
                            this.callListeners(command);
                            continue block22;
                        }
                        case SHUTDOWN: {
                            CommandReader.this.makeQueueFull();
                            CommandReader.this.wakeupIterator();
                            this.callListeners(command);
                            continue block22;
                        }
                        case BYE_ACK: {
                            this.callListeners(command);
                            CommandReader.this.state.set(Thread.State.TERMINATED);
                            continue block22;
                        }
                    }
                    this.callListeners(command);
                }
                return;
            }
            catch (EOFException | ClosedChannelException e) {
                CommandReader.this.state.set(Thread.State.TERMINATED);
                if (isTestSetFinished) return;
                String msg = "TestSet has not finished before stream error has appeared >> initializing exit by non-null configuration: " + CommandReader.this.shutdown;
                DumpErrorSingleton.getSingleton().dumpStreamException((Throwable)e, msg);
                this.exitByConfiguration();
                return;
            }
            catch (IOException e) {
                CommandReader.this.state.set(Thread.State.TERMINATED);
                if (e instanceof InterruptedIOException) return;
                if (e.getCause() instanceof InterruptedException) return;
                String msg = "[SUREFIRE] std/in stream corrupted";
                DumpErrorSingleton.getSingleton().dumpStreamException((Throwable)e, msg);
                CommandReader.this.logger.error(msg, (Throwable)e);
                return;
            }
            finally {
                if (!isTestSetFinished) {
                    CommandReader.this.makeQueueFull();
                }
                CommandReader.this.wakeupIterator();
            }
        }

        private void callListeners(Command cmd) {
            MasterProcessCommand expectedCommandType = cmd.getCommandType();
            for (BiProperty listenerWrapper : CommandReader.this.listeners) {
                MasterProcessCommand commandType = (MasterProcessCommand)listenerWrapper.getP1();
                CommandListener listener = (CommandListener)listenerWrapper.getP2();
                if (commandType != null && commandType != expectedCommandType) continue;
                listener.update(cmd);
            }
        }

        private void exitByConfiguration() {
            Shutdown shutdown = CommandReader.this.shutdown;
            if (shutdown != null) {
                CommandReader.this.makeQueueFull();
                CommandReader.this.wakeupIterator();
                this.callListeners(Command.toShutdown((Shutdown)shutdown));
            }
        }
    }

    private final class ClassesIterator
    implements Iterator<String> {
        private final MasterProcessChannelEncoder eventChannel;
        private String clazz;
        private int nextQueueIndex;

        private ClassesIterator(MasterProcessChannelEncoder eventChannel) {
            this.eventChannel = eventChannel;
        }

        @Override
        public boolean hasNext() {
            this.popUnread();
            return StringUtils.isNotBlank((String)this.clazz);
        }

        @Override
        public String next() {
            this.popUnread();
            try {
                if (StringUtils.isBlank((String)this.clazz)) {
                    throw new NoSuchElementException(CommandReader.this.isStopped() ? "stream was stopped" : CommandReader.LAST_TEST_SYMBOL);
                }
                String string = this.clazz;
                return string;
            }
            finally {
                this.clazz = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void popUnread() {
            if (this.shouldFinish()) {
                this.clazz = null;
                return;
            }
            if (StringUtils.isBlank((String)this.clazz)) {
                this.requestNextTest();
                CommandReader.this.awaitNextTest();
                if (this.shouldFinish()) {
                    this.clazz = null;
                    return;
                }
                this.clazz = (String)CommandReader.this.testClasses.get(this.nextQueueIndex++);
                CommandReader.this.iteratedCount = this.nextQueueIndex;
            }
            if (CommandReader.this.isStopped()) {
                this.clazz = null;
            }
        }

        private void requestNextTest() {
            this.eventChannel.acquireNextTest();
        }

        private boolean shouldFinish() {
            boolean wasLastTestRead = this.isEndSymbolAt(this.nextQueueIndex);
            return CommandReader.this.isStopped() || wasLastTestRead;
        }

        private boolean isEndSymbolAt(int index) {
            return CommandReader.this.isQueueFull() && 1 + index == CommandReader.this.testClasses.size();
        }
    }

    private final class ClassesIterable
    implements Iterable<String> {
        private final MasterProcessChannelEncoder eventChannel;

        ClassesIterable(MasterProcessChannelEncoder eventChannel) {
            this.eventChannel = eventChannel;
        }

        @Override
        public Iterator<String> iterator() {
            return new ClassesIterator(this.eventChannel);
        }
    }
}

