/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.rayo;

import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.rayo.DialIq;
import org.jitsi.xmpp.extensions.rayo.EndExtension;
import org.jitsi.xmpp.extensions.rayo.HangUp;
import org.jitsi.xmpp.extensions.rayo.HeaderExtension;
import org.jitsi.xmpp.extensions.rayo.RayoIq;
import org.jitsi.xmpp.extensions.rayo.RefIq;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;

public class RayoIqProvider
extends SafeParseIqProvider<RayoIq> {
    public static final String NAMESPACE = "urn:xmpp:rayo:1";

    public void registerRayoIQs() {
        ProviderManager.addIQProvider((String)"dial", (String)NAMESPACE, (Object)((Object)this));
        ProviderManager.addIQProvider((String)"ref", (String)NAMESPACE, (Object)((Object)this));
        ProviderManager.addIQProvider((String)"hangup", (String)NAMESPACE, (Object)((Object)this));
        ProviderManager.addExtensionProvider((String)"end", (String)NAMESPACE, new DefaultPacketExtensionProvider<EndExtension>(EndExtension.class));
        ProviderManager.addExtensionProvider((String)"header", (String)NAMESPACE, new DefaultPacketExtensionProvider<HeaderExtension>(HeaderExtension.class));
    }

    @Override
    protected RayoIq doParse(XmlPullParser parser) throws Exception {
        RayoIq iq;
        String namespace = parser.getNamespace();
        if (!NAMESPACE.equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("dial".equals(rootElement)) {
            DialIq dial;
            iq = dial = new DialIq();
            String src = parser.getAttributeValue("", "from");
            String dst = parser.getAttributeValue("", "to");
            if (StringUtils.isEmpty((CharSequence)dst)) {
                return null;
            }
            dial.setSource(src);
            dial.setDestination(dst);
        } else if ("ref".equals(rootElement)) {
            RefIq ref = new RefIq();
            iq = ref;
            String uri = parser.getAttributeValue("", "uri");
            if (StringUtils.isEmpty((CharSequence)uri)) {
                return null;
            }
            ref.setUri(uri);
        } else if ("hangup".equals(rootElement)) {
            iq = new HangUp();
        } else {
            return null;
        }
        boolean done = false;
        HeaderExtension header = null;
        while (!done) {
            switch (parser.next()) {
                case END_ELEMENT: {
                    String name = parser.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"header".equals(name) || header == null) break;
                    iq.addExtension(header);
                    header = null;
                    break;
                }
                case START_ELEMENT: {
                    String name = parser.getName();
                    if (!"header".equals(name)) break;
                    header = new HeaderExtension();
                    String nameAttr = parser.getAttributeValue("", "name");
                    header.setName(nameAttr);
                    String valueAttr = parser.getAttributeValue("", "value");
                    header.setValue(valueAttr);
                    break;
                }
            }
        }
        return iq;
    }
}

