/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;

@Mojo(name="rootlocation", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true, requiresProject=true)
public class RootLocationMojo
extends AbstractDefinePropertyMojo {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(property="buildhelper.runOnlyAtExecutionRoot", defaultValue="false")
    private boolean runOnlyAtExecutionRoot;
    @Parameter(defaultValue="rootlocation")
    private String rootLocationProperty;

    public void execute() throws MojoFailureException {
        if (this.runOnlyAtExecutionRoot && !this.getProject().isExecutionRoot()) {
            this.getLog().info((CharSequence)"Skip getting the rootlocation in this project because it's not the Execution Root");
        } else {
            try {
                MavenProject topLevelProject = this.getLocalRoot(this.project);
                this.defineProperty(this.rootLocationProperty, topLevelProject.getBasedir().getAbsolutePath());
            }
            catch (IOException ex) {
                throw new MojoFailureException("Unable to detect root location: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private MavenProject getLocalRoot(MavenProject project) throws IOException {
        MavenProject currentProject = project;
        MavenProject localRootProject = project;
        ArrayList<File> parentDirs = new ArrayList<File>();
        this.getAllParentDirectories(project.getBasedir(), parentDirs);
        for (File parentDir : parentDirs) {
            this.getLog().debug((CharSequence)("Checking to see if " + parentDir + " is an aggregator parent"));
            File parent = new File(parentDir, "pom.xml");
            if (!parent.isFile()) continue;
            try {
                ProjectBuildingResult result = this.projectBuilder.build(parent, this.session.getProjectBuildingRequest());
                MavenProject parentProject = result.getProject();
                String currentProjectCanonicalPath = currentProject.getBasedir().getCanonicalPath();
                if (this.getAllChildModules(parentProject).contains(currentProjectCanonicalPath)) {
                    this.getLog().debug((CharSequence)(parentDir + " is an aggregator parent of current project "));
                    localRootProject = parentProject;
                    currentProject = parentProject;
                    continue;
                }
                this.getLog().debug((CharSequence)(parentDir + " is not an aggregator parent of current project (" + this.getAllChildModules(parentProject) + "/" + currentProjectCanonicalPath + ") "));
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)("Local aggregation root is " + localRootProject.getBasedir()));
        return localRootProject;
    }

    private void getAllParentDirectories(File directory, List<File> parents) {
        File parent = directory.getParentFile();
        if (parent != null && parent.isDirectory()) {
            parents.add(parent);
            this.getAllParentDirectories(parent, parents);
        }
    }

    private Set<String> getAllChildModules(MavenProject project) throws IOException {
        Model model = project.getOriginalModel();
        TreeSet<String> paths = new TreeSet<String>();
        paths.addAll(this.getChildModuleCanoncialPath(project, model.getModules()));
        for (Profile profile : model.getProfiles()) {
            paths.addAll(this.getChildModuleCanoncialPath(project, profile.getModules()));
        }
        return paths;
    }

    private Set<String> getChildModuleCanoncialPath(MavenProject project, List<String> modules) throws IOException {
        TreeSet<String> paths = new TreeSet<String>();
        for (String module : modules) {
            File file = new File(project.getBasedir(), module);
            paths.add(file.getCanonicalPath());
        }
        return paths;
    }
}

