/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.property.seed;

import io.kotest.assertions.print.PrintKt;
import io.kotest.common.TestPath;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005H\u0002\u001a\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\t\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\u001a\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\b\u0010\r\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\b\u001a\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0000\u00a8\u0006\u0011"}, d2={"clearSeed", "", "path", "Lio/kotest/common/TestPath;", "configDirectory", "", "escape", "readSeed", "", "(Lio/kotest/common/TestPath;)Ljava/lang/Long;", "seedDirectory", "Ljava/nio/file/Path;", "seedPath", "userHome", "writeSeed", "seed", "xdgCacheHomeOrNull", "kotest-property"})
@SourceDebugExtension(value={"SMAP\nseedio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 seedio.kt\nio/kotest/property/seed/SeedioKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class SeedioKt {
    @Nullable
    public static final Long readSeed(@NotNull TestPath path) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Long l2;
            Path p = SeedioKt.seedPath(path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(p, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                List<String> list2 = Files.readAllLines(p);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
                String string2 = (String)CollectionsKt.firstOrNull(list2);
                l2 = string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null ? StringsKt.toLongOrNull((String)string2) : null;
            } else {
                l2 = null;
            }
            l = l2;
        }
        catch (Exception e) {
            System.out.println((Object)"Error reading seed");
            PrintKt.print((Object)e);
            l = null;
        }
        return l;
    }

    @Nullable
    public static final String xdgCacheHomeOrNull() {
        String string2;
        String string3 = System.getenv("XDG_CACHE_HOME");
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            string2 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public static final String userHome() {
        String string2 = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        return string2;
    }

    @NotNull
    public static final String configDirectory() {
        String string2 = SeedioKt.xdgCacheHomeOrNull();
        if (string2 == null) {
            string2 = SeedioKt.userHome();
        }
        return string2;
    }

    @NotNull
    public static final Path seedDirectory() {
        Path path = Paths.get(SeedioKt.configDirectory(), new String[0]).resolve(".kotest").resolve("seeds");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public static final Path seedPath(@NotNull TestPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = SeedioKt.seedDirectory().resolve(SeedioKt.escape(path.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private static final String escape(String path) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)path, (char)'/', (char)'_', (boolean)false, (int)4, null), (char)'\\', (char)'_', (boolean)false, (int)4, null), (char)'<', (char)'_', (boolean)false, (int)4, null), (char)'>', (char)'_', (boolean)false, (int)4, null), (char)':', (char)'_', (boolean)false, (int)4, null), (char)'(', (char)'_', (boolean)false, (int)4, null), (char)')', (char)'_', (boolean)false, (int)4, null);
    }

    public static final void writeSeed(@NotNull TestPath path, long seed) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Path f = SeedioKt.seedPath(path);
            f.getParent().toFile().mkdirs();
            Files.write(f, StringsKt.encodeToByteArray((String)String.valueOf(seed)), new OpenOption[0]);
        }
        catch (Exception e) {
            System.out.println((Object)"Error writing seed");
            e.printStackTrace();
        }
    }

    public static final void clearSeed(@NotNull TestPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Path f = SeedioKt.seedPath(path);
            File file2 = f.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file2);
        }
        catch (Exception e) {
            System.out.println((Object)"Error clearing seed");
            e.printStackTrace();
        }
    }
}

