/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.git.GitChangeSet;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class GitChangeLogConsumer
extends AbstractConsumer {
    private static final String GIT_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    private static final int STATUS_GET_HEADER = 1;
    private static final int STATUS_GET_AUTHOR = 2;
    private static final int STATUS_GET_DATE = 3;
    private static final int STATUS_GET_FILE = 4;
    private static final int STATUS_GET_COMMENT = 5;
    private static final String HEADER_PATTERN = "^commit (.*)";
    private static final String AUTHOR_PATTERN = "^Author: (.*)";
    private static final String DATE_PATTERN = "^Date:\\s*(.*)";
    private static final String FILE_PATTERN = "^:\\d* \\d* [:xdigit:]*\\.* [:xdigit:]*\\.* ([:upper:])\\t(.*)";
    private int status = 1;
    private List entries = new ArrayList();
    private GitChangeSet currentChange;
    private String currentRevision;
    private StringBuffer currentComment;
    private RE headerRegexp;
    private RE authorRegexp;
    private RE dateRegexp;
    private RE fileRegexp;
    private String userDateFormat;

    public GitChangeLogConsumer(ScmLogger logger, String userDateFormat) {
        super(logger);
        this.userDateFormat = userDateFormat;
        try {
            this.headerRegexp = new RE(HEADER_PATTERN);
            this.authorRegexp = new RE(AUTHOR_PATTERN);
            this.dateRegexp = new RE(DATE_PATTERN);
            this.fileRegexp = new RE(FILE_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public List getModifications() {
        this.processGetFile("");
        return this.entries;
    }

    public void consumeLine(String line) {
        switch (this.status) {
            case 1: {
                this.processGetHeader(line);
                break;
            }
            case 2: {
                this.processGetAuthor(line);
                break;
            }
            case 3: {
                this.processGetDate(line, null);
                break;
            }
            case 5: {
                this.processGetComment(line);
                break;
            }
            case 4: {
                this.processGetFile(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void processGetHeader(String line) {
        if (!this.headerRegexp.match(line)) {
            return;
        }
        this.currentRevision = this.headerRegexp.getParen(1);
        this.currentChange = new GitChangeSet();
        this.status = 2;
    }

    private void processGetAuthor(String line) {
        if (!this.authorRegexp.match(line)) {
            return;
        }
        String author = this.authorRegexp.getParen(1);
        this.currentChange.setAuthor(author);
        this.status = 3;
    }

    private void processGetDate(String line, Locale locale) {
        if (!this.dateRegexp.match(line)) {
            return;
        }
        String datestring = this.dateRegexp.getParen(1);
        Date date = this.parseDate(datestring.trim(), this.userDateFormat, GIT_TIMESTAMP_PATTERN, locale);
        this.currentChange.setDate(date);
        this.status = 5;
    }

    private void processGetComment(String line) {
        if (line.length() < 4) {
            if (this.currentComment == null) {
                this.currentComment = new StringBuffer();
            } else {
                this.currentChange.setComment(this.currentComment.toString());
                this.status = 4;
            }
        } else {
            if (this.currentComment.length() > 0) {
                this.currentComment.append('\n');
            }
            this.currentComment.append(line.substring(4));
        }
    }

    private void processGetFile(String line) {
        if (line.length() == 0) {
            if (this.currentChange != null) {
                this.entries.add(this.currentChange);
            }
            this.resetChangeLog();
            this.status = 1;
        } else {
            if (!this.fileRegexp.match(line)) {
                return;
            }
            String name = this.fileRegexp.getParen(2);
            this.currentChange.addFile(new ChangeFile(name, this.currentRevision));
        }
    }

    private void resetChangeLog() {
        this.currentComment = null;
        this.currentChange = null;
    }
}

