/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.extensions.DefaultStatelessReportMojoConfiguration;
import org.apache.maven.plugin.surefire.extensions.SurefireConsoleOutputReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessTestsetInfoReporter;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.extensions.ConsoleOutputReportEventListener;
import org.apache.maven.surefire.extensions.StatelessReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoConsoleReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoFileReportEventListener;
import org.apache.maven.surefire.shared.lang3.StringUtils;

public final class StartupReportConfiguration {
    private final PrintStream originalSystemOut;
    private final PrintStream originalSystemErr;
    private final boolean useFile;
    private final boolean printSummary;
    private final String reportFormat;
    private final String reportNameSuffix;
    private final File statisticsFile;
    private final boolean requiresRunHistory;
    private final boolean redirectTestOutputToFile;
    private final File reportsDirectory;
    private final boolean trimStackTrace;
    private final int rerunFailingTestsCount;
    private final String xsdSchemaLocation;
    private final Map<String, Deque<WrappedReportEntry>> testClassMethodRunHistory = new ConcurrentHashMap<String, Deque<WrappedReportEntry>>();
    private final Charset encoding;
    private final boolean isForking;
    private final boolean enableOutErrElements;
    private final boolean enablePropertiesElement;
    private final SurefireStatelessReporter xmlReporter;
    private final SurefireConsoleOutputReporter consoleOutputReporter;
    private final SurefireStatelessTestsetInfoReporter testsetReporter;
    private StatisticsReporter statisticsReporter;

    public StartupReportConfiguration(boolean useFile, boolean printSummary, String reportFormat, boolean redirectTestOutputToFile, @Nonnull File reportsDirectory, boolean trimStackTrace, String reportNameSuffix, File statisticsFile, boolean requiresRunHistory, int rerunFailingTestsCount, String xsdSchemaLocation, String encoding, boolean isForking, boolean enableOutErrElements, boolean enablePropertiesElement, SurefireStatelessReporter xmlReporter, SurefireConsoleOutputReporter consoleOutputReporter, SurefireStatelessTestsetInfoReporter testsetReporter) {
        this.useFile = useFile;
        this.printSummary = printSummary;
        this.reportFormat = reportFormat;
        this.redirectTestOutputToFile = redirectTestOutputToFile;
        this.reportsDirectory = reportsDirectory;
        this.trimStackTrace = trimStackTrace;
        this.reportNameSuffix = reportNameSuffix;
        this.statisticsFile = statisticsFile;
        this.requiresRunHistory = requiresRunHistory;
        this.originalSystemOut = System.out;
        this.originalSystemErr = System.err;
        this.rerunFailingTestsCount = rerunFailingTestsCount;
        this.xsdSchemaLocation = xsdSchemaLocation;
        String charset = StringUtils.trimToNull((String)encoding);
        this.encoding = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
        this.isForking = isForking;
        this.enableOutErrElements = enableOutErrElements;
        this.enablePropertiesElement = enablePropertiesElement;
        this.xmlReporter = xmlReporter;
        this.consoleOutputReporter = consoleOutputReporter;
        this.testsetReporter = testsetReporter;
    }

    @Deprecated
    public StartupReportConfiguration(boolean useFile, boolean printSummary, String reportFormat, boolean redirectTestOutputToFile, @Nonnull File reportsDirectory, boolean trimStackTrace, String reportNameSuffix, File statisticsFile, boolean requiresRunHistory, int rerunFailingTestsCount, String xsdSchemaLocation, String encoding, boolean isForking, SurefireStatelessReporter xmlReporter, SurefireConsoleOutputReporter consoleOutputReporter, SurefireStatelessTestsetInfoReporter testsetReporter) {
        this(useFile, printSummary, reportFormat, redirectTestOutputToFile, reportsDirectory, trimStackTrace, reportNameSuffix, statisticsFile, requiresRunHistory, rerunFailingTestsCount, xsdSchemaLocation, encoding, isForking, true, true, xmlReporter, consoleOutputReporter, testsetReporter);
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    public StatelessReportEventListener<WrappedReportEntry, TestSetStats> instantiateStatelessXmlReporter(Integer forkNumber) {
        assert (forkNumber == null == !this.isForking);
        ConcurrentHashMap<String, Deque<WrappedReportEntry>> testClassMethodRunHistory = this.isForking ? new ConcurrentHashMap() : this.testClassMethodRunHistory;
        DefaultStatelessReportMojoConfiguration xmlReporterConfig = new DefaultStatelessReportMojoConfiguration(this.resolveReportsDirectory(forkNumber), this.reportNameSuffix, this.trimStackTrace, this.rerunFailingTestsCount, this.xsdSchemaLocation, this.enableOutErrElements, this.enablePropertiesElement, testClassMethodRunHistory);
        return this.xmlReporter.isDisable() ? null : this.xmlReporter.createListener(xmlReporterConfig);
    }

    public StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> instantiateFileReporter(Integer forkNumber) {
        return !this.testsetReporter.isDisable() && this.isUseFile() && this.isBriefOrPlainFormat() ? this.testsetReporter.createListener(this.resolveReportsDirectory(forkNumber), this.reportNameSuffix, this.encoding) : null;
    }

    public StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> instantiateConsoleReporter(ConsoleLogger consoleLogger) {
        return !this.testsetReporter.isDisable() && this.shouldReportToConsole() ? this.testsetReporter.createListener(consoleLogger) : null;
    }

    public boolean isBriefOrPlainFormat() {
        String fmt = this.getReportFormat();
        return "brief".equals(fmt) || "plain".equals(fmt);
    }

    public ConsoleOutputReportEventListener instantiateConsoleOutputFileReporter(Integer forkNum) {
        ConsoleOutputReportEventListener outputReport = this.isRedirectTestOutputToFile() ? this.consoleOutputReporter.createListener(this.resolveReportsDirectory(forkNum), this.reportNameSuffix, forkNum) : this.consoleOutputReporter.createListener(this.originalSystemOut, this.originalSystemErr);
        return this.consoleOutputReporter.isDisable() ? null : outputReport;
    }

    public synchronized StatisticsReporter getStatisticsReporter() {
        if (this.statisticsReporter == null) {
            this.statisticsReporter = this.requiresRunHistory ? new StatisticsReporter(this.statisticsFile) : null;
        }
        return this.statisticsReporter;
    }

    public File getStatisticsFile() {
        return this.statisticsFile;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public boolean isRequiresRunHistory() {
        return this.requiresRunHistory;
    }

    public String getXsdSchemaLocation() {
        return this.xsdSchemaLocation;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public boolean isForking() {
        return this.isForking;
    }

    public boolean isEnableOutErrElements() {
        return this.enableOutErrElements;
    }

    public boolean isEnablePropertiesElement() {
        return this.enablePropertiesElement;
    }

    private File resolveReportsDirectory(Integer forkNumber) {
        return forkNumber == null ? this.reportsDirectory : SurefireHelper.replaceForkThreadsInPath(this.reportsDirectory, forkNumber);
    }

    public SurefireStatelessReporter getXmlReporter() {
        return this.xmlReporter;
    }

    public SurefireConsoleOutputReporter getConsoleOutputReporter() {
        return this.consoleOutputReporter;
    }

    public SurefireStatelessTestsetInfoReporter getTestsetReporter() {
        return this.testsetReporter;
    }

    private boolean shouldReportToConsole() {
        return this.isUseFile() ? this.isPrintSummary() : this.isRedirectTestOutputToFile() || this.isBriefOrPlainFormat();
    }
}

