/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.charger.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.sonatype.sisu.charger.ChargeStrategy;
import org.sonatype.sisu.charger.internal.Charge;
import org.sonatype.sisu.charger.internal.ChargeWrapper;

public abstract class AbstractChargeStrategy<E>
implements ChargeStrategy<E> {
    protected E getFutureResult(ChargeWrapper<E> wrapper) throws Exception {
        block6: {
            try {
                return wrapper.getFuture().get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof InterruptedException) break block6;
                if (e.getCause() instanceof Exception) {
                    Exception cause = (Exception)e.getCause();
                    if (!wrapper.handle(cause)) {
                        throw cause;
                    }
                }
                throw new RuntimeException(e.getCause());
            }
            catch (CancellationException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected List<E> getAllResults(Charge<E> charge) throws Exception {
        List<ChargeWrapper<E>> ammo = charge.getAmmoFutures();
        ArrayList<E> result = new ArrayList<E>(ammo.size());
        for (ChargeWrapper<E> f : ammo) {
            E e = this.getFutureResult(f);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public abstract boolean isDone(Charge<E> var1, ChargeWrapper<E> var2);

    @Override
    public abstract List<E> getResult(Charge<E> var1) throws Exception;
}

