/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.mojo.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import org.apache.maven.plugin.logging.Log;

public class MavenAppender
extends AppenderBase<ILoggingEvent> {
    private final Log log;

    public MavenAppender(Log log) {
        this.log = log;
    }

    protected void append(ILoggingEvent event) {
        if (event.getLevel().isGreaterOrEqual(Level.ERROR)) {
            this.log.error((CharSequence)event.getFormattedMessage(), this.getThrowable(event));
        } else if (event.getLevel().isGreaterOrEqual(Level.WARN)) {
            this.log.warn((CharSequence)event.getFormattedMessage(), this.getThrowable(event));
        } else if (event.getLevel().isGreaterOrEqual(Level.INFO)) {
            this.log.info((CharSequence)event.getFormattedMessage(), this.getThrowable(event));
        } else {
            this.log.debug((CharSequence)event.getFormattedMessage(), this.getThrowable(event));
        }
    }

    private Throwable getThrowable(ILoggingEvent event) {
        IThrowableProxy proxy = event.getThrowableProxy();
        if (proxy instanceof ThrowableProxy) {
            return ((ThrowableProxy)proxy).getThrowable();
        }
        return null;
    }
}

