/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.FromHeaderImpl;
import java.util.Random;

public interface FromHeader
extends AddressParametersHeader {
    public static final Buffer NAME = Buffers.wrap((String)"From");
    public static final Buffer COMPACT_NAME = Buffers.wrap((String)"f");

    public Buffer getTag() throws SipParseException;

    @Override
    public FromHeader clone();

    @Override
    default public boolean isFromHeader() {
        return true;
    }

    @Override
    default public FromHeader toFromHeader() {
        return this;
    }

    public static FromHeader frame(Buffer buffer) throws SipParseException {
        Buffer original = buffer.slice();
        Object[] result = AddressParametersHeader.frame(buffer);
        return new FromHeaderImpl(original, (Address)result[0], (Buffer)result[1]);
    }

    public static FromHeader frame(String buffer) throws SipParseException {
        return FromHeader.frame(Buffers.wrap((String)buffer));
    }

    public static Buffer generateTag() {
        return Buffers.wrap((String)Integer.toHexString(new Random().nextInt()));
    }

    public static AddressParametersHeader.Builder<FromHeader> builder() {
        return new Builder();
    }

    public static AddressParametersHeader.Builder<FromHeader> withHost(Buffer host) throws SipParseException {
        return FromHeader.builder().withHost(host);
    }

    public static AddressParametersHeader.Builder<FromHeader> withHost(String host) throws SipParseException {
        return FromHeader.builder().withHost(host);
    }

    public static AddressParametersHeader.Builder<FromHeader> withAddress(Address address) throws SipParseException {
        return FromHeader.builder().withAddress(address);
    }

    @Override
    public AddressParametersHeader.Builder<FromHeader> copy();

    public static class Builder
    extends AddressParametersHeader.Builder<FromHeader> {
        private Builder() {
            super(NAME);
        }

        @Override
        public FromHeader internalBuild(Buffer rawValue, Address address, Buffer params) throws SipParseException {
            return new FromHeaderImpl(rawValue, address, params);
        }
    }
}

