/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.MediaTypeHeader;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.ContentTypeHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;

public interface ContentTypeHeader
extends SipHeader,
MediaTypeHeader,
Parameters {
    public static final Buffer NAME = Buffers.wrap((String)"Content-Type");
    public static final Buffer COMPACT_NAME = Buffers.wrap((String)"c");

    @Override
    public ContentTypeHeader clone();

    @Override
    public Builder copy();

    @Override
    default public boolean isContentTypeHeader() {
        return true;
    }

    @Override
    default public ContentTypeHeader toContentTypeHeader() {
        return this;
    }

    public static ContentTypeHeader frame(Buffer buffer) throws SipParseException {
        PreConditions.assertNotEmpty(buffer, "The supplied buffer cannot be null or empty");
        Buffer original = buffer.slice();
        Buffer[] mediaType = MediaTypeHeader.frame(buffer);
        return new ContentTypeHeaderImpl(original, mediaType[0], mediaType[1], buffer);
    }

    public static Builder withType(Buffer type) {
        Builder builder = new Builder();
        builder.withType(type);
        return builder;
    }

    public static Builder withType(String type) {
        return ContentTypeHeader.withType(Buffers.wrap((String)type));
    }

    public static Builder withParams(Buffer params) {
        return new Builder(params);
    }

    public static class Builder
    extends MediaTypeHeader.Builder<ContentTypeHeader> {
        protected Builder() {
            super(NAME);
        }

        protected Builder(Buffer params) {
            super(NAME, params);
        }

        @Override
        protected ContentTypeHeader internalBuild(Buffer rawValue, Buffer type, Buffer subType, Buffer params) {
            return new ContentTypeHeaderImpl(rawValue, type, subType, params);
        }

        @Override
        public SipHeader.Builder<ContentTypeHeader> withValue(Buffer value) {
            throw new RuntimeException("TODO: not implemented yet");
        }
    }
}

