/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.ContactHeaderImpl;

public interface ContactHeader
extends AddressParametersHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Contact");
    public static final Buffer COMPACT_NAME = Buffers.wrap((String)"m");

    @Override
    public ContactHeader clone();

    public static Builder with() {
        return new Builder();
    }

    public static Builder withAddress(Address address) throws SipParseException {
        Builder builder = new Builder();
        builder.withAddress(address);
        return builder;
    }

    public static Builder withHost(Buffer host) throws SipParseException {
        Builder builder = new Builder();
        builder.withHost(host);
        return builder;
    }

    public static Builder withHost(String host) throws SipParseException {
        Builder builder = new Builder();
        builder.withHost(host);
        return builder;
    }

    public static Builder withSipURI(SipURI uri) throws SipParseException {
        Builder builder = new Builder();
        Address address = Address.withURI(uri).build();
        builder.withAddress(address);
        return builder;
    }

    public static ContactHeader frame(Buffer buffer) throws SipParseException {
        Buffer original = buffer.slice();
        Object[] result = AddressParametersHeader.frame(buffer);
        return new ContactHeaderImpl(original, (Address)result[0], (Buffer)result[1]);
    }

    @Override
    public Builder copy();

    @Override
    default public boolean isContactHeader() {
        return true;
    }

    @Override
    default public ContactHeader toContactHeader() {
        return this;
    }

    public static class Builder
    extends AddressParametersHeader.Builder<ContactHeader> {
        private Builder() {
            super(NAME);
        }

        @Override
        public ContactHeader internalBuild(Buffer rawValue, Address address, Buffer params) throws SipParseException {
            return new ContactHeaderImpl(rawValue, address, params);
        }
    }
}

