/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.DependencyVersionMap;
import org.apache.maven.enforcer.rules.dependency.ResolverUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

@Named(value="dependencyConvergence")
public final class DependencyConvergence
extends AbstractStandardEnforcerRule {
    private boolean uniqueVersions;
    private List<String> includes;
    private List<String> excludes;
    private List<String> excludedScopes = Arrays.asList("test", "provided");
    private DependencyVersionMap dependencyVersionMap;
    private final ResolverUtil resolverUtil;

    @Inject
    public DependencyConvergence(ResolverUtil resolverUtil) {
        this.resolverUtil = Objects.requireNonNull(resolverUtil);
    }

    public void execute() throws EnforcerRuleException {
        DependencyNode node = this.resolverUtil.resolveTransitiveDependenciesVerbose(this.excludedScopes);
        this.dependencyVersionMap = new DependencyVersionMap().setUniqueVersions(this.uniqueVersions);
        node.accept((DependencyVisitor)this.dependencyVersionMap);
        List<String> errorMsgs = this.getConvergenceErrorMsgs(this.dependencyVersionMap.getConflictedVersionNumbers(this.includes, this.excludes));
        if (!errorMsgs.isEmpty()) {
            throw new EnforcerRuleException("Failed while enforcing releasability." + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), errorMsgs));
        }
    }

    private StringBuilder buildTreeString(DependencyNode node) {
        ArrayList<String> loc = new ArrayList<String>();
        DependencyNode currentNode = node;
        while (currentNode != null) {
            loc.add(ArtifactUtils.toArtifact(currentNode).toString());
            currentNode = this.dependencyVersionMap.getParent(currentNode);
        }
        Collections.reverse(loc);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < loc.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                builder.append("  ");
            }
            builder.append("+-").append((String)loc.get(i)).append(System.lineSeparator());
        }
        return builder;
    }

    private List<String> getConvergenceErrorMsgs(List<List<DependencyNode>> errors) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        for (List<DependencyNode> nodeList : errors) {
            errorMsgs.add(this.buildConvergenceErrorMsg(nodeList));
        }
        return errorMsgs;
    }

    private String buildConvergenceErrorMsg(List<DependencyNode> nodeList) {
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator()).append("Dependency convergence error for ").append(nodeList.get(0).getArtifact().toString()).append(" paths to dependency are:").append(System.lineSeparator());
        if (nodeList.size() > 0) {
            builder.append((CharSequence)this.buildTreeString(nodeList.get(0)));
        }
        for (DependencyNode node : nodeList.subList(1, nodeList.size())) {
            builder.append("and").append(System.lineSeparator()).append((CharSequence)this.buildTreeString(node));
        }
        return builder.toString();
    }

    public String toString() {
        return String.format("DependencyConvergence[includes=%s, excludes=%s, uniqueVersions=%b]", this.includes, this.excludes, this.uniqueVersions);
    }
}

