/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.doxia.markup.Markup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.reporting.MavenReportRenderer;
import org.apache.maven.shared.utils.StringUtils;

public abstract class AbstractMavenReportRenderer
implements MavenReportRenderer {
    protected Sink sink;
    private int section;

    public AbstractMavenReportRenderer(Sink sink) {
        this.sink = sink;
    }

    public void render() {
        this.sink.head();
        this.sink.title();
        this.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.renderBody();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    protected void startSection(String name) {
        this.startSection(name, name);
    }

    protected void startSection(String name, String anchor) {
        ++this.section;
        this.sink.section(this.section, null);
        this.sink.anchor(anchor);
        this.sink.anchor_();
        this.sink.sectionTitle(this.section, null);
        this.text(name);
        this.sink.sectionTitle_(this.section);
    }

    protected void endSection() {
        this.sink.section_(this.section);
        --this.section;
        if (this.section < 0) {
            throw new IllegalStateException("Too many closing sections");
        }
    }

    protected void startTable() {
        this.startTable(null, false);
    }

    protected void startTable(int[] justification, boolean grid) {
        this.sink.table();
        this.sink.tableRows(justification, grid);
    }

    protected void endTable() {
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected void tableHeaderCell(String text) {
        this.sink.tableHeaderCell();
        this.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void tableCell(String text) {
        this.tableCell(text, false);
    }

    protected void tableCell(String text, boolean asHtml) {
        this.sink.tableCell();
        if (asHtml) {
            this.sink.rawText(text);
        } else {
            this.linkPatternedText(text);
        }
        this.sink.tableCell_();
    }

    protected void tableRow(String[] content) {
        this.sink.tableRow();
        if (content != null) {
            for (int i = 0; i < content.length; ++i) {
                this.tableCell(content[i]);
            }
        }
        this.sink.tableRow_();
    }

    protected void tableHeader(String[] content) {
        this.sink.tableRow();
        if (content != null) {
            for (int i = 0; i < content.length; ++i) {
                this.tableHeaderCell(content[i]);
            }
        }
        this.sink.tableRow_();
    }

    protected void tableCaption(String caption) {
        this.sink.tableCaption();
        this.text(caption);
        this.sink.tableCaption_();
    }

    protected void paragraph(String paragraph) {
        this.sink.paragraph();
        this.text(paragraph);
        this.sink.paragraph_();
    }

    protected void link(String href, String name) {
        this.sink.link(href);
        this.text(name);
        this.sink.link_();
    }

    protected void text(String text) {
        if (text == null || text.isEmpty()) {
            this.sink.text("-");
        } else {
            this.sink.text(text);
        }
    }

    protected void verbatimText(String text) {
        this.sink.verbatim();
        this.text(text);
        this.sink.verbatim_();
    }

    protected void verbatimLink(String text, String href) {
        if (href == null || href.isEmpty()) {
            this.verbatimText(text);
        } else {
            this.sink.verbatim();
            this.link(href, text);
            this.sink.verbatim_();
        }
    }

    protected void verbatimSource(String source) {
        this.sink.verbatim(SinkEventAttributeSet.SOURCE);
        this.text(source);
        this.sink.verbatim_();
    }

    protected void javaScript(String jsCode) {
        this.sink.rawText(Markup.EOL + "<script>" + Markup.EOL + jsCode + Markup.EOL + "</script>" + Markup.EOL);
    }

    public void linkPatternedText(String text) {
        if (text == null || text.isEmpty()) {
            this.text(text);
        } else {
            List<String> segments = AbstractMavenReportRenderer.applyPattern(text);
            if (segments == null) {
                this.text(text);
            } else {
                Iterator<String> it = segments.iterator();
                while (it.hasNext()) {
                    String name = it.next();
                    String href = it.next();
                    if (href == null) {
                        this.text(name);
                        continue;
                    }
                    this.link(href, name);
                }
            }
        }
    }

    protected static String createLinkPatternedText(String text, String href) {
        if (text == null) {
            return text;
        }
        if (href == null) {
            return text;
        }
        return '{' + text + ", " + href + '}';
    }

    protected static String propertiesToString(Properties props) {
        if (props == null || props.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    private static List<String> applyPattern(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ArrayList<String> segments = new ArrayList<String>();
        if (text.indexOf("${") != -1) {
            int lastComma = text.lastIndexOf(",");
            int lastSemi = text.lastIndexOf("}");
            if (lastComma != -1 && lastSemi != -1 && lastComma < lastSemi) {
                segments.add(text.substring(lastComma + 1, lastSemi).trim());
                segments.add(null);
            } else {
                segments.add(text);
                segments.add(null);
            }
            return segments;
        }
        boolean inQuote = false;
        int braceStack = 0;
        int lastOffset = 0;
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\'' && !inQuote && braceStack == 0) {
                if (i + 1 < text.length() && text.charAt(i + 1) == '\'') {
                    segments.add(text.substring(lastOffset, ++i));
                    segments.add(null);
                    lastOffset = i + 1;
                    continue;
                }
                inQuote = true;
                continue;
            }
            switch (ch) {
                case '{': {
                    if (inQuote) continue block5;
                    if (braceStack == 0) {
                        if (i != lastOffset) {
                            segments.add(text.substring(lastOffset, i));
                            segments.add(null);
                        }
                        lastOffset = i + 1;
                    }
                    ++braceStack;
                    continue block5;
                }
                case '}': {
                    if (inQuote || --braceStack != 0) continue block5;
                    String subString = text.substring(lastOffset, i);
                    lastOffset = i + 1;
                    int lastComma = subString.lastIndexOf(",");
                    if (lastComma != -1) {
                        segments.add(subString.substring(0, lastComma).trim());
                        segments.add(subString.substring(lastComma + 1).trim());
                        continue block5;
                    }
                    segments.add(subString);
                    segments.add(null);
                    continue block5;
                }
                case '\'': {
                    inQuote = false;
                    continue block5;
                }
            }
        }
        if (!StringUtils.isEmpty((String)text.substring(lastOffset))) {
            segments.add(text.substring(lastOffset));
            segments.add(null);
        }
        if (braceStack != 0) {
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        if (inQuote) {
            // empty if block
        }
        return Collections.unmodifiableList(segments);
    }

    public abstract String getTitle();

    protected abstract void renderBody();
}

