/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class HostPort
extends GenericObject {
    private static final long serialVersionUID = -7103412227431884523L;
    protected Host host = null;
    protected int port = -1;

    @Override
    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder buffer) {
        this.host.encode(buffer);
        if (this.port != -1) {
            buffer.append(":").append(this.port);
        }
        return buffer;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HostPort that = (HostPort)other;
        return this.port == that.port && this.host.equals(that.host);
    }

    public Host getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public void removePort() {
        this.port = -1;
    }

    public void setHost(Host h) {
        this.host = h;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.host == null) {
            return null;
        }
        return this.host.getInetAddress();
    }

    @Override
    public void merge(Object mergeObject) {
        super.merge(mergeObject);
        if (this.port == -1) {
            this.port = ((HostPort)mergeObject).port;
        }
    }

    @Override
    public Object clone() {
        HostPort retval = (HostPort)super.clone();
        if (this.host != null) {
            retval.host = (Host)this.host.clone();
        }
        return retval;
    }

    public String toString() {
        return this.encode();
    }

    public int hashCode() {
        return this.host.hashCode() + this.port;
    }
}

