/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.easymock.IAnswer;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;
import org.easymock.internal.ThrowableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayState
implements IMocksControlState,
Serializable {
    private static final long serialVersionUID = 6314142602251047572L;
    private final IMocksBehavior behavior;
    private final ReentrantLock lock = new ReentrantLock();

    public ReplayState(IMocksBehavior behavior) {
        this.behavior = behavior;
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        this.behavior.checkThreadSafety();
        if (this.behavior.isThreadSafe()) {
            this.lock.lock();
            try {
                Object object = this.invokeInner(invocation);
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.invokeInner(invocation);
    }

    private Object invokeInner(Invocation invocation) throws Throwable {
        LastControl.pushCurrentInvocation(invocation);
        try {
            Result result = this.behavior.addActual(invocation);
            try {
                Object object = result.answer();
                return object;
            }
            catch (Throwable t) {
                if (result.shouldFillInStackTrace()) {
                    throw new ThrowableWrapper(t);
                }
                throw t;
            }
        }
        finally {
            LastControl.popCurrentInvocation();
        }
    }

    @Override
    public void verify() {
        this.behavior.verify();
    }

    @Override
    public void replay() {
        this.throwWrappedIllegalStateException();
    }

    public void callback(Runnable runnable) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void checkOrder(boolean value) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void makeThreadSafe(boolean threadSafe) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void checkIsUsedInOneThread(boolean shouldBeUsedInOneThread) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andReturn(Object value) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andThrow(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andAnswer(IAnswer<?> answer) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andDelegateTo(Object answer) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andVoid() {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andStubReturn(Object value) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andStubThrow(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andStubAnswer(IAnswer<?> answer) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andStubDelegateTo(Object delegateTo) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void asStub() {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void times(Range range) {
        this.throwWrappedIllegalStateException();
    }

    public void setDefaultReturnValue(Object value) {
        this.throwWrappedIllegalStateException();
    }

    public void setDefaultThrowable(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    public void setDefaultVoidCallable() {
        this.throwWrappedIllegalStateException();
    }

    private void throwWrappedIllegalStateException() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("This method must not be called in replay state."));
    }

    @Override
    public void assertRecordState() {
        this.throwWrappedIllegalStateException();
    }
}

