/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.io.scan;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.shared.io.scan.AbstractResourceInclusionScanner;
import org.apache.maven.shared.io.scan.InclusionScanException;
import org.apache.maven.shared.io.scan.mapping.SourceMapping;

public class StaleResourceScanner
extends AbstractResourceInclusionScanner {
    private final long lastUpdatedWithinMsecs;
    private final Set<String> sourceIncludes;
    private final Set<String> sourceExcludes;

    public StaleResourceScanner() {
        this(0L, Collections.singleton("**/*"), Collections.emptySet());
    }

    public StaleResourceScanner(long lastUpdatedWithinMsecs) {
        this(lastUpdatedWithinMsecs, Collections.singleton("**/*"), Collections.emptySet());
    }

    public StaleResourceScanner(long lastUpdatedWithinMsecs, Set<String> sourceIncludes, Set<String> sourceExcludes) {
        this.lastUpdatedWithinMsecs = lastUpdatedWithinMsecs;
        this.sourceIncludes = sourceIncludes;
        this.sourceExcludes = sourceExcludes;
    }

    @Override
    public Set<File> getIncludedSources(File sourceDir, File targetDir) throws InclusionScanException {
        List<SourceMapping> srcMappings = this.getSourceMappings();
        if (srcMappings.isEmpty()) {
            return Collections.emptySet();
        }
        String[] potentialIncludes = this.scanForSources(sourceDir, this.sourceIncludes, this.sourceExcludes);
        HashSet<File> matchingSources = new HashSet<File>();
        block0: for (int i = 0; i < potentialIncludes.length; ++i) {
            String path = potentialIncludes[i];
            File sourceFile = new File(sourceDir, path);
            for (SourceMapping mapping : srcMappings) {
                Set<File> targetFiles = mapping.getTargetFiles(targetDir, path);
                for (File targetFile : targetFiles) {
                    if (targetFile.exists() && targetFile.lastModified() + this.lastUpdatedWithinMsecs >= sourceFile.lastModified()) continue;
                    matchingSources.add(sourceFile);
                    continue block0;
                }
            }
        }
        return matchingSources;
    }
}

