/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.security;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.client.core.subsystem.security.Role;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.JerseyEntitySupport;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.security.JerseyRoles;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.security.rest.model.RoleResource;
import org.sonatype.security.rest.model.RoleResourceRequest;
import org.sonatype.security.rest.model.RoleResourceResponse;

public class JerseyRole
extends JerseyEntitySupport<Role, RoleResource>
implements Role {
    public JerseyRole(JerseyNexusClient nexusClient, String id) {
        super(nexusClient, id);
    }

    public JerseyRole(JerseyNexusClient nexusClient, String id, RoleResource settings) {
        super(nexusClient, id, settings);
    }

    @Override
    protected RoleResource createSettings(String id) {
        RoleResource resource = new RoleResource();
        resource.setId(id);
        resource.setUserManaged(true);
        return resource;
    }

    @Override
    protected RoleResource doGet() {
        try {
            return ((RoleResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRoles.path(this.id())).get(RoleResourceResponse.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    protected RoleResource doCreate() {
        RoleResourceRequest request = new RoleResourceRequest();
        request.setData((RoleResource)this.settings());
        try {
            return ((RoleResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("roles").post(RoleResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    protected RoleResource doUpdate() {
        RoleResourceRequest request = new RoleResourceRequest();
        request.setData((RoleResource)this.settings());
        try {
            return ((RoleResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRoles.path(this.id())).put(RoleResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    protected void doRemove() {
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRoles.path(this.id())).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public String name() {
        return ((RoleResource)this.settings()).getName();
    }

    @Override
    public String description() {
        return ((RoleResource)this.settings()).getDescription();
    }

    @Override
    public List<String> privileges() {
        return Collections.unmodifiableList(((RoleResource)this.settings()).getPrivileges());
    }

    @Override
    public List<String> roles() {
        return Collections.unmodifiableList(((RoleResource)this.settings()).getRoles());
    }

    @Override
    public Role withDescription(String value) {
        ((RoleResource)this.settings()).setDescription(value);
        return this;
    }

    @Override
    public Role withName(String value) {
        ((RoleResource)this.settings()).setName(value);
        return this;
    }

    @Override
    public Role withPrivilege(String value) {
        ((RoleResource)this.settings()).addPrivilege(value);
        return this;
    }

    @Override
    public Role withRole(String value) {
        ((RoleResource)this.settings()).addRole(value);
        return this;
    }

    @Override
    public Role removePrivilege(String value) {
        ((RoleResource)this.settings()).removePrivilege(value);
        return this;
    }

    @Override
    public Role removeRole(String value) {
        ((RoleResource)this.settings()).removeRole(value);
        return this;
    }
}

