/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.parts;

import org.jxmpp.JxmppContext;
import org.jxmpp.jid.parts.Part;
import org.jxmpp.stringprep.XmppStringPrepUtil;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public class Localpart
extends Part {
    private static final long serialVersionUID = 1L;
    private transient String unescapedCache;

    private Localpart(String localpart) {
        super(localpart);
    }

    public String asUnescapedString() {
        if (this.unescapedCache != null) {
            return this.unescapedCache;
        }
        this.unescapedCache = XmppStringUtils.unescapeLocalpart((String)this.toString());
        return this.unescapedCache;
    }

    public static Localpart fromOrThrowUnchecked(CharSequence cs) {
        try {
            return Localpart.from(cs.toString());
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Localpart fromUnescapedOrThrowUnchecked(CharSequence cs) {
        try {
            return Localpart.fromUnescaped(cs.toString());
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Localpart formUnescapedOrNull(CharSequence cs) {
        try {
            return Localpart.fromUnescaped(cs);
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static Localpart fromUnescaped(String unescapedLocalpart) throws XmppStringprepException {
        String escapedLocalpartString = XmppStringUtils.escapeLocalpart((String)unescapedLocalpart);
        return Localpart.from(escapedLocalpartString);
    }

    public static Localpart fromUnescaped(CharSequence unescapedLocalpart) throws XmppStringprepException {
        return Localpart.fromUnescaped(unescapedLocalpart.toString());
    }

    public static Localpart fromOrNull(CharSequence cs) {
        try {
            return Localpart.from(cs.toString());
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public static Localpart from(String localpart) throws XmppStringprepException {
        return Localpart.from(localpart, JxmppContext.getDefaultContext());
    }

    public static Localpart from(String localpart, JxmppContext context) throws XmppStringprepException {
        localpart = XmppStringPrepUtil.localprep((String)localpart, (JxmppContext)context);
        Localpart.assertNotLongerThan1023BytesOrEmpty(localpart);
        return new Localpart(localpart);
    }
}

