/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.plexus.components.io.attributes.Java7AttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java7FileAttributes
implements PlexusIoResourceAttributes {
    @Nullable
    private final Integer groupId;
    @Nullable
    private final String groupName;
    @Nullable
    private final Integer userId;
    private final String userName;
    private final boolean symbolicLink;
    private final int octalMode;
    private final Set<PosixFilePermission> permissions;

    public Java7FileAttributes(@Nonnull File file, @Nonnull Map<Integer, String> userCache, @Nonnull Map<Integer, String> groupCache) throws IOException {
        BasicFileAttributes basicFileAttributes = Java7AttributeUtils.getFileAttributes(file);
        if (basicFileAttributes instanceof PosixFileAttributes) {
            this.permissions = ((PosixFileAttributes)basicFileAttributes).permissions();
            this.groupId = (Integer)Files.readAttributes(file.toPath(), "unix:gid", new LinkOption[0]).get("gid");
            String groupName = groupCache.get(this.groupId);
            if (groupName != null) {
                this.groupName = groupName;
            } else {
                this.groupName = ((PosixFileAttributes)basicFileAttributes).group().getName();
                groupCache.put(this.groupId, this.groupName);
            }
            this.userId = (Integer)Files.readAttributes(file.toPath(), "unix:uid", new LinkOption[0]).get("uid");
            String userName = userCache.get(this.userId);
            if (userName != null) {
                this.userName = userName;
            } else {
                this.userName = ((PosixFileAttributes)basicFileAttributes).owner().getName();
                userCache.put(this.userId, this.userName);
            }
            this.octalMode = this.calculatePosixOctalMode();
        } else {
            FileOwnerAttributeView fa = Java7AttributeUtils.getFileOwnershipInfo(file);
            this.userName = fa.getOwner().getName();
            this.userId = null;
            this.groupName = null;
            this.groupId = null;
            this.octalMode = -1;
            this.permissions = Collections.emptySet();
        }
        this.symbolicLink = basicFileAttributes.isSymbolicLink();
    }

    @Nonnull
    public static PlexusIoResourceAttributes uncached(@Nonnull File file) throws IOException {
        return new Java7FileAttributes(file, new HashMap<Integer, String>(), new HashMap<Integer, String>());
    }

    @Override
    @Nullable
    public Integer getGroupId() {
        return this.groupId;
    }

    public boolean hasGroupId() {
        return false;
    }

    public boolean hasUserId() {
        return false;
    }

    @Override
    @Nullable
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Integer getUserId() {
        return this.userId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isGroupExecutable() {
        return this.containsPermission(PosixFilePermission.GROUP_EXECUTE);
    }

    private boolean containsPermission(PosixFilePermission groupExecute) {
        return this.permissions.contains((Object)groupExecute);
    }

    @Override
    public boolean isGroupReadable() {
        return this.containsPermission(PosixFilePermission.GROUP_READ);
    }

    @Override
    public boolean isGroupWritable() {
        return this.containsPermission(PosixFilePermission.GROUP_WRITE);
    }

    @Override
    public boolean isOwnerExecutable() {
        return this.containsPermission(PosixFilePermission.OWNER_EXECUTE);
    }

    @Override
    public boolean isOwnerReadable() {
        return this.containsPermission(PosixFilePermission.OWNER_READ);
    }

    @Override
    public boolean isOwnerWritable() {
        return this.containsPermission(PosixFilePermission.OWNER_WRITE);
    }

    @Override
    public boolean isWorldExecutable() {
        return this.containsPermission(PosixFilePermission.OTHERS_EXECUTE);
    }

    @Override
    public boolean isWorldReadable() {
        return this.containsPermission(PosixFilePermission.OTHERS_READ);
    }

    @Override
    public boolean isWorldWritable() {
        return this.containsPermission(PosixFilePermission.OTHERS_WRITE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nFile Attributes:\n------------------------------\nuser: ");
        sb.append(this.userName == null ? "" : this.userName);
        sb.append("\ngroup: ");
        sb.append(this.groupName == null ? "" : this.groupName);
        sb.append("\nuid: ");
        sb.append(this.hasUserId() ? Integer.toString(this.userId) : "");
        sb.append("\ngid: ");
        sb.append(this.hasGroupId() ? Integer.toString(this.groupId) : "");
        return sb.toString();
    }

    @Override
    public int getOctalMode() {
        return this.octalMode;
    }

    public int calculatePosixOctalMode() {
        int result = 0;
        if (this.isOwnerReadable()) {
            result |= 0x100;
        }
        if (this.isOwnerWritable()) {
            result |= 0x80;
        }
        if (this.isOwnerExecutable()) {
            result |= 0x40;
        }
        if (this.isGroupReadable()) {
            result |= 0x20;
        }
        if (this.isGroupWritable()) {
            result |= 0x10;
        }
        if (this.isGroupExecutable()) {
            result |= 8;
        }
        if (this.isWorldReadable()) {
            result |= 4;
        }
        if (this.isWorldWritable()) {
            result |= 2;
        }
        if (this.isWorldExecutable()) {
            result |= 1;
        }
        return result;
    }

    public String getOctalModeString() {
        return Integer.toString(this.getOctalMode(), 8);
    }

    @Override
    public boolean isSymbolicLink() {
        return this.symbolicLink;
    }
}

