/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.deploy.AbstractDeployMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

public class DeployMojo
extends AbstractDeployMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");
    private MavenProject project;
    private Artifact artifact;
    private String packaging;
    private File pomFile;
    private String altDeploymentRepository;
    private List attachedArtifacts;
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean isPomArtifact;
        File sshFile;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
            return;
        }
        this.failIfOffline();
        ArtifactRepository repo = this.getDeploymentRepository();
        String protocol = repo.getProtocol();
        if (protocol.equalsIgnoreCase("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        if (!(isPomArtifact = "pom".equals(this.packaging))) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
            this.artifact.addMetadata((ArtifactMetadata)metadata);
        }
        if (this.updateReleaseInfo) {
            this.artifact.setRelease(true);
        }
        try {
            if (isPomArtifact) {
                this.deploy(this.pomFile, this.artifact, repo, this.getLocalRepository());
            } else {
                File file = this.artifact.getFile();
                if (file != null && file.isFile()) {
                    this.deploy(file, this.artifact, repo, this.getLocalRepository());
                } else if (!this.attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to deploy, deploying attached artifacts instead.");
                    Artifact pomArtifact = this.artifactFactory.createProjectArtifact(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getBaseVersion());
                    pomArtifact.setFile(this.pomFile);
                    if (this.updateReleaseInfo) {
                        pomArtifact.setRelease(true);
                    }
                    this.deploy(this.pomFile, pomArtifact, repo, this.getLocalRepository());
                    this.artifact.setResolvedVersion(pomArtifact.getVersion());
                } else {
                    String message = "The packaging for this project did not assign a file to the build artifact";
                    throw new MojoExecutionException(message);
                }
            }
            for (Artifact attached : this.attachedArtifacts) {
                this.deploy(attached.getFile(), attached, repo, this.getLocalRepository());
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private ArtifactRepository getDeploymentRepository() throws MojoExecutionException, MojoFailureException {
        ArtifactRepository repo = null;
        if (this.altDeploymentRepository != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + this.altDeploymentRepository));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)this.altDeploymentRepository, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::layout::url\".");
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            ArtifactRepositoryLayout repoLayout = this.getLayout(layout);
            repo = this.repositoryFactory.createDeploymentArtifactRepository(id, url, repoLayout, true);
        }
        if (repo == null) {
            repo = this.project.getDistributionManagementArtifactRepository();
        }
        if (repo == null) {
            String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        return repo;
    }
}

