/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.mojo.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackUtils {
    public static void syncLogLevelWithMaven(Log log) {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            Logger logger = ((LoggerContext)factory).getLogger("ROOT");
            LogbackUtils.syncLogLevelWithMaven(logger, log);
        }
    }

    public static void syncLogLevelWithLevel(Level level) {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            Logger logger = ((LoggerContext)factory).getLogger("ROOT");
            LogbackUtils.syncLogLevelWithLevel(logger, level);
        }
    }

    public static void syncLogLevelWithMaven(Logger logger, Log log) {
        if (log.isDebugEnabled()) {
            LogbackUtils.syncLogLevelWithLevel(logger, Level.DEBUG);
        } else if (log.isInfoEnabled()) {
            LogbackUtils.syncLogLevelWithLevel(logger, Level.INFO);
        } else if (log.isWarnEnabled()) {
            LogbackUtils.syncLogLevelWithLevel(logger, Level.WARN);
        } else {
            LogbackUtils.syncLogLevelWithLevel(logger, Level.ERROR);
        }
    }

    public static void syncLogLevelWithLevel(Logger logger, Level level) {
        logger.setLevel(level);
    }
}

