/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.util.scan;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.util.scan.AbstractSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;

public class SimpleSourceInclusionScanner
extends AbstractSourceInclusionScanner {
    private Set<String> sourceIncludes;
    private Set<String> sourceExcludes;

    public SimpleSourceInclusionScanner(Set<String> sourceIncludes, Set<String> sourceExcludes) {
        this.sourceIncludes = sourceIncludes;
        this.sourceExcludes = sourceExcludes;
    }

    @Override
    public Set<File> getIncludedSources(File sourceDir, File targetDir) throws InclusionScanException {
        List<SourceMapping> srcMappings = this.getSourceMappings();
        if (srcMappings.isEmpty()) {
            return Collections.emptySet();
        }
        String[] potentialSources = this.scanForSources(sourceDir, this.sourceIncludes, this.sourceExcludes);
        HashSet<File> matchingSources = new HashSet<File>(potentialSources != null ? potentialSources.length : 0);
        if (potentialSources != null) {
            for (String potentialSource : potentialSources) {
                matchingSources.add(new File(sourceDir, potentialSource));
            }
        }
        return matchingSources;
    }
}

