// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package container provides access to the Kubernetes Engine API.
//
// For product documentation, see: https://cloud.google.com/kubernetes-engine/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/container/v1beta1"
//	...
//	ctx := context.Background()
//	containerService, err := container.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	containerService, err := container.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	containerService, err := container.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package container // import "google.golang.org/api/container/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "container:v1beta1"
const apiName = "container"
const apiVersion = "v1beta1"
const basePath = "https://container.googleapis.com/"
const basePathTemplate = "https://container.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://container.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Aggregated = NewProjectsAggregatedService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.Zones = NewProjectsZonesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Aggregated *ProjectsAggregatedService

	Locations *ProjectsLocationsService

	Zones *ProjectsZonesService
}

func NewProjectsAggregatedService(s *Service) *ProjectsAggregatedService {
	rs := &ProjectsAggregatedService{s: s}
	rs.UsableSubnetworks = NewProjectsAggregatedUsableSubnetworksService(s)
	return rs
}

type ProjectsAggregatedService struct {
	s *Service

	UsableSubnetworks *ProjectsAggregatedUsableSubnetworksService
}

func NewProjectsAggregatedUsableSubnetworksService(s *Service) *ProjectsAggregatedUsableSubnetworksService {
	rs := &ProjectsAggregatedUsableSubnetworksService{s: s}
	return rs
}

type ProjectsAggregatedUsableSubnetworksService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Clusters = NewProjectsLocationsClustersService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Clusters *ProjectsLocationsClustersService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsClustersService(s *Service) *ProjectsLocationsClustersService {
	rs := &ProjectsLocationsClustersService{s: s}
	rs.NodePools = NewProjectsLocationsClustersNodePoolsService(s)
	rs.WellKnown = NewProjectsLocationsClustersWellKnownService(s)
	return rs
}

type ProjectsLocationsClustersService struct {
	s *Service

	NodePools *ProjectsLocationsClustersNodePoolsService

	WellKnown *ProjectsLocationsClustersWellKnownService
}

func NewProjectsLocationsClustersNodePoolsService(s *Service) *ProjectsLocationsClustersNodePoolsService {
	rs := &ProjectsLocationsClustersNodePoolsService{s: s}
	return rs
}

type ProjectsLocationsClustersNodePoolsService struct {
	s *Service
}

func NewProjectsLocationsClustersWellKnownService(s *Service) *ProjectsLocationsClustersWellKnownService {
	rs := &ProjectsLocationsClustersWellKnownService{s: s}
	return rs
}

type ProjectsLocationsClustersWellKnownService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsZonesService(s *Service) *ProjectsZonesService {
	rs := &ProjectsZonesService{s: s}
	rs.Clusters = NewProjectsZonesClustersService(s)
	rs.Operations = NewProjectsZonesOperationsService(s)
	return rs
}

type ProjectsZonesService struct {
	s *Service

	Clusters *ProjectsZonesClustersService

	Operations *ProjectsZonesOperationsService
}

func NewProjectsZonesClustersService(s *Service) *ProjectsZonesClustersService {
	rs := &ProjectsZonesClustersService{s: s}
	rs.NodePools = NewProjectsZonesClustersNodePoolsService(s)
	return rs
}

type ProjectsZonesClustersService struct {
	s *Service

	NodePools *ProjectsZonesClustersNodePoolsService
}

func NewProjectsZonesClustersNodePoolsService(s *Service) *ProjectsZonesClustersNodePoolsService {
	rs := &ProjectsZonesClustersNodePoolsService{s: s}
	return rs
}

type ProjectsZonesClustersNodePoolsService struct {
	s *Service
}

func NewProjectsZonesOperationsService(s *Service) *ProjectsZonesOperationsService {
	rs := &ProjectsZonesOperationsService{s: s}
	return rs
}

type ProjectsZonesOperationsService struct {
	s *Service
}

// AcceleratorConfig: AcceleratorConfig represents a Hardware Accelerator
// request.
type AcceleratorConfig struct {
	// AcceleratorCount: The number of the accelerator cards exposed to an
	// instance.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty,string"`
	// AcceleratorType: The accelerator type resource name. List of supported
	// accelerators here
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/gpus)
	AcceleratorType string `json:"acceleratorType,omitempty"`
	// GpuDriverInstallationConfig: The configuration for auto installation of GPU
	// driver.
	GpuDriverInstallationConfig *GPUDriverInstallationConfig `json:"gpuDriverInstallationConfig,omitempty"`
	// GpuPartitionSize: Size of partitions to create on the GPU. Valid values are
	// described in the NVIDIA mig user guide
	// (https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
	GpuPartitionSize string `json:"gpuPartitionSize,omitempty"`
	// GpuSharingConfig: The configuration for GPU sharing options.
	GpuSharingConfig *GPUSharingConfig `json:"gpuSharingConfig,omitempty"`
	// MaxTimeSharedClientsPerGpu: The number of time-shared GPU resources to
	// expose for each physical GPU.
	MaxTimeSharedClientsPerGpu int64 `json:"maxTimeSharedClientsPerGpu,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdditionalIPRangesConfig: AdditionalIPRangesConfig is the configuration for
// individual additional subnetwork attached to the cluster
type AdditionalIPRangesConfig struct {
	// PodIpv4RangeNames: List of secondary ranges names within this subnetwork
	// that can be used for pod IPs. Example1: gke-pod-range1 Example2:
	// gke-pod-range1,gke-pod-range2
	PodIpv4RangeNames []string `json:"podIpv4RangeNames,omitempty"`
	// Subnetwork: Name of the subnetwork. This can be the full path of the
	// subnetwork or just the name. Example1: my-subnet Example2:
	// projects/gke-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PodIpv4RangeNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PodIpv4RangeNames") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdditionalIPRangesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AdditionalIPRangesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdditionalNodeNetworkConfig: AdditionalNodeNetworkConfig is the
// configuration for additional node networks within the NodeNetworkConfig
// message
type AdditionalNodeNetworkConfig struct {
	// Network: Name of the VPC where the additional interface belongs
	Network string `json:"network,omitempty"`
	// Subnetwork: Name of the subnetwork where the additional interface belongs
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdditionalNodeNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AdditionalNodeNetworkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdditionalPodNetworkConfig: AdditionalPodNetworkConfig is the configuration
// for additional pod networks within the NodeNetworkConfig message
type AdditionalPodNetworkConfig struct {
	// MaxPodsPerNode: The maximum number of pods per node which use this pod
	// network.
	MaxPodsPerNode *MaxPodsConstraint `json:"maxPodsPerNode,omitempty"`
	// NetworkAttachment: The name of the network attachment for pods to
	// communicate to; cannot be specified along with subnetwork or
	// secondary_pod_range.
	NetworkAttachment string `json:"networkAttachment,omitempty"`
	// SecondaryPodRange: The name of the secondary range on the subnet which
	// provides IP address for this pod range.
	SecondaryPodRange string `json:"secondaryPodRange,omitempty"`
	// Subnetwork: Name of the subnetwork where the additional pod network belongs.
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxPodsPerNode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxPodsPerNode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdditionalPodNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AdditionalPodNetworkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdditionalPodRangesConfig: AdditionalPodRangesConfig is the configuration
// for additional pod secondary ranges supporting the ClusterUpdate message.
type AdditionalPodRangesConfig struct {
	// PodRangeInfo: Output only. Information for additional pod range.
	PodRangeInfo []*RangeInfo `json:"podRangeInfo,omitempty"`
	// PodRangeNames: Name for pod secondary ipv4 range which has the actual range
	// defined ahead.
	PodRangeNames []string `json:"podRangeNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PodRangeInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PodRangeInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdditionalPodRangesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AdditionalPodRangesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AddonsConfig: Configuration for the addons that can be automatically spun up
// in the cluster, enabling additional functionality.
type AddonsConfig struct {
	// CloudRunConfig: Configuration for the Cloud Run addon. The `IstioConfig`
	// addon must be enabled in order to enable Cloud Run addon. This option can
	// only be enabled at cluster creation time.
	CloudRunConfig *CloudRunConfig `json:"cloudRunConfig,omitempty"`
	// ConfigConnectorConfig: Configuration for the ConfigConnector add-on, a
	// Kubernetes extension to manage hosted GCP services through the Kubernetes
	// API
	ConfigConnectorConfig *ConfigConnectorConfig `json:"configConnectorConfig,omitempty"`
	// DnsCacheConfig: Configuration for NodeLocalDNS, a dns cache running on
	// cluster nodes
	DnsCacheConfig *DnsCacheConfig `json:"dnsCacheConfig,omitempty"`
	// GcePersistentDiskCsiDriverConfig: Configuration for the Compute Engine
	// Persistent Disk CSI driver.
	GcePersistentDiskCsiDriverConfig *GcePersistentDiskCsiDriverConfig `json:"gcePersistentDiskCsiDriverConfig,omitempty"`
	// GcpFilestoreCsiDriverConfig: Configuration for the GCP Filestore CSI driver.
	GcpFilestoreCsiDriverConfig *GcpFilestoreCsiDriverConfig `json:"gcpFilestoreCsiDriverConfig,omitempty"`
	// GcsFuseCsiDriverConfig: Configuration for the Cloud Storage Fuse CSI driver.
	GcsFuseCsiDriverConfig *GcsFuseCsiDriverConfig `json:"gcsFuseCsiDriverConfig,omitempty"`
	// GkeBackupAgentConfig: Configuration for the Backup for GKE agent addon.
	GkeBackupAgentConfig *GkeBackupAgentConfig `json:"gkeBackupAgentConfig,omitempty"`
	// HighScaleCheckpointingConfig: Configuration for the High Scale Checkpointing
	// add-on.
	HighScaleCheckpointingConfig *HighScaleCheckpointingConfig `json:"highScaleCheckpointingConfig,omitempty"`
	// HorizontalPodAutoscaling: Configuration for the horizontal pod autoscaling
	// feature, which increases or decreases the number of replica pods a
	// replication controller has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `json:"horizontalPodAutoscaling,omitempty"`
	// HttpLoadBalancing: Configuration for the HTTP (L7) load balancing controller
	// addon, which makes it easy to set up HTTP load balancers for services in a
	// cluster.
	HttpLoadBalancing *HttpLoadBalancing `json:"httpLoadBalancing,omitempty"`
	// IstioConfig: Configuration for Istio, an open platform to connect, manage,
	// and secure microservices.
	IstioConfig *IstioConfig `json:"istioConfig,omitempty"`
	// KalmConfig: Configuration for the KALM addon, which manages the lifecycle of
	// k8s applications.
	KalmConfig *KalmConfig `json:"kalmConfig,omitempty"`
	// KubernetesDashboard: Configuration for the Kubernetes Dashboard. This addon
	// is deprecated, and will be disabled in 1.15. It is recommended to use the
	// Cloud Console to manage and monitor your Kubernetes clusters, workloads and
	// applications. For more information, see:
	// https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/concepts/dashboards
	KubernetesDashboard *KubernetesDashboard `json:"kubernetesDashboard,omitempty"`
	// LustreCsiDriverConfig: Configuration for the Lustre CSI driver.
	LustreCsiDriverConfig *LustreCsiDriverConfig `json:"lustreCsiDriverConfig,omitempty"`
	// NetworkPolicyConfig: Configuration for NetworkPolicy. This only tracks
	// whether the addon is enabled or not on the Master, it does not track whether
	// network policy is enabled for the nodes.
	NetworkPolicyConfig *NetworkPolicyConfig `json:"networkPolicyConfig,omitempty"`
	// ParallelstoreCsiDriverConfig: Configuration for the Cloud Storage
	// Parallelstore CSI driver.
	ParallelstoreCsiDriverConfig *ParallelstoreCsiDriverConfig `json:"parallelstoreCsiDriverConfig,omitempty"`
	// RayOperatorConfig: Optional. Configuration for Ray Operator addon.
	RayOperatorConfig *RayOperatorConfig `json:"rayOperatorConfig,omitempty"`
	// StatefulHaConfig: Optional. Configuration for the StatefulHA add-on.
	StatefulHaConfig *StatefulHAConfig `json:"statefulHaConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudRunConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudRunConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddonsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AddonsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdvancedDatapathObservabilityConfig: AdvancedDatapathObservabilityConfig
// specifies configuration of observability features of advanced datapath.
type AdvancedDatapathObservabilityConfig struct {
	// EnableMetrics: Expose flow metrics on nodes
	EnableMetrics bool `json:"enableMetrics,omitempty"`
	// EnableRelay: Enable Relay component
	EnableRelay bool `json:"enableRelay,omitempty"`
	// RelayMode: Method used to make Relay available
	//
	// Possible values:
	//   "RELAY_MODE_UNSPECIFIED" - Default value. This shouldn't be used.
	//   "DISABLED" - disabled
	//   "INTERNAL_VPC_LB" - exposed via internal load balancer
	//   "EXTERNAL_LB" - exposed via external load balancer
	RelayMode string `json:"relayMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableMetrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdvancedDatapathObservabilityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AdvancedDatapathObservabilityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdvancedMachineFeatures: Specifies options for controlling advanced machine
// features.
type AdvancedMachineFeatures struct {
	// EnableNestedVirtualization: Whether or not to enable nested virtualization
	// (defaults to false).
	EnableNestedVirtualization bool `json:"enableNestedVirtualization,omitempty"`
	// PerformanceMonitoringUnit: Type of Performance Monitoring Unit (PMU)
	// requested on node pool instances. If unset, PMU will not be available to the
	// node.
	//
	// Possible values:
	//   "PERFORMANCE_MONITORING_UNIT_UNSPECIFIED" - PMU not enabled.
	//   "ARCHITECTURAL" - Architecturally defined non-LLC events.
	//   "STANDARD" - Most documented core/L2 events.
	//   "ENHANCED" - Most documented core/L2 and LLC events.
	PerformanceMonitoringUnit string `json:"performanceMonitoringUnit,omitempty"`
	// ThreadsPerCore: The number of threads per physical core. To disable
	// simultaneous multithreading (SMT) set this to 1. If unset, the maximum
	// number of threads supported per core by the underlying processor is assumed.
	ThreadsPerCore int64 `json:"threadsPerCore,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EnableNestedVirtualization")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableNestedVirtualization") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdvancedMachineFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod AdvancedMachineFeatures
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnonymousAuthenticationConfig: AnonymousAuthenticationConfig defines the
// settings needed to limit endpoints that allow anonymous authentication.
type AnonymousAuthenticationConfig struct {
	// Mode: Defines the mode of limiting anonymous access in the cluster.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value not specified.
	//   "ENABLED" - Anonymous authentication is allowed for all endpoints.
	//   "LIMITED" - Anonymous authentication is allowed for only health check
	// endpoints.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnonymousAuthenticationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AnonymousAuthenticationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthenticatorGroupsConfig: Configuration for returning group information
// from authenticators.
type AuthenticatorGroupsConfig struct {
	// Enabled: Whether this cluster should return group membership lookups during
	// authentication using a group of security groups.
	Enabled bool `json:"enabled,omitempty"`
	// SecurityGroup: The name of the security group-of-groups to be used. Only
	// relevant if enabled = true.
	SecurityGroup string `json:"securityGroup,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthenticatorGroupsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuthenticatorGroupsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutoIpamConfig: AutoIpamConfig contains all information related to Auto IPAM
type AutoIpamConfig struct {
	// Enabled: The flag that enables Auto IPAM on this cluster
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutoIpamConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AutoIpamConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutoMonitoringConfig: AutoMonitoringConfig defines the configuration for GKE
// Workload Auto-Monitoring.
type AutoMonitoringConfig struct {
	// Scope: Scope for GKE Workload Auto-Monitoring.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Not set.
	//   "ALL" - Auto-Monitoring is enabled for all supported applications.
	//   "NONE" - Disable Auto-Monitoring.
	Scope string `json:"scope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Scope") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Scope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutoMonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AutoMonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutoUpgradeOptions: AutoUpgradeOptions defines the set of options for the
// user to control how the Auto Upgrades will proceed.
type AutoUpgradeOptions struct {
	// AutoUpgradeStartTime: Output only. This field is set when upgrades are about
	// to commence with the approximate start time for the upgrades, in RFC3339
	// (https://www.ietf.org/rfc/rfc3339.txt) text format.
	AutoUpgradeStartTime string `json:"autoUpgradeStartTime,omitempty"`
	// Description: Output only. This field is set when upgrades are about to
	// commence with the description of the upgrade.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoUpgradeStartTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoUpgradeStartTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutoUpgradeOptions) MarshalJSON() ([]byte, error) {
	type NoMethod AutoUpgradeOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Autopilot: Autopilot is the configuration for Autopilot settings on the
// cluster.
type Autopilot struct {
	// ConversionStatus: Output only. ConversionStatus shows conversion status.
	ConversionStatus *AutopilotConversionStatus `json:"conversionStatus,omitempty"`
	// Enabled: Enable Autopilot
	Enabled bool `json:"enabled,omitempty"`
	// PrivilegedAdmissionConfig: PrivilegedAdmissionConfig is the configuration
	// related to privileged admission control.
	PrivilegedAdmissionConfig *PrivilegedAdmissionConfig `json:"privilegedAdmissionConfig,omitempty"`
	// WorkloadPolicyConfig: WorkloadPolicyConfig is the configuration related to
	// GCW workload policy
	WorkloadPolicyConfig *WorkloadPolicyConfig `json:"workloadPolicyConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversionStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversionStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Autopilot) MarshalJSON() ([]byte, error) {
	type NoMethod Autopilot
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutopilotCompatibilityIssue: AutopilotCompatibilityIssue contains
// information about a specific compatibility issue with Autopilot mode.
type AutopilotCompatibilityIssue struct {
	// ConstraintType: The constraint type of the issue.
	ConstraintType string `json:"constraintType,omitempty"`
	// Description: The description of the issue.
	Description string `json:"description,omitempty"`
	// DocumentationUrl: A URL to a public documentation, which addresses resolving
	// this issue.
	DocumentationUrl string `json:"documentationUrl,omitempty"`
	// IncompatibilityType: The incompatibility type of this issue.
	//
	// Possible values:
	//   "UNSPECIFIED" - Default value, should not be used.
	//   "INCOMPATIBILITY" - Indicates that the issue is a known incompatibility
	// between the cluster and Autopilot mode.
	//   "ADDITIONAL_CONFIG_REQUIRED" - Indicates the issue is an incompatibility
	// if customers take no further action to resolve.
	//   "PASSED_WITH_OPTIONAL_CONFIG" - Indicates the issue is not an
	// incompatibility, but depending on the workloads business logic, there is a
	// potential that they won't work on Autopilot.
	IncompatibilityType string `json:"incompatibilityType,omitempty"`
	// LastObservation: The last time when this issue was observed.
	LastObservation string `json:"lastObservation,omitempty"`
	// Subjects: The name of the resources which are subject to this issue.
	Subjects []string `json:"subjects,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstraintType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstraintType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutopilotCompatibilityIssue) MarshalJSON() ([]byte, error) {
	type NoMethod AutopilotCompatibilityIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutopilotConfig: AutopilotConfig contains configuration of autopilot feature
// for this nodepool.
type AutopilotConfig struct {
	// Enabled: Denotes that nodes belonging to this node pool are Autopilot nodes.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutopilotConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AutopilotConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutopilotConversionStatus: AutopilotConversionStatus represents conversion
// status.
type AutopilotConversionStatus struct {
	// State: Output only. The current state of the conversion.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - STATE_UNSPECIFIED indicates the state is
	// unspecified.
	//   "DONE" - DONE indicates the conversion has been completed. Old node pools
	// will continue being deleted in the background.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutopilotConversionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AutopilotConversionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutoprovisioningNodePoolDefaults: AutoprovisioningNodePoolDefaults contains
// defaults for a node pool created by NAP.
type AutoprovisioningNodePoolDefaults struct {
	// BootDiskKmsKey:  The Customer Managed Encryption Key used to encrypt the
	// boot disk attached to each node in the node pool. This should be of the form
	// projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKey
	// s/[KEY_NAME]. For more information about protecting resources with Cloud KMS
	// Keys please see:
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/customer-managed-encryption
	BootDiskKmsKey string `json:"bootDiskKmsKey,omitempty"`
	// DiskSizeGb: Size of the disk attached to each node, specified in GB. The
	// smallest allowed disk size is 10GB. If unspecified, the default disk size is
	// 100GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty"`
	// DiskType: Type of the disk attached to each node (e.g. 'pd-standard',
	// 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is
	// 'pd-standard'
	DiskType string `json:"diskType,omitempty"`
	// ImageType: The image type to use for NAP created node. Please see
	// https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/concepts/node-images
	// for available image types.
	ImageType string `json:"imageType,omitempty"`
	// InsecureKubeletReadonlyPortEnabled: DEPRECATED. Use
	// NodePoolAutoConfig.NodeKubeletConfig instead.
	InsecureKubeletReadonlyPortEnabled bool `json:"insecureKubeletReadonlyPortEnabled,omitempty"`
	// Management: NodeManagement configuration for this NodePool.
	Management *NodeManagement `json:"management,omitempty"`
	// MinCpuPlatform: Deprecated. Minimum CPU platform to be used for NAP created
	// node pools. The instance may be scheduled on the specified or newer CPU
	// platform. Applicable values are the friendly names of CPU platforms, such as
	// minCpuPlatform: Intel Haswell or minCpuPlatform: Intel Sandy Bridge. For
	// more information, read how to specify min CPU platform
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/instances/specify-min-cpu-platform).
	// This field is deprecated, min_cpu_platform should be specified using
	// `cloud.google.com/requested-min-cpu-platform` label selector on the pod. To
	// unset the min cpu platform field pass "automatic" as field value.
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`
	// OauthScopes: The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account. The following scopes are
	// recommended, but not required, and by default are not included: *
	// `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes. *
	// `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io** (the Google Container Registry
	// (https://{$universe.dns_names.final_documentation_domain}/container-registry/)).
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `json:"oauthScopes,omitempty"`
	// ServiceAccount: The Google Cloud Platform Service Account to be used by the
	// node VMs. Specify the email address of the Service Account; otherwise, if no
	// Service Account is specified, the "default" service account is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ShieldedInstanceConfig: Shielded Instance options.
	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`
	// UpgradeSettings: Upgrade settings control disruption and speed of the
	// upgrade.
	UpgradeSettings *UpgradeSettings `json:"upgradeSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BootDiskKmsKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BootDiskKmsKey") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutoprovisioningNodePoolDefaults) MarshalJSON() ([]byte, error) {
	type NoMethod AutoprovisioningNodePoolDefaults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AvailableVersion: Deprecated.
type AvailableVersion struct {
	// Reason: Reason for availability.
	Reason string `json:"reason,omitempty"`
	// Version: Kubernetes version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Reason") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AvailableVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AvailableVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BestEffortProvisioning: Best effort provisioning.
type BestEffortProvisioning struct {
	// Enabled: When this is enabled, cluster/node pool creations will ignore
	// non-fatal errors like stockout to best provision as many nodes as possible
	// right now and eventually bring up all target number of nodes
	Enabled bool `json:"enabled,omitempty"`
	// MinProvisionNodes: Minimum number of nodes to be provisioned to be
	// considered as succeeded, and the rest of nodes will be provisioned gradually
	// and eventually when stockout issue has been resolved.
	MinProvisionNodes int64 `json:"minProvisionNodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BestEffortProvisioning) MarshalJSON() ([]byte, error) {
	type NoMethod BestEffortProvisioning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigQueryDestination: Parameters for using BigQuery as the destination of
// resource usage export.
type BigQueryDestination struct {
	// DatasetId: The ID of a BigQuery Dataset.
	DatasetId string `json:"datasetId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BinaryAuthorization: Configuration for Binary Authorization.
type BinaryAuthorization struct {
	// Enabled: This field is deprecated. Leave this unset and instead configure
	// BinaryAuthorization using evaluation_mode. If evaluation_mode is set to
	// anything other than EVALUATION_MODE_UNSPECIFIED, this field is ignored.
	Enabled bool `json:"enabled,omitempty"`
	// EvaluationMode: Mode of operation for binauthz policy evaluation. If
	// unspecified, defaults to DISABLED.
	//
	// Possible values:
	//   "EVALUATION_MODE_UNSPECIFIED" - Default value
	//   "DISABLED" - Disable BinaryAuthorization
	//   "PROJECT_SINGLETON_POLICY_ENFORCE" - Enforce Kubernetes admission requests
	// with BinaryAuthorization using the project's singleton policy. This is
	// equivalent to setting the enabled boolean to true.
	//   "POLICY_BINDINGS" - Use Binary Authorization Continuous Validation with
	// the policies specified in policy_bindings.
	//   "POLICY_BINDINGS_AND_PROJECT_SINGLETON_POLICY_ENFORCE" - Use Binary
	// Authorization Continuous Validation with the policies specified in
	// policy_bindings and enforce Kubernetes admission requests with Binary
	// Authorization using the project's singleton policy.
	EvaluationMode string `json:"evaluationMode,omitempty"`
	// PolicyBindings: Optional. Binauthz policies that apply to this cluster.
	PolicyBindings []*PolicyBinding `json:"policyBindings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BinaryAuthorization) MarshalJSON() ([]byte, error) {
	type NoMethod BinaryAuthorization
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlueGreenInfo: Information relevant to blue-green upgrade.
type BlueGreenInfo struct {
	// BlueInstanceGroupUrls: The resource URLs of the [managed instance groups]
	// (/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with blue pool.
	BlueInstanceGroupUrls []string `json:"blueInstanceGroupUrls,omitempty"`
	// BluePoolDeletionStartTime: Time to start deleting blue pool to complete
	// blue-green upgrade, in RFC3339 (https://www.ietf.org/rfc/rfc3339.txt) text
	// format.
	BluePoolDeletionStartTime string `json:"bluePoolDeletionStartTime,omitempty"`
	// GreenInstanceGroupUrls: The resource URLs of the [managed instance groups]
	// (/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with green pool.
	GreenInstanceGroupUrls []string `json:"greenInstanceGroupUrls,omitempty"`
	// GreenPoolVersion: Version of green pool.
	GreenPoolVersion string `json:"greenPoolVersion,omitempty"`
	// Phase: Current blue-green upgrade phase.
	//
	// Possible values:
	//   "PHASE_UNSPECIFIED" - Unspecified phase.
	//   "UPDATE_STARTED" - blue-green upgrade has been initiated.
	//   "CREATING_GREEN_POOL" - Start creating green pool nodes.
	//   "CORDONING_BLUE_POOL" - Start cordoning blue pool nodes.
	//   "WAITING_TO_DRAIN_BLUE_POOL" - Start waiting after cordoning the blue pool
	// and before draining it.
	//   "DRAINING_BLUE_POOL" - Start draining blue pool nodes.
	//   "NODE_POOL_SOAKING" - Start soaking time after draining entire blue pool.
	//   "DELETING_BLUE_POOL" - Start deleting blue nodes.
	//   "ROLLBACK_STARTED" - Rollback has been initiated.
	Phase string `json:"phase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlueInstanceGroupUrls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlueInstanceGroupUrls") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlueGreenInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BlueGreenInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlueGreenSettings: Settings for blue-green upgrade.
type BlueGreenSettings struct {
	// NodePoolSoakDuration: Time needed after draining entire blue pool. After
	// this period, blue pool will be cleaned up.
	NodePoolSoakDuration string `json:"nodePoolSoakDuration,omitempty"`
	// StandardRolloutPolicy: Standard policy for the blue-green upgrade.
	StandardRolloutPolicy *StandardRolloutPolicy `json:"standardRolloutPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NodePoolSoakDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodePoolSoakDuration") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlueGreenSettings) MarshalJSON() ([]byte, error) {
	type NoMethod BlueGreenSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BootDisk: BootDisk specifies the boot disk configuration for nodepools.
type BootDisk struct {
	// DiskType: Disk type of the boot disk. (i.e. Hyperdisk-Balanced, PD-Balanced,
	// etc.)
	DiskType string `json:"diskType,omitempty"`
	// ProvisionedIops: For Hyperdisk-Balanced only, the provisioned IOPS config
	// value.
	ProvisionedIops int64 `json:"provisionedIops,omitempty,string"`
	// ProvisionedThroughput: For Hyperdisk-Balanced only, the provisioned
	// throughput config value.
	ProvisionedThroughput int64 `json:"provisionedThroughput,omitempty,string"`
	// SizeGb: Disk size in GB. Replaces NodeConfig.disk_size_gb
	SizeGb int64 `json:"sizeGb,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DiskType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BootDisk) MarshalJSON() ([]byte, error) {
	type NoMethod BootDisk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: CancelOperationRequest cancels a single operation.
type CancelOperationRequest struct {
	// Name: The name (project, location, operation id) of the operation to cancel.
	// Specified in the format `projects/*/locations/*/operations/*`.
	Name string `json:"name,omitempty"`
	// OperationId: Deprecated. The server-assigned `name` of the operation. This
	// field has been deprecated and replaced by the name field.
	OperationId string `json:"operationId,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the operation resides. This field has been deprecated and replaced
	// by the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CancelOperationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CancelOperationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CertificateAuthorityDomainConfig: CertificateAuthorityDomainConfig
// configures one or more fully qualified domain names (FQDN) to a specific
// certificate.
type CertificateAuthorityDomainConfig struct {
	// Fqdns: List of fully qualified domain names (FQDN). Specifying port is
	// supported. Wildcards are NOT supported. Examples: - my.customdomain.com -
	// 10.0.1.2:5000
	Fqdns []string `json:"fqdns,omitempty"`
	// GcpSecretManagerCertificateConfig: Google Secret Manager (GCP) certificate
	// configuration.
	GcpSecretManagerCertificateConfig *GCPSecretManagerCertificateConfig `json:"gcpSecretManagerCertificateConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fqdns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fqdns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CertificateAuthorityDomainConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CertificateAuthorityDomainConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckAutopilotCompatibilityResponse: CheckAutopilotCompatibilityResponse has
// a list of compatibility issues.
type CheckAutopilotCompatibilityResponse struct {
	// Issues: The list of issues for the given operation.
	Issues []*AutopilotCompatibilityIssue `json:"issues,omitempty"`
	// Summary: The summary of the autopilot compatibility response.
	Summary string `json:"summary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Issues") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckAutopilotCompatibilityResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckAutopilotCompatibilityResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CidrBlock: CidrBlock contains an optional name and one CIDR block.
type CidrBlock struct {
	// CidrBlock: cidr_block must be specified in CIDR notation.
	CidrBlock string `json:"cidrBlock,omitempty"`
	// DisplayName: display_name is an optional field for users to identify CIDR
	// blocks.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CidrBlock") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CidrBlock") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CidrBlock) MarshalJSON() ([]byte, error) {
	type NoMethod CidrBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClientCertificateConfig: Configuration for client certificates on the
// cluster.
type ClientCertificateConfig struct {
	// IssueClientCertificate: Issue a client certificate.
	IssueClientCertificate bool `json:"issueClientCertificate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueClientCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueClientCertificate") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClientCertificateConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ClientCertificateConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudRunConfig: Configuration options for the Cloud Run feature.
type CloudRunConfig struct {
	// Disabled: Whether Cloud Run addon is enabled for this cluster.
	Disabled bool `json:"disabled,omitempty"`
	// LoadBalancerType: Which load balancer type is installed for Cloud Run.
	//
	// Possible values:
	//   "LOAD_BALANCER_TYPE_UNSPECIFIED" - Load balancer type for Cloud Run is
	// unspecified.
	//   "LOAD_BALANCER_TYPE_EXTERNAL" - Install external load balancer for Cloud
	// Run.
	//   "LOAD_BALANCER_TYPE_INTERNAL" - Install internal load balancer for Cloud
	// Run.
	LoadBalancerType string `json:"loadBalancerType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudRunConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CloudRunConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Cluster: A Google Kubernetes Engine cluster.
type Cluster struct {
	// AddonsConfig: Configurations for the various addons available to run in the
	// cluster.
	AddonsConfig *AddonsConfig `json:"addonsConfig,omitempty"`
	// AlphaClusterFeatureGates: The list of user specified Kubernetes feature
	// gates. Each string represents the activation status of a feature gate (e.g.
	// "featureX=true" or "featureX=false")
	AlphaClusterFeatureGates []string `json:"alphaClusterFeatureGates,omitempty"`
	// AnonymousAuthenticationConfig: Configuration for limiting anonymous access
	// to all endpoints except the health checks.
	AnonymousAuthenticationConfig *AnonymousAuthenticationConfig `json:"anonymousAuthenticationConfig,omitempty"`
	// AuthenticatorGroupsConfig: Configuration controlling RBAC group membership
	// information.
	AuthenticatorGroupsConfig *AuthenticatorGroupsConfig `json:"authenticatorGroupsConfig,omitempty"`
	// Autopilot: Autopilot configuration for the cluster.
	Autopilot *Autopilot `json:"autopilot,omitempty"`
	// Autoscaling: Cluster-level autoscaling configuration.
	Autoscaling *ClusterAutoscaling `json:"autoscaling,omitempty"`
	// BinaryAuthorization: Configuration for Binary Authorization.
	BinaryAuthorization *BinaryAuthorization `json:"binaryAuthorization,omitempty"`
	// ClusterIpv4Cidr: The IP address range of the container pods in this cluster,
	// in CIDR (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have one automatically chosen
	// or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `json:"clusterIpv4Cidr,omitempty"`
	// ClusterTelemetry: Telemetry integration for the cluster.
	ClusterTelemetry *ClusterTelemetry `json:"clusterTelemetry,omitempty"`
	// CompliancePostureConfig: Enable/Disable Compliance Posture features for the
	// cluster.
	CompliancePostureConfig *CompliancePostureConfig `json:"compliancePostureConfig,omitempty"`
	// Conditions: Which conditions caused the current cluster state.
	Conditions []*StatusCondition `json:"conditions,omitempty"`
	// ConfidentialNodes: Configuration of Confidential Nodes. All the nodes in the
	// cluster will be Confidential VM once enabled.
	ConfidentialNodes *ConfidentialNodes `json:"confidentialNodes,omitempty"`
	// ControlPlaneEndpointsConfig: Configuration for all cluster's control plane
	// endpoints.
	ControlPlaneEndpointsConfig *ControlPlaneEndpointsConfig `json:"controlPlaneEndpointsConfig,omitempty"`
	// CostManagementConfig: Configuration for the fine-grained cost management
	// feature.
	CostManagementConfig *CostManagementConfig `json:"costManagementConfig,omitempty"`
	// CreateTime: Output only. The time the cluster was created, in RFC3339
	// (https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `json:"createTime,omitempty"`
	// CurrentMasterVersion: Output only. The current software version of the
	// master endpoint.
	CurrentMasterVersion string `json:"currentMasterVersion,omitempty"`
	// CurrentNodeCount: Output only. The number of nodes currently in the cluster.
	// Deprecated. Call Kubernetes API directly to retrieve node information.
	CurrentNodeCount int64 `json:"currentNodeCount,omitempty"`
	// CurrentNodeVersion: Output only. Deprecated, use NodePool.version
	// (https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools)
	// instead. The current version of the node software components. If they are
	// currently at multiple versions because they're in the process of being
	// upgraded, this reflects the minimum version of all nodes.
	CurrentNodeVersion string `json:"currentNodeVersion,omitempty"`
	// DatabaseEncryption: Configuration of etcd encryption.
	DatabaseEncryption *DatabaseEncryption `json:"databaseEncryption,omitempty"`
	// DefaultMaxPodsConstraint: The default constraint on the maximum number of
	// pods that can be run simultaneously on a node in the node pool of this
	// cluster. Only honored if cluster created with IP Alias support.
	DefaultMaxPodsConstraint *MaxPodsConstraint `json:"defaultMaxPodsConstraint,omitempty"`
	// Description: An optional description of this cluster.
	Description string `json:"description,omitempty"`
	// EnableK8sBetaApis: Kubernetes open source beta apis enabled on the cluster.
	// Only beta apis.
	EnableK8sBetaApis *K8sBetaAPIConfig `json:"enableK8sBetaApis,omitempty"`
	// EnableKubernetesAlpha: Kubernetes alpha features are enabled on this
	// cluster. This includes alpha API groups (e.g. v1beta1) and features that may
	// not be production ready in the kubernetes version of the master and nodes.
	// The cluster has no SLA for uptime and master/node upgrades are disabled.
	// Alpha enabled clusters are automatically deleted thirty days after creation.
	EnableKubernetesAlpha bool `json:"enableKubernetesAlpha,omitempty"`
	// EnableTpu: Enable the ability to use Cloud TPUs in this cluster. This field
	// is deprecated, use tpu_config.enabled instead. This field is deprecated due
	// to the deprecation of 2VM TPU. The end of life date for 2VM TPU is
	// 2025-04-25.
	EnableTpu bool `json:"enableTpu,omitempty"`
	// Endpoint: Output only. The IP address of this cluster's master endpoint. The
	// endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`. See the `masterAuth` property of this
	// resource for username and password information.
	Endpoint string `json:"endpoint,omitempty"`
	// EnterpriseConfig: GKE Enterprise Configuration.
	EnterpriseConfig *EnterpriseConfig `json:"enterpriseConfig,omitempty"`
	// Etag: This checksum is computed by the server based on the value of cluster
	// fields, and may be sent on update requests to ensure the client has an
	// up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// ExpireTime: Output only. The time the cluster will be automatically deleted
	// in RFC3339 (https://www.ietf.org/rfc/rfc3339.txt) text format.
	ExpireTime string `json:"expireTime,omitempty"`
	// Fleet: Fleet information for the cluster.
	Fleet *Fleet `json:"fleet,omitempty"`
	// GkeAutoUpgradeConfig: Configuration for GKE auto upgrades.
	GkeAutoUpgradeConfig *GkeAutoUpgradeConfig `json:"gkeAutoUpgradeConfig,omitempty"`
	// Id: Output only. Unique id for the cluster.
	Id string `json:"id,omitempty"`
	// IdentityServiceConfig: Configuration for Identity Service component.
	IdentityServiceConfig *IdentityServiceConfig `json:"identityServiceConfig,omitempty"`
	// InitialClusterVersion: The initial Kubernetes version for this cluster.
	// Valid versions are those found in validMasterVersions returned by
	// getServerConfig. The version can be upgraded over time; such upgrades are
	// reflected in currentMasterVersion and currentNodeVersion. Users may specify
	// either explicit versions offered by Kubernetes Engine or version aliases,
	// which have the following behavior: - "latest": picks the highest valid
	// Kubernetes version - "1.X": picks the highest valid patch+gke.N patch in the
	// 1.X version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y
	// version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "","-":
	// picks the default Kubernetes version
	InitialClusterVersion string `json:"initialClusterVersion,omitempty"`
	// InitialNodeCount: The number of nodes to create in this cluster. You must
	// ensure that your Compute Engine resource quota
	// (https://{$universe.dns_names.final_documentation_domain}/compute/quotas) is
	// sufficient for this number of instances. You must also have available
	// firewall and routes quota. For requests, this field should only be used in
	// lieu of a "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time. This
	// field is deprecated, use node_pool.initial_node_count instead.
	InitialNodeCount int64 `json:"initialNodeCount,omitempty"`
	// InstanceGroupUrls: Output only. Deprecated. Use
	// node_pools.instance_group_urls.
	InstanceGroupUrls []string `json:"instanceGroupUrls,omitempty"`
	// IpAllocationPolicy: Configuration for cluster IP allocation.
	IpAllocationPolicy *IPAllocationPolicy `json:"ipAllocationPolicy,omitempty"`
	// LabelFingerprint: The fingerprint of the set of labels for this cluster.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`
	// LegacyAbac: Configuration for the legacy ABAC authorization mode.
	LegacyAbac *LegacyAbac `json:"legacyAbac,omitempty"`
	// Location: Output only. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/regions-zones/regions-zones#available)
	// or region
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/regions-zones/regions-zones#available)
	// in which the cluster resides.
	Location string `json:"location,omitempty"`
	// Locations: The list of Google Compute Engine zones
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster's nodes should be located. This field provides a
	// default value if NodePool.Locations
	// (https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
	// are not specified during node pool creation. Warning: changing cluster
	// locations will update the NodePool.Locations
	// (https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
	// of all node pools and will result in nodes being added and/or removed.
	Locations []string `json:"locations,omitempty"`
	// LoggingConfig: Logging configuration for the cluster.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// LoggingService: The logging service the cluster should use to write logs.
	// Currently available options: * `logging.googleapis.com/kubernetes` - The
	// Cloud Logging service with a Kubernetes-native resource model *
	// `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	// available as of GKE 1.15). * `none` - no logs will be exported from the
	// cluster. If left as an empty string,`logging.googleapis.com/kubernetes` will
	// be used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	LoggingService string `json:"loggingService,omitempty"`
	// MaintenancePolicy: Configure the maintenance policy for this cluster.
	MaintenancePolicy *MaintenancePolicy `json:"maintenancePolicy,omitempty"`
	// Master: Configuration for master components.
	Master *Master `json:"master,omitempty"`
	// MasterAuth: The authentication information for accessing the master
	// endpoint. If unspecified, the defaults are used: For clusters before v1.12,
	// if master_auth is unspecified, `username` will be set to "admin", a random
	// password will be generated, and a client certificate will be issued.
	MasterAuth *MasterAuth `json:"masterAuth,omitempty"`
	// MasterAuthorizedNetworksConfig: The configuration options for master
	// authorized networks feature. Deprecated: Use
	// ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config
	// instead.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `json:"masterAuthorizedNetworksConfig,omitempty"`
	// MasterIpv4CidrBlock: The IP prefix in CIDR notation to use for the hosted
	// master network. This prefix will be used for assigning private IP addresses
	// to the master or set of masters, as well as the ILB VIP. This field is
	// deprecated, use private_cluster_config.master_ipv4_cidr_block instead.
	MasterIpv4CidrBlock string `json:"masterIpv4CidrBlock,omitempty"`
	// MeshCertificates: Configuration for issuance of mTLS keys and certificates
	// to Kubernetes pods.
	MeshCertificates *MeshCertificates `json:"meshCertificates,omitempty"`
	// MonitoringConfig: Monitoring configuration for the cluster.
	MonitoringConfig *MonitoringConfig `json:"monitoringConfig,omitempty"`
	// MonitoringService: The monitoring service the cluster should use to write
	// metrics. Currently available options: *
	// `monitoring.googleapis.com/kubernetes` - The Cloud Monitoring service with a
	// Kubernetes-native resource model * `monitoring.googleapis.com` - The legacy
	// Cloud Monitoring service (no longer available as of GKE 1.15). * `none` - No
	// metrics will be exported from the cluster. If left as an empty
	// string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or
	// `monitoring.googleapis.com` for earlier versions.
	MonitoringService string `json:"monitoringService,omitempty"`
	// Name: The name of this cluster. The name must be unique within this project
	// and location (e.g. zone or region), and can be up to 40 characters with the
	// following restrictions: * Lowercase letters, numbers, and hyphens only. *
	// Must start with a letter. * Must end with a number or a letter.
	Name string `json:"name,omitempty"`
	// Network: The name of the Google Compute Engine network
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/networks-and-firewalls#networks)
	// to which the cluster is connected. If left unspecified, the `default`
	// network will be used. On output this shows the network ID instead of the
	// name.
	Network string `json:"network,omitempty"`
	// NetworkConfig: Configuration for cluster networking.
	NetworkConfig *NetworkConfig `json:"networkConfig,omitempty"`
	// NetworkPolicy: Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`
	// NodeConfig: Parameters used in creating the cluster's nodes. For requests,
	// this field should only be used in lieu of a "node_pool" object, since this
	// configuration (along with the "initial_node_count") will be used to create a
	// "NodePool" object with an auto-generated name. Do not use this and a
	// node_pool at the same time. For responses, this field will be populated with
	// the node configuration of the first node pool. (For configuration of each
	// node pool, see `node_pool.config`) If unspecified, the defaults are used.
	// This field is deprecated, use node_pool.config instead.
	NodeConfig *NodeConfig `json:"nodeConfig,omitempty"`
	// NodeIpv4CidrSize: Output only. The size of the address space on each node
	// for hosting containers. This is provisioned from within the
	// `container_ipv4_cidr` range. This field will only be set when cluster is in
	// route-based network mode.
	NodeIpv4CidrSize int64 `json:"nodeIpv4CidrSize,omitempty"`
	// NodePoolAutoConfig: Node pool configs that apply to all auto-provisioned
	// node pools in autopilot clusters and node auto-provisioning enabled
	// clusters.
	NodePoolAutoConfig *NodePoolAutoConfig `json:"nodePoolAutoConfig,omitempty"`
	// NodePoolDefaults: Default NodePool settings for the entire cluster. These
	// settings are overridden if specified on the specific NodePool object.
	NodePoolDefaults *NodePoolDefaults `json:"nodePoolDefaults,omitempty"`
	// NodePools: The node pools associated with this cluster. This field should
	// not be set if "node_config" or "initial_node_count" are specified.
	NodePools []*NodePool `json:"nodePools,omitempty"`
	// NotificationConfig: Notification configuration of the cluster.
	NotificationConfig *NotificationConfig `json:"notificationConfig,omitempty"`
	// ParentProductConfig: The configuration of the parent product of the cluster.
	// This field is used by Google internal products that are built on top of the
	// GKE cluster and take the ownership of the cluster.
	ParentProductConfig *ParentProductConfig `json:"parentProductConfig,omitempty"`
	// PodAutoscaling: The config for pod autoscaling.
	PodAutoscaling *PodAutoscaling `json:"podAutoscaling,omitempty"`
	// PodSecurityPolicyConfig: Configuration for the PodSecurityPolicy feature.
	PodSecurityPolicyConfig *PodSecurityPolicyConfig `json:"podSecurityPolicyConfig,omitempty"`
	// PrivateCluster: If this is a private cluster setup. Private clusters are
	// clusters that, by default have no external IP addresses on the nodes and
	// where nodes and the master communicate over private IP addresses. This field
	// is deprecated, use private_cluster_config.enable_private_nodes instead.
	PrivateCluster bool `json:"privateCluster,omitempty"`
	// PrivateClusterConfig: Configuration for private cluster.
	PrivateClusterConfig *PrivateClusterConfig `json:"privateClusterConfig,omitempty"`
	// ProtectConfig: Deprecated: Use SecurityPostureConfig instead. Enable/Disable
	// Protect API features for the cluster.
	ProtectConfig *ProtectConfig `json:"protectConfig,omitempty"`
	// RbacBindingConfig: RBACBindingConfig allows user to restrict
	// ClusterRoleBindings an RoleBindings that can be created.
	RbacBindingConfig *RBACBindingConfig `json:"rbacBindingConfig,omitempty"`
	// ReleaseChannel: Release channel configuration. If left unspecified on
	// cluster creation and a version is specified, the cluster is enrolled in the
	// most mature release channel where the version is available (first checking
	// STABLE, then REGULAR, and finally RAPID). Otherwise, if no release channel
	// configuration and no version is specified, the cluster is enrolled in the
	// REGULAR channel with its default version.
	ReleaseChannel *ReleaseChannel `json:"releaseChannel,omitempty"`
	// ResourceLabels: The resource labels for the cluster to use to annotate any
	// related Google Compute Engine resources.
	ResourceLabels map[string]string `json:"resourceLabels,omitempty"`
	// ResourceUsageExportConfig: Configuration for exporting resource usages.
	// Resource usage export is disabled when this config unspecified.
	ResourceUsageExportConfig *ResourceUsageExportConfig `json:"resourceUsageExportConfig,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SecretManagerConfig: Secret CSI driver configuration.
	SecretManagerConfig *SecretManagerConfig `json:"secretManagerConfig,omitempty"`
	// SecurityPostureConfig: Enable/Disable Security Posture API features for the
	// cluster.
	SecurityPostureConfig *SecurityPostureConfig `json:"securityPostureConfig,omitempty"`
	// SelfLink: Output only. Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`
	// ServicesIpv4Cidr: Output only. The IP address range of the Kubernetes
	// services in this cluster, in CIDR
	// (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
	// `1.2.3.4/29`). Service addresses are typically put in the last `/16` from
	// the container CIDR.
	ServicesIpv4Cidr string `json:"servicesIpv4Cidr,omitempty"`
	// ShieldedNodes: Shielded Nodes configuration.
	ShieldedNodes *ShieldedNodes `json:"shieldedNodes,omitempty"`
	// Status: Output only. The current status of this cluster.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the cluster is being
	// created.
	//   "RUNNING" - The RUNNING state indicates the cluster has been created and
	// is fully usable.
	//   "RECONCILING" - The RECONCILING state indicates that some work is actively
	// being done on the cluster, such as upgrading the master or node software.
	// Details can be found in the `statusMessage` field.
	//   "STOPPING" - The STOPPING state indicates the cluster is being deleted.
	//   "ERROR" - The ERROR state indicates the cluster may be unusable. Details
	// can be found in the `statusMessage` field.
	//   "DEGRADED" - The DEGRADED state indicates the cluster requires user action
	// to restore full functionality. Details can be found in the `statusMessage`
	// field.
	Status string `json:"status,omitempty"`
	// StatusMessage: Output only. Deprecated. Use conditions instead. Additional
	// information about the current status of this cluster, if available.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Subnetwork: The name of the Google Compute Engine subnetwork
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/subnetworks)
	// to which the cluster is connected. On output this shows the subnetwork ID
	// instead of the name.
	Subnetwork string `json:"subnetwork,omitempty"`
	// TpuConfig: Configuration for Cloud TPU support; This field is deprecated due
	// to the deprecation of 2VM TPU. The end of life date for 2VM TPU is
	// 2025-04-25.
	TpuConfig *TpuConfig `json:"tpuConfig,omitempty"`
	// TpuIpv4CidrBlock: Output only. The IP address range of the Cloud TPUs in
	// this cluster, in CIDR
	// (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
	// `1.2.3.4/29`). This field is deprecated due to the deprecation of 2VM TPU.
	// The end of life date for 2VM TPU is 2025-04-25.
	TpuIpv4CidrBlock string `json:"tpuIpv4CidrBlock,omitempty"`
	// UserManagedKeysConfig: The Custom keys configuration for the cluster.
	UserManagedKeysConfig *UserManagedKeysConfig `json:"userManagedKeysConfig,omitempty"`
	// VerticalPodAutoscaling: Cluster-level Vertical Pod Autoscaling
	// configuration.
	VerticalPodAutoscaling *VerticalPodAutoscaling `json:"verticalPodAutoscaling,omitempty"`
	// WorkloadAltsConfig: Configuration for direct-path (via ALTS) with workload
	// identity.
	WorkloadAltsConfig *WorkloadALTSConfig `json:"workloadAltsConfig,omitempty"`
	// WorkloadCertificates: Configuration for issuance of mTLS keys and
	// certificates to Kubernetes pods.
	WorkloadCertificates *WorkloadCertificates `json:"workloadCertificates,omitempty"`
	// WorkloadIdentityConfig: Configuration for the use of Kubernetes Service
	// Accounts in GCP IAM policies.
	WorkloadIdentityConfig *WorkloadIdentityConfig `json:"workloadIdentityConfig,omitempty"`
	// Zone: Output only. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field is deprecated, use location
	// instead.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AddonsConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddonsConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Cluster) MarshalJSON() ([]byte, error) {
	type NoMethod Cluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterAutoscaling: ClusterAutoscaling contains global, per-cluster
// information required by Cluster Autoscaler to automatically adjust the size
// of the cluster and create/delete node pools based on the current needs.
type ClusterAutoscaling struct {
	// AutoprovisioningLocations: The list of Google Compute Engine zones
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the NodePool's nodes can be created by NAP.
	AutoprovisioningLocations []string `json:"autoprovisioningLocations,omitempty"`
	// AutoprovisioningNodePoolDefaults: AutoprovisioningNodePoolDefaults contains
	// defaults for a node pool created by NAP.
	AutoprovisioningNodePoolDefaults *AutoprovisioningNodePoolDefaults `json:"autoprovisioningNodePoolDefaults,omitempty"`
	// AutoscalingProfile: Defines autoscaling behaviour.
	//
	// Possible values:
	//   "PROFILE_UNSPECIFIED" - No change to autoscaling configuration.
	//   "OPTIMIZE_UTILIZATION" - Prioritize optimizing utilization of resources.
	//   "BALANCED" - Use default (balanced) autoscaling configuration.
	AutoscalingProfile string `json:"autoscalingProfile,omitempty"`
	// DefaultComputeClassConfig: Default compute class is a configuration for
	// default compute class.
	DefaultComputeClassConfig *DefaultComputeClassConfig `json:"defaultComputeClassConfig,omitempty"`
	// EnableNodeAutoprovisioning: Enables automatic node pool creation and
	// deletion.
	EnableNodeAutoprovisioning bool `json:"enableNodeAutoprovisioning,omitempty"`
	// ResourceLimits: Contains global constraints regarding minimum and maximum
	// amount of resources in the cluster.
	ResourceLimits []*ResourceLimit `json:"resourceLimits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoprovisioningLocations")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoprovisioningLocations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterAutoscaling) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterAutoscaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterNetworkPerformanceConfig: Configuration of all network bandwidth
// tiers
type ClusterNetworkPerformanceConfig struct {
	// TotalEgressBandwidthTier: Specifies the total network bandwidth tier for the
	// NodePool.
	//
	// Possible values:
	//   "TIER_UNSPECIFIED" - Default value
	//   "TIER_1" - Higher bandwidth, actual values based on VM size.
	TotalEgressBandwidthTier string `json:"totalEgressBandwidthTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TotalEgressBandwidthTier")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalEgressBandwidthTier") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterNetworkPerformanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterNetworkPerformanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterTelemetry: Telemetry integration for the cluster.
type ClusterTelemetry struct {
	// Type: Type of the integration.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not set.
	//   "DISABLED" - Monitoring integration is disabled.
	//   "ENABLED" - Monitoring integration is enabled.
	//   "SYSTEM_ONLY" - Only system components are monitored and logged.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterTelemetry) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterTelemetry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpdate: ClusterUpdate describes an update to the cluster. Exactly one
// update can be applied to a cluster with each request, so at most one field
// can be provided.
type ClusterUpdate struct {
	// AdditionalPodRangesConfig: The additional pod ranges to be added to the
	// cluster. These pod ranges can be used by node pools to allocate pod IPs.
	AdditionalPodRangesConfig *AdditionalPodRangesConfig `json:"additionalPodRangesConfig,omitempty"`
	// DesiredAdditionalIpRangesConfig: The desired config for additional
	// subnetworks attached to the cluster.
	DesiredAdditionalIpRangesConfig *DesiredAdditionalIPRangesConfig `json:"desiredAdditionalIpRangesConfig,omitempty"`
	// DesiredAddonsConfig: Configurations for the various addons available to run
	// in the cluster.
	DesiredAddonsConfig *AddonsConfig `json:"desiredAddonsConfig,omitempty"`
	// DesiredAnonymousAuthenticationConfig: Configuration for limiting anonymous
	// access to all endpoints except the health checks.
	DesiredAnonymousAuthenticationConfig *AnonymousAuthenticationConfig `json:"desiredAnonymousAuthenticationConfig,omitempty"`
	// DesiredAuthenticatorGroupsConfig: AuthenticatorGroupsConfig specifies the
	// config for the cluster security groups settings.
	DesiredAuthenticatorGroupsConfig *AuthenticatorGroupsConfig `json:"desiredAuthenticatorGroupsConfig,omitempty"`
	// DesiredAutoIpamConfig: AutoIpamConfig contains all information related to
	// Auto IPAM
	DesiredAutoIpamConfig *AutoIpamConfig `json:"desiredAutoIpamConfig,omitempty"`
	// DesiredAutopilotWorkloadPolicyConfig: WorkloadPolicyConfig is the
	// configuration related to GCW workload policy
	DesiredAutopilotWorkloadPolicyConfig *WorkloadPolicyConfig `json:"desiredAutopilotWorkloadPolicyConfig,omitempty"`
	// DesiredBinaryAuthorization: The desired configuration options for the Binary
	// Authorization feature.
	DesiredBinaryAuthorization *BinaryAuthorization `json:"desiredBinaryAuthorization,omitempty"`
	// DesiredClusterAutoscaling: Cluster-level autoscaling configuration.
	DesiredClusterAutoscaling *ClusterAutoscaling `json:"desiredClusterAutoscaling,omitempty"`
	// DesiredClusterTelemetry: The desired telemetry integration for the cluster.
	DesiredClusterTelemetry *ClusterTelemetry `json:"desiredClusterTelemetry,omitempty"`
	// DesiredCompliancePostureConfig: Enable/Disable Compliance Posture features
	// for the cluster.
	DesiredCompliancePostureConfig *CompliancePostureConfig `json:"desiredCompliancePostureConfig,omitempty"`
	// DesiredContainerdConfig: The desired containerd config for the cluster.
	DesiredContainerdConfig *ContainerdConfig `json:"desiredContainerdConfig,omitempty"`
	// DesiredControlPlaneEndpointsConfig: Control plane endpoints configuration.
	DesiredControlPlaneEndpointsConfig *ControlPlaneEndpointsConfig `json:"desiredControlPlaneEndpointsConfig,omitempty"`
	// DesiredCostManagementConfig: The desired configuration for the fine-grained
	// cost management feature.
	DesiredCostManagementConfig *CostManagementConfig `json:"desiredCostManagementConfig,omitempty"`
	// DesiredDatabaseEncryption: Configuration of etcd encryption.
	DesiredDatabaseEncryption *DatabaseEncryption `json:"desiredDatabaseEncryption,omitempty"`
	// DesiredDatapathProvider: The desired datapath provider for the cluster.
	//
	// Possible values:
	//   "DATAPATH_PROVIDER_UNSPECIFIED" - Default value.
	//   "LEGACY_DATAPATH" - Use the IPTables implementation based on kube-proxy.
	//   "ADVANCED_DATAPATH" - Use the eBPF based GKE Dataplane V2 with additional
	// features. See the [GKE Dataplane V2
	// documentation](https://{$universe.dns_names.final_documentation_domain}/kuber
	// netes-engine/docs/how-to/dataplane-v2) for more.
	DesiredDatapathProvider string `json:"desiredDatapathProvider,omitempty"`
	// DesiredDefaultEnablePrivateNodes: Override the default setting of whether
	// future created nodes have private IP addresses only, namely
	// NetworkConfig.default_enable_private_nodes
	DesiredDefaultEnablePrivateNodes bool `json:"desiredDefaultEnablePrivateNodes,omitempty"`
	// DesiredDefaultSnatStatus: The desired status of whether to disable default
	// sNAT for this cluster.
	DesiredDefaultSnatStatus *DefaultSnatStatus `json:"desiredDefaultSnatStatus,omitempty"`
	// DesiredDisableL4LbFirewallReconciliation: Enable/Disable L4 LB VPC firewall
	// reconciliation for the cluster.
	DesiredDisableL4LbFirewallReconciliation bool `json:"desiredDisableL4LbFirewallReconciliation,omitempty"`
	// DesiredDnsConfig: DNSConfig contains clusterDNS config for this cluster.
	DesiredDnsConfig *DNSConfig `json:"desiredDnsConfig,omitempty"`
	// DesiredEnableCiliumClusterwideNetworkPolicy: Enable/Disable Cilium
	// Clusterwide Network Policy for the cluster.
	DesiredEnableCiliumClusterwideNetworkPolicy bool `json:"desiredEnableCiliumClusterwideNetworkPolicy,omitempty"`
	// DesiredEnableFqdnNetworkPolicy: Enable/Disable FQDN Network Policy for the
	// cluster.
	DesiredEnableFqdnNetworkPolicy bool `json:"desiredEnableFqdnNetworkPolicy,omitempty"`
	// DesiredEnableMultiNetworking: Enable/Disable Multi-Networking for the
	// cluster
	DesiredEnableMultiNetworking bool `json:"desiredEnableMultiNetworking,omitempty"`
	// DesiredEnablePrivateEndpoint: Enable/Disable private endpoint for the
	// cluster's master. Deprecated: Use
	// desired_control_plane_endpoints_config.ip_endpoints_config.enable_public_endp
	// oint instead. Note that the value of enable_public_endpoint is reversed: if
	// enable_private_endpoint is false, then enable_public_endpoint will be true.
	DesiredEnablePrivateEndpoint bool `json:"desiredEnablePrivateEndpoint,omitempty"`
	// DesiredEnterpriseConfig: The desired enterprise configuration for the
	// cluster.
	DesiredEnterpriseConfig *DesiredEnterpriseConfig `json:"desiredEnterpriseConfig,omitempty"`
	// DesiredFleet: The desired fleet configuration for the cluster.
	DesiredFleet *Fleet `json:"desiredFleet,omitempty"`
	// DesiredGatewayApiConfig: The desired config of Gateway API on this cluster.
	DesiredGatewayApiConfig *GatewayAPIConfig `json:"desiredGatewayApiConfig,omitempty"`
	// DesiredGcfsConfig: The desired GCFS config for the cluster.
	DesiredGcfsConfig *GcfsConfig `json:"desiredGcfsConfig,omitempty"`
	// DesiredHostMaintenancePolicy: HostMaintenancePolicy contains the desired
	// maintenance policy for the Google Compute Engine hosts.
	DesiredHostMaintenancePolicy *HostMaintenancePolicy `json:"desiredHostMaintenancePolicy,omitempty"`
	// DesiredIdentityServiceConfig: The desired Identity Service component
	// configuration.
	DesiredIdentityServiceConfig *IdentityServiceConfig `json:"desiredIdentityServiceConfig,omitempty"`
	// DesiredImageType: The desired image type for the node pool. NOTE: Set the
	// "desired_node_pool" field as well.
	DesiredImageType string `json:"desiredImageType,omitempty"`
	// DesiredInTransitEncryptionConfig: Specify the details of in-transit
	// encryption. Now named inter-node transparent encryption.
	//
	// Possible values:
	//   "IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED" - Unspecified, will be inferred
	// as default - IN_TRANSIT_ENCRYPTION_UNSPECIFIED.
	//   "IN_TRANSIT_ENCRYPTION_DISABLED" - In-transit encryption is disabled.
	//   "IN_TRANSIT_ENCRYPTION_INTER_NODE_TRANSPARENT" - Data in-transit is
	// encrypted using inter-node transparent encryption.
	DesiredInTransitEncryptionConfig string `json:"desiredInTransitEncryptionConfig,omitempty"`
	// DesiredIntraNodeVisibilityConfig: The desired config of Intra-node
	// visibility.
	DesiredIntraNodeVisibilityConfig *IntraNodeVisibilityConfig `json:"desiredIntraNodeVisibilityConfig,omitempty"`
	// DesiredK8sBetaApis: Beta APIs enabled for cluster.
	DesiredK8sBetaApis *K8sBetaAPIConfig `json:"desiredK8sBetaApis,omitempty"`
	// DesiredL4ilbSubsettingConfig: The desired L4 Internal Load Balancer
	// Subsetting configuration.
	DesiredL4ilbSubsettingConfig *ILBSubsettingConfig `json:"desiredL4ilbSubsettingConfig,omitempty"`
	// DesiredLocations: The desired list of Google Compute Engine zones
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster's nodes should be located. This list must always
	// include the cluster's primary zone. Warning: changing cluster locations will
	// update the locations of all node pools and will result in nodes being added
	// and/or removed.
	DesiredLocations []string `json:"desiredLocations,omitempty"`
	// DesiredLoggingConfig: The desired logging configuration.
	DesiredLoggingConfig *LoggingConfig `json:"desiredLoggingConfig,omitempty"`
	// DesiredLoggingService: The logging service the cluster should use to write
	// logs. Currently available options: * `logging.googleapis.com/kubernetes` -
	// The Cloud Logging service with a Kubernetes-native resource model *
	// `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	// available as of GKE 1.15). * `none` - no logs will be exported from the
	// cluster. If left as an empty string,`logging.googleapis.com/kubernetes` will
	// be used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	DesiredLoggingService string `json:"desiredLoggingService,omitempty"`
	// DesiredMaster: Configuration for master components.
	DesiredMaster *Master `json:"desiredMaster,omitempty"`
	// DesiredMasterAuthorizedNetworksConfig: The desired configuration options for
	// master authorized networks feature. Deprecated: Use
	// desired_control_plane_endpoints_config.ip_endpoints_config.authorized_network
	// s_config instead.
	DesiredMasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `json:"desiredMasterAuthorizedNetworksConfig,omitempty"`
	// DesiredMasterVersion: The Kubernetes version to change the master to. The
	// only valid value is the latest supported version. Users may specify either
	// explicit versions offered by Kubernetes Engine or version aliases, which
	// have the following behavior: - "latest": picks the highest valid Kubernetes
	// version - "1.X": picks the highest valid patch+gke.N patch in the 1.X
	// version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-": picks the
	// default Kubernetes version
	DesiredMasterVersion string `json:"desiredMasterVersion,omitempty"`
	// DesiredMeshCertificates: Configuration for issuance of mTLS keys and
	// certificates to Kubernetes pods.
	DesiredMeshCertificates *MeshCertificates `json:"desiredMeshCertificates,omitempty"`
	// DesiredMonitoringConfig: The desired monitoring configuration.
	DesiredMonitoringConfig *MonitoringConfig `json:"desiredMonitoringConfig,omitempty"`
	// DesiredMonitoringService: The monitoring service the cluster should use to
	// write metrics. Currently available options: *
	// `monitoring.googleapis.com/kubernetes` - The Cloud Monitoring service with a
	// Kubernetes-native resource model * `monitoring.googleapis.com` - The legacy
	// Cloud Monitoring service (no longer available as of GKE 1.15). * `none` - No
	// metrics will be exported from the cluster. If left as an empty
	// string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or
	// `monitoring.googleapis.com` for earlier versions.
	DesiredMonitoringService string `json:"desiredMonitoringService,omitempty"`
	// DesiredNetworkPerformanceConfig: The desired network performance config.
	DesiredNetworkPerformanceConfig *ClusterNetworkPerformanceConfig `json:"desiredNetworkPerformanceConfig,omitempty"`
	// DesiredNodeKubeletConfig: The desired node kubelet config for the cluster.
	DesiredNodeKubeletConfig *NodeKubeletConfig `json:"desiredNodeKubeletConfig,omitempty"`
	// DesiredNodePoolAutoConfigKubeletConfig: The desired node kubelet config for
	// all auto-provisioned node pools in autopilot clusters and node
	// auto-provisioning enabled clusters.
	DesiredNodePoolAutoConfigKubeletConfig *NodeKubeletConfig `json:"desiredNodePoolAutoConfigKubeletConfig,omitempty"`
	// DesiredNodePoolAutoConfigLinuxNodeConfig: The desired Linux node config for
	// all auto-provisioned node pools in autopilot clusters and node
	// auto-provisioning enabled clusters. Currently only `cgroup_mode` can be set
	// here.
	DesiredNodePoolAutoConfigLinuxNodeConfig *LinuxNodeConfig `json:"desiredNodePoolAutoConfigLinuxNodeConfig,omitempty"`
	// DesiredNodePoolAutoConfigNetworkTags: The desired network tags that apply to
	// all auto-provisioned node pools in autopilot clusters and node
	// auto-provisioning enabled clusters.
	DesiredNodePoolAutoConfigNetworkTags *NetworkTags `json:"desiredNodePoolAutoConfigNetworkTags,omitempty"`
	// DesiredNodePoolAutoConfigResourceManagerTags: The desired resource manager
	// tags that apply to all auto-provisioned node pools in autopilot clusters and
	// node auto-provisioning enabled clusters.
	DesiredNodePoolAutoConfigResourceManagerTags *ResourceManagerTags `json:"desiredNodePoolAutoConfigResourceManagerTags,omitempty"`
	// DesiredNodePoolAutoscaling: Autoscaler configuration for the node pool
	// specified in desired_node_pool_id. If there is only one pool in the cluster
	// and desired_node_pool_id is not provided then the change applies to that
	// single node pool.
	DesiredNodePoolAutoscaling *NodePoolAutoscaling `json:"desiredNodePoolAutoscaling,omitempty"`
	// DesiredNodePoolId: The node pool to be upgraded. This field is mandatory if
	// "desired_node_version", "desired_image_family",
	// "desired_node_pool_autoscaling", or "desired_workload_metadata_config" is
	// specified and there is more than one node pool on the cluster.
	DesiredNodePoolId string `json:"desiredNodePoolId,omitempty"`
	// DesiredNodePoolLoggingConfig: The desired node pool logging configuration
	// defaults for the cluster.
	DesiredNodePoolLoggingConfig *NodePoolLoggingConfig `json:"desiredNodePoolLoggingConfig,omitempty"`
	// DesiredNodeVersion: The Kubernetes version to change the nodes to (typically
	// an upgrade). Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior: -
	// "latest": picks the highest valid Kubernetes version - "1.X": picks the
	// highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the
	// highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an
	// explicit Kubernetes version - "-": picks the Kubernetes master version
	DesiredNodeVersion string `json:"desiredNodeVersion,omitempty"`
	// DesiredNotificationConfig: The desired notification configuration.
	DesiredNotificationConfig *NotificationConfig `json:"desiredNotificationConfig,omitempty"`
	// DesiredParentProductConfig: The desired parent product config for the
	// cluster.
	DesiredParentProductConfig *ParentProductConfig `json:"desiredParentProductConfig,omitempty"`
	// DesiredPodAutoscaling: The desired config for pod autoscaling.
	DesiredPodAutoscaling *PodAutoscaling `json:"desiredPodAutoscaling,omitempty"`
	// DesiredPodSecurityPolicyConfig: The desired configuration options for the
	// PodSecurityPolicy feature.
	DesiredPodSecurityPolicyConfig *PodSecurityPolicyConfig `json:"desiredPodSecurityPolicyConfig,omitempty"`
	// DesiredPrivateClusterConfig: The desired private cluster configuration.
	// master_global_access_config is the only field that can be changed via this
	// field. See also ClusterUpdate.desired_enable_private_endpoint for modifying
	// other fields within PrivateClusterConfig. Deprecated: Use
	// desired_control_plane_endpoints_config.ip_endpoints_config.global_access
	// instead.
	DesiredPrivateClusterConfig *PrivateClusterConfig `json:"desiredPrivateClusterConfig,omitempty"`
	// DesiredPrivateIpv6GoogleAccess: The desired state of IPv6 connectivity to
	// Google Services.
	//
	// Possible values:
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED" - Default value. Same as DISABLED
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED" - No private access to or from
	// Google Services
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE" - Enables private IPv6 access to
	// Google Services from GKE
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL" - Enables private IPv6 access
	// to and from Google Services
	DesiredPrivateIpv6GoogleAccess string `json:"desiredPrivateIpv6GoogleAccess,omitempty"`
	// DesiredProtectConfig: Deprecated: Use DesiredSecurityPostureConfig instead.
	// Enable/Disable Protect API features for the cluster.
	DesiredProtectConfig *ProtectConfig `json:"desiredProtectConfig,omitempty"`
	// DesiredRbacBindingConfig: RBACBindingConfig allows user to restrict
	// ClusterRoleBindings an RoleBindings that can be created.
	DesiredRbacBindingConfig *RBACBindingConfig `json:"desiredRbacBindingConfig,omitempty"`
	// DesiredReleaseChannel: The desired release channel configuration.
	DesiredReleaseChannel *ReleaseChannel `json:"desiredReleaseChannel,omitempty"`
	// DesiredResourceUsageExportConfig: The desired configuration for exporting
	// resource usage.
	DesiredResourceUsageExportConfig *ResourceUsageExportConfig `json:"desiredResourceUsageExportConfig,omitempty"`
	// DesiredSecretManagerConfig: Enable/Disable Secret Manager Config.
	DesiredSecretManagerConfig *SecretManagerConfig `json:"desiredSecretManagerConfig,omitempty"`
	// DesiredSecurityPostureConfig: Enable/Disable Security Posture API features
	// for the cluster.
	DesiredSecurityPostureConfig *SecurityPostureConfig `json:"desiredSecurityPostureConfig,omitempty"`
	// DesiredServiceExternalIpsConfig: ServiceExternalIPsConfig specifies the
	// config for the use of Services with ExternalIPs field.
	DesiredServiceExternalIpsConfig *ServiceExternalIPsConfig `json:"desiredServiceExternalIpsConfig,omitempty"`
	// DesiredShieldedNodes: Configuration for Shielded Nodes.
	DesiredShieldedNodes *ShieldedNodes `json:"desiredShieldedNodes,omitempty"`
	// DesiredStackType: The desired stack type of the cluster. If a stack type is
	// provided and does not match the current stack type of the cluster, update
	// will attempt to change the stack type to the new type.
	//
	// Possible values:
	//   "STACK_TYPE_UNSPECIFIED" - By default, the clusters will be IPV4 only
	//   "IPV4" - The value used if the cluster is a IPV4 only
	//   "IPV4_IPV6" - The value used if the cluster is a dual stack cluster
	DesiredStackType string `json:"desiredStackType,omitempty"`
	// DesiredTpuConfig: The desired Cloud TPU configuration. This field is
	// deprecated due to the deprecation of 2VM TPU. The end of life date for 2VM
	// TPU is 2025-04-25.
	DesiredTpuConfig *TpuConfig `json:"desiredTpuConfig,omitempty"`
	// DesiredUserManagedKeysConfig: The desired user managed keys config for the
	// cluster.
	DesiredUserManagedKeysConfig *UserManagedKeysConfig `json:"desiredUserManagedKeysConfig,omitempty"`
	// DesiredVerticalPodAutoscaling: Cluster-level Vertical Pod Autoscaling
	// configuration.
	DesiredVerticalPodAutoscaling *VerticalPodAutoscaling `json:"desiredVerticalPodAutoscaling,omitempty"`
	// DesiredWorkloadAltsConfig: Configuration for direct-path (via ALTS) with
	// workload identity.
	DesiredWorkloadAltsConfig *WorkloadALTSConfig `json:"desiredWorkloadAltsConfig,omitempty"`
	// DesiredWorkloadCertificates: Configuration for issuance of mTLS keys and
	// certificates to Kubernetes pods.
	DesiredWorkloadCertificates *WorkloadCertificates `json:"desiredWorkloadCertificates,omitempty"`
	// DesiredWorkloadIdentityConfig: Configuration for Workload Identity.
	DesiredWorkloadIdentityConfig *WorkloadIdentityConfig `json:"desiredWorkloadIdentityConfig,omitempty"`
	// EnableK8sBetaApis: Kubernetes open source beta apis enabled on the cluster.
	// Only beta apis
	EnableK8sBetaApis *K8sBetaAPIConfig `json:"enableK8sBetaApis,omitempty"`
	// Etag: The current etag of the cluster. If an etag is provided and does not
	// match the current etag of the cluster, update will be blocked and an ABORTED
	// error will be returned.
	Etag string `json:"etag,omitempty"`
	// GkeAutoUpgradeConfig: Configuration for GKE auto upgrade.
	GkeAutoUpgradeConfig *GkeAutoUpgradeConfig `json:"gkeAutoUpgradeConfig,omitempty"`
	// PrivateClusterConfig: The desired private cluster configuration. Has no
	// effect. Use desired_private_cluster_config instead.
	PrivateClusterConfig *PrivateClusterConfig `json:"privateClusterConfig,omitempty"`
	// RemovedAdditionalPodRangesConfig: The additional pod ranges that are to be
	// removed from the cluster. The pod ranges specified here must have been
	// specified earlier in the 'additional_pod_ranges_config' argument.
	RemovedAdditionalPodRangesConfig *AdditionalPodRangesConfig `json:"removedAdditionalPodRangesConfig,omitempty"`
	// UserManagedKeysConfig: The Custom keys configuration for the cluster. This
	// field is deprecated. Use ClusterUpdate.desired_user_managed_keys_config
	// instead.
	UserManagedKeysConfig *UserManagedKeysConfig `json:"userManagedKeysConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalPodRangesConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalPodRangesConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpdate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterUpgradeInfo: ClusterUpgradeInfo contains the upgrade information of a
// cluster.
type ClusterUpgradeInfo struct {
	// AutoUpgradeStatus: The auto upgrade status.
	//
	// Possible values:
	//   "UNKNOWN" - UNKNOWN indicates an unknown status.
	//   "ACTIVE" - ACTIVE indicates an active status.
	//   "MINOR_UPGRADE_PAUSED" - MINOR_UPGRADE_PAUSED indicates the minor version
	// upgrade is paused.
	//   "UPGRADE_PAUSED" - UPGRADE_PAUSED indicates the upgrade is paused.
	AutoUpgradeStatus []string `json:"autoUpgradeStatus,omitempty"`
	// EndOfExtendedSupportTimestamp: The cluster's current minor version's end of
	// extended support timestamp.
	EndOfExtendedSupportTimestamp string `json:"endOfExtendedSupportTimestamp,omitempty"`
	// EndOfStandardSupportTimestamp: The cluster's current minor version's end of
	// standard support timestamp.
	EndOfStandardSupportTimestamp string `json:"endOfStandardSupportTimestamp,omitempty"`
	// MinorTargetVersion: minor_target_version indicates the target version for
	// minor upgrade.
	MinorTargetVersion string `json:"minorTargetVersion,omitempty"`
	// PatchTargetVersion: patch_target_version indicates the target version for
	// patch upgrade.
	PatchTargetVersion string `json:"patchTargetVersion,omitempty"`
	// PausedReason: The auto upgrade paused reason.
	//
	// Possible values:
	//   "AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED" -
	// AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED indicates an unspecified reason.
	//   "MAINTENANCE_WINDOW" - MAINTENANCE_WINDOW indicates the cluster is outside
	// customer maintenance window.
	//   "MAINTENANCE_EXCLUSION_NO_UPGRADES" - MAINTENANCE_EXCLUSION_NO_UPGRADES
	// indicates the cluster is in a maintenance exclusion with scope NO_UPGRADES.
	//   "MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES" -
	// MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES indicates the cluster is in a
	// maintenance exclusion with scope NO_MINOR_UPGRADES.
	//   "CLUSTER_DISRUPTION_BUDGET" - CLUSTER_DISRUPTION_BUDGET indicates the
	// cluster is outside the cluster disruption budget.
	//   "CLUSTER_DISRUPTION_BUDGET_MINOR_UPGRADE" -
	// CLUSTER_DISRUPTION_BUDGET_MINOR_UPGRADE indicates the cluster is outside the
	// cluster disruption budget for minor version upgrade.
	//   "SYSTEM_CONFIG" - SYSTEM_CONFIG indicates the cluster upgrade is paused by
	// system config.
	PausedReason []string `json:"pausedReason,omitempty"`
	// UpgradeDetails: The list of past auto upgrades.
	UpgradeDetails []*UpgradeDetails `json:"upgradeDetails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoUpgradeStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoUpgradeStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterUpgradeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUpgradeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompleteIPRotationRequest: CompleteIPRotationRequest moves the cluster
// master back into single-IP mode.
type CompleteIPRotationRequest struct {
	// ClusterId: Deprecated. The name of the cluster. This field has been
	// deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster name) of the cluster to complete
	// IP rotation. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompleteIPRotationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CompleteIPRotationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompleteNodePoolUpgradeRequest: CompleteNodePoolUpgradeRequest sets the name
// of target node pool to complete upgrade.
type CompleteNodePoolUpgradeRequest struct {
}

// CompliancePostureConfig: CompliancePostureConfig defines the settings needed
// to enable/disable features for the Compliance Posture.
type CompliancePostureConfig struct {
	// ComplianceStandards: List of enabled compliance standards.
	ComplianceStandards []*ComplianceStandard `json:"complianceStandards,omitempty"`
	// Mode: Defines the enablement mode for Compliance Posture.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value not specified.
	//   "DISABLED" - Disables Compliance Posture features on the cluster.
	//   "ENABLED" - Enables Compliance Posture features on the cluster.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComplianceStandards") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComplianceStandards") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompliancePostureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CompliancePostureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComplianceStandard: Defines the details of a compliance standard.
type ComplianceStandard struct {
	// Standard: Name of the compliance standard.
	Standard string `json:"standard,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Standard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Standard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComplianceStandard) MarshalJSON() ([]byte, error) {
	type NoMethod ComplianceStandard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfidentialNodes: ConfidentialNodes is configuration for the confidential
// nodes feature, which makes nodes run on confidential VMs.
type ConfidentialNodes struct {
	// ConfidentialInstanceType: Defines the type of technology used by the
	// confidential node.
	//
	// Possible values:
	//   "CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED" - No type specified. Do not use
	// this value.
	//   "SEV" - AMD Secure Encrypted Virtualization.
	//   "SEV_SNP" - AMD Secure Encrypted Virtualization - Secure Nested Paging.
	//   "TDX" - Intel Trust Domain eXtension.
	ConfidentialInstanceType string `json:"confidentialInstanceType,omitempty"`
	// Enabled: Whether Confidential Nodes feature is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidentialInstanceType")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidentialInstanceType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfidentialNodes) MarshalJSON() ([]byte, error) {
	type NoMethod ConfidentialNodes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigConnectorConfig: Configuration options for the Config Connector
// add-on.
type ConfigConnectorConfig struct {
	// Enabled: Whether Cloud Connector is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigConnectorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigConnectorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsumptionMeteringConfig: Parameters for controlling consumption metering.
type ConsumptionMeteringConfig struct {
	// Enabled: Whether to enable consumption metering for this cluster. If
	// enabled, a second BigQuery table will be created to hold resource
	// consumption records.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsumptionMeteringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConsumptionMeteringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContainerdConfig: ContainerdConfig contains configuration to customize
// containerd.
type ContainerdConfig struct {
	// PrivateRegistryAccessConfig: PrivateRegistryAccessConfig is used to
	// configure access configuration for private container registries.
	PrivateRegistryAccessConfig *PrivateRegistryAccessConfig `json:"privateRegistryAccessConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PrivateRegistryAccessConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrivateRegistryAccessConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContainerdConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerdConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ControlPlaneEndpointsConfig: Configuration for all of the cluster's control
// plane endpoints.
type ControlPlaneEndpointsConfig struct {
	// DnsEndpointConfig: DNS endpoint configuration.
	DnsEndpointConfig *DNSEndpointConfig `json:"dnsEndpointConfig,omitempty"`
	// IpEndpointsConfig: IP endpoints configuration.
	IpEndpointsConfig *IPEndpointsConfig `json:"ipEndpointsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DnsEndpointConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DnsEndpointConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ControlPlaneEndpointsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ControlPlaneEndpointsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CostManagementConfig: Configuration for fine-grained cost management
// feature.
type CostManagementConfig struct {
	// Enabled: Whether the feature is enabled or not.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CostManagementConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CostManagementConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateClusterRequest: CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	// Cluster: Required. A cluster resource
	// (https://{$universe.dns_names.final_documentation_domain}/container-engine/reference/rest/v1beta1/projects.locations.clusters)
	Cluster *Cluster `json:"cluster,omitempty"`
	// Parent: The parent (project and location) where the cluster will be created.
	// Specified in the format `projects/*/locations/*`.
	Parent string `json:"parent,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the parent field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cluster") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateClusterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateNodePoolRequest: CreateNodePoolRequest creates a node pool for a
// cluster.
type CreateNodePoolRequest struct {
	// ClusterId: Deprecated. The name of the cluster. This field has been
	// deprecated and replaced by the parent field.
	ClusterId string `json:"clusterId,omitempty"`
	// NodePool: Required. The node pool to create.
	NodePool *NodePool `json:"nodePool,omitempty"`
	// Parent: The parent (project, location, cluster name) where the node pool
	// will be created. Specified in the format
	// `projects/*/locations/*/clusters/*`.
	Parent string `json:"parent,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the parent field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateNodePoolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateNodePoolRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DNSConfig: DNSConfig contains the desired set of options for configuring
// clusterDNS.
type DNSConfig struct {
	// AdditiveVpcScopeDnsDomain: Optional. The domain used in Additive VPC scope.
	AdditiveVpcScopeDnsDomain string `json:"additiveVpcScopeDnsDomain,omitempty"`
	// ClusterDns: cluster_dns indicates which in-cluster DNS provider should be
	// used.
	//
	// Possible values:
	//   "PROVIDER_UNSPECIFIED" - Default value
	//   "PLATFORM_DEFAULT" - Use GKE default DNS provider(kube-dns) for DNS
	// resolution.
	//   "CLOUD_DNS" - Use CloudDNS for DNS resolution.
	//   "KUBE_DNS" - Use KubeDNS for DNS resolution.
	ClusterDns string `json:"clusterDns,omitempty"`
	// ClusterDnsDomain: cluster_dns_domain is the suffix used for all cluster
	// service records.
	ClusterDnsDomain string `json:"clusterDnsDomain,omitempty"`
	// ClusterDnsScope: cluster_dns_scope indicates the scope of access to cluster
	// DNS records.
	//
	// Possible values:
	//   "DNS_SCOPE_UNSPECIFIED" - Default value, will be inferred as cluster
	// scope.
	//   "CLUSTER_SCOPE" - DNS records are accessible from within the cluster.
	//   "VPC_SCOPE" - DNS records are accessible from within the VPC.
	ClusterDnsScope string `json:"clusterDnsScope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditiveVpcScopeDnsDomain")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditiveVpcScopeDnsDomain") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DNSConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DNSConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DNSEndpointConfig: Describes the configuration of a DNS endpoint.
type DNSEndpointConfig struct {
	// AllowExternalTraffic: Controls whether user traffic is allowed over this
	// endpoint. Note that GCP-managed services may still use the endpoint even if
	// this is false.
	AllowExternalTraffic bool `json:"allowExternalTraffic,omitempty"`
	// Endpoint: Output only. The cluster's DNS endpoint configuration. A DNS
	// format address. This is accessible from the public internet. Ex:
	// uid.us-central1.gke.goog. Always present, but the behavior may change
	// according to the value of DNSEndpointConfig.allow_external_traffic.
	Endpoint string `json:"endpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowExternalTraffic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowExternalTraffic") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DNSEndpointConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DNSEndpointConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DailyMaintenanceWindow: Time window specified for daily maintenance
// operations.
type DailyMaintenanceWindow struct {
	// Duration: Output only. Duration of the time window, automatically chosen to
	// be smallest possible in the given scenario.
	Duration string `json:"duration,omitempty"`
	// StartTime: Time within the maintenance window to start the maintenance
	// operations. It must be in format "HH:MM", where HH : [00-23] and MM :
	// [00-59] GMT.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Duration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyMaintenanceWindow) MarshalJSON() ([]byte, error) {
	type NoMethod DailyMaintenanceWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseEncryption: Configuration of etcd encryption.
type DatabaseEncryption struct {
	// CurrentState: Output only. The current state of etcd encryption.
	//
	// Possible values:
	//   "CURRENT_STATE_UNSPECIFIED" - Should never be set
	//   "CURRENT_STATE_ENCRYPTED" - Secrets in etcd are encrypted.
	//   "CURRENT_STATE_DECRYPTED" - Secrets in etcd are stored in plain text (at
	// etcd level) - this is unrelated to Compute Engine level full disk
	// encryption.
	//   "CURRENT_STATE_ENCRYPTION_PENDING" - Encryption (or re-encryption with a
	// different CloudKMS key) of Secrets is in progress.
	//   "CURRENT_STATE_ENCRYPTION_ERROR" - Encryption (or re-encryption with a
	// different CloudKMS key) of Secrets in etcd encountered an error.
	//   "CURRENT_STATE_DECRYPTION_PENDING" - De-crypting Secrets to plain text in
	// etcd is in progress.
	//   "CURRENT_STATE_DECRYPTION_ERROR" - De-crypting Secrets to plain text in
	// etcd encountered an error.
	CurrentState string `json:"currentState,omitempty"`
	// DecryptionKeys: Output only. Keys in use by the cluster for decrypting
	// existing objects, in addition to the key in `key_name`. Each item is a
	// CloudKMS key resource.
	DecryptionKeys []string `json:"decryptionKeys,omitempty"`
	// KeyName: Name of CloudKMS key to use for the encryption of secrets in etcd.
	// Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
	KeyName string `json:"keyName,omitempty"`
	// LastOperationErrors: Output only. Records errors seen during
	// DatabaseEncryption update operations.
	LastOperationErrors []*OperationError `json:"lastOperationErrors,omitempty"`
	// State: The desired state of etcd encryption.
	//
	// Possible values:
	//   "UNKNOWN" - Should never be set
	//   "ENCRYPTED" - Secrets in etcd are encrypted.
	//   "DECRYPTED" - Secrets in etcd are stored in plain text (at etcd level) -
	// this is unrelated to Compute Engine level full disk encryption.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseEncryption) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseEncryption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultComputeClassConfig: DefaultComputeClassConfig defines default compute
// class configuration.
type DefaultComputeClassConfig struct {
	// Enabled: Enables default compute class.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultComputeClassConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultComputeClassConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultSnatStatus: DefaultSnatStatus contains the desired state of whether
// default sNAT should be disabled on the cluster.
type DefaultSnatStatus struct {
	// Disabled: Disables cluster default sNAT rules.
	Disabled bool `json:"disabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultSnatStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultSnatStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DesiredAdditionalIPRangesConfig: DesiredAdditionalIPRangesConfig is a
// wrapper used for cluster update operation and contains multiple
// AdditionalIPRangesConfigs.
type DesiredAdditionalIPRangesConfig struct {
	// AdditionalIpRangesConfigs: List of additional IP ranges configs where each
	// AdditionalIPRangesConfig corresponds to one subnetwork's IP ranges
	AdditionalIpRangesConfigs []*AdditionalIPRangesConfig `json:"additionalIpRangesConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalIpRangesConfigs")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalIpRangesConfigs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DesiredAdditionalIPRangesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DesiredAdditionalIPRangesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DesiredEnterpriseConfig: DesiredEnterpriseConfig is a wrapper used for
// updating enterprise_config.
type DesiredEnterpriseConfig struct {
	// DesiredTier: desired_tier specifies the desired tier of the cluster.
	//
	// Possible values:
	//   "CLUSTER_TIER_UNSPECIFIED" - CLUSTER_TIER_UNSPECIFIED is when cluster_tier
	// is not set.
	//   "STANDARD" - STANDARD indicates a standard GKE cluster.
	//   "ENTERPRISE" - ENTERPRISE indicates a GKE Enterprise cluster.
	DesiredTier string `json:"desiredTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DesiredTier") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DesiredTier") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DesiredEnterpriseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DesiredEnterpriseConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DnsCacheConfig: Configuration for NodeLocal DNSCache
type DnsCacheConfig struct {
	// Enabled: Whether NodeLocal DNSCache is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DnsCacheConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DnsCacheConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EnterpriseConfig: EnterpriseConfig is the cluster enterprise configuration.
type EnterpriseConfig struct {
	// ClusterTier: Output only. cluster_tier indicates the effective tier of the
	// cluster.
	//
	// Possible values:
	//   "CLUSTER_TIER_UNSPECIFIED" - CLUSTER_TIER_UNSPECIFIED is when cluster_tier
	// is not set.
	//   "STANDARD" - STANDARD indicates a standard GKE cluster.
	//   "ENTERPRISE" - ENTERPRISE indicates a GKE Enterprise cluster.
	ClusterTier string `json:"clusterTier,omitempty"`
	// DesiredTier: desired_tier specifies the desired tier of the cluster.
	//
	// Possible values:
	//   "CLUSTER_TIER_UNSPECIFIED" - CLUSTER_TIER_UNSPECIFIED is when cluster_tier
	// is not set.
	//   "STANDARD" - STANDARD indicates a standard GKE cluster.
	//   "ENTERPRISE" - ENTERPRISE indicates a GKE Enterprise cluster.
	DesiredTier string `json:"desiredTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterTier") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterTier") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnterpriseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EnterpriseConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EphemeralStorageConfig: EphemeralStorageConfig contains configuration for
// the ephemeral storage filesystem.
type EphemeralStorageConfig struct {
	// LocalSsdCount: Number of local SSDs to use to back ephemeral storage. Uses
	// NVMe interfaces. The limit for this value is dependent upon the maximum
	// number of disk available on a machine per zone. See:
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/local-ssd
	// for more information. A zero (or unset) value has different meanings
	// depending on machine type being used: 1. For pre-Gen3 machines, which
	// support flexible numbers of local ssds, zero (or unset) means to disable
	// using local SSDs as ephemeral storage. 2. For Gen3 machines which dictate a
	// specific number of local ssds, zero (or unset) means to use the default
	// number of local ssds that goes with that machine type. For example, for a
	// c3-standard-8-lssd machine, 2 local ssds would be provisioned. For
	// c3-standard-8 (which doesn't support local ssds), 0 will be provisioned. See
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/local-ssd#choose_number_local_ssds
	// for more info.
	LocalSsdCount int64 `json:"localSsdCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocalSsdCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocalSsdCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EphemeralStorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EphemeralStorageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EphemeralStorageLocalSsdConfig: EphemeralStorageLocalSsdConfig contains
// configuration for the node ephemeral storage using Local SSDs.
type EphemeralStorageLocalSsdConfig struct {
	// DataCacheCount: Number of local SSDs to use for GKE Data Cache.
	DataCacheCount int64 `json:"dataCacheCount,omitempty"`
	// LocalSsdCount: Number of local SSDs to use to back ephemeral storage. Uses
	// NVMe interfaces. A zero (or unset) value has different meanings depending on
	// machine type being used: 1. For pre-Gen3 machines, which support flexible
	// numbers of local ssds, zero (or unset) means to disable using local SSDs as
	// ephemeral storage. The limit for this value is dependent upon the maximum
	// number of disk available on a machine per zone. See:
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/local-ssd
	// for more information. 2. For Gen3 machines which dictate a specific number
	// of local ssds, zero (or unset) means to use the default number of local ssds
	// that goes with that machine type. For example, for a c3-standard-8-lssd
	// machine, 2 local ssds would be provisioned. For c3-standard-8 (which doesn't
	// support local ssds), 0 will be provisioned. See
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/local-ssd#choose_number_local_ssds
	// for more info.
	LocalSsdCount int64 `json:"localSsdCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataCacheCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataCacheCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EphemeralStorageLocalSsdConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EphemeralStorageLocalSsdConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvictionGracePeriod: Eviction grace periods are grace periods for each
// eviction signal.
type EvictionGracePeriod struct {
	// ImagefsAvailable: Optional. Grace period for eviction due to imagefs
	// available signal. Sample format: "10s". Must be >= 0. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	ImagefsAvailable string `json:"imagefsAvailable,omitempty"`
	// ImagefsInodesFree: Optional. Grace period for eviction due to imagefs inodes
	// free signal. Sample format: "10s". Must be >= 0. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	ImagefsInodesFree string `json:"imagefsInodesFree,omitempty"`
	// MemoryAvailable: Optional. Grace period for eviction due to memory available
	// signal. Sample format: "10s". Must be >= 0. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	MemoryAvailable string `json:"memoryAvailable,omitempty"`
	// NodefsAvailable: Optional. Grace period for eviction due to nodefs available
	// signal. Sample format: "10s". Must be >= 0. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	NodefsAvailable string `json:"nodefsAvailable,omitempty"`
	// NodefsInodesFree: Optional. Grace period for eviction due to nodefs inodes
	// free signal. Sample format: "10s". Must be >= 0. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	NodefsInodesFree string `json:"nodefsInodesFree,omitempty"`
	// PidAvailable: Optional. Grace period for eviction due to pid available
	// signal. Sample format: "10s". Must be >= 0. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	PidAvailable string `json:"pidAvailable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImagefsAvailable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImagefsAvailable") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvictionGracePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod EvictionGracePeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvictionMinimumReclaim: Eviction minimum reclaims are the resource amounts
// of minimum reclaims for each eviction signal.
type EvictionMinimumReclaim struct {
	// ImagefsAvailable: Optional. Minimum reclaim for eviction due to imagefs
	// available signal. Only take percentage value for now. Sample format: "10%".
	// Must be <=10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	ImagefsAvailable string `json:"imagefsAvailable,omitempty"`
	// ImagefsInodesFree: Optional. Minimum reclaim for eviction due to imagefs
	// inodes free signal. Only take percentage value for now. Sample format:
	// "10%". Must be <=10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	ImagefsInodesFree string `json:"imagefsInodesFree,omitempty"`
	// MemoryAvailable: Optional. Minimum reclaim for eviction due to memory
	// available signal. Only take percentage value for now. Sample format: "10%".
	// Must be <=10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	MemoryAvailable string `json:"memoryAvailable,omitempty"`
	// NodefsAvailable: Optional. Minimum reclaim for eviction due to nodefs
	// available signal. Only take percentage value for now. Sample format: "10%".
	// Must be <=10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	NodefsAvailable string `json:"nodefsAvailable,omitempty"`
	// NodefsInodesFree: Optional. Minimum reclaim for eviction due to nodefs
	// inodes free signal. Only take percentage value for now. Sample format:
	// "10%". Must be <=10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	NodefsInodesFree string `json:"nodefsInodesFree,omitempty"`
	// PidAvailable: Optional. Minimum reclaim for eviction due to pid available
	// signal. Only take percentage value for now. Sample format: "10%". Must be
	// <=10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	PidAvailable string `json:"pidAvailable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImagefsAvailable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImagefsAvailable") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvictionMinimumReclaim) MarshalJSON() ([]byte, error) {
	type NoMethod EvictionMinimumReclaim
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvictionSignals: Eviction signals are the current state of a particular
// resource at a specific point in time. The kubelet uses eviction signals to
// make eviction decisions by comparing the signals to eviction thresholds,
// which are the minimum amount of the resource that should be available on the
// node.
type EvictionSignals struct {
	// ImagefsAvailable: Optional. Amount of storage available on filesystem that
	// container runtime uses for storing images layers. If the container
	// filesystem and image filesystem are not separate, then imagefs can store
	// both image layers and writeable layers. Defines the amount of
	// "imagefs.available" signal in kubelet. Default is unset, if not specified in
	// the kubelet config. Sample format: "30%". Must be >= 15%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	ImagefsAvailable string `json:"imagefsAvailable,omitempty"`
	// ImagefsInodesFree: Optional. Amount of inodes available on filesystem that
	// container runtime uses for storing images layers. Defines the amount of
	// "imagefs.inodesFree" signal in kubelet. Default is unset, if not specified
	// in the kubelet config. Linux only. Sample format: "30%". Must be >= 5%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	ImagefsInodesFree string `json:"imagefsInodesFree,omitempty"`
	// MemoryAvailable: Optional. Memory available (i.e. capacity - workingSet), in
	// bytes. Defines the amount of "memory.available" signal in kubelet. Default
	// is unset, if not specified in the kubelet config. Format: positive number +
	// unit, e.g. 100Ki, 10Mi, 5Gi. Valid units are Ki, Mi, Gi. Must be >= 100Mi
	// and <= 50% of the node's memory. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	MemoryAvailable string `json:"memoryAvailable,omitempty"`
	// NodefsAvailable: Optional. Amount of storage available on filesystem that
	// kubelet uses for volumes, daemon logs, etc. Defines the amount of
	// "nodefs.available" signal in kubelet. Default is unset, if not specified in
	// the kubelet config. Sample format: "30%". Must be >= 10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	NodefsAvailable string `json:"nodefsAvailable,omitempty"`
	// NodefsInodesFree: Optional. Amount of inodes available on filesystem that
	// kubelet uses for volumes, daemon logs, etc. Defines the amount of
	// "nodefs.inodesFree" signal in kubelet. Default is unset, if not specified in
	// the kubelet config. Linux only. It takses percentage value for now. Sample
	// format: "30%". Must be >= 5% and <= 50%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	NodefsInodesFree string `json:"nodefsInodesFree,omitempty"`
	// PidAvailable: Optional. Amount of PID available for pod allocation. Defines
	// the amount of "pid.available" signal in kubelet. Default is unset, if not
	// specified in the kubelet config. Sample format: "30%". Must be >= 10%. See
	// https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
	PidAvailable string `json:"pidAvailable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImagefsAvailable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImagefsAvailable") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvictionSignals) MarshalJSON() ([]byte, error) {
	type NoMethod EvictionSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FastSocket: Configuration of Fast Socket feature.
type FastSocket struct {
	// Enabled: Whether Fast Socket features are enabled in the node pool.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FastSocket) MarshalJSON() ([]byte, error) {
	type NoMethod FastSocket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Filter: Allows filtering to one or more specific event types. If event types
// are present, those and only those event types will be transmitted to the
// cluster. Other types will be skipped. If no filter is specified, or no event
// types are present, all event types will be sent
type Filter struct {
	// EventType: Event types to allowlist.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Not set, will be ignored.
	//   "UPGRADE_AVAILABLE_EVENT" - Corresponds with UpgradeAvailableEvent.
	//   "UPGRADE_EVENT" - Corresponds with UpgradeEvent.
	//   "SECURITY_BULLETIN_EVENT" - Corresponds with SecurityBulletinEvent.
	//   "UPGRADE_INFO_EVENT" - Corresponds with UpgradeInfoEvent.
	EventType []string `json:"eventType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EventType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EventType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Filter) MarshalJSON() ([]byte, error) {
	type NoMethod Filter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Fleet: Fleet is the fleet configuration for the cluster.
type Fleet struct {
	// Membership: Output only. The full resource name of the registered fleet
	// membership of the cluster, in the format
	// `//gkehub.googleapis.com/projects/*/locations/*/memberships/*`.
	Membership string `json:"membership,omitempty"`
	// MembershipType: The type of the cluster's fleet membership.
	//
	// Possible values:
	//   "MEMBERSHIP_TYPE_UNSPECIFIED" - The MembershipType is not set.
	//   "LIGHTWEIGHT" - The membership supports only lightweight compatible
	// features.
	MembershipType string `json:"membershipType,omitempty"`
	// PreRegistered: Output only. Whether the cluster has been registered through
	// the fleet API.
	PreRegistered bool `json:"preRegistered,omitempty"`
	// Project: The Fleet host project(project ID or project number) where this
	// cluster will be registered to. This field cannot be changed after the
	// cluster has been registered.
	Project string `json:"project,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Membership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Fleet) MarshalJSON() ([]byte, error) {
	type NoMethod Fleet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GCPSecretManagerCertificateConfig: GCPSecretManagerCertificateConfig
// configures a secret from Google Secret Manager
// (https://{$universe.dns_names.final_documentation_domain}/secret-manager).
type GCPSecretManagerCertificateConfig struct {
	// SecretUri: Secret URI, in the form
	// "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION". Version can
	// be fixed (e.g. "2") or "latest"
	SecretUri string `json:"secretUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GCPSecretManagerCertificateConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GCPSecretManagerCertificateConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GPUDriverInstallationConfig: GPUDriverInstallationConfig specifies the
// version of GPU driver to be auto installed.
type GPUDriverInstallationConfig struct {
	// GpuDriverVersion: Mode for how the GPU driver is installed.
	//
	// Possible values:
	//   "GPU_DRIVER_VERSION_UNSPECIFIED" - Default value is to not install any GPU
	// driver.
	//   "INSTALLATION_DISABLED" - Disable GPU driver auto installation and needs
	// manual installation
	//   "DEFAULT" - "Default" GPU driver in COS and Ubuntu.
	//   "LATEST" - "Latest" GPU driver in COS.
	GpuDriverVersion string `json:"gpuDriverVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GpuDriverVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GpuDriverVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GPUDriverInstallationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GPUDriverInstallationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GPUSharingConfig: GPUSharingConfig represents the GPU sharing configuration
// for Hardware Accelerators.
type GPUSharingConfig struct {
	// GpuSharingStrategy: The type of GPU sharing strategy to enable on the GPU
	// node.
	//
	// Possible values:
	//   "GPU_SHARING_STRATEGY_UNSPECIFIED" - Default value.
	//   "TIME_SHARING" - GPUs are time-shared between containers.
	//   "MPS" - GPUs are shared between containers with NVIDIA MPS.
	GpuSharingStrategy string `json:"gpuSharingStrategy,omitempty"`
	// MaxSharedClientsPerGpu: The max number of containers that can share a
	// physical GPU.
	MaxSharedClientsPerGpu int64 `json:"maxSharedClientsPerGpu,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "GpuSharingStrategy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GpuSharingStrategy") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GPUSharingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GPUSharingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GatewayAPIConfig: GatewayAPIConfig contains the desired config of Gateway
// API on this cluster.
type GatewayAPIConfig struct {
	// Channel: The Gateway API release channel to use for Gateway API.
	//
	// Possible values:
	//   "CHANNEL_UNSPECIFIED" - Default value.
	//   "CHANNEL_DISABLED" - Gateway API support is disabled
	//   "CHANNEL_EXPERIMENTAL" - Deprecated: use CHANNEL_STANDARD instead. Gateway
	// API support is enabled, experimental CRDs are installed
	//   "CHANNEL_STANDARD" - Gateway API support is enabled, standard CRDs are
	// installed
	Channel string `json:"channel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GatewayAPIConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GatewayAPIConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcePersistentDiskCsiDriverConfig: Configuration for the Compute Engine PD
// CSI driver.
type GcePersistentDiskCsiDriverConfig struct {
	// Enabled: Whether the Compute Engine PD CSI driver is enabled for this
	// cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcePersistentDiskCsiDriverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GcePersistentDiskCsiDriverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcfsConfig: GcfsConfig contains configurations of Google Container File
// System.
type GcfsConfig struct {
	// Enabled: Whether to use GCFS.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcfsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GcfsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcpFilestoreCsiDriverConfig: Configuration for the GCP Filestore CSI driver.
type GcpFilestoreCsiDriverConfig struct {
	// Enabled: Whether the GCP Filestore CSI driver is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcpFilestoreCsiDriverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GcpFilestoreCsiDriverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsFuseCsiDriverConfig: Configuration for the Cloud Storage Fuse CSI driver.
type GcsFuseCsiDriverConfig struct {
	// Enabled: Whether the Cloud Storage Fuse CSI driver is enabled for this
	// cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsFuseCsiDriverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GcsFuseCsiDriverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetJSONWebKeysResponse: GetJSONWebKeysResponse is a valid JSON Web Key Set
// as specified in rfc 7517
type GetJSONWebKeysResponse struct {
	// CacheHeader: For HTTP requests, this field is automatically extracted into
	// the Cache-Control HTTP header.
	CacheHeader *HttpCacheControlResponseHeader `json:"cacheHeader,omitempty"`
	// Keys: The public component of the keys used by the cluster to sign token
	// requests.
	Keys []*Jwk `json:"keys,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CacheHeader") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheHeader") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetJSONWebKeysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetJSONWebKeysResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetOpenIDConfigResponse: GetOpenIDConfigResponse is an OIDC discovery
// document for the cluster. See the OpenID Connect Discovery 1.0 specification
// for details.
type GetOpenIDConfigResponse struct {
	// CacheHeader: For HTTP requests, this field is automatically extracted into
	// the Cache-Control HTTP header.
	CacheHeader *HttpCacheControlResponseHeader `json:"cacheHeader,omitempty"`
	// ClaimsSupported: Supported claims.
	ClaimsSupported []string `json:"claims_supported,omitempty"`
	// GrantTypes: Supported grant types.
	GrantTypes []string `json:"grant_types,omitempty"`
	// IdTokenSigningAlgValuesSupported: supported ID Token signing Algorithms.
	IdTokenSigningAlgValuesSupported []string `json:"id_token_signing_alg_values_supported,omitempty"`
	// Issuer: OIDC Issuer.
	Issuer string `json:"issuer,omitempty"`
	// JwksUri: JSON Web Key uri.
	JwksUri string `json:"jwks_uri,omitempty"`
	// ResponseTypesSupported: Supported response types.
	ResponseTypesSupported []string `json:"response_types_supported,omitempty"`
	// SubjectTypesSupported: Supported subject types.
	SubjectTypesSupported []string `json:"subject_types_supported,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CacheHeader") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheHeader") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetOpenIDConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetOpenIDConfigResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeAutoUpgradeConfig: GkeAutoUpgradeConfig is the configuration for GKE auto
// upgrades.
type GkeAutoUpgradeConfig struct {
	// PatchMode: PatchMode specifies how auto upgrade patch builds should be
	// selected.
	//
	// Possible values:
	//   "PATCH_MODE_UNSPECIFIED" - PATCH_MODE_UNSPECIFIED defaults to using the
	// upgrade target from the channel's patch upgrade targets as the upgrade
	// target for the version.
	//   "ACCELERATED" - ACCELERATED denotes that the latest patch build in the
	// channel should be used as the upgrade target for the version.
	PatchMode string `json:"patchMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PatchMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PatchMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeAutoUpgradeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GkeAutoUpgradeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeBackupAgentConfig: Configuration for the Backup for GKE Agent.
type GkeBackupAgentConfig struct {
	// Enabled: Whether the Backup for GKE agent is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeBackupAgentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GkeBackupAgentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HighScaleCheckpointingConfig: Configuration for the High Scale
// Checkpointing.
type HighScaleCheckpointingConfig struct {
	// Enabled: Whether the High Scale Checkpointing is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HighScaleCheckpointingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod HighScaleCheckpointingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HorizontalPodAutoscaling: Configuration options for the horizontal pod
// autoscaling feature, which increases or decreases the number of replica pods
// a replication controller has based on the resource usage of the existing
// pods.
type HorizontalPodAutoscaling struct {
	// Disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the
	// cluster. When enabled, it ensures that metrics are collected into
	// Stackdriver Monitoring.
	Disabled bool `json:"disabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HorizontalPodAutoscaling) MarshalJSON() ([]byte, error) {
	type NoMethod HorizontalPodAutoscaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HostMaintenancePolicy: HostMaintenancePolicy contains the maintenance policy
// for the hosts on which the GKE VMs run on.
type HostMaintenancePolicy struct {
	// MaintenanceInterval: Specifies the frequency of planned maintenance events.
	//
	// Possible values:
	//   "MAINTENANCE_INTERVAL_UNSPECIFIED" - The maintenance interval is not
	// explicitly specified.
	//   "AS_NEEDED" - Nodes are eligible to receive infrastructure and hypervisor
	// updates as they become available. This may result in more maintenance
	// operations (live migrations or terminations) for the node than the PERIODIC
	// option.
	//   "PERIODIC" - Nodes receive infrastructure and hypervisor updates on a
	// periodic basis, minimizing the number of maintenance operations (live
	// migrations or terminations) on an individual VM. This may mean underlying
	// VMs will take longer to receive an update than if it was configured for
	// AS_NEEDED. Security updates will still be applied as soon as they are
	// available.
	MaintenanceInterval string `json:"maintenanceInterval,omitempty"`
	// OpportunisticMaintenanceStrategy: Strategy that will trigger maintenance on
	// behalf of the customer.
	OpportunisticMaintenanceStrategy *OpportunisticMaintenanceStrategy `json:"opportunisticMaintenanceStrategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaintenanceInterval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaintenanceInterval") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HostMaintenancePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HostMaintenancePolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpCacheControlResponseHeader: RFC-2616: cache control support
type HttpCacheControlResponseHeader struct {
	// Age: 14.6 response cache age, in seconds since the response is generated
	Age int64 `json:"age,omitempty,string"`
	// Directive: 14.9 request and response directives
	Directive string `json:"directive,omitempty"`
	// Expires: 14.21 response cache expires, in RFC 1123 date format
	Expires string `json:"expires,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Age") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Age") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpCacheControlResponseHeader) MarshalJSON() ([]byte, error) {
	type NoMethod HttpCacheControlResponseHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpLoadBalancing: Configuration options for the HTTP (L7) load balancing
// controller addon, which makes it easy to set up HTTP load balancers for
// services in a cluster.
type HttpLoadBalancing struct {
	// Disabled: Whether the HTTP Load Balancing controller is enabled in the
	// cluster. When enabled, it runs a small pod in the cluster that manages the
	// load balancers.
	Disabled bool `json:"disabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpLoadBalancing) MarshalJSON() ([]byte, error) {
	type NoMethod HttpLoadBalancing
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HugepagesConfig: Hugepages amount in both 2m and 1g size
type HugepagesConfig struct {
	// HugepageSize1g: Optional. Amount of 1G hugepages
	HugepageSize1g int64 `json:"hugepageSize1g,omitempty"`
	// HugepageSize2m: Optional. Amount of 2M hugepages
	HugepageSize2m int64 `json:"hugepageSize2m,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HugepageSize1g") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HugepageSize1g") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HugepagesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod HugepagesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ILBSubsettingConfig: ILBSubsettingConfig contains the desired config of L4
// Internal LoadBalancer subsetting on this cluster.
type ILBSubsettingConfig struct {
	// Enabled: Enables l4 ILB subsetting for this cluster
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ILBSubsettingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ILBSubsettingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IPAllocationPolicy: Configuration for controlling how IPs are allocated in
// the cluster.
type IPAllocationPolicy struct {
	// AdditionalIpRangesConfigs: Output only. The additional IP ranges that are
	// added to the cluster. These IP ranges can be used by new node pools to
	// allocate node and pod IPs automatically. Each AdditionalIPRangesConfig
	// corresponds to a single subnetwork. Once a range is removed it will not show
	// up in IPAllocationPolicy.
	AdditionalIpRangesConfigs []*AdditionalIPRangesConfig `json:"additionalIpRangesConfigs,omitempty"`
	// AdditionalPodRangesConfig: Output only. The additional pod ranges that are
	// added to the cluster. These pod ranges can be used by new node pools to
	// allocate pod IPs automatically. Once the range is removed it will not show
	// up in IPAllocationPolicy.
	AdditionalPodRangesConfig *AdditionalPodRangesConfig `json:"additionalPodRangesConfig,omitempty"`
	// AllowRouteOverlap: If true, allow allocation of cluster CIDR ranges that
	// overlap with certain kinds of network routes. By default we do not allow
	// cluster CIDR ranges to intersect with any user declared routes. With
	// allow_route_overlap == true, we allow overlapping with CIDR ranges that are
	// larger than the cluster CIDR range. If this field is set to true, then
	// cluster and services CIDRs must be fully-specified (e.g. `10.96.0.0/14`, but
	// not `/14`), which means: 1) When `use_ip_aliases` is true,
	// `cluster_ipv4_cidr_block` and `services_ipv4_cidr_block` must be
	// fully-specified. 2) When `use_ip_aliases` is false,
	// `cluster.cluster_ipv4_cidr` muse be fully-specified.
	AllowRouteOverlap bool `json:"allowRouteOverlap,omitempty"`
	// AutoIpamConfig: Optional. AutoIpamConfig contains all information related to
	// Auto IPAM
	AutoIpamConfig *AutoIpamConfig `json:"autoIpamConfig,omitempty"`
	// ClusterIpv4Cidr: This field is deprecated, use cluster_ipv4_cidr_block.
	ClusterIpv4Cidr string `json:"clusterIpv4Cidr,omitempty"`
	// ClusterIpv4CidrBlock: The IP address range for the cluster pod IPs. If this
	// field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This
	// field is only applicable when `use_ip_aliases` is true. Set to blank to have
	// a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a
	// range chosen with a specific netmask. Set to a CIDR
	// (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
	// `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`,
	// `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
	ClusterIpv4CidrBlock string `json:"clusterIpv4CidrBlock,omitempty"`
	// ClusterSecondaryRangeName: The name of the secondary range to be used for
	// the cluster CIDR block. The secondary range will be used for pod IP
	// addresses. This must be an existing secondary range associated with the
	// cluster subnetwork. This field is only applicable with use_ip_aliases and
	// create_subnetwork is false.
	ClusterSecondaryRangeName string `json:"clusterSecondaryRangeName,omitempty"`
	// CreateSubnetwork: Whether a new subnetwork will be created automatically for
	// the cluster. This field is only applicable when `use_ip_aliases` is true.
	CreateSubnetwork bool `json:"createSubnetwork,omitempty"`
	// DefaultPodIpv4RangeUtilization: Output only. The utilization of the cluster
	// default IPv4 range for the pod. The ratio is Usage/[Total number of IPs in
	// the secondary range], Usage=numNodes*numZones*podIPsPerNode.
	DefaultPodIpv4RangeUtilization float64 `json:"defaultPodIpv4RangeUtilization,omitempty"`
	// Ipv6AccessType: The ipv6 access type (internal or external) when
	// create_subnetwork is true
	//
	// Possible values:
	//   "IPV6_ACCESS_TYPE_UNSPECIFIED" - Default value, will be defaulted as type
	// external.
	//   "INTERNAL" - Access type internal (all v6 addresses are internal IPs)
	//   "EXTERNAL" - Access type external (all v6 addresses are external IPs)
	Ipv6AccessType string `json:"ipv6AccessType,omitempty"`
	// NodeIpv4Cidr: This field is deprecated, use node_ipv4_cidr_block.
	NodeIpv4Cidr string `json:"nodeIpv4Cidr,omitempty"`
	// NodeIpv4CidrBlock: The IP address range of the instance IPs in this cluster.
	// This is applicable only if `create_subnetwork` is true. Set to blank to have
	// a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a
	// range chosen with a specific netmask. Set to a CIDR
	// (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
	// `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`,
	// `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
	NodeIpv4CidrBlock string `json:"nodeIpv4CidrBlock,omitempty"`
	// PodCidrOverprovisionConfig: [PRIVATE FIELD] Pod CIDR size overprovisioning
	// config for the cluster. Pod CIDR size per node depends on max_pods_per_node.
	// By default, the value of max_pods_per_node is doubled and then rounded off
	// to next power of 2 to get the size of pod CIDR block per node. Example:
	// max_pods_per_node of 30 would result in 64 IPs (/26). This config can
	// disable the doubling of IPs (we still round off to next power of 2) Example:
	// max_pods_per_node of 30 will result in 32 IPs (/27) when overprovisioning is
	// disabled.
	PodCidrOverprovisionConfig *PodCIDROverprovisionConfig `json:"podCidrOverprovisionConfig,omitempty"`
	// ServicesIpv4Cidr: This field is deprecated, use services_ipv4_cidr_block.
	ServicesIpv4Cidr string `json:"servicesIpv4Cidr,omitempty"`
	// ServicesIpv4CidrBlock: The IP address range of the services IPs in this
	// cluster. If blank, a range will be automatically chosen with the default
	// size. This field is only applicable when `use_ip_aliases` is true. Set to
	// blank to have a range chosen with the default size. Set to /netmask (e.g.
	// `/14`) to have a range chosen with a specific netmask. Set to a CIDR
	// (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
	// `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`,
	// `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
	ServicesIpv4CidrBlock string `json:"servicesIpv4CidrBlock,omitempty"`
	// ServicesIpv6CidrBlock: Output only. The services IPv6 CIDR block for the
	// cluster.
	ServicesIpv6CidrBlock string `json:"servicesIpv6CidrBlock,omitempty"`
	// ServicesSecondaryRangeName: The name of the secondary range to be used as
	// for the services CIDR block. The secondary range will be used for service
	// ClusterIPs. This must be an existing secondary range associated with the
	// cluster subnetwork. This field is only applicable with use_ip_aliases and
	// create_subnetwork is false.
	ServicesSecondaryRangeName string `json:"servicesSecondaryRangeName,omitempty"`
	// StackType: IP stack type
	//
	// Possible values:
	//   "STACK_TYPE_UNSPECIFIED" - By default, the clusters will be IPV4 only
	//   "IPV4" - The value used if the cluster is a IPV4 only
	//   "IPV4_IPV6" - The value used if the cluster is a dual stack cluster
	StackType string `json:"stackType,omitempty"`
	// SubnetIpv6CidrBlock: Output only. The subnet's IPv6 CIDR block used by nodes
	// and pods.
	SubnetIpv6CidrBlock string `json:"subnetIpv6CidrBlock,omitempty"`
	// SubnetworkName: A custom subnetwork name to be used if `create_subnetwork`
	// is true. If this field is empty, then an automatic name will be chosen for
	// the new subnetwork.
	SubnetworkName string `json:"subnetworkName,omitempty"`
	// TpuIpv4CidrBlock: The IP address range of the Cloud TPUs in this cluster. If
	// unspecified, a range will be automatically chosen with the default size.
	// This field is only applicable when `use_ip_aliases` is true. If unspecified,
	// the range will use the default size. Set to /netmask (e.g. `/14`) to have a
	// range chosen with a specific netmask. Set to a CIDR
	// (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
	// `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`,
	// `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. This
	// field is deprecated, use cluster.tpu_config.ipv4_cidr_block instead.
	TpuIpv4CidrBlock string `json:"tpuIpv4CidrBlock,omitempty"`
	// UseIpAliases: Whether alias IPs will be used for pod IPs in the cluster.
	// This is used in conjunction with use_routes. It cannot be true if use_routes
	// is true. If both use_ip_aliases and use_routes are false, then the server
	// picks the default IP allocation mode
	UseIpAliases bool `json:"useIpAliases,omitempty"`
	// UseRoutes: Whether routes will be used for pod IPs in the cluster. This is
	// used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases
	// is true. If both use_ip_aliases and use_routes are false, then the server
	// picks the default IP allocation mode
	UseRoutes bool `json:"useRoutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalIpRangesConfigs")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalIpRangesConfigs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IPAllocationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod IPAllocationPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *IPAllocationPolicy) UnmarshalJSON(data []byte) error {
	type NoMethod IPAllocationPolicy
	var s1 struct {
		DefaultPodIpv4RangeUtilization gensupport.JSONFloat64 `json:"defaultPodIpv4RangeUtilization"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DefaultPodIpv4RangeUtilization = float64(s1.DefaultPodIpv4RangeUtilization)
	return nil
}

// IPEndpointsConfig: IP endpoints configuration.
type IPEndpointsConfig struct {
	// AuthorizedNetworksConfig: Configuration of authorized networks. If enabled,
	// restricts access to the control plane based on source IP. It is invalid to
	// specify both Cluster.masterAuthorizedNetworksConfig and this field at the
	// same time.
	AuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `json:"authorizedNetworksConfig,omitempty"`
	// EnablePublicEndpoint: Controls whether the control plane allows access
	// through a public IP. It is invalid to specify both
	// PrivateClusterConfig.enablePrivateEndpoint and this field at the same time.
	EnablePublicEndpoint bool `json:"enablePublicEndpoint,omitempty"`
	// Enabled: Controls whether to allow direct IP access.
	Enabled bool `json:"enabled,omitempty"`
	// GlobalAccess: Controls whether the control plane's private endpoint is
	// accessible from sources in other regions. It is invalid to specify both
	// PrivateClusterMasterGlobalAccessConfig.enabled and this field at the same
	// time.
	GlobalAccess bool `json:"globalAccess,omitempty"`
	// PrivateEndpoint: Output only. The internal IP address of this cluster's
	// control plane. Only populated if enabled.
	PrivateEndpoint string `json:"privateEndpoint,omitempty"`
	// PrivateEndpointSubnetwork: Subnet to provision the master's private endpoint
	// during cluster creation. Specified in projects/*/regions/*/subnetworks/*
	// format. It is invalid to specify both
	// PrivateClusterConfig.privateEndpointSubnetwork and this field at the same
	// time.
	PrivateEndpointSubnetwork string `json:"privateEndpointSubnetwork,omitempty"`
	// PublicEndpoint: Output only. The external IP address of this cluster's
	// control plane. Only populated if enabled.
	PublicEndpoint string `json:"publicEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthorizedNetworksConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizedNetworksConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IPEndpointsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IPEndpointsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityServiceConfig: IdentityServiceConfig is configuration for Identity
// Service which allows customers to use external identity providers with the
// K8S API
type IdentityServiceConfig struct {
	// Enabled: Whether to enable the Identity Service component
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityServiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityServiceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IntraNodeVisibilityConfig: IntraNodeVisibilityConfig contains the desired
// config of the intra-node visibility on this cluster.
type IntraNodeVisibilityConfig struct {
	// Enabled: Enables intra node visibility for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IntraNodeVisibilityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IntraNodeVisibilityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IstioConfig: Configuration options for Istio addon.
type IstioConfig struct {
	// Auth: The specified Istio auth mode, either none, or mutual TLS.
	//
	// Possible values:
	//   "AUTH_NONE" - auth not enabled
	//   "AUTH_MUTUAL_TLS" - auth mutual TLS enabled
	Auth string `json:"auth,omitempty"`
	// Disabled: Whether Istio is enabled for this cluster.
	Disabled bool `json:"disabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Auth") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Auth") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IstioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IstioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Jwk: Jwk is a JSON Web Key as specified in RFC 7517
type Jwk struct {
	// Alg: Algorithm.
	Alg string `json:"alg,omitempty"`
	// Crv: Used for ECDSA keys.
	Crv string `json:"crv,omitempty"`
	// E: Used for RSA keys.
	E string `json:"e,omitempty"`
	// Kid: Key ID.
	Kid string `json:"kid,omitempty"`
	// Kty: Key Type.
	Kty string `json:"kty,omitempty"`
	// N: Used for RSA keys.
	N string `json:"n,omitempty"`
	// Use: Permitted uses for the public keys.
	Use string `json:"use,omitempty"`
	// X: Used for ECDSA keys.
	X string `json:"x,omitempty"`
	// Y: Used for ECDSA keys.
	Y string `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alg") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alg") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Jwk) MarshalJSON() ([]byte, error) {
	type NoMethod Jwk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// K8sBetaAPIConfig: Kubernetes open source beta apis enabled on the cluster.
type K8sBetaAPIConfig struct {
	// EnabledApis: api name, e.g. storage.k8s.io/v1beta1/csistoragecapacities.
	EnabledApis []string `json:"enabledApis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnabledApis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnabledApis") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s K8sBetaAPIConfig) MarshalJSON() ([]byte, error) {
	type NoMethod K8sBetaAPIConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KalmConfig: Configuration options for the KALM addon.
type KalmConfig struct {
	// Enabled: Whether KALM is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KalmConfig) MarshalJSON() ([]byte, error) {
	type NoMethod KalmConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KubernetesDashboard: Configuration for the Kubernetes Dashboard.
type KubernetesDashboard struct {
	// Disabled: Whether the Kubernetes Dashboard is enabled for this cluster.
	Disabled bool `json:"disabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KubernetesDashboard) MarshalJSON() ([]byte, error) {
	type NoMethod KubernetesDashboard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LegacyAbac: Configuration for the legacy Attribute Based Access Control
// authorization mode.
type LegacyAbac struct {
	// Enabled: Whether the ABAC authorizer is enabled for this cluster. When
	// enabled, identities in the system, including service accounts, nodes, and
	// controllers, will have statically granted permissions beyond those provided
	// by the RBAC configuration or IAM.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LegacyAbac) MarshalJSON() ([]byte, error) {
	type NoMethod LegacyAbac
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LinuxNodeConfig: Parameters that can be configured on Linux nodes.
type LinuxNodeConfig struct {
	// CgroupMode: cgroup_mode specifies the cgroup mode to be used on the node.
	//
	// Possible values:
	//   "CGROUP_MODE_UNSPECIFIED" - CGROUP_MODE_UNSPECIFIED is when unspecified
	// cgroup configuration is used. The default for the GKE node OS image will be
	// used.
	//   "CGROUP_MODE_V1" - CGROUP_MODE_V1 specifies to use cgroupv1 for the cgroup
	// configuration on the node image.
	//   "CGROUP_MODE_V2" - CGROUP_MODE_V2 specifies to use cgroupv2 for the cgroup
	// configuration on the node image.
	CgroupMode string `json:"cgroupMode,omitempty"`
	// Hugepages: Optional. Amounts for 2M and 1G hugepages
	Hugepages *HugepagesConfig `json:"hugepages,omitempty"`
	// Sysctls: The Linux kernel parameters to be applied to the nodes and all pods
	// running on the nodes. The following parameters are supported.
	// net.core.busy_poll net.core.busy_read net.core.netdev_max_backlog
	// net.core.rmem_max net.core.rmem_default net.core.wmem_default
	// net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem
	// net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse net.ipv4.tcp_max_orphans
	// net.netfilter.nf_conntrack_max net.netfilter.nf_conntrack_buckets
	// net.netfilter.nf_conntrack_tcp_timeout_close_wait
	// net.netfilter.nf_conntrack_tcp_timeout_time_wait
	// net.netfilter.nf_conntrack_tcp_timeout_established
	// net.netfilter.nf_conntrack_acct kernel.shmmni kernel.shmmax kernel.shmall
	// fs.aio-max-nr fs.file-max fs.inotify.max_user_instances
	// fs.inotify.max_user_watches fs.nr_open vm.dirty_background_ratio
	// vm.dirty_expire_centisecs vm.dirty_ratio vm.dirty_writeback_centisecs
	// vm.max_map_count vm.overcommit_memory vm.overcommit_ratio
	// vm.vfs_cache_pressure vm.swappiness vm.watermark_scale_factor
	// vm.min_free_kbytes
	Sysctls map[string]string `json:"sysctls,omitempty"`
	// TransparentHugepageDefrag: Optional. Defines the transparent hugepage defrag
	// configuration on the node. VM hugepage allocation can be managed by either
	// limiting defragmentation for delayed allocation or skipping it entirely for
	// immediate allocation only. See
	// https://docs.kernel.org/admin-guide/mm/transhuge.html for more details.
	//
	// Possible values:
	//   "TRANSPARENT_HUGEPAGE_DEFRAG_UNSPECIFIED" - Default value. GKE will not
	// modify the kernel configuration.
	//   "TRANSPARENT_HUGEPAGE_DEFRAG_ALWAYS" - It means that an application
	// requesting THP will stall on allocation failure and directly reclaim pages
	// and compact memory in an effort to allocate a THP immediately.
	//   "TRANSPARENT_HUGEPAGE_DEFRAG_DEFER" - It means that an application will
	// wake kswapd in the background to reclaim pages and wake kcompactd to compact
	// memory so that THP is available in the near future. It’s the
	// responsibility of khugepaged to then install the THP pages later.
	//   "TRANSPARENT_HUGEPAGE_DEFRAG_DEFER_WITH_MADVISE" - It means that an
	// application will enter direct reclaim and compaction like always, but only
	// for regions that have used madvise(MADV_HUGEPAGE); all other regions will
	// wake kswapd in the background to reclaim pages and wake kcompactd to compact
	// memory so that THP is available in the near future.
	//   "TRANSPARENT_HUGEPAGE_DEFRAG_MADVISE" - It means that an application will
	// enter direct reclaim like always but only for regions that are have used
	// madvise(MADV_HUGEPAGE). This is the default kernel configuration.
	//   "TRANSPARENT_HUGEPAGE_DEFRAG_NEVER" - It means that an application will
	// never enter direct reclaim or compaction.
	TransparentHugepageDefrag string `json:"transparentHugepageDefrag,omitempty"`
	// TransparentHugepageEnabled: Optional. Transparent hugepage support for
	// anonymous memory can be entirely disabled (mostly for debugging purposes) or
	// only enabled inside MADV_HUGEPAGE regions (to avoid the risk of consuming
	// more memory resources) or enabled system wide. See
	// https://docs.kernel.org/admin-guide/mm/transhuge.html for more details.
	//
	// Possible values:
	//   "TRANSPARENT_HUGEPAGE_ENABLED_UNSPECIFIED" - Default value. GKE will not
	// modify the kernel configuration.
	//   "TRANSPARENT_HUGEPAGE_ENABLED_ALWAYS" - Transparent hugepage support for
	// anonymous memory is enabled system wide.
	//   "TRANSPARENT_HUGEPAGE_ENABLED_MADVISE" - Transparent hugepage support for
	// anonymous memory is enabled inside MADV_HUGEPAGE regions. This is the
	// default kernel configuration.
	//   "TRANSPARENT_HUGEPAGE_ENABLED_NEVER" - Transparent hugepage support for
	// anonymous memory is disabled.
	TransparentHugepageEnabled string `json:"transparentHugepageEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CgroupMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CgroupMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinuxNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LinuxNodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListClustersResponse: ListClustersResponse is the result of
// ListClustersRequest.
type ListClustersResponse struct {
	// Clusters: A list of clusters in the project in the specified zone, or across
	// all ones.
	Clusters []*Cluster `json:"clusters,omitempty"`
	// MissingZones: If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones []string `json:"missingZones,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Clusters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clusters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClustersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: ListLocationsResponse returns the list of all GKE
// locations and their recommendation state.
type ListLocationsResponse struct {
	// Locations: A full list of GKE locations.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: Only return ListLocationsResponse that occur after the
	// page_token. This value should be populated from the
	// ListLocationsResponse.next_page_token if that response token was set (which
	// happens when listing more Locations than fit in a single
	// ListLocationsResponse).
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListNodePoolsResponse: ListNodePoolsResponse is the result of
// ListNodePoolsRequest.
type ListNodePoolsResponse struct {
	// NodePools: A list of node pools for a cluster.
	NodePools []*NodePool `json:"nodePools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NodePools") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodePools") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListNodePoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListNodePoolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: ListOperationsResponse is the result of
// ListOperationsRequest.
type ListOperationsResponse struct {
	// MissingZones: If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones []string `json:"missingZones,omitempty"`
	// Operations: A list of operations in the project in the specified zone.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MissingZones") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MissingZones") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListUsableSubnetworksResponse: ListUsableSubnetworksResponse is the response
// of ListUsableSubnetworksRequest.
type ListUsableSubnetworksResponse struct {
	// NextPageToken: This token allows you to get the next page of results for
	// list requests. If the number of results is larger than `page_size`, use the
	// `next_page_token` as a value for the query parameter `page_token` in the
	// next request. The value will become empty when there are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Subnetworks: A list of usable subnetworks in the specified network project.
	Subnetworks []*UsableSubnetwork `json:"subnetworks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUsableSubnetworksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUsableSubnetworksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalNvmeSsdBlockConfig: LocalNvmeSsdBlockConfig contains configuration for
// using raw-block local NVMe SSDs
type LocalNvmeSsdBlockConfig struct {
	// LocalSsdCount: Number of local NVMe SSDs to use. The limit for this value is
	// dependent upon the maximum number of disk available on a machine per zone.
	// See:
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/local-ssd
	// for more information. A zero (or unset) value has different meanings
	// depending on machine type being used: 1. For pre-Gen3 machines, which
	// support flexible numbers of local ssds, zero (or unset) means to disable
	// using local SSDs as ephemeral storage. 2. For Gen3 machines which dictate a
	// specific number of local ssds, zero (or unset) means to use the default
	// number of local ssds that goes with that machine type. For example, for a
	// c3-standard-8-lssd machine, 2 local ssds would be provisioned. For
	// c3-standard-8 (which doesn't support local ssds), 0 will be provisioned. See
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/local-ssd#choose_number_local_ssds
	// for more info.
	LocalSsdCount int64 `json:"localSsdCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocalSsdCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocalSsdCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalNvmeSsdBlockConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LocalNvmeSsdBlockConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: Location returns the location name, and if the location is
// recommended for GKE cluster scheduling.
type Location struct {
	// Name: Contains the name of the resource requested. Specified in the format
	// `projects/*/locations/*`.
	Name string `json:"name,omitempty"`
	// Recommended: Whether the location is recommended for GKE cluster scheduling.
	Recommended bool `json:"recommended,omitempty"`
	// Type: Contains the type of location this Location is for. Regional or Zonal.
	//
	// Possible values:
	//   "LOCATION_TYPE_UNSPECIFIED" - LOCATION_TYPE_UNSPECIFIED means the location
	// type was not determined.
	//   "ZONE" - A GKE Location where Zonal clusters can be created.
	//   "REGION" - A GKE Location where Regional clusters can be created.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoggingComponentConfig: LoggingComponentConfig is cluster logging component
// configuration.
type LoggingComponentConfig struct {
	// EnableComponents: Select components to collect logs. An empty set would
	// disable all logging.
	//
	// Possible values:
	//   "COMPONENT_UNSPECIFIED" - Default value. This shouldn't be used.
	//   "SYSTEM_COMPONENTS" - system components
	//   "WORKLOADS" - workloads
	//   "APISERVER" - kube-apiserver
	//   "SCHEDULER" - kube-scheduler
	//   "CONTROLLER_MANAGER" - kube-controller-manager
	//   "KCP_SSHD" - kcp-sshd
	//   "KCP_CONNECTION" - kcp connection logs
	//   "KCP_HPA" - horizontal pod autoscaler decision logs
	EnableComponents []string `json:"enableComponents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableComponents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableComponents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoggingComponentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingComponentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoggingConfig: LoggingConfig is cluster logging configuration.
type LoggingConfig struct {
	// ComponentConfig: Logging components configuration
	ComponentConfig *LoggingComponentConfig `json:"componentConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComponentConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComponentConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoggingVariantConfig: LoggingVariantConfig specifies the behaviour of the
// logging component.
type LoggingVariantConfig struct {
	// Variant: Logging variant deployed on nodes.
	//
	// Possible values:
	//   "VARIANT_UNSPECIFIED" - Default value. This shouldn't be used.
	//   "DEFAULT" - default logging variant.
	//   "MAX_THROUGHPUT" - maximum logging throughput variant.
	Variant string `json:"variant,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Variant") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Variant") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoggingVariantConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingVariantConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LustreCsiDriverConfig: Configuration for the Lustre CSI driver.
type LustreCsiDriverConfig struct {
	// EnableLegacyLustrePort: If set to true, the Lustre CSI driver will install
	// Lustre kernel modules using port 6988.
	EnableLegacyLustrePort bool `json:"enableLegacyLustrePort,omitempty"`
	// Enabled: Whether the Lustre CSI driver is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableLegacyLustrePort") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableLegacyLustrePort") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LustreCsiDriverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LustreCsiDriverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceExclusionOptions: Represents the Maintenance exclusion option.
type MaintenanceExclusionOptions struct {
	// Scope: Scope specifies the upgrade scope which upgrades are blocked by the
	// exclusion.
	//
	// Possible values:
	//   "NO_UPGRADES" - NO_UPGRADES excludes all upgrades, including patch
	// upgrades and minor upgrades across control planes and nodes. This is the
	// default exclusion behavior.
	//   "NO_MINOR_UPGRADES" - NO_MINOR_UPGRADES excludes all minor upgrades for
	// the cluster, only patches are allowed.
	//   "NO_MINOR_OR_NODE_UPGRADES" - NO_MINOR_OR_NODE_UPGRADES excludes all minor
	// upgrades for the cluster, and also exclude all node pool upgrades. Only
	// control plane patches are allowed.
	Scope string `json:"scope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Scope") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Scope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceExclusionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceExclusionOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenancePolicy: MaintenancePolicy defines the maintenance policy to be
// used for the cluster.
type MaintenancePolicy struct {
	// ResourceVersion: A hash identifying the version of this policy, so that
	// updates to fields of the policy won't accidentally undo intermediate changes
	// (and so that users of the API unaware of some fields won't accidentally
	// remove other fields). Make a `get()` request to the cluster to get the
	// current resource version and include it with requests to set the policy.
	ResourceVersion string `json:"resourceVersion,omitempty"`
	// Window: Specifies the maintenance window in which maintenance may be
	// performed.
	Window *MaintenanceWindow `json:"window,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenancePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenancePolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceWindow: MaintenanceWindow defines the maintenance window to be
// used for the cluster.
type MaintenanceWindow struct {
	// DailyMaintenanceWindow: DailyMaintenanceWindow specifies a daily maintenance
	// operation window.
	DailyMaintenanceWindow *DailyMaintenanceWindow `json:"dailyMaintenanceWindow,omitempty"`
	// MaintenanceExclusions: Exceptions to maintenance window. Non-emergency
	// maintenance should not occur in these windows.
	MaintenanceExclusions map[string]TimeWindow `json:"maintenanceExclusions,omitempty"`
	// RecurringWindow: RecurringWindow specifies some number of recurring time
	// periods for maintenance to occur. The time windows may be overlapping. If no
	// maintenance windows are set, maintenance can occur at any time.
	RecurringWindow *RecurringTimeWindow `json:"recurringWindow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DailyMaintenanceWindow") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DailyMaintenanceWindow") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceWindow) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ManagedPrometheusConfig: ManagedPrometheusConfig defines the configuration
// for Google Cloud Managed Service for Prometheus.
type ManagedPrometheusConfig struct {
	// AutoMonitoringConfig: GKE Workload Auto-Monitoring Configuration.
	AutoMonitoringConfig *AutoMonitoringConfig `json:"autoMonitoringConfig,omitempty"`
	// Enabled: Enable Managed Collection.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoMonitoringConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoMonitoringConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManagedPrometheusConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedPrometheusConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Master: Master is the configuration for components on master.
type Master struct {
}

// MasterAuth: The authentication information for accessing the master
// endpoint. Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	// ClientCertificate: Output only. Base64-encoded public certificate used by
	// clients to authenticate to the cluster endpoint. Issued only if
	// client_certificate_config is set.
	ClientCertificate string `json:"clientCertificate,omitempty"`
	// ClientCertificateConfig: Configuration for client certificate authentication
	// on the cluster. For clusters before v1.12, if no configuration is specified,
	// a client certificate is issued.
	ClientCertificateConfig *ClientCertificateConfig `json:"clientCertificateConfig,omitempty"`
	// ClientKey: Output only. Base64-encoded private key used by clients to
	// authenticate to the cluster endpoint.
	ClientKey string `json:"clientKey,omitempty"`
	// ClusterCaCertificate: Output only. Base64-encoded public certificate that is
	// the root of trust for the cluster.
	ClusterCaCertificate string `json:"clusterCaCertificate,omitempty"`
	// Password: The password to use for HTTP basic authentication to the master
	// endpoint. Because the master endpoint is open to the Internet, you should
	// create a strong password. If a password is provided for cluster creation,
	// username must be non-empty. Warning: basic authentication is deprecated, and
	// will be removed in GKE control plane versions 1.19 and newer. For a list of
	// recommended authentication methods, see:
	// https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/how-to/api-server-authentication
	Password string `json:"password,omitempty"`
	// Username: The username to use for HTTP basic authentication to the master
	// endpoint. For clusters v1.6.0 and later, basic authentication can be
	// disabled by leaving username unspecified (or setting it to the empty
	// string). Warning: basic authentication is deprecated, and will be removed in
	// GKE control plane versions 1.19 and newer. For a list of recommended
	// authentication methods, see:
	// https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/how-to/api-server-authentication
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientCertificate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MasterAuth) MarshalJSON() ([]byte, error) {
	type NoMethod MasterAuth
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MasterAuthorizedNetworksConfig: Configuration options for the master
// authorized networks feature. Enabled master authorized networks will
// disallow all external traffic to access Kubernetes master through HTTPS
// except traffic from the given CIDR blocks, Google Compute Engine Public IPs
// and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	// CidrBlocks: cidr_blocks define up to 10 external networks that could access
	// Kubernetes master through HTTPS.
	CidrBlocks []*CidrBlock `json:"cidrBlocks,omitempty"`
	// Enabled: Whether or not master authorized networks is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// GcpPublicCidrsAccessEnabled: Whether master is accessible via Google Compute
	// Engine Public IP addresses.
	GcpPublicCidrsAccessEnabled bool `json:"gcpPublicCidrsAccessEnabled,omitempty"`
	// PrivateEndpointEnforcementEnabled: Whether master authorized networks is
	// enforced on private endpoint or not.
	PrivateEndpointEnforcementEnabled bool `json:"privateEndpointEnforcementEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CidrBlocks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CidrBlocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MasterAuthorizedNetworksConfig) MarshalJSON() ([]byte, error) {
	type NoMethod MasterAuthorizedNetworksConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaxPodsConstraint: Constraints applied to pods.
type MaxPodsConstraint struct {
	// MaxPodsPerNode: Constraint enforced on the max num of pods per node.
	MaxPodsPerNode int64 `json:"maxPodsPerNode,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "MaxPodsPerNode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxPodsPerNode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaxPodsConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod MaxPodsConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MemoryManager: The option enables the Kubernetes NUMA-aware Memory Manager
// feature. Detailed description about the feature can be found here
// (https://kubernetes.io/docs/tasks/administer-cluster/memory-manager/).
type MemoryManager struct {
	// Policy: Controls the memory management policy on the Node. See
	// https://kubernetes.io/docs/tasks/administer-cluster/memory-manager/#policies
	// The following values are allowed. * "none" * "static" The default value is
	// 'none' if unspecified.
	Policy string `json:"policy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MemoryManager) MarshalJSON() ([]byte, error) {
	type NoMethod MemoryManager
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MeshCertificates: Configuration for issuance of mTLS keys and certificates
// to Kubernetes pods.
type MeshCertificates struct {
	// EnableCertificates: enable_certificates controls issuance of workload mTLS
	// certificates. If set, the GKE Workload Identity Certificates controller and
	// node agent will be deployed in the cluster, which can then be configured by
	// creating a WorkloadCertificateConfig Custom Resource. Requires Workload
	// Identity (workload_pool must be non-empty).
	EnableCertificates bool `json:"enableCertificates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableCertificates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableCertificates") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MeshCertificates) MarshalJSON() ([]byte, error) {
	type NoMethod MeshCertificates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Metric: Progress metric is (string, int|float|string) pair.
type Metric struct {
	// DoubleValue: For metrics with floating point value.
	DoubleValue float64 `json:"doubleValue,omitempty"`
	// IntValue: For metrics with integer value.
	IntValue int64 `json:"intValue,omitempty,string"`
	// Name: Required. Metric name, e.g., "nodes total", "percent done".
	Name string `json:"name,omitempty"`
	// StringValue: For metrics with custom values (ratios, visual progress, etc.).
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoubleValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoubleValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Metric) MarshalJSON() ([]byte, error) {
	type NoMethod Metric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Metric) UnmarshalJSON(data []byte) error {
	type NoMethod Metric
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// MonitoringComponentConfig: MonitoringComponentConfig is cluster monitoring
// component configuration.
type MonitoringComponentConfig struct {
	// EnableComponents: Select components to collect metrics. An empty set would
	// disable all monitoring.
	//
	// Possible values:
	//   "COMPONENT_UNSPECIFIED" - Default value. This shouldn't be used.
	//   "SYSTEM_COMPONENTS" - system components
	//   "WORKLOADS" - Deprecated: Use Google Cloud Managed Service for Prometheus.
	//   "APISERVER" - kube-apiserver
	//   "SCHEDULER" - kube-scheduler
	//   "CONTROLLER_MANAGER" - kube-controller-manager
	//   "STORAGE" - Storage
	//   "HPA" - Horizontal Pod Autoscaling
	//   "POD" - Pod
	//   "DAEMONSET" - DaemonSet
	//   "DEPLOYMENT" - Deployment
	//   "STATEFULSET" - Statefulset
	//   "CADVISOR" - CADVISOR
	//   "KUBELET" - KUBELET
	//   "DCGM" - NVIDIA Data Center GPU Manager (DCGM)
	//   "JOBSET" - JobSet
	EnableComponents []string `json:"enableComponents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableComponents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableComponents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MonitoringComponentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoringComponentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MonitoringConfig: MonitoringConfig is cluster monitoring configuration.
type MonitoringConfig struct {
	// AdvancedDatapathObservabilityConfig: Configuration of Advanced Datapath
	// Observability features.
	AdvancedDatapathObservabilityConfig *AdvancedDatapathObservabilityConfig `json:"advancedDatapathObservabilityConfig,omitempty"`
	// ComponentConfig: Monitoring components configuration
	ComponentConfig *MonitoringComponentConfig `json:"componentConfig,omitempty"`
	// ManagedPrometheusConfig: Enable Google Cloud Managed Service for Prometheus
	// in the cluster.
	ManagedPrometheusConfig *ManagedPrometheusConfig `json:"managedPrometheusConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AdvancedDatapathObservabilityConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AdvancedDatapathObservabilityConfig") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s MonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkConfig: NetworkConfig reports the relative names of network &
// subnetwork.
type NetworkConfig struct {
	// DatapathProvider: The desired datapath provider for this cluster. By
	// default, uses the IPTables-based kube-proxy implementation.
	//
	// Possible values:
	//   "DATAPATH_PROVIDER_UNSPECIFIED" - Default value.
	//   "LEGACY_DATAPATH" - Use the IPTables implementation based on kube-proxy.
	//   "ADVANCED_DATAPATH" - Use the eBPF based GKE Dataplane V2 with additional
	// features. See the [GKE Dataplane V2
	// documentation](https://{$universe.dns_names.final_documentation_domain}/kuber
	// netes-engine/docs/how-to/dataplane-v2) for more.
	DatapathProvider string `json:"datapathProvider,omitempty"`
	// DefaultEnablePrivateNodes: Controls whether by default nodes have private IP
	// addresses only. It is invalid to specify both
	// PrivateClusterConfig.enablePrivateNodes and this field at the same time. To
	// update the default setting, use
	// ClusterUpdate.desired_default_enable_private_nodes
	DefaultEnablePrivateNodes bool `json:"defaultEnablePrivateNodes,omitempty"`
	// DefaultSnatStatus: Whether the cluster disables default in-node sNAT rules.
	// In-node sNAT rules will be disabled when default_snat_status is disabled.
	// When disabled is set to false, default IP masquerade rules will be applied
	// to the nodes to prevent sNAT on cluster internal traffic.
	DefaultSnatStatus *DefaultSnatStatus `json:"defaultSnatStatus,omitempty"`
	// DisableL4LbFirewallReconciliation: Disable L4 load balancer VPC firewalls to
	// enable firewall policies.
	DisableL4LbFirewallReconciliation bool `json:"disableL4LbFirewallReconciliation,omitempty"`
	// DnsConfig: DNSConfig contains clusterDNS config for this cluster.
	DnsConfig *DNSConfig `json:"dnsConfig,omitempty"`
	// EnableCiliumClusterwideNetworkPolicy: Whether CiliumClusterWideNetworkPolicy
	// is enabled on this cluster.
	EnableCiliumClusterwideNetworkPolicy bool `json:"enableCiliumClusterwideNetworkPolicy,omitempty"`
	// EnableFqdnNetworkPolicy: Whether FQDN Network Policy is enabled on this
	// cluster.
	EnableFqdnNetworkPolicy bool `json:"enableFqdnNetworkPolicy,omitempty"`
	// EnableIntraNodeVisibility: Whether Intra-node visibility is enabled for this
	// cluster. This makes same node pod to pod traffic visible for VPC network.
	EnableIntraNodeVisibility bool `json:"enableIntraNodeVisibility,omitempty"`
	// EnableL4ilbSubsetting: Whether L4ILB Subsetting is enabled for this cluster.
	EnableL4ilbSubsetting bool `json:"enableL4ilbSubsetting,omitempty"`
	// EnableMultiNetworking: Whether multi-networking is enabled for this cluster.
	EnableMultiNetworking bool `json:"enableMultiNetworking,omitempty"`
	// GatewayApiConfig: GatewayAPIConfig contains the desired config of Gateway
	// API on this cluster.
	GatewayApiConfig *GatewayAPIConfig `json:"gatewayApiConfig,omitempty"`
	// InTransitEncryptionConfig: Specify the details of in-transit encryption.
	//
	// Possible values:
	//   "IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED" - Unspecified, will be inferred
	// as default - IN_TRANSIT_ENCRYPTION_UNSPECIFIED.
	//   "IN_TRANSIT_ENCRYPTION_DISABLED" - In-transit encryption is disabled.
	//   "IN_TRANSIT_ENCRYPTION_INTER_NODE_TRANSPARENT" - Data in-transit is
	// encrypted using inter-node transparent encryption.
	InTransitEncryptionConfig string `json:"inTransitEncryptionConfig,omitempty"`
	// Network: Output only. The relative name of the Google Compute Engine network
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/networks-and-firewalls#networks)
	// to which the cluster is connected. Example:
	// projects/my-project/global/networks/my-network
	Network string `json:"network,omitempty"`
	// NetworkPerformanceConfig: Network bandwidth tier configuration.
	NetworkPerformanceConfig *ClusterNetworkPerformanceConfig `json:"networkPerformanceConfig,omitempty"`
	// PrivateIpv6GoogleAccess: The desired state of IPv6 connectivity to Google
	// Services. By default, no private IPv6 access to or from Google Services (all
	// access will be via IPv4)
	//
	// Possible values:
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED" - Default value. Same as DISABLED
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED" - No private access to or from
	// Google Services
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE" - Enables private IPv6 access to
	// Google Services from GKE
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL" - Enables private IPv6 access
	// to and from Google Services
	PrivateIpv6GoogleAccess string `json:"privateIpv6GoogleAccess,omitempty"`
	// ServiceExternalIpsConfig: ServiceExternalIPsConfig specifies if services
	// with externalIPs field are blocked or not.
	ServiceExternalIpsConfig *ServiceExternalIPsConfig `json:"serviceExternalIpsConfig,omitempty"`
	// Subnetwork: Output only. The relative name of the Google Compute Engine
	// subnetwork
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/vpc)
	// to which the cluster is connected. Example:
	// projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatapathProvider") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatapathProvider") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkPerformanceConfig: Configuration of all network bandwidth tiers
type NetworkPerformanceConfig struct {
	// ExternalIpEgressBandwidthTier: Specifies the network bandwidth tier for the
	// NodePool for traffic to external/public IP addresses.
	//
	// Possible values:
	//   "TIER_UNSPECIFIED" - Default value
	//   "TIER_1" - Higher bandwidth, actual values based on VM size.
	ExternalIpEgressBandwidthTier string `json:"externalIpEgressBandwidthTier,omitempty"`
	// TotalEgressBandwidthTier: Specifies the total network bandwidth tier for the
	// NodePool.
	//
	// Possible values:
	//   "TIER_UNSPECIFIED" - Default value
	//   "TIER_1" - Higher bandwidth, actual values based on VM size.
	TotalEgressBandwidthTier string `json:"totalEgressBandwidthTier,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ExternalIpEgressBandwidthTier") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalIpEgressBandwidthTier")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkPerformanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkPerformanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkPolicy: Configuration options for the NetworkPolicy feature.
// https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
type NetworkPolicy struct {
	// Enabled: Whether network policy is enabled on the cluster.
	Enabled bool `json:"enabled,omitempty"`
	// Provider: The selected network policy provider.
	//
	// Possible values:
	//   "PROVIDER_UNSPECIFIED" - Not set
	//   "CALICO" - Tigera (Calico Felix).
	Provider string `json:"provider,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkPolicyConfig: Configuration for NetworkPolicy. This only tracks
// whether the addon is enabled or not on the Master, it does not track whether
// network policy is enabled for the nodes.
type NetworkPolicyConfig struct {
	// Disabled: Whether NetworkPolicy is enabled for this cluster.
	Disabled bool `json:"disabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkPolicyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkPolicyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkTags: Collection of Compute Engine network tags that can be applied
// to a node's underlying VM instance. (See `tags` field in `NodeConfig`
// (/kubernetes-engine/docs/reference/rest/v1/NodeConfig)).
type NetworkTags struct {
	// Tags: List of network tags.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tags") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkTags) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkTags
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeAffinity: Specifies the NodeAffinity key, values, and affinity operator
// according to shared sole tenant node group affinities
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/nodes/sole-tenant-nodes#node_affinity_and_anti-affinity).
type NodeAffinity struct {
	// Key: Key for NodeAffinity.
	Key string `json:"key,omitempty"`
	// Operator: Operator for NodeAffinity.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Invalid or unspecified affinity operator.
	//   "IN" - Affinity operator.
	//   "NOT_IN" - Anti-affinity operator.
	Operator string `json:"operator,omitempty"`
	// Values: Values for NodeAffinity.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeAffinity) MarshalJSON() ([]byte, error) {
	type NoMethod NodeAffinity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeConfig: Parameters that describe the nodes in a cluster. GKE Autopilot
// clusters do not recognize parameters in `NodeConfig`. Use
// AutoprovisioningNodePoolDefaults instead.
type NodeConfig struct {
	// Accelerators: A list of hardware accelerators to be attached to each node.
	// See
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/gpus
	// for more information about support for GPUs.
	Accelerators []*AcceleratorConfig `json:"accelerators,omitempty"`
	// AdvancedMachineFeatures: Advanced features for the Compute Engine VM.
	AdvancedMachineFeatures *AdvancedMachineFeatures `json:"advancedMachineFeatures,omitempty"`
	// BootDisk: Boot disk configuration for the node pool.
	BootDisk *BootDisk `json:"bootDisk,omitempty"`
	// BootDiskKmsKey:  The Customer Managed Encryption Key used to encrypt the
	// boot disk attached to each node in the node pool. This should be of the form
	// projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKey
	// s/[KEY_NAME]. For more information about protecting resources with Cloud KMS
	// Keys please see:
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/customer-managed-encryption
	BootDiskKmsKey string `json:"bootDiskKmsKey,omitempty"`
	// ConfidentialNodes: Confidential nodes config. All the nodes in the node pool
	// will be Confidential VM once enabled.
	ConfidentialNodes *ConfidentialNodes `json:"confidentialNodes,omitempty"`
	// ContainerdConfig: Parameters for containerd customization.
	ContainerdConfig *ContainerdConfig `json:"containerdConfig,omitempty"`
	// DiskSizeGb: Size of the disk attached to each node, specified in GB. The
	// smallest allowed disk size is 10GB. If unspecified, the default disk size is
	// 100GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty"`
	// DiskType: Type of the disk attached to each node (e.g. 'pd-standard',
	// 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is
	// 'pd-standard'
	DiskType string `json:"diskType,omitempty"`
	// EffectiveCgroupMode: Output only. effective_cgroup_mode is the cgroup mode
	// actually used by the node pool. It is determined by the cgroup mode
	// specified in the LinuxNodeConfig or the default cgroup mode based on the
	// cluster creation version.
	//
	// Possible values:
	//   "EFFECTIVE_CGROUP_MODE_UNSPECIFIED" - EFFECTIVE_CGROUP_MODE_UNSPECIFIED
	// means the cgroup configuration for the node pool is unspecified, i.e. the
	// node pool is a Windows node pool.
	//   "EFFECTIVE_CGROUP_MODE_V1" - CGROUP_MODE_V1 means the node pool is
	// configured to use cgroupv1 for the cgroup configuration.
	//   "EFFECTIVE_CGROUP_MODE_V2" - CGROUP_MODE_V2 means the node pool is
	// configured to use cgroupv2 for the cgroup configuration.
	EffectiveCgroupMode string `json:"effectiveCgroupMode,omitempty"`
	// EnableConfidentialStorage: Optional. Reserved for future use.
	EnableConfidentialStorage bool `json:"enableConfidentialStorage,omitempty"`
	// EphemeralStorageConfig: Parameters for the ephemeral storage filesystem. If
	// unspecified, ephemeral storage is backed by the boot disk.
	EphemeralStorageConfig *EphemeralStorageConfig `json:"ephemeralStorageConfig,omitempty"`
	// EphemeralStorageLocalSsdConfig: Parameters for the node ephemeral storage
	// using Local SSDs. If unspecified, ephemeral storage is backed by the boot
	// disk. This field is functionally equivalent to the ephemeral_storage_config
	EphemeralStorageLocalSsdConfig *EphemeralStorageLocalSsdConfig `json:"ephemeralStorageLocalSsdConfig,omitempty"`
	// FastSocket: Enable or disable NCCL fast socket for the node pool.
	FastSocket *FastSocket `json:"fastSocket,omitempty"`
	// FlexStart: Flex Start flag for enabling Flex Start VM.
	FlexStart bool `json:"flexStart,omitempty"`
	// GcfsConfig: GCFS (Google Container File System) configs.
	GcfsConfig *GcfsConfig `json:"gcfsConfig,omitempty"`
	// Gvnic: Enable or disable gvnic on the node pool.
	Gvnic *VirtualNIC `json:"gvnic,omitempty"`
	// HostMaintenancePolicy: HostMaintenancePolicy contains the desired
	// maintenance policy for the Google Compute Engine hosts.
	HostMaintenancePolicy *HostMaintenancePolicy `json:"hostMaintenancePolicy,omitempty"`
	// ImageType: The image type to use for this node. Note that for a given image
	// type, the latest version of it will be used. Please see
	// https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/concepts/node-images
	// for available image types.
	ImageType string `json:"imageType,omitempty"`
	// KubeletConfig: Node kubelet configs.
	KubeletConfig *NodeKubeletConfig `json:"kubeletConfig,omitempty"`
	// Labels: The map of Kubernetes labels (key/value pairs) to be applied to each
	// node. These will added in addition to any default label(s) that Kubernetes
	// may apply to the node. In case of conflict in label keys, the applied set
	// may differ depending on the Kubernetes version -- it's best to assume the
	// behavior is undefined and conflicts should be avoided. For more information,
	// including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	Labels map[string]string `json:"labels,omitempty"`
	// LinuxNodeConfig: Parameters that can be configured on Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `json:"linuxNodeConfig,omitempty"`
	// LocalNvmeSsdBlockConfig: Parameters for using raw-block Local NVMe SSDs.
	LocalNvmeSsdBlockConfig *LocalNvmeSsdBlockConfig `json:"localNvmeSsdBlockConfig,omitempty"`
	// LocalSsdCount: The number of local SSD disks to be attached to the node. The
	// limit for this value is dependent upon the maximum number of disks available
	// on a machine per zone. See:
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/local-ssd
	// for more information.
	LocalSsdCount int64 `json:"localSsdCount,omitempty"`
	// LocalSsdEncryptionMode: Specifies which method should be used for encrypting
	// the Local SSDs attached to the node.
	//
	// Possible values:
	//   "LOCAL_SSD_ENCRYPTION_MODE_UNSPECIFIED" - The given node will be encrypted
	// using keys managed by Google infrastructure and the keys will be deleted
	// when the node is deleted.
	//   "STANDARD_ENCRYPTION" - The given node will be encrypted using keys
	// managed by Google infrastructure and the keys will be deleted when the node
	// is deleted.
	//   "EPHEMERAL_KEY_ENCRYPTION" - The given node will opt-in for using
	// ephemeral key for encryption of Local SSDs. The Local SSDs will not be able
	// to recover data in case of node crash.
	LocalSsdEncryptionMode string `json:"localSsdEncryptionMode,omitempty"`
	// LoggingConfig: Logging configuration.
	LoggingConfig *NodePoolLoggingConfig `json:"loggingConfig,omitempty"`
	// MachineType: The name of a Google Compute Engine machine type
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/machine-types).
	// If unspecified, the default machine type is `e2-medium`.
	MachineType string `json:"machineType,omitempty"`
	// MaxRunDuration: The maximum duration for the nodes to exist. If unspecified,
	// the nodes can exist indefinitely.
	MaxRunDuration string `json:"maxRunDuration,omitempty"`
	// Metadata: The metadata key/value pairs assigned to instances in the cluster.
	// Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the reserved keys: -
	// "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" -
	// "containerd-configure-sh" - "enable-oslogin" - "gci-ensure-gke-docker" -
	// "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" -
	// "kube-env" - "startup-script" - "user-data" - "disable-address-manager" -
	// "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" -
	// "install-ssh-psm1" - "user-profile-psm1" Values are free-form strings, and
	// only have meaning as interpreted by the image running in the instance. The
	// only restriction placed on them is that each value's size must be less than
	// or equal to 32 KB. The total size of all keys and values must be less than
	// 512 KB.
	Metadata map[string]string `json:"metadata,omitempty"`
	// MinCpuPlatform: Minimum CPU platform to be used by this instance. The
	// instance may be scheduled on the specified or newer CPU platform. Applicable
	// values are the friendly names of CPU platforms, such as `minCpuPlatform:
	// "Intel Haswell" or `minCpuPlatform: "Intel Sandy Bridge". For more
	// information, read how to specify min CPU platform
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/instances/specify-min-cpu-platform).
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`
	// NodeGroup: Setting this field will assign instances of this pool to run on
	// the specified node group. This is useful for running workloads on sole
	// tenant nodes
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/nodes/sole-tenant-nodes).
	NodeGroup string `json:"nodeGroup,omitempty"`
	// OauthScopes: The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account. The following scopes are
	// recommended, but not required, and by default are not included: *
	// `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes. *
	// `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io** (the Google Container Registry
	// (https://{$universe.dns_names.final_documentation_domain}/container-registry/)).
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `json:"oauthScopes,omitempty"`
	// Preemptible: Whether the nodes are created as preemptible VM instances. See:
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/instances/preemptible
	// for more information about preemptible VM instances.
	Preemptible bool `json:"preemptible,omitempty"`
	// ReservationAffinity: The optional reservation affinity. Setting this field
	// will apply the specified Zonal Compute Reservation
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/instances/reserving-zonal-resources)
	// to this node pool.
	ReservationAffinity *ReservationAffinity `json:"reservationAffinity,omitempty"`
	// ResourceLabels: The resource labels for the node pool to use to annotate any
	// related Google Compute Engine resources.
	ResourceLabels map[string]string `json:"resourceLabels,omitempty"`
	// ResourceManagerTags: A map of resource manager tag keys and values to be
	// attached to the nodes.
	ResourceManagerTags *ResourceManagerTags `json:"resourceManagerTags,omitempty"`
	// SandboxConfig: Sandbox configuration for this node.
	SandboxConfig *SandboxConfig `json:"sandboxConfig,omitempty"`
	// SecondaryBootDiskUpdateStrategy: Secondary boot disk update strategy.
	SecondaryBootDiskUpdateStrategy *SecondaryBootDiskUpdateStrategy `json:"secondaryBootDiskUpdateStrategy,omitempty"`
	// SecondaryBootDisks: List of secondary boot disks attached to the nodes.
	SecondaryBootDisks []*SecondaryBootDisk `json:"secondaryBootDisks,omitempty"`
	// ServiceAccount: The Google Cloud Platform Service Account to be used by the
	// node VMs. Specify the email address of the Service Account; otherwise, if no
	// Service Account is specified, the "default" service account is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ShieldedInstanceConfig: Shielded Instance options.
	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`
	// SoleTenantConfig: Parameters for node pools to be backed by shared sole
	// tenant node groups.
	SoleTenantConfig *SoleTenantConfig `json:"soleTenantConfig,omitempty"`
	// Spot: Spot flag for enabling Spot VM, which is a rebrand of the existing
	// preemptible flag.
	Spot bool `json:"spot,omitempty"`
	// StoragePools: List of Storage Pools where boot disks are provisioned.
	StoragePools []string `json:"storagePools,omitempty"`
	// Tags: The list of instance tags applied to all nodes. Tags are used to
	// identify valid sources or targets for network firewalls and are specified by
	// the client during cluster or node pool creation. Each tag within the list
	// must comply with RFC1035.
	Tags []string `json:"tags,omitempty"`
	// Taints: List of kubernetes taints to be applied to each node. For more
	// information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Taints []*NodeTaint `json:"taints,omitempty"`
	// WindowsNodeConfig: Parameters that can be configured on Windows nodes.
	WindowsNodeConfig *WindowsNodeConfig `json:"windowsNodeConfig,omitempty"`
	// WorkloadMetadataConfig: The workload metadata configuration for this node.
	WorkloadMetadataConfig *WorkloadMetadataConfig `json:"workloadMetadataConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accelerators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accelerators") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeConfigDefaults: Subset of NodeConfig message that has defaults.
type NodeConfigDefaults struct {
	// ContainerdConfig: Parameters for containerd customization.
	ContainerdConfig *ContainerdConfig `json:"containerdConfig,omitempty"`
	// GcfsConfig: GCFS (Google Container File System, also known as Riptide)
	// options.
	GcfsConfig *GcfsConfig `json:"gcfsConfig,omitempty"`
	// HostMaintenancePolicy: HostMaintenancePolicy contains the desired
	// maintenance policy for the Google Compute Engine hosts.
	HostMaintenancePolicy *HostMaintenancePolicy `json:"hostMaintenancePolicy,omitempty"`
	// LoggingConfig: Logging configuration for node pools.
	LoggingConfig *NodePoolLoggingConfig `json:"loggingConfig,omitempty"`
	// NodeKubeletConfig: NodeKubeletConfig controls the defaults for new
	// node-pools. Currently only `insecure_kubelet_readonly_port_enabled` can be
	// set here.
	NodeKubeletConfig *NodeKubeletConfig `json:"nodeKubeletConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerdConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerdConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeConfigDefaults) MarshalJSON() ([]byte, error) {
	type NoMethod NodeConfigDefaults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeKubeletConfig: Node kubelet configs.
type NodeKubeletConfig struct {
	// AllowedUnsafeSysctls: Optional. Defines a comma-separated allowlist of
	// unsafe sysctls or sysctl patterns (ending in `*`). The unsafe namespaced
	// sysctl groups are `kernel.shm*`, `kernel.msg*`, `kernel.sem`, `fs.mqueue.*`,
	// and `net.*`. Leaving this allowlist empty means they cannot be set on Pods.
	// To allow certain sysctls or sysctl patterns to be set on Pods, list them
	// separated by commas. For example: `kernel.msg*,net.ipv4.route.min_pmtu`. See
	// https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster/ for more
	// details.
	AllowedUnsafeSysctls []string `json:"allowedUnsafeSysctls,omitempty"`
	// ContainerLogMaxFiles: Optional. Defines the maximum number of container log
	// files that can be present for a container. See
	// https://kubernetes.io/docs/concepts/cluster-administration/logging/#log-rotation
	// The value must be an integer between 2 and 10, inclusive. The default value
	// is 5 if unspecified.
	ContainerLogMaxFiles int64 `json:"containerLogMaxFiles,omitempty"`
	// ContainerLogMaxSize: Optional. Defines the maximum size of the container log
	// file before it is rotated. See
	// https://kubernetes.io/docs/concepts/cluster-administration/logging/#log-rotation
	// Valid format is positive number + unit, e.g. 100Ki, 10Mi. Valid units are
	// Ki, Mi, Gi. The value must be between 10Mi and 500Mi, inclusive. Note that
	// the total container log size (container_log_max_size *
	// container_log_max_files) cannot exceed 1% of the total storage of the node,
	// to avoid disk pressure caused by log files. The default value is 10Mi if
	// unspecified.
	ContainerLogMaxSize string `json:"containerLogMaxSize,omitempty"`
	// CpuCfsQuota: Enable CPU CFS quota enforcement for containers that specify
	// CPU limits. This option is enabled by default which makes kubelet use CFS
	// quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
	// enforce container CPU limits. Otherwise, CPU limits will not be enforced at
	// all. Disable this option to mitigate CPU throttling problems while still
	// having your pods to be in Guaranteed QoS class by specifying the CPU limits.
	// The default value is 'true' if unspecified.
	CpuCfsQuota bool `json:"cpuCfsQuota,omitempty"`
	// CpuCfsQuotaPeriod: Set the CPU CFS quota period value 'cpu.cfs_period_us'.
	// The string must be a sequence of decimal numbers, each with optional
	// fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us"
	// (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.
	CpuCfsQuotaPeriod string `json:"cpuCfsQuotaPeriod,omitempty"`
	// CpuManagerPolicy: Control the CPU management policy on the node. See
	// https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
	// The following values are allowed. * "none": the default, which represents
	// the existing scheduling behavior. * "static": allows pods with certain
	// resource characteristics to be granted increased CPU affinity and
	// exclusivity on the node. The default value is 'none' if unspecified.
	CpuManagerPolicy string `json:"cpuManagerPolicy,omitempty"`
	// EvictionMaxPodGracePeriodSeconds: Optional.
	// eviction_max_pod_grace_period_seconds is the maximum allowed grace period
	// (in seconds) to use when terminating pods in response to a soft eviction
	// threshold being met. This value effectively caps the Pod's
	// terminationGracePeriodSeconds value during soft evictions. Default: 0.
	// Range: [0, 300].
	EvictionMaxPodGracePeriodSeconds int64 `json:"evictionMaxPodGracePeriodSeconds,omitempty"`
	// EvictionMinimumReclaim: Optional. eviction_minimum_reclaim is a map of
	// signal names to quantities that defines minimum reclaims, which describe the
	// minimum amount of a given resource the kubelet will reclaim when performing
	// a pod eviction while that resource is under pressure.
	EvictionMinimumReclaim *EvictionMinimumReclaim `json:"evictionMinimumReclaim,omitempty"`
	// EvictionSoft: Optional. eviction_soft is a map of signal names to quantities
	// that defines soft eviction thresholds. Each signal is compared to its
	// corresponding threshold to determine if a pod eviction should occur.
	EvictionSoft *EvictionSignals `json:"evictionSoft,omitempty"`
	// EvictionSoftGracePeriod: Optional. eviction_soft_grace_period is a map of
	// signal names to quantities that defines grace periods for each soft eviction
	// signal. The grace period is the amount of time that a pod must be under
	// pressure before an eviction occurs.
	EvictionSoftGracePeriod *EvictionGracePeriod `json:"evictionSoftGracePeriod,omitempty"`
	// ImageGcHighThresholdPercent: Optional. Defines the percent of disk usage
	// after which image garbage collection is always run. The percent is
	// calculated as this field value out of 100. The value must be between 10 and
	// 85, inclusive and greater than image_gc_low_threshold_percent. The default
	// value is 85 if unspecified.
	ImageGcHighThresholdPercent int64 `json:"imageGcHighThresholdPercent,omitempty"`
	// ImageGcLowThresholdPercent: Optional. Defines the percent of disk usage
	// before which image garbage collection is never run. Lowest disk usage to
	// garbage collect to. The percent is calculated as this field value out of
	// 100. The value must be between 10 and 85, inclusive and smaller than
	// image_gc_high_threshold_percent. The default value is 80 if unspecified.
	ImageGcLowThresholdPercent int64 `json:"imageGcLowThresholdPercent,omitempty"`
	// ImageMaximumGcAge: Optional. Defines the maximum age an image can be unused
	// before it is garbage collected. The string must be a sequence of decimal
	// numbers, each with optional fraction and a unit suffix, such as "300s",
	// "1.5h", and "2h45m". Valid time units are "ns", "us" (or "µs"), "ms", "s",
	// "m", "h". The value must be a positive duration greater than
	// image_minimum_gc_age or "0s". The default value is "0s" if unspecified,
	// which disables this field, meaning images won't be garbage collected based
	// on being unused for too long.
	ImageMaximumGcAge string `json:"imageMaximumGcAge,omitempty"`
	// ImageMinimumGcAge: Optional. Defines the minimum age for an unused image
	// before it is garbage collected. The string must be a sequence of decimal
	// numbers, each with optional fraction and a unit suffix, such as "300s",
	// "1.5h", and "2h45m". Valid time units are "ns", "us" (or "µs"), "ms", "s",
	// "m", "h". The value must be a positive duration less than or equal to 2
	// minutes. The default value is "2m0s" if unspecified.
	ImageMinimumGcAge string `json:"imageMinimumGcAge,omitempty"`
	// InsecureKubeletReadonlyPortEnabled: Enable or disable Kubelet read only
	// port.
	InsecureKubeletReadonlyPortEnabled bool `json:"insecureKubeletReadonlyPortEnabled,omitempty"`
	// MaxParallelImagePulls: Optional. Defines the maximum number of image pulls
	// in parallel. The range is 2 to 5, inclusive. The default value is 2 or 3
	// depending on the disk type. See
	// https://kubernetes.io/docs/concepts/containers/images/#maximum-parallel-image-pulls
	// for more details.
	MaxParallelImagePulls int64 `json:"maxParallelImagePulls,omitempty"`
	// MemoryManager: Optional. Controls NUMA-aware Memory Manager configuration on
	// the node. For more information, see:
	// https://kubernetes.io/docs/tasks/administer-cluster/memory-manager/
	MemoryManager *MemoryManager `json:"memoryManager,omitempty"`
	// PodPidsLimit: Set the Pod PID limits. See
	// https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
	// Controls the maximum number of processes allowed to run in a pod. The value
	// must be greater than or equal to 1024 and less than 4194304.
	PodPidsLimit int64 `json:"podPidsLimit,omitempty,string"`
	// SingleProcessOomKill: Optional. Defines whether to enable single process OOM
	// killer. If true, will prevent the memory.oom.group flag from being set for
	// container cgroups in cgroups v2. This causes processes in the container to
	// be OOM killed individually instead of as a group.
	SingleProcessOomKill bool `json:"singleProcessOomKill,omitempty"`
	// TopologyManager: Optional. Controls Topology Manager configuration on the
	// node. For more information, see:
	// https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/
	TopologyManager *TopologyManager `json:"topologyManager,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedUnsafeSysctls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedUnsafeSysctls") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeKubeletConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NodeKubeletConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeLabels: Collection of node-level Kubernetes labels
// (https://kubernetes.io/docs/concepts/overview/working-with-objects/labels).
type NodeLabels struct {
	// Labels: Map of node label keys and node label values.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeLabels) MarshalJSON() ([]byte, error) {
	type NoMethod NodeLabels
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeManagement: NodeManagement defines the set of node management services
// turned on for the node pool.
type NodeManagement struct {
	// AutoRepair: Whether the nodes will be automatically repaired.
	AutoRepair bool `json:"autoRepair,omitempty"`
	// AutoUpgrade: Whether the nodes will be automatically upgraded.
	AutoUpgrade bool `json:"autoUpgrade,omitempty"`
	// UpgradeOptions: Specifies the Auto Upgrade knobs for the node pool.
	UpgradeOptions *AutoUpgradeOptions `json:"upgradeOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoRepair") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoRepair") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeManagement) MarshalJSON() ([]byte, error) {
	type NoMethod NodeManagement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeNetworkConfig: Parameters for node pool-level network config.
type NodeNetworkConfig struct {
	// AdditionalNodeNetworkConfigs: We specify the additional node networks for
	// this node pool using this list. Each node network corresponds to an
	// additional interface
	AdditionalNodeNetworkConfigs []*AdditionalNodeNetworkConfig `json:"additionalNodeNetworkConfigs,omitempty"`
	// AdditionalPodNetworkConfigs: We specify the additional pod networks for this
	// node pool using this list. Each pod network corresponds to an additional
	// alias IP range for the node
	AdditionalPodNetworkConfigs []*AdditionalPodNetworkConfig `json:"additionalPodNetworkConfigs,omitempty"`
	// CreatePodRange: Input only. Whether to create a new range for pod IPs in
	// this node pool. Defaults are provided for `pod_range` and
	// `pod_ipv4_cidr_block` if they are not specified. If neither
	// `create_pod_range` or `pod_range` are specified, the cluster-level default
	// (`ip_allocation_policy.cluster_ipv4_cidr_block`) is used. Only applicable if
	// `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed
	// after the node pool has been created.
	CreatePodRange bool `json:"createPodRange,omitempty"`
	// EnablePrivateNodes: Whether nodes have internal IP addresses only. If
	// enable_private_nodes is not specified, then the value is derived from
	// Cluster.NetworkConfig.default_enable_private_nodes
	EnablePrivateNodes bool `json:"enablePrivateNodes,omitempty"`
	// NetworkPerformanceConfig: Network bandwidth tier configuration.
	NetworkPerformanceConfig *NetworkPerformanceConfig `json:"networkPerformanceConfig,omitempty"`
	// PodCidrOverprovisionConfig: [PRIVATE FIELD] Pod CIDR size overprovisioning
	// config for the nodepool. Pod CIDR size per node depends on
	// max_pods_per_node. By default, the value of max_pods_per_node is rounded off
	// to next power of 2 and we then double that to get the size of pod CIDR block
	// per node. Example: max_pods_per_node of 30 would result in 64 IPs (/26).
	// This config can disable the doubling of IPs (we still round off to next
	// power of 2) Example: max_pods_per_node of 30 will result in 32 IPs (/27)
	// when overprovisioning is disabled.
	PodCidrOverprovisionConfig *PodCIDROverprovisionConfig `json:"podCidrOverprovisionConfig,omitempty"`
	// PodIpv4CidrBlock: The IP address range for pod IPs in this node pool. Only
	// applicable if `create_pod_range` is true. Set to blank to have a range
	// chosen with the default size. Set to /netmask (e.g. `/14`) to have a range
	// chosen with a specific netmask. Set to a CIDR
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation
	// (e.g. `10.96.0.0/14`) to pick a specific range to use. Only applicable if
	// `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed
	// after the node pool has been created.
	PodIpv4CidrBlock string `json:"podIpv4CidrBlock,omitempty"`
	// PodIpv4RangeUtilization: Output only. The utilization of the IPv4 range for
	// the pod. The ratio is Usage/[Total number of IPs in the secondary range],
	// Usage=numNodes*numZones*podIPsPerNode.
	PodIpv4RangeUtilization float64 `json:"podIpv4RangeUtilization,omitempty"`
	// PodRange: The ID of the secondary range for pod IPs. If `create_pod_range`
	// is true, this ID is used for the new range. If `create_pod_range` is false,
	// uses an existing secondary range with this ID. Only applicable if
	// `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed
	// after the node pool has been created.
	PodRange string `json:"podRange,omitempty"`
	// Subnetwork: Output only. The subnetwork path for the node pool. Format:
	// projects/{project}/regions/{region}/subnetworks/{subnetwork} If the cluster
	// is associated with multiple subnetworks, the subnetwork for the node pool is
	// picked based on the IP utilization during node pool creation and is
	// immutable.
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AdditionalNodeNetworkConfigs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalNodeNetworkConfigs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NodeNetworkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *NodeNetworkConfig) UnmarshalJSON(data []byte) error {
	type NoMethod NodeNetworkConfig
	var s1 struct {
		PodIpv4RangeUtilization gensupport.JSONFloat64 `json:"podIpv4RangeUtilization"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PodIpv4RangeUtilization = float64(s1.PodIpv4RangeUtilization)
	return nil
}

// NodePool: NodePool contains the name and configuration for a cluster's node
// pool. Node pools are a set of nodes (i.e. VM's), with a common configuration
// and specification, under the control of the cluster master. They may have a
// set of Kubernetes labels applied to them, which may be used to reference
// them during pod scheduling. They may also be resized up or down, to
// accommodate the workload.
type NodePool struct {
	// AutopilotConfig: Specifies the autopilot configuration for this node pool.
	// This field is exclusively reserved for Cluster Autoscaler.
	AutopilotConfig *AutopilotConfig `json:"autopilotConfig,omitempty"`
	// Autoscaling: Autoscaler configuration for this NodePool. Autoscaler is
	// enabled only if a valid configuration is present.
	Autoscaling *NodePoolAutoscaling `json:"autoscaling,omitempty"`
	// BestEffortProvisioning: Enable best effort provisioning for nodes
	BestEffortProvisioning *BestEffortProvisioning `json:"bestEffortProvisioning,omitempty"`
	// Conditions: Which conditions caused the current node pool state.
	Conditions []*StatusCondition `json:"conditions,omitempty"`
	// Config: The node configuration of the pool.
	Config *NodeConfig `json:"config,omitempty"`
	// Etag: This checksum is computed by the server based on the value of node
	// pool fields, and may be sent on update requests to ensure the client has an
	// up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// InitialNodeCount: The initial node count for the pool. You must ensure that
	// your Compute Engine resource quota
	// (https://{$universe.dns_names.final_documentation_domain}/compute/quotas) is
	// sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	InitialNodeCount int64 `json:"initialNodeCount,omitempty"`
	// InstanceGroupUrls: Output only. The resource URLs of the managed instance
	// groups
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with this node pool. During the node pool blue-green upgrade
	// operation, the URLs contain both blue and green resources.
	InstanceGroupUrls []string `json:"instanceGroupUrls,omitempty"`
	// Locations: The list of Google Compute Engine zones
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the NodePool's nodes should be located. If this value is
	// unspecified during node pool creation, the Cluster.Locations
	// (https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
	// value will be used, instead. Warning: changing node pool locations will
	// result in nodes being added and/or removed.
	Locations []string `json:"locations,omitempty"`
	// Management: NodeManagement configuration for this NodePool.
	Management *NodeManagement `json:"management,omitempty"`
	// MaxPodsConstraint: The constraint on the maximum number of pods that can be
	// run simultaneously on a node in the node pool.
	MaxPodsConstraint *MaxPodsConstraint `json:"maxPodsConstraint,omitempty"`
	// Name: The name of the node pool.
	Name string `json:"name,omitempty"`
	// NetworkConfig: Networking configuration for this NodePool. If specified, it
	// overrides the cluster-level defaults.
	NetworkConfig *NodeNetworkConfig `json:"networkConfig,omitempty"`
	// PlacementPolicy: Specifies the node placement policy.
	PlacementPolicy *PlacementPolicy `json:"placementPolicy,omitempty"`
	// PodIpv4CidrSize: Output only. The pod CIDR block size per node in this node
	// pool.
	PodIpv4CidrSize int64 `json:"podIpv4CidrSize,omitempty"`
	// QueuedProvisioning: Specifies the configuration of queued provisioning.
	QueuedProvisioning *QueuedProvisioning `json:"queuedProvisioning,omitempty"`
	// SelfLink: Output only. Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`
	// Status: Output only. The status of the nodes in this pool instance.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the node pool is being
	// created.
	//   "RUNNING" - The RUNNING state indicates the node pool has been created and
	// is fully usable.
	//   "RUNNING_WITH_ERROR" - The RUNNING_WITH_ERROR state indicates the node
	// pool has been created and is partially usable. Some error state has occurred
	// and some functionality may be impaired. Customer may need to reissue a
	// request or trigger a new update.
	//   "RECONCILING" - The RECONCILING state indicates that some work is actively
	// being done on the node pool, such as upgrading node software. Details can be
	// found in the `statusMessage` field.
	//   "STOPPING" - The STOPPING state indicates the node pool is being deleted.
	//   "ERROR" - The ERROR state indicates the node pool may be unusable. Details
	// can be found in the `statusMessage` field.
	Status string `json:"status,omitempty"`
	// StatusMessage: Output only. Deprecated. Use conditions instead. Additional
	// information about the current status of this node pool instance, if
	// available.
	StatusMessage string `json:"statusMessage,omitempty"`
	// UpdateInfo: Output only. Update info contains relevant information during a
	// node pool update.
	UpdateInfo *UpdateInfo `json:"updateInfo,omitempty"`
	// UpgradeSettings: Upgrade settings control disruption and speed of the
	// upgrade.
	UpgradeSettings *UpgradeSettings `json:"upgradeSettings,omitempty"`
	// Version: The version of Kubernetes running on this NodePool's nodes. If
	// unspecified, it defaults as described here
	// (https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/versioning#specifying_node_version).
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutopilotConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutopilotConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodePool) MarshalJSON() ([]byte, error) {
	type NoMethod NodePool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodePoolAutoConfig: node pool configs that apply to all auto-provisioned
// node pools in autopilot clusters and node auto-provisioning enabled clusters
type NodePoolAutoConfig struct {
	// LinuxNodeConfig: Output only. Configuration options for Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `json:"linuxNodeConfig,omitempty"`
	// NetworkTags: The list of instance tags applied to all nodes. Tags are used
	// to identify valid sources or targets for network firewalls and are specified
	// by the client during cluster creation. Each tag within the list must comply
	// with RFC1035.
	NetworkTags *NetworkTags `json:"networkTags,omitempty"`
	// NodeKubeletConfig: NodeKubeletConfig controls the defaults for
	// autoprovisioned node-pools. Currently only
	// `insecure_kubelet_readonly_port_enabled` can be set here.
	NodeKubeletConfig *NodeKubeletConfig `json:"nodeKubeletConfig,omitempty"`
	// ResourceManagerTags: Resource manager tag keys and values to be attached to
	// the nodes for managing Compute Engine firewalls using Network Firewall
	// Policies.
	ResourceManagerTags *ResourceManagerTags `json:"resourceManagerTags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LinuxNodeConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LinuxNodeConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodePoolAutoConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NodePoolAutoConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodePoolAutoscaling: NodePoolAutoscaling contains information required by
// cluster autoscaler to adjust the size of the node pool to the current
// cluster usage.
type NodePoolAutoscaling struct {
	// Autoprovisioned: Can this node pool be deleted automatically.
	Autoprovisioned bool `json:"autoprovisioned,omitempty"`
	// Enabled: Is autoscaling enabled for this node pool.
	Enabled bool `json:"enabled,omitempty"`
	// LocationPolicy: Location policy used when scaling up a nodepool.
	//
	// Possible values:
	//   "LOCATION_POLICY_UNSPECIFIED" - Not set.
	//   "BALANCED" - BALANCED is a best effort policy that aims to balance the
	// sizes of different zones.
	//   "ANY" - ANY policy picks zones that have the highest capacity available.
	LocationPolicy string `json:"locationPolicy,omitempty"`
	// MaxNodeCount: Maximum number of nodes for one location in the node pool.
	// Must be >= min_node_count. There has to be enough quota to scale up the
	// cluster.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MinNodeCount: Minimum number of nodes for one location in the node pool.
	// Must be greater than or equal to 0 and less than or equal to max_node_count.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// TotalMaxNodeCount: Maximum number of nodes in the node pool. Must be greater
	// than or equal to total_min_node_count. There has to be enough quota to scale
	// up the cluster. The total_*_node_count fields are mutually exclusive with
	// the *_node_count fields.
	TotalMaxNodeCount int64 `json:"totalMaxNodeCount,omitempty"`
	// TotalMinNodeCount: Minimum number of nodes in the node pool. Must be greater
	// than or equal to 0 and less than or equal to total_max_node_count. The
	// total_*_node_count fields are mutually exclusive with the *_node_count
	// fields.
	TotalMinNodeCount int64 `json:"totalMinNodeCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Autoprovisioned") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Autoprovisioned") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodePoolAutoscaling) MarshalJSON() ([]byte, error) {
	type NoMethod NodePoolAutoscaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodePoolDefaults: Subset of Nodepool message that has defaults.
type NodePoolDefaults struct {
	// NodeConfigDefaults: Subset of NodeConfig message that has defaults.
	NodeConfigDefaults *NodeConfigDefaults `json:"nodeConfigDefaults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NodeConfigDefaults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodeConfigDefaults") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodePoolDefaults) MarshalJSON() ([]byte, error) {
	type NoMethod NodePoolDefaults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodePoolLoggingConfig: NodePoolLoggingConfig specifies logging configuration
// for nodepools.
type NodePoolLoggingConfig struct {
	// VariantConfig: Logging variant configuration.
	VariantConfig *LoggingVariantConfig `json:"variantConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VariantConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VariantConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodePoolLoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NodePoolLoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodePoolUpgradeInfo: NodePoolUpgradeInfo contains the upgrade information of
// a nodepool.
type NodePoolUpgradeInfo struct {
	// AutoUpgradeStatus: The auto upgrade status.
	//
	// Possible values:
	//   "UNKNOWN" - UNKNOWN indicates an unknown status.
	//   "ACTIVE" - ACTIVE indicates an active status.
	//   "MINOR_UPGRADE_PAUSED" - MINOR_UPGRADE_PAUSED indicates the minor version
	// upgrade is paused.
	//   "UPGRADE_PAUSED" - UPGRADE_PAUSED indicates the upgrade is paused.
	AutoUpgradeStatus []string `json:"autoUpgradeStatus,omitempty"`
	// EndOfExtendedSupportTimestamp: The nodepool's current minor version's end of
	// extended support timestamp.
	EndOfExtendedSupportTimestamp string `json:"endOfExtendedSupportTimestamp,omitempty"`
	// EndOfStandardSupportTimestamp: The nodepool's current minor version's end of
	// standard support timestamp.
	EndOfStandardSupportTimestamp string `json:"endOfStandardSupportTimestamp,omitempty"`
	// MinorTargetVersion: minor_target_version indicates the target version for
	// minor upgrade.
	MinorTargetVersion string `json:"minorTargetVersion,omitempty"`
	// PatchTargetVersion: patch_target_version indicates the target version for
	// patch upgrade.
	PatchTargetVersion string `json:"patchTargetVersion,omitempty"`
	// PausedReason: The auto upgrade paused reason.
	//
	// Possible values:
	//   "AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED" -
	// AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED indicates an unspecified reason.
	//   "MAINTENANCE_WINDOW" - MAINTENANCE_WINDOW indicates the cluster is outside
	// customer maintenance window.
	//   "MAINTENANCE_EXCLUSION_NO_UPGRADES" - MAINTENANCE_EXCLUSION_NO_UPGRADES
	// indicates the cluster is in a maintenance exclusion with scope NO_UPGRADES.
	//   "MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES" -
	// MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES indicates the cluster is in a
	// maintenance exclusion with scope NO_MINOR_UPGRADES.
	//   "SYSTEM_CONFIG" - SYSTEM_CONFIG indicates the cluster upgrade is paused by
	// system config.
	PausedReason []string `json:"pausedReason,omitempty"`
	// UpgradeDetails: The list of past auto upgrades.
	UpgradeDetails []*UpgradeDetails `json:"upgradeDetails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoUpgradeStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoUpgradeStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodePoolUpgradeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod NodePoolUpgradeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeTaint: Kubernetes taint is composed of three fields: key, value, and
// effect. Effect can only be one of three types: NoSchedule, PreferNoSchedule
// or NoExecute. See here
// (https://kubernetes.io/docs/concepts/configuration/taint-and-toleration) for
// more information, including usage and the valid values.
type NodeTaint struct {
	// Effect: Effect for taint.
	//
	// Possible values:
	//   "EFFECT_UNSPECIFIED" - Not set
	//   "NO_SCHEDULE" - NoSchedule
	//   "PREFER_NO_SCHEDULE" - PreferNoSchedule
	//   "NO_EXECUTE" - NoExecute
	Effect string `json:"effect,omitempty"`
	// Key: Key for taint.
	Key string `json:"key,omitempty"`
	// Value: Value for taint.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Effect") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Effect") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeTaint) MarshalJSON() ([]byte, error) {
	type NoMethod NodeTaint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeTaints: Collection of Kubernetes node taints
// (https://kubernetes.io/docs/concepts/configuration/taint-and-toleration).
type NodeTaints struct {
	// Taints: List of node taints.
	Taints []*NodeTaint `json:"taints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Taints") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Taints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeTaints) MarshalJSON() ([]byte, error) {
	type NoMethod NodeTaints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NotificationConfig: NotificationConfig is the configuration of
// notifications.
type NotificationConfig struct {
	// Pubsub: Notification config for Pub/Sub.
	Pubsub *PubSub `json:"pubsub,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Pubsub") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pubsub") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This operation resource represents operations that may have
// happened or are happening on the cluster. All fields are output only.
type Operation struct {
	// ClusterConditions: Which conditions caused the current cluster state.
	// Deprecated. Use field error instead.
	ClusterConditions []*StatusCondition `json:"clusterConditions,omitempty"`
	// Detail: Output only. Detailed operation progress, if available.
	Detail string `json:"detail,omitempty"`
	// EndTime: Output only. The time the operation completed, in RFC3339
	// (https://www.ietf.org/rfc/rfc3339.txt) text format.
	EndTime string `json:"endTime,omitempty"`
	// Error: The error result of the operation in case of failure.
	Error *Status `json:"error,omitempty"`
	// Location: Output only. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/regions-zones/regions-zones#available)
	// or region
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/regions-zones/regions-zones#available)
	// in which the cluster resides.
	Location string `json:"location,omitempty"`
	// Name: Output only. The server-assigned ID for the operation.
	Name string `json:"name,omitempty"`
	// NodepoolConditions: Which conditions caused the current node pool state.
	// Deprecated. Use field error instead.
	NodepoolConditions []*StatusCondition `json:"nodepoolConditions,omitempty"`
	// OperationType: Output only. The operation type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not set.
	//   "CREATE_CLUSTER" - The cluster is being created. The cluster should be
	// assumed to be unusable until the operation finishes. In the event of the
	// operation failing, the cluster will enter the ERROR state and eventually be
	// deleted.
	//   "DELETE_CLUSTER" - The cluster is being deleted. The cluster should be
	// assumed to be unusable as soon as this operation starts. In the event of the
	// operation failing, the cluster will enter the ERROR state and the deletion
	// will be automatically retried until completed.
	//   "UPGRADE_MASTER" - The cluster version is being updated. Note that this
	// includes "upgrades" to the same version, which are simply a recreation. This
	// also includes
	// [auto-upgrades](https://{$universe.dns_names.final_documentation_domain}/kube
	// rnetes-engine/docs/concepts/cluster-upgrades#upgrading_automatically). For
	// more details, see [documentation on cluster
	// upgrades](https://{$universe.dns_names.final_documentation_domain}/kubernetes
	// -engine/docs/concepts/cluster-upgrades#cluster_upgrades).
	//   "UPGRADE_NODES" - A node pool is being updated. Despite calling this an
	// "upgrade", this includes most forms of updates to node pools. This also
	// includes
	// [auto-upgrades](https://{$universe.dns_names.final_documentation_domain}/kube
	// rnetes-engine/docs/how-to/node-auto-upgrades). This operation sets the
	// progress field and may be canceled. The upgrade strategy depends on [node
	// pool
	// configuration](https://{$universe.dns_names.final_documentation_domain}/kuber
	// netes-engine/docs/concepts/node-pool-upgrade-strategies). The nodes are
	// generally still usable during this operation.
	//   "REPAIR_CLUSTER" - A problem has been detected with the control plane and
	// is being repaired. This operation type is initiated by GKE. For more
	// details, see [documentation on
	// repairs](https://{$universe.dns_names.final_documentation_domain}/kubernetes-
	// engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
	//   "UPDATE_CLUSTER" - The cluster is being updated. This is a broad category
	// of operations and includes operations that only change metadata as well as
	// those that must recreate the entire cluster. If the control plane must be
	// recreated, this will cause temporary downtime for zonal clusters. Some
	// features require recreating the nodes as well. Those will be recreated as
	// separate operations and the update may not be completely functional until
	// the node pools recreations finish. Node recreations will generally follow
	// [maintenance
	// policies](https://{$universe.dns_names.final_documentation_domain}/kubernetes
	// -engine/docs/concepts/maintenance-windows-and-exclusions). Some
	// GKE-initiated operations use this type. This includes certain types of
	// auto-upgrades and incident mitigations.
	//   "CREATE_NODE_POOL" - A node pool is being created. The node pool should be
	// assumed to be unusable until this operation finishes. In the event of an
	// error, the node pool may be partially created. If enabled, [node
	// autoprovisioning](https://{$universe.dns_names.final_documentation_domain}/ku
	// bernetes-engine/docs/how-to/node-auto-provisioning) may have automatically
	// initiated such operations.
	//   "DELETE_NODE_POOL" - The node pool is being deleted. The node pool should
	// be assumed to be unusable as soon as this operation starts.
	//   "SET_NODE_POOL_MANAGEMENT" - The node pool's manamagent field is being
	// updated. These operations only update metadata and may be concurrent with
	// most other operations.
	//   "AUTO_REPAIR_NODES" - A problem has been detected with nodes and [they are
	// being
	// repaired](https://{$universe.dns_names.final_documentation_domain}/kubernetes
	// -engine/docs/how-to/node-auto-repair). This operation type is initiated by
	// GKE, typically automatically. This operation may be concurrent with other
	// operations and there may be multiple repairs occurring on the same node
	// pool.
	//   "AUTO_UPGRADE_NODES" - Unused. Automatic node upgrade uses UPGRADE_NODES.
	//   "SET_LABELS" - Unused. Updating labels uses UPDATE_CLUSTER.
	//   "SET_MASTER_AUTH" - Unused. Updating master auth uses UPDATE_CLUSTER.
	//   "SET_NODE_POOL_SIZE" - The node pool is being resized. With the exception
	// of resizing to or from size zero, the node pool is generally usable during
	// this operation.
	//   "SET_NETWORK_POLICY" - Unused. Updating network policy uses
	// UPDATE_CLUSTER.
	//   "SET_MAINTENANCE_POLICY" - Unused. Updating maintenance policy uses
	// UPDATE_CLUSTER.
	//   "RESIZE_CLUSTER" - The control plane is being resized. This operation type
	// is initiated by GKE. These operations are often performed preemptively to
	// ensure that the control plane has sufficient resources and is not typically
	// an indication of issues. For more details, see [documentation on
	// resizes](https://{$universe.dns_names.final_documentation_domain}/kubernetes-
	// engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
	//   "FLEET_FEATURE_UPGRADE" - Fleet features of GKE Enterprise are being
	// upgraded. The cluster should be assumed to be blocked for other upgrades
	// until the operation finishes.
	OperationType string `json:"operationType,omitempty"`
	// Progress: Output only. Progress information for an operation.
	Progress *OperationProgress `json:"progress,omitempty"`
	// SelfLink: Output only. Server-defined URI for the operation. Example:
	// `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1
	// /operations/operation-123`.
	SelfLink string `json:"selfLink,omitempty"`
	// StartTime: Output only. The time the operation started, in RFC3339
	// (https://www.ietf.org/rfc/rfc3339.txt) text format.
	StartTime string `json:"startTime,omitempty"`
	// Status: Output only. The current status of the operation.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Not set.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	//   "ABORTING" - The operation is aborting.
	Status string `json:"status,omitempty"`
	// StatusMessage: Output only. If an error has occurred, a textual description
	// of the error. Deprecated. Use field error instead.
	StatusMessage string `json:"statusMessage,omitempty"`
	// TargetLink: Output only. Server-defined URI for the target of the operation.
	// The format of this is a URI to the resource being modified (such as a
	// cluster, node pool, or node). For node pool repairs, there may be multiple
	// nodes being repaired, but only one will be the target. Examples: - ##
	// `https://container.googleapis.com/v1/projects/123/locations/us-central1/clust
	// ers/my-cluster` ##
	// `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/cluster
	// s/my-cluster/nodePools/my-np`
	// `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/cluster
	// s/my-cluster/nodePools/my-np/node/my-node`
	TargetLink string `json:"targetLink,omitempty"`
	// Zone: Output only. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the operation is taking place. This field is deprecated, use
	// location instead.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClusterConditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterConditions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationError: OperationError records errors seen from CloudKMS keys
// encountered during updates to DatabaseEncryption configuration.
type OperationError struct {
	// ErrorMessage: Description of the error seen during the operation.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// KeyName: CloudKMS key resource that had the error.
	KeyName string `json:"keyName,omitempty"`
	// Timestamp: Time when the CloudKMS error was seen.
	Timestamp string `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationError) MarshalJSON() ([]byte, error) {
	type NoMethod OperationError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationProgress: Information about operation (or operation stage)
// progress.
type OperationProgress struct {
	// Metrics: Progress metric bundle, for example: metrics: [{name: "nodes done",
	// int_value: 15}, {name: "nodes total", int_value: 32}] or metrics: [{name:
	// "progress", double_value: 0.56}, {name: "progress scale", double_value:
	// 1.0}]
	Metrics []*Metric `json:"metrics,omitempty"`
	// Name: A non-parameterized string describing an operation stage. Unset for
	// single-stage operations.
	Name string `json:"name,omitempty"`
	// Stages: Substages of an operation or a stage.
	Stages []*OperationProgress `json:"stages,omitempty"`
	// Status: Status of an operation stage. Unset for single-stage operations.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Not set.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	//   "ABORTING" - The operation is aborting.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationProgress) MarshalJSON() ([]byte, error) {
	type NoMethod OperationProgress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OpportunisticMaintenanceStrategy: Strategy that will trigger maintenance on
// behalf of the customer.
type OpportunisticMaintenanceStrategy struct {
	// MaintenanceAvailabilityWindow: The window of time that opportunistic
	// maintenance can run. Example: A setting of 14 days implies that
	// opportunistic maintenance can only be ran in the 2 weeks leading up to the
	// scheduled maintenance date. Setting 28 days allows opportunistic maintenance
	// to run at any time in the scheduled maintenance window (all `PERIODIC`
	// maintenance is set 28 days in advance).
	MaintenanceAvailabilityWindow string `json:"maintenanceAvailabilityWindow,omitempty"`
	// MinNodesPerPool: The minimum nodes required to be available in a pool.
	// Blocks maintenance if it would cause the number of running nodes to dip
	// below this value.
	MinNodesPerPool int64 `json:"minNodesPerPool,omitempty,string"`
	// NodeIdleTimeWindow: The amount of time that a node can remain idle (no
	// customer owned workloads running), before triggering maintenance.
	NodeIdleTimeWindow string `json:"nodeIdleTimeWindow,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "MaintenanceAvailabilityWindow") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaintenanceAvailabilityWindow")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OpportunisticMaintenanceStrategy) MarshalJSON() ([]byte, error) {
	type NoMethod OpportunisticMaintenanceStrategy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParallelstoreCsiDriverConfig: Configuration for the Cloud Storage
// Parallelstore CSI driver.
type ParallelstoreCsiDriverConfig struct {
	// Enabled: Whether the Cloud Storage Parallelstore CSI driver is enabled for
	// this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParallelstoreCsiDriverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ParallelstoreCsiDriverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParentProductConfig: ParentProductConfig is the configuration of the parent
// product of the cluster. This field is used by Google internal products that
// are built on top of a GKE cluster and take the ownership of the cluster.
type ParentProductConfig struct {
	// Labels: Labels contain the configuration of the parent product.
	Labels map[string]string `json:"labels,omitempty"`
	// ProductName: Name of the parent product associated with the cluster.
	ProductName string `json:"productName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParentProductConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ParentProductConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PlacementPolicy: PlacementPolicy defines the placement policy used by the
// node pool.
type PlacementPolicy struct {
	// PolicyName: If set, refers to the name of a custom resource policy supplied
	// by the user. The resource policy must be in the same project and region as
	// the node pool. If not found, InvalidArgument error is returned.
	PolicyName string `json:"policyName,omitempty"`
	// TpuTopology: TPU placement topology for pod slice node pool.
	// https://{$universe.dns_names.final_documentation_domain}/tpu/docs/types-topologies#tpu_topologies
	TpuTopology string `json:"tpuTopology,omitempty"`
	// Type: The type of placement.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - TYPE_UNSPECIFIED specifies no requirements on nodes
	// placement.
	//   "COMPACT" - COMPACT specifies node placement in the same availability
	// domain to ensure low communication latency.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PlacementPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod PlacementPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PodAutoscaling: PodAutoscaling is used for configuration of parameters for
// workload autoscaling.
type PodAutoscaling struct {
	// HpaProfile: Selected Horizontal Pod Autoscaling profile.
	//
	// Possible values:
	//   "HPA_PROFILE_UNSPECIFIED" - HPA_PROFILE_UNSPECIFIED is used when no custom
	// HPA profile is set.
	//   "NONE" - Customers explicitly opt-out of HPA profiles.
	//   "PERFORMANCE" - PERFORMANCE is used when customers opt-in to the
	// performance HPA profile. In this profile we support a higher number of HPAs
	// per cluster and faster metrics collection for workload autoscaling.
	HpaProfile string `json:"hpaProfile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HpaProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HpaProfile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PodAutoscaling) MarshalJSON() ([]byte, error) {
	type NoMethod PodAutoscaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PodCIDROverprovisionConfig: [PRIVATE FIELD] Config for pod CIDR size
// overprovisioning.
type PodCIDROverprovisionConfig struct {
	// Disable: Whether Pod CIDR overprovisioning is disabled. Note: Pod CIDR
	// overprovisioning is enabled by default.
	Disable bool `json:"disable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PodCIDROverprovisionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PodCIDROverprovisionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PodSecurityPolicyConfig: Configuration for the PodSecurityPolicy feature.
type PodSecurityPolicyConfig struct {
	// Enabled: Enable the PodSecurityPolicy controller for this cluster. If
	// enabled, pods must be valid under a PodSecurityPolicy to be created.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PodSecurityPolicyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PodSecurityPolicyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyBinding: Binauthz policy that applies to this cluster.
type PolicyBinding struct {
	// Name: The relative resource name of the binauthz platform policy to
	// evaluate. GKE platform policies have the following format:
	// `projects/{project_number}/platforms/gke/policies/{policy_id}`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyBinding) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrivateClusterConfig: Configuration options for private clusters.
type PrivateClusterConfig struct {
	// EnablePrivateEndpoint: Whether the master's internal IP address is used as
	// the cluster endpoint. Use
	// ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_public_endpoint
	// instead. Note that the value of enable_public_endpoint is reversed: if
	// enable_private_endpoint is false, then enable_public_endpoint will be true.
	EnablePrivateEndpoint bool `json:"enablePrivateEndpoint,omitempty"`
	// EnablePrivateNodes: Whether nodes have internal IP addresses only. If
	// enabled, all nodes are given only RFC 1918 private addresses and communicate
	// with the master via private networking. Deprecated: Use
	// NetworkConfig.default_enable_private_nodes instead.
	EnablePrivateNodes bool `json:"enablePrivateNodes,omitempty"`
	// MasterGlobalAccessConfig: Controls master global access settings.
	// Deprecated: Use
	// ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_global_access instead.
	MasterGlobalAccessConfig *PrivateClusterMasterGlobalAccessConfig `json:"masterGlobalAccessConfig,omitempty"`
	// MasterIpv4CidrBlock: The IP range in CIDR notation to use for the hosted
	// master network. This range will be used for assigning internal IP addresses
	// to the master or set of masters, as well as the ILB VIP. This range must not
	// overlap with any other ranges in use within the cluster's network.
	MasterIpv4CidrBlock string `json:"masterIpv4CidrBlock,omitempty"`
	// PeeringName: Output only. The peering name in the customer VPC used by this
	// cluster.
	PeeringName string `json:"peeringName,omitempty"`
	// PrivateEndpoint: Output only. The internal IP address of this cluster's
	// master endpoint. Deprecated: Use
	// ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint instead.
	PrivateEndpoint string `json:"privateEndpoint,omitempty"`
	// PrivateEndpointSubnetwork: Subnet to provision the master's private endpoint
	// during cluster creation. Specified in projects/*/regions/*/subnetworks/*
	// format. Deprecated: Use
	// ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork
	// instead.
	PrivateEndpointSubnetwork string `json:"privateEndpointSubnetwork,omitempty"`
	// PublicEndpoint: Output only. The external IP address of this cluster's
	// master endpoint. Deprecated: Use
	// ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint instead.
	PublicEndpoint string `json:"publicEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnablePrivateEndpoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnablePrivateEndpoint") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrivateClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateClusterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrivateClusterMasterGlobalAccessConfig: Configuration for controlling master
// global access settings.
type PrivateClusterMasterGlobalAccessConfig struct {
	// Enabled: Whenever master is accessible globally or not.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrivateClusterMasterGlobalAccessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateClusterMasterGlobalAccessConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrivateRegistryAccessConfig: PrivateRegistryAccessConfig contains access
// configuration for private container registries.
type PrivateRegistryAccessConfig struct {
	// CertificateAuthorityDomainConfig: Private registry access configuration.
	CertificateAuthorityDomainConfig []*CertificateAuthorityDomainConfig `json:"certificateAuthorityDomainConfig,omitempty"`
	// Enabled: Private registry access is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CertificateAuthorityDomainConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CertificateAuthorityDomainConfig") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s PrivateRegistryAccessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateRegistryAccessConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrivilegedAdmissionConfig: PrivilegedAdmissionConfig stores the list of
// authorized allowlist paths for the cluster.
type PrivilegedAdmissionConfig struct {
	// AllowlistPaths: The customer allowlist Cloud Storage paths for the cluster.
	// These paths are used with the `--autopilot-privileged-admission` flag to
	// authorize privileged workloads in Autopilot clusters. Paths can be
	// GKE-owned, in the format `gke:////`, or customer-owned, in the format
	// `gs:///`. Wildcards (`*`) are supported to authorize all allowlists under
	// specific paths or directories. Example: `gs://my-bucket/*` will authorize
	// all allowlists under the `my-bucket` bucket.
	AllowlistPaths []string `json:"allowlistPaths,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistPaths") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistPaths") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrivilegedAdmissionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PrivilegedAdmissionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProtectConfig: ProtectConfig defines the flags needed to enable/disable
// features for the Protect API.
type ProtectConfig struct {
	// WorkloadConfig: WorkloadConfig defines which actions are enabled for a
	// cluster's workload configurations.
	WorkloadConfig *WorkloadConfig `json:"workloadConfig,omitempty"`
	// WorkloadVulnerabilityMode: Sets which mode to use for Protect workload
	// vulnerability scanning feature.
	//
	// Possible values:
	//   "WORKLOAD_VULNERABILITY_MODE_UNSPECIFIED" - Default value not specified.
	//   "DISABLED" - Disables Workload Vulnerability Scanning feature on the
	// cluster.
	//   "BASIC" - Applies basic vulnerability scanning settings for cluster
	// workloads.
	WorkloadVulnerabilityMode string `json:"workloadVulnerabilityMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WorkloadConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WorkloadConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProtectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ProtectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PubSub: Pub/Sub specific notification config.
type PubSub struct {
	// Enabled: Enable notifications for Pub/Sub.
	Enabled bool `json:"enabled,omitempty"`
	// Filter: Allows filtering to one or more specific event types. If no filter
	// is specified, or if a filter is specified with no event types, all event
	// types will be sent
	Filter *Filter `json:"filter,omitempty"`
	// Topic: The desired Pub/Sub topic to which notifications will be sent by GKE.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PubSub) MarshalJSON() ([]byte, error) {
	type NoMethod PubSub
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueuedProvisioning: QueuedProvisioning defines the queued provisioning used
// by the node pool.
type QueuedProvisioning struct {
	// Enabled: Denotes that this nodepool is QRM specific, meaning nodes can be
	// only obtained through queuing via the Cluster Autoscaler ProvisioningRequest
	// API.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueuedProvisioning) MarshalJSON() ([]byte, error) {
	type NoMethod QueuedProvisioning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RBACBindingConfig: RBACBindingConfig allows user to restrict
// ClusterRoleBindings an RoleBindings that can be created.
type RBACBindingConfig struct {
	// EnableInsecureBindingSystemAuthenticated: Setting this to true will allow
	// any ClusterRoleBinding and RoleBinding with subjects system:authenticated.
	EnableInsecureBindingSystemAuthenticated bool `json:"enableInsecureBindingSystemAuthenticated,omitempty"`
	// EnableInsecureBindingSystemUnauthenticated: Setting this to true will allow
	// any ClusterRoleBinding and RoleBinding with subjets system:anonymous or
	// system:unauthenticated.
	EnableInsecureBindingSystemUnauthenticated bool `json:"enableInsecureBindingSystemUnauthenticated,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableInsecureBindingSystemAuthenticated") to unconditionally include in
	// API requests. By default, fields with empty or default values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "EnableInsecureBindingSystemAuthenticated") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s RBACBindingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RBACBindingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RangeInfo: RangeInfo contains the range name and the range utilization by
// this cluster.
type RangeInfo struct {
	// RangeName: Output only. Name of a range.
	RangeName string `json:"rangeName,omitempty"`
	// Utilization: Output only. The utilization of the range.
	Utilization float64 `json:"utilization,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RangeName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RangeName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RangeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RangeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RangeInfo) UnmarshalJSON(data []byte) error {
	type NoMethod RangeInfo
	var s1 struct {
		Utilization gensupport.JSONFloat64 `json:"utilization"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Utilization = float64(s1.Utilization)
	return nil
}

// RayClusterLoggingConfig: RayClusterLoggingConfig specifies logging
// configuration for Ray clusters.
type RayClusterLoggingConfig struct {
	// Enabled: Enable log collection for Ray clusters.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RayClusterLoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RayClusterLoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RayClusterMonitoringConfig: RayClusterMonitoringConfig specifies monitoring
// configuration for Ray clusters.
type RayClusterMonitoringConfig struct {
	// Enabled: Enable metrics collection for Ray clusters.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RayClusterMonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RayClusterMonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RayOperatorConfig: Configuration options for the Ray Operator add-on.
type RayOperatorConfig struct {
	// Enabled: Whether the Ray addon is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// RayClusterLoggingConfig: Optional. Logging configuration for Ray clusters.
	RayClusterLoggingConfig *RayClusterLoggingConfig `json:"rayClusterLoggingConfig,omitempty"`
	// RayClusterMonitoringConfig: Optional. Monitoring configuration for Ray
	// clusters.
	RayClusterMonitoringConfig *RayClusterMonitoringConfig `json:"rayClusterMonitoringConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RayOperatorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RayOperatorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RecurringTimeWindow: Represents an arbitrary window of time that recurs.
type RecurringTimeWindow struct {
	// Recurrence: An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3)
	// for how this window reccurs. They go on for the span of time between the
	// start and end time. For example, to have something repeat every weekday,
	// you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily
	// (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first
	// weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies
	// how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4
	// window every weekday, you'd use something like: ``` start time =
	// 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence =
	// FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to
	// make the window encompass every weekend from midnight Saturday till the last
	// minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time =
	// 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start
	// and end time's specific dates are largely arbitrary except to specify
	// duration of the window and when it first starts. The FREQ values of HOURLY,
	// MINUTELY, and SECONDLY are not supported.
	Recurrence string `json:"recurrence,omitempty"`
	// Window: The window of the first recurrence.
	Window *TimeWindow `json:"window,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Recurrence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Recurrence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RecurringTimeWindow) MarshalJSON() ([]byte, error) {
	type NoMethod RecurringTimeWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReleaseChannel: ReleaseChannel indicates which release channel a cluster is
// subscribed to. Release channels are arranged in order of risk. When a
// cluster is subscribed to a release channel, Google maintains both the master
// version and the node version. Node auto-upgrade defaults to true and cannot
// be disabled.
type ReleaseChannel struct {
	// Channel: channel specifies which release channel the cluster is subscribed
	// to.
	//
	// Possible values:
	//   "UNSPECIFIED" - No channel specified.
	//   "RAPID" - RAPID channel is offered on an early access basis for customers
	// who want to test new releases. WARNING: Versions available in the RAPID
	// Channel may be subject to unresolved issues with no known workaround and are
	// not subject to any SLAs.
	//   "REGULAR" - Clusters subscribed to REGULAR receive versions that are
	// considered GA quality. REGULAR is intended for production users who want to
	// take advantage of new features.
	//   "STABLE" - Clusters subscribed to STABLE receive versions that are known
	// to be stable and reliable in production.
	//   "EXTENDED" - Clusters subscribed to EXTENDED receive extended support and
	// availability for versions which are known to be stable and reliable in
	// production.
	Channel string `json:"channel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReleaseChannel) MarshalJSON() ([]byte, error) {
	type NoMethod ReleaseChannel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReleaseChannelConfig: ReleaseChannelConfig exposes configuration for a
// release channel.
type ReleaseChannelConfig struct {
	// AvailableVersions: Deprecated. This field has been deprecated and replaced
	// with the valid_versions field.
	AvailableVersions []*AvailableVersion `json:"availableVersions,omitempty"`
	// Channel: The release channel this configuration applies to.
	//
	// Possible values:
	//   "UNSPECIFIED" - No channel specified.
	//   "RAPID" - RAPID channel is offered on an early access basis for customers
	// who want to test new releases. WARNING: Versions available in the RAPID
	// Channel may be subject to unresolved issues with no known workaround and are
	// not subject to any SLAs.
	//   "REGULAR" - Clusters subscribed to REGULAR receive versions that are
	// considered GA quality. REGULAR is intended for production users who want to
	// take advantage of new features.
	//   "STABLE" - Clusters subscribed to STABLE receive versions that are known
	// to be stable and reliable in production.
	//   "EXTENDED" - Clusters subscribed to EXTENDED receive extended support and
	// availability for versions which are known to be stable and reliable in
	// production.
	Channel string `json:"channel,omitempty"`
	// DefaultVersion: The default version for newly created clusters on the
	// channel.
	DefaultVersion string `json:"defaultVersion,omitempty"`
	// UpgradeTargetVersion: The auto upgrade target version for clusters on the
	// channel.
	UpgradeTargetVersion string `json:"upgradeTargetVersion,omitempty"`
	// ValidVersions: List of valid versions for the channel.
	ValidVersions []string `json:"validVersions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableVersions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReleaseChannelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ReleaseChannelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReservationAffinity: ReservationAffinity
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/instances/reserving-zonal-resources)
// is the configuration of desired reservation which instances could take
// capacity from.
type ReservationAffinity struct {
	// ConsumeReservationType: Corresponds to the type of reservation consumption.
	//
	// Possible values:
	//   "UNSPECIFIED" - Default value. This should not be used.
	//   "NO_RESERVATION" - Do not consume from any reserved capacity.
	//   "ANY_RESERVATION" - Consume any reservation available.
	//   "SPECIFIC_RESERVATION" - Must consume from a specific reservation. Must
	// specify key value fields for specifying the reservations.
	ConsumeReservationType string `json:"consumeReservationType,omitempty"`
	// Key: Corresponds to the label key of a reservation resource. To target a
	// SPECIFIC_RESERVATION by name, specify
	// "compute.googleapis.com/reservation-name" as the key and specify the name of
	// your reservation as its value.
	Key string `json:"key,omitempty"`
	// Values: Corresponds to the label value(s) of reservation resource(s).
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsumeReservationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsumeReservationType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReservationAffinity) MarshalJSON() ([]byte, error) {
	type NoMethod ReservationAffinity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceLabels: Collection of GCP labels
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-labels).
type ResourceLabels struct {
	// Labels: Map of node label keys and node label values.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceLabels) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceLabels
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceLimit: Contains information about amount of some resource in the
// cluster. For memory, value should be in GB.
type ResourceLimit struct {
	// Maximum: Maximum amount of the resource in the cluster.
	Maximum int64 `json:"maximum,omitempty,string"`
	// Minimum: Minimum amount of the resource in the cluster.
	Minimum int64 `json:"minimum,omitempty,string"`
	// ResourceType: Resource name "cpu", "memory" or gpu-specific string.
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Maximum") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Maximum") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceLimit) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceLimit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceManagerTags: A map of resource manager tag keys and values to be
// attached to the nodes for managing Compute Engine firewalls using Network
// Firewall Policies. Tags must be according to specifications in
// https://{$universe.dns_names.final_documentation_domain}/vpc/docs/tags-firewalls-overview#specifications.
// A maximum of 5 tag key-value pairs can be specified. Existing tags will be
// replaced with new values.
type ResourceManagerTags struct {
	// Tags: Tags must be in one of the following formats ([KEY]=[VALUE]) 1.
	// `tagKeys/{tag_key_id}=tagValues/{tag_value_id}` 2.
	// `{org_id}/{tag_key_name}={tag_value_name}` 3.
	// `{project_id}/{tag_key_name}={tag_value_name}`
	Tags map[string]string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tags") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceManagerTags) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceManagerTags
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceUsageExportConfig: Configuration for exporting cluster resource
// usages.
type ResourceUsageExportConfig struct {
	// BigqueryDestination: Configuration to use BigQuery as usage export
	// destination.
	BigqueryDestination *BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// ConsumptionMeteringConfig: Configuration to enable resource consumption
	// metering.
	ConsumptionMeteringConfig *ConsumptionMeteringConfig `json:"consumptionMeteringConfig,omitempty"`
	// EnableNetworkEgressMetering: Whether to enable network egress metering for
	// this cluster. If enabled, a daemonset will be created in the cluster to
	// meter network egress traffic.
	EnableNetworkEgressMetering bool `json:"enableNetworkEgressMetering,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceUsageExportConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceUsageExportConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackNodePoolUpgradeRequest: RollbackNodePoolUpgradeRequest rollbacks the
// previously Aborted or Failed NodePool upgrade. This will be an no-op if the
// last upgrade successfully completed.
type RollbackNodePoolUpgradeRequest struct {
	// ClusterId: Deprecated. The name of the cluster to rollback. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster, node pool id) of the node poll
	// to rollback upgrade. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `json:"name,omitempty"`
	// NodePoolId: Deprecated. The name of the node pool to rollback. This field
	// has been deprecated and replaced by the name field.
	NodePoolId string `json:"nodePoolId,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// RespectPdb: Option for rollback to ignore the PodDisruptionBudget. Default
	// value is false.
	RespectPdb bool `json:"respectPdb,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackNodePoolUpgradeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackNodePoolUpgradeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotationConfig: RotationConfig is config for secret manager auto rotation.
type RotationConfig struct {
	// Enabled: Whether the rotation is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// RotationInterval: The interval between two consecutive rotations. Default
	// rotation interval is 2 minutes.
	RotationInterval string `json:"rotationInterval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RotationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SandboxConfig: SandboxConfig contains configurations of the sandbox to use
// for the node.
type SandboxConfig struct {
	// SandboxType: Type of the sandbox to use for the node (e.g. 'gvisor')
	SandboxType string `json:"sandboxType,omitempty"`
	// Type: Type of the sandbox to use for the node.
	//
	// Possible values:
	//   "UNSPECIFIED" - Default value. This should not be used.
	//   "GVISOR" - Run sandbox using gvisor.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SandboxType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SandboxType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SandboxConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SandboxConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecondaryBootDisk: SecondaryBootDisk represents a persistent disk attached
// to a node with special configurations based on its mode.
type SecondaryBootDisk struct {
	// DiskImage: Fully-qualified resource ID for an existing disk image.
	DiskImage string `json:"diskImage,omitempty"`
	// Mode: Disk mode (container image cache, etc.)
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - MODE_UNSPECIFIED is when mode is not set.
	//   "CONTAINER_IMAGE_CACHE" - CONTAINER_IMAGE_CACHE is for using the secondary
	// boot disk as a container image cache.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiskImage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskImage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecondaryBootDisk) MarshalJSON() ([]byte, error) {
	type NoMethod SecondaryBootDisk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecondaryBootDiskUpdateStrategy: SecondaryBootDiskUpdateStrategy is a
// placeholder which will be extended in the future to define different options
// for updating secondary boot disks.
type SecondaryBootDiskUpdateStrategy struct {
}

// SecretManagerConfig: SecretManagerConfig is config for secret manager
// enablement.
type SecretManagerConfig struct {
	// Enabled: Enable/Disable Secret Manager Config.
	Enabled bool `json:"enabled,omitempty"`
	// RotationConfig: Rotation config for secret manager.
	RotationConfig *RotationConfig `json:"rotationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecretManagerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SecretManagerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityBulletinEvent: SecurityBulletinEvent is a notification sent to
// customers when a security bulletin has been posted that they are vulnerable
// to.
type SecurityBulletinEvent struct {
	// AffectedSupportedMinors: The GKE minor versions affected by this
	// vulnerability.
	AffectedSupportedMinors []string `json:"affectedSupportedMinors,omitempty"`
	// BriefDescription: A brief description of the bulletin. See the bulletin
	// pointed to by the bulletin_uri field for an expanded description.
	BriefDescription string `json:"briefDescription,omitempty"`
	// BulletinId: The ID of the bulletin corresponding to the vulnerability.
	BulletinId string `json:"bulletinId,omitempty"`
	// BulletinUri: The URI link to the bulletin on the website for more
	// information.
	BulletinUri string `json:"bulletinUri,omitempty"`
	// CveIds: The CVEs associated with this bulletin.
	CveIds []string `json:"cveIds,omitempty"`
	// ManualStepsRequired: If this field is specified, it means there are manual
	// steps that the user must take to make their clusters safe.
	ManualStepsRequired bool `json:"manualStepsRequired,omitempty"`
	// MitigatedVersions: The GKE versions where this vulnerability is mitigated.
	MitigatedVersions []string `json:"mitigatedVersions,omitempty"`
	// PatchedVersions: The GKE versions where this vulnerability is patched.
	PatchedVersions []string `json:"patchedVersions,omitempty"`
	// ResourceTypeAffected: The resource type (node/control plane) that has the
	// vulnerability. Multiple notifications (1 notification per resource type)
	// will be sent for a vulnerability that affects > 1 resource type.
	ResourceTypeAffected string `json:"resourceTypeAffected,omitempty"`
	// Severity: The severity of this bulletin as it relates to GKE.
	Severity string `json:"severity,omitempty"`
	// SuggestedUpgradeTarget: This represents a version selected from the
	// patched_versions field that the cluster receiving this notification should
	// most likely want to upgrade to based on its current version. Note that if
	// this notification is being received by a given cluster, it means that this
	// version is currently available as an upgrade target in that cluster's
	// location.
	SuggestedUpgradeTarget string `json:"suggestedUpgradeTarget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AffectedSupportedMinors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffectedSupportedMinors") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityBulletinEvent) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityBulletinEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityPostureConfig: SecurityPostureConfig defines the flags needed to
// enable/disable features for the Security Posture API.
type SecurityPostureConfig struct {
	// Mode: Sets which mode to use for Security Posture features.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value not specified.
	//   "DISABLED" - Disables Security Posture features on the cluster.
	//   "BASIC" - Applies Security Posture features on the cluster.
	//   "ENTERPRISE" - Applies the Security Posture off cluster Enterprise level
	// features.
	Mode string `json:"mode,omitempty"`
	// VulnerabilityMode: Sets which mode to use for vulnerability scanning.
	//
	// Possible values:
	//   "VULNERABILITY_MODE_UNSPECIFIED" - Default value not specified.
	//   "VULNERABILITY_DISABLED" - Disables vulnerability scanning on the cluster.
	//   "VULNERABILITY_BASIC" - Applies basic vulnerability scanning on the
	// cluster.
	//   "VULNERABILITY_ENTERPRISE" - Applies the Security Posture's vulnerability
	// on cluster Enterprise level features.
	VulnerabilityMode string `json:"vulnerabilityMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityPostureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityPostureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServerConfig: Kubernetes Engine service configuration.
type ServerConfig struct {
	// Channels: List of release channel configurations.
	Channels []*ReleaseChannelConfig `json:"channels,omitempty"`
	// DefaultClusterVersion: Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `json:"defaultClusterVersion,omitempty"`
	// DefaultImageType: Default image type.
	DefaultImageType string `json:"defaultImageType,omitempty"`
	// ValidImageTypes: List of valid image types.
	ValidImageTypes []string `json:"validImageTypes,omitempty"`
	// ValidMasterVersions: List of valid master versions, in descending order.
	ValidMasterVersions []string `json:"validMasterVersions,omitempty"`
	// ValidNodeVersions: List of valid node upgrade target versions, in descending
	// order.
	ValidNodeVersions []string `json:"validNodeVersions,omitempty"`
	// WindowsVersionMaps: Maps of Kubernetes version and supported Windows server
	// versions.
	WindowsVersionMaps map[string]WindowsVersions `json:"windowsVersionMaps,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Channels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceExternalIPsConfig: Config to block services with externalIPs field.
type ServiceExternalIPsConfig struct {
	// Enabled: Whether Services with ExternalIPs field are allowed or not.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceExternalIPsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceExternalIPsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetAddonsConfigRequest: SetAddonsRequest sets the addons associated with the
// cluster.
type SetAddonsConfigRequest struct {
	// AddonsConfig: Required. The desired configurations for the various addons
	// available to run in the cluster.
	AddonsConfig *AddonsConfig `json:"addonsConfig,omitempty"`
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster) of the cluster to set addons.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddonsConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddonsConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetAddonsConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetAddonsConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetLabelsRequest: SetLabelsRequest sets the Google Cloud Platform labels on
// a Google Container Engine cluster, which will in turn set them for Google
// Compute Engine resources used by that cluster
type SetLabelsRequest struct {
	// ClusterId: Deprecated. The name of the cluster. This field has been
	// deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// LabelFingerprint: Required. The fingerprint of the previous set of labels
	// for this resource, used to detect conflicts. The fingerprint is initially
	// generated by Kubernetes Engine and changes after every request to modify or
	// update labels. You must always provide an up-to-date fingerprint hash when
	// updating or changing labels. Make a `get()` request to the resource to get
	// the latest fingerprint.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`
	// Name: The name (project, location, cluster name) of the cluster to set
	// labels. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// ResourceLabels: Required. The labels to set for that cluster.
	ResourceLabels map[string]string `json:"resourceLabels,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetLegacyAbacRequest: SetLegacyAbacRequest enables or disables the ABAC
// authorization mechanism for a cluster.
type SetLegacyAbacRequest struct {
	// ClusterId: Deprecated. The name of the cluster to update. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Enabled: Required. Whether ABAC authorization will be enabled in the
	// cluster.
	Enabled bool `json:"enabled,omitempty"`
	// Name: The name (project, location, cluster name) of the cluster to set
	// legacy abac. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetLegacyAbacRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetLegacyAbacRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetLocationsRequest: SetLocationsRequest sets the locations of the cluster.
type SetLocationsRequest struct {
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Locations: Required. The desired list of Google Compute Engine zones
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster's nodes should be located. Changing the locations a
	// cluster is in will result in nodes being either created or removed from the
	// cluster, depending on whether locations are being added or removed. This
	// list must always include the cluster's primary zone.
	Locations []string `json:"locations,omitempty"`
	// Name: The name (project, location, cluster) of the cluster to set locations.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetLocationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetLocationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetLoggingServiceRequest: SetLoggingServiceRequest sets the logging service
// of a cluster.
type SetLoggingServiceRequest struct {
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// LoggingService: Required. The logging service the cluster should use to
	// write logs. Currently available options: *
	// `logging.googleapis.com/kubernetes` - The Cloud Logging service with a
	// Kubernetes-native resource model * `logging.googleapis.com` - The legacy
	// Cloud Logging service (no longer available as of GKE 1.15). * `none` - no
	// logs will be exported from the cluster. If left as an empty
	// string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or
	// `logging.googleapis.com` for earlier versions.
	LoggingService string `json:"loggingService,omitempty"`
	// Name: The name (project, location, cluster) of the cluster to set logging.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetLoggingServiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetLoggingServiceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetMaintenancePolicyRequest: SetMaintenancePolicyRequest sets the
// maintenance policy for a cluster.
type SetMaintenancePolicyRequest struct {
	// ClusterId: Required. The name of the cluster to update.
	ClusterId string `json:"clusterId,omitempty"`
	// MaintenancePolicy: Required. The maintenance policy to be set for the
	// cluster. An empty field clears the existing maintenance policy.
	MaintenancePolicy *MaintenancePolicy `json:"maintenancePolicy,omitempty"`
	// Name: The name (project, location, cluster name) of the cluster to set
	// maintenance policy. Specified in the format
	// `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Required. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Required. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetMaintenancePolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetMaintenancePolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetMasterAuthRequest: SetMasterAuthRequest updates the admin password of a
// cluster.
type SetMasterAuthRequest struct {
	// Action: Required. The exact form of action to be taken on the master auth.
	//
	// Possible values:
	//   "UNKNOWN" - Operation is unknown and will error out.
	//   "SET_PASSWORD" - Set the password to a user generated value.
	//   "GENERATE_PASSWORD" - Generate a new password and set it to that.
	//   "SET_USERNAME" - Set the username. If an empty username is provided, basic
	// authentication is disabled for the cluster. If a non-empty username is
	// provided, basic authentication is enabled, with either a provided password
	// or a generated one.
	Action string `json:"action,omitempty"`
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster) of the cluster to set auth.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Update: Required. A description of the update.
	Update *MasterAuth `json:"update,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetMasterAuthRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetMasterAuthRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetMonitoringServiceRequest: SetMonitoringServiceRequest sets the monitoring
// service of a cluster.
type SetMonitoringServiceRequest struct {
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// MonitoringService: Required. The monitoring service the cluster should use
	// to write metrics. Currently available options: *
	// `monitoring.googleapis.com/kubernetes` - The Cloud Monitoring service with a
	// Kubernetes-native resource model * `monitoring.googleapis.com` - The legacy
	// Cloud Monitoring service (no longer available as of GKE 1.15). * `none` - No
	// metrics will be exported from the cluster. If left as an empty
	// string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or
	// `monitoring.googleapis.com` for earlier versions.
	MonitoringService string `json:"monitoringService,omitempty"`
	// Name: The name (project, location, cluster) of the cluster to set
	// monitoring. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetMonitoringServiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetMonitoringServiceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetNetworkPolicyRequest: SetNetworkPolicyRequest enables/disables network
// policy for a cluster.
type SetNetworkPolicyRequest struct {
	// ClusterId: Deprecated. The name of the cluster. This field has been
	// deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster name) of the cluster to set
	// networking policy. Specified in the format
	// `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// NetworkPolicy: Required. Configuration options for the NetworkPolicy
	// feature.
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetNetworkPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetNetworkPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetNodePoolAutoscalingRequest: SetNodePoolAutoscalingRequest sets the
// autoscaler settings of a node pool.
type SetNodePoolAutoscalingRequest struct {
	// Autoscaling: Required. Autoscaling configuration for the node pool.
	Autoscaling *NodePoolAutoscaling `json:"autoscaling,omitempty"`
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster, node pool) of the node pool to
	// set autoscaler settings. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `json:"name,omitempty"`
	// NodePoolId: Deprecated. The name of the node pool to upgrade. This field has
	// been deprecated and replaced by the name field.
	NodePoolId string `json:"nodePoolId,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Autoscaling") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Autoscaling") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetNodePoolAutoscalingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetNodePoolAutoscalingRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetNodePoolManagementRequest: SetNodePoolManagementRequest sets the node
// management properties of a node pool.
type SetNodePoolManagementRequest struct {
	// ClusterId: Deprecated. The name of the cluster to update. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Management: Required. NodeManagement configuration for the node pool.
	Management *NodeManagement `json:"management,omitempty"`
	// Name: The name (project, location, cluster, node pool id) of the node pool
	// to set management properties. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `json:"name,omitempty"`
	// NodePoolId: Deprecated. The name of the node pool to update. This field has
	// been deprecated and replaced by the name field.
	NodePoolId string `json:"nodePoolId,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetNodePoolManagementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetNodePoolManagementRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetNodePoolSizeRequest: SetNodePoolSizeRequest sets the size of a node pool.
type SetNodePoolSizeRequest struct {
	// ClusterId: Deprecated. The name of the cluster to update. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster, node pool id) of the node pool
	// to set size. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `json:"name,omitempty"`
	// NodeCount: Required. The desired node count for the pool.
	NodeCount int64 `json:"nodeCount,omitempty"`
	// NodePoolId: Deprecated. The name of the node pool to update. This field has
	// been deprecated and replaced by the name field.
	NodePoolId string `json:"nodePoolId,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetNodePoolSizeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetNodePoolSizeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShieldedInstanceConfig: A set of Shielded Instance options.
type ShieldedInstanceConfig struct {
	// EnableIntegrityMonitoring: Defines whether the instance has integrity
	// monitoring enabled. Enables monitoring and attestation of the boot integrity
	// of the instance. The attestation is performed against the integrity policy
	// baseline. This baseline is initially derived from the implicitly trusted
	// boot image when the instance is created.
	EnableIntegrityMonitoring bool `json:"enableIntegrityMonitoring,omitempty"`
	// EnableSecureBoot: Defines whether the instance has Secure Boot enabled.
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the boot
	// process if signature verification fails.
	EnableSecureBoot bool `json:"enableSecureBoot,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableIntegrityMonitoring")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableIntegrityMonitoring") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShieldedInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ShieldedInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShieldedNodes: Configuration of Shielded Nodes feature.
type ShieldedNodes struct {
	// Enabled: Whether Shielded Nodes features are enabled on all nodes in this
	// cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShieldedNodes) MarshalJSON() ([]byte, error) {
	type NoMethod ShieldedNodes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SoleTenantConfig: SoleTenantConfig contains the NodeAffinities to specify
// what shared sole tenant node groups should back the node pool.
type SoleTenantConfig struct {
	// MinNodeCpus: Optional. The minimum number of virtual CPUs this instance will
	// consume when running on a sole-tenant node. This field can only be set if
	// the node pool is created in a shared sole-tenant node group.
	MinNodeCpus int64 `json:"minNodeCpus,omitempty"`
	// NodeAffinities: NodeAffinities used to match to a shared sole tenant node
	// group.
	NodeAffinities []*NodeAffinity `json:"nodeAffinities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MinNodeCpus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MinNodeCpus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SoleTenantConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SoleTenantConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StandardRolloutPolicy: Standard rollout policy is the default policy for
// blue-green.
type StandardRolloutPolicy struct {
	// BatchNodeCount: Number of blue nodes to drain in a batch.
	BatchNodeCount int64 `json:"batchNodeCount,omitempty"`
	// BatchPercentage: Percentage of the blue pool nodes to drain in a batch. The
	// range of this field should be (0.0, 1.0].
	BatchPercentage float64 `json:"batchPercentage,omitempty"`
	// BatchSoakDuration: Soak time after each batch gets drained. Default to zero.
	BatchSoakDuration string `json:"batchSoakDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchNodeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchNodeCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StandardRolloutPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod StandardRolloutPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *StandardRolloutPolicy) UnmarshalJSON(data []byte) error {
	type NoMethod StandardRolloutPolicy
	var s1 struct {
		BatchPercentage gensupport.JSONFloat64 `json:"batchPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BatchPercentage = float64(s1.BatchPercentage)
	return nil
}

// StartIPRotationRequest: StartIPRotationRequest creates a new IP for the
// cluster and then performs a node upgrade on each node pool to point to the
// new IP.
type StartIPRotationRequest struct {
	// ClusterId: Deprecated. The name of the cluster. This field has been
	// deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster name) of the cluster to start IP
	// rotation. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// RotateCredentials: Whether to rotate credentials during IP rotation.
	RotateCredentials bool `json:"rotateCredentials,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StartIPRotationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StartIPRotationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StatefulHAConfig: Configuration for the Stateful HA add-on.
type StatefulHAConfig struct {
	// Enabled: Whether the Stateful HA add-on is enabled for this cluster.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StatefulHAConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StatefulHAConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StatusCondition: StatusCondition describes why a cluster or a node pool has
// a certain status (e.g., ERROR or DEGRADED).
type StatusCondition struct {
	// CanonicalCode: Canonical code of the condition.
	//
	// Possible values:
	//   "OK" - Not an error; returned on success. HTTP Mapping: 200 OK
	//   "CANCELLED" - The operation was cancelled, typically by the caller. HTTP
	// Mapping: 499 Client Closed Request
	//   "UNKNOWN" - Unknown error. For example, this error may be returned when a
	// `Status` value received from another address space belongs to an error space
	// that is not known in this address space. Also errors raised by APIs that do
	// not return enough error information may be converted to this error. HTTP
	// Mapping: 500 Internal Server Error
	//   "INVALID_ARGUMENT" - The client specified an invalid argument. Note that
	// this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
	// arguments that are problematic regardless of the state of the system (e.g.,
	// a malformed file name). HTTP Mapping: 400 Bad Request
	//   "DEADLINE_EXCEEDED" - The deadline expired before the operation could
	// complete. For operations that change the state of the system, this error may
	// be returned even if the operation has completed successfully. For example, a
	// successful response from a server could have been delayed long enough for
	// the deadline to expire. HTTP Mapping: 504 Gateway Timeout
	//   "NOT_FOUND" - Some requested entity (e.g., file or directory) was not
	// found. Note to server developers: if a request is denied for an entire class
	// of users, such as gradual feature rollout or undocumented allowlist,
	// `NOT_FOUND` may be used. If a request is denied for some users within a
	// class of users, such as user-based access control, `PERMISSION_DENIED` must
	// be used. HTTP Mapping: 404 Not Found
	//   "ALREADY_EXISTS" - The entity that a client attempted to create (e.g.,
	// file or directory) already exists. HTTP Mapping: 409 Conflict
	//   "PERMISSION_DENIED" - The caller does not have permission to execute the
	// specified operation. `PERMISSION_DENIED` must not be used for rejections
	// caused by exhausting some resource (use `RESOURCE_EXHAUSTED` instead for
	// those errors). `PERMISSION_DENIED` must not be used if the caller can not be
	// identified (use `UNAUTHENTICATED` instead for those errors). This error code
	// does not imply the request is valid or the requested entity exists or
	// satisfies other pre-conditions. HTTP Mapping: 403 Forbidden
	//   "UNAUTHENTICATED" - The request does not have valid authentication
	// credentials for the operation. HTTP Mapping: 401 Unauthorized
	//   "RESOURCE_EXHAUSTED" - Some resource has been exhausted, perhaps a
	// per-user quota, or perhaps the entire file system is out of space. HTTP
	// Mapping: 429 Too Many Requests
	//   "FAILED_PRECONDITION" - The operation was rejected because the system is
	// not in a state required for the operation's execution. For example, the
	// directory to be deleted is non-empty, an rmdir operation is applied to a
	// non-directory, etc. Service implementors can use the following guidelines to
	// decide between `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`: (a) Use
	// `UNAVAILABLE` if the client can retry just the failing call. (b) Use
	// `ABORTED` if the client should retry at a higher level. For example, when a
	// client-specified test-and-set fails, indicating the client should restart a
	// read-modify-write sequence. (c) Use `FAILED_PRECONDITION` if the client
	// should not retry until the system state has been explicitly fixed. For
	// example, if an "rmdir" fails because the directory is non-empty,
	// `FAILED_PRECONDITION` should be returned since the client should not retry
	// unless the files are deleted from the directory. HTTP Mapping: 400 Bad
	// Request
	//   "ABORTED" - The operation was aborted, typically due to a concurrency
	// issue such as a sequencer check failure or transaction abort. See the
	// guidelines above for deciding between `FAILED_PRECONDITION`, `ABORTED`, and
	// `UNAVAILABLE`. HTTP Mapping: 409 Conflict
	//   "OUT_OF_RANGE" - The operation was attempted past the valid range. E.g.,
	// seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this error
	// indicates a problem that may be fixed if the system state changes. For
	// example, a 32-bit file system will generate `INVALID_ARGUMENT` if asked to
	// read at an offset that is not in the range [0,2^32-1], but it will generate
	// `OUT_OF_RANGE` if asked to read from an offset past the current file size.
	// There is a fair bit of overlap between `FAILED_PRECONDITION` and
	// `OUT_OF_RANGE`. We recommend using `OUT_OF_RANGE` (the more specific error)
	// when it applies so that callers who are iterating through a space can easily
	// look for an `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping:
	// 400 Bad Request
	//   "UNIMPLEMENTED" - The operation is not implemented or is not
	// supported/enabled in this service. HTTP Mapping: 501 Not Implemented
	//   "INTERNAL" - Internal errors. This means that some invariants expected by
	// the underlying system have been broken. This error code is reserved for
	// serious errors. HTTP Mapping: 500 Internal Server Error
	//   "UNAVAILABLE" - The service is currently unavailable. This is most likely
	// a transient condition, which can be corrected by retrying with a backoff.
	// Note that it is not always safe to retry non-idempotent operations. See the
	// guidelines above for deciding between `FAILED_PRECONDITION`, `ABORTED`, and
	// `UNAVAILABLE`. HTTP Mapping: 503 Service Unavailable
	//   "DATA_LOSS" - Unrecoverable data loss or corruption. HTTP Mapping: 500
	// Internal Server Error
	CanonicalCode string `json:"canonicalCode,omitempty"`
	// Code: Machine-friendly representation of the condition Deprecated. Use
	// canonical_code instead.
	//
	// Possible values:
	//   "UNKNOWN" - UNKNOWN indicates a generic condition.
	//   "GCE_STOCKOUT" - GCE_STOCKOUT indicates that Google Compute Engine
	// resources are temporarily unavailable.
	//   "GKE_SERVICE_ACCOUNT_DELETED" - GKE_SERVICE_ACCOUNT_DELETED indicates that
	// the user deleted their robot service account.
	//   "GCE_QUOTA_EXCEEDED" - Google Compute Engine quota was exceeded.
	//   "SET_BY_OPERATOR" - Cluster state was manually changed by an SRE due to a
	// system logic error.
	//   "CLOUD_KMS_KEY_ERROR" - Unable to perform an encrypt operation against the
	// CloudKMS key used for etcd level encryption.
	//   "CA_EXPIRING" - Cluster CA is expiring soon.
	//   "NODE_SERVICE_ACCOUNT_MISSING_PERMISSIONS" - Node service account is
	// missing permissions.
	//   "CLOUD_KMS_KEY_DESTROYED" - Cloud KMS key version used for etcd level
	// encryption has been destroyed. This is a permanent error.
	Code string `json:"code,omitempty"`
	// Message: Human-friendly representation of the condition
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StatusCondition) MarshalJSON() ([]byte, error) {
	type NoMethod StatusCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeWindow: Represents an arbitrary window of time.
type TimeWindow struct {
	// EndTime: The time that the window ends. The end time should take place after
	// the start time.
	EndTime string `json:"endTime,omitempty"`
	// MaintenanceExclusionOptions: MaintenanceExclusionOptions provides
	// maintenance exclusion related options.
	MaintenanceExclusionOptions *MaintenanceExclusionOptions `json:"maintenanceExclusionOptions,omitempty"`
	// StartTime: The time that the window first starts.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeWindow) MarshalJSON() ([]byte, error) {
	type NoMethod TimeWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TopologyManager: TopologyManager defines the configuration options for
// Topology Manager feature. See
// https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/
type TopologyManager struct {
	// Policy: Configures the strategy for resource alignment. Allowed values are:
	// * none: the default policy, and does not perform any topology alignment. *
	// restricted: the topology manager stores the preferred NUMA node affinity for
	// the container, and will reject the pod if the affinity if not preferred. *
	// best-effort: the topology manager stores the preferred NUMA node affinity
	// for the container. If the affinity is not preferred, the topology manager
	// will admit the pod to the node anyway. * single-numa-node: the topology
	// manager determines if the single NUMA node affinity is possible. If it is,
	// Topology Manager will store this and the Hint Providers can then use this
	// information when making the resource allocation decision. If, however, this
	// is not possible then the Topology Manager will reject the pod from the node.
	// This will result in a pod in a Terminated state with a pod admission
	// failure. The default policy value is 'none' if unspecified. Details about
	// each strategy can be found here
	// (https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-policies).
	Policy string `json:"policy,omitempty"`
	// Scope: The Topology Manager aligns resources in following scopes: *
	// container * pod The default scope is 'container' if unspecified. See
	// https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-scopes
	Scope string `json:"scope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TopologyManager) MarshalJSON() ([]byte, error) {
	type NoMethod TopologyManager
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TpuConfig: Configuration for Cloud TPU. This message is deprecated due to
// the deprecation of 2VM TPU. The end of life date for 2VM TPU is 2025-04-25.
type TpuConfig struct {
	// Enabled: Whether Cloud TPU integration is enabled or not.
	Enabled bool `json:"enabled,omitempty"`
	// Ipv4CidrBlock: IPv4 CIDR block reserved for Cloud TPU in the VPC.
	Ipv4CidrBlock string `json:"ipv4CidrBlock,omitempty"`
	// UseServiceNetworking: Whether to use service networking for Cloud TPU or
	// not.
	UseServiceNetworking bool `json:"useServiceNetworking,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TpuConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TpuConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateClusterRequest: UpdateClusterRequest updates the settings of a
// cluster.
type UpdateClusterRequest struct {
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// Name: The name (project, location, cluster) of the cluster to update.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Update: Required. A description of the update.
	Update *ClusterUpdate `json:"update,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateClusterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateInfo: UpdateInfo contains resource (instance groups, etc), status and
// other intermediate information relevant to a node pool upgrade.
type UpdateInfo struct {
	// BlueGreenInfo: Information of a blue-green upgrade.
	BlueGreenInfo *BlueGreenInfo `json:"blueGreenInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlueGreenInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlueGreenInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateMasterRequest: UpdateMasterRequest updates the master of the cluster.
type UpdateMasterRequest struct {
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// MasterVersion: Required. The Kubernetes version to change the master to.
	// Users may specify either explicit versions offered by Kubernetes Engine or
	// version aliases, which have the following behavior: - "latest": picks the
	// highest valid Kubernetes version - "1.X": picks the highest valid
	// patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
	// gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
	// Kubernetes version - "-": picks the default Kubernetes version
	MasterVersion string `json:"masterVersion,omitempty"`
	// Name: The name (project, location, cluster) of the cluster to update.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `json:"name,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateMasterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateMasterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateNodePoolRequest: SetNodePoolVersionRequest updates the version of a
// node pool.
type UpdateNodePoolRequest struct {
	// Accelerators: A list of hardware accelerators to be attached to each node.
	// See
	// https://{$universe.dns_names.final_documentation_domain}/compute/docs/gpus
	// for more information about support for GPUs.
	Accelerators []*AcceleratorConfig `json:"accelerators,omitempty"`
	// BootDisk: The desired boot disk config for nodes in the node pool. Initiates
	// an upgrade operation that migrates the nodes in the node pool to the
	// specified boot disk config.
	BootDisk *BootDisk `json:"bootDisk,omitempty"`
	// ClusterId: Deprecated. The name of the cluster to upgrade. This field has
	// been deprecated and replaced by the name field.
	ClusterId string `json:"clusterId,omitempty"`
	// ConfidentialNodes: Confidential nodes config. All the nodes in the node pool
	// will be Confidential VM once enabled.
	ConfidentialNodes *ConfidentialNodes `json:"confidentialNodes,omitempty"`
	// ContainerdConfig: The desired containerd config for nodes in the node pool.
	// Initiates an upgrade operation that recreates the nodes with the new config.
	ContainerdConfig *ContainerdConfig `json:"containerdConfig,omitempty"`
	// DiskSizeGb: Optional. The desired disk size for nodes in the node pool.
	// Initiates an upgrade operation that migrates the nodes in the node pool to
	// the specified disk size.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`
	// DiskType: Optional. The desired disk type for nodes in the node pool.
	// Initiates an upgrade operation that migrates the nodes in the node pool to
	// the specified disk type.
	DiskType string `json:"diskType,omitempty"`
	// Etag: The current etag of the node pool. If an etag is provided and does not
	// match the current etag of the node pool, update will be blocked and an
	// ABORTED error will be returned.
	Etag string `json:"etag,omitempty"`
	// FastSocket: Enable or disable NCCL fast socket for the node pool.
	FastSocket *FastSocket `json:"fastSocket,omitempty"`
	// FlexStart: Flex Start flag for enabling Flex Start VM.
	FlexStart bool `json:"flexStart,omitempty"`
	// GcfsConfig: GCFS config.
	GcfsConfig *GcfsConfig `json:"gcfsConfig,omitempty"`
	// Gvnic: Enable or disable gvnic on the node pool.
	Gvnic *VirtualNIC `json:"gvnic,omitempty"`
	// ImageType: Required. The desired image type for the node pool. Please see
	// https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/concepts/node-images
	// for available image types.
	ImageType string `json:"imageType,omitempty"`
	// KubeletConfig: Node kubelet configs.
	KubeletConfig *NodeKubeletConfig `json:"kubeletConfig,omitempty"`
	// Labels: The desired node labels to be applied to all nodes in the node pool.
	// If this field is not present, the labels will not be changed. Otherwise, the
	// existing node labels will be *replaced* with the provided labels.
	Labels *NodeLabels `json:"labels,omitempty"`
	// LinuxNodeConfig: Parameters that can be configured on Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `json:"linuxNodeConfig,omitempty"`
	// Locations: The desired list of Google Compute Engine zones
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the node pool's nodes should be located. Changing the locations for
	// a node pool will result in nodes being either created or removed from the
	// node pool, depending on whether locations are being added or removed.
	Locations []string `json:"locations,omitempty"`
	// LoggingConfig: Logging configuration.
	LoggingConfig *NodePoolLoggingConfig `json:"loggingConfig,omitempty"`
	// MachineType: Optional. The desired machine type for nodes in the node pool.
	// Initiates an upgrade operation that migrates the nodes in the node pool to
	// the specified machine type.
	MachineType string `json:"machineType,omitempty"`
	// MaxRunDuration: The maximum duration for the nodes to exist. If unspecified,
	// the nodes can exist indefinitely.
	MaxRunDuration string `json:"maxRunDuration,omitempty"`
	// Name: The name (project, location, cluster, node pool) of the node pool to
	// update. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `json:"name,omitempty"`
	// NodeNetworkConfig: Node network config.
	NodeNetworkConfig *NodeNetworkConfig `json:"nodeNetworkConfig,omitempty"`
	// NodePoolId: Deprecated. The name of the node pool to upgrade. This field has
	// been deprecated and replaced by the name field.
	NodePoolId string `json:"nodePoolId,omitempty"`
	// NodeVersion: Required. The Kubernetes version to change the nodes to
	// (typically an upgrade). Users may specify either explicit versions offered
	// by Kubernetes Engine or version aliases, which have the following behavior:
	// - "latest": picks the highest valid Kubernetes version - "1.X": picks the
	// highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the
	// highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an
	// explicit Kubernetes version - "-": picks the Kubernetes master version
	NodeVersion string `json:"nodeVersion,omitempty"`
	// ProjectId: Deprecated. The Google Developers Console project ID or project
	// number
	// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `json:"projectId,omitempty"`
	// QueuedProvisioning: Specifies the configuration of queued provisioning.
	QueuedProvisioning *QueuedProvisioning `json:"queuedProvisioning,omitempty"`
	// ResourceLabels: The resource labels for the node pool to use to annotate any
	// related Google Compute Engine resources.
	ResourceLabels *ResourceLabels `json:"resourceLabels,omitempty"`
	// ResourceManagerTags: Desired resource manager tag keys and values to be
	// attached to the nodes for managing Compute Engine firewalls using Network
	// Firewall Policies. Existing tags will be replaced with new values.
	ResourceManagerTags *ResourceManagerTags `json:"resourceManagerTags,omitempty"`
	// StoragePools: List of Storage Pools where boot disks are provisioned.
	// Existing Storage Pools will be replaced with storage-pools.
	StoragePools []string `json:"storagePools,omitempty"`
	// Tags: The desired network tags to be applied to all nodes in the node pool.
	// If this field is not present, the tags will not be changed. Otherwise, the
	// existing network tags will be *replaced* with the provided tags.
	Tags *NetworkTags `json:"tags,omitempty"`
	// Taints: The desired node taints to be applied to all nodes in the node pool.
	// If this field is not present, the taints will not be changed. Otherwise, the
	// existing node taints will be *replaced* with the provided taints.
	Taints *NodeTaints `json:"taints,omitempty"`
	// UpgradeSettings: Upgrade settings control disruption and speed of the
	// upgrade.
	UpgradeSettings *UpgradeSettings `json:"upgradeSettings,omitempty"`
	// WindowsNodeConfig: Parameters that can be configured on Windows nodes.
	WindowsNodeConfig *WindowsNodeConfig `json:"windowsNodeConfig,omitempty"`
	// WorkloadMetadataConfig: The desired workload metadata config for the node
	// pool.
	WorkloadMetadataConfig *WorkloadMetadataConfig `json:"workloadMetadataConfig,omitempty"`
	// Zone: Deprecated. The name of the Google Compute Engine zone
	// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
	// in which the cluster resides. This field has been deprecated and replaced by
	// the name field.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accelerators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accelerators") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateNodePoolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateNodePoolRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeAvailableEvent: UpgradeAvailableEvent is a notification sent to
// customers when a new available version is released.
type UpgradeAvailableEvent struct {
	// ReleaseChannel: The release channel of the version. If empty, it means a
	// non-channel release.
	ReleaseChannel *ReleaseChannel `json:"releaseChannel,omitempty"`
	// Resource: Optional relative path to the resource. For example, the relative
	// path of the node pool.
	Resource string `json:"resource,omitempty"`
	// ResourceType: The resource type of the release version.
	//
	// Possible values:
	//   "UPGRADE_RESOURCE_TYPE_UNSPECIFIED" - Default value. This shouldn't be
	// used.
	//   "MASTER" - Master / control plane
	//   "NODE_POOL" - Node pool
	ResourceType string `json:"resourceType,omitempty"`
	// Version: The release version available for upgrade.
	Version string `json:"version,omitempty"`
	// WindowsVersions: Windows node versions info.
	WindowsVersions *WindowsVersions `json:"windowsVersions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReleaseChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReleaseChannel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeAvailableEvent) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeAvailableEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeDetails: UpgradeDetails contains detailed information of each
// individual upgrade operation.
type UpgradeDetails struct {
	// EndTime: The end timestamp of the upgrade.
	EndTime string `json:"endTime,omitempty"`
	// InitialVersion: The version before the upgrade.
	InitialVersion string `json:"initialVersion,omitempty"`
	// StartTime: The start timestamp of the upgrade.
	StartTime string `json:"startTime,omitempty"`
	// StartType: The start type of the upgrade.
	//
	// Possible values:
	//   "START_TYPE_UNSPECIFIED" - Upgrade start type is unspecified.
	//   "AUTOMATIC" - Upgrade started automatically.
	//   "MANUAL" - Upgrade started manually.
	StartType string `json:"startType,omitempty"`
	// State: Output only. The state of the upgrade.
	//
	// Possible values:
	//   "UNKNOWN" - Upgrade state is unknown.
	//   "FAILED" - Upgrade has failed with an error.
	//   "SUCCEEDED" - Upgrade has succeeded.
	//   "CANCELED" - Upgrade has been canceled.
	//   "RUNNING" - Upgrade is running.
	State string `json:"state,omitempty"`
	// TargetVersion: The version after the upgrade.
	TargetVersion string `json:"targetVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeDetails) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeEvent: UpgradeEvent is a notification sent to customers by the
// cluster server when a resource is upgrading.
type UpgradeEvent struct {
	// CurrentVersion: The current version before the upgrade.
	CurrentVersion string `json:"currentVersion,omitempty"`
	// Operation: The operation associated with this upgrade.
	Operation string `json:"operation,omitempty"`
	// OperationStartTime: The time when the operation was started.
	OperationStartTime string `json:"operationStartTime,omitempty"`
	// Resource: Optional relative path to the resource. For example in node pool
	// upgrades, the relative path of the node pool.
	Resource string `json:"resource,omitempty"`
	// ResourceType: The resource type that is upgrading.
	//
	// Possible values:
	//   "UPGRADE_RESOURCE_TYPE_UNSPECIFIED" - Default value. This shouldn't be
	// used.
	//   "MASTER" - Master / control plane
	//   "NODE_POOL" - Node pool
	ResourceType string `json:"resourceType,omitempty"`
	// TargetVersion: The target version for the upgrade.
	TargetVersion string `json:"targetVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeEvent) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeInfoEvent: UpgradeInfoEvent is a notification sent to customers about
// the upgrade information of a resource.
type UpgradeInfoEvent struct {
	// CurrentVersion: The current version before the upgrade.
	CurrentVersion string `json:"currentVersion,omitempty"`
	// Description: A brief description of the event.
	Description string `json:"description,omitempty"`
	// EndTime: The time when the operation ended.
	EndTime string `json:"endTime,omitempty"`
	// EventType: The type of the event.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - EVENT_TYPE_UNSPECIFIED indicates the event type
	// is unspecified.
	//   "END_OF_SUPPORT" - END_OF_SUPPORT indicates GKE version reaches end of
	// support, check standard_support_end_time and extended_support_end_time for
	// more details.
	//   "COS_MILESTONE_VERSION_UPDATE" - COS_MILESTONE_VERSION_UPDATE indicates
	// that the COS node image will update COS milestone version for new patch
	// versions starting with the one in the description.
	//   "UPGRADE_LIFECYCLE" - UPGRADE_LIFECYCLE indicates the event is about the
	// upgrade lifecycle.
	EventType string `json:"eventType,omitempty"`
	// ExtendedSupportEndTime: The end of extended support timestamp.
	ExtendedSupportEndTime string `json:"extendedSupportEndTime,omitempty"`
	// Operation: The operation associated with this upgrade.
	Operation string `json:"operation,omitempty"`
	// Resource: Optional relative path to the resource. For example in node pool
	// upgrades, the relative path of the node pool.
	Resource string `json:"resource,omitempty"`
	// ResourceType: The resource type associated with the upgrade.
	//
	// Possible values:
	//   "UPGRADE_RESOURCE_TYPE_UNSPECIFIED" - Default value. This shouldn't be
	// used.
	//   "MASTER" - Master / control plane
	//   "NODE_POOL" - Node pool
	ResourceType string `json:"resourceType,omitempty"`
	// StandardSupportEndTime: The end of standard support timestamp.
	StandardSupportEndTime string `json:"standardSupportEndTime,omitempty"`
	// StartTime: The time when the operation was started.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The state of the upgrade.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - STATE_UNSPECIFIED indicates the state is
	// unspecified.
	//   "STARTED" - STARTED indicates the upgrade has started.
	//   "SUCCEEDED" - SUCCEEDED indicates the upgrade has completed successfully.
	//   "FAILED" - FAILED indicates the upgrade has failed.
	//   "CANCELED" - CANCELED indicates the upgrade has canceled.
	State string `json:"state,omitempty"`
	// TargetVersion: The target version for the upgrade.
	TargetVersion string `json:"targetVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeInfoEvent) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeInfoEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeSettings: These upgrade settings control the level of parallelism and
// the level of disruption caused by an upgrade. maxUnavailable controls the
// number of nodes that can be simultaneously unavailable. maxSurge controls
// the number of additional nodes that can be added to the node pool
// temporarily for the time of the upgrade to increase the number of available
// nodes. (maxUnavailable + maxSurge) determines the level of parallelism (how
// many nodes are being upgraded at the same time). Note: upgrades inevitably
// introduce some disruption since workloads need to be moved from old nodes to
// new, upgraded ones. Even if maxUnavailable=0, this holds true. (Disruption
// stays within the limits of PodDisruptionBudget, if it is configured.)
// Consider a hypothetical node pool with 5 nodes having maxSurge=2,
// maxUnavailable=1. This means the upgrade process upgrades 3 nodes
// simultaneously. It creates 2 additional (upgraded) nodes, then it brings
// down 3 old (not yet upgraded) nodes at the same time. This ensures that
// there are always at least 4 nodes available. These upgrade settings
// configure the upgrade strategy for the node pool. Use strategy to switch
// between the strategies applied to the node pool. If the strategy is SURGE,
// use max_surge and max_unavailable to control the level of parallelism and
// the level of disruption caused by upgrade. 1. maxSurge controls the number
// of additional nodes that can be added to the node pool temporarily for the
// time of the upgrade to increase the number of available nodes. 2.
// maxUnavailable controls the number of nodes that can be simultaneously
// unavailable. 3. (maxUnavailable + maxSurge) determines the level of
// parallelism (how many nodes are being upgraded at the same time). If the
// strategy is BLUE_GREEN, use blue_green_settings to configure the blue-green
// upgrade related settings. 1. standard_rollout_policy is the default policy.
// The policy is used to control the way blue pool gets drained. The draining
// is executed in the batch mode. The batch size could be specified as either
// percentage of the node pool size or the number of nodes. batch_soak_duration
// is the soak time after each batch gets drained. 2. node_pool_soak_duration
// is the soak time after all blue nodes are drained. After this period, the
// blue pool nodes will be deleted.
type UpgradeSettings struct {
	// BlueGreenSettings: Settings for blue-green upgrade strategy.
	BlueGreenSettings *BlueGreenSettings `json:"blueGreenSettings,omitempty"`
	// MaxSurge: The maximum number of nodes that can be created beyond the current
	// size of the node pool during the upgrade process.
	MaxSurge int64 `json:"maxSurge,omitempty"`
	// MaxUnavailable: The maximum number of nodes that can be simultaneously
	// unavailable during the upgrade process. A node is considered available if
	// its status is Ready.
	MaxUnavailable int64 `json:"maxUnavailable,omitempty"`
	// Strategy: Update strategy of the node pool.
	//
	// Possible values:
	//   "NODE_POOL_UPDATE_STRATEGY_UNSPECIFIED" - Default value if unset. GKE
	// internally defaults the update strategy to SURGE for unspecified strategies.
	//   "BLUE_GREEN" - blue-green upgrade.
	//   "SURGE" - SURGE is the traditional way of upgrading a node pool. max_surge
	// and max_unavailable determines the level of upgrade parallelism.
	Strategy string `json:"strategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlueGreenSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlueGreenSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeSettings) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsableSubnetwork: UsableSubnetwork resource returns the subnetwork name, its
// associated network and the primary CIDR range.
type UsableSubnetwork struct {
	// IpCidrRange: The range of internal addresses that are owned by this
	// subnetwork.
	IpCidrRange string `json:"ipCidrRange,omitempty"`
	// Network: Network Name. Example:
	// projects/my-project/global/networks/my-network
	Network string `json:"network,omitempty"`
	// SecondaryIpRanges: Secondary IP ranges.
	SecondaryIpRanges []*UsableSubnetworkSecondaryRange `json:"secondaryIpRanges,omitempty"`
	// StatusMessage: A human readable status message representing the reasons for
	// cases where the caller cannot use the secondary ranges under the subnet. For
	// example if the secondary_ip_ranges is empty due to a permission issue, an
	// insufficient permission message will be given by status_message.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Subnetwork: Subnetwork Name. Example:
	// projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpCidrRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpCidrRange") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsableSubnetwork) MarshalJSON() ([]byte, error) {
	type NoMethod UsableSubnetwork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsableSubnetworkSecondaryRange: Secondary IP range of a usable subnetwork.
type UsableSubnetworkSecondaryRange struct {
	// IpCidrRange: The range of IP addresses belonging to this subnetwork
	// secondary range.
	IpCidrRange string `json:"ipCidrRange,omitempty"`
	// RangeName: The name associated with this subnetwork secondary range, used
	// when adding an alias IP range to a VM instance.
	RangeName string `json:"rangeName,omitempty"`
	// Status: This field is to determine the status of the secondary range
	// programmably.
	//
	// Possible values:
	//   "UNKNOWN" - UNKNOWN is the zero value of the Status enum. It's not a valid
	// status.
	//   "UNUSED" - UNUSED denotes that this range is unclaimed by any cluster.
	//   "IN_USE_SERVICE" - IN_USE_SERVICE denotes that this range is claimed by a
	// cluster for services. It cannot be used for other clusters.
	//   "IN_USE_SHAREABLE_POD" - IN_USE_SHAREABLE_POD denotes this range was
	// created by the network admin and is currently claimed by a cluster for pods.
	// It can only be used by other clusters as a pod range.
	//   "IN_USE_MANAGED_POD" - IN_USE_MANAGED_POD denotes this range was created
	// by GKE and is claimed for pods. It cannot be used for other clusters.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpCidrRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpCidrRange") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsableSubnetworkSecondaryRange) MarshalJSON() ([]byte, error) {
	type NoMethod UsableSubnetworkSecondaryRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserManagedKeysConfig: UserManagedKeysConfig holds the resource address to
// Keys which are used for signing certs and token that are used for
// communication within cluster.
type UserManagedKeysConfig struct {
	// AggregationCa: The Certificate Authority Service caPool to use for the
	// aggregation CA in this cluster.
	AggregationCa string `json:"aggregationCa,omitempty"`
	// ClusterCa: The Certificate Authority Service caPool to use for the cluster
	// CA in this cluster.
	ClusterCa string `json:"clusterCa,omitempty"`
	// ControlPlaneDiskEncryptionKey: The Cloud KMS cryptoKey to use for
	// Confidential Hyperdisk on the control plane nodes.
	ControlPlaneDiskEncryptionKey string `json:"controlPlaneDiskEncryptionKey,omitempty"`
	// EtcdApiCa: Resource path of the Certificate Authority Service caPool to use
	// for the etcd API CA in this cluster.
	EtcdApiCa string `json:"etcdApiCa,omitempty"`
	// EtcdPeerCa: Resource path of the Certificate Authority Service caPool to use
	// for the etcd peer CA in this cluster.
	EtcdPeerCa string `json:"etcdPeerCa,omitempty"`
	// GkeopsEtcdBackupEncryptionKey: Resource path of the Cloud KMS cryptoKey to
	// use for encryption of internal etcd backups.
	GkeopsEtcdBackupEncryptionKey string `json:"gkeopsEtcdBackupEncryptionKey,omitempty"`
	// ServiceAccountSigningKeys: The Cloud KMS cryptoKeyVersions to use for
	// signing service account JWTs issued by this cluster. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{crypt
	// oKey}/cryptoKeyVersions/{cryptoKeyVersion}`
	ServiceAccountSigningKeys []string `json:"serviceAccountSigningKeys,omitempty"`
	// ServiceAccountVerificationKeys: The Cloud KMS cryptoKeyVersions to use for
	// verifying service account JWTs issued by this cluster. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{crypt
	// oKey}/cryptoKeyVersions/{cryptoKeyVersion}`
	ServiceAccountVerificationKeys []string `json:"serviceAccountVerificationKeys,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationCa") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationCa") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserManagedKeysConfig) MarshalJSON() ([]byte, error) {
	type NoMethod UserManagedKeysConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerticalPodAutoscaling: VerticalPodAutoscaling contains global, per-cluster
// information required by Vertical Pod Autoscaler to automatically adjust the
// resources of pods controlled by it.
type VerticalPodAutoscaling struct {
	// Enabled: Enables vertical pod autoscaling.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerticalPodAutoscaling) MarshalJSON() ([]byte, error) {
	type NoMethod VerticalPodAutoscaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VirtualNIC: Configuration of gVNIC feature.
type VirtualNIC struct {
	// Enabled: Whether gVNIC features are enabled in the node pool.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VirtualNIC) MarshalJSON() ([]byte, error) {
	type NoMethod VirtualNIC
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WindowsNodeConfig: Parameters that can be configured on Windows nodes.
// Windows Node Config that define the parameters that will be used to
// configure the Windows node pool settings.
type WindowsNodeConfig struct {
	// OsVersion: OSVersion specifies the Windows node config to be used on the
	// node.
	//
	// Possible values:
	//   "OS_VERSION_UNSPECIFIED" - When OSVersion is not specified
	//   "OS_VERSION_LTSC2019" - LTSC2019 specifies to use LTSC2019 as the Windows
	// Servercore Base Image.
	//   "OS_VERSION_LTSC2022" - LTSC2022 specifies to use LTSC2022 as the Windows
	// Servercore Base Image.
	OsVersion string `json:"osVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OsVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OsVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WindowsNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsNodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WindowsVersion: Windows server version.
type WindowsVersion struct {
	// ImageType: Windows server image type
	ImageType string `json:"imageType,omitempty"`
	// OsVersion: Windows server build number
	OsVersion string `json:"osVersion,omitempty"`
	// SupportEndDate: Mainstream support end date
	SupportEndDate *Date `json:"supportEndDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WindowsVersion) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WindowsVersions: Windows server versions.
type WindowsVersions struct {
	// WindowsVersions: List of Windows server versions.
	WindowsVersions []*WindowsVersion `json:"windowsVersions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WindowsVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WindowsVersions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WindowsVersions) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsVersions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadALTSConfig: Configuration for direct-path (via ALTS) with workload
// identity.
type WorkloadALTSConfig struct {
	// EnableAlts: enable_alts controls whether the alts handshaker should be
	// enabled or not for direct-path. Requires Workload Identity (workload_pool
	// must be non-empty).
	EnableAlts bool `json:"enableAlts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableAlts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableAlts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadALTSConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadALTSConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadCertificates: Configuration for issuance of mTLS keys and
// certificates to Kubernetes pods.
type WorkloadCertificates struct {
	// EnableCertificates: enable_certificates controls issuance of workload mTLS
	// certificates. If set, the GKE Workload Identity Certificates controller and
	// node agent will be deployed in the cluster, which can then be configured by
	// creating a WorkloadCertificateConfig Custom Resource. Requires Workload
	// Identity (workload_pool must be non-empty).
	EnableCertificates bool `json:"enableCertificates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableCertificates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableCertificates") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadCertificates) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadCertificates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadConfig: WorkloadConfig defines the flags to enable or disable the
// workload configurations for the cluster.
type WorkloadConfig struct {
	// AuditMode: Sets which mode of auditing should be used for the cluster's
	// workloads.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value meaning that no mode has been
	// specified.
	//   "DISABLED" - This disables Workload Configuration auditing on the cluster,
	// meaning that nothing is surfaced.
	//   "BASIC" - Applies the default set of policy auditing to a cluster's
	// workloads.
	//   "BASELINE" - Surfaces configurations that are not in line with the Pod
	// Security Standard Baseline policy.
	//   "RESTRICTED" - Surfaces configurations that are not in line with the Pod
	// Security Standard Restricted policy.
	AuditMode string `json:"auditMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadIdentityConfig: Configuration for the use of Kubernetes Service
// Accounts in GCP IAM policies.
type WorkloadIdentityConfig struct {
	// IdentityNamespace: IAM Identity Namespace to attach all Kubernetes Service
	// Accounts to.
	IdentityNamespace string `json:"identityNamespace,omitempty"`
	// IdentityProvider: identity provider is the third party identity provider.
	IdentityProvider string `json:"identityProvider,omitempty"`
	// WorkloadPool: The workload pool to attach all Kubernetes service accounts
	// to.
	WorkloadPool string `json:"workloadPool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdentityNamespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentityNamespace") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadIdentityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadIdentityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadMetadataConfig: WorkloadMetadataConfig defines the metadata
// configuration to expose to workloads on the node pool.
type WorkloadMetadataConfig struct {
	// Mode: Mode is the configuration for how to expose metadata to workloads
	// running on the node pool.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Not set.
	//   "GCE_METADATA" - Expose all Compute Engine metadata to pods.
	//   "GKE_METADATA" - Run the GKE Metadata Server on this node. The GKE
	// Metadata Server exposes a metadata API to workloads that is compatible with
	// the V1 Compute Metadata APIs exposed by the Compute Engine and App Engine
	// Metadata Servers. This feature can only be enabled if Workload Identity is
	// enabled at the cluster level.
	Mode string `json:"mode,omitempty"`
	// NodeMetadata: NodeMetadata is the configuration for how to expose metadata
	// to the workloads running on the node.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not set.
	//   "SECURE" - Prevent workloads not in hostNetwork from accessing certain VM
	// metadata, specifically kube-env, which contains Kubelet credentials, and the
	// instance identity token. Metadata concealment is a temporary security
	// solution available while the bootstrapping process for cluster nodes is
	// being redesigned with significant security improvements. This feature is
	// scheduled to be deprecated in the future and later removed.
	//   "EXPOSE" - Expose all VM metadata to pods.
	//   "GKE_METADATA_SERVER" - Run the GKE Metadata Server on this node. The GKE
	// Metadata Server exposes a metadata API to workloads that is compatible with
	// the V1 Compute Metadata APIs exposed by the Compute Engine and App Engine
	// Metadata Servers. This feature can only be enabled if Workload Identity is
	// enabled at the cluster level.
	NodeMetadata string `json:"nodeMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadMetadataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadMetadataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadPolicyConfig: WorkloadPolicyConfig is the configuration related to
// GCW workload policy
type WorkloadPolicyConfig struct {
	// AllowNetAdmin: If true, workloads can use NET_ADMIN capability.
	AllowNetAdmin bool `json:"allowNetAdmin,omitempty"`
	// AutopilotCompatibilityAuditingEnabled: If true, enables the GCW Auditor that
	// audits workloads on standard clusters.
	AutopilotCompatibilityAuditingEnabled bool `json:"autopilotCompatibilityAuditingEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowNetAdmin") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowNetAdmin") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadPolicyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadPolicyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsAggregatedUsableSubnetworksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists subnetworks that can be used for creating clusters in a project.
//
//   - parent: The parent project where subnetworks are usable. Specified in the
//     format `projects/*`.
func (r *ProjectsAggregatedUsableSubnetworksService) List(parent string) *ProjectsAggregatedUsableSubnetworksListCall {
	c := &ProjectsAggregatedUsableSubnetworksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering currently only
// supports equality on the networkProjectId and must be in the form:
// "networkProjectId=[PROJECTID]", where `networkProjectId` is the project
// which owns the listed subnetworks. This defaults to the parent project ID.
func (c *ProjectsAggregatedUsableSubnetworksListCall) Filter(filter string) *ProjectsAggregatedUsableSubnetworksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The max number of results
// per page that should be returned. If the number of available results is
// larger than `page_size`, a `next_page_token` is returned which can be used
// to get the next page of results in subsequent requests. Acceptable values
// are 0 to 500, inclusive. (Default: 500)
func (c *ProjectsAggregatedUsableSubnetworksListCall) PageSize(pageSize int64) *ProjectsAggregatedUsableSubnetworksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set this to the nextPageToken returned by previous list requests to get
// the next page of results.
func (c *ProjectsAggregatedUsableSubnetworksListCall) PageToken(pageToken string) *ProjectsAggregatedUsableSubnetworksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAggregatedUsableSubnetworksListCall) Fields(s ...googleapi.Field) *ProjectsAggregatedUsableSubnetworksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAggregatedUsableSubnetworksListCall) IfNoneMatch(entityTag string) *ProjectsAggregatedUsableSubnetworksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAggregatedUsableSubnetworksListCall) Context(ctx context.Context) *ProjectsAggregatedUsableSubnetworksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAggregatedUsableSubnetworksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAggregatedUsableSubnetworksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/aggregated/usableSubnetworks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.aggregated.usableSubnetworks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.aggregated.usableSubnetworks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUsableSubnetworksResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAggregatedUsableSubnetworksListCall) Do(opts ...googleapi.CallOption) (*ListUsableSubnetworksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUsableSubnetworksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.aggregated.usableSubnetworks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAggregatedUsableSubnetworksListCall) Pages(ctx context.Context, f func(*ListUsableSubnetworksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGetServerConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetServerConfig: Returns configuration info about the Google Kubernetes
// Engine service.
//
//   - name: The name (project and location) of the server config to get,
//     specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsService) GetServerConfig(name string) *ProjectsLocationsGetServerConfigCall {
	c := &ProjectsLocationsGetServerConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsGetServerConfigCall) ProjectId(projectId string) *ProjectsLocationsGetServerConfigCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// to return operations for. This field has been deprecated and replaced by the
// name field.
func (c *ProjectsLocationsGetServerConfigCall) Zone(zone string) *ProjectsLocationsGetServerConfigCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetServerConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetServerConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetServerConfigCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetServerConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetServerConfigCall) Context(ctx context.Context) *ProjectsLocationsGetServerConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetServerConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetServerConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/serverConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.getServerConfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.getServerConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *ServerConfig.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetServerConfigCall) Do(opts ...googleapi.CallOption) (*ServerConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ServerConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.getServerConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Fetches locations that offer Google Kubernetes Engine.
//
//   - parent: Contains the name of the resource requested. Specified in the
//     format `projects/*`.
func (r *ProjectsLocationsService) List(parent string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersCheckAutopilotCompatibilityCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CheckAutopilotCompatibility: Checks the cluster compatibility with Autopilot
// mode, and returns a list of compatibility issues.
//
//   - name: The name (project, location, cluster) of the cluster to retrieve.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) CheckAutopilotCompatibility(name string) *ProjectsLocationsClustersCheckAutopilotCompatibilityCall {
	c := &ProjectsLocationsClustersCheckAutopilotCompatibilityCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersCheckAutopilotCompatibilityCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersCheckAutopilotCompatibilityCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersCheckAutopilotCompatibilityCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersCheckAutopilotCompatibilityCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersCheckAutopilotCompatibilityCall) Context(ctx context.Context) *ProjectsLocationsClustersCheckAutopilotCompatibilityCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersCheckAutopilotCompatibilityCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersCheckAutopilotCompatibilityCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:checkAutopilotCompatibility")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.checkAutopilotCompatibility", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.checkAutopilotCompatibility" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckAutopilotCompatibilityResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersCheckAutopilotCompatibilityCall) Do(opts ...googleapi.CallOption) (*CheckAutopilotCompatibilityResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckAutopilotCompatibilityResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.checkAutopilotCompatibility", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersCompleteIpRotationCall struct {
	s                         *Service
	name                      string
	completeiprotationrequest *CompleteIPRotationRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// CompleteIpRotation: Completes master IP rotation.
//
//   - name: The name (project, location, cluster name) of the cluster to
//     complete IP rotation. Specified in the format
//     `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) CompleteIpRotation(name string, completeiprotationrequest *CompleteIPRotationRequest) *ProjectsLocationsClustersCompleteIpRotationCall {
	c := &ProjectsLocationsClustersCompleteIpRotationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.completeiprotationrequest = completeiprotationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersCompleteIpRotationCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersCompleteIpRotationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersCompleteIpRotationCall) Context(ctx context.Context) *ProjectsLocationsClustersCompleteIpRotationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersCompleteIpRotationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersCompleteIpRotationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.completeiprotationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:completeIpRotation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.completeIpRotation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.completeIpRotation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersCompleteIpRotationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.completeIpRotation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersCreateCall struct {
	s                    *Service
	parent               string
	createclusterrequest *CreateClusterRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Create: Creates a cluster, consisting of the specified number and type of
// Google Compute Engine instances. By default, the cluster is created in the
// project's default network
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/networks-and-firewalls#networks).
// One firewall is added for the cluster. After cluster creation, the Kubelet
// creates routes for each node to allow the containers on that node to
// communicate with all other instances in the cluster. Finally, an entry is
// added to the project's global metadata indicating which CIDR range the
// cluster is using.
//
//   - parent: The parent (project and location) where the cluster will be
//     created. Specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsClustersService) Create(parent string, createclusterrequest *CreateClusterRequest) *ProjectsLocationsClustersCreateCall {
	c := &ProjectsLocationsClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.createclusterrequest = createclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.createclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the cluster, including the Kubernetes endpoint and all
// worker nodes. Firewalls and routes that were configured during cluster
// creation are also deleted. Other Google Compute Engine resources that might
// be in use by the cluster, such as load balancer resources, are not deleted
// if they weren't present when the cluster was initially created.
//
//   - name: The name (project, location, cluster) of the cluster to delete.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) Delete(name string) *ProjectsLocationsClustersDeleteCall {
	c := &ProjectsLocationsClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ClusterId sets the optional parameter "clusterId": Deprecated. The name of
// the cluster to delete. This field has been deprecated and replaced by the
// name field.
func (c *ProjectsLocationsClustersDeleteCall) ClusterId(clusterId string) *ProjectsLocationsClustersDeleteCall {
	c.urlParams_.Set("clusterId", clusterId)
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsClustersDeleteCall) ProjectId(projectId string) *ProjectsLocationsClustersDeleteCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// in which the cluster resides. This field has been deprecated and replaced by
// the name field.
func (c *ProjectsLocationsClustersDeleteCall) Zone(zone string) *ProjectsLocationsClustersDeleteCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersDeleteCall) Context(ctx context.Context) *ProjectsLocationsClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersFetchClusterUpgradeInfoCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchClusterUpgradeInfo: Fetch upgrade information of a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to get.
//     Specified in the format `projects/*/locations/*/clusters/*` or
//     `projects/*/zones/*/clusters/*`.
func (r *ProjectsLocationsClustersService) FetchClusterUpgradeInfo(name string) *ProjectsLocationsClustersFetchClusterUpgradeInfoCall {
	c := &ProjectsLocationsClustersFetchClusterUpgradeInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Version sets the optional parameter "version": API request version that
// initiates this operation.
func (c *ProjectsLocationsClustersFetchClusterUpgradeInfoCall) Version(version string) *ProjectsLocationsClustersFetchClusterUpgradeInfoCall {
	c.urlParams_.Set("version", version)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersFetchClusterUpgradeInfoCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersFetchClusterUpgradeInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersFetchClusterUpgradeInfoCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersFetchClusterUpgradeInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersFetchClusterUpgradeInfoCall) Context(ctx context.Context) *ProjectsLocationsClustersFetchClusterUpgradeInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersFetchClusterUpgradeInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersFetchClusterUpgradeInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:fetchClusterUpgradeInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.fetchClusterUpgradeInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.fetchClusterUpgradeInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClusterUpgradeInfo.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClustersFetchClusterUpgradeInfoCall) Do(opts ...googleapi.CallOption) (*ClusterUpgradeInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClusterUpgradeInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.fetchClusterUpgradeInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details for a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to retrieve.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) Get(name string) *ProjectsLocationsClustersGetCall {
	c := &ProjectsLocationsClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ClusterId sets the optional parameter "clusterId": Deprecated. The name of
// the cluster to retrieve. This field has been deprecated and replaced by the
// name field.
func (c *ProjectsLocationsClustersGetCall) ClusterId(clusterId string) *ProjectsLocationsClustersGetCall {
	c.urlParams_.Set("clusterId", clusterId)
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsClustersGetCall) ProjectId(projectId string) *ProjectsLocationsClustersGetCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// in which the cluster resides. This field has been deprecated and replaced by
// the name field.
func (c *ProjectsLocationsClustersGetCall) Zone(zone string) *ProjectsLocationsClustersGetCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersGetCall) Context(ctx context.Context) *ProjectsLocationsClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Cluster.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersGetCall) Do(opts ...googleapi.CallOption) (*Cluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Cluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersGetJwksCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetJwks: Gets the public component of the cluster signing keys in JSON Web
// Key format.
//
//   - parent: The cluster (project, location, cluster name) to get keys for.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) GetJwks(parent string) *ProjectsLocationsClustersGetJwksCall {
	c := &ProjectsLocationsClustersGetJwksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersGetJwksCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersGetJwksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersGetJwksCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersGetJwksCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersGetJwksCall) Context(ctx context.Context) *ProjectsLocationsClustersGetJwksCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersGetJwksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersGetJwksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/jwks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.getJwks", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.getJwks" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetJSONWebKeysResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClustersGetJwksCall) Do(opts ...googleapi.CallOption) (*GetJSONWebKeysResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetJSONWebKeysResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.getJwks", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all clusters owned by a project in either the specified zone or
// all zones.
//
//   - parent: The parent (project and location) where the clusters will be
//     listed. Specified in the format `projects/*/locations/*`. Location "-"
//     matches all zones and all regions.
func (r *ProjectsLocationsClustersService) List(parent string) *ProjectsLocationsClustersListCall {
	c := &ProjectsLocationsClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the parent field.
func (c *ProjectsLocationsClustersListCall) ProjectId(projectId string) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// in which the cluster resides, or "-" for all zones. This field has been
// deprecated and replaced by the parent field.
func (c *ProjectsLocationsClustersListCall) Zone(zone string) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersListCall) Context(ctx context.Context) *ProjectsLocationsClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListClustersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClustersListCall) Do(opts ...googleapi.CallOption) (*ListClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetAddonsCall struct {
	s                      *Service
	name                   string
	setaddonsconfigrequest *SetAddonsConfigRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetAddons: Sets the addons for a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to set addons.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetAddons(name string, setaddonsconfigrequest *SetAddonsConfigRequest) *ProjectsLocationsClustersSetAddonsCall {
	c := &ProjectsLocationsClustersSetAddonsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setaddonsconfigrequest = setaddonsconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetAddonsCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetAddonsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetAddonsCall) Context(ctx context.Context) *ProjectsLocationsClustersSetAddonsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetAddonsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetAddonsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setaddonsconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setAddons")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setAddons", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setAddons" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetAddonsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setAddons", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetLegacyAbacCall struct {
	s                    *Service
	name                 string
	setlegacyabacrequest *SetLegacyAbacRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// SetLegacyAbac: Enables or disables the ABAC authorization mechanism on a
// cluster.
//
//   - name: The name (project, location, cluster name) of the cluster to set
//     legacy abac. Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetLegacyAbac(name string, setlegacyabacrequest *SetLegacyAbacRequest) *ProjectsLocationsClustersSetLegacyAbacCall {
	c := &ProjectsLocationsClustersSetLegacyAbacCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setlegacyabacrequest = setlegacyabacrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetLegacyAbacCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetLegacyAbacCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetLegacyAbacCall) Context(ctx context.Context) *ProjectsLocationsClustersSetLegacyAbacCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetLegacyAbacCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetLegacyAbacCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setlegacyabacrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setLegacyAbac")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setLegacyAbac", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setLegacyAbac" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetLegacyAbacCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setLegacyAbac", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetLocationsCall struct {
	s                   *Service
	name                string
	setlocationsrequest *SetLocationsRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetLocations: Sets the locations for a specific cluster. Deprecated. Use
// projects.locations.clusters.update
// (https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters/update)
// instead.
//
//   - name: The name (project, location, cluster) of the cluster to set
//     locations. Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetLocations(name string, setlocationsrequest *SetLocationsRequest) *ProjectsLocationsClustersSetLocationsCall {
	c := &ProjectsLocationsClustersSetLocationsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setlocationsrequest = setlocationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetLocationsCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetLocationsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetLocationsCall) Context(ctx context.Context) *ProjectsLocationsClustersSetLocationsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetLocationsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetLocationsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setlocationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setLocations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setLocations", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setLocations" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetLocationsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setLocations", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetLoggingCall struct {
	s                        *Service
	name                     string
	setloggingservicerequest *SetLoggingServiceRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// SetLogging: Sets the logging service for a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to set logging.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetLogging(name string, setloggingservicerequest *SetLoggingServiceRequest) *ProjectsLocationsClustersSetLoggingCall {
	c := &ProjectsLocationsClustersSetLoggingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setloggingservicerequest = setloggingservicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetLoggingCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetLoggingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetLoggingCall) Context(ctx context.Context) *ProjectsLocationsClustersSetLoggingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetLoggingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetLoggingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setloggingservicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setLogging")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setLogging", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setLogging" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetLoggingCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setLogging", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetMaintenancePolicyCall struct {
	s                           *Service
	name                        string
	setmaintenancepolicyrequest *SetMaintenancePolicyRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// SetMaintenancePolicy: Sets the maintenance policy for a cluster.
//
//   - name: The name (project, location, cluster name) of the cluster to set
//     maintenance policy. Specified in the format
//     `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetMaintenancePolicy(name string, setmaintenancepolicyrequest *SetMaintenancePolicyRequest) *ProjectsLocationsClustersSetMaintenancePolicyCall {
	c := &ProjectsLocationsClustersSetMaintenancePolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setmaintenancepolicyrequest = setmaintenancepolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetMaintenancePolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetMaintenancePolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetMaintenancePolicyCall) Context(ctx context.Context) *ProjectsLocationsClustersSetMaintenancePolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetMaintenancePolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetMaintenancePolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setmaintenancepolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setMaintenancePolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setMaintenancePolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setMaintenancePolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetMaintenancePolicyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setMaintenancePolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetMasterAuthCall struct {
	s                    *Service
	name                 string
	setmasterauthrequest *SetMasterAuthRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// SetMasterAuth: Sets master auth materials. Currently supports changing the
// admin password or a specific cluster, either via password generation or
// explicitly setting the password.
//
//   - name: The name (project, location, cluster) of the cluster to set auth.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetMasterAuth(name string, setmasterauthrequest *SetMasterAuthRequest) *ProjectsLocationsClustersSetMasterAuthCall {
	c := &ProjectsLocationsClustersSetMasterAuthCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setmasterauthrequest = setmasterauthrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetMasterAuthCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetMasterAuthCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetMasterAuthCall) Context(ctx context.Context) *ProjectsLocationsClustersSetMasterAuthCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetMasterAuthCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetMasterAuthCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setmasterauthrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setMasterAuth")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setMasterAuth", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setMasterAuth" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetMasterAuthCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setMasterAuth", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetMonitoringCall struct {
	s                           *Service
	name                        string
	setmonitoringservicerequest *SetMonitoringServiceRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// SetMonitoring: Sets the monitoring service for a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to set
//     monitoring. Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetMonitoring(name string, setmonitoringservicerequest *SetMonitoringServiceRequest) *ProjectsLocationsClustersSetMonitoringCall {
	c := &ProjectsLocationsClustersSetMonitoringCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setmonitoringservicerequest = setmonitoringservicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetMonitoringCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetMonitoringCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetMonitoringCall) Context(ctx context.Context) *ProjectsLocationsClustersSetMonitoringCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetMonitoringCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetMonitoringCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setmonitoringservicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setMonitoring")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setMonitoring", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setMonitoring" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetMonitoringCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setMonitoring", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetNetworkPolicyCall struct {
	s                       *Service
	name                    string
	setnetworkpolicyrequest *SetNetworkPolicyRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// SetNetworkPolicy: Enables or disables Network Policy for a cluster.
//
//   - name: The name (project, location, cluster name) of the cluster to set
//     networking policy. Specified in the format
//     `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetNetworkPolicy(name string, setnetworkpolicyrequest *SetNetworkPolicyRequest) *ProjectsLocationsClustersSetNetworkPolicyCall {
	c := &ProjectsLocationsClustersSetNetworkPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setnetworkpolicyrequest = setnetworkpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetNetworkPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetNetworkPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetNetworkPolicyCall) Context(ctx context.Context) *ProjectsLocationsClustersSetNetworkPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetNetworkPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetNetworkPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnetworkpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setNetworkPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setNetworkPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setNetworkPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetNetworkPolicyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setNetworkPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersSetResourceLabelsCall struct {
	s                *Service
	name             string
	setlabelsrequest *SetLabelsRequest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// SetResourceLabels: Sets labels on a cluster.
//
//   - name: The name (project, location, cluster name) of the cluster to set
//     labels. Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) SetResourceLabels(name string, setlabelsrequest *SetLabelsRequest) *ProjectsLocationsClustersSetResourceLabelsCall {
	c := &ProjectsLocationsClustersSetResourceLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setlabelsrequest = setlabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersSetResourceLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersSetResourceLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersSetResourceLabelsCall) Context(ctx context.Context) *ProjectsLocationsClustersSetResourceLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersSetResourceLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersSetResourceLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setlabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setResourceLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setResourceLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.setResourceLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersSetResourceLabelsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.setResourceLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersStartIpRotationCall struct {
	s                      *Service
	name                   string
	startiprotationrequest *StartIPRotationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// StartIpRotation: Starts master IP rotation.
//
//   - name: The name (project, location, cluster name) of the cluster to start
//     IP rotation. Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) StartIpRotation(name string, startiprotationrequest *StartIPRotationRequest) *ProjectsLocationsClustersStartIpRotationCall {
	c := &ProjectsLocationsClustersStartIpRotationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.startiprotationrequest = startiprotationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersStartIpRotationCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersStartIpRotationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersStartIpRotationCall) Context(ctx context.Context) *ProjectsLocationsClustersStartIpRotationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersStartIpRotationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersStartIpRotationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.startiprotationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:startIpRotation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.startIpRotation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.startIpRotation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersStartIpRotationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.startIpRotation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersUpdateCall struct {
	s                    *Service
	name                 string
	updateclusterrequest *UpdateClusterRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Update: Updates the settings for a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to update.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) Update(name string, updateclusterrequest *UpdateClusterRequest) *ProjectsLocationsClustersUpdateCall {
	c := &ProjectsLocationsClustersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.updateclusterrequest = updateclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersUpdateCall) Context(ctx context.Context) *ProjectsLocationsClustersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updateclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersUpdateMasterCall struct {
	s                   *Service
	name                string
	updatemasterrequest *UpdateMasterRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// UpdateMaster: Updates the master for a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to update.
//     Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersService) UpdateMaster(name string, updatemasterrequest *UpdateMasterRequest) *ProjectsLocationsClustersUpdateMasterCall {
	c := &ProjectsLocationsClustersUpdateMasterCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.updatemasterrequest = updatemasterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersUpdateMasterCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersUpdateMasterCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersUpdateMasterCall) Context(ctx context.Context) *ProjectsLocationsClustersUpdateMasterCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersUpdateMasterCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersUpdateMasterCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updatemasterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:updateMaster")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.updateMaster", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.updateMaster" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersUpdateMasterCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.updateMaster", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsCompleteUpgradeCall struct {
	s                              *Service
	name                           string
	completenodepoolupgraderequest *CompleteNodePoolUpgradeRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// CompleteUpgrade: CompleteNodePoolUpgrade will signal an on-going node pool
// upgrade to complete.
//
//   - name: The name (project, location, cluster, node pool id) of the node pool
//     to complete upgrade. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) CompleteUpgrade(name string, completenodepoolupgraderequest *CompleteNodePoolUpgradeRequest) *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall {
	c := &ProjectsLocationsClustersNodePoolsCompleteUpgradeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.completenodepoolupgraderequest = completenodepoolupgraderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.completenodepoolupgraderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:completeUpgrade")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.completeUpgrade", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.completeUpgrade" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsCompleteUpgradeCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.completeUpgrade", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsCreateCall struct {
	s                     *Service
	parent                string
	createnodepoolrequest *CreateNodePoolRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Create: Creates a node pool for a cluster.
//
//   - parent: The parent (project, location, cluster name) where the node pool
//     will be created. Specified in the format
//     `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersNodePoolsService) Create(parent string, createnodepoolrequest *CreateNodePoolRequest) *ProjectsLocationsClustersNodePoolsCreateCall {
	c := &ProjectsLocationsClustersNodePoolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.createnodepoolrequest = createnodepoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsCreateCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.createnodepoolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/nodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a node pool from a cluster.
//
//   - name: The name (project, location, cluster, node pool id) of the node pool
//     to delete. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) Delete(name string) *ProjectsLocationsClustersNodePoolsDeleteCall {
	c := &ProjectsLocationsClustersNodePoolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ClusterId sets the optional parameter "clusterId": Deprecated. The name of
// the cluster. This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) ClusterId(clusterId string) *ProjectsLocationsClustersNodePoolsDeleteCall {
	c.urlParams_.Set("clusterId", clusterId)
	return c
}

// NodePoolId sets the optional parameter "nodePoolId": Deprecated. The name of
// the node pool to delete. This field has been deprecated and replaced by the
// name field.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) NodePoolId(nodePoolId string) *ProjectsLocationsClustersNodePoolsDeleteCall {
	c.urlParams_.Set("nodePoolId", nodePoolId)
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) ProjectId(projectId string) *ProjectsLocationsClustersNodePoolsDeleteCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// in which the cluster resides. This field has been deprecated and replaced by
// the name field.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) Zone(zone string) *ProjectsLocationsClustersNodePoolsDeleteCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchNodePoolUpgradeInfo: Fetch upgrade information of a specific nodepool.
//
//   - name: The name (project, location, cluster, nodepool) of the nodepool to
//     get. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*` or
//     `projects/*/zones/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) FetchNodePoolUpgradeInfo(name string) *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c := &ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Version sets the optional parameter "version": API request version that
// initiates this operation.
func (c *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall) Version(version string) *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.urlParams_.Set("version", version)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:fetchNodePoolUpgradeInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.fetchNodePoolUpgradeInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.fetchNodePoolUpgradeInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *NodePoolUpgradeInfo.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClustersNodePoolsFetchNodePoolUpgradeInfoCall) Do(opts ...googleapi.CallOption) (*NodePoolUpgradeInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NodePoolUpgradeInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.fetchNodePoolUpgradeInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the requested node pool.
//
//   - name: The name (project, location, cluster, node pool id) of the node pool
//     to get. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) Get(name string) *ProjectsLocationsClustersNodePoolsGetCall {
	c := &ProjectsLocationsClustersNodePoolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ClusterId sets the optional parameter "clusterId": Deprecated. The name of
// the cluster. This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsClustersNodePoolsGetCall) ClusterId(clusterId string) *ProjectsLocationsClustersNodePoolsGetCall {
	c.urlParams_.Set("clusterId", clusterId)
	return c
}

// NodePoolId sets the optional parameter "nodePoolId": Deprecated. The name of
// the node pool. This field has been deprecated and replaced by the name
// field.
func (c *ProjectsLocationsClustersNodePoolsGetCall) NodePoolId(nodePoolId string) *ProjectsLocationsClustersNodePoolsGetCall {
	c.urlParams_.Set("nodePoolId", nodePoolId)
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsClustersNodePoolsGetCall) ProjectId(projectId string) *ProjectsLocationsClustersNodePoolsGetCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// in which the cluster resides. This field has been deprecated and replaced by
// the name field.
func (c *ProjectsLocationsClustersNodePoolsGetCall) Zone(zone string) *ProjectsLocationsClustersNodePoolsGetCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersNodePoolsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersNodePoolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsGetCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *NodePool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsGetCall) Do(opts ...googleapi.CallOption) (*NodePool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NodePool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the node pools for a cluster.
//
//   - parent: The parent (project, location, cluster name) where the node pools
//     will be listed. Specified in the format
//     `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersNodePoolsService) List(parent string) *ProjectsLocationsClustersNodePoolsListCall {
	c := &ProjectsLocationsClustersNodePoolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// ClusterId sets the optional parameter "clusterId": Deprecated. The name of
// the cluster. This field has been deprecated and replaced by the parent
// field.
func (c *ProjectsLocationsClustersNodePoolsListCall) ClusterId(clusterId string) *ProjectsLocationsClustersNodePoolsListCall {
	c.urlParams_.Set("clusterId", clusterId)
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the parent field.
func (c *ProjectsLocationsClustersNodePoolsListCall) ProjectId(projectId string) *ProjectsLocationsClustersNodePoolsListCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// in which the cluster resides. This field has been deprecated and replaced by
// the parent field.
func (c *ProjectsLocationsClustersNodePoolsListCall) Zone(zone string) *ProjectsLocationsClustersNodePoolsListCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersNodePoolsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersNodePoolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsListCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/nodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListNodePoolsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClustersNodePoolsListCall) Do(opts ...googleapi.CallOption) (*ListNodePoolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListNodePoolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsRollbackCall struct {
	s                              *Service
	name                           string
	rollbacknodepoolupgraderequest *RollbackNodePoolUpgradeRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Rollback: Rolls back a previously Aborted or Failed NodePool upgrade. This
// makes no changes if the last upgrade successfully completed.
//
//   - name: The name (project, location, cluster, node pool id) of the node poll
//     to rollback upgrade. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) Rollback(name string, rollbacknodepoolupgraderequest *RollbackNodePoolUpgradeRequest) *ProjectsLocationsClustersNodePoolsRollbackCall {
	c := &ProjectsLocationsClustersNodePoolsRollbackCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rollbacknodepoolupgraderequest = rollbacknodepoolupgraderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsRollbackCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsRollbackCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsRollbackCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsRollbackCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsRollbackCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsRollbackCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rollbacknodepoolupgraderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:rollback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.rollback", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.rollback" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsRollbackCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.rollback", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsSetAutoscalingCall struct {
	s                             *Service
	name                          string
	setnodepoolautoscalingrequest *SetNodePoolAutoscalingRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// SetAutoscaling: Sets the autoscaling settings of a specific node pool.
//
//   - name: The name (project, location, cluster, node pool) of the node pool to
//     set autoscaler settings. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) SetAutoscaling(name string, setnodepoolautoscalingrequest *SetNodePoolAutoscalingRequest) *ProjectsLocationsClustersNodePoolsSetAutoscalingCall {
	c := &ProjectsLocationsClustersNodePoolsSetAutoscalingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setnodepoolautoscalingrequest = setnodepoolautoscalingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsSetAutoscalingCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsSetAutoscalingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsSetAutoscalingCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsSetAutoscalingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsSetAutoscalingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsSetAutoscalingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnodepoolautoscalingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setAutoscaling")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.setAutoscaling", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.setAutoscaling" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsSetAutoscalingCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.setAutoscaling", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsSetManagementCall struct {
	s                            *Service
	name                         string
	setnodepoolmanagementrequest *SetNodePoolManagementRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// SetManagement: Sets the NodeManagement options for a node pool.
//
//   - name: The name (project, location, cluster, node pool id) of the node pool
//     to set management properties. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) SetManagement(name string, setnodepoolmanagementrequest *SetNodePoolManagementRequest) *ProjectsLocationsClustersNodePoolsSetManagementCall {
	c := &ProjectsLocationsClustersNodePoolsSetManagementCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setnodepoolmanagementrequest = setnodepoolmanagementrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsSetManagementCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsSetManagementCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsSetManagementCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsSetManagementCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsSetManagementCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsSetManagementCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnodepoolmanagementrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setManagement")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.setManagement", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.setManagement" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsSetManagementCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.setManagement", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsSetSizeCall struct {
	s                      *Service
	name                   string
	setnodepoolsizerequest *SetNodePoolSizeRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetSize: SetNodePoolSizeRequest sets the size of a node pool. The new size
// will be used for all replicas, including future replicas created by
// modifying NodePool.locations.
//
//   - name: The name (project, location, cluster, node pool id) of the node pool
//     to set size. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) SetSize(name string, setnodepoolsizerequest *SetNodePoolSizeRequest) *ProjectsLocationsClustersNodePoolsSetSizeCall {
	c := &ProjectsLocationsClustersNodePoolsSetSizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setnodepoolsizerequest = setnodepoolsizerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsSetSizeCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsSetSizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsSetSizeCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsSetSizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsSetSizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsSetSizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnodepoolsizerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:setSize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.setSize", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.setSize" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsSetSizeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.setSize", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersNodePoolsUpdateCall struct {
	s                     *Service
	name                  string
	updatenodepoolrequest *UpdateNodePoolRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Update: Updates the version and/or image type of a specific node pool.
//
//   - name: The name (project, location, cluster, node pool) of the node pool to
//     update. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*`.
func (r *ProjectsLocationsClustersNodePoolsService) Update(name string, updatenodepoolrequest *UpdateNodePoolRequest) *ProjectsLocationsClustersNodePoolsUpdateCall {
	c := &ProjectsLocationsClustersNodePoolsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.updatenodepoolrequest = updatenodepoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersNodePoolsUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersNodePoolsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersNodePoolsUpdateCall) Context(ctx context.Context) *ProjectsLocationsClustersNodePoolsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersNodePoolsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersNodePoolsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updatenodepoolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.nodePools.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersNodePoolsUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.nodePools.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetOpenidConfiguration: Gets the OIDC discovery document for the cluster.
// See the OpenID Connect Discovery 1.0 specification
// (https://openid.net/specs/openid-connect-discovery-1_0.html) for details.
//
//   - parent: The cluster (project, location, cluster name) to get the discovery
//     document for. Specified in the format `projects/*/locations/*/clusters/*`.
func (r *ProjectsLocationsClustersWellKnownService) GetOpenidConfiguration(parent string) *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall {
	c := &ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall) Context(ctx context.Context) *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/.well-known/openid-configuration")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.well-known.getOpenid-configuration", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.clusters.well-known.getOpenid-configuration" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetOpenIDConfigResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersWellKnownGetOpenidConfigurationCall) Do(opts ...googleapi.CallOption) (*GetOpenIDConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetOpenIDConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.clusters.well-known.getOpenid-configuration", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Cancels the specified operation.
//
//   - name: The name (project, location, operation id) of the operation to
//     cancel. Specified in the format `projects/*/locations/*/operations/*`.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified operation.
//
//   - name: The name (project, location, operation id) of the operation to get.
//     Specified in the format `projects/*/locations/*/operations/*`.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// OperationId sets the optional parameter "operationId": Deprecated. The
// server-assigned `name` of the operation. This field has been deprecated and
// replaced by the name field.
func (c *ProjectsLocationsOperationsGetCall) OperationId(operationId string) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("operationId", operationId)
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the name field.
func (c *ProjectsLocationsOperationsGetCall) ProjectId(projectId string) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// in which the cluster resides. This field has been deprecated and replaced by
// the name field.
func (c *ProjectsLocationsOperationsGetCall) Zone(zone string) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all operations in a project in the specified zone or all zones.
//
//   - parent: The parent (project and location) where the operations will be
//     listed. Specified in the format `projects/*/locations/*`. Location "-"
//     matches all zones and all regions.
func (r *ProjectsLocationsOperationsService) List(parent string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// ProjectId sets the optional parameter "projectId": Deprecated. The Google
// Developers Console project ID or project number
// (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
// This field has been deprecated and replaced by the parent field.
func (c *ProjectsLocationsOperationsListCall) ProjectId(projectId string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Zone sets the optional parameter "zone": Deprecated. The name of the Google
// Compute Engine zone
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
// to return operations for, or `-` for all zones. This field has been
// deprecated and replaced by the parent field.
func (c *ProjectsLocationsOperationsListCall) Zone(zone string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("zone", zone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesGetServerconfigCall struct {
	s            *Service
	projectId    string
	zone         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetServerconfig: Returns configuration info about the Google Kubernetes
// Engine service.
//
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     to return operations for. This field has been deprecated and replaced by
//     the name field.
func (r *ProjectsZonesService) GetServerconfig(projectId string, zone string) *ProjectsZonesGetServerconfigCall {
	c := &ProjectsZonesGetServerconfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	return c
}

// Name sets the optional parameter "name": The name (project and location) of
// the server config to get, specified in the format `projects/*/locations/*`.
func (c *ProjectsZonesGetServerconfigCall) Name(name string) *ProjectsZonesGetServerconfigCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesGetServerconfigCall) Fields(s ...googleapi.Field) *ProjectsZonesGetServerconfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesGetServerconfigCall) IfNoneMatch(entityTag string) *ProjectsZonesGetServerconfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesGetServerconfigCall) Context(ctx context.Context) *ProjectsZonesGetServerconfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesGetServerconfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesGetServerconfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/serverconfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.getServerconfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.getServerconfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *ServerConfig.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesGetServerconfigCall) Do(opts ...googleapi.CallOption) (*ServerConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ServerConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.getServerconfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersAddonsCall struct {
	s                      *Service
	projectId              string
	zone                   string
	clusterId              string
	setaddonsconfigrequest *SetAddonsConfigRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Addons: Sets the addons for a specific cluster.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Addons(projectId string, zone string, clusterId string, setaddonsconfigrequest *SetAddonsConfigRequest) *ProjectsZonesClustersAddonsCall {
	c := &ProjectsZonesClustersAddonsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setaddonsconfigrequest = setaddonsconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersAddonsCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersAddonsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersAddonsCall) Context(ctx context.Context) *ProjectsZonesClustersAddonsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersAddonsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersAddonsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setaddonsconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.addons", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.addons" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersAddonsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.addons", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersCompleteIpRotationCall struct {
	s                         *Service
	projectId                 string
	zone                      string
	clusterId                 string
	completeiprotationrequest *CompleteIPRotationRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// CompleteIpRotation: Completes master IP rotation.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) CompleteIpRotation(projectId string, zone string, clusterId string, completeiprotationrequest *CompleteIPRotationRequest) *ProjectsZonesClustersCompleteIpRotationCall {
	c := &ProjectsZonesClustersCompleteIpRotationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.completeiprotationrequest = completeiprotationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersCompleteIpRotationCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersCompleteIpRotationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersCompleteIpRotationCall) Context(ctx context.Context) *ProjectsZonesClustersCompleteIpRotationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersCompleteIpRotationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersCompleteIpRotationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.completeiprotationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.completeIpRotation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.completeIpRotation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersCompleteIpRotationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.completeIpRotation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersCreateCall struct {
	s                    *Service
	projectId            string
	zone                 string
	createclusterrequest *CreateClusterRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Create: Creates a cluster, consisting of the specified number and type of
// Google Compute Engine instances. By default, the cluster is created in the
// project's default network
// (https://{$universe.dns_names.final_documentation_domain}/compute/docs/networks-and-firewalls#networks).
// One firewall is added for the cluster. After cluster creation, the Kubelet
// creates routes for each node to allow the containers on that node to
// communicate with all other instances in the cluster. Finally, an entry is
// added to the project's global metadata indicating which CIDR range the
// cluster is using.
//
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the parent field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the parent field.
func (r *ProjectsZonesClustersService) Create(projectId string, zone string, createclusterrequest *CreateClusterRequest) *ProjectsZonesClustersCreateCall {
	c := &ProjectsZonesClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.createclusterrequest = createclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersCreateCall) Context(ctx context.Context) *ProjectsZonesClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.createclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersDeleteCall struct {
	s          *Service
	projectId  string
	zone       string
	clusterId  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the cluster, including the Kubernetes endpoint and all
// worker nodes. Firewalls and routes that were configured during cluster
// creation are also deleted. Other Google Compute Engine resources that might
// be in use by the cluster, such as load balancer resources, are not deleted
// if they weren't present when the cluster was initially created.
//
//   - clusterId: Deprecated. The name of the cluster to delete. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Delete(projectId string, zone string, clusterId string) *ProjectsZonesClustersDeleteCall {
	c := &ProjectsZonesClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	return c
}

// Name sets the optional parameter "name": The name (project, location,
// cluster) of the cluster to delete. Specified in the format
// `projects/*/locations/*/clusters/*`.
func (c *ProjectsZonesClustersDeleteCall) Name(name string) *ProjectsZonesClustersDeleteCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersDeleteCall) Context(ctx context.Context) *ProjectsZonesClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersFetchClusterUpgradeInfoCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchClusterUpgradeInfo: Fetch upgrade information of a specific cluster.
//
//   - name: The name (project, location, cluster) of the cluster to get.
//     Specified in the format `projects/*/locations/*/clusters/*` or
//     `projects/*/zones/*/clusters/*`.
func (r *ProjectsZonesClustersService) FetchClusterUpgradeInfo(name string) *ProjectsZonesClustersFetchClusterUpgradeInfoCall {
	c := &ProjectsZonesClustersFetchClusterUpgradeInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Version sets the optional parameter "version": API request version that
// initiates this operation.
func (c *ProjectsZonesClustersFetchClusterUpgradeInfoCall) Version(version string) *ProjectsZonesClustersFetchClusterUpgradeInfoCall {
	c.urlParams_.Set("version", version)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersFetchClusterUpgradeInfoCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersFetchClusterUpgradeInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesClustersFetchClusterUpgradeInfoCall) IfNoneMatch(entityTag string) *ProjectsZonesClustersFetchClusterUpgradeInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersFetchClusterUpgradeInfoCall) Context(ctx context.Context) *ProjectsZonesClustersFetchClusterUpgradeInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersFetchClusterUpgradeInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersFetchClusterUpgradeInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:fetchClusterUpgradeInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.fetchClusterUpgradeInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.fetchClusterUpgradeInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClusterUpgradeInfo.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsZonesClustersFetchClusterUpgradeInfoCall) Do(opts ...googleapi.CallOption) (*ClusterUpgradeInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClusterUpgradeInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.fetchClusterUpgradeInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersGetCall struct {
	s            *Service
	projectId    string
	zone         string
	clusterId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details for a specific cluster.
//
//   - clusterId: Deprecated. The name of the cluster to retrieve. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Get(projectId string, zone string, clusterId string) *ProjectsZonesClustersGetCall {
	c := &ProjectsZonesClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	return c
}

// Name sets the optional parameter "name": The name (project, location,
// cluster) of the cluster to retrieve. Specified in the format
// `projects/*/locations/*/clusters/*`.
func (c *ProjectsZonesClustersGetCall) Name(name string) *ProjectsZonesClustersGetCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersGetCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesClustersGetCall) IfNoneMatch(entityTag string) *ProjectsZonesClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersGetCall) Context(ctx context.Context) *ProjectsZonesClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Cluster.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersGetCall) Do(opts ...googleapi.CallOption) (*Cluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Cluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersLegacyAbacCall struct {
	s                    *Service
	projectId            string
	zone                 string
	clusterId            string
	setlegacyabacrequest *SetLegacyAbacRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// LegacyAbac: Enables or disables the ABAC authorization mechanism on a
// cluster.
//
//   - clusterId: Deprecated. The name of the cluster to update. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) LegacyAbac(projectId string, zone string, clusterId string, setlegacyabacrequest *SetLegacyAbacRequest) *ProjectsZonesClustersLegacyAbacCall {
	c := &ProjectsZonesClustersLegacyAbacCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setlegacyabacrequest = setlegacyabacrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersLegacyAbacCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersLegacyAbacCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersLegacyAbacCall) Context(ctx context.Context) *ProjectsZonesClustersLegacyAbacCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersLegacyAbacCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersLegacyAbacCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setlegacyabacrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.legacyAbac", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.legacyAbac" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersLegacyAbacCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.legacyAbac", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersListCall struct {
	s            *Service
	projectId    string
	zone         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all clusters owned by a project in either the specified zone or
// all zones.
//
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the parent field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides, or "-" for all zones. This field has been
//     deprecated and replaced by the parent field.
func (r *ProjectsZonesClustersService) List(projectId string, zone string) *ProjectsZonesClustersListCall {
	c := &ProjectsZonesClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	return c
}

// Parent sets the optional parameter "parent": The parent (project and
// location) where the clusters will be listed. Specified in the format
// `projects/*/locations/*`. Location "-" matches all zones and all regions.
func (c *ProjectsZonesClustersListCall) Parent(parent string) *ProjectsZonesClustersListCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersListCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesClustersListCall) IfNoneMatch(entityTag string) *ProjectsZonesClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersListCall) Context(ctx context.Context) *ProjectsZonesClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListClustersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsZonesClustersListCall) Do(opts ...googleapi.CallOption) (*ListClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersLocationsCall struct {
	s                   *Service
	projectId           string
	zone                string
	clusterId           string
	setlocationsrequest *SetLocationsRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Locations: Sets the locations for a specific cluster. Deprecated. Use
// projects.locations.clusters.update
// (https://{$universe.dns_names.final_documentation_domain}/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters/update)
// instead.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Locations(projectId string, zone string, clusterId string, setlocationsrequest *SetLocationsRequest) *ProjectsZonesClustersLocationsCall {
	c := &ProjectsZonesClustersLocationsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setlocationsrequest = setlocationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersLocationsCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersLocationsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersLocationsCall) Context(ctx context.Context) *ProjectsZonesClustersLocationsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersLocationsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersLocationsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setlocationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.locations", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.locations" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersLocationsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.locations", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersLoggingCall struct {
	s                        *Service
	projectId                string
	zone                     string
	clusterId                string
	setloggingservicerequest *SetLoggingServiceRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Logging: Sets the logging service for a specific cluster.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Logging(projectId string, zone string, clusterId string, setloggingservicerequest *SetLoggingServiceRequest) *ProjectsZonesClustersLoggingCall {
	c := &ProjectsZonesClustersLoggingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setloggingservicerequest = setloggingservicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersLoggingCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersLoggingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersLoggingCall) Context(ctx context.Context) *ProjectsZonesClustersLoggingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersLoggingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersLoggingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setloggingservicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.logging", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.logging" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersLoggingCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.logging", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersMasterCall struct {
	s                   *Service
	projectId           string
	zone                string
	clusterId           string
	updatemasterrequest *UpdateMasterRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Master: Updates the master for a specific cluster.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Master(projectId string, zone string, clusterId string, updatemasterrequest *UpdateMasterRequest) *ProjectsZonesClustersMasterCall {
	c := &ProjectsZonesClustersMasterCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.updatemasterrequest = updatemasterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersMasterCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersMasterCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersMasterCall) Context(ctx context.Context) *ProjectsZonesClustersMasterCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersMasterCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersMasterCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updatemasterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.master", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.master" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersMasterCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.master", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersMonitoringCall struct {
	s                           *Service
	projectId                   string
	zone                        string
	clusterId                   string
	setmonitoringservicerequest *SetMonitoringServiceRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Monitoring: Sets the monitoring service for a specific cluster.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Monitoring(projectId string, zone string, clusterId string, setmonitoringservicerequest *SetMonitoringServiceRequest) *ProjectsZonesClustersMonitoringCall {
	c := &ProjectsZonesClustersMonitoringCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setmonitoringservicerequest = setmonitoringservicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersMonitoringCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersMonitoringCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersMonitoringCall) Context(ctx context.Context) *ProjectsZonesClustersMonitoringCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersMonitoringCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersMonitoringCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setmonitoringservicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.monitoring", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.monitoring" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersMonitoringCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.monitoring", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersResourceLabelsCall struct {
	s                *Service
	projectId        string
	zone             string
	clusterId        string
	setlabelsrequest *SetLabelsRequest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// ResourceLabels: Sets labels on a cluster.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) ResourceLabels(projectId string, zone string, clusterId string, setlabelsrequest *SetLabelsRequest) *ProjectsZonesClustersResourceLabelsCall {
	c := &ProjectsZonesClustersResourceLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setlabelsrequest = setlabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersResourceLabelsCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersResourceLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersResourceLabelsCall) Context(ctx context.Context) *ProjectsZonesClustersResourceLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersResourceLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersResourceLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setlabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.resourceLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.resourceLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersResourceLabelsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.resourceLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersSetMaintenancePolicyCall struct {
	s                           *Service
	projectId                   string
	zone                        string
	clusterId                   string
	setmaintenancepolicyrequest *SetMaintenancePolicyRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// SetMaintenancePolicy: Sets the maintenance policy for a cluster.
//
//   - clusterId: The name of the cluster to update.
//   - projectId: The Google Developers Console project ID or project number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//   - zone: The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides.
func (r *ProjectsZonesClustersService) SetMaintenancePolicy(projectId string, zone string, clusterId string, setmaintenancepolicyrequest *SetMaintenancePolicyRequest) *ProjectsZonesClustersSetMaintenancePolicyCall {
	c := &ProjectsZonesClustersSetMaintenancePolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setmaintenancepolicyrequest = setmaintenancepolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersSetMaintenancePolicyCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersSetMaintenancePolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersSetMaintenancePolicyCall) Context(ctx context.Context) *ProjectsZonesClustersSetMaintenancePolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersSetMaintenancePolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersSetMaintenancePolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setmaintenancepolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.setMaintenancePolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.setMaintenancePolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersSetMaintenancePolicyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.setMaintenancePolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersSetMasterAuthCall struct {
	s                    *Service
	projectId            string
	zone                 string
	clusterId            string
	setmasterauthrequest *SetMasterAuthRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// SetMasterAuth: Sets master auth materials. Currently supports changing the
// admin password or a specific cluster, either via password generation or
// explicitly setting the password.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) SetMasterAuth(projectId string, zone string, clusterId string, setmasterauthrequest *SetMasterAuthRequest) *ProjectsZonesClustersSetMasterAuthCall {
	c := &ProjectsZonesClustersSetMasterAuthCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setmasterauthrequest = setmasterauthrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersSetMasterAuthCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersSetMasterAuthCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersSetMasterAuthCall) Context(ctx context.Context) *ProjectsZonesClustersSetMasterAuthCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersSetMasterAuthCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersSetMasterAuthCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setmasterauthrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.setMasterAuth", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.setMasterAuth" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersSetMasterAuthCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.setMasterAuth", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersSetNetworkPolicyCall struct {
	s                       *Service
	projectId               string
	zone                    string
	clusterId               string
	setnetworkpolicyrequest *SetNetworkPolicyRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// SetNetworkPolicy: Enables or disables Network Policy for a cluster.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) SetNetworkPolicy(projectId string, zone string, clusterId string, setnetworkpolicyrequest *SetNetworkPolicyRequest) *ProjectsZonesClustersSetNetworkPolicyCall {
	c := &ProjectsZonesClustersSetNetworkPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.setnetworkpolicyrequest = setnetworkpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersSetNetworkPolicyCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersSetNetworkPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersSetNetworkPolicyCall) Context(ctx context.Context) *ProjectsZonesClustersSetNetworkPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersSetNetworkPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersSetNetworkPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnetworkpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.setNetworkPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.setNetworkPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersSetNetworkPolicyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.setNetworkPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersStartIpRotationCall struct {
	s                      *Service
	projectId              string
	zone                   string
	clusterId              string
	startiprotationrequest *StartIPRotationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// StartIpRotation: Starts master IP rotation.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) StartIpRotation(projectId string, zone string, clusterId string, startiprotationrequest *StartIPRotationRequest) *ProjectsZonesClustersStartIpRotationCall {
	c := &ProjectsZonesClustersStartIpRotationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.startiprotationrequest = startiprotationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersStartIpRotationCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersStartIpRotationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersStartIpRotationCall) Context(ctx context.Context) *ProjectsZonesClustersStartIpRotationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersStartIpRotationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersStartIpRotationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.startiprotationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.startIpRotation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.startIpRotation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersStartIpRotationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.startIpRotation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersUpdateCall struct {
	s                    *Service
	projectId            string
	zone                 string
	clusterId            string
	updateclusterrequest *UpdateClusterRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Update: Updates the settings for a specific cluster.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersService) Update(projectId string, zone string, clusterId string, updateclusterrequest *UpdateClusterRequest) *ProjectsZonesClustersUpdateCall {
	c := &ProjectsZonesClustersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.updateclusterrequest = updateclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersUpdateCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersUpdateCall) Context(ctx context.Context) *ProjectsZonesClustersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updateclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsAutoscalingCall struct {
	s                             *Service
	projectId                     string
	zone                          string
	clusterId                     string
	nodePoolId                    string
	setnodepoolautoscalingrequest *SetNodePoolAutoscalingRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Autoscaling: Sets the autoscaling settings of a specific node pool.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - nodePoolId: Deprecated. The name of the node pool to upgrade. This field
//     has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersNodePoolsService) Autoscaling(projectId string, zone string, clusterId string, nodePoolId string, setnodepoolautoscalingrequest *SetNodePoolAutoscalingRequest) *ProjectsZonesClustersNodePoolsAutoscalingCall {
	c := &ProjectsZonesClustersNodePoolsAutoscalingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.nodePoolId = nodePoolId
	c.setnodepoolautoscalingrequest = setnodepoolautoscalingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsAutoscalingCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsAutoscalingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsAutoscalingCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsAutoscalingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsAutoscalingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsAutoscalingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnodepoolautoscalingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":  c.projectId,
		"zone":       c.zone,
		"clusterId":  c.clusterId,
		"nodePoolId": c.nodePoolId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.autoscaling", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.autoscaling" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsAutoscalingCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.autoscaling", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsCreateCall struct {
	s                     *Service
	projectId             string
	zone                  string
	clusterId             string
	createnodepoolrequest *CreateNodePoolRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Create: Creates a node pool for a cluster.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the parent field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the parent field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the parent field.
func (r *ProjectsZonesClustersNodePoolsService) Create(projectId string, zone string, clusterId string, createnodepoolrequest *CreateNodePoolRequest) *ProjectsZonesClustersNodePoolsCreateCall {
	c := &ProjectsZonesClustersNodePoolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.createnodepoolrequest = createnodepoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsCreateCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsCreateCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.createnodepoolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsDeleteCall struct {
	s          *Service
	projectId  string
	zone       string
	clusterId  string
	nodePoolId string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a node pool from a cluster.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the name field.
//   - nodePoolId: Deprecated. The name of the node pool to delete. This field
//     has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersNodePoolsService) Delete(projectId string, zone string, clusterId string, nodePoolId string) *ProjectsZonesClustersNodePoolsDeleteCall {
	c := &ProjectsZonesClustersNodePoolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.nodePoolId = nodePoolId
	return c
}

// Name sets the optional parameter "name": The name (project, location,
// cluster, node pool id) of the node pool to delete. Specified in the format
// `projects/*/locations/*/clusters/*/nodePools/*`.
func (c *ProjectsZonesClustersNodePoolsDeleteCall) Name(name string) *ProjectsZonesClustersNodePoolsDeleteCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsDeleteCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsDeleteCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":  c.projectId,
		"zone":       c.zone,
		"clusterId":  c.clusterId,
		"nodePoolId": c.nodePoolId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchNodePoolUpgradeInfo: Fetch upgrade information of a specific nodepool.
//
//   - name: The name (project, location, cluster, nodepool) of the nodepool to
//     get. Specified in the format
//     `projects/*/locations/*/clusters/*/nodePools/*` or
//     `projects/*/zones/*/clusters/*/nodePools/*`.
func (r *ProjectsZonesClustersNodePoolsService) FetchNodePoolUpgradeInfo(name string) *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c := &ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Version sets the optional parameter "version": API request version that
// initiates this operation.
func (c *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall) Version(version string) *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.urlParams_.Set("version", version)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall) IfNoneMatch(entityTag string) *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:fetchNodePoolUpgradeInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.fetchNodePoolUpgradeInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.fetchNodePoolUpgradeInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *NodePoolUpgradeInfo.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsZonesClustersNodePoolsFetchNodePoolUpgradeInfoCall) Do(opts ...googleapi.CallOption) (*NodePoolUpgradeInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NodePoolUpgradeInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.fetchNodePoolUpgradeInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsGetCall struct {
	s            *Service
	projectId    string
	zone         string
	clusterId    string
	nodePoolId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the requested node pool.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the name field.
//   - nodePoolId: Deprecated. The name of the node pool. This field has been
//     deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersNodePoolsService) Get(projectId string, zone string, clusterId string, nodePoolId string) *ProjectsZonesClustersNodePoolsGetCall {
	c := &ProjectsZonesClustersNodePoolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.nodePoolId = nodePoolId
	return c
}

// Name sets the optional parameter "name": The name (project, location,
// cluster, node pool id) of the node pool to get. Specified in the format
// `projects/*/locations/*/clusters/*/nodePools/*`.
func (c *ProjectsZonesClustersNodePoolsGetCall) Name(name string) *ProjectsZonesClustersNodePoolsGetCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsGetCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesClustersNodePoolsGetCall) IfNoneMatch(entityTag string) *ProjectsZonesClustersNodePoolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsGetCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":  c.projectId,
		"zone":       c.zone,
		"clusterId":  c.clusterId,
		"nodePoolId": c.nodePoolId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *NodePool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsGetCall) Do(opts ...googleapi.CallOption) (*NodePool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NodePool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsListCall struct {
	s            *Service
	projectId    string
	zone         string
	clusterId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the node pools for a cluster.
//
//   - clusterId: Deprecated. The name of the cluster. This field has been
//     deprecated and replaced by the parent field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the parent field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the parent field.
func (r *ProjectsZonesClustersNodePoolsService) List(projectId string, zone string, clusterId string) *ProjectsZonesClustersNodePoolsListCall {
	c := &ProjectsZonesClustersNodePoolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	return c
}

// Parent sets the optional parameter "parent": The parent (project, location,
// cluster name) where the node pools will be listed. Specified in the format
// `projects/*/locations/*/clusters/*`.
func (c *ProjectsZonesClustersNodePoolsListCall) Parent(parent string) *ProjectsZonesClustersNodePoolsListCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsListCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesClustersNodePoolsListCall) IfNoneMatch(entityTag string) *ProjectsZonesClustersNodePoolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsListCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
		"clusterId": c.clusterId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListNodePoolsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsZonesClustersNodePoolsListCall) Do(opts ...googleapi.CallOption) (*ListNodePoolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListNodePoolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsRollbackCall struct {
	s                              *Service
	projectId                      string
	zone                           string
	clusterId                      string
	nodePoolId                     string
	rollbacknodepoolupgraderequest *RollbackNodePoolUpgradeRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Rollback: Rolls back a previously Aborted or Failed NodePool upgrade. This
// makes no changes if the last upgrade successfully completed.
//
//   - clusterId: Deprecated. The name of the cluster to rollback. This field has
//     been deprecated and replaced by the name field.
//   - nodePoolId: Deprecated. The name of the node pool to rollback. This field
//     has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersNodePoolsService) Rollback(projectId string, zone string, clusterId string, nodePoolId string, rollbacknodepoolupgraderequest *RollbackNodePoolUpgradeRequest) *ProjectsZonesClustersNodePoolsRollbackCall {
	c := &ProjectsZonesClustersNodePoolsRollbackCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.nodePoolId = nodePoolId
	c.rollbacknodepoolupgraderequest = rollbacknodepoolupgraderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsRollbackCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsRollbackCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsRollbackCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsRollbackCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsRollbackCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsRollbackCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rollbacknodepoolupgraderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":  c.projectId,
		"zone":       c.zone,
		"clusterId":  c.clusterId,
		"nodePoolId": c.nodePoolId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.rollback", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.rollback" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsRollbackCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.rollback", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsSetManagementCall struct {
	s                            *Service
	projectId                    string
	zone                         string
	clusterId                    string
	nodePoolId                   string
	setnodepoolmanagementrequest *SetNodePoolManagementRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// SetManagement: Sets the NodeManagement options for a node pool.
//
//   - clusterId: Deprecated. The name of the cluster to update. This field has
//     been deprecated and replaced by the name field.
//   - nodePoolId: Deprecated. The name of the node pool to update. This field
//     has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersNodePoolsService) SetManagement(projectId string, zone string, clusterId string, nodePoolId string, setnodepoolmanagementrequest *SetNodePoolManagementRequest) *ProjectsZonesClustersNodePoolsSetManagementCall {
	c := &ProjectsZonesClustersNodePoolsSetManagementCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.nodePoolId = nodePoolId
	c.setnodepoolmanagementrequest = setnodepoolmanagementrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsSetManagementCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsSetManagementCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsSetManagementCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsSetManagementCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsSetManagementCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsSetManagementCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnodepoolmanagementrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":  c.projectId,
		"zone":       c.zone,
		"clusterId":  c.clusterId,
		"nodePoolId": c.nodePoolId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.setManagement", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.setManagement" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsSetManagementCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.setManagement", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsSetSizeCall struct {
	s                      *Service
	projectId              string
	zone                   string
	clusterId              string
	nodePoolId             string
	setnodepoolsizerequest *SetNodePoolSizeRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetSize: SetNodePoolSizeRequest sets the size of a node pool. The new size
// will be used for all replicas, including future replicas created by
// modifying NodePool.locations.
//
//   - clusterId: Deprecated. The name of the cluster to update. This field has
//     been deprecated and replaced by the name field.
//   - nodePoolId: Deprecated. The name of the node pool to update. This field
//     has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersNodePoolsService) SetSize(projectId string, zone string, clusterId string, nodePoolId string, setnodepoolsizerequest *SetNodePoolSizeRequest) *ProjectsZonesClustersNodePoolsSetSizeCall {
	c := &ProjectsZonesClustersNodePoolsSetSizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.nodePoolId = nodePoolId
	c.setnodepoolsizerequest = setnodepoolsizerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsSetSizeCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsSetSizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsSetSizeCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsSetSizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsSetSizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsSetSizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setnodepoolsizerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":  c.projectId,
		"zone":       c.zone,
		"clusterId":  c.clusterId,
		"nodePoolId": c.nodePoolId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.setSize", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.setSize" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsSetSizeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.setSize", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesClustersNodePoolsUpdateCall struct {
	s                     *Service
	projectId             string
	zone                  string
	clusterId             string
	nodePoolId            string
	updatenodepoolrequest *UpdateNodePoolRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Update: Updates the version and/or image type of a specific node pool.
//
//   - clusterId: Deprecated. The name of the cluster to upgrade. This field has
//     been deprecated and replaced by the name field.
//   - nodePoolId: Deprecated. The name of the node pool to upgrade. This field
//     has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesClustersNodePoolsService) Update(projectId string, zone string, clusterId string, nodePoolId string, updatenodepoolrequest *UpdateNodePoolRequest) *ProjectsZonesClustersNodePoolsUpdateCall {
	c := &ProjectsZonesClustersNodePoolsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.clusterId = clusterId
	c.nodePoolId = nodePoolId
	c.updatenodepoolrequest = updatenodepoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesClustersNodePoolsUpdateCall) Fields(s ...googleapi.Field) *ProjectsZonesClustersNodePoolsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesClustersNodePoolsUpdateCall) Context(ctx context.Context) *ProjectsZonesClustersNodePoolsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesClustersNodePoolsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesClustersNodePoolsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updatenodepoolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":  c.projectId,
		"zone":       c.zone,
		"clusterId":  c.clusterId,
		"nodePoolId": c.nodePoolId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.clusters.nodePools.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesClustersNodePoolsUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.clusters.nodePools.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesOperationsCancelCall struct {
	s                      *Service
	projectId              string
	zone                   string
	operationId            string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Cancels the specified operation.
//
//   - operationId: Deprecated. The server-assigned `name` of the operation. This
//     field has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the operation resides. This field has been deprecated and
//     replaced by the name field.
func (r *ProjectsZonesOperationsService) Cancel(projectId string, zone string, operationId string, canceloperationrequest *CancelOperationRequest) *ProjectsZonesOperationsCancelCall {
	c := &ProjectsZonesOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.operationId = operationId
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsZonesOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesOperationsCancelCall) Context(ctx context.Context) *ProjectsZonesOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"zone":        c.zone,
		"operationId": c.operationId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesOperationsGetCall struct {
	s            *Service
	projectId    string
	zone         string
	operationId  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified operation.
//
//   - operationId: Deprecated. The server-assigned `name` of the operation. This
//     field has been deprecated and replaced by the name field.
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the name field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     in which the cluster resides. This field has been deprecated and replaced
//     by the name field.
func (r *ProjectsZonesOperationsService) Get(projectId string, zone string, operationId string) *ProjectsZonesOperationsGetCall {
	c := &ProjectsZonesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	c.operationId = operationId
	return c
}

// Name sets the optional parameter "name": The name (project, location,
// operation id) of the operation to get. Specified in the format
// `projects/*/locations/*/operations/*`.
func (c *ProjectsZonesOperationsGetCall) Name(name string) *ProjectsZonesOperationsGetCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsZonesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsZonesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesOperationsGetCall) Context(ctx context.Context) *ProjectsZonesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/operations/{operationId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"zone":        c.zone,
		"operationId": c.operationId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsZonesOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsZonesOperationsListCall struct {
	s            *Service
	projectId    string
	zone         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all operations in a project in the specified zone or all zones.
//
//   - projectId: Deprecated. The Google Developers Console project ID or project
//     number
//     (https://{$universe.dns_names.final_documentation_domain}/resource-manager/docs/creating-managing-projects).
//     This field has been deprecated and replaced by the parent field.
//   - zone: Deprecated. The name of the Google Compute Engine zone
//     (https://{$universe.dns_names.final_documentation_domain}/compute/docs/zones#available)
//     to return operations for, or `-` for all zones. This field has been
//     deprecated and replaced by the parent field.
func (r *ProjectsZonesOperationsService) List(projectId string, zone string) *ProjectsZonesOperationsListCall {
	c := &ProjectsZonesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.zone = zone
	return c
}

// Parent sets the optional parameter "parent": The parent (project and
// location) where the operations will be listed. Specified in the format
// `projects/*/locations/*`. Location "-" matches all zones and all regions.
func (c *ProjectsZonesOperationsListCall) Parent(parent string) *ProjectsZonesOperationsListCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsZonesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsZonesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsZonesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsZonesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsZonesOperationsListCall) Context(ctx context.Context) *ProjectsZonesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsZonesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsZonesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects/{projectId}/zones/{zone}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"zone":      c.zone,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "container.projects.zones.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "container.projects.zones.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsZonesOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "container.projects.zones.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
