// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package playgrouping provides access to the Google Play Grouping API.
//
// For product documentation, see: https://cloud.google.com/playgrouping/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/playgrouping/v1alpha1"
//	...
//	ctx := context.Background()
//	playgroupingService, err := playgrouping.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	playgroupingService, err := playgrouping.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	playgroupingService, err := playgrouping.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package playgrouping // import "google.golang.org/api/playgrouping/v1alpha1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "playgrouping:v1alpha1"
const apiName = "playgrouping"
const apiVersion = "v1alpha1"
const basePath = "https://playgrouping.googleapis.com/"
const basePathTemplate = "https://playgrouping.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://playgrouping.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Apps = NewAppsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Apps *AppsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAppsService(s *Service) *AppsService {
	rs := &AppsService{s: s}
	rs.Tokens = NewAppsTokensService(s)
	return rs
}

type AppsService struct {
	s *Service

	Tokens *AppsTokensService
}

func NewAppsTokensService(s *Service) *AppsTokensService {
	rs := &AppsTokensService{s: s}
	rs.Tags = NewAppsTokensTagsService(s)
	return rs
}

type AppsTokensService struct {
	s *Service

	Tags *AppsTokensTagsService
}

func NewAppsTokensTagsService(s *Service) *AppsTokensTagsService {
	rs := &AppsTokensTagsService{s: s}
	return rs
}

type AppsTokensTagsService struct {
	s *Service
}

// CreateOrUpdateTagsRequest: Request message for CreateOrUpdateTags.
// VerifyToken.
type CreateOrUpdateTagsRequest struct {
	// Tags: Tags to be inserted or updated.
	Tags []*Tag `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tags") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateOrUpdateTagsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateOrUpdateTagsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateOrUpdateTagsResponse: Response message for CreateOrUpdateTags.
type CreateOrUpdateTagsResponse struct {
	// Tags: All requested tags are returned, including pre-existing ones.
	Tags []*Tag `json:"tags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Tags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tags") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateOrUpdateTagsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CreateOrUpdateTagsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Tag: A tag is associated with exactly one package name and user.
type Tag struct {
	// BooleanValue: A boolean value of the tag.
	BooleanValue bool `json:"booleanValue,omitempty"`
	// Int64Value: A signed 64-bit integer value of the tag.
	Int64Value int64 `json:"int64Value,omitempty,string"`
	// Key: Required. Key for the tag.
	Key string `json:"key,omitempty"`
	// StringValue: A string value of the tag.
	StringValue string `json:"stringValue,omitempty"`
	// TimeValue: A time value of the tag.
	TimeValue string `json:"timeValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BooleanValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Tag) MarshalJSON() ([]byte, error) {
	type NoMethod Tag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerifyTokenRequest: Request message for VerifyToken.
type VerifyTokenRequest struct {
	// Persona: Required. Persona represented by the token. Format:
	// personas/{persona}
	Persona string `json:"persona,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Persona") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Persona") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerifyTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod VerifyTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerifyTokenResponse: Response message for VerifyToken.
type VerifyTokenResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type AppsTokensVerifyCall struct {
	s                  *Service
	appPackage         string
	token              string
	verifytokenrequest *VerifyTokenRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Verify: Verify an API token by asserting the app and persona it belongs to.
// The verification is a protection against client-side attacks and will fail
// if the contents of the token don't match the provided values. A token must
// be verified before it can be used to manipulate user tags.
//
// - appPackage: App the token belongs to. Format: apps/{package_name}.
// - token: The token to be verified. Format: tokens/{token}.
func (r *AppsTokensService) Verify(appPackage string, token string, verifytokenrequest *VerifyTokenRequest) *AppsTokensVerifyCall {
	c := &AppsTokensVerifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appPackage = appPackage
	c.token = token
	c.verifytokenrequest = verifytokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsTokensVerifyCall) Fields(s ...googleapi.Field) *AppsTokensVerifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsTokensVerifyCall) Context(ctx context.Context) *AppsTokensVerifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsTokensVerifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsTokensVerifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.verifytokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+appPackage}/{+token}:verify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"appPackage": c.appPackage,
		"token":      c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playgrouping.apps.tokens.verify" call.
// Any non-2xx status code is an error. Response headers are in either
// *VerifyTokenResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AppsTokensVerifyCall) Do(opts ...googleapi.CallOption) (*VerifyTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VerifyTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsTokensTagsCreateOrUpdateCall struct {
	s                         *Service
	appPackage                string
	token                     string
	createorupdatetagsrequest *CreateOrUpdateTagsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// CreateOrUpdate: Create or update tags for the user and app that are
// represented by the given token.
//
//   - appPackage: App whose tags are being manipulated. Format:
//     apps/{package_name}.
//   - token: Token for which the tags are being inserted or updated. Format:
//     tokens/{token}.
func (r *AppsTokensTagsService) CreateOrUpdate(appPackage string, token string, createorupdatetagsrequest *CreateOrUpdateTagsRequest) *AppsTokensTagsCreateOrUpdateCall {
	c := &AppsTokensTagsCreateOrUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appPackage = appPackage
	c.token = token
	c.createorupdatetagsrequest = createorupdatetagsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsTokensTagsCreateOrUpdateCall) Fields(s ...googleapi.Field) *AppsTokensTagsCreateOrUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsTokensTagsCreateOrUpdateCall) Context(ctx context.Context) *AppsTokensTagsCreateOrUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsTokensTagsCreateOrUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsTokensTagsCreateOrUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.createorupdatetagsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+appPackage}/{+token}/tags:createOrUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"appPackage": c.appPackage,
		"token":      c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playgrouping.apps.tokens.tags.createOrUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *CreateOrUpdateTagsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AppsTokensTagsCreateOrUpdateCall) Do(opts ...googleapi.CallOption) (*CreateOrUpdateTagsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CreateOrUpdateTagsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
