// Copyright 2012-2017 the u-root Authors. All rights reserved
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package pci

// IDs is an array of Vendor structs, enumerating vendor and device IDs.
var IDs = []Vendor{
	{ID: 0x0001, Name: "SafeNet (wrong ID)", Devices: []Device{}},
	{
		ID: 0x0010, Name: "Allied Telesis, Inc (Wrong ID)", Devices: []Device{
			{ID: 0x8139, Name: "AT-2500TX V3 Ethernet"},
		},
	},
	{
		ID: 0x0014, Name: "Loongson Technology LLC", Devices: []Device{
			{ID: 0x7a00, Name: "Hyper Transport Bridge Controller"},
			{ID: 0x7a02, Name: "APB (Advanced Peripheral Bus) Controller"},
			{ID: 0x7a03, Name: "Gigabit Ethernet Controller"},
			{ID: 0x7a04, Name: "OTG USB Controller"},
			{ID: 0x7a05, Name: "Vivante GPU (Graphics Processing Unit)"},
			{ID: 0x7a06, Name: "DC (Display Controller)"},
			{ID: 0x7a07, Name: "HDA (High Definition Audio) Controller"},
			{ID: 0x7a08, Name: "SATA AHCI Controller"},
			{ID: 0x7a09, Name: "PCI-to-PCI Bridge"},
			{ID: 0x7a0b, Name: "SPI Controller"},
			{ID: 0x7a0c, Name: "LPC Controller"},
			{ID: 0x7a0f, Name: "DMA (Direct Memory Access) Controller"},
			{ID: 0x7a10, Name: "Hyper Transport Bridge Controller"},
			{ID: 0x7a14, Name: "EHCI USB Controller"},
			{ID: 0x7a15, Name: "Vivante GPU (Graphics Processing Unit)"},
			{ID: 0x7a19, Name: "PCI-to-PCI Bridge"},
			{ID: 0x7a24, Name: "OHCI USB Controller"},
			{ID: 0x7a29, Name: "PCI-to-PCI Bridge"},
		},
	},
	{
		ID: 0x001c, Name: "PEAK-System Technik GmbH", Devices: []Device{
			{ID: 0x0001, Name: "PCAN-PCI CAN-Bus controller"},
		},
	},
	{ID: 0x003d, Name: "Lockheed Martin-Marietta Corp", Devices: []Device{}},
	{ID: 0x0059, Name: "Tiger Jet Network Inc. (Wrong ID)", Devices: []Device{}},
	{
		ID: 0x0070, Name: "Hauppauge computer works Inc.", Devices: []Device{
			{ID: 0x7801, Name: "WinTV HVR-1800 MCE"},
		},
	},
	{ID: 0x0071, Name: "Nebula Electronics Ltd.", Devices: []Device{}},
	{
		ID: 0x0095, Name: "Silicon Image, Inc. (Wrong ID)", Devices: []Device{
			{ID: 0x0680, Name: "Ultra ATA/133 IDE RAID CONTROLLER CARD"},
		},
	},
	{ID: 0x00a7, Name: "Teles AG (Wrong ID)", Devices: []Device{}},
	{ID: 0x0100, Name: "nCipher Security", Devices: []Device{}},
	{ID: 0x0123, Name: "General Dynamics", Devices: []Device{}},
	{ID: 0x0128, Name: "Dell (wrong ID)", Devices: []Device{}},
	{
		ID: 0x018a, Name: "LevelOne", Devices: []Device{
			{ID: 0x0106, Name: "FPC-0106TX misprogrammed [RTL81xx]"},
		},
	},
	{ID: 0x01de, Name: "Oxide Computer Company", Devices: []Device{}},
	{ID: 0x0200, Name: "Dell (wrong ID)", Devices: []Device{}},
	{
		ID: 0x021b, Name: "Compaq Computer Corporation", Devices: []Device{
			{ID: 0x8139, Name: "HNE-300 (RealTek RTL8139c) [iPaq Networking]"},
		},
	},
	{ID: 0x0270, Name: "Hauppauge computer works Inc. (Wrong ID)", Devices: []Device{}},
	{ID: 0x0291, Name: "Davicom Semiconductor, Inc. (Wrong ID)", Devices: []Device{}},
	{
		ID: 0x02ac, Name: "SpeedStream", Devices: []Device{
			{ID: 0x1012, Name: "1012 PCMCIA 10/100 Ethernet Card [RTL81xx]"},
		},
	},
	{ID: 0x02e0, Name: "XFX Pine Group Inc. (Wrong ID)", Devices: []Device{}},
	{ID: 0x0303, Name: "Hewlett-Packard Company (Wrong ID)", Devices: []Device{}},
	{ID: 0x0308, Name: "ZyXEL Communications Corporation (Wrong ID)", Devices: []Device{}},
	{ID: 0x0315, Name: "SK-Electronics Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x0357, Name: "TTTech Computertechnik AG (Wrong ID)", Devices: []Device{
			{ID: 0x000a, Name: "TTP-Monitoring Card V2.0"},
		},
	},
	{
		ID: 0x0432, Name: "SCM Microsystems, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Pluto2 DVB-T Receiver for PCMCIA [EasyWatch MobilSet]"},
		},
	},
	{ID: 0x0497, Name: "Dell Inc. (wrong ID)", Devices: []Device{}},
	{
		ID: 0x0675, Name: "Dynalink", Devices: []Device{
			{ID: 0x1700, Name: "IS64PH ISDN Adapter"},
			{ID: 0x1702, Name: "IS64PH ISDN Adapter"},
			{ID: 0x1703, Name: "ISDN Adapter (PCI Bus, DV, W)"},
			{ID: 0x1704, Name: "ISDN Adapter (PCI Bus, D, C)"},
		},
	},
	{ID: 0x0721, Name: "Sapphire, Inc.", Devices: []Device{}},
	{
		ID: 0x0731, Name: "Jingjia Microelectronics Co Ltd", Devices: []Device{
			{ID: 0x7200, Name: "JM7200 Series GPU"},
			{ID: 0x9200, Name: "JM9200"},
			{ID: 0x920a, Name: "JH920"},
			{ID: 0x920b, Name: "JH920-I"},
			{ID: 0x920c, Name: "JH920-M"},
			{ID: 0x9210, Name: "JM9210"},
			{ID: 0x9211, Name: "JM9210-I"},
			{ID: 0x9230, Name: "JM9230"},
			{ID: 0x9231, Name: "JM9231-I"},
			{ID: 0x9250, Name: "JM9250"},
			{ID: 0x930a, Name: "JH930-I"},
			{ID: 0x930b, Name: "JH930-M"},
		},
	},
	{ID: 0x0777, Name: "Ubiquiti Networks, Inc.", Devices: []Device{}},
	{
		ID: 0x0795, Name: "Wired Inc.", Devices: []Device{
			{ID: 0x6663, Name: "Butane II (MPEG2 encoder board)"},
			{ID: 0x6666, Name: "MediaPress (MPEG2 encoder board)"},
		},
	},
	{ID: 0x07d1, Name: "D-Link System Inc", Devices: []Device{}},
	{ID: 0x0824, Name: "T1042 [Freescale]", Devices: []Device{}},
	{ID: 0x0925, Name: "VIA Technologies, Inc. (Wrong ID)", Devices: []Device{}},
	{ID: 0x0a89, Name: "BREA Technologies Inc", Devices: []Device{}},
	{
		ID: 0x0b0b, Name: "Rhino Equipment Corp.", Devices: []Device{
			{ID: 0x0105, Name: "R1T1"},
			{ID: 0x0205, Name: "R4FXO"},
			{ID: 0x0206, Name: "RCB4FXO 4-channel FXO analog telephony card"},
			{ID: 0x0305, Name: "R4T1"},
			{ID: 0x0405, Name: "R8FXX"},
			{ID: 0x0406, Name: "RCB8FXX 8-channel modular analog telephony card"},
			{ID: 0x0505, Name: "R24FXX"},
			{ID: 0x0506, Name: "RCB24FXS 24-Channel FXS analog telephony card"},
			{ID: 0x0605, Name: "R2T1"},
			{ID: 0x0705, Name: "R24FXS"},
			{ID: 0x0706, Name: "RCB24FXO 24-Channel FXO analog telephony card"},
			{ID: 0x0905, Name: "R1T3 Single T3 Digital Telephony Card"},
			{ID: 0x0906, Name: "RCB24FXX 24-channel modular analog telephony card"},
			{ID: 0x0a06, Name: "RCB672FXX 672-channel modular analog telephony card"},
		},
	},
	{ID: 0x0ccd, Name: "Preferred Networks, Inc.", Devices: []Device{}},
	{
		ID: 0x0e11, Name: "Compaq Computer Corporation", Devices: []Device{
			{ID: 0x0001, Name: "PCI to EISA Bridge"},
			{ID: 0x0002, Name: "PCI to ISA Bridge"},
			{ID: 0x0046, Name: "Smart Array 64xx"},
			{ID: 0x0049, Name: "NC7132 Gigabit Upgrade Module"},
			{ID: 0x004a, Name: "NC6136 Gigabit Server Adapter"},
			{ID: 0x005a, Name: "Remote Insight II board - Lights-Out"},
			{ID: 0x007c, Name: "NC7770 1000BaseTX"},
			{ID: 0x007d, Name: "NC6770 1000BaseTX"},
			{ID: 0x0085, Name: "NC7780 1000BaseTX"},
			{ID: 0x00b1, Name: "Remote Insight II board - PCI device"},
			{ID: 0x00bb, Name: "NC7760"},
			{ID: 0x00ca, Name: "NC7771"},
			{ID: 0x00cb, Name: "NC7781"},
			{ID: 0x00cf, Name: "NC7772"},
			{ID: 0x00d0, Name: "NC7782"},
			{ID: 0x00d1, Name: "NC7783"},
			{ID: 0x00e3, Name: "NC7761"},
			{ID: 0x0508, Name: "Netelligent 4/16 Token Ring"},
			{ID: 0x1000, Name: "Triflex/Pentium Bridge, Model 1000"},
			{ID: 0x2000, Name: "Triflex/Pentium Bridge, Model 2000"},
			{ID: 0x3032, Name: "QVision 1280/p"},
			{ID: 0x3033, Name: "QVision 1280/p"},
			{ID: 0x3034, Name: "QVision 1280/p"},
			{ID: 0x4000, Name: "4000 [Triflex]"},
			{ID: 0x4040, Name: "Integrated Array"},
			{ID: 0x4048, Name: "Compaq Raid LC2"},
			{ID: 0x4050, Name: "Smart Array 4200"},
			{ID: 0x4051, Name: "Smart Array 4250ES"},
			{ID: 0x4058, Name: "Smart Array 431"},
			{ID: 0x4070, Name: "Smart Array 5300"},
			{ID: 0x4080, Name: "Smart Array 5i"},
			{ID: 0x4082, Name: "Smart Array 532"},
			{ID: 0x4083, Name: "Smart Array 5312"},
			{ID: 0x4091, Name: "Smart Array 6i"},
			{ID: 0x409a, Name: "Smart Array 641"},
			{ID: 0x409b, Name: "Smart Array 642"},
			{ID: 0x409c, Name: "Smart Array 6400"},
			{ID: 0x409d, Name: "Smart Array 6400 EM"},
			{ID: 0x6010, Name: "HotPlug PCI Bridge 6010"},
			{ID: 0x7020, Name: "USB Controller"},
			{ID: 0xa0ec, Name: "Fibre Channel Host Controller"},
			{ID: 0xa0f0, Name: "Advanced System Management Controller"},
			{ID: 0xa0f3, Name: "Triflex PCI to ISA Bridge"},
			{ID: 0xa0f7, Name: "PCI Hotplug Controller"},
			{ID: 0xa0f8, Name: "ZFMicro Chipset USB"},
			{ID: 0xa0fc, Name: "FibreChannel HBA Tachyon"},
			{ID: 0xae10, Name: "Smart-2/P RAID Controller"},
			{ID: 0xae29, Name: "MIS-L"},
			{ID: 0xae2a, Name: "MPC"},
			{ID: 0xae2b, Name: "MIS-E"},
			{ID: 0xae31, Name: "System Management Controller"},
			{ID: 0xae32, Name: "Netelligent 10/100 TX PCI UTP"},
			{ID: 0xae33, Name: "Triflex Dual EIDE Controller"},
			{ID: 0xae34, Name: "Netelligent 10 T PCI UTP"},
			{ID: 0xae35, Name: "Integrated NetFlex-3/P"},
			{ID: 0xae40, Name: "Netelligent Dual 10/100 TX PCI UTP"},
			{ID: 0xae43, Name: "Netelligent Integrated 10/100 TX UTP"},
			{ID: 0xae69, Name: "CETUS-L"},
			{ID: 0xae6c, Name: "Northstar"},
			{ID: 0xae6d, Name: "NorthStar CPU to PCI Bridge"},
			{ID: 0xb011, Name: "Netelligent 10/100 TX Embedded UTP"},
			{ID: 0xb012, Name: "Netelligent 10 T/2 PCI UTP/Coax"},
			{ID: 0xb01e, Name: "NC3120 Fast Ethernet NIC"},
			{ID: 0xb01f, Name: "NC3122 Fast Ethernet NIC"},
			{ID: 0xb02f, Name: "NC1120 Ethernet NIC"},
			{ID: 0xb030, Name: "Netelligent 10/100 TX UTP"},
			{ID: 0xb04a, Name: "10/100 TX PCI Intel WOL UTP Controller"},
			{ID: 0xb060, Name: "Smart Array 5300 Controller"},
			{ID: 0xb0c6, Name: "NC3161 Fast Ethernet NIC"},
			{ID: 0xb0c7, Name: "NC3160 Fast Ethernet NIC"},
			{ID: 0xb0d7, Name: "NC3121 Fast Ethernet NIC"},
			{ID: 0xb0dd, Name: "NC3131 Fast Ethernet NIC"},
			{ID: 0xb0de, Name: "NC3132 Fast Ethernet Module"},
			{ID: 0xb0df, Name: "NC6132 Gigabit Module"},
			{ID: 0xb0e0, Name: "NC6133 Gigabit Module"},
			{ID: 0xb0e1, Name: "NC3133 Fast Ethernet Module"},
			{ID: 0xb123, Name: "NC6134 Gigabit NIC"},
			{ID: 0xb134, Name: "NC3163 Fast Ethernet NIC"},
			{ID: 0xb13c, Name: "NC3162 Fast Ethernet NIC"},
			{ID: 0xb144, Name: "NC3123 Fast Ethernet NIC"},
			{ID: 0xb163, Name: "NC3134 Fast Ethernet NIC"},
			{ID: 0xb164, Name: "NC3165 Fast Ethernet Upgrade Module"},
			{ID: 0xb178, Name: "Smart Array 5i/532"},
			{ID: 0xb1a4, Name: "NC7131 Gigabit Server Adapter"},
			{ID: 0xb200, Name: "Memory Hot-Plug Controller"},
			{ID: 0xb203, Name: "Integrated Lights Out Controller"},
			{ID: 0xb204, Name: "Integrated Lights Out  Processor"},
			{ID: 0xc000, Name: "Remote Insight Lights-Out Edition"},
			{ID: 0xf130, Name: "NetFlex-3/P ThunderLAN 1.0"},
			{ID: 0xf150, Name: "NetFlex-3/P ThunderLAN 2.3"},
		},
	},
	{ID: 0x0e55, Name: "HaSoTec GmbH", Devices: []Device{}},
	{
		ID: 0x0eac, Name: "SHF Communication Technologies AG", Devices: []Device{
			{ID: 0x0008, Name: "Ethernet Powerlink Managing Node 01"},
		},
	},
	{ID: 0x0f62, Name: "Acrox Technologies Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1000, Name: "Broadcom / LSI", Devices: []Device{
			{ID: 0x0001, Name: "53c810"},
			{ID: 0x0002, Name: "53c820"},
			{ID: 0x0003, Name: "53c825"},
			{ID: 0x0004, Name: "53c815"},
			{ID: 0x0005, Name: "53c810AP"},
			{ID: 0x0006, Name: "53c860"},
			{ID: 0x000a, Name: "53c1510"},
			{ID: 0x000b, Name: "53C896/897"},
			{ID: 0x000c, Name: "53c895"},
			{ID: 0x000d, Name: "53c885"},
			{ID: 0x000f, Name: "53c875"},
			{ID: 0x0010, Name: "53C1510"},
			{ID: 0x0012, Name: "53c895a"},
			{ID: 0x0013, Name: "53c875a"},
			{ID: 0x0014, Name: "MegaRAID Tri-Mode SAS3516"},
			{ID: 0x0015, Name: "MegaRAID Tri-Mode SAS3416"},
			{ID: 0x0016, Name: "MegaRAID Tri-Mode SAS3508"},
			{ID: 0x0017, Name: "MegaRAID Tri-Mode SAS3408"},
			{ID: 0x001b, Name: "MegaRAID Tri-Mode SAS3504"},
			{ID: 0x001c, Name: "MegaRAID Tri-Mode SAS3404"},
			{ID: 0x0020, Name: "53c1010 Ultra3 SCSI Adapter"},
			{ID: 0x0021, Name: "53c1010 66MHz  Ultra3 SCSI Adapter"},
			{ID: 0x002f, Name: "MegaRAID SAS 2208 IOV [Thunderbolt]"},
			{ID: 0x0030, Name: "53c1030 PCI-X Fusion-MPT Dual Ultra320 SCSI"},
			{ID: 0x0031, Name: "53c1030ZC PCI-X Fusion-MPT Dual Ultra320 SCSI"},
			{ID: 0x0032, Name: "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI"},
			{ID: 0x0033, Name: "1030ZC_53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI"},
			{ID: 0x0040, Name: "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI"},
			{ID: 0x0041, Name: "53C1035ZC PCI-X Fusion-MPT Dual Ultra320 SCSI"},
			{ID: 0x0050, Name: "SAS1064 PCI-X Fusion-MPT SAS"},
			{ID: 0x0052, Name: "MegaRAID SAS-3 3216/3224 [Cutlass]"},
			{ID: 0x0053, Name: "MegaRAID SAS-3 3216/3224 [Cutlass]"},
			{ID: 0x0054, Name: "SAS1068 PCI-X Fusion-MPT SAS"},
			{ID: 0x0055, Name: "SAS1068 PCI-X Fusion-MPT SAS"},
			{ID: 0x0056, Name: "SAS1064ET PCI-Express Fusion-MPT SAS"},
			{ID: 0x0057, Name: "M1064E MegaRAID SAS"},
			{ID: 0x0058, Name: "SAS1068E PCI-Express Fusion-MPT SAS"},
			{ID: 0x0059, Name: "MegaRAID SAS 8208ELP/8208ELP"},
			{ID: 0x005a, Name: "SAS1066E PCI-Express Fusion-MPT SAS"},
			{ID: 0x005b, Name: "MegaRAID SAS 2208 [Thunderbolt]"},
			{ID: 0x005c, Name: "SAS1064A PCI-X Fusion-MPT SAS"},
			{ID: 0x005d, Name: "MegaRAID SAS-3 3108 [Invader]"},
			{ID: 0x005e, Name: "SAS1066 PCI-X Fusion-MPT SAS"},
			{ID: 0x005f, Name: "MegaRAID SAS-3 3008 [Fury]"},
			{ID: 0x0060, Name: "MegaRAID SAS 1078"},
			{ID: 0x0062, Name: "SAS1078 PCI-Express Fusion-MPT SAS"},
			{ID: 0x0064, Name: "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor]"},
			{ID: 0x0065, Name: "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor]"},
			{ID: 0x006e, Name: "SAS2308 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0070, Name: "SAS2004 PCI-Express Fusion-MPT SAS-2 [Spitfire]"},
			{ID: 0x0071, Name: "MR SAS HBA 2004"},
			{ID: 0x0072, Name: "SAS2008 PCI-Express Fusion-MPT SAS-2 [Falcon]"},
			{ID: 0x0073, Name: "MegaRAID SAS 2008 [Falcon]"},
			{ID: 0x0074, Name: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]"},
			{ID: 0x0076, Name: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]"},
			{ID: 0x0077, Name: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]"},
			{ID: 0x0079, Name: "MegaRAID SAS 2108 [Liberator]"},
			{ID: 0x007c, Name: "MegaRAID SAS 1078DE"},
			{ID: 0x007e, Name: "SSS6200 PCI-Express Flash SSD"},
			{ID: 0x0080, Name: "SAS2208 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0081, Name: "SAS2208 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0082, Name: "SAS2208 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0083, Name: "SAS2208 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0084, Name: "SAS2208 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0085, Name: "SAS2208 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0086, Name: "SAS2308 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x0087, Name: "SAS2308 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x008f, Name: "53c875J"},
			{ID: 0x0090, Name: "SAS3108 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x0091, Name: "SAS3108 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x0094, Name: "SAS3108 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x0095, Name: "SAS3108 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x0096, Name: "SAS3004 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x0097, Name: "SAS3008 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00a5, Name: "Fusion-MPT 24GSAS/PCIe SAS40xx"},
			{ID: 0x00ab, Name: "SAS3516 Fusion-MPT Tri-Mode RAID On Chip (ROC)"},
			{ID: 0x00ac, Name: "SAS3416 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)"},
			{ID: 0x00ae, Name: "SAS3508 Fusion-MPT Tri-Mode RAID On Chip (ROC)"},
			{ID: 0x00af, Name: "SAS3408 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)"},
			{ID: 0x00b2, Name: "PCIe Switch management endpoint"},
			{ID: 0x00be, Name: "SAS3504 Fusion-MPT Tri-Mode RAID On Chip (ROC)"},
			{ID: 0x00bf, Name: "SAS3404 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)"},
			{ID: 0x00c0, Name: "SAS3324 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c1, Name: "SAS3324 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c2, Name: "SAS3324 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c3, Name: "SAS3324 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c4, Name: "SAS3224 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c5, Name: "SAS3316 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c6, Name: "SAS3316 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c7, Name: "SAS3316 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c8, Name: "SAS3316 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00c9, Name: "SAS3216 PCI-Express Fusion-MPT SAS-3"},
			{ID: 0x00ce, Name: "MegaRAID SAS-3 3316 [Intruder]"},
			{ID: 0x00cf, Name: "MegaRAID SAS-3 3324 [Intruder]"},
			{ID: 0x00d0, Name: "SAS3716 Fusion-MPT Tri-Mode RAID Controller Chip (ROC)"},
			{ID: 0x00d1, Name: "SAS3616 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)"},
			{ID: 0x00d3, Name: "MegaRAID Tri-Mode SAS3716W"},
			{ID: 0x00e0, Name: "Fusion-MPT 12GSAS/PCIe Unsupported SAS39xx"},
			{ID: 0x00e1, Name: "Fusion-MPT 12GSAS/PCIe SAS39xx"},
			{ID: 0x00e2, Name: "Fusion-MPT 12GSAS/PCIe Secure SAS39xx"},
			{ID: 0x00e3, Name: "Fusion-MPT 12GSAS/PCIe Unsupported SAS39xx"},
			{ID: 0x00e4, Name: "Fusion-MPT 12GSAS/PCIe Unsupported SAS38xx"},
			{ID: 0x00e5, Name: "Fusion-MPT 12GSAS/PCIe SAS38xx"},
			{ID: 0x00e6, Name: "Fusion-MPT 12GSAS/PCIe Secure SAS38xx"},
			{ID: 0x00e7, Name: "Fusion-MPT 12GSAS/PCIe Unsupported SAS38xx"},
			{ID: 0x02b0, Name: "Virtual Endpoint on PCIe Switch"},
			{ID: 0x02b1, Name: "Virtual Endpoint on PCIe Switch (9749)"},
			{ID: 0x0407, Name: "MegaRAID"},
			{ID: 0x0408, Name: "MegaRAID"},
			{ID: 0x0409, Name: "MegaRAID"},
			{ID: 0x0411, Name: "MegaRAID SAS 1068"},
			{ID: 0x0413, Name: "MegaRAID SAS 1068 [Verde ZCR]"},
			{ID: 0x0621, Name: "FC909 Fibre Channel Adapter"},
			{ID: 0x0622, Name: "FC929 Fibre Channel Adapter"},
			{ID: 0x0623, Name: "FC929 LAN"},
			{ID: 0x0624, Name: "FC919 Fibre Channel Adapter"},
			{ID: 0x0625, Name: "FC919 LAN"},
			{ID: 0x0626, Name: "FC929X Fibre Channel Adapter"},
			{ID: 0x0627, Name: "FC929X LAN"},
			{ID: 0x0628, Name: "FC919X Fibre Channel Adapter"},
			{ID: 0x0629, Name: "FC919X LAN"},
			{ID: 0x0640, Name: "FC949X Fibre Channel Adapter"},
			{ID: 0x0642, Name: "FC939X Fibre Channel Adapter"},
			{ID: 0x0646, Name: "FC949ES Fibre Channel Adapter"},
			{ID: 0x0701, Name: "83C885 NT50 DigitalScape Fast Ethernet"},
			{ID: 0x0702, Name: "Yellowfin G-NIC gigabit ethernet"},
			{ID: 0x0804, Name: "SA2010"},
			{ID: 0x0805, Name: "SA2010ZC"},
			{ID: 0x0806, Name: "SA2020"},
			{ID: 0x0807, Name: "SA2020ZC"},
			{ID: 0x0901, Name: "61C102"},
			{ID: 0x1000, Name: "63C815"},
			{ID: 0x10e0, Name: "MegaRAID 12GSAS/PCIe Unsupported SAS39xx"},
			{ID: 0x10e1, Name: "MegaRAID 12GSAS/PCIe SAS39xx"},
			{ID: 0x10e2, Name: "MegaRAID 12GSAS/PCIe Secure SAS39xx"},
			{ID: 0x10e3, Name: "MegaRAID 12GSAS/PCIe Unsupported SAS39xx"},
			{ID: 0x10e4, Name: "MegaRAID 12GSAS/PCIe Unsupported SAS38xx"},
			{ID: 0x10e5, Name: "MegaRAID 12GSAS/PCIe SAS38xx"},
			{ID: 0x10e6, Name: "MegaRAID 12GSAS/PCIe Secure SAS38xx"},
			{ID: 0x10e7, Name: "MegaRAID 12GSAS/PCIe Unsupported SAS38xx"},
			{ID: 0x1960, Name: "MegaRAID"},
			{ID: 0x3050, Name: "SAS2008 PCI-Express Fusion-MPT SAS-2"},
			{ID: 0x6001, Name: "DX1 Multiformat Broadcast HD/SD Encoder/Decoder"},
			{ID: 0xc010, Name: "PEX88048 50 lane, 50 port, PCI Express Gen 4.0 ExpressFabric Platform"},
			{ID: 0xc012, Name: "PEX880xx PCIe Gen 4 Switch"},
			{ID: 0xc030, Name: "PEX890xx PCIe Gen 5 Switch"},
		},
	},
	{
		ID: 0x1001, Name: "Kolter Electronic", Devices: []Device{
			{ID: 0x0010, Name: "PCI 1616 Measurement card with 32 digital I/O lines"},
			{ID: 0x0011, Name: "OPTO-PCI Opto-Isolated digital I/O board"},
			{ID: 0x0012, Name: "PCI-AD/DA Analogue I/O board"},
			{ID: 0x0013, Name: "PCI-OPTO-RELAIS Digital I/O board with relay outputs"},
			{ID: 0x0014, Name: "PCI-Counter/Timer Counter Timer board"},
			{ID: 0x0015, Name: "PCI-DAC416 Analogue output board"},
			{ID: 0x0016, Name: "PCI-MFB Analogue I/O board"},
			{ID: 0x0017, Name: "PROTO-3 PCI Prototyping board"},
			{ID: 0x9100, Name: "INI-9100/9100W SCSI Host"},
		},
	},
	{
		ID: 0x1002, Name: "Advanced Micro Devices, Inc. [AMD/ATI]", Devices: []Device{
			{ID: 0x1304, Name: "Kaveri"},
			{ID: 0x1305, Name: "Kaveri"},
			{ID: 0x1306, Name: "Kaveri"},
			{ID: 0x1307, Name: "Kaveri"},
			{ID: 0x1308, Name: "Kaveri HDMI/DP Audio Controller"},
			{ID: 0x1309, Name: "Kaveri [Radeon R6/R7 Graphics]"},
			{ID: 0x130a, Name: "Kaveri [Radeon R6 Graphics]"},
			{ID: 0x130b, Name: "Kaveri [Radeon R4 Graphics]"},
			{ID: 0x130c, Name: "Kaveri [Radeon R7 Graphics]"},
			{ID: 0x130d, Name: "Kaveri [Radeon R6 Graphics]"},
			{ID: 0x130e, Name: "Kaveri [Radeon R5 Graphics]"},
			{ID: 0x130f, Name: "Kaveri [Radeon R7 Graphics]"},
			{ID: 0x1310, Name: "Kaveri"},
			{ID: 0x1311, Name: "Kaveri"},
			{ID: 0x1312, Name: "Kaveri"},
			{ID: 0x1313, Name: "Kaveri [Radeon R7 Graphics]"},
			{ID: 0x1314, Name: "Wrestler HDMI Audio"},
			{ID: 0x1315, Name: "Kaveri [Radeon R5 Graphics]"},
			{ID: 0x1316, Name: "Kaveri [Radeon R5 Graphics]"},
			{ID: 0x1317, Name: "Kaveri"},
			{ID: 0x1318, Name: "Kaveri [Radeon R5 Graphics]"},
			{ID: 0x131b, Name: "Kaveri [Radeon R4 Graphics]"},
			{ID: 0x131c, Name: "Kaveri [Radeon R7 Graphics]"},
			{ID: 0x131d, Name: "Kaveri [Radeon R6 Graphics]"},
			{ID: 0x13e9, Name: "Ariel"},
			{ID: 0x13fe, Name: "Cyan Skillfish"},
			{ID: 0x1478, Name: "Navi 10 XL Upstream Port of PCI Express Switch"},
			{ID: 0x1479, Name: "Navi 10 XL Downstream Port of PCI Express Switch"},
			{ID: 0x154c, Name: "Kryptos [Radeon RX 350]"},
			{ID: 0x154e, Name: "Garfield"},
			{ID: 0x1551, Name: "Arlene"},
			{ID: 0x1552, Name: "Pooky"},
			{ID: 0x1561, Name: "Anubis"},
			{ID: 0x15d8, Name: "Picasso/Raven 2 [Radeon Vega Series / Radeon Vega Mobile Series]"},
			{ID: 0x15dd, Name: "Raven Ridge [Radeon Vega Series / Radeon Vega Mobile Series]"},
			{ID: 0x15de, Name: "Raven/Raven2/Fenghuang HDMI/DP Audio Controller"},
			{ID: 0x15df, Name: "Raven/Raven2/Fenghuang/Renoir Cryptographic Coprocessor"},
			{ID: 0x15e7, Name: "Barcelo"},
			{ID: 0x15ff, Name: "Fenghuang [Zhongshan Subor Z+]"},
			{ID: 0x1607, Name: "Arden"},
			{ID: 0x1636, Name: "Renoir"},
			{ID: 0x1637, Name: "Renoir Radeon High Definition Audio Controller"},
			{ID: 0x1638, Name: "Cezanne"},
			{ID: 0x163f, Name: "VanGogh"},
			{ID: 0x164c, Name: "Lucienne"},
			{ID: 0x164d, Name: "Rembrandt"},
			{ID: 0x1681, Name: "Rembrandt"},
			{ID: 0x1714, Name: "BeaverCreek HDMI Audio [Radeon HD 6500D and 6400G-6600G series]"},
			{ID: 0x3150, Name: "RV380/M24 [Mobility Radeon X600]"},
			{ID: 0x3151, Name: "RV380 GL [FireMV 2400]"},
			{ID: 0x3152, Name: "RV370/M22 [Mobility Radeon X300]"},
			{ID: 0x3154, Name: "RV380/M24 GL [Mobility FireGL V3200]"},
			{ID: 0x3155, Name: "RV380 GL [FireMV 2400]"},
			{ID: 0x3171, Name: "RV380 GL [FireMV 2400] (Secondary)"},
			{ID: 0x3e50, Name: "RV380 [Radeon X550/X600]"},
			{ID: 0x3e54, Name: "RV380 GL [FireGL V3200]"},
			{ID: 0x3e70, Name: "RV380 [Radeon X550/X600] (Secondary)"},
			{ID: 0x4136, Name: "RS100 [Mobility IGP 320M]"},
			{ID: 0x4137, Name: "RS200 [Radeon IGP 340]"},
			{ID: 0x4144, Name: "R300 [Radeon 9500]"},
			{ID: 0x4146, Name: "R300 [Radeon 9700 PRO]"},
			{ID: 0x4147, Name: "R300 GL [FireGL Z1]"},
			{ID: 0x4148, Name: "R350 [Radeon 9800/9800 SE]"},
			{ID: 0x4150, Name: "RV350 [Radeon 9550/9600/X1050 Series]"},
			{ID: 0x4151, Name: "RV350 [Radeon 9600 Series]"},
			{ID: 0x4152, Name: "RV360 [Radeon 9600/X1050 Series]"},
			{ID: 0x4153, Name: "RV350 [Radeon 9550]"},
			{ID: 0x4154, Name: "RV350 GL [FireGL T2]"},
			{ID: 0x4155, Name: "RV350 [Radeon 9600]"},
			{ID: 0x4157, Name: "RV350 GL [FireGL T2]"},
			{ID: 0x4158, Name: "68800AX [Graphics Ultra Pro PCI]"},
			{ID: 0x4164, Name: "R300 [Radeon 9500 PRO] (Secondary)"},
			{ID: 0x4165, Name: "R300 [Radeon 9700 PRO] (Secondary)"},
			{ID: 0x4166, Name: "R300 [Radeon 9700 PRO] (Secondary)"},
			{ID: 0x4168, Name: "RV350 [Radeon 9800 SE] (Secondary)"},
			{ID: 0x4170, Name: "RV350 [Radeon 9550/9600/X1050 Series] (Secondary)"},
			{ID: 0x4171, Name: "RV350 [Radeon 9600] (Secondary)"},
			{ID: 0x4172, Name: "RV350 [Radeon 9600/X1050 Series] (Secondary)"},
			{ID: 0x4173, Name: "RV350 [Radeon 9550] (Secondary)"},
			{ID: 0x4242, Name: "R200 [All-In-Wonder Radeon 8500 DV]"},
			{ID: 0x4243, Name: "R200 PCI Bridge [All-in-Wonder Radeon 8500DV]"},
			{ID: 0x4336, Name: "RS100 [Radeon IGP 320M]"},
			{ID: 0x4337, Name: "RS200M [Radeon IGP 330M/340M/345M/350M]"},
			{ID: 0x4341, Name: "SB200 AC97 Audio Controller"},
			{ID: 0x4342, Name: "SB200 PCI to PCI Bridge"},
			{ID: 0x4345, Name: "SB200 EHCI USB Controller"},
			{ID: 0x4346, Name: "Crayola 6 [XENOS Parent Die (XBOX 360)]"},
			{ID: 0x4347, Name: "SB200 OHCI USB Controller #1"},
			{ID: 0x4348, Name: "SB200 OHCI USB Controller #2"},
			{ID: 0x4349, Name: "SB200 IDE Controller"},
			{ID: 0x434c, Name: "SB200 PCI to LPC Bridge"},
			{ID: 0x434d, Name: "SB200 AC97 Modem Controller"},
			{ID: 0x4353, Name: "SB200 SMBus Controller"},
			{ID: 0x4354, Name: "215CT [Mach64 CT PCI]"},
			{ID: 0x4358, Name: "Mach64 CX [Graphics Xpression]"},
			{ID: 0x4361, Name: "SB300 AC'97 Audio Controller"},
			{ID: 0x4362, Name: "SB300 PCI to PCI Bridge"},
			{ID: 0x4363, Name: "SB300 SMBus Controller"},
			{ID: 0x4365, Name: "SB300 USB Controller (EHCI)"},
			{ID: 0x4367, Name: "SB300 USB Controller (EHCI)"},
			{ID: 0x4368, Name: "SB300 USB Controller (EHCI)"},
			{ID: 0x4369, Name: "SB300 IDE Controller"},
			{ID: 0x436c, Name: "SB300 PCI to LPC Bridge"},
			{ID: 0x436d, Name: "SB300 AC97 Modem Controller"},
			{ID: 0x436e, Name: "SB300 Serial ATA Controller"},
			{ID: 0x4370, Name: "IXP SB400 AC'97 Audio Controller"},
			{ID: 0x4371, Name: "IXP SB4x0 PCI-PCI Bridge"},
			{ID: 0x4372, Name: "IXP SB4x0 SMBus Controller"},
			{ID: 0x4373, Name: "IXP SB4x0 USB2 Host Controller"},
			{ID: 0x4374, Name: "IXP SB4x0 USB Host Controller"},
			{ID: 0x4375, Name: "IXP SB4x0 USB Host Controller"},
			{ID: 0x4376, Name: "IXP SB4x0 IDE Controller"},
			{ID: 0x4377, Name: "IXP SB4x0 PCI-ISA Bridge"},
			{ID: 0x4378, Name: "IXP SB400 AC'97 Modem Controller"},
			{ID: 0x4379, Name: "IXP SB4x0 Serial ATA Controller"},
			{ID: 0x437a, Name: "IXP SB400 Serial ATA Controller"},
			{ID: 0x437b, Name: "IXP SB4x0 High Definition Audio Controller"},
			{ID: 0x4380, Name: "SB600 Non-Raid-5 SATA"},
			{ID: 0x4381, Name: "SB600 SATA Controller (RAID 5 mode)"},
			{ID: 0x4382, Name: "SB600 AC97 Audio"},
			{ID: 0x4383, Name: "SBx00 Azalia (Intel HDA)"},
			{ID: 0x4384, Name: "SBx00 PCI to PCI Bridge"},
			{ID: 0x4385, Name: "SBx00 SMBus Controller"},
			{ID: 0x4386, Name: "SB600 USB Controller (EHCI)"},
			{ID: 0x4387, Name: "SB600 USB (OHCI0)"},
			{ID: 0x4388, Name: "SB600 USB (OHCI1)"},
			{ID: 0x4389, Name: "SB600 USB (OHCI2)"},
			{ID: 0x438a, Name: "SB600 USB (OHCI3)"},
			{ID: 0x438b, Name: "SB600 USB (OHCI4)"},
			{ID: 0x438c, Name: "SB600 IDE"},
			{ID: 0x438d, Name: "SB600 PCI to LPC Bridge"},
			{ID: 0x438e, Name: "SB600 AC97 Modem"},
			{ID: 0x4390, Name: "SB7x0/SB8x0/SB9x0 SATA Controller [IDE mode]"},
			{ID: 0x4391, Name: "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode]"},
			{ID: 0x4392, Name: "SB7x0/SB8x0/SB9x0 SATA Controller [Non-RAID5 mode]"},
			{ID: 0x4393, Name: "SB7x0/SB8x0/SB9x0 SATA Controller [RAID5 mode]"},
			{ID: 0x4394, Name: "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode]"},
			{ID: 0x4395, Name: "SB8x0/SB9x0 SATA Controller [Storage mode]"},
			{ID: 0x4396, Name: "SB7x0/SB8x0/SB9x0 USB EHCI Controller"},
			{ID: 0x4397, Name: "SB7x0/SB8x0/SB9x0 USB OHCI0 Controller"},
			{ID: 0x4398, Name: "SB7x0 USB OHCI1 Controller"},
			{ID: 0x4399, Name: "SB7x0/SB8x0/SB9x0 USB OHCI2 Controller"},
			{ID: 0x439c, Name: "SB7x0/SB8x0/SB9x0 IDE Controller"},
			{ID: 0x439d, Name: "SB7x0/SB8x0/SB9x0 LPC host controller"},
			{ID: 0x43a0, Name: "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 0)"},
			{ID: 0x43a1, Name: "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 1)"},
			{ID: 0x43a2, Name: "SB900 PCI to PCI bridge (PCIE port 2)"},
			{ID: 0x43a3, Name: "SB900 PCI to PCI bridge (PCIE port 3)"},
			{ID: 0x4437, Name: "RS250 [Mobility Radeon 7000 IGP]"},
			{ID: 0x4554, Name: "210888ET [Mach64 ET]"},
			{ID: 0x4630, Name: "XENOS Parent Die (XBOX 360)"},
			{ID: 0x4631, Name: "XENOS Daughter Die (XBOX 360)"},
			{ID: 0x4654, Name: "Mach64 VT"},
			{ID: 0x4742, Name: "Rage 3 [3D Rage PRO AGP 2X]"},
			{ID: 0x4744, Name: "Rage 3 [3D Rage PRO AGP 1X]"},
			{ID: 0x4749, Name: "3D Rage PRO PCI"},
			{ID: 0x474d, Name: "Rage XL AGP 2X"},
			{ID: 0x474e, Name: "Rage XC AGP"},
			{ID: 0x474f, Name: "Rage XL"},
			{ID: 0x4750, Name: "3D Rage Pro PCI"},
			{ID: 0x4752, Name: "Rage 3 [Rage XL PCI]"},
			{ID: 0x4753, Name: "Rage XC"},
			{ID: 0x4754, Name: "Mach64 GT/GT-B [3D Rage I/II]"},
			{ID: 0x4755, Name: "Mach64 GT-B [3D Rage II+ DVD]"},
			{ID: 0x4756, Name: "Rage 2 [3D Rage IIC PCI]"},
			{ID: 0x4757, Name: "Rage 2 [3D Rage IIC AGP]"},
			{ID: 0x4758, Name: "Mach64 GX [WinTurbo]"},
			{ID: 0x4759, Name: "Rage 3 [3D Rage IIC PCI]"},
			{ID: 0x475a, Name: "3D Rage IIC AGP"},
			{ID: 0x4845, Name: "Xilleon 220 HBIU for HDTV2"},
			{ID: 0x4846, Name: "Xilleon 220 IDE for HDTV2"},
			{ID: 0x4847, Name: "Xilleon 220 USB for HDTV2"},
			{ID: 0x4848, Name: "Xilleon 220 DAIO-0 for HDTV2"},
			{ID: 0x4849, Name: "Xilleon 220 DAIO-1 for HDTV2"},
			{ID: 0x484a, Name: "Xilleon 220 LPC for HDTV2"},
			{ID: 0x4850, Name: "Xilleon 215 HBIU for X215"},
			{ID: 0x4851, Name: "Xilleon 215 IDE for X215"},
			{ID: 0x4852, Name: "Xilleon 215 USB for X215"},
			{ID: 0x4853, Name: "Xilleon 215 DAIO-0 for X215"},
			{ID: 0x4854, Name: "Xilleon 215 DAIO-1 for X215"},
			{ID: 0x4855, Name: "Xilleon 225 HBIU for X225"},
			{ID: 0x4856, Name: "Xilleon 225 IDE for X225"},
			{ID: 0x4857, Name: "Xilleon 225 USB for X225"},
			{ID: 0x4858, Name: "Xilleon 225 DAIO-0 for X225"},
			{ID: 0x4859, Name: "Xilleon 225 DAIO-1 for X225"},
			{ID: 0x4860, Name: "Xilleon 210 HBIU for X210"},
			{ID: 0x4861, Name: "Xilleon 210 IDE for X210"},
			{ID: 0x4862, Name: "Xilleon 210 USB for X210"},
			{ID: 0x4863, Name: "Xilleon 210 DAIO-0 for X210"},
			{ID: 0x4864, Name: "Xilleon 210 DAIO-1 for X210"},
			{ID: 0x4865, Name: "Xilleon 226 HBIU for X226"},
			{ID: 0x4866, Name: "Xilleon 226 IDE for X226"},
			{ID: 0x4867, Name: "Xilleon 226 USB for X226"},
			{ID: 0x4868, Name: "Xilleon 226 DAIO-0 for X226"},
			{ID: 0x4869, Name: "Xilleon 226 DAIO-1 for X226"},
			{ID: 0x486a, Name: "Xilleon 240S HBIU for X240S"},
			{ID: 0x486b, Name: "Xilleon 240H HBIU for X240H"},
			{ID: 0x486c, Name: "Xilleon 240S USB for X240S"},
			{ID: 0x486d, Name: "Xilleon 240H USB for X240H"},
			{ID: 0x486e, Name: "Xilleon 250 USB 1.1 for X250"},
			{ID: 0x486f, Name: "Xilleon 260 USB 1.1 for X260"},
			{ID: 0x4870, Name: "Xilleon 250 HBIU for X250"},
			{ID: 0x4871, Name: "Xilleon 250 IDE for X250"},
			{ID: 0x4872, Name: "Xilleon 234/235 HBIU for X234/X235"},
			{ID: 0x4873, Name: "Xilleon 244/245 HBIU for X244/X245"},
			{ID: 0x4874, Name: "Xilleon 234/235 USB 1.1 for X234/X235"},
			{ID: 0x4875, Name: "Xilleon 260 HBIU for X260"},
			{ID: 0x4876, Name: "Xilleon 260 IDE for X260"},
			{ID: 0x4877, Name: "Xilleon 244/245 USB 1.1 for X244/X245"},
			{ID: 0x4878, Name: "Xilleon 270 HBIU for X270"},
			{ID: 0x487b, Name: "Xilleon 242 HBIU for X242"},
			{ID: 0x487d, Name: "Xilleon 242 USB 1.1 for X242"},
			{ID: 0x4880, Name: "Xilleon 254 HBIU for X254"},
			{ID: 0x4881, Name: "Xilleon 254 USB 1.1 for X254"},
			{ID: 0x4882, Name: "Xilleon 255 HBIU for X255"},
			{ID: 0x4883, Name: "Xilleon 255 USB 1.1 for X255"},
			{ID: 0x4884, Name: "Xilleon 243 HBIU for X243"},
			{ID: 0x4885, Name: "Xilleon 243 USB 1.1 for X243"},
			{ID: 0x4886, Name: "Xilleon 233 HBIU for X233"},
			{ID: 0x4887, Name: "Xilleon 233 USB 1.1 for X233"},
			{ID: 0x4888, Name: "Xilleon 143 HBIU for X143"},
			{ID: 0x4889, Name: "Xilleon 143 HBIU for X143L"},
			{ID: 0x488a, Name: "Xilleon 143 HBIU for X143S"},
			{ID: 0x4966, Name: "RV250 [Radeon 9000 Series]"},
			{ID: 0x496e, Name: "RV250 [Radeon 9000] (Secondary)"},
			{ID: 0x4a49, Name: "R420 [Radeon X800 PRO/GTO AGP]"},
			{ID: 0x4a4a, Name: "R420 [Radeon X800 GT AGP]"},
			{ID: 0x4a4b, Name: "R420 [Radeon X800 AGP Series]"},
			{ID: 0x4a4d, Name: "R420 GL [FireGL X3-256]"},
			{ID: 0x4a4e, Name: "RV420/M18 [Mobility Radeon 9800]"},
			{ID: 0x4a4f, Name: "R420 [Radeon X850 AGP]"},
			{ID: 0x4a50, Name: "R420 [Radeon X800 XT Platinum Edition AGP]"},
			{ID: 0x4a54, Name: "R420 [Radeon X800 VE AGP]"},
			{ID: 0x4a69, Name: "R420 [Radeon X800 PRO/GTO] (Secondary)"},
			{ID: 0x4a6a, Name: "R420 [Radeon X800] (Secondary)"},
			{ID: 0x4a6b, Name: "R420 [Radeon X800 XT AGP] (Secondary)"},
			{ID: 0x4a70, Name: "R420 [Radeon X800 XT Platinum Edition AGP] (Secondary)"},
			{ID: 0x4a74, Name: "R420 [Radeon X800 VE] (Secondary)"},
			{ID: 0x4b49, Name: "R481 [Radeon X850 XT AGP]"},
			{ID: 0x4b4b, Name: "R481 [Radeon X850 PRO AGP]"},
			{ID: 0x4b4c, Name: "R481 [Radeon X850 XT Platinum Edition AGP]"},
			{ID: 0x4b69, Name: "R481 [Radeon X850 XT AGP] (Secondary)"},
			{ID: 0x4b6b, Name: "R481 [Radeon X850 PRO AGP] (Secondary)"},
			{ID: 0x4b6c, Name: "R481 [Radeon X850 XT Platinum Edition AGP] (Secondary)"},
			{ID: 0x4c42, Name: "Mach64 LT [3D Rage LT PRO AGP]"},
			{ID: 0x4c46, Name: "Rage Mobility 128 AGP 2X/Mobility M3"},
			{ID: 0x4c47, Name: "3D Rage IIC PCI / Mobility Radeon 7500/7500C"},
			{ID: 0x4c49, Name: "3D Rage LT PRO PCI"},
			{ID: 0x4c4d, Name: "Rage Mobility AGP 2x Series"},
			{ID: 0x4c50, Name: "Rage 3 LT [3D Rage LT PRO PCI]"},
			{ID: 0x4c52, Name: "M1 [Rage Mobility-M1 PCI]"},
			{ID: 0x4c54, Name: "264LT [Mach64 LT]"},
			{ID: 0x4c57, Name: "RV200/M7 [Mobility Radeon 7500]"},
			{ID: 0x4c58, Name: "RV200/M7 GL [Mobility FireGL 7800]"},
			{ID: 0x4c59, Name: "RV100/M6 [Rage/Radeon Mobility Series]"},
			{ID: 0x4c66, Name: "RV250/M9 GL [Mobility FireGL 9000/Radeon 9000]"},
			{ID: 0x4c6e, Name: "RV250/M9 [Mobility Radeon 9000] (Secondary)"},
			{ID: 0x4d46, Name: "Rage Mobility 128 AGP 4X/Mobility M4"},
			{ID: 0x4d52, Name: "Theater 550 PRO PCI [ATI TV Wonder 550]"},
			{ID: 0x4d53, Name: "Theater 550 PRO PCIe"},
			{ID: 0x4e44, Name: "R300 [Radeon 9700/9700 PRO]"},
			{ID: 0x4e45, Name: "R300 [Radeon 9500 PRO/9700]"},
			{ID: 0x4e46, Name: "R300 [Radeon 9600 TX]"},
			{ID: 0x4e47, Name: "R300 GL [FireGL X1]"},
			{ID: 0x4e48, Name: "R350 [Radeon 9800 Series]"},
			{ID: 0x4e49, Name: "R350 [Radeon 9800]"},
			{ID: 0x4e4a, Name: "R360 [Radeon 9800 XXL/XT]"},
			{ID: 0x4e4b, Name: "R350 GL [FireGL X2 AGP Pro]"},
			{ID: 0x4e50, Name: "RV350/M10 / RV360/M11 [Mobility Radeon 9600 (PRO) / 9700]"},
			{ID: 0x4e51, Name: "RV350 [Radeon 9550/9600/X1050 Series]"},
			{ID: 0x4e52, Name: "RV350/M10 [Mobility Radeon 9500/9700 SE]"},
			{ID: 0x4e54, Name: "RV350/M10 GL [Mobility FireGL T2]"},
			{ID: 0x4e56, Name: "RV360/M12 [Mobility Radeon 9550]"},
			{ID: 0x4e64, Name: "R300 [Radeon 9700 PRO] (Secondary)"},
			{ID: 0x4e65, Name: "R300 [Radeon 9500 PRO] (Secondary)"},
			{ID: 0x4e66, Name: "RV350 [Radeon 9600] (Secondary)"},
			{ID: 0x4e67, Name: "R300 GL [FireGL X1] (Secondary)"},
			{ID: 0x4e68, Name: "R350 [Radeon 9800 PRO] (Secondary)"},
			{ID: 0x4e69, Name: "R350 [Radeon 9800] (Secondary)"},
			{ID: 0x4e6a, Name: "RV350 [Radeon 9800 XT] (Secondary)"},
			{ID: 0x4e71, Name: "RV350/M10 [Mobility Radeon 9600] (Secondary)"},
			{ID: 0x4f72, Name: "RV250 [Radeon 9000 Series]"},
			{ID: 0x4f73, Name: "RV250 [Radeon 9000 Series] (Secondary)"},
			{ID: 0x5044, Name: "All-In-Wonder 128 PCI"},
			{ID: 0x5046, Name: "Rage 4 [Rage 128 PRO AGP 4X]"},
			{ID: 0x5050, Name: "Rage 4 [Rage 128 PRO PCI / Xpert 128 PCI]"},
			{ID: 0x5052, Name: "Rage 4 [Rage 128 PRO AGP 4X]"},
			{ID: 0x5144, Name: "R100 [Radeon 7200 / All-In-Wonder Radeon]"},
			{ID: 0x5148, Name: "R200 GL [FireGL 8800]"},
			{ID: 0x514c, Name: "R200 [Radeon 8500/8500 LE]"},
			{ID: 0x514d, Name: "R200 [Radeon 9100]"},
			{ID: 0x5157, Name: "RV200 [Radeon 7500/7500 LE]"},
			{ID: 0x5159, Name: "RV100 [Radeon 7000 / Radeon VE]"},
			{ID: 0x515e, Name: "ES1000"},
			{ID: 0x5245, Name: "Rage 128 GL PCI"},
			{ID: 0x5246, Name: "Rage 128 (Rage 4) series"},
			{ID: 0x524b, Name: "Rage 128 VR PCI"},
			{ID: 0x524c, Name: "Rage 128 VR AGP"},
			{ID: 0x534d, Name: "Rage 128 4X AGP 4x"},
			{ID: 0x5354, Name: "Mach 64 VT"},
			{ID: 0x5446, Name: "Rage 128 PRO Ultra AGP 4x"},
			{ID: 0x5452, Name: "Rage 128 PRO Ultra4XL VR-R AGP"},
			{ID: 0x5460, Name: "RV370/M22 [Mobility Radeon X300]"},
			{ID: 0x5461, Name: "RV370/M22 [Mobility Radeon X300]"},
			{ID: 0x5462, Name: "RV380/M24C [Mobility Radeon X600 SE]"},
			{ID: 0x5464, Name: "RV370/M22 GL [Mobility FireGL V3100]"},
			{ID: 0x5549, Name: "R423 [Radeon X800 GTO]"},
			{ID: 0x554a, Name: "R423 [Radeon X800 XT Platinum Edition]"},
			{ID: 0x554b, Name: "R423 [Radeon X800 GT/SE]"},
			{ID: 0x554d, Name: "R480 [Radeon X800 GTO2/XL]"},
			{ID: 0x554e, Name: "R430 [All-In-Wonder X800 GT]"},
			{ID: 0x554f, Name: "R430 [Radeon X800]"},
			{ID: 0x5550, Name: "R423 GL [FireGL V7100]"},
			{ID: 0x5551, Name: "R423 GL [FireGL V5100]"},
			{ID: 0x5569, Name: "R423 [Radeon X800 PRO] (Secondary)"},
			{ID: 0x556b, Name: "R423 [Radeon X800 GT] (Secondary)"},
			{ID: 0x556d, Name: "R480 [Radeon X800 GTO2/XL] (Secondary)"},
			{ID: 0x556f, Name: "R430 [Radeon X800] (Secondary)"},
			{ID: 0x5571, Name: "R423 GL [FireGL V5100] (Secondary)"},
			{ID: 0x564b, Name: "RV410/M26 GL [Mobility FireGL V5000]"},
			{ID: 0x564f, Name: "RV410/M26 [Mobility Radeon X700 XL]"},
			{ID: 0x5652, Name: "RV410/M26 [Mobility Radeon X700]"},
			{ID: 0x5653, Name: "RV410/M26 [Mobility Radeon X700]"},
			{ID: 0x5654, Name: "Mach64 VT [Video Xpression]"},
			{ID: 0x5655, Name: "264VT3 [Mach64 VT3]"},
			{ID: 0x5656, Name: "Mach64 VT4 [Video Xpression+]"},
			{ID: 0x5657, Name: "RV410 [Radeon X550 XTX / X700]"},
			{ID: 0x5830, Name: "RS300 Host Bridge"},
			{ID: 0x5831, Name: "RS300 Host Bridge"},
			{ID: 0x5832, Name: "RS300 Host Bridge"},
			{ID: 0x5833, Name: "RS300 Host Bridge"},
			{ID: 0x5834, Name: "RS300 [Radeon 9100 IGP]"},
			{ID: 0x5835, Name: "RS300M [Mobility Radeon 9100 IGP]"},
			{ID: 0x5838, Name: "RS300 AGP Bridge"},
			{ID: 0x5854, Name: "RS480 [Radeon Xpress 200 Series] (Secondary)"},
			{ID: 0x5874, Name: "RS480 [Radeon Xpress 1150] (Secondary)"},
			{ID: 0x5940, Name: "RV280 [Radeon 9200 PRO] (Secondary)"},
			{ID: 0x5941, Name: "RV280 [Radeon 9200] (Secondary)"},
			{ID: 0x5944, Name: "RV280 [Radeon 9200 SE PCI]"},
			{ID: 0x5950, Name: "RS480/RS482/RS485 Host Bridge"},
			{ID: 0x5951, Name: "RX480/RX482 Host Bridge"},
			{ID: 0x5952, Name: "RD580 Host Bridge"},
			{ID: 0x5954, Name: "RS480 [Radeon Xpress 200 Series]"},
			{ID: 0x5955, Name: "RS480M [Mobility Radeon Xpress 200]"},
			{ID: 0x5956, Name: "RD790 Host Bridge"},
			{ID: 0x5957, Name: "RX780/RX790 Host Bridge"},
			{ID: 0x5958, Name: "RD780 Host Bridge"},
			{ID: 0x5960, Name: "RV280 [Radeon 9200 PRO / 9250]"},
			{ID: 0x5961, Name: "RV280 [Radeon 9200]"},
			{ID: 0x5962, Name: "RV280 [Radeon 9200]"},
			{ID: 0x5964, Name: "RV280 [Radeon 9200 SE]"},
			{ID: 0x5965, Name: "RV280 GL [FireMV 2200 PCI]"},
			{ID: 0x5974, Name: "RS482/RS485 [Radeon Xpress 1100/1150]"},
			{ID: 0x5975, Name: "RS482M [Mobility Radeon Xpress 200]"},
			{ID: 0x5978, Name: "RX780/RD790 PCI to PCI bridge (external gfx0 port A)"},
			{ID: 0x5979, Name: "RD790 PCI to PCI bridge (external gfx0 port B)"},
			{ID: 0x597a, Name: "RD790 PCI to PCI bridge (PCI express gpp port A)"},
			{ID: 0x597b, Name: "RX780/RD790 PCI to PCI bridge (PCI express gpp port B)"},
			{ID: 0x597c, Name: "RD790 PCI to PCI bridge (PCI express gpp port C)"},
			{ID: 0x597d, Name: "RX780/RD790 PCI to PCI bridge (PCI express gpp port D)"},
			{ID: 0x597e, Name: "RD790 PCI to PCI bridge (PCI express gpp port E)"},
			{ID: 0x597f, Name: "RD790 PCI to PCI bridge (PCI express gpp port F)"},
			{ID: 0x5980, Name: "RD790 PCI to PCI bridge (external gfx1 port A)"},
			{ID: 0x5981, Name: "RD790 PCI to PCI bridge (external gfx1 port B)"},
			{ID: 0x5982, Name: "RD790 PCI to PCI bridge (NB-SB link)"},
			{ID: 0x5a10, Name: "RD890 Northbridge only dual slot (2x16) PCI-e GFX Hydra part"},
			{ID: 0x5a11, Name: "RD890 Northbridge only single slot PCI-e GFX Hydra part"},
			{ID: 0x5a12, Name: "RD890 Northbridge only dual slot (2x8) PCI-e GFX Hydra part"},
			{ID: 0x5a13, Name: "RD890S/SR5650 Host Bridge"},
			{ID: 0x5a14, Name: "RD9x0/RX980 Host Bridge"},
			{ID: 0x5a15, Name: "RD890 PCI to PCI bridge (PCI express gpp port A)"},
			{ID: 0x5a16, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GFX port 0)"},
			{ID: 0x5a17, Name: "RD890/RD9x0 PCI to PCI bridge (PCI Express GFX port 1)"},
			{ID: 0x5a18, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 0)"},
			{ID: 0x5a19, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 1)"},
			{ID: 0x5a1a, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 2)"},
			{ID: 0x5a1b, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 3)"},
			{ID: 0x5a1c, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 4)"},
			{ID: 0x5a1d, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 5)"},
			{ID: 0x5a1e, Name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP2 Port 0)"},
			{ID: 0x5a1f, Name: "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 0)"},
			{ID: 0x5a20, Name: "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 1)"},
			{ID: 0x5a23, Name: "RD890S/RD990 I/O Memory Management Unit (IOMMU)"},
			{ID: 0x5a31, Name: "RC410 Host Bridge"},
			{ID: 0x5a33, Name: "RS400 Host Bridge"},
			{ID: 0x5a34, Name: "RS4xx PCI Express Port [ext gfx]"},
			{ID: 0x5a36, Name: "RC4xx/RS4xx PCI Express Port 1"},
			{ID: 0x5a37, Name: "RC4xx/RS4xx PCI Express Port 2"},
			{ID: 0x5a38, Name: "RC4xx/RS4xx PCI Express Port 3"},
			{ID: 0x5a39, Name: "RC4xx/RS4xx PCI Express Port 4"},
			{ID: 0x5a3f, Name: "RC4xx/RS4xx PCI Bridge [int gfx]"},
			{ID: 0x5a41, Name: "RS400 [Radeon Xpress 200]"},
			{ID: 0x5a42, Name: "RS400M [Radeon Xpress 200M]"},
			{ID: 0x5a61, Name: "RC410 [Radeon Xpress 200/1100]"},
			{ID: 0x5a62, Name: "RC410M [Mobility Radeon Xpress 200M]"},
			{ID: 0x5b60, Name: "RV370 [Radeon X300]"},
			{ID: 0x5b62, Name: "RV370 [Radeon X600/X600 SE]"},
			{ID: 0x5b63, Name: "RV370 [Radeon X300/X550/X1050 Series]"},
			{ID: 0x5b64, Name: "RV370 GL [FireGL V3100]"},
			{ID: 0x5b65, Name: "RV370 GL [FireMV 2200]"},
			{ID: 0x5b66, Name: "RV370X"},
			{ID: 0x5b70, Name: "RV370 [Radeon X300 SE]"},
			{ID: 0x5b72, Name: "RV380 [Radeon X300/X550/X1050 Series] (Secondary)"},
			{ID: 0x5b73, Name: "RV370 [Radeon X300/X550/X1050 Series] (Secondary)"},
			{ID: 0x5b74, Name: "RV370 GL [FireGL V3100] (Secondary)"},
			{ID: 0x5b75, Name: "RV370 GL [FireMV 2200] (Secondary)"},
			{ID: 0x5c61, Name: "RV280/M9+ [Mobility Radeon 9200 AGP]"},
			{ID: 0x5c63, Name: "RV280/M9+ [Mobility Radeon 9200 AGP]"},
			{ID: 0x5d44, Name: "RV280 [Radeon 9200 SE] (Secondary)"},
			{ID: 0x5d45, Name: "RV280 GL [FireMV 2200 PCI] (Secondary)"},
			{ID: 0x5d48, Name: "R423/M28 [Mobility Radeon X800 XT]"},
			{ID: 0x5d49, Name: "R423/M28 GL [Mobility FireGL V5100]"},
			{ID: 0x5d4a, Name: "R423/M28 [Mobility Radeon X800]"},
			{ID: 0x5d4d, Name: "R480 [Radeon X850 XT Platinum Edition]"},
			{ID: 0x5d4e, Name: "R480 [Radeon X850 SE]"},
			{ID: 0x5d4f, Name: "R480 [Radeon X800 GTO]"},
			{ID: 0x5d50, Name: "R480 GL [FireGL V7200]"},
			{ID: 0x5d52, Name: "R480 [Radeon X850 XT]"},
			{ID: 0x5d57, Name: "R423 [Radeon X800 XT]"},
			{ID: 0x5d6d, Name: "R480 [Radeon X850 XT Platinum Edition] (Secondary)"},
			{ID: 0x5d6f, Name: "R480 [Radeon X800 GTO] (Secondary)"},
			{ID: 0x5d72, Name: "R480 [Radeon X850 XT] (Secondary)"},
			{ID: 0x5d77, Name: "R423 [Radeon X800 XT] (Secondary)"},
			{ID: 0x5e48, Name: "RV410 GL [FireGL V5000]"},
			{ID: 0x5e49, Name: "RV410 [Radeon X700 Series]"},
			{ID: 0x5e4a, Name: "RV410 [Radeon X700 XT]"},
			{ID: 0x5e4b, Name: "RV410 [Radeon X700 PRO]"},
			{ID: 0x5e4c, Name: "RV410 [Radeon X700 SE]"},
			{ID: 0x5e4d, Name: "RV410 [Radeon X700]"},
			{ID: 0x5e4f, Name: "RV410 [Radeon X700]"},
			{ID: 0x5e6b, Name: "RV410 [Radeon X700 PRO] (Secondary)"},
			{ID: 0x5e6d, Name: "RV410 [Radeon X700] (Secondary)"},
			{ID: 0x5f57, Name: "R423 [Radeon X800 XT]"},
			{ID: 0x6600, Name: "Mars [Radeon HD 8670A/8670M/8750M / R7 M370]"},
			{ID: 0x6601, Name: "Mars [Radeon HD 8730M]"},
			{ID: 0x6604, Name: "Opal XT [Radeon R7 M265/M365X/M465]"},
			{ID: 0x6605, Name: "Opal PRO [Radeon R7 M260X]"},
			{ID: 0x6606, Name: "Mars XTX [Radeon HD 8790M]"},
			{ID: 0x6607, Name: "Mars LE [Radeon HD 8530M / R5 M240]"},
			{ID: 0x6608, Name: "Oland GL [FirePro W2100]"},
			{ID: 0x6609, Name: "Oland GL [FirePro W2100 / Barco MXRT 2600]"},
			{ID: 0x6610, Name: "Oland XT [Radeon HD 8670 / R5 340X OEM / R7 250/350/350X OEM]"},
			{ID: 0x6611, Name: "Oland [Radeon HD 8570 / R5 430 OEM / R7 240/340 / Radeon 520 OEM]"},
			{ID: 0x6613, Name: "Oland PRO [Radeon R7 240/340 / Radeon 520]"},
			{ID: 0x6631, Name: "Oland"},
			{ID: 0x6640, Name: "Saturn XT [FirePro M6100]"},
			{ID: 0x6641, Name: "Saturn PRO [Radeon HD 8930M]"},
			{ID: 0x6646, Name: "Bonaire XT [Radeon R9 M280X]"},
			{ID: 0x6647, Name: "Saturn PRO/XT [Radeon R9 M270X/M280X]"},
			{ID: 0x6649, Name: "Bonaire [FirePro W5100]"},
			{ID: 0x664d, Name: "Bonaire [FirePro W5100 / Barco MXRT-5600]"},
			{ID: 0x6650, Name: "Bonaire"},
			{ID: 0x6651, Name: "Bonaire"},
			{ID: 0x6658, Name: "Bonaire XTX [Radeon R7 260X/360]"},
			{ID: 0x665c, Name: "Bonaire XT [Radeon HD 7790/8770 / R7 360 / R9 260/360 OEM]"},
			{ID: 0x665d, Name: "Bonaire [Radeon R7 200 Series]"},
			{ID: 0x665f, Name: "Tobago PRO [Radeon R7 360 / R9 360 OEM]"},
			{ID: 0x6660, Name: "Sun XT [Radeon HD 8670A/8670M/8690M / R5 M330 / M430 / Radeon 520 Mobile]"},
			{ID: 0x6663, Name: "Sun PRO [Radeon HD 8570A/8570M]"},
			{ID: 0x6664, Name: "Jet XT [Radeon R5 M240]"},
			{ID: 0x6665, Name: "Jet PRO [Radeon R5 M230 / R7 M260DX / Radeon 520 Mobile]"},
			{ID: 0x6667, Name: "Jet ULT [Radeon R5 M230]"},
			{ID: 0x666f, Name: "Sun LE [Radeon HD 8550M / R5 M230]"},
			{ID: 0x66a0, Name: "Vega 20 [Radeon Instinct]"},
			{ID: 0x66a1, Name: "Vega 20 [Radeon Pro VII/Radeon Instinct MI50 32GB]"},
			{ID: 0x66a2, Name: "Vega 20"},
			{ID: 0x66a3, Name: "Vega 20 [Radeon Pro Vega II/Radeon Pro Vega II Duo]"},
			{ID: 0x66a7, Name: "Vega 20 [Radeon Pro Vega 20]"},
			{ID: 0x66af, Name: "Vega 20 [Radeon VII]"},
			{ID: 0x6704, Name: "Cayman PRO GL [FirePro V7900]"},
			{ID: 0x6707, Name: "Cayman LE GL [FirePro V5900]"},
			{ID: 0x6718, Name: "Cayman XT [Radeon HD 6970]"},
			{ID: 0x6719, Name: "Cayman PRO [Radeon HD 6950]"},
			{ID: 0x671c, Name: "Antilles [Radeon HD 6990]"},
			{ID: 0x671d, Name: "Antilles [Radeon HD 6990]"},
			{ID: 0x671f, Name: "Cayman CE [Radeon HD 6930]"},
			{ID: 0x6720, Name: "Blackcomb [Radeon HD 6970M/6990M]"},
			{ID: 0x6738, Name: "Barts XT [Radeon HD 6870]"},
			{ID: 0x6739, Name: "Barts PRO [Radeon HD 6850]"},
			{ID: 0x673e, Name: "Barts LE [Radeon HD 6790]"},
			{ID: 0x6740, Name: "Whistler [Radeon HD 6730M/6770M/7690M XT]"},
			{ID: 0x6741, Name: "Whistler [Radeon HD 6630M/6650M/6750M/7670M/7690M]"},
			{ID: 0x6742, Name: "Whistler LE [Radeon HD 6610M/7610M]"},
			{ID: 0x6743, Name: "Whistler [Radeon E6760]"},
			{ID: 0x6749, Name: "Turks GL [FirePro V4900]"},
			{ID: 0x674a, Name: "Turks GL [FirePro V3900]"},
			{ID: 0x6750, Name: "Onega [Radeon HD 6650A/7650A]"},
			{ID: 0x6751, Name: "Turks [Radeon HD 7650A/7670A]"},
			{ID: 0x6758, Name: "Turks XT [Radeon HD 6670/7670]"},
			{ID: 0x6759, Name: "Turks PRO [Radeon HD 6570/7570/8550 / R5 230]"},
			{ID: 0x675b, Name: "Turks [Radeon HD 7600 Series]"},
			{ID: 0x675d, Name: "Turks PRO [Radeon HD 7570]"},
			{ID: 0x675f, Name: "Turks LE [Radeon HD 5570/6510/7510/8510]"},
			{ID: 0x6760, Name: "Seymour [Radeon HD 6400M/7400M Series]"},
			{ID: 0x6761, Name: "Seymour LP [Radeon HD 6430M]"},
			{ID: 0x6763, Name: "Seymour [Radeon E6460]"},
			{ID: 0x6764, Name: "Seymour [Radeon HD 6400M Series]"},
			{ID: 0x6765, Name: "Seymour [Radeon HD 6400M Series]"},
			{ID: 0x6766, Name: "Caicos"},
			{ID: 0x6767, Name: "Caicos"},
			{ID: 0x6768, Name: "Caicos"},
			{ID: 0x6770, Name: "Caicos [Radeon HD 6450A/7450A]"},
			{ID: 0x6771, Name: "Caicos XTX [Radeon HD 8490 / R5 235X OEM]"},
			{ID: 0x6772, Name: "Caicos [Radeon HD 7450A]"},
			{ID: 0x6778, Name: "Caicos XT [Radeon HD 7470/8470 / R5 235/310 OEM]"},
			{ID: 0x6779, Name: "Caicos [Radeon HD 6450/7450/8450 / R5 230 OEM]"},
			{ID: 0x677b, Name: "Caicos PRO [Radeon HD 7450]"},
			{ID: 0x6780, Name: "Tahiti XT GL [FirePro W9000]"},
			{ID: 0x6784, Name: "Tahiti [FirePro Series Graphics Adapter]"},
			{ID: 0x6788, Name: "Tahiti [FirePro Series Graphics Adapter]"},
			{ID: 0x678a, Name: "Tahiti PRO GL [FirePro Series]"},
			{ID: 0x6798, Name: "Tahiti XT [Radeon HD 7970/8970 OEM / R9 280X]"},
			{ID: 0x679a, Name: "Tahiti PRO [Radeon HD 7950/8950 OEM / R9 280]"},
			{ID: 0x679b, Name: "Malta [Radeon HD 7990/8990 OEM]"},
			{ID: 0x679e, Name: "Tahiti LE [Radeon HD 7870 XT]"},
			{ID: 0x679f, Name: "Tahiti"},
			{ID: 0x67a0, Name: "Hawaii XT GL [FirePro W9100]"},
			{ID: 0x67a1, Name: "Hawaii PRO GL [FirePro W8100]"},
			{ID: 0x67a2, Name: "Hawaii GL"},
			{ID: 0x67a8, Name: "Hawaii"},
			{ID: 0x67a9, Name: "Hawaii"},
			{ID: 0x67aa, Name: "Hawaii"},
			{ID: 0x67b0, Name: "Hawaii XT / Grenada XT [Radeon R9 290X/390X]"},
			{ID: 0x67b1, Name: "Hawaii PRO [Radeon R9 290/390]"},
			{ID: 0x67b8, Name: "Hawaii XT [Radeon R9 290X Engineering Sample]"},
			{ID: 0x67b9, Name: "Vesuvius [Radeon R9 295X2]"},
			{ID: 0x67be, Name: "Hawaii LE"},
			{ID: 0x67c0, Name: "Ellesmere [Radeon Pro WX 7100 Mobile]"},
			{ID: 0x67c2, Name: "Ellesmere [Radeon Pro V7300X / V7350x2]"},
			{ID: 0x67c4, Name: "Ellesmere [Radeon Pro WX 7100]"},
			{ID: 0x67c7, Name: "Ellesmere [Radeon Pro WX 5100]"},
			{ID: 0x67ca, Name: "Ellesmere [Polaris10]"},
			{ID: 0x67cc, Name: "Ellesmere [Polaris10]"},
			{ID: 0x67cf, Name: "Ellesmere [Polaris10]"},
			{ID: 0x67d0, Name: "Ellesmere [Radeon Pro V7300X / V7350x2]"},
			{ID: 0x67d4, Name: "Ellesmere [Radeon Pro WX 7100 / Barco MXRT-8700]"},
			{ID: 0x67d7, Name: "Ellesmere [Radeon Pro WX 5100 / Barco MXRT-6700]"},
			{ID: 0x67df, Name: "Ellesmere [Radeon RX 470/480/570/570X/580/580X/590]"},
			{ID: 0x67e0, Name: "Baffin [Radeon Pro WX 4170]"},
			{ID: 0x67e1, Name: "Baffin [Polaris11]"},
			{ID: 0x67e3, Name: "Baffin [Radeon Pro WX 4100]"},
			{ID: 0x67e8, Name: "Baffin [Radeon Pro WX 4130/4150]"},
			{ID: 0x67e9, Name: "Baffin [Polaris11]"},
			{ID: 0x67eb, Name: "Baffin [Radeon Pro V5300X]"},
			{ID: 0x67ef, Name: "Baffin [Radeon RX 460/560D / Pro 450/455/460/555/555X/560/560X]"},
			{ID: 0x67ff, Name: "Baffin [Radeon RX 550 640SP / RX 560/560X]"},
			{ID: 0x6800, Name: "Wimbledon XT [Radeon HD 7970M]"},
			{ID: 0x6801, Name: "Neptune XT [Radeon HD 8970M]"},
			{ID: 0x6802, Name: "Wimbledon"},
			{ID: 0x6806, Name: "Neptune"},
			{ID: 0x6808, Name: "Pitcairn XT GL [FirePro W7000]"},
			{ID: 0x6809, Name: "Pitcairn LE GL [FirePro W5000]"},
			{ID: 0x6810, Name: "Curacao XT / Trinidad XT [Radeon R7 370 / R9 270X/370X]"},
			{ID: 0x6811, Name: "Curacao PRO [Radeon R7 370 / R9 270/370 OEM]"},
			{ID: 0x6816, Name: "Pitcairn"},
			{ID: 0x6817, Name: "Pitcairn"},
			{ID: 0x6818, Name: "Pitcairn XT [Radeon HD 7870 GHz Edition]"},
			{ID: 0x6819, Name: "Pitcairn PRO [Radeon HD 7850 / R7 265 / R9 270 1024SP]"},
			{ID: 0x6820, Name: "Venus XTX [Radeon HD 8890M / R9 M275X/M375X]"},
			{ID: 0x6821, Name: "Venus XT [Radeon HD 8870M / R9 M270X/M370X]"},
			{ID: 0x6822, Name: "Venus PRO [Radeon E8860]"},
			{ID: 0x6823, Name: "Venus PRO [Radeon HD 8850M / R9 M265X]"},
			{ID: 0x6825, Name: "Heathrow XT [Radeon HD 7870M]"},
			{ID: 0x6826, Name: "Chelsea LP [Radeon HD 7700M Series]"},
			{ID: 0x6827, Name: "Heathrow PRO [Radeon HD 7850M/8850M]"},
			{ID: 0x6828, Name: "Cape Verde PRO [FirePro W600]"},
			{ID: 0x6829, Name: "Cape Verde"},
			{ID: 0x682a, Name: "Venus PRO"},
			{ID: 0x682b, Name: "Cape Verde PRO / Venus LE / Tropo PRO-L [Radeon HD 8830M / R7 250 / R7 M465X]"},
			{ID: 0x682c, Name: "Cape Verde GL [FirePro W4100]"},
			{ID: 0x682d, Name: "Chelsea XT GL [FirePro M4000]"},
			{ID: 0x682f, Name: "Chelsea LP [Radeon HD 7730M]"},
			{ID: 0x6835, Name: "Cape Verde PRX [Radeon R9 255 OEM]"},
			{ID: 0x6837, Name: "Cape Verde LE [Radeon HD 7730/8730]"},
			{ID: 0x683d, Name: "Cape Verde XT [Radeon HD 7770/8760 / R7 250X]"},
			{ID: 0x683f, Name: "Cape Verde PRO [Radeon HD 7750/8740 / R7 250E]"},
			{ID: 0x6840, Name: "Thames [Radeon HD 7500M/7600M Series]"},
			{ID: 0x6841, Name: "Thames [Radeon HD 7550M/7570M/7650M]"},
			{ID: 0x6842, Name: "Thames LE [Radeon HD 7000M Series]"},
			{ID: 0x6843, Name: "Thames [Radeon HD 7670M]"},
			{ID: 0x6860, Name: "Vega 10 [Radeon Instinct MI25]"},
			{ID: 0x6861, Name: "Vega 10 XT [Radeon PRO WX 9100]"},
			{ID: 0x6862, Name: "Vega 10 XT [Radeon PRO SSG]"},
			{ID: 0x6863, Name: "Vega 10 XTX [Radeon Vega Frontier Edition]"},
			{ID: 0x6864, Name: "Vega 10 [Radeon Pro V340]"},
			{ID: 0x6867, Name: "Vega 10 XL [Radeon Pro Vega 56]"},
			{ID: 0x6868, Name: "Vega 10 [Radeon PRO WX 8100/8200]"},
			{ID: 0x6869, Name: "Vega 10 XGA [Radeon Pro Vega 48]"},
			{ID: 0x686a, Name: "Vega 10 LEA"},
			{ID: 0x686b, Name: "Vega 10 XTXA [Radeon Pro Vega 64X]"},
			{ID: 0x686c, Name: "Vega 10 [Radeon Instinct MI25 MxGPU]"},
			{ID: 0x686d, Name: "Vega 10 GLXTA"},
			{ID: 0x686e, Name: "Vega 10 GLXLA"},
			{ID: 0x687f, Name: "Vega 10 XL/XT [Radeon RX Vega 56/64]"},
			{ID: 0x6880, Name: "Lexington [Radeon HD 6550M]"},
			{ID: 0x6888, Name: "Cypress XT [FirePro V8800]"},
			{ID: 0x6889, Name: "Cypress PRO [FirePro V7800]"},
			{ID: 0x688a, Name: "Cypress XT [FirePro V9800]"},
			{ID: 0x688c, Name: "Cypress XT GL [FireStream 9370]"},
			{ID: 0x688d, Name: "Cypress PRO GL [FireStream 9350]"},
			{ID: 0x6898, Name: "Cypress XT [Radeon HD 5870]"},
			{ID: 0x6899, Name: "Cypress PRO [Radeon HD 5850]"},
			{ID: 0x689b, Name: "Cypress PRO [Radeon HD 6800 Series]"},
			{ID: 0x689c, Name: "Hemlock [Radeon HD 5970]"},
			{ID: 0x689d, Name: "Hemlock [Radeon HD 5970]"},
			{ID: 0x689e, Name: "Cypress LE [Radeon HD 5830]"},
			{ID: 0x68a0, Name: "Broadway XT [Mobility Radeon HD 5870]"},
			{ID: 0x68a1, Name: "Broadway PRO [Mobility Radeon HD 5850]"},
			{ID: 0x68a8, Name: "Granville [Radeon HD 6850M/6870M]"},
			{ID: 0x68a9, Name: "Juniper XT [FirePro V5800]"},
			{ID: 0x68b8, Name: "Juniper XT [Radeon HD 5770]"},
			{ID: 0x68b9, Name: "Juniper LE [Radeon HD 5670 640SP Edition]"},
			{ID: 0x68ba, Name: "Juniper XT [Radeon HD 6770]"},
			{ID: 0x68be, Name: "Juniper PRO [Radeon HD 5750]"},
			{ID: 0x68bf, Name: "Juniper PRO [Radeon HD 6750]"},
			{ID: 0x68c0, Name: "Madison [Mobility Radeon HD 5730 / 6570M]"},
			{ID: 0x68c1, Name: "Madison [Mobility Radeon HD 5650/5750 / 6530M/6550M]"},
			{ID: 0x68c7, Name: "Pinewood [Mobility Radeon HD 5570/6550A]"},
			{ID: 0x68c8, Name: "Redwood XT GL [FirePro V4800]"},
			{ID: 0x68c9, Name: "Redwood PRO GL [FirePro V3800]"},
			{ID: 0x68d8, Name: "Redwood XT [Radeon HD 5670/5690/5730]"},
			{ID: 0x68d9, Name: "Redwood PRO [Radeon HD 5550/5570/5630/6510/6610/7570]"},
			{ID: 0x68da, Name: "Redwood LE [Radeon HD 5550/5570/5630/6390/6490/7570]"},
			{ID: 0x68de, Name: "Redwood"},
			{ID: 0x68e0, Name: "Park [Mobility Radeon HD 5430/5450/5470]"},
			{ID: 0x68e1, Name: "Park [Mobility Radeon HD 5430]"},
			{ID: 0x68e4, Name: "Robson CE [Radeon HD 6370M/7370M]"},
			{ID: 0x68e5, Name: "Robson LE [Radeon HD 6330M]"},
			{ID: 0x68e8, Name: "Cedar"},
			{ID: 0x68e9, Name: "Cedar [ATI FirePro (FireGL) Graphics Adapter]"},
			{ID: 0x68f1, Name: "Cedar GL [FirePro 2460]"},
			{ID: 0x68f2, Name: "Cedar GL [FirePro 2270]"},
			{ID: 0x68f8, Name: "Cedar [Radeon HD 7300 Series]"},
			{ID: 0x68f9, Name: "Cedar [Radeon HD 5000/6000/7350/8350 Series]"},
			{ID: 0x68fa, Name: "Cedar [Radeon HD 7350/8350 / R5 220]"},
			{ID: 0x68fe, Name: "Cedar LE"},
			{ID: 0x6900, Name: "Topaz XT [Radeon R7 M260/M265 / M340/M360 / M440/M445 / 530/535 / 620/625 Mobile]"},
			{ID: 0x6901, Name: "Topaz PRO [Radeon R5 M255]"},
			{ID: 0x6907, Name: "Meso XT [Radeon R5 M315]"},
			{ID: 0x6920, Name: "Amethyst [Radeon R9 M395/ M395X Mac Edition]"},
			{ID: 0x6921, Name: "Amethyst XT [Radeon R9 M295X / M390X]"},
			{ID: 0x6929, Name: "Tonga XT GL [FirePro S7150]"},
			{ID: 0x692b, Name: "Tonga PRO GL [FirePro W7100]"},
			{ID: 0x692f, Name: "Tonga XTV GL [FirePro S7150V]"},
			{ID: 0x6938, Name: "Tonga XT / Amethyst XT [Radeon R9 380X / R9 M295X]"},
			{ID: 0x6939, Name: "Tonga PRO [Radeon R9 285/380]"},
			{ID: 0x693b, Name: "Tonga PRO GL [FirePro W7100 / Barco MXRT-7600]"},
			{ID: 0x694c, Name: "Polaris 22 XT [Radeon RX Vega M GH]"},
			{ID: 0x694e, Name: "Polaris 22 XL [Radeon RX Vega M GL]"},
			{ID: 0x694f, Name: "Polaris 22 MGL XL [Radeon Pro WX Vega M GL]"},
			{ID: 0x6980, Name: "Polaris12"},
			{ID: 0x6981, Name: "Lexa XT [Radeon PRO WX 3200]"},
			{ID: 0x6985, Name: "Lexa XT [Radeon PRO WX 3100]"},
			{ID: 0x6986, Name: "Polaris12"},
			{ID: 0x6987, Name: "Lexa [Radeon 540X/550X/630 / RX 640 / E9171 MCM]"},
			{ID: 0x698f, Name: "Lexa XT [Radeon PRO WX 3100 / Barco MXRT 4700]"},
			{ID: 0x6995, Name: "Lexa XT [Radeon PRO WX 2100]"},
			{ID: 0x699f, Name: "Lexa PRO [Radeon 540/540X/550/550X / RX 540X/550/550X]"},
			{ID: 0x69a0, Name: "Vega 12"},
			{ID: 0x69a1, Name: "Vega 12"},
			{ID: 0x69a2, Name: "Vega 12"},
			{ID: 0x69a3, Name: "Vega 12"},
			{ID: 0x69af, Name: "Vega 12 [Radeon Pro Vega 20]"},
			{ID: 0x6fdf, Name: "Polaris 20 XL [Radeon RX 580 2048SP]"},
			{ID: 0x700f, Name: "RS100 AGP Bridge"},
			{ID: 0x7010, Name: "RS200/RS250 AGP Bridge"},
			{ID: 0x7100, Name: "R520 [Radeon X1800 XT]"},
			{ID: 0x7101, Name: "R520/M58 [Mobility Radeon X1800 XT]"},
			{ID: 0x7102, Name: "R520/M58 [Mobility Radeon X1800]"},
			{ID: 0x7104, Name: "R520 GL [FireGL V7200 / Barco MXTR-5100]"},
			{ID: 0x7109, Name: "R520 [Radeon X1800 XL]"},
			{ID: 0x710a, Name: "R520 [Radeon X1800 GTO]"},
			{ID: 0x710b, Name: "R520 [Radeon X1800 GTO]"},
			{ID: 0x710e, Name: "R520 GL [FireGL V7300]"},
			{ID: 0x710f, Name: "R520 GL [FireGL V7350]"},
			{ID: 0x7120, Name: "R520 [Radeon X1800] (Secondary)"},
			{ID: 0x7124, Name: "R520 GL [FireGL V7200] (Secondary)"},
			{ID: 0x7129, Name: "R520 [Radeon X1800] (Secondary)"},
			{ID: 0x712e, Name: "R520 GL [FireGL V7300] (Secondary)"},
			{ID: 0x712f, Name: "R520 GL [FireGL V7350] (Secondary)"},
			{ID: 0x7140, Name: "RV515 [Radeon X1300/X1550/X1600 Series]"},
			{ID: 0x7142, Name: "RV515 PRO [Radeon X1300/X1550 Series]"},
			{ID: 0x7143, Name: "RV505 [Radeon X1300/X1550 Series]"},
			{ID: 0x7145, Name: "RV515/M54 [Mobility Radeon X1400]"},
			{ID: 0x7146, Name: "RV515 [Radeon X1300/X1550]"},
			{ID: 0x7147, Name: "RV505 [Radeon X1550 64-bit]"},
			{ID: 0x7149, Name: "RV515/M52 [Mobility Radeon X1300]"},
			{ID: 0x714a, Name: "RV515/M52 [Mobility Radeon X1300]"},
			{ID: 0x7152, Name: "RV515 GL [FireGL V3300]"},
			{ID: 0x7153, Name: "RV515 GL [FireGL V3350]"},
			{ID: 0x715f, Name: "RV505 CE [Radeon X1550 64-bit]"},
			{ID: 0x7162, Name: "RV515 PRO [Radeon X1300/X1550 Series] (Secondary)"},
			{ID: 0x7163, Name: "RV505 [Radeon X1550 Series] (Secondary)"},
			{ID: 0x7166, Name: "RV515 [Radeon X1300/X1550 Series] (Secondary)"},
			{ID: 0x7167, Name: "RV515 [Radeon X1550 64-bit] (Secondary)"},
			{ID: 0x7172, Name: "RV515 GL [FireGL V3300] (Secondary)"},
			{ID: 0x7173, Name: "RV515 GL [FireGL V3350] (Secondary)"},
			{ID: 0x7181, Name: "RV516 [Radeon X1600/X1650 Series]"},
			{ID: 0x7183, Name: "RV516 [Radeon X1300/X1550 Series]"},
			{ID: 0x7186, Name: "RV516/M64 [Mobility Radeon X1450]"},
			{ID: 0x7187, Name: "RV516 [Radeon X1300/X1550 Series]"},
			{ID: 0x7188, Name: "RV516/M64-S [Mobility Radeon X2300]"},
			{ID: 0x718a, Name: "RV516/M64 [Mobility Radeon X2300]"},
			{ID: 0x718b, Name: "RV516/M62 [Mobility Radeon X1350]"},
			{ID: 0x718c, Name: "RV516/M62-CSP64 [Mobility Radeon X1350]"},
			{ID: 0x718d, Name: "RV516/M64-CSP128 [Mobility Radeon X1450]"},
			{ID: 0x7193, Name: "RV516 [Radeon X1550 Series]"},
			{ID: 0x7196, Name: "RV516/M62-S [Mobility Radeon X1350]"},
			{ID: 0x719b, Name: "RV516 GL [FireMV 2250]"},
			{ID: 0x719f, Name: "RV516 [Radeon X1550 Series]"},
			{ID: 0x71a0, Name: "RV516 [Radeon X1300/X1550 Series] (Secondary)"},
			{ID: 0x71a1, Name: "RV516 [Radeon X1600/X1650 Series] (Secondary)"},
			{ID: 0x71a3, Name: "RV516 [Radeon X1300/X1550 Series] (Secondary)"},
			{ID: 0x71a7, Name: "RV516 [Radeon X1300/X1550 Series] (Secondary)"},
			{ID: 0x71bb, Name: "RV516 GL [FireMV 2250] (Secondary)"},
			{ID: 0x71c0, Name: "RV530 [Radeon X1600 XT/X1650 GTO]"},
			{ID: 0x71c1, Name: "RV535 [Radeon X1650 PRO]"},
			{ID: 0x71c2, Name: "RV530 [Radeon X1600 PRO]"},
			{ID: 0x71c3, Name: "RV530 [Radeon X1600 PRO]"},
			{ID: 0x71c4, Name: "RV530/M56 GL [Mobility FireGL V5200]"},
			{ID: 0x71c5, Name: "RV530/M56-P [Mobility Radeon X1600]"},
			{ID: 0x71c6, Name: "RV530LE [Radeon X1600/X1650 PRO]"},
			{ID: 0x71c7, Name: "RV535 [Radeon X1650 PRO]"},
			{ID: 0x71ce, Name: "RV530 [Radeon X1300 XT/X1600 PRO]"},
			{ID: 0x71d2, Name: "RV530 GL [FireGL V3400]"},
			{ID: 0x71d4, Name: "RV530/M66 GL [Mobility FireGL V5250]"},
			{ID: 0x71d5, Name: "RV530/M66-P [Mobility Radeon X1700]"},
			{ID: 0x71d6, Name: "RV530/M66-XT [Mobility Radeon X1700]"},
			{ID: 0x71de, Name: "RV530/M66 [Mobility Radeon X1700/X2500]"},
			{ID: 0x71e0, Name: "RV530 [Radeon X1600] (Secondary)"},
			{ID: 0x71e1, Name: "RV535 [Radeon X1650 PRO] (Secondary)"},
			{ID: 0x71e2, Name: "RV530 [Radeon X1600] (Secondary)"},
			{ID: 0x71e6, Name: "RV530 [Radeon X1650] (Secondary)"},
			{ID: 0x71e7, Name: "RV535 [Radeon X1650 PRO] (Secondary)"},
			{ID: 0x71f2, Name: "RV530 GL [FireGL V3400] (Secondary)"},
			{ID: 0x7210, Name: "RV550/M71 [Mobility Radeon HD 2300]"},
			{ID: 0x7211, Name: "RV550/M71 [Mobility Radeon X2300 HD]"},
			{ID: 0x7240, Name: "R580+ [Radeon X1950 XTX]"},
			{ID: 0x7244, Name: "R580+ [Radeon X1950 XT]"},
			{ID: 0x7248, Name: "R580 [Radeon X1950]"},
			{ID: 0x7249, Name: "R580 [Radeon X1900 XT]"},
			{ID: 0x724b, Name: "R580 [Radeon X1900 GT]"},
			{ID: 0x724e, Name: "R580 GL [FireGL V7350]"},
			{ID: 0x7269, Name: "R580 [Radeon X1900 XT] (Secondary)"},
			{ID: 0x726b, Name: "R580 [Radeon X1900 GT] (Secondary)"},
			{ID: 0x726e, Name: "R580 [AMD Stream Processor] (Secondary)"},
			{ID: 0x7280, Name: "RV570 [Radeon X1950 PRO]"},
			{ID: 0x7288, Name: "RV570 [Radeon X1950 GT]"},
			{ID: 0x7291, Name: "RV560 [Radeon X1650 XT]"},
			{ID: 0x7293, Name: "RV560 [Radeon X1650 GT]"},
			{ID: 0x72a0, Name: "RV570 [Radeon X1950 PRO] (Secondary)"},
			{ID: 0x72a8, Name: "RV570 [Radeon X1950 GT] (Secondary)"},
			{ID: 0x72b1, Name: "RV560 [Radeon X1650 XT] (Secondary)"},
			{ID: 0x72b3, Name: "RV560 [Radeon X1650 GT] (Secondary)"},
			{ID: 0x7300, Name: "Fiji [Radeon R9 FURY / NANO Series]"},
			{ID: 0x7310, Name: "Navi 10 [Radeon Pro W5700X]"},
			{ID: 0x7312, Name: "Navi 10 [Radeon Pro W5700]"},
			{ID: 0x7314, Name: "Navi 10 USB"},
			{ID: 0x731f, Name: "Navi 10 [Radeon RX 5600 OEM/5600 XT / 5700/5700 XT]"},
			{ID: 0x7340, Name: "Navi 14 [Radeon RX 5500/5500M / Pro 5500M]"},
			{ID: 0x7341, Name: "Navi 14 [Radeon Pro W5500]"},
			{ID: 0x7347, Name: "Navi 14 [Radeon Pro W5500M]"},
			{ID: 0x734f, Name: "Navi 14 [Radeon Pro W5300M]"},
			{ID: 0x7360, Name: "Navi 12 [Radeon Pro 5600M / V520]"},
			{ID: 0x7362, Name: "Navi 12 [Radeon Pro V520]"},
			{ID: 0x7388, Name: "Arcturus GL-XL"},
			{ID: 0x738c, Name: "Arcturus GL-XL [Instinct MI100]"},
			{ID: 0x738e, Name: "Arcturus GL-XL [Instinct MI100]"},
			{ID: 0x73a2, Name: "Navi 21 Pro-XTA [Radeon Pro W6900X]"},
			{ID: 0x73a3, Name: "Navi 21 GL-XL [Radeon PRO W6800]"},
			{ID: 0x73a4, Name: "Navi 21 USB"},
			{ID: 0x73ab, Name: "Navi 21 Pro-XLA [Radeon Pro W6800X/Radeon Pro W6800X Duo]"},
			{ID: 0x73af, Name: "Navi 21 [Radeon RX 6900 XT]"},
			{ID: 0x73bf, Name: "Navi 21 [Radeon RX 6800/6800 XT / 6900 XT]"},
			{ID: 0x73c3, Name: "Navi 22"},
			{ID: 0x73c4, Name: "Navi 22 USB"},
			{ID: 0x73df, Name: "Navi 22 [Radeon RX 6700/6700 XT / 6800M]"},
			{ID: 0x73e0, Name: "Navi 23"},
			{ID: 0x73e1, Name: "Navi 23 WKS-XM [Radeon PRO W6600M]"},
			{ID: 0x73e3, Name: "Navi 23 WKS-XL [Radeon PRO W6600]"},
			{ID: 0x73e4, Name: "Navi 23 USB"},
			{ID: 0x73ff, Name: "Navi 23 [Radeon RX 6600/6600 XT/6600M]"},
			{ID: 0x7408, Name: "Aldebaran"},
			{ID: 0x740c, Name: "Aldebaran"},
			{ID: 0x740f, Name: "Aldebaran"},
			{ID: 0x7833, Name: "RS350 Host Bridge"},
			{ID: 0x7834, Name: "RS350 [Radeon 9100 PRO/XT IGP]"},
			{ID: 0x7835, Name: "RS350M [Mobility Radeon 9000 IGP]"},
			{ID: 0x7838, Name: "RS350 AGP Bridge"},
			{ID: 0x7910, Name: "RS690 Host Bridge"},
			{ID: 0x7911, Name: "RS690/RS740 Host Bridge"},
			{ID: 0x7912, Name: "RS690/RS740 PCI to PCI Bridge (Internal gfx)"},
			{ID: 0x7913, Name: "RS690 PCI to PCI Bridge (PCI Express Graphics Port 0)"},
			{ID: 0x7915, Name: "RS690 PCI to PCI Bridge (PCI Express Port 1)"},
			{ID: 0x7916, Name: "RS690 PCI to PCI Bridge (PCI Express Port 2)"},
			{ID: 0x7917, Name: "RS690 PCI to PCI Bridge (PCI Express Port 3)"},
			{ID: 0x7919, Name: "RS690 HDMI Audio [Radeon Xpress 1200 Series]"},
			{ID: 0x791e, Name: "RS690 [Radeon X1200]"},
			{ID: 0x791f, Name: "RS690M [Radeon Xpress 1200/1250/1270]"},
			{ID: 0x7930, Name: "RS600 Host Bridge"},
			{ID: 0x7932, Name: "RS600 PCI to PCI Bridge (Internal gfx)"},
			{ID: 0x7933, Name: "RS600 PCI to PCI Bridge (PCI Express Graphics Port 0)"},
			{ID: 0x7935, Name: "RS600 PCI to PCI Bridge (PCI Express Port 1)"},
			{ID: 0x7936, Name: "RS600 PCI to PCI Bridge (PCI Express Port 2)"},
			{ID: 0x7937, Name: "RS690 PCI to PCI Bridge (PCI Express Port 3)"},
			{ID: 0x793b, Name: "RS600 HDMI Audio [Radeon Xpress 1250]"},
			{ID: 0x793f, Name: "RS690M [Radeon Xpress 1200/1250/1270] (Secondary)"},
			{ID: 0x7941, Name: "RS600 [Radeon Xpress 1250]"},
			{ID: 0x7942, Name: "RS600M [Radeon Xpress 1250]"},
			{ID: 0x796e, Name: "RS740 [Radeon 2100]"},
			{ID: 0x9400, Name: "R600 [Radeon HD 2900 PRO/XT]"},
			{ID: 0x9401, Name: "R600 [Radeon HD 2900 XT]"},
			{ID: 0x9403, Name: "R600 [Radeon HD 2900 PRO]"},
			{ID: 0x9405, Name: "R600 [Radeon HD 2900 GT]"},
			{ID: 0x940a, Name: "R600 GL [FireGL V8650]"},
			{ID: 0x940b, Name: "R600 GL [FireGL V8600]"},
			{ID: 0x940f, Name: "R600 GL [FireGL V7600]"},
			{ID: 0x9440, Name: "RV770 [Radeon HD 4870]"},
			{ID: 0x9441, Name: "R700 [Radeon HD 4870 X2]"},
			{ID: 0x9442, Name: "RV770 [Radeon HD 4850]"},
			{ID: 0x9443, Name: "R700 [Radeon HD 4850 X2]"},
			{ID: 0x9444, Name: "RV770 GL [FirePro V8750]"},
			{ID: 0x9446, Name: "RV770 GL [FirePro V7760]"},
			{ID: 0x944a, Name: "RV770/M98L [Mobility Radeon HD 4850]"},
			{ID: 0x944b, Name: "RV770/M98 [Mobility Radeon HD 4850 X2]"},
			{ID: 0x944c, Name: "RV770 LE [Radeon HD 4830]"},
			{ID: 0x944e, Name: "RV770 CE [Radeon HD 4710]"},
			{ID: 0x9450, Name: "RV770 GL [FireStream 9270]"},
			{ID: 0x9452, Name: "RV770 GL [FireStream 9250]"},
			{ID: 0x9456, Name: "RV770 GL [FirePro V8700]"},
			{ID: 0x945a, Name: "RV770/M98-XT [Mobility Radeon HD 4870]"},
			{ID: 0x9460, Name: "RV790 [Radeon HD 4890]"},
			{ID: 0x9462, Name: "RV790 [Radeon HD 4860]"},
			{ID: 0x946a, Name: "RV770 GL [FirePro M7750]"},
			{ID: 0x9480, Name: "RV730/M96 [Mobility Radeon HD 4650/5165]"},
			{ID: 0x9488, Name: "RV730/M96-XT [Mobility Radeon HD 4670]"},
			{ID: 0x9489, Name: "RV730/M96 GL [Mobility FireGL V5725]"},
			{ID: 0x9490, Name: "RV730 XT [Radeon HD 4670]"},
			{ID: 0x9491, Name: "RV730/M96-CSP [Radeon E4690]"},
			{ID: 0x9495, Name: "RV730 [Radeon HD 4600 AGP Series]"},
			{ID: 0x9498, Name: "RV730 PRO [Radeon HD 4650]"},
			{ID: 0x949c, Name: "RV730 GL [FirePro V7750]"},
			{ID: 0x949e, Name: "RV730 GL [FirePro V5700]"},
			{ID: 0x949f, Name: "RV730 GL [FirePro V3750]"},
			{ID: 0x94a0, Name: "RV740/M97 [Mobility Radeon HD 4830]"},
			{ID: 0x94a1, Name: "RV740/M97-XT [Mobility Radeon HD 4860]"},
			{ID: 0x94a3, Name: "RV740/M97 GL [FirePro M7740]"},
			{ID: 0x94b3, Name: "RV740 PRO [Radeon HD 4770]"},
			{ID: 0x94b4, Name: "RV740 PRO [Radeon HD 4750]"},
			{ID: 0x94c1, Name: "RV610 [Radeon HD 2400 PRO/XT]"},
			{ID: 0x94c3, Name: "RV610 [Radeon HD 2400 PRO]"},
			{ID: 0x94c4, Name: "RV610 LE [Radeon HD 2400 PRO AGP]"},
			{ID: 0x94c5, Name: "RV610 [Radeon HD 2400 LE]"},
			{ID: 0x94c7, Name: "RV610 [Radeon HD 2350]"},
			{ID: 0x94c8, Name: "RV610/M74 [Mobility Radeon HD 2400 XT]"},
			{ID: 0x94c9, Name: "RV610/M72-S [Mobility Radeon HD 2400]"},
			{ID: 0x94cb, Name: "RV610 [Radeon E2400]"},
			{ID: 0x94cc, Name: "RV610 LE [Radeon HD 2400 PRO PCI]"},
			{ID: 0x9500, Name: "RV670 [Radeon HD 3850 X2]"},
			{ID: 0x9501, Name: "RV670 [Radeon HD 3870]"},
			{ID: 0x9504, Name: "RV670/M88 [Mobility Radeon HD 3850]"},
			{ID: 0x9505, Name: "RV670 [Radeon HD 3690/3850]"},
			{ID: 0x9506, Name: "RV670/M88 [Mobility Radeon HD 3850 X2]"},
			{ID: 0x9507, Name: "RV670 [Radeon HD 3830]"},
			{ID: 0x9508, Name: "RV670/M88-XT [Mobility Radeon HD 3870]"},
			{ID: 0x9509, Name: "RV670/M88 [Mobility Radeon HD 3870 X2]"},
			{ID: 0x950f, Name: "R680 [Radeon HD 3870 X2]"},
			{ID: 0x9511, Name: "RV670 GL [FireGL V7700]"},
			{ID: 0x9513, Name: "RV670 [Radeon HD 3850 X2]"},
			{ID: 0x9515, Name: "RV670 PRO [Radeon HD 3850 AGP]"},
			{ID: 0x9519, Name: "RV670 GL [FireStream 9170]"},
			{ID: 0x9540, Name: "RV710 [Radeon HD 4550]"},
			{ID: 0x954f, Name: "RV710 [Radeon HD 4350/4550]"},
			{ID: 0x9552, Name: "RV710/M92 [Mobility Radeon HD 4330/4350/4550]"},
			{ID: 0x9553, Name: "RV710/M92 [Mobility Radeon HD 4530/4570/545v]"},
			{ID: 0x9555, Name: "RV710/M92 [Mobility Radeon HD 4350/4550]"},
			{ID: 0x9557, Name: "RV711/M93 GL [FirePro RG220]"},
			{ID: 0x955f, Name: "RV710/M92 [Mobility Radeon HD 4330]"},
			{ID: 0x9580, Name: "RV630 [Radeon HD 2600 PRO]"},
			{ID: 0x9581, Name: "RV630/M76 [Mobility Radeon HD 2600]"},
			{ID: 0x9583, Name: "RV630/M76 [Mobility Radeon HD 2600 XT/2700]"},
			{ID: 0x9586, Name: "RV630 XT [Radeon HD 2600 XT AGP]"},
			{ID: 0x9587, Name: "RV630 PRO [Radeon HD 2600 PRO AGP]"},
			{ID: 0x9588, Name: "RV630 XT [Radeon HD 2600 XT]"},
			{ID: 0x9589, Name: "RV630 PRO [Radeon HD 2600 PRO]"},
			{ID: 0x958a, Name: "RV630 [Radeon HD 2600 X2]"},
			{ID: 0x958b, Name: "RV630/M76 [Mobility Radeon HD 2600 XT]"},
			{ID: 0x958c, Name: "RV630 GL [FireGL V5600]"},
			{ID: 0x958d, Name: "RV630 GL [FireGL V3600]"},
			{ID: 0x9591, Name: "RV635/M86 [Mobility Radeon HD 3650]"},
			{ID: 0x9593, Name: "RV635/M86 [Mobility Radeon HD 3670]"},
			{ID: 0x9595, Name: "RV635/M86 GL [Mobility FireGL V5700]"},
			{ID: 0x9596, Name: "RV635 PRO [Radeon HD 3650 AGP]"},
			{ID: 0x9597, Name: "RV635 PRO [Radeon HD 3650 AGP]"},
			{ID: 0x9598, Name: "RV635 [Radeon HD 3650/3750/4570/4580]"},
			{ID: 0x9599, Name: "RV635 PRO [Radeon HD 3650 AGP]"},
			{ID: 0x95c0, Name: "RV620 PRO [Radeon HD 3470]"},
			{ID: 0x95c2, Name: "RV620/M82 [Mobility Radeon HD 3410/3430]"},
			{ID: 0x95c4, Name: "RV620/M82 [Mobility Radeon HD 3450/3470]"},
			{ID: 0x95c5, Name: "RV620 LE [Radeon HD 3450]"},
			{ID: 0x95c6, Name: "RV620 LE [Radeon HD 3450 AGP]"},
			{ID: 0x95c9, Name: "RV620 LE [Radeon HD 3450 PCI]"},
			{ID: 0x95cc, Name: "RV620 GL [FirePro V3700]"},
			{ID: 0x95cd, Name: "RV620 GL [FirePro 2450]"},
			{ID: 0x95cf, Name: "RV620 GL [FirePro 2260]"},
			{ID: 0x960f, Name: "RS780 HDMI Audio [Radeon 3000/3100 / HD 3200/3300]"},
			{ID: 0x9610, Name: "RS780 [Radeon HD 3200]"},
			{ID: 0x9611, Name: "RS780C [Radeon 3100]"},
			{ID: 0x9612, Name: "RS780M [Mobility Radeon HD 3200]"},
			{ID: 0x9613, Name: "RS780MC [Mobility Radeon HD 3100]"},
			{ID: 0x9614, Name: "RS780D [Radeon HD 3300]"},
			{ID: 0x9615, Name: "RS780E [Radeon HD 3200]"},
			{ID: 0x9616, Name: "RS780L [Radeon 3000]"},
			{ID: 0x9640, Name: "Sumo [Radeon HD 6550D]"},
			{ID: 0x9641, Name: "Sumo [Radeon HD 6620G]"},
			{ID: 0x9642, Name: "SuperSumo [Radeon HD 6370D]"},
			{ID: 0x9643, Name: "SuperSumo [Radeon HD 6380G]"},
			{ID: 0x9644, Name: "SuperSumo [Radeon HD 6410D]"},
			{ID: 0x9645, Name: "SuperSumo [Radeon HD 6410D]"},
			{ID: 0x9647, Name: "Sumo [Radeon HD 6520G]"},
			{ID: 0x9648, Name: "Sumo [Radeon HD 6480G]"},
			{ID: 0x9649, Name: "SuperSumo [Radeon HD 6480G]"},
			{ID: 0x964a, Name: "Sumo [Radeon HD 6530D]"},
			{ID: 0x964b, Name: "Sumo"},
			{ID: 0x964c, Name: "Sumo"},
			{ID: 0x964e, Name: "Sumo"},
			{ID: 0x964f, Name: "Sumo"},
			{ID: 0x970f, Name: "RS880 HDMI Audio [Radeon HD 4200 Series]"},
			{ID: 0x9710, Name: "RS880 [Radeon HD 4200]"},
			{ID: 0x9712, Name: "RS880M [Mobility Radeon HD 4225/4250]"},
			{ID: 0x9713, Name: "RS880M [Mobility Radeon HD 4100]"},
			{ID: 0x9714, Name: "RS880 [Radeon HD 4290]"},
			{ID: 0x9715, Name: "RS880 [Radeon HD 4250]"},
			{ID: 0x9802, Name: "Wrestler [Radeon HD 6310]"},
			{ID: 0x9803, Name: "Wrestler [Radeon HD 6310]"},
			{ID: 0x9804, Name: "Wrestler [Radeon HD 6250]"},
			{ID: 0x9805, Name: "Wrestler [Radeon HD 6250]"},
			{ID: 0x9806, Name: "Wrestler [Radeon HD 6320]"},
			{ID: 0x9807, Name: "Wrestler [Radeon HD 6290]"},
			{ID: 0x9808, Name: "Wrestler [Radeon HD 7340]"},
			{ID: 0x9809, Name: "Wrestler [Radeon HD 7310]"},
			{ID: 0x980a, Name: "Wrestler [Radeon HD 7290]"},
			{ID: 0x9830, Name: "Kabini [Radeon HD 8400 / R3 Series]"},
			{ID: 0x9831, Name: "Kabini [Radeon HD 8400E]"},
			{ID: 0x9832, Name: "Kabini [Radeon HD 8330]"},
			{ID: 0x9833, Name: "Kabini [Radeon HD 8330E]"},
			{ID: 0x9834, Name: "Kabini [Radeon HD 8210]"},
			{ID: 0x9835, Name: "Kabini [Radeon HD 8310E]"},
			{ID: 0x9836, Name: "Kabini [Radeon HD 8280 / R3 Series]"},
			{ID: 0x9837, Name: "Kabini [Radeon HD 8280E]"},
			{ID: 0x9838, Name: "Kabini [Radeon HD 8240 / R3 Series]"},
			{ID: 0x9839, Name: "Kabini [Radeon HD 8180]"},
			{ID: 0x983d, Name: "Temash [Radeon HD 8250/8280G]"},
			{ID: 0x9840, Name: "Kabini HDMI/DP Audio"},
			{ID: 0x9850, Name: "Mullins [Radeon R3 Graphics]"},
			{ID: 0x9851, Name: "Mullins [Radeon R4/R5 Graphics]"},
			{ID: 0x9852, Name: "Mullins [Radeon R2 Graphics]"},
			{ID: 0x9853, Name: "Mullins [Radeon R2 Graphics]"},
			{ID: 0x9854, Name: "Mullins [Radeon R3E Graphics]"},
			{ID: 0x9855, Name: "Mullins [Radeon R6 Graphics]"},
			{ID: 0x9856, Name: "Mullins [Radeon R1E/R2E Graphics]"},
			{ID: 0x9857, Name: "Mullins [Radeon APU XX-2200M with R2 Graphics]"},
			{ID: 0x9858, Name: "Mullins"},
			{ID: 0x9859, Name: "Mullins"},
			{ID: 0x985a, Name: "Mullins"},
			{ID: 0x985b, Name: "Mullins"},
			{ID: 0x985c, Name: "Mullins"},
			{ID: 0x985d, Name: "Mullins"},
			{ID: 0x985e, Name: "Mullins"},
			{ID: 0x985f, Name: "Mullins"},
			{ID: 0x9874, Name: "Wani [Radeon R5/R6/R7 Graphics]"},
			{ID: 0x9890, Name: "Amur"},
			{ID: 0x98c0, Name: "Nolan"},
			{ID: 0x98e4, Name: "Stoney [Radeon R2/R3/R4/R5 Graphics]"},
			{ID: 0x9900, Name: "Trinity [Radeon HD 7660G]"},
			{ID: 0x9901, Name: "Trinity [Radeon HD 7660D]"},
			{ID: 0x9902, Name: "Trinity HDMI Audio Controller"},
			{ID: 0x9903, Name: "Trinity [Radeon HD 7640G]"},
			{ID: 0x9904, Name: "Trinity [Radeon HD 7560D]"},
			{ID: 0x9905, Name: "Trinity GL [FirePro A300]"},
			{ID: 0x9906, Name: "Trinity GL [FirePro A320]"},
			{ID: 0x9907, Name: "Trinity [Radeon HD 7620G]"},
			{ID: 0x9908, Name: "Trinity [Radeon HD 7600G]"},
			{ID: 0x9909, Name: "Trinity [Radeon HD 7500G]"},
			{ID: 0x990a, Name: "Trinity [Radeon HD 7500G]"},
			{ID: 0x990b, Name: "Richland [Radeon HD 8650G]"},
			{ID: 0x990c, Name: "Richland [Radeon HD 8670D]"},
			{ID: 0x990d, Name: "Richland [Radeon HD 8550G]"},
			{ID: 0x990e, Name: "Richland [Radeon HD 8570D]"},
			{ID: 0x990f, Name: "Richland [Radeon HD 8610G]"},
			{ID: 0x9910, Name: "Trinity [Radeon HD 7660G]"},
			{ID: 0x9913, Name: "Trinity [Radeon HD 7640G]"},
			{ID: 0x9917, Name: "Trinity [Radeon HD 7620G]"},
			{ID: 0x9918, Name: "Trinity [Radeon HD 7600G]"},
			{ID: 0x9919, Name: "Trinity [Radeon HD 7500G]"},
			{ID: 0x991e, Name: "Bishop [Xbox One S APU]"},
			{ID: 0x9920, Name: "Liverpool [Playstation 4 APU]"},
			{ID: 0x9921, Name: "Liverpool HDMI/DP Audio Controller"},
			{ID: 0x9922, Name: "Starshp"},
			{ID: 0x9923, Name: "Starsha2 [Kingston/Clayton]"},
			{ID: 0x9924, Name: "Gladius"},
			{ID: 0x9925, Name: "Kingston/Clayton/Jupiter/Gladius/Montego HDMI Controller"},
			{ID: 0x9926, Name: "Jupiter"},
			{ID: 0x9990, Name: "Trinity 2 [Radeon HD 7520G]"},
			{ID: 0x9991, Name: "Trinity 2 [Radeon HD 7540D]"},
			{ID: 0x9992, Name: "Trinity 2 [Radeon HD 7420G]"},
			{ID: 0x9993, Name: "Trinity 2 [Radeon HD 7480D]"},
			{ID: 0x9994, Name: "Trinity 2 [Radeon HD 7400G]"},
			{ID: 0x9995, Name: "Richland [Radeon HD 8450G]"},
			{ID: 0x9996, Name: "Richland [Radeon HD 8470D]"},
			{ID: 0x9997, Name: "Richland [Radeon HD 8350G]"},
			{ID: 0x9998, Name: "Richland [Radeon HD 8370D]"},
			{ID: 0x9999, Name: "Richland [Radeon HD 8510G]"},
			{ID: 0x999a, Name: "Richland [Radeon HD 8410G]"},
			{ID: 0x999b, Name: "Richland [Radeon HD 8310G]"},
			{ID: 0x999c, Name: "Richland [Radeon HD 8650D]"},
			{ID: 0x999d, Name: "Richland [Radeon HD 8550D]"},
			{ID: 0x99a0, Name: "Trinity 2 [Radeon HD 7520G]"},
			{ID: 0x99a2, Name: "Trinity 2 [Radeon HD 7420G]"},
			{ID: 0x99a4, Name: "Trinity 2 [Radeon HD 7400G]"},
			{ID: 0xaa00, Name: "R600 HDMI Audio [Radeon HD 2900 GT/PRO/XT]"},
			{ID: 0xaa01, Name: "RV635 HDMI Audio [Radeon HD 3650/3730/3750]"},
			{ID: 0xaa08, Name: "RV630 HDMI Audio [Radeon HD 2600 PRO/XT / HD 3610]"},
			{ID: 0xaa10, Name: "RV610 HDMI Audio [Radeon HD 2350 PRO / 2400 PRO/XT / HD 3410]"},
			{ID: 0xaa18, Name: "RV670/680 HDMI Audio [Radeon HD 3690/3800 Series]"},
			{ID: 0xaa20, Name: "RV635 HDMI Audio [Radeon HD 3650/3730/3750]"},
			{ID: 0xaa28, Name: "RV620 HDMI Audio [Radeon HD 3450/3470/3550/3570]"},
			{ID: 0xaa30, Name: "RV770 HDMI Audio [Radeon HD 4850/4870]"},
			{ID: 0xaa38, Name: "RV710/730 HDMI Audio [Radeon HD 4000 series]"},
			{ID: 0xaa50, Name: "Cypress HDMI Audio [Radeon HD 5830/5850/5870 / 6850/6870 Rebrand]"},
			{ID: 0xaa58, Name: "Juniper HDMI Audio [Radeon HD 5700 Series]"},
			{ID: 0xaa60, Name: "Redwood HDMI Audio [Radeon HD 5000 Series]"},
			{ID: 0xaa68, Name: "Cedar HDMI Audio [Radeon HD 5400/6300/7300 Series]"},
			{ID: 0xaa80, Name: "Cayman/Antilles HDMI Audio [Radeon HD 6930/6950/6970/6990]"},
			{ID: 0xaa88, Name: "Barts HDMI Audio [Radeon HD 6790/6850/6870 / 7720 OEM]"},
			{ID: 0xaa90, Name: "Turks HDMI Audio [Radeon HD 6500/6600 / 6700M Series]"},
			{ID: 0xaa98, Name: "Caicos HDMI Audio [Radeon HD 6450 / 7450/8450/8490 OEM / R5 230/235/235X OEM]"},
			{ID: 0xaaa0, Name: "Tahiti HDMI Audio [Radeon HD 7870 XT / 7950/7970]"},
			{ID: 0xaab0, Name: "Oland/Hainan/Cape Verde/Pitcairn HDMI Audio [Radeon HD 7000 Series]"},
			{ID: 0xaab8, Name: "Tiran HDMI Audio"},
			{ID: 0xaac0, Name: "Tobago HDMI Audio [Radeon R7 360 / R9 360 OEM]"},
			{ID: 0xaac8, Name: "Hawaii HDMI Audio [Radeon R9 290/290X / 390/390X]"},
			{ID: 0xaad8, Name: "Tonga HDMI Audio [Radeon R9 285/380]"},
			{ID: 0xaae0, Name: "Baffin HDMI/DP Audio [Radeon RX 550 640SP / RX 560/560X]"},
			{ID: 0xaae8, Name: "Fiji HDMI/DP Audio [Radeon R9 Nano / FURY/FURY X]"},
			{ID: 0xaaf0, Name: "Ellesmere HDMI Audio [Radeon RX 470/480 / 570/580/590]"},
			{ID: 0xaaf8, Name: "Vega 10 HDMI Audio [Radeon Vega 56/64]"},
			{ID: 0xab00, Name: "Baffin HDMI/DP Audio [Radeon RX 550 640SP / RX 560/560X]"},
			{ID: 0xab08, Name: "Polaris 22 HDMI Audio"},
			{ID: 0xab10, Name: "Lexa HDMI Audio"},
			{ID: 0xab18, Name: "Vega 12 HDMI Audio"},
			{ID: 0xab20, Name: "Vega 20 HDMI Audio [Radeon VII]"},
			{ID: 0xab28, Name: "Navi 21 HDMI Audio [Radeon RX 6800/6800 XT / 6900 XT]"},
			{ID: 0xab38, Name: "Navi 10 HDMI Audio"},
			{ID: 0xac00, Name: "Theater 506 World-Wide Analog Decoder"},
			{ID: 0xac01, Name: "Theater 506 World-Wide Analog Decoder"},
			{ID: 0xac02, Name: "TV Wonder HD 600 PCIe"},
			{ID: 0xac03, Name: "Theater 506 PCIe"},
			{ID: 0xac04, Name: "Theater 506 USB"},
			{ID: 0xac05, Name: "Theater 506 USB"},
			{ID: 0xac06, Name: "Theater 506 External USB"},
			{ID: 0xac07, Name: "Theater 506 External USB"},
			{ID: 0xac08, Name: "Theater 506A World-Wide Analog Decoder + Demodulator"},
			{ID: 0xac09, Name: "Theater 506A World-Wide Analog Decoder + Demodulator"},
			{ID: 0xac0a, Name: "Theater 506A PCIe"},
			{ID: 0xac0b, Name: "Theater 506A PCIe"},
			{ID: 0xac0c, Name: "Theater 506A USB"},
			{ID: 0xac0d, Name: "Theater 506A USB"},
			{ID: 0xac0e, Name: "Theater 506A External USB"},
			{ID: 0xac0f, Name: "Theater 506A External USB"},
			{ID: 0xac12, Name: "Theater HD T507 (DVB-T) TV tuner/capture device"},
			{ID: 0xcab0, Name: "RS100 Host Bridge"},
			{ID: 0xcab2, Name: "RS200 Host Bridge"},
			{ID: 0xcab3, Name: "RS250 Host Bridge"},
			{ID: 0xcbb2, Name: "RS200 Host Bridge"},
		},
	},
	{
		ID: 0x1003, Name: "ULSI Systems", Devices: []Device{
			{ID: 0x0201, Name: "US201"},
		},
	},
	{
		ID: 0x1004, Name: "VLSI Technology Inc", Devices: []Device{
			{ID: 0x0005, Name: "82C592-FC1"},
			{ID: 0x0006, Name: "82C593-FC1"},
			{ID: 0x0007, Name: "82C594-AFC2"},
			{ID: 0x0008, Name: "82C596/7 [Wildcat]"},
			{ID: 0x0009, Name: "82C597-AFC2"},
			{ID: 0x000c, Name: "82C541 [Lynx]"},
			{ID: 0x000d, Name: "82C543 [Lynx]"},
			{ID: 0x0101, Name: "82C532"},
			{ID: 0x0102, Name: "82C534 [Eagle]"},
			{ID: 0x0103, Name: "82C538"},
			{ID: 0x0104, Name: "82C535"},
			{ID: 0x0105, Name: "82C147"},
			{ID: 0x0200, Name: "82C975"},
			{ID: 0x0280, Name: "82C925"},
			{ID: 0x0304, Name: "QSound ThunderBird PCI Audio"},
			{ID: 0x0305, Name: "QSound ThunderBird PCI Audio Gameport"},
			{ID: 0x0306, Name: "QSound ThunderBird PCI Audio Support Registers"},
			{ID: 0x0307, Name: "SAA7785 ThunderBird PCI Audio"},
			{ID: 0x0308, Name: "SAA7785 ThunderBird PCI Audio Gameport"},
			{ID: 0x0702, Name: "VAS96011 [Golden Gate II]"},
			{ID: 0x0703, Name: "Tollgate"},
		},
	},
	{
		ID: 0x1005, Name: "Avance Logic Inc. [ALI]", Devices: []Device{
			{ID: 0x2064, Name: "ALG2032/2064"},
			{ID: 0x2128, Name: "ALG2364A"},
			{ID: 0x2301, Name: "ALG2301"},
			{ID: 0x2302, Name: "ALG2302"},
			{ID: 0x2364, Name: "ALG2364"},
			{ID: 0x2464, Name: "ALG2364A"},
			{ID: 0x2501, Name: "ALG2564A/25128A"},
		},
	},
	{ID: 0x1006, Name: "Reply Group", Devices: []Device{}},
	{ID: 0x1007, Name: "NetFrame Systems Inc", Devices: []Device{}},
	{ID: 0x1008, Name: "Epson", Devices: []Device{}},
	{ID: 0x100a, Name: "Phoenix Technologies", Devices: []Device{}},
	{
		ID: 0x100b, Name: "National Semiconductor Corporation", Devices: []Device{
			{ID: 0x0001, Name: "DP83810"},
			{ID: 0x0002, Name: "87415/87560 IDE"},
			{ID: 0x000e, Name: "87560 Legacy I/O"},
			{ID: 0x000f, Name: "FireWire Controller"},
			{ID: 0x0011, Name: "NS87560 National PCI System I/O"},
			{ID: 0x0012, Name: "USB Controller"},
			{ID: 0x0020, Name: "DP83815 (MacPhyter) Ethernet Controller"},
			{ID: 0x0021, Name: "PC87200 PCI to ISA Bridge"},
			{ID: 0x0022, Name: "DP83820 10/100/1000 Ethernet Controller"},
			{ID: 0x0028, Name: "Geode GX2 Host Bridge"},
			{ID: 0x002a, Name: "CS5535 South Bridge"},
			{ID: 0x002b, Name: "CS5535 ISA bridge"},
			{ID: 0x002d, Name: "CS5535 IDE"},
			{ID: 0x002e, Name: "CS5535 Audio"},
			{ID: 0x002f, Name: "CS5535 USB"},
			{ID: 0x0030, Name: "Geode GX2 Graphics Processor"},
			{ID: 0x0035, Name: "DP83065 [Saturn] 10/100/1000 Ethernet Controller"},
			{ID: 0x0500, Name: "SCx200 Bridge"},
			{ID: 0x0501, Name: "SCx200 SMI"},
			{ID: 0x0502, Name: "SCx200, SC1100 IDE controller"},
			{ID: 0x0503, Name: "SCx200, SC1100 Audio Controller"},
			{ID: 0x0504, Name: "SCx200 Video"},
			{ID: 0x0505, Name: "SCx200 XBus"},
			{ID: 0x0510, Name: "SC1100 Bridge"},
			{ID: 0x0511, Name: "SC1100 SMI & ACPI"},
			{ID: 0x0515, Name: "SC1100 XBus"},
			{ID: 0xd001, Name: "87410 IDE"},
		},
	},
	{
		ID: 0x100c, Name: "Tseng Labs Inc", Devices: []Device{
			{ID: 0x3202, Name: "ET4000/W32p rev A"},
			{ID: 0x3205, Name: "ET4000/W32p rev B"},
			{ID: 0x3206, Name: "ET4000/W32p rev C"},
			{ID: 0x3207, Name: "ET4000/W32p rev D"},
			{ID: 0x3208, Name: "ET6000"},
			{ID: 0x4702, Name: "ET6300"},
		},
	},
	{ID: 0x100d, Name: "AST Research Inc", Devices: []Device{}},
	{
		ID: 0x100e, Name: "Weitek", Devices: []Device{
			{ID: 0x9000, Name: "P9000 Viper"},
			{ID: 0x9001, Name: "P9000 Viper"},
			{ID: 0x9002, Name: "P9000 Viper"},
			{ID: 0x9100, Name: "P9100 Viper Pro/SE"},
		},
	},
	{ID: 0x1010, Name: "Video Logic, Ltd.", Devices: []Device{}},
	{
		ID: 0x1011, Name: "Digital Equipment Corporation", Devices: []Device{
			{ID: 0x0001, Name: "DECchip 21050"},
			{ID: 0x0002, Name: "DECchip 21040 [Tulip]"},
			{ID: 0x0004, Name: "DECchip 21030 [TGA]"},
			{ID: 0x0007, Name: "NVRAM [Zephyr NVRAM]"},
			{ID: 0x0008, Name: "KZPSA [KZPSA]"},
			{ID: 0x0009, Name: "DECchip 21140 [FasterNet]"},
			{ID: 0x000a, Name: "21230 Video Codec"},
			{ID: 0x000d, Name: "PBXGB [TGA2]"},
			{ID: 0x000f, Name: "PCI-to-PDQ Interface Chip [PFI] FDDI (DEFPA)"},
			{ID: 0x0014, Name: "DECchip 21041 [Tulip Pass 3]"},
			{ID: 0x0016, Name: "ATMworks 350 Adapter [OPPO] (DGLPB)"},
			{ID: 0x0017, Name: "PV-PCI Graphics Controller (ZLXp-L)"},
			{ID: 0x0018, Name: "Memory Channel interface"},
			{ID: 0x0019, Name: "DECchip 21142/43"},
			{ID: 0x001a, Name: "Farallon PN9000SX Gigabit Ethernet"},
			{ID: 0x0021, Name: "DECchip 21052"},
			{ID: 0x0022, Name: "DECchip 21150"},
			{ID: 0x0023, Name: "DECchip 21150"},
			{ID: 0x0024, Name: "DECchip 21152"},
			{ID: 0x0025, Name: "DECchip 21153"},
			{ID: 0x0026, Name: "DECchip 21154"},
			{ID: 0x0034, Name: "56k Modem Cardbus"},
			{ID: 0x0045, Name: "DECchip 21553"},
			{ID: 0x0046, Name: "DECchip 21554"},
			{ID: 0x1065, Name: "StrongARM DC21285"},
		},
	},
	{ID: 0x1012, Name: "Micronics Computers Inc", Devices: []Device{}},
	{
		ID: 0x1013, Name: "Cirrus Logic", Devices: []Device{
			{ID: 0x0038, Name: "GD 7548"},
			{ID: 0x0040, Name: "GD 7555 Flat Panel GUI Accelerator"},
			{ID: 0x004c, Name: "GD 7556 Video/Graphics LCD/CRT Ctrlr"},
			{ID: 0x00a0, Name: "GD 5430/40 [Alpine]"},
			{ID: 0x00a2, Name: "GD 5432 [Alpine]"},
			{ID: 0x00a4, Name: "GD 5434-4 [Alpine]"},
			{ID: 0x00a8, Name: "GD 5434-8 [Alpine]"},
			{ID: 0x00ac, Name: "GD 5436 [Alpine]"},
			{ID: 0x00b0, Name: "GD 5440"},
			{ID: 0x00b8, Name: "GD 5446"},
			{ID: 0x00bc, Name: "GD 5480"},
			{ID: 0x00d0, Name: "GD 5462"},
			{ID: 0x00d2, Name: "GD 5462 [Laguna I]"},
			{ID: 0x00d4, Name: "GD 5464 [Laguna]"},
			{ID: 0x00d5, Name: "GD 5464 BD [Laguna]"},
			{ID: 0x00d6, Name: "GD 5465 [Laguna]"},
			{ID: 0x00e8, Name: "GD 5436U"},
			{ID: 0x1100, Name: "CL 6729"},
			{ID: 0x1110, Name: "PD 6832 PCMCIA/CardBus Ctrlr"},
			{ID: 0x1112, Name: "PD 6834 PCMCIA/CardBus Ctrlr"},
			{ID: 0x1113, Name: "PD 6833 PCMCIA/CardBus Ctrlr"},
			{ID: 0x1200, Name: "GD 7542 [Nordic]"},
			{ID: 0x1202, Name: "GD 7543 [Viking]"},
			{ID: 0x1204, Name: "GD 7541 [Nordic Light]"},
			{ID: 0x4000, Name: "MD 5620 [CLM Data Fax Voice]"},
			{ID: 0x4400, Name: "CD 4400"},
			{ID: 0x6001, Name: "CS 4610/11 [CrystalClear SoundFusion Audio Accelerator]"},
			{ID: 0x6003, Name: "CS 4614/22/24/30 [CrystalClear SoundFusion Audio Accelerator]"},
			{ID: 0x6004, Name: "CS 4614/22/24 [CrystalClear SoundFusion Audio Accelerator]"},
			{ID: 0x6005, Name: "Crystal CS4281 PCI Audio"},
		},
	},
	{
		ID: 0x1014, Name: "IBM", Devices: []Device{
			{ID: 0x0002, Name: "PCI to MCA Bridge"},
			{ID: 0x0005, Name: "Processor to I/O Controller [Alta Lite]"},
			{ID: 0x0007, Name: "Processor to I/O Controller [Alta MP]"},
			{ID: 0x000a, Name: "PCI to ISA Bridge (IBM27-82376) [Fire Coral]"},
			{ID: 0x0017, Name: "CPU to PCI Bridge"},
			{ID: 0x0018, Name: "TR Auto LANstreamer"},
			{ID: 0x001b, Name: "GXT-150P"},
			{ID: 0x001c, Name: "Carrera"},
			{ID: 0x001d, Name: "SCSI-2 FAST PCI Adapter (82G2675)"},
			{ID: 0x0020, Name: "GXT1000 Graphics Adapter"},
			{ID: 0x0022, Name: "PCI to PCI Bridge (IBM27-82351)"},
			{ID: 0x002d, Name: "Processor to I/O Controller [Python]"},
			{ID: 0x002e, Name: "SCSI RAID Adapter [ServeRAID]"},
			{ID: 0x0031, Name: "2 Port Serial Adapter"},
			{ID: 0x0036, Name: "PCI to 32-bit LocalBus Bridge [Miami]"},
			{ID: 0x0037, Name: "PowerPC to PCI Bridge (IBM27-82660)"},
			{ID: 0x003a, Name: "CPU to PCI Bridge"},
			{ID: 0x003c, Name: "GXT250P/GXT255P Graphics Adapter"},
			{ID: 0x003e, Name: "16/4 Token ring UTP/STP controller"},
			{ID: 0x0045, Name: "SSA Adapter"},
			{ID: 0x0046, Name: "MPIC interrupt controller"},
			{ID: 0x0047, Name: "PCI to PCI Bridge"},
			{ID: 0x0048, Name: "PCI to PCI Bridge"},
			{ID: 0x0049, Name: "Warhead SCSI Controller"},
			{ID: 0x004e, Name: "ATM Controller (14104e00)"},
			{ID: 0x004f, Name: "ATM Controller (14104f00)"},
			{ID: 0x0050, Name: "ATM Controller (14105000)"},
			{ID: 0x0053, Name: "25 MBit ATM Controller"},
			{ID: 0x0054, Name: "GXT500P/GXT550P Graphics Adapter"},
			{ID: 0x0057, Name: "MPEG PCI Bridge"},
			{ID: 0x0058, Name: "SSA Adapter [Advanced SerialRAID/X]"},
			{ID: 0x005e, Name: "GXT800P Graphics Adapter"},
			{ID: 0x007c, Name: "ATM Controller (14107c00)"},
			{ID: 0x007d, Name: "3780IDSP [MWave]"},
			{ID: 0x008b, Name: "EADS PCI to PCI Bridge"},
			{ID: 0x008e, Name: "GXT3000P Graphics Adapter"},
			{ID: 0x0090, Name: "GXT 3000P"},
			{ID: 0x0091, Name: "SSA Adapter"},
			{ID: 0x0095, Name: "20H2999 PCI Docking Bridge"},
			{ID: 0x0096, Name: "Chukar chipset SCSI controller"},
			{ID: 0x009f, Name: "PCI 4758 Cryptographic Accelerator"},
			{ID: 0x00a5, Name: "ATM Controller (1410a500)"},
			{ID: 0x00a6, Name: "ATM 155MBPS MM Controller (1410a600)"},
			{ID: 0x00b7, Name: "GXT2000P Graphics Adapter"},
			{ID: 0x00b8, Name: "GXT2000P Graphics Adapter"},
			{ID: 0x00be, Name: "ATM 622MBPS Controller (1410be00)"},
			{ID: 0x00dc, Name: "Advanced Systems Management Adapter (ASMA)"},
			{ID: 0x00fc, Name: "CPC710 Dual Bridge and Memory Controller (PCI-64)"},
			{ID: 0x0105, Name: "CPC710 Dual Bridge and Memory Controller (PCI-32)"},
			{ID: 0x010f, Name: "Remote Supervisor Adapter (RSA)"},
			{ID: 0x0142, Name: "Yotta Video Compositor Input"},
			{ID: 0x0144, Name: "Yotta Video Compositor Output"},
			{ID: 0x0156, Name: "405GP PLB to PCI Bridge"},
			{ID: 0x015e, Name: "622Mbps ATM PCI Adapter"},
			{ID: 0x0160, Name: "64bit/66MHz PCI ATM 155 MMF"},
			{ID: 0x016e, Name: "GXT4000P Graphics Adapter"},
			{ID: 0x0170, Name: "GXT6000P Graphics Adapter"},
			{ID: 0x017d, Name: "GXT300P Graphics Adapter"},
			{ID: 0x0180, Name: "Snipe chipset SCSI controller"},
			{ID: 0x0188, Name: "EADS-X PCI-X to PCI-X Bridge"},
			{ID: 0x01a7, Name: "PCI-X to PCI-X Bridge"},
			{ID: 0x01bd, Name: "ServeRAID Controller"},
			{ID: 0x01c1, Name: "64bit/66MHz PCI ATM 155 UTP"},
			{ID: 0x01e6, Name: "Cryptographic Accelerator"},
			{ID: 0x01ef, Name: "PowerPC 440GP PCI Bridge"},
			{ID: 0x01ff, Name: "10/100 Mbps Ethernet"},
			{ID: 0x0219, Name: "Multiport Serial Adapter"},
			{ID: 0x021b, Name: "GXT6500P Graphics Adapter"},
			{ID: 0x021c, Name: "GXT4500P Graphics Adapter"},
			{ID: 0x0233, Name: "GXT135P Graphics Adapter"},
			{ID: 0x025a, Name: "Drone card"},
			{ID: 0x028c, Name: "Citrine chipset SCSI controller"},
			{ID: 0x02a1, Name: "Calgary PCI-X Host Bridge"},
			{ID: 0x02bd, Name: "Obsidian chipset SCSI controller"},
			{ID: 0x0302, Name: "Winnipeg PCI-X Host Bridge"},
			{ID: 0x0308, Name: "CalIOC2 PCI-E Root Port"},
			{ID: 0x0311, Name: "FC 5740/1954 4-Port 10/100/1000 Base-TX PCI-X Adapter for POWER"},
			{ID: 0x0314, Name: "ZISC 036 Neural accelerator card"},
			{ID: 0x032d, Name: "Axon - Cell Companion Chip"},
			{ID: 0x0339, Name: "Obsidian-E PCI-E SCSI controller"},
			{ID: 0x033d, Name: "PCI-E IPR SAS Adapter (FPGA)"},
			{ID: 0x034a, Name: "PCI-E IPR SAS Adapter (ASIC)"},
			{ID: 0x03dc, Name: "POWER8 Host Bridge (PHB3)"},
			{ID: 0x044b, Name: "GenWQE Accelerator Adapter"},
			{ID: 0x04aa, Name: "Flash Adapter 90 (PCIe2 0.9TB)"},
			{ID: 0x04c1, Name: "POWER9 Host Bridge (PHB4)"},
			{ID: 0x04da, Name: "PCI-E IPR SAS+ Adapter (ASIC)"},
			{ID: 0x04ed, Name: "Internal Shared Memory (ISM) virtual PCI device"},
			{ID: 0x3022, Name: "QLA3022 Network Adapter"},
			{ID: 0x4022, Name: "QLA3022 Network Adapter"},
			{ID: 0xffff, Name: "MPIC-2 interrupt controller"},
		},
	},
	{ID: 0x1015, Name: "LSI Logic Corp of Canada", Devices: []Device{}},
	{ID: 0x1016, Name: "ICL Personal Systems", Devices: []Device{}},
	{
		ID: 0x1017, Name: "SPEA Software AG", Devices: []Device{
			{ID: 0x5343, Name: "SPEA 3D Accelerator"},
		},
	},
	{ID: 0x1018, Name: "Unisys Systems", Devices: []Device{}},
	{ID: 0x1019, Name: "Elitegroup Computer Systems", Devices: []Device{}},
	{
		ID: 0x101a, Name: "AT&T GIS (NCR)", Devices: []Device{
			{ID: 0x0005, Name: "100VG ethernet"},
			{ID: 0x0007, Name: "BYNET BIC4G/2C/2G"},
			{ID: 0x0009, Name: "PQS Memory Controller"},
			{ID: 0x000a, Name: "BYNET BPCI Adapter"},
			{ID: 0x000b, Name: "BYNET 4 Port BYA Switch (BYA4P)"},
			{ID: 0x000c, Name: "BYNET 4 Port BYA Switch (BYA4G)"},
			{ID: 0x0010, Name: "NCR AMC Memory Controller"},
			{ID: 0x1dc1, Name: "BYNET BIC2M/BIC4M/BYA4M"},
			{ID: 0x1fa8, Name: "BYNET Multi-port BIC Adapter (XBIC Based)"},
		},
	},
	{
		ID: 0x101b, Name: "Vitesse Semiconductor", Devices: []Device{
			{ID: 0x0452, Name: "VSC452 [SuperBMC]"},
		},
	},
	{
		ID: 0x101c, Name: "Western Digital", Devices: []Device{
			{ID: 0x0193, Name: "33C193A"},
			{ID: 0x0196, Name: "33C196A"},
			{ID: 0x0197, Name: "33C197A"},
			{ID: 0x0296, Name: "33C296A"},
			{ID: 0x3193, Name: "7193"},
			{ID: 0x3197, Name: "7197"},
			{ID: 0x3296, Name: "33C296A"},
			{ID: 0x4296, Name: "34C296"},
			{ID: 0x9710, Name: "Pipeline 9710"},
			{ID: 0x9712, Name: "Pipeline 9712"},
			{ID: 0xc24a, Name: "90C"},
		},
	},
	{ID: 0x101d, Name: "Maxim Integrated Products", Devices: []Device{}},
	{
		ID: 0x101e, Name: "American Megatrends Inc.", Devices: []Device{
			{ID: 0x0009, Name: "MegaRAID 428 Ultra RAID Controller (rev 03)"},
			{ID: 0x1960, Name: "MegaRAID"},
			{ID: 0x9010, Name: "MegaRAID 428 Ultra RAID Controller"},
			{ID: 0x9030, Name: "EIDE Controller"},
			{ID: 0x9031, Name: "EIDE Controller"},
			{ID: 0x9032, Name: "EIDE & SCSI Controller"},
			{ID: 0x9033, Name: "SCSI Controller"},
			{ID: 0x9040, Name: "Multimedia card"},
			{ID: 0x9060, Name: "MegaRAID 434 Ultra GT RAID Controller"},
			{ID: 0x9063, Name: "MegaRAC"},
		},
	},
	{ID: 0x101f, Name: "PictureTel", Devices: []Device{}},
	{ID: 0x1020, Name: "Hitachi Computer Products", Devices: []Device{}},
	{ID: 0x1021, Name: "OKI Electric Industry Co. Ltd.", Devices: []Device{}},
	{
		ID: 0x1022, Name: "Advanced Micro Devices, Inc. [AMD]", Devices: []Device{
			{ID: 0x1100, Name: "K8 [Athlon64/Opteron] HyperTransport Technology Configuration"},
			{ID: 0x1101, Name: "K8 [Athlon64/Opteron] Address Map"},
			{ID: 0x1102, Name: "K8 [Athlon64/Opteron] DRAM Controller"},
			{ID: 0x1103, Name: "K8 [Athlon64/Opteron] Miscellaneous Control"},
			{ID: 0x1200, Name: "Family 10h Processor HyperTransport Configuration"},
			{ID: 0x1201, Name: "Family 10h Processor Address Map"},
			{ID: 0x1202, Name: "Family 10h Processor DRAM Controller"},
			{ID: 0x1203, Name: "Family 10h Processor Miscellaneous Control"},
			{ID: 0x1204, Name: "Family 10h Processor Link Control"},
			{ID: 0x1300, Name: "Family 11h Processor HyperTransport Configuration"},
			{ID: 0x1301, Name: "Family 11h Processor Address Map"},
			{ID: 0x1302, Name: "Family 11h Processor DRAM Controller"},
			{ID: 0x1303, Name: "Family 11h Processor Miscellaneous Control"},
			{ID: 0x1304, Name: "Family 11h Processor Link Control"},
			{ID: 0x1305, Name: "Griffin Function 5"},
			{ID: 0x1306, Name: "Griffin Function 6"},
			{ID: 0x1307, Name: "Griffin Function 7"},
			{ID: 0x1308, Name: "Kaveri Audio Controller"},
			{ID: 0x1314, Name: "Wrestler/Bheem/Ontario/Krishna Audio Controller"},
			{ID: 0x13e0, Name: "Ariel Root Complex"},
			{ID: 0x13e1, Name: "Ariel IOMMU"},
			{ID: 0x13e2, Name: "Ariel PCIe Dummy Host Bridge"},
			{ID: 0x13e3, Name: "Ariel PCIe GPP Bridge"},
			{ID: 0x13e4, Name: "Ariel PCIe Dummy Host Bridge"},
			{ID: 0x13e5, Name: "Ariel Internal PCIe GPP Bridge 0 to Bus A"},
			{ID: 0x13e6, Name: "Ariel Internal PCIe GPP Bridge 0 to Bus B"},
			{ID: 0x13e7, Name: "Ariel SMBus Controller"},
			{ID: 0x13e8, Name: "Ariel LPC Bridge"},
			{ID: 0x13e9, Name: "Ariel Internal GPU"},
			{ID: 0x13ea, Name: "Ariel HD Audio Controller"},
			{ID: 0x13eb, Name: "Ariel HD Audio Coprocessor"},
			{ID: 0x13ec, Name: "Ariel Cryptographic Coprocessor"},
			{ID: 0x13ed, Name: "Ariel USB 3.1 Type C: Gen2 x 1port + DP Alt Mode"},
			{ID: 0x13ee, Name: "Ariel USB 3.1 Type A: Gen2 x 2 ports"},
			{ID: 0x13ef, Name: "Ariel ZCN/MP4"},
			{ID: 0x13f0, Name: "Ariel Device 24: Function 0"},
			{ID: 0x13f1, Name: "Ariel Device 24: Function 1"},
			{ID: 0x13f2, Name: "Ariel Device 24: Function 2"},
			{ID: 0x13f3, Name: "Ariel Device 24: Function 3"},
			{ID: 0x13f4, Name: "Ariel Device 24: Function 4"},
			{ID: 0x13f5, Name: "Ariel Device 24: Function 5"},
			{ID: 0x13f6, Name: "Ariel Device 24: Function 6"},
			{ID: 0x13f7, Name: "Ariel Device 24: Function 7"},
			{ID: 0x1400, Name: "Family 15h (Models 10h-1fh) Processor Function 0"},
			{ID: 0x1401, Name: "Family 15h (Models 10h-1fh) Processor Function 1"},
			{ID: 0x1402, Name: "Family 15h (Models 10h-1fh) Processor Function 2"},
			{ID: 0x1403, Name: "Family 15h (Models 10h-1fh) Processor Function 3"},
			{ID: 0x1404, Name: "Family 15h (Models 10h-1fh) Processor Function 4"},
			{ID: 0x1405, Name: "Family 15h (Models 10h-1fh) Processor Function 5"},
			{ID: 0x1410, Name: "Family 15h (Models 10h-1fh) Processor Root Complex"},
			{ID: 0x1412, Name: "Family 15h (Models 10h-1fh) Processor Root Port"},
			{ID: 0x1413, Name: "Family 15h (Models 10h-1fh) Processor Root Port"},
			{ID: 0x1414, Name: "Family 15h (Models 10h-1fh) Processor Root Port"},
			{ID: 0x1415, Name: "Family 15h (Models 10h-1fh) Processor Root Port"},
			{ID: 0x1416, Name: "Family 15h (Models 10h-1fh) Processor Root Port"},
			{ID: 0x1417, Name: "Family 15h (Models 10h-1fh) Processor Root Port"},
			{ID: 0x1418, Name: "Family 15h (Models 10h-1fh) Processor Root Port"},
			{ID: 0x1419, Name: "Family 15h (Models 10h-1fh) I/O Memory Management Unit"},
			{ID: 0x141a, Name: "Family 15h (Models 30h-3fh) Processor Function 0"},
			{ID: 0x141b, Name: "Family 15h (Models 30h-3fh) Processor Function 1"},
			{ID: 0x141c, Name: "Family 15h (Models 30h-3fh) Processor Function 2"},
			{ID: 0x141d, Name: "Family 15h (Models 30h-3fh) Processor Function 3"},
			{ID: 0x141e, Name: "Family 15h (Models 30h-3fh) Processor Function 4"},
			{ID: 0x141f, Name: "Family 15h (Models 30h-3fh) Processor Function 5"},
			{ID: 0x1422, Name: "Family 15h (Models 30h-3fh) Processor Root Complex"},
			{ID: 0x1423, Name: "Family 15h (Models 30h-3fh) I/O Memory Management Unit"},
			{ID: 0x1424, Name: "Family 15h (Models 30h-3fh) Processor Root Port"},
			{ID: 0x1425, Name: "Kaveri P2P Bridge for GFX PCIe Port [1:0]"},
			{ID: 0x1426, Name: "Family 15h (Models 30h-3fh) Processor Root Port"},
			{ID: 0x142e, Name: "Liverpool Processor HT configuration"},
			{ID: 0x142f, Name: "Liverpool Processor Address Maps"},
			{ID: 0x1430, Name: "Liverpool Processor DRAM configuration"},
			{ID: 0x1431, Name: "Liverpool Processor Misc configuration"},
			{ID: 0x1432, Name: "Liverpool Processor PM configuration"},
			{ID: 0x1433, Name: "Liverpool Processor NB Performance Monitor"},
			{ID: 0x1434, Name: "Liverpool Processor SPLL Configuration"},
			{ID: 0x1436, Name: "Liverpool Processor Root Complex"},
			{ID: 0x1437, Name: "Liverpool I/O Memory Management Unit"},
			{ID: 0x1438, Name: "Liverpool UMI PCIe Dummy Host Bridge"},
			{ID: 0x1439, Name: "Family 16h Processor Functions 5:1"},
			{ID: 0x143a, Name: "Kingston/Clayton/Gladius/Montego Root Complex"},
			{ID: 0x143b, Name: "Kingston/Clayton/Gladius/Montego P2P Bridge for UMI Link"},
			{ID: 0x1440, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 0"},
			{ID: 0x1441, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 1"},
			{ID: 0x1442, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 2"},
			{ID: 0x1443, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 3"},
			{ID: 0x1444, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 4"},
			{ID: 0x1445, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 5"},
			{ID: 0x1446, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 6"},
			{ID: 0x1447, Name: "Matisse/Vermeer Data Fabric: Device 18h; Function 7"},
			{ID: 0x1448, Name: "Renoir Device 24: Function 0"},
			{ID: 0x1449, Name: "Renoir Device 24: Function 1"},
			{ID: 0x144a, Name: "Renoir Device 24: Function 2"},
			{ID: 0x144b, Name: "Renoir Device 24: Function 3"},
			{ID: 0x144c, Name: "Renoir Device 24: Function 4"},
			{ID: 0x144d, Name: "Renoir Device 24: Function 5"},
			{ID: 0x144e, Name: "Renoir Device 24: Function 6"},
			{ID: 0x144f, Name: "Renoir Device 24: Function 7"},
			{ID: 0x1450, Name: "Family 17h (Models 00h-0fh) Root Complex"},
			{ID: 0x1451, Name: "Family 17h (Models 00h-0fh) I/O Memory Management Unit"},
			{ID: 0x1452, Name: "Family 17h (Models 00h-1fh) PCIe Dummy Host Bridge"},
			{ID: 0x1453, Name: "Family 17h (Models 00h-0fh) PCIe GPP Bridge"},
			{ID: 0x1454, Name: "Family 17h (Models 00h-0fh) Internal PCIe GPP Bridge 0 to Bus B"},
			{ID: 0x1455, Name: "Zeppelin/Renoir PCIe Dummy Function"},
			{ID: 0x1456, Name: "Family 17h (Models 00h-0fh) Platform Security Processor"},
			{ID: 0x1457, Name: "Family 17h (Models 00h-0fh) HD Audio Controller"},
			{ID: 0x145a, Name: "Zeppelin/Raven/Raven2 PCIe Dummy Function"},
			{ID: 0x145b, Name: "Zeppelin Non-Transparent Bridge"},
			{ID: 0x145c, Name: "Family 17h (Models 00h-0fh) USB 3.0 Host Controller"},
			{ID: 0x145d, Name: "Zeppelin Switch Upstream (PCIE SW.US)"},
			{ID: 0x145e, Name: "Zeppelin Switch Downstream (PCIE SW.DS)"},
			{ID: 0x145f, Name: "Zeppelin USB 3.0 Host controller"},
			{ID: 0x1460, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 0"},
			{ID: 0x1461, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 1"},
			{ID: 0x1462, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 2"},
			{ID: 0x1463, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 3"},
			{ID: 0x1464, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 4"},
			{ID: 0x1465, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 5"},
			{ID: 0x1466, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 6"},
			{ID: 0x1467, Name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 7"},
			{ID: 0x1468, Name: "Zeppelin Cryptographic Coprocessor NTBCCP"},
			{ID: 0x1470, Name: "Vega 10 PCIe Bridge"},
			{ID: 0x1471, Name: "Vega 10 PCIe Bridge"},
			{ID: 0x1480, Name: "Starship/Matisse Root Complex"},
			{ID: 0x1481, Name: "Starship/Matisse IOMMU"},
			{ID: 0x1482, Name: "Starship/Matisse PCIe Dummy Host Bridge"},
			{ID: 0x1483, Name: "Starship/Matisse GPP Bridge"},
			{ID: 0x1484, Name: "Starship/Matisse Internal PCIe GPP Bridge 0 to bus[E:B]"},
			{ID: 0x1485, Name: "Starship/Matisse Reserved SPP"},
			{ID: 0x1486, Name: "Starship/Matisse Cryptographic Coprocessor PSPCPP"},
			{ID: 0x1487, Name: "Starship/Matisse HD Audio Controller"},
			{ID: 0x1488, Name: "Starship Reserved SSP"},
			{ID: 0x1489, Name: "Starship Reserved SSP"},
			{ID: 0x148a, Name: "Starship/Matisse PCIe Dummy Function"},
			{ID: 0x148b, Name: "Starship/Matisse Non-Transparent Bridge"},
			{ID: 0x148c, Name: "Starship USB 3.0 Host Controller"},
			{ID: 0x148d, Name: "Starship/Matisse Switch Upstream (PCIE SW.US)"},
			{ID: 0x148e, Name: "Starship/Matisse Switch Downstream (PCIE SW.DS)"},
			{ID: 0x148f, Name: "Starship Reserved SSP"},
			{ID: 0x1490, Name: "Starship Device 24; Function 0"},
			{ID: 0x1491, Name: "Starship Device 24; Function 1"},
			{ID: 0x1492, Name: "Starship Device 24; Function 2"},
			{ID: 0x1493, Name: "Starship Device 24; Function 3"},
			{ID: 0x1494, Name: "Starship Device 24; Function 4"},
			{ID: 0x1495, Name: "Starship Device 24; Function 5"},
			{ID: 0x1496, Name: "Starship Device 24; Function 6"},
			{ID: 0x1497, Name: "Starship Device 24; Function 7"},
			{ID: 0x1498, Name: "Starship/Matisse PTDMA"},
			{ID: 0x1499, Name: "Starship/Matisse NVMe"},
			{ID: 0x149a, Name: "Starship PCIe GPP Bridge [1:0]"},
			{ID: 0x149b, Name: "Starship Reserved SSP"},
			{ID: 0x149c, Name: "Matisse USB 3.0 Host Controller"},
			{ID: 0x149d, Name: "Vangogh CVIP"},
			{ID: 0x1510, Name: "Family 14h Processor Root Complex"},
			{ID: 0x1512, Name: "Family 14h Processor Root Port"},
			{ID: 0x1513, Name: "Family 14h Processor Root Port"},
			{ID: 0x1514, Name: "Family 14h Processor Root Port"},
			{ID: 0x1515, Name: "Family 14h Processor Root Port"},
			{ID: 0x1516, Name: "Family 14h Processor Root Port"},
			{ID: 0x1530, Name: "Family 16h Processor Function 0"},
			{ID: 0x1531, Name: "Family 16h Processor Function 1"},
			{ID: 0x1532, Name: "Family 16h Processor Function 2"},
			{ID: 0x1533, Name: "Family 16h Processor Function 3"},
			{ID: 0x1534, Name: "Family 16h Processor Function 4"},
			{ID: 0x1535, Name: "Family 16h Processor Function 5"},
			{ID: 0x1536, Name: "Family 16h Processor Root Complex"},
			{ID: 0x1537, Name: "Kabini/Mullins PSP-Platform Security Processor"},
			{ID: 0x1538, Name: "Family 16h Processor Function 0"},
			{ID: 0x1539, Name: "Kabini P2P Bridge for PCIe Ports[4:0]"},
			{ID: 0x1540, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky HT Configuration"},
			{ID: 0x1541, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Address Maps"},
			{ID: 0x1542, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky DRAM Configuration"},
			{ID: 0x1543, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Miscellaneous Configuration"},
			{ID: 0x1544, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky PM Configuration"},
			{ID: 0x1545, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky NB Performance Monitor"},
			{ID: 0x1546, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Root Complex"},
			{ID: 0x1547, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky IOMMU"},
			{ID: 0x1548, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky UMI PCIe Dummy Host Bridge"},
			{ID: 0x1549, Name: "Kryptos/Cato/Garfield/Garfield+ P2P Bridge for PCIe Port [3:0]"},
			{ID: 0x154a, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Audio Processor"},
			{ID: 0x154b, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Security Processor"},
			{ID: 0x154d, Name: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky/Anubis HDMI Controller"},
			{ID: 0x154f, Name: "Anubis Audio Processor"},
			{ID: 0x1550, Name: "Garfield+/Arlene/Pooky/Anubis SPLL Configuration"},
			{ID: 0x1553, Name: "Arlene/Pooky P2P Bridge for PCIE (3:0)"},
			{ID: 0x155b, Name: "Anubis Root Complex"},
			{ID: 0x155c, Name: "Anubis IOMMU"},
			{ID: 0x155d, Name: "Anubis UMI PCIe Dummy Bridge"},
			{ID: 0x155e, Name: "Anubis P2P Bridge for PCIe Ports [4:0]"},
			{ID: 0x1560, Name: "Anubis Security Processor"},
			{ID: 0x1566, Name: "Family 16h (Models 30h-3fh) Processor Root Complex"},
			{ID: 0x1567, Name: "Mullins IOMMU"},
			{ID: 0x156b, Name: "Family 16h (Models 30h-3fh) Host Bridge"},
			{ID: 0x1570, Name: "Family 15h (Models 60h-6fh) Processor Function 0"},
			{ID: 0x1571, Name: "Family 15h (Models 60h-6fh) Processor Function 1"},
			{ID: 0x1572, Name: "Family 15h (Models 60h-6fh) Processor Function 2"},
			{ID: 0x1573, Name: "Family 15h (Models 60h-6fh) Processor Function 3"},
			{ID: 0x1574, Name: "Family 15h (Models 60h-6fh) Processor Function 4"},
			{ID: 0x1575, Name: "Family 15h (Models 60h-6fh) Processor Function 5"},
			{ID: 0x1576, Name: "Family 15h (Models 60h-6fh) Processor Root Complex"},
			{ID: 0x1577, Name: "Family 15h (Models 60h-6fh) I/O Memory Management Unit"},
			{ID: 0x1578, Name: "Carrizo Platform Security Processor"},
			{ID: 0x1579, Name: "Carrizo Audio Processor"},
			{ID: 0x157a, Name: "Family 15h (Models 60h-6fh) Audio Controller"},
			{ID: 0x157b, Name: "Family 15h (Models 60h-6fh) Host Bridge"},
			{ID: 0x157c, Name: "Family 15h (Models 60h-6fh) Processor Root Port"},
			{ID: 0x157d, Name: "Carrizo Audio Dummy Host Bridge"},
			{ID: 0x157e, Name: "Carrizo Audio Controller"},
			{ID: 0x1580, Name: "Family 16h (Models 30h-3fh) Processor Function 0"},
			{ID: 0x1581, Name: "Family 16h (Models 30h-3fh) Processor Function 1"},
			{ID: 0x1582, Name: "Family 16h (Models 30h-3fh) Processor Function 2"},
			{ID: 0x1583, Name: "Family 16h (Models 30h-3fh) Processor Function 3"},
			{ID: 0x1584, Name: "Family 16h (Models 30h-3fh) Processor Function 4"},
			{ID: 0x1585, Name: "Family 16h (Models 30h-3fh) Processor Function 5"},
			{ID: 0x1590, Name: "Amur/Nolan HT Configuration"},
			{ID: 0x1591, Name: "Amur/Nolan Address Maps"},
			{ID: 0x1592, Name: "Amur/Nolan DRAM Configuration"},
			{ID: 0x1593, Name: "Amur/Nolan Miscellaneous Configuration"},
			{ID: 0x1594, Name: "Amur/Nolan PM Configuration"},
			{ID: 0x1595, Name: "Amur/Nolan NB Performance Monitor"},
			{ID: 0x1596, Name: "Amur/Nolan Root Complex"},
			{ID: 0x1597, Name: "Amur/Nolan IOMMU"},
			{ID: 0x1598, Name: "Amur/Nolan Platform Security Processor"},
			{ID: 0x1599, Name: "Amur/Nolan PCIe Dummy Host Bridge"},
			{ID: 0x159d, Name: "Amur Function 6: Gasket"},
			{ID: 0x15b0, Name: "Stoney HT Configuration"},
			{ID: 0x15b1, Name: "Stoney Address Maps"},
			{ID: 0x15b2, Name: "Stoney DRAM Configuration"},
			{ID: 0x15b3, Name: "Stoney Miscellaneous Configuration"},
			{ID: 0x15b4, Name: "Stoney PM Configuration"},
			{ID: 0x15b5, Name: "Stoney NB Performance Monitor"},
			{ID: 0x15bc, Name: "Stoney PCIe [GFX,GPP] Bridge [4:0]"},
			{ID: 0x15be, Name: "Stoney Audio Processor"},
			{ID: 0x15d0, Name: "Raven/Raven2 Root Complex"},
			{ID: 0x15d1, Name: "Raven/Raven2 IOMMU"},
			{ID: 0x15d2, Name: "Raven/Raven2 PCIe Dummy Host Bridge"},
			{ID: 0x15d3, Name: "Raven/Raven2 PCIe GPP Bridge [6:0]"},
			{ID: 0x15d4, Name: "FireFlight USB 3.1"},
			{ID: 0x15d5, Name: "FireFlight USB 3.1"},
			{ID: 0x15da, Name: "Raven/Raven2 PCIe Dummy Host Bridge"},
			{ID: 0x15db, Name: "Raven/Raven2 Internal PCIe GPP Bridge 0 to Bus A"},
			{ID: 0x15dc, Name: "Raven/Raven2 Internal PCIe GPP Bridge 0 to Bus B"},
			{ID: 0x15de, Name: "Raven/Raven2/FireFlight HD Audio Controller"},
			{ID: 0x15df, Name: "Family 17h (Models 10h-1fh) Platform Security Processor"},
			{ID: 0x15e0, Name: "Raven USB 3.1"},
			{ID: 0x15e1, Name: "Raven USB 3.1"},
			{ID: 0x15e2, Name: "Raven/Raven2/FireFlight/Renoir Audio Processor"},
			{ID: 0x15e3, Name: "Family 17h (Models 10h-1fh) HD Audio Controller"},
			{ID: 0x15e4, Name: "Raven/Raven2/Renoir Sensor Fusion Hub"},
			{ID: 0x15e5, Name: "Raven2 USB 3.1"},
			{ID: 0x15e6, Name: "Raven/Raven2/Renoir Non-Sensor Fusion Hub KMDF driver"},
			{ID: 0x15e8, Name: "Raven/Raven2 Device 24: Function 0"},
			{ID: 0x15e9, Name: "Raven/Raven2 Device 24: Function 1"},
			{ID: 0x15ea, Name: "Raven/Raven2 Device 24: Function 2"},
			{ID: 0x15eb, Name: "Raven/Raven2 Device 24: Function 3"},
			{ID: 0x15ec, Name: "Raven/Raven2 Device 24: Function 4"},
			{ID: 0x15ed, Name: "Raven/Raven2 Device 24: Function 5"},
			{ID: 0x15ee, Name: "Raven/Raven2 Device 24: Function 6"},
			{ID: 0x15ef, Name: "Raven/Raven2 Device 24: Function 7"},
			{ID: 0x15f0, Name: "FireFlight Device 24: Function 0"},
			{ID: 0x15f1, Name: "FireFlight Device 24: Function 1"},
			{ID: 0x15f2, Name: "FireFlight Device 24: Function 2"},
			{ID: 0x15f3, Name: "FireFlight Device 24: Function 3"},
			{ID: 0x15f4, Name: "FireFlight Device 24: Function 4"},
			{ID: 0x15f5, Name: "FireFlight Device 24: Function 5"},
			{ID: 0x15f6, Name: "FireFlight Device 24: Function 6"},
			{ID: 0x15f7, Name: "FireFlight Device 24: Function 7"},
			{ID: 0x15f8, Name: "FireFlight Root Complex"},
			{ID: 0x15f9, Name: "FireFlight IOMMU"},
			{ID: 0x15fa, Name: "FireFlight PCIe Dummy Host Bridge"},
			{ID: 0x15fb, Name: "FireFlight PCIe GPP Bride 3:0"},
			{ID: 0x15fc, Name: "FireFlight PCIe Dummy Host Bridge"},
			{ID: 0x15fd, Name: "FireFlight Internal PCIe GPP Bridge 0 to Bus A"},
			{ID: 0x15fe, Name: "FireFlight Internal PCIe GPP Bridge 0 to Bus B"},
			{ID: 0x15ff, Name: "FireFlight Bus A; Device 0: Function 0: Internal GPU"},
			{ID: 0x1600, Name: "Family 15h Processor Function 0"},
			{ID: 0x1601, Name: "Family 15h Processor Function 1"},
			{ID: 0x1602, Name: "Family 15h Processor Function 2"},
			{ID: 0x1603, Name: "Family 15h Processor Function 3"},
			{ID: 0x1604, Name: "Family 15h Processor Function 4"},
			{ID: 0x1605, Name: "Family 15h Processor Function 5"},
			{ID: 0x1606, Name: "Arden Security Processor"},
			{ID: 0x1608, Name: "Arden Device 18h: Function 0"},
			{ID: 0x1609, Name: "Arden Device 18h: Function 1"},
			{ID: 0x160a, Name: "Arden Device 18h: Function 2"},
			{ID: 0x160b, Name: "Arden Device 18h: Function 3"},
			{ID: 0x160c, Name: "Arden Device 18h: Function 4"},
			{ID: 0x160d, Name: "Arden Device 18h: Function 5"},
			{ID: 0x160e, Name: "Arden Device 18h: Function 6"},
			{ID: 0x160f, Name: "Arden Device 18h: Function 7"},
			{ID: 0x1620, Name: "Anubis HT Configuration"},
			{ID: 0x1621, Name: "Anubis Address Maps"},
			{ID: 0x1622, Name: "Anubis DRAM Configuration"},
			{ID: 0x1623, Name: "Anubis Miscellaneous Configuration"},
			{ID: 0x1624, Name: "Anubis PM Configuration"},
			{ID: 0x1625, Name: "Anubis NB Performance Monitor"},
			{ID: 0x1626, Name: "Arden Root Complex"},
			{ID: 0x1627, Name: "Arden IOMMU"},
			{ID: 0x1628, Name: "Arden PCIe Dummy Host Bridge"},
			{ID: 0x1629, Name: "Arden PCIe GPP Bridge"},
			{ID: 0x162a, Name: "Arden Internal PCIe GPP Bridge 0 to bus X"},
			{ID: 0x162b, Name: "Arden PCIe Non-Transparent Bridge"},
			{ID: 0x1630, Name: "Renoir/Cezanne Root Complex"},
			{ID: 0x1631, Name: "Renoir/Cezanne IOMMU"},
			{ID: 0x1632, Name: "Renoir PCIe Dummy Host Bridge"},
			{ID: 0x1633, Name: "Renoir PCIe GPP Bridge"},
			{ID: 0x1634, Name: "Renoir/Cezanne PCIe GPP Bridge"},
			{ID: 0x1635, Name: "Renoir Internal PCIe GPP Bridge to Bus"},
			{ID: 0x1637, Name: "Renoir HD Audio Controller"},
			{ID: 0x1639, Name: "Renoir/Cezanne USB 3.1"},
			{ID: 0x163a, Name: "VanGogh USB0"},
			{ID: 0x163b, Name: "VanGogh USB1"},
			{ID: 0x163c, Name: "VanGogh SecUSB"},
			{ID: 0x163d, Name: "VanGogh SecureFunction"},
			{ID: 0x163e, Name: "VanGogh HSP"},
			{ID: 0x1641, Name: "Renoir 10GbE Controller Port 0 (XGBE0/1)"},
			{ID: 0x1642, Name: "Renoir WLAN"},
			{ID: 0x1643, Name: "Renoir BT"},
			{ID: 0x1644, Name: "Renoir I2S"},
			{ID: 0x1648, Name: "VanGogh Root Complex"},
			{ID: 0x1649, Name: "VanGogh PSP/CCP"},
			{ID: 0x164f, Name: "Milan IOMMU"},
			{ID: 0x1650, Name: "Milan Data Fabric; Function 0"},
			{ID: 0x1651, Name: "Milan Data Fabric; Function 1"},
			{ID: 0x1652, Name: "Milan Data Fabric; Function 2"},
			{ID: 0x1653, Name: "Milan Data Fabric; Function 3"},
			{ID: 0x1654, Name: "Milan Data Fabric; Function 4"},
			{ID: 0x1655, Name: "Milan Data Fabric; Function 5"},
			{ID: 0x1656, Name: "Milan Data Fabric; Function 6"},
			{ID: 0x1657, Name: "Milan Data Fabric; Function 7"},
			{ID: 0x166a, Name: "Cezanne Data Fabric; Function 0"},
			{ID: 0x166b, Name: "Cezanne Data Fabric; Function 1"},
			{ID: 0x166c, Name: "Cezanne Data Fabric; Function 2"},
			{ID: 0x166d, Name: "Cezanne Data Fabric; Function 3"},
			{ID: 0x166e, Name: "Cezanne Data Fabric; Function 4"},
			{ID: 0x166f, Name: "Cezanne Data Fabric; Function 5"},
			{ID: 0x1670, Name: "Cezanne Data Fabric; Function 6"},
			{ID: 0x1671, Name: "Cezanne Data Fabric; Function 7"},
			{ID: 0x1700, Name: "Family 12h/14h Processor Function 0"},
			{ID: 0x1701, Name: "Family 12h/14h Processor Function 1"},
			{ID: 0x1702, Name: "Family 12h/14h Processor Function 2"},
			{ID: 0x1703, Name: "Family 12h/14h Processor Function 3"},
			{ID: 0x1704, Name: "Family 12h/14h Processor Function 4"},
			{ID: 0x1705, Name: "Family 12h Processor Root Complex"},
			{ID: 0x1706, Name: "Llano P2P Bridge to external GPU"},
			{ID: 0x1707, Name: "Family 12h Processor Root Port"},
			{ID: 0x1708, Name: "Family 12h Processor Root Port"},
			{ID: 0x1709, Name: "Family 12h Processor Root Port"},
			{ID: 0x170a, Name: "Family 12h Processor Root Port"},
			{ID: 0x170b, Name: "Family 12h Processor Root Port"},
			{ID: 0x170c, Name: "Family 12h Processor Root Port"},
			{ID: 0x170d, Name: "Family 12h Processor Root Port"},
			{ID: 0x1716, Name: "Family 12h/14h Processor Function 5"},
			{ID: 0x1718, Name: "Family 12h/14h Processor Function 6"},
			{ID: 0x1719, Name: "Family 12h/14h Processor Function 7"},
			{ID: 0x2000, Name: "79c970 [PCnet32 LANCE]"},
			{ID: 0x2001, Name: "Am79C978 PCnet Home (HomePNA) 1/10 PCI Ethernet Adapter [Am79C971 PHY]"},
			{ID: 0x2003, Name: "Am 1771 MBW [Alchemy]"},
			{ID: 0x2020, Name: "53c974 [PCscsi]"},
			{ID: 0x2040, Name: "79c974"},
			{ID: 0x2080, Name: "CS5536 [Geode companion] Host Bridge"},
			{ID: 0x2081, Name: "Geode LX Video"},
			{ID: 0x2082, Name: "Geode LX AES Security Block"},
			{ID: 0x208f, Name: "CS5536 GeodeLink PCI South Bridge"},
			{ID: 0x2090, Name: "CS5536 [Geode companion] ISA"},
			{ID: 0x2091, Name: "CS5536 [Geode companion] FLASH"},
			{ID: 0x2093, Name: "CS5536 [Geode companion] Audio"},
			{ID: 0x2094, Name: "CS5536 [Geode companion] OHC"},
			{ID: 0x2095, Name: "CS5536 [Geode companion] EHC"},
			{ID: 0x2096, Name: "CS5536 [Geode companion] UDC"},
			{ID: 0x2097, Name: "CS5536 [Geode companion] UOC"},
			{ID: 0x209a, Name: "CS5536 [Geode companion] IDE"},
			{ID: 0x2625, Name: "Am79C973 [Lance/PCI PCNet/32]"},
			{ID: 0x2627, Name: "Am79C975 [Lance/PCI PCNet/32]"},
			{ID: 0x3000, Name: "ELanSC520 Microcontroller"},
			{ID: 0x43a0, Name: "Hudson PCI to PCI bridge (PCIE port 0)"},
			{ID: 0x43a1, Name: "Hudson PCI to PCI bridge (PCIE port 1)"},
			{ID: 0x43a2, Name: "Hudson PCI to PCI bridge (PCIE port 2)"},
			{ID: 0x43a3, Name: "Hudson PCI to PCI bridge (PCIE port 3)"},
			{ID: 0x43b0, Name: "X370 Series Chipset PCIe Upstream Port"},
			{ID: 0x43b1, Name: "X399 Series Chipset PCIe Bridge"},
			{ID: 0x43b4, Name: "300 Series Chipset PCIe Port"},
			{ID: 0x43b5, Name: "X370 Series Chipset SATA Controller"},
			{ID: 0x43b6, Name: "X399 Series Chipset SATA Controller"},
			{ID: 0x43b7, Name: "300 Series Chipset SATA Controller"},
			{ID: 0x43b9, Name: "X370 Series Chipset USB 3.1 xHCI Controller"},
			{ID: 0x43ba, Name: "X399 Series Chipset USB 3.1 xHCI Controller"},
			{ID: 0x43bb, Name: "300 Series Chipset USB 3.1 xHCI Controller"},
			{ID: 0x43c6, Name: "400 Series Chipset PCIe Bridge"},
			{ID: 0x43c7, Name: "400 Series Chipset PCIe Port"},
			{ID: 0x43c8, Name: "400 Series Chipset SATA Controller"},
			{ID: 0x43d5, Name: "400 Series Chipset USB 3.1 XHCI Controller"},
			{ID: 0x57a3, Name: "Matisse PCIe GPP Bridge"},
			{ID: 0x57a4, Name: "Matisse PCIe GPP Bridge"},
			{ID: 0x57ad, Name: "Matisse Switch Upstream"},
			{ID: 0x7006, Name: "AMD-751 [Irongate] System Controller"},
			{ID: 0x7007, Name: "AMD-751 [Irongate] AGP Bridge"},
			{ID: 0x700a, Name: "AMD-IGR4 AGP Host to PCI Bridge"},
			{ID: 0x700b, Name: "AMD-IGR4 PCI to PCI Bridge"},
			{ID: 0x700c, Name: "AMD-760 MP [IGD4-2P] System Controller"},
			{ID: 0x700d, Name: "AMD-760 MP [IGD4-2P] AGP Bridge"},
			{ID: 0x700e, Name: "AMD-760 [IGD4-1P] System Controller"},
			{ID: 0x700f, Name: "AMD-760 [IGD4-1P] AGP Bridge"},
			{ID: 0x7400, Name: "AMD-755 [Cobra] ISA"},
			{ID: 0x7401, Name: "AMD-755 [Cobra] IDE"},
			{ID: 0x7403, Name: "AMD-755 [Cobra] ACPI"},
			{ID: 0x7404, Name: "AMD-755 [Cobra] USB"},
			{ID: 0x7408, Name: "AMD-756 [Viper] ISA"},
			{ID: 0x7409, Name: "AMD-756 [Viper] IDE"},
			{ID: 0x740b, Name: "AMD-756 [Viper] ACPI"},
			{ID: 0x740c, Name: "AMD-756 [Viper] USB"},
			{ID: 0x7410, Name: "AMD-766 [ViperPlus] ISA"},
			{ID: 0x7411, Name: "AMD-766 [ViperPlus] IDE"},
			{ID: 0x7413, Name: "AMD-766 [ViperPlus] ACPI"},
			{ID: 0x7414, Name: "AMD-766 [ViperPlus] USB"},
			{ID: 0x7440, Name: "AMD-768 [Opus] ISA"},
			{ID: 0x7441, Name: "AMD-768 [Opus] IDE"},
			{ID: 0x7443, Name: "AMD-768 [Opus] ACPI"},
			{ID: 0x7445, Name: "AMD-768 [Opus] Audio"},
			{ID: 0x7446, Name: "AMD-768 [Opus] MC97 Modem"},
			{ID: 0x7448, Name: "AMD-768 [Opus] PCI"},
			{ID: 0x7449, Name: "AMD-768 [Opus] USB"},
			{ID: 0x7450, Name: "AMD-8131 PCI-X Bridge"},
			{ID: 0x7451, Name: "AMD-8131 PCI-X IOAPIC"},
			{ID: 0x7454, Name: "AMD-8151 System Controller"},
			{ID: 0x7455, Name: "AMD-8151 AGP Bridge"},
			{ID: 0x7458, Name: "AMD-8132 PCI-X Bridge"},
			{ID: 0x7459, Name: "AMD-8132 PCI-X IOAPIC"},
			{ID: 0x7460, Name: "AMD-8111 PCI"},
			{ID: 0x7461, Name: "AMD-8111 USB"},
			{ID: 0x7462, Name: "AMD-8111 Ethernet"},
			{ID: 0x7463, Name: "AMD-8111 USB EHCI"},
			{ID: 0x7464, Name: "AMD-8111 USB OHCI"},
			{ID: 0x7468, Name: "AMD-8111 LPC"},
			{ID: 0x7469, Name: "AMD-8111 IDE"},
			{ID: 0x746a, Name: "AMD-8111 SMBus 2.0"},
			{ID: 0x746b, Name: "AMD-8111 ACPI"},
			{ID: 0x746d, Name: "AMD-8111 AC97 Audio"},
			{ID: 0x746e, Name: "AMD-8111 MC97 Modem"},
			{ID: 0x756b, Name: "AMD-8111 ACPI"},
			{ID: 0x7800, Name: "FCH SATA Controller [IDE mode]"},
			{ID: 0x7801, Name: "FCH SATA Controller [AHCI mode]"},
			{ID: 0x7802, Name: "FCH SATA Controller [RAID mode]"},
			{ID: 0x7803, Name: "FCH SATA Controller [RAID mode]"},
			{ID: 0x7804, Name: "FCH SATA Controller [AHCI mode]"},
			{ID: 0x7805, Name: "FCH SATA Controller [RAID mode]"},
			{ID: 0x7806, Name: "FCH SD Flash Controller"},
			{ID: 0x7807, Name: "FCH USB OHCI Controller"},
			{ID: 0x7808, Name: "FCH USB EHCI Controller"},
			{ID: 0x7809, Name: "FCH USB OHCI Controller"},
			{ID: 0x780a, Name: "Kabini/Mullins SATA Raid/AHCI Mode (DotHill driver)"},
			{ID: 0x780b, Name: "FCH SMBus Controller"},
			{ID: 0x780c, Name: "FCH IDE Controller"},
			{ID: 0x780d, Name: "FCH Azalia Controller"},
			{ID: 0x780e, Name: "FCH LPC Bridge"},
			{ID: 0x780f, Name: "FCH PCI Bridge"},
			{ID: 0x7812, Name: "FCH USB XHCI Controller"},
			{ID: 0x7813, Name: "FCH SD Flash Controller"},
			{ID: 0x7814, Name: "FCH USB XHCI Controller"},
			{ID: 0x7900, Name: "FCH SATA Controller [IDE mode]"},
			{ID: 0x7901, Name: "FCH SATA Controller [AHCI mode]"},
			{ID: 0x7902, Name: "FCH SATA Controller [RAID mode]"},
			{ID: 0x7903, Name: "FCH SATA Controller [RAID mode]"},
			{ID: 0x7904, Name: "FCH SATA Controller [AHCI mode]"},
			{ID: 0x7906, Name: "FCH SD Flash Controller"},
			{ID: 0x7908, Name: "FCH USB EHCI Controller"},
			{ID: 0x790b, Name: "FCH SMBus Controller"},
			{ID: 0x790e, Name: "FCH LPC Bridge"},
			{ID: 0x790f, Name: "FCH PCI Bridge"},
			{ID: 0x7914, Name: "FCH USB XHCI Controller"},
			{ID: 0x9600, Name: "RS780 Host Bridge"},
			{ID: 0x9601, Name: "RS880 Host Bridge"},
			{ID: 0x9602, Name: "RS780/RS880 PCI to PCI bridge (int gfx)"},
			{ID: 0x9603, Name: "RS780 PCI to PCI bridge (ext gfx port 0)"},
			{ID: 0x9604, Name: "RS780/RS880 PCI to PCI bridge (PCIE port 0)"},
			{ID: 0x9605, Name: "RS780/RS880 PCI to PCI bridge (PCIE port 1)"},
			{ID: 0x9606, Name: "RS780 PCI to PCI bridge (PCIE port 2)"},
			{ID: 0x9607, Name: "RS780/RS880 PCI to PCI bridge (PCIE port 3)"},
			{ID: 0x9608, Name: "RS780/RS880 PCI to PCI bridge (PCIE port 4)"},
			{ID: 0x9609, Name: "RS780/RS880 PCI to PCI bridge (PCIE port 5)"},
			{ID: 0x960a, Name: "RS780 PCI to PCI bridge (NB-SB link)"},
			{ID: 0x960b, Name: "RS780 PCI to PCI bridge (ext gfx port 1)"},
		},
	},
	{
		ID: 0x1023, Name: "Trident Microsystems", Devices: []Device{
			{ID: 0x0194, Name: "82C194"},
			{ID: 0x2000, Name: "4DWave DX"},
			{ID: 0x2001, Name: "4DWave NX"},
			{ID: 0x2100, Name: "CyberBlade XP4m32"},
			{ID: 0x2200, Name: "XGI Volari XP5"},
			{ID: 0x8400, Name: "CyberBlade/i7"},
			{ID: 0x8420, Name: "CyberBlade/i7d"},
			{ID: 0x8500, Name: "CyberBlade/i1"},
			{ID: 0x8520, Name: "CyberBlade i1"},
			{ID: 0x8620, Name: "CyberBlade/i1"},
			{ID: 0x8820, Name: "CyberBlade XPAi1"},
			{ID: 0x9320, Name: "TGUI 9320"},
			{ID: 0x9350, Name: "GUI Accelerator"},
			{ID: 0x9360, Name: "Flat panel GUI Accelerator"},
			{ID: 0x9382, Name: "Cyber 9382 [Reference design]"},
			{ID: 0x9383, Name: "Cyber 9383 [Reference design]"},
			{ID: 0x9385, Name: "Cyber 9385 [Reference design]"},
			{ID: 0x9386, Name: "Cyber 9386"},
			{ID: 0x9388, Name: "Cyber 9388"},
			{ID: 0x9397, Name: "Cyber 9397"},
			{ID: 0x939a, Name: "Cyber 9397DVD"},
			{ID: 0x9420, Name: "TGUI 9420"},
			{ID: 0x9430, Name: "TGUI 9430"},
			{ID: 0x9440, Name: "TGUI 9440"},
			{ID: 0x9460, Name: "TGUI 9460"},
			{ID: 0x9470, Name: "TGUI 9470"},
			{ID: 0x9520, Name: "Cyber 9520"},
			{ID: 0x9525, Name: "Cyber 9525"},
			{ID: 0x9540, Name: "Cyber 9540"},
			{ID: 0x9660, Name: "TGUI 9660/938x/968x"},
			{ID: 0x9680, Name: "TGUI 9680"},
			{ID: 0x9682, Name: "TGUI 9682"},
			{ID: 0x9683, Name: "TGUI 9683"},
			{ID: 0x9685, Name: "ProVIDIA 9685"},
			{ID: 0x9750, Name: "3DImage 9750"},
			{ID: 0x9753, Name: "TGUI 9753"},
			{ID: 0x9754, Name: "TGUI 9754"},
			{ID: 0x9759, Name: "TGUI 975"},
			{ID: 0x9783, Name: "TGUI 9783"},
			{ID: 0x9785, Name: "TGUI 9785"},
			{ID: 0x9850, Name: "3DImage 9850"},
			{ID: 0x9880, Name: "Blade 3D PCI/AGP"},
			{ID: 0x9910, Name: "CyberBlade/XP"},
			{ID: 0x9930, Name: "CyberBlade/XPm"},
			{ID: 0x9960, Name: "CyberBlade XP2"},
		},
	},
	{ID: 0x1024, Name: "Zenith Data Systems", Devices: []Device{}},
	{
		ID: 0x1025, Name: "Acer Incorporated [ALI]", Devices: []Device{
			{ID: 0x1435, Name: "M1435"},
			{ID: 0x1445, Name: "M1445"},
			{ID: 0x1449, Name: "M1449"},
			{ID: 0x1451, Name: "M1451"},
			{ID: 0x1461, Name: "M1461"},
			{ID: 0x1489, Name: "M1489"},
			{ID: 0x1511, Name: "M1511"},
			{ID: 0x1512, Name: "ALI M1512 Aladdin"},
			{ID: 0x1513, Name: "M1513"},
			{ID: 0x1521, Name: "ALI M1521 Aladdin III CPU Bridge"},
			{ID: 0x1523, Name: "ALI M1523 ISA Bridge"},
			{ID: 0x1531, Name: "M1531 Northbridge [Aladdin IV/IV+]"},
			{ID: 0x1533, Name: "M1533 PCI-to-ISA Bridge"},
			{ID: 0x1535, Name: "M1535 PCI Bridge + Super I/O + FIR"},
			{ID: 0x1541, Name: "M1541 Northbridge [Aladdin V]"},
			{ID: 0x1542, Name: "M1542 Northbridge [Aladdin V]"},
			{ID: 0x1543, Name: "M1543 PCI-to-ISA Bridge + Super I/O + FIR"},
			{ID: 0x1561, Name: "M1561 Northbridge [Aladdin 7]"},
			{ID: 0x1621, Name: "M1621 Northbridge [Aladdin-Pro II]"},
			{ID: 0x1631, Name: "M1631 Northbridge+3D Graphics [Aladdin TNT2]"},
			{ID: 0x1641, Name: "M1641 Northbridge [Aladdin-Pro IV]"},
			{ID: 0x1647, Name: "M1647 [MaGiK1] PCI North Bridge"},
			{ID: 0x1671, Name: "M1671 Northbridge [ALADDiN-P4]"},
			{ID: 0x1672, Name: "Northbridge [CyberALADDiN-P4]"},
			{ID: 0x3141, Name: "M3141"},
			{ID: 0x3143, Name: "M3143"},
			{ID: 0x3145, Name: "M3145"},
			{ID: 0x3147, Name: "M3147"},
			{ID: 0x3149, Name: "M3149"},
			{ID: 0x3151, Name: "M3151"},
			{ID: 0x3307, Name: "M3307 MPEG-I Video Controller"},
			{ID: 0x3309, Name: "M3309 MPEG-II Video w/ Software Audio Decoder"},
			{ID: 0x3321, Name: "M3321 MPEG-II Audio/Video Decoder"},
			{ID: 0x5212, Name: "M4803"},
			{ID: 0x5215, Name: "ALI PCI EIDE Controller"},
			{ID: 0x5217, Name: "M5217H"},
			{ID: 0x5219, Name: "M5219"},
			{ID: 0x5225, Name: "M5225"},
			{ID: 0x5229, Name: "M5229"},
			{ID: 0x5235, Name: "M5235"},
			{ID: 0x5237, Name: "M5237 PCI USB Host Controller"},
			{ID: 0x5240, Name: "EIDE Controller"},
			{ID: 0x5241, Name: "PCMCIA Bridge"},
			{ID: 0x5242, Name: "General Purpose Controller"},
			{ID: 0x5243, Name: "PCI to PCI Bridge Controller"},
			{ID: 0x5244, Name: "Floppy Disk Controller"},
			{ID: 0x5247, Name: "M1541 PCI to PCI Bridge"},
			{ID: 0x5251, Name: "M5251 P1394 Controller"},
			{ID: 0x5427, Name: "PCI to AGP Bridge"},
			{ID: 0x5451, Name: "M5451 PCI AC-Link Controller Audio Device"},
			{ID: 0x5453, Name: "M5453 PCI AC-Link Controller Modem Device"},
			{ID: 0x7101, Name: "M7101 PCI PMU Power Management Controller"},
			{ID: 0x9602, Name: "AMD RS780/RS880 PCI to PCI bridge (int gfx)"},
		},
	},
	{
		ID: 0x1028, Name: "Dell", Devices: []Device{
			{ID: 0x0001, Name: "PowerEdge Expandable RAID Controller 2/Si"},
			{ID: 0x0002, Name: "PowerEdge Expandable RAID Controller 3/Di"},
			{ID: 0x0003, Name: "PowerEdge Expandable RAID Controller 3/Si"},
			{ID: 0x0004, Name: "PowerEdge Expandable RAID Controller 3/Di [Iguana]"},
			{ID: 0x0006, Name: "PowerEdge Expandable RAID Controller 3/Di"},
			{ID: 0x0007, Name: "Remote Access Card III"},
			{ID: 0x0008, Name: "Remote Access Card III"},
			{ID: 0x0009, Name: "Remote Access Card III: BMC/SMIC device not present"},
			{ID: 0x000a, Name: "PowerEdge Expandable RAID Controller 3/Di"},
			{ID: 0x000c, Name: "Embedded Remote Access or ERA/O"},
			{ID: 0x000d, Name: "Embedded Remote Access: BMC/SMIC device"},
			{ID: 0x000e, Name: "PowerEdge Expandable RAID controller 4/Di"},
			{ID: 0x000f, Name: "PowerEdge Expandable RAID controller 4/Di"},
			{ID: 0x0010, Name: "Remote Access Card 4"},
			{ID: 0x0011, Name: "Remote Access Card 4 Daughter Card"},
			{ID: 0x0012, Name: "Remote Access Card 4 Daughter Card Virtual UART"},
			{ID: 0x0013, Name: "PowerEdge Expandable RAID controller 4"},
			{ID: 0x0014, Name: "Remote Access Card 4 Daughter Card SMIC interface"},
			{ID: 0x0015, Name: "PowerEdge Expandable RAID controller 5"},
			{ID: 0x0016, Name: "PowerEdge Expandable RAID controller S300"},
			{ID: 0x0073, Name: "NV-RAM Adapter"},
		},
	},
	{ID: 0x1029, Name: "Siemens Nixdorf IS", Devices: []Device{}},
	{
		ID: 0x102a, Name: "LSI Logic", Devices: []Device{
			{ID: 0x0000, Name: "HYDRA"},
			{ID: 0x0010, Name: "ASPEN"},
			{ID: 0x001f, Name: "AHA-2940U2/U2W /7890/7891 SCSI Controllers"},
			{ID: 0x00c5, Name: "AIC-7899 U160/m SCSI Controller"},
			{ID: 0x00cf, Name: "AIC-7899P U160/m"},
		},
	},
	{
		ID: 0x102b, Name: "Matrox Electronics Systems Ltd.", Devices: []Device{
			{ID: 0x0010, Name: "MGA-I [Impression?]"},
			{ID: 0x0100, Name: "MGA 1064SG [Mystique]"},
			{ID: 0x0518, Name: "MGA-II [Athena]"},
			{ID: 0x0519, Name: "MGA 2064W [Millennium]"},
			{ID: 0x051a, Name: "MGA 1064SG [Mystique]"},
			{ID: 0x051b, Name: "MGA 2164W [Millennium II]"},
			{ID: 0x051e, Name: "MGA 1064SG [Mystique] AGP"},
			{ID: 0x051f, Name: "MGA 2164W [Millennium II] AGP"},
			{ID: 0x0520, Name: "MGA G200"},
			{ID: 0x0521, Name: "MGA G200 AGP"},
			{ID: 0x0522, Name: "MGA G200e [Pilot] ServerEngines (SEP1)"},
			{ID: 0x0525, Name: "MGA G400/G450"},
			{ID: 0x0527, Name: "Parhelia"},
			{ID: 0x0528, Name: "Parhelia"},
			{ID: 0x0530, Name: "MGA G200EV"},
			{ID: 0x0532, Name: "MGA G200eW WPCM450"},
			{ID: 0x0533, Name: "MGA G200EH"},
			{ID: 0x0534, Name: "G200eR2"},
			{ID: 0x0536, Name: "Integrated Matrox G200eW3 Graphics Controller"},
			{ID: 0x0538, Name: "MGA G200eH3"},
			{ID: 0x0540, Name: "M91XX"},
			{ID: 0x0550, Name: "SV2"},
			{ID: 0x0d10, Name: "MGA Ultima/Impression"},
			{ID: 0x1000, Name: "MGA G100 [Productiva]"},
			{ID: 0x1001, Name: "MGA G100 [Productiva] AGP"},
			{ID: 0x2007, Name: "MGA Mistral"},
			{ID: 0x2527, Name: "Millennium G550"},
			{ID: 0x2537, Name: "Millennium P650/P750"},
			{ID: 0x2538, Name: "Millennium P650 PCIe"},
			{ID: 0x2539, Name: "Millennium P690"},
			{ID: 0x4164, Name: "Morphis QxT frame grabber"},
			{ID: 0x43b4, Name: "Morphis Qxt encoding engine"},
			{ID: 0x4510, Name: "Morphis COM port"},
			{ID: 0x4536, Name: "VIA Framegrabber"},
			{ID: 0x4686, Name: "Concord GX (customized Intel 82541)"},
			{ID: 0x475b, Name: "Solios eCL/XCL-B frame grabber"},
			{ID: 0x475d, Name: "Vio frame grabber family"},
			{ID: 0x475f, Name: "Solios (single-Full) CL frame grabber"},
			{ID: 0x47a1, Name: "Solios eA/XA frame grabber"},
			{ID: 0x47a2, Name: "Solios COM port"},
			{ID: 0x47c1, Name: "Solios (dual-Base/single-Medium) CL frame grabber"},
			{ID: 0x47c2, Name: "Solios COM port"},
			{ID: 0x4949, Name: "Radient frame grabber family"},
			{ID: 0x4cdc, Name: "Morphis JPEG2000 accelerator"},
			{ID: 0x4f54, Name: "Morphis (e)Quad frame grabber"},
			{ID: 0x4fc5, Name: "Morphis (e)Dual frame grabber"},
			{ID: 0x5e10, Name: "Morphis aux I/O"},
			{ID: 0x6573, Name: "Shark 10/100 Multiport SwitchNIC"},
		},
	},
	{
		ID: 0x102c, Name: "Chips and Technologies", Devices: []Device{
			{ID: 0x00b8, Name: "F64310"},
			{ID: 0x00c0, Name: "F69000 HiQVideo"},
			{ID: 0x00d0, Name: "F65545"},
			{ID: 0x00d8, Name: "F65545"},
			{ID: 0x00dc, Name: "F65548"},
			{ID: 0x00e0, Name: "F65550"},
			{ID: 0x00e4, Name: "F65554"},
			{ID: 0x00e5, Name: "F65555 HiQVPro"},
			{ID: 0x00f0, Name: "F68554"},
			{ID: 0x00f4, Name: "F68554 HiQVision"},
			{ID: 0x00f5, Name: "F68555"},
			{ID: 0x0c30, Name: "F69030"},
		},
	},
	{
		ID: 0x102d, Name: "Wyse Technology Inc.", Devices: []Device{
			{ID: 0x50dc, Name: "3328 Audio"},
		},
	},
	{ID: 0x102e, Name: "Olivetti Advanced Technology", Devices: []Device{}},
	{
		ID: 0x102f, Name: "Toshiba America", Devices: []Device{
			{ID: 0x0009, Name: "r4x00"},
			{ID: 0x000a, Name: "TX3927 MIPS RISC PCI Controller"},
			{ID: 0x0020, Name: "ATM Meteor 155"},
			{ID: 0x0030, Name: "TC35815CF PCI 10/100 Mbit Ethernet Controller"},
			{ID: 0x0031, Name: "TC35815CF PCI 10/100 Mbit Ethernet Controller with WOL"},
			{ID: 0x0032, Name: "TC35815CF PCI 10/100 Mbit Ethernet Controller on TX4939"},
			{ID: 0x0105, Name: "TC86C001 [goku-s] IDE"},
			{ID: 0x0106, Name: "TC86C001 [goku-s] USB 1.1 Host"},
			{ID: 0x0107, Name: "TC86C001 [goku-s] USB Device Controller"},
			{ID: 0x0108, Name: "TC86C001 [goku-s] I2C/SIO/GPIO Controller"},
			{ID: 0x0180, Name: "TX4927/38 MIPS RISC PCI Controller"},
			{ID: 0x0181, Name: "TX4925 MIPS RISC PCI Controller"},
			{ID: 0x0182, Name: "TX4937 MIPS RISC PCI Controller"},
			{ID: 0x01b4, Name: "Celleb platform IDE interface"},
			{ID: 0x01b5, Name: "SCC USB 2.0 EHCI controller"},
			{ID: 0x01b6, Name: "SCC USB 1.1 OHCI controller"},
		},
	},
	{ID: 0x1030, Name: "TMC Research", Devices: []Device{}},
	{
		ID: 0x1031, Name: "Miro Computer Products AG", Devices: []Device{
			{ID: 0x5601, Name: "DC20 ASIC"},
			{ID: 0x5607, Name: "Video I/O & motion JPEG compressor"},
			{ID: 0x5631, Name: "Media 3D"},
			{ID: 0x6057, Name: "MiroVideo DC10/DC30+"},
		},
	},
	{ID: 0x1032, Name: "Compaq", Devices: []Device{}},
	{
		ID: 0x1033, Name: "NEC Corporation", Devices: []Device{
			{ID: 0x0000, Name: "Vr4181A USB Host or Function Control Unit"},
			{ID: 0x0001, Name: "PCI to 486-like bus Bridge"},
			{ID: 0x0002, Name: "PCI to VL98 Bridge"},
			{ID: 0x0003, Name: "ATM Controller"},
			{ID: 0x0004, Name: "R4000 PCI Bridge"},
			{ID: 0x0005, Name: "PCI to 486-like bus Bridge"},
			{ID: 0x0006, Name: "PC-9800 Graphic Accelerator"},
			{ID: 0x0007, Name: "PCI to UX-Bus Bridge"},
			{ID: 0x0008, Name: "PC-9800 Graphic Accelerator"},
			{ID: 0x0009, Name: "PCI to PC9800 Core-Graph Bridge"},
			{ID: 0x0016, Name: "PCI to VL Bridge"},
			{ID: 0x001a, Name: "[Nile II]"},
			{ID: 0x0021, Name: "Vrc4373 [Nile I]"},
			{ID: 0x0029, Name: "PowerVR PCX1"},
			{ID: 0x002a, Name: "PowerVR 3D"},
			{ID: 0x002c, Name: "Star Alpha 2"},
			{ID: 0x002d, Name: "PCI to C-bus Bridge"},
			{ID: 0x0035, Name: "OHCI USB Controller"},
			{ID: 0x003b, Name: "PCI to C-bus Bridge"},
			{ID: 0x003e, Name: "NAPCCARD Cardbus Controller"},
			{ID: 0x0046, Name: "PowerVR PCX2 [midas]"},
			{ID: 0x005a, Name: "Vrc5074 [Nile 4]"},
			{ID: 0x0063, Name: "uPD72862 [Firewarden] IEEE1394 OHCI 1.0 Link Controller"},
			{ID: 0x0067, Name: "PowerVR Neon 250 Chipset"},
			{ID: 0x0072, Name: "uPD72874 IEEE1394 OHCI 1.1 3-port PHY-Link Ctrlr"},
			{ID: 0x0074, Name: "56k Voice Modem"},
			{ID: 0x009b, Name: "Vrc5476"},
			{ID: 0x00a5, Name: "VRC4173"},
			{ID: 0x00a6, Name: "VRC5477 AC97"},
			{ID: 0x00cd, Name: "uPD72870 [Firewarden] IEEE1394a OHCI 1.0 Link/3-port PHY Controller"},
			{ID: 0x00ce, Name: "uPD72871 [Firewarden] IEEE1394a OHCI 1.0 Link/1-port PHY Controller"},
			{ID: 0x00df, Name: "Vr4131"},
			{ID: 0x00e0, Name: "uPD72010x USB 2.0 Controller"},
			{ID: 0x00e7, Name: "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller"},
			{ID: 0x00f2, Name: "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller"},
			{ID: 0x00f3, Name: "uPD6113x Multimedia Decoder/Processor [EMMA2]"},
			{ID: 0x010c, Name: "VR7701"},
			{ID: 0x0125, Name: "uPD720400 PCI Express - PCI/PCI-X Bridge"},
			{ID: 0x013a, Name: "Dual Tuner/MPEG Encoder"},
			{ID: 0x0194, Name: "uPD720200 USB 3.0 Host Controller"},
			{ID: 0x01e7, Name: "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller"},
			{ID: 0x01f2, Name: "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller"},
		},
	},
	{ID: 0x1034, Name: "Framatome Connectors USA Inc.", Devices: []Device{}},
	{ID: 0x1035, Name: "Comp. & Comm. Research Lab", Devices: []Device{}},
	{
		ID: 0x1036, Name: "Future Domain Corp.", Devices: []Device{
			{ID: 0x0000, Name: "TMC-18C30 [36C70]"},
		},
	},
	{ID: 0x1037, Name: "Hitachi Micro Systems", Devices: []Device{}},
	{ID: 0x1038, Name: "AMP, Inc", Devices: []Device{}},
	{
		ID: 0x1039, Name: "Silicon Integrated Systems [SiS]", Devices: []Device{
			{ID: 0x0001, Name: "AGP Port (virtual PCI-to-PCI bridge)"},
			{ID: 0x0002, Name: "AGP Port (virtual PCI-to-PCI bridge)"},
			{ID: 0x0003, Name: "AGP Port (virtual PCI-to-PCI bridge)"},
			{ID: 0x0004, Name: "PCI-to-PCI bridge"},
			{ID: 0x0006, Name: "85C501/2/3"},
			{ID: 0x0008, Name: "SiS85C503/5513 (LPC Bridge)"},
			{ID: 0x0009, Name: "5595 Power Management Controller"},
			{ID: 0x000a, Name: "PCI-to-PCI bridge"},
			{ID: 0x0016, Name: "SiS961/2/3 SMBus controller"},
			{ID: 0x0018, Name: "SiS85C503/5513 (LPC Bridge)"},
			{ID: 0x0163, Name: "163 802.11b/g Wireless LAN Adapter"},
			{ID: 0x0180, Name: "RAID bus controller 180 SATA/PATA  [SiS]"},
			{ID: 0x0181, Name: "SATA"},
			{ID: 0x0182, Name: "182 SATA/RAID Controller"},
			{ID: 0x0186, Name: "AHCI Controller (0106)"},
			{ID: 0x0190, Name: "190 Ethernet Adapter"},
			{ID: 0x0191, Name: "191 Gigabit Ethernet Adapter"},
			{ID: 0x0200, Name: "5597/5598/6326 VGA"},
			{ID: 0x0204, Name: "82C204"},
			{ID: 0x0205, Name: "SG86C205"},
			{ID: 0x0300, Name: "300/305 PCI/AGP VGA Display Adapter"},
			{ID: 0x0310, Name: "315H PCI/AGP VGA Display Adapter"},
			{ID: 0x0315, Name: "315 PCI/AGP VGA Display Adapter"},
			{ID: 0x0325, Name: "315PRO PCI/AGP VGA Display Adapter"},
			{ID: 0x0330, Name: "330 [Xabre] PCI/AGP VGA Display Adapter"},
			{ID: 0x0406, Name: "85C501/2"},
			{ID: 0x0496, Name: "SiS85C496 PCI & CPU Memory Controller (PCM)"},
			{ID: 0x0530, Name: "530 Host"},
			{ID: 0x0540, Name: "540 Host"},
			{ID: 0x0550, Name: "550 Host"},
			{ID: 0x0597, Name: "5513C"},
			{ID: 0x0601, Name: "85C601"},
			{ID: 0x0620, Name: "620 Host"},
			{ID: 0x0630, Name: "630 Host"},
			{ID: 0x0633, Name: "633 Host"},
			{ID: 0x0635, Name: "635 Host"},
			{ID: 0x0645, Name: "SiS645 Host & Memory & AGP Controller"},
			{ID: 0x0646, Name: "SiS645DX Host & Memory & AGP Controller"},
			{ID: 0x0648, Name: "645xx"},
			{ID: 0x0649, Name: "SiS649 Host"},
			{ID: 0x0650, Name: "650/M650 Host"},
			{ID: 0x0651, Name: "651 Host"},
			{ID: 0x0655, Name: "655 Host"},
			{ID: 0x0660, Name: "660 Host"},
			{ID: 0x0661, Name: "661FX/M661FX/M661MX Host"},
			{ID: 0x0662, Name: "662 Host"},
			{ID: 0x0671, Name: "671MX"},
			{ID: 0x0730, Name: "730 Host"},
			{ID: 0x0733, Name: "733 Host"},
			{ID: 0x0735, Name: "735 Host"},
			{ID: 0x0740, Name: "740 Host"},
			{ID: 0x0741, Name: "741/741GX/M741 Host"},
			{ID: 0x0745, Name: "745 Host"},
			{ID: 0x0746, Name: "746 Host"},
			{ID: 0x0755, Name: "755 Host"},
			{ID: 0x0760, Name: "760/M760 Host"},
			{ID: 0x0761, Name: "761/M761 Host"},
			{ID: 0x0900, Name: "SiS900 PCI Fast Ethernet"},
			{ID: 0x0961, Name: "SiS961 [MuTIOL Media IO]"},
			{ID: 0x0962, Name: "SiS962 [MuTIOL Media IO] LPC Controller"},
			{ID: 0x0963, Name: "SiS963 [MuTIOL Media IO] LPC Controller"},
			{ID: 0x0964, Name: "SiS964 [MuTIOL Media IO] LPC Controller"},
			{ID: 0x0965, Name: "SiS965 [MuTIOL Media IO]"},
			{ID: 0x0966, Name: "SiS966 [MuTIOL Media IO]"},
			{ID: 0x0968, Name: "SiS968 [MuTIOL Media IO]"},
			{ID: 0x1180, Name: "SATA Controller / IDE mode"},
			{ID: 0x1182, Name: "SATA Controller / RAID mode"},
			{ID: 0x1183, Name: "SATA Controller / IDE mode"},
			{ID: 0x1184, Name: "AHCI Controller / RAID mode"},
			{ID: 0x1185, Name: "AHCI IDE Controller (0106)"},
			{ID: 0x3602, Name: "83C602"},
			{ID: 0x5107, Name: "5107"},
			{ID: 0x5300, Name: "SiS540 PCI Display Adapter"},
			{ID: 0x5315, Name: "550 PCI/AGP VGA Display Adapter"},
			{ID: 0x5401, Name: "486 PCI Chipset"},
			{ID: 0x5511, Name: "5511/5512"},
			{ID: 0x5513, Name: "5513 IDE Controller"},
			{ID: 0x5517, Name: "5517"},
			{ID: 0x5571, Name: "5571"},
			{ID: 0x5581, Name: "5581 Pentium Chipset"},
			{ID: 0x5582, Name: "5582"},
			{ID: 0x5591, Name: "5591/5592 Host"},
			{ID: 0x5596, Name: "5596 Pentium Chipset"},
			{ID: 0x5597, Name: "5597 [SiS5582]"},
			{ID: 0x5600, Name: "5600 Host"},
			{ID: 0x6204, Name: "Video decoder & MPEG interface"},
			{ID: 0x6205, Name: "VGA Controller"},
			{ID: 0x6236, Name: "6236 3D-AGP"},
			{ID: 0x6300, Name: "630/730 PCI/AGP VGA Display Adapter"},
			{ID: 0x6306, Name: "530/620 PCI/AGP VGA Display Adapter"},
			{ID: 0x6325, Name: "65x/M650/740 PCI/AGP VGA Display Adapter"},
			{ID: 0x6326, Name: "86C326 5598/6326"},
			{ID: 0x6330, Name: "661/741/760 PCI/AGP or 662/761Gx PCIE VGA Display Adapter"},
			{ID: 0x6350, Name: "770/670 PCIE VGA Display Adapter"},
			{ID: 0x6351, Name: "771/671 PCIE VGA Display Adapter"},
			{ID: 0x7001, Name: "USB 1.1 Controller"},
			{ID: 0x7002, Name: "USB 2.0 Controller"},
			{ID: 0x7007, Name: "FireWire Controller"},
			{ID: 0x7012, Name: "SiS7012 AC'97 Sound Controller"},
			{ID: 0x7013, Name: "AC'97 Modem Controller"},
			{ID: 0x7016, Name: "SiS7016 PCI Fast Ethernet Adapter"},
			{ID: 0x7018, Name: "SiS PCI Audio Accelerator"},
			{ID: 0x7019, Name: "SiS7019 Audio Accelerator"},
			{ID: 0x7502, Name: "Azalia Audio Controller"},
		},
	},
	{ID: 0x103a, Name: "Seiko Epson Corporation", Devices: []Device{}},
	{ID: 0x103b, Name: "Tatung Corp. Of America", Devices: []Device{}},
	{
		ID: 0x103c, Name: "Hewlett-Packard Company", Devices: []Device{
			{ID: 0x1005, Name: "A4977A Visualize EG"},
			{ID: 0x1008, Name: "Visualize FX"},
			{ID: 0x1028, Name: "Tach TL Fibre Channel Host Adapter"},
			{ID: 0x1029, Name: "Tach XL2 Fibre Channel Host Adapter"},
			{ID: 0x102a, Name: "Tach TS Fibre Channel Host Adapter"},
			{ID: 0x1030, Name: "J2585A DeskDirect 10/100VG NIC"},
			{ID: 0x1031, Name: "J2585B HP 10/100VG PCI LAN Adapter"},
			{ID: 0x1040, Name: "J2973A DeskDirect 10BaseT NIC"},
			{ID: 0x1041, Name: "J2585B DeskDirect 10/100 NIC"},
			{ID: 0x1042, Name: "J2970A DeskDirect 10BaseT/2 NIC"},
			{ID: 0x1048, Name: "Diva Serial [GSP] Multiport UART"},
			{ID: 0x1054, Name: "PCI Local Bus Adapter"},
			{ID: 0x1064, Name: "79C970 PCnet Ethernet Controller"},
			{ID: 0x108b, Name: "Visualize FXe"},
			{ID: 0x10c1, Name: "NetServer Smart IRQ Router"},
			{ID: 0x10ed, Name: "TopTools Remote Control"},
			{ID: 0x10f0, Name: "rio System Bus Adapter"},
			{ID: 0x10f1, Name: "rio I/O Controller"},
			{ID: 0x1219, Name: "NetServer PCI Hot-Plug Controller"},
			{ID: 0x121a, Name: "NetServer SMIC Controller"},
			{ID: 0x121b, Name: "NetServer Legacy COM Port Decoder"},
			{ID: 0x121c, Name: "NetServer PCI COM Port Decoder"},
			{ID: 0x1229, Name: "zx1 System Bus Adapter"},
			{ID: 0x122a, Name: "zx1 I/O Controller"},
			{ID: 0x122e, Name: "PCI-X Local Bus Adapter"},
			{ID: 0x127b, Name: "sx1000 System Bus Adapter"},
			{ID: 0x127c, Name: "sx1000 I/O Controller"},
			{ID: 0x128d, Name: "Diva [GSP] Management Board"},
			{ID: 0x1290, Name: "Auxiliary Diva Serial Port"},
			{ID: 0x1291, Name: "Auxiliary Diva Serial Port"},
			{ID: 0x12b4, Name: "zx1 QuickSilver AGP8x Local Bus Adapter"},
			{ID: 0x12eb, Name: "sx2000 System Bus Adapter"},
			{ID: 0x12ec, Name: "sx2000 I/O Controller"},
			{ID: 0x12ee, Name: "PCI-X 2.0 Local Bus Adapter"},
			{ID: 0x1302, Name: "RMP-3 Shared Memory Driver"},
			{ID: 0x1303, Name: "RMP-3 (Remote Management Processor)"},
			{ID: 0x22f6, Name: "iLO5 Virtual USB Controller"},
			{ID: 0x2910, Name: "E2910A PCIBus Exerciser"},
			{ID: 0x2925, Name: "E2925A 32 Bit, 33 MHzPCI Exerciser & Analyzer"},
			{ID: 0x3206, Name: "Adaptec Embedded Serial ATA HostRAID"},
			{ID: 0x3220, Name: "Smart Array P600"},
			{ID: 0x3230, Name: "Smart Array Controller"},
			{ID: 0x3238, Name: "Smart Array E200i (SAS Controller)"},
			{ID: 0x3239, Name: "Smart Array Gen9 Controllers"},
			{ID: 0x323a, Name: "Smart Array G6 controllers"},
			{ID: 0x323b, Name: "Smart Array Gen8 Controllers"},
			{ID: 0x323c, Name: "Smart Array Gen8+ Controllers"},
			{ID: 0x3300, Name: "Integrated Lights-Out Standard Virtual USB Controller"},
			{ID: 0x3301, Name: "Integrated Lights-Out Standard Serial Port"},
			{ID: 0x3302, Name: "Integrated Lights-Out Standard KCS Interface"},
			{ID: 0x3305, Name: "Integrated Lights-Out (iLO2) Controller"},
			{ID: 0x3306, Name: "Integrated Lights-Out Standard Slave Instrumentation & System Support"},
			{ID: 0x3307, Name: "Integrated Lights-Out Standard Management Processor Support and Messaging"},
			{ID: 0x3308, Name: "Integrated Lights-Out Standard MS Watchdog Timer"},
			{ID: 0x4030, Name: "zx2 System Bus Adapter"},
			{ID: 0x4031, Name: "zx2 I/O Controller"},
			{ID: 0x4037, Name: "PCIe Local Bus Adapter"},
			{ID: 0x9602, Name: "AMD RS780/RS880 PCI to PCI bridge (int gfx)"},
		},
	},
	{ID: 0x103e, Name: "Solliday Engineering", Devices: []Device{}},
	{ID: 0x103f, Name: "Synopsys/Logic Modeling Group", Devices: []Device{}},
	{ID: 0x1040, Name: "Accelgraphics Inc.", Devices: []Device{}},
	{ID: 0x1041, Name: "Computrend", Devices: []Device{}},
	{
		ID: 0x1042, Name: "Micron", Devices: []Device{
			{ID: 0x1000, Name: "PC Tech RZ1000"},
			{ID: 0x1001, Name: "PC Tech RZ1001"},
			{ID: 0x3000, Name: "Samurai_0"},
			{ID: 0x3010, Name: "Samurai_1"},
			{ID: 0x3020, Name: "Samurai_IDE"},
		},
	},
	{
		ID: 0x1043, Name: "ASUSTeK Computer Inc.", Devices: []Device{
			{ID: 0x0464, Name: "Radeon R9 270x GPU"},
			{ID: 0x0521, Name: "RX580 [RX 580 Dual O8G]"},
			{ID: 0x0675, Name: "ISDNLink P-IN100-ST-D"},
			{ID: 0x9602, Name: "AMD RS780/RS880 PCI to PCI bridge (int gfx)"},
		},
	},
	{
		ID: 0x1044, Name: "Adaptec (formerly DPT)", Devices: []Device{
			{ID: 0x1012, Name: "Domino RAID Engine"},
			{ID: 0xa400, Name: "SmartCache/Raid I-IV Controller"},
			{ID: 0xa500, Name: "PCI Bridge"},
			{ID: 0xa501, Name: "SmartRAID V Controller"},
			{ID: 0xa511, Name: "SmartRAID V Controller"},
			{ID: 0xc066, Name: "3010S Ultra3 Dual Channel"},
		},
	},
	{
		ID: 0x1045, Name: "OPTi Inc.", Devices: []Device{
			{ID: 0xa0f8, Name: "82C750 [Vendetta] USB Controller"},
			{ID: 0xc101, Name: "92C264"},
			{ID: 0xc178, Name: "92C178"},
			{ID: 0xc556, Name: "82X556 [Viper]"},
			{ID: 0xc557, Name: "82C557 [Viper-M]"},
			{ID: 0xc558, Name: "82C558 [Viper-M ISA+IDE]"},
			{ID: 0xc567, Name: "82C750 [Vendetta], device 0"},
			{ID: 0xc568, Name: "82C750 [Vendetta], device 1"},
			{ID: 0xc569, Name: "82C579 [Viper XPress+ Chipset]"},
			{ID: 0xc621, Name: "82C621 [Viper-M/N+]"},
			{ID: 0xc700, Name: "82C700 [FireStar]"},
			{ID: 0xc701, Name: "82C701 [FireStar Plus]"},
			{ID: 0xc814, Name: "82C814 [Firebridge 1]"},
			{ID: 0xc822, Name: "82C822"},
			{ID: 0xc824, Name: "82C824"},
			{ID: 0xc825, Name: "82C825 [Firebridge 2]"},
			{ID: 0xc832, Name: "82C832"},
			{ID: 0xc861, Name: "82C861 OHCI USB Host"},
			{ID: 0xc881, Name: "82C881 [FireLink] 1394 OHCI Link Controller"},
			{ID: 0xc895, Name: "82C895"},
			{ID: 0xc935, Name: "EV1935 ECTIVA MachOne PCIAudio"},
			{ID: 0xd568, Name: "82C825 [Firebridge 2]"},
			{ID: 0xd721, Name: "IDE [FireStar]"},
		},
	},
	{ID: 0x1046, Name: "IPC Corporation, Ltd.", Devices: []Device{}},
	{ID: 0x1047, Name: "Genoa Systems Corp", Devices: []Device{}},
	{
		ID: 0x1048, Name: "Elsa AG", Devices: []Device{
			{ID: 0x0c60, Name: "Gladiac MX"},
			{ID: 0x0d22, Name: "Quadro4 900XGL [ELSA GLoria4 900XGL]"},
			{ID: 0x1000, Name: "QuickStep 1000"},
			{ID: 0x3000, Name: "QuickStep 3000"},
			{ID: 0x8901, Name: "Gloria XL"},
		},
	},
	{ID: 0x1049, Name: "Fountain Technologies, Inc.", Devices: []Device{}},
	{
		ID: 0x104a, Name: "STMicroelectronics", Devices: []Device{
			{ID: 0x0000, Name: "STLS2F Host Bridge"},
			{ID: 0x0008, Name: "STG 2000X"},
			{ID: 0x0009, Name: "STG 1764X"},
			{ID: 0x0010, Name: "STG4000 [3D Prophet Kyro Series]"},
			{ID: 0x0201, Name: "STPC Vega Northbridge"},
			{ID: 0x0209, Name: "STPC Consumer/Industrial North- and Southbridge"},
			{ID: 0x020a, Name: "STPC Atlas/ConsumerS/Consumer IIA Northbridge"},
			{ID: 0x020b, Name: "STPC Consumer II ISA Bridge"},
			{ID: 0x0210, Name: "STPC Atlas ISA Bridge"},
			{ID: 0x021a, Name: "STPC Consumer S Southbridge"},
			{ID: 0x021b, Name: "STPC Consumer IIA Southbridge"},
			{ID: 0x0220, Name: "STPC Industrial PCI to PCCard bridge"},
			{ID: 0x0228, Name: "STPC Atlas IDE"},
			{ID: 0x0229, Name: "STPC Vega IDE"},
			{ID: 0x0230, Name: "STPC Atlas/Vega OHCI USB Controller"},
			{ID: 0x0238, Name: "STPC Vega LAN"},
			{ID: 0x0500, Name: "ST70137 [Unicorn] ADSL DMT Transceiver"},
			{ID: 0x0564, Name: "STPC Client Northbridge"},
			{ID: 0x0981, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
			{ID: 0x1746, Name: "STG 1764X"},
			{ID: 0x2774, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
			{ID: 0x3520, Name: "MPEG-II decoder card"},
			{ID: 0x55cc, Name: "STPC Client Southbridge"},
		},
	},
	{
		ID: 0x104b, Name: "BusLogic", Devices: []Device{
			{ID: 0x0140, Name: "BT-946C (old) [multimaster  01]"},
			{ID: 0x1040, Name: "BT-946C (BA80C30) [MultiMaster 10]"},
			{ID: 0x8130, Name: "Flashpoint LT"},
		},
	},
	{
		ID: 0x104c, Name: "Texas Instruments", Devices: []Device{
			{ID: 0x0500, Name: "100 MBit LAN Controller"},
			{ID: 0x0508, Name: "TMS380C2X Compressor Interface"},
			{ID: 0x1000, Name: "Eagle i/f AS"},
			{ID: 0x104c, Name: "PCI1510 PC card Cardbus Controller"},
			{ID: 0x3d04, Name: "TVP4010 [Permedia]"},
			{ID: 0x3d07, Name: "TVP4020 [Permedia 2]"},
			{ID: 0x8000, Name: "PCILynx/PCILynx2 IEEE 1394 Link Layer Controller"},
			{ID: 0x8009, Name: "TSB12LV22 IEEE-1394 Controller"},
			{ID: 0x8017, Name: "PCI4410 FireWire Controller"},
			{ID: 0x8019, Name: "TSB12LV23 IEEE-1394 Controller"},
			{ID: 0x8020, Name: "TSB12LV26 IEEE-1394 Controller (Link)"},
			{ID: 0x8021, Name: "TSB43AA22 IEEE-1394 Controller (PHY/Link Integrated)"},
			{ID: 0x8022, Name: "TSB43AB22 IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx]"},
			{ID: 0x8023, Name: "TSB43AB22A IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx]"},
			{ID: 0x8024, Name: "TSB43AB23 IEEE-1394a-2000 Controller (PHY/Link)"},
			{ID: 0x8025, Name: "TSB82AA2 IEEE-1394b Link Layer Controller"},
			{ID: 0x8026, Name: "TSB43AB21 IEEE-1394a-2000 Controller (PHY/Link)"},
			{ID: 0x8027, Name: "PCI4451 IEEE-1394 Controller"},
			{ID: 0x8029, Name: "PCI4510 IEEE-1394 Controller"},
			{ID: 0x802b, Name: "PCI7410,7510,7610 OHCI-Lynx Controller"},
			{ID: 0x802e, Name: "PCI7x20 1394a-2000 OHCI Two-Port PHY/Link-Layer Controller"},
			{ID: 0x8031, Name: "PCIxx21/PCIxx11/PCIx515 PC Card Controller"},
			{ID: 0x8032, Name: "OHCI Compliant IEEE 1394 Host Controller"},
			{ID: 0x8033, Name: "PCIxx21/PCIxx11 Flash Media Controller"},
			{ID: 0x8034, Name: "PCIxx21/PCIxx11 SD Host Controller"},
			{ID: 0x8035, Name: "PCIxx21/PCIxx11 Smart Card Controller"},
			{ID: 0x8036, Name: "PCI6515 Cardbus Controller"},
			{ID: 0x8038, Name: "PCI6515 SmartCard Controller"},
			{ID: 0x8039, Name: "PCIxx12 Cardbus Controller"},
			{ID: 0x803a, Name: "PCIxx12 OHCI Compliant IEEE 1394 Host Controller"},
			{ID: 0x803b, Name: "PCIxx12 Flash Media Controller"},
			{ID: 0x803c, Name: "PCIxx12 SDA Standard Compliant SD Host Controller"},
			{ID: 0x803d, Name: "PCIxx12 GemCore based SmartCard controller"},
			{ID: 0x8101, Name: "TSB43DB42 IEEE-1394a-2000 Controller (PHY/Link)"},
			{ID: 0x8201, Name: "PCI1620 Firmware Loading Function"},
			{ID: 0x8204, Name: "PCI7410/7510/7610 PCI Firmware Loading Function"},
			{ID: 0x8231, Name: "XIO2000(A)/XIO2200A PCI Express-to-PCI Bridge"},
			{ID: 0x8232, Name: "XIO3130 PCI Express Switch (Upstream)"},
			{ID: 0x8233, Name: "XIO3130 PCI Express Switch (Downstream)"},
			{ID: 0x8235, Name: "XIO2200A IEEE-1394a-2000 Controller (PHY/Link)"},
			{ID: 0x823e, Name: "XIO2213A/B/XIO2221 PCI Express to PCI Bridge [Cheetah Express]"},
			{ID: 0x823f, Name: "XIO2213A/B/XIO2221 IEEE-1394b OHCI Controller [Cheetah Express]"},
			{ID: 0x8240, Name: "XIO2001 PCI Express-to-PCI Bridge"},
			{ID: 0x8241, Name: "TUSB73x0 SuperSpeed USB 3.0 xHCI Host Controller"},
			{ID: 0x8400, Name: "ACX 100 22Mbps Wireless Interface"},
			{ID: 0x8401, Name: "ACX 100 22Mbps Wireless Interface"},
			{ID: 0x8888, Name: "Multicore DSP+ARM KeyStone II SOC"},
			{ID: 0x9000, Name: "Wireless Interface (of unknown type)"},
			{ID: 0x9065, Name: "TMS320DM642"},
			{ID: 0x9066, Name: "ACX 111 54Mbps Wireless Interface"},
			{ID: 0xa001, Name: "TDC1570"},
			{ID: 0xa100, Name: "TDC1561"},
			{ID: 0xa102, Name: "TNETA1575 HyperSAR Plus w/PCI Host i/f & UTOPIA i/f"},
			{ID: 0xa106, Name: "TMS320C6414 TMS320C6415 TMS320C6416"},
			{ID: 0xac10, Name: "PCI1050"},
			{ID: 0xac11, Name: "PCI1053"},
			{ID: 0xac12, Name: "PCI1130"},
			{ID: 0xac13, Name: "PCI1031"},
			{ID: 0xac15, Name: "PCI1131"},
			{ID: 0xac16, Name: "PCI1250"},
			{ID: 0xac17, Name: "PCI1220"},
			{ID: 0xac18, Name: "PCI1260"},
			{ID: 0xac19, Name: "PCI1221"},
			{ID: 0xac1a, Name: "PCI1210"},
			{ID: 0xac1b, Name: "PCI1450"},
			{ID: 0xac1c, Name: "PCI1225"},
			{ID: 0xac1d, Name: "PCI1251A"},
			{ID: 0xac1e, Name: "PCI1211"},
			{ID: 0xac1f, Name: "PCI1251B"},
			{ID: 0xac20, Name: "TI 2030"},
			{ID: 0xac21, Name: "PCI2031"},
			{ID: 0xac22, Name: "PCI2032 PCI Docking Bridge"},
			{ID: 0xac23, Name: "PCI2250 PCI-to-PCI Bridge"},
			{ID: 0xac28, Name: "PCI2050 PCI-to-PCI Bridge"},
			{ID: 0xac2c, Name: "PCI2060 PCI-to-PCI Bridge"},
			{ID: 0xac30, Name: "PCI1260 PC card Cardbus Controller"},
			{ID: 0xac40, Name: "PCI4450 PC card Cardbus Controller"},
			{ID: 0xac41, Name: "PCI4410 PC card Cardbus Controller"},
			{ID: 0xac42, Name: "PCI4451 PC card Cardbus Controller"},
			{ID: 0xac44, Name: "PCI4510 PC card Cardbus Controller"},
			{ID: 0xac46, Name: "PCI4520 PC card Cardbus Controller"},
			{ID: 0xac47, Name: "PCI7510 PC card Cardbus Controller"},
			{ID: 0xac48, Name: "PCI7610 PC Card Cardbus Controller"},
			{ID: 0xac49, Name: "PCI7410 PC Card Cardbus Controller"},
			{ID: 0xac4a, Name: "PCI7510/7610 CardBus Bridge"},
			{ID: 0xac4b, Name: "PCI7610 SD/MMC controller"},
			{ID: 0xac4c, Name: "PCI7610 Memory Stick controller"},
			{ID: 0xac50, Name: "PCI1410 PC card Cardbus Controller"},
			{ID: 0xac51, Name: "PCI1420 PC card Cardbus Controller"},
			{ID: 0xac52, Name: "PCI1451 PC card Cardbus Controller"},
			{ID: 0xac53, Name: "PCI1421 PC card Cardbus Controller"},
			{ID: 0xac54, Name: "PCI1620 PC Card Controller"},
			{ID: 0xac55, Name: "PCI1520 PC card Cardbus Controller"},
			{ID: 0xac56, Name: "PCI1510 PC card Cardbus Controller"},
			{ID: 0xac60, Name: "PCI2040 PCI to DSP Bridge Controller"},
			{ID: 0xac8d, Name: "PCI 7620"},
			{ID: 0xac8e, Name: "PCI7420 CardBus Controller"},
			{ID: 0xac8f, Name: "PCI7420/7620 SD/MS-Pro Controller"},
			{ID: 0xb001, Name: "TMS320C6424"},
			{ID: 0xfe00, Name: "FireWire Host Controller"},
			{ID: 0xfe03, Name: "12C01A FireWire Host Controller"},
		},
	},
	{
		ID: 0x104d, Name: "Sony Corporation", Devices: []Device{
			{ID: 0x8004, Name: "DTL-H2500 [Playstation development board]"},
			{ID: 0x8009, Name: "CXD1947Q i.LINK Controller"},
			{ID: 0x800c, Name: "DTL-H800 [PS1 sound development board]"},
			{ID: 0x8039, Name: "CXD3222 i.LINK Controller"},
			{ID: 0x8047, Name: "PS2 TOOL MRP"},
			{ID: 0x8056, Name: "Rockwell HCF 56K modem"},
			{ID: 0x808a, Name: "Memory Stick Controller"},
			{ID: 0x80ff, Name: "PS2 Performance Analyzer"},
			{ID: 0x814a, Name: "PS2 Performance Analyzer"},
			{ID: 0x8183, Name: "ATHENS [PS3 prototype developer interface card]"},
			{ID: 0x81b0, Name: "BM-1 [PSP TOOL Board Management Device]"},
			{ID: 0x81c3, Name: "VO-4 [PSP TOOL Video Output Device]"},
			{ID: 0x81ce, Name: "SxS Pro memory card"},
			{ID: 0x81ff, Name: "PS3 TOOL MRP"},
			{ID: 0x8200, Name: "PS3 TOOL RSX Tracing FPGA"},
			{ID: 0x820e, Name: "CXD9208GP [PS3 PS2 emulation subsystem adapter]"},
			{ID: 0x905c, Name: "SxS Pro memory card"},
			{ID: 0x907f, Name: "SxS Pro+ memory card"},
			{ID: 0x908f, Name: "Aeolia ACPI"},
			{ID: 0x909e, Name: "Aeolia Ethernet Controller (Marvell Yukon 2 Family)"},
			{ID: 0x909f, Name: "Aeolia SATA AHCI Controller"},
			{ID: 0x90a0, Name: "Aeolia SD/MMC Host Controller"},
			{ID: 0x90a1, Name: "Aeolia PCI Express Glue and Miscellaneous Devices"},
			{ID: 0x90a2, Name: "Aeolia DMA Controller"},
			{ID: 0x90a3, Name: "Aeolia Memory (DDR3/SPM)"},
			{ID: 0x90a4, Name: "Aeolia USB 3.0 xHCI Host Controller"},
			{ID: 0x90bc, Name: "SxS Pro+ memory card"},
			{ID: 0x90c8, Name: "Belize ACPI"},
			{ID: 0x90c9, Name: "Belize Ethernet Controller"},
			{ID: 0x90ca, Name: "Belize SATA AHCI Controller"},
			{ID: 0x90cb, Name: "Belize SD/MMC Host Controller"},
			{ID: 0x90cc, Name: "Belize PCI Express Glue and Miscellaneous Devices"},
			{ID: 0x90cd, Name: "Belize DMA Controller"},
			{ID: 0x90ce, Name: "Belize Memory (DDR3/SPM)"},
			{ID: 0x90cf, Name: "Belize USB 3.0 xHCI Host Controller"},
			{ID: 0x90d7, Name: "Baikal ACPI"},
			{ID: 0x90d8, Name: "Baikal Ethernet Controller"},
			{ID: 0x90d9, Name: "Baikal SATA AHCI Controller"},
			{ID: 0x90da, Name: "Baikal SD/MMC Host Controller"},
			{ID: 0x90db, Name: "Baikal PCI Express Glue and Miscellaneous Devices"},
			{ID: 0x90dc, Name: "Baikal DMA Controller"},
			{ID: 0x90dd, Name: "Baikal Memory (DDR3/SPM)"},
			{ID: 0x90de, Name: "Baikal USB 3.0 xHCI Host Controller"},
		},
	},
	{
		ID: 0x104e, Name: "Oak Technology, Inc", Devices: []Device{
			{ID: 0x0017, Name: "OTI-64017"},
			{ID: 0x0107, Name: "OTI-107 [Spitfire]"},
			{ID: 0x0109, Name: "Video Adapter"},
			{ID: 0x0111, Name: "OTI-64111 [Spitfire]"},
			{ID: 0x0217, Name: "OTI-64217"},
			{ID: 0x0317, Name: "OTI-64317"},
		},
	},
	{ID: 0x104f, Name: "Co-time Computer Ltd", Devices: []Device{}},
	{
		ID: 0x1050, Name: "Winbond Electronics Corp", Devices: []Device{
			{ID: 0x0000, Name: "NE2000"},
			{ID: 0x0001, Name: "W83769F"},
			{ID: 0x0033, Name: "W89C33D 802.11 a/b/g BB/MAC"},
			{ID: 0x0105, Name: "W82C105"},
			{ID: 0x0840, Name: "W89C840"},
			{ID: 0x0940, Name: "W89C940"},
			{ID: 0x5a5a, Name: "W89C940F"},
			{ID: 0x6692, Name: "W6692"},
			{ID: 0x9921, Name: "W99200F MPEG-1 Video Encoder"},
			{ID: 0x9922, Name: "W99200F/W9922PF MPEG-1/2 Video Encoder"},
			{ID: 0x9970, Name: "W9970CF"},
		},
	},
	{ID: 0x1051, Name: "Anigma, Inc.", Devices: []Device{}},
	{ID: 0x1052, Name: "?Young Micro Systems", Devices: []Device{}},
	{ID: 0x1053, Name: "Young Micro Systems", Devices: []Device{}},
	{
		ID: 0x1054, Name: "Hitachi, Ltd", Devices: []Device{
			{ID: 0x3009, Name: "2Gbps Fibre Channel to PCI HBA 3009"},
			{ID: 0x300a, Name: "4Gbps Fibre Channel to PCI-X HBA 300a"},
			{ID: 0x300b, Name: "4Gbps Fibre Channel to PCI-X HBA 300b"},
			{ID: 0x300f, Name: "ColdFusion 3 Chipset Processor to I/O Controller"},
			{ID: 0x3010, Name: "ColdFusion 3 Chipset Memory Controller Hub"},
			{ID: 0x3011, Name: "ColdFusion 3e Chipset Processor to I/O Controller"},
			{ID: 0x3012, Name: "ColdFusion 3e Chipset Memory Controller Hub"},
			{ID: 0x3017, Name: "Unassigned Hitachi Shared FC Device 3017"},
			{ID: 0x301b, Name: "Virtual VGA Device"},
			{ID: 0x301d, Name: "PCIe-to-PCIe Bridge with Virtualization IO Assist Feature"},
			{ID: 0x3020, Name: "FIVE-EX based Fibre Channel to PCIe HBA"},
			{ID: 0x302c, Name: "M001 PCI Express Switch Upstream Port"},
			{ID: 0x302d, Name: "M001 PCI Express Switch Downstream Port"},
			{ID: 0x3070, Name: "Hitachi FIVE-FX Fibre Channel to PCIe HBA"},
			{ID: 0x3505, Name: "SH7751 PCI Controller (PCIC)"},
			{ID: 0x350e, Name: "SH7751R PCI Controller (PCIC)"},
		},
	},
	{
		ID: 0x1055, Name: "Microchip Technology / SMSC", Devices: []Device{
			{ID: 0x9130, Name: "SLC90E66 [Victory66] IDE"},
			{ID: 0x9460, Name: "SLC90E66 [Victory66] ISA"},
			{ID: 0x9462, Name: "SLC90E66 [Victory66] USB"},
			{ID: 0x9463, Name: "SLC90E66 [Victory66] ACPI"},
			{ID: 0xe420, Name: "LAN9420/LAN9420i"},
		},
	},
	{ID: 0x1056, Name: "ICL", Devices: []Device{}},
	{
		ID: 0x1057, Name: "Motorola", Devices: []Device{
			{ID: 0x0001, Name: "MPC105 [Eagle]"},
			{ID: 0x0002, Name: "MPC106 [Grackle]"},
			{ID: 0x0003, Name: "MPC8240 [Kahlua]"},
			{ID: 0x0004, Name: "MPC107"},
			{ID: 0x0006, Name: "MPC8245 [Unity]"},
			{ID: 0x0008, Name: "MPC8540"},
			{ID: 0x0009, Name: "MPC8560"},
			{ID: 0x0012, Name: "MPC8548 [PowerQUICC III]"},
			{ID: 0x0100, Name: "MC145575 [HFC-PCI]"},
			{ID: 0x0431, Name: "KTI829c 100VG"},
			{ID: 0x1073, Name: "Nokia N770"},
			{ID: 0x1219, Name: "Nokia N800"},
			{ID: 0x1801, Name: "DSP56301 Digital Signal Processor"},
			{ID: 0x18c0, Name: "MPC8265A/8266/8272"},
			{ID: 0x18c1, Name: "MPC8271/MPC8272"},
			{ID: 0x3052, Name: "SM56 Data Fax Modem"},
			{ID: 0x3410, Name: "DSP56361 Digital Signal Processor"},
			{ID: 0x4801, Name: "Raven"},
			{ID: 0x4802, Name: "Falcon"},
			{ID: 0x4803, Name: "Hawk"},
			{ID: 0x4806, Name: "CPX8216"},
			{ID: 0x480b, Name: "MPC7410"},
			{ID: 0x4d68, Name: "20268"},
			{ID: 0x5600, Name: "SM56 PCI Modem"},
			{ID: 0x5608, Name: "Wildcard X100P"},
			{ID: 0x5803, Name: "MPC5200"},
			{ID: 0x5806, Name: "MCF54 Coldfire"},
			{ID: 0x5808, Name: "MPC8220"},
			{ID: 0x5809, Name: "MPC5200B"},
			{ID: 0x6400, Name: "MPC190 Security Processor (S1 family, encryption)"},
			{ID: 0x6405, Name: "MPC184 Security Processor (S1 family)"},
		},
	},
	{ID: 0x1058, Name: "Electronics & Telecommunications RSH", Devices: []Device{}},
	{ID: 0x1059, Name: "Kontron", Devices: []Device{}},
	{
		ID: 0x105a, Name: "Promise Technology, Inc.", Devices: []Device{
			{ID: 0x0d30, Name: "PDC20265 (FastTrak100 Lite/Ultra100)"},
			{ID: 0x0d38, Name: "20263"},
			{ID: 0x1275, Name: "20275"},
			{ID: 0x3318, Name: "PDC20318 (SATA150 TX4)"},
			{ID: 0x3319, Name: "PDC20319 (FastTrak S150 TX4)"},
			{ID: 0x3371, Name: "PDC20371 (FastTrak S150 TX2plus)"},
			{ID: 0x3373, Name: "PDC20378 (FastTrak 378/SATA 378)"},
			{ID: 0x3375, Name: "PDC20375 (SATA150 TX2plus)"},
			{ID: 0x3376, Name: "PDC20376 (FastTrak 376)"},
			{ID: 0x3515, Name: "PDC40719 [FastTrak TX4300/TX4310]"},
			{ID: 0x3519, Name: "PDC40519 (FastTrak TX4200)"},
			{ID: 0x3570, Name: "PDC20771 [FastTrak TX2300]"},
			{ID: 0x3571, Name: "PDC20571 (FastTrak TX2200)"},
			{ID: 0x3574, Name: "PDC20579 SATAII 150 IDE Controller"},
			{ID: 0x3577, Name: "PDC40779 (SATA 300 779)"},
			{ID: 0x3d17, Name: "PDC40718 (SATA 300 TX4)"},
			{ID: 0x3d18, Name: "PDC20518/PDC40518 (SATAII 150 TX4)"},
			{ID: 0x3d73, Name: "PDC40775 (SATA 300 TX2plus)"},
			{ID: 0x3d75, Name: "PDC20575 (SATAII150 TX2plus)"},
			{ID: 0x3f20, Name: "PDC42819 [FastTrak TX2650/TX4650]"},
			{ID: 0x4302, Name: "80333 [SuperTrak EX4350]"},
			{ID: 0x4d30, Name: "PDC20267 (FastTrak100/Ultra100)"},
			{ID: 0x4d33, Name: "20246"},
			{ID: 0x4d38, Name: "PDC20262 (FastTrak66/Ultra66)"},
			{ID: 0x4d68, Name: "PDC20268 [Ultra100 TX2]"},
			{ID: 0x4d69, Name: "20269"},
			{ID: 0x5275, Name: "PDC20276 (MBFastTrak133 Lite)"},
			{ID: 0x5300, Name: "DC5300"},
			{ID: 0x6268, Name: "PDC20270 (FastTrak100 LP/TX2/TX4)"},
			{ID: 0x6269, Name: "PDC20271 (FastTrak TX2000)"},
			{ID: 0x6300, Name: "PDC81731 [FastTrak SX8300]"},
			{ID: 0x6621, Name: "PDC20621 (FastTrak S150 SX4/FastTrak SX4000 lite)"},
			{ID: 0x6622, Name: "PDC20621 [SATA150 SX4] 4 Channel IDE RAID Controller"},
			{ID: 0x6624, Name: "PDC20621 [FastTrak SX4100]"},
			{ID: 0x6626, Name: "PDC20618 (Ultra 618)"},
			{ID: 0x6629, Name: "PDC20619 (FastTrak TX4000)"},
			{ID: 0x7275, Name: "PDC20277 (SBFastTrak133 Lite)"},
			{ID: 0x8002, Name: "SATAII150 SX8"},
			{ID: 0x8350, Name: "80333 [SuperTrak EX8350/EX16350], 80331 [SuperTrak EX8300/EX16300]"},
			{ID: 0x8650, Name: "81384 [SuperTrak EX SAS and SATA RAID Controller]"},
			{ID: 0x8760, Name: "PM8010 [SuperTrak EX SAS and SATA 6G RAID Controller]"},
			{ID: 0xc350, Name: "80333 [SuperTrak EX12350]"},
			{ID: 0xe350, Name: "80333 [SuperTrak EX24350]"},
		},
	},
	{ID: 0x105b, Name: "Foxconn International, Inc.", Devices: []Device{}},
	{ID: 0x105c, Name: "Wipro Infotech Limited", Devices: []Device{}},
	{
		ID: 0x105d, Name: "Number 9 Computer Company", Devices: []Device{
			{ID: 0x2309, Name: "Imagine 128"},
			{ID: 0x2339, Name: "Imagine 128-II"},
			{ID: 0x493d, Name: "Imagine 128 T2R [Ticket to Ride]"},
			{ID: 0x5348, Name: "Revolution 4"},
		},
	},
	{ID: 0x105e, Name: "Vtech Computers Ltd", Devices: []Device{}},
	{ID: 0x105f, Name: "Infotronic America Inc", Devices: []Device{}},
	{
		ID: 0x1060, Name: "United Microelectronics [UMC]", Devices: []Device{
			{ID: 0x0001, Name: "UM82C881"},
			{ID: 0x0002, Name: "UM82C886"},
			{ID: 0x0101, Name: "UM8673F"},
			{ID: 0x0881, Name: "UM8881"},
			{ID: 0x0886, Name: "UM8886F"},
			{ID: 0x0891, Name: "UM8891A"},
			{ID: 0x1001, Name: "UM886A"},
			{ID: 0x673a, Name: "UM8886BF"},
			{ID: 0x673b, Name: "EIDE Master/DMA"},
			{ID: 0x8710, Name: "UM8710"},
			{ID: 0x886a, Name: "UM8886A"},
			{ID: 0x8881, Name: "UM8881F"},
			{ID: 0x8886, Name: "UM8886F"},
			{ID: 0x888a, Name: "UM8886A"},
			{ID: 0x8891, Name: "UM8891A"},
			{ID: 0x9017, Name: "UM9017F"},
			{ID: 0x9018, Name: "UM9018"},
			{ID: 0x9026, Name: "UM9026"},
			{ID: 0xe881, Name: "UM8881N"},
			{ID: 0xe886, Name: "UM8886N"},
			{ID: 0xe88a, Name: "UM8886N"},
			{ID: 0xe891, Name: "UM8891N"},
		},
	},
	{
		ID: 0x1061, Name: "I.I.T.", Devices: []Device{
			{ID: 0x0001, Name: "AGX016"},
			{ID: 0x0002, Name: "IIT3204/3501"},
		},
	},
	{ID: 0x1062, Name: "Maspar Computer Corp", Devices: []Device{}},
	{ID: 0x1063, Name: "Ocean Office Automation", Devices: []Device{}},
	{
		ID: 0x1064, Name: "Alcatel", Devices: []Device{
			{ID: 0x1102, Name: "Dynamite 2840 (ADSL PCI modem)"},
		},
	},
	{ID: 0x1065, Name: "Texas Microsystems", Devices: []Device{}},
	{
		ID: 0x1066, Name: "PicoPower Technology", Devices: []Device{
			{ID: 0x0000, Name: "PT80C826"},
			{ID: 0x0001, Name: "PT86C521 [Vesuvius v1] Host Bridge"},
			{ID: 0x0002, Name: "PT86C523 [Vesuvius v3] PCI-ISA Bridge Master"},
			{ID: 0x0003, Name: "PT86C524 [Nile] PCI-to-PCI Bridge"},
			{ID: 0x0004, Name: "PT86C525 [Nile-II] PCI-to-PCI Bridge"},
			{ID: 0x0005, Name: "National PC87550 System Controller"},
			{ID: 0x8002, Name: "PT86C523 [Vesuvius v3] PCI-ISA Bridge Slave"},
		},
	},
	{
		ID: 0x1067, Name: "Mitsubishi Electric", Devices: []Device{
			{ID: 0x0301, Name: "AccelGraphics AccelECLIPSE"},
			{ID: 0x0304, Name: "AccelGALAXY A2100 [OEM Evans & Sutherland]"},
			{ID: 0x0308, Name: "Tornado 3000 [OEM Evans & Sutherland]"},
			{ID: 0x1002, Name: "VG500 [VolumePro Volume Rendering Accelerator]"},
		},
	},
	{ID: 0x1068, Name: "Diversified Technology", Devices: []Device{}},
	{
		ID: 0x1069, Name: "Mylex Corporation", Devices: []Device{
			{ID: 0x0001, Name: "DAC960P"},
			{ID: 0x0002, Name: "DAC960PD"},
			{ID: 0x0010, Name: "DAC960PG"},
			{ID: 0x0020, Name: "DAC960LA"},
			{ID: 0x0050, Name: "AcceleRAID 352/170/160 support Device"},
			{ID: 0xb166, Name: "AcceleRAID 600/500/400/Sapphire support Device"},
			{ID: 0xba55, Name: "eXtremeRAID 1100 support Device"},
			{ID: 0xba56, Name: "eXtremeRAID 2000/3000 support Device"},
			{ID: 0xba57, Name: "eXtremeRAID 4000/5000 support Device"},
		},
	},
	{ID: 0x106a, Name: "Aten Research Inc", Devices: []Device{}},
	{
		ID: 0x106b, Name: "Apple Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Bandit PowerPC host bridge"},
			{ID: 0x0002, Name: "Grand Central I/O"},
			{ID: 0x0003, Name: "Control Video"},
			{ID: 0x0004, Name: "PlanB Video-In"},
			{ID: 0x0007, Name: "O'Hare I/O"},
			{ID: 0x000b, Name: "Apple Camera"},
			{ID: 0x000c, Name: "DOS on Mac"},
			{ID: 0x000e, Name: "Hydra Mac I/O"},
			{ID: 0x0010, Name: "Heathrow Mac I/O"},
			{ID: 0x0017, Name: "Paddington Mac I/O"},
			{ID: 0x0018, Name: "UniNorth FireWire"},
			{ID: 0x0019, Name: "KeyLargo USB"},
			{ID: 0x001e, Name: "UniNorth Internal PCI"},
			{ID: 0x001f, Name: "UniNorth PCI"},
			{ID: 0x0020, Name: "UniNorth AGP"},
			{ID: 0x0021, Name: "UniNorth GMAC (Sun GEM)"},
			{ID: 0x0022, Name: "KeyLargo Mac I/O"},
			{ID: 0x0024, Name: "UniNorth/Pangea GMAC (Sun GEM)"},
			{ID: 0x0025, Name: "KeyLargo/Pangea Mac I/O"},
			{ID: 0x0026, Name: "KeyLargo/Pangea USB"},
			{ID: 0x0027, Name: "UniNorth/Pangea AGP"},
			{ID: 0x0028, Name: "UniNorth/Pangea PCI"},
			{ID: 0x0029, Name: "UniNorth/Pangea Internal PCI"},
			{ID: 0x002d, Name: "UniNorth 1.5 AGP"},
			{ID: 0x002e, Name: "UniNorth 1.5 PCI"},
			{ID: 0x002f, Name: "UniNorth 1.5 Internal PCI"},
			{ID: 0x0030, Name: "UniNorth/Pangea FireWire"},
			{ID: 0x0031, Name: "UniNorth 2 FireWire"},
			{ID: 0x0032, Name: "UniNorth 2 GMAC (Sun GEM)"},
			{ID: 0x0033, Name: "UniNorth 2 ATA/100"},
			{ID: 0x0034, Name: "UniNorth 2 AGP"},
			{ID: 0x0035, Name: "UniNorth 2 PCI"},
			{ID: 0x0036, Name: "UniNorth 2 Internal PCI"},
			{ID: 0x003b, Name: "UniNorth/Intrepid ATA/100"},
			{ID: 0x003e, Name: "KeyLargo/Intrepid Mac I/O"},
			{ID: 0x003f, Name: "KeyLargo/Intrepid USB"},
			{ID: 0x0040, Name: "K2 KeyLargo USB"},
			{ID: 0x0041, Name: "K2 KeyLargo Mac/IO"},
			{ID: 0x0042, Name: "K2 FireWire"},
			{ID: 0x0043, Name: "K2 ATA/100"},
			{ID: 0x0045, Name: "K2 HT-PCI Bridge"},
			{ID: 0x0046, Name: "K2 HT-PCI Bridge"},
			{ID: 0x0047, Name: "K2 HT-PCI Bridge"},
			{ID: 0x0048, Name: "K2 HT-PCI Bridge"},
			{ID: 0x0049, Name: "K2 HT-PCI Bridge"},
			{ID: 0x004a, Name: "CPC945 HT Bridge"},
			{ID: 0x004b, Name: "U3 AGP"},
			{ID: 0x004c, Name: "K2 GMAC (Sun GEM)"},
			{ID: 0x004f, Name: "Shasta Mac I/O"},
			{ID: 0x0050, Name: "Shasta IDE"},
			{ID: 0x0051, Name: "Shasta (Sun GEM)"},
			{ID: 0x0052, Name: "Shasta Firewire"},
			{ID: 0x0053, Name: "Shasta PCI Bridge"},
			{ID: 0x0054, Name: "Shasta PCI Bridge"},
			{ID: 0x0055, Name: "Shasta PCI Bridge"},
			{ID: 0x0056, Name: "U4 PCIe"},
			{ID: 0x0057, Name: "U3 HT Bridge"},
			{ID: 0x0058, Name: "U3L AGP Bridge"},
			{ID: 0x0059, Name: "U3H AGP Bridge"},
			{ID: 0x005b, Name: "CPC945 PCIe Bridge"},
			{ID: 0x0066, Name: "Intrepid2 AGP Bridge"},
			{ID: 0x0067, Name: "Intrepid2 PCI Bridge"},
			{ID: 0x0068, Name: "Intrepid2 PCI Bridge"},
			{ID: 0x0069, Name: "Intrepid2 ATA/100"},
			{ID: 0x006a, Name: "Intrepid2 Firewire"},
			{ID: 0x006b, Name: "Intrepid2 GMAC (Sun GEM)"},
			{ID: 0x0074, Name: "U4 HT Bridge"},
			{ID: 0x1645, Name: "Broadcom NetXtreme BCM5701 Gigabit Ethernet"},
			{ID: 0x1801, Name: "T2 Bridge Controller"},
			{ID: 0x1802, Name: "T2 Secure Enclave Processor"},
			{ID: 0x1803, Name: "Apple Audio Device"},
			{ID: 0x2001, Name: "S1X NVMe Controller"},
			{ID: 0x2002, Name: "S3ELab NVMe Controller"},
			{ID: 0x2003, Name: "S3X NVMe Controller"},
			{ID: 0x2005, Name: "ANS2 NVMe Controller"},
		},
	},
	{
		ID: 0x106c, Name: "Hynix Semiconductor", Devices: []Device{
			{ID: 0x8139, Name: "8139c 100BaseTX Ethernet Controller"},
			{ID: 0x8801, Name: "Dual Pentium ISA/PCI Motherboard"},
			{ID: 0x8802, Name: "PowerPC ISA/PCI Motherboard"},
			{ID: 0x8803, Name: "Dual Window Graphics Accelerator"},
			{ID: 0x8804, Name: "LAN Controller"},
			{ID: 0x8805, Name: "100-BaseT LAN"},
		},
	},
	{ID: 0x106d, Name: "Sequent Computer Systems", Devices: []Device{}},
	{ID: 0x106e, Name: "DFI, Inc", Devices: []Device{}},
	{ID: 0x106f, Name: "City Gate Development Ltd", Devices: []Device{}},
	{ID: 0x1070, Name: "Daewoo Telecom Ltd", Devices: []Device{}},
	{
		ID: 0x1071, Name: "Mitac", Devices: []Device{
			{ID: 0x8160, Name: "Mitac 8060B Mobile Platform"},
		},
	},
	{ID: 0x1072, Name: "GIT Co Ltd", Devices: []Device{}},
	{
		ID: 0x1073, Name: "Yamaha Corporation", Devices: []Device{
			{ID: 0x0001, Name: "3D GUI Accelerator"},
			{ID: 0x0002, Name: "YGV615 [RPA3 3D-Graphics Controller]"},
			{ID: 0x0003, Name: "YMF-740"},
			{ID: 0x0004, Name: "YMF-724"},
			{ID: 0x0005, Name: "DS1 Audio"},
			{ID: 0x0006, Name: "DS1 Audio"},
			{ID: 0x0008, Name: "DS1 Audio"},
			{ID: 0x000a, Name: "DS1L Audio"},
			{ID: 0x000c, Name: "YMF-740C [DS-1L Audio Controller]"},
			{ID: 0x000d, Name: "YMF-724F [DS-1 Audio Controller]"},
			{ID: 0x0010, Name: "YMF-744B [DS-1S Audio Controller]"},
			{ID: 0x0012, Name: "YMF-754 [DS-1E Audio Controller]"},
			{ID: 0x0020, Name: "DS-1 Audio"},
			{ID: 0x1000, Name: "SW1000XG [XG Factory]"},
			{ID: 0x2000, Name: "DS2416 Digital Mixing Card"},
		},
	},
	{
		ID: 0x1074, Name: "NexGen Microsystems", Devices: []Device{
			{ID: 0x4e78, Name: "82c500/1"},
		},
	},
	{ID: 0x1075, Name: "Advanced Integrations Research", Devices: []Device{}},
	{ID: 0x1076, Name: "Chaintech Computer Co. Ltd", Devices: []Device{}},
	{
		ID: 0x1077, Name: "QLogic Corp.", Devices: []Device{
			{ID: 0x1016, Name: "ISP10160 Single Channel Ultra3 SCSI Processor"},
			{ID: 0x1020, Name: "ISP1020 Fast-wide SCSI"},
			{ID: 0x1022, Name: "ISP1022 Fast-wide SCSI"},
			{ID: 0x1080, Name: "ISP1080 SCSI Host Adapter"},
			{ID: 0x1216, Name: "ISP12160 Dual Channel Ultra3 SCSI Processor"},
			{ID: 0x1240, Name: "ISP1240 SCSI Host Adapter"},
			{ID: 0x1280, Name: "ISP1280 SCSI Host Adapter"},
			{ID: 0x1634, Name: "FastLinQ QL45000 Series 40GbE Controller"},
			{ID: 0x1644, Name: "FastLinQ QL45000 Series 100GbE Controller"},
			{ID: 0x1654, Name: "FastLinQ QL45000 Series 50GbE Controller"},
			{ID: 0x1656, Name: "FastLinQ QL45000 Series 25GbE Controller"},
			{ID: 0x165c, Name: "FastLinQ QL45000 Series 10/25/40/50GbE Controller (FCoE)"},
			{ID: 0x165e, Name: "FastLinQ QL45000 Series 10/25/40/50GbE Controller (iSCSI)"},
			{ID: 0x1664, Name: "FastLinQ QL45000 Series Gigabit Ethernet Controller (SR-IOV VF)"},
			{ID: 0x2020, Name: "ISP2020A Fast!SCSI Basic Adapter"},
			{ID: 0x2031, Name: "ISP8324-based 16Gb Fibre Channel to PCI Express Adapter"},
			{ID: 0x2071, Name: "ISP2714-based 16/32Gb Fibre Channel to PCIe Adapter"},
			{ID: 0x2081, Name: "ISP2814-based 64/32G Fibre Channel to PCIe Controller"},
			{ID: 0x2089, Name: "ISP2854-based 64/32G Fibre Channel to PCIe Controller with StorCryption"},
			{ID: 0x2100, Name: "QLA2100 64-bit Fibre Channel Adapter"},
			{ID: 0x2200, Name: "QLA2200 64-bit Fibre Channel Adapter"},
			{ID: 0x2261, Name: "ISP2722-based 16/32Gb Fibre Channel to PCIe Adapter"},
			{ID: 0x2281, Name: "ISP2812-based 64/32G Fibre Channel to PCIe Controller"},
			{ID: 0x2289, Name: "ISP2852-based 64/32G Fibre Channel to PCIe Controller with StorCryption"},
			{ID: 0x2300, Name: "QLA2300 64-bit Fibre Channel Adapter"},
			{ID: 0x2312, Name: "ISP2312-based 2Gb Fibre Channel to PCI-X HBA"},
			{ID: 0x2322, Name: "ISP2322-based 2Gb Fibre Channel to PCI-X HBA"},
			{ID: 0x2422, Name: "ISP2422-based 4Gb Fibre Channel to PCI-X HBA"},
			{ID: 0x2432, Name: "ISP2432-based 4Gb Fibre Channel to PCI Express HBA"},
			{ID: 0x2532, Name: "ISP2532-based 8Gb Fibre Channel to PCI Express HBA"},
			{ID: 0x2971, Name: "ISP2684"},
			{ID: 0x3022, Name: "ISP4022-based Ethernet NIC"},
			{ID: 0x3032, Name: "ISP4032-based Ethernet IPv6 NIC"},
			{ID: 0x4010, Name: "ISP4010-based iSCSI TOE HBA"},
			{ID: 0x4022, Name: "ISP4022-based iSCSI TOE HBA"},
			{ID: 0x4032, Name: "ISP4032-based iSCSI TOE IPv6 HBA"},
			{ID: 0x5432, Name: "SP232-based 4Gb Fibre Channel to PCI Express HBA"},
			{ID: 0x6312, Name: "SP202-based 2Gb Fibre Channel to PCI-X HBA"},
			{ID: 0x6322, Name: "SP212-based 2Gb Fibre Channel to PCI-X HBA"},
			{ID: 0x7220, Name: "IBA7220 InfiniBand HCA"},
			{ID: 0x7322, Name: "IBA7322 QDR InfiniBand HCA"},
			{ID: 0x8000, Name: "10GbE Converged Network Adapter (TCP/IP Networking)"},
			{ID: 0x8001, Name: "10GbE Converged Network Adapter (FCoE)"},
			{ID: 0x8020, Name: "cLOM8214 1/10GbE Controller"},
			{ID: 0x8021, Name: "8200 Series 10GbE Converged Network Adapter (FCoE)"},
			{ID: 0x8022, Name: "8200 Series 10GbE Converged Network Adapter (iSCSI)"},
			{ID: 0x8030, Name: "ISP8324 1/10GbE Converged Network Controller"},
			{ID: 0x8031, Name: "8300 Series 10GbE Converged Network Adapter (FCoE)"},
			{ID: 0x8032, Name: "8300 Series 10GbE Converged Network Adapter (iSCSI)"},
			{ID: 0x8070, Name: "FastLinQ QL41000 Series 10/25/40/50GbE Controller"},
			{ID: 0x8080, Name: "FastLinQ QL41000 Series 10/25/40/50GbE Controller (FCoE)"},
			{ID: 0x8084, Name: "FastLinQ QL41000 Series 10/25/40/50GbE Controller (iSCSI)"},
			{ID: 0x8090, Name: "FastLinQ QL41000 Series Gigabit Ethernet Controller (SR-IOV VF)"},
			{ID: 0x8430, Name: "ISP8324 1/10GbE Converged Network Controller (NIC VF)"},
			{ID: 0x8431, Name: "8300 Series 10GbE Converged Network Adapter (FCoE VF)"},
			{ID: 0x8432, Name: "ISP2432M-based 10GbE Converged Network Adapter (CNA)"},
		},
	},
	{
		ID: 0x1078, Name: "Cyrix Corporation", Devices: []Device{
			{ID: 0x0000, Name: "5510 [Grappa]"},
			{ID: 0x0001, Name: "PCI Master"},
			{ID: 0x0002, Name: "5520 [Cognac]"},
			{ID: 0x0100, Name: "5530 Legacy [Kahlua]"},
			{ID: 0x0101, Name: "5530 SMI [Kahlua]"},
			{ID: 0x0102, Name: "5530 IDE [Kahlua]"},
			{ID: 0x0103, Name: "5530 Audio [Kahlua]"},
			{ID: 0x0104, Name: "5530 Video [Kahlua]"},
			{ID: 0x0400, Name: "ZFMicro PCI Bridge"},
			{ID: 0x0401, Name: "ZFMicro Chipset SMI"},
			{ID: 0x0402, Name: "ZFMicro Chipset IDE"},
			{ID: 0x0403, Name: "ZFMicro Expansion Bus"},
		},
	},
	{ID: 0x1079, Name: "I-Bus", Devices: []Device{}},
	{ID: 0x107a, Name: "NetWorth", Devices: []Device{}},
	{ID: 0x107b, Name: "Gateway, Inc.", Devices: []Device{}},
	{ID: 0x107c, Name: "LG Electronics [Lucky Goldstar Co. Ltd]", Devices: []Device{}},
	{
		ID: 0x107d, Name: "LeadTek Research Inc.", Devices: []Device{
			{ID: 0x0000, Name: "P86C850"},
		},
	},
	{
		ID: 0x107e, Name: "Interphase Corporation", Devices: []Device{
			{ID: 0x0001, Name: "5515 ATM Adapter [Flipper]"},
			{ID: 0x0002, Name: "100 VG AnyLan Controller"},
			{ID: 0x0004, Name: "5526 Fibre Channel Host Adapter"},
			{ID: 0x0005, Name: "x526 Fibre Channel Host Adapter"},
			{ID: 0x0008, Name: "5525/5575 ATM Adapter (155 Mbit) [Atlantic]"},
			{ID: 0x9003, Name: "5535-4P-BRI-ST"},
			{ID: 0x9007, Name: "5535-4P-BRI-U"},
			{ID: 0x9008, Name: "5535-1P-SR"},
			{ID: 0x900c, Name: "5535-1P-SR-ST"},
			{ID: 0x900e, Name: "5535-1P-SR-U"},
			{ID: 0x9011, Name: "5535-1P-PRI"},
			{ID: 0x9013, Name: "5535-2P-PRI"},
			{ID: 0x9023, Name: "5536-4P-BRI-ST"},
			{ID: 0x9027, Name: "5536-4P-BRI-U"},
			{ID: 0x9031, Name: "5536-1P-PRI"},
			{ID: 0x9033, Name: "5536-2P-PRI"},
		},
	},
	{
		ID: 0x107f, Name: "Data Technology Corporation", Devices: []Device{
			{ID: 0x0802, Name: "SL82C105"},
		},
	},
	{
		ID: 0x1080, Name: "Contaq Microsystems", Devices: []Device{
			{ID: 0x0600, Name: "82C599"},
			{ID: 0xc691, Name: "Cypress CY82C691"},
			{ID: 0xc693, Name: "82c693"},
		},
	},
	{
		ID: 0x1081, Name: "Supermac Technology", Devices: []Device{
			{ID: 0x0d47, Name: "Radius PCI to NuBUS Bridge"},
		},
	},
	{ID: 0x1082, Name: "EFA Corporation of America", Devices: []Device{}},
	{
		ID: 0x1083, Name: "Forex Computer Corporation", Devices: []Device{
			{ID: 0x0001, Name: "FR710"},
		},
	},
	{ID: 0x1084, Name: "Parador", Devices: []Device{}},
	{ID: 0x1086, Name: "J. Bond Computer Systems", Devices: []Device{}},
	{ID: 0x1087, Name: "Cache Computer", Devices: []Device{}},
	{ID: 0x1088, Name: "Microcomputer Systems (M) Son", Devices: []Device{}},
	{ID: 0x1089, Name: "Data General Corporation", Devices: []Device{}},
	{
		ID: 0x108a, Name: "SBS Technologies", Devices: []Device{
			{ID: 0x0001, Name: "VME Bridge Model 617"},
			{ID: 0x0010, Name: "VME Bridge Model 618"},
			{ID: 0x0040, Name: "dataBLIZZARD"},
			{ID: 0x3000, Name: "VME Bridge Model 2706"},
		},
	},
	{ID: 0x108c, Name: "Oakleigh Systems Inc.", Devices: []Device{}},
	{
		ID: 0x108d, Name: "Olicom", Devices: []Device{
			{ID: 0x0001, Name: "Token-Ring 16/4 PCI Adapter (3136/3137)"},
			{ID: 0x0002, Name: "16/4 Token Ring"},
			{ID: 0x0004, Name: "RapidFire OC-3139/3140 Token-Ring 16/4 PCI Adapter"},
			{ID: 0x0005, Name: "GoCard 3250 Token-Ring 16/4 CardBus PC Card"},
			{ID: 0x0006, Name: "OC-3530 RapidFire Token-Ring 100"},
			{ID: 0x0007, Name: "RapidFire 3141 Token-Ring 16/4 PCI Fiber Adapter"},
			{ID: 0x0008, Name: "RapidFire 3540 HSTR 100/16/4 PCI Adapter"},
			{ID: 0x0011, Name: "OC-2315"},
			{ID: 0x0012, Name: "OC-2325"},
			{ID: 0x0013, Name: "OC-2183/2185"},
			{ID: 0x0014, Name: "OC-2326"},
			{ID: 0x0019, Name: "OC-2327/2250 10/100 Ethernet Adapter"},
			{ID: 0x0021, Name: "OC-6151/6152 [RapidFire ATM 155]"},
			{ID: 0x0022, Name: "ATM Adapter"},
		},
	},
	{
		ID: 0x108e, Name: "Oracle/SUN", Devices: []Device{
			{ID: 0x0001, Name: "EBUS"},
			{ID: 0x1000, Name: "EBUS"},
			{ID: 0x1001, Name: "Happy Meal 10/100 Ethernet [hme]"},
			{ID: 0x1100, Name: "RIO EBUS"},
			{ID: 0x1101, Name: "RIO 10/100 Ethernet [eri]"},
			{ID: 0x1102, Name: "RIO 1394"},
			{ID: 0x1103, Name: "RIO USB"},
			{ID: 0x1647, Name: "Broadcom 570x 10/100/1000 Ethernet [bge]"},
			{ID: 0x1648, Name: "Broadcom 570x 10/100/1000 Ethernet [bge]"},
			{ID: 0x16a7, Name: "Broadcom 570x 10/100/1000 Ethernet [bge]"},
			{ID: 0x16a8, Name: "Broadcom 570x 10/100/1000 Ethernet [bge]"},
			{ID: 0x2bad, Name: "GEM 10/100/1000 Ethernet [ge]"},
			{ID: 0x5000, Name: "Simba Advanced PCI Bridge"},
			{ID: 0x5043, Name: "SunPCI Co-processor"},
			{ID: 0x5ca0, Name: "Crypto Accelerator 6000 [mca]"},
			{ID: 0x6300, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6301, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6302, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6303, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6310, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6311, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6312, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6313, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6320, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6323, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6330, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6331, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6332, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6333, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6340, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6343, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6350, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6353, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x6722, Name: "Intel 21554 PCI-PCI bus bridge [db21554]"},
			{ID: 0x676e, Name: "SunPCiIII"},
			{ID: 0x7063, Name: "SunPCiII / SunPCiIIpro"},
			{ID: 0x8000, Name: "Psycho PCI Bus Module"},
			{ID: 0x8001, Name: "Schizo PCI Bus Module"},
			{ID: 0x8002, Name: "Schizo+ PCI Bus Module"},
			{ID: 0x80f0, Name: "PCIe switch [px]"},
			{ID: 0x80f8, Name: "PCIe switch [px]"},
			{ID: 0x9010, Name: "PCIe/PCI bridge switch [pxb_plx]"},
			{ID: 0x9020, Name: "PCIe/PCI bridge switch [pxb_plx]"},
			{ID: 0x9102, Name: "Davicom Fast Ethernet driver for Davicom DM9102A [dmfe]"},
			{ID: 0xa000, Name: "Psycho UPA-PCI Bus Module [pcipsy]"},
			{ID: 0xa001, Name: "Psycho UPA-PCI Bus Module [pcipsy]"},
			{ID: 0xa801, Name: "Schizo Fireplane-PCI bus bridge module [pcisch]"},
			{ID: 0xaaaa, Name: "Multithreaded Shared 10GbE Ethernet Network Controller"},
			{ID: 0xabba, Name: "Cassini 10/100/1000"},
			{ID: 0xabcd, Name: "Multithreaded 10-Gigabit Ethernet Network Controller"},
			{ID: 0xc416, Name: "Sun Fire System/System Controller Interface chip [sbbc]"},
		},
	},
	{ID: 0x108f, Name: "Systemsoft", Devices: []Device{}},
	{
		ID: 0x1090, Name: "Compro Computer Services, Inc.", Devices: []Device{
			{ID: 0x4610, Name: "PCI RTOM"},
			{ID: 0x4620, Name: "GPIO HSD"},
		},
	},
	{
		ID: 0x1091, Name: "Intergraph Corporation", Devices: []Device{
			{ID: 0x0020, Name: "3D graphics processor"},
			{ID: 0x0021, Name: "3D graphics processor w/Texturing"},
			{ID: 0x0040, Name: "3D graphics frame buffer"},
			{ID: 0x0041, Name: "3D graphics frame buffer"},
			{ID: 0x0060, Name: "Proprietary bus bridge"},
			{ID: 0x00e4, Name: "Powerstorm 4D50T"},
			{ID: 0x0720, Name: "Motion JPEG codec"},
			{ID: 0x0780, Name: "Intense3D Wildcat 3410 (MSMT496)"},
			{ID: 0x07a0, Name: "Sun Expert3D-Lite Graphics Accelerator"},
			{ID: 0x1091, Name: "Sun Expert3D Graphics Accelerator"},
		},
	},
	{
		ID: 0x1092, Name: "Diamond Multimedia Systems", Devices: []Device{
			{ID: 0x0028, Name: "Viper V770"},
			{ID: 0x00a0, Name: "Speedstar Pro SE"},
			{ID: 0x00a8, Name: "Speedstar 64"},
			{ID: 0x0550, Name: "Viper V550"},
			{ID: 0x08d4, Name: "Supra 2260 Modem"},
			{ID: 0x094c, Name: "SupraExpress 56i Pro"},
			{ID: 0x1001, Name: "Video Crunch It 1001 capture card"},
			{ID: 0x1092, Name: "Viper V330"},
			{ID: 0x6120, Name: "Maximum DVD"},
			{ID: 0x8810, Name: "Stealth SE"},
			{ID: 0x8811, Name: "Stealth 64/SE"},
			{ID: 0x8880, Name: "Stealth"},
			{ID: 0x8881, Name: "Stealth"},
			{ID: 0x88b0, Name: "Stealth 64"},
			{ID: 0x88b1, Name: "Stealth 64"},
			{ID: 0x88c0, Name: "Stealth 64"},
			{ID: 0x88c1, Name: "Stealth 64"},
			{ID: 0x88d0, Name: "Stealth 64"},
			{ID: 0x88d1, Name: "Stealth 64"},
			{ID: 0x88f0, Name: "Stealth 64"},
			{ID: 0x88f1, Name: "Stealth 64"},
			{ID: 0x9999, Name: "DMD-I0928-1 \"Monster sound\" sound chip"},
		},
	},
	{
		ID: 0x1093, Name: "National Instruments", Devices: []Device{
			{ID: 0x0160, Name: "PCI-DIO-96"},
			{ID: 0x0162, Name: "PCI-MIO-16XE-50"},
			{ID: 0x0fe1, Name: "PXI-8320"},
			{ID: 0x1150, Name: "PCI-6533 (PCI-DIO-32HS)"},
			{ID: 0x1170, Name: "PCI-MIO-16XE-10"},
			{ID: 0x1180, Name: "PCI-MIO-16E-1"},
			{ID: 0x1190, Name: "PCI-MIO-16E-4"},
			{ID: 0x11b0, Name: "PXI-6070E"},
			{ID: 0x11c0, Name: "PXI-6040E"},
			{ID: 0x11d0, Name: "PXI-6030E"},
			{ID: 0x1270, Name: "PCI-6032E"},
			{ID: 0x1290, Name: "PCI-6704"},
			{ID: 0x12b0, Name: "PCI-6534"},
			{ID: 0x1310, Name: "PCI-6602"},
			{ID: 0x1320, Name: "PXI-6533"},
			{ID: 0x1330, Name: "PCI-6031E"},
			{ID: 0x1340, Name: "PCI-6033E"},
			{ID: 0x1350, Name: "PCI-6071E"},
			{ID: 0x1360, Name: "PXI-6602"},
			{ID: 0x13c0, Name: "PXI-6508"},
			{ID: 0x1490, Name: "PXI-6534"},
			{ID: 0x14e0, Name: "PCI-6110"},
			{ID: 0x14f0, Name: "PCI-6111"},
			{ID: 0x1580, Name: "PXI-6031E"},
			{ID: 0x15b0, Name: "PXI-6071E"},
			{ID: 0x1710, Name: "PXI-6509"},
			{ID: 0x17c0, Name: "PXI-5690"},
			{ID: 0x17d0, Name: "PCI-6503"},
			{ID: 0x1870, Name: "PCI-6713"},
			{ID: 0x1880, Name: "PCI-6711"},
			{ID: 0x18b0, Name: "PCI-6052E"},
			{ID: 0x18c0, Name: "PXI-6052E"},
			{ID: 0x1920, Name: "PXI-6704"},
			{ID: 0x1930, Name: "PCI-6040E"},
			{ID: 0x19c0, Name: "PCI-4472"},
			{ID: 0x1aa0, Name: "PXI-4110"},
			{ID: 0x1ad0, Name: "PCI-6133"},
			{ID: 0x1ae0, Name: "PXI-6133"},
			{ID: 0x1e30, Name: "PCI-6624"},
			{ID: 0x1e40, Name: "PXI-6624"},
			{ID: 0x1e50, Name: "PXI-5404"},
			{ID: 0x2410, Name: "PCI-6733"},
			{ID: 0x2420, Name: "PXI-6733"},
			{ID: 0x2430, Name: "PCI-6731"},
			{ID: 0x2470, Name: "PCI-4474"},
			{ID: 0x24a0, Name: "PCI-4065"},
			{ID: 0x24b0, Name: "PXI-4200"},
			{ID: 0x24f0, Name: "PXI-4472"},
			{ID: 0x2510, Name: "PCI-4472"},
			{ID: 0x2520, Name: "PCI-4474"},
			{ID: 0x27a0, Name: "PCI-6123"},
			{ID: 0x27b0, Name: "PXI-6123"},
			{ID: 0x2880, Name: "DAQCard-6601"},
			{ID: 0x2890, Name: "PCI-6036E"},
			{ID: 0x28a0, Name: "PXI-4461"},
			{ID: 0x28b0, Name: "PCI-6013"},
			{ID: 0x28c0, Name: "PCI-6014"},
			{ID: 0x28d0, Name: "PCI-5122"},
			{ID: 0x28e0, Name: "PXI-5122"},
			{ID: 0x29f0, Name: "PXI-7334"},
			{ID: 0x2a00, Name: "PXI-7344"},
			{ID: 0x2a60, Name: "PCI-6023E"},
			{ID: 0x2a70, Name: "PCI-6024E"},
			{ID: 0x2a80, Name: "PCI-6025E"},
			{ID: 0x2ab0, Name: "PXI-6025E"},
			{ID: 0x2b10, Name: "PXI-6527"},
			{ID: 0x2b20, Name: "PCI-6527"},
			{ID: 0x2b80, Name: "PXI-6713"},
			{ID: 0x2b90, Name: "PXI-6711"},
			{ID: 0x2c60, Name: "PCI-6601"},
			{ID: 0x2c70, Name: "PXI-6601"},
			{ID: 0x2c80, Name: "PCI-6035E"},
			{ID: 0x2c90, Name: "PCI-6703"},
			{ID: 0x2ca0, Name: "PCI-6034E"},
			{ID: 0x2cb0, Name: "PCI-7344"},
			{ID: 0x2cc0, Name: "PXI-6608"},
			{ID: 0x2d20, Name: "PXI-5600"},
			{ID: 0x2db0, Name: "PCI-6608"},
			{ID: 0x2dc0, Name: "PCI-4070"},
			{ID: 0x2dd0, Name: "PXI-4070"},
			{ID: 0x2eb0, Name: "PXI-4472"},
			{ID: 0x2ec0, Name: "PXI-6115"},
			{ID: 0x2ed0, Name: "PCI-6115"},
			{ID: 0x2ee0, Name: "PXI-6120"},
			{ID: 0x2ef0, Name: "PCI-6120"},
			{ID: 0x2fd1, Name: "PCI-7334"},
			{ID: 0x2fd2, Name: "PCI-7350"},
			{ID: 0x2fd3, Name: "PCI-7342"},
			{ID: 0x2fd5, Name: "PXI-7350"},
			{ID: 0x2fd6, Name: "PXI-7342"},
			{ID: 0x7003, Name: "PCI-6551"},
			{ID: 0x7004, Name: "PXI-6551"},
			{ID: 0x700b, Name: "PXI-5421"},
			{ID: 0x700c, Name: "PCI-5421"},
			{ID: 0x701a, Name: "VXIpc-87xB"},
			{ID: 0x701b, Name: "VXIpc-770"},
			{ID: 0x7023, Name: "PXI-2593"},
			{ID: 0x7027, Name: "PCI-MXI-2 Universal"},
			{ID: 0x702c, Name: "PXI-7831R"},
			{ID: 0x702d, Name: "PCI-7831R"},
			{ID: 0x702e, Name: "PXI-7811R"},
			{ID: 0x702f, Name: "PCI-7811R"},
			{ID: 0x7030, Name: "PCI-CAN (Series 2)"},
			{ID: 0x7031, Name: "PCI-CAN/2 (Series 2)"},
			{ID: 0x7032, Name: "PCI-CAN/LS (Series 2)"},
			{ID: 0x7033, Name: "PCI-CAN/LS2 (Series 2)"},
			{ID: 0x7034, Name: "PCI-CAN/DS (Series 2)"},
			{ID: 0x7035, Name: "PXI-8460 (Series 2, 1 port)"},
			{ID: 0x7036, Name: "PXI-8460 (Series 2, 2 ports)"},
			{ID: 0x7037, Name: "PXI-8461 (Series 2, 1 port)"},
			{ID: 0x7038, Name: "PXI-8461 (Series 2, 2 ports)"},
			{ID: 0x7039, Name: "PXI-8462 (Series 2)"},
			{ID: 0x703f, Name: "PXI-2566"},
			{ID: 0x7040, Name: "PXI-2567"},
			{ID: 0x7044, Name: "MXI-4 Connection Monitor"},
			{ID: 0x7047, Name: "PXI-6653"},
			{ID: 0x704c, Name: "PXI-2530"},
			{ID: 0x704f, Name: "PXI-4220"},
			{ID: 0x7050, Name: "PXI-4204"},
			{ID: 0x7055, Name: "PXI-7830R"},
			{ID: 0x7056, Name: "PCI-7830R"},
			{ID: 0x705a, Name: "PCI-CAN/XS (Series 2)"},
			{ID: 0x705b, Name: "PCI-CAN/XS2 (Series 2)"},
			{ID: 0x705c, Name: "PXI-8464 (Series 2, 1 port)"},
			{ID: 0x705d, Name: "PXI-8464 (Series 2, 2 ports)"},
			{ID: 0x705e, Name: "cRIO-9102"},
			{ID: 0x7060, Name: "PXI-5610"},
			{ID: 0x7064, Name: "PXI-1045 Trigger Routing Module"},
			{ID: 0x7065, Name: "PXI-6652"},
			{ID: 0x7066, Name: "PXI-6651"},
			{ID: 0x7067, Name: "PXI-2529"},
			{ID: 0x7068, Name: "PCI-CAN/SW (Series 2)"},
			{ID: 0x7069, Name: "PCI-CAN/SW2 (Series 2)"},
			{ID: 0x706a, Name: "PXI-8463 (Series 2, 1 port)"},
			{ID: 0x706b, Name: "PXI-8463 (Series 2, 2 ports)"},
			{ID: 0x7073, Name: "PCI-6723"},
			{ID: 0x7074, Name: "PXI-7833R"},
			{ID: 0x7075, Name: "PXI-6552"},
			{ID: 0x7076, Name: "PCI-6552"},
			{ID: 0x707c, Name: "PXI-1428"},
			{ID: 0x707e, Name: "PXI-4462"},
			{ID: 0x7080, Name: "PXI-8430/2 (RS-232) Interface"},
			{ID: 0x7081, Name: "PXI-8431/2 (RS-485) Interface"},
			{ID: 0x7083, Name: "PCI-7833R"},
			{ID: 0x7085, Name: "PCI-6509"},
			{ID: 0x7086, Name: "PXI-6528"},
			{ID: 0x7087, Name: "PCI-6515"},
			{ID: 0x7088, Name: "PCI-6514"},
			{ID: 0x708c, Name: "PXI-2568"},
			{ID: 0x708d, Name: "PXI-2569"},
			{ID: 0x70a9, Name: "PCI-6528"},
			{ID: 0x70aa, Name: "PCI-6229"},
			{ID: 0x70ab, Name: "PCI-6259"},
			{ID: 0x70ac, Name: "PCI-6289"},
			{ID: 0x70ad, Name: "PXI-6251"},
			{ID: 0x70ae, Name: "PXI-6220"},
			{ID: 0x70af, Name: "PCI-6221"},
			{ID: 0x70b0, Name: "PCI-6220"},
			{ID: 0x70b1, Name: "PXI-6229"},
			{ID: 0x70b2, Name: "PXI-6259"},
			{ID: 0x70b3, Name: "PXI-6289"},
			{ID: 0x70b4, Name: "PCI-6250"},
			{ID: 0x70b5, Name: "PXI-6221"},
			{ID: 0x70b6, Name: "PCI-6280"},
			{ID: 0x70b7, Name: "PCI-6254"},
			{ID: 0x70b8, Name: "PCI-6251"},
			{ID: 0x70b9, Name: "PXI-6250"},
			{ID: 0x70ba, Name: "PXI-6254"},
			{ID: 0x70bb, Name: "PXI-6280"},
			{ID: 0x70bc, Name: "PCI-6284"},
			{ID: 0x70bd, Name: "PCI-6281"},
			{ID: 0x70be, Name: "PXI-6284"},
			{ID: 0x70bf, Name: "PXI-6281"},
			{ID: 0x70c0, Name: "PCI-6143"},
			{ID: 0x70c3, Name: "PCI-6511"},
			{ID: 0x70c4, Name: "PXI-7330"},
			{ID: 0x70c5, Name: "PXI-7340"},
			{ID: 0x70c6, Name: "PCI-7330"},
			{ID: 0x70c7, Name: "PCI-7340"},
			{ID: 0x70c8, Name: "PCI-6513"},
			{ID: 0x70c9, Name: "PXI-6515"},
			{ID: 0x70ca, Name: "PCI-1405"},
			{ID: 0x70cc, Name: "PCI-6512"},
			{ID: 0x70cd, Name: "PXI-6514"},
			{ID: 0x70ce, Name: "PXI-1405"},
			{ID: 0x70cf, Name: "PCIe-GPIB"},
			{ID: 0x70d0, Name: "PXI-2570"},
			{ID: 0x70d1, Name: "PXI-6513"},
			{ID: 0x70d2, Name: "PXI-6512"},
			{ID: 0x70d3, Name: "PXI-6511"},
			{ID: 0x70d4, Name: "PCI-6722"},
			{ID: 0x70d6, Name: "PXI-4072"},
			{ID: 0x70d7, Name: "PXI-6541"},
			{ID: 0x70d8, Name: "PXI-6542"},
			{ID: 0x70d9, Name: "PCI-6541"},
			{ID: 0x70da, Name: "PCI-6542"},
			{ID: 0x70db, Name: "PCI-8430/2 (RS-232) Interface"},
			{ID: 0x70dc, Name: "PCI-8431/2 (RS-485) Interface"},
			{ID: 0x70dd, Name: "PXI-8430/4 (RS-232) Interface"},
			{ID: 0x70de, Name: "PXI-8431/4 (RS-485) Interface"},
			{ID: 0x70df, Name: "PCI-8430/4 (RS-232) Interface"},
			{ID: 0x70e0, Name: "PCI-8431/4 (RS-485) Interface"},
			{ID: 0x70e1, Name: "PXI-2532"},
			{ID: 0x70e2, Name: "PXI-8430/8 (RS-232) Interface"},
			{ID: 0x70e3, Name: "PXI-8431/8 (RS-485) Interface"},
			{ID: 0x70e4, Name: "PCI-8430/8 (RS-232) Interface"},
			{ID: 0x70e5, Name: "PCI-8431/8 (RS-485) Interface"},
			{ID: 0x70e6, Name: "PXI-8430/16 (RS-232) Interface"},
			{ID: 0x70e7, Name: "PCI-8430/16 (RS-232) Interface"},
			{ID: 0x70e8, Name: "PXI-8432/2 (Isolated RS-232) Interface"},
			{ID: 0x70e9, Name: "PXI-8433/2 (Isolated RS-485) Interface"},
			{ID: 0x70ea, Name: "PCI-8432/2 (Isolated RS-232) Interface"},
			{ID: 0x70eb, Name: "PCI-8433/2 (Isolated RS-485) Interface"},
			{ID: 0x70ec, Name: "PXI-8432/4 (Isolated RS-232) Interface"},
			{ID: 0x70ed, Name: "PXI-8433/4 (Isolated RS-485) Interface"},
			{ID: 0x70ee, Name: "PCI-8432/4 (Isolated RS-232) Interface"},
			{ID: 0x70ef, Name: "PCI-8433/4 (Isolated RS-485) Interface"},
			{ID: 0x70f0, Name: "PXI-5922"},
			{ID: 0x70f1, Name: "PCI-5922"},
			{ID: 0x70f2, Name: "PCI-6224"},
			{ID: 0x70f3, Name: "PXI-6224"},
			{ID: 0x70f6, Name: "cRIO-9101"},
			{ID: 0x70f7, Name: "cRIO-9103"},
			{ID: 0x70f8, Name: "cRIO-9104"},
			{ID: 0x70ff, Name: "PXI-6723"},
			{ID: 0x7100, Name: "PXI-6722"},
			{ID: 0x7104, Name: "PCIx-1429"},
			{ID: 0x7105, Name: "PCIe-1429"},
			{ID: 0x710a, Name: "PXI-4071"},
			{ID: 0x710d, Name: "PXI-6143"},
			{ID: 0x710e, Name: "PCIe-GPIB"},
			{ID: 0x710f, Name: "PXI-5422"},
			{ID: 0x7110, Name: "PCI-5422"},
			{ID: 0x7111, Name: "PXI-5441"},
			{ID: 0x7119, Name: "PXI-6561"},
			{ID: 0x711a, Name: "PXI-6562"},
			{ID: 0x711b, Name: "PCI-6561"},
			{ID: 0x711c, Name: "PCI-6562"},
			{ID: 0x7120, Name: "PCI-7390"},
			{ID: 0x7121, Name: "PXI-5122EX"},
			{ID: 0x7122, Name: "PCI-5122EX"},
			{ID: 0x7123, Name: "PXIe-5653"},
			{ID: 0x7124, Name: "PCI-6510"},
			{ID: 0x7125, Name: "PCI-6516"},
			{ID: 0x7126, Name: "PCI-6517"},
			{ID: 0x7127, Name: "PCI-6518"},
			{ID: 0x7128, Name: "PCI-6519"},
			{ID: 0x7137, Name: "PXI-2575"},
			{ID: 0x713c, Name: "PXI-2585"},
			{ID: 0x713d, Name: "PXI-2586"},
			{ID: 0x7142, Name: "PXI-4224"},
			{ID: 0x7144, Name: "PXI-5124"},
			{ID: 0x7145, Name: "PCI-5124"},
			{ID: 0x7146, Name: "PCI-6132"},
			{ID: 0x7147, Name: "PXI-6132"},
			{ID: 0x7148, Name: "PCI-6122"},
			{ID: 0x7149, Name: "PXI-6122"},
			{ID: 0x714c, Name: "PXI-5114"},
			{ID: 0x714d, Name: "PCI-5114"},
			{ID: 0x7150, Name: "PXI-2564"},
			{ID: 0x7152, Name: "PCI-5640R"},
			{ID: 0x7156, Name: "PXI-1044 Trigger Routing Module"},
			{ID: 0x715d, Name: "PCI-1426"},
			{ID: 0x7167, Name: "PXI-5412"},
			{ID: 0x7168, Name: "PCI-5412"},
			{ID: 0x716b, Name: "PCI-6230"},
			{ID: 0x716c, Name: "PCI-6225"},
			{ID: 0x716d, Name: "PXI-6225"},
			{ID: 0x716f, Name: "PCI-4461"},
			{ID: 0x7170, Name: "PCI-4462"},
			{ID: 0x7171, Name: "PCI-6010"},
			{ID: 0x7174, Name: "PXI-8360"},
			{ID: 0x7177, Name: "PXI-6230"},
			{ID: 0x717d, Name: "PCIe-6251"},
			{ID: 0x717f, Name: "PCIe-6259"},
			{ID: 0x7187, Name: "PCI-1410"},
			{ID: 0x718b, Name: "PCI-6521"},
			{ID: 0x718c, Name: "PXI-6521"},
			{ID: 0x7191, Name: "PCI-6154"},
			{ID: 0x7193, Name: "PXI-7813R"},
			{ID: 0x7194, Name: "PCI-7813R"},
			{ID: 0x7195, Name: "PCI-8254R"},
			{ID: 0x7197, Name: "PXI-5402"},
			{ID: 0x7198, Name: "PCI-5402"},
			{ID: 0x719f, Name: "PCIe-6535"},
			{ID: 0x71a0, Name: "PCIe-6536"},
			{ID: 0x71a3, Name: "PXI-5650"},
			{ID: 0x71a4, Name: "PXI-5652"},
			{ID: 0x71a5, Name: "PXI-2594"},
			{ID: 0x71a7, Name: "PXI-2595"},
			{ID: 0x71a9, Name: "PXI-2596"},
			{ID: 0x71aa, Name: "PXI-2597"},
			{ID: 0x71ab, Name: "PXI-2598"},
			{ID: 0x71ac, Name: "PXI-2599"},
			{ID: 0x71ad, Name: "PCI-GPIB+"},
			{ID: 0x71ae, Name: "PCIe-1430"},
			{ID: 0x71b7, Name: "PXI-1056 Trigger Routing Module"},
			{ID: 0x71b8, Name: "PXI-1045 Trigger Routing Module"},
			{ID: 0x71b9, Name: "PXI-1044 Trigger Routing Module"},
			{ID: 0x71bb, Name: "PXI-2584"},
			{ID: 0x71bc, Name: "PCI-6221 (37-pin)"},
			{ID: 0x71bf, Name: "PCIe-1427"},
			{ID: 0x71c5, Name: "PCI-6520"},
			{ID: 0x71c6, Name: "PXI-2576"},
			{ID: 0x71c7, Name: "cRIO-9072"},
			{ID: 0x71dc, Name: "PCI-1588"},
			{ID: 0x71e0, Name: "PCI-6255"},
			{ID: 0x71e1, Name: "PXI-6255"},
			{ID: 0x71e2, Name: "PXI-5406"},
			{ID: 0x71e3, Name: "PCI-5406"},
			{ID: 0x71fc, Name: "PXI-4022"},
			{ID: 0x7209, Name: "PCI-6233"},
			{ID: 0x720a, Name: "PXI-6233"},
			{ID: 0x720b, Name: "PCI-6238"},
			{ID: 0x720c, Name: "PXI-6238"},
			{ID: 0x7260, Name: "PXI-5142"},
			{ID: 0x7261, Name: "PCI-5142"},
			{ID: 0x726d, Name: "PXI-5651"},
			{ID: 0x7273, Name: "PXI-4461"},
			{ID: 0x7274, Name: "PXI-4462"},
			{ID: 0x7279, Name: "PCI-6232"},
			{ID: 0x727a, Name: "PXI-6232"},
			{ID: 0x727b, Name: "PCI-6239"},
			{ID: 0x727c, Name: "PXI-6239"},
			{ID: 0x727e, Name: "SMBus Controller"},
			{ID: 0x7281, Name: "PCI-6236"},
			{ID: 0x7282, Name: "PXI-6236"},
			{ID: 0x7283, Name: "PXI-2554"},
			{ID: 0x7288, Name: "PXIe-5611"},
			{ID: 0x7293, Name: "PCIe-8255R"},
			{ID: 0x729d, Name: "cRIO-9074"},
			{ID: 0x72a4, Name: "PCIe-4065"},
			{ID: 0x72a7, Name: "PCIe-6537"},
			{ID: 0x72a8, Name: "PXI-5152"},
			{ID: 0x72a9, Name: "PCI-5152"},
			{ID: 0x72aa, Name: "PXI-5105"},
			{ID: 0x72ab, Name: "PCI-5105"},
			{ID: 0x72b8, Name: "PXI-6682"},
			{ID: 0x72d0, Name: "PXI-2545"},
			{ID: 0x72d1, Name: "PXI-2546"},
			{ID: 0x72d2, Name: "PXI-2547"},
			{ID: 0x72d3, Name: "PXI-2548"},
			{ID: 0x72d4, Name: "PXI-2549"},
			{ID: 0x72d5, Name: "PXI-2555"},
			{ID: 0x72d6, Name: "PXI-2556"},
			{ID: 0x72d7, Name: "PXI-2557"},
			{ID: 0x72d8, Name: "PXI-2558"},
			{ID: 0x72d9, Name: "PXI-2559"},
			{ID: 0x72e8, Name: "PXIe-6251"},
			{ID: 0x72e9, Name: "PXIe-6259"},
			{ID: 0x72ef, Name: "PXI-4498"},
			{ID: 0x72f0, Name: "PXI-4496"},
			{ID: 0x72fb, Name: "PXIe-6672"},
			{ID: 0x730e, Name: "PXI-4130"},
			{ID: 0x730f, Name: "PXI-5922EX"},
			{ID: 0x7310, Name: "PCI-5922EX"},
			{ID: 0x731c, Name: "PXI-2535"},
			{ID: 0x731d, Name: "PXI-2536"},
			{ID: 0x7322, Name: "PXIe-6124"},
			{ID: 0x7327, Name: "PXI-6529"},
			{ID: 0x732c, Name: "VXI-8360T"},
			{ID: 0x7331, Name: "PXIe-5602"},
			{ID: 0x7332, Name: "PXIe-5601"},
			{ID: 0x7333, Name: "PXI-5900"},
			{ID: 0x7335, Name: "PXI-2533"},
			{ID: 0x7336, Name: "PXI-2534"},
			{ID: 0x7342, Name: "PXI-4461"},
			{ID: 0x7349, Name: "PXI-5154"},
			{ID: 0x734a, Name: "PCI-5154"},
			{ID: 0x7357, Name: "PXI-4065"},
			{ID: 0x7359, Name: "PXI-4495"},
			{ID: 0x7370, Name: "PXI-4461"},
			{ID: 0x7373, Name: "sbRIO-9601"},
			{ID: 0x7374, Name: "IOtech-9601"},
			{ID: 0x7375, Name: "sbRIO-9602"},
			{ID: 0x7378, Name: "sbRIO-9641"},
			{ID: 0x737d, Name: "PXI-5124EX"},
			{ID: 0x7384, Name: "PXI-7851R"},
			{ID: 0x7385, Name: "PXI-7852R"},
			{ID: 0x7386, Name: "PCIe-7851R"},
			{ID: 0x7387, Name: "PCIe-7852R"},
			{ID: 0x7390, Name: "PXI-7841R"},
			{ID: 0x7391, Name: "PXI-7842R"},
			{ID: 0x7392, Name: "PXI-7853R"},
			{ID: 0x7393, Name: "PCIe-7841R"},
			{ID: 0x7394, Name: "PCIe-7842R"},
			{ID: 0x7397, Name: "sbRIO-9611"},
			{ID: 0x7398, Name: "sbRIO-9612"},
			{ID: 0x7399, Name: "sbRIO-9631"},
			{ID: 0x739a, Name: "sbRIO-9632"},
			{ID: 0x739b, Name: "sbRIO-9642"},
			{ID: 0x73a1, Name: "PXIe-4498"},
			{ID: 0x73a2, Name: "PXIe-4496"},
			{ID: 0x73a5, Name: "PXIe-5641R"},
			{ID: 0x73a7, Name: "PXI-8250 Chassis Monitor Module"},
			{ID: 0x73a8, Name: "PXI-8511 CAN/LS"},
			{ID: 0x73a9, Name: "PXI-8511 CAN/LS"},
			{ID: 0x73aa, Name: "PXI-8512 CAN/HS"},
			{ID: 0x73ab, Name: "PXI-8512 CAN/HS"},
			{ID: 0x73ac, Name: "PXI-8513 CAN/XS"},
			{ID: 0x73ad, Name: "PXI-8513 CAN/XS"},
			{ID: 0x73af, Name: "PXI-8516 LIN"},
			{ID: 0x73b1, Name: "PXI-8517 FlexRay"},
			{ID: 0x73b2, Name: "PXI-8531 CANopen"},
			{ID: 0x73b3, Name: "PXI-8531 CANopen"},
			{ID: 0x73b4, Name: "PXI-8532 DeviceNet"},
			{ID: 0x73b5, Name: "PXI-8532 DeviceNet"},
			{ID: 0x73b6, Name: "PCI-8511 CAN/LS"},
			{ID: 0x73b7, Name: "PCI-8511 CAN/LS"},
			{ID: 0x73b8, Name: "PCI-8512 CAN/HS"},
			{ID: 0x73b9, Name: "PCI-8512 CAN/HS"},
			{ID: 0x73ba, Name: "PCI-8513 CAN/XS"},
			{ID: 0x73bb, Name: "PCI-8513 CAN/XS"},
			{ID: 0x73bd, Name: "PCI-8516 LIN"},
			{ID: 0x73bf, Name: "PCI-8517 FlexRay"},
			{ID: 0x73c0, Name: "PCI-8531 CANopen"},
			{ID: 0x73c1, Name: "PCI-8531 CANopen"},
			{ID: 0x73c2, Name: "PCI-8532 DeviceNet"},
			{ID: 0x73c3, Name: "PCI-8532 DeviceNet"},
			{ID: 0x73c5, Name: "PXIe-2527"},
			{ID: 0x73c6, Name: "PXIe-2529"},
			{ID: 0x73c8, Name: "PXIe-2530"},
			{ID: 0x73c9, Name: "PXIe-2532"},
			{ID: 0x73ca, Name: "PXIe-2569"},
			{ID: 0x73cb, Name: "PXIe-2575"},
			{ID: 0x73cc, Name: "PXIe-2593"},
			{ID: 0x73d5, Name: "PXI-7951R"},
			{ID: 0x73d6, Name: "PXI-7952R"},
			{ID: 0x73d7, Name: "PXI-7953R"},
			{ID: 0x73e1, Name: "PXI-7854R"},
			{ID: 0x73ec, Name: "PXI-7954R"},
			{ID: 0x73ed, Name: "cRIO-9073"},
			{ID: 0x73f0, Name: "PXI-5153"},
			{ID: 0x73f1, Name: "PCI-5153"},
			{ID: 0x73f4, Name: "PXI-2515"},
			{ID: 0x73f6, Name: "cRIO-9111"},
			{ID: 0x73f7, Name: "cRIO-9112"},
			{ID: 0x73f8, Name: "cRIO-9113"},
			{ID: 0x73f9, Name: "cRIO-9114"},
			{ID: 0x73fa, Name: "cRIO-9116"},
			{ID: 0x73fb, Name: "cRIO-9118"},
			{ID: 0x7404, Name: "PXI-4132"},
			{ID: 0x7405, Name: "PXIe-6674T"},
			{ID: 0x7406, Name: "PXIe-6674"},
			{ID: 0x740e, Name: "PCIe-8430/16 (RS-232) Interface"},
			{ID: 0x740f, Name: "PCIe-8430/8 (RS-232) Interface"},
			{ID: 0x7410, Name: "PCIe-8431/16 (RS-485) Interface"},
			{ID: 0x7411, Name: "PCIe-8431/8 (RS-485) Interface"},
			{ID: 0x7414, Name: "PCIe-GPIB+"},
			{ID: 0x741c, Name: "PXI-5691"},
			{ID: 0x741d, Name: "PXI-5695"},
			{ID: 0x743c, Name: "CSC-3059"},
			{ID: 0x7448, Name: "PXI-2510"},
			{ID: 0x7454, Name: "PXI-2512"},
			{ID: 0x7455, Name: "PXI-2514"},
			{ID: 0x7456, Name: "PXIe-2512"},
			{ID: 0x7457, Name: "PXIe-2514"},
			{ID: 0x745a, Name: "PXI-6682H"},
			{ID: 0x745e, Name: "PXI-5153EX"},
			{ID: 0x745f, Name: "PCI-5153EX"},
			{ID: 0x7460, Name: "PXI-5154EX"},
			{ID: 0x7461, Name: "PCI-5154EX"},
			{ID: 0x746d, Name: "PXIe-5650"},
			{ID: 0x746e, Name: "PXIe-5651"},
			{ID: 0x746f, Name: "PXIe-5652"},
			{ID: 0x7472, Name: "PXI-2800"},
			{ID: 0x7495, Name: "PXIe-5603"},
			{ID: 0x7497, Name: "PXIe-5605"},
			{ID: 0x74ae, Name: "PXIe-2515"},
			{ID: 0x74b4, Name: "PXI-2531"},
			{ID: 0x74b5, Name: "PXIe-2531"},
			{ID: 0x74c1, Name: "PXIe-8430/16 (RS-232) Interface"},
			{ID: 0x74c2, Name: "PXIe-8430/8 (RS-232) Interface"},
			{ID: 0x74c3, Name: "PXIe-8431/16 (RS-485) Interface"},
			{ID: 0x74c4, Name: "PXIe-8431/8 (RS-485) Interface"},
			{ID: 0x74d5, Name: "PXIe-5630"},
			{ID: 0x74d9, Name: "PCIe-8432/2 (Isolated RS-232) Interface"},
			{ID: 0x74da, Name: "PCIe-8433/2 (Isolated RS-485) Interface"},
			{ID: 0x74db, Name: "PCIe-8432/4 (Isolated RS-232) Interface"},
			{ID: 0x74dc, Name: "PCIe-8433/4 (Isolated RS-485) Interface"},
			{ID: 0x74e8, Name: "NI 9148"},
			{ID: 0x7515, Name: "PCIe-8430/2 (RS-232) Interface"},
			{ID: 0x7516, Name: "PCIe-8430/4 (RS-232) Interface"},
			{ID: 0x7517, Name: "PCIe-8431/2 (RS-485) Interface"},
			{ID: 0x7518, Name: "PCIe-8431/4 (RS-485) Interface"},
			{ID: 0x751b, Name: "cRIO-9081"},
			{ID: 0x751c, Name: "cRIO-9082"},
			{ID: 0x7528, Name: "PXIe-4497"},
			{ID: 0x7529, Name: "PXIe-4499"},
			{ID: 0x752a, Name: "PXIe-4492"},
			{ID: 0x7539, Name: "NI 9157"},
			{ID: 0x753a, Name: "NI 9159"},
			{ID: 0x7598, Name: "PXI-2571"},
			{ID: 0x75a4, Name: "PXI-4131A"},
			{ID: 0x75b1, Name: "PCIe-7854R"},
			{ID: 0x75ba, Name: "PXI-2543"},
			{ID: 0x75bb, Name: "PXIe-2543"},
			{ID: 0x75e5, Name: "PXI-6683"},
			{ID: 0x75e6, Name: "PXI-6683H"},
			{ID: 0x75ef, Name: "PXIe-5632"},
			{ID: 0x761c, Name: "VXI-8360LT"},
			{ID: 0x761f, Name: "PXI-2540"},
			{ID: 0x7620, Name: "PXIe-2540"},
			{ID: 0x7621, Name: "PXI-2541"},
			{ID: 0x7622, Name: "PXIe-2541"},
			{ID: 0x7626, Name: "NI 9154"},
			{ID: 0x7627, Name: "NI 9155"},
			{ID: 0x7638, Name: "PXI-2720"},
			{ID: 0x7639, Name: "PXI-2722"},
			{ID: 0x763a, Name: "PXIe-2725"},
			{ID: 0x763b, Name: "PXIe-2727"},
			{ID: 0x763c, Name: "PXI-4465"},
			{ID: 0x764b, Name: "PXIe-2790"},
			{ID: 0x764c, Name: "PXI-2520"},
			{ID: 0x764d, Name: "PXI-2521"},
			{ID: 0x764e, Name: "PXI-2522"},
			{ID: 0x764f, Name: "PXI-2523"},
			{ID: 0x7654, Name: "PXI-2796"},
			{ID: 0x7655, Name: "PXI-2797"},
			{ID: 0x7656, Name: "PXI-2798"},
			{ID: 0x7657, Name: "PXI-2799"},
			{ID: 0x765d, Name: "PXI-2542"},
			{ID: 0x765e, Name: "PXIe-2542"},
			{ID: 0x765f, Name: "PXI-2544"},
			{ID: 0x7660, Name: "PXIe-2544"},
			{ID: 0x766d, Name: "PCIe-6535B"},
			{ID: 0x766e, Name: "PCIe-6536B"},
			{ID: 0x766f, Name: "PCIe-6537B"},
			{ID: 0x76a3, Name: "PXIe-6535B"},
			{ID: 0x76a4, Name: "PXIe-6536B"},
			{ID: 0x76a5, Name: "PXIe-6537B"},
			{ID: 0x783e, Name: "PXI-8368"},
			{ID: 0x9020, Name: "PXI-2501"},
			{ID: 0x9030, Name: "PXI-2503"},
			{ID: 0x9040, Name: "PXI-2527"},
			{ID: 0x9050, Name: "PXI-2565"},
			{ID: 0x9060, Name: "PXI-2590"},
			{ID: 0x9070, Name: "PXI-2591"},
			{ID: 0x9080, Name: "PXI-2580"},
			{ID: 0x9090, Name: "PCI-4021"},
			{ID: 0x90a0, Name: "PXI-4021"},
			{ID: 0xa001, Name: "PCI-MXI-2"},
			{ID: 0xb001, Name: "PCI-1408"},
			{ID: 0xb011, Name: "PXI-1408"},
			{ID: 0xb021, Name: "PCI-1424"},
			{ID: 0xb022, Name: "PXI-1424"},
			{ID: 0xb031, Name: "PCI-1413"},
			{ID: 0xb041, Name: "PCI-1407"},
			{ID: 0xb051, Name: "PXI-1407"},
			{ID: 0xb061, Name: "PCI-1411"},
			{ID: 0xb071, Name: "PCI-1422"},
			{ID: 0xb081, Name: "PXI-1422"},
			{ID: 0xb091, Name: "PXI-1411"},
			{ID: 0xb0b1, Name: "PCI-1409"},
			{ID: 0xb0c1, Name: "PXI-1409"},
			{ID: 0xb0e1, Name: "PCI-1428"},
			{ID: 0xc4c4, Name: "PXIe/PCIe Device"},
			{ID: 0xc801, Name: "PCI-GPIB"},
			{ID: 0xc811, Name: "PCI-GPIB+"},
			{ID: 0xc821, Name: "PXI-GPIB"},
			{ID: 0xc831, Name: "PMC-GPIB"},
			{ID: 0xc840, Name: "PCI-GPIB"},
			{ID: 0xd130, Name: "PCI-232/2 Interface"},
			{ID: 0xd140, Name: "PCI-232/4 Interface"},
			{ID: 0xd150, Name: "PCI-232/8 Interface"},
			{ID: 0xd160, Name: "PCI-485/2 Interface"},
			{ID: 0xd170, Name: "PCI-485/4 Interface"},
			{ID: 0xd190, Name: "PXI-8422/2 (Isolated RS-232) Interface"},
			{ID: 0xd1a0, Name: "PXI-8422/4 (Isolated RS-232) Interface"},
			{ID: 0xd1b0, Name: "PXI-8423/2 (Isolated RS-485) Interface"},
			{ID: 0xd1c0, Name: "PXI-8423/4 (Isolated RS-485) Interface"},
			{ID: 0xd1d0, Name: "PXI-8420/2 (RS-232) Interface"},
			{ID: 0xd1e0, Name: "PXI-8420/4 (RS-232) Interface"},
			{ID: 0xd1f0, Name: "PXI-8420/8 (RS-232) Interface"},
			{ID: 0xd1f1, Name: "PXI-8420/16 (RS-232) Interface"},
			{ID: 0xd230, Name: "PXI-8421/2 (RS-485) Interface"},
			{ID: 0xd240, Name: "PXI-8421/4 (RS-485) Interface"},
			{ID: 0xd250, Name: "PCI-232/2 (Isolated) Interface"},
			{ID: 0xd260, Name: "PCI-485/2 (Isolated) Interface"},
			{ID: 0xd270, Name: "PCI-232/4 (Isolated) Interface"},
			{ID: 0xd280, Name: "PCI-485/4 (Isolated) Interface"},
			{ID: 0xd290, Name: "PCI-485/8 Interface"},
			{ID: 0xd2a0, Name: "PXI-8421/8 (RS-485) Interface"},
			{ID: 0xd2b0, Name: "PCI-232/16 Interface"},
			{ID: 0xe111, Name: "PCI-CAN"},
			{ID: 0xe131, Name: "PXI-8461 (1 port)"},
			{ID: 0xe141, Name: "PCI-CAN/LS"},
			{ID: 0xe151, Name: "PXI-8460 (1 port)"},
			{ID: 0xe211, Name: "PCI-CAN/2"},
			{ID: 0xe231, Name: "PXI-8461 (2 ports)"},
			{ID: 0xe241, Name: "PCI-CAN/LS2"},
			{ID: 0xe251, Name: "PXI-8460 (2 ports)"},
			{ID: 0xe261, Name: "PCI-CAN/DS"},
			{ID: 0xe271, Name: "PXI-8462"},
			{ID: 0xf110, Name: "VMEpc-650"},
			{ID: 0xf120, Name: "VXIpc-650"},
			{ID: 0xfe00, Name: "VXIpc-87x"},
			{ID: 0xfe41, Name: "VXIpc-860"},
			{ID: 0xfe51, Name: "VXIpc-74x"},
			{ID: 0xfe61, Name: "VXIpc-850"},
			{ID: 0xfe70, Name: "VXIpc-880"},
		},
	},
	{ID: 0x1094, Name: "First International Computers [FIC]", Devices: []Device{}},
	{
		ID: 0x1095, Name: "Silicon Image, Inc.", Devices: []Device{
			{ID: 0x0240, Name: "Adaptec AAR-1210SA SATA HostRAID Controller"},
			{ID: 0x0640, Name: "PCI0640"},
			{ID: 0x0643, Name: "PCI0643"},
			{ID: 0x0646, Name: "PCI0646"},
			{ID: 0x0647, Name: "PCI0647"},
			{ID: 0x0648, Name: "PCI0648"},
			{ID: 0x0649, Name: "SiI 0649 Ultra ATA/100 PCI to ATA Host Controller"},
			{ID: 0x0650, Name: "PBC0650A"},
			{ID: 0x0670, Name: "USB0670"},
			{ID: 0x0673, Name: "USB0673"},
			{ID: 0x0680, Name: "PCI0680 Ultra ATA-133 Host Controller"},
			{ID: 0x3112, Name: "SiI 3112 [SATALink/SATARaid] Serial ATA Controller"},
			{ID: 0x3114, Name: "SiI 3114 [SATALink/SATARaid] Serial ATA Controller"},
			{ID: 0x3124, Name: "SiI 3124 PCI-X Serial ATA Controller"},
			{ID: 0x3132, Name: "SiI 3132 Serial ATA Raid II Controller"},
			{ID: 0x3512, Name: "SiI 3512 [SATALink/SATARaid] Serial ATA Controller"},
			{ID: 0x3531, Name: "SiI 3531 [SATALink/SATARaid] Serial ATA Controller"},
		},
	},
	{ID: 0x1096, Name: "Alacron", Devices: []Device{}},
	{ID: 0x1097, Name: "Appian Technology", Devices: []Device{}},
	{
		ID: 0x1098, Name: "Quantum Designs (H.K.) Ltd", Devices: []Device{
			{ID: 0x0001, Name: "QD-8500"},
			{ID: 0x0002, Name: "QD-8580"},
		},
	},
	{ID: 0x1099, Name: "Samsung Electronics Co., Ltd", Devices: []Device{}},
	{ID: 0x109a, Name: "Packard Bell", Devices: []Device{}},
	{ID: 0x109b, Name: "Gemlight Computer Ltd.", Devices: []Device{}},
	{ID: 0x109c, Name: "Megachips Corporation", Devices: []Device{}},
	{ID: 0x109d, Name: "Zida Technologies Ltd.", Devices: []Device{}},
	{
		ID: 0x109e, Name: "Brooktree Corporation", Devices: []Device{
			{ID: 0x0310, Name: "Bt848 Video Capture"},
			{ID: 0x032e, Name: "Bt878 Video Capture"},
			{ID: 0x0350, Name: "Bt848 Video Capture"},
			{ID: 0x0351, Name: "Bt849A Video capture"},
			{ID: 0x0369, Name: "Bt878 Video Capture"},
			{ID: 0x036c, Name: "Bt879(??) Video Capture"},
			{ID: 0x036e, Name: "Bt878 Video Capture"},
			{ID: 0x036f, Name: "Bt879 Video Capture"},
			{ID: 0x0370, Name: "Bt880 Video Capture"},
			{ID: 0x0878, Name: "Bt878 Audio Capture"},
			{ID: 0x0879, Name: "Bt879 Audio Capture"},
			{ID: 0x0880, Name: "Bt880 Audio Capture"},
			{ID: 0x2115, Name: "BtV 2115 Mediastream controller"},
			{ID: 0x2125, Name: "BtV 2125 Mediastream controller"},
			{ID: 0x2164, Name: "BtV 2164"},
			{ID: 0x2165, Name: "BtV 2165"},
			{ID: 0x8230, Name: "Bt8230 ATM Segment/Reassembly Ctrlr (SRC)"},
			{ID: 0x8472, Name: "Bt8472"},
			{ID: 0x8474, Name: "Bt8474"},
		},
	},
	{ID: 0x109f, Name: "Trigem Computer Inc.", Devices: []Device{}},
	{ID: 0x10a0, Name: "Meidensha Corporation", Devices: []Device{}},
	{ID: 0x10a1, Name: "Juko Electronics Ind. Co. Ltd", Devices: []Device{}},
	{ID: 0x10a2, Name: "Quantum Corporation", Devices: []Device{}},
	{ID: 0x10a3, Name: "Everex Systems Inc", Devices: []Device{}},
	{ID: 0x10a4, Name: "Globe Manufacturing Sales", Devices: []Device{}},
	{
		ID: 0x10a5, Name: "Smart Link Ltd.", Devices: []Device{
			{ID: 0x3052, Name: "SmartPCI562 56K Modem"},
			{ID: 0x5449, Name: "SmartPCI561 modem"},
		},
	},
	{ID: 0x10a6, Name: "Informtech Industrial Ltd.", Devices: []Device{}},
	{ID: 0x10a7, Name: "Benchmarq Microelectronics", Devices: []Device{}},
	{
		ID: 0x10a8, Name: "Sierra Semiconductor", Devices: []Device{
			{ID: 0x0000, Name: "STB Horizon 64"},
		},
	},
	{
		ID: 0x10a9, Name: "Silicon Graphics Intl. Corp.", Devices: []Device{
			{ID: 0x0001, Name: "Crosstalk to PCI Bridge"},
			{ID: 0x0002, Name: "Linc I/O controller"},
			{ID: 0x0003, Name: "IOC3 I/O controller"},
			{ID: 0x0004, Name: "O2 MACE"},
			{ID: 0x0005, Name: "RAD Audio"},
			{ID: 0x0006, Name: "HPCEX"},
			{ID: 0x0007, Name: "RPCEX"},
			{ID: 0x0008, Name: "DiVO VIP"},
			{ID: 0x0009, Name: "AceNIC Gigabit Ethernet"},
			{ID: 0x0010, Name: "AMP Video I/O"},
			{ID: 0x0011, Name: "GRIP"},
			{ID: 0x0012, Name: "SGH PSHAC GSN"},
			{ID: 0x0208, Name: "SSIM1 SAS Adapter"},
			{ID: 0x1001, Name: "Magic Carpet"},
			{ID: 0x1002, Name: "Lithium"},
			{ID: 0x1003, Name: "Dual JPEG 1"},
			{ID: 0x1004, Name: "Dual JPEG 2"},
			{ID: 0x1005, Name: "Dual JPEG 3"},
			{ID: 0x1006, Name: "Dual JPEG 4"},
			{ID: 0x1007, Name: "Dual JPEG 5"},
			{ID: 0x1008, Name: "Cesium"},
			{ID: 0x100a, Name: "IOC4 I/O controller"},
			{ID: 0x1504, Name: "SSIM1 Fibre Channel Adapter"},
			{ID: 0x2001, Name: "Fibre Channel"},
			{ID: 0x2002, Name: "ASDE"},
			{ID: 0x4001, Name: "TIO-CE PCI Express Bridge"},
			{ID: 0x4002, Name: "TIO-CE PCI Express Port"},
			{ID: 0x8001, Name: "O2 1394"},
			{ID: 0x8002, Name: "G-net NT"},
			{ID: 0x802b, Name: "REACT external interrupt controller"},
		},
	},
	{
		ID: 0x10aa, Name: "ACC Microelectronics", Devices: []Device{
			{ID: 0x0000, Name: "ACCM 2188"},
			{ID: 0x2051, Name: "2051 CPU bridge"},
			{ID: 0x5842, Name: "2051 ISA bridge"},
		},
	},
	{ID: 0x10ab, Name: "Digicom", Devices: []Device{}},
	{ID: 0x10ac, Name: "Honeywell IAC", Devices: []Device{}},
	{
		ID: 0x10ad, Name: "Symphony Labs", Devices: []Device{
			{ID: 0x0001, Name: "W83769F"},
			{ID: 0x0003, Name: "SL82C103"},
			{ID: 0x0005, Name: "SL82C105"},
			{ID: 0x0103, Name: "SL82c103"},
			{ID: 0x0105, Name: "SL82c105"},
			{ID: 0x0565, Name: "W83C553F/W83C554F"},
		},
	},
	{ID: 0x10ae, Name: "Cornerstone Technology", Devices: []Device{}},
	{ID: 0x10af, Name: "Micro Computer Systems Inc", Devices: []Device{}},
	{ID: 0x10b0, Name: "CardExpert Technology", Devices: []Device{}},
	{ID: 0x10b1, Name: "Cabletron Systems Inc", Devices: []Device{}},
	{ID: 0x10b2, Name: "Raytheon Company", Devices: []Device{}},
	{
		ID: 0x10b3, Name: "Databook Inc", Devices: []Device{
			{ID: 0x3106, Name: "DB87144"},
			{ID: 0xb106, Name: "DB87144"},
		},
	},
	{
		ID: 0x10b4, Name: "STB Systems Inc", Devices: []Device{
			{ID: 0x1b1d, Name: "Velocity 128 3D"},
		},
	},
	{
		ID: 0x10b5, Name: "PLX Technology, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "i960 PCI bus interface"},
			{ID: 0x0557, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x1000, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x1024, Name: "Acromag, Inc. IndustryPack Carrier Card"},
			{ID: 0x1042, Name: "Brandywine / jxi2, Inc. - PMC-SyncClock32, IRIG A & B, Nasa 36"},
			{ID: 0x106a, Name: "Dual OX16C952 4 port serial adapter [Megawolf Romulus/4]"},
			{ID: 0x1076, Name: "VScom 800 8 port serial adaptor"},
			{ID: 0x1077, Name: "VScom 400 4 port serial adaptor"},
			{ID: 0x1078, Name: "VScom 210 2 port serial and 1 port parallel adaptor"},
			{ID: 0x1103, Name: "VScom 200 2 port serial adaptor"},
			{ID: 0x1146, Name: "VScom 010 1 port parallel adaptor"},
			{ID: 0x1147, Name: "VScom 020 2 port parallel adaptor"},
			{ID: 0x2000, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x2540, Name: "IXXAT CAN-Interface PC-I 04/PCI"},
			{ID: 0x2724, Name: "Thales PCSM Security Card"},
			{ID: 0x3376, Name: "Cosateq 4 Port CAN Card"},
			{ID: 0x4000, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x4001, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x4002, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x6140, Name: "PCI6140 32-bit 33MHz PCI-to-PCI Bridge"},
			{ID: 0x6150, Name: "PCI6150 32-bit 33MHz PCI-to-PCI Bridge"},
			{ID: 0x6152, Name: "PCI6152 32-bit 66MHz PCI-to-PCI Bridge"},
			{ID: 0x6154, Name: "PCI6154 64-bit 66MHz PCI-to-PCI Bridge"},
			{ID: 0x6254, Name: "PCI6254 64-bit 66MHz PCI-to-PCI Bridge"},
			{ID: 0x6466, Name: "PCI6466 64-bit 66MHz PCI-to-PCI Bridge"},
			{ID: 0x6520, Name: "PCI6520 64-bit 133MHz PCI-X-to-PCI-X Bridge"},
			{ID: 0x6540, Name: "PCI6540 64-bit 133MHz PCI-X-to-PCI-X Bridge"},
			{ID: 0x6541, Name: "PCI6540/6466 PCI-PCI bridge (non-transparent mode, primary side)"},
			{ID: 0x6542, Name: "PCI6540/6466 PCI-PCI bridge (non-transparent mode, secondary side)"},
			{ID: 0x8111, Name: "PEX 8111 PCI Express-to-PCI Bridge"},
			{ID: 0x8112, Name: "PEX8112 x1 Lane PCI Express-to-PCI Bridge"},
			{ID: 0x8114, Name: "PEX 8114 PCI Express-to-PCI/PCI-X Bridge"},
			{ID: 0x8311, Name: "PEX8311 x1 Lane PCI Express-to-Generic Local Bus Bridge"},
			{ID: 0x8505, Name: "PEX 8505 5-lane, 5-port PCI Express Switch"},
			{ID: 0x8508, Name: "PEX 8508 8-lane, 5-port PCI Express Switch"},
			{ID: 0x8509, Name: "PEX 8509 8-lane, 8-port PCI Express Switch"},
			{ID: 0x8512, Name: "PEX 8512 12-lane, 5-port PCI Express Switch"},
			{ID: 0x8516, Name: "PEX 8516  Versatile PCI Express Switch"},
			{ID: 0x8517, Name: "PEX 8517 16-lane, 5-port PCI Express Switch"},
			{ID: 0x8518, Name: "PEX 8518 16-lane, 5-port PCI Express Switch"},
			{ID: 0x8524, Name: "PEX 8524 24-lane, 6-port PCI Express Switch"},
			{ID: 0x8525, Name: "PEX 8525 24-lane, 5-port PCI Express Switch"},
			{ID: 0x8532, Name: "PEX 8532  Versatile PCI Express Switch"},
			{ID: 0x8533, Name: "PEX 8533 32-lane, 6-port PCI Express Switch"},
			{ID: 0x8547, Name: "PEX 8547 48-lane, 3-port PCI Express Switch"},
			{ID: 0x8548, Name: "PEX 8548 48-lane, 9-port PCI Express Switch"},
			{ID: 0x8603, Name: "PEX 8603 3-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8604, Name: "PEX 8604 4-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8605, Name: "PEX 8605 PCI Express 4-port Gen2 Switch"},
			{ID: 0x8606, Name: "PEX 8606 6 Lane, 6 Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8608, Name: "PEX 8608 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8609, Name: "PEX 8609 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA"},
			{ID: 0x8612, Name: "PEX 8612 12-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8613, Name: "PEX 8613 12-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8614, Name: "PEX 8614 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8615, Name: "PEX 8615 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA"},
			{ID: 0x8616, Name: "PEX 8616 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8617, Name: "PEX 8617 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch with P2P"},
			{ID: 0x8618, Name: "PEX 8618 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8619, Name: "PEX 8619 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA"},
			{ID: 0x8624, Name: "PEX 8624 24-lane, 6-Port PCI Express Gen 2 (5.0 GT/s) Switch [ExpressLane]"},
			{ID: 0x8625, Name: "PEX 8625 24-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8632, Name: "PEX 8632 32-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8636, Name: "PEX 8636 36-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8647, Name: "PEX 8647 48-Lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8648, Name: "PEX 8648 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8649, Name: "PEX 8649 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8664, Name: "PEX 8664 64-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch"},
			{ID: 0x8680, Name: "PEX 8680 80-lane, 20-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch"},
			{ID: 0x8696, Name: "PEX 8696 96-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch"},
			{ID: 0x8717, Name: "PEX 8717 16-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch with DMA"},
			{ID: 0x8718, Name: "PEX 8718 16-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch"},
			{ID: 0x8724, Name: "PEX 8724 24-Lane, 6-Port PCI Express Gen 3 (8 GT/s) Switch, 19 x 19mm FCBGA"},
			{ID: 0x8725, Name: "PEX 8725 24-Lane, 10-Port PCI Express Gen 3 (8.0 GT/s) Multi-Root Switch with DMA"},
			{ID: 0x8732, Name: "PEX 8732 32-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch"},
			{ID: 0x8734, Name: "PEX 8734 32-lane, 8-Port PCI Express Gen 3 (8.0GT/s) Switch"},
			{ID: 0x8747, Name: "PEX 8747 48-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch"},
			{ID: 0x8748, Name: "PEX 8748 48-Lane, 12-Port PCI Express Gen 3 (8 GT/s) Switch, 27 x 27mm FCBGA"},
			{ID: 0x8749, Name: "PEX 8749 48-Lane, 18-Port PCI Express Gen 3 (8.0 GT/s) Multi-Root Switch with DMA"},
			{ID: 0x87a0, Name: "PEX PCI Express Switch NT0 Port Link Interface"},
			{ID: 0x87a1, Name: "PEX PCI Express Switch NT1 Port Link Interface"},
			{ID: 0x87b0, Name: "PEX PCI Express Switch NT0 Port Virtual Interface"},
			{ID: 0x87b1, Name: "PEX PCI Express Switch NT1 Port Virtual Interface"},
			{ID: 0x87d0, Name: "PEX PCI Express Switch DMA interface"},
			{ID: 0x9016, Name: "PLX 9016 8-port serial controller"},
			{ID: 0x9030, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x9036, Name: "9036"},
			{ID: 0x9050, Name: "PCI <-> IOBus Bridge"},
			{ID: 0x9052, Name: "PCI9052 PCI <-> IOBus Bridge"},
			{ID: 0x9054, Name: "PCI9054 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x9056, Name: "PCI9056 32-bit 66MHz PCI <-> IOBus Bridge"},
			{ID: 0x9060, Name: "PCI9060 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x906d, Name: "9060SD"},
			{ID: 0x906e, Name: "9060ES"},
			{ID: 0x9080, Name: "PCI9080 32-bit; 33MHz PCI <-> IOBus Bridge"},
			{ID: 0x9656, Name: "PCI9656 PCI <-> IOBus Bridge"},
			{ID: 0x9733, Name: "PEX 9733 33-lane, 9-port PCI Express Gen 3 (8.0 GT/s) Switch"},
			{ID: 0x9749, Name: "PEX 9749 49-lane, 13-port PCI Express Gen 3 (8.0 GT/s) Switch"},
			{ID: 0xa100, Name: "Blackmagic Design DeckLink"},
			{ID: 0xbb04, Name: "B&B 3PCIOSD1A Isolated PCI Serial"},
			{ID: 0xc001, Name: "CronyxOmega-PCI (8-port RS232)"},
			{ID: 0xd00d, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0xd33d, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
			{ID: 0xd44d, Name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge"},
		},
	},
	{
		ID: 0x10b6, Name: "Madge Networks", Devices: []Device{
			{ID: 0x0001, Name: "Smart 16/4 PCI Ringnode"},
			{ID: 0x0002, Name: "Smart 16/4 PCI Ringnode Mk2"},
			{ID: 0x0003, Name: "Smart 16/4 PCI Ringnode Mk3"},
			{ID: 0x0004, Name: "Smart 16/4 PCI Ringnode Mk1"},
			{ID: 0x0006, Name: "16/4 Cardbus Adapter"},
			{ID: 0x0007, Name: "Presto PCI Adapter"},
			{ID: 0x0009, Name: "Smart 100/16/4 PCI-HS Ringnode"},
			{ID: 0x000a, Name: "Token Ring 100/16/4 Ringnode/Ringrunner"},
			{ID: 0x000b, Name: "16/4 CardBus Adapter Mk2"},
			{ID: 0x000c, Name: "RapidFire 3140V2 16/4 TR Adapter"},
			{ID: 0x1000, Name: "Collage 25/155 ATM Client Adapter"},
			{ID: 0x1001, Name: "Collage 155 ATM Server Adapter"},
		},
	},
	{
		ID: 0x10b7, Name: "3Com Corporation", Devices: []Device{
			{ID: 0x0001, Name: "3c985 1000BaseSX (SX/TX)"},
			{ID: 0x0013, Name: "AR5212 802.11abg NIC (3CRDAG675)"},
			{ID: 0x0910, Name: "3C910-A01"},
			{ID: 0x1006, Name: "MINI PCI type 3B Data Fax Modem"},
			{ID: 0x1007, Name: "Mini PCI 56k Winmodem"},
			{ID: 0x1201, Name: "3c982-TXM 10/100baseTX Dual Port A [Hydra]"},
			{ID: 0x1202, Name: "3c982-TXM 10/100baseTX Dual Port B [Hydra]"},
			{ID: 0x1700, Name: "3c940 10/100/1000Base-T [Marvell]"},
			{ID: 0x3390, Name: "3c339 TokenLink Velocity"},
			{ID: 0x3590, Name: "3c359 TokenLink Velocity XL"},
			{ID: 0x4500, Name: "3c450 HomePNA [Tornado]"},
			{ID: 0x5055, Name: "3c555 Laptop Hurricane"},
			{ID: 0x5057, Name: "3c575 Megahertz 10/100 LAN CardBus [Boomerang]"},
			{ID: 0x5157, Name: "3cCFE575BT Megahertz 10/100 LAN CardBus [Cyclone]"},
			{ID: 0x5257, Name: "3cCFE575CT CardBus [Cyclone]"},
			{ID: 0x5900, Name: "3c590 10BaseT [Vortex]"},
			{ID: 0x5920, Name: "3c592 EISA 10mbps Demon/Vortex"},
			{ID: 0x5950, Name: "3c595 100BaseTX [Vortex]"},
			{ID: 0x5951, Name: "3c595 100BaseT4 [Vortex]"},
			{ID: 0x5952, Name: "3c595 100Base-MII [Vortex]"},
			{ID: 0x5970, Name: "3c597 EISA Fast Demon/Vortex"},
			{ID: 0x5b57, Name: "3c595 Megahertz 10/100 LAN CardBus [Boomerang]"},
			{ID: 0x6000, Name: "3CRSHPW796 [OfficeConnect Wireless CardBus]"},
			{ID: 0x6001, Name: "3com 3CRWE154G72 [Office Connect Wireless LAN Adapter]"},
			{ID: 0x6055, Name: "3c556 Hurricane CardBus [Cyclone]"},
			{ID: 0x6056, Name: "3c556B CardBus [Tornado]"},
			{ID: 0x6560, Name: "3cCFE656 CardBus [Cyclone]"},
			{ID: 0x6561, Name: "3cCFEM656 10/100 LAN+56K Modem CardBus"},
			{ID: 0x6562, Name: "3cCFEM656B 10/100 LAN+Winmodem CardBus [Cyclone]"},
			{ID: 0x6563, Name: "3cCFEM656B 10/100 LAN+56K Modem CardBus"},
			{ID: 0x6564, Name: "3cXFEM656C 10/100 LAN+Winmodem CardBus [Tornado]"},
			{ID: 0x7646, Name: "3cSOHO100-TX Hurricane"},
			{ID: 0x7770, Name: "3CRWE777 PCI Wireless Adapter [Airconnect]"},
			{ID: 0x7940, Name: "3c803 FDDILink UTP Controller"},
			{ID: 0x7980, Name: "3c804 FDDILink SAS Controller"},
			{ID: 0x7990, Name: "3c805 FDDILink DAS Controller"},
			{ID: 0x80eb, Name: "3c940B 10/100/1000Base-T"},
			{ID: 0x8811, Name: "Token ring"},
			{ID: 0x9000, Name: "3c900 10BaseT [Boomerang]"},
			{ID: 0x9001, Name: "3c900 10Mbps Combo [Boomerang]"},
			{ID: 0x9004, Name: "3c900B-TPO Etherlink XL [Cyclone]"},
			{ID: 0x9005, Name: "3c900B-Combo Etherlink XL [Cyclone]"},
			{ID: 0x9006, Name: "3c900B-TPC Etherlink XL [Cyclone]"},
			{ID: 0x900a, Name: "3c900B-FL 10base-FL [Cyclone]"},
			{ID: 0x9050, Name: "3c905 100BaseTX [Boomerang]"},
			{ID: 0x9051, Name: "3c905 100BaseT4 [Boomerang]"},
			{ID: 0x9054, Name: "3C905B-TX Fast Etherlink XL PCI"},
			{ID: 0x9055, Name: "3c905B 100BaseTX [Cyclone]"},
			{ID: 0x9056, Name: "3c905B-T4 Fast EtherLink XL [Cyclone]"},
			{ID: 0x9058, Name: "3c905B Deluxe Etherlink 10/100/BNC [Cyclone]"},
			{ID: 0x905a, Name: "3c905B-FX Fast Etherlink XL FX 100baseFx [Cyclone]"},
			{ID: 0x9200, Name: "3c905C-TX/TX-M [Tornado]"},
			{ID: 0x9201, Name: "3C920B-EMB Integrated Fast Ethernet Controller [Tornado]"},
			{ID: 0x9202, Name: "3Com 3C920B-EMB-WNM Integrated Fast Ethernet Controller"},
			{ID: 0x9210, Name: "3C920B-EMB-WNM Integrated Fast Ethernet Controller"},
			{ID: 0x9300, Name: "3CSOHO100B-TX 910-A01 [tulip]"},
			{ID: 0x9800, Name: "3c980-TX Fast Etherlink XL Server Adapter [Cyclone]"},
			{ID: 0x9805, Name: "3c980-C 10/100baseTX NIC [Python-T]"},
			{ID: 0x9900, Name: "3C990-TX [Typhoon]"},
			{ID: 0x9902, Name: "3CR990-TX-95 [Typhoon 56-bit]"},
			{ID: 0x9903, Name: "3CR990-TX-97 [Typhoon 168-bit]"},
			{ID: 0x9904, Name: "3C990B-TX-M/3C990BSVR [Typhoon2]"},
			{ID: 0x9905, Name: "3CR990-FX-95/97/95 [Typhon Fiber]"},
			{ID: 0x9908, Name: "3CR990SVR95 [Typhoon Server 56-bit]"},
			{ID: 0x9909, Name: "3CR990SVR97 [Typhoon Server 168-bit]"},
			{ID: 0x990a, Name: "3C990SVR [Typhoon Server]"},
			{ID: 0x990b, Name: "3C990SVR [Typhoon Server]"},
		},
	},
	{
		ID: 0x10b8, Name: "Standard Microsystems Corp [SMC]", Devices: []Device{
			{ID: 0x0005, Name: "83c170 EPIC/100 Fast Ethernet Adapter"},
			{ID: 0x0006, Name: "83c175 EPIC/100 Fast Ethernet Adapter"},
			{ID: 0x1000, Name: "FDC 37c665"},
			{ID: 0x1001, Name: "FDC 37C922"},
			{ID: 0xa011, Name: "83C170QF"},
			{ID: 0xb106, Name: "SMC34C90"},
		},
	},
	{
		ID: 0x10b9, Name: "ULi Electronics Inc.", Devices: []Device{
			{ID: 0x0101, Name: "CMI8338/C3DX PCI Audio Device"},
			{ID: 0x0111, Name: "C-Media CMI8738/C3DX Audio Device (OEM)"},
			{ID: 0x0780, Name: "Multi-IO Card"},
			{ID: 0x0782, Name: "Multi-IO Card"},
			{ID: 0x1435, Name: "M1435"},
			{ID: 0x1445, Name: "M1445"},
			{ID: 0x1449, Name: "M1449"},
			{ID: 0x1451, Name: "M1451"},
			{ID: 0x1461, Name: "M1461"},
			{ID: 0x1489, Name: "M1489 Cache-Memory PCI Controller (CMP) [FinALi 486] CPU to PCI bridge"},
			{ID: 0x1511, Name: "M1511 [Aladdin]"},
			{ID: 0x1512, Name: "M1512 [Aladdin]"},
			{ID: 0x1513, Name: "M1513 [Aladdin]"},
			{ID: 0x1521, Name: "M1521 [Aladdin III]"},
			{ID: 0x1523, Name: "M1523"},
			{ID: 0x1531, Name: "M1531 [Aladdin IV]"},
			{ID: 0x1533, Name: "M1533/M1535/M1543 PCI to ISA Bridge [Aladdin IV/V/V+]"},
			{ID: 0x1541, Name: "M1541"},
			{ID: 0x1543, Name: "M1543"},
			{ID: 0x1563, Name: "M1563 HyperTransport South Bridge"},
			{ID: 0x1573, Name: "PCI to LPC Controller"},
			{ID: 0x1575, Name: "M1575 South Bridge"},
			{ID: 0x1621, Name: "M1621"},
			{ID: 0x1631, Name: "ALI M1631 PCI North Bridge Aladdin Pro III"},
			{ID: 0x1632, Name: "M1632M Northbridge+Trident"},
			{ID: 0x1641, Name: "ALI M1641 PCI North Bridge Aladdin Pro IV"},
			{ID: 0x1644, Name: "M1644/M1644T Northbridge+Trident"},
			{ID: 0x1646, Name: "M1646 Northbridge+Trident"},
			{ID: 0x1647, Name: "M1647 Northbridge [MAGiK 1 / MobileMAGiK 1]"},
			{ID: 0x1651, Name: "M1651/M1651T Northbridge [Aladdin-Pro 5/5M,Aladdin-Pro 5T/5TM]"},
			{ID: 0x1671, Name: "M1671 Super P4 Northbridge [AGP4X,PCI and SDR/DDR]"},
			{ID: 0x1672, Name: "M1672 Northbridge [CyberALADDiN-P4]"},
			{ID: 0x1681, Name: "M1681 P4 Northbridge [AGP8X,HyperTransport and SDR/DDR]"},
			{ID: 0x1687, Name: "M1687 K8 Northbridge [AGP8X and HyperTransport]"},
			{ID: 0x1689, Name: "M1689 K8 Northbridge [Super K8 Single Chip]"},
			{ID: 0x1695, Name: "M1695 Host Bridge"},
			{ID: 0x1697, Name: "M1697 HTT Host Bridge"},
			{ID: 0x3141, Name: "M3141"},
			{ID: 0x3143, Name: "M3143"},
			{ID: 0x3145, Name: "M3145"},
			{ID: 0x3147, Name: "M3147"},
			{ID: 0x3149, Name: "M3149"},
			{ID: 0x3151, Name: "M3151"},
			{ID: 0x3307, Name: "M3307"},
			{ID: 0x3309, Name: "M3309"},
			{ID: 0x3323, Name: "M3325 Video/Audio Decoder"},
			{ID: 0x5212, Name: "M4803"},
			{ID: 0x5215, Name: "MS4803"},
			{ID: 0x5217, Name: "M5217H"},
			{ID: 0x5219, Name: "M5219"},
			{ID: 0x5225, Name: "M5225"},
			{ID: 0x5228, Name: "M5228 ALi ATA/RAID Controller"},
			{ID: 0x5229, Name: "M5229 IDE"},
			{ID: 0x5235, Name: "M5225"},
			{ID: 0x5237, Name: "USB 1.1 Controller"},
			{ID: 0x5239, Name: "USB 2.0 Controller"},
			{ID: 0x5243, Name: "M1541 PCI to AGP Controller"},
			{ID: 0x5246, Name: "AGP8X Controller"},
			{ID: 0x5247, Name: "PCI to AGP Controller"},
			{ID: 0x5249, Name: "M5249 HTT to PCI Bridge"},
			{ID: 0x524b, Name: "PCI Express Root Port"},
			{ID: 0x524c, Name: "PCI Express Root Port"},
			{ID: 0x524d, Name: "PCI Express Root Port"},
			{ID: 0x524e, Name: "PCI Express Root Port"},
			{ID: 0x5251, Name: "M5251 P1394 OHCI 1.0 Controller"},
			{ID: 0x5253, Name: "M5253 P1394 OHCI 1.1 Controller"},
			{ID: 0x5261, Name: "M5261 Ethernet Controller"},
			{ID: 0x5263, Name: "ULi 1689,1573 integrated ethernet."},
			{ID: 0x5281, Name: "ALi M5281 Serial ATA / RAID Host Controller"},
			{ID: 0x5287, Name: "ULi 5287 SATA"},
			{ID: 0x5288, Name: "ULi M5288 SATA"},
			{ID: 0x5289, Name: "ULi 5289 SATA"},
			{ID: 0x5450, Name: "Lucent Technologies Soft Modem AMR"},
			{ID: 0x5451, Name: "M5451 PCI AC-Link Controller Audio Device"},
			{ID: 0x5453, Name: "M5453 PCI AC-Link Controller Modem Device"},
			{ID: 0x5455, Name: "M5455 PCI AC-Link Controller Audio Device"},
			{ID: 0x5457, Name: "M5457 AC'97 Modem Controller"},
			{ID: 0x5459, Name: "SmartLink SmartPCI561 56K Modem"},
			{ID: 0x545a, Name: "SmartLink SmartPCI563 56K Modem"},
			{ID: 0x5461, Name: "HD Audio Controller"},
			{ID: 0x5471, Name: "M5471 Memory Stick Controller"},
			{ID: 0x5473, Name: "M5473 SD-MMC Controller"},
			{ID: 0x7101, Name: "M7101 Power Management Controller [PMU]"},
		},
	},
	{
		ID: 0x10ba, Name: "Mitsubishi Electric Corp.", Devices: []Device{
			{ID: 0x0301, Name: "AccelGraphics AccelECLIPSE"},
			{ID: 0x0304, Name: "AccelGALAXY A2100 [OEM Evans & Sutherland]"},
			{ID: 0x0308, Name: "Tornado 3000 [OEM Evans & Sutherland]"},
			{ID: 0x1002, Name: "VG500 [VolumePro Volume Rendering Accelerator]"},
		},
	},
	{ID: 0x10bb, Name: "Dapha Electronics Corporation", Devices: []Device{}},
	{ID: 0x10bc, Name: "Advanced Logic Research", Devices: []Device{}},
	{
		ID: 0x10bd, Name: "Surecom Technology", Devices: []Device{
			{ID: 0x0e34, Name: "NE-34"},
		},
	},
	{ID: 0x10be, Name: "Tseng Labs International Co.", Devices: []Device{}},
	{ID: 0x10bf, Name: "Most Inc", Devices: []Device{}},
	{ID: 0x10c0, Name: "Boca Research Inc.", Devices: []Device{}},
	{ID: 0x10c1, Name: "ICM Co., Ltd.", Devices: []Device{}},
	{ID: 0x10c2, Name: "Auspex Systems Inc.", Devices: []Device{}},
	{ID: 0x10c3, Name: "Samsung Semiconductors, Inc.", Devices: []Device{}},
	{ID: 0x10c4, Name: "Award Software International Inc.", Devices: []Device{}},
	{ID: 0x10c5, Name: "Xerox Corporation", Devices: []Device{}},
	{ID: 0x10c6, Name: "Rambus Inc.", Devices: []Device{}},
	{ID: 0x10c7, Name: "Media Vision", Devices: []Device{}},
	{
		ID: 0x10c8, Name: "Neomagic Corporation", Devices: []Device{
			{ID: 0x0001, Name: "NM2070 [MagicGraph 128]"},
			{ID: 0x0002, Name: "NM2090 [MagicGraph 128V]"},
			{ID: 0x0003, Name: "NM2093 [MagicGraph 128ZV]"},
			{ID: 0x0004, Name: "NM2160 [MagicGraph 128XD]"},
			{ID: 0x0005, Name: "NM2200 [MagicGraph 256AV]"},
			{ID: 0x0006, Name: "NM2360 [MagicMedia 256ZX]"},
			{ID: 0x0016, Name: "NM2380 [MagicMedia 256XL+]"},
			{ID: 0x0025, Name: "NM2230 [MagicGraph 256AV+]"},
			{ID: 0x0083, Name: "NM2093 [MagicGraph 128ZV+]"},
			{ID: 0x8005, Name: "NM2200 [MagicMedia 256AV Audio]"},
			{ID: 0x8006, Name: "NM2360 [MagicMedia 256ZX Audio]"},
			{ID: 0x8016, Name: "NM2380 [MagicMedia 256XL+ Audio]"},
		},
	},
	{ID: 0x10c9, Name: "Dataexpert Corporation", Devices: []Device{}},
	{ID: 0x10ca, Name: "Fujitsu Microelectr., Inc.", Devices: []Device{}},
	{ID: 0x10cb, Name: "Omron Corporation", Devices: []Device{}},
	{
		ID: 0x10cc, Name: "Mai Logic Incorporated", Devices: []Device{
			{ID: 0x0660, Name: "Articia S Host Bridge"},
			{ID: 0x0661, Name: "Articia S PCI Bridge"},
		},
	},
	{
		ID: 0x10cd, Name: "Advanced System Products, Inc", Devices: []Device{
			{ID: 0x1100, Name: "ASC1100"},
			{ID: 0x1200, Name: "ASC1200 [(abp940) Fast SCSI-II]"},
			{ID: 0x1300, Name: "ASC1300 / ASC3030 [ABP940-U / ABP960-U / ABP3925]"},
			{ID: 0x2300, Name: "ABP940-UW"},
			{ID: 0x2500, Name: "ABP940-U2W"},
			{ID: 0x2700, Name: "ABP3950-U3W"},
		},
	},
	{ID: 0x10ce, Name: "Radius", Devices: []Device{}},
	{
		ID: 0x10cf, Name: "Fujitsu Limited.", Devices: []Device{
			{ID: 0x01ef, Name: "PCEA4 PCI-Express Dual Port ESCON Adapter"},
			{ID: 0x1414, Name: "On-board USB 1.1 companion controller"},
			{ID: 0x1415, Name: "On-board USB 2.0 EHCI controller"},
			{ID: 0x1422, Name: "E8410 nVidia graphics adapter"},
			{ID: 0x142d, Name: "HD audio (Realtek ALC262)"},
			{ID: 0x1430, Name: "82566MM Intel 1Gb copper LAN interface"},
			{ID: 0x1623, Name: "PCEA4 PCI-Express Dual Port ESCON Adapter"},
			{ID: 0x2001, Name: "mb86605"},
			{ID: 0x200c, Name: "MB86613L IEEE1394 OHCI 1.0 Controller"},
			{ID: 0x2010, Name: "MB86613S IEEE1394 OHCI 1.1 Controller"},
			{ID: 0x2019, Name: "MB86295S [CORAL P]"},
			{ID: 0x201e, Name: "MB86296S [CORAL PA]"},
			{ID: 0x202b, Name: "MB86297A [Carmine Graphics Controller]"},
		},
	},
	{ID: 0x10d1, Name: "FuturePlus Systems Corp.", Devices: []Device{}},
	{ID: 0x10d2, Name: "Molex Incorporated", Devices: []Device{}},
	{ID: 0x10d3, Name: "Jabil Circuit Inc", Devices: []Device{}},
	{ID: 0x10d4, Name: "Hualon Microelectronics", Devices: []Device{}},
	{ID: 0x10d5, Name: "Autologic Inc.", Devices: []Device{}},
	{ID: 0x10d6, Name: "Cetia", Devices: []Device{}},
	{ID: 0x10d7, Name: "BCM Advanced Research", Devices: []Device{}},
	{ID: 0x10d8, Name: "Advanced Peripherals Labs", Devices: []Device{}},
	{
		ID: 0x10d9, Name: "Macronix, Inc. [MXIC]", Devices: []Device{
			{ID: 0x0431, Name: "MX98715"},
			{ID: 0x0512, Name: "MX98713"},
			{ID: 0x0531, Name: "MX987x5"},
			{ID: 0x8625, Name: "MX86250"},
			{ID: 0x8626, Name: "Macronix MX86251 + 3Dfx Voodoo Rush"},
			{ID: 0x8888, Name: "MX86200"},
		},
	},
	{
		ID: 0x10da, Name: "Compaq IPG-Austin", Devices: []Device{
			{ID: 0x0508, Name: "TC4048 Token Ring 4/16"},
			{ID: 0x3390, Name: "Tl3c3x9"},
		},
	},
	{ID: 0x10db, Name: "Rohm LSI Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x10dc, Name: "CERN/ECP/EDU", Devices: []Device{
			{ID: 0x0001, Name: "STAR/RD24 SCI-PCI (PMC)"},
			{ID: 0x0002, Name: "TAR/RD24 SCI-PCI (PMC)"},
			{ID: 0x0021, Name: "HIPPI destination"},
			{ID: 0x0022, Name: "HIPPI source"},
			{ID: 0x10dc, Name: "ATT2C15-3 FPGA"},
		},
	},
	{
		ID: 0x10dd, Name: "Evans & Sutherland", Devices: []Device{
			{ID: 0x0100, Name: "Lightning 1200"},
		},
	},
	{
		ID: 0x10de, Name: "NVIDIA Corporation", Devices: []Device{
			{ID: 0x0008, Name: "NV1 [STG2000X-B Series]"},
			{ID: 0x0009, Name: "NV1 [NV1 Series]"},
			{ID: 0x0018, Name: "NV3 [Riva 128]"},
			{ID: 0x0019, Name: "NV3 [Riva 128ZX]"},
			{ID: 0x0020, Name: "NV4 [Riva TNT]"},
			{ID: 0x0028, Name: "NV5 [Riva TNT2 / TNT2 Pro]"},
			{ID: 0x0029, Name: "NV5 [Riva TNT2 Ultra]"},
			{ID: 0x002a, Name: "NV5 [Riva TNT2]"},
			{ID: 0x002b, Name: "NV5 [Riva TNT2]"},
			{ID: 0x002c, Name: "NV5 [Vanta / Vanta LT]"},
			{ID: 0x002d, Name: "NV5 [Riva TNT2 Model 64 / Model 64 Pro]"},
			{ID: 0x0034, Name: "MCP04 SMBus"},
			{ID: 0x0035, Name: "MCP04 IDE"},
			{ID: 0x0036, Name: "MCP04 Serial ATA Controller"},
			{ID: 0x0037, Name: "MCP04 Ethernet Controller"},
			{ID: 0x0038, Name: "MCP04 Ethernet Controller"},
			{ID: 0x003a, Name: "MCP04 AC'97 Audio Controller"},
			{ID: 0x003b, Name: "MCP04 USB Controller"},
			{ID: 0x003c, Name: "MCP04 USB Controller"},
			{ID: 0x003d, Name: "MCP04 PCI Bridge"},
			{ID: 0x003e, Name: "MCP04 Serial ATA Controller"},
			{ID: 0x0040, Name: "NV40 [GeForce 6800 Ultra]"},
			{ID: 0x0041, Name: "NV40 [GeForce 6800]"},
			{ID: 0x0042, Name: "NV40 [GeForce 6800 LE]"},
			{ID: 0x0043, Name: "NV40 [GeForce 6800 XE]"},
			{ID: 0x0044, Name: "NV40 [GeForce 6800 XT]"},
			{ID: 0x0045, Name: "NV40 [GeForce 6800 GT]"},
			{ID: 0x0047, Name: "NV40 [GeForce 6800 GS]"},
			{ID: 0x0048, Name: "NV40 [GeForce 6800 XT]"},
			{ID: 0x004e, Name: "NV40GL [Quadro FX 4000]"},
			{ID: 0x0050, Name: "CK804 ISA Bridge"},
			{ID: 0x0051, Name: "CK804 ISA Bridge"},
			{ID: 0x0052, Name: "CK804 SMBus"},
			{ID: 0x0053, Name: "CK804 IDE"},
			{ID: 0x0054, Name: "CK804 Serial ATA Controller"},
			{ID: 0x0055, Name: "CK804 Serial ATA Controller"},
			{ID: 0x0056, Name: "CK804 Ethernet Controller"},
			{ID: 0x0057, Name: "CK804 Ethernet Controller"},
			{ID: 0x0058, Name: "CK804 AC'97 Modem"},
			{ID: 0x0059, Name: "CK804 AC'97 Audio Controller"},
			{ID: 0x005a, Name: "CK804 USB Controller"},
			{ID: 0x005b, Name: "CK804 USB Controller"},
			{ID: 0x005c, Name: "CK804 PCI Bridge"},
			{ID: 0x005d, Name: "CK804 PCIE Bridge"},
			{ID: 0x005e, Name: "CK804 Memory Controller"},
			{ID: 0x005f, Name: "CK804 Memory Controller"},
			{ID: 0x0060, Name: "nForce2 ISA Bridge"},
			{ID: 0x0064, Name: "nForce2 SMBus (MCP)"},
			{ID: 0x0065, Name: "nForce2 IDE"},
			{ID: 0x0066, Name: "nForce2 Ethernet Controller"},
			{ID: 0x0067, Name: "nForce2 USB Controller"},
			{ID: 0x0068, Name: "nForce2 USB Controller"},
			{ID: 0x006a, Name: "nForce2 AC97 Audio Controler (MCP)"},
			{ID: 0x006b, Name: "nForce Audio Processing Unit"},
			{ID: 0x006c, Name: "nForce2 External PCI Bridge"},
			{ID: 0x006d, Name: "nForce2 PCI Bridge"},
			{ID: 0x006e, Name: "nForce2 FireWire (IEEE 1394) Controller"},
			{ID: 0x0080, Name: "MCP2A ISA bridge"},
			{ID: 0x0084, Name: "MCP2A SMBus"},
			{ID: 0x0085, Name: "MCP2A IDE"},
			{ID: 0x0086, Name: "MCP2A Ethernet Controller"},
			{ID: 0x0087, Name: "MCP2A USB Controller"},
			{ID: 0x0088, Name: "MCP2A USB Controller"},
			{ID: 0x008a, Name: "MCP2S AC'97 Audio Controller"},
			{ID: 0x008b, Name: "MCP2A PCI Bridge"},
			{ID: 0x008c, Name: "MCP2A Ethernet Controller"},
			{ID: 0x008e, Name: "nForce2 Serial ATA Controller"},
			{ID: 0x0090, Name: "G70 [GeForce 7800 GTX]"},
			{ID: 0x0091, Name: "G70 [GeForce 7800 GTX]"},
			{ID: 0x0092, Name: "G70 [GeForce 7800 GT]"},
			{ID: 0x0093, Name: "G70 [GeForce 7800 GS]"},
			{ID: 0x0095, Name: "G70 [GeForce 7800 SLI]"},
			{ID: 0x0097, Name: "G70 [GeForce GTS 250]"},
			{ID: 0x0098, Name: "G70M [GeForce Go 7800]"},
			{ID: 0x0099, Name: "G70M [GeForce Go 7800 GTX]"},
			{ID: 0x009d, Name: "G70GL [Quadro FX 4500]"},
			{ID: 0x00a0, Name: "NV0A [Aladdin TNT2 IGP]"},
			{ID: 0x00c0, Name: "NV41 [GeForce 6800 GS]"},
			{ID: 0x00c1, Name: "NV41 [GeForce 6800]"},
			{ID: 0x00c2, Name: "NV41 [GeForce 6800 LE]"},
			{ID: 0x00c3, Name: "NV41 [GeForce 6800 XT]"},
			{ID: 0x00c5, Name: "NV41"},
			{ID: 0x00c6, Name: "NV41"},
			{ID: 0x00c7, Name: "NV41"},
			{ID: 0x00c8, Name: "NV41M [GeForce Go 6800]"},
			{ID: 0x00c9, Name: "NV41M [GeForce Go 6800 Ultra]"},
			{ID: 0x00cc, Name: "NV41GLM [Quadro FX Go1400]"},
			{ID: 0x00cd, Name: "NV42GL [Quadro FX 3450/4000 SDI]"},
			{ID: 0x00ce, Name: "NV41GL [Quadro FX 1400]"},
			{ID: 0x00cf, Name: "NV41"},
			{ID: 0x00d0, Name: "nForce3 LPC Bridge"},
			{ID: 0x00d1, Name: "nForce3 Host Bridge"},
			{ID: 0x00d2, Name: "nForce3 AGP Bridge"},
			{ID: 0x00d3, Name: "CK804 Memory Controller"},
			{ID: 0x00d4, Name: "nForce3 SMBus"},
			{ID: 0x00d5, Name: "nForce3 IDE"},
			{ID: 0x00d6, Name: "nForce3 Ethernet"},
			{ID: 0x00d7, Name: "nForce3 USB 1.1"},
			{ID: 0x00d8, Name: "nForce3 USB 2.0"},
			{ID: 0x00d9, Name: "nForce3 Audio"},
			{ID: 0x00da, Name: "nForce3 Audio"},
			{ID: 0x00dd, Name: "nForce3 PCI Bridge"},
			{ID: 0x00df, Name: "CK8S Ethernet Controller"},
			{ID: 0x00e0, Name: "nForce3 250Gb LPC Bridge"},
			{ID: 0x00e1, Name: "nForce3 250Gb Host Bridge"},
			{ID: 0x00e2, Name: "nForce3 250Gb AGP Host to PCI Bridge"},
			{ID: 0x00e3, Name: "nForce3 Serial ATA Controller"},
			{ID: 0x00e4, Name: "nForce 250Gb PCI System Management"},
			{ID: 0x00e5, Name: "CK8S Parallel ATA Controller (v2.5)"},
			{ID: 0x00e6, Name: "CK8S Ethernet Controller"},
			{ID: 0x00e7, Name: "CK8S USB Controller"},
			{ID: 0x00e8, Name: "nForce3 EHCI USB 2.0 Controller"},
			{ID: 0x00ea, Name: "nForce3 250Gb AC'97 Audio Controller"},
			{ID: 0x00ed, Name: "nForce3 250Gb PCI-to-PCI Bridge"},
			{ID: 0x00ee, Name: "nForce3 Serial ATA Controller 2"},
			{ID: 0x00f1, Name: "NV43 [GeForce 6600 GT]"},
			{ID: 0x00f2, Name: "NV43 [GeForce 6600]"},
			{ID: 0x00f3, Name: "NV43 [GeForce 6200]"},
			{ID: 0x00f4, Name: "NV43 [GeForce 6600 LE]"},
			{ID: 0x00f5, Name: "G70/G71 [GeForce 7800 GS AGP]"},
			{ID: 0x00f6, Name: "NV43 [GeForce 6800 GS/XT]"},
			{ID: 0x00f8, Name: "NV45GL [Quadro FX 3400/4400]"},
			{ID: 0x00f9, Name: "NV40 [GeForce 6800 GT/GTO/Ultra]"},
			{ID: 0x00fa, Name: "NV39 [GeForce PCX 5750]"},
			{ID: 0x00fb, Name: "NV35 [GeForce PCX 5900]"},
			{ID: 0x00fc, Name: "NV37GL [Quadro FX 330/GeForce PCX 5300]"},
			{ID: 0x00fd, Name: "NV37GL [Quadro PCI-E Series]"},
			{ID: 0x00fe, Name: "NV38GL [Quadro FX 1300]"},
			{ID: 0x00ff, Name: "NV19 [GeForce PCX 4300]"},
			{ID: 0x0100, Name: "NV10 [GeForce 256 SDR]"},
			{ID: 0x0101, Name: "NV10 [GeForce 256 DDR]"},
			{ID: 0x0103, Name: "NV10GL [Quadro]"},
			{ID: 0x0110, Name: "NV11 [GeForce2 MX/MX 400]"},
			{ID: 0x0111, Name: "NV11 [GeForce2 MX200]"},
			{ID: 0x0112, Name: "NV11M [GeForce2 Go]"},
			{ID: 0x0113, Name: "NV11GL [Quadro2 MXR/EX/Go]"},
			{ID: 0x0140, Name: "NV43 [GeForce 6600 GT]"},
			{ID: 0x0141, Name: "NV43 [GeForce 6600]"},
			{ID: 0x0142, Name: "NV43 [GeForce 6600 LE]"},
			{ID: 0x0143, Name: "NV43 [GeForce 6600 VE]"},
			{ID: 0x0144, Name: "NV43M [GeForce Go 6600]"},
			{ID: 0x0145, Name: "NV43 [GeForce 6610 XL]"},
			{ID: 0x0146, Name: "NV43M [GeForce Go6200 TE / 6600 TE]"},
			{ID: 0x0147, Name: "NV43 [GeForce 6700 XL]"},
			{ID: 0x0148, Name: "NV43M [GeForce Go 6600]"},
			{ID: 0x0149, Name: "NV43M [GeForce Go 6600 GT]"},
			{ID: 0x014a, Name: "NV43 [Quadro NVS 440]"},
			{ID: 0x014b, Name: "NV43"},
			{ID: 0x014d, Name: "NV43GL [Quadro FX 550]"},
			{ID: 0x014e, Name: "NV43GL [Quadro FX 540]"},
			{ID: 0x014f, Name: "NV43 [GeForce 6200]"},
			{ID: 0x0150, Name: "NV15 [GeForce2 GTS/Pro]"},
			{ID: 0x0151, Name: "NV15 [GeForce2 Ti]"},
			{ID: 0x0152, Name: "NV15 [GeForce2 Ultra]"},
			{ID: 0x0153, Name: "NV15GL [Quadro2 Pro]"},
			{ID: 0x0160, Name: "NV44 [GeForce 6500]"},
			{ID: 0x0161, Name: "NV44 [GeForce 6200 TurboCache]"},
			{ID: 0x0162, Name: "NV44 [GeForce 6200 SE TurboCache]"},
			{ID: 0x0163, Name: "NV44 [GeForce 6200 LE]"},
			{ID: 0x0164, Name: "NV44M [GeForce Go 6200]"},
			{ID: 0x0165, Name: "NV44 [Quadro NVS 285]"},
			{ID: 0x0166, Name: "NV44M [GeForce Go 6400]"},
			{ID: 0x0167, Name: "NV44M [GeForce Go 6200]"},
			{ID: 0x0168, Name: "NV44M [GeForce Go 6400]"},
			{ID: 0x0169, Name: "NV44 [GeForce 6250]"},
			{ID: 0x016a, Name: "NV44 [GeForce 7100 GS]"},
			{ID: 0x016d, Name: "NV44"},
			{ID: 0x016e, Name: "NV44"},
			{ID: 0x016f, Name: "NV44"},
			{ID: 0x0170, Name: "NV17 [GeForce4 MX 460]"},
			{ID: 0x0171, Name: "NV17 [GeForce4 MX 440]"},
			{ID: 0x0172, Name: "NV17 [GeForce4 MX 420]"},
			{ID: 0x0173, Name: "NV17 [GeForce4 MX 440-SE]"},
			{ID: 0x0174, Name: "NV17M [GeForce4 440 Go]"},
			{ID: 0x0175, Name: "NV17M [GeForce4 420 Go]"},
			{ID: 0x0176, Name: "NV17M [GeForce4 420 Go 32M]"},
			{ID: 0x0177, Name: "NV17M [GeForce4 460 Go]"},
			{ID: 0x0178, Name: "NV17GL [Quadro4 550 XGL]"},
			{ID: 0x0179, Name: "NV17M [GeForce4 440 Go 64M]"},
			{ID: 0x017a, Name: "NV17GL [Quadro NVS]"},
			{ID: 0x017b, Name: "NV17GL [Quadro4 550 XGL]"},
			{ID: 0x017c, Name: "NV17GL [Quadro4 500 GoGL]"},
			{ID: 0x017f, Name: "NV17"},
			{ID: 0x0181, Name: "NV18 [GeForce4 MX 440 AGP 8x]"},
			{ID: 0x0182, Name: "NV18 [GeForce4 MX 440SE AGP 8x]"},
			{ID: 0x0183, Name: "NV18 [GeForce4 MX 420 AGP 8x]"},
			{ID: 0x0184, Name: "NV18 [GeForce4 MX]"},
			{ID: 0x0185, Name: "NV18 [GeForce4 MX 4000]"},
			{ID: 0x0186, Name: "NV18M [GeForce4 448 Go]"},
			{ID: 0x0187, Name: "NV18M [GeForce4 488 Go]"},
			{ID: 0x0188, Name: "NV18GL [Quadro4 580 XGL]"},
			{ID: 0x0189, Name: "NV18 [GeForce4 MX with AGP8X (Mac)]"},
			{ID: 0x018a, Name: "NV18GL [Quadro NVS 280 SD]"},
			{ID: 0x018b, Name: "NV18GL [Quadro4 380 XGL]"},
			{ID: 0x018c, Name: "NV18GL [Quadro NVS 50 PCI]"},
			{ID: 0x018d, Name: "NV18M [GeForce4 448 Go]"},
			{ID: 0x0190, Name: "G80 [GeForce 8800 GTS / 8800 GTX]"},
			{ID: 0x0191, Name: "G80 [GeForce 8800 GTX]"},
			{ID: 0x0192, Name: "G80 [GeForce 8800 GTS]"},
			{ID: 0x0193, Name: "G80 [GeForce 8800 GTS]"},
			{ID: 0x0194, Name: "G80 [GeForce 8800 Ultra]"},
			{ID: 0x0197, Name: "G80GL [Tesla C870]"},
			{ID: 0x019d, Name: "G80GL [Quadro FX 5600]"},
			{ID: 0x019e, Name: "G80GL [Quadro FX 4600]"},
			{ID: 0x01a0, Name: "nForce 220/420 NV1A [GeForce2 MX]"},
			{ID: 0x01a4, Name: "nForce CPU bridge"},
			{ID: 0x01ab, Name: "nForce 420 Memory Controller (DDR)"},
			{ID: 0x01ac, Name: "nForce 220/420 Memory Controller"},
			{ID: 0x01ad, Name: "nForce 220/420 Memory Controller"},
			{ID: 0x01b0, Name: "nForce Audio Processing Unit"},
			{ID: 0x01b1, Name: "nForce AC'97 Audio Controller"},
			{ID: 0x01b2, Name: "nForce ISA Bridge"},
			{ID: 0x01b4, Name: "nForce PCI System Management"},
			{ID: 0x01b7, Name: "nForce AGP to PCI Bridge"},
			{ID: 0x01b8, Name: "nForce PCI-to-PCI bridge"},
			{ID: 0x01bc, Name: "nForce IDE"},
			{ID: 0x01c1, Name: "nForce AC'97 Modem Controller"},
			{ID: 0x01c2, Name: "nForce USB Controller"},
			{ID: 0x01c3, Name: "nForce Ethernet Controller"},
			{ID: 0x01d0, Name: "G72 [GeForce 7350 LE]"},
			{ID: 0x01d1, Name: "G72 [GeForce 7300 LE]"},
			{ID: 0x01d2, Name: "G72 [GeForce 7550 LE]"},
			{ID: 0x01d3, Name: "G72 [GeForce 7200 GS / 7300 SE]"},
			{ID: 0x01d5, Name: "G72"},
			{ID: 0x01d6, Name: "G72M [GeForce Go 7200]"},
			{ID: 0x01d7, Name: "G72M [Quadro NVS 110M/GeForce Go 7300]"},
			{ID: 0x01d8, Name: "G72M [GeForce Go 7400]"},
			{ID: 0x01d9, Name: "G72M [GeForce Go 7450]"},
			{ID: 0x01da, Name: "G72M [Quadro NVS 110M]"},
			{ID: 0x01db, Name: "G72M [Quadro NVS 120M]"},
			{ID: 0x01dc, Name: "G72GLM [Quadro FX 350M]"},
			{ID: 0x01dd, Name: "G72 [GeForce 7500 LE]"},
			{ID: 0x01de, Name: "G72GL [Quadro FX 350]"},
			{ID: 0x01df, Name: "G72 [GeForce 7300 GS]"},
			{ID: 0x01e0, Name: "nForce2 IGP2"},
			{ID: 0x01e8, Name: "nForce2 AGP"},
			{ID: 0x01ea, Name: "nForce2 Memory Controller 0"},
			{ID: 0x01eb, Name: "nForce2 Memory Controller 1"},
			{ID: 0x01ec, Name: "nForce2 Memory Controller 2"},
			{ID: 0x01ed, Name: "nForce2 Memory Controller 3"},
			{ID: 0x01ee, Name: "nForce2 Memory Controller 4"},
			{ID: 0x01ef, Name: "nForce2 Memory Controller 5"},
			{ID: 0x01f0, Name: "NV1F C17 [GeForce4 MX IGP]"},
			{ID: 0x0200, Name: "NV20 [GeForce3]"},
			{ID: 0x0201, Name: "NV20 [GeForce3 Ti 200]"},
			{ID: 0x0202, Name: "NV20 [GeForce3 Ti 500]"},
			{ID: 0x0203, Name: "NV20GL [Quadro DCC]"},
			{ID: 0x0211, Name: "NV48 [GeForce 6800]"},
			{ID: 0x0212, Name: "NV48 [GeForce 6800 LE]"},
			{ID: 0x0215, Name: "NV48 [GeForce 6800 GT]"},
			{ID: 0x0218, Name: "NV48 [GeForce 6800 XT]"},
			{ID: 0x0221, Name: "NV44A [GeForce 6200]"},
			{ID: 0x0222, Name: "NV44 [GeForce 6200 A-LE]"},
			{ID: 0x0224, Name: "NV44"},
			{ID: 0x0240, Name: "C51PV [GeForce 6150]"},
			{ID: 0x0241, Name: "C51 [GeForce 6150 LE]"},
			{ID: 0x0242, Name: "C51G [GeForce 6100]"},
			{ID: 0x0243, Name: "C51 PCI Express Bridge"},
			{ID: 0x0244, Name: "C51 [GeForce Go 6150]"},
			{ID: 0x0245, Name: "C51 [Quadro NVS 210S/GeForce 6150LE]"},
			{ID: 0x0246, Name: "C51 PCI Express Bridge"},
			{ID: 0x0247, Name: "C51 [GeForce Go 6100]"},
			{ID: 0x0248, Name: "C51 PCI Express Bridge"},
			{ID: 0x0249, Name: "C51 PCI Express Bridge"},
			{ID: 0x024a, Name: "C51 PCI Express Bridge"},
			{ID: 0x024b, Name: "C51 PCI Express Bridge"},
			{ID: 0x024c, Name: "C51 PCI Express Bridge"},
			{ID: 0x024d, Name: "C51 PCI Express Bridge"},
			{ID: 0x024e, Name: "C51 PCI Express Bridge"},
			{ID: 0x024f, Name: "C51 PCI Express Bridge"},
			{ID: 0x0250, Name: "NV25 [GeForce4 Ti 4600]"},
			{ID: 0x0251, Name: "NV25 [GeForce4 Ti 4400]"},
			{ID: 0x0252, Name: "NV25 [GeForce4 Ti]"},
			{ID: 0x0253, Name: "NV25 [GeForce4 Ti 4200]"},
			{ID: 0x0258, Name: "NV25GL [Quadro4 900 XGL]"},
			{ID: 0x0259, Name: "NV25GL [Quadro4 750 XGL]"},
			{ID: 0x025b, Name: "NV25GL [Quadro4 700 XGL]"},
			{ID: 0x0260, Name: "MCP51 LPC Bridge"},
			{ID: 0x0261, Name: "MCP51 LPC Bridge"},
			{ID: 0x0262, Name: "MCP51 LPC Bridge"},
			{ID: 0x0263, Name: "MCP51 LPC Bridge"},
			{ID: 0x0264, Name: "MCP51 SMBus"},
			{ID: 0x0265, Name: "MCP51 IDE"},
			{ID: 0x0266, Name: "MCP51 Serial ATA Controller"},
			{ID: 0x0267, Name: "MCP51 Serial ATA Controller"},
			{ID: 0x0268, Name: "MCP51 Ethernet Controller"},
			{ID: 0x0269, Name: "MCP51 Ethernet Controller"},
			{ID: 0x026a, Name: "MCP51 MCI"},
			{ID: 0x026b, Name: "MCP51 AC97 Audio Controller"},
			{ID: 0x026c, Name: "MCP51 High Definition Audio"},
			{ID: 0x026d, Name: "MCP51 USB Controller"},
			{ID: 0x026e, Name: "MCP51 USB Controller"},
			{ID: 0x026f, Name: "MCP51 PCI Bridge"},
			{ID: 0x0270, Name: "MCP51 Host Bridge"},
			{ID: 0x0271, Name: "MCP51 PMU"},
			{ID: 0x0272, Name: "MCP51 Memory Controller 0"},
			{ID: 0x027e, Name: "C51 Memory Controller 2"},
			{ID: 0x027f, Name: "C51 Memory Controller 3"},
			{ID: 0x0280, Name: "NV28 [GeForce4 Ti 4800]"},
			{ID: 0x0281, Name: "NV28 [GeForce4 Ti 4200 AGP 8x]"},
			{ID: 0x0282, Name: "NV28 [GeForce4 Ti 4800 SE]"},
			{ID: 0x0286, Name: "NV28M [GeForce4 Ti 4200 Go AGP 8x]"},
			{ID: 0x0288, Name: "NV28GL [Quadro4 980 XGL]"},
			{ID: 0x0289, Name: "NV28GL [Quadro4 780 XGL]"},
			{ID: 0x028c, Name: "NV28GLM [Quadro4 Go700]"},
			{ID: 0x0290, Name: "G71 [GeForce 7900 GTX]"},
			{ID: 0x0291, Name: "G71 [GeForce 7900 GT/GTO]"},
			{ID: 0x0292, Name: "G71 [GeForce 7900 GS]"},
			{ID: 0x0293, Name: "G71 [GeForce 7900 GX2]"},
			{ID: 0x0294, Name: "G71 [GeForce 7950 GX2]"},
			{ID: 0x0295, Name: "G71 [GeForce 7950 GT]"},
			{ID: 0x0297, Name: "G71M [GeForce Go 7950 GTX]"},
			{ID: 0x0298, Name: "G71M [GeForce Go 7900 GS]"},
			{ID: 0x0299, Name: "G71M [GeForce Go 7900 GTX]"},
			{ID: 0x029a, Name: "G71GLM [Quadro FX 2500M]"},
			{ID: 0x029b, Name: "G71GLM [Quadro FX 1500M]"},
			{ID: 0x029c, Name: "G71GL [Quadro FX 5500]"},
			{ID: 0x029d, Name: "G71GL [Quadro FX 3500]"},
			{ID: 0x029e, Name: "G71GL [Quadro FX 1500]"},
			{ID: 0x029f, Name: "G71GL [Quadro FX 4500 X2]"},
			{ID: 0x02a0, Name: "NV2A [XGPU]"},
			{ID: 0x02a5, Name: "MCPX CPU Bridge"},
			{ID: 0x02a6, Name: "MCPX Memory Controller"},
			{ID: 0x02e0, Name: "G73 [GeForce 7600 GT AGP]"},
			{ID: 0x02e1, Name: "G73 [GeForce 7600 GS AGP]"},
			{ID: 0x02e2, Name: "G73 [GeForce 7300 GT AGP]"},
			{ID: 0x02e3, Name: "G71 [GeForce 7900 GS AGP]"},
			{ID: 0x02e4, Name: "G71 [GeForce 7950 GT AGP]"},
			{ID: 0x02e5, Name: "G71 [GeForce 7600 GS AGP]"},
			{ID: 0x02f0, Name: "C51 Host Bridge"},
			{ID: 0x02f1, Name: "C51 Host Bridge"},
			{ID: 0x02f2, Name: "C51 Host Bridge"},
			{ID: 0x02f3, Name: "C51 Host Bridge"},
			{ID: 0x02f4, Name: "C51 Host Bridge"},
			{ID: 0x02f5, Name: "C51 Host Bridge"},
			{ID: 0x02f6, Name: "C51 Host Bridge"},
			{ID: 0x02f7, Name: "C51 Host Bridge"},
			{ID: 0x02f8, Name: "C51 Memory Controller 5"},
			{ID: 0x02f9, Name: "C51 Memory Controller 4"},
			{ID: 0x02fa, Name: "C51 Memory Controller 0"},
			{ID: 0x02fb, Name: "C51 PCI Express Bridge"},
			{ID: 0x02fc, Name: "C51 PCI Express Bridge"},
			{ID: 0x02fd, Name: "C51 PCI Express Bridge"},
			{ID: 0x02fe, Name: "C51 Memory Controller 1"},
			{ID: 0x02ff, Name: "C51 Host Bridge"},
			{ID: 0x0300, Name: "NV30 [GeForce FX]"},
			{ID: 0x0301, Name: "NV30 [GeForce FX 5800 Ultra]"},
			{ID: 0x0302, Name: "NV30 [GeForce FX 5800]"},
			{ID: 0x0308, Name: "NV30GL [Quadro FX 2000]"},
			{ID: 0x0309, Name: "NV30GL [Quadro FX 1000]"},
			{ID: 0x0311, Name: "NV31 [GeForce FX 5600 Ultra]"},
			{ID: 0x0312, Name: "NV31 [GeForce FX 5600]"},
			{ID: 0x0314, Name: "NV31 [GeForce FX 5600XT]"},
			{ID: 0x0316, Name: "NV31M"},
			{ID: 0x0318, Name: "NV31GL"},
			{ID: 0x031a, Name: "NV31M [GeForce FX Go5600]"},
			{ID: 0x031b, Name: "NV31M [GeForce FX Go5650]"},
			{ID: 0x031c, Name: "NV31GLM [Quadro FX Go700]"},
			{ID: 0x0320, Name: "NV34 [GeForce FX 5200]"},
			{ID: 0x0321, Name: "NV34 [GeForce FX 5200 Ultra]"},
			{ID: 0x0322, Name: "NV34 [GeForce FX 5200]"},
			{ID: 0x0323, Name: "NV34 [GeForce FX 5200LE]"},
			{ID: 0x0324, Name: "NV34M [GeForce FX Go5200 64M]"},
			{ID: 0x0325, Name: "NV34M [GeForce FX Go5250]"},
			{ID: 0x0326, Name: "NV34 [GeForce FX 5500]"},
			{ID: 0x0327, Name: "NV34 [GeForce FX 5100]"},
			{ID: 0x0328, Name: "NV34M [GeForce FX Go5200 32M/64M]"},
			{ID: 0x0329, Name: "NV34M [GeForce FX Go5200]"},
			{ID: 0x032a, Name: "NV34GL [Quadro NVS 280 PCI]"},
			{ID: 0x032b, Name: "NV34GL [Quadro FX 500/600 PCI]"},
			{ID: 0x032c, Name: "NV34M [GeForce FX Go5300 / Go5350]"},
			{ID: 0x032d, Name: "NV34M [GeForce FX Go5100]"},
			{ID: 0x032e, Name: "NV34"},
			{ID: 0x032f, Name: "NV34 [GeForce FX 5200]"},
			{ID: 0x0330, Name: "NV35 [GeForce FX 5900 Ultra]"},
			{ID: 0x0331, Name: "NV35 [GeForce FX 5900]"},
			{ID: 0x0332, Name: "NV35 [GeForce FX 5900XT]"},
			{ID: 0x0333, Name: "NV38 [GeForce FX 5950 Ultra]"},
			{ID: 0x0334, Name: "NV35 [GeForce FX 5900ZT]"},
			{ID: 0x0338, Name: "NV35GL [Quadro FX 3000]"},
			{ID: 0x033f, Name: "NV35GL [Quadro FX 700]"},
			{ID: 0x0341, Name: "NV36 [GeForce FX 5700 Ultra]"},
			{ID: 0x0342, Name: "NV36 [GeForce FX 5700]"},
			{ID: 0x0343, Name: "NV36 [GeForce FX 5700LE]"},
			{ID: 0x0344, Name: "NV36 [GeForce FX 5700VE]"},
			{ID: 0x0347, Name: "NV36M [GeForce FX Go5700]"},
			{ID: 0x0348, Name: "NV36M [GeForce FX Go5700]"},
			{ID: 0x034c, Name: "NV36 [Quadro FX Go1000]"},
			{ID: 0x034d, Name: "NV36"},
			{ID: 0x034e, Name: "NV36GL [Quadro FX 1100]"},
			{ID: 0x0360, Name: "MCP55 LPC Bridge"},
			{ID: 0x0361, Name: "MCP55 LPC Bridge"},
			{ID: 0x0362, Name: "MCP55 LPC Bridge"},
			{ID: 0x0363, Name: "MCP55 LPC Bridge"},
			{ID: 0x0364, Name: "MCP55 LPC Bridge"},
			{ID: 0x0365, Name: "MCP55 LPC Bridge"},
			{ID: 0x0366, Name: "MCP55 LPC Bridge"},
			{ID: 0x0367, Name: "MCP55 LPC Bridge"},
			{ID: 0x0368, Name: "MCP55 SMBus Controller"},
			{ID: 0x0369, Name: "MCP55 Memory Controller"},
			{ID: 0x036a, Name: "MCP55 Memory Controller"},
			{ID: 0x036b, Name: "MCP55 SMU"},
			{ID: 0x036c, Name: "MCP55 USB Controller"},
			{ID: 0x036d, Name: "MCP55 USB Controller"},
			{ID: 0x036e, Name: "MCP55 IDE"},
			{ID: 0x0370, Name: "MCP55 PCI bridge"},
			{ID: 0x0371, Name: "MCP55 High Definition Audio"},
			{ID: 0x0372, Name: "MCP55 Ethernet"},
			{ID: 0x0373, Name: "MCP55 Ethernet"},
			{ID: 0x0374, Name: "MCP55 PCI Express bridge"},
			{ID: 0x0375, Name: "MCP55 PCI Express bridge"},
			{ID: 0x0376, Name: "MCP55 PCI Express bridge"},
			{ID: 0x0377, Name: "MCP55 PCI Express bridge"},
			{ID: 0x0378, Name: "MCP55 PCI Express bridge"},
			{ID: 0x037a, Name: "MCP55 Memory Controller"},
			{ID: 0x037e, Name: "MCP55 SATA Controller"},
			{ID: 0x037f, Name: "MCP55 SATA Controller"},
			{ID: 0x038b, Name: "G73 [GeForce 7650 GS]"},
			{ID: 0x0390, Name: "G73 [GeForce 7650 GS]"},
			{ID: 0x0391, Name: "G73 [GeForce 7600 GT]"},
			{ID: 0x0392, Name: "G73 [GeForce 7600 GS]"},
			{ID: 0x0393, Name: "G73 [GeForce 7300 GT]"},
			{ID: 0x0394, Name: "G73 [GeForce 7600 LE]"},
			{ID: 0x0395, Name: "G73 [GeForce 7300 GT]"},
			{ID: 0x0396, Name: "G73"},
			{ID: 0x0397, Name: "G73M [GeForce Go 7700]"},
			{ID: 0x0398, Name: "G73M [GeForce Go 7600]"},
			{ID: 0x0399, Name: "G73M [GeForce Go 7600 GT]"},
			{ID: 0x039a, Name: "G73M [Quadro NVS 300M]"},
			{ID: 0x039b, Name: "G73M [GeForce Go 7900 SE]"},
			{ID: 0x039c, Name: "G73GLM [Quadro FX 550M]"},
			{ID: 0x039d, Name: "G73"},
			{ID: 0x039e, Name: "G73GL [Quadro FX 560]"},
			{ID: 0x039f, Name: "G73"},
			{ID: 0x03a0, Name: "C55 Host Bridge"},
			{ID: 0x03a1, Name: "C55 Host Bridge"},
			{ID: 0x03a2, Name: "C55 Host Bridge"},
			{ID: 0x03a3, Name: "C55 Host Bridge"},
			{ID: 0x03a4, Name: "C55 Host Bridge"},
			{ID: 0x03a5, Name: "C55 Host Bridge"},
			{ID: 0x03a6, Name: "C55 Host Bridge"},
			{ID: 0x03a7, Name: "C55 Host Bridge"},
			{ID: 0x03a8, Name: "C55 Memory Controller"},
			{ID: 0x03a9, Name: "C55 Memory Controller"},
			{ID: 0x03aa, Name: "C55 Memory Controller"},
			{ID: 0x03ab, Name: "C55 Memory Controller"},
			{ID: 0x03ac, Name: "C55 Memory Controller"},
			{ID: 0x03ad, Name: "C55 Memory Controller"},
			{ID: 0x03ae, Name: "C55 Memory Controller"},
			{ID: 0x03af, Name: "C55 Memory Controller"},
			{ID: 0x03b0, Name: "C55 Memory Controller"},
			{ID: 0x03b1, Name: "C55 Memory Controller"},
			{ID: 0x03b2, Name: "C55 Memory Controller"},
			{ID: 0x03b3, Name: "C55 Memory Controller"},
			{ID: 0x03b4, Name: "C55 Memory Controller"},
			{ID: 0x03b5, Name: "C55 Memory Controller"},
			{ID: 0x03b6, Name: "C55 Memory Controller"},
			{ID: 0x03b7, Name: "C55 PCI Express bridge"},
			{ID: 0x03b8, Name: "C55 PCI Express bridge"},
			{ID: 0x03b9, Name: "C55 PCI Express bridge"},
			{ID: 0x03ba, Name: "C55 Memory Controller"},
			{ID: 0x03bb, Name: "C55 PCI Express bridge"},
			{ID: 0x03bc, Name: "C55 Memory Controller"},
			{ID: 0x03d0, Name: "C61 [GeForce 6150SE nForce 430]"},
			{ID: 0x03d1, Name: "C61 [GeForce 6100 nForce 405]"},
			{ID: 0x03d2, Name: "C61 [GeForce 6100 nForce 400]"},
			{ID: 0x03d5, Name: "C61 [GeForce 6100 nForce 420]"},
			{ID: 0x03d6, Name: "C61 [GeForce 7025 / nForce 630a]"},
			{ID: 0x03e0, Name: "MCP61 LPC Bridge"},
			{ID: 0x03e1, Name: "MCP61 LPC Bridge"},
			{ID: 0x03e2, Name: "MCP61 Host Bridge"},
			{ID: 0x03e3, Name: "MCP61 LPC Bridge"},
			{ID: 0x03e4, Name: "MCP61 High Definition Audio"},
			{ID: 0x03e5, Name: "MCP61 Ethernet"},
			{ID: 0x03e6, Name: "MCP61 Ethernet"},
			{ID: 0x03e7, Name: "MCP61 SATA Controller"},
			{ID: 0x03e8, Name: "MCP61 PCI Express bridge"},
			{ID: 0x03e9, Name: "MCP61 PCI Express bridge"},
			{ID: 0x03ea, Name: "MCP61 Memory Controller"},
			{ID: 0x03eb, Name: "MCP61 SMBus"},
			{ID: 0x03ec, Name: "MCP61 IDE"},
			{ID: 0x03ee, Name: "MCP61 Ethernet"},
			{ID: 0x03ef, Name: "MCP61 Ethernet"},
			{ID: 0x03f0, Name: "MCP61 High Definition Audio"},
			{ID: 0x03f1, Name: "MCP61 USB 1.1 Controller"},
			{ID: 0x03f2, Name: "MCP61 USB 2.0 Controller"},
			{ID: 0x03f3, Name: "MCP61 PCI bridge"},
			{ID: 0x03f4, Name: "MCP61 SMU"},
			{ID: 0x03f5, Name: "MCP61 Memory Controller"},
			{ID: 0x03f6, Name: "MCP61 SATA Controller"},
			{ID: 0x03f7, Name: "MCP61 SATA Controller"},
			{ID: 0x0400, Name: "G84 [GeForce 8600 GTS]"},
			{ID: 0x0401, Name: "G84 [GeForce 8600 GT]"},
			{ID: 0x0402, Name: "G84 [GeForce 8600 GT]"},
			{ID: 0x0403, Name: "G84 [GeForce 8600 GS]"},
			{ID: 0x0404, Name: "G84 [GeForce 8400 GS]"},
			{ID: 0x0405, Name: "G84M [GeForce 9500M GS]"},
			{ID: 0x0406, Name: "G84 [GeForce 8300 GS]"},
			{ID: 0x0407, Name: "G84M [GeForce 8600M GT]"},
			{ID: 0x0408, Name: "G84M [GeForce 9650M GS]"},
			{ID: 0x0409, Name: "G84M [GeForce 8700M GT]"},
			{ID: 0x040a, Name: "G84GL [Quadro FX 370]"},
			{ID: 0x040b, Name: "G84GLM [Quadro NVS 320M]"},
			{ID: 0x040c, Name: "G84GLM [Quadro FX 570M]"},
			{ID: 0x040d, Name: "G84GLM [Quadro FX 1600M]"},
			{ID: 0x040e, Name: "G84GL [Quadro FX 570]"},
			{ID: 0x040f, Name: "G84GL [Quadro FX 1700]"},
			{ID: 0x0410, Name: "G92 [GeForce GT 330]"},
			{ID: 0x0414, Name: "G92 [GeForce 9800 GT]"},
			{ID: 0x0418, Name: "G92 [GeForce GT 330 OEM]"},
			{ID: 0x0420, Name: "G86 [GeForce 8400 SE]"},
			{ID: 0x0421, Name: "G86 [GeForce 8500 GT]"},
			{ID: 0x0422, Name: "G86 [GeForce 8400 GS]"},
			{ID: 0x0423, Name: "G86 [GeForce 8300 GS]"},
			{ID: 0x0424, Name: "G86 [GeForce 8400 GS]"},
			{ID: 0x0425, Name: "G86M [GeForce 8600M GS]"},
			{ID: 0x0426, Name: "G86M [GeForce 8400M GT]"},
			{ID: 0x0427, Name: "G86M [GeForce 8400M GS]"},
			{ID: 0x0428, Name: "G86M [GeForce 8400M G]"},
			{ID: 0x0429, Name: "G86M [Quadro NVS 140M]"},
			{ID: 0x042a, Name: "G86M [Quadro NVS 130M]"},
			{ID: 0x042b, Name: "G86M [Quadro NVS 135M]"},
			{ID: 0x042c, Name: "G86 [GeForce 9400 GT]"},
			{ID: 0x042d, Name: "G86GLM [Quadro FX 360M]"},
			{ID: 0x042e, Name: "G86M [GeForce 9300M G]"},
			{ID: 0x042f, Name: "G86 [Quadro NVS 290]"},
			{ID: 0x0440, Name: "MCP65 LPC Bridge"},
			{ID: 0x0441, Name: "MCP65 LPC Bridge"},
			{ID: 0x0442, Name: "MCP65 LPC Bridge"},
			{ID: 0x0443, Name: "MCP65 LPC Bridge"},
			{ID: 0x0444, Name: "MCP65 Memory Controller"},
			{ID: 0x0445, Name: "MCP65 Memory Controller"},
			{ID: 0x0446, Name: "MCP65 SMBus"},
			{ID: 0x0447, Name: "MCP65 SMU"},
			{ID: 0x0448, Name: "MCP65 IDE"},
			{ID: 0x0449, Name: "MCP65 PCI bridge"},
			{ID: 0x044a, Name: "MCP65 High Definition Audio"},
			{ID: 0x044b, Name: "MCP65 High Definition Audio"},
			{ID: 0x044c, Name: "MCP65 AHCI Controller"},
			{ID: 0x044d, Name: "MCP65 AHCI Controller"},
			{ID: 0x044e, Name: "MCP65 AHCI Controller"},
			{ID: 0x044f, Name: "MCP65 AHCI Controller"},
			{ID: 0x0450, Name: "MCP65 Ethernet"},
			{ID: 0x0451, Name: "MCP65 Ethernet"},
			{ID: 0x0452, Name: "MCP65 Ethernet"},
			{ID: 0x0453, Name: "MCP65 Ethernet"},
			{ID: 0x0454, Name: "MCP65 USB 1.1 OHCI Controller"},
			{ID: 0x0455, Name: "MCP65 USB 2.0 EHCI Controller"},
			{ID: 0x0456, Name: "MCP65 USB Controller"},
			{ID: 0x0457, Name: "MCP65 USB Controller"},
			{ID: 0x0458, Name: "MCP65 PCI Express bridge"},
			{ID: 0x0459, Name: "MCP65 PCI Express bridge"},
			{ID: 0x045a, Name: "MCP65 PCI Express bridge"},
			{ID: 0x045b, Name: "MCP65 PCI Express bridge"},
			{ID: 0x045c, Name: "MCP65 SATA Controller"},
			{ID: 0x045d, Name: "MCP65 SATA Controller"},
			{ID: 0x045e, Name: "MCP65 SATA Controller"},
			{ID: 0x045f, Name: "MCP65 SATA Controller"},
			{ID: 0x0531, Name: "C67 [GeForce 7150M / nForce 630M]"},
			{ID: 0x0533, Name: "C67 [GeForce 7000M / nForce 610M]"},
			{ID: 0x053a, Name: "C68 [GeForce 7050 PV / nForce 630a]"},
			{ID: 0x053b, Name: "C68 [GeForce 7050 PV / nForce 630a]"},
			{ID: 0x053e, Name: "C68 [GeForce 7025 / nForce 630a]"},
			{ID: 0x0541, Name: "MCP67 Memory Controller"},
			{ID: 0x0542, Name: "MCP67 SMBus"},
			{ID: 0x0543, Name: "MCP67 Co-processor"},
			{ID: 0x0547, Name: "MCP67 Memory Controller"},
			{ID: 0x0548, Name: "MCP67 ISA Bridge"},
			{ID: 0x054c, Name: "MCP67 Ethernet"},
			{ID: 0x054d, Name: "MCP67 Ethernet"},
			{ID: 0x054e, Name: "MCP67 Ethernet"},
			{ID: 0x054f, Name: "MCP67 Ethernet"},
			{ID: 0x0550, Name: "MCP67 AHCI Controller"},
			{ID: 0x0554, Name: "MCP67 AHCI Controller"},
			{ID: 0x0555, Name: "MCP67 SATA Controller"},
			{ID: 0x055c, Name: "MCP67 High Definition Audio"},
			{ID: 0x055d, Name: "MCP67 High Definition Audio"},
			{ID: 0x055e, Name: "MCP67 OHCI USB 1.1 Controller"},
			{ID: 0x055f, Name: "MCP67 EHCI USB 2.0 Controller"},
			{ID: 0x0560, Name: "MCP67 IDE Controller"},
			{ID: 0x0561, Name: "MCP67 PCI Bridge"},
			{ID: 0x0562, Name: "MCP67 PCI Express Bridge"},
			{ID: 0x0563, Name: "MCP67 PCI Express Bridge"},
			{ID: 0x0568, Name: "MCP78S [GeForce 8200] Memory Controller"},
			{ID: 0x0569, Name: "MCP78S [GeForce 8200] PCI Express Bridge"},
			{ID: 0x056a, Name: "MCP73 [nForce 630i] USB 2.0 Controller (EHCI)"},
			{ID: 0x056c, Name: "MCP73 IDE Controller"},
			{ID: 0x056d, Name: "MCP73 PCI Express bridge"},
			{ID: 0x056e, Name: "MCP73 PCI Express bridge"},
			{ID: 0x056f, Name: "MCP73 PCI Express bridge"},
			{ID: 0x05b1, Name: "NF200 PCIe 2.0 switch"},
			{ID: 0x05b8, Name: "NF200 PCIe 2.0 switch for GTX 295"},
			{ID: 0x05be, Name: "NF200 PCIe 2.0 switch for Quadro Plex S4 / Tesla S870 / Tesla S1070 / Tesla S2050"},
			{ID: 0x05e0, Name: "GT200b [GeForce GTX 295]"},
			{ID: 0x05e1, Name: "GT200 [GeForce GTX 280]"},
			{ID: 0x05e2, Name: "GT200 [GeForce GTX 260]"},
			{ID: 0x05e3, Name: "GT200b [GeForce GTX 285]"},
			{ID: 0x05e6, Name: "GT200b [GeForce GTX 275]"},
			{ID: 0x05e7, Name: "GT200GL [Tesla C1060 / M1060]"},
			{ID: 0x05ea, Name: "GT200 [GeForce GTX 260]"},
			{ID: 0x05eb, Name: "GT200 [GeForce GTX 295]"},
			{ID: 0x05ed, Name: "GT200GL [Quadro Plex 2200 D2]"},
			{ID: 0x05f1, Name: "GT200 [GeForce GTX 280]"},
			{ID: 0x05f2, Name: "GT200 [GeForce GTX 260]"},
			{ID: 0x05f8, Name: "GT200GL [Quadro Plex 2200 S4]"},
			{ID: 0x05f9, Name: "GT200GL [Quadro CX]"},
			{ID: 0x05fd, Name: "GT200GL [Quadro FX 5800]"},
			{ID: 0x05fe, Name: "GT200GL [Quadro FX 4800]"},
			{ID: 0x05ff, Name: "GT200GL [Quadro FX 3800]"},
			{ID: 0x0600, Name: "G92 [GeForce 8800 GTS 512]"},
			{ID: 0x0601, Name: "G92 [GeForce 9800 GT]"},
			{ID: 0x0602, Name: "G92 [GeForce 8800 GT]"},
			{ID: 0x0603, Name: "G92 [GeForce GT 230 OEM]"},
			{ID: 0x0604, Name: "G92 [GeForce 9800 GX2]"},
			{ID: 0x0605, Name: "G92 [GeForce 9800 GT]"},
			{ID: 0x0606, Name: "G92 [GeForce 8800 GS]"},
			{ID: 0x0607, Name: "G92 [GeForce GTS 240]"},
			{ID: 0x0608, Name: "G92M [GeForce 9800M GTX]"},
			{ID: 0x0609, Name: "G92M [GeForce 8800M GTS]"},
			{ID: 0x060a, Name: "G92M [GeForce GTX 280M]"},
			{ID: 0x060b, Name: "G92M [GeForce 9800M GT]"},
			{ID: 0x060c, Name: "G92M [GeForce 8800M GTX]"},
			{ID: 0x060d, Name: "G92 [GeForce 8800 GS]"},
			{ID: 0x060f, Name: "G92M [GeForce GTX 285M]"},
			{ID: 0x0610, Name: "G92 [GeForce 9600 GSO]"},
			{ID: 0x0611, Name: "G92 [GeForce 8800 GT]"},
			{ID: 0x0612, Name: "G92 [GeForce 9800 GTX / 9800 GTX+]"},
			{ID: 0x0613, Name: "G92 [GeForce 9800 GTX+]"},
			{ID: 0x0614, Name: "G92 [GeForce 9800 GT]"},
			{ID: 0x0615, Name: "G92 [GeForce GTS 250]"},
			{ID: 0x0617, Name: "G92M [GeForce 9800M GTX]"},
			{ID: 0x0618, Name: "G92M [GeForce GTX 260M]"},
			{ID: 0x0619, Name: "G92GL [Quadro FX 4700 X2]"},
			{ID: 0x061a, Name: "G92GL [Quadro FX 3700]"},
			{ID: 0x061b, Name: "G92GL [Quadro VX 200]"},
			{ID: 0x061c, Name: "G92GLM [Quadro FX 3600M]"},
			{ID: 0x061d, Name: "G92GLM [Quadro FX 2800M]"},
			{ID: 0x061e, Name: "G92GLM [Quadro FX 3700M]"},
			{ID: 0x061f, Name: "G92GLM [Quadro FX 3800M]"},
			{ID: 0x0620, Name: "G94 [GeForce 9800 GT]"},
			{ID: 0x0621, Name: "G94 [GeForce GT 230]"},
			{ID: 0x0622, Name: "G94 [GeForce 9600 GT]"},
			{ID: 0x0623, Name: "G94 [GeForce 9600 GS]"},
			{ID: 0x0624, Name: "G94 [GeForce 9600 GT Green Edition]"},
			{ID: 0x0625, Name: "G94 [GeForce 9600 GSO 512]"},
			{ID: 0x0626, Name: "G94 [GeForce GT 130]"},
			{ID: 0x0627, Name: "G94 [GeForce GT 140]"},
			{ID: 0x0628, Name: "G94M [GeForce 9800M GTS]"},
			{ID: 0x062a, Name: "G94M [GeForce 9700M GTS]"},
			{ID: 0x062b, Name: "G94M [GeForce 9800M GS]"},
			{ID: 0x062c, Name: "G94M [GeForce 9800M GTS]"},
			{ID: 0x062d, Name: "G94 [GeForce 9600 GT]"},
			{ID: 0x062e, Name: "G94 [GeForce 9600 GT]"},
			{ID: 0x062f, Name: "G94 [GeForce 9800 S]"},
			{ID: 0x0630, Name: "G94 [GeForce 9600 GT]"},
			{ID: 0x0631, Name: "G94M [GeForce GTS 160M]"},
			{ID: 0x0632, Name: "G94M [GeForce GTS 150M]"},
			{ID: 0x0633, Name: "G94 [GeForce GT 220]"},
			{ID: 0x0635, Name: "G94 [GeForce 9600 GSO]"},
			{ID: 0x0637, Name: "G94 [GeForce 9600 GT]"},
			{ID: 0x0638, Name: "G94GL [Quadro FX 1800]"},
			{ID: 0x063a, Name: "G94GLM [Quadro FX 2700M]"},
			{ID: 0x063f, Name: "G94 [GeForce 9600 GE]"},
			{ID: 0x0640, Name: "G96C [GeForce 9500 GT]"},
			{ID: 0x0641, Name: "G96C [GeForce 9400 GT]"},
			{ID: 0x0642, Name: "G96 [D9M-10]"},
			{ID: 0x0643, Name: "G96 [GeForce 9500 GT]"},
			{ID: 0x0644, Name: "G96 [GeForce 9500 GS]"},
			{ID: 0x0645, Name: "G96C [GeForce 9500 GS]"},
			{ID: 0x0646, Name: "G96C [GeForce GT 120]"},
			{ID: 0x0647, Name: "G96CM [GeForce 9600M GT]"},
			{ID: 0x0648, Name: "G96CM [GeForce 9600M GS]"},
			{ID: 0x0649, Name: "G96CM [GeForce 9600M GT]"},
			{ID: 0x064a, Name: "G96M [GeForce 9700M GT]"},
			{ID: 0x064b, Name: "G96M [GeForce 9500M G]"},
			{ID: 0x064c, Name: "G96CM [GeForce 9650M GT]"},
			{ID: 0x064e, Name: "G96C [GeForce 9600 GSO / 9800 GT]"},
			{ID: 0x0651, Name: "G96CM [GeForce G 110M]"},
			{ID: 0x0652, Name: "G96CM [GeForce GT 130M]"},
			{ID: 0x0653, Name: "G96CM [GeForce GT 120M]"},
			{ID: 0x0654, Name: "G96CM [GeForce GT 220M]"},
			{ID: 0x0655, Name: "G96 [GeForce GT 120 Mac Edition]"},
			{ID: 0x0656, Name: "G96 [GeForce GT 120 Mac Edition]"},
			{ID: 0x0658, Name: "G96GL [Quadro FX 380]"},
			{ID: 0x0659, Name: "G96CGL [Quadro FX 580]"},
			{ID: 0x065a, Name: "G96GLM [Quadro FX 1700M]"},
			{ID: 0x065b, Name: "G96C [GeForce 9400 GT]"},
			{ID: 0x065c, Name: "G96GLM [Quadro FX 770M]"},
			{ID: 0x065d, Name: "G96 [GeForce 9500 GA / 9600 GT / GTS 250]"},
			{ID: 0x065f, Name: "G96C [GeForce G210]"},
			{ID: 0x06c0, Name: "GF100 [GeForce GTX 480]"},
			{ID: 0x06c4, Name: "GF100 [GeForce GTX 465]"},
			{ID: 0x06ca, Name: "GF100M [GeForce GTX 480M]"},
			{ID: 0x06cb, Name: "GF100 [GeForce GTX 480]"},
			{ID: 0x06cd, Name: "GF100 [GeForce GTX 470]"},
			{ID: 0x06d0, Name: "GF100GL"},
			{ID: 0x06d1, Name: "GF100GL [Tesla C2050 / C2070]"},
			{ID: 0x06d2, Name: "GF100GL [Tesla M2070]"},
			{ID: 0x06d8, Name: "GF100GL [Quadro 6000]"},
			{ID: 0x06d9, Name: "GF100GL [Quadro 5000]"},
			{ID: 0x06da, Name: "GF100GLM [Quadro 5000M]"},
			{ID: 0x06dc, Name: "GF100GL [Quadro 6000]"},
			{ID: 0x06dd, Name: "GF100GL [Quadro 4000]"},
			{ID: 0x06de, Name: "GF100GL [Tesla T20 Processor]"},
			{ID: 0x06df, Name: "GF100GL [Tesla M2070-Q]"},
			{ID: 0x06e0, Name: "G98 [GeForce 9300 GE]"},
			{ID: 0x06e1, Name: "G98 [GeForce 9300 GS]"},
			{ID: 0x06e2, Name: "G98 [GeForce 8400]"},
			{ID: 0x06e3, Name: "G98 [GeForce 8300 GS]"},
			{ID: 0x06e4, Name: "G98 [GeForce 8400 GS Rev. 2]"},
			{ID: 0x06e5, Name: "G98M [GeForce 9300M GS]"},
			{ID: 0x06e6, Name: "G98 [GeForce G 100]"},
			{ID: 0x06e7, Name: "G98 [GeForce 9300 SE]"},
			{ID: 0x06e8, Name: "G98M [GeForce 9200M GS]"},
			{ID: 0x06e9, Name: "G98M [GeForce 9300M GS]"},
			{ID: 0x06ea, Name: "G98M [Quadro NVS 150M]"},
			{ID: 0x06eb, Name: "G98M [Quadro NVS 160M]"},
			{ID: 0x06ec, Name: "G98M [GeForce G 105M]"},
			{ID: 0x06ed, Name: "G98 [GeForce 9600 GT / 9800 GT]"},
			{ID: 0x06ee, Name: "G98 [GeForce 9600 GT / 9800 GT / GT 240]"},
			{ID: 0x06ef, Name: "G98M [GeForce G 103M]"},
			{ID: 0x06f1, Name: "G98M [GeForce G 105M]"},
			{ID: 0x06f8, Name: "G98 [Quadro NVS 420]"},
			{ID: 0x06f9, Name: "G98GL [Quadro FX 370 LP]"},
			{ID: 0x06fa, Name: "G98 [Quadro NVS 450]"},
			{ID: 0x06fb, Name: "G98GLM [Quadro FX 370M]"},
			{ID: 0x06fd, Name: "G98 [Quadro NVS 295]"},
			{ID: 0x06ff, Name: "G98 [HICx16 + Graphics]"},
			{ID: 0x0751, Name: "MCP78S [GeForce 8200] Memory Controller"},
			{ID: 0x0752, Name: "MCP78S [GeForce 8200] SMBus"},
			{ID: 0x0753, Name: "MCP78S [GeForce 8200] Co-Processor"},
			{ID: 0x0754, Name: "MCP78S [GeForce 8200] Memory Controller"},
			{ID: 0x0759, Name: "MCP78S [GeForce 8200] IDE"},
			{ID: 0x075a, Name: "MCP78S [GeForce 8200] PCI Bridge"},
			{ID: 0x075b, Name: "MCP78S [GeForce 8200] PCI Express Bridge"},
			{ID: 0x075c, Name: "MCP78S [GeForce 8200] LPC Bridge"},
			{ID: 0x075d, Name: "MCP78S [GeForce 8200] LPC Bridge"},
			{ID: 0x0760, Name: "MCP77 Ethernet"},
			{ID: 0x0761, Name: "MCP77 Ethernet"},
			{ID: 0x0762, Name: "MCP77 Ethernet"},
			{ID: 0x0763, Name: "MCP77 Ethernet"},
			{ID: 0x0774, Name: "MCP72XE/MCP72P/MCP78U/MCP78S High Definition Audio"},
			{ID: 0x0778, Name: "MCP78S [GeForce 8200] PCI Express Bridge"},
			{ID: 0x077a, Name: "MCP78S [GeForce 8200] PCI Bridge"},
			{ID: 0x077b, Name: "MCP78S [GeForce 8200] OHCI USB 1.1 Controller"},
			{ID: 0x077c, Name: "MCP78S [GeForce 8200] EHCI USB 2.0 Controller"},
			{ID: 0x077d, Name: "MCP78S [GeForce 8200] OHCI USB 1.1 Controller"},
			{ID: 0x077e, Name: "MCP78S [GeForce 8200] EHCI USB 2.0 Controller"},
			{ID: 0x07c0, Name: "MCP73 Host Bridge"},
			{ID: 0x07c1, Name: "MCP73 Host Bridge"},
			{ID: 0x07c2, Name: "MCP73 Host Bridge"},
			{ID: 0x07c3, Name: "MCP73 Host Bridge"},
			{ID: 0x07c5, Name: "MCP73 Host Bridge"},
			{ID: 0x07c8, Name: "MCP73 Memory Controller"},
			{ID: 0x07cb, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07cd, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07ce, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07cf, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07d0, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07d1, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07d2, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07d3, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07d6, Name: "nForce 610i/630i memory controller"},
			{ID: 0x07d7, Name: "MCP73 LPC Bridge"},
			{ID: 0x07d8, Name: "MCP73 SMBus"},
			{ID: 0x07d9, Name: "MCP73 Memory Controller"},
			{ID: 0x07da, Name: "MCP73 Co-processor"},
			{ID: 0x07dc, Name: "MCP73 Ethernet"},
			{ID: 0x07dd, Name: "MCP73 Ethernet"},
			{ID: 0x07de, Name: "MCP73 Ethernet"},
			{ID: 0x07df, Name: "MCP73 Ethernet"},
			{ID: 0x07e0, Name: "C73 [GeForce 7150 / nForce 630i]"},
			{ID: 0x07e1, Name: "C73 [GeForce 7100 / nForce 630i]"},
			{ID: 0x07e2, Name: "C73 [GeForce 7050 / nForce 630i]"},
			{ID: 0x07e3, Name: "C73 [GeForce 7050 / nForce 610i]"},
			{ID: 0x07e5, Name: "C73 [GeForce 7100 / nForce 620i]"},
			{ID: 0x07f0, Name: "MCP73 SATA Controller (IDE mode)"},
			{ID: 0x07f4, Name: "GeForce 7100/nForce 630i SATA"},
			{ID: 0x07f8, Name: "MCP73 SATA RAID Controller"},
			{ID: 0x07fc, Name: "MCP73 High Definition Audio"},
			{ID: 0x07fe, Name: "MCP73 OHCI USB 1.1 Controller"},
			{ID: 0x0840, Name: "C77 [GeForce 8200M]"},
			{ID: 0x0844, Name: "C77 [GeForce 9100M G]"},
			{ID: 0x0845, Name: "C77 [GeForce 8200M G]"},
			{ID: 0x0846, Name: "C77 [GeForce 9200]"},
			{ID: 0x0847, Name: "C78 [GeForce 9100]"},
			{ID: 0x0848, Name: "C77 [GeForce 8300]"},
			{ID: 0x0849, Name: "C77 [GeForce 8200]"},
			{ID: 0x084a, Name: "C77 [nForce 730a]"},
			{ID: 0x084b, Name: "C77 [GeForce 8200]"},
			{ID: 0x084c, Name: "C77 [nForce 780a/980a SLI]"},
			{ID: 0x084d, Name: "C77 [nForce 750a SLI]"},
			{ID: 0x084f, Name: "C77 [GeForce 8100 / nForce 720a]"},
			{ID: 0x0860, Name: "C79 [GeForce 9300]"},
			{ID: 0x0861, Name: "C79 [GeForce 9400]"},
			{ID: 0x0862, Name: "C79 [GeForce 9400M G]"},
			{ID: 0x0863, Name: "C79 [GeForce 9400M]"},
			{ID: 0x0864, Name: "C79 [GeForce 9300]"},
			{ID: 0x0865, Name: "C79 [GeForce 9300 / ION]"},
			{ID: 0x0866, Name: "C79 [GeForce 9400M G]"},
			{ID: 0x0867, Name: "C79 [GeForce 9400]"},
			{ID: 0x0868, Name: "C79 [nForce 760i SLI]"},
			{ID: 0x0869, Name: "MCP7A [GeForce 9400]"},
			{ID: 0x086a, Name: "C79 [GeForce 9400]"},
			{ID: 0x086c, Name: "C79 [GeForce 9300 / nForce 730i]"},
			{ID: 0x086d, Name: "C79 [GeForce 9200]"},
			{ID: 0x086e, Name: "C79 [GeForce 9100M G]"},
			{ID: 0x086f, Name: "MCP79 [GeForce 8200M G]"},
			{ID: 0x0870, Name: "C79 [GeForce 9400M]"},
			{ID: 0x0871, Name: "C79 [GeForce 9200]"},
			{ID: 0x0872, Name: "C79 [GeForce G102M]"},
			{ID: 0x0873, Name: "C79 [GeForce G102M]"},
			{ID: 0x0874, Name: "C79 [ION]"},
			{ID: 0x0876, Name: "C79 [GeForce 9400M / ION]"},
			{ID: 0x087a, Name: "C79 [GeForce 9400]"},
			{ID: 0x087d, Name: "C79 [ION]"},
			{ID: 0x087e, Name: "C79 [ION LE]"},
			{ID: 0x087f, Name: "C79 [ION LE]"},
			{ID: 0x08a0, Name: "MCP89 [GeForce 320M]"},
			{ID: 0x08a2, Name: "MCP89 [GeForce 320M]"},
			{ID: 0x08a3, Name: "MCP89 [GeForce 320M]"},
			{ID: 0x08a4, Name: "MCP89 [GeForce 320M]"},
			{ID: 0x08a5, Name: "MCP89 [GeForce 320M]"},
			{ID: 0x0a20, Name: "GT216 [GeForce GT 220]"},
			{ID: 0x0a21, Name: "GT216M [GeForce GT 330M]"},
			{ID: 0x0a22, Name: "GT216 [GeForce 315]"},
			{ID: 0x0a23, Name: "GT216 [GeForce 210]"},
			{ID: 0x0a24, Name: "GT216 [GeForce 405]"},
			{ID: 0x0a26, Name: "GT216 [GeForce 405]"},
			{ID: 0x0a27, Name: "GT216 [GeForce 405]"},
			{ID: 0x0a28, Name: "GT216M [GeForce GT 230M]"},
			{ID: 0x0a29, Name: "GT216M [GeForce GT 330M]"},
			{ID: 0x0a2a, Name: "GT216M [GeForce GT 230M]"},
			{ID: 0x0a2b, Name: "GT216M [GeForce GT 330M]"},
			{ID: 0x0a2c, Name: "GT216M [NVS 5100M]"},
			{ID: 0x0a2d, Name: "GT216M [GeForce GT 320M]"},
			{ID: 0x0a30, Name: "GT216 [GeForce 505]"},
			{ID: 0x0a32, Name: "GT216 [GeForce GT 415]"},
			{ID: 0x0a34, Name: "GT216M [GeForce GT 240M]"},
			{ID: 0x0a35, Name: "GT216M [GeForce GT 325M]"},
			{ID: 0x0a38, Name: "GT216GL [Quadro 400]"},
			{ID: 0x0a3c, Name: "GT216GLM [Quadro FX 880M]"},
			{ID: 0x0a60, Name: "GT218 [GeForce G210]"},
			{ID: 0x0a62, Name: "GT218 [GeForce 205]"},
			{ID: 0x0a63, Name: "GT218 [GeForce 310]"},
			{ID: 0x0a64, Name: "GT218 [ION]"},
			{ID: 0x0a65, Name: "GT218 [GeForce 210]"},
			{ID: 0x0a66, Name: "GT218 [GeForce 310]"},
			{ID: 0x0a67, Name: "GT218 [GeForce 315]"},
			{ID: 0x0a68, Name: "GT218M [GeForce G 105M]"},
			{ID: 0x0a69, Name: "GT218M [GeForce G 105M]"},
			{ID: 0x0a6a, Name: "GT218M [NVS 2100M]"},
			{ID: 0x0a6c, Name: "GT218M [NVS 3100M]"},
			{ID: 0x0a6e, Name: "GT218M [GeForce 305M]"},
			{ID: 0x0a6f, Name: "GT218M [ION]"},
			{ID: 0x0a70, Name: "GT218M [GeForce 310M]"},
			{ID: 0x0a71, Name: "GT218M [GeForce 305M]"},
			{ID: 0x0a72, Name: "GT218M [GeForce 310M]"},
			{ID: 0x0a73, Name: "GT218M [GeForce 305M]"},
			{ID: 0x0a74, Name: "GT218M [GeForce G210M]"},
			{ID: 0x0a75, Name: "GT218M [GeForce 310M]"},
			{ID: 0x0a76, Name: "GT218M [ION 2]"},
			{ID: 0x0a78, Name: "GT218GL [Quadro FX 380 LP]"},
			{ID: 0x0a7a, Name: "GT218M [GeForce 315M]"},
			{ID: 0x0a7b, Name: "GT218 [GeForce 505]"},
			{ID: 0x0a7c, Name: "GT218GLM [Quadro FX 380M]"},
			{ID: 0x0a80, Name: "MCP79 Host Bridge"},
			{ID: 0x0a81, Name: "MCP79 Host Bridge"},
			{ID: 0x0a82, Name: "MCP79 Host Bridge"},
			{ID: 0x0a83, Name: "MCP79 Host Bridge"},
			{ID: 0x0a84, Name: "MCP79 Host Bridge"},
			{ID: 0x0a85, Name: "MCP79 Host Bridge"},
			{ID: 0x0a86, Name: "MCP79 Host Bridge"},
			{ID: 0x0a87, Name: "MCP79 Host Bridge"},
			{ID: 0x0a88, Name: "MCP79 Memory Controller"},
			{ID: 0x0a89, Name: "MCP79 Memory Controller"},
			{ID: 0x0a98, Name: "MCP79 Memory Controller"},
			{ID: 0x0aa0, Name: "MCP79 PCI Express Bridge"},
			{ID: 0x0aa2, Name: "MCP79 SMBus"},
			{ID: 0x0aa3, Name: "MCP79 Co-processor"},
			{ID: 0x0aa4, Name: "MCP79 Memory Controller"},
			{ID: 0x0aa5, Name: "MCP79 OHCI USB 1.1 Controller"},
			{ID: 0x0aa6, Name: "MCP79 EHCI USB 2.0 Controller"},
			{ID: 0x0aa7, Name: "MCP79 OHCI USB 1.1 Controller"},
			{ID: 0x0aa8, Name: "MCP79 OHCI USB 1.1 Controller"},
			{ID: 0x0aa9, Name: "MCP79 EHCI USB 2.0 Controller"},
			{ID: 0x0aaa, Name: "MCP79 EHCI USB 2.0 Controller"},
			{ID: 0x0aab, Name: "MCP79 PCI Bridge"},
			{ID: 0x0aac, Name: "MCP79 LPC Bridge"},
			{ID: 0x0aad, Name: "MCP79 LPC Bridge"},
			{ID: 0x0aae, Name: "MCP79 LPC Bridge"},
			{ID: 0x0aaf, Name: "MCP79 LPC Bridge"},
			{ID: 0x0ab0, Name: "MCP79 Ethernet"},
			{ID: 0x0ab1, Name: "MCP79 Ethernet"},
			{ID: 0x0ab2, Name: "MCP79 Ethernet"},
			{ID: 0x0ab3, Name: "MCP79 Ethernet"},
			{ID: 0x0ab4, Name: "MCP79 SATA Controller"},
			{ID: 0x0ab5, Name: "MCP79 SATA Controller"},
			{ID: 0x0ab6, Name: "MCP79 SATA Controller"},
			{ID: 0x0ab7, Name: "MCP79 SATA Controller"},
			{ID: 0x0ab8, Name: "MCP79 AHCI Controller"},
			{ID: 0x0ab9, Name: "MCP79 AHCI Controller"},
			{ID: 0x0aba, Name: "MCP79 AHCI Controller"},
			{ID: 0x0abb, Name: "MCP79 AHCI Controller"},
			{ID: 0x0abc, Name: "MCP79 RAID Controller"},
			{ID: 0x0abd, Name: "MCP79 RAID Controller"},
			{ID: 0x0abe, Name: "MCP79 RAID Controller"},
			{ID: 0x0abf, Name: "MCP79 RAID Controller"},
			{ID: 0x0ac0, Name: "MCP79 High Definition Audio"},
			{ID: 0x0ac1, Name: "MCP79 High Definition Audio"},
			{ID: 0x0ac2, Name: "MCP79 High Definition Audio"},
			{ID: 0x0ac3, Name: "MCP79 High Definition Audio"},
			{ID: 0x0ac4, Name: "MCP79 PCI Express Bridge"},
			{ID: 0x0ac5, Name: "MCP79 PCI Express Bridge"},
			{ID: 0x0ac6, Name: "MCP79 PCI Express Bridge"},
			{ID: 0x0ac7, Name: "MCP79 PCI Express Bridge"},
			{ID: 0x0ac8, Name: "MCP79 PCI Express Bridge"},
			{ID: 0x0ad0, Name: "MCP78S [GeForce 8200] SATA Controller (non-AHCI mode)"},
			{ID: 0x0ad4, Name: "MCP78S [GeForce 8200] AHCI Controller"},
			{ID: 0x0ad8, Name: "MCP78S [GeForce 8200] SATA Controller (RAID mode)"},
			{ID: 0x0be2, Name: "GT216 HDMI Audio Controller"},
			{ID: 0x0be3, Name: "High Definition Audio Controller"},
			{ID: 0x0be4, Name: "High Definition Audio Controller"},
			{ID: 0x0be5, Name: "GF100 High Definition Audio Controller"},
			{ID: 0x0be9, Name: "GF106 High Definition Audio Controller"},
			{ID: 0x0bea, Name: "GF108 High Definition Audio Controller"},
			{ID: 0x0beb, Name: "GF104 High Definition Audio Controller"},
			{ID: 0x0bee, Name: "GF116 High Definition Audio Controller"},
			{ID: 0x0bf0, Name: "Tegra2 PCIe x4 Bridge"},
			{ID: 0x0bf1, Name: "Tegra2 PCIe x2 Bridge"},
			{ID: 0x0ca0, Name: "GT215 [GeForce GT 330]"},
			{ID: 0x0ca2, Name: "GT215 [GeForce GT 320]"},
			{ID: 0x0ca3, Name: "GT215 [GeForce GT 240]"},
			{ID: 0x0ca4, Name: "GT215 [GeForce GT 340]"},
			{ID: 0x0ca5, Name: "GT215 [GeForce GT 220]"},
			{ID: 0x0ca7, Name: "GT215 [GeForce GT 330]"},
			{ID: 0x0ca8, Name: "GT215M [GeForce GTS 260M]"},
			{ID: 0x0ca9, Name: "GT215M [GeForce GTS 250M]"},
			{ID: 0x0cac, Name: "GT215 [GeForce GT 220/315]"},
			{ID: 0x0caf, Name: "GT215M [GeForce GT 335M]"},
			{ID: 0x0cb0, Name: "GT215M [GeForce GTS 350M]"},
			{ID: 0x0cb1, Name: "GT215M [GeForce GTS 360M]"},
			{ID: 0x0cbc, Name: "GT215GLM [Quadro FX 1800M]"},
			{ID: 0x0d60, Name: "MCP89 HOST Bridge"},
			{ID: 0x0d68, Name: "MCP89 Memory Controller"},
			{ID: 0x0d69, Name: "MCP89 Memory Controller"},
			{ID: 0x0d76, Name: "MCP89 PCI Express Bridge"},
			{ID: 0x0d79, Name: "MCP89 SMBus"},
			{ID: 0x0d7a, Name: "MCP89 Co-Processor"},
			{ID: 0x0d7b, Name: "MCP89 Memory Controller"},
			{ID: 0x0d7d, Name: "MCP89 Ethernet"},
			{ID: 0x0d80, Name: "MCP89 LPC Bridge"},
			{ID: 0x0d85, Name: "MCP89 SATA Controller"},
			{ID: 0x0d88, Name: "MCP89 SATA Controller (AHCI mode)"},
			{ID: 0x0d89, Name: "MCP89 SATA Controller (AHCI mode)"},
			{ID: 0x0d8d, Name: "MCP89 SATA Controller (RAID mode)"},
			{ID: 0x0d94, Name: "MCP89 High Definition Audio"},
			{ID: 0x0d9c, Name: "MCP89 OHCI USB 1.1 Controller"},
			{ID: 0x0d9d, Name: "MCP89 EHCI USB 2.0 Controller"},
			{ID: 0x0dc0, Name: "GF106 [GeForce GT 440]"},
			{ID: 0x0dc4, Name: "GF106 [GeForce GTS 450]"},
			{ID: 0x0dc5, Name: "GF106 [GeForce GTS 450 OEM]"},
			{ID: 0x0dc6, Name: "GF106 [GeForce GTS 450 OEM]"},
			{ID: 0x0dcd, Name: "GF106M [GeForce GT 555M]"},
			{ID: 0x0dce, Name: "GF106M [GeForce GT 555M]"},
			{ID: 0x0dd1, Name: "GF106M [GeForce GTX 460M]"},
			{ID: 0x0dd2, Name: "GF106M [GeForce GT 445M]"},
			{ID: 0x0dd3, Name: "GF106M [GeForce GT 435M]"},
			{ID: 0x0dd6, Name: "GF106M [GeForce GT 550M]"},
			{ID: 0x0dd8, Name: "GF106GL [Quadro 2000]"},
			{ID: 0x0dda, Name: "GF106GLM [Quadro 2000M]"},
			{ID: 0x0de0, Name: "GF108 [GeForce GT 440]"},
			{ID: 0x0de1, Name: "GF108 [GeForce GT 430]"},
			{ID: 0x0de2, Name: "GF108 [GeForce GT 420]"},
			{ID: 0x0de3, Name: "GF108M [GeForce GT 635M]"},
			{ID: 0x0de4, Name: "GF108 [GeForce GT 520]"},
			{ID: 0x0de5, Name: "GF108 [GeForce GT 530]"},
			{ID: 0x0de7, Name: "GF108 [GeForce GT 610]"},
			{ID: 0x0de8, Name: "GF108M [GeForce GT 620M]"},
			{ID: 0x0de9, Name: "GF108M [GeForce GT 620M/630M/635M/640M LE]"},
			{ID: 0x0dea, Name: "GF108M [GeForce 610M]"},
			{ID: 0x0deb, Name: "GF108M [GeForce GT 555M]"},
			{ID: 0x0dec, Name: "GF108M [GeForce GT 525M]"},
			{ID: 0x0ded, Name: "GF108M [GeForce GT 520M]"},
			{ID: 0x0dee, Name: "GF108M [GeForce GT 415M]"},
			{ID: 0x0def, Name: "GF108M [NVS 5400M]"},
			{ID: 0x0df0, Name: "GF108M [GeForce GT 425M]"},
			{ID: 0x0df1, Name: "GF108M [GeForce GT 420M]"},
			{ID: 0x0df2, Name: "GF108M [GeForce GT 435M]"},
			{ID: 0x0df3, Name: "GF108M [GeForce GT 420M]"},
			{ID: 0x0df4, Name: "GF108M [GeForce GT 540M]"},
			{ID: 0x0df5, Name: "GF108M [GeForce GT 525M]"},
			{ID: 0x0df6, Name: "GF108M [GeForce GT 550M]"},
			{ID: 0x0df7, Name: "GF108M [GeForce GT 520M]"},
			{ID: 0x0df8, Name: "GF108GL [Quadro 600]"},
			{ID: 0x0df9, Name: "GF108GLM [Quadro 500M]"},
			{ID: 0x0dfa, Name: "GF108GLM [Quadro 1000M]"},
			{ID: 0x0dfc, Name: "GF108GLM [NVS 5200M]"},
			{ID: 0x0e08, Name: "GF119 HDMI Audio Controller"},
			{ID: 0x0e09, Name: "GF110 High Definition Audio Controller"},
			{ID: 0x0e0a, Name: "GK104 HDMI Audio Controller"},
			{ID: 0x0e0b, Name: "GK106 HDMI Audio Controller"},
			{ID: 0x0e0c, Name: "GF114 HDMI Audio Controller"},
			{ID: 0x0e0f, Name: "GK208 HDMI/DP Audio Controller"},
			{ID: 0x0e12, Name: "TegraK1 PCIe x4 Bridge"},
			{ID: 0x0e13, Name: "TegraK1 PCIe x1 Bridge"},
			{ID: 0x0e1a, Name: "GK110 High Definition Audio Controller"},
			{ID: 0x0e1b, Name: "GK107 HDMI Audio Controller"},
			{ID: 0x0e1c, Name: "Tegra3+ PCIe x4 Bridge"},
			{ID: 0x0e1d, Name: "Tegra3+ PCIe x2 Bridge"},
			{ID: 0x0e22, Name: "GF104 [GeForce GTX 460]"},
			{ID: 0x0e23, Name: "GF104 [GeForce GTX 460 SE]"},
			{ID: 0x0e24, Name: "GF104 [GeForce GTX 460 OEM]"},
			{ID: 0x0e30, Name: "GF104M [GeForce GTX 470M]"},
			{ID: 0x0e31, Name: "GF104M [GeForce GTX 485M]"},
			{ID: 0x0e3a, Name: "GF104GLM [Quadro 3000M]"},
			{ID: 0x0e3b, Name: "GF104GLM [Quadro 4000M]"},
			{ID: 0x0f00, Name: "GF108 [GeForce GT 630]"},
			{ID: 0x0f01, Name: "GF108 [GeForce GT 620]"},
			{ID: 0x0f02, Name: "GF108 [GeForce GT 730]"},
			{ID: 0x0f03, Name: "GF108 [GeForce GT 610]"},
			{ID: 0x0f06, Name: "GF108 [GeForce GT 730]"},
			{ID: 0x0fb0, Name: "GM200 High Definition Audio"},
			{ID: 0x0fb8, Name: "GP108 High Definition Audio Controller"},
			{ID: 0x0fb9, Name: "GP107GL High Definition Audio Controller"},
			{ID: 0x0fba, Name: "GM206 High Definition Audio Controller"},
			{ID: 0x0fbb, Name: "GM204 High Definition Audio Controller"},
			{ID: 0x0fbc, Name: "GM107 High Definition Audio Controller [GeForce 940MX]"},
			{ID: 0x0fc0, Name: "GK107 [GeForce GT 640 OEM]"},
			{ID: 0x0fc1, Name: "GK107 [GeForce GT 640]"},
			{ID: 0x0fc2, Name: "GK107 [GeForce GT 630 OEM]"},
			{ID: 0x0fc5, Name: "GK107 [GeForce GT 1030]"},
			{ID: 0x0fc6, Name: "GK107 [GeForce GTX 650]"},
			{ID: 0x0fc8, Name: "GK107 [GeForce GT 740]"},
			{ID: 0x0fc9, Name: "GK107 [GeForce GT 730]"},
			{ID: 0x0fcd, Name: "GK107M [GeForce GT 755M]"},
			{ID: 0x0fce, Name: "GK107M [GeForce GT 640M LE]"},
			{ID: 0x0fd1, Name: "GK107M [GeForce GT 650M]"},
			{ID: 0x0fd2, Name: "GK107M [GeForce GT 640M]"},
			{ID: 0x0fd3, Name: "GK107M [GeForce GT 640M LE]"},
			{ID: 0x0fd4, Name: "GK107M [GeForce GTX 660M]"},
			{ID: 0x0fd5, Name: "GK107M [GeForce GT 650M Mac Edition]"},
			{ID: 0x0fd6, Name: "GK107M"},
			{ID: 0x0fd8, Name: "GK107M [GeForce GT 640M Mac Edition]"},
			{ID: 0x0fd9, Name: "GK107M [GeForce GT 645M]"},
			{ID: 0x0fdb, Name: "GK107M"},
			{ID: 0x0fdf, Name: "GK107M [GeForce GT 740M]"},
			{ID: 0x0fe0, Name: "GK107M [GeForce GTX 660M Mac Edition]"},
			{ID: 0x0fe1, Name: "GK107M [GeForce GT 730M]"},
			{ID: 0x0fe2, Name: "GK107M [GeForce GT 745M]"},
			{ID: 0x0fe3, Name: "GK107M [GeForce GT 745M]"},
			{ID: 0x0fe4, Name: "GK107M [GeForce GT 750M]"},
			{ID: 0x0fe5, Name: "GK107 [GeForce K340 USM]"},
			{ID: 0x0fe6, Name: "GK107 [GRID K1 NVS USM]"},
			{ID: 0x0fe7, Name: "GK107GL [GRID K100 vGPU]"},
			{ID: 0x0fe8, Name: "GK107M"},
			{ID: 0x0fe9, Name: "GK107M [GeForce GT 750M Mac Edition]"},
			{ID: 0x0fea, Name: "GK107M [GeForce GT 755M Mac Edition]"},
			{ID: 0x0fec, Name: "GK107M [GeForce 710A]"},
			{ID: 0x0fed, Name: "GK107M [GeForce 820M]"},
			{ID: 0x0fee, Name: "GK107M [GeForce 810M]"},
			{ID: 0x0fef, Name: "GK107GL [GRID K340]"},
			{ID: 0x0ff1, Name: "GK107 [NVS 1000]"},
			{ID: 0x0ff2, Name: "GK107GL [GRID K1]"},
			{ID: 0x0ff3, Name: "GK107GL [Quadro K420]"},
			{ID: 0x0ff5, Name: "GK107GL [GRID K1 Tesla USM]"},
			{ID: 0x0ff6, Name: "GK107GLM [Quadro K1100M]"},
			{ID: 0x0ff7, Name: "GK107GL [GRID K140Q vGPU]"},
			{ID: 0x0ff8, Name: "GK107GLM [Quadro K500M]"},
			{ID: 0x0ff9, Name: "GK107GL [Quadro K2000D]"},
			{ID: 0x0ffa, Name: "GK107GL [Quadro K600]"},
			{ID: 0x0ffb, Name: "GK107GLM [Quadro K2000M]"},
			{ID: 0x0ffc, Name: "GK107GLM [Quadro K1000M]"},
			{ID: 0x0ffd, Name: "GK107 [NVS 510]"},
			{ID: 0x0ffe, Name: "GK107GL [Quadro K2000]"},
			{ID: 0x0fff, Name: "GK107GL [Quadro 410]"},
			{ID: 0x1001, Name: "GK110B [GeForce GTX TITAN Z]"},
			{ID: 0x1003, Name: "GK110 [GeForce GTX Titan LE]"},
			{ID: 0x1004, Name: "GK110 [GeForce GTX 780]"},
			{ID: 0x1005, Name: "GK110 [GeForce GTX TITAN]"},
			{ID: 0x1007, Name: "GK110 [GeForce GTX 780 Rev. 2]"},
			{ID: 0x1008, Name: "GK110 [GeForce GTX 780 Ti 6GB]"},
			{ID: 0x100a, Name: "GK110B [GeForce GTX 780 Ti]"},
			{ID: 0x100c, Name: "GK110B [GeForce GTX TITAN Black]"},
			{ID: 0x101e, Name: "GK110GL [Tesla K20X]"},
			{ID: 0x101f, Name: "GK110GL [Tesla K20]"},
			{ID: 0x1020, Name: "GK110GL [Tesla K20X]"},
			{ID: 0x1021, Name: "GK110GL [Tesla K20Xm]"},
			{ID: 0x1022, Name: "GK110GL [Tesla K20c]"},
			{ID: 0x1023, Name: "GK110BGL [Tesla K40m]"},
			{ID: 0x1024, Name: "GK180GL [Tesla K40c]"},
			{ID: 0x1026, Name: "GK110GL [Tesla K20s]"},
			{ID: 0x1027, Name: "GK110BGL [Tesla K40st]"},
			{ID: 0x1028, Name: "GK110GL [Tesla K20m]"},
			{ID: 0x1029, Name: "GK110BGL [Tesla K40s]"},
			{ID: 0x102a, Name: "GK110BGL [Tesla K40t]"},
			{ID: 0x102d, Name: "GK210GL [Tesla K80]"},
			{ID: 0x102e, Name: "GK110BGL [Tesla K40d]"},
			{ID: 0x102f, Name: "GK110BGL [Tesla Stella Solo]"},
			{ID: 0x103a, Name: "GK110GL [Quadro K6000]"},
			{ID: 0x103c, Name: "GK110GL [Quadro K5200]"},
			{ID: 0x103f, Name: "GK110BGL [Tesla Stella SXM]"},
			{ID: 0x1040, Name: "GF119 [GeForce GT 520]"},
			{ID: 0x1042, Name: "GF119 [GeForce 510]"},
			{ID: 0x1045, Name: "GF119"},
			{ID: 0x1048, Name: "GF119 [GeForce 605]"},
			{ID: 0x1049, Name: "GF119 [GeForce GT 620 OEM]"},
			{ID: 0x104a, Name: "GF119 [GeForce GT 610]"},
			{ID: 0x104b, Name: "GF119 [GeForce GT 625 OEM]"},
			{ID: 0x104c, Name: "GF119 [GeForce GT 705]"},
			{ID: 0x104d, Name: "GF119 [GeForce GT 710]"},
			{ID: 0x1050, Name: "GF119M [GeForce GT 520M]"},
			{ID: 0x1051, Name: "GF119M [GeForce GT 520MX]"},
			{ID: 0x1052, Name: "GF119M [GeForce GT 520M]"},
			{ID: 0x1054, Name: "GF119M [GeForce 410M]"},
			{ID: 0x1055, Name: "GF119M [GeForce 410M]"},
			{ID: 0x1056, Name: "GF119M [NVS 4200M]"},
			{ID: 0x1057, Name: "GF119M [Quadro NVS 4200M]"},
			{ID: 0x1058, Name: "GF119M [GeForce 610M]"},
			{ID: 0x1059, Name: "GF119M [GeForce 610M]"},
			{ID: 0x105a, Name: "GF119M [GeForce 610M]"},
			{ID: 0x105b, Name: "GF119M [GeForce 705M]"},
			{ID: 0x107c, Name: "GF119 [NVS 315]"},
			{ID: 0x107d, Name: "GF119 [NVS 310]"},
			{ID: 0x1080, Name: "GF110 [GeForce GTX 580]"},
			{ID: 0x1081, Name: "GF110 [GeForce GTX 570]"},
			{ID: 0x1082, Name: "GF110 [GeForce GTX 560 Ti OEM]"},
			{ID: 0x1084, Name: "GF110 [GeForce GTX 560 OEM]"},
			{ID: 0x1086, Name: "GF110 [GeForce GTX 570 Rev. 2]"},
			{ID: 0x1087, Name: "GF110 [GeForce GTX 560 Ti 448 Cores]"},
			{ID: 0x1088, Name: "GF110 [GeForce GTX 590]"},
			{ID: 0x1089, Name: "GF110 [GeForce GTX 580 Rev. 2]"},
			{ID: 0x108b, Name: "GF110 [GeForce GTX 580]"},
			{ID: 0x108e, Name: "GF110GL [Tesla C2090]"},
			{ID: 0x1091, Name: "GF110GL [Tesla M2090]"},
			{ID: 0x1094, Name: "GF110GL [Tesla M2075]"},
			{ID: 0x1096, Name: "GF110GL [Tesla C2050 / C2075]"},
			{ID: 0x109a, Name: "GF100GLM [Quadro 5010M]"},
			{ID: 0x109b, Name: "GF100GL [Quadro 7000]"},
			{ID: 0x10c0, Name: "GT218 [GeForce 9300 GS Rev. 2]"},
			{ID: 0x10c3, Name: "GT218 [GeForce 8400 GS Rev. 3]"},
			{ID: 0x10c5, Name: "GT218 [GeForce 405]"},
			{ID: 0x10d8, Name: "GT218 [NVS 300]"},
			{ID: 0x10ef, Name: "GP102 HDMI Audio Controller"},
			{ID: 0x10f0, Name: "GP104 High Definition Audio Controller"},
			{ID: 0x10f1, Name: "GP106 High Definition Audio Controller"},
			{ID: 0x10f7, Name: "TU102 High Definition Audio Controller"},
			{ID: 0x10f8, Name: "TU104 HD Audio Controller"},
			{ID: 0x10f9, Name: "TU106 High Definition Audio Controller"},
			{ID: 0x1140, Name: "GF117M [GeForce 610M/710M/810M/820M / GT 620M/625M/630M/720M]"},
			{ID: 0x1180, Name: "GK104 [GeForce GTX 680]"},
			{ID: 0x1182, Name: "GK104 [GeForce GTX 760 Ti]"},
			{ID: 0x1183, Name: "GK104 [GeForce GTX 660 Ti]"},
			{ID: 0x1184, Name: "GK104 [GeForce GTX 770]"},
			{ID: 0x1185, Name: "GK104 [GeForce GTX 660 OEM]"},
			{ID: 0x1186, Name: "GK104 [GeForce GTX 660 Ti]"},
			{ID: 0x1187, Name: "GK104 [GeForce GTX 760]"},
			{ID: 0x1188, Name: "GK104 [GeForce GTX 690]"},
			{ID: 0x1189, Name: "GK104 [GeForce GTX 670]"},
			{ID: 0x118a, Name: "GK104GL [GRID K520]"},
			{ID: 0x118b, Name: "GK104GL [GRID K2 GeForce USM]"},
			{ID: 0x118c, Name: "GK104 [GRID K2 NVS USM]"},
			{ID: 0x118d, Name: "GK104GL [GRID K200 vGPU]"},
			{ID: 0x118e, Name: "GK104 [GeForce GTX 760 OEM]"},
			{ID: 0x118f, Name: "GK104GL [Tesla K10]"},
			{ID: 0x1191, Name: "GK104 [GeForce GTX 760 Rev. 2]"},
			{ID: 0x1193, Name: "GK104 [GeForce GTX 760 Ti OEM]"},
			{ID: 0x1194, Name: "GK104GL [Tesla K8]"},
			{ID: 0x1195, Name: "GK104 [GeForce GTX 660 Rev. 2]"},
			{ID: 0x1198, Name: "GK104M [GeForce GTX 880M]"},
			{ID: 0x1199, Name: "GK104M [GeForce GTX 870M]"},
			{ID: 0x119a, Name: "GK104M [GeForce GTX 860M]"},
			{ID: 0x119d, Name: "GK104M [GeForce GTX 775M Mac Edition]"},
			{ID: 0x119e, Name: "GK104M [GeForce GTX 780M Mac Edition]"},
			{ID: 0x119f, Name: "GK104M [GeForce GTX 780M]"},
			{ID: 0x11a0, Name: "GK104M [GeForce GTX 680M]"},
			{ID: 0x11a1, Name: "GK104M [GeForce GTX 670MX]"},
			{ID: 0x11a2, Name: "GK104M [GeForce GTX 675MX Mac Edition]"},
			{ID: 0x11a3, Name: "GK104M [GeForce GTX 680MX]"},
			{ID: 0x11a7, Name: "GK104M [GeForce GTX 675MX]"},
			{ID: 0x11a9, Name: "GK104M [GeForce GTX 870M]"},
			{ID: 0x11af, Name: "GK104GLM [GRID IceCube]"},
			{ID: 0x11b0, Name: "GK104GL [GRID K240Q / K260Q vGPU]"},
			{ID: 0x11b1, Name: "GK104GL [GRID K2 Tesla USM]"},
			{ID: 0x11b4, Name: "GK104GL [Quadro K4200]"},
			{ID: 0x11b6, Name: "GK104GLM [Quadro K3100M]"},
			{ID: 0x11b7, Name: "GK104GLM [Quadro K4100M]"},
			{ID: 0x11b8, Name: "GK104GLM [Quadro K5100M]"},
			{ID: 0x11b9, Name: "GK104GLM"},
			{ID: 0x11ba, Name: "GK104GL [Quadro K5000]"},
			{ID: 0x11bb, Name: "GK104GL [Quadro 4100]"},
			{ID: 0x11bc, Name: "GK104GLM [Quadro K5000M]"},
			{ID: 0x11bd, Name: "GK104GLM [Quadro K4000M]"},
			{ID: 0x11be, Name: "GK104GLM [Quadro K3000M]"},
			{ID: 0x11bf, Name: "GK104GL [GRID K2]"},
			{ID: 0x11c0, Name: "GK106 [GeForce GTX 660]"},
			{ID: 0x11c2, Name: "GK106 [GeForce GTX 650 Ti Boost]"},
			{ID: 0x11c3, Name: "GK106 [GeForce GTX 650 Ti OEM]"},
			{ID: 0x11c4, Name: "GK106 [GeForce GTX 645 OEM]"},
			{ID: 0x11c5, Name: "GK106 [GeForce GT 740]"},
			{ID: 0x11c6, Name: "GK106 [GeForce GTX 650 Ti]"},
			{ID: 0x11c7, Name: "GK106 [GeForce GTX 750 Ti]"},
			{ID: 0x11c8, Name: "GK106 [GeForce GTX 650 OEM]"},
			{ID: 0x11cb, Name: "GK106 [GeForce GT 740]"},
			{ID: 0x11e0, Name: "GK106M [GeForce GTX 770M]"},
			{ID: 0x11e1, Name: "GK106M [GeForce GTX 765M]"},
			{ID: 0x11e2, Name: "GK106M [GeForce GTX 765M]"},
			{ID: 0x11e3, Name: "GK106M [GeForce GTX 760M]"},
			{ID: 0x11e7, Name: "GK106M"},
			{ID: 0x11fa, Name: "GK106GL [Quadro K4000]"},
			{ID: 0x11fc, Name: "GK106GLM [Quadro K2100M]"},
			{ID: 0x1200, Name: "GF114 [GeForce GTX 560 Ti]"},
			{ID: 0x1201, Name: "GF114 [GeForce GTX 560]"},
			{ID: 0x1202, Name: "GF114 [GeForce GTX 560 Ti OEM]"},
			{ID: 0x1203, Name: "GF114 [GeForce GTX 460 SE v2]"},
			{ID: 0x1205, Name: "GF114 [GeForce GTX 460 v2]"},
			{ID: 0x1206, Name: "GF114 [GeForce GTX 555]"},
			{ID: 0x1207, Name: "GF114 [GeForce GT 645 OEM]"},
			{ID: 0x1208, Name: "GF114 [GeForce GTX 560 SE]"},
			{ID: 0x1210, Name: "GF114M [GeForce GTX 570M]"},
			{ID: 0x1211, Name: "GF114M [GeForce GTX 580M]"},
			{ID: 0x1212, Name: "GF114M [GeForce GTX 675M]"},
			{ID: 0x1213, Name: "GF114M [GeForce GTX 670M]"},
			{ID: 0x1241, Name: "GF116 [GeForce GT 545 OEM]"},
			{ID: 0x1243, Name: "GF116 [GeForce GT 545]"},
			{ID: 0x1244, Name: "GF116 [GeForce GTX 550 Ti]"},
			{ID: 0x1245, Name: "GF116 [GeForce GTS 450 Rev. 2]"},
			{ID: 0x1246, Name: "GF116M [GeForce GT 550M]"},
			{ID: 0x1247, Name: "GF116M [GeForce GT 555M/635M]"},
			{ID: 0x1248, Name: "GF116M [GeForce GT 555M/635M]"},
			{ID: 0x1249, Name: "GF116 [GeForce GTS 450 Rev. 3]"},
			{ID: 0x124b, Name: "GF116 [GeForce GT 640 OEM]"},
			{ID: 0x124d, Name: "GF116M [GeForce GT 555M/635M]"},
			{ID: 0x1251, Name: "GF116M [GeForce GT 560M]"},
			{ID: 0x1280, Name: "GK208 [GeForce GT 635]"},
			{ID: 0x1281, Name: "GK208 [GeForce GT 710]"},
			{ID: 0x1282, Name: "GK208 [GeForce GT 640 Rev. 2]"},
			{ID: 0x1284, Name: "GK208 [GeForce GT 630 Rev. 2]"},
			{ID: 0x1286, Name: "GK208 [GeForce GT 720]"},
			{ID: 0x1287, Name: "GK208B [GeForce GT 730]"},
			{ID: 0x1288, Name: "GK208B [GeForce GT 720]"},
			{ID: 0x1289, Name: "GK208 [GeForce GT 710]"},
			{ID: 0x128a, Name: "GK208B"},
			{ID: 0x128b, Name: "GK208B [GeForce GT 710]"},
			{ID: 0x128c, Name: "GK208B"},
			{ID: 0x1290, Name: "GK208M [GeForce GT 730M]"},
			{ID: 0x1291, Name: "GK208M [GeForce GT 735M]"},
			{ID: 0x1292, Name: "GK208M [GeForce GT 740M]"},
			{ID: 0x1293, Name: "GK208M [GeForce GT 730M]"},
			{ID: 0x1294, Name: "GK208M [GeForce GT 740M]"},
			{ID: 0x1295, Name: "GK208M [GeForce 710M]"},
			{ID: 0x1296, Name: "GK208M [GeForce 825M]"},
			{ID: 0x1298, Name: "GK208M [GeForce GT 720M]"},
			{ID: 0x1299, Name: "GK208BM [GeForce 920M]"},
			{ID: 0x129a, Name: "GK208BM [GeForce 910M]"},
			{ID: 0x12a0, Name: "GK208"},
			{ID: 0x12b9, Name: "GK208GLM [Quadro K610M]"},
			{ID: 0x12ba, Name: "GK208GLM [Quadro K510M]"},
			{ID: 0x1340, Name: "GM108M [GeForce 830M]"},
			{ID: 0x1341, Name: "GM108M [GeForce 840M]"},
			{ID: 0x1344, Name: "GM108M [GeForce 845M]"},
			{ID: 0x1346, Name: "GM108M [GeForce 930M]"},
			{ID: 0x1347, Name: "GM108M [GeForce 940M]"},
			{ID: 0x1348, Name: "GM108M [GeForce 945M / 945A]"},
			{ID: 0x1349, Name: "GM108M [GeForce 930M]"},
			{ID: 0x134b, Name: "GM108M [GeForce 940MX]"},
			{ID: 0x134d, Name: "GM108M [GeForce 940MX]"},
			{ID: 0x134e, Name: "GM108M [GeForce 930MX]"},
			{ID: 0x134f, Name: "GM108M [GeForce 920MX]"},
			{ID: 0x137a, Name: "GM108GLM [Quadro K620M / Quadro M500M]"},
			{ID: 0x137b, Name: "GM108GLM [Quadro M520 Mobile]"},
			{ID: 0x137d, Name: "GM108M [GeForce 940A]"},
			{ID: 0x1380, Name: "GM107 [GeForce GTX 750 Ti]"},
			{ID: 0x1381, Name: "GM107 [GeForce GTX 750]"},
			{ID: 0x1382, Name: "GM107 [GeForce GTX 745]"},
			{ID: 0x1389, Name: "GM107GL [GRID M30]"},
			{ID: 0x1390, Name: "GM107M [GeForce 845M]"},
			{ID: 0x1391, Name: "GM107M [GeForce GTX 850M]"},
			{ID: 0x1392, Name: "GM107M [GeForce GTX 860M]"},
			{ID: 0x1393, Name: "GM107M [GeForce 840M]"},
			{ID: 0x1398, Name: "GM107M [GeForce 845M]"},
			{ID: 0x1399, Name: "GM107M [GeForce 945M]"},
			{ID: 0x139a, Name: "GM107M [GeForce GTX 950M]"},
			{ID: 0x139b, Name: "GM107M [GeForce GTX 960M]"},
			{ID: 0x139c, Name: "GM107M [GeForce 940M]"},
			{ID: 0x139d, Name: "GM107M [GeForce GTX 750 Ti]"},
			{ID: 0x13b0, Name: "GM107GLM [Quadro M2000M]"},
			{ID: 0x13b1, Name: "GM107GLM [Quadro M1000M]"},
			{ID: 0x13b2, Name: "GM107GLM [Quadro M600M]"},
			{ID: 0x13b3, Name: "GM107GLM [Quadro K2200M]"},
			{ID: 0x13b4, Name: "GM107GLM [Quadro M620 Mobile]"},
			{ID: 0x13b6, Name: "GM107GLM [Quadro M1200 Mobile]"},
			{ID: 0x13b9, Name: "GM107GL [NVS 810]"},
			{ID: 0x13ba, Name: "GM107GL [Quadro K2200]"},
			{ID: 0x13bb, Name: "GM107GL [Quadro K620]"},
			{ID: 0x13bc, Name: "GM107GL [Quadro K1200]"},
			{ID: 0x13bd, Name: "GM107GL [Tesla M10]"},
			{ID: 0x13c0, Name: "GM204 [GeForce GTX 980]"},
			{ID: 0x13c1, Name: "GM204"},
			{ID: 0x13c2, Name: "GM204 [GeForce GTX 970]"},
			{ID: 0x13c3, Name: "GM204"},
			{ID: 0x13d7, Name: "GM204M [GeForce GTX 980M]"},
			{ID: 0x13d8, Name: "GM204M [GeForce GTX 970M]"},
			{ID: 0x13d9, Name: "GM204M [GeForce GTX 965M]"},
			{ID: 0x13da, Name: "GM204M [GeForce GTX 980 Mobile]"},
			{ID: 0x13e7, Name: "GM204GL [GeForce GTX 980 Engineering Sample]"},
			{ID: 0x13f0, Name: "GM204GL [Quadro M5000]"},
			{ID: 0x13f1, Name: "GM204GL [Quadro M4000]"},
			{ID: 0x13f2, Name: "GM204GL [Tesla M60]"},
			{ID: 0x13f3, Name: "GM204GL [Tesla M6]"},
			{ID: 0x13f8, Name: "GM204GLM [Quadro M5000M / M5000 SE]"},
			{ID: 0x13f9, Name: "GM204GLM [Quadro M4000M]"},
			{ID: 0x13fa, Name: "GM204GLM [Quadro M3000M]"},
			{ID: 0x13fb, Name: "GM204GLM [Quadro M5500]"},
			{ID: 0x1401, Name: "GM206 [GeForce GTX 960]"},
			{ID: 0x1402, Name: "GM206 [GeForce GTX 950]"},
			{ID: 0x1404, Name: "GM206 [GeForce GTX 960 FAKE]"},
			{ID: 0x1406, Name: "GM206 [GeForce GTX 960 OEM]"},
			{ID: 0x1407, Name: "GM206 [GeForce GTX 750 v2]"},
			{ID: 0x1427, Name: "GM206M [GeForce GTX 965M]"},
			{ID: 0x1430, Name: "GM206GL [Quadro M2000]"},
			{ID: 0x1431, Name: "GM206GL [Tesla M4]"},
			{ID: 0x1436, Name: "GM206GLM [Quadro M2200 Mobile]"},
			{ID: 0x15f0, Name: "GP100GL [Quadro GP100]"},
			{ID: 0x15f1, Name: "GP100GL"},
			{ID: 0x15f7, Name: "GP100GL [Tesla P100 PCIe 12GB]"},
			{ID: 0x15f8, Name: "GP100GL [Tesla P100 PCIe 16GB]"},
			{ID: 0x15f9, Name: "GP100GL [Tesla P100 SXM2 16GB]"},
			{ID: 0x1617, Name: "GM204M [GeForce GTX 980M]"},
			{ID: 0x1618, Name: "GM204M [GeForce GTX 970M]"},
			{ID: 0x1619, Name: "GM204M [GeForce GTX 965M]"},
			{ID: 0x161a, Name: "GM204M [GeForce GTX 980 Mobile]"},
			{ID: 0x1667, Name: "GM204M [GeForce GTX 965M]"},
			{ID: 0x1725, Name: "GP100"},
			{ID: 0x172e, Name: "GP100"},
			{ID: 0x172f, Name: "GP100"},
			{ID: 0x174d, Name: "GM108M [GeForce MX130]"},
			{ID: 0x174e, Name: "GM108M [GeForce MX110]"},
			{ID: 0x1789, Name: "GM107GL [GRID M3-3020]"},
			{ID: 0x179c, Name: "GM107 [GeForce 940MX]"},
			{ID: 0x17c2, Name: "GM200 [GeForce GTX TITAN X]"},
			{ID: 0x17c8, Name: "GM200 [GeForce GTX 980 Ti]"},
			{ID: 0x17f0, Name: "GM200GL [Quadro M6000]"},
			{ID: 0x17f1, Name: "GM200GL [Quadro M6000 24GB]"},
			{ID: 0x17fd, Name: "GM200GL [Tesla M40]"},
			{ID: 0x1ad0, Name: "Tegra PCIe x8 Endpoint"},
			{ID: 0x1ad1, Name: "Tegra PCIe x4/x8 Endpoint/Root Complex"},
			{ID: 0x1ad2, Name: "Tegra PCIe x1 Root Complex"},
			{ID: 0x1ad3, Name: "Xavier SATA Controller"},
			{ID: 0x1ad6, Name: "TU102 USB 3.1 Host Controller"},
			{ID: 0x1ad7, Name: "TU102 USB Type-C UCSI Controller"},
			{ID: 0x1ad8, Name: "TU104 USB 3.1 Host Controller"},
			{ID: 0x1ad9, Name: "TU104 USB Type-C UCSI Controller"},
			{ID: 0x1ada, Name: "TU106 USB 3.1 Host Controller"},
			{ID: 0x1adb, Name: "TU106 USB Type-C UCSI Controller"},
			{ID: 0x1aeb, Name: "TU116 High Definition Audio Controller"},
			{ID: 0x1aec, Name: "TU116 USB 3.1 Host Controller"},
			{ID: 0x1aed, Name: "TU116 USB Type-C UCSI Controller"},
			{ID: 0x1aef, Name: "GA102 High Definition Audio Controller"},
			{ID: 0x1b00, Name: "GP102 [TITAN X]"},
			{ID: 0x1b01, Name: "GP102 [GeForce GTX 1080 Ti 10GB]"},
			{ID: 0x1b02, Name: "GP102 [TITAN Xp]"},
			{ID: 0x1b04, Name: "GP102"},
			{ID: 0x1b06, Name: "GP102 [GeForce GTX 1080 Ti]"},
			{ID: 0x1b07, Name: "GP102 [P102-100]"},
			{ID: 0x1b30, Name: "GP102GL [Quadro P6000]"},
			{ID: 0x1b38, Name: "GP102GL [Tesla P40]"},
			{ID: 0x1b39, Name: "GP102GL [Tesla P10]"},
			{ID: 0x1b70, Name: "GP102GL"},
			{ID: 0x1b78, Name: "GP102GL"},
			{ID: 0x1b80, Name: "GP104 [GeForce GTX 1080]"},
			{ID: 0x1b81, Name: "GP104 [GeForce GTX 1070]"},
			{ID: 0x1b82, Name: "GP104 [GeForce GTX 1070 Ti]"},
			{ID: 0x1b83, Name: "GP104 [GeForce GTX 1060 6GB]"},
			{ID: 0x1b84, Name: "GP104 [GeForce GTX 1060 3GB]"},
			{ID: 0x1b87, Name: "GP104 [P104-100]"},
			{ID: 0x1ba0, Name: "GP104M [GeForce GTX 1080 Mobile]"},
			{ID: 0x1ba1, Name: "GP104M [GeForce GTX 1070 Mobile]"},
			{ID: 0x1ba2, Name: "GP104M [GeForce GTX 1070 Mobile]"},
			{ID: 0x1ba9, Name: "GP104M"},
			{ID: 0x1baa, Name: "GP104M"},
			{ID: 0x1bad, Name: "GP104 [GeForce GTX 1070 Engineering Sample]"},
			{ID: 0x1bb0, Name: "GP104GL [Quadro P5000]"},
			{ID: 0x1bb1, Name: "GP104GL [Quadro P4000]"},
			{ID: 0x1bb3, Name: "GP104GL [Tesla P4]"},
			{ID: 0x1bb4, Name: "GP104GL [Tesla P6]"},
			{ID: 0x1bb5, Name: "GP104GLM [Quadro P5200 Mobile]"},
			{ID: 0x1bb6, Name: "GP104GLM [Quadro P5000 Mobile]"},
			{ID: 0x1bb7, Name: "GP104GLM [Quadro P4000 Mobile]"},
			{ID: 0x1bb8, Name: "GP104GLM [Quadro P3000 Mobile]"},
			{ID: 0x1bb9, Name: "GP104GLM [Quadro P4200 Mobile]"},
			{ID: 0x1bbb, Name: "GP104GLM [Quadro P3200 Mobile]"},
			{ID: 0x1bc7, Name: "GP104 [P104-101]"},
			{ID: 0x1be0, Name: "GP104BM [GeForce GTX 1080 Mobile]"},
			{ID: 0x1be1, Name: "GP104BM [GeForce GTX 1070 Mobile]"},
			{ID: 0x1c00, Name: "GP106"},
			{ID: 0x1c01, Name: "GP106"},
			{ID: 0x1c02, Name: "GP106 [GeForce GTX 1060 3GB]"},
			{ID: 0x1c03, Name: "GP106 [GeForce GTX 1060 6GB]"},
			{ID: 0x1c04, Name: "GP106 [GeForce GTX 1060 5GB]"},
			{ID: 0x1c06, Name: "GP106 [GeForce GTX 1060 6GB Rev. 2]"},
			{ID: 0x1c07, Name: "GP106 [P106-100]"},
			{ID: 0x1c09, Name: "GP106 [P106-090]"},
			{ID: 0x1c20, Name: "GP106M [GeForce GTX 1060 Mobile]"},
			{ID: 0x1c21, Name: "GP106M [GeForce GTX 1050 Ti Mobile]"},
			{ID: 0x1c22, Name: "GP106M [GeForce GTX 1050 Mobile]"},
			{ID: 0x1c23, Name: "GP106M [GeForce GTX 1060 Mobile Rev. 2]"},
			{ID: 0x1c2d, Name: "GP106M"},
			{ID: 0x1c30, Name: "GP106GL [Quadro P2000]"},
			{ID: 0x1c31, Name: "GP106GL [Quadro P2200]"},
			{ID: 0x1c35, Name: "GP106M [Quadro P2000 Mobile]"},
			{ID: 0x1c36, Name: "GP106 [P106M]"},
			{ID: 0x1c60, Name: "GP106BM [GeForce GTX 1060 Mobile 6GB]"},
			{ID: 0x1c61, Name: "GP106BM [GeForce GTX 1050 Ti Mobile]"},
			{ID: 0x1c62, Name: "GP106BM [GeForce GTX 1050 Mobile]"},
			{ID: 0x1c70, Name: "GP106GL"},
			{ID: 0x1c81, Name: "GP107 [GeForce GTX 1050]"},
			{ID: 0x1c82, Name: "GP107 [GeForce GTX 1050 Ti]"},
			{ID: 0x1c83, Name: "GP107 [GeForce GTX 1050 3GB]"},
			{ID: 0x1c8c, Name: "GP107M [GeForce GTX 1050 Ti Mobile]"},
			{ID: 0x1c8d, Name: "GP107M [GeForce GTX 1050 Mobile]"},
			{ID: 0x1c8e, Name: "GP107M"},
			{ID: 0x1c8f, Name: "GP107M [GeForce GTX 1050 Ti Max-Q]"},
			{ID: 0x1c90, Name: "GP107M [GeForce MX150]"},
			{ID: 0x1c91, Name: "GP107M [GeForce GTX 1050 3 GB Max-Q]"},
			{ID: 0x1c92, Name: "GP107M [GeForce GTX 1050 Mobile]"},
			{ID: 0x1c94, Name: "GP107M [GeForce MX350]"},
			{ID: 0x1c96, Name: "GP107M [GeForce MX350]"},
			{ID: 0x1ca7, Name: "GP107GL"},
			{ID: 0x1ca8, Name: "GP107GL"},
			{ID: 0x1caa, Name: "GP107GL"},
			{ID: 0x1cb1, Name: "GP107GL [Quadro P1000]"},
			{ID: 0x1cb2, Name: "GP107GL [Quadro P600]"},
			{ID: 0x1cb3, Name: "GP107GL [Quadro P400]"},
			{ID: 0x1cb6, Name: "GP107GL [Quadro P620]"},
			{ID: 0x1cba, Name: "GP107GLM [Quadro P2000 Mobile]"},
			{ID: 0x1cbb, Name: "GP107GLM [Quadro P1000 Mobile]"},
			{ID: 0x1cbc, Name: "GP107GLM [Quadro P600 Mobile]"},
			{ID: 0x1cbd, Name: "GP107GLM [Quadro P620]"},
			{ID: 0x1ccc, Name: "GP107BM [GeForce GTX 1050 Ti Mobile]"},
			{ID: 0x1ccd, Name: "GP107BM [GeForce GTX 1050 Mobile]"},
			{ID: 0x1cfa, Name: "GP107GL [Quadro P2000]"},
			{ID: 0x1cfb, Name: "GP107GL [Quadro P1000]"},
			{ID: 0x1d01, Name: "GP108 [GeForce GT 1030]"},
			{ID: 0x1d02, Name: "GP108 [GeForce GT 1010]"},
			{ID: 0x1d10, Name: "GP108M [GeForce MX150]"},
			{ID: 0x1d11, Name: "GP108M [GeForce MX230]"},
			{ID: 0x1d12, Name: "GP108M [GeForce MX150]"},
			{ID: 0x1d13, Name: "GP108M [GeForce MX250]"},
			{ID: 0x1d16, Name: "GP108M [GeForce MX330]"},
			{ID: 0x1d33, Name: "GP108GLM [Quadro P500 Mobile]"},
			{ID: 0x1d34, Name: "GP108GLM [Quadro P520]"},
			{ID: 0x1d52, Name: "GP108BM [GeForce MX250]"},
			{ID: 0x1d56, Name: "GP108BM [GeForce MX330]"},
			{ID: 0x1d81, Name: "GV100 [TITAN V]"},
			{ID: 0x1db1, Name: "GV100GL [Tesla V100 SXM2 16GB]"},
			{ID: 0x1db2, Name: "GV100GL [Tesla V100 DGXS 16GB]"},
			{ID: 0x1db3, Name: "GV100GL [Tesla V100 FHHL 16GB]"},
			{ID: 0x1db4, Name: "GV100GL [Tesla V100 PCIe 16GB]"},
			{ID: 0x1db5, Name: "GV100GL [Tesla V100 SXM2 32GB]"},
			{ID: 0x1db6, Name: "GV100GL [Tesla V100 PCIe 32GB]"},
			{ID: 0x1db7, Name: "GV100GL [Tesla V100 DGXS 32GB]"},
			{ID: 0x1db8, Name: "GV100GL [Tesla V100 SXM3 32GB]"},
			{ID: 0x1dba, Name: "GV100GL [Quadro GV100]"},
			{ID: 0x1df0, Name: "GV100GL [Tesla PG500-216]"},
			{ID: 0x1df2, Name: "GV100GL [Tesla PG503-216]"},
			{ID: 0x1df5, Name: "GV100GL [Tesla V100 SXM2 16GB]"},
			{ID: 0x1df6, Name: "GV100GL [Tesla V100S PCIe 32GB]"},
			{ID: 0x1e02, Name: "TU102 [TITAN RTX]"},
			{ID: 0x1e04, Name: "TU102 [GeForce RTX 2080 Ti]"},
			{ID: 0x1e07, Name: "TU102 [GeForce RTX 2080 Ti Rev. A]"},
			{ID: 0x1e09, Name: "TU102 [CMP 50HX]"},
			{ID: 0x1e2d, Name: "TU102 [GeForce RTX 2080 Ti Engineering Sample]"},
			{ID: 0x1e2e, Name: "TU102 [GeForce RTX 2080 Ti 12GB Engineering Sample]"},
			{ID: 0x1e30, Name: "TU102GL [Quadro RTX 6000/8000]"},
			{ID: 0x1e36, Name: "TU102GL [Quadro RTX 6000]"},
			{ID: 0x1e37, Name: "TU102GL [GRID RTX T10-4/T10-8/T10-16]"},
			{ID: 0x1e38, Name: "TU102GL"},
			{ID: 0x1e3c, Name: "TU102GL"},
			{ID: 0x1e3d, Name: "TU102GL"},
			{ID: 0x1e3e, Name: "TU102GL"},
			{ID: 0x1e78, Name: "TU102GL [Quadro RTX 6000/8000]"},
			{ID: 0x1e81, Name: "TU104 [GeForce RTX 2080 SUPER]"},
			{ID: 0x1e82, Name: "TU104 [GeForce RTX 2080]"},
			{ID: 0x1e84, Name: "TU104 [GeForce RTX 2070 SUPER]"},
			{ID: 0x1e87, Name: "TU104 [GeForce RTX 2080 Rev. A]"},
			{ID: 0x1e89, Name: "TU104 [GeForce RTX 2060]"},
			{ID: 0x1e90, Name: "TU104M [GeForce RTX 2080 Mobile]"},
			{ID: 0x1e91, Name: "TU104M [GeForce RTX 2070 SUPER Mobile / Max-Q]"},
			{ID: 0x1e93, Name: "TU104M [GeForce RTX 2080 SUPER Mobile / Max-Q]"},
			{ID: 0x1eab, Name: "TU104M"},
			{ID: 0x1eae, Name: "TU104M"},
			{ID: 0x1eb0, Name: "TU104GL [Quadro RTX 5000]"},
			{ID: 0x1eb1, Name: "TU104GL [Quadro RTX 4000]"},
			{ID: 0x1eb4, Name: "TU104GL [T4G]"},
			{ID: 0x1eb5, Name: "TU104GLM [Quadro RTX 5000 Mobile / Max-Q]"},
			{ID: 0x1eb6, Name: "TU104GLM [Quadro RTX 4000 Mobile / Max-Q]"},
			{ID: 0x1eb8, Name: "TU104GL [Tesla T4]"},
			{ID: 0x1eb9, Name: "TU104GL"},
			{ID: 0x1ebe, Name: "TU104GL"},
			{ID: 0x1ec2, Name: "TU104 [GeForce RTX 2070 SUPER]"},
			{ID: 0x1ec7, Name: "TU104 [GeForce RTX 2070 SUPER]"},
			{ID: 0x1ed0, Name: "TU104BM [GeForce RTX 2080 Mobile]"},
			{ID: 0x1ed1, Name: "TU104BM [GeForce RTX 2070 SUPER Mobile / Max-Q]"},
			{ID: 0x1ed3, Name: "TU104BM [GeForce RTX 2080 SUPER Mobile / Max-Q]"},
			{ID: 0x1ef5, Name: "TU104GLM [Quadro RTX 5000 Mobile Refresh]"},
			{ID: 0x1f02, Name: "TU106 [GeForce RTX 2070]"},
			{ID: 0x1f03, Name: "TU106 [GeForce RTX 2060 12GB]"},
			{ID: 0x1f04, Name: "TU106"},
			{ID: 0x1f06, Name: "TU106 [GeForce RTX 2060 SUPER]"},
			{ID: 0x1f07, Name: "TU106 [GeForce RTX 2070 Rev. A]"},
			{ID: 0x1f08, Name: "TU106 [GeForce RTX 2060 Rev. A]"},
			{ID: 0x1f09, Name: "TU106 [GeForce GTX 1660 SUPER]"},
			{ID: 0x1f0a, Name: "TU106 [GeForce GTX 1650]"},
			{ID: 0x1f0b, Name: "TU106 [CMP 40HX]"},
			{ID: 0x1f10, Name: "TU106M [GeForce RTX 2070 Mobile]"},
			{ID: 0x1f11, Name: "TU106M [GeForce RTX 2060 Mobile]"},
			{ID: 0x1f12, Name: "TU106M [GeForce RTX 2060 Max-Q]"},
			{ID: 0x1f14, Name: "TU106M [GeForce RTX 2070 Mobile / Max-Q Refresh]"},
			{ID: 0x1f15, Name: "TU106M [GeForce RTX 2060 Mobile]"},
			{ID: 0x1f2e, Name: "TU106M"},
			{ID: 0x1f36, Name: "TU106GLM [Quadro RTX 3000 Mobile / Max-Q]"},
			{ID: 0x1f42, Name: "TU106 [GeForce RTX 2060 SUPER]"},
			{ID: 0x1f47, Name: "TU106 [GeForce RTX 2060 SUPER]"},
			{ID: 0x1f50, Name: "TU106BM [GeForce RTX 2070 Mobile / Max-Q]"},
			{ID: 0x1f51, Name: "TU106BM [GeForce RTX 2060 Mobile]"},
			{ID: 0x1f54, Name: "TU106BM [GeForce RTX 2070 Mobile]"},
			{ID: 0x1f55, Name: "TU106BM [GeForce RTX 2060 Mobile]"},
			{ID: 0x1f76, Name: "TU106GLM [Quadro RTX 3000 Mobile Refresh]"},
			{ID: 0x1f81, Name: "TU117"},
			{ID: 0x1f82, Name: "TU117 [GeForce GTX 1650]"},
			{ID: 0x1f91, Name: "TU117M [GeForce GTX 1650 Mobile / Max-Q]"},
			{ID: 0x1f92, Name: "TU117M [GeForce GTX 1650 Mobile]"},
			{ID: 0x1f94, Name: "TU117M [GeForce GTX 1650 Mobile]"},
			{ID: 0x1f95, Name: "TU117M [GeForce GTX 1650 Ti Mobile]"},
			{ID: 0x1f96, Name: "TU117M [GeForce GTX 1650 Mobile / Max-Q]"},
			{ID: 0x1f97, Name: "TU117M [GeForce MX450]"},
			{ID: 0x1f98, Name: "TU117M [GeForce MX450]"},
			{ID: 0x1f99, Name: "TU117M"},
			{ID: 0x1f9c, Name: "TU117M [GeForce MX450]"},
			{ID: 0x1f9d, Name: "TU117M [GeForce GTX 1650 Mobile / Max-Q]"},
			{ID: 0x1f9f, Name: "TU117M [GeForce MX550]"},
			{ID: 0x1fa0, Name: "TU117M [GeForce MX550]"},
			{ID: 0x1fae, Name: "TU117GL"},
			{ID: 0x1fb0, Name: "TU117GLM [Quadro T1000 Mobile]"},
			{ID: 0x1fb1, Name: "TU117GL [T600]"},
			{ID: 0x1fb2, Name: "TU117GLM [Quadro T400 Mobile]"},
			{ID: 0x1fb8, Name: "TU117GLM [Quadro T2000 Mobile / Max-Q]"},
			{ID: 0x1fb9, Name: "TU117GLM [Quadro T1000 Mobile]"},
			{ID: 0x1fba, Name: "TU117GLM [T600 Mobile]"},
			{ID: 0x1fbb, Name: "TU117GLM [Quadro T500 Mobile]"},
			{ID: 0x1fbc, Name: "TU117GLM [T1200 Laptop GPU]"},
			{ID: 0x1fbf, Name: "TU117GL"},
			{ID: 0x1fd9, Name: "TU117BM [GeForce GTX 1650 Mobile Refresh]"},
			{ID: 0x1fdd, Name: "TU117BM [GeForce GTX 1650 Mobile Refresh]"},
			{ID: 0x1ff0, Name: "TU117GL [T1000 8GB]"},
			{ID: 0x1ff2, Name: "TU117GL [T400 4GB]"},
			{ID: 0x1ff9, Name: "TU117GLM [Quadro T1000 Mobile]"},
			{ID: 0x20b0, Name: "GA100 [A100 SXM4 40GB]"},
			{ID: 0x20b1, Name: "GA100 [A100 PCIe 40GB]"},
			{ID: 0x20b2, Name: "GA100 [A100 SXM4 80GB]"},
			{ID: 0x20b5, Name: "GA100 [A100 PCIe 80GB]"},
			{ID: 0x20b6, Name: "GA100GL [PG506-232]"},
			{ID: 0x20b7, Name: "GA100GL [A30 PCIe]"},
			{ID: 0x20bb, Name: "GA100 [DRIVE A100 PROD]"},
			{ID: 0x20be, Name: "GA100 [GRID A100A]"},
			{ID: 0x20bf, Name: "GA100 [GRID A100B]"},
			{ID: 0x20c2, Name: "GA100 [CMP 170HX]"},
			{ID: 0x20f1, Name: "GA100 [A100 PCIe 40GB]"},
			{ID: 0x2182, Name: "TU116 [GeForce GTX 1660 Ti]"},
			{ID: 0x2183, Name: "TU116"},
			{ID: 0x2184, Name: "TU116 [GeForce GTX 1660]"},
			{ID: 0x2187, Name: "TU116 [GeForce GTX 1650 SUPER]"},
			{ID: 0x2188, Name: "TU116 [GeForce GTX 1650]"},
			{ID: 0x2189, Name: "TU116 [CMP 30HX]"},
			{ID: 0x2191, Name: "TU116M [GeForce GTX 1660 Ti Mobile]"},
			{ID: 0x2192, Name: "TU116M [GeForce GTX 1650 Ti Mobile]"},
			{ID: 0x21ae, Name: "TU116GL"},
			{ID: 0x21bf, Name: "TU116GL"},
			{ID: 0x21c2, Name: "TU116"},
			{ID: 0x21c4, Name: "TU116 [GeForce GTX 1660 SUPER]"},
			{ID: 0x21d1, Name: "TU116BM [GeForce GTX 1660 Ti Mobile]"},
			{ID: 0x2200, Name: "GA102"},
			{ID: 0x2204, Name: "GA102 [GeForce RTX 3090]"},
			{ID: 0x2205, Name: "GA102 [GeForce RTX 3080 Ti 20GB]"},
			{ID: 0x2206, Name: "GA102 [GeForce RTX 3080]"},
			{ID: 0x2208, Name: "GA102 [GeForce RTX 3080 Ti]"},
			{ID: 0x220a, Name: "GA102 [GeForce RTX 3080 12GB]"},
			{ID: 0x220d, Name: "GA102 [CMP 90HX]"},
			{ID: 0x2216, Name: "GA102 [GeForce RTX 3080 Lite Hash Rate]"},
			{ID: 0x222b, Name: "GA102 [GeForce RTX 3090 Engineering Sample]"},
			{ID: 0x222f, Name: "GA102 [GeForce RTX 3080 11GB / 12GB Engineering Sample]"},
			{ID: 0x2230, Name: "GA102GL [RTX A6000]"},
			{ID: 0x2231, Name: "GA102GL [RTX A5000]"},
			{ID: 0x2232, Name: "GA102GL [RTX A4500]"},
			{ID: 0x2235, Name: "GA102GL [A40]"},
			{ID: 0x2236, Name: "GA102GL [A10]"},
			{ID: 0x2237, Name: "GA102GL [A10G]"},
			{ID: 0x223f, Name: "GA102GL"},
			{ID: 0x228b, Name: "GA104 High Definition Audio Controller"},
			{ID: 0x2296, Name: "Tegra PCIe Endpoint Virtual Network"},
			{ID: 0x2302, Name: "GA103"},
			{ID: 0x2321, Name: "GA103"},
			{ID: 0x2414, Name: "GA103 [GeForce RTX 3060 Ti]"},
			{ID: 0x2420, Name: "GA103M [GeForce RTX 3080 Ti Mobile]"},
			{ID: 0x2482, Name: "GA104 [GeForce RTX 3070 Ti]"},
			{ID: 0x2483, Name: "GA104"},
			{ID: 0x2484, Name: "GA104 [GeForce RTX 3070]"},
			{ID: 0x2486, Name: "GA104 [GeForce RTX 3060 Ti]"},
			{ID: 0x2487, Name: "GA104 [GeForce RTX 3060]"},
			{ID: 0x2488, Name: "GA104 [GeForce RTX 3070 Lite Hash Rate]"},
			{ID: 0x2489, Name: "GA104 [GeForce RTX 3060 Ti Lite Hash Rate]"},
			{ID: 0x248a, Name: "GA104 [CMP 70HX]"},
			{ID: 0x249c, Name: "GA104M [GeForce RTX 3080 Mobile / Max-Q 8GB/16GB]"},
			{ID: 0x249d, Name: "GA104M [GeForce RTX 3070 Mobile / Max-Q]"},
			{ID: 0x249f, Name: "GA104M"},
			{ID: 0x24a0, Name: "GA104 [Geforce RTX 3070 Ti Laptop GPU]"},
			{ID: 0x24ac, Name: "GA104 [GeForce RTX 30x0 Engineering Sample]"},
			{ID: 0x24ad, Name: "GA104 [GeForce RTX 3060 Engineering Sample]"},
			{ID: 0x24af, Name: "GA104 [GeForce RTX 3070 Engineering Sample]"},
			{ID: 0x24b0, Name: "GA104GL [RTX A4000]"},
			{ID: 0x24b6, Name: "GA104GLM [RTX A5000 Mobile]"},
			{ID: 0x24b7, Name: "GA104GLM [RTX A4000 Mobile]"},
			{ID: 0x24b8, Name: "GA104GLM [RTX A3000 Mobile]"},
			{ID: 0x24bf, Name: "GA104 [GeForce RTX 3070 Engineering Sample]"},
			{ID: 0x24dc, Name: "GA104M [GeForce RTX 3080 Mobile / Max-Q 8GB/16GB]"},
			{ID: 0x24dd, Name: "GA104M [GeForce RTX 3070 Mobile / Max-Q]"},
			{ID: 0x2501, Name: "GA106 [GeForce RTX 3060]"},
			{ID: 0x2503, Name: "GA106 [GeForce RTX 3060]"},
			{ID: 0x2504, Name: "GA106 [GeForce RTX 3060 Lite Hash Rate]"},
			{ID: 0x2505, Name: "GA106"},
			{ID: 0x2520, Name: "GA106M [GeForce RTX 3060 Mobile / Max-Q]"},
			{ID: 0x2523, Name: "GA106M [GeForce RTX 3050 Ti Mobile / Max-Q]"},
			{ID: 0x252f, Name: "GA106 [GeForce RTX 3060 Engineering Sample]"},
			{ID: 0x2531, Name: "GA106 [RTX A2000]"},
			{ID: 0x2560, Name: "GA106M [GeForce RTX 3060 Mobile / Max-Q]"},
			{ID: 0x2563, Name: "GA106M [GeForce RTX 3050 Ti Mobile / Max-Q]"},
			{ID: 0x2571, Name: "GA106 [RTX A2000 12GB]"},
			{ID: 0x2583, Name: "GA107 [GeForce RTX 3050]"},
			{ID: 0x25a0, Name: "GA107M [GeForce RTX 3050 Ti Mobile]"},
			{ID: 0x25a2, Name: "GA107M [GeForce RTX 3050 Mobile]"},
			{ID: 0x25a4, Name: "GA107"},
			{ID: 0x25a5, Name: "GA107M [GeForce RTX 3050 Mobile]"},
			{ID: 0x25a6, Name: "GA107M [GeForce MX570]"},
			{ID: 0x25a7, Name: "GA107M [GeForce MX570]"},
			{ID: 0x25a9, Name: "GA107M [GeForce RTX 2050]"},
			{ID: 0x25af, Name: "GA107 [GeForce RTX 3050 Engineering Sample]"},
			{ID: 0x25b5, Name: "GA107GLM [RTX A4 Mobile]"},
			{ID: 0x25b6, Name: "GA107GL [A2 / A16]"},
			{ID: 0x25b8, Name: "GA107GLM [RTX A2000 Mobile]"},
			{ID: 0x25e0, Name: "GA107BM [GeForce RTX 3050 Ti Mobile]"},
			{ID: 0x25e2, Name: "GA107BM [GeForce RTX 3050 Mobile]"},
			{ID: 0x25e5, Name: "GA107BM [GeForce RTX 3050 Mobile]"},
		},
	},
	{
		ID: 0x10df, Name: "Emulex Corporation", Devices: []Device{
			{ID: 0x0720, Name: "OneConnect NIC (Skyhawk)"},
			{ID: 0x0722, Name: "OneConnect iSCSI Initiator (Skyhawk)"},
			{ID: 0x0723, Name: "OneConnect iSCSI Initiator + Target (Skyhawk)"},
			{ID: 0x0724, Name: "OneConnect FCoE Initiator (Skyhawk)"},
			{ID: 0x0728, Name: "OneConnect NIC (Skyhawk-VF)"},
			{ID: 0x072a, Name: "OneConnect iSCSI Initiator (Skyhawk-VF)"},
			{ID: 0x072b, Name: "OneConnect iSCSI Initiator + Target (Skyhawk-VF)"},
			{ID: 0x072c, Name: "OneConnect FCoE Initiator (Skyhawk-VF)"},
			{ID: 0x1ae5, Name: "LP6000 Fibre Channel Host Adapter"},
			{ID: 0xe100, Name: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter"},
			{ID: 0xe131, Name: "LightPulse 8Gb/s PCIe Shared I/O Fibre Channel Adapter"},
			{ID: 0xe180, Name: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter"},
			{ID: 0xe200, Name: "LPe15000/LPe16000 Series 8Gb/16Gb Fibre Channel Adapter"},
			{ID: 0xe208, Name: "LightPulse 16Gb Fibre Channel Host Adapter (Lancer-VF)"},
			{ID: 0xe220, Name: "OneConnect NIC (Lancer)"},
			{ID: 0xe240, Name: "OneConnect iSCSI Initiator (Lancer)"},
			{ID: 0xe260, Name: "OneConnect FCoE Initiator (Lancer)"},
			{ID: 0xe268, Name: "OneConnect 10Gb FCoE Converged Network Adapter (Lancer-VF)"},
			{ID: 0xe300, Name: "LPe31000/LPe32000 Series 16Gb/32Gb Fibre Channel Adapter"},
			{ID: 0xf011, Name: "Saturn: LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf015, Name: "Saturn: LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf085, Name: "LP850 Fibre Channel Host Adapter"},
			{ID: 0xf095, Name: "LP952 Fibre Channel Host Adapter"},
			{ID: 0xf098, Name: "LP982 Fibre Channel Host Adapter"},
			{ID: 0xf0a1, Name: "Thor LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf0a5, Name: "Thor LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf0b5, Name: "Viper LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf0d1, Name: "Helios LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf0d5, Name: "Helios LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf0e1, Name: "Zephyr LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf0e5, Name: "Zephyr LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf0f5, Name: "Neptune LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf100, Name: "LPe12000 Series 8Gb Fibre Channel Adapter"},
			{ID: 0xf111, Name: "Saturn-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf112, Name: "Saturn-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xf180, Name: "LPSe12002 EmulexSecure Fibre Channel Adapter"},
			{ID: 0xf400, Name: "LPe35000/LPe36000 Series 32Gb/64Gb Fibre Channel Adapter"},
			{ID: 0xf500, Name: "LPe37000/LPe38000 Series 32Gb/64Gb Fibre Channel Adapter"},
			{ID: 0xf700, Name: "LP7000 Fibre Channel Host Adapter"},
			{ID: 0xf701, Name: "LP7000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)"},
			{ID: 0xf800, Name: "LP8000 Fibre Channel Host Adapter"},
			{ID: 0xf801, Name: "LP8000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)"},
			{ID: 0xf900, Name: "LP9000 Fibre Channel Host Adapter"},
			{ID: 0xf901, Name: "LP9000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)"},
			{ID: 0xf980, Name: "LP9802 Fibre Channel Host Adapter"},
			{ID: 0xf981, Name: "LP9802 Fibre Channel Host Adapter Alternate ID"},
			{ID: 0xf982, Name: "LP9802 Fibre Channel Host Adapter Alternate ID"},
			{ID: 0xfa00, Name: "Thor-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfb00, Name: "Viper LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfc00, Name: "Thor-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfc10, Name: "Helios-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfc20, Name: "Zephyr-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfc40, Name: "Saturn-X: LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfc50, Name: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter"},
			{ID: 0xfd00, Name: "Helios-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfd11, Name: "Helios-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfd12, Name: "Helios-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfe00, Name: "Zephyr-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfe05, Name: "Zephyr-X: LightPulse FCoE Adapter"},
			{ID: 0xfe11, Name: "Zephyr-X LightPulse Fibre Channel Host Adapter"},
			{ID: 0xfe12, Name: "Zephyr-X LightPulse FCoE Adapter"},
			{ID: 0xff00, Name: "Neptune LightPulse Fibre Channel Host Adapter"},
		},
	},
	{
		ID: 0x10e0, Name: "Integrated Micro Solutions Inc.", Devices: []Device{
			{ID: 0x5026, Name: "IMS5026/27/28"},
			{ID: 0x5027, Name: "IMS5027"},
			{ID: 0x5028, Name: "IMS5028"},
			{ID: 0x8849, Name: "IMS8849"},
			{ID: 0x8853, Name: "IMS8853"},
			{ID: 0x9128, Name: "IMS9128 [Twin turbo 128]"},
		},
	},
	{
		ID: 0x10e1, Name: "Tekram Technology Co.,Ltd.", Devices: []Device{
			{ID: 0x0391, Name: "TRM-S1040"},
			{ID: 0x690c, Name: "DC-690c"},
			{ID: 0xdc29, Name: "DC-290"},
		},
	},
	{ID: 0x10e2, Name: "Aptix Corporation", Devices: []Device{}},
	{
		ID: 0x10e3, Name: "Tundra Semiconductor Corp.", Devices: []Device{
			{ID: 0x0000, Name: "CA91C042 [Universe]"},
			{ID: 0x0108, Name: "Tsi108 Host Bridge for Single PowerPC"},
			{ID: 0x0148, Name: "Tsi148 [Tempe]"},
			{ID: 0x0860, Name: "CA91C860 [QSpan]"},
			{ID: 0x0862, Name: "CA91C862A [QSpan-II]"},
			{ID: 0x8111, Name: "Tsi381 PCIe to PCI Bridge"},
			{ID: 0x8260, Name: "CA91L8200B [Dual PCI PowerSpan II]"},
			{ID: 0x8261, Name: "CA91L8260B [Single PCI PowerSpan II]"},
			{ID: 0xa108, Name: "Tsi109 Host Bridge for Dual PowerPC"},
		},
	},
	{
		ID: 0x10e4, Name: "Tandem Computers", Devices: []Device{
			{ID: 0x8029, Name: "Realtek 8029 Network Card"},
		},
	},
	{ID: 0x10e5, Name: "Micro Industries Corporation", Devices: []Device{}},
	{ID: 0x10e6, Name: "Gainbery Computer Products Inc.", Devices: []Device{}},
	{ID: 0x10e7, Name: "Vadem", Devices: []Device{}},
	{
		ID: 0x10e8, Name: "Applied Micro Circuits Corp.", Devices: []Device{
			{ID: 0x1072, Name: "INES GPIB-PCI (AMCC5920 based)"},
			{ID: 0x2011, Name: "Q-Motion Video Capture/Edit board"},
			{ID: 0x4750, Name: "S5930 [Matchmaker]"},
			{ID: 0x5920, Name: "S5920"},
			{ID: 0x8043, Name: "LANai4.x [Myrinet LANai interface chip]"},
			{ID: 0x8062, Name: "S5933_PARASTATION"},
			{ID: 0x807d, Name: "S5933 [Matchmaker]"},
			{ID: 0x8088, Name: "Kongsberg Spacetec Format Synchronizer"},
			{ID: 0x8089, Name: "Kongsberg Spacetec Serial Output Board"},
			{ID: 0x809c, Name: "S5933_HEPC3"},
			{ID: 0x80b9, Name: "Harmonix Hi-Card P8 (4x active ISDN BRI)"},
			{ID: 0x80d7, Name: "PCI-9112"},
			{ID: 0x80d8, Name: "PCI-7200"},
			{ID: 0x80d9, Name: "PCI-9118"},
			{ID: 0x80da, Name: "PCI-9812"},
			{ID: 0x80fc, Name: "APCI1500 Signal processing controller (16 dig. inputs + 16 dig. outputs)"},
			{ID: 0x811a, Name: "PCI-IEEE1355-DS-DE Interface"},
			{ID: 0x814c, Name: "Fastcom ESCC-PCI (Commtech, Inc.)"},
			{ID: 0x8170, Name: "S5933 [Matchmaker] (Chipset Development Tool)"},
			{ID: 0x81e6, Name: "Multimedia video controller"},
			{ID: 0x828d, Name: "APCI3001 Signal processing controller (up to 16 analog inputs)"},
			{ID: 0x8291, Name: "Fastcom 232/8-PCI (Commtech, Inc.)"},
			{ID: 0x82c4, Name: "Fastcom 422/4-PCI (Commtech, Inc.)"},
			{ID: 0x82c5, Name: "Fastcom 422/2-PCI (Commtech, Inc.)"},
			{ID: 0x82c6, Name: "Fastcom IG422/1-PCI (Commtech, Inc.)"},
			{ID: 0x82c7, Name: "Fastcom IG232/2-PCI (Commtech, Inc.)"},
			{ID: 0x82ca, Name: "Fastcom 232/4-PCI (Commtech, Inc.)"},
			{ID: 0x82db, Name: "AJA HDNTV HD SDI Framestore"},
			{ID: 0x82e2, Name: "Fastcom DIO24H-PCI (Commtech, Inc.)"},
			{ID: 0x8406, Name: "PCIcanx/PCIcan CAN interface [Kvaser AB]"},
			{ID: 0x8407, Name: "PCIcan II CAN interface (A1021, PCB-07, PCB-08) [Kvaser AB]"},
			{ID: 0x8851, Name: "S5933 on Innes Corp FM Radio Capture card"},
			{ID: 0xe004, Name: "X-Gene PCIe bridge"},
		},
	},
	{ID: 0x10e9, Name: "Alps Electric Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x10ea, Name: "Integraphics", Devices: []Device{
			{ID: 0x1680, Name: "IGA-1680"},
			{ID: 0x1682, Name: "IGA-1682"},
			{ID: 0x1683, Name: "IGA-1683"},
			{ID: 0x2000, Name: "CyberPro 2000"},
			{ID: 0x2010, Name: "CyberPro 2000A"},
			{ID: 0x5000, Name: "CyberPro 5000"},
			{ID: 0x5050, Name: "CyberPro 5050"},
			{ID: 0x5202, Name: "CyberPro 5202"},
			{ID: 0x5252, Name: "CyberPro5252"},
		},
	},
	{
		ID: 0x10eb, Name: "Artists Graphics", Devices: []Device{
			{ID: 0x0101, Name: "3GA"},
			{ID: 0x8111, Name: "Twist3 Frame Grabber"},
		},
	},
	{
		ID: 0x10ec, Name: "Realtek Semiconductor Co., Ltd.", Devices: []Device{
			{ID: 0x0139, Name: "RTL-8139/8139C/8139C+ Ethernet Controller"},
			{ID: 0x3000, Name: "Killer E3000 2.5GbE Controller"},
			{ID: 0x5208, Name: "RTS5208 PCI Express Card Reader"},
			{ID: 0x5209, Name: "RTS5209 PCI Express Card Reader"},
			{ID: 0x5227, Name: "RTS5227 PCI Express Card Reader"},
			{ID: 0x5229, Name: "RTS5229 PCI Express Card Reader"},
			{ID: 0x522a, Name: "RTS522A PCI Express Card Reader"},
			{ID: 0x5249, Name: "RTS5249 PCI Express Card Reader"},
			{ID: 0x524a, Name: "RTS524A PCI Express Card Reader"},
			{ID: 0x5250, Name: "RTS5250 PCI Express Card Reader"},
			{ID: 0x525a, Name: "RTS525A PCI Express Card Reader"},
			{ID: 0x5260, Name: "RTS5260 PCI Express Card Reader"},
			{ID: 0x5286, Name: "RTS5286 PCI Express Card Reader"},
			{ID: 0x5287, Name: "RTL8411B PCI Express Card Reader"},
			{ID: 0x5288, Name: "RTS5288 PCI Express Card Reader"},
			{ID: 0x5289, Name: "RTL8411 PCI Express Card Reader"},
			{ID: 0x5762, Name: "RTS5763DL NVMe SSD Controller"},
			{ID: 0x8029, Name: "RTL-8029(AS)"},
			{ID: 0x8125, Name: "RTL8125 2.5GbE Controller"},
			{ID: 0x8129, Name: "RTL-8129"},
			{ID: 0x8136, Name: "RTL810xE PCI Express Fast Ethernet controller"},
			{ID: 0x8137, Name: "RTL8104E PCIe Fast Ethernet Controller"},
			{ID: 0x8138, Name: "RT8139 (B/C) Cardbus Fast Ethernet Adapter"},
			{ID: 0x8139, Name: "RTL-8100/8101L/8139 PCI Fast Ethernet Adapter"},
			{ID: 0x8161, Name: "RTL8111/8168/8411 PCI Express Gigabit Ethernet Controller"},
			{ID: 0x8167, Name: "RTL-8110SC/8169SC Gigabit Ethernet"},
			{ID: 0x8168, Name: "RTL8111/8168/8411 PCI Express Gigabit Ethernet Controller"},
			{ID: 0x8169, Name: "RTL8169 PCI Gigabit Ethernet Controller"},
			{ID: 0x816a, Name: "RTL8111xP UART #1"},
			{ID: 0x816b, Name: "RTL8111xP UART #2"},
			{ID: 0x816c, Name: "RTL8111xP IPMI interface"},
			{ID: 0x816d, Name: "RTL811x EHCI host controller"},
			{ID: 0x816e, Name: "Realtek RealManage BMC"},
			{ID: 0x8171, Name: "RTL8191SEvA Wireless LAN Controller"},
			{ID: 0x8172, Name: "RTL8191SEvB Wireless LAN Controller"},
			{ID: 0x8173, Name: "RTL8192SE Wireless LAN Controller"},
			{ID: 0x8174, Name: "RTL8192SE Wireless LAN Controller"},
			{ID: 0x8176, Name: "RTL8188CE 802.11b/g/n WiFi Adapter"},
			{ID: 0x8177, Name: "RTL8191CE PCIe Wireless Network Adapter"},
			{ID: 0x8178, Name: "RTL8192CE PCIe Wireless Network Adapter"},
			{ID: 0x8179, Name: "RTL8188EE Wireless Network Adapter"},
			{ID: 0x8180, Name: "RTL8180L 802.11b MAC"},
			{ID: 0x8185, Name: "RTL-8185 IEEE 802.11a/b/g Wireless LAN Controller"},
			{ID: 0x818b, Name: "RTL8192EE PCIe Wireless Network Adapter"},
			{ID: 0x8190, Name: "RTL8190 802.11n PCI Wireless Network Adapter"},
			{ID: 0x8191, Name: "RTL8192CE PCIe Wireless Network Adapter"},
			{ID: 0x8192, Name: "RTL8192E/RTL8192SE Wireless LAN Controller"},
			{ID: 0x8193, Name: "RTL8192DE Wireless LAN Controller"},
			{ID: 0x8196, Name: "RTL8196 Integrated PCI-e Bridge"},
			{ID: 0x8197, Name: "SmartLAN56 56K Modem"},
			{ID: 0x8199, Name: "RTL8187SE Wireless LAN Controller"},
			{ID: 0x8723, Name: "RTL8723AE PCIe Wireless Network Adapter"},
			{ID: 0x8812, Name: "RTL8812AE 802.11ac PCIe Wireless Network Adapter"},
			{ID: 0x8813, Name: "RTL8813AE 802.11ac PCIe Wireless Network Adapter"},
			{ID: 0x8821, Name: "RTL8821AE 802.11ac PCIe Wireless Network Adapter"},
			{ID: 0x8852, Name: "RTL8852AE 802.11ax PCIe Wireless Network Adapter"},
			{ID: 0xb723, Name: "RTL8723BE PCIe Wireless Network Adapter"},
			{ID: 0xb822, Name: "RTL8822BE 802.11a/b/g/n/ac WiFi adapter"},
			{ID: 0xc821, Name: "RTL8821CE 802.11ac PCIe Wireless Network Adapter"},
			{ID: 0xc822, Name: "RTL8822CE 802.11ac PCIe Wireless Network Adapter"},
			{ID: 0xc82f, Name: "RTL8822CE 802.11ac PCIe Wireless Network Adapter"},
			{ID: 0xd723, Name: "RTL8723DE 802.11b/g/n PCIe Adapter"},
		},
	},
	{
		ID: 0x10ed, Name: "Ascii Corporation", Devices: []Device{
			{ID: 0x7310, Name: "V7310"},
		},
	},
	{
		ID: 0x10ee, Name: "Xilinx Corporation", Devices: []Device{
			{ID: 0x0001, Name: "EUROCOM for PCI (ECOMP)"},
			{ID: 0x0002, Name: "Octal E1/T1 for PCI ETP Card"},
			{ID: 0x0007, Name: "Default PCIe endpoint ID"},
			{ID: 0x0205, Name: "Wildcard TE205P"},
			{ID: 0x0210, Name: "Wildcard TE210P"},
			{ID: 0x0300, Name: "Spartan 3 Designs (Xilinx IP)"},
			{ID: 0x0314, Name: "Wildcard TE405P/TE410P (1st Gen)"},
			{ID: 0x0405, Name: "Wildcard TE405P (2nd Gen)"},
			{ID: 0x0410, Name: "Wildcard TE410P (2nd Gen)"},
			{ID: 0x0600, Name: "Xilinx 6 Designs (Xilinx IP)"},
			{ID: 0x3fc0, Name: "RME Digi96"},
			{ID: 0x3fc1, Name: "RME Digi96/8"},
			{ID: 0x3fc2, Name: "RME Digi96/8 Pro"},
			{ID: 0x3fc3, Name: "RME Digi96/8 Pad"},
			{ID: 0x3fc4, Name: "RME Digi9652 (Hammerfall)"},
			{ID: 0x3fc5, Name: "RME Hammerfall DSP"},
			{ID: 0x3fc6, Name: "RME Hammerfall DSP MADI"},
			{ID: 0x5005, Name: "Alveo U250"},
			{ID: 0x7038, Name: "FPGA Card XC7VX690T"},
			{ID: 0x8019, Name: "Memory controller"},
			{ID: 0x8380, Name: "Ellips ProfiXpress Profibus Master"},
			{ID: 0x8381, Name: "Ellips Santos Frame Grabber"},
			{ID: 0xd154, Name: "Copley Controls CAN card (PCI-CAN-02)"},
			{ID: 0xebf0, Name: "SED Systems Modulator/Demodulator"},
			{ID: 0xebf1, Name: "SED Systems Audio Interface Card"},
			{ID: 0xebf2, Name: "SED Systems Common PCI Interface"},
			{ID: 0xebf3, Name: "SED Systems PCIe-AXI Bridge"},
		},
	},
	{
		ID: 0x10ef, Name: "Racore Computer Products, Inc.", Devices: []Device{
			{ID: 0x8154, Name: "M815x Token Ring Adapter"},
		},
	},
	{ID: 0x10f0, Name: "Peritek Corporation", Devices: []Device{}},
	{
		ID: 0x10f1, Name: "Tyan Computer", Devices: []Device{
			{ID: 0x2865, Name: "Tyan Thunder K8E S2865"},
			{ID: 0x5300, Name: "Tyan S5380 Mainboard"},
		},
	},
	{ID: 0x10f2, Name: "Achme Computer, Inc.", Devices: []Device{}},
	{ID: 0x10f3, Name: "Alaris, Inc.", Devices: []Device{}},
	{ID: 0x10f4, Name: "S-MOS Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x10f5, Name: "NKK Corporation", Devices: []Device{
			{ID: 0xa001, Name: "NDR4000 [NR4600 Bridge]"},
		},
	},
	{ID: 0x10f6, Name: "Creative Electronic Systems SA", Devices: []Device{}},
	{ID: 0x10f7, Name: "Matsushita Electric Industrial Co., Ltd.", Devices: []Device{}},
	{ID: 0x10f8, Name: "Altos India Ltd", Devices: []Device{}},
	{ID: 0x10f9, Name: "PC Direct", Devices: []Device{}},
	{
		ID: 0x10fa, Name: "Truevision", Devices: []Device{
			{ID: 0x000c, Name: "TARGA 1000"},
		},
	},
	{
		ID: 0x10fb, Name: "Thesys Gesellschaft fuer Mikroelektronik mbH", Devices: []Device{
			{ID: 0x186f, Name: "TH 6255"},
		},
	},
	{
		ID: 0x10fc, Name: "I-O Data Device, Inc.", Devices: []Device{
			{ID: 0x0003, Name: "Cardbus IDE Controller"},
			{ID: 0x0005, Name: "Cardbus SCSI CBSC II"},
		},
	},
	{ID: 0x10fd, Name: "Soyo Computer, Inc", Devices: []Device{}},
	{ID: 0x10fe, Name: "Fast Multimedia AG", Devices: []Device{}},
	{ID: 0x10ff, Name: "NCube", Devices: []Device{}},
	{ID: 0x1100, Name: "Jazz Multimedia", Devices: []Device{}},
	{
		ID: 0x1101, Name: "Initio Corporation", Devices: []Device{
			{ID: 0x0002, Name: "INI-920 Ultra SCSI Adapter"},
			{ID: 0x1060, Name: "INI-A100U2W"},
			{ID: 0x1622, Name: "INI-1623 PCI SATA-II Controller"},
			{ID: 0x9100, Name: "INI-9100/9100W"},
			{ID: 0x9400, Name: "INI-940 Fast Wide SCSI Adapter"},
			{ID: 0x9401, Name: "INI-935 Fast Wide SCSI Adapter"},
			{ID: 0x9500, Name: "INI-950 SCSI Adapter"},
			{ID: 0x9502, Name: "INI-950P Ultra Wide SCSI Adapter"},
		},
	},
	{
		ID: 0x1102, Name: "Creative Labs", Devices: []Device{
			{ID: 0x0002, Name: "EMU10k1 [Sound Blaster Live! Series]"},
			{ID: 0x0003, Name: "SB AWE64(D)"},
			{ID: 0x0004, Name: "EMU10k2/CA0100/CA0102/CA10200 [Sound Blaster Audigy Series]"},
			{ID: 0x0005, Name: "EMU20k1 [Sound Blaster X-Fi Series]"},
			{ID: 0x0006, Name: "EMU10k1X / CA0103 [SB Live! OEM / SB 5.1 / Ectiva 5.1]"},
			{ID: 0x0007, Name: "CA0106/CA0111 [SB Live!/Audigy/X-Fi Series]"},
			{ID: 0x0008, Name: "CA0108/CA10300 [Sound Blaster Audigy Series]"},
			{ID: 0x0009, Name: "CA0110 [Sound Blaster X-Fi Xtreme Audio]"},
			{ID: 0x000b, Name: "EMU20k2 [Sound Blaster X-Fi Titanium Series]"},
			{ID: 0x0012, Name: "Sound Core3D [Sound Blaster Recon3D / Z-Series]"},
			{ID: 0x4001, Name: "SB Audigy FireWire Port"},
			{ID: 0x7002, Name: "SB Live! Game Port"},
			{ID: 0x7003, Name: "SB Audigy Game Port"},
			{ID: 0x7004, Name: "[SB Live! Value] Input device controller"},
			{ID: 0x7005, Name: "SB Audigy LS Game Port"},
			{ID: 0x7006, Name: "[SB X-Fi Xtreme Audio] CA0110-IBG PCIe to PCI Bridge"},
			{ID: 0x8938, Name: "Ectiva EV1938"},
		},
	},
	{
		ID: 0x1103, Name: "HighPoint Technologies, Inc.", Devices: []Device{
			{ID: 0x0003, Name: "HPT343/345/346/363"},
			{ID: 0x0004, Name: "HPT366/368/370/370A/372/372N"},
			{ID: 0x0005, Name: "HPT372A/372N"},
			{ID: 0x0006, Name: "HPT302/302N"},
			{ID: 0x0007, Name: "HPT371/371N"},
			{ID: 0x0008, Name: "HPT374"},
			{ID: 0x0009, Name: "HPT372N"},
			{ID: 0x0620, Name: "RocketRAID 620 2 Port SATA-III Controller"},
			{ID: 0x0622, Name: "RocketRAID 622 2 Port SATA-III Controller"},
			{ID: 0x0640, Name: "RocketRAID 640 4 Port SATA-III Controller"},
			{ID: 0x0641, Name: "RocketRAID 640L 4 Port SATA-III Controller"},
			{ID: 0x0642, Name: "RocketRAID 642L SATA-III Controller (2 eSATA ports + 2 internal SATA ports)"},
			{ID: 0x0644, Name: "RocketRAID 644 4 Port SATA-III Controller (eSATA)"},
			{ID: 0x0645, Name: "RocketRAID 644L 4 Port SATA-III Controller (eSATA)"},
			{ID: 0x0646, Name: "RocketRAID 644LS SATA-III Controller (4 eSATA devices connected by 1 SAS cable)"},
			{ID: 0x1720, Name: "RocketRAID 1720 (2x SATA II RAID Controller)"},
			{ID: 0x1740, Name: "RocketRAID 1740"},
			{ID: 0x1742, Name: "RocketRAID 1742"},
			{ID: 0x2210, Name: "RocketRAID 2210 SATA-II Controller"},
			{ID: 0x2300, Name: "RocketRAID 230x 4 Port SATA-II Controller"},
			{ID: 0x2310, Name: "RocketRAID 2310 4 Port SATA-II Controller"},
			{ID: 0x2320, Name: "RocketRAID 2320 SATA-II Controller"},
			{ID: 0x2322, Name: "RocketRAID 2322 SATA-II Controller"},
			{ID: 0x2340, Name: "RocketRAID 2340 16 Port SATA-II Controller"},
			{ID: 0x2640, Name: "RocketRAID 2640 SAS/SATA Controller"},
			{ID: 0x2722, Name: "RocketRAID 2722"},
			{ID: 0x2740, Name: "RocketRAID 2740"},
			{ID: 0x2744, Name: "RocketRaid 2744"},
			{ID: 0x2782, Name: "RocketRAID 2782"},
			{ID: 0x3120, Name: "RocketRAID 3120"},
			{ID: 0x3220, Name: "RocketRAID 3220"},
			{ID: 0x3320, Name: "RocketRAID 3320"},
			{ID: 0x4310, Name: "RocketRaid 4310"},
			{ID: 0x7505, Name: "SSD7505 PCIe Gen4 x16 4-Port M.2 NVMe RAID Controller"},
		},
	},
	{ID: 0x1104, Name: "RasterOps Corp.", Devices: []Device{}},
	{
		ID: 0x1105, Name: "Sigma Designs, Inc.", Devices: []Device{
			{ID: 0x1105, Name: "REALmagic Xcard MPEG 1/2/3/4 DVD Decoder"},
			{ID: 0x8300, Name: "REALmagic Hollywood Plus DVD Decoder"},
			{ID: 0x8400, Name: "EM840x REALmagic DVD/MPEG-2 Audio/Video Decoder"},
			{ID: 0x8401, Name: "EM8401 REALmagic DVD/MPEG-2 A/V Decoder"},
			{ID: 0x8470, Name: "EM8470 REALmagic DVD/MPEG-4 A/V Decoder"},
			{ID: 0x8471, Name: "EM8471 REALmagic DVD/MPEG-4 A/V Decoder"},
			{ID: 0x8475, Name: "EM8475 REALmagic DVD/MPEG-4 A/V Decoder"},
			{ID: 0x8476, Name: "EM8476 REALmagic DVD/MPEG-4 A/V Decoder"},
			{ID: 0x8485, Name: "EM8485 REALmagic DVD/MPEG-4 A/V Decoder"},
			{ID: 0x8486, Name: "EM8486 REALmagic DVD/MPEG-4 A/V Decoder"},
			{ID: 0xc621, Name: "EM8621L Digital Media Processor"},
			{ID: 0xc622, Name: "EM8622L MPEG-4.10 (H.264) and SMPTE 421M (VC-1) A/V Decoder"},
		},
	},
	{
		ID: 0x1106, Name: "VIA Technologies, Inc.", Devices: []Device{
			{ID: 0x0102, Name: "Embedded VIA Ethernet Controller"},
			{ID: 0x0130, Name: "VT6305 1394.A Controller"},
			{ID: 0x0198, Name: "P4X600 Host Bridge"},
			{ID: 0x0204, Name: "K8M800 Host Bridge"},
			{ID: 0x0208, Name: "PT890 Host Bridge"},
			{ID: 0x0238, Name: "K8T890 Host Bridge"},
			{ID: 0x0258, Name: "PT880 Host Bridge"},
			{ID: 0x0259, Name: "CN333/CN400/PM880 Host Bridge"},
			{ID: 0x0269, Name: "KT880 Host Bridge"},
			{ID: 0x0282, Name: "K8T800Pro Host Bridge"},
			{ID: 0x0290, Name: "K8M890 Host Bridge"},
			{ID: 0x0293, Name: "PM896 Host Bridge"},
			{ID: 0x0296, Name: "P4M800 Host Bridge"},
			{ID: 0x0305, Name: "VT8363/8365 [KT133/KM133]"},
			{ID: 0x0308, Name: "PT880 Ultra/PT894 Host Bridge"},
			{ID: 0x0314, Name: "CN700/VN800/P4M800CE/Pro Host Bridge"},
			{ID: 0x0324, Name: "CX700/VX700 Host Bridge"},
			{ID: 0x0327, Name: "P4M890 Host Bridge"},
			{ID: 0x0336, Name: "K8M890CE Host Bridge"},
			{ID: 0x0340, Name: "PT900 Host Bridge"},
			{ID: 0x0351, Name: "K8T890CF Host Bridge"},
			{ID: 0x0353, Name: "VX800/820-Series Chipset Host-Bridge Controller"},
			{ID: 0x0364, Name: "CN896/VN896/P4M900 Host Bridge"},
			{ID: 0x0391, Name: "VT8371 [KX133]"},
			{ID: 0x0409, Name: "VX855/VX875 Host Bridge: Host Control"},
			{ID: 0x0410, Name: "VX900 Series Host Bridge: Host Control"},
			{ID: 0x0415, Name: "VT6415 PATA IDE Host Controller"},
			{ID: 0x0501, Name: "VT8501 [Apollo MVP4]"},
			{ID: 0x0505, Name: "VT82C505"},
			{ID: 0x0561, Name: "VT82C576MV"},
			{ID: 0x0571, Name: "VT82C586A/B/VT82C686/A/B/VT823x/A/C PIPC Bus Master IDE"},
			{ID: 0x0576, Name: "VT82C576 3V [Apollo Master]"},
			{ID: 0x0581, Name: "CX700/VX700/VX800/820-Series Serial ATA RAID-Controller"},
			{ID: 0x0585, Name: "VT82C585VP [Apollo VP1/VPX]"},
			{ID: 0x0586, Name: "VT82C586/A/B PCI-to-ISA [Apollo VP]"},
			{ID: 0x0591, Name: "VT8237A SATA 2-Port Controller"},
			{ID: 0x0595, Name: "VT82C595 [Apollo VP2]"},
			{ID: 0x0596, Name: "VT82C596 ISA [Mobile South]"},
			{ID: 0x0597, Name: "VT82C597 [Apollo VP3]"},
			{ID: 0x0598, Name: "VT82C598 [Apollo MVP3]"},
			{ID: 0x0601, Name: "VT8601 [Apollo ProMedia]"},
			{ID: 0x0605, Name: "VT8605 [ProSavage PM133]"},
			{ID: 0x0680, Name: "VT82C680 [Apollo P6]"},
			{ID: 0x0686, Name: "VT82C686 [Apollo Super South]"},
			{ID: 0x0691, Name: "VT82C693A/694x [Apollo PRO133x]"},
			{ID: 0x0693, Name: "VT82C693 [Apollo Pro Plus]"},
			{ID: 0x0698, Name: "VT82C693A [Apollo Pro133 AGP]"},
			{ID: 0x0709, Name: "VX11 Standard Host Bridge"},
			{ID: 0x070a, Name: "VX11 PCI Express Root Port"},
			{ID: 0x070b, Name: "VX11 PCI Express Root Port"},
			{ID: 0x070c, Name: "VX11 PCI Express Root Port"},
			{ID: 0x070d, Name: "VX11 PCI Express Root Port"},
			{ID: 0x070e, Name: "VX11 PCI Express Root Port"},
			{ID: 0x0926, Name: "VT82C926 [Amazon]"},
			{ID: 0x1000, Name: "VT82C570MV"},
			{ID: 0x1106, Name: "VT82C570MV"},
			{ID: 0x1122, Name: "VX800/VX820 Chrome 9 HC3 Integrated Graphics"},
			{ID: 0x1204, Name: "K8M800 Host Bridge"},
			{ID: 0x1208, Name: "PT890 Host Bridge"},
			{ID: 0x1238, Name: "K8T890 Host Bridge"},
			{ID: 0x1258, Name: "PT880 Host Bridge"},
			{ID: 0x1259, Name: "CN333/CN400/PM880 Host Bridge"},
			{ID: 0x1269, Name: "KT880 Host Bridge"},
			{ID: 0x1282, Name: "K8T800Pro Host Bridge"},
			{ID: 0x1290, Name: "K8M890 Host Bridge"},
			{ID: 0x1293, Name: "PM896 Host Bridge"},
			{ID: 0x1296, Name: "P4M800 Host Bridge"},
			{ID: 0x1308, Name: "PT894 Host Bridge"},
			{ID: 0x1314, Name: "CN700/VN800/P4M800CE/Pro Host Bridge"},
			{ID: 0x1324, Name: "CX700/VX700-Series Error Reporting"},
			{ID: 0x1327, Name: "P4M890 Host Bridge"},
			{ID: 0x1336, Name: "K8M890CE Host Bridge"},
			{ID: 0x1340, Name: "PT900 Host Bridge"},
			{ID: 0x1351, Name: "VT3351 Host Bridge"},
			{ID: 0x1353, Name: "VX800/VX820 Error Reporting"},
			{ID: 0x1364, Name: "CN896/VN896/P4M900 Host Bridge"},
			{ID: 0x1409, Name: "VX855/VX875 Error Reporting"},
			{ID: 0x1410, Name: "VX900 Series Error Reporting"},
			{ID: 0x1571, Name: "VT82C576M/VT82C586"},
			{ID: 0x1595, Name: "VT82C595/97 [Apollo VP2/97]"},
			{ID: 0x1732, Name: "VT1732 [Envy24 II] PCI Multi-Channel Audio Controller"},
			{ID: 0x2106, Name: "VIA Rhine Family Fast Ethernet Adapter (VT6105)"},
			{ID: 0x2204, Name: "K8M800 Host Bridge"},
			{ID: 0x2208, Name: "PT890 Host Bridge"},
			{ID: 0x2238, Name: "K8T890 Host Bridge"},
			{ID: 0x2258, Name: "PT880 Host Bridge"},
			{ID: 0x2259, Name: "CN333/CN400/PM880 CPU Host Bridge"},
			{ID: 0x2269, Name: "KT880 Host Bridge"},
			{ID: 0x2282, Name: "K8T800Pro Host Bridge"},
			{ID: 0x2290, Name: "K8M890 Host Bridge"},
			{ID: 0x2293, Name: "PM896 Host Bridge"},
			{ID: 0x2296, Name: "P4M800 Host Bridge"},
			{ID: 0x2308, Name: "PT894 Host Bridge"},
			{ID: 0x2314, Name: "CN700/VN800/P4M800CE/Pro Host Bridge"},
			{ID: 0x2324, Name: "CX700/VX700-Series Host Interface Control"},
			{ID: 0x2327, Name: "P4M890 Host Bridge"},
			{ID: 0x2336, Name: "K8M890CE Host Bridge"},
			{ID: 0x2340, Name: "PT900 Host Bridge"},
			{ID: 0x2351, Name: "VT3351 Host Bridge"},
			{ID: 0x2353, Name: "VX800/VX820 Host Bus Control"},
			{ID: 0x2364, Name: "CN896/VN896/P4M900 Host Bridge"},
			{ID: 0x2409, Name: "VX855/VX875 Host Bus Control"},
			{ID: 0x2410, Name: "VX900 Series CPU Bus Controller"},
			{ID: 0x287a, Name: "VT8251 PCI to PCI Bridge"},
			{ID: 0x287b, Name: "VT8251 Host Bridge"},
			{ID: 0x287c, Name: "VT8251 PCIE Root Port"},
			{ID: 0x287d, Name: "VT8251 PCIE Root Port"},
			{ID: 0x287e, Name: "VT8237/8251 Ultra VLINK Controller"},
			{ID: 0x3022, Name: "CLE266"},
			{ID: 0x3038, Name: "VT82xx/62xx/VX700/8x0/900 UHCI USB 1.1 Controller"},
			{ID: 0x3040, Name: "VT82C586B ACPI"},
			{ID: 0x3043, Name: "VT86C100A [Rhine]"},
			{ID: 0x3044, Name: "VT6306/7/8 [Fire II(M)] IEEE 1394 OHCI Controller"},
			{ID: 0x3050, Name: "VT82C596 Power Management"},
			{ID: 0x3051, Name: "VT82C596 Power Management"},
			{ID: 0x3053, Name: "VT6105M [Rhine-III]"},
			{ID: 0x3057, Name: "VT82C686 [Apollo Super ACPI]"},
			{ID: 0x3058, Name: "VT82C686 AC97 Audio Controller"},
			{ID: 0x3059, Name: "VT8233/A/8235/8237 AC97 Audio Controller"},
			{ID: 0x3065, Name: "VT6102/VT6103 [Rhine-II]"},
			{ID: 0x3068, Name: "AC'97 Modem Controller"},
			{ID: 0x3074, Name: "VT8233 PCI to ISA Bridge"},
			{ID: 0x3091, Name: "VT8633 [Apollo Pro266]"},
			{ID: 0x3099, Name: "VT8366/A/7 [Apollo KT266/A/333]"},
			{ID: 0x3101, Name: "VT8653 Host Bridge"},
			{ID: 0x3102, Name: "VT8662 Host Bridge"},
			{ID: 0x3103, Name: "VT8615 Host Bridge"},
			{ID: 0x3104, Name: "USB 2.0 EHCI-Compliant Host-Controller"},
			{ID: 0x3106, Name: "VT6105/VT6106S [Rhine-III]"},
			{ID: 0x3108, Name: "K8M800/K8N800/K8N800A [S3 UniChrome Pro]"},
			{ID: 0x3109, Name: "VT8233C PCI to ISA Bridge"},
			{ID: 0x3112, Name: "VT8361 [KLE133] Host Bridge"},
			{ID: 0x3113, Name: "VPX/VPX2 PCI to PCI Bridge Controller"},
			{ID: 0x3116, Name: "VT8375 [KM266/KL266] Host Bridge"},
			{ID: 0x3118, Name: "CN400/PM800/PM880/PN800/PN880 [S3 UniChrome Pro]"},
			{ID: 0x3119, Name: "VT6120/VT6121/VT6122 Gigabit Ethernet Adapter"},
			{ID: 0x3122, Name: "VT8623 [Apollo CLE266] integrated CastleRock graphics"},
			{ID: 0x3123, Name: "VT8623 [Apollo CLE266]"},
			{ID: 0x3128, Name: "VT8753 [P4X266 AGP]"},
			{ID: 0x3133, Name: "VT3133 Host Bridge"},
			{ID: 0x3142, Name: "VT6651 WiFi Adapter, 802.11b"},
			{ID: 0x3147, Name: "VT8233A ISA Bridge"},
			{ID: 0x3148, Name: "P4M266 Host Bridge"},
			{ID: 0x3149, Name: "VIA VT6420 SATA RAID Controller"},
			{ID: 0x3156, Name: "P/KN266 Host Bridge"},
			{ID: 0x3157, Name: "CX700/VX700 [S3 UniChrome Pro]"},
			{ID: 0x3164, Name: "VT6410 ATA133 RAID controller"},
			{ID: 0x3168, Name: "P4X333/P4X400/PT800 AGP Bridge"},
			{ID: 0x3177, Name: "VT8235 ISA Bridge"},
			{ID: 0x3178, Name: "ProSavageDDR P4N333 Host Bridge"},
			{ID: 0x3188, Name: "VT8385 [K8T800 AGP] Host Bridge"},
			{ID: 0x3189, Name: "VT8377 [KT400/KT600 AGP] Host Bridge"},
			{ID: 0x31b0, Name: "VX11 Standard Host Bridge"},
			{ID: 0x31b1, Name: "VX11 Standard Host Bridge"},
			{ID: 0x31b2, Name: "VX11 DRAM Controller"},
			{ID: 0x31b3, Name: "VX11 Power Management Controller"},
			{ID: 0x31b4, Name: "VX11 I/O APIC"},
			{ID: 0x31b5, Name: "VX11 Scratch Device"},
			{ID: 0x31b7, Name: "VX11 Standard Host Bridge"},
			{ID: 0x31b8, Name: "VX11 PCI to PCI Bridge"},
			{ID: 0x3204, Name: "K8M800 Host Bridge"},
			{ID: 0x3205, Name: "VT8378 [KM400/A] Chipset Host Bridge"},
			{ID: 0x3208, Name: "PT890 Host Bridge"},
			{ID: 0x3213, Name: "VPX/VPX2 PCI to PCI Bridge Controller"},
			{ID: 0x3218, Name: "K8T800M Host Bridge"},
			{ID: 0x3227, Name: "VT8237 ISA bridge [KT600/K8T800/K8T890 South]"},
			{ID: 0x3230, Name: "K8M890CE/K8N890CE [Chrome 9]"},
			{ID: 0x3238, Name: "K8T890 Host Bridge"},
			{ID: 0x3249, Name: "VT6421 IDE/SATA Controller"},
			{ID: 0x324a, Name: "CX700/VX700 PCI to PCI Bridge"},
			{ID: 0x324b, Name: "CX700/VX700 Host Bridge"},
			{ID: 0x324e, Name: "CX700/VX700 Internal Module Bus"},
			{ID: 0x3253, Name: "VT6655 WiFi Adapter, 802.11a/b/g"},
			{ID: 0x3258, Name: "PT880 Host Bridge"},
			{ID: 0x3259, Name: "CN333/CN400/PM880 Host Bridge"},
			{ID: 0x3260, Name: "VIA Chrome9 HC IGP"},
			{ID: 0x3269, Name: "KT880 Host Bridge"},
			{ID: 0x3282, Name: "K8T800Pro Host Bridge"},
			{ID: 0x3287, Name: "VT8251 PCI to ISA Bridge"},
			{ID: 0x3288, Name: "VX900/VT8xxx High Definition Audio Controller"},
			{ID: 0x3290, Name: "K8M890 Host Bridge"},
			{ID: 0x3296, Name: "P4M800 Host Bridge"},
			{ID: 0x3324, Name: "CX700/VX700-Series DRAM Bus Control"},
			{ID: 0x3327, Name: "P4M890 Host Bridge"},
			{ID: 0x3336, Name: "K8M890CE Host Bridge"},
			{ID: 0x3337, Name: "VT8237A PCI to ISA Bridge"},
			{ID: 0x3340, Name: "PT900 Host Bridge"},
			{ID: 0x3343, Name: "P4M890 [S3 UniChrome Pro]"},
			{ID: 0x3344, Name: "CN700/P4M800 Pro/P4M800 CE/VN800 Graphics [S3 UniChrome Pro]"},
			{ID: 0x3349, Name: "VT8251 AHCI/SATA 4-Port Controller"},
			{ID: 0x3351, Name: "VT3351 Host Bridge"},
			{ID: 0x3353, Name: "VX800/820 PCI to PCI Bridge"},
			{ID: 0x3364, Name: "CN896/VN896/P4M900 Host Bridge"},
			{ID: 0x3365, Name: "VT630x IEEE 1394 Host Controller [Fire II/M]"},
			{ID: 0x3371, Name: "CN896/VN896/P4M900 [Chrome 9 HC]"},
			{ID: 0x3372, Name: "VT8237S PCI to ISA Bridge"},
			{ID: 0x337a, Name: "VT8237A PCI to PCI Bridge"},
			{ID: 0x337b, Name: "VT8237A Host Bridge"},
			{ID: 0x3403, Name: "VT6315 Series Firewire Controller"},
			{ID: 0x3409, Name: "VX855/VX875 DRAM Bus Control"},
			{ID: 0x3410, Name: "VX900 Series DRAM Bus Control"},
			{ID: 0x3432, Name: "VL800/801 xHCI USB 3.0 Controller"},
			{ID: 0x3456, Name: "VX11 Standard Host Bridge"},
			{ID: 0x345b, Name: "VX11 Miscellaneous Bus"},
			{ID: 0x3483, Name: "VL805/806 xHCI USB 3.0 Controller"},
			{ID: 0x3a01, Name: "VX11 Graphics [Chrome 645/640]"},
			{ID: 0x4149, Name: "VIA VT6420 (ATA133) Controller"},
			{ID: 0x4204, Name: "K8M800 Host Bridge"},
			{ID: 0x4208, Name: "PT890 Host Bridge"},
			{ID: 0x4238, Name: "K8T890 Host Bridge"},
			{ID: 0x4258, Name: "PT880 Host Bridge"},
			{ID: 0x4259, Name: "CN333/CN400/PM880 Host Bridge"},
			{ID: 0x4269, Name: "KT880 Host Bridge"},
			{ID: 0x4282, Name: "K8T800Pro Host Bridge"},
			{ID: 0x4290, Name: "K8M890 Host Bridge"},
			{ID: 0x4293, Name: "PM896 Host Bridge"},
			{ID: 0x4296, Name: "P4M800 Host Bridge"},
			{ID: 0x4308, Name: "PT894 Host Bridge"},
			{ID: 0x4314, Name: "CN700/VN800/P4M800CE/Pro Host Bridge"},
			{ID: 0x4324, Name: "CX700/VX700-Series Power Management and Testing Control"},
			{ID: 0x4327, Name: "P4M890 Host Bridge"},
			{ID: 0x4336, Name: "K8M890CE Host Bridge"},
			{ID: 0x4340, Name: "PT900 Host Bridge"},
			{ID: 0x4351, Name: "VT3351 Host Bridge"},
			{ID: 0x4353, Name: "VX800/VX820 Power Management Control"},
			{ID: 0x4364, Name: "CN896/VN896/P4M900 Host Bridge"},
			{ID: 0x4409, Name: "VX855/VX875 Power Management Control"},
			{ID: 0x4410, Name: "VX900 Series Power Management and Chip Testing Control"},
			{ID: 0x5030, Name: "VT82C596 ACPI [Apollo PRO]"},
			{ID: 0x5122, Name: "VX855/VX875 Chrome 9 HCM Integrated Graphics"},
			{ID: 0x5208, Name: "PT890 I/O APIC Interrupt Controller"},
			{ID: 0x5238, Name: "K8T890 I/O APIC Interrupt Controller"},
			{ID: 0x5287, Name: "VT8251 Serial ATA Controller"},
			{ID: 0x5290, Name: "K8M890 I/O APIC Interrupt Controller"},
			{ID: 0x5308, Name: "PT894 I/O APIC Interrupt Controller"},
			{ID: 0x5324, Name: "CX700M2/VX700/VX800/820-Series Serial ATA & EIDE-Controller"},
			{ID: 0x5327, Name: "P4M890 I/O APIC Interrupt Controller"},
			{ID: 0x5336, Name: "K8M890CE I/O APIC Interrupt Controller"},
			{ID: 0x5340, Name: "PT900 I/O APIC Interrupt Controller"},
			{ID: 0x5351, Name: "VT3351 I/O APIC Interrupt Controller"},
			{ID: 0x5353, Name: "VX800/VX820 APIC and Central Traffic Control"},
			{ID: 0x5364, Name: "CN896/VN896/P4M900 I/O APIC Interrupt Controller"},
			{ID: 0x5372, Name: "VT8237/8251 Serial ATA Controller"},
			{ID: 0x5409, Name: "VX855/VX875 APIC and Central Traffic Control"},
			{ID: 0x5410, Name: "VX900 Series APIC and Central Traffic Control"},
			{ID: 0x6100, Name: "VT85C100A [Rhine II]"},
			{ID: 0x6287, Name: "SATA RAID Controller"},
			{ID: 0x6290, Name: "K8M890CE Host Bridge"},
			{ID: 0x6327, Name: "P4M890 Security Device"},
			{ID: 0x6353, Name: "VX800/VX820 Scratch Registers"},
			{ID: 0x6364, Name: "CN896/VN896/P4M900 Security Device"},
			{ID: 0x6409, Name: "VX855/VX875 Scratch Registers"},
			{ID: 0x6410, Name: "VX900 Series Scratch Registers"},
			{ID: 0x7122, Name: "VX900 Graphics [Chrome9 HD]"},
			{ID: 0x7204, Name: "K8M800 Host Bridge"},
			{ID: 0x7205, Name: "KM400/KN400/P4M800 [S3 UniChrome]"},
			{ID: 0x7208, Name: "PT890 Host Bridge"},
			{ID: 0x7238, Name: "K8T890 Host Bridge"},
			{ID: 0x7258, Name: "PT880 Host Bridge"},
			{ID: 0x7259, Name: "CN333/CN400/PM880 Host Bridge"},
			{ID: 0x7269, Name: "KT880 Host Bridge"},
			{ID: 0x7282, Name: "K8T800Pro Host Bridge"},
			{ID: 0x7290, Name: "K8M890 Host Bridge"},
			{ID: 0x7293, Name: "PM896 Host Bridge"},
			{ID: 0x7296, Name: "P4M800 Host Bridge"},
			{ID: 0x7308, Name: "PT894 Host Bridge"},
			{ID: 0x7314, Name: "CN700/VN800/P4M800CE/Pro Host Bridge"},
			{ID: 0x7324, Name: "CX700/VX700-Series North-South Module Interface Control"},
			{ID: 0x7327, Name: "P4M890 Host Bridge"},
			{ID: 0x7336, Name: "K8M890CE Host Bridge"},
			{ID: 0x7340, Name: "PT900 Host Bridge"},
			{ID: 0x7351, Name: "VT3351 Host Bridge"},
			{ID: 0x7353, Name: "VX800/VX820 North-South Module Interface Control"},
			{ID: 0x7364, Name: "CN896/VN896/P4M900 Host Bridge"},
			{ID: 0x7409, Name: "VX855/VX875 North-South Module Interface Control"},
			{ID: 0x7410, Name: "VX900 Series North-South Module Interface Control"},
			{ID: 0x8231, Name: "VT8231 [PCI-to-ISA Bridge]"},
			{ID: 0x8235, Name: "VT8235 ACPI"},
			{ID: 0x8305, Name: "VT8363/8365 [KT133/KM133 AGP]"},
			{ID: 0x8324, Name: "CX700/VX700-Series Bus Control and Power Management"},
			{ID: 0x8353, Name: "VX800/VX820 Bus Control and Power Management"},
			{ID: 0x8391, Name: "VT8371 [KX133 AGP]"},
			{ID: 0x8400, Name: "MVP4"},
			{ID: 0x8409, Name: "VX855/VX875 Bus Control and Power Management"},
			{ID: 0x8410, Name: "VX900 Series Bus Control and Power Management"},
			{ID: 0x8500, Name: "KLE133/PLE133/PLE133T"},
			{ID: 0x8501, Name: "VT8501 [Apollo MVP4 AGP]"},
			{ID: 0x8596, Name: "VT82C596 [Apollo PRO AGP]"},
			{ID: 0x8597, Name: "VT82C597 [Apollo VP3 AGP]"},
			{ID: 0x8598, Name: "VT82C598/694x [Apollo MVP3/Pro133x AGP]"},
			{ID: 0x8601, Name: "VT8601 [Apollo ProMedia AGP]"},
			{ID: 0x8605, Name: "VT8605 [PM133 AGP]"},
			{ID: 0x8691, Name: "VT82C691 [Apollo Pro]"},
			{ID: 0x8693, Name: "VT82C693 [Apollo Pro Plus] PCI Bridge"},
			{ID: 0x8a25, Name: "PL133/PL133T [S3 ProSavage]"},
			{ID: 0x8a26, Name: "KL133/KL133A/KM133/KM133A [S3 ProSavage]"},
			{ID: 0x8d01, Name: "PN133/PN133T [S3 Twister]"},
			{ID: 0x8d04, Name: "KM266/P4M266/P4M266A/P4N266 [S3 ProSavageDDR]"},
			{ID: 0x9001, Name: "VX900 Series Serial-ATA Controller"},
			{ID: 0x9082, Name: "Standard AHCI 1.0 SATA Controller"},
			{ID: 0x9140, Name: "HDMI Audio Device"},
			{ID: 0x9201, Name: "USB3.0 Controller"},
			{ID: 0x9530, Name: "VX800/820/900 Series Secure Digital Memory Card Controller"},
			{ID: 0x95d0, Name: "VX800/820/900 Series SDIO Host Controller"},
			{ID: 0xa208, Name: "PT890 PCI to PCI Bridge Controller"},
			{ID: 0xa238, Name: "K8T890 PCI to PCI Bridge Controller"},
			{ID: 0xa327, Name: "P4M890 PCI to PCI Bridge Controller"},
			{ID: 0xa353, Name: "VX8xx/900 Series South-North Module Interface Control"},
			{ID: 0xa364, Name: "CN896/VN896/P4M900 PCI to PCI Bridge Controller"},
			{ID: 0xa409, Name: "VX855/VX875/VX900 Series USB Device Controller"},
			{ID: 0xa410, Name: "VX900 Series PCI Express Root Port 0"},
			{ID: 0xb091, Name: "VT8633 [Apollo Pro266 AGP]"},
			{ID: 0xb099, Name: "VT8366/A/7 [Apollo KT266/A/333 AGP]"},
			{ID: 0xb101, Name: "VT8653 AGP Bridge"},
			{ID: 0xb102, Name: "VT8362 AGP Bridge"},
			{ID: 0xb103, Name: "VT8615 AGP Bridge"},
			{ID: 0xb112, Name: "VT8361 [KLE133] AGP Bridge"},
			{ID: 0xb113, Name: "VPX/VPX2 I/O APIC Interrupt Controller"},
			{ID: 0xb115, Name: "VT8363/8365 [KT133/KM133] PCI Bridge"},
			{ID: 0xb168, Name: "VT8235 PCI Bridge"},
			{ID: 0xb188, Name: "VT8237/8251 PCI bridge [K8M890/K8T800/K8T890 South]"},
			{ID: 0xb198, Name: "VT8237/CX700/VX700-Series PCI to PCI Bridge"},
			{ID: 0xb213, Name: "VPX/VPX2 I/O APIC Interrupt Controller"},
			{ID: 0xb353, Name: "VX855/VX875/VX900 PCI to PCI Bridge"},
			{ID: 0xb410, Name: "VX900 Series PCI Express Root Port 1"},
			{ID: 0xb999, Name: "[K8T890 North / VT8237 South] PCI Bridge"},
			{ID: 0xc208, Name: "PT890 PCI to PCI Bridge Controller"},
			{ID: 0xc238, Name: "K8T890 PCI to PCI Bridge Controller"},
			{ID: 0xc327, Name: "P4M890 PCI to PCI Bridge Controller"},
			{ID: 0xc340, Name: "PT900 PCI to PCI Bridge Controller"},
			{ID: 0xc353, Name: "VX800/820-Series PCI-Express Root (PCI-to-PCI Virtual Bridge)"},
			{ID: 0xc364, Name: "CN896/VN896/P4M900 PCI to PCI Bridge Controller"},
			{ID: 0xc409, Name: "VX855/VX875 EIDE Controller"},
			{ID: 0xc410, Name: "VX900 Series PCI Express Root Port 2"},
			{ID: 0xd104, Name: "VT8237R USB UDCI Controller"},
			{ID: 0xd208, Name: "PT890 PCI to PCI Bridge Controller"},
			{ID: 0xd213, Name: "VPX/VPX2 PCI to PCI Bridge Controller"},
			{ID: 0xd238, Name: "K8T890 PCI to PCI Bridge Controller"},
			{ID: 0xd340, Name: "PT900 PCI to PCI Bridge Controller"},
			{ID: 0xd410, Name: "VX900 Series PCI Express Root Port 3"},
			{ID: 0xe208, Name: "PT890 PCI to PCI Bridge Controller"},
			{ID: 0xe238, Name: "K8T890 PCI to PCI Bridge Controller"},
			{ID: 0xe340, Name: "PT900 PCI to PCI Bridge Controller"},
			{ID: 0xe353, Name: "VX800/820-Series PCI-Express Root Port 0"},
			{ID: 0xe410, Name: "VX900 Series PCI Express Physical Layer Electrical Sub-block"},
			{ID: 0xf208, Name: "PT890 PCI to PCI Bridge Controller"},
			{ID: 0xf238, Name: "K8T890 PCI to PCI Bridge Controller"},
			{ID: 0xf340, Name: "PT900 PCI to PCI Bridge Controller"},
			{ID: 0xf353, Name: "VX800/820-Series PCI-Express Root Port 1"},
			{ID: 0xf410, Name: "VX900 Series PCI UART Port 0-3"},
		},
	},
	{
		ID: 0x1107, Name: "Stratus Computers", Devices: []Device{
			{ID: 0x0576, Name: "VIA VT82C570MV [Apollo] (Wrong vendor ID!)"},
		},
	},
	{
		ID: 0x1108, Name: "Proteon, Inc.", Devices: []Device{
			{ID: 0x0100, Name: "p1690plus_AA"},
			{ID: 0x0101, Name: "p1690plus_AB"},
			{ID: 0x0105, Name: "P1690Plus"},
			{ID: 0x0108, Name: "P1690Plus"},
			{ID: 0x0138, Name: "P1690Plus"},
			{ID: 0x0139, Name: "P1690Plus"},
			{ID: 0x013c, Name: "P1690Plus"},
			{ID: 0x013d, Name: "P1690Plus"},
		},
	},
	{
		ID: 0x1109, Name: "Cogent Data Technologies, Inc.", Devices: []Device{
			{ID: 0x1400, Name: "EM110TX [EX110TX]"},
		},
	},
	{
		ID: 0x110a, Name: "Siemens AG", Devices: []Device{
			{ID: 0x0002, Name: "Pirahna 2-port"},
			{ID: 0x0005, Name: "Tulip controller, power management, switch extender"},
			{ID: 0x0006, Name: "FSC PINC (I/O-APIC)"},
			{ID: 0x0015, Name: "FSC Multiprocessor Interrupt Controller"},
			{ID: 0x001d, Name: "FSC Copernicus Management Controller"},
			{ID: 0x007b, Name: "FSC Remote Service Controller, mailbox device"},
			{ID: 0x007c, Name: "FSC Remote Service Controller, shared memory device"},
			{ID: 0x007d, Name: "FSC Remote Service Controller, SMIC device"},
			{ID: 0x2101, Name: "HST SAPHIR V Primary PCI (ISDN/PMx)"},
			{ID: 0x2102, Name: "DSCC4 PEB/PEF 20534 DMA Supported Serial Communication Controller with 4 Channels"},
			{ID: 0x2104, Name: "Eicon Diva 2.02 compatible passive ISDN card"},
			{ID: 0x3141, Name: "SIMATIC NET CP 5611 / 5621"},
			{ID: 0x3142, Name: "SIMATIC NET CP 5613 / 5614"},
			{ID: 0x3143, Name: "SIMATIC NET CP 1613"},
			{ID: 0x4021, Name: "SIMATIC NET CP 5512 (Profibus and MPI Cardbus Adapter)"},
			{ID: 0x4029, Name: "SIMATIC NET CP 5613 A2"},
			{ID: 0x4035, Name: "SIMATIC NET CP 1613 A2"},
			{ID: 0x4036, Name: "SIMATIC NET CP 1616"},
			{ID: 0x4038, Name: "SIMATIC NET CP 1604"},
			{ID: 0x4069, Name: "SIMATIC NET CP 5623"},
			{ID: 0x407c, Name: "SIMATIC NET CP 5612"},
			{ID: 0x407d, Name: "SIMATIC NET CP 5613 A3"},
			{ID: 0x407e, Name: "SIMATIC NET CP 5622"},
			{ID: 0x4083, Name: "SIMATIC NET CP 5614 A3"},
			{ID: 0x4084, Name: "SIMATIC NET CP 1626"},
			{ID: 0x4942, Name: "FPGA I-Bus Tracer for MBD"},
			{ID: 0x6120, Name: "SZB6120"},
		},
	},
	{
		ID: 0x110b, Name: "Chromatic Research Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Mpact Media Processor"},
			{ID: 0x0004, Name: "Mpact 2"},
		},
	},
	{ID: 0x110c, Name: "Mini-Max Technology, Inc.", Devices: []Device{}},
	{ID: 0x110d, Name: "Znyx Advanced Systems", Devices: []Device{}},
	{ID: 0x110e, Name: "CPU Technology", Devices: []Device{}},
	{ID: 0x110f, Name: "Ross Technology", Devices: []Device{}},
	{
		ID: 0x1110, Name: "Powerhouse Systems", Devices: []Device{
			{ID: 0x6037, Name: "Firepower Powerized SMP I/O ASIC"},
			{ID: 0x6073, Name: "Firepower Powerized SMP I/O ASIC"},
		},
	},
	{ID: 0x1111, Name: "Santa Cruz Operation", Devices: []Device{}},
	{
		ID: 0x1112, Name: "Osicom Technologies Inc", Devices: []Device{
			{ID: 0x2200, Name: "FDDI Adapter"},
			{ID: 0x2300, Name: "Fast Ethernet Adapter"},
			{ID: 0x2340, Name: "4 Port Fast Ethernet Adapter"},
			{ID: 0x2400, Name: "ATM Adapter"},
		},
	},
	{
		ID: 0x1113, Name: "Accton Technology Corporation", Devices: []Device{
			{ID: 0x1211, Name: "SMC2-1211TX"},
			{ID: 0x1216, Name: "EN-1216 Ethernet Adapter"},
			{ID: 0x1217, Name: "EN-1217 Ethernet Adapter"},
			{ID: 0x5105, Name: "10Mbps Network card"},
			{ID: 0x9211, Name: "EN-1207D Fast Ethernet Adapter"},
			{ID: 0x9511, Name: "21x4x DEC-Tulip compatible Fast Ethernet"},
			{ID: 0xd301, Name: "CPWNA100 (Philips wireless PCMCIA)"},
			{ID: 0xec02, Name: "SMC 1244TX v3"},
			{ID: 0xee23, Name: "SMCWPCIT-G 108Mbps Wireless PCI adapter"},
		},
	},
	{
		ID: 0x1114, Name: "Atmel Corporation", Devices: []Device{
			{ID: 0x0506, Name: "at76c506 802.11b Wireless Network Adaptor"},
		},
	},
	{ID: 0x1115, Name: "3D Labs", Devices: []Device{}},
	{
		ID: 0x1116, Name: "Data Translation", Devices: []Device{
			{ID: 0x0022, Name: "DT3001"},
			{ID: 0x0023, Name: "DT3002"},
			{ID: 0x0024, Name: "DT3003"},
			{ID: 0x0025, Name: "DT3004"},
			{ID: 0x0026, Name: "DT3005"},
			{ID: 0x0027, Name: "DT3001-PGL"},
			{ID: 0x0028, Name: "DT3003-PGL"},
			{ID: 0x0051, Name: "DT322"},
			{ID: 0x0060, Name: "DT340"},
			{ID: 0x0069, Name: "DT332"},
			{ID: 0x80c2, Name: "DT3162"},
		},
	},
	{
		ID: 0x1117, Name: "Datacube, Inc", Devices: []Device{
			{ID: 0x9500, Name: "Max-1C SVGA card"},
			{ID: 0x9501, Name: "Max-1C image processing"},
		},
	},
	{ID: 0x1118, Name: "Berg Electronics", Devices: []Device{}},
	{
		ID: 0x1119, Name: "ICP Vortex Computersysteme GmbH", Devices: []Device{
			{ID: 0x0000, Name: "GDT 6000/6020/6050"},
			{ID: 0x0001, Name: "GDT 6000B/6010"},
			{ID: 0x0002, Name: "GDT 6110/6510"},
			{ID: 0x0003, Name: "GDT 6120/6520"},
			{ID: 0x0004, Name: "GDT 6530"},
			{ID: 0x0005, Name: "GDT 6550"},
			{ID: 0x0006, Name: "GDT 6117/6517"},
			{ID: 0x0007, Name: "GDT 6127/6527"},
			{ID: 0x0008, Name: "GDT 6537"},
			{ID: 0x0009, Name: "GDT 6557/6557-ECC"},
			{ID: 0x000a, Name: "GDT 6115/6515"},
			{ID: 0x000b, Name: "GDT 6125/6525"},
			{ID: 0x000c, Name: "GDT 6535"},
			{ID: 0x000d, Name: "GDT 6555/6555-ECC"},
			{ID: 0x0100, Name: "GDT 6117RP/6517RP"},
			{ID: 0x0101, Name: "GDT 6127RP/6527RP"},
			{ID: 0x0102, Name: "GDT 6537RP"},
			{ID: 0x0103, Name: "GDT 6557RP"},
			{ID: 0x0104, Name: "GDT 6111RP/6511RP"},
			{ID: 0x0105, Name: "GDT 6121RP/6521RP"},
			{ID: 0x0110, Name: "GDT 6117RD/6517RD"},
			{ID: 0x0111, Name: "GDT 6127RD/6527RD"},
			{ID: 0x0112, Name: "GDT 6537RD"},
			{ID: 0x0113, Name: "GDT 6557RD"},
			{ID: 0x0114, Name: "GDT 6111RD/6511RD"},
			{ID: 0x0115, Name: "GDT 6121RD/6521RD"},
			{ID: 0x0118, Name: "GDT 6118RD/6518RD/6618RD"},
			{ID: 0x0119, Name: "GDT 6128RD/6528RD/6628RD"},
			{ID: 0x011a, Name: "GDT 6538RD/6638RD"},
			{ID: 0x011b, Name: "GDT 6558RD/6658RD"},
			{ID: 0x0120, Name: "GDT 6117RP2/6517RP2"},
			{ID: 0x0121, Name: "GDT 6127RP2/6527RP2"},
			{ID: 0x0122, Name: "GDT 6537RP2"},
			{ID: 0x0123, Name: "GDT 6557RP2"},
			{ID: 0x0124, Name: "GDT 6111RP2/6511RP2"},
			{ID: 0x0125, Name: "GDT 6121RP2/6521RP2"},
			{ID: 0x0136, Name: "GDT 6113RS/6513RS"},
			{ID: 0x0137, Name: "GDT 6123RS/6523RS"},
			{ID: 0x0138, Name: "GDT 6118RS/6518RS/6618RS"},
			{ID: 0x0139, Name: "GDT 6128RS/6528RS/6628RS"},
			{ID: 0x013a, Name: "GDT 6538RS/6638RS"},
			{ID: 0x013b, Name: "GDT 6558RS/6658RS"},
			{ID: 0x013c, Name: "GDT 6533RS/6633RS"},
			{ID: 0x013d, Name: "GDT 6543RS/6643RS"},
			{ID: 0x013e, Name: "GDT 6553RS/6653RS"},
			{ID: 0x013f, Name: "GDT 6563RS/6663RS"},
			{ID: 0x0166, Name: "GDT 7113RN/7513RN/7613RN"},
			{ID: 0x0167, Name: "GDT 7123RN/7523RN/7623RN"},
			{ID: 0x0168, Name: "GDT 7118RN/7518RN/7518RN"},
			{ID: 0x0169, Name: "GDT 7128RN/7528RN/7628RN"},
			{ID: 0x016a, Name: "GDT 7538RN/7638RN"},
			{ID: 0x016b, Name: "GDT 7558RN/7658RN"},
			{ID: 0x016c, Name: "GDT 7533RN/7633RN"},
			{ID: 0x016d, Name: "GDT 7543RN/7643RN"},
			{ID: 0x016e, Name: "GDT 7553RN/7653RN"},
			{ID: 0x016f, Name: "GDT 7563RN/7663RN"},
			{ID: 0x01d6, Name: "GDT 4x13RZ"},
			{ID: 0x01d7, Name: "GDT 4x23RZ"},
			{ID: 0x01f6, Name: "GDT 8x13RZ"},
			{ID: 0x01f7, Name: "GDT 8x23RZ"},
			{ID: 0x01fc, Name: "GDT 8x33RZ"},
			{ID: 0x01fd, Name: "GDT 8x43RZ"},
			{ID: 0x01fe, Name: "GDT 8x53RZ"},
			{ID: 0x01ff, Name: "GDT 8x63RZ"},
			{ID: 0x0210, Name: "GDT 6519RD/6619RD"},
			{ID: 0x0211, Name: "GDT 6529RD/6629RD"},
			{ID: 0x0260, Name: "GDT 7519RN/7619RN"},
			{ID: 0x0261, Name: "GDT 7529RN/7629RN"},
			{ID: 0x02ff, Name: "GDT MAXRP"},
			{ID: 0x0300, Name: "GDT NEWRX"},
			{ID: 0x0301, Name: "GDT NEWRX2"},
		},
	},
	{
		ID: 0x111a, Name: "Efficient Networks, Inc", Devices: []Device{
			{ID: 0x0000, Name: "155P-MF1 (FPGA)"},
			{ID: 0x0002, Name: "155P-MF1 (ASIC)"},
			{ID: 0x0003, Name: "ENI-25P ATM"},
			{ID: 0x0005, Name: "SpeedStream (LANAI)"},
			{ID: 0x0007, Name: "SpeedStream ADSL"},
			{ID: 0x1020, Name: "SpeedStream PCI 10/100 Network Card"},
			{ID: 0x1203, Name: "SpeedStream 1023 Wireless PCI Adapter"},
		},
	},
	{ID: 0x111b, Name: "Teledyne Electronic Systems", Devices: []Device{}},
	{
		ID: 0x111c, Name: "Tricord Systems Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Powerbis Bridge"},
		},
	},
	{
		ID: 0x111d, Name: "Microsemi / PMC / IDT", Devices: []Device{
			{ID: 0x0001, Name: "IDT77201/77211 155Mbps ATM SAR Controller [NICStAR]"},
			{ID: 0x0003, Name: "IDT77222/77252 155Mbps ATM MICRO ABR SAR Controller"},
			{ID: 0x0004, Name: "IDT77V252 155Mbps ATM MICRO ABR SAR Controller"},
			{ID: 0x0005, Name: "IDT77V222 155Mbps ATM MICRO ABR SAR Controller"},
			{ID: 0x8018, Name: "PES12N3A 12-lane 3-Port PCI Express Switch"},
			{ID: 0x801c, Name: "PES24N3A PCI Express Switch"},
			{ID: 0x8028, Name: "PES4T4 PCI Express Switch"},
			{ID: 0x802b, Name: "PES8T5A PCI Express Switch"},
			{ID: 0x802c, Name: "PES16T4 PCI Express Switch"},
			{ID: 0x802d, Name: "PES16T7 PCI Express Switch"},
			{ID: 0x802e, Name: "PES24T6 PCI Express Switch"},
			{ID: 0x802f, Name: "PES32T8 PCI Express Switch"},
			{ID: 0x8032, Name: "PES48T12 PCI Express Switch"},
			{ID: 0x8034, Name: "PES16/22/34H16 PCI Express Switch"},
			{ID: 0x8035, Name: "PES32H8 PCI Express Switch"},
			{ID: 0x8036, Name: "PES48H12 PCI Express Switch"},
			{ID: 0x8037, Name: "PES64H16 PCI Express Switch"},
			{ID: 0x8039, Name: "PES3T3 PCI Express Switch"},
			{ID: 0x803a, Name: "PES4T4 PCI Express Switch"},
			{ID: 0x803c, Name: "PES5T5 PCI Express Switch"},
			{ID: 0x803d, Name: "PES6T5 PCI Express Switch"},
			{ID: 0x8048, Name: "PES8NT2 PCI Express Switch"},
			{ID: 0x8049, Name: "PES8NT2 PCI Express Switch"},
			{ID: 0x804a, Name: "PES8NT2 PCI Express Internal NTB"},
			{ID: 0x804b, Name: "PES8NT2 PCI Express External NTB"},
			{ID: 0x804c, Name: "PES16NT2 PCI Express Switch"},
			{ID: 0x804d, Name: "PES16NT2 PCI Express Switch"},
			{ID: 0x804e, Name: "PES16NT2 PCI Express Internal NTB"},
			{ID: 0x804f, Name: "PES16NT2 PCI Express External NTB"},
			{ID: 0x8058, Name: "PES12NT3 PCI Express Switch"},
			{ID: 0x8059, Name: "PES12NT3 PCI Express Switch"},
			{ID: 0x805a, Name: "PES12NT3 PCI Express Internal NTB"},
			{ID: 0x805b, Name: "PES12NT3 PCI Express External NTB"},
			{ID: 0x805c, Name: "PES24NT3 PCI Express Switch"},
			{ID: 0x805d, Name: "PES24NT3 PCI Express Switch"},
			{ID: 0x805e, Name: "PES24NT3 PCI Express Internal NTB"},
			{ID: 0x805f, Name: "PES24NT3 PCI Express External NTB"},
			{ID: 0x8060, Name: "PES16T4G2 PCI Express Gen2 Switch"},
			{ID: 0x8061, Name: "PES12T3G2 PCI Express Gen2 Switch"},
			{ID: 0x8068, Name: "PES6T6G2 PCI Express Gen2 Switch"},
			{ID: 0x806a, Name: "PES24T3G2 PCI Express Gen2 Switch"},
			{ID: 0x806c, Name: "PES16T4A/4T4G2 PCI Express Gen2 Switch"},
			{ID: 0x806e, Name: "PES24T6G2 PCI Express Gen2 Switch"},
			{ID: 0x806f, Name: "HIO524G2 PCI Express Gen2 Switch"},
			{ID: 0x8077, Name: "89HPES64H16G2 64-Lane 16-Port PCIe Gen2 System Interconnect Switch"},
			{ID: 0x8088, Name: "PES32NT8BG2 PCI Express Switch"},
			{ID: 0x808a, Name: "89HPES32NT24BG2 PCI Express Switch"},
			{ID: 0x808c, Name: "89HPES32NT24AG2 PCI Express Switch"},
			{ID: 0x808e, Name: "PES24NT24G2 PCI Express Switch"},
			{ID: 0x808f, Name: "89HPES32NT8AG2 32-Lane 8-Port PCIe Gen2 System Interconnect Switch with Non-Transparent Bridging"},
			{ID: 0x8090, Name: "89HPES16NT16G2 16-Lane 16-Port PCIe Gen2 System Interconnect Switch"},
			{ID: 0x8092, Name: "89HPES12NT12G2 12-Lane 12-Port PCIe Gen2 System Interconnect Switch"},
			{ID: 0x80cf, Name: "F32P08xG3 [PCIe boot mode]"},
			{ID: 0x80d2, Name: "F32P08xG3 NVMe controller"},
		},
	},
	{ID: 0x111e, Name: "Eldec", Devices: []Device{}},
	{
		ID: 0x111f, Name: "Precision Digital Images", Devices: []Device{
			{ID: 0x4a47, Name: "Precision MX Video engine interface"},
			{ID: 0x5243, Name: "Frame capture bus interface"},
		},
	},
	{
		ID: 0x1120, Name: "Dell EMC", Devices: []Device{
			{ID: 0x2306, Name: "Unity Fibre Channel Controller"},
			{ID: 0x2501, Name: "Unity Ethernet Controller"},
			{ID: 0x2505, Name: "Unity Fibre Channel Controller"},
		},
	},
	{ID: 0x1121, Name: "Zilog", Devices: []Device{}},
	{ID: 0x1122, Name: "Multi-tech Systems, Inc.", Devices: []Device{}},
	{ID: 0x1123, Name: "Excellent Design, Inc.", Devices: []Device{}},
	{
		ID: 0x1124, Name: "Leutron Vision AG", Devices: []Device{
			{ID: 0x2581, Name: "Picport Monochrome"},
		},
	},
	{ID: 0x1125, Name: "Eurocore", Devices: []Device{}},
	{ID: 0x1126, Name: "Vigra", Devices: []Device{}},
	{
		ID: 0x1127, Name: "FORE Systems Inc", Devices: []Device{
			{ID: 0x0200, Name: "ForeRunner PCA-200 ATM"},
			{ID: 0x0210, Name: "PCA-200PC"},
			{ID: 0x0250, Name: "ATM"},
			{ID: 0x0300, Name: "ForeRunner PCA-200EPC ATM"},
			{ID: 0x0310, Name: "ATM"},
			{ID: 0x0400, Name: "ForeRunnerHE ATM Adapter"},
		},
	},
	{ID: 0x1129, Name: "Firmworks", Devices: []Device{}},
	{ID: 0x112a, Name: "Hermes Electronics Company, Ltd.", Devices: []Device{}},
	{ID: 0x112b, Name: "Heidelberger Druckmaschinen AGHeidelberger Druckmaschinen AG", Devices: []Device{}},
	{ID: 0x112c, Name: "Zenith Data Systems", Devices: []Device{}},
	{ID: 0x112d, Name: "Ravicad", Devices: []Device{}},
	{ID: 0x112e, Name: "Infomedia Microelectronics Inc.", Devices: []Device{}},
	{
		ID: 0x112f, Name: "Dalsa Inc.", Devices: []Device{
			{ID: 0x0000, Name: "MVC IC-PCI"},
			{ID: 0x0001, Name: "MVC IM-PCI Video frame grabber/processor"},
			{ID: 0x0004, Name: "PCDig Digital Image Capture"},
			{ID: 0x0008, Name: "PC-CamLink PCI framegrabber"},
		},
	},
	{ID: 0x1130, Name: "Computervision", Devices: []Device{}},
	{
		ID: 0x1131, Name: "Philips Semiconductors", Devices: []Device{
			{ID: 0x1561, Name: "USB 1.1 Host Controller"},
			{ID: 0x1562, Name: "USB 2.0 Host Controller"},
			{ID: 0x3400, Name: "SmartPCI56(UCB1500) 56K Modem"},
			{ID: 0x5400, Name: "TriMedia TM1000/1100"},
			{ID: 0x5402, Name: "TriMedia TM1300"},
			{ID: 0x5405, Name: "TriMedia TM1500"},
			{ID: 0x5406, Name: "TriMedia TM1700"},
			{ID: 0x540b, Name: "PNX1005 Media Processor"},
			{ID: 0x7130, Name: "SAA7130 Video Broadcast Decoder"},
			{ID: 0x7133, Name: "SAA7131/SAA7133/SAA7135 Video Broadcast Decoder"},
			{ID: 0x7134, Name: "SAA7134/SAA7135HL Video Broadcast Decoder"},
			{ID: 0x7145, Name: "SAA7145"},
			{ID: 0x7146, Name: "SAA7146"},
			{ID: 0x7160, Name: "SAA7160"},
			{ID: 0x7162, Name: "SAA7162"},
			{ID: 0x7164, Name: "SAA7164"},
			{ID: 0x7231, Name: "SAA7231"},
			{ID: 0x9730, Name: "SAA9730 Integrated Multimedia and Peripheral Controller"},
		},
	},
	{ID: 0x1132, Name: "Mitel Corp.", Devices: []Device{}},
	{
		ID: 0x1133, Name: "Dialogic Corporation", Devices: []Device{
			{ID: 0x7701, Name: "Eiconcard C90"},
			{ID: 0x7711, Name: "Eiconcard C91"},
			{ID: 0x7901, Name: "EiconCard S90"},
			{ID: 0x7902, Name: "EiconCard S90"},
			{ID: 0x7911, Name: "EiconCard S91"},
			{ID: 0x7912, Name: "EiconCard S91"},
			{ID: 0x7921, Name: "Eiconcard S92"},
			{ID: 0x7941, Name: "EiconCard S94"},
			{ID: 0x7942, Name: "EiconCard S94"},
			{ID: 0x7943, Name: "EiconCard S94"},
			{ID: 0x7944, Name: "EiconCard S94"},
			{ID: 0x7945, Name: "Eiconcard S94"},
			{ID: 0x7948, Name: "Eiconcard S94 64bit/66MHz"},
			{ID: 0x9711, Name: "Eiconcard S91 V2"},
			{ID: 0x9911, Name: "Eiconcard S91 V2"},
			{ID: 0x9941, Name: "Eiconcard S94 V2"},
			{ID: 0x9a41, Name: "Eiconcard S94 PCIe"},
			{ID: 0xb921, Name: "EiconCard P92"},
			{ID: 0xb922, Name: "EiconCard P92"},
			{ID: 0xb923, Name: "EiconCard P92"},
			{ID: 0xe001, Name: "Diva Pro 2.0 S/T"},
			{ID: 0xe002, Name: "Diva 2.0 S/T PCI"},
			{ID: 0xe003, Name: "Diva Pro 2.0 U"},
			{ID: 0xe004, Name: "Diva 2.0 U PCI"},
			{ID: 0xe005, Name: "Diva 2.01 S/T PCI"},
			{ID: 0xe006, Name: "Diva CT S/T PCI"},
			{ID: 0xe007, Name: "Diva CT U PCI"},
			{ID: 0xe008, Name: "Diva CT Lite S/T PCI"},
			{ID: 0xe009, Name: "Diva CT Lite U PCI"},
			{ID: 0xe00a, Name: "Diva ISDN+V.90 PCI"},
			{ID: 0xe00b, Name: "Diva ISDN PCI 2.02"},
			{ID: 0xe00c, Name: "Diva 2.02 PCI U"},
			{ID: 0xe00d, Name: "Diva Pro 3.0 PCI"},
			{ID: 0xe00e, Name: "Diva ISDN+CT S/T PCI Rev 2"},
			{ID: 0xe010, Name: "Diva Server BRI-2M PCI"},
			{ID: 0xe011, Name: "Diva Server BRI S/T Rev 2"},
			{ID: 0xe012, Name: "Diva Server 4BRI-8M PCI"},
			{ID: 0xe013, Name: "4BRI"},
			{ID: 0xe014, Name: "Diva Server PRI-30M PCI"},
			{ID: 0xe015, Name: "Diva PRI PCI v2"},
			{ID: 0xe016, Name: "Diva Server Voice 4BRI PCI"},
			{ID: 0xe017, Name: "Diva Server Voice 4BRI Rev 2"},
			{ID: 0xe018, Name: "BRI"},
			{ID: 0xe019, Name: "Diva Server Voice PRI Rev 2"},
			{ID: 0xe01a, Name: "Diva BRI-2FX PCI v2"},
			{ID: 0xe01b, Name: "Diva Server Voice BRI-2M 2.0 PCI"},
			{ID: 0xe01c, Name: "PRI"},
			{ID: 0xe01e, Name: "2PRI"},
			{ID: 0xe020, Name: "4PRI"},
			{ID: 0xe022, Name: "Analog-2"},
			{ID: 0xe024, Name: "Analog-4"},
			{ID: 0xe028, Name: "Analog-8"},
			{ID: 0xe02a, Name: "Diva IPM-300 PCI v1"},
			{ID: 0xe02c, Name: "Diva IPM-600 PCI v1"},
			{ID: 0xe02e, Name: "4BRI"},
			{ID: 0xe032, Name: "BRI"},
			{ID: 0xe034, Name: "Diva BRI-CTI PCI v2"},
		},
	},
	{
		ID: 0x1134, Name: "Mercury Computer Systems", Devices: []Device{
			{ID: 0x0001, Name: "Raceway Bridge"},
			{ID: 0x0002, Name: "Dual PCI to RapidIO Bridge"},
			{ID: 0x000b, Name: "POET Serial RapidIO Bridge"},
			{ID: 0x000d, Name: "POET PSDMS Device"},
		},
	},
	{
		ID: 0x1135, Name: "FUJIFILM Business Innovation Corp.", Devices: []Device{
			{ID: 0x0001, Name: "Printer controller"},
		},
	},
	{
		ID: 0x1136, Name: "Momentum Data Systems", Devices: []Device{
			{ID: 0x0002, Name: "PCI-JTAG"},
		},
	},
	{
		ID: 0x1137, Name: "Cisco Systems Inc", Devices: []Device{
			{ID: 0x0023, Name: "VIC 81 PCIe Upstream Port"},
			{ID: 0x0040, Name: "VIC PCIe Upstream Port"},
			{ID: 0x0041, Name: "VIC PCIe Downstream Port"},
			{ID: 0x0042, Name: "VIC Management Controller"},
			{ID: 0x0043, Name: "VIC Ethernet NIC"},
			{ID: 0x0044, Name: "VIC Ethernet NIC Dynamic"},
			{ID: 0x0045, Name: "VIC FCoE HBA"},
			{ID: 0x0046, Name: "VIC SCSI Controller"},
			{ID: 0x004e, Name: "VIC 82 PCIe Upstream Port"},
			{ID: 0x0071, Name: "VIC SR-IOV VF"},
			{ID: 0x007a, Name: "VIC 1300 PCIe Upstream Port"},
			{ID: 0x00cf, Name: "VIC Userspace NIC"},
			{ID: 0x023e, Name: "1GigE I350 LOM"},
		},
	},
	{
		ID: 0x1138, Name: "Ziatech Corporation", Devices: []Device{
			{ID: 0x8905, Name: "8905 [STD 32 Bridge]"},
		},
	},
	{
		ID: 0x1139, Name: "Dynamic Pictures, Inc", Devices: []Device{
			{ID: 0x0001, Name: "VGA Compatible 3D Graphics"},
		},
	},
	{ID: 0x113a, Name: "FWB Inc", Devices: []Device{}},
	{ID: 0x113b, Name: "Network Computing Devices", Devices: []Device{}},
	{
		ID: 0x113c, Name: "Cyclone Microsystems, Inc.", Devices: []Device{
			{ID: 0x0000, Name: "PCI-9060 i960 Bridge"},
			{ID: 0x0001, Name: "PCI-SDK [PCI i960 Evaluation Platform]"},
			{ID: 0x0911, Name: "PCI-911 [i960Jx-based Intelligent I/O Controller]"},
			{ID: 0x0912, Name: "PCI-912 [i960CF-based Intelligent I/O Controller]"},
			{ID: 0x0913, Name: "PCI-913"},
			{ID: 0x0914, Name: "PCI-914 [I/O Controller w/ secondary PCI bus]"},
		},
	},
	{ID: 0x113d, Name: "Leading Edge Products Inc", Devices: []Device{}},
	{ID: 0x113e, Name: "Sanyo Electric Co - Computer Engineering Dept", Devices: []Device{}},
	{
		ID: 0x113f, Name: "Equinox Systems, Inc.", Devices: []Device{
			{ID: 0x0808, Name: "SST-64P Adapter"},
			{ID: 0x1010, Name: "SST-128P Adapter"},
			{ID: 0x80c0, Name: "SST-16P DB Adapter"},
			{ID: 0x80c4, Name: "SST-16P RJ Adapter"},
			{ID: 0x80c8, Name: "SST-16P Adapter"},
			{ID: 0x8888, Name: "SST-4P Adapter"},
			{ID: 0x9090, Name: "SST-8P Adapter"},
		},
	},
	{ID: 0x1140, Name: "Intervoice Inc", Devices: []Device{}},
	{ID: 0x1141, Name: "Crest Microsystem Inc", Devices: []Device{}},
	{
		ID: 0x1142, Name: "Alliance Semiconductor Corporation", Devices: []Device{
			{ID: 0x3210, Name: "AP6410"},
			{ID: 0x6422, Name: "ProVideo 6422"},
			{ID: 0x6424, Name: "ProVideo 6424"},
			{ID: 0x6425, Name: "ProMotion AT25"},
			{ID: 0x643d, Name: "ProMotion AT3D"},
		},
	},
	{ID: 0x1143, Name: "NetPower, Inc", Devices: []Device{}},
	{
		ID: 0x1144, Name: "Cincinnati Milacron", Devices: []Device{
			{ID: 0x0001, Name: "Noservo controller"},
		},
	},
	{
		ID: 0x1145, Name: "Workbit Corporation", Devices: []Device{
			{ID: 0x8007, Name: "NinjaSCSI-32 Workbit"},
			{ID: 0xf007, Name: "NinjaSCSI-32 KME"},
			{ID: 0xf010, Name: "NinjaSCSI-32 Workbit"},
			{ID: 0xf012, Name: "NinjaSCSI-32 Logitec"},
			{ID: 0xf013, Name: "NinjaSCSI-32 Logitec"},
			{ID: 0xf015, Name: "NinjaSCSI-32 Melco"},
			{ID: 0xf020, Name: "NinjaSCSI-32 Sony PCGA-DVD51"},
			{ID: 0xf021, Name: "NinjaPATA-32 Delkin Cardbus UDMA"},
			{ID: 0xf024, Name: "NinjaPATA-32 Delkin Cardbus UDMA"},
			{ID: 0xf103, Name: "NinjaPATA-32 Delkin Cardbus UDMA"},
		},
	},
	{ID: 0x1146, Name: "Force Computers", Devices: []Device{}},
	{ID: 0x1147, Name: "Interface Corp", Devices: []Device{}},
	{
		ID: 0x1148, Name: "SysKonnect", Devices: []Device{
			{ID: 0x4000, Name: "FDDI Adapter"},
			{ID: 0x4200, Name: "Token Ring adapter"},
			{ID: 0x4300, Name: "SK-9872 Gigabit Ethernet Server Adapter (SK-NET GE-ZX dual link)"},
			{ID: 0x4320, Name: "SK-98xx V2.0 Gigabit Ethernet Adapter [Marvell 88E8001]"},
			{ID: 0x4400, Name: "SK-9Dxx Gigabit Ethernet Adapter"},
			{ID: 0x4500, Name: "SK-9Mxx Gigabit Ethernet Adapter"},
			{ID: 0x9000, Name: "SK-9Sxx Gigabit Ethernet Server Adapter PCI-X [Marvell 88E8022]"},
			{ID: 0x9843, Name: "[Fujitsu] Gigabit Ethernet"},
			{ID: 0x9e00, Name: "SK-9E21D 10/100/1000Base-T Adapter, Copper RJ-45"},
			{ID: 0x9e01, Name: "SK-9E21M 10/100/1000Base-T Adapter"},
		},
	},
	{ID: 0x1149, Name: "Win System Corporation", Devices: []Device{}},
	{
		ID: 0x114a, Name: "VMIC", Devices: []Device{
			{ID: 0x5565, Name: "GE-IP PCI5565,PMC5565 Reflective Memory Node"},
			{ID: 0x5579, Name: "VMIPCI-5579 (Reflective Memory Card)"},
			{ID: 0x5587, Name: "VMIPCI-5587 (Reflective Memory Card)"},
			{ID: 0x6504, Name: "VMIC PCI 7755 FPGA"},
			{ID: 0x7587, Name: "VMIVME-7587"},
		},
	},
	{ID: 0x114b, Name: "Canopus Co., Ltd", Devices: []Device{}},
	{ID: 0x114c, Name: "Annabooks", Devices: []Device{}},
	{ID: 0x114d, Name: "IC Corporation", Devices: []Device{}},
	{ID: 0x114e, Name: "Nikon Systems Inc", Devices: []Device{}},
	{
		ID: 0x114f, Name: "Digi International", Devices: []Device{
			{ID: 0x0002, Name: "AccelePort EPC"},
			{ID: 0x0003, Name: "RightSwitch SE-6"},
			{ID: 0x0004, Name: "AccelePort Xem"},
			{ID: 0x0005, Name: "AccelePort Xr"},
			{ID: 0x0006, Name: "AccelePort Xr,C/X"},
			{ID: 0x0009, Name: "AccelePort Xr/J"},
			{ID: 0x000a, Name: "AccelePort EPC/J"},
			{ID: 0x000c, Name: "DataFirePRIme T1 (1-port)"},
			{ID: 0x000d, Name: "SyncPort 2-Port (x.25/FR)"},
			{ID: 0x0011, Name: "AccelePort 8r EIA-232 (IBM)"},
			{ID: 0x0012, Name: "AccelePort 8r EIA-422"},
			{ID: 0x0013, Name: "AccelePort Xr"},
			{ID: 0x0014, Name: "AccelePort 8r EIA-422"},
			{ID: 0x0015, Name: "AccelePort Xem"},
			{ID: 0x0016, Name: "AccelePort EPC/X"},
			{ID: 0x0017, Name: "AccelePort C/X"},
			{ID: 0x001a, Name: "DataFirePRIme E1 (1-port)"},
			{ID: 0x001b, Name: "AccelePort C/X (IBM)"},
			{ID: 0x001c, Name: "AccelePort Xr (SAIP)"},
			{ID: 0x001d, Name: "DataFire RAS T1/E1/PRI"},
			{ID: 0x0023, Name: "AccelePort RAS"},
			{ID: 0x0024, Name: "DataFire RAS B4 ST/U"},
			{ID: 0x0026, Name: "AccelePort 4r 920"},
			{ID: 0x0027, Name: "AccelePort Xr 920"},
			{ID: 0x0028, Name: "ClassicBoard 4"},
			{ID: 0x0029, Name: "ClassicBoard 8"},
			{ID: 0x0034, Name: "AccelePort 2r 920"},
			{ID: 0x0035, Name: "DataFire DSP T1/E1/PRI cPCI"},
			{ID: 0x0040, Name: "AccelePort Xp"},
			{ID: 0x0042, Name: "AccelePort 2p"},
			{ID: 0x0043, Name: "AccelePort 4p"},
			{ID: 0x0044, Name: "AccelePort 8p"},
			{ID: 0x0045, Name: "AccelePort 16p"},
			{ID: 0x004e, Name: "AccelePort 32p"},
			{ID: 0x0070, Name: "Datafire Micro V IOM2 (Europe)"},
			{ID: 0x0071, Name: "Datafire Micro V (Europe)"},
			{ID: 0x0072, Name: "Datafire Micro V IOM2 (North America)"},
			{ID: 0x0073, Name: "Datafire Micro V (North America)"},
			{ID: 0x00b0, Name: "Digi Neo 4"},
			{ID: 0x00b1, Name: "Digi Neo 8"},
			{ID: 0x00c8, Name: "Digi Neo 2 DB9"},
			{ID: 0x00c9, Name: "Digi Neo 2 DB9 PRI"},
			{ID: 0x00ca, Name: "Digi Neo 2 RJ45"},
			{ID: 0x00cb, Name: "Digi Neo 2 RJ45 PRI"},
			{ID: 0x00cc, Name: "Digi Neo 1 422"},
			{ID: 0x00cd, Name: "Digi Neo 1 422 485"},
			{ID: 0x00ce, Name: "Digi Neo 2 422 485"},
			{ID: 0x00d0, Name: "ClassicBoard 4 422"},
			{ID: 0x00d1, Name: "ClassicBoard 8 422"},
			{ID: 0x00f1, Name: "Digi Neo PCI-E 4 port"},
			{ID: 0x00f4, Name: "Digi Neo 4 (IBM version)"},
			{ID: 0x6001, Name: "Avanstar"},
		},
	},
	{ID: 0x1150, Name: "Thinking Machines Corp", Devices: []Device{}},
	{ID: 0x1151, Name: "JAE Electronics Inc.", Devices: []Device{}},
	{ID: 0x1152, Name: "Megatek", Devices: []Device{}},
	{ID: 0x1153, Name: "Land Win Electronic Corp", Devices: []Device{}},
	{ID: 0x1154, Name: "Melco Inc", Devices: []Device{}},
	{ID: 0x1155, Name: "Pine Technology Ltd", Devices: []Device{}},
	{ID: 0x1156, Name: "Periscope Engineering", Devices: []Device{}},
	{ID: 0x1157, Name: "Avsys Corporation", Devices: []Device{}},
	{
		ID: 0x1158, Name: "Voarx R & D Inc", Devices: []Device{
			{ID: 0x3011, Name: "Tokenet/vg 1001/10m anylan"},
			{ID: 0x9050, Name: "Lanfleet/Truevalue"},
			{ID: 0x9051, Name: "Lanfleet/Truevalue"},
		},
	},
	{
		ID: 0x1159, Name: "MuTech Corporation", Devices: []Device{
			{ID: 0x0001, Name: "MV-1000"},
			{ID: 0x0002, Name: "MV-1500"},
		},
	},
	{ID: 0x115a, Name: "Harlequin Ltd", Devices: []Device{}},
	{ID: 0x115b, Name: "Parallax Graphics", Devices: []Device{}},
	{ID: 0x115c, Name: "Photron Ltd.", Devices: []Device{}},
	{
		ID: 0x115d, Name: "Xircom", Devices: []Device{
			{ID: 0x0003, Name: "Cardbus Ethernet 10/100"},
			{ID: 0x0005, Name: "Cardbus Ethernet 10/100"},
			{ID: 0x0007, Name: "Cardbus Ethernet 10/100"},
			{ID: 0x000b, Name: "Cardbus Ethernet 10/100"},
			{ID: 0x000c, Name: "Mini-PCI V.90 56k Modem"},
			{ID: 0x000f, Name: "Cardbus Ethernet 10/100"},
			{ID: 0x00d4, Name: "Mini-PCI K56Flex Modem"},
			{ID: 0x0101, Name: "Cardbus 56k modem"},
			{ID: 0x0103, Name: "Cardbus Ethernet + 56k Modem"},
		},
	},
	{ID: 0x115e, Name: "Peer Protocols Inc", Devices: []Device{}},
	{ID: 0x115f, Name: "Maxtor Corporation", Devices: []Device{}},
	{ID: 0x1160, Name: "Megasoft Inc", Devices: []Device{}},
	{ID: 0x1161, Name: "PFU Limited", Devices: []Device{}},
	{ID: 0x1162, Name: "OA Laboratory Co Ltd", Devices: []Device{}},
	{
		ID: 0x1163, Name: "Rendition", Devices: []Device{
			{ID: 0x0001, Name: "Verite 1000"},
			{ID: 0x2000, Name: "Verite V2000/V2100/V2200"},
		},
	},
	{ID: 0x1164, Name: "Advanced Peripherals Technologies", Devices: []Device{}},
	{
		ID: 0x1165, Name: "Imagraph Corporation", Devices: []Device{
			{ID: 0x0001, Name: "Motion TPEG Recorder/Player with audio"},
		},
	},
	{
		ID: 0x1166, Name: "Broadcom", Devices: []Device{
			{ID: 0x0000, Name: "CMIC-LE"},
			{ID: 0x0005, Name: "CNB20-LE Host Bridge"},
			{ID: 0x0006, Name: "CNB20HE Host Bridge"},
			{ID: 0x0007, Name: "CNB20-LE Host Bridge"},
			{ID: 0x0008, Name: "CNB20HE Host Bridge"},
			{ID: 0x0009, Name: "CNB20LE Host Bridge"},
			{ID: 0x0010, Name: "CIOB30"},
			{ID: 0x0011, Name: "CMIC-HE"},
			{ID: 0x0012, Name: "CMIC-WS Host Bridge (GC-LE chipset)"},
			{ID: 0x0013, Name: "CNB20-HE Host Bridge"},
			{ID: 0x0014, Name: "CMIC-LE Host Bridge (GC-LE chipset)"},
			{ID: 0x0015, Name: "CMIC-GC Host Bridge"},
			{ID: 0x0016, Name: "CMIC-GC Host Bridge"},
			{ID: 0x0017, Name: "GCNB-LE Host Bridge"},
			{ID: 0x0031, Name: "HT1100 HPX0 HT Host Bridge"},
			{ID: 0x0036, Name: "BCM5785 [HT1000] PCI/PCI-X Bridge"},
			{ID: 0x0101, Name: "CIOB-X2 PCI-X I/O Bridge"},
			{ID: 0x0103, Name: "EPB PCI-Express to PCI-X Bridge"},
			{ID: 0x0104, Name: "BCM5785 [HT1000] PCI/PCI-X Bridge"},
			{ID: 0x0110, Name: "CIOB-E I/O Bridge with Gigabit Ethernet"},
			{ID: 0x0130, Name: "BCM5780 [HT2000] PCI-X bridge"},
			{ID: 0x0132, Name: "BCM5780 [HT2000] PCI-Express Bridge"},
			{ID: 0x0140, Name: "HT2100 PCI-Express Bridge"},
			{ID: 0x0141, Name: "HT2100 PCI-Express Bridge"},
			{ID: 0x0142, Name: "HT2100 PCI-Express Bridge"},
			{ID: 0x0144, Name: "HT2100 PCI-Express Bridge"},
			{ID: 0x0200, Name: "OSB4 South Bridge"},
			{ID: 0x0201, Name: "CSB5 South Bridge"},
			{ID: 0x0203, Name: "CSB6 South Bridge"},
			{ID: 0x0205, Name: "BCM5785 [HT1000] Legacy South Bridge"},
			{ID: 0x0211, Name: "OSB4 IDE Controller"},
			{ID: 0x0212, Name: "CSB5 IDE Controller"},
			{ID: 0x0213, Name: "CSB6 RAID/IDE Controller"},
			{ID: 0x0214, Name: "BCM5785 [HT1000] IDE"},
			{ID: 0x0217, Name: "CSB6 IDE Controller"},
			{ID: 0x021b, Name: "HT1100 HD Audio"},
			{ID: 0x0220, Name: "OSB4/CSB5 OHCI USB Controller"},
			{ID: 0x0221, Name: "CSB6 OHCI USB Controller"},
			{ID: 0x0223, Name: "BCM5785 [HT1000] USB"},
			{ID: 0x0225, Name: "CSB5 LPC bridge"},
			{ID: 0x0227, Name: "GCLE-2 Host Bridge"},
			{ID: 0x0230, Name: "CSB5 LPC bridge"},
			{ID: 0x0234, Name: "BCM5785 [HT1000] LPC"},
			{ID: 0x0235, Name: "BCM5785 [HT1000] XIOAPIC0-2"},
			{ID: 0x0238, Name: "BCM5785 [HT1000] WDTimer"},
			{ID: 0x0240, Name: "K2 SATA"},
			{ID: 0x0241, Name: "RAIDCore RC4000"},
			{ID: 0x0242, Name: "RAIDCore BC4000"},
			{ID: 0x024a, Name: "BCM5785 [HT1000] SATA (Native SATA Mode)"},
			{ID: 0x024b, Name: "BCM5785 [HT1000] SATA (PATA/IDE Mode)"},
			{ID: 0x0406, Name: "HT1100 PCI-X Bridge"},
			{ID: 0x0408, Name: "HT1100 Legacy Device"},
			{ID: 0x040a, Name: "HT1100 ISA-LPC Bridge"},
			{ID: 0x0410, Name: "HT1100 SATA Controller (Native SATA Mode)"},
			{ID: 0x0411, Name: "HT1100 SATA Controller (PATA / IDE Mode)"},
			{ID: 0x0412, Name: "HT1100 USB OHCI Controller"},
			{ID: 0x0414, Name: "HT1100 USB EHCI Controller"},
			{ID: 0x0416, Name: "HT1100 USB EHCI Controller (with Debug Port)"},
			{ID: 0x0420, Name: "HT1100 PCI-Express Bridge"},
			{ID: 0x0421, Name: "HT1100 SAS/SATA Controller"},
			{ID: 0x0422, Name: "HT1100 PCI-Express Bridge"},
		},
	},
	{ID: 0x1167, Name: "Mutoh Industries Inc", Devices: []Device{}},
	{ID: 0x1168, Name: "Thine Electronics Inc", Devices: []Device{}},
	{ID: 0x1169, Name: "Centre for Development of Advanced Computing", Devices: []Device{}},
	{
		ID: 0x116a, Name: "Luminex Software, Inc.", Devices: []Device{
			{ID: 0x6100, Name: "Bus/Tag Channel"},
			{ID: 0x6800, Name: "Escon Channel"},
			{ID: 0x7100, Name: "Bus/Tag Channel"},
			{ID: 0x7800, Name: "Escon Channel"},
		},
	},
	{ID: 0x116b, Name: "Connectware Inc", Devices: []Device{}},
	{ID: 0x116c, Name: "Intelligent Resources Integrated Systems", Devices: []Device{}},
	{ID: 0x116d, Name: "Martin-Marietta", Devices: []Device{}},
	{ID: 0x116e, Name: "Electronics for Imaging", Devices: []Device{}},
	{ID: 0x116f, Name: "Workstation Technology", Devices: []Device{}},
	{ID: 0x1170, Name: "Inventec Corporation", Devices: []Device{}},
	{ID: 0x1171, Name: "Loughborough Sound Images Plc", Devices: []Device{}},
	{
		ID: 0x1172, Name: "Altera Corporation", Devices: []Device{
			{ID: 0x00a7, Name: "Stratix V"},
			{ID: 0x0530, Name: "Stratix IV"},
			{ID: 0x646c, Name: "KT-500/KT-521 board"},
		},
	},
	{ID: 0x1173, Name: "Adobe Systems, Inc", Devices: []Device{}},
	{ID: 0x1174, Name: "Bridgeport Machines", Devices: []Device{}},
	{ID: 0x1175, Name: "Mitron Computer Inc.", Devices: []Device{}},
	{ID: 0x1176, Name: "SBE Incorporated", Devices: []Device{}},
	{ID: 0x1177, Name: "Silicon Engineering", Devices: []Device{}},
	{
		ID: 0x1178, Name: "Alfa, Inc.", Devices: []Device{
			{ID: 0xafa1, Name: "Fast Ethernet Adapter"},
		},
	},
	{
		ID: 0x1179, Name: "Toshiba Corporation", Devices: []Device{
			{ID: 0x0102, Name: "Extended IDE Controller"},
			{ID: 0x0103, Name: "EX-IDE Type-B"},
			{ID: 0x010e, Name: "PXP04 NVMe SSD"},
			{ID: 0x010f, Name: "NVMe Controller"},
			{ID: 0x0110, Name: "NVMe SSD Controller Cx5"},
			{ID: 0x0113, Name: "BG3 NVMe SSD Controller"},
			{ID: 0x0115, Name: "XG4 NVMe SSD Controller"},
			{ID: 0x011a, Name: "XG6 NVMe SSD Controller"},
			{ID: 0x0404, Name: "DVD Decoder card"},
			{ID: 0x0406, Name: "Tecra Video Capture device"},
			{ID: 0x0407, Name: "DVD Decoder card (Version 2)"},
			{ID: 0x0601, Name: "CPU to PCI bridge"},
			{ID: 0x0602, Name: "PCI to ISA bridge"},
			{ID: 0x0603, Name: "ToPIC95 PCI to CardBus Bridge for Notebooks"},
			{ID: 0x0604, Name: "PCI-Docking Host bridge"},
			{ID: 0x060a, Name: "ToPIC95"},
			{ID: 0x060f, Name: "ToPIC97"},
			{ID: 0x0617, Name: "ToPIC100 PCI to Cardbus Bridge with ZV Support"},
			{ID: 0x0618, Name: "CPU to PCI and PCI to ISA bridge"},
			{ID: 0x0701, Name: "FIR Port Type-O"},
			{ID: 0x0803, Name: "TC6371AF SD Host Controller"},
			{ID: 0x0804, Name: "TC6371AF SmartMedia Controller"},
			{ID: 0x0805, Name: "SD TypA Controller"},
			{ID: 0x0d01, Name: "FIR Port Type-DO"},
		},
	},
	{ID: 0x117a, Name: "A-Trend Technology", Devices: []Device{}},
	{ID: 0x117b, Name: "L G Electronics, Inc.", Devices: []Device{}},
	{
		ID: 0x117c, Name: "ATTO Technology, Inc.", Devices: []Device{
			{ID: 0x002c, Name: "ExpressSAS R380"},
			{ID: 0x002d, Name: "ExpressSAS R348"},
			{ID: 0x0030, Name: "Ultra320 SCSI Host Adapter"},
			{ID: 0x0033, Name: "SAS Adapter"},
			{ID: 0x0041, Name: "ExpressSAS R30F"},
			{ID: 0x0042, Name: "ExpressSAS 6Gb/s SAS/SATA HBA"},
			{ID: 0x0049, Name: "ExpressSAS 6Gb SAS/SATA RAID Adapter"},
			{ID: 0x0064, Name: "Celerity FC 16Gb/s Gen 5 Fibre Channel HBA"},
			{ID: 0x0094, Name: "Celerity FC 16/32Gb/s Gen 6 Fibre Channel HBA"},
			{ID: 0x00bb, Name: "Celerity FC 32/64Gb/s Gen 7 Fibre Channel HBA"},
			{ID: 0x00c5, Name: "ExpressNVM PCIe Gen4 Switch"},
			{ID: 0x00e6, Name: "ExpressSAS GT 12Gb/s SAS/SATA HBA"},
			{ID: 0x8013, Name: "ExpressPCI UL4D"},
			{ID: 0x8014, Name: "ExpressPCI UL4S"},
			{ID: 0x8027, Name: "ExpressPCI UL5D"},
			{ID: 0x8070, Name: "ExpressSAS 12Gb/s SAS/SATA HBA"},
			{ID: 0x8072, Name: "ExpressSAS 12Gb/s SAS/SATA HBA"},
		},
	},
	{ID: 0x117d, Name: "Becton & Dickinson", Devices: []Device{}},
	{ID: 0x117e, Name: "T/R Systems", Devices: []Device{}},
	{ID: 0x117f, Name: "Integrated Circuit Systems", Devices: []Device{}},
	{
		ID: 0x1180, Name: "Ricoh Co Ltd", Devices: []Device{
			{ID: 0x0465, Name: "RL5c465"},
			{ID: 0x0466, Name: "RL5c466"},
			{ID: 0x0475, Name: "RL5c475"},
			{ID: 0x0476, Name: "RL5c476 II"},
			{ID: 0x0477, Name: "RL5c477"},
			{ID: 0x0478, Name: "RL5c478"},
			{ID: 0x0511, Name: "R5C511"},
			{ID: 0x0522, Name: "R5C522 IEEE 1394 Controller"},
			{ID: 0x0551, Name: "R5C551 IEEE 1394 Controller"},
			{ID: 0x0552, Name: "R5C552 IEEE 1394 Controller"},
			{ID: 0x0554, Name: "R5C554"},
			{ID: 0x0575, Name: "R5C575 SD Bus Host Adapter"},
			{ID: 0x0576, Name: "R5C576 SD Bus Host Adapter"},
			{ID: 0x0592, Name: "R5C592 Memory Stick Bus Host Adapter"},
			{ID: 0x0811, Name: "R5C811"},
			{ID: 0x0822, Name: "R5C822 SD/SDIO/MMC/MS/MSPro Host Adapter"},
			{ID: 0x0832, Name: "R5C832 IEEE 1394 Controller"},
			{ID: 0x0841, Name: "R5C841 CardBus/SD/SDIO/MMC/MS/MSPro/xD/IEEE1394"},
			{ID: 0x0843, Name: "R5C843 MMC Host Controller"},
			{ID: 0x0852, Name: "xD-Picture Card Controller"},
			{ID: 0xe230, Name: "R5U2xx (R5U230 / R5U231 / R5U241) [Memory Stick Host Controller]"},
			{ID: 0xe476, Name: "CardBus bridge"},
			{ID: 0xe822, Name: "MMC/SD Host Controller"},
			{ID: 0xe823, Name: "PCIe SDXC/MMC Host Controller"},
			{ID: 0xe832, Name: "R5C832 PCIe IEEE 1394 Controller"},
			{ID: 0xe852, Name: "PCIe xD-Picture Card Controller"},
		},
	},
	{ID: 0x1181, Name: "Telmatics International", Devices: []Device{}},
	{ID: 0x1183, Name: "Fujikura Ltd", Devices: []Device{}},
	{ID: 0x1184, Name: "Forks Inc", Devices: []Device{}},
	{ID: 0x1185, Name: "Dataworld International Ltd", Devices: []Device{}},
	{
		ID: 0x1186, Name: "D-Link System Inc", Devices: []Device{
			{ID: 0x1002, Name: "DL10050 Sundance Ethernet"},
			{ID: 0x1025, Name: "AirPlus Xtreme G DWL-G650 Adapter"},
			{ID: 0x1026, Name: "AirXpert DWL-AG650 Wireless Cardbus Adapter"},
			{ID: 0x1043, Name: "AirXpert DWL-AG650 Wireless Cardbus Adapter"},
			{ID: 0x1300, Name: "RTL8139 Ethernet"},
			{ID: 0x1340, Name: "DFE-690TXD CardBus PC Card"},
			{ID: 0x1540, Name: "DFE-680TX"},
			{ID: 0x1541, Name: "DFE-680TXD CardBus PC Card"},
			{ID: 0x1561, Name: "DRP-32TXD Cardbus PC Card"},
			{ID: 0x3300, Name: "DWL-510 / DWL-610 802.11b [Realtek RTL8180L]"},
			{ID: 0x3a10, Name: "AirXpert DWL-AG650 Wireless Cardbus Adapter(rev.B)"},
			{ID: 0x3a11, Name: "AirXpert DWL-AG520 Wireless PCI Adapter(rev.B)"},
			{ID: 0x4000, Name: "DL2000-based Gigabit Ethernet"},
			{ID: 0x4001, Name: "DGE-550SX PCI-X Gigabit Ethernet Adapter"},
			{ID: 0x4200, Name: "DFE-520TX Fast Ethernet PCI Adapter"},
			{ID: 0x4300, Name: "DGE-528T Gigabit Ethernet Adapter"},
			{ID: 0x4302, Name: "DGE-530T Gigabit Ethernet Adapter (rev.C1) [Realtek RTL8169]"},
			{ID: 0x4b00, Name: "DGE-560T PCI Express Gigabit Ethernet Adapter"},
			{ID: 0x4b01, Name: "DGE-530T Gigabit Ethernet Adapter (rev 11)"},
			{ID: 0x4b02, Name: "DGE-560SX PCI Express Gigabit Ethernet Adapter"},
			{ID: 0x4b03, Name: "DGE-550T Gigabit Ethernet Adapter V.B1"},
			{ID: 0x4c00, Name: "Gigabit Ethernet Adapter"},
			{ID: 0x8400, Name: "D-Link DWL-650+ CardBus PC Card"},
		},
	},
	{ID: 0x1187, Name: "Advanced Technology Laboratories, Inc.", Devices: []Device{}},
	{ID: 0x1188, Name: "Shima Seiki Manufacturing Ltd.", Devices: []Device{}},
	{ID: 0x1189, Name: "Matsushita Electronics Co Ltd", Devices: []Device{}},
	{ID: 0x118a, Name: "Hilevel Technology", Devices: []Device{}},
	{ID: 0x118b, Name: "Hypertec Pty Limited", Devices: []Device{}},
	{
		ID: 0x118c, Name: "Corollary, Inc", Devices: []Device{
			{ID: 0x0014, Name: "PCIB [C-bus II to PCI bus host bridge chip]"},
			{ID: 0x1117, Name: "Intel 8-way XEON Profusion Chipset [Cache Coherency Filter]"},
		},
	},
	{
		ID: 0x118d, Name: "BitFlow Inc", Devices: []Device{
			{ID: 0x0001, Name: "Raptor-PCI framegrabber"},
			{ID: 0x0012, Name: "Model 12 Road Runner Frame Grabber"},
			{ID: 0x0014, Name: "Model 14 Road Runner Frame Grabber"},
			{ID: 0x0024, Name: "Model 24 Road Runner Frame Grabber"},
			{ID: 0x0044, Name: "Model 44 Road Runner Frame Grabber"},
			{ID: 0x0112, Name: "Model 12 Road Runner Frame Grabber"},
			{ID: 0x0114, Name: "Model 14 Road Runner Frame Grabber"},
			{ID: 0x0124, Name: "Model 24 Road Runner Frame Grabber"},
			{ID: 0x0144, Name: "Model 44 Road Runner Frame Grabber"},
			{ID: 0x0212, Name: "Model 12 Road Runner Frame Grabber"},
			{ID: 0x0214, Name: "Model 14 Road Runner Frame Grabber"},
			{ID: 0x0224, Name: "Model 24 Road Runner Frame Grabber"},
			{ID: 0x0244, Name: "Model 44 Road Runner Frame Grabber"},
			{ID: 0x0312, Name: "Model 12 Road Runner Frame Grabber"},
			{ID: 0x0314, Name: "Model 14 Road Runner Frame Grabber"},
			{ID: 0x0324, Name: "Model 24 Road Runner Frame Grabber"},
			{ID: 0x0344, Name: "Model 44 Road Runner Frame Grabber"},
			{ID: 0xb04e, Name: "Claxon CXP4 CoaXPress frame grabber"},
		},
	},
	{ID: 0x118e, Name: "Hermstedt GmbH", Devices: []Device{}},
	{ID: 0x118f, Name: "Green Logic", Devices: []Device{}},
	{
		ID: 0x1190, Name: "Tripace", Devices: []Device{
			{ID: 0xc731, Name: "TP-910/920/940 PCI Ultra(Wide) SCSI Adapter"},
		},
	},
	{
		ID: 0x1191, Name: "Artop Electronic Corp", Devices: []Device{
			{ID: 0x0003, Name: "SCSI Cache Host Adapter"},
			{ID: 0x0004, Name: "ATP8400"},
			{ID: 0x0005, Name: "ATP850UF"},
			{ID: 0x0006, Name: "ATP860 NO-BIOS"},
			{ID: 0x0007, Name: "ATP860"},
			{ID: 0x0008, Name: "ATP865 NO-ROM"},
			{ID: 0x0009, Name: "ATP865"},
			{ID: 0x000a, Name: "ATP867-A"},
			{ID: 0x000b, Name: "ATP867-B"},
			{ID: 0x000d, Name: "ATP8620"},
			{ID: 0x000e, Name: "ATP8620"},
			{ID: 0x8002, Name: "AEC6710 SCSI-2 Host Adapter"},
			{ID: 0x8010, Name: "AEC6712UW SCSI"},
			{ID: 0x8020, Name: "AEC6712U SCSI"},
			{ID: 0x8030, Name: "AEC6712S SCSI"},
			{ID: 0x8040, Name: "AEC6712D SCSI"},
			{ID: 0x8050, Name: "AEC6712SUW SCSI"},
			{ID: 0x8060, Name: "AEC6712 SCSI"},
			{ID: 0x8080, Name: "AEC67160 SCSI"},
			{ID: 0x8081, Name: "AEC67160S SCSI"},
			{ID: 0x808a, Name: "AEC67162 2-ch. LVD SCSI"},
		},
	},
	{ID: 0x1192, Name: "Densan Company Ltd", Devices: []Device{}},
	{
		ID: 0x1193, Name: "Zeitnet Inc.", Devices: []Device{
			{ID: 0x0001, Name: "1221"},
			{ID: 0x0002, Name: "1225"},
		},
	},
	{ID: 0x1194, Name: "Toucan Technology", Devices: []Device{}},
	{ID: 0x1195, Name: "Ratoc System Inc", Devices: []Device{}},
	{ID: 0x1196, Name: "Hytec Electronics Ltd", Devices: []Device{}},
	{
		ID: 0x1197, Name: "Gage Applied Sciences, Inc.", Devices: []Device{
			{ID: 0x010c, Name: "CompuScope 82G 8bit 2GS/s Analog Input Card"},
		},
	},
	{ID: 0x1198, Name: "Lambda Systems Inc", Devices: []Device{}},
	{
		ID: 0x1199, Name: "Attachmate Corporation", Devices: []Device{
			{ID: 0x0101, Name: "Advanced ISCA/PCI Adapter"},
		},
	},
	{ID: 0x119a, Name: "Mind Share, Inc.", Devices: []Device{}},
	{
		ID: 0x119b, Name: "Omega Micro Inc.", Devices: []Device{
			{ID: 0x1221, Name: "82C092G"},
		},
	},
	{ID: 0x119c, Name: "Information Technology Inst.", Devices: []Device{}},
	{ID: 0x119d, Name: "Bug, Inc. Sapporo Japan", Devices: []Device{}},
	{
		ID: 0x119e, Name: "Fujitsu Microelectronics Ltd.", Devices: []Device{
			{ID: 0x0001, Name: "FireStream 155"},
			{ID: 0x0003, Name: "FireStream 50"},
		},
	},
	{
		ID: 0x119f, Name: "Bull HN Information Systems", Devices: []Device{
			{ID: 0x1081, Name: "BXI Host Channel Adapter"},
			{ID: 0x1101, Name: "BXI Host Channel Adapter v1.2"},
			{ID: 0x1121, Name: "BXI Host Channel Adapter v1.3"},
		},
	},
	{ID: 0x11a0, Name: "Convex Computer Corporation", Devices: []Device{}},
	{ID: 0x11a1, Name: "Hamamatsu Photonics K.K.", Devices: []Device{}},
	{ID: 0x11a2, Name: "Sierra Research and Technology", Devices: []Device{}},
	{ID: 0x11a3, Name: "Deuretzbacher GmbH & Co. Eng. KG", Devices: []Device{}},
	{ID: 0x11a4, Name: "Barco Graphics NV", Devices: []Device{}},
	{ID: 0x11a5, Name: "Microunity Systems Eng. Inc", Devices: []Device{}},
	{ID: 0x11a6, Name: "Pure Data Ltd.", Devices: []Device{}},
	{ID: 0x11a7, Name: "Power Computing Corp.", Devices: []Device{}},
	{ID: 0x11a8, Name: "Systech Corp.", Devices: []Device{}},
	{
		ID: 0x11a9, Name: "InnoSys Inc.", Devices: []Device{
			{ID: 0x4240, Name: "AMCC S933Q Intelligent Serial Card"},
		},
	},
	{ID: 0x11aa, Name: "Actel", Devices: []Device{}},
	{
		ID: 0x11ab, Name: "Marvell Technology Group Ltd.", Devices: []Device{
			{ID: 0x0100, Name: "88F3700 [Armada 3700 Family] ARM SoC"},
			{ID: 0x0110, Name: "88F60x0/88F70x0/88F80x0/CN913x ARM SoC"},
			{ID: 0x0146, Name: "GT-64010/64010A System Controller"},
			{ID: 0x0f53, Name: "88E6318 Link Street network controller"},
			{ID: 0x11ab, Name: "MV88SE614x SATA II PCI-E controller"},
			{ID: 0x138f, Name: "W8300 802.11 Adapter (rev 07)"},
			{ID: 0x1fa6, Name: "Marvell W8300 802.11 Adapter"},
			{ID: 0x1fa7, Name: "88W8310 and 88W8000G [Libertas] 802.11g client chipset"},
			{ID: 0x1faa, Name: "88w8335 [Libertas] 802.11b/g Wireless"},
			{ID: 0x2211, Name: "88SB2211 PCI Express to PCI Bridge"},
			{ID: 0x2a01, Name: "88W8335 [Libertas] 802.11b/g Wireless"},
			{ID: 0x2a02, Name: "88W8361 [TopDog] 802.11n Wireless"},
			{ID: 0x2a08, Name: "88W8362e [TopDog] 802.11a/b/g/n Wireless"},
			{ID: 0x2a0a, Name: "88W8363 [TopDog] 802.11n Wireless"},
			{ID: 0x2a0c, Name: "88W8363 [TopDog] 802.11n Wireless"},
			{ID: 0x2a24, Name: "88W8363 [TopDog] 802.11n Wireless"},
			{ID: 0x2a2b, Name: "88W8687 [TopDog] 802.11b/g Wireless"},
			{ID: 0x2a30, Name: "88W8687 [TopDog] 802.11b/g Wireless"},
			{ID: 0x2a40, Name: "88W8366 [TopDog] 802.11n Wireless"},
			{ID: 0x2a41, Name: "88W8366 [TopDog] 802.11n Wireless"},
			{ID: 0x2a42, Name: "88W8366 [TopDog] 802.11n Wireless"},
			{ID: 0x2a43, Name: "88W8366 [TopDog] 802.11n Wireless"},
			{ID: 0x2a55, Name: "88W8864 [Avastar] 802.11ac Wireless"},
			{ID: 0x2b36, Name: "88W8764 [Avastar] 802.11n Wireless"},
			{ID: 0x2b38, Name: "88W8897 [AVASTAR] 802.11ac Wireless"},
			{ID: 0x2b40, Name: "88W8964 [Avastar] 802.11ac Wireless"},
			{ID: 0x4101, Name: "OLPC Cafe Controller Secure Digital Controller"},
			{ID: 0x4146, Name: "GT-64111 System Controller"},
			{ID: 0x4320, Name: "88E8001 Gigabit Ethernet Controller"},
			{ID: 0x4340, Name: "88E8021 PCI-X IPMI Gigabit Ethernet Controller"},
			{ID: 0x4341, Name: "88E8022 PCI-X IPMI Gigabit Ethernet Controller"},
			{ID: 0x4342, Name: "88E8061 PCI-E IPMI Gigabit Ethernet Controller"},
			{ID: 0x4343, Name: "88E8062 PCI-E IPMI Gigabit Ethernet Controller"},
			{ID: 0x4344, Name: "88E8021 PCI-X IPMI Gigabit Ethernet Controller"},
			{ID: 0x4345, Name: "88E8022 PCI-X IPMI Gigabit Ethernet Controller"},
			{ID: 0x4346, Name: "88E8061 PCI-E IPMI Gigabit Ethernet Controller"},
			{ID: 0x4347, Name: "88E8062 PCI-E IPMI Gigabit Ethernet Controller"},
			{ID: 0x4350, Name: "88E8035 PCI-E Fast Ethernet Controller"},
			{ID: 0x4351, Name: "88E8036 PCI-E Fast Ethernet Controller"},
			{ID: 0x4352, Name: "88E8038 PCI-E Fast Ethernet Controller"},
			{ID: 0x4353, Name: "88E8039 PCI-E Fast Ethernet Controller"},
			{ID: 0x4354, Name: "88E8040 PCI-E Fast Ethernet Controller"},
			{ID: 0x4355, Name: "88E8040T PCI-E Fast Ethernet Controller"},
			{ID: 0x4356, Name: "88EC033 PCI-E Fast Ethernet Controller"},
			{ID: 0x4357, Name: "88E8042 PCI-E Fast Ethernet Controller"},
			{ID: 0x435a, Name: "88E8048 PCI-E Fast Ethernet Controller"},
			{ID: 0x4360, Name: "88E8052 PCI-E ASF Gigabit Ethernet Controller"},
			{ID: 0x4361, Name: "88E8050 PCI-E ASF Gigabit Ethernet Controller"},
			{ID: 0x4362, Name: "88E8053 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x4363, Name: "88E8055 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x4364, Name: "88E8056 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x4365, Name: "88E8070 based Ethernet Controller"},
			{ID: 0x4366, Name: "88EC036 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x4367, Name: "88EC032 Ethernet Controller"},
			{ID: 0x4368, Name: "88EC034 Ethernet Controller"},
			{ID: 0x4369, Name: "88EC042 Ethernet Controller"},
			{ID: 0x436a, Name: "88E8058 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x436b, Name: "88E8071 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x436c, Name: "88E8072 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x436d, Name: "88E8055 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x4370, Name: "88E8075 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x4380, Name: "88E8057 PCI-E Gigabit Ethernet Controller"},
			{ID: 0x4381, Name: "Yukon Optima 88E8059 [PCIe Gigabit Ethernet Controller with AVB]"},
			{ID: 0x4611, Name: "GT-64115 System Controller"},
			{ID: 0x4620, Name: "GT-64120/64120A/64121A System Controller"},
			{ID: 0x4801, Name: "GT-48001"},
			{ID: 0x5005, Name: "Belkin F5D5005 Gigabit Desktop Network PCI Card"},
			{ID: 0x5040, Name: "MV88SX5040 4-port SATA I PCI-X Controller"},
			{ID: 0x5041, Name: "MV88SX5041 4-port SATA I PCI-X Controller"},
			{ID: 0x5080, Name: "MV88SX5080 8-port SATA I PCI-X Controller"},
			{ID: 0x5081, Name: "MV88SX5081 8-port SATA I PCI-X Controller"},
			{ID: 0x5181, Name: "88f5181 [Orion-1] ARM SoC"},
			{ID: 0x5182, Name: "88f5182 [Orion-NAS] ARM SoC"},
			{ID: 0x5281, Name: "88f5281 [Orion-2] ARM SoC"},
			{ID: 0x6041, Name: "MV88SX6041 4-port SATA II PCI-X Controller"},
			{ID: 0x6042, Name: "88SX6042 PCI-X 4-Port SATA-II"},
			{ID: 0x6081, Name: "MV88SX6081 8-port SATA II PCI-X Controller"},
			{ID: 0x6101, Name: "88SE6101/6102 single-port PATA133 interface"},
			{ID: 0x6121, Name: "88SE6111/6121 SATA II / PATA Controller"},
			{ID: 0x6141, Name: "88SE614x SATA II PCI-E controller"},
			{ID: 0x6145, Name: "88SE6145 SATA II PCI-E controller"},
			{ID: 0x6180, Name: "88F6180 [Kirkwood] ARM SoC"},
			{ID: 0x6192, Name: "88F6190/6192 [Kirkwood] ARM SoC"},
			{ID: 0x6281, Name: "88F6281 [Kirkwood] ARM SoC"},
			{ID: 0x6381, Name: "MV78xx0 [Discovery Innovation] ARM SoC"},
			{ID: 0x6440, Name: "88SE6440 SAS/SATA PCIe controller"},
			{ID: 0x6450, Name: "64560 System Controller"},
			{ID: 0x6460, Name: "MV64360/64361/64362 System Controller"},
			{ID: 0x6480, Name: "MV64460/64461/64462 System Controller"},
			{ID: 0x6485, Name: "MV64460/64461/64462 System Controller, Revision B"},
			{ID: 0x6560, Name: "88F6560 [Avanta] ARM SoC"},
			{ID: 0x6710, Name: "88F6710 [Armada 370] ARM SoC"},
			{ID: 0x6820, Name: "88F6820 [Armada 385] ARM SoC"},
			{ID: 0x6828, Name: "88F6828 [Armada 388] ARM SoC"},
			{ID: 0x6920, Name: "88F6920 [Armada 390] ARM SoC"},
			{ID: 0x7042, Name: "88SX7042 PCI-e 4-port SATA-II"},
			{ID: 0x7810, Name: "MV78100 [Discovery Innovation] ARM SoC"},
			{ID: 0x7820, Name: "MV78200 [Discovery Innovation] ARM SoC"},
			{ID: 0x7823, Name: "MV78230 [Armada XP] ARM SoC"},
			{ID: 0x7846, Name: "MV78460 [Armada XP] ARM SoC"},
			{ID: 0xd40f, Name: "Bobcat3 Ethernet Switch"},
			{ID: 0xf003, Name: "GT-64010 Primary Image Piranha Image Generator"},
		},
	},
	{ID: 0x11ac, Name: "Canon Information Systems Research Aust.", Devices: []Device{}},
	{
		ID: 0x11ad, Name: "Lite-On Communications Inc", Devices: []Device{
			{ID: 0x0002, Name: "LNE100TX"},
			{ID: 0xc115, Name: "LNE100TX [Linksys EtherFast 10/100]"},
		},
	},
	{ID: 0x11ae, Name: "Aztech System Ltd", Devices: []Device{}},
	{
		ID: 0x11af, Name: "Avid Technology Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Cinema"},
			{ID: 0xee40, Name: "Digidesign Audiomedia III"},
		},
	},
	{
		ID: 0x11b0, Name: "V3 Semiconductor Inc.", Devices: []Device{
			{ID: 0x0002, Name: "V300PSC"},
			{ID: 0x0292, Name: "V292PBC [Am29030/40 Bridge]"},
			{ID: 0x0960, Name: "V96xPBC"},
			{ID: 0x880a, Name: "Deltacast Delta-HD-22"},
			{ID: 0xc960, Name: "V96DPC"},
		},
	},
	{ID: 0x11b1, Name: "Apricot Computers", Devices: []Device{}},
	{ID: 0x11b2, Name: "Eastman Kodak", Devices: []Device{}},
	{ID: 0x11b3, Name: "Barr Systems Inc.", Devices: []Device{}},
	{ID: 0x11b4, Name: "Leitch Technology International", Devices: []Device{}},
	{ID: 0x11b5, Name: "Radstone Technology Plc", Devices: []Device{}},
	{ID: 0x11b6, Name: "United Video Corp", Devices: []Device{}},
	{ID: 0x11b7, Name: "Motorola", Devices: []Device{}},
	{
		ID: 0x11b8, Name: "XPoint Technologies, Inc", Devices: []Device{
			{ID: 0x0001, Name: "Quad PeerMaster"},
		},
	},
	{
		ID: 0x11b9, Name: "Pathlight Technology Inc.", Devices: []Device{
			{ID: 0xc0ed, Name: "SSA Controller"},
		},
	},
	{ID: 0x11ba, Name: "Videotron Corp", Devices: []Device{}},
	{ID: 0x11bb, Name: "Pyramid Technology", Devices: []Device{}},
	{
		ID: 0x11bc, Name: "Network Peripherals Inc", Devices: []Device{
			{ID: 0x0001, Name: "NP-PCI"},
		},
	},
	{
		ID: 0x11bd, Name: "Pinnacle Systems Inc.", Devices: []Device{
			{ID: 0x002e, Name: "PCTV 40i"},
			{ID: 0x0040, Name: "Royal TS Function 1"},
			{ID: 0x0041, Name: "RoyalTS Function 2"},
			{ID: 0x0042, Name: "Royal TS Function 3"},
			{ID: 0x0051, Name: "PCTV HD 800i"},
			{ID: 0xbede, Name: "AV/DV Studio Capture Card"},
		},
	},
	{ID: 0x11be, Name: "International Microcircuits Inc", Devices: []Device{}},
	{ID: 0x11bf, Name: "Astrodesign, Inc.", Devices: []Device{}},
	{ID: 0x11c0, Name: "Hewlett Packard", Devices: []Device{}},
	{
		ID: 0x11c1, Name: "LSI Corporation", Devices: []Device{
			{ID: 0x0440, Name: "56k WinModem"},
			{ID: 0x0441, Name: "56k WinModem"},
			{ID: 0x0442, Name: "56k WinModem"},
			{ID: 0x0443, Name: "LT WinModem"},
			{ID: 0x0444, Name: "LT WinModem"},
			{ID: 0x0445, Name: "LT WinModem"},
			{ID: 0x0446, Name: "LT WinModem"},
			{ID: 0x0447, Name: "LT WinModem"},
			{ID: 0x0448, Name: "WinModem 56k"},
			{ID: 0x0449, Name: "L56xM+S [Mars-2] WinModem 56k"},
			{ID: 0x044a, Name: "F-1156IV WinModem (V90, 56KFlex)"},
			{ID: 0x044b, Name: "LT WinModem"},
			{ID: 0x044c, Name: "LT WinModem"},
			{ID: 0x044d, Name: "LT WinModem"},
			{ID: 0x044e, Name: "LT WinModem"},
			{ID: 0x044f, Name: "V90 WildWire Modem"},
			{ID: 0x0450, Name: "LT WinModem"},
			{ID: 0x0451, Name: "LT WinModem"},
			{ID: 0x0452, Name: "LT WinModem"},
			{ID: 0x0453, Name: "LT WinModem"},
			{ID: 0x0454, Name: "LT WinModem"},
			{ID: 0x0455, Name: "LT WinModem"},
			{ID: 0x0456, Name: "LT WinModem"},
			{ID: 0x0457, Name: "LT WinModem"},
			{ID: 0x0458, Name: "LT WinModem"},
			{ID: 0x0459, Name: "LT WinModem"},
			{ID: 0x045a, Name: "LT WinModem"},
			{ID: 0x045c, Name: "LT WinModem"},
			{ID: 0x0461, Name: "V90 WildWire Modem"},
			{ID: 0x0462, Name: "V90 WildWire Modem"},
			{ID: 0x0480, Name: "Venus Modem (V90, 56KFlex)"},
			{ID: 0x048c, Name: "V.92 56K WinModem"},
			{ID: 0x048f, Name: "V.92 56k WinModem"},
			{ID: 0x0620, Name: "Lucent V.92 Data/Fax Modem"},
			{ID: 0x2600, Name: "StarPro26XX family (SP2601, SP2603, SP2612) DSP"},
			{ID: 0x5400, Name: "OR3TP12 FPSC"},
			{ID: 0x5656, Name: "Venus Modem"},
			{ID: 0x5801, Name: "USB"},
			{ID: 0x5802, Name: "USS-312 USB Controller"},
			{ID: 0x5803, Name: "USS-344S USB Controller"},
			{ID: 0x5811, Name: "FW322/323 [TrueFire] 1394a Controller"},
			{ID: 0x5901, Name: "FW643 [TrueFire] PCIe 1394b Controller"},
			{ID: 0x5903, Name: "FW533 [TrueFire] PCIe 1394a Controller"},
			{ID: 0x8110, Name: "T8110 H.100/H.110 TDM switch"},
			{ID: 0xab10, Name: "WL60010 Wireless LAN MAC"},
			{ID: 0xab11, Name: "WL60040 Multimode Wireles LAN MAC"},
			{ID: 0xab20, Name: "ORiNOCO PCI Adapter"},
			{ID: 0xab21, Name: "Agere Wireless PCI Adapter"},
			{ID: 0xab30, Name: "Hermes2 Mini-PCI WaveLAN a/b/g"},
			{ID: 0xed00, Name: "ET-131x PCI-E Ethernet Controller"},
			{ID: 0xed01, Name: "ET-131x PCI-E Ethernet Controller"},
		},
	},
	{ID: 0x11c2, Name: "Sand Microelectronics", Devices: []Device{}},
	{ID: 0x11c3, Name: "NEC Corporation", Devices: []Device{}},
	{ID: 0x11c4, Name: "Document Technologies, Inc", Devices: []Device{}},
	{ID: 0x11c5, Name: "Shiva Corporation", Devices: []Device{}},
	{ID: 0x11c6, Name: "Dainippon Screen Mfg. Co. Ltd", Devices: []Device{}},
	{ID: 0x11c7, Name: "D.C.M. Data Systems", Devices: []Device{}},
	{
		ID: 0x11c8, Name: "Dolphin Interconnect Solutions AS", Devices: []Device{
			{ID: 0x0658, Name: "PSB32 SCI-Adapter D31x"},
			{ID: 0xd665, Name: "PSB64 SCI-Adapter D32x"},
			{ID: 0xd667, Name: "PSB66 SCI-Adapter D33x"},
		},
	},
	{
		ID: 0x11c9, Name: "Magma", Devices: []Device{
			{ID: 0x0010, Name: "16-line serial port w/- DMA"},
			{ID: 0x0011, Name: "4-line serial port w/- DMA"},
		},
	},
	{ID: 0x11ca, Name: "LSI Systems, Inc", Devices: []Device{}},
	{
		ID: 0x11cb, Name: "Specialix Research Ltd.", Devices: []Device{
			{ID: 0x2000, Name: "PCI_9050"},
			{ID: 0x4000, Name: "SUPI_1"},
			{ID: 0x8000, Name: "T225"},
		},
	},
	{ID: 0x11cc, Name: "Michels & Kleberhoff Computer GmbH", Devices: []Device{}},
	{ID: 0x11cd, Name: "HAL Computer Systems, Inc.", Devices: []Device{}},
	{ID: 0x11ce, Name: "Netaccess", Devices: []Device{}},
	{ID: 0x11cf, Name: "Pioneer Electronic Corporation", Devices: []Device{}},
	{ID: 0x11d0, Name: "Lockheed Martin Federal Systems-Manassas", Devices: []Device{}},
	{
		ID: 0x11d1, Name: "Auravision", Devices: []Device{
			{ID: 0x01f7, Name: "VxP524"},
			{ID: 0x01f9, Name: "VxP951"},
		},
	},
	{ID: 0x11d2, Name: "Intercom Inc.", Devices: []Device{}},
	{ID: 0x11d3, Name: "Trancell Systems Inc", Devices: []Device{}},
	{
		ID: 0x11d4, Name: "Analog Devices", Devices: []Device{
			{ID: 0x1535, Name: "Blackfin BF535 processor"},
			{ID: 0x1805, Name: "SM56 PCI modem"},
		},
	},
	{
		ID: 0x11d5, Name: "Ikon Corporation", Devices: []Device{
			{ID: 0x0115, Name: "10115"},
			{ID: 0x0117, Name: "10117"},
		},
	},
	{ID: 0x11d6, Name: "Tekelec Telecom", Devices: []Device{}},
	{ID: 0x11d7, Name: "Trenton Technology, Inc.", Devices: []Device{}},
	{ID: 0x11d8, Name: "Image Technologies Development", Devices: []Device{}},
	{ID: 0x11d9, Name: "TEC Corporation", Devices: []Device{}},
	{ID: 0x11da, Name: "Novell", Devices: []Device{}},
	{ID: 0x11db, Name: "Sega Enterprises Ltd", Devices: []Device{}},
	{ID: 0x11dc, Name: "Questra Corporation", Devices: []Device{}},
	{ID: 0x11dd, Name: "Crosfield Electronics Limited", Devices: []Device{}},
	{
		ID: 0x11de, Name: "Zoran Corporation", Devices: []Device{
			{ID: 0x6017, Name: "miroVIDEO DC30"},
			{ID: 0x6057, Name: "ZR36057PQC Video cutting chipset"},
			{ID: 0x6120, Name: "ZR36120"},
		},
	},
	{ID: 0x11df, Name: "New Wave PDG", Devices: []Device{}},
	{ID: 0x11e0, Name: "Cray Communications A/S", Devices: []Device{}},
	{ID: 0x11e1, Name: "GEC Plessey Semi Inc.", Devices: []Device{}},
	{ID: 0x11e2, Name: "Samsung Information Systems America", Devices: []Device{}},
	{
		ID: 0x11e3, Name: "Quicklogic Corporation", Devices: []Device{
			{ID: 0x0001, Name: "COM-ON-AIR Dosch&Amand DECT"},
			{ID: 0x0560, Name: "QL5064 Companion Design Demo Board"},
			{ID: 0x5030, Name: "PC Watchdog"},
			{ID: 0x8417, Name: "QL5064 [QuickPCI] PCI v2.2 bridge for SMT417 Dual TMS320C6416T PMC Module"},
		},
	},
	{ID: 0x11e4, Name: "Second Wave Inc", Devices: []Device{}},
	{ID: 0x11e5, Name: "IIX Consulting", Devices: []Device{}},
	{ID: 0x11e6, Name: "Mitsui-Zosen System Research", Devices: []Device{}},
	{ID: 0x11e7, Name: "Toshiba America, Elec. Company", Devices: []Device{}},
	{ID: 0x11e8, Name: "Digital Processing Systems Inc.", Devices: []Device{}},
	{ID: 0x11e9, Name: "Highwater Designs Ltd.", Devices: []Device{}},
	{ID: 0x11ea, Name: "Elsag Bailey", Devices: []Device{}},
	{ID: 0x11eb, Name: "Formation Inc.", Devices: []Device{}},
	{
		ID: 0x11ec, Name: "Coreco Inc", Devices: []Device{
			{ID: 0x000d, Name: "Oculus-F/64P"},
			{ID: 0x1800, Name: "Cobra/C6"},
		},
	},
	{ID: 0x11ed, Name: "Mediamatics", Devices: []Device{}},
	{ID: 0x11ee, Name: "Dome Imaging Systems Inc", Devices: []Device{}},
	{ID: 0x11ef, Name: "Nicolet Technologies B.V.", Devices: []Device{}},
	{
		ID: 0x11f0, Name: "Compu-Shack", Devices: []Device{
			{ID: 0x4231, Name: "FDDI"},
			{ID: 0x4232, Name: "FASTline UTP Quattro"},
			{ID: 0x4233, Name: "FASTline FO"},
			{ID: 0x4234, Name: "FASTline UTP"},
			{ID: 0x4235, Name: "FASTline-II UTP"},
			{ID: 0x4236, Name: "FASTline-II FO"},
			{ID: 0x4731, Name: "GIGAline"},
		},
	},
	{ID: 0x11f1, Name: "Symbios Logic Inc", Devices: []Device{}},
	{ID: 0x11f2, Name: "Picture Tel Japan K.K.", Devices: []Device{}},
	{
		ID: 0x11f3, Name: "Keithley Metrabyte", Devices: []Device{
			{ID: 0x0011, Name: "KPCI-PIO24"},
		},
	},
	{
		ID: 0x11f4, Name: "Kinetic Systems Corporation", Devices: []Device{
			{ID: 0x2915, Name: "CAMAC controller"},
		},
	},
	{ID: 0x11f5, Name: "Computing Devices International", Devices: []Device{}},
	{
		ID: 0x11f6, Name: "Compex", Devices: []Device{
			{ID: 0x0112, Name: "ENet100VG4"},
			{ID: 0x0113, Name: "FreedomLine 100"},
			{ID: 0x1401, Name: "ReadyLink 2000"},
			{ID: 0x2011, Name: "RL100-ATX 10/100"},
			{ID: 0x2201, Name: "ReadyLink 100TX (Winbond W89C840)"},
			{ID: 0x9881, Name: "RL100TX Fast Ethernet"},
		},
	},
	{ID: 0x11f7, Name: "Scientific Atlanta", Devices: []Device{}},
	{
		ID: 0x11f8, Name: "PMC-Sierra Inc.", Devices: []Device{
			{ID: 0x5220, Name: "BR522x [PMC-Sierra maxRAID SAS Controller]"},
			{ID: 0x7364, Name: "PM7364 [FREEDM - 32 Frame Engine & Datalink Mgr]"},
			{ID: 0x7375, Name: "PM7375 [LASAR-155 ATM SAR]"},
			{ID: 0x7384, Name: "PM7384 [FREEDM - 84P672 Frm Engine & Datalink Mgr]"},
			{ID: 0x8000, Name: "PM8000  [SPC - SAS Protocol Controller]"},
			{ID: 0x8009, Name: "PM8009 SPCve 8x6G"},
			{ID: 0x8018, Name: "PM8018 Adaptec SAS Adaptor ASA-70165H PCIe Gen3 x8 6 Gbps 16-lane 4x SFF-8644"},
			{ID: 0x8032, Name: "PM8032 Tachyon QE8"},
			{ID: 0x8053, Name: "PM8053 SXP 12G 24-port SAS/SATA expander"},
			{ID: 0x8054, Name: "PM8054 SXP 12G 36-port SAS/SATA expander"},
			{ID: 0x8055, Name: "PM8055 SXP 12G 48-port SAS/SATA expander"},
			{ID: 0x8056, Name: "PM8056 SXP 12G 68-port SAS/SATA expander"},
			{ID: 0x8060, Name: "PM8060 SRCv 12G eight-port SAS/SATA RoC"},
			{ID: 0x8063, Name: "PM8063 SRCv 12G 16-port SAS/SATA RoC"},
			{ID: 0x8070, Name: "PM8070 Tachyon SPCv 12G eight-port SAS/SATA controller"},
			{ID: 0x8071, Name: "PM8071 Tachyon SPCve 12G eight-port SAS/SATA controller"},
			{ID: 0x8072, Name: "PM8072 Tachyon SPCv 12G 16-port SAS/SATA controller"},
			{ID: 0x8073, Name: "PM8073 Tachyon SPCve 12G 16-port SAS/SATA controller"},
			{ID: 0x8531, Name: "PM8531 PFX 24xG3 PCIe Fanout Switch"},
			{ID: 0x8532, Name: "PM8532 PFX 32xG3 PCIe Fanout Switch"},
			{ID: 0x8533, Name: "PM8533 PFX 48xG3 PCIe Fanout Switch"},
			{ID: 0x8534, Name: "PM8534 PFX 64xG3 PCIe Fanout Switch"},
			{ID: 0x8535, Name: "PM8535 PFX 80xG3 PCIe Fanout Switch"},
			{ID: 0x8536, Name: "PM8536 PFX 96xG3 PCIe Fanout Switch"},
			{ID: 0x8546, Name: "PM8546 B-FEIP PSX 96xG3 PCIe Storage Switch"},
			{ID: 0x8562, Name: "PM8562 Switchtec PFX-L 32xG3 Fanout-Lite PCIe Gen3 Switch"},
		},
	},
	{ID: 0x11f9, Name: "I-Cube Inc", Devices: []Device{}},
	{ID: 0x11fa, Name: "Kasan Electronics Company, Ltd.", Devices: []Device{}},
	{ID: 0x11fb, Name: "Datel Inc", Devices: []Device{}},
	{ID: 0x11fc, Name: "Silicon Magic", Devices: []Device{}},
	{ID: 0x11fd, Name: "High Street Consultants", Devices: []Device{}},
	{
		ID: 0x11fe, Name: "Pepperl+Fuchs", Devices: []Device{
			{ID: 0x0001, Name: "RocketPort PCI 32-port w/external I/F"},
			{ID: 0x0002, Name: "RocketPort PCI 8-port w/external I/F"},
			{ID: 0x0003, Name: "RocketPort PCI 16-port w/external I/F"},
			{ID: 0x0004, Name: "RocketPort PCI 4-port w/Quad Cable"},
			{ID: 0x0005, Name: "RocketPort PCI 8-port w/Octa Cable"},
			{ID: 0x0006, Name: "RocketPort PCI 8-port w/RJ11 connectors"},
			{ID: 0x0007, Name: "RocketPort PCI 4-port w/RJ45 connectors"},
			{ID: 0x0008, Name: "RocketPort PCI 8-port w/DB78 SNI connector (Siemens)"},
			{ID: 0x0009, Name: "RocketPort PCI 16-port w/DB78 SNI connector (Siemens)"},
			{ID: 0x000a, Name: "RocketPort PCI Plus 4-port w/Quad Cable"},
			{ID: 0x000b, Name: "RocketPort PCI Plus 8-port w/Octa Cable"},
			{ID: 0x000c, Name: "RocketModem II 6-port"},
			{ID: 0x000d, Name: "RocketModem 4-port"},
			{ID: 0x000e, Name: "RocketPort PCI Plus 2-port RS-232 w/DB9 connectors"},
			{ID: 0x000f, Name: "RocketPort PCI Plus 2-port SMPTE w/DB9 connectors"},
			{ID: 0x0040, Name: "RocketPort INFINITY 8-port w/Octa Cable RJ45"},
			{ID: 0x0041, Name: "RocketPort INFINITY 32-port w/external I/F"},
			{ID: 0x0042, Name: "RocketPort INFINITY 8-port w/external I/F"},
			{ID: 0x0043, Name: "RocketPort INFINITY 16-port w/external I/F"},
			{ID: 0x0044, Name: "RocketPort INFINITY 4-port w/Quad Cable DB"},
			{ID: 0x0045, Name: "RocketPort INFINITY 8-port w/Octa Cable DB"},
			{ID: 0x0046, Name: "RocketPort INFINITY 4-port w/external I/F"},
			{ID: 0x0047, Name: "RocketPort INFINITY 4J (4-port) w/RJ45 connectors"},
			{ID: 0x0048, Name: "RocketPort INFINITY 4J (4-port) w/RJ45 connectors"},
			{ID: 0x004a, Name: "RocketPort INFINITY Plus 4-port"},
			{ID: 0x004b, Name: "RocketPort INFINITY Plus 8-port"},
			{ID: 0x004c, Name: "RocketModem INFINITY III 8-port"},
			{ID: 0x004d, Name: "RocketModem INFINITY III 4-port"},
			{ID: 0x004e, Name: "RocketPort INFINITY Plus 2-port"},
			{ID: 0x004f, Name: "RocketPort INFINITY 2-port SMPTE w/DB9 connectors"},
			{ID: 0x0050, Name: "RocketPort INFINITY Plus 4-port RJ45"},
			{ID: 0x0051, Name: "RocketPort INFINITY Plus 8-port RJ11"},
			{ID: 0x0052, Name: "RocketPort INFINITY 8-port SMPTE w/DB9 Connectors"},
			{ID: 0x0060, Name: "RocketPort EXPRESS 8-port w/Octa Cable"},
			{ID: 0x0061, Name: "RocketPort EXPRESS 32-port w/external I/F"},
			{ID: 0x0062, Name: "RocketPort EXPRESS 8-Port w/external I/F"},
			{ID: 0x0063, Name: "RocketPort EXPRESS 16-port w/external I/F"},
			{ID: 0x0064, Name: "RocketPort EXPRESS 4-port w/Quad Cable"},
			{ID: 0x0065, Name: "RocketPort EXPRESS 8-port w/Octa Cable"},
			{ID: 0x0066, Name: "RocketPort EXPRESS 4-port w/external I/F"},
			{ID: 0x0067, Name: "RocketPort EXPRESS 4J (4-port) w/RJ45 connectors"},
			{ID: 0x0068, Name: "RocketPort EXPRESS 8J (8-port) w/RJ11 connectors"},
			{ID: 0x006f, Name: "RocketPort EXPRESS SMPTE 2-port"},
			{ID: 0x0072, Name: "RocketPort EXPRESS SMPTE 8-port w/external I/F"},
			{ID: 0x0801, Name: "RocketPort uPCI 32-port w/external I/F"},
			{ID: 0x0802, Name: "RocketPort uPCI 8-port w/external I/F"},
			{ID: 0x0803, Name: "RocketPort uPCI 16-port w/external I/F"},
			{ID: 0x0805, Name: "RocketPort uPCI 8-port w/Octa Cable"},
			{ID: 0x080b, Name: "RocketPort Plus uPCI 8-port w/Octa Cable"},
			{ID: 0x080c, Name: "RocketModem III 8-port"},
			{ID: 0x080d, Name: "RocketModem III 4-port"},
			{ID: 0x080e, Name: "RocketPort uPCI 2-port RS232 w/DB9 connectors"},
			{ID: 0x080f, Name: "RocketPort uPCI SMPTE 2-port"},
			{ID: 0x0810, Name: "RocketPort Plus uPCI 4J (4-port) w/RJ45 connectors"},
			{ID: 0x0811, Name: "RocketPort Plus uPCI 8J (8-port) w/RJ11 connectors"},
			{ID: 0x0812, Name: "RocketPort Plus uPCI 422 8-port"},
			{ID: 0x0813, Name: "RocketModem IV uPCI 8-port"},
			{ID: 0x0814, Name: "RocketModem IV uPCI 4-port"},
			{ID: 0x0903, Name: "RocketPort Compact PCI 16 port w/external I/F"},
			{ID: 0x8015, Name: "RocketPort 550 4-port"},
			{ID: 0x8805, Name: "RocketPort uPCI 4-port w/Quad Cable"},
			{ID: 0x880b, Name: "RocketPort Plus uPCI 4-port w/Quad Cable"},
			{ID: 0x8812, Name: "RocketPort Plus uPCI 4-port RS422 w/Quad Cable"},
		},
	},
	{
		ID: 0x11ff, Name: "Scion Corporation", Devices: []Device{
			{ID: 0x0003, Name: "AG-5"},
		},
	},
	{ID: 0x1200, Name: "CSS Corporation", Devices: []Device{}},
	{ID: 0x1201, Name: "Vista Controls Corp", Devices: []Device{}},
	{
		ID: 0x1202, Name: "Network General Corp.", Devices: []Device{
			{ID: 0x4300, Name: "Gigabit Ethernet Adapter"},
		},
	},
	{ID: 0x1203, Name: "Bayer Corporation, Agfa Division", Devices: []Device{}},
	{
		ID: 0x1204, Name: "Lattice Semiconductor Corporation", Devices: []Device{
			{ID: 0x1965, Name: "SB6501 802.11ad Wireless Network Adapter"},
		},
	},
	{ID: 0x1205, Name: "Array Corporation", Devices: []Device{}},
	{ID: 0x1206, Name: "Amdahl Corporation", Devices: []Device{}},
	{
		ID: 0x1208, Name: "Parsytec GmbH", Devices: []Device{
			{ID: 0x4853, Name: "HS-Link Device"},
		},
	},
	{ID: 0x1209, Name: "SCI Systems Inc", Devices: []Device{}},
	{ID: 0x120a, Name: "Synaptel", Devices: []Device{}},
	{ID: 0x120b, Name: "Adaptive Solutions", Devices: []Device{}},
	{ID: 0x120c, Name: "Technical Corp.", Devices: []Device{}},
	{ID: 0x120d, Name: "Compression Labs, Inc.", Devices: []Device{}},
	{
		ID: 0x120e, Name: "Cyclades Corporation", Devices: []Device{
			{ID: 0x0100, Name: "Cyclom-Y below first megabyte"},
			{ID: 0x0101, Name: "Cyclom-Y above first megabyte"},
			{ID: 0x0102, Name: "Cyclom-4Y below first megabyte"},
			{ID: 0x0103, Name: "Cyclom-4Y above first megabyte"},
			{ID: 0x0104, Name: "Cyclom-8Y below first megabyte"},
			{ID: 0x0105, Name: "Cyclom-8Y above first megabyte"},
			{ID: 0x0200, Name: "Cyclades-Z below first megabyte"},
			{ID: 0x0201, Name: "Cyclades-Z above first megabyte"},
			{ID: 0x0300, Name: "PC300/RSV or /X21 (2 ports)"},
			{ID: 0x0301, Name: "PC300/RSV or /X21 (1 port)"},
			{ID: 0x0310, Name: "PC300/TE (2 ports)"},
			{ID: 0x0311, Name: "PC300/TE (1 port)"},
			{ID: 0x0320, Name: "PC300/TE-M (2 ports)"},
			{ID: 0x0321, Name: "PC300/TE-M (1 port)"},
			{ID: 0x0400, Name: "PC400"},
		},
	},
	{
		ID: 0x120f, Name: "Essential Communications", Devices: []Device{
			{ID: 0x0001, Name: "Roadrunner serial HIPPI"},
		},
	},
	{ID: 0x1210, Name: "Hyperparallel Technologies", Devices: []Device{}},
	{ID: 0x1211, Name: "Braintech Inc", Devices: []Device{}},
	{ID: 0x1213, Name: "Applied Intelligent Systems, Inc.", Devices: []Device{}},
	{ID: 0x1214, Name: "Performance Technologies, Inc.", Devices: []Device{}},
	{ID: 0x1215, Name: "Interware Co., Ltd", Devices: []Device{}},
	{ID: 0x1216, Name: "Purup Prepress A/S", Devices: []Device{}},
	{
		ID: 0x1217, Name: "O2 Micro, Inc.", Devices: []Device{
			{ID: 0x00f7, Name: "Firewire (IEEE 1394)"},
			{ID: 0x10f7, Name: "1394 OHCI Compliant Host Controller"},
			{ID: 0x11f7, Name: "OZ600 1394a-2000 Controller"},
			{ID: 0x13f7, Name: "1394 OHCI Compliant Host Controller"},
			{ID: 0x6729, Name: "OZ6729"},
			{ID: 0x673a, Name: "OZ6730"},
			{ID: 0x6832, Name: "OZ6832/6833 CardBus Controller"},
			{ID: 0x6836, Name: "OZ6836/6860 CardBus Controller"},
			{ID: 0x6872, Name: "OZ6812 CardBus Controller"},
			{ID: 0x6925, Name: "OZ6922 CardBus Controller"},
			{ID: 0x6933, Name: "OZ6933/711E1 CardBus/SmartCardBus Controller"},
			{ID: 0x6972, Name: "OZ601/6912/711E0 CardBus/SmartCardBus Controller"},
			{ID: 0x7110, Name: "OZ711Mx 4-in-1 MemoryCardBus Accelerator"},
			{ID: 0x7112, Name: "OZ711EC1/M1 SmartCardBus/MemoryCardBus Controller"},
			{ID: 0x7113, Name: "OZ711EC1 SmartCardBus Controller"},
			{ID: 0x7114, Name: "OZ711M1/MC1 4-in-1 MemoryCardBus Controller"},
			{ID: 0x7120, Name: "Integrated MMC/SD Controller"},
			{ID: 0x7130, Name: "Integrated MS/xD Controller"},
			{ID: 0x7134, Name: "OZ711MP1/MS1 MemoryCardBus Controller"},
			{ID: 0x7135, Name: "Cardbus bridge"},
			{ID: 0x7136, Name: "OZ711SP1 Memory CardBus Controller"},
			{ID: 0x71e2, Name: "OZ711E2 SmartCardBus Controller"},
			{ID: 0x7212, Name: "OZ711M2 4-in-1 MemoryCardBus Controller"},
			{ID: 0x7213, Name: "OZ6933E CardBus Controller"},
			{ID: 0x7223, Name: "OZ711M3/MC3 4-in-1 MemoryCardBus Controller"},
			{ID: 0x7233, Name: "OZ711MP3/MS3 4-in-1 MemoryCardBus Controller"},
			{ID: 0x8120, Name: "Integrated MMC/SD Controller"},
			{ID: 0x8130, Name: "Integrated MS/MSPRO/xD Controller"},
			{ID: 0x8220, Name: "OZ600FJ1/OZ900FJ1 SD/MMC Card Reader Controller"},
			{ID: 0x8221, Name: "OZ600FJ0/OZ900FJ0/OZ600FJS SD/MMC Card Reader Controller"},
			{ID: 0x8320, Name: "OZ600RJ1/OZ900RJ1 SD/MMC Card Reader Controller"},
			{ID: 0x8321, Name: "OZ600RJ0/OZ900RJ0/OZ600RJS SD/MMC Card Reader Controller"},
			{ID: 0x8330, Name: "OZ600 MS/xD Controller"},
			{ID: 0x8331, Name: "O2 Flash Memory Card"},
			{ID: 0x8520, Name: "SD/MMC Card Reader Controller"},
			{ID: 0x8621, Name: "SD/MMC Card Reader Controller"},
		},
	},
	{ID: 0x1218, Name: "Hybricon Corp.", Devices: []Device{}},
	{ID: 0x1219, Name: "First Virtual Corporation", Devices: []Device{}},
	{
		ID: 0x121a, Name: "3Dfx Interactive, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Voodoo"},
			{ID: 0x0002, Name: "Voodoo 2"},
			{ID: 0x0003, Name: "Voodoo Banshee"},
			{ID: 0x0004, Name: "Voodoo Banshee [Velocity 100]"},
			{ID: 0x0005, Name: "Voodoo 3"},
			{ID: 0x0009, Name: "Voodoo 4 / Voodoo 5"},
			{ID: 0x0057, Name: "Voodoo 3/3000 [Avenger]"},
		},
	},
	{ID: 0x121b, Name: "Advanced Telecommunications Modules", Devices: []Device{}},
	{ID: 0x121c, Name: "Nippon Texaco., Ltd", Devices: []Device{}},
	{ID: 0x121d, Name: "LiPPERT ADLINK Technology GmbH", Devices: []Device{}},
	{
		ID: 0x121e, Name: "CSPI", Devices: []Device{
			{ID: 0x0201, Name: "Myrinet 2000 Scalable Cluster Interconnect"},
		},
	},
	{ID: 0x121f, Name: "Arcus Technology, Inc.", Devices: []Device{}},
	{
		ID: 0x1220, Name: "Ariel Corporation", Devices: []Device{
			{ID: 0x1220, Name: "AMCC 5933 TMS320C80 DSP/Imaging board"},
		},
	},
	{
		ID: 0x1221, Name: "Contec Co., Ltd", Devices: []Device{
			{ID: 0x9172, Name: "PO-64L(PCI)H [Isolated Digital Output Board for PCI]"},
			{ID: 0x91a2, Name: "PO-32L(PCI)H [Isolated Digital Output Board for PCI]"},
			{ID: 0x91c3, Name: "DA16-16(LPCI)L [Un-insulated highly precise analog output board for Low Profile PCI]"},
			{ID: 0xb152, Name: "DIO-96D2-LPCI"},
			{ID: 0xc103, Name: "ADA16-32/2(PCI)F [High-Speed Analog I/O Board for PCI]"},
		},
	},
	{ID: 0x1222, Name: "Ancor Communications, Inc.", Devices: []Device{}},
	{
		ID: 0x1223, Name: "Artesyn Communication Products", Devices: []Device{
			{ID: 0x0003, Name: "PM/Link"},
			{ID: 0x0004, Name: "PM/T1"},
			{ID: 0x0005, Name: "PM/E1"},
			{ID: 0x0008, Name: "PM/SLS"},
			{ID: 0x0009, Name: "BajaSpan Resource Target"},
			{ID: 0x000a, Name: "BajaSpan Section 0"},
			{ID: 0x000b, Name: "BajaSpan Section 1"},
			{ID: 0x000c, Name: "BajaSpan Section 2"},
			{ID: 0x000d, Name: "BajaSpan Section 3"},
			{ID: 0x000e, Name: "PM/PPC"},
		},
	},
	{ID: 0x1224, Name: "Interactive Images", Devices: []Device{}},
	{ID: 0x1225, Name: "Power I/O, Inc.", Devices: []Device{}},
	{
		ID: 0x1227, Name: "EIZO Rugged Solutions", Devices: []Device{
			{ID: 0x0006, Name: "Raptor GFX 8P"},
			{ID: 0x0023, Name: "Raptor GFX [1100T]"},
			{ID: 0x0045, Name: "Raptor 4000-L [Linux version]"},
			{ID: 0x004a, Name: "Raptor 4000-LR-L [Linux version]"},
		},
	},
	{ID: 0x1228, Name: "Norsk Elektro Optikk A/S", Devices: []Device{}},
	{ID: 0x1229, Name: "Data Kinesis Inc.", Devices: []Device{}},
	{ID: 0x122a, Name: "Integrated Telecom", Devices: []Device{}},
	{ID: 0x122b, Name: "LG Industrial Systems Co., Ltd", Devices: []Device{}},
	{ID: 0x122c, Name: "Sican GmbH", Devices: []Device{}},
	{
		ID: 0x122d, Name: "Aztech System Ltd", Devices: []Device{
			{ID: 0x1206, Name: "368DSP"},
			{ID: 0x1400, Name: "Trident PCI288-Q3DII (NX)"},
			{ID: 0x50dc, Name: "3328 Audio"},
			{ID: 0x80da, Name: "3328 Audio"},
		},
	},
	{
		ID: 0x122e, Name: "Xyratex", Devices: []Device{
			{ID: 0x7722, Name: "Napatech XL1"},
			{ID: 0x7724, Name: "Napatech XL2/XA"},
			{ID: 0x7729, Name: "Napatech XD"},
		},
	},
	{ID: 0x122f, Name: "Andrew Corporation", Devices: []Device{}},
	{ID: 0x1230, Name: "Fishcamp Engineering", Devices: []Device{}},
	{
		ID: 0x1231, Name: "Woodward McCoach, Inc.", Devices: []Device{
			{ID: 0x04e1, Name: "Desktop PCI Telephony 4"},
			{ID: 0x05e1, Name: "Desktop PCI Telephony 5/6"},
			{ID: 0x0d00, Name: "LightParser"},
			{ID: 0x0d02, Name: "LightParser 2"},
			{ID: 0x0d13, Name: "Desktop PCI L1/L3 Telephony"},
		},
	},
	{ID: 0x1232, Name: "GPT Limited", Devices: []Device{}},
	{ID: 0x1233, Name: "Bus-Tech, Inc.", Devices: []Device{}},
	{ID: 0x1235, Name: "SMART Modular Technologies", Devices: []Device{}},
	{
		ID: 0x1236, Name: "Sigma Designs Corporation", Devices: []Device{
			{ID: 0x0000, Name: "RealMagic64/GX"},
			{ID: 0x6401, Name: "REALmagic 64/GX (SD 6425)"},
		},
	},
	{ID: 0x1237, Name: "Alta Technology Corporation", Devices: []Device{}},
	{ID: 0x1238, Name: "Adtran", Devices: []Device{}},
	{ID: 0x1239, Name: "3DO Company", Devices: []Device{}},
	{ID: 0x123a, Name: "Visicom Laboratories, Inc.", Devices: []Device{}},
	{ID: 0x123b, Name: "Seeq Technology, Inc.", Devices: []Device{}},
	{ID: 0x123c, Name: "Century Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x123d, Name: "Engineering Design Team, Inc.", Devices: []Device{
			{ID: 0x0000, Name: "EasyConnect 8/32"},
			{ID: 0x0002, Name: "EasyConnect 8/64"},
			{ID: 0x0003, Name: "EasyIO"},
		},
	},
	{ID: 0x123e, Name: "Simutech, Inc.", Devices: []Device{}},
	{
		ID: 0x123f, Name: "LSI Logic", Devices: []Device{
			{ID: 0x00e4, Name: "MPEG"},
			{ID: 0x8120, Name: "DVxplore Codec"},
			{ID: 0x8888, Name: "Cinemaster C 3.0 DVD Decoder"},
		},
	},
	{ID: 0x1240, Name: "Marathon Technologies Corp.", Devices: []Device{}},
	{ID: 0x1241, Name: "DSC Communications", Devices: []Device{}},
	{
		ID: 0x1242, Name: "JNI Corporation", Devices: []Device{
			{ID: 0x1560, Name: "JNIC-1560 PCI-X Fibre Channel Controller"},
			{ID: 0x4643, Name: "FCI-1063 Fibre Channel Adapter"},
			{ID: 0x6562, Name: "FCX2-6562 Dual Channel PCI-X Fibre Channel Adapter"},
			{ID: 0x656a, Name: "FCX-6562 PCI-X Fibre Channel Adapter"},
		},
	},
	{ID: 0x1243, Name: "Delphax", Devices: []Device{}},
	{
		ID: 0x1244, Name: "AVM GmbH", Devices: []Device{
			{ID: 0x0700, Name: "B1 ISDN"},
			{ID: 0x0800, Name: "C4 ISDN"},
			{ID: 0x0a00, Name: "A1 ISDN [Fritz]"},
			{ID: 0x0e00, Name: "Fritz!Card PCI v2.0 ISDN"},
			{ID: 0x0e80, Name: "Fritz!Card PCI v2.1 ISDN"},
			{ID: 0x1100, Name: "C2 ISDN"},
			{ID: 0x1200, Name: "T1 ISDN"},
			{ID: 0x2700, Name: "Fritz!Card DSL SL"},
			{ID: 0x2900, Name: "Fritz!Card DSL v2.0"},
		},
	},
	{ID: 0x1245, Name: "A.P.D., S.A.", Devices: []Device{}},
	{ID: 0x1246, Name: "Dipix Technologies, Inc.", Devices: []Device{}},
	{ID: 0x1247, Name: "Xylon Research, Inc.", Devices: []Device{}},
	{ID: 0x1248, Name: "Central Data Corporation", Devices: []Device{}},
	{ID: 0x1249, Name: "Samsung Electronics Co., Ltd.", Devices: []Device{}},
	{ID: 0x124a, Name: "AEG Electrocom GmbH", Devices: []Device{}},
	{
		ID: 0x124b, Name: "SBS/Greenspring Modular I/O", Devices: []Device{
			{ID: 0x0040, Name: "PCI-40A or cPCI-200 Quad IndustryPack carrier"},
		},
	},
	{ID: 0x124c, Name: "Solitron Technologies, Inc.", Devices: []Device{}},
	{
		ID: 0x124d, Name: "Stallion Technologies, Inc.", Devices: []Device{
			{ID: 0x0000, Name: "EasyConnection 8/32"},
			{ID: 0x0002, Name: "EasyConnection 8/64"},
			{ID: 0x0003, Name: "EasyIO"},
			{ID: 0x0004, Name: "EasyConnection/RA"},
		},
	},
	{ID: 0x124e, Name: "Cylink", Devices: []Device{}},
	{
		ID: 0x124f, Name: "Infortrend Technology, Inc.", Devices: []Device{
			{ID: 0x0041, Name: "IFT-2000 Series RAID Controller"},
		},
	},
	{ID: 0x1250, Name: "Hitachi Microcomputer System Ltd", Devices: []Device{}},
	{ID: 0x1251, Name: "VLSI Solutions Oy", Devices: []Device{}},
	{ID: 0x1253, Name: "Guzik Technical Enterprises", Devices: []Device{}},
	{
		ID: 0x1254, Name: "Linear Systems Ltd.", Devices: []Device{
			{ID: 0x0065, Name: "DVB Master FD"},
			{ID: 0x007c, Name: "DVB Master Quad/o"},
		},
	},
	{
		ID: 0x1255, Name: "Optibase Ltd", Devices: []Device{
			{ID: 0x1110, Name: "MPEG Forge"},
			{ID: 0x1210, Name: "MPEG Fusion"},
			{ID: 0x2110, Name: "VideoPlex"},
			{ID: 0x2120, Name: "VideoPlex CC"},
			{ID: 0x2130, Name: "VideoQuest"},
		},
	},
	{
		ID: 0x1256, Name: "Perceptive Solutions, Inc.", Devices: []Device{
			{ID: 0x4201, Name: "PCI-2220I"},
			{ID: 0x4401, Name: "PCI-2240I"},
			{ID: 0x5201, Name: "PCI-2000"},
		},
	},
	{ID: 0x1257, Name: "Vertex Networks, Inc.", Devices: []Device{}},
	{ID: 0x1258, Name: "Gilbarco, Inc.", Devices: []Device{}},
	{
		ID: 0x1259, Name: "Allied Telesis", Devices: []Device{
			{ID: 0x2560, Name: "AT-2560 Fast Ethernet Adapter (i82557B)"},
			{ID: 0x2801, Name: "AT-2801FX (RTL-8139)"},
			{ID: 0xa117, Name: "RTL81xx Fast Ethernet"},
			{ID: 0xa11e, Name: "RTL81xx Fast Ethernet"},
			{ID: 0xa120, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
		},
	},
	{ID: 0x125a, Name: "ABB Power Systems", Devices: []Device{}},
	{
		ID: 0x125b, Name: "Asix Electronics Corporation", Devices: []Device{
			{ID: 0x1400, Name: "AX88141 Fast Ethernet Controller"},
			{ID: 0x9100, Name: "AX99100 PCIe to Multi I/O Controller"},
		},
	},
	{
		ID: 0x125c, Name: "Aurora Technologies, Inc.", Devices: []Device{
			{ID: 0x0101, Name: "Saturn 4520P"},
			{ID: 0x0640, Name: "Aries 16000P"},
		},
	},
	{
		ID: 0x125d, Name: "ESS Technology", Devices: []Device{
			{ID: 0x0000, Name: "ES336H Fax Modem (Early Model)"},
			{ID: 0x1948, Name: "ES1948 Maestro-1"},
			{ID: 0x1968, Name: "ES1968 Maestro 2"},
			{ID: 0x1969, Name: "ES1938/ES1946/ES1969 Solo-1 Audiodrive"},
			{ID: 0x1978, Name: "ES1978 Maestro 2E"},
			{ID: 0x1988, Name: "ES1988 Allegro-1"},
			{ID: 0x1989, Name: "ESS Modem"},
			{ID: 0x1998, Name: "ES1983S Maestro-3i PCI Audio Accelerator"},
			{ID: 0x1999, Name: "ES1983S Maestro-3i PCI Modem Accelerator"},
			{ID: 0x199a, Name: "ES1983S Maestro-3i PCI Audio Accelerator"},
			{ID: 0x199b, Name: "ES1983S Maestro-3i PCI Modem Accelerator"},
			{ID: 0x2808, Name: "ES336H Fax Modem (Later Model)"},
			{ID: 0x2838, Name: "ES2838/2839 SuperLink Modem"},
			{ID: 0x2898, Name: "ES2898 Modem"},
		},
	},
	{ID: 0x125e, Name: "Specialvideo Engineering SRL", Devices: []Device{}},
	{
		ID: 0x125f, Name: "Concurrent Technologies, Inc.", Devices: []Device{
			{ID: 0x2071, Name: "CC PMC/232"},
			{ID: 0x2084, Name: "CC PMC/23P"},
			{ID: 0x2091, Name: "CC PMC/422"},
		},
	},
	{
		ID: 0x1260, Name: "Intersil Corporation", Devices: []Device{
			{ID: 0x3872, Name: "ISL3872 [Prism 3]"},
			{ID: 0x3873, Name: "ISL3874 [Prism 2.5]/ISL3872 [Prism 3]"},
			{ID: 0x3877, Name: "ISL3877 [Prism Indigo]"},
			{ID: 0x3886, Name: "ISL3886 [Prism Javelin/Prism Xbow]"},
			{ID: 0x3890, Name: "ISL3890 [Prism GT/Prism Duette]/ISL3886 [Prism Javelin/Prism Xbow]"},
			{ID: 0x8130, Name: "HMP8130 NTSC/PAL Video Decoder"},
			{ID: 0x8131, Name: "HMP8131 NTSC/PAL Video Decoder"},
			{ID: 0xffff, Name: "ISL3886IK"},
		},
	},
	{ID: 0x1261, Name: "Matsushita-Kotobuki Electronics Industries, Ltd.", Devices: []Device{}},
	{ID: 0x1262, Name: "ES Computer Company, Ltd.", Devices: []Device{}},
	{ID: 0x1263, Name: "Sonic Solutions", Devices: []Device{}},
	{ID: 0x1264, Name: "Aval Nagasaki Corporation", Devices: []Device{}},
	{ID: 0x1265, Name: "Casio Computer Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1266, Name: "Microdyne Corporation", Devices: []Device{
			{ID: 0x0001, Name: "NE10/100 Adapter (i82557B)"},
			{ID: 0x1910, Name: "NE2000Plus (RT8029) Ethernet Adapter"},
		},
	},
	{
		ID: 0x1267, Name: "S. A. Telecommunications", Devices: []Device{
			{ID: 0x5352, Name: "PCR2101"},
			{ID: 0x5a4b, Name: "Telsat Turbo"},
		},
	},
	{ID: 0x1268, Name: "Tektronix", Devices: []Device{}},
	{
		ID: 0x1269, Name: "Thomson-CSF/TTM", Devices: []Device{
			{ID: 0x00b3, Name: "5G Data Card [Cinterion MV31-W]"},
		},
	},
	{ID: 0x126a, Name: "Lexmark International, Inc.", Devices: []Device{}},
	{ID: 0x126b, Name: "Adax, Inc.", Devices: []Device{}},
	{
		ID: 0x126c, Name: "Northern Telecom", Devices: []Device{
			{ID: 0x1211, Name: "10/100BaseTX [RTL81xx]"},
			{ID: 0x126c, Name: "802.11b Wireless Ethernet Adapter"},
		},
	},
	{ID: 0x126d, Name: "Splash Technology, Inc.", Devices: []Device{}},
	{ID: 0x126e, Name: "Sumitomo Metal Industries, Ltd.", Devices: []Device{}},
	{
		ID: 0x126f, Name: "Silicon Motion, Inc.", Devices: []Device{
			{ID: 0x0501, Name: "SM501 VoyagerGX Rev. AA"},
			{ID: 0x0510, Name: "SM501 VoyagerGX Rev. B"},
			{ID: 0x0710, Name: "SM710 LynxEM"},
			{ID: 0x0712, Name: "SM712 LynxEM+"},
			{ID: 0x0718, Name: "SM718 LynxSE+"},
			{ID: 0x0720, Name: "SM720 Lynx3DM"},
			{ID: 0x0730, Name: "SM731 Cougar3DR"},
			{ID: 0x0750, Name: "SM750"},
			{ID: 0x0810, Name: "SM810 LynxE"},
			{ID: 0x0811, Name: "SM811 LynxE"},
			{ID: 0x0820, Name: "SM820 Lynx3D"},
			{ID: 0x0910, Name: "SM910"},
			{ID: 0x2262, Name: "SM2262/SM2262EN SSD Controller"},
			{ID: 0x2263, Name: "SM2263EN/SM2263XT SSD Controller"},
		},
	},
	{ID: 0x1270, Name: "Olympus Optical Co., Ltd.", Devices: []Device{}},
	{ID: 0x1271, Name: "GW Instruments", Devices: []Device{}},
	{ID: 0x1272, Name: "Telematics International", Devices: []Device{}},
	{
		ID: 0x1273, Name: "Hughes Network Systems", Devices: []Device{
			{ID: 0x0002, Name: "DirecPC"},
		},
	},
	{
		ID: 0x1274, Name: "Ensoniq", Devices: []Device{
			{ID: 0x1171, Name: "ES1373 / Creative Labs CT5803 [AudioPCI]"},
			{ID: 0x1371, Name: "ES1371/ES1373 / Creative Labs CT2518"},
			{ID: 0x5000, Name: "ES1370 [AudioPCI]"},
			{ID: 0x5880, Name: "5880B / Creative Labs CT5880"},
			{ID: 0x8001, Name: "CT5880 [AudioPCI]"},
			{ID: 0x8002, Name: "5880A [AudioPCI]"},
		},
	},
	{ID: 0x1275, Name: "Network Appliance Corporation", Devices: []Device{}},
	{ID: 0x1276, Name: "Switched Network Technologies, Inc.", Devices: []Device{}},
	{ID: 0x1277, Name: "Comstream", Devices: []Device{}},
	{
		ID: 0x1278, Name: "Transtech Parallel Systems Ltd.", Devices: []Device{
			{ID: 0x0701, Name: "TPE3/TM3 PowerPC Node"},
			{ID: 0x0710, Name: "TPE5 PowerPC PCI board"},
			{ID: 0x1100, Name: "PMC-FPGA02"},
			{ID: 0x1101, Name: "TS-C43 card with 4 ADSP-TS101 processors"},
		},
	},
	{
		ID: 0x1279, Name: "Transmeta Corporation", Devices: []Device{
			{ID: 0x0060, Name: "TM8000 Northbridge"},
			{ID: 0x0061, Name: "TM8000 AGP bridge"},
			{ID: 0x0295, Name: "Northbridge"},
			{ID: 0x0395, Name: "LongRun Northbridge"},
			{ID: 0x0396, Name: "SDRAM controller"},
			{ID: 0x0397, Name: "BIOS scratchpad"},
		},
	},
	{
		ID: 0x127a, Name: "Rockwell International", Devices: []Device{
			{ID: 0x1002, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1003, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1004, Name: "HCF 56k Data/Fax/Voice Modem"},
			{ID: 0x1005, Name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x1022, Name: "HCF 56k Modem"},
			{ID: 0x1023, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1024, Name: "HCF 56k Data/Fax/Voice Modem"},
			{ID: 0x1025, Name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x1026, Name: "HCF 56k PCI Speakerphone Modem"},
			{ID: 0x1032, Name: "HCF 56k Modem"},
			{ID: 0x1033, Name: "HCF 56k Modem"},
			{ID: 0x1034, Name: "HCF 56k Modem"},
			{ID: 0x1035, Name: "HCF 56k PCI Speakerphone Modem"},
			{ID: 0x1036, Name: "HCF 56k Modem"},
			{ID: 0x1085, Name: "HCF 56k Volcano PCI Modem"},
			{ID: 0x2004, Name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x2005, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x2013, Name: "HSF 56k Data/Fax Modem"},
			{ID: 0x2014, Name: "HSF 56k Data/Fax/Voice Modem"},
			{ID: 0x2015, Name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x2016, Name: "HSF 56k Data/Fax/Voice/Spkp Modem"},
			{ID: 0x4311, Name: "Riptide HSF 56k PCI Modem"},
			{ID: 0x4320, Name: "Riptide PCI Audio Controller"},
			{ID: 0x4321, Name: "Riptide HCF 56k PCI Modem"},
			{ID: 0x4322, Name: "Riptide PCI Game Controller"},
			{ID: 0x8234, Name: "RapidFire 616X ATM155 Adapter"},
		},
	},
	{ID: 0x127b, Name: "Pixera Corporation", Devices: []Device{}},
	{ID: 0x127c, Name: "Crosspoint Solutions, Inc.", Devices: []Device{}},
	{ID: 0x127d, Name: "Vela Research", Devices: []Device{}},
	{
		ID: 0x127e, Name: "Winnov, L.P.", Devices: []Device{
			{ID: 0x0010, Name: "Videum 1000 Plus"},
		},
	},
	{ID: 0x127f, Name: "Fujifilm", Devices: []Device{}},
	{ID: 0x1280, Name: "Photoscript Group Ltd.", Devices: []Device{}},
	{ID: 0x1281, Name: "Yokogawa Electric Corporation", Devices: []Device{}},
	{
		ID: 0x1282, Name: "Davicom Semiconductor, Inc.", Devices: []Device{
			{ID: 0x6585, Name: "DM562P V90 Modem"},
			{ID: 0x9009, Name: "DM9009 Ethernet Controller"},
			{ID: 0x9100, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
			{ID: 0x9102, Name: "DM9102 Fast Ethernet Controller"},
			{ID: 0x9132, Name: "Ethernet 100/10 MBit"},
		},
	},
	{
		ID: 0x1283, Name: "Integrated Technology Express, Inc.", Devices: []Device{
			{ID: 0x673a, Name: "IT8330G"},
			{ID: 0x8152, Name: "IT8152F/G Advanced RISC-to-PCI Companion Chip"},
			{ID: 0x8211, Name: "ITE 8211F Single Channel UDMA 133"},
			{ID: 0x8212, Name: "IT8212 Dual channel ATA RAID controller"},
			{ID: 0x8213, Name: "IT8213 IDE Controller"},
			{ID: 0x8330, Name: "IT8330G"},
			{ID: 0x8872, Name: "IT887xF PCI to ISA I/O chip with SMB, GPIO, Serial or Parallel Port"},
			{ID: 0x8888, Name: "IT8888F/G PCI to ISA Bridge with SMB [Golden Gate]"},
			{ID: 0x8889, Name: "IT8889F PCI to ISA Bridge"},
			{ID: 0x8892, Name: "IT8892E PCIe to PCI Bridge"},
			{ID: 0x8893, Name: "IT8893E PCIe to PCI Bridge"},
			{ID: 0xe886, Name: "IT8330G"},
		},
	},
	{ID: 0x1284, Name: "Sahara Networks, Inc.", Devices: []Device{}},
	{
		ID: 0x1285, Name: "Platform Technologies, Inc.", Devices: []Device{
			{ID: 0x0100, Name: "AGOGO sound chip (aka ESS Maestro 1)"},
		},
	},
	{ID: 0x1286, Name: "Mazet GmbH", Devices: []Device{}},
	{
		ID: 0x1287, Name: "M-Pact, Inc.", Devices: []Device{
			{ID: 0x001e, Name: "LS220D DVD Decoder"},
			{ID: 0x001f, Name: "LS220C DVD Decoder"},
		},
	},
	{ID: 0x1288, Name: "Timestep Corporation", Devices: []Device{}},
	{ID: 0x1289, Name: "AVC Technology, Inc.", Devices: []Device{}},
	{ID: 0x128a, Name: "Asante Technologies, Inc.", Devices: []Device{}},
	{ID: 0x128b, Name: "Transwitch Corporation", Devices: []Device{}},
	{ID: 0x128c, Name: "Retix Corporation", Devices: []Device{}},
	{
		ID: 0x128d, Name: "G2 Networks, Inc.", Devices: []Device{
			{ID: 0x0021, Name: "ATM155 Adapter"},
		},
	},
	{
		ID: 0x128e, Name: "Hoontech Corporation/Samho Multi Tech Ltd.", Devices: []Device{
			{ID: 0x0008, Name: "ST128 WSS/SB"},
			{ID: 0x0009, Name: "ST128 SAM9407"},
			{ID: 0x000a, Name: "ST128 Game Port"},
			{ID: 0x000b, Name: "ST128 MPU Port"},
			{ID: 0x000c, Name: "ST128 Ctrl Port"},
		},
	},
	{ID: 0x128f, Name: "Tateno Dennou, Inc.", Devices: []Device{}},
	{ID: 0x1290, Name: "Sord Computer Corporation", Devices: []Device{}},
	{ID: 0x1291, Name: "NCS Computer Italia", Devices: []Device{}},
	{
		ID: 0x1292, Name: "Tritech Microelectronics Inc", Devices: []Device{
			{ID: 0xfc02, Name: "Pyramid3D TR25202"},
		},
	},
	{ID: 0x1293, Name: "Media Reality Technology", Devices: []Device{}},
	{ID: 0x1294, Name: "Rhetorex, Inc.", Devices: []Device{}},
	{
		ID: 0x1295, Name: "Imagenation Corporation", Devices: []Device{
			{ID: 0x0800, Name: "PXR800"},
			{ID: 0x1000, Name: "PXD1000"},
		},
	},
	{ID: 0x1296, Name: "Kofax Image Products", Devices: []Device{}},
	{ID: 0x1297, Name: "Holco Enterprise Co, Ltd/Shuttle Computer", Devices: []Device{}},
	{ID: 0x1298, Name: "Spellcaster Telecommunications Inc.", Devices: []Device{}},
	{ID: 0x1299, Name: "Knowledge Technology Lab.", Devices: []Device{}},
	{
		ID: 0x129a, Name: "VMetro, inc.", Devices: []Device{
			{ID: 0x0615, Name: "PBT-615 PCI-X Bus Analyzer"},
			{ID: 0x1100, Name: "PMC-FPGA05"},
			{ID: 0x1106, Name: "XMC-FPGA05F, PCI interface"},
			{ID: 0x1107, Name: "XMC-FPGA05F, PCIe interface"},
			{ID: 0x1108, Name: "XMC-FPGA05D, PCI interface"},
			{ID: 0x1109, Name: "XMC-FPGA05D, PCIe interface"},
		},
	},
	{ID: 0x129b, Name: "Image Access", Devices: []Device{}},
	{ID: 0x129c, Name: "Jaycor", Devices: []Device{}},
	{ID: 0x129d, Name: "Compcore Multimedia, Inc.", Devices: []Device{}},
	{ID: 0x129e, Name: "Victor Company of Japan, Ltd.", Devices: []Device{}},
	{ID: 0x129f, Name: "OEC Medical Systems, Inc.", Devices: []Device{}},
	{ID: 0x12a0, Name: "Allen-Bradley Company", Devices: []Device{}},
	{ID: 0x12a1, Name: "Simpact Associates, Inc.", Devices: []Device{}},
	{ID: 0x12a2, Name: "Newgen Systems Corporation", Devices: []Device{}},
	{
		ID: 0x12a3, Name: "Lucent Technologies", Devices: []Device{
			{ID: 0x8105, Name: "T8105 H100 Digital Switch"},
		},
	},
	{ID: 0x12a4, Name: "NTT Electronics Corporation", Devices: []Device{}},
	{ID: 0x12a5, Name: "Vision Dynamics Ltd.", Devices: []Device{}},
	{ID: 0x12a6, Name: "Scalable Networks, Inc.", Devices: []Device{}},
	{ID: 0x12a7, Name: "AMO GmbH", Devices: []Device{}},
	{ID: 0x12a8, Name: "News Datacom", Devices: []Device{}},
	{ID: 0x12a9, Name: "Xiotech Corporation", Devices: []Device{}},
	{ID: 0x12aa, Name: "SDL Communications, Inc.", Devices: []Device{}},
	{
		ID: 0x12ab, Name: "YUAN High-Tech Development Co., Ltd.", Devices: []Device{
			{ID: 0x0000, Name: "MPG160/Kuroutoshikou ITVC15-STVLP"},
			{ID: 0x0002, Name: "AU8830 [Vortex2] Based Sound Card With A3D Support"},
			{ID: 0x0003, Name: "T507 (DVB-T) TV tuner/capture device"},
			{ID: 0x2300, Name: "Club-3D Zap TV2100"},
			{ID: 0x3000, Name: "MPG-200C PCI DVD Decoder Card"},
			{ID: 0x4789, Name: "MPC788 MiniPCI Hybrid TV Tuner"},
			{ID: 0xfff3, Name: "MPG600/Kuroutoshikou ITVC16-STVLP"},
			{ID: 0xffff, Name: "MPG600/Kuroutoshikou ITVC16-STVLP"},
		},
	},
	{ID: 0x12ac, Name: "Measurex Corporation", Devices: []Device{}},
	{ID: 0x12ad, Name: "Multidata GmbH", Devices: []Device{}},
	{
		ID: 0x12ae, Name: "Alteon Networks Inc.", Devices: []Device{
			{ID: 0x0001, Name: "AceNIC Gigabit Ethernet"},
			{ID: 0x0002, Name: "AceNIC Gigabit Ethernet (Copper)"},
			{ID: 0x00fa, Name: "Farallon PN9100-T Gigabit Ethernet"},
		},
	},
	{ID: 0x12af, Name: "TDK USA Corp", Devices: []Device{}},
	{ID: 0x12b0, Name: "Jorge Scientific Corp", Devices: []Device{}},
	{ID: 0x12b1, Name: "GammaLink", Devices: []Device{}},
	{ID: 0x12b2, Name: "General Signal Networks", Devices: []Device{}},
	{ID: 0x12b3, Name: "Inter-Face Co Ltd", Devices: []Device{}},
	{ID: 0x12b4, Name: "FutureTel Inc", Devices: []Device{}},
	{ID: 0x12b5, Name: "Granite Systems Inc.", Devices: []Device{}},
	{ID: 0x12b6, Name: "Natural Microsystems", Devices: []Device{}},
	{ID: 0x12b7, Name: "Cognex Corporation", Devices: []Device{}},
	{ID: 0x12b8, Name: "Korg", Devices: []Device{}},
	{
		ID: 0x12b9, Name: "3Com Corp, Modem Division", Devices: []Device{
			{ID: 0x1006, Name: "WinModem"},
			{ID: 0x1007, Name: "USR 56k Internal WinModem"},
			{ID: 0x1008, Name: "56K FaxModem Model 5610"},
		},
	},
	{ID: 0x12ba, Name: "BittWare, Inc.", Devices: []Device{}},
	{ID: 0x12bb, Name: "Nippon Unisoft Corporation", Devices: []Device{}},
	{ID: 0x12bc, Name: "Array Microsystems", Devices: []Device{}},
	{ID: 0x12bd, Name: "Computerm Corp.", Devices: []Device{}},
	{
		ID: 0x12be, Name: "Anchor Chips Inc.", Devices: []Device{
			{ID: 0x3041, Name: "AN3041Q CO-MEM"},
			{ID: 0x3042, Name: "AN3042Q CO-MEM Lite"},
		},
	},
	{ID: 0x12bf, Name: "Fujifilm Microdevices", Devices: []Device{}},
	{ID: 0x12c0, Name: "Infimed", Devices: []Device{}},
	{ID: 0x12c1, Name: "GMM Research Corp", Devices: []Device{}},
	{ID: 0x12c2, Name: "Mentec Limited", Devices: []Device{}},
	{
		ID: 0x12c3, Name: "Holtek Microelectronics Inc", Devices: []Device{
			{ID: 0x0058, Name: "PCI NE2K Ethernet"},
			{ID: 0x5598, Name: "PCI NE2K Ethernet"},
		},
	},
	{
		ID: 0x12c4, Name: "Connect Tech Inc", Devices: []Device{
			{ID: 0x0001, Name: "Blue HEAT/PCI 8 (RS232/CL/RJ11)"},
			{ID: 0x0002, Name: "Blue HEAT/PCI 4 (RS232)"},
			{ID: 0x0003, Name: "Blue HEAT/PCI 2 (RS232)"},
			{ID: 0x0004, Name: "Blue HEAT/PCI 8 (UNIV, RS485)"},
			{ID: 0x0005, Name: "Blue HEAT/PCI 4+4/6+2 (UNIV, RS232/485)"},
			{ID: 0x0006, Name: "Blue HEAT/PCI 4 (OPTO, RS485)"},
			{ID: 0x0007, Name: "Blue HEAT/PCI 2+2 (RS232/485)"},
			{ID: 0x0008, Name: "Blue HEAT/PCI 2 (OPTO, Tx, RS485)"},
			{ID: 0x0009, Name: "Blue HEAT/PCI 2+6 (RS232/485)"},
			{ID: 0x000a, Name: "Blue HEAT/PCI 8 (Tx, RS485)"},
			{ID: 0x000b, Name: "Blue HEAT/PCI 4 (Tx, RS485)"},
			{ID: 0x000c, Name: "Blue HEAT/PCI 2 (20 MHz, RS485)"},
			{ID: 0x000d, Name: "Blue HEAT/PCI 2 PTM"},
			{ID: 0x0100, Name: "NT960/PCI"},
			{ID: 0x0201, Name: "cPCI Titan - 2 Port"},
			{ID: 0x0202, Name: "cPCI Titan - 4 Port"},
			{ID: 0x0300, Name: "CTI PCI UART 2 (RS232)"},
			{ID: 0x0301, Name: "CTI PCI UART 4 (RS232)"},
			{ID: 0x0302, Name: "CTI PCI UART 8 (RS232)"},
			{ID: 0x0310, Name: "CTI PCI UART 1+1 (RS232/485)"},
			{ID: 0x0311, Name: "CTI PCI UART 2+2 (RS232/485)"},
			{ID: 0x0312, Name: "CTI PCI UART 4+4 (RS232/485)"},
			{ID: 0x0320, Name: "CTI PCI UART 2"},
			{ID: 0x0321, Name: "CTI PCI UART 4"},
			{ID: 0x0322, Name: "CTI PCI UART 8"},
			{ID: 0x0330, Name: "CTI PCI UART 2 (RS485)"},
			{ID: 0x0331, Name: "CTI PCI UART 4 (RS485)"},
			{ID: 0x0332, Name: "CTI PCI UART 8 (RS485)"},
		},
	},
	{
		ID: 0x12c5, Name: "Picture Elements Incorporated", Devices: []Device{
			{ID: 0x007e, Name: "Imaging/Scanning Subsystem Engine"},
			{ID: 0x007f, Name: "Imaging/Scanning Subsystem Engine"},
			{ID: 0x0081, Name: "PCIVST [Grayscale Thresholding Engine]"},
			{ID: 0x0085, Name: "Video Simulator/Sender"},
			{ID: 0x0086, Name: "THR2 Multi-scale Thresholder"},
		},
	},
	{ID: 0x12c6, Name: "Mitani Corporation", Devices: []Device{}},
	{
		ID: 0x12c7, Name: "Dialogic Corp", Devices: []Device{
			{ID: 0x0546, Name: "Springware D/120JCT-LS"},
			{ID: 0x0647, Name: "Springware D/240JCT-T1"},
			{ID: 0x0676, Name: "Springware D/41JCT-LS"},
			{ID: 0x0685, Name: "Springware D/480JCT-2T1"},
		},
	},
	{ID: 0x12c8, Name: "G Force Co, Ltd", Devices: []Device{}},
	{ID: 0x12c9, Name: "Gigi Operations", Devices: []Device{}},
	{ID: 0x12ca, Name: "Integrated Computing Engines", Devices: []Device{}},
	{
		ID: 0x12cb, Name: "Antex Electronics Corporation", Devices: []Device{
			{ID: 0x0027, Name: "SC4 (StudioCard)"},
			{ID: 0x002e, Name: "StudioCard 2000"},
		},
	},
	{ID: 0x12cc, Name: "Pluto Technologies International", Devices: []Device{}},
	{ID: 0x12cd, Name: "Aims Lab", Devices: []Device{}},
	{ID: 0x12ce, Name: "Netspeed Inc.", Devices: []Device{}},
	{ID: 0x12cf, Name: "Prophet Systems, Inc.", Devices: []Device{}},
	{ID: 0x12d0, Name: "GDE Systems, Inc.", Devices: []Device{}},
	{ID: 0x12d1, Name: "PSITech", Devices: []Device{}},
	{
		ID: 0x12d2, Name: "NVidia / SGS Thomson (Joint Venture)", Devices: []Device{
			{ID: 0x0008, Name: "NV1"},
			{ID: 0x0009, Name: "DAC64"},
			{ID: 0x0018, Name: "Riva128"},
			{ID: 0x0019, Name: "Riva128ZX"},
			{ID: 0x0020, Name: "TNT"},
			{ID: 0x0028, Name: "TNT2"},
			{ID: 0x0029, Name: "UTNT2"},
			{ID: 0x002c, Name: "VTNT2"},
			{ID: 0x00a0, Name: "ITNT2"},
		},
	},
	{ID: 0x12d3, Name: "Vingmed Sound A/S", Devices: []Device{}},
	{
		ID: 0x12d4, Name: "Ulticom (Formerly DGM&S)", Devices: []Device{
			{ID: 0x0200, Name: "T1 Card"},
		},
	},
	{
		ID: 0x12d5, Name: "Equator Technologies Inc", Devices: []Device{
			{ID: 0x0003, Name: "BSP16"},
			{ID: 0x1000, Name: "BSP15"},
		},
	},
	{ID: 0x12d6, Name: "Analogic Corp", Devices: []Device{}},
	{ID: 0x12d7, Name: "Biotronic SRL", Devices: []Device{}},
	{
		ID: 0x12d8, Name: "Pericom Semiconductor", Devices: []Device{
			{ID: 0x01a7, Name: "7C21P100 2-port PCI-X to PCI-X Bridge"},
			{ID: 0x0303, Name: "PCI Express Switch 3-3"},
			{ID: 0x0508, Name: "PI7C9X20508GP PCI Express Switch 5Port-8Lane"},
			{ID: 0x2304, Name: "PI7C9X2G304 EL/SL PCIe2 3-Port/4-Lane Packet Switch"},
			{ID: 0x2308, Name: "PI7C9X2G308GP 8-lane PCI Express 2.0 Switch with 3 PCI Express ports"},
			{ID: 0x2404, Name: "PI7C9X2G404 EL/SL PCIe2 4-Port/4-Lane Packet Switch"},
			{ID: 0x2608, Name: "PI7C9X2G608GP PCIe2 6-Port/8-Lane Packet Switch"},
			{ID: 0x400a, Name: "PI7C9X442SL PCI Express Bridge Port"},
			{ID: 0x400e, Name: "PI7C9X442SL USB OHCI Controller"},
			{ID: 0x400f, Name: "PI7C9X442SL USB EHCI Controller"},
			{ID: 0x71e2, Name: "PI7C7300A/PI7C7300D PCI-to-PCI Bridge"},
			{ID: 0x71e3, Name: "PI7C7300A/PI7C7300D PCI-to-PCI Bridge (Secondary Bus 2)"},
			{ID: 0x8140, Name: "PI7C8140A PCI-to-PCI Bridge"},
			{ID: 0x8148, Name: "PI7C8148A/PI7C8148B PCI-to-PCI Bridge"},
			{ID: 0x8150, Name: "PCI to PCI Bridge"},
			{ID: 0x8152, Name: "PI7C8152A/PI7C8152B/PI7C8152BI PCI-to-PCI Bridge"},
			{ID: 0x8154, Name: "PI7C8154A/PI7C8154B/PI7C8154BI PCI-to-PCI Bridge"},
			{ID: 0x8619, Name: "PI7C9X2G1616PR PCIe2 16-Port/16-Lane Packet Switch"},
			{ID: 0xe110, Name: "PI7C9X110 PCI Express to PCI bridge"},
			{ID: 0xe111, Name: "PI7C9X111SL PCIe-to-PCI Reversible Bridge"},
			{ID: 0xe130, Name: "PCI Express to PCI-XPI7C9X130 PCI-X Bridge"},
		},
	},
	{
		ID: 0x12d9, Name: "Aculab PLC", Devices: []Device{
			{ID: 0x0002, Name: "PCI Prosody"},
			{ID: 0x0004, Name: "cPCI Prosody"},
			{ID: 0x0005, Name: "Aculab E1/T1 PCI card"},
			{ID: 0x1078, Name: "Prosody X class e1000 device"},
		},
	},
	{ID: 0x12da, Name: "True Time Inc.", Devices: []Device{}},
	{ID: 0x12db, Name: "Annapolis Micro Systems, Inc", Devices: []Device{}},
	{ID: 0x12dc, Name: "Symicron Computer Communication Ltd.", Devices: []Device{}},
	{ID: 0x12dd, Name: "Management Graphics", Devices: []Device{}},
	{
		ID: 0x12de, Name: "Rainbow Technologies", Devices: []Device{
			{ID: 0x0200, Name: "CryptoSwift CS200"},
		},
	},
	{ID: 0x12df, Name: "SBS Technologies Inc", Devices: []Device{}},
	{
		ID: 0x12e0, Name: "Chase Research", Devices: []Device{
			{ID: 0x0010, Name: "ST16C654 Quad UART"},
			{ID: 0x0020, Name: "ST16C654 Quad UART"},
			{ID: 0x0030, Name: "ST16C654 Quad UART"},
		},
	},
	{ID: 0x12e1, Name: "Nintendo Co, Ltd", Devices: []Device{}},
	{ID: 0x12e2, Name: "Datum Inc. Bancomm-Timing Division", Devices: []Device{}},
	{ID: 0x12e3, Name: "Imation Corp - Medical Imaging Systems", Devices: []Device{}},
	{ID: 0x12e4, Name: "Brooktrout Technology Inc", Devices: []Device{}},
	{ID: 0x12e5, Name: "Apex Semiconductor Inc", Devices: []Device{}},
	{ID: 0x12e6, Name: "Cirel Systems", Devices: []Device{}},
	{ID: 0x12e7, Name: "Sunsgroup Corporation", Devices: []Device{}},
	{ID: 0x12e8, Name: "Crisc Corp", Devices: []Device{}},
	{ID: 0x12e9, Name: "GE Spacenet", Devices: []Device{}},
	{ID: 0x12ea, Name: "Zuken", Devices: []Device{}},
	{
		ID: 0x12eb, Name: "Aureal Semiconductor", Devices: []Device{
			{ID: 0x0001, Name: "Vortex 1"},
			{ID: 0x0002, Name: "Vortex 2"},
			{ID: 0x0003, Name: "AU8810 Vortex Digital Audio Processor"},
			{ID: 0x8803, Name: "Vortex 56k Software Modem"},
		},
	},
	{ID: 0x12ec, Name: "3A International, Inc.", Devices: []Device{}},
	{ID: 0x12ed, Name: "Optivision Inc.", Devices: []Device{}},
	{ID: 0x12ee, Name: "Orange Micro", Devices: []Device{}},
	{ID: 0x12ef, Name: "Vienna Systems", Devices: []Device{}},
	{ID: 0x12f0, Name: "Pentek", Devices: []Device{}},
	{ID: 0x12f1, Name: "Sorenson Vision Inc", Devices: []Device{}},
	{ID: 0x12f2, Name: "Gammagraphx, Inc.", Devices: []Device{}},
	{ID: 0x12f3, Name: "Radstone Technology", Devices: []Device{}},
	{ID: 0x12f4, Name: "Megatel", Devices: []Device{}},
	{ID: 0x12f5, Name: "Forks", Devices: []Device{}},
	{ID: 0x12f6, Name: "Dawson France", Devices: []Device{}},
	{ID: 0x12f7, Name: "Cognex", Devices: []Device{}},
	{
		ID: 0x12f8, Name: "Electronic Design GmbH", Devices: []Device{
			{ID: 0x0002, Name: "VideoMaker"},
		},
	},
	{ID: 0x12f9, Name: "Four Fold Ltd", Devices: []Device{}},
	{
		ID: 0x12fb, Name: "Spectrum Signal Processing", Devices: []Device{
			{ID: 0x0001, Name: "PMC-MAI"},
			{ID: 0x00f5, Name: "F5 Dakar"},
			{ID: 0x02ad, Name: "PMC-2MAI"},
			{ID: 0x2adc, Name: "ePMC-2ADC"},
			{ID: 0x3100, Name: "PRO-3100"},
			{ID: 0x3500, Name: "PRO-3500"},
			{ID: 0x4d4f, Name: "Modena"},
			{ID: 0x8120, Name: "ePMC-8120"},
			{ID: 0xda62, Name: "Daytona C6201 PCI (Hurricane)"},
			{ID: 0xdb62, Name: "Ingliston XBIF"},
			{ID: 0xdc62, Name: "Ingliston PLX9054"},
			{ID: 0xdd62, Name: "Ingliston JTAG/ISP"},
			{ID: 0xeddc, Name: "ePMC-MSDDC"},
			{ID: 0xfa01, Name: "ePMC-FPGA"},
		},
	},
	{ID: 0x12fc, Name: "Capital Equipment Corp", Devices: []Device{}},
	{ID: 0x12fd, Name: "I2S", Devices: []Device{}},
	{ID: 0x12fe, Name: "ESD Electronic System Design GmbH", Devices: []Device{}},
	{ID: 0x12ff, Name: "Lexicon", Devices: []Device{}},
	{ID: 0x1300, Name: "Harman International Industries Inc", Devices: []Device{}},
	{ID: 0x1302, Name: "Computer Sciences Corp", Devices: []Device{}},
	{
		ID: 0x1303, Name: "Innovative Integration", Devices: []Device{
			{ID: 0x0030, Name: "X3-SDF 4-channel XMC acquisition board"},
		},
	},
	{ID: 0x1304, Name: "Juniper Networks", Devices: []Device{}},
	{ID: 0x1305, Name: "Netphone, Inc", Devices: []Device{}},
	{ID: 0x1306, Name: "Duet Technologies", Devices: []Device{}},
	{
		ID: 0x1307, Name: "Measurement Computing", Devices: []Device{
			{ID: 0x0001, Name: "PCI-DAS1602/16"},
			{ID: 0x000b, Name: "PCI-DIO48H"},
			{ID: 0x000c, Name: "PCI-PDISO8"},
			{ID: 0x000d, Name: "PCI-PDISO16"},
			{ID: 0x000f, Name: "PCI-DAS1200"},
			{ID: 0x0010, Name: "PCI-DAS1602/12"},
			{ID: 0x0014, Name: "PCI-DIO24H"},
			{ID: 0x0015, Name: "PCI-DIO24H/CTR3"},
			{ID: 0x0016, Name: "PCI-DIO48H/CTR15"},
			{ID: 0x0017, Name: "PCI-DIO96H"},
			{ID: 0x0018, Name: "PCI-CTR05"},
			{ID: 0x0019, Name: "PCI-DAS1200/JR"},
			{ID: 0x001a, Name: "PCI-DAS1001"},
			{ID: 0x001b, Name: "PCI-DAS1002"},
			{ID: 0x001c, Name: "PCI-DAS1602JR/16"},
			{ID: 0x001d, Name: "PCI-DAS6402/16"},
			{ID: 0x001e, Name: "PCI-DAS6402/12"},
			{ID: 0x001f, Name: "PCI-DAS16/M1"},
			{ID: 0x0020, Name: "PCI-DDA02/12"},
			{ID: 0x0021, Name: "PCI-DDA04/12"},
			{ID: 0x0022, Name: "PCI-DDA08/12"},
			{ID: 0x0023, Name: "PCI-DDA02/16"},
			{ID: 0x0024, Name: "PCI-DDA04/16"},
			{ID: 0x0025, Name: "PCI-DDA08/16"},
			{ID: 0x0026, Name: "PCI-DAC04/12-HS"},
			{ID: 0x0027, Name: "PCI-DAC04/16-HS"},
			{ID: 0x0028, Name: "PCI-DIO24"},
			{ID: 0x0029, Name: "PCI-DAS08"},
			{ID: 0x002c, Name: "PCI-INT32"},
			{ID: 0x0033, Name: "PCI-DUAL-AC5"},
			{ID: 0x0034, Name: "PCI-DAS-TC"},
			{ID: 0x0035, Name: "PCI-DAS64/M1/16"},
			{ID: 0x0036, Name: "PCI-DAS64/M2/16"},
			{ID: 0x0037, Name: "PCI-DAS64/M3/16"},
			{ID: 0x004c, Name: "PCI-DAS1000"},
			{ID: 0x004d, Name: "PCI-QUAD04"},
			{ID: 0x0052, Name: "PCI-DAS4020/12"},
			{ID: 0x0053, Name: "PCIM-DDA06/16"},
			{ID: 0x0054, Name: "PCI-DIO96"},
			{ID: 0x005d, Name: "PCI-DAS6023"},
			{ID: 0x005e, Name: "PCI-DAS6025"},
			{ID: 0x005f, Name: "PCI-DAS6030"},
			{ID: 0x0060, Name: "PCI-DAS6031"},
			{ID: 0x0061, Name: "PCI-DAS6032"},
			{ID: 0x0062, Name: "PCI-DAS6033"},
			{ID: 0x0063, Name: "PCI-DAS6034"},
			{ID: 0x0064, Name: "PCI-DAS6035"},
			{ID: 0x0065, Name: "PCI-DAS6040"},
			{ID: 0x0066, Name: "PCI-DAS6052"},
			{ID: 0x0067, Name: "PCI-DAS6070"},
			{ID: 0x0068, Name: "PCI-DAS6071"},
			{ID: 0x006f, Name: "PCI-DAS6036"},
			{ID: 0x0070, Name: "PCI-DAC6702"},
			{ID: 0x0078, Name: "PCI-DAS6013"},
			{ID: 0x0079, Name: "PCI-DAS6014"},
			{ID: 0x0115, Name: "PCIe-DAS1602/16"},
		},
	},
	{
		ID: 0x1308, Name: "Jato Technologies Inc.", Devices: []Device{
			{ID: 0x0001, Name: "NetCelerator Adapter"},
		},
	},
	{ID: 0x1309, Name: "AB Semiconductor Ltd", Devices: []Device{}},
	{ID: 0x130a, Name: "Mitsubishi Electric Microcomputer", Devices: []Device{}},
	{ID: 0x130b, Name: "Colorgraphic Communications Corp", Devices: []Device{}},
	{ID: 0x130c, Name: "Ambex Technologies, Inc", Devices: []Device{}},
	{ID: 0x130d, Name: "Accelerix Inc", Devices: []Device{}},
	{ID: 0x130e, Name: "Yamatake-Honeywell Co. Ltd", Devices: []Device{}},
	{ID: 0x130f, Name: "Advanet Inc", Devices: []Device{}},
	{ID: 0x1310, Name: "Gespac", Devices: []Device{}},
	{ID: 0x1311, Name: "Videoserver, Inc", Devices: []Device{}},
	{ID: 0x1312, Name: "Acuity Imaging, Inc", Devices: []Device{}},
	{ID: 0x1313, Name: "Yaskawa Electric Co.", Devices: []Device{}},
	{ID: 0x1315, Name: "Wavesat", Devices: []Device{}},
	{ID: 0x1316, Name: "Teradyne Inc", Devices: []Device{}},
	{
		ID: 0x1317, Name: "ADMtek", Devices: []Device{
			{ID: 0x0981, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
			{ID: 0x0985, Name: "NC100 Network Everywhere Fast Ethernet 10/100"},
			{ID: 0x1985, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
			{ID: 0x2850, Name: "HSP MicroModem 56"},
			{ID: 0x5120, Name: "ADM5120 OpenGate System-on-Chip"},
			{ID: 0x8201, Name: "ADM8211 802.11b Wireless Interface"},
			{ID: 0x8211, Name: "ADM8211 802.11b Wireless Interface"},
			{ID: 0x9511, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
		},
	},
	{
		ID: 0x1318, Name: "Packet Engines Inc.", Devices: []Device{
			{ID: 0x0911, Name: "GNIC-II PCI Gigabit Ethernet [Hamachi]"},
		},
	},
	{
		ID: 0x1319, Name: "Fortemedia, Inc", Devices: []Device{
			{ID: 0x0801, Name: "Xwave QS3000A [FM801]"},
			{ID: 0x0802, Name: "Xwave QS3000A [FM801 game port]"},
			{ID: 0x1000, Name: "FM801 PCI Audio"},
			{ID: 0x1001, Name: "FM801 PCI Joystick"},
		},
	},
	{ID: 0x131a, Name: "Finisar Corp.", Devices: []Device{}},
	{ID: 0x131c, Name: "Nippon Electro-Sensory Devices Corp", Devices: []Device{}},
	{ID: 0x131d, Name: "Sysmic, Inc.", Devices: []Device{}},
	{ID: 0x131e, Name: "Xinex Networks Inc", Devices: []Device{}},
	{
		ID: 0x131f, Name: "Siig Inc", Devices: []Device{
			{ID: 0x1000, Name: "CyberSerial (1-port) 16550"},
			{ID: 0x1001, Name: "CyberSerial (1-port) 16650"},
			{ID: 0x1002, Name: "CyberSerial (1-port) 16850"},
			{ID: 0x1010, Name: "Duet 1S(16550)+1P"},
			{ID: 0x1011, Name: "Duet 1S(16650)+1P"},
			{ID: 0x1012, Name: "Duet 1S(16850)+1P"},
			{ID: 0x1020, Name: "CyberParallel (1-port)"},
			{ID: 0x1021, Name: "CyberParallel (2-port)"},
			{ID: 0x1030, Name: "CyberSerial (2-port) 16550"},
			{ID: 0x1031, Name: "CyberSerial (2-port) 16650"},
			{ID: 0x1032, Name: "CyberSerial (2-port) 16850"},
			{ID: 0x1034, Name: "Trio 2S(16550)+1P"},
			{ID: 0x1035, Name: "Trio 2S(16650)+1P"},
			{ID: 0x1036, Name: "Trio 2S(16850)+1P"},
			{ID: 0x1050, Name: "CyberSerial (4-port) 16550"},
			{ID: 0x1051, Name: "CyberSerial (4-port) 16650"},
			{ID: 0x1052, Name: "CyberSerial (4-port) 16850"},
			{ID: 0x2000, Name: "CyberSerial (1-port) 16550"},
			{ID: 0x2001, Name: "CyberSerial (1-port) 16650"},
			{ID: 0x2002, Name: "CyberSerial (1-port) 16850"},
			{ID: 0x2010, Name: "Duet 1S(16550)+1P"},
			{ID: 0x2011, Name: "Duet 1S(16650)+1P"},
			{ID: 0x2012, Name: "Duet 1S(16850)+1P"},
			{ID: 0x2020, Name: "CyberParallel (1-port)"},
			{ID: 0x2021, Name: "CyberParallel (2-port)"},
			{ID: 0x2030, Name: "CyberSerial (2-port) 16550"},
			{ID: 0x2031, Name: "CyberSerial (2-port) 16650"},
			{ID: 0x2032, Name: "CyberSerial (2-port) 16850"},
			{ID: 0x2040, Name: "Trio 1S(16550)+2P"},
			{ID: 0x2041, Name: "Trio 1S(16650)+2P"},
			{ID: 0x2042, Name: "Trio 1S(16850)+2P"},
			{ID: 0x2050, Name: "CyberSerial (4-port) 16550"},
			{ID: 0x2051, Name: "CyberSerial (4-port) 16650"},
			{ID: 0x2052, Name: "CyberSerial (4-port) 16850"},
			{ID: 0x2060, Name: "Trio 2S(16550)+1P"},
			{ID: 0x2061, Name: "Trio 2S(16650)+1P"},
			{ID: 0x2062, Name: "Trio 2S(16850)+1P"},
			{ID: 0x2081, Name: "CyberSerial (8-port) ST16654"},
		},
	},
	{ID: 0x1320, Name: "Crypto AG", Devices: []Device{}},
	{ID: 0x1321, Name: "Arcobel Graphics BV", Devices: []Device{}},
	{ID: 0x1322, Name: "MTT Co., Ltd", Devices: []Device{}},
	{ID: 0x1323, Name: "Dome Inc", Devices: []Device{}},
	{ID: 0x1324, Name: "Sphere Communications", Devices: []Device{}},
	{ID: 0x1325, Name: "Salix Technologies, Inc", Devices: []Device{}},
	{ID: 0x1326, Name: "Seachange international", Devices: []Device{}},
	{ID: 0x1327, Name: "Voss scientific", Devices: []Device{}},
	{ID: 0x1328, Name: "quadrant international", Devices: []Device{}},
	{ID: 0x1329, Name: "Productivity Enhancement", Devices: []Device{}},
	{ID: 0x132a, Name: "Microcom Inc.", Devices: []Device{}},
	{ID: 0x132b, Name: "Broadband Technologies", Devices: []Device{}},
	{ID: 0x132c, Name: "Micrel Inc", Devices: []Device{}},
	{ID: 0x132d, Name: "Integrated Silicon Solution, Inc.", Devices: []Device{}},
	{ID: 0x1330, Name: "MMC Networks", Devices: []Device{}},
	{
		ID: 0x1331, Name: "RadiSys Corporation", Devices: []Device{
			{ID: 0x0030, Name: "ENP-2611"},
			{ID: 0x8200, Name: "82600 Host Bridge"},
			{ID: 0x8201, Name: "82600 IDE"},
			{ID: 0x8202, Name: "82600 USB"},
			{ID: 0x8210, Name: "82600 PCI Bridge"},
		},
	},
	{
		ID: 0x1332, Name: "Micro Memory", Devices: []Device{
			{ID: 0x5415, Name: "MM-5415CN PCI Memory Module with Battery Backup"},
			{ID: 0x5425, Name: "MM-5425CN PCI 64/66 Memory Module with Battery Backup"},
			{ID: 0x6140, Name: "MM-6140D"},
		},
	},
	{ID: 0x1334, Name: "Redcreek Communications, Inc", Devices: []Device{}},
	{ID: 0x1335, Name: "Videomail, Inc", Devices: []Device{}},
	{ID: 0x1337, Name: "Third Planet Publishing", Devices: []Device{}},
	{ID: 0x1338, Name: "BT Electronics", Devices: []Device{}},
	{ID: 0x133a, Name: "Vtel Corp", Devices: []Device{}},
	{ID: 0x133b, Name: "Softcom Microsystems", Devices: []Device{}},
	{ID: 0x133c, Name: "Holontech Corp", Devices: []Device{}},
	{ID: 0x133d, Name: "SS Technologies", Devices: []Device{}},
	{ID: 0x133e, Name: "Virtual Computer Corp", Devices: []Device{}},
	{ID: 0x133f, Name: "SCM Microsystems", Devices: []Device{}},
	{ID: 0x1340, Name: "Atalla Corp", Devices: []Device{}},
	{ID: 0x1341, Name: "Kyoto Microcomputer Co", Devices: []Device{}},
	{ID: 0x1342, Name: "Promax Systems Inc", Devices: []Device{}},
	{ID: 0x1343, Name: "Phylon Communications Inc", Devices: []Device{}},
	{
		ID: 0x1344, Name: "Micron Technology Inc", Devices: []Device{
			{ID: 0x5150, Name: "RealSSD P320h"},
			{ID: 0x5151, Name: "RealSSD P320m"},
			{ID: 0x5152, Name: "RealSSD P320s"},
			{ID: 0x5153, Name: "RealSSD P325m"},
			{ID: 0x5160, Name: "RealSSD P420h"},
			{ID: 0x5161, Name: "RealSSD P420m"},
			{ID: 0x5163, Name: "RealSSD P425m"},
			{ID: 0x5180, Name: "9100 PRO NVMe SSD"},
			{ID: 0x5181, Name: "9100 MAX NVMe SSD"},
			{ID: 0x5190, Name: "9200 ECO NVMe SSD"},
			{ID: 0x5191, Name: "9200 PRO NVMe SSD"},
			{ID: 0x5192, Name: "9200 MAX NVMe SSD"},
		},
	},
	{ID: 0x1345, Name: "Arescom Inc", Devices: []Device{}},
	{ID: 0x1347, Name: "Odetics", Devices: []Device{}},
	{ID: 0x1349, Name: "Sumitomo Electric Industries, Ltd.", Devices: []Device{}},
	{
		ID: 0x134a, Name: "DTC Technology Corp.", Devices: []Device{
			{ID: 0x0001, Name: "Domex 536"},
			{ID: 0x0002, Name: "Domex DMX3194UP SCSI Adapter"},
		},
	},
	{ID: 0x134b, Name: "ARK Research Corp.", Devices: []Device{}},
	{ID: 0x134c, Name: "Chori Joho System Co. Ltd", Devices: []Device{}},
	{
		ID: 0x134d, Name: "PCTel Inc", Devices: []Device{
			{ID: 0x2189, Name: "HSP56 MicroModem"},
			{ID: 0x2486, Name: "2304WT V.92 MDC Modem"},
			{ID: 0x7890, Name: "HSP MicroModem 56"},
			{ID: 0x7891, Name: "HSP MicroModem 56"},
			{ID: 0x7892, Name: "HSP MicroModem 56"},
			{ID: 0x7893, Name: "HSP MicroModem 56"},
			{ID: 0x7894, Name: "HSP MicroModem 56"},
			{ID: 0x7895, Name: "HSP MicroModem 56"},
			{ID: 0x7896, Name: "HSP MicroModem 56"},
			{ID: 0x7897, Name: "HSP MicroModem 56"},
		},
	},
	{ID: 0x134e, Name: "CSTI", Devices: []Device{}},
	{ID: 0x134f, Name: "Algo System Co Ltd", Devices: []Device{}},
	{ID: 0x1350, Name: "Systec Co. Ltd", Devices: []Device{}},
	{ID: 0x1351, Name: "Sonix Inc", Devices: []Device{}},
	{
		ID: 0x1353, Name: "dbeeSet Technology", Devices: []Device{
			{ID: 0x0002, Name: "Proserver"},
			{ID: 0x0003, Name: "PCI-FUT"},
			{ID: 0x0004, Name: "PCI-S0"},
			{ID: 0x0005, Name: "PCI-FUT-S0"},
			{ID: 0x0006, Name: "OTDU-1U (FPGA Zynq-7000)"},
			{ID: 0x0007, Name: "OTDU-EX"},
		},
	},
	{ID: 0x1354, Name: "Dwave System Inc", Devices: []Device{}},
	{ID: 0x1355, Name: "Kratos Analytical Ltd", Devices: []Device{}},
	{ID: 0x1356, Name: "The Logical Co", Devices: []Device{}},
	{ID: 0x1359, Name: "Prisa Networks", Devices: []Device{}},
	{
		ID: 0x135a, Name: "Brain Boxes", Devices: []Device{
			{ID: 0x0a61, Name: "UC-324 [VELOCITY RS422/485]"},
		},
	},
	{ID: 0x135b, Name: "Giganet Inc", Devices: []Device{}},
	{
		ID: 0x135c, Name: "Quatech Inc", Devices: []Device{
			{ID: 0x0010, Name: "QSC-100"},
			{ID: 0x0020, Name: "DSC-100"},
			{ID: 0x0030, Name: "DSC-200/300"},
			{ID: 0x0040, Name: "QSC-200/300"},
			{ID: 0x0050, Name: "ESC-100D"},
			{ID: 0x0060, Name: "ESC-100M"},
			{ID: 0x00f0, Name: "MPAC-100 Synchronous Serial Card (Zilog 85230)"},
			{ID: 0x0170, Name: "QSCLP-100"},
			{ID: 0x0180, Name: "DSCLP-100"},
			{ID: 0x0190, Name: "SSCLP-100"},
			{ID: 0x01a0, Name: "QSCLP-200/300"},
			{ID: 0x01b0, Name: "DSCLP-200/300"},
			{ID: 0x01c0, Name: "SSCLP-200/300"},
			{ID: 0x0258, Name: "DSPSX-200/300"},
		},
	},
	{ID: 0x135d, Name: "ABB Network Partner AB", Devices: []Device{}},
	{
		ID: 0x135e, Name: "Sealevel Systems Inc", Devices: []Device{
			{ID: 0x5101, Name: "Route 56.PCI - Multi-Protocol Serial Interface (Zilog Z16C32)"},
			{ID: 0x7101, Name: "Single Port RS-232/422/485/530"},
			{ID: 0x7201, Name: "Dual Port RS-232/422/485 Interface"},
			{ID: 0x7202, Name: "Dual Port RS-232 Interface"},
			{ID: 0x7401, Name: "Four Port RS-232 Interface"},
			{ID: 0x7402, Name: "Four Port RS-422/485 Interface"},
			{ID: 0x7801, Name: "Eight Port RS-232 Interface"},
			{ID: 0x7804, Name: "Eight Port RS-232/422/485 Interface"},
			{ID: 0x8001, Name: "8001 Digital I/O Adapter"},
		},
	},
	{ID: 0x135f, Name: "I-Data International A-S", Devices: []Device{}},
	{
		ID: 0x1360, Name: "Meinberg Funkuhren", Devices: []Device{
			{ID: 0x0101, Name: "PCI32 DCF77 Radio Clock"},
			{ID: 0x0102, Name: "PCI509 DCF77 Radio Clock"},
			{ID: 0x0103, Name: "PCI510 DCF77 Radio Clock"},
			{ID: 0x0104, Name: "PCI511 DCF77 Radio Clock"},
			{ID: 0x0105, Name: "PEX511 DCF77 Radio Clock (PCI Express)"},
			{ID: 0x0106, Name: "PZF180PEX High Precision DCF77 Radio Clock (PCI Express)"},
			{ID: 0x0201, Name: "GPS167PCI GPS Receiver"},
			{ID: 0x0202, Name: "GPS168PCI GPS Receiver"},
			{ID: 0x0203, Name: "GPS169PCI GPS Receiver"},
			{ID: 0x0204, Name: "GPS170PCI GPS Receiver"},
			{ID: 0x0205, Name: "GPS170PEX GPS Receiver (PCI Express)"},
			{ID: 0x0206, Name: "GPS180PEX GPS Receiver (PCI Express)"},
			{ID: 0x0207, Name: "GLN180PEX GPS/GLONASS receiver (PCI Express)"},
			{ID: 0x0208, Name: "GPS180AMC GPS Receiver (PCI Express / MicroTCA / AdvancedMC)"},
			{ID: 0x0209, Name: "GNS181PEX GPS/Galileo/GLONASS/BEIDOU receiver (PCI Express)"},
			{ID: 0x0301, Name: "TCR510PCI IRIG Timecode Reader"},
			{ID: 0x0302, Name: "TCR167PCI IRIG Timecode Reader"},
			{ID: 0x0303, Name: "TCR511PCI IRIG Timecode Reader"},
			{ID: 0x0304, Name: "TCR511PEX IRIG Timecode Reader (PCI Express)"},
			{ID: 0x0305, Name: "TCR170PEX IRIG Timecode Reader (PCI Express)"},
			{ID: 0x0306, Name: "TCR180PEX IRIG Timecode Reader (PCI Express)"},
			{ID: 0x0501, Name: "PTP270PEX PTP/IEEE1588 slave card (PCI Express)"},
			{ID: 0x0601, Name: "FRC511PEX Free Running Clock (PCI Express)"},
		},
	},
	{ID: 0x1361, Name: "Soliton Systems K.K.", Devices: []Device{}},
	{ID: 0x1362, Name: "Fujifacom Corporation", Devices: []Device{}},
	{ID: 0x1363, Name: "Phoenix Technology Ltd", Devices: []Device{}},
	{ID: 0x1364, Name: "ATM Communications Inc", Devices: []Device{}},
	{ID: 0x1365, Name: "Hypercope GmbH", Devices: []Device{}},
	{ID: 0x1366, Name: "Teijin Seiki Co. Ltd", Devices: []Device{}},
	{ID: 0x1367, Name: "Hitachi Zosen Corporation", Devices: []Device{}},
	{ID: 0x1368, Name: "Skyware Corporation", Devices: []Device{}},
	{ID: 0x1369, Name: "Digigram", Devices: []Device{}},
	{
		ID: 0x136a, Name: "High Soft Tech", Devices: []Device{
			{ID: 0x0004, Name: "HST Saphir VII mini PCI"},
			{ID: 0x0007, Name: "HST Saphir III E MultiLink 4"},
			{ID: 0x0008, Name: "HST Saphir III E MultiLink 8"},
			{ID: 0x000a, Name: "HST Saphir III E MultiLink 2"},
		},
	},
	{
		ID: 0x136b, Name: "Kawasaki Steel Corporation", Devices: []Device{
			{ID: 0xff01, Name: "KL5A72002 Motion JPEG"},
		},
	},
	{ID: 0x136c, Name: "Adtek System Science Co Ltd", Devices: []Device{}},
	{ID: 0x136d, Name: "Gigalabs Inc", Devices: []Device{}},
	{ID: 0x136f, Name: "Applied Magic Inc", Devices: []Device{}},
	{ID: 0x1370, Name: "ATL Products", Devices: []Device{}},
	{
		ID: 0x1371, Name: "CNet Technology Inc", Devices: []Device{
			{ID: 0x434e, Name: "GigaCard Network Adapter"},
		},
	},
	{ID: 0x1373, Name: "Silicon Vision Inc", Devices: []Device{}},
	{
		ID: 0x1374, Name: "Silicom Ltd.", Devices: []Device{
			{ID: 0x0024, Name: "Silicom Dual port Giga Ethernet BGE Bypass Server Adapter"},
			{ID: 0x0025, Name: "Silicom Quad port Giga Ethernet BGE Bypass Server Adapter"},
			{ID: 0x0026, Name: "Silicom Dual port Fiber Giga Ethernet 546 Bypass Server Adapter"},
			{ID: 0x0027, Name: "Silicom Dual port Fiber LX Giga Ethernet 546 Bypass Server Adapter"},
			{ID: 0x0029, Name: "Silicom Dual port Copper Giga Ethernet 546GB Bypass Server Adapter"},
			{ID: 0x002a, Name: "Silicom Dual port Fiber Giga Ethernet 546 TAP/Bypass Server Adapter"},
			{ID: 0x002b, Name: "Silicom Dual port Copper Fast Ethernet 546 TAP/Bypass Server Adapter (PXE2TBI)"},
			{ID: 0x002c, Name: "Silicom Quad port Copper Giga Ethernet 546GB Bypass Server Adapter (PXG4BPI)"},
			{ID: 0x002d, Name: "Silicom Quad port Fiber-SX Giga Ethernet 546GB Bypass Server Adapter (PXG4BPFI)"},
			{ID: 0x002e, Name: "Silicom Quad port Fiber-LX Giga Ethernet 546GB Bypass Server Adapter (PXG4BPFI-LX)"},
			{ID: 0x002f, Name: "Silicom Dual port Fiber-SX Giga Ethernet 546GB Low profile Bypass Server Adapter (PXG2BPFIL)"},
			{ID: 0x0030, Name: "Silicom Dual port Fiber-LX Giga Ethernet 546GB Low profile Bypass Server Adapter"},
			{ID: 0x0031, Name: "Silicom Quad port Copper Giga Ethernet PCI-E Bypass Server Adapter"},
			{ID: 0x0032, Name: "Silicom Dual port Copper Fast Ethernet 546 TAP/Bypass Server Adapter"},
			{ID: 0x0034, Name: "Silicom Dual port Copper Giga Ethernet PCI-E BGE Bypass Server Adapter"},
			{ID: 0x0035, Name: "Silicom Quad port Copper Giga Ethernet PCI-E BGE Bypass Server Adapter"},
			{ID: 0x0036, Name: "Silicom Dual port Fiber Giga Ethernet PCI-E BGE Bypass Server Adapter"},
			{ID: 0x0037, Name: "Silicom Dual port Copper Ethernet PCI-E Intel based Bypass Server Adapter"},
			{ID: 0x0038, Name: "Silicom Quad port Copper Ethernet PCI-E Intel based Bypass Server Adapter"},
			{ID: 0x0039, Name: "Silicom Dual port Fiber-SX Ethernet PCI-E Intel based Bypass Server Adapter"},
			{ID: 0x003a, Name: "Silicom Dual port Fiber-LX Ethernet PCI-E Intel based Bypass Server Adapter"},
			{ID: 0x003b, Name: "Silicom Dual port Fiber Ethernet PMC Intel based Bypass Server Adapter (PMCX2BPFI)"},
			{ID: 0x003c, Name: "Silicom Dual port Copper Ethernet PCI-X BGE based Bypass Server Adapter (PXG2BPRB)"},
			{ID: 0x003d, Name: "2-port Copper GBE Bypass with Caviume 1010 PCI-X"},
			{ID: 0x003e, Name: "Silicom Dual port Fiber Giga Ethernet PCI-E 571 TAP/Bypass Server Adapter (PEG2TBFI)"},
			{ID: 0x003f, Name: "Silicom Dual port Copper Giga Ethernet PCI-X 546 TAP/Bypass Server Adapter (PXG2TBI)"},
			{ID: 0x0040, Name: "Silicom Quad port Fiber-SX Giga Ethernet 571 Bypass Server Adapter (PEG4BPFI)"},
			{ID: 0x0042, Name: "4-port Copper GBE PMC-X Bypass"},
			{ID: 0x0043, Name: "Silicom Quad port Fiber-SX Giga Ethernet 546 Bypass Server Adapter (PXG4BPFID)"},
			{ID: 0x0045, Name: "Silicom 6 port Copper Giga Ethernet 546 Bypass Server Adapter (PXG6BPI)"},
			{ID: 0x0046, Name: "4-port bypass PCI-E w disconnect low profile"},
			{ID: 0x0047, Name: "Silicom Dual port Fiber-SX Giga Ethernet 571 Bypass Disconnect Server Adapter (PEG2BPFID)"},
			{ID: 0x004a, Name: "Silicom Quad port Fiber-LX Giga Ethernet 571 Bypass Server Adapter (PEG4BPFI-LX)"},
			{ID: 0x004d, Name: "Dual port Copper Giga Ethernet PCI-E Bypass Server Adapter"},
			{ID: 0x0401, Name: "Gigabit Ethernet ExpressModule Bypass Server Adapter"},
			{ID: 0x0420, Name: "Gigabit Ethernet ExpressModule Bypass Server Adapter"},
			{ID: 0x0460, Name: "Gigabit Ethernet Express Module Bypass Server Adapter"},
			{ID: 0x0461, Name: "Gigabit Ethernet ExpressModule Bypass Server Adapter"},
			{ID: 0x0462, Name: "Gigabit Ethernet ExpressModule Bypass Server Adapter"},
			{ID: 0x0470, Name: "Octal-port Copper Gigabit Ethernet Express Module Bypass Server Adapter"},
			{ID: 0x0482, Name: "Dual-port Fiber (SR) 10 Gigabit Ethernet ExpressModule Bypass Server Adapter"},
			{ID: 0x0483, Name: "Dual-port Fiber (LR) 10 Gigabit Ethernet ExpressModule Bypass Server Adapter"},
		},
	},
	{ID: 0x1375, Name: "Argosystems Inc", Devices: []Device{}},
	{ID: 0x1376, Name: "LMC", Devices: []Device{}},
	{ID: 0x1377, Name: "Electronic Equipment Production & Distribution GmbH", Devices: []Device{}},
	{ID: 0x1378, Name: "Telemann Co. Ltd", Devices: []Device{}},
	{ID: 0x1379, Name: "Asahi Kasei Microsystems Co Ltd", Devices: []Device{}},
	{
		ID: 0x137a, Name: "Mark of the Unicorn Inc", Devices: []Device{
			{ID: 0x0001, Name: "PCI-324 Audiowire Interface"},
		},
	},
	{ID: 0x137b, Name: "PPT Vision", Devices: []Device{}},
	{ID: 0x137c, Name: "Iwatsu Electric Co Ltd", Devices: []Device{}},
	{ID: 0x137d, Name: "Dynachip Corporation", Devices: []Device{}},
	{ID: 0x137e, Name: "Patriot Scientific Corporation", Devices: []Device{}},
	{ID: 0x137f, Name: "Japan Satellite Systems Inc", Devices: []Device{}},
	{ID: 0x1380, Name: "Sanritz Automation Co Ltd", Devices: []Device{}},
	{ID: 0x1381, Name: "Brains Co. Ltd", Devices: []Device{}},
	{
		ID: 0x1382, Name: "Marian - Electronic & Software", Devices: []Device{
			{ID: 0x0001, Name: "ARC88 audio recording card"},
			{ID: 0x2008, Name: "Prodif 96 Pro sound system"},
			{ID: 0x2048, Name: "Prodif Plus sound system"},
			{ID: 0x2088, Name: "Marc 8 Midi sound system"},
			{ID: 0x20c8, Name: "Marc A sound system"},
			{ID: 0x4008, Name: "Marc 2 sound system"},
			{ID: 0x4010, Name: "Marc 2 Pro sound system"},
			{ID: 0x4048, Name: "Marc 4 MIDI sound system"},
			{ID: 0x4088, Name: "Marc 4 Digi sound system"},
			{ID: 0x4248, Name: "Marc X sound system"},
			{ID: 0x4424, Name: "TRACE D4 Sound System"},
		},
	},
	{ID: 0x1383, Name: "Controlnet Inc", Devices: []Device{}},
	{ID: 0x1384, Name: "Reality Simulation Systems Inc", Devices: []Device{}},
	{
		ID: 0x1385, Name: "Netgear", Devices: []Device{
			{ID: 0x006b, Name: "WA301 802.11b Wireless PCI Adapter"},
			{ID: 0x4100, Name: "MA301 802.11b Wireless PCI Adapter"},
			{ID: 0x4601, Name: "WAG511 802.11a/b/g Dual Band Wireless PC Card"},
			{ID: 0x620a, Name: "GA620 Gigabit Ethernet"},
			{ID: 0x630a, Name: "GA630 Gigabit Ethernet"},
		},
	},
	{ID: 0x1386, Name: "Video Domain Technologies", Devices: []Device{}},
	{ID: 0x1387, Name: "Systran Corp", Devices: []Device{}},
	{ID: 0x1388, Name: "Hitachi Information Technology Co Ltd", Devices: []Device{}},
	{
		ID: 0x1389, Name: "Applicom International", Devices: []Device{
			{ID: 0x0001, Name: "PCI1500PFB [Intelligent fieldbus adaptor]"},
		},
	},
	{
		ID: 0x138a, Name: "Fusion Micromedia Corp", Devices: []Device{
			{ID: 0x003d, Name: "VFS491 Validity Sensor"},
		},
	},
	{ID: 0x138b, Name: "Tokimec Inc", Devices: []Device{}},
	{ID: 0x138c, Name: "Silicon Reality", Devices: []Device{}},
	{ID: 0x138d, Name: "Future Techno Designs pte Ltd", Devices: []Device{}},
	{ID: 0x138e, Name: "Basler GmbH", Devices: []Device{}},
	{ID: 0x138f, Name: "Patapsco Designs Inc", Devices: []Device{}},
	{ID: 0x1390, Name: "Concept Development Inc", Devices: []Device{}},
	{ID: 0x1391, Name: "Development Concepts Inc", Devices: []Device{}},
	{ID: 0x1392, Name: "Medialight Inc", Devices: []Device{}},
	{
		ID: 0x1393, Name: "Moxa Technologies Co Ltd", Devices: []Device{
			{ID: 0x0001, Name: "UC7000 Serial"},
			{ID: 0x1020, Name: "CP-102 (2-port RS-232 PCI)"},
			{ID: 0x1021, Name: "CP-102UL (2-port RS-232 Universal PCI)"},
			{ID: 0x1022, Name: "CP-102U (2-port RS-232 Universal PCI)"},
			{ID: 0x1023, Name: "CP-102UF"},
			{ID: 0x1024, Name: "CP-102E (2-port RS-232 Smart PCI Express Serial Board)"},
			{ID: 0x1025, Name: "CP-102EL (2-port RS-232 Smart PCI Express Serial Board)"},
			{ID: 0x1040, Name: "Smartio C104H/PCI"},
			{ID: 0x1041, Name: "CP104U (4-port RS-232 Universal PCI)"},
			{ID: 0x1042, Name: "CP104JU (4-port RS-232 Universal PCI)"},
			{ID: 0x1043, Name: "CP104EL (4-port RS-232 Smart PCI Express)"},
			{ID: 0x1044, Name: "POS104UL (4-port RS-232 Universal PCI)"},
			{ID: 0x1045, Name: "CP-104EL-A (4-port RS-232 PCI Express Serial Board)"},
			{ID: 0x1080, Name: "CB108 (8-port RS-232 PC/104-plus Module)"},
			{ID: 0x1140, Name: "CT-114 series"},
			{ID: 0x1141, Name: "Industrio CP-114"},
			{ID: 0x1142, Name: "CB114 (4-port RS-232/422/485 PC/104-plus Module)"},
			{ID: 0x1143, Name: "CP-114UL (4-port RS-232/422/485 Smart Universal PCI Serial Board)"},
			{ID: 0x1144, Name: "CP-114EL (4-port RS-232/422/485 Smart PCI Express Serial Board)"},
			{ID: 0x1180, Name: "CP118U (8-port RS-232/422/485 Smart Universal PCI)"},
			{ID: 0x1181, Name: "CP118EL (8-port RS-232/422/485 Smart PCI Express)"},
			{ID: 0x1182, Name: "CP-118EL-A (8-port RS-232/422/485 PCI Express Serial Board)"},
			{ID: 0x1320, Name: "CP132 (2-port RS-422/485 PCI)"},
			{ID: 0x1321, Name: "CP132U (2-Port RS-422/485 Universal PCI)"},
			{ID: 0x1322, Name: "CP-132EL (2-port RS-422/485 Smart PCI Express Serial Board)"},
			{ID: 0x1340, Name: "CP134U (4-Port RS-422/485 Universal PCI)"},
			{ID: 0x1341, Name: "CB134I (4-port RS-422/485 PC/104-plus Module)"},
			{ID: 0x1380, Name: "CP138U (8-port RS-232/422/485 Smart Universal PCI)"},
			{ID: 0x1680, Name: "Smartio C168H/PCI"},
			{ID: 0x1681, Name: "CP-168U V2 Smart Serial Board (8-port RS-232)"},
			{ID: 0x1682, Name: "CP-168EL (8-port RS-232 Smart PCI Express)"},
			{ID: 0x1683, Name: "CP-168EL-A (8-port RS-232 PCI Express Serial Board)"},
			{ID: 0x2040, Name: "Intellio CP-204J"},
			{ID: 0x2180, Name: "Intellio C218 Turbo PCI"},
			{ID: 0x3200, Name: "Intellio C320 Turbo PCI"},
		},
	},
	{
		ID: 0x1394, Name: "Level One Communications", Devices: []Device{
			{ID: 0x0001, Name: "LXT1001 Gigabit Ethernet"},
		},
	},
	{ID: 0x1395, Name: "Ambicom Inc", Devices: []Device{}},
	{ID: 0x1396, Name: "Cipher Systems Inc", Devices: []Device{}},
	{
		ID: 0x1397, Name: "Cologne Chip Designs GmbH", Devices: []Device{
			{ID: 0x08b4, Name: "ISDN network Controller [HFC-4S]"},
			{ID: 0x16b8, Name: "ISDN network Controller [HFC-8S]"},
			{ID: 0x2bd0, Name: "ISDN network controller [HFC-PCI]"},
			{ID: 0x30b1, Name: "ISDN network Controller [HFC-E1]"},
			{ID: 0xb700, Name: "ISDN network controller PrimuX S0 [HFC-PCI]"},
			{ID: 0xf001, Name: "GSM Network Controller [HFC-4GSM]"},
		},
	},
	{ID: 0x1398, Name: "Clarion co. Ltd", Devices: []Device{}},
	{ID: 0x1399, Name: "Rios systems Co Ltd", Devices: []Device{}},
	{
		ID: 0x139a, Name: "Alacritech Inc", Devices: []Device{
			{ID: 0x0001, Name: "Quad Port 10/100 Server Accelerator"},
			{ID: 0x0003, Name: "Single Port 10/100 Server Accelerator"},
			{ID: 0x0005, Name: "Single Port Gigabit Server Accelerator"},
		},
	},
	{ID: 0x139b, Name: "Mediasonic Multimedia Systems Ltd", Devices: []Device{}},
	{ID: 0x139c, Name: "Quantum 3d Inc", Devices: []Device{}},
	{ID: 0x139d, Name: "EPL limited", Devices: []Device{}},
	{ID: 0x139e, Name: "Media4", Devices: []Device{}},
	{ID: 0x139f, Name: "Aethra s.r.l.", Devices: []Device{}},
	{ID: 0x13a0, Name: "Crystal Group Inc", Devices: []Device{}},
	{ID: 0x13a1, Name: "Kawasaki Heavy Industries Ltd", Devices: []Device{}},
	{ID: 0x13a2, Name: "Ositech Communications Inc", Devices: []Device{}},
	{
		ID: 0x13a3, Name: "Hifn Inc.", Devices: []Device{
			{ID: 0x0005, Name: "7751 Security Processor"},
			{ID: 0x0006, Name: "6500 Public Key Processor"},
			{ID: 0x0007, Name: "7811 Security Processor"},
			{ID: 0x0012, Name: "7951 Security Processor"},
			{ID: 0x0014, Name: "78XX Security Processor"},
			{ID: 0x0016, Name: "8065 Security Processor"},
			{ID: 0x0017, Name: "8165 Security Processor"},
			{ID: 0x0018, Name: "8154 Security Processor"},
			{ID: 0x001d, Name: "7956 Security Processor"},
			{ID: 0x001f, Name: "7855 Security Processor"},
			{ID: 0x0020, Name: "7955 Security Processor"},
			{ID: 0x0026, Name: "8155 Security Processor"},
			{ID: 0x002e, Name: "9630 Compression Processor"},
			{ID: 0x002f, Name: "9725 Compression and Security Processor"},
			{ID: 0x0033, Name: "8201 Acceleration Processor"},
			{ID: 0x0034, Name: "8202 Acceleration Processor"},
			{ID: 0x0035, Name: "8203 Acceleration Processor"},
			{ID: 0x0037, Name: "8204 Acceleration Processor"},
		},
	},
	{ID: 0x13a4, Name: "Rascom Inc", Devices: []Device{}},
	{ID: 0x13a5, Name: "Audio Digital Imaging Inc", Devices: []Device{}},
	{ID: 0x13a6, Name: "Videonics Inc", Devices: []Device{}},
	{ID: 0x13a7, Name: "Teles AG", Devices: []Device{}},
	{
		ID: 0x13a8, Name: "Exar Corp.", Devices: []Device{
			{ID: 0x0152, Name: "XR17C/D152 Dual PCI UART"},
			{ID: 0x0154, Name: "XR17C154 Quad UART"},
			{ID: 0x0158, Name: "XR17C158 Octal UART"},
			{ID: 0x0252, Name: "XR17V252 Dual UART PCI controller"},
			{ID: 0x0254, Name: "XR17V254 Quad UART PCI controller"},
			{ID: 0x0258, Name: "XR17V258 Octal UART PCI controller"},
			{ID: 0x0352, Name: "XR17V3521 Dual PCIe UART"},
		},
	},
	{ID: 0x13a9, Name: "Siemens Medical Systems, Ultrasound Group", Devices: []Device{}},
	{ID: 0x13aa, Name: "Broadband Networks Inc", Devices: []Device{}},
	{ID: 0x13ab, Name: "Arcom Control Systems Ltd", Devices: []Device{}},
	{ID: 0x13ac, Name: "Motion Media Technology Ltd", Devices: []Device{}},
	{ID: 0x13ad, Name: "Nexus Inc", Devices: []Device{}},
	{ID: 0x13ae, Name: "ALD Technology Ltd", Devices: []Device{}},
	{ID: 0x13af, Name: "T.Sqware", Devices: []Device{}},
	{ID: 0x13b0, Name: "Maxspeed Corp", Devices: []Device{}},
	{ID: 0x13b1, Name: "Tamura corporation", Devices: []Device{}},
	{ID: 0x13b2, Name: "Techno Chips Co. Ltd", Devices: []Device{}},
	{ID: 0x13b3, Name: "Lanart Corporation", Devices: []Device{}},
	{ID: 0x13b4, Name: "Wellbean Co Inc", Devices: []Device{}},
	{ID: 0x13b5, Name: "ARM", Devices: []Device{}},
	{ID: 0x13b6, Name: "Dlog GmbH", Devices: []Device{}},
	{ID: 0x13b7, Name: "Logic Devices Inc", Devices: []Device{}},
	{ID: 0x13b8, Name: "Nokia Telecommunications oy", Devices: []Device{}},
	{ID: 0x13b9, Name: "Elecom Co Ltd", Devices: []Device{}},
	{ID: 0x13ba, Name: "Oxford Instruments", Devices: []Device{}},
	{ID: 0x13bb, Name: "Sanyo Technosound Co Ltd", Devices: []Device{}},
	{ID: 0x13bc, Name: "Bitran Corporation", Devices: []Device{}},
	{ID: 0x13bd, Name: "Sharp corporation", Devices: []Device{}},
	{ID: 0x13be, Name: "Miroku Jyoho Service Co. Ltd", Devices: []Device{}},
	{ID: 0x13bf, Name: "Sharewave Inc", Devices: []Device{}},
	{
		ID: 0x13c0, Name: "Microgate Corporation", Devices: []Device{
			{ID: 0x0010, Name: "SyncLink Adapter v1"},
			{ID: 0x0020, Name: "SyncLink SCC Adapter"},
			{ID: 0x0030, Name: "SyncLink Multiport Adapter"},
			{ID: 0x0070, Name: "SyncLink GT Adapter"},
			{ID: 0x0080, Name: "SyncLink GT4 Adapter"},
			{ID: 0x00a0, Name: "SyncLink GT2 Adapter"},
			{ID: 0x0210, Name: "SyncLink Adapter v2"},
		},
	},
	{
		ID: 0x13c1, Name: "3ware Inc", Devices: []Device{
			{ID: 0x1000, Name: "5xxx/6xxx-series PATA-RAID"},
			{ID: 0x1001, Name: "7xxx/8xxx-series PATA/SATA-RAID"},
			{ID: 0x1002, Name: "9xxx-series SATA-RAID"},
			{ID: 0x1003, Name: "9550SX SATA-II RAID PCI-X"},
			{ID: 0x1004, Name: "9650SE SATA-II RAID PCIe"},
			{ID: 0x1005, Name: "9690SA SAS/SATA-II RAID PCIe"},
			{ID: 0x1010, Name: "9750 SAS2/SATA-II RAID PCIe"},
		},
	},
	{
		ID: 0x13c2, Name: "Technotrend Systemtechnik GmbH", Devices: []Device{
			{ID: 0x000e, Name: "Technotrend/Hauppauge DVB card rev2.3"},
			{ID: 0x1019, Name: "TTechnoTrend-budget DVB S2-3200"},
		},
	},
	{ID: 0x13c3, Name: "Janz Computer AG", Devices: []Device{}},
	{ID: 0x13c4, Name: "Phase Metrics", Devices: []Device{}},
	{ID: 0x13c5, Name: "Alphi Technology Corp", Devices: []Device{}},
	{
		ID: 0x13c6, Name: "Condor Engineering Inc", Devices: []Device{
			{ID: 0x0520, Name: "CEI-520 A429 Card"},
			{ID: 0x0620, Name: "CEI-620 A429 Card"},
			{ID: 0x0820, Name: "CEI-820 A429 Card"},
			{ID: 0x0830, Name: "CEI-830 A429 Card"},
			{ID: 0x1004, Name: "P-SER Multi-channel PMC to RS-485/422/232 adapter"},
		},
	},
	{
		ID: 0x13c7, Name: "Blue Chip Technology Ltd", Devices: []Device{
			{ID: 0x0adc, Name: "PCI-ADC"},
			{ID: 0x0b10, Name: "PCI-PIO"},
			{ID: 0x0d10, Name: "PCI-DIO"},
			{ID: 0x524c, Name: "PCI-RLY"},
			{ID: 0x5744, Name: "PCI-WDT"},
		},
	},
	{ID: 0x13c8, Name: "Apptech Inc", Devices: []Device{}},
	{ID: 0x13c9, Name: "Eaton Corporation", Devices: []Device{}},
	{ID: 0x13ca, Name: "Iomega Corporation", Devices: []Device{}},
	{ID: 0x13cb, Name: "Yano Electric Co Ltd", Devices: []Device{}},
	{ID: 0x13cc, Name: "BARCO", Devices: []Device{}},
	{ID: 0x13cd, Name: "Compatible Systems Corporation", Devices: []Device{}},
	{ID: 0x13ce, Name: "Cocom A/S", Devices: []Device{}},
	{ID: 0x13cf, Name: "Studio Audio & Video Ltd", Devices: []Device{}},
	{
		ID: 0x13d0, Name: "Techsan Electronics Co Ltd", Devices: []Device{
			{ID: 0x2103, Name: "B2C2 FlexCopII DVB chip / Technisat SkyStar2 DVB card"},
			{ID: 0x2104, Name: "B2C2 FlexCopIII DVB chip / Technisat SkyStar2 DVB card (rev 01)"},
			{ID: 0x2200, Name: "B2C2 FlexCopIII DVB chip / Technisat SkyStar2 DVB card"},
		},
	},
	{
		ID: 0x13d1, Name: "Abocom Systems Inc", Devices: []Device{
			{ID: 0xab02, Name: "ADMtek Centaur-C rev 17 [D-Link DFE-680TX] CardBus Fast Ethernet Adapter"},
			{ID: 0xab03, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
			{ID: 0xab06, Name: "RTL8139 [FE2000VX] CardBus Fast Ethernet Attached Port Adapter"},
			{ID: 0xab08, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
		},
	},
	{ID: 0x13d2, Name: "Shark Multimedia Inc", Devices: []Device{}},
	{ID: 0x13d4, Name: "Graphics Microsystems Inc", Devices: []Device{}},
	{ID: 0x13d5, Name: "Media 100 Inc", Devices: []Device{}},
	{ID: 0x13d6, Name: "K.I. Technology Co Ltd", Devices: []Device{}},
	{ID: 0x13d7, Name: "Toshiba Engineering Corporation", Devices: []Device{}},
	{ID: 0x13d8, Name: "Phobos corporation", Devices: []Device{}},
	{ID: 0x13d9, Name: "Apex PC Solutions Inc", Devices: []Device{}},
	{ID: 0x13da, Name: "Intresource Systems pte Ltd", Devices: []Device{}},
	{ID: 0x13db, Name: "Janich & Klass Computertechnik GmbH", Devices: []Device{}},
	{ID: 0x13dc, Name: "Netboost Corporation", Devices: []Device{}},
	{ID: 0x13dd, Name: "Multimedia Bundle Inc", Devices: []Device{}},
	{ID: 0x13de, Name: "ABB Robotics Products AB", Devices: []Device{}},
	{
		ID: 0x13df, Name: "E-Tech Inc", Devices: []Device{
			{ID: 0x0001, Name: "PCI56RVP Modem"},
		},
	},
	{ID: 0x13e0, Name: "GVC Corporation", Devices: []Device{}},
	{ID: 0x13e1, Name: "Silicom Multimedia Systems Inc", Devices: []Device{}},
	{ID: 0x13e2, Name: "Dynamics Research Corporation", Devices: []Device{}},
	{ID: 0x13e3, Name: "Nest Inc", Devices: []Device{}},
	{ID: 0x13e4, Name: "Calculex Inc", Devices: []Device{}},
	{ID: 0x13e5, Name: "Telesoft Design Ltd", Devices: []Device{}},
	{ID: 0x13e6, Name: "Argosy research Inc", Devices: []Device{}},
	{ID: 0x13e7, Name: "NAC Incorporated", Devices: []Device{}},
	{ID: 0x13e8, Name: "Chip Express Corporation", Devices: []Device{}},
	{ID: 0x13e9, Name: "Intraserver Technology Inc", Devices: []Device{}},
	{ID: 0x13ea, Name: "Dallas Semiconductor", Devices: []Device{}},
	{ID: 0x13eb, Name: "Hauppauge Computer Works Inc", Devices: []Device{}},
	{
		ID: 0x13ec, Name: "Zydacron Inc", Devices: []Device{
			{ID: 0x000a, Name: "NPC-RC01 Remote control receiver"},
		},
	},
	{ID: 0x13ed, Name: "Raytheion E-Systems", Devices: []Device{}},
	{ID: 0x13ee, Name: "Hayes Microcomputer Products Inc", Devices: []Device{}},
	{ID: 0x13ef, Name: "Coppercom Inc", Devices: []Device{}},
	{
		ID: 0x13f0, Name: "Sundance Technology Inc / IC Plus Corp", Devices: []Device{
			{ID: 0x0200, Name: "IC Plus IP100A Integrated 10/100 Ethernet MAC + PHY"},
			{ID: 0x0201, Name: "ST201 Sundance Ethernet"},
			{ID: 0x1021, Name: "TC902x Gigabit Ethernet"},
			{ID: 0x1023, Name: "IP1000 Family Gigabit Ethernet"},
		},
	},
	{ID: 0x13f1, Name: "Oce' - Technologies B.V.", Devices: []Device{}},
	{ID: 0x13f2, Name: "Ford Microelectronics Inc", Devices: []Device{}},
	{ID: 0x13f3, Name: "Mcdata Corporation", Devices: []Device{}},
	{
		ID: 0x13f4, Name: "Troika Networks, Inc.", Devices: []Device{
			{ID: 0x1401, Name: "Zentai Fibre Channel Adapter"},
		},
	},
	{ID: 0x13f5, Name: "Kansai Electric Co. Ltd", Devices: []Device{}},
	{
		ID: 0x13f6, Name: "C-Media Electronics Inc", Devices: []Device{
			{ID: 0x0011, Name: "CMI8738"},
			{ID: 0x0100, Name: "CM8338A"},
			{ID: 0x0101, Name: "CM8338B"},
			{ID: 0x0111, Name: "CMI8738/CMI8768 PCI Audio"},
			{ID: 0x0211, Name: "CM8738"},
			{ID: 0x5011, Name: "CM8888 [Oxygen Express]"},
			{ID: 0x8788, Name: "CMI8788 [Oxygen HD Audio]"},
		},
	},
	{ID: 0x13f7, Name: "Wildfire Communications", Devices: []Device{}},
	{ID: 0x13f8, Name: "Ad Lib Multimedia Inc", Devices: []Device{}},
	{ID: 0x13f9, Name: "NTT Advanced Technology Corp.", Devices: []Device{}},
	{ID: 0x13fa, Name: "Pentland Systems Ltd", Devices: []Device{}},
	{ID: 0x13fb, Name: "Aydin Corp", Devices: []Device{}},
	{ID: 0x13fc, Name: "Computer Peripherals International", Devices: []Device{}},
	{ID: 0x13fd, Name: "Micro Science Inc", Devices: []Device{}},
	{
		ID: 0x13fe, Name: "Advantech Co. Ltd", Devices: []Device{
			{ID: 0x1240, Name: "PCI-1240 4-channel stepper motor controller card"},
			{ID: 0x1600, Name: "PCI-16xx series PCI multiport serial board (function 0)"},
			{ID: 0x1603, Name: "PCI-1603 2-port isolated RS-232/current loop"},
			{ID: 0x1604, Name: "PCI-1604 2-port RS-232"},
			{ID: 0x1680, Name: "PCI-1680 Rev.A1 2-port CAN-bus with isolation protection"},
			{ID: 0x16ff, Name: "PCI-16xx series PCI multiport serial board (function 1: RX/TX steering CPLD)"},
			{ID: 0x1711, Name: "PCI-1711 16-channel data acquisition card 12-bit, 100kS/s"},
			{ID: 0x1713, Name: "PCI-1713 32-channel isolated analog input card"},
			{ID: 0x1733, Name: "PCI-1733 32-channel isolated digital input card"},
			{ID: 0x1734, Name: "PCI-1734 32-channel isolated digital output card"},
			{ID: 0x1752, Name: "PCI-1752 64-channel Isolated Digital Output Card"},
			{ID: 0x1754, Name: "PCI-1754 64-channel Isolated Digital Input Card"},
			{ID: 0x1756, Name: "PCI-1756 64-ch Isolated Digital I/O PCI Card"},
			{ID: 0xa004, Name: "PCI-1612 4-port RS-232/422/485"},
			{ID: 0xc302, Name: "MIOe-3680 2-Port CAN-Bus MIOe Module with Isolation Protection"},
		},
	},
	{ID: 0x13ff, Name: "Silicon Spice Inc", Devices: []Device{}},
	{
		ID: 0x1400, Name: "Artx Inc", Devices: []Device{
			{ID: 0x1401, Name: "9432 TX"},
		},
	},
	{ID: 0x1401, Name: "CR-Systems A/S", Devices: []Device{}},
	{
		ID: 0x1402, Name: "Meilhaus Electronic GmbH", Devices: []Device{
			{ID: 0x0630, Name: "ME-630"},
			{ID: 0x0940, Name: "ME-94"},
			{ID: 0x0950, Name: "ME-95"},
			{ID: 0x0960, Name: "ME-96"},
			{ID: 0x1000, Name: "ME-1000"},
			{ID: 0x100a, Name: "ME-1000"},
			{ID: 0x100b, Name: "ME-1000"},
			{ID: 0x1400, Name: "ME-1400"},
			{ID: 0x140a, Name: "ME-1400A"},
			{ID: 0x140b, Name: "ME-1400B"},
			{ID: 0x140c, Name: "ME-1400C"},
			{ID: 0x140d, Name: "ME-1400D"},
			{ID: 0x140e, Name: "ME-1400E"},
			{ID: 0x14ea, Name: "ME-1400EA"},
			{ID: 0x14eb, Name: "ME-1400EB"},
			{ID: 0x1604, Name: "ME-1600/4U"},
			{ID: 0x1608, Name: "ME-1600/8U"},
			{ID: 0x160c, Name: "ME-1600/12U"},
			{ID: 0x160f, Name: "ME-1600/16U"},
			{ID: 0x168f, Name: "ME-1600/16U8I"},
			{ID: 0x4610, Name: "ME-4610"},
			{ID: 0x4650, Name: "ME-4650"},
			{ID: 0x4660, Name: "ME-4660"},
			{ID: 0x4661, Name: "ME-4660I"},
			{ID: 0x4662, Name: "ME-4660"},
			{ID: 0x4663, Name: "ME-4660I"},
			{ID: 0x4670, Name: "ME-4670"},
			{ID: 0x4671, Name: "ME-4670I"},
			{ID: 0x4672, Name: "ME-4670S"},
			{ID: 0x4673, Name: "ME-4670IS"},
			{ID: 0x4680, Name: "ME-4680"},
			{ID: 0x4681, Name: "ME-4680I"},
			{ID: 0x4682, Name: "ME-4680S"},
			{ID: 0x4683, Name: "ME-4680IS"},
			{ID: 0x6004, Name: "ME-6000/4"},
			{ID: 0x6008, Name: "ME-6000/8"},
			{ID: 0x600f, Name: "ME-6000/16"},
			{ID: 0x6014, Name: "ME-6000I/4"},
			{ID: 0x6018, Name: "ME-6000I/8"},
			{ID: 0x601f, Name: "ME-6000I/16"},
			{ID: 0x6034, Name: "ME-6000ISLE/4"},
			{ID: 0x6038, Name: "ME-6000ISLE/8"},
			{ID: 0x603f, Name: "ME-6000ISLE/16"},
			{ID: 0x6044, Name: "ME-6000/4/DIO"},
			{ID: 0x6048, Name: "ME-6000/8/DIO"},
			{ID: 0x604f, Name: "ME-6000/16/DIO"},
			{ID: 0x6054, Name: "ME-6000I/4/DIO"},
			{ID: 0x6058, Name: "ME-6000I/8/DIO"},
			{ID: 0x605f, Name: "ME-6000I/16/DIO"},
			{ID: 0x6074, Name: "ME-6000ISLE/4/DIO"},
			{ID: 0x6078, Name: "ME-6000ISLE/8/DIO"},
			{ID: 0x607f, Name: "ME-6000ISLE/16/DIO"},
			{ID: 0x6104, Name: "ME-6100/4"},
			{ID: 0x6108, Name: "ME-6100/8"},
			{ID: 0x610f, Name: "ME-6100/16"},
			{ID: 0x6114, Name: "ME-6100I/4"},
			{ID: 0x6118, Name: "ME-6100I/8"},
			{ID: 0x611f, Name: "ME-6100I/16"},
			{ID: 0x6134, Name: "ME-6100ISLE/4"},
			{ID: 0x6138, Name: "ME-6100ISLE/8"},
			{ID: 0x613f, Name: "ME-6100ISLE/16"},
			{ID: 0x6144, Name: "ME-6100/4/DIO"},
			{ID: 0x6148, Name: "ME-6100/8/DIO"},
			{ID: 0x614f, Name: "ME-6100/16/DIO"},
			{ID: 0x6154, Name: "ME-6100I/4/DIO"},
			{ID: 0x6158, Name: "ME-6100I/8/DIO"},
			{ID: 0x615f, Name: "ME-6100I/16/DIO"},
			{ID: 0x6174, Name: "ME-6100ISLE/4/DIO"},
			{ID: 0x6178, Name: "ME-6100ISLE/8/DIO"},
			{ID: 0x617f, Name: "ME-6100ISLE/16/DIO"},
			{ID: 0x6259, Name: "ME-6200I/9/DIO"},
			{ID: 0x6359, Name: "ME-6300I/9/DIO"},
			{ID: 0x810a, Name: "ME-8100A"},
			{ID: 0x810b, Name: "ME-8100B"},
			{ID: 0x820a, Name: "ME-8200A"},
			{ID: 0x820b, Name: "ME-8200B"},
		},
	},
	{ID: 0x1403, Name: "Ascor Inc", Devices: []Device{}},
	{ID: 0x1404, Name: "Fundamental Software Inc", Devices: []Device{}},
	{ID: 0x1405, Name: "Excalibur Systems Inc", Devices: []Device{}},
	{ID: 0x1406, Name: "Oce' Printing Systems GmbH", Devices: []Device{}},
	{
		ID: 0x1407, Name: "Lava Computer mfg Inc", Devices: []Device{
			{ID: 0x0100, Name: "Lava Dual Serial"},
			{ID: 0x0101, Name: "Lava Quatro A"},
			{ID: 0x0102, Name: "Lava Quatro B"},
			{ID: 0x0110, Name: "Lava DSerial-PCI Port A"},
			{ID: 0x0111, Name: "Lava DSerial-PCI Port B"},
			{ID: 0x0120, Name: "Quattro-PCI A"},
			{ID: 0x0121, Name: "Quattro-PCI B"},
			{ID: 0x0180, Name: "Lava Octo A"},
			{ID: 0x0181, Name: "Lava Octo B"},
			{ID: 0x0200, Name: "Lava Port Plus"},
			{ID: 0x0201, Name: "Lava Quad A"},
			{ID: 0x0202, Name: "Lava Quad B"},
			{ID: 0x0220, Name: "Lava Quattro PCI Ports A/B"},
			{ID: 0x0221, Name: "Lava Quattro PCI Ports C/D"},
			{ID: 0x0400, Name: "Lava 8255-PIO-PCI"},
			{ID: 0x0500, Name: "Lava Single Serial"},
			{ID: 0x0520, Name: "Lava RS422-SS-PCI"},
			{ID: 0x0600, Name: "Lava Port 650"},
			{ID: 0x8000, Name: "Lava Parallel"},
			{ID: 0x8001, Name: "Dual parallel port controller A"},
			{ID: 0x8002, Name: "Lava Dual Parallel port A"},
			{ID: 0x8003, Name: "Lava Dual Parallel port B"},
			{ID: 0x8800, Name: "BOCA Research IOPPAR"},
		},
	},
	{ID: 0x1408, Name: "Aloka Co. Ltd", Devices: []Device{}},
	{
		ID: 0x1409, Name: "Timedia Technology Co Ltd", Devices: []Device{
			{ID: 0x7168, Name: "PCI2S550 (Dual 16550 UART)"},
			{ID: 0x7268, Name: "SUN1888 (Dual IEEE1284 parallel port)"},
		},
	},
	{ID: 0x140a, Name: "DSP Research Inc", Devices: []Device{}},
	{ID: 0x140b, Name: "Abaco Systems, Inc.", Devices: []Device{}},
	{ID: 0x140c, Name: "Elmic Systems Inc", Devices: []Device{}},
	{ID: 0x140d, Name: "Matsushita Electric Works Ltd", Devices: []Device{}},
	{ID: 0x140e, Name: "Goepel Electronic GmbH", Devices: []Device{}},
	{ID: 0x140f, Name: "Salient Systems Corp", Devices: []Device{}},
	{ID: 0x1410, Name: "Midas lab Inc", Devices: []Device{}},
	{ID: 0x1411, Name: "Ikos Systems Inc", Devices: []Device{}},
	{
		ID: 0x1412, Name: "VIA Technologies Inc.", Devices: []Device{
			{ID: 0x1712, Name: "ICE1712 [Envy24] PCI Multi-Channel I/O Controller"},
			{ID: 0x1724, Name: "VT1720/24 [Envy24PT/HT] PCI Multi-Channel Audio Controller"},
		},
	},
	{ID: 0x1413, Name: "Addonics", Devices: []Device{}},
	{
		ID: 0x1414, Name: "Microsoft Corporation", Devices: []Device{
			{ID: 0x0001, Name: "MN-120 (ADMtek Centaur-C based)"},
			{ID: 0x0002, Name: "MN-130 (ADMtek Centaur-P based)"},
			{ID: 0x008c, Name: "Basic Render Driver"},
			{ID: 0x5353, Name: "Hyper-V virtual VGA"},
			{ID: 0x5801, Name: "XMA Decoder (Xenon)"},
			{ID: 0x5802, Name: "SATA Controller - CdRom (Xenon)"},
			{ID: 0x5803, Name: "SATA Controller - Disk (Xenon)"},
			{ID: 0x5804, Name: "OHCI Controller 0 (Xenon)"},
			{ID: 0x5805, Name: "EHCI Controller 0 (Xenon)"},
			{ID: 0x5806, Name: "OHCI Controller 1 (Xenon)"},
			{ID: 0x5807, Name: "EHCI Controller 1 (Xenon)"},
			{ID: 0x580a, Name: "Fast Ethernet Adapter (Xenon)"},
			{ID: 0x580b, Name: "Secure Flash Controller (Xenon)"},
			{ID: 0x580d, Name: "System Management Controller (Xenon)"},
			{ID: 0x5811, Name: "Xenos GPU (Xenon)"},
		},
	},
	{
		ID: 0x1415, Name: "Oxford Semiconductor Ltd", Devices: []Device{
			{ID: 0x8401, Name: "OX9162 Mode 1 (8-bit bus)"},
			{ID: 0x8403, Name: "OX9162 Mode 0 (parallel port)"},
			{ID: 0x9500, Name: "OX16PCI954 (Quad 16950 UART) function 0 (Disabled)"},
			{ID: 0x9501, Name: "OX16PCI954 (Quad 16950 UART) function 0 (Uart)"},
			{ID: 0x9505, Name: "OXuPCI952 (Dual 16C950 UART)"},
			{ID: 0x950a, Name: "EXSYS EX-41092 Dual 16950 Serial adapter"},
			{ID: 0x950b, Name: "OXCB950 Cardbus 16950 UART"},
			{ID: 0x9510, Name: "OX16PCI954 (Quad 16950 UART) function 1 (Disabled)"},
			{ID: 0x9511, Name: "OX16PCI954 (Quad 16950 UART) function 1 (8bit bus)"},
			{ID: 0x9512, Name: "OX16PCI954 (Quad 16950 UART) function 1 (32bit bus)"},
			{ID: 0x9513, Name: "OX16PCI954 (Quad 16950 UART) function 1 (parallel port)"},
			{ID: 0x9521, Name: "OX16PCI952 (Dual 16950 UART)"},
			{ID: 0x9523, Name: "OX16PCI952 Integrated Parallel Port"},
			{ID: 0xc000, Name: "OXPCIe840 Parallel Port"},
			{ID: 0xc004, Name: "OXPCIe840 Parallel Port"},
			{ID: 0xc006, Name: "OXPCIe840 GPIO"},
			{ID: 0xc100, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc101, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc104, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc105, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc106, Name: "OXPCIe952 GPIO"},
			{ID: 0xc108, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc109, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc10c, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc10d, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc10e, Name: "OXPCIe952 GPIO"},
			{ID: 0xc110, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc114, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc118, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc11b, Name: "OXPCIe952 Native 950 UART"},
			{ID: 0xc11c, Name: "OXPCIe952 Parallel Port"},
			{ID: 0xc11e, Name: "OXPCIe952 GPIO"},
			{ID: 0xc11f, Name: "OXPCIe952 Native 950 UART"},
			{ID: 0xc120, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc124, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc126, Name: "OXPCIe952 GPIO"},
			{ID: 0xc128, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc12c, Name: "OXPCIe952 Legacy 950 UART"},
			{ID: 0xc12e, Name: "OXPCIe952 GPIO"},
			{ID: 0xc134, Name: "OXPCIe952 GPIO"},
			{ID: 0xc138, Name: "OXPCIe952 Native 950 UART"},
			{ID: 0xc13c, Name: "OXPCIe952 GPIO"},
			{ID: 0xc13d, Name: "OXPCIe952 Native 950 UART"},
			{ID: 0xc140, Name: "OXPCIe952 Legacy 950 UART #1"},
			{ID: 0xc141, Name: "OXPCIe952 Legacy 950 UART #2"},
			{ID: 0xc144, Name: "OXPCIe952 Legacy 950 UART #1"},
			{ID: 0xc145, Name: "OXPCIe952 Legacy 950 UART #2"},
			{ID: 0xc146, Name: "OXPCIe952 GPIO"},
			{ID: 0xc148, Name: "OXPCIe952 Legacy 950 UART #1"},
			{ID: 0xc149, Name: "OXPCIe952 Legacy 950 UART #2"},
			{ID: 0xc14c, Name: "OXPCIe952 Legacy 950 UART #1"},
			{ID: 0xc14d, Name: "OXPCIe952 Legacy 950 UART #2"},
			{ID: 0xc14e, Name: "OXPCIe952 GPIO"},
			{ID: 0xc154, Name: "OXPCIe952 GPIO"},
			{ID: 0xc158, Name: "OXPCIe952 Dual Native 950 UART"},
			{ID: 0xc15c, Name: "OXPCIe952 GPIO"},
			{ID: 0xc15d, Name: "OXPCIe952 Dual Native 950 UART"},
			{ID: 0xc204, Name: "OXPCIe954 GPIO"},
			{ID: 0xc208, Name: "OXPCIe954 Quad Native 950 UART"},
			{ID: 0xc20c, Name: "OXPCIe954 GPIO"},
			{ID: 0xc20d, Name: "OXPCIe954 Quad Native 950 UART"},
			{ID: 0xc304, Name: "OXPCIe958 GPIO"},
			{ID: 0xc308, Name: "OXPCIe958 Quad Native 950 UART"},
			{ID: 0xc30c, Name: "OXPCIe958 GPIO"},
			{ID: 0xc30d, Name: "OXPCIe958 Quad Native 950 UART"},
			{ID: 0xc530, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc531, Name: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc534, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc535, Name: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc536, Name: "OXPCIe200 GPIO"},
			{ID: 0xc538, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc539, Name: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc53b, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc53c, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc53d, Name: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)"},
			{ID: 0xc53e, Name: "OXPCIe200 GPIO"},
			{ID: 0xc53f, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc540, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)"},
			{ID: 0xc541, Name: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)"},
			{ID: 0xc544, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)"},
			{ID: 0xc545, Name: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)"},
			{ID: 0xc546, Name: "OXPCIe200 GPIO"},
			{ID: 0xc548, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)"},
			{ID: 0xc549, Name: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)"},
			{ID: 0xc54b, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc54c, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)"},
			{ID: 0xc54d, Name: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)"},
			{ID: 0xc54e, Name: "OXPCIe200 Dual GPIO"},
			{ID: 0xc54f, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc560, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)"},
			{ID: 0xc561, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc564, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)"},
			{ID: 0xc565, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc566, Name: "OXPCIe200 GPIO"},
			{ID: 0xc568, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)"},
			{ID: 0xc569, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc56b, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc56c, Name: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)"},
			{ID: 0xc56d, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc56e, Name: "OXPCIe200 GPIO"},
			{ID: 0xc56f, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc570, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)"},
			{ID: 0xc571, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc574, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)"},
			{ID: 0xc575, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc576, Name: "OXPCIe200 GPIO"},
			{ID: 0xc578, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)"},
			{ID: 0xc579, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc57b, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc57c, Name: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)"},
			{ID: 0xc57d, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc57e, Name: "OXPCIe200 GPIO"},
			{ID: 0xc57f, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc5a0, Name: "OXPCIe200 OHCI USB Controller (ULPI)"},
			{ID: 0xc5a1, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc5a2, Name: "OXPCIe200 Programmable Memory Interface"},
			{ID: 0xc5a4, Name: "OXPCIe200 OHCI USB Controller (ULPI)"},
			{ID: 0xc5a5, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc5a6, Name: "OXPCIe200 Programmable Memory Interface & GPIO"},
			{ID: 0xc5a8, Name: "OXPCIe200 OHCI USB Controller (ULPI)"},
			{ID: 0xc5a9, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc5aa, Name: "OXPCIe200 Programmable Memory Interface"},
			{ID: 0xc5ab, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc5ac, Name: "OXPCIe200 OHCI USB Controller (ULPI)"},
			{ID: 0xc5ad, Name: "OXPCIe200 EHCI USB Controller (ULPI)"},
			{ID: 0xc5ae, Name: "OXPCIe200 Programmable Memory Interface & GPIO"},
			{ID: 0xc5af, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc5b0, Name: "OXPCIe200 OHCI USB Controller (R-ULPI)"},
			{ID: 0xc5b1, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc5b2, Name: "OXPCIe200 Programmable Memory Interface"},
			{ID: 0xc5b4, Name: "OXPCIe200 OHCI USB Controller (R-ULPI)"},
			{ID: 0xc5b5, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc5b6, Name: "OXPCIe200 Programmable Memory Interface & GPIO"},
			{ID: 0xc5b8, Name: "OXPCIe200 OHCI USB Controller (R-ULPI)"},
			{ID: 0xc5b9, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc5ba, Name: "OXPCIe200 Programmable Memory Interface"},
			{ID: 0xc5bb, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc5bc, Name: "OXPCIe200 OHCI USB Controller (R-ULPI)"},
			{ID: 0xc5bd, Name: "OXPCIe200 EHCI USB Controller (R-ULPI)"},
			{ID: 0xc5be, Name: "OXPCIe200 Programmable Memory Interface & GPIO"},
			{ID: 0xc5bf, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc5c0, Name: "OXPCIe200 OHCI USB Controller (analog)"},
			{ID: 0xc5c2, Name: "OXPCIe200 Programmable Memory Interface"},
			{ID: 0xc5c4, Name: "OXPCIe200 OHCI USB Controller (analog)"},
			{ID: 0xc5c6, Name: "OXPCIe200 Programmable Memory Interface & GPIO"},
			{ID: 0xc5c8, Name: "OXPCIe200 OHCI USB Controller (analog)"},
			{ID: 0xc5ca, Name: "OXPCIe200 Programmable Memory Interface"},
			{ID: 0xc5cb, Name: "OXPCIe200 Native 950 UART"},
			{ID: 0xc5cc, Name: "OXPCIe200 OHCI USB Controller (analog)"},
			{ID: 0xc5ce, Name: "OXPCIe200 Programmable Memory Interface & GPIO"},
			{ID: 0xc5cf, Name: "OXPCIe200 Native 950 UART"},
		},
	},
	{ID: 0x1416, Name: "Multiwave Innovation pte Ltd", Devices: []Device{}},
	{ID: 0x1417, Name: "Convergenet Technologies Inc", Devices: []Device{}},
	{ID: 0x1418, Name: "Kyushu electronics systems Inc", Devices: []Device{}},
	{ID: 0x1419, Name: "Excel Switching Corp", Devices: []Device{}},
	{ID: 0x141a, Name: "Apache Micro Peripherals Inc", Devices: []Device{}},
	{ID: 0x141b, Name: "Zoom Telephonics Inc", Devices: []Device{}},
	{ID: 0x141d, Name: "Digitan Systems Inc", Devices: []Device{}},
	{ID: 0x141e, Name: "Fanuc Ltd", Devices: []Device{}},
	{ID: 0x141f, Name: "Visiontech Ltd", Devices: []Device{}},
	{
		ID: 0x1420, Name: "Psion Dacom plc", Devices: []Device{
			{ID: 0x8002, Name: "Gold Card NetGlobal 56k+10/100Mb CardBus (Ethernet part)"},
			{ID: 0x8003, Name: "Gold Card NetGlobal 56k+10/100Mb CardBus (Modem part)"},
		},
	},
	{ID: 0x1421, Name: "Ads Technologies Inc", Devices: []Device{}},
	{ID: 0x1422, Name: "Ygrec Systems Co Ltd", Devices: []Device{}},
	{ID: 0x1423, Name: "Custom Technology Corp.", Devices: []Device{}},
	{ID: 0x1424, Name: "Videoserver Connections", Devices: []Device{}},
	{
		ID: 0x1425, Name: "Chelsio Communications Inc", Devices: []Device{
			{ID: 0x000b, Name: "T210 Protocol Engine"},
			{ID: 0x000c, Name: "T204 Protocol Engine"},
			{ID: 0x0022, Name: "10GbE Ethernet Adapter"},
			{ID: 0x0030, Name: "T310 10GbE Single Port Adapter"},
			{ID: 0x0031, Name: "T320 10GbE Dual Port Adapter"},
			{ID: 0x0032, Name: "T302 1GbE Dual Port Adapter"},
			{ID: 0x0033, Name: "T304 1GbE Quad Port Adapter"},
			{ID: 0x0034, Name: "B320 10GbE Dual Port Adapter"},
			{ID: 0x0035, Name: "S310-CR 10GbE Single Port Adapter"},
			{ID: 0x0036, Name: "S320-LP-CR 10GbE Dual Port Adapter"},
			{ID: 0x0037, Name: "N320-G2-CR 10GbE Dual Port Adapter"},
			{ID: 0x4001, Name: "T420-CR Unified Wire Ethernet Controller"},
			{ID: 0x4002, Name: "T422-CR Unified Wire Ethernet Controller"},
			{ID: 0x4003, Name: "T440-CR Unified Wire Ethernet Controller"},
			{ID: 0x4004, Name: "T420-BCH Unified Wire Ethernet Controller"},
			{ID: 0x4005, Name: "T440-BCH Unified Wire Ethernet Controller"},
			{ID: 0x4006, Name: "T440-CH Unified Wire Ethernet Controller"},
			{ID: 0x4007, Name: "T420-SO Unified Wire Ethernet Controller"},
			{ID: 0x4008, Name: "T420-CX Unified Wire Ethernet Controller"},
			{ID: 0x4009, Name: "T420-BT Unified Wire Ethernet Controller"},
			{ID: 0x400a, Name: "T404-BT Unified Wire Ethernet Controller"},
			{ID: 0x400b, Name: "B420-SR Unified Wire Ethernet Controller"},
			{ID: 0x400c, Name: "B404-BT Unified Wire Ethernet Controller"},
			{ID: 0x400d, Name: "T480 Unified Wire Ethernet Controller"},
			{ID: 0x400e, Name: "T440-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x400f, Name: "T440 [Amsterdam] Unified Wire Ethernet Controller"},
			{ID: 0x4080, Name: "T480-4080 T480 Unified Wire Ethernet Controller"},
			{ID: 0x4081, Name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller"},
			{ID: 0x4082, Name: "T420-4082  Unified Wire Ethernet Controller"},
			{ID: 0x4083, Name: "T420X-4083 Unified Wire Ethernet Controller"},
			{ID: 0x4084, Name: "T440-4084 Unified Wire Ethernet Controller"},
			{ID: 0x4085, Name: "T420-4085 SFP+ Unified Wire Ethernet Controller"},
			{ID: 0x4086, Name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller"},
			{ID: 0x4087, Name: "T440T-4087 Unified Wire Ethernet Controller"},
			{ID: 0x4088, Name: "T440-4088 Unified Wire Ethernet Controller"},
			{ID: 0x4401, Name: "T420-CR Unified Wire Ethernet Controller"},
			{ID: 0x4402, Name: "T422-CR Unified Wire Ethernet Controller"},
			{ID: 0x4403, Name: "T440-CR Unified Wire Ethernet Controller"},
			{ID: 0x4404, Name: "T420-BCH Unified Wire Ethernet Controller"},
			{ID: 0x4405, Name: "T440-BCH Unified Wire Ethernet Controller"},
			{ID: 0x4406, Name: "T440-CH Unified Wire Ethernet Controller"},
			{ID: 0x4407, Name: "T420-SO Unified Wire Ethernet Controller"},
			{ID: 0x4408, Name: "T420-CX Unified Wire Ethernet Controller"},
			{ID: 0x4409, Name: "T420-BT Unified Wire Ethernet Controller"},
			{ID: 0x440a, Name: "T404-BT Unified Wire Ethernet Controller"},
			{ID: 0x440b, Name: "B420-SR Unified Wire Ethernet Controller"},
			{ID: 0x440c, Name: "B404-BT Unified Wire Ethernet Controller"},
			{ID: 0x440d, Name: "T480 Unified Wire Ethernet Controller"},
			{ID: 0x440e, Name: "T440-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x440f, Name: "T440 [Amsterdam] Unified Wire Ethernet Controller"},
			{ID: 0x4480, Name: "T480-4080 T480 Unified Wire Ethernet Controller"},
			{ID: 0x4481, Name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller"},
			{ID: 0x4482, Name: "T420-4082  Unified Wire Ethernet Controller"},
			{ID: 0x4483, Name: "T420X-4083 Unified Wire Ethernet Controller"},
			{ID: 0x4484, Name: "T440-4084 Unified Wire Ethernet Controller"},
			{ID: 0x4485, Name: "T420-4085 SFP+ Unified Wire Ethernet Controller"},
			{ID: 0x4486, Name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller"},
			{ID: 0x4487, Name: "T440T-4087 Unified Wire Ethernet Controller"},
			{ID: 0x4488, Name: "T440-4088 Unified Wire Ethernet Controller"},
			{ID: 0x4501, Name: "T420-CR Unified Wire Storage Controller"},
			{ID: 0x4502, Name: "T422-CR Unified Wire Storage Controller"},
			{ID: 0x4503, Name: "T440-CR Unified Wire Storage Controller"},
			{ID: 0x4504, Name: "T420-BCH Unified Wire Storage Controller"},
			{ID: 0x4505, Name: "T440-BCH Unified Wire Storage Controller"},
			{ID: 0x4506, Name: "T440-CH Unified Wire Storage Controller"},
			{ID: 0x4507, Name: "T420-SO Unified Wire Storage Controller"},
			{ID: 0x4508, Name: "T420-CX Unified Wire Storage Controller"},
			{ID: 0x4509, Name: "T420-BT Unified Wire Storage Controller"},
			{ID: 0x450a, Name: "T404-BT Unified Wire Storage Controller"},
			{ID: 0x450b, Name: "B420-SR Unified Wire Storage Controller"},
			{ID: 0x450c, Name: "B404-BT Unified Wire Storage Controller"},
			{ID: 0x450d, Name: "T480 Unified Wire Storage Controller"},
			{ID: 0x450e, Name: "T440-LP-CR Unified Wire Storage Controller"},
			{ID: 0x450f, Name: "T440 [Amsterdam] Unified Wire Storage Controller"},
			{ID: 0x4580, Name: "T480-4080 T480 Unified Wire Storage Controller"},
			{ID: 0x4581, Name: "T440F-4081 T440-FCoE Unified Wire Storage Controller"},
			{ID: 0x4582, Name: "T420-4082  Unified Wire Storage Controller"},
			{ID: 0x4583, Name: "T420X-4083 Unified Wire Storage Controller"},
			{ID: 0x4584, Name: "T440-4084 Unified Wire Storage Controller"},
			{ID: 0x4585, Name: "T420-4085 SFP+ Unified Wire Storage Controller"},
			{ID: 0x4586, Name: "T440-4086 10Gbase-T Unified Wire Storage Controller"},
			{ID: 0x4587, Name: "T440T-4087 Unified Wire Storage Controller"},
			{ID: 0x4588, Name: "T440-4088 Unified Wire Storage Controller"},
			{ID: 0x4601, Name: "T420-CR Unified Wire Storage Controller"},
			{ID: 0x4602, Name: "T422-CR Unified Wire Storage Controller"},
			{ID: 0x4603, Name: "T440-CR Unified Wire Storage Controller"},
			{ID: 0x4604, Name: "T420-BCH Unified Wire Storage Controller"},
			{ID: 0x4605, Name: "T440-BCH Unified Wire Storage Controller"},
			{ID: 0x4606, Name: "T440-CH Unified Wire Storage Controller"},
			{ID: 0x4607, Name: "T420-SO Unified Wire Storage Controller"},
			{ID: 0x4608, Name: "T420-CX Unified Wire Storage Controller"},
			{ID: 0x4609, Name: "T420-BT Unified Wire Storage Controller"},
			{ID: 0x460a, Name: "T404-BT Unified Wire Storage Controller"},
			{ID: 0x460b, Name: "B420-SR Unified Wire Storage Controller"},
			{ID: 0x460c, Name: "B404-BT Unified Wire Storage Controller"},
			{ID: 0x460d, Name: "T480 Unified Wire Storage Controller"},
			{ID: 0x460e, Name: "T440-LP-CR Unified Wire Storage Controller"},
			{ID: 0x460f, Name: "T440 [Amsterdam] Unified Wire Storage Controller"},
			{ID: 0x4680, Name: "T480-4080 T480 Unified Wire Storage Controller"},
			{ID: 0x4681, Name: "T440F-4081 T440-FCoE Unified Wire Storage Controller"},
			{ID: 0x4682, Name: "T420-4082  Unified Wire Storage Controller"},
			{ID: 0x4683, Name: "T420X-4083 Unified Wire Storage Controller"},
			{ID: 0x4684, Name: "T440-4084 Unified Wire Storage Controller"},
			{ID: 0x4685, Name: "T420-4085 SFP+ Unified Wire Storage Controller"},
			{ID: 0x4686, Name: "T440-4086 10Gbase-T Unified Wire Storage Controller"},
			{ID: 0x4687, Name: "T440T-4087 Unified Wire Storage Controller"},
			{ID: 0x4688, Name: "T440-4088 Unified Wire Storage Controller"},
			{ID: 0x4701, Name: "T420-CR Unified Wire Ethernet Controller"},
			{ID: 0x4702, Name: "T422-CR Unified Wire Ethernet Controller"},
			{ID: 0x4703, Name: "T440-CR Unified Wire Ethernet Controller"},
			{ID: 0x4704, Name: "T420-BCH Unified Wire Ethernet Controller"},
			{ID: 0x4705, Name: "T440-BCH Unified Wire Ethernet Controller"},
			{ID: 0x4706, Name: "T440-CH Unified Wire Ethernet Controller"},
			{ID: 0x4707, Name: "T420-SO Unified Wire Ethernet Controller"},
			{ID: 0x4708, Name: "T420-CX Unified Wire Ethernet Controller"},
			{ID: 0x4709, Name: "T420-BT Unified Wire Ethernet Controller"},
			{ID: 0x470a, Name: "T404-BT Unified Wire Ethernet Controller"},
			{ID: 0x470b, Name: "B420-SR Unified Wire Ethernet Controller"},
			{ID: 0x470c, Name: "B404-BT Unified Wire Ethernet Controller"},
			{ID: 0x470d, Name: "T480 Unified Wire Ethernet Controller"},
			{ID: 0x470e, Name: "T440-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x470f, Name: "T440 [Amsterdam] Unified Wire Ethernet Controller"},
			{ID: 0x4780, Name: "T480-4080 T480 Unified Wire Ethernet Controller"},
			{ID: 0x4781, Name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller"},
			{ID: 0x4782, Name: "T420-4082  Unified Wire Ethernet Controller"},
			{ID: 0x4783, Name: "T420X-4083 Unified Wire Ethernet Controller"},
			{ID: 0x4784, Name: "T440-4084 Unified Wire Ethernet Controller"},
			{ID: 0x4785, Name: "T420-4085 SFP+ Unified Wire Ethernet Controller"},
			{ID: 0x4786, Name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller"},
			{ID: 0x4787, Name: "T440T-4087 Unified Wire Ethernet Controller"},
			{ID: 0x4788, Name: "T440-4088 Unified Wire Ethernet Controller"},
			{ID: 0x4801, Name: "T420-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4802, Name: "T422-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4803, Name: "T440-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4804, Name: "T420-BCH Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4805, Name: "T440-BCH Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4806, Name: "T440-CH Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4807, Name: "T420-SO Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4808, Name: "T420-CX Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4809, Name: "T420-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x480a, Name: "T404-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x480b, Name: "B420-SR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x480c, Name: "B404-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x480d, Name: "T480 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x480e, Name: "T440-LP-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x480f, Name: "T440 [Amsterdam] Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4880, Name: "T480-4080 T480 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4881, Name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4882, Name: "T420-4082 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4883, Name: "T420X-4083 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4884, Name: "T440-4084 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4885, Name: "T420-4085 SFP+ Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4886, Name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4887, Name: "T440T-4087 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x4888, Name: "T440-4088 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5001, Name: "T520-CR Unified Wire Ethernet Controller"},
			{ID: 0x5002, Name: "T522-CR Unified Wire Ethernet Controller"},
			{ID: 0x5003, Name: "T540-CR Unified Wire Ethernet Controller"},
			{ID: 0x5004, Name: "T520-BCH Unified Wire Ethernet Controller"},
			{ID: 0x5005, Name: "T540-BCH Unified Wire Ethernet Controller"},
			{ID: 0x5006, Name: "T540-CH Unified Wire Ethernet Controller"},
			{ID: 0x5007, Name: "T520-SO Unified Wire Ethernet Controller"},
			{ID: 0x5008, Name: "T520-CX Unified Wire Ethernet Controller"},
			{ID: 0x5009, Name: "T520-BT Unified Wire Ethernet Controller"},
			{ID: 0x500a, Name: "T504-BT Unified Wire Ethernet Controller"},
			{ID: 0x500b, Name: "B520-SR Unified Wire Ethernet Controller"},
			{ID: 0x500c, Name: "B504-BT Unified Wire Ethernet Controller"},
			{ID: 0x500d, Name: "T580-CR Unified Wire Ethernet Controller"},
			{ID: 0x500e, Name: "T540-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x500f, Name: "T540 [Amsterdam] Unified Wire Ethernet Controller"},
			{ID: 0x5010, Name: "T580-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x5011, Name: "T520-LL-CR Unified Wire Ethernet Controller"},
			{ID: 0x5012, Name: "T560-CR Unified Wire Ethernet Controller"},
			{ID: 0x5013, Name: "T580-CHR Unified Wire Ethernet Controller"},
			{ID: 0x5014, Name: "T580-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x5015, Name: "T502-BT Unified Wire Ethernet Controller"},
			{ID: 0x5016, Name: "T580-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x5017, Name: "T520-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x5018, Name: "T540-BT Unified Wire Ethernet Controller"},
			{ID: 0x5019, Name: "T540-LP-BT Unified Wire Ethernet Controller"},
			{ID: 0x501a, Name: "T540-SO-BT Unified Wire Ethernet Controller"},
			{ID: 0x501b, Name: "T540-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x5080, Name: "T540-5080 Unified Wire Ethernet Controller"},
			{ID: 0x5081, Name: "T540-5081 Unified Wire Ethernet Controller"},
			{ID: 0x5082, Name: "T504-5082 Unified Wire Ethernet Controller"},
			{ID: 0x5083, Name: "T540-5083 Unified Wire Ethernet Controller"},
			{ID: 0x5084, Name: "T540-5084 Unified Wire Ethernet Controller"},
			{ID: 0x5085, Name: "T580-5085 Unified Wire Ethernet Controller"},
			{ID: 0x5086, Name: "T580-5086 Unified Wire Ethernet Controller"},
			{ID: 0x5087, Name: "T580-5087 Unified Wire Ethernet Controller"},
			{ID: 0x5088, Name: "T570-5088 Unified Wire Ethernet Controller"},
			{ID: 0x5089, Name: "T520-5089 Unified Wire Ethernet Controller"},
			{ID: 0x5090, Name: "T540-5090 Unified Wire Ethernet Controller"},
			{ID: 0x5091, Name: "T522-5091 Unified Wire Ethernet Controller"},
			{ID: 0x5092, Name: "T520-5092 Unified Wire Ethernet Controller"},
			{ID: 0x5093, Name: "T580-5093 Unified Wire Ethernet Controller"},
			{ID: 0x5094, Name: "T540-5094 Unified Wire Ethernet Controller"},
			{ID: 0x5095, Name: "T540-5095 Unified Wire Ethernet Controller"},
			{ID: 0x5096, Name: "T580-5096 Unified Wire Ethernet Controller"},
			{ID: 0x5097, Name: "T520-5097 Unified Wire Ethernet Controller"},
			{ID: 0x5098, Name: "T580-5098 Unified Wire Ethernet Controller"},
			{ID: 0x5099, Name: "T580-5099 Unified Wire Ethernet Controller"},
			{ID: 0x509a, Name: "T520-509A Unified Wire Ethernet Controller"},
			{ID: 0x509b, Name: "T540-509B Unified Wire Ethernet Controller"},
			{ID: 0x509c, Name: "T520-509C Unified Wire Ethernet Controller"},
			{ID: 0x509d, Name: "T540-509D Unified Wire Ethernet Controller"},
			{ID: 0x509e, Name: "T520-509E Unified Wire Ethernet Controller"},
			{ID: 0x509f, Name: "T540-509F Unified Wire Ethernet Controller"},
			{ID: 0x50a0, Name: "T540-50A0 Unified Wire Ethernet Controller"},
			{ID: 0x50a1, Name: "T540-50A1 Unified Wire Ethernet Controller"},
			{ID: 0x50a2, Name: "T580-50A2 Unified Wire Ethernet Controller"},
			{ID: 0x50a3, Name: "T580-50A3 Unified Wire Ethernet Controller"},
			{ID: 0x50a4, Name: "T540-50A4 Unified Wire Ethernet Controller"},
			{ID: 0x50a5, Name: "T522-50A5 Unified Wire Ethernet Controller"},
			{ID: 0x50a6, Name: "T522-50A6 Unified Wire Ethernet Controller"},
			{ID: 0x50a7, Name: "T580-50A7 Unified Wire Ethernet Controller"},
			{ID: 0x50a8, Name: "T580-50A8 Unified Wire Ethernet Controller"},
			{ID: 0x50a9, Name: "T580-50A9 Unified Wire Ethernet Controller"},
			{ID: 0x50aa, Name: "T580-50AA Unified Wire Ethernet Controller"},
			{ID: 0x50ab, Name: "T520-50AB Unified Wire Ethernet Controller"},
			{ID: 0x50ac, Name: "T540-50AC Unified Wire Ethernet Controller"},
			{ID: 0x50ad, Name: "T520-50AD Unified Wire Ethernet Controller"},
			{ID: 0x50ae, Name: "T540-50AE Unified Wire Ethernet Controller"},
			{ID: 0x50af, Name: "T580-50AF Unified Wire Ethernet Controller"},
			{ID: 0x50b0, Name: "T520-50B0 Unified Wire Ethernet Controller"},
			{ID: 0x5401, Name: "T520-CR Unified Wire Ethernet Controller"},
			{ID: 0x5402, Name: "T522-CR Unified Wire Ethernet Controller"},
			{ID: 0x5403, Name: "T540-CR Unified Wire Ethernet Controller"},
			{ID: 0x5404, Name: "T520-BCH Unified Wire Ethernet Controller"},
			{ID: 0x5405, Name: "T540-BCH Unified Wire Ethernet Controller"},
			{ID: 0x5406, Name: "T540-CH Unified Wire Ethernet Controller"},
			{ID: 0x5407, Name: "T520-SO Unified Wire Ethernet Controller"},
			{ID: 0x5408, Name: "T520-CX Unified Wire Ethernet Controller"},
			{ID: 0x5409, Name: "T520-BT Unified Wire Ethernet Controller"},
			{ID: 0x540a, Name: "T504-BT Unified Wire Ethernet Controller"},
			{ID: 0x540b, Name: "B520-SR Unified Wire Ethernet Controller"},
			{ID: 0x540c, Name: "B504-BT Unified Wire Ethernet Controller"},
			{ID: 0x540d, Name: "T580-CR Unified Wire Ethernet Controller"},
			{ID: 0x540e, Name: "T540-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x540f, Name: "T540 [Amsterdam] Unified Wire Ethernet Controller"},
			{ID: 0x5410, Name: "T580-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x5411, Name: "T520-LL-CR Unified Wire Ethernet Controller"},
			{ID: 0x5412, Name: "T560-CR Unified Wire Ethernet Controller"},
			{ID: 0x5413, Name: "T580-CHR Unified Wire Ethernet Controller"},
			{ID: 0x5414, Name: "T580-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x5415, Name: "T502-BT Unified Wire Ethernet Controller"},
			{ID: 0x5416, Name: "T580-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x5417, Name: "T520-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x5418, Name: "T540-BT Unified Wire Ethernet Controller"},
			{ID: 0x5419, Name: "T540-LP-BT Unified Wire Ethernet Controller"},
			{ID: 0x541a, Name: "T540-SO-BT Unified Wire Ethernet Controller"},
			{ID: 0x541b, Name: "T540-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x5480, Name: "T540-5080 Unified Wire Ethernet Controller"},
			{ID: 0x5481, Name: "T540-5081 Unified Wire Ethernet Controller"},
			{ID: 0x5482, Name: "T504-5082 Unified Wire Ethernet Controller"},
			{ID: 0x5483, Name: "T540-5083 Unified Wire Ethernet Controller"},
			{ID: 0x5484, Name: "T540-5084 Unified Wire Ethernet Controller"},
			{ID: 0x5485, Name: "T580-5085 Unified Wire Ethernet Controller"},
			{ID: 0x5486, Name: "T580-5086 Unified Wire Ethernet Controller"},
			{ID: 0x5487, Name: "T580-5087 Unified Wire Ethernet Controller"},
			{ID: 0x5488, Name: "T570-5088 Unified Wire Ethernet Controller"},
			{ID: 0x5489, Name: "T520-5089 Unified Wire Ethernet Controller"},
			{ID: 0x5490, Name: "T540-5090 Unified Wire Ethernet Controller"},
			{ID: 0x5491, Name: "T522-5091 Unified Wire Ethernet Controller"},
			{ID: 0x5492, Name: "T520-5092 Unified Wire Ethernet Controller"},
			{ID: 0x5493, Name: "T580-5093 Unified Wire Ethernet Controller"},
			{ID: 0x5494, Name: "T540-5094 Unified Wire Ethernet Controller"},
			{ID: 0x5495, Name: "T540-5095 Unified Wire Ethernet Controller"},
			{ID: 0x5496, Name: "T580-5096 Unified Wire Ethernet Controller"},
			{ID: 0x5497, Name: "T520-5097 Unified Wire Ethernet Controller"},
			{ID: 0x5498, Name: "T580-5098 Unified Wire Ethernet Controller"},
			{ID: 0x5499, Name: "T580-5099 Unified Wire Ethernet Controller"},
			{ID: 0x549a, Name: "T520-509A Unified Wire Ethernet Controller"},
			{ID: 0x549b, Name: "T540-509B Unified Wire Ethernet Controller"},
			{ID: 0x549c, Name: "T520-509C Unified Wire Ethernet Controller"},
			{ID: 0x549d, Name: "T540-509D Unified Wire Ethernet Controller"},
			{ID: 0x549e, Name: "T520-509E Unified Wire Ethernet Controller"},
			{ID: 0x549f, Name: "T540-509F Unified Wire Ethernet Controller"},
			{ID: 0x54a0, Name: "T540-50A0 Unified Wire Ethernet Controller"},
			{ID: 0x54a1, Name: "T540-50A1 Unified Wire Ethernet Controller"},
			{ID: 0x54a2, Name: "T580-50A2 Unified Wire Ethernet Controller"},
			{ID: 0x54a3, Name: "T580-50A3 Unified Wire Ethernet Controller"},
			{ID: 0x54a4, Name: "T540-50A4 Unified Wire Ethernet Controller"},
			{ID: 0x54a5, Name: "T522-50A5 Unified Wire Ethernet Controller"},
			{ID: 0x54a6, Name: "T522-50A6 Unified Wire Ethernet Controller"},
			{ID: 0x54a7, Name: "T580-50A7 Unified Wire Ethernet Controller"},
			{ID: 0x54a8, Name: "T580-50A8 Unified Wire Ethernet Controller"},
			{ID: 0x54a9, Name: "T580-50A9 Unified Wire Ethernet Controller"},
			{ID: 0x54aa, Name: "T580-50AA Unified Wire Ethernet Controller"},
			{ID: 0x54ab, Name: "T520-50AB Unified Wire Ethernet Controller"},
			{ID: 0x54ac, Name: "T540-50AC Unified Wire Ethernet Controller"},
			{ID: 0x54ad, Name: "T520-50AD Unified Wire Ethernet Controller"},
			{ID: 0x54ae, Name: "T540-50AE Unified Wire Ethernet Controller"},
			{ID: 0x54af, Name: "T580-50AF Unified Wire Ethernet Controller"},
			{ID: 0x54b0, Name: "T520-50B0 Unified Wire Ethernet Controller"},
			{ID: 0x5501, Name: "T520-CR Unified Wire Storage Controller"},
			{ID: 0x5502, Name: "T522-CR Unified Wire Storage Controller"},
			{ID: 0x5503, Name: "T540-CR Unified Wire Storage Controller"},
			{ID: 0x5504, Name: "T520-BCH Unified Wire Storage Controller"},
			{ID: 0x5505, Name: "T540-BCH Unified Wire Storage Controller"},
			{ID: 0x5506, Name: "T540-CH Unified Wire Storage Controller"},
			{ID: 0x5507, Name: "T520-SO Unified Wire Storage Controller"},
			{ID: 0x5508, Name: "T520-CX Unified Wire Storage Controller"},
			{ID: 0x5509, Name: "T520-BT Unified Wire Storage Controller"},
			{ID: 0x550a, Name: "T504-BT Unified Wire Storage Controller"},
			{ID: 0x550b, Name: "B520-SR Unified Wire Storage Controller"},
			{ID: 0x550c, Name: "B504-BT Unified Wire Storage Controller"},
			{ID: 0x550d, Name: "T580-CR Unified Wire Storage Controller"},
			{ID: 0x550e, Name: "T540-LP-CR Unified Wire Storage Controller"},
			{ID: 0x550f, Name: "T540 [Amsterdam] Unified Wire Storage Controller"},
			{ID: 0x5510, Name: "T580-LP-CR Unified Wire Storage Controller"},
			{ID: 0x5511, Name: "T520-LL-CR Unified Wire Storage Controller"},
			{ID: 0x5512, Name: "T560-CR Unified Wire Storage Controller"},
			{ID: 0x5513, Name: "T580-CHR Unified Wire Storage Controller"},
			{ID: 0x5514, Name: "T580-SO-CR Unified Wire Storage Controller"},
			{ID: 0x5515, Name: "T502-BT Unified Wire Storage Controller"},
			{ID: 0x5516, Name: "T580-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x5517, Name: "T520-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x5518, Name: "T540-BT Unified Wire Storage Controller"},
			{ID: 0x5519, Name: "T540-LP-BT Unified Wire Storage Controller"},
			{ID: 0x551a, Name: "T540-SO-BT Unified Wire Storage Controller"},
			{ID: 0x551b, Name: "T540-SO-CR Unified Wire Storage Controller"},
			{ID: 0x5580, Name: "T540-5080 Unified Wire Storage Controller"},
			{ID: 0x5581, Name: "T540-5081 Unified Wire Storage Controller"},
			{ID: 0x5582, Name: "T504-5082 Unified Wire Storage Controller"},
			{ID: 0x5583, Name: "T540-5083 Unified Wire Storage Controller"},
			{ID: 0x5584, Name: "T540-5084 Unified Wire Storage Controller"},
			{ID: 0x5585, Name: "T580-5085 Unified Wire Storage Controller"},
			{ID: 0x5586, Name: "T580-5086 Unified Wire Storage Controller"},
			{ID: 0x5587, Name: "T580-5087 Unified Wire Storage Controller"},
			{ID: 0x5588, Name: "T570-5088 Unified Wire Storage Controller"},
			{ID: 0x5589, Name: "T520-5089 Unified Wire Storage Controller"},
			{ID: 0x5590, Name: "T540-5090 Unified Wire Storage Controller"},
			{ID: 0x5591, Name: "T522-5091 Unified Wire Storage Controller"},
			{ID: 0x5592, Name: "T520-5092 Unified Wire Storage Controller"},
			{ID: 0x5593, Name: "T580-5093 Unified Wire Storage Controller"},
			{ID: 0x5594, Name: "T540-5094 Unified Wire Storage Controller"},
			{ID: 0x5595, Name: "T540-5095 Unified Wire Storage Controller"},
			{ID: 0x5596, Name: "T580-5096 Unified Wire Storage Controller"},
			{ID: 0x5597, Name: "T520-5097 Unified Wire Storage Controller"},
			{ID: 0x5598, Name: "T580-5098 Unified Wire Storage Controller"},
			{ID: 0x5599, Name: "T580-5099 Unified Wire Storage Controller"},
			{ID: 0x559a, Name: "T520-509A Unified Wire Storage Controller"},
			{ID: 0x559b, Name: "T540-509B Unified Wire Storage Controller"},
			{ID: 0x559c, Name: "T520-509C Unified Wire Storage Controller"},
			{ID: 0x559d, Name: "T540-509D Unified Wire Storage Controller"},
			{ID: 0x559e, Name: "T520-509E Unified Wire Storage Controller"},
			{ID: 0x559f, Name: "T540-509F Unified Wire Storage Controller"},
			{ID: 0x55a0, Name: "T540-50A0 Unified Wire Storage Controller"},
			{ID: 0x55a1, Name: "T540-50A1 Unified Wire Storage Controller"},
			{ID: 0x55a2, Name: "T580-50A2 Unified Wire Storage Controller"},
			{ID: 0x55a3, Name: "T580-50A3 Unified Wire Storage Controller"},
			{ID: 0x55a4, Name: "T540-50A4 Unified Wire Storage Controller"},
			{ID: 0x55a5, Name: "T522-50A5 Unified Wire Storage Controller"},
			{ID: 0x55a6, Name: "T522-50A6 Unified Wire Storage Controller"},
			{ID: 0x55a7, Name: "T580-50A7 Unified Wire Storage Controller"},
			{ID: 0x55a8, Name: "T580-50A8 Unified Wire Storage Controller"},
			{ID: 0x55a9, Name: "T580-50A9 Unified Wire Storage Controller"},
			{ID: 0x55aa, Name: "T580-50AA Unified Wire Storage Controller"},
			{ID: 0x55ab, Name: "T520-50AB Unified Wire Storage Controller"},
			{ID: 0x55ac, Name: "T540-50AC Unified Wire Storage Controller"},
			{ID: 0x55ad, Name: "T520-50AD Unified Wire Storage Controller"},
			{ID: 0x55ae, Name: "T540-50AE Unified Wire Storage Controller"},
			{ID: 0x55af, Name: "T580-50AF Unified Wire Storage Controller"},
			{ID: 0x55b0, Name: "T520-50B0 Unified Wire Storage Controller"},
			{ID: 0x5601, Name: "T520-CR Unified Wire Storage Controller"},
			{ID: 0x5602, Name: "T522-CR Unified Wire Storage Controller"},
			{ID: 0x5603, Name: "T540-CR Unified Wire Storage Controller"},
			{ID: 0x5604, Name: "T520-BCH Unified Wire Storage Controller"},
			{ID: 0x5605, Name: "T540-BCH Unified Wire Storage Controller"},
			{ID: 0x5606, Name: "T540-CH Unified Wire Storage Controller"},
			{ID: 0x5607, Name: "T520-SO Unified Wire Storage Controller"},
			{ID: 0x5608, Name: "T520-CX Unified Wire Storage Controller"},
			{ID: 0x5609, Name: "T520-BT Unified Wire Storage Controller"},
			{ID: 0x560a, Name: "T504-BT Unified Wire Storage Controller"},
			{ID: 0x560b, Name: "B520-SR Unified Wire Storage Controller"},
			{ID: 0x560c, Name: "B504-BT Unified Wire Storage Controller"},
			{ID: 0x560d, Name: "T580-CR Unified Wire Storage Controller"},
			{ID: 0x560e, Name: "T540-LP-CR Unified Wire Storage Controller"},
			{ID: 0x560f, Name: "T540 [Amsterdam] Unified Wire Storage Controller"},
			{ID: 0x5610, Name: "T580-LP-CR Unified Wire Storage Controller"},
			{ID: 0x5611, Name: "T520-LL-CR Unified Wire Storage Controller"},
			{ID: 0x5612, Name: "T560-CR Unified Wire Storage Controller"},
			{ID: 0x5613, Name: "T580-CHR Unified Wire Storage Controller"},
			{ID: 0x5614, Name: "T580-SO-CR Unified Wire Storage Controller"},
			{ID: 0x5615, Name: "T502-BT Unified Wire Storage Controller"},
			{ID: 0x5616, Name: "T580-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x5617, Name: "T520-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x5618, Name: "T540-BT Unified Wire Storage Controller"},
			{ID: 0x5619, Name: "T540-LP-BT Unified Wire Storage Controller"},
			{ID: 0x561a, Name: "T540-SO-BT Unified Wire Storage Controller"},
			{ID: 0x561b, Name: "T540-SO-CR Unified Wire Storage Controller"},
			{ID: 0x5680, Name: "T540-5080 Unified Wire Storage Controller"},
			{ID: 0x5681, Name: "T540-5081 Unified Wire Storage Controller"},
			{ID: 0x5682, Name: "T504-5082 Unified Wire Storage Controller"},
			{ID: 0x5683, Name: "T540-5083 Unified Wire Storage Controller"},
			{ID: 0x5684, Name: "T540-5084 Unified Wire Storage Controller"},
			{ID: 0x5685, Name: "T580-5085 Unified Wire Storage Controller"},
			{ID: 0x5686, Name: "T580-5086 Unified Wire Storage Controller"},
			{ID: 0x5687, Name: "T580-5087 Unified Wire Storage Controller"},
			{ID: 0x5688, Name: "T570-5088 Unified Wire Storage Controller"},
			{ID: 0x5689, Name: "T520-5089 Unified Wire Storage Controller"},
			{ID: 0x5690, Name: "T540-5090 Unified Wire Storage Controller"},
			{ID: 0x5691, Name: "T522-5091 Unified Wire Storage Controller"},
			{ID: 0x5692, Name: "T520-5092 Unified Wire Storage Controller"},
			{ID: 0x5693, Name: "T580-5093 Unified Wire Storage Controller"},
			{ID: 0x5694, Name: "T540-5094 Unified Wire Storage Controller"},
			{ID: 0x5695, Name: "T540-5095 Unified Wire Storage Controller"},
			{ID: 0x5696, Name: "T580-5096 Unified Wire Storage Controller"},
			{ID: 0x5697, Name: "T520-5097 Unified Wire Storage Controller"},
			{ID: 0x5698, Name: "T580-5098 Unified Wire Storage Controller"},
			{ID: 0x5699, Name: "T580-5099 Unified Wire Storage Controller"},
			{ID: 0x569a, Name: "T520-509A Unified Wire Storage Controller"},
			{ID: 0x569b, Name: "T540-509B Unified Wire Storage Controller"},
			{ID: 0x569c, Name: "T520-509C Unified Wire Storage Controller"},
			{ID: 0x569d, Name: "T540-509D Unified Wire Storage Controller"},
			{ID: 0x569e, Name: "T520-509E Unified Wire Storage Controller"},
			{ID: 0x569f, Name: "T540-509F Unified Wire Storage Controller"},
			{ID: 0x56a0, Name: "T540-50A0 Unified Wire Storage Controller"},
			{ID: 0x56a1, Name: "T540-50A1 Unified Wire Storage Controller"},
			{ID: 0x56a2, Name: "T580-50A2 Unified Wire Storage Controller"},
			{ID: 0x56a3, Name: "T580-50A3 Unified Wire Storage Controller"},
			{ID: 0x56a4, Name: "T540-50A4 Unified Wire Storage Controller"},
			{ID: 0x56a5, Name: "T522-50A5 Unified Wire Storage Controller"},
			{ID: 0x56a6, Name: "T522-50A6 Unified Wire Storage Controller"},
			{ID: 0x56a7, Name: "T580-50A7 Unified Wire Storage Controller"},
			{ID: 0x56a8, Name: "T580-50A8 Unified Wire Storage Controller"},
			{ID: 0x56a9, Name: "T580-50A9 Unified Wire Storage Controller"},
			{ID: 0x56aa, Name: "T580-50AA Unified Wire Storage Controller"},
			{ID: 0x56ab, Name: "T520-50AB Unified Wire Storage Controller"},
			{ID: 0x56ac, Name: "T540-50AC Unified Wire Storage Controller"},
			{ID: 0x56ad, Name: "T520-50AD Unified Wire Storage Controller"},
			{ID: 0x56ae, Name: "T540-50AE Unified Wire Storage Controller"},
			{ID: 0x56af, Name: "T580-50AF Unified Wire Storage Controller"},
			{ID: 0x56b0, Name: "T520-50B0 Unified Wire Storage Controller"},
			{ID: 0x5701, Name: "T520-CR Unified Wire Ethernet Controller"},
			{ID: 0x5702, Name: "T522-CR Unified Wire Ethernet Controller"},
			{ID: 0x5703, Name: "T540-CR Unified Wire Ethernet Controller"},
			{ID: 0x5704, Name: "T520-BCH Unified Wire Ethernet Controller"},
			{ID: 0x5705, Name: "T540-BCH Unified Wire Ethernet Controller"},
			{ID: 0x5706, Name: "T540-CH Unified Wire Ethernet Controller"},
			{ID: 0x5707, Name: "T520-SO Unified Wire Ethernet Controller"},
			{ID: 0x5708, Name: "T520-CX Unified Wire Ethernet Controller"},
			{ID: 0x5709, Name: "T520-BT Unified Wire Ethernet Controller"},
			{ID: 0x570a, Name: "T504-BT Unified Wire Ethernet Controller"},
			{ID: 0x570b, Name: "B520-SR Unified Wire Ethernet Controller"},
			{ID: 0x570c, Name: "B504-BT Unified Wire Ethernet Controller"},
			{ID: 0x570d, Name: "T580-CR Unified Wire Ethernet Controller"},
			{ID: 0x570e, Name: "T540-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x570f, Name: "T540 [Amsterdam] Unified Wire Ethernet Controller"},
			{ID: 0x5710, Name: "T580-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x5711, Name: "T520-LL-CR Unified Wire Ethernet Controller"},
			{ID: 0x5712, Name: "T560-CR Unified Wire Ethernet Controller"},
			{ID: 0x5713, Name: "T580-CR Unified Wire Ethernet Controller"},
			{ID: 0x5714, Name: "T580-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x5715, Name: "T502-BT Unified Wire Ethernet Controller"},
			{ID: 0x5780, Name: "T540-5080 Unified Wire Ethernet Controller"},
			{ID: 0x5781, Name: "T540-5081 Unified Wire Ethernet Controller"},
			{ID: 0x5782, Name: "T504-5082 Unified Wire Ethernet Controller"},
			{ID: 0x5783, Name: "T540-5083 Unified Wire Ethernet Controller"},
			{ID: 0x5784, Name: "T580-5084 Unified Wire Ethernet Controller"},
			{ID: 0x5785, Name: "T580-5085 Unified Wire Ethernet Controller"},
			{ID: 0x5786, Name: "T580-5086 Unified Wire Ethernet Controller"},
			{ID: 0x5787, Name: "T580-5087 Unified Wire Ethernet Controller"},
			{ID: 0x5788, Name: "T570-5088 Unified Wire Ethernet Controller"},
			{ID: 0x5789, Name: "T520-5089 Unified Wire Ethernet Controller"},
			{ID: 0x5790, Name: "T540-5090 Unified Wire Ethernet Controller"},
			{ID: 0x5791, Name: "T522-5091 Unified Wire Ethernet Controller"},
			{ID: 0x5792, Name: "T520-5092 Unified Wire Ethernet Controller"},
			{ID: 0x5793, Name: "T580-5093 Unified Wire Ethernet Controller"},
			{ID: 0x5794, Name: "T540-5094 Unified Wire Ethernet Controller"},
			{ID: 0x5795, Name: "T540-5095 Unified Wire Ethernet Controller"},
			{ID: 0x5796, Name: "T580-5096 Unified Wire Ethernet Controller"},
			{ID: 0x5797, Name: "T520-5097 Unified Wire Ethernet Controller"},
			{ID: 0x5801, Name: "T520-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5802, Name: "T522-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5803, Name: "T540-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5804, Name: "T520-BCH Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5805, Name: "T540-BCH Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5806, Name: "T540-CH Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5807, Name: "T520-SO Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5808, Name: "T520-CX Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5809, Name: "T520-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x580a, Name: "T504-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x580b, Name: "B520-SR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x580c, Name: "B504-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x580d, Name: "T580-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x580e, Name: "T540-LP-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x580f, Name: "T540 [Amsterdam] Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5810, Name: "T580-LP-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5811, Name: "T520-LL-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5812, Name: "T560-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5813, Name: "T580-CHR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5814, Name: "T580-SO-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5815, Name: "T502-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5816, Name: "T580-OCP-SO Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5817, Name: "T520-OCP-SO Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5818, Name: "T540-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5819, Name: "T540-LP-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x581a, Name: "T540-SO-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x581b, Name: "T540-SO-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5880, Name: "T540-5080 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5881, Name: "T540-5081 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5882, Name: "T504-5082 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5883, Name: "T540-5083 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5884, Name: "T540-5084 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5885, Name: "T580-5085 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5886, Name: "T580-5086 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5887, Name: "T580-5087 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5888, Name: "T570-5088 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5889, Name: "T520-5089 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5890, Name: "T540-5090 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5891, Name: "T522-5091 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5892, Name: "T520-5092 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5893, Name: "T580-5093 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5894, Name: "T540-5094 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5895, Name: "T540-5095 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5896, Name: "T580-5096 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5897, Name: "T520-5097 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5898, Name: "T580-5098 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x5899, Name: "T580-5099 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x589a, Name: "T520-509A Unified Wire Ethernet Controller [VF]"},
			{ID: 0x589b, Name: "T540-509B Unified Wire Ethernet Controller [VF]"},
			{ID: 0x589c, Name: "T520-509C Unified Wire Ethernet Controller [VF]"},
			{ID: 0x589d, Name: "T540-509D Unified Wire Ethernet Controller [VF]"},
			{ID: 0x589e, Name: "T520-509E Unified Wire Ethernet Controller [VF]"},
			{ID: 0x589f, Name: "T540-509F Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a0, Name: "T540-50A0 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a1, Name: "T540-50A1 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a2, Name: "T580-50A2 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a3, Name: "T580-50A3 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a4, Name: "T540-50A4 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a5, Name: "T522-50A5 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a6, Name: "T522-50A6 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a7, Name: "T580-50A7 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a8, Name: "T580-50A8 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58a9, Name: "T580-50A9 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58aa, Name: "T580-50AA Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58ab, Name: "T520-50AB Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58ac, Name: "T540-50AC Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58ad, Name: "T520-50AD Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58ae, Name: "T540-50AE Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58af, Name: "T580-50AF Unified Wire Ethernet Controller [VF]"},
			{ID: 0x58b0, Name: "T520-50B0 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6001, Name: "T6225-CR Unified Wire Ethernet Controller"},
			{ID: 0x6002, Name: "T6225-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x6003, Name: "T6425-CR Unified Wire Ethernet Controller"},
			{ID: 0x6004, Name: "T6425-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x6005, Name: "T6225-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x6006, Name: "T62100-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x6007, Name: "T62100-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x6008, Name: "T62100-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x6009, Name: "T6210-BT Unified Wire Ethernet Controller"},
			{ID: 0x600d, Name: "T62100-CR Unified Wire Ethernet Controller"},
			{ID: 0x6011, Name: "T6225-LL-CR Unified Wire Ethernet Controller"},
			{ID: 0x6014, Name: "T61100-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x6015, Name: "T6201-BT Unified Wire Ethernet Controller"},
			{ID: 0x6080, Name: "T6225-6080 Unified Wire Ethernet Controller"},
			{ID: 0x6081, Name: "T62100-6081 Unified Wire Ethernet Controller"},
			{ID: 0x6082, Name: "T6225-6082 Unified Wire Ethernet Controller"},
			{ID: 0x6083, Name: "T62100-6083 Unified Wire Ethernet Controller"},
			{ID: 0x6084, Name: "T64100-6084 Unified Wire Ethernet Controller"},
			{ID: 0x6085, Name: "T6240-6085 Unified Wire Ethernet Controller"},
			{ID: 0x6086, Name: "T6225-6086 Unified Wire Ethernet Controller"},
			{ID: 0x6087, Name: "T6225-6087 Unified Wire Ethernet Controller"},
			{ID: 0x6088, Name: "T62100-6088 Unified Wire Ethernet Controller"},
			{ID: 0x6089, Name: "T62100-6089 Unified Wire Ethernet Controller"},
			{ID: 0x608a, Name: "T62100-608a Unified Wire Ethernet Controller"},
			{ID: 0x6401, Name: "T6225-CR Unified Wire Ethernet Controller"},
			{ID: 0x6402, Name: "T6225-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x6403, Name: "T6425-CR Unified Wire Ethernet Controller"},
			{ID: 0x6404, Name: "T6425-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x6405, Name: "T6225-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x6406, Name: "T62100-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x6407, Name: "T62100-LP-CR Unified Wire Ethernet Controller"},
			{ID: 0x6408, Name: "T62100-SO-CR Unified Wire Ethernet Controller"},
			{ID: 0x6409, Name: "T6210-BT Unified Wire Ethernet Controller"},
			{ID: 0x640d, Name: "T62100-CR Unified Wire Ethernet Controller"},
			{ID: 0x6411, Name: "T6225-LL-CR Unified Wire Ethernet Controller"},
			{ID: 0x6414, Name: "T61100-OCP-SO Unified Wire Ethernet Controller"},
			{ID: 0x6415, Name: "T6201-BT Unified Wire Ethernet Controller"},
			{ID: 0x6480, Name: "T6225-6080 Unified Wire Ethernet Controller"},
			{ID: 0x6481, Name: "T62100-6081 Unified Wire Ethernet Controller"},
			{ID: 0x6482, Name: "T6225-6082 Unified Wire Ethernet Controller"},
			{ID: 0x6483, Name: "T62100-6083 Unified Wire Ethernet Controller"},
			{ID: 0x6484, Name: "T64100-6084 Unified Wire Ethernet Controller"},
			{ID: 0x6485, Name: "T6240-6085 Unified Wire Ethernet Controller"},
			{ID: 0x6486, Name: "T6225-6086 Unified Wire Ethernet Controller"},
			{ID: 0x6487, Name: "T6225-6087 Unified Wire Ethernet Controller"},
			{ID: 0x6488, Name: "T62100-6088 Unified Wire Ethernet Controller"},
			{ID: 0x6489, Name: "T62100-6089 Unified Wire Ethernet Controller"},
			{ID: 0x648a, Name: "T62100-608a Unified Wire Ethernet Controller"},
			{ID: 0x6501, Name: "T6225-CR Unified Wire Storage Controller"},
			{ID: 0x6502, Name: "T6225-SO-CR Unified Wire Storage Controller"},
			{ID: 0x6503, Name: "T6425-CR Unified Wire Storage Controller"},
			{ID: 0x6504, Name: "T6425-SO-CR Unified Wire Storage Controller"},
			{ID: 0x6505, Name: "T6225-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x6506, Name: "T62100-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x6507, Name: "T62100-LP-CR Unified Wire Storage Controller"},
			{ID: 0x6508, Name: "T62100-SO-CR Unified Wire Storage Controller"},
			{ID: 0x6509, Name: "T6210-BT Unified Wire Storage Controller"},
			{ID: 0x650d, Name: "T62100-CR Unified Wire Storage Controller"},
			{ID: 0x6511, Name: "T6225-LL-CR Unified Wire Storage Controller"},
			{ID: 0x6514, Name: "T61100-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x6515, Name: "T6201-BT Unified Wire Storage Controller"},
			{ID: 0x6580, Name: "T6225-6080 Unified Wire Storage Controller"},
			{ID: 0x6581, Name: "T62100-6081 Unified Wire Storage Controller"},
			{ID: 0x6582, Name: "T6225-6082 Unified Wire Storage Controller"},
			{ID: 0x6583, Name: "T62100-6083 Unified Wire Storage Controller"},
			{ID: 0x6584, Name: "T64100-6084 Unified Wire Storage Controller"},
			{ID: 0x6585, Name: "T6240-6085 Unified Wire Storage Controller"},
			{ID: 0x6586, Name: "T6225-6086 Unified Wire Storage Controller"},
			{ID: 0x6587, Name: "T6225-6087 Unified Wire Storage Controller"},
			{ID: 0x6588, Name: "T62100-6088 Unified Wire Storage Controller"},
			{ID: 0x6589, Name: "T62100-6089 Unified Wire Storage Controller"},
			{ID: 0x658a, Name: "T62100-608a Unified Wire Storage Controller"},
			{ID: 0x6601, Name: "T6225-CR Unified Wire Storage Controller"},
			{ID: 0x6602, Name: "T6225-SO-CR Unified Wire Storage Controller"},
			{ID: 0x6603, Name: "T6425-CR Unified Wire Storage Controller"},
			{ID: 0x6604, Name: "T6425-SO-CR Unified Wire Storage Controller"},
			{ID: 0x6605, Name: "T6225-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x6606, Name: "T62100-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x6607, Name: "T62100-LP-CR Unified Wire Storage Controller"},
			{ID: 0x6608, Name: "T62100-SO-CR Unified Wire Storage Controller"},
			{ID: 0x6609, Name: "T6210-BT Unified Wire Storage Controller"},
			{ID: 0x660d, Name: "T62100-CR Unified Wire Storage Controller"},
			{ID: 0x6611, Name: "T6225-LL-CR Unified Wire Storage Controller"},
			{ID: 0x6614, Name: "T61100-OCP-SO Unified Wire Storage Controller"},
			{ID: 0x6615, Name: "T6201-BT Unified Wire Storage Controller"},
			{ID: 0x6680, Name: "T6225-6080 Unified Wire Storage Controller"},
			{ID: 0x6681, Name: "T62100-6081 Unified Wire Storage Controller"},
			{ID: 0x6682, Name: "T6225-6082 Unified Wire Storage Controller"},
			{ID: 0x6683, Name: "T62100-6083 Unified Wire Storage Controller"},
			{ID: 0x6684, Name: "T64100-6084 Unified Wire Storage Controller"},
			{ID: 0x6685, Name: "T6240-6085 Unified Wire Storage Controller"},
			{ID: 0x6686, Name: "T6225-6086 Unified Wire Storage Controller"},
			{ID: 0x6687, Name: "T6225-6087 Unified Wire Storage Controller"},
			{ID: 0x6688, Name: "T62100-6088 Unified Wire Storage Controller"},
			{ID: 0x6689, Name: "T62100-6089 Unified Wire Storage Controller"},
			{ID: 0x668a, Name: "T62100-608a Unified Wire Storage Controller"},
			{ID: 0x6801, Name: "T6225-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6802, Name: "T6225-SO-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6803, Name: "T6425-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6804, Name: "T6425-SO-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6805, Name: "T6225-OCP-SO Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6806, Name: "T62100-OCP-SO Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6807, Name: "T62100-LP-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6808, Name: "T62100-SO-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6809, Name: "T6210-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x680d, Name: "T62100-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6811, Name: "T6225-LL-CR Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6814, Name: "T61100-OCP-SO Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6815, Name: "T6201-BT Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6880, Name: "T6225-6080 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6881, Name: "T62100-6081 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6882, Name: "T6225-6082 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6883, Name: "T62100-6083 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6884, Name: "T64100-6084 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6885, Name: "T6240-6085 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6886, Name: "T6225-6086 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6887, Name: "T6225-6087 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6888, Name: "T62100-6088 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x6889, Name: "T62100-6089 Unified Wire Ethernet Controller [VF]"},
			{ID: 0x688a, Name: "T62100-608a Unified Wire Ethernet Controller [VF]"},
			{ID: 0xa000, Name: "PE10K Unified Wire Ethernet Controller"},
		},
	},
	{ID: 0x1426, Name: "Storage Technology Corp.", Devices: []Device{}},
	{ID: 0x1427, Name: "Better On-Line Solutions", Devices: []Device{}},
	{ID: 0x1428, Name: "Edec Co Ltd", Devices: []Device{}},
	{ID: 0x1429, Name: "Unex Technology Corp.", Devices: []Device{}},
	{ID: 0x142a, Name: "Kingmax Technology Inc", Devices: []Device{}},
	{ID: 0x142b, Name: "Radiolan", Devices: []Device{}},
	{ID: 0x142c, Name: "Minton Optic Industry Co Ltd", Devices: []Device{}},
	{ID: 0x142d, Name: "Pix stream Inc", Devices: []Device{}},
	{
		ID: 0x142e, Name: "Vitec Multimedia", Devices: []Device{
			{ID: 0x4020, Name: "VM2-2 [Video Maker 2] MPEG1/2 Encoder"},
			{ID: 0x4337, Name: "VM2-2-C7 [Video Maker 2 rev. C7] MPEG1/2 Encoder"},
		},
	},
	{ID: 0x142f, Name: "Radicom Research Inc", Devices: []Device{}},
	{ID: 0x1430, Name: "ITT Aerospace/Communications Division", Devices: []Device{}},
	{ID: 0x1431, Name: "Gilat Satellite Networks", Devices: []Device{}},
	{
		ID: 0x1432, Name: "Edimax Computer Co.", Devices: []Device{
			{ID: 0x9130, Name: "RTL81xx Fast Ethernet"},
		},
	},
	{ID: 0x1433, Name: "Eltec Elektronik GmbH", Devices: []Device{}},
	{
		ID: 0x1435, Name: "RTD Embedded Technologies, Inc.", Devices: []Device{
			{ID: 0x4520, Name: "PCI4520"},
			{ID: 0x6020, Name: "SPM6020"},
			{ID: 0x6030, Name: "SPM6030"},
			{ID: 0x6420, Name: "SPM186420"},
			{ID: 0x6430, Name: "SPM176430"},
			{ID: 0x6431, Name: "SPM176431"},
			{ID: 0x7520, Name: "DM7520"},
			{ID: 0x7540, Name: "SDM7540"},
			{ID: 0x7820, Name: "DM7820"},
		},
	},
	{ID: 0x1436, Name: "CIS Technology Inc", Devices: []Device{}},
	{ID: 0x1437, Name: "Nissin Inc Co", Devices: []Device{}},
	{ID: 0x1438, Name: "Atmel-dream", Devices: []Device{}},
	{ID: 0x1439, Name: "Outsource Engineering & Mfg. Inc", Devices: []Device{}},
	{ID: 0x143a, Name: "Stargate Solutions Inc", Devices: []Device{}},
	{ID: 0x143b, Name: "Canon Research Center, America", Devices: []Device{}},
	{ID: 0x143c, Name: "Amlogic Inc", Devices: []Device{}},
	{ID: 0x143d, Name: "Tamarack Microelectronics Inc", Devices: []Device{}},
	{ID: 0x143e, Name: "Jones Futurex Inc", Devices: []Device{}},
	{ID: 0x143f, Name: "Lightwell Co Ltd - Zax Division", Devices: []Device{}},
	{ID: 0x1440, Name: "ALGOL Corp.", Devices: []Device{}},
	{ID: 0x1441, Name: "AGIE Ltd", Devices: []Device{}},
	{ID: 0x1442, Name: "Phoenix Contact GmbH & Co.", Devices: []Device{}},
	{ID: 0x1443, Name: "Unibrain S.A.", Devices: []Device{}},
	{ID: 0x1444, Name: "TRW", Devices: []Device{}},
	{ID: 0x1445, Name: "Logical DO Ltd", Devices: []Device{}},
	{ID: 0x1446, Name: "Graphin Co Ltd", Devices: []Device{}},
	{ID: 0x1447, Name: "AIM GmBH", Devices: []Device{}},
	{ID: 0x1448, Name: "Alesis Studio Electronics", Devices: []Device{}},
	{ID: 0x1449, Name: "TUT Systems Inc", Devices: []Device{}},
	{
		ID: 0x144a, Name: "Adlink Technology", Devices: []Device{
			{ID: 0x6208, Name: "PCI-6208V"},
			{ID: 0x7250, Name: "PCI-7250"},
			{ID: 0x7296, Name: "PCI-7296"},
			{ID: 0x7432, Name: "PCI-7432"},
			{ID: 0x7433, Name: "PCI-7433"},
			{ID: 0x7434, Name: "PCI-7434"},
			{ID: 0x7841, Name: "PCI-7841"},
			{ID: 0x8133, Name: "PCI-8133"},
			{ID: 0x8164, Name: "PCI-8164"},
			{ID: 0x8554, Name: "PCI-8554"},
			{ID: 0x9111, Name: "PCI-9111"},
			{ID: 0x9113, Name: "PCI-9113"},
			{ID: 0x9114, Name: "PCI-9114"},
			{ID: 0xa001, Name: "ADi-BSEC"},
		},
	},
	{ID: 0x144b, Name: "Verint Systems Inc.", Devices: []Device{}},
	{ID: 0x144c, Name: "Catalina Research Inc", Devices: []Device{}},
	{
		ID: 0x144d, Name: "Samsung Electronics Co Ltd", Devices: []Device{
			{ID: 0x1600, Name: "Apple PCIe SSD"},
			{ID: 0xa544, Name: "Exynos 8890 PCIe Root Complex"},
			{ID: 0xa800, Name: "XP941 PCIe SSD"},
			{ID: 0xa802, Name: "NVMe SSD Controller SM951/PM951"},
			{ID: 0xa804, Name: "NVMe SSD Controller SM961/PM961/SM963"},
			{ID: 0xa808, Name: "NVMe SSD Controller SM981/PM981/PM983"},
			{ID: 0xa809, Name: "NVMe SSD Controller 980"},
			{ID: 0xa80a, Name: "NVMe SSD Controller PM9A1/PM9A3/980PRO"},
			{ID: 0xa820, Name: "NVMe SSD Controller 171X"},
			{ID: 0xa821, Name: "NVMe SSD Controller 172X"},
			{ID: 0xa822, Name: "NVMe SSD Controller 172Xa/172Xb"},
			{ID: 0xa824, Name: "NVMe SSD Controller PM173X"},
			{ID: 0xa825, Name: "NVMe SSD Controller PM173Xa"},
			{ID: 0xa826, Name: "NVMe SSD Controller PM174X"},
			{ID: 0xecec, Name: "Exynos 8895 PCIe Root Complex"},
		},
	},
	{ID: 0x144e, Name: "OLITEC", Devices: []Device{}},
	{ID: 0x144f, Name: "Askey Computer Corp.", Devices: []Device{}},
	{ID: 0x1450, Name: "Octave Communications Ind.", Devices: []Device{}},
	{ID: 0x1451, Name: "SP3D Chip Design GmBH", Devices: []Device{}},
	{ID: 0x1453, Name: "MYCOM Inc", Devices: []Device{}},
	{ID: 0x1454, Name: "Altiga Networks", Devices: []Device{}},
	{ID: 0x1455, Name: "Logic Plus Plus Inc", Devices: []Device{}},
	{ID: 0x1456, Name: "Advanced Hardware Architectures", Devices: []Device{}},
	{ID: 0x1457, Name: "Nuera Communications Inc", Devices: []Device{}},
	{
		ID: 0x1458, Name: "Gigabyte Technology Co., Ltd", Devices: []Device{
			{ID: 0x22e8, Name: "Ellesmere [Radeon RX 480]"},
			{ID: 0x3483, Name: "USB 3.0 Controller (VIA VL80x-based xHCI Controller)"},
		},
	},
	{ID: 0x1459, Name: "DOOIN Electronics", Devices: []Device{}},
	{ID: 0x145a, Name: "Escalate Networks Inc", Devices: []Device{}},
	{ID: 0x145b, Name: "PRAIM SRL", Devices: []Device{}},
	{ID: 0x145c, Name: "Cryptek", Devices: []Device{}},
	{ID: 0x145d, Name: "Gallant Computer Inc", Devices: []Device{}},
	{ID: 0x145e, Name: "Aashima Technology B.V.", Devices: []Device{}},
	{
		ID: 0x145f, Name: "Baldor Electric Company", Devices: []Device{
			{ID: 0x0001, Name: "NextMove PCI"},
		},
	},
	{ID: 0x1460, Name: "DYNARC INC", Devices: []Device{}},
	{
		ID: 0x1461, Name: "Avermedia Technologies Inc", Devices: []Device{
			{ID: 0xa3ce, Name: "M179"},
			{ID: 0xa3cf, Name: "M179"},
			{ID: 0xa836, Name: "M115 DVB-T, PAL/SECAM/NTSC Tuner"},
			{ID: 0xe836, Name: "M115S Hybrid Analog/DVB PAL/SECAM/NTSC Tuner"},
			{ID: 0xf436, Name: "AVerTV Hybrid+FM"},
		},
	},
	{
		ID: 0x1462, Name: "Micro-Star International Co., Ltd. [MSI]", Devices: []Device{
			{ID: 0x3483, Name: "MSI USB 3.0 (VIA VL80x-based xHCI USB Controller)"},
			{ID: 0x7c56, Name: "Realtek Ethernet controller RTL8111H"},
			{ID: 0xaaf0, Name: "Radeon RX 580 Gaming X 8G"},
		},
	},
	{ID: 0x1463, Name: "Fast Corporation", Devices: []Device{}},
	{ID: 0x1464, Name: "Interactive Circuits & Systems Ltd", Devices: []Device{}},
	{ID: 0x1465, Name: "GN NETTEST Telecom DIV.", Devices: []Device{}},
	{ID: 0x1466, Name: "Designpro Inc.", Devices: []Device{}},
	{ID: 0x1467, Name: "DIGICOM SPA", Devices: []Device{}},
	{ID: 0x1468, Name: "AMBIT Microsystem Corp.", Devices: []Device{}},
	{ID: 0x1469, Name: "Cleveland Motion Controls", Devices: []Device{}},
	{
		ID: 0x146a, Name: "Aeroflex", Devices: []Device{
			{ID: 0x3010, Name: "3010 RF Synthesizer"},
			{ID: 0x3a11, Name: "3011A PXI RF Synthesizer"},
		},
	},
	{ID: 0x146b, Name: "Parascan Technologies Ltd", Devices: []Device{}},
	{
		ID: 0x146c, Name: "Ruby Tech Corp.", Devices: []Device{
			{ID: 0x1430, Name: "FE-1430TX Fast Ethernet PCI Adapter"},
		},
	},
	{ID: 0x146d, Name: "Tachyon, INC.", Devices: []Device{}},
	{ID: 0x146e, Name: "Williams Electronics Games, Inc.", Devices: []Device{}},
	{ID: 0x146f, Name: "Multi Dimensional Consulting Inc", Devices: []Device{}},
	{ID: 0x1470, Name: "Bay Networks", Devices: []Device{}},
	{ID: 0x1471, Name: "Integrated Telecom Express Inc", Devices: []Device{}},
	{ID: 0x1472, Name: "DAIKIN Industries, Ltd", Devices: []Device{}},
	{ID: 0x1473, Name: "ZAPEX Technologies Inc", Devices: []Device{}},
	{ID: 0x1474, Name: "Doug Carson & Associates", Devices: []Device{}},
	{ID: 0x1475, Name: "PICAZO Communications", Devices: []Device{}},
	{ID: 0x1476, Name: "MORTARA Instrument Inc", Devices: []Device{}},
	{ID: 0x1477, Name: "Net Insight", Devices: []Device{}},
	{ID: 0x1478, Name: "DIATREND Corporation", Devices: []Device{}},
	{ID: 0x1479, Name: "TORAY Industries Inc", Devices: []Device{}},
	{ID: 0x147a, Name: "FORMOSA Industrial Computing", Devices: []Device{}},
	{
		ID: 0x147b, Name: "ABIT Computer Corp.", Devices: []Device{
			{ID: 0x1084, Name: "IP35 [Dark Raider]"},
		},
	},
	{ID: 0x147c, Name: "AWARE, Inc.", Devices: []Device{}},
	{ID: 0x147d, Name: "Interworks Computer Products", Devices: []Device{}},
	{ID: 0x147e, Name: "Matsushita Graphic Communication Systems, Inc.", Devices: []Device{}},
	{ID: 0x147f, Name: "NIHON UNISYS, Ltd.", Devices: []Device{}},
	{ID: 0x1480, Name: "SCII Telecom", Devices: []Device{}},
	{ID: 0x1481, Name: "BIOPAC Systems Inc", Devices: []Device{}},
	{
		ID: 0x1482, Name: "ISYTEC - Integrierte Systemtechnik GmBH", Devices: []Device{
			{ID: 0x0001, Name: "PCI-16 Host Interface for ITC-16"},
		},
	},
	{ID: 0x1483, Name: "LABWAY Corporation", Devices: []Device{}},
	{ID: 0x1484, Name: "Logic Corporation", Devices: []Device{}},
	{ID: 0x1485, Name: "ERMA - Electronic GmBH", Devices: []Device{}},
	{ID: 0x1486, Name: "L3 Communications Telemetry & Instrumentation", Devices: []Device{}},
	{ID: 0x1487, Name: "MARQUETTE Medical Systems", Devices: []Device{}},
	{ID: 0x1489, Name: "KYE Systems Corporation", Devices: []Device{}},
	{ID: 0x148a, Name: "OPTO", Devices: []Device{}},
	{ID: 0x148b, Name: "INNOMEDIALOGIC Inc.", Devices: []Device{}},
	{
		ID: 0x148c, Name: "Tul Corporation / PowerColor", Devices: []Device{
			{ID: 0x2391, Name: "Radeon RX 590 [Red Devil]"},
		},
	},
	{
		ID: 0x148d, Name: "DIGICOM Systems, Inc.", Devices: []Device{
			{ID: 0x1003, Name: "HCF 56k Data/Fax Modem"},
		},
	},
	{ID: 0x148e, Name: "OSI Plus Corporation", Devices: []Device{}},
	{ID: 0x148f, Name: "Plant Equipment, Inc.", Devices: []Device{}},
	{ID: 0x1490, Name: "Stone Microsystems PTY Ltd.", Devices: []Device{}},
	{ID: 0x1491, Name: "ZEAL Corporation", Devices: []Device{}},
	{ID: 0x1492, Name: "Time Logic Corporation", Devices: []Device{}},
	{ID: 0x1493, Name: "MAKER Communications", Devices: []Device{}},
	{ID: 0x1494, Name: "WINTOP Technology, Inc.", Devices: []Device{}},
	{ID: 0x1495, Name: "TOKAI Communications Industry Co. Ltd", Devices: []Device{}},
	{ID: 0x1496, Name: "JOYTECH Computer Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1497, Name: "SMA Regelsysteme GmBH", Devices: []Device{
			{ID: 0x1497, Name: "SMA Technologie AG"},
		},
	},
	{
		ID: 0x1498, Name: "TEWS Technologies GmbH", Devices: []Device{
			{ID: 0x0330, Name: "TPMC816 2 Channel CAN bus controller."},
			{ID: 0x035d, Name: "TPMC861 4-Channel Isolated Serial Interface RS422/RS485"},
			{ID: 0x0385, Name: "TPMC901 Extended CAN bus with 2/4/6 CAN controller"},
			{ID: 0x21cc, Name: "TCP460 CompactPCI 16 Channel Serial Interface RS232/RS422"},
			{ID: 0x21cd, Name: "TCP461 CompactPCI 8 Channel Serial Interface RS232/RS422"},
			{ID: 0x3064, Name: "TPCI100 (2 Slot IndustryPack PCI Carrier)"},
			{ID: 0x30c8, Name: "TPCI200 4 Slot IndustryPack PCI Carrier"},
			{ID: 0x70c8, Name: "TPCE200 4 Slot IndustryPack PCIe Carrier"},
			{ID: 0x9177, Name: "TXMC375 8 channel RS232/RS422/RS485 programmable serial interface"},
		},
	},
	{ID: 0x1499, Name: "EMTEC CO., Ltd", Devices: []Device{}},
	{ID: 0x149a, Name: "ANDOR Technology Ltd", Devices: []Device{}},
	{ID: 0x149b, Name: "SEIKO Instruments Inc", Devices: []Device{}},
	{ID: 0x149c, Name: "OVISLINK Corp.", Devices: []Device{}},
	{
		ID: 0x149d, Name: "NEWTEK Inc", Devices: []Device{
			{ID: 0x0001, Name: "Video Toaster for PC"},
		},
	},
	{ID: 0x149e, Name: "Mapletree Networks Inc.", Devices: []Device{}},
	{ID: 0x149f, Name: "LECTRON Co Ltd", Devices: []Device{}},
	{ID: 0x14a0, Name: "SOFTING GmBH", Devices: []Device{}},
	{ID: 0x14a1, Name: "Systembase Co Ltd", Devices: []Device{}},
	{ID: 0x14a2, Name: "Millennium Engineering Inc", Devices: []Device{}},
	{ID: 0x14a3, Name: "Maverick Networks", Devices: []Device{}},
	{
		ID: 0x14a4, Name: "Lite-On Technology Corporation", Devices: []Device{
			{ID: 0x22f1, Name: "M8Pe Series NVMe SSD"},
			{ID: 0x4318, Name: "Broadcom BCM4318 [AirForce One 54g] 802.11g WLAN Controller"},
		},
	},
	{ID: 0x14a5, Name: "XIONICS Document Technologies Inc", Devices: []Device{}},
	{ID: 0x14a6, Name: "INOVA Computers GmBH & Co KG", Devices: []Device{}},
	{ID: 0x14a7, Name: "MYTHOS Systems Inc", Devices: []Device{}},
	{ID: 0x14a8, Name: "FEATRON Technologies Corporation", Devices: []Device{}},
	{ID: 0x14a9, Name: "HIVERTEC Inc", Devices: []Device{}},
	{ID: 0x14aa, Name: "Advanced MOS Technology Inc", Devices: []Device{}},
	{ID: 0x14ab, Name: "Siemens Industry Software Inc.", Devices: []Device{}},
	{ID: 0x14ac, Name: "Novaweb Technologies Inc", Devices: []Device{}},
	{ID: 0x14ad, Name: "Time Space Radio AB", Devices: []Device{}},
	{ID: 0x14ae, Name: "CTI, Inc", Devices: []Device{}},
	{
		ID: 0x14af, Name: "Guillemot Corporation", Devices: []Device{
			{ID: 0x7102, Name: "3D Prophet II MX"},
		},
	},
	{ID: 0x14b0, Name: "BST Communication Technology Ltd", Devices: []Device{}},
	{ID: 0x14b1, Name: "Nextcom K.K.", Devices: []Device{}},
	{ID: 0x14b2, Name: "ENNOVATE Networks Inc", Devices: []Device{}},
	{
		ID: 0x14b3, Name: "XPEED Inc", Devices: []Device{
			{ID: 0x0000, Name: "DSL NIC"},
		},
	},
	{ID: 0x14b4, Name: "PHILIPS Business Electronics B.V.", Devices: []Device{}},
	{
		ID: 0x14b5, Name: "Creamware GmBH", Devices: []Device{
			{ID: 0x0200, Name: "Scope"},
			{ID: 0x0300, Name: "Pulsar"},
			{ID: 0x0400, Name: "PulsarSRB"},
			{ID: 0x0600, Name: "Pulsar2"},
			{ID: 0x0800, Name: "DSP-Board"},
			{ID: 0x0900, Name: "DSP-Board"},
			{ID: 0x0a00, Name: "DSP-Board"},
			{ID: 0x0b00, Name: "DSP-Board"},
		},
	},
	{ID: 0x14b6, Name: "Quantum Data Corp.", Devices: []Device{}},
	{
		ID: 0x14b7, Name: "PROXIM Inc", Devices: []Device{
			{ID: 0x0001, Name: "Symphony 4110"},
		},
	},
	{ID: 0x14b8, Name: "Techsoft Technology Co Ltd", Devices: []Device{}},
	{
		ID: 0x14b9, Name: "Cisco Aironet Wireless Communications", Devices: []Device{
			{ID: 0x0001, Name: "PC4800"},
			{ID: 0x0340, Name: "PC4800"},
			{ID: 0x0350, Name: "350 series 802.11b Wireless LAN Adapter"},
			{ID: 0x4500, Name: "PC4500"},
			{ID: 0x4800, Name: "Cisco Aironet 340 802.11b Wireless LAN Adapter/Aironet PC4800"},
			{ID: 0xa504, Name: "Cisco Aironet Wireless 802.11b"},
			{ID: 0xa505, Name: "Cisco Aironet CB20a 802.11a Wireless LAN Adapter"},
			{ID: 0xa506, Name: "Cisco Aironet Mini PCI b/g"},
		},
	},
	{
		ID: 0x14ba, Name: "INTERNIX Inc.", Devices: []Device{
			{ID: 0x0600, Name: "ARC-PCI/22"},
		},
	},
	{ID: 0x14bb, Name: "SEMTECH Corporation", Devices: []Device{}},
	{
		ID: 0x14bc, Name: "Globespan Semiconductor Inc.", Devices: []Device{
			{ID: 0xd002, Name: "Pulsar [PCI ADSL Card]"},
			{ID: 0xd00f, Name: "Pulsar [PCI ADSL Card]"},
		},
	},
	{ID: 0x14bd, Name: "CARDIO Control N.V.", Devices: []Device{}},
	{ID: 0x14be, Name: "L3 Communications", Devices: []Device{}},
	{ID: 0x14bf, Name: "SPIDER Communications Inc.", Devices: []Device{}},
	{
		ID: 0x14c0, Name: "COMPAL Electronics Inc", Devices: []Device{
			{ID: 0x1201, Name: "X550 10Gb 2P RJ45 OCP Mezz"},
		},
	},
	{
		ID: 0x14c1, Name: "MYRICOM Inc.", Devices: []Device{
			{ID: 0x0008, Name: "Myri-10G Dual-Protocol NIC"},
			{ID: 0x8043, Name: "Myrinet 2000 Scalable Cluster Interconnect"},
		},
	},
	{ID: 0x14c2, Name: "DTK Computer", Devices: []Device{}},
	{
		ID: 0x14c3, Name: "MEDIATEK Corp.", Devices: []Device{
			{ID: 0x7612, Name: "MT7612E 802.11acbgn PCI Express Wireless Network Adapter"},
			{ID: 0x7630, Name: "MT7630e 802.11bgn Wireless Network Adapter"},
			{ID: 0x7662, Name: "MT7662E 802.11ac PCI Express Wireless Network Adapter"},
			{ID: 0x7915, Name: "MT7915E 802.11ax PCI Express Wireless Network Adapter"},
			{ID: 0x7961, Name: "MT7921 802.11ax PCI Express Wireless Network Adapter"},
		},
	},
	{ID: 0x14c4, Name: "IWASAKI Information Systems Co Ltd", Devices: []Device{}},
	{ID: 0x14c5, Name: "Automation Products AB", Devices: []Device{}},
	{ID: 0x14c6, Name: "Data Race Inc", Devices: []Device{}},
	{ID: 0x14c7, Name: "Modular Technology Holdings Ltd", Devices: []Device{}},
	{ID: 0x14c8, Name: "Turbocomm Tech. Inc.", Devices: []Device{}},
	{ID: 0x14c9, Name: "ODIN Telesystems Inc", Devices: []Device{}},
	{ID: 0x14ca, Name: "PE Logic Corp.", Devices: []Device{}},
	{ID: 0x14cb, Name: "Billionton Systems Inc", Devices: []Device{}},
	{ID: 0x14cc, Name: "NAKAYO Telecommunications Inc", Devices: []Device{}},
	{
		ID: 0x14cd, Name: "Universal Global Scientific Industrial Co.,Ltd", Devices: []Device{
			{ID: 0x0001, Name: "USI-1514-1GbaseT [OCP1]"},
			{ID: 0x0002, Name: "USI-4227-SFP [OCP2]"},
			{ID: 0x0003, Name: "USI-X557-10GbaseT [OCP3]"},
		},
	},
	{ID: 0x14ce, Name: "Whistle Communications", Devices: []Device{}},
	{ID: 0x14cf, Name: "TEK Microsystems Inc.", Devices: []Device{}},
	{ID: 0x14d0, Name: "Ericsson Axe R & D", Devices: []Device{}},
	{ID: 0x14d1, Name: "Computer Hi-Tech Co Ltd", Devices: []Device{}},
	{
		ID: 0x14d2, Name: "Titan Electronics Inc", Devices: []Device{
			{ID: 0x8001, Name: "VScom 010L 1 port parallel adaptor"},
			{ID: 0x8002, Name: "VScom 020L 2 port parallel adaptor"},
			{ID: 0x8010, Name: "VScom 100L 1 port serial adaptor"},
			{ID: 0x8011, Name: "VScom 110L 1 port serial and 1 port parallel adaptor"},
			{ID: 0x8020, Name: "VScom 200L 1 or 2 port serial adaptor"},
			{ID: 0x8021, Name: "VScom 210L 2 port serial and 1 port parallel adaptor"},
			{ID: 0x8028, Name: "VScom 200I/200I-SI 2-port serial adapter"},
			{ID: 0x8040, Name: "VScom 400L 4 port serial adaptor"},
			{ID: 0x8043, Name: "VScom 430L 4-port serial and 3-port parallel adapter"},
			{ID: 0x8048, Name: "VScom 400I 4-port serial adapter"},
			{ID: 0x8080, Name: "VScom 800L 8 port serial adaptor"},
			{ID: 0x8088, Name: "VScom 800I 8-port serial adapter"},
			{ID: 0xa000, Name: "VScom 010H 1 port parallel adaptor"},
			{ID: 0xa001, Name: "VScom 100H 1 port serial adaptor"},
			{ID: 0xa003, Name: "VScom 400H 4 port serial adaptor"},
			{ID: 0xa004, Name: "VScom 400HF1 4 port serial adaptor"},
			{ID: 0xa005, Name: "VScom 200H 2 port serial adaptor"},
			{ID: 0xa007, Name: "VScom PCI800EH (PCIe) 8-port serial adapter Port 1-4"},
			{ID: 0xa008, Name: "VScom PCI800EH (PCIe) 8-port serial adapter Port 5-8"},
			{ID: 0xa009, Name: "VScom PCI400EH (PCIe) 4-port serial adapter"},
			{ID: 0xe001, Name: "VScom 010HV2 1 port parallel adaptor"},
			{ID: 0xe010, Name: "VScom 100HV2 1 port serial adaptor"},
			{ID: 0xe020, Name: "VScom 200HV2 2 port serial adaptor"},
		},
	},
	{
		ID: 0x14d3, Name: "CIRTECH (UK) Ltd", Devices: []Device{
			{ID: 0x0002, Name: "DTL-T14000 Rev. 1 [PS2 TOOL CD/DVD Emulator]"},
			{ID: 0x0003, Name: "DTL-T14000 Rev. 2 [PS2 TOOL CD/DVD Emulator]"},
			{ID: 0x0004, Name: "DTL-T14000 Rev. 3 [PS2 TOOL CD/DVD Emulator]"},
		},
	},
	{ID: 0x14d4, Name: "Panacom Technology Corp", Devices: []Device{}},
	{ID: 0x14d5, Name: "Nitsuko Corporation", Devices: []Device{}},
	{
		ID: 0x14d6, Name: "Accusys Inc", Devices: []Device{
			{ID: 0x6101, Name: "ACS-61xxx, PCIe to SAS/SATA RAID HBA"},
			{ID: 0x6201, Name: "ACS-62xxx, External PCIe to SAS/SATA RAID controller"},
		},
	},
	{ID: 0x14d7, Name: "Hirakawa Hewtech Corp", Devices: []Device{}},
	{ID: 0x14d8, Name: "HOPF Elektronik GmBH", Devices: []Device{}},
	{
		ID: 0x14d9, Name: "Alliance Semiconductor Corporation", Devices: []Device{
			{ID: 0x0010, Name: "AP1011/SP1011 HyperTransport-PCI Bridge [Sturgeon]"},
			{ID: 0x9000, Name: "AS90L10204/10208 HyperTransport to PCI-X Bridge"},
		},
	},
	{ID: 0x14da, Name: "National Aerospace Laboratories", Devices: []Device{}},
	{
		ID: 0x14db, Name: "AFAVLAB Technology Inc", Devices: []Device{
			{ID: 0x2120, Name: "TK9902"},
			{ID: 0x2182, Name: "AFAVLAB Technology Inc. 8-port serial card"},
		},
	},
	{
		ID: 0x14dc, Name: "Amplicon Liveline Ltd", Devices: []Device{
			{ID: 0x0000, Name: "PCI230"},
			{ID: 0x0001, Name: "PCI242"},
			{ID: 0x0002, Name: "PCI244"},
			{ID: 0x0003, Name: "PCI247"},
			{ID: 0x0004, Name: "PCI248"},
			{ID: 0x0005, Name: "PCI249"},
			{ID: 0x0006, Name: "PCI260"},
			{ID: 0x0007, Name: "PCI224"},
			{ID: 0x0008, Name: "PCI234"},
			{ID: 0x0009, Name: "PCI236"},
			{ID: 0x000a, Name: "PCI272"},
			{ID: 0x000b, Name: "PCI215"},
		},
	},
	{ID: 0x14dd, Name: "Boulder Design Labs Inc", Devices: []Device{}},
	{ID: 0x14de, Name: "Applied Integration Corporation", Devices: []Device{}},
	{ID: 0x14df, Name: "ASIC Communications Corp", Devices: []Device{}},
	{ID: 0x14e1, Name: "INVERTEX", Devices: []Device{}},
	{ID: 0x14e2, Name: "INFOLIBRIA", Devices: []Device{}},
	{ID: 0x14e3, Name: "AMTELCO", Devices: []Device{}},
	{
		ID: 0x14e4, Name: "Broadcom Inc. and subsidiaries", Devices: []Device{
			{ID: 0x0576, Name: "BCM43224 802.11a/b/g/n"},
			{ID: 0x0800, Name: "Sentry5 Chipcommon I/O Controller"},
			{ID: 0x0804, Name: "Sentry5 PCI Bridge"},
			{ID: 0x0805, Name: "Sentry5 MIPS32 CPU"},
			{ID: 0x0806, Name: "Sentry5 Ethernet Controller"},
			{ID: 0x080b, Name: "Sentry5 Crypto Accelerator"},
			{ID: 0x080f, Name: "Sentry5 DDR/SDR RAM Controller"},
			{ID: 0x0811, Name: "Sentry5 External Interface Core"},
			{ID: 0x0816, Name: "BCM3302 Sentry5 MIPS32 CPU"},
			{ID: 0x1570, Name: "720p FaceTime HD Camera"},
			{ID: 0x1600, Name: "NetXtreme BCM5752 Gigabit Ethernet PCI Express"},
			{ID: 0x1601, Name: "NetXtreme BCM5752M Gigabit Ethernet PCI Express"},
			{ID: 0x1604, Name: "BCM5745X NetXtreme-E Ethernet Partition"},
			{ID: 0x1605, Name: "BCM5745X NetXtreme-E RDMA Partition"},
			{ID: 0x1606, Name: "BCM5745X NetXtreme-E RDMA Virtual Function"},
			{ID: 0x1609, Name: "BCM5745X NetXtreme-E Ethernet Virtual Function"},
			{ID: 0x1612, Name: "BCM70012 Video Decoder [Crystal HD]"},
			{ID: 0x1614, Name: "BCM57454 NetXtreme-E 10Gb/25Gb/40Gb/50Gb/100Gb Ethernet"},
			{ID: 0x1615, Name: "BCM70015 Video Decoder [Crystal HD]"},
			{ID: 0x1639, Name: "NetXtreme II BCM5709 Gigabit Ethernet"},
			{ID: 0x163a, Name: "NetXtreme II BCM5709S Gigabit Ethernet"},
			{ID: 0x163b, Name: "NetXtreme II BCM5716 Gigabit Ethernet"},
			{ID: 0x163c, Name: "NetXtreme II BCM5716S Gigabit Ethernet"},
			{ID: 0x163d, Name: "NetXtreme II BCM57811 10-Gigabit Ethernet"},
			{ID: 0x163e, Name: "NetXtreme II BCM57811 10 Gigabit Ethernet Multi Function"},
			{ID: 0x163f, Name: "NetXtreme II BCM57811 10-Gigabit Ethernet Virtual Function"},
			{ID: 0x1641, Name: "NetXtreme BCM57787 Gigabit Ethernet PCIe"},
			{ID: 0x1642, Name: "NetXtreme BCM57764 Gigabit Ethernet PCIe"},
			{ID: 0x1643, Name: "NetXtreme BCM5725 Gigabit Ethernet PCIe"},
			{ID: 0x1644, Name: "NetXtreme BCM5700 Gigabit Ethernet"},
			{ID: 0x1645, Name: "NetXtreme BCM5701 Gigabit Ethernet"},
			{ID: 0x1646, Name: "NetXtreme BCM5702 Gigabit Ethernet"},
			{ID: 0x1647, Name: "NetXtreme BCM5703 Gigabit Ethernet"},
			{ID: 0x1648, Name: "NetXtreme BCM5704 Gigabit Ethernet"},
			{ID: 0x1649, Name: "NetXtreme BCM5704S_2 Gigabit Ethernet"},
			{ID: 0x164a, Name: "NetXtreme II BCM5706 Gigabit Ethernet"},
			{ID: 0x164c, Name: "NetXtreme II BCM5708 Gigabit Ethernet"},
			{ID: 0x164d, Name: "NetXtreme BCM5702FE Gigabit Ethernet"},
			{ID: 0x164e, Name: "NetXtreme II BCM57710 10-Gigabit PCIe [Everest]"},
			{ID: 0x164f, Name: "NetXtreme II BCM57711 10-Gigabit PCIe"},
			{ID: 0x1650, Name: "NetXtreme II BCM57711E 10-Gigabit PCIe"},
			{ID: 0x1653, Name: "NetXtreme BCM5705 Gigabit Ethernet"},
			{ID: 0x1654, Name: "NetXtreme BCM5705_2 Gigabit Ethernet"},
			{ID: 0x1655, Name: "NetXtreme BCM5717 Gigabit Ethernet PCIe"},
			{ID: 0x1656, Name: "NetXtreme BCM5718 Gigabit Ethernet PCIe"},
			{ID: 0x1657, Name: "NetXtreme BCM5719 Gigabit Ethernet PCIe"},
			{ID: 0x1659, Name: "NetXtreme BCM5721 Gigabit Ethernet PCI Express"},
			{ID: 0x165a, Name: "NetXtreme BCM5722 Gigabit Ethernet PCI Express"},
			{ID: 0x165b, Name: "NetXtreme BCM5723 Gigabit Ethernet PCIe"},
			{ID: 0x165c, Name: "NetXtreme BCM5724 Gigabit Ethernet PCIe"},
			{ID: 0x165d, Name: "NetXtreme BCM5705M Gigabit Ethernet"},
			{ID: 0x165e, Name: "NetXtreme BCM5705M_2 Gigabit Ethernet"},
			{ID: 0x165f, Name: "NetXtreme BCM5720 Gigabit Ethernet PCIe"},
			{ID: 0x1662, Name: "NetXtreme II BCM57712 10 Gigabit Ethernet"},
			{ID: 0x1663, Name: "NetXtreme II BCM57712 10 Gigabit Ethernet Multi Function"},
			{ID: 0x1665, Name: "NetXtreme BCM5717 Gigabit Ethernet PCIe"},
			{ID: 0x1668, Name: "NetXtreme BCM5714 Gigabit Ethernet"},
			{ID: 0x1669, Name: "NetXtreme 5714S Gigabit Ethernet"},
			{ID: 0x166a, Name: "NetXtreme BCM5780 Gigabit Ethernet"},
			{ID: 0x166b, Name: "NetXtreme BCM5780S Gigabit Ethernet"},
			{ID: 0x166e, Name: "570x 10/100 Integrated Controller"},
			{ID: 0x166f, Name: "NetXtreme II BCM57712 10 Gigabit Ethernet Virtual Function"},
			{ID: 0x1672, Name: "NetXtreme BCM5754M Gigabit Ethernet PCI Express"},
			{ID: 0x1673, Name: "NetXtreme BCM5755M Gigabit Ethernet PCI Express"},
			{ID: 0x1674, Name: "NetXtreme BCM5756ME Gigabit Ethernet PCI Express"},
			{ID: 0x1677, Name: "NetXtreme BCM5751 Gigabit Ethernet PCI Express"},
			{ID: 0x1678, Name: "NetXtreme BCM5715 Gigabit Ethernet"},
			{ID: 0x1679, Name: "NetXtreme BCM5715S Gigabit Ethernet"},
			{ID: 0x167a, Name: "NetXtreme BCM5754 Gigabit Ethernet PCI Express"},
			{ID: 0x167b, Name: "NetXtreme BCM5755 Gigabit Ethernet PCI Express"},
			{ID: 0x167d, Name: "NetXtreme BCM5751M Gigabit Ethernet PCI Express"},
			{ID: 0x167e, Name: "NetXtreme BCM5751F Fast Ethernet PCI Express"},
			{ID: 0x167f, Name: "NetLink BCM5787F Fast Ethernet PCI Express"},
			{ID: 0x1680, Name: "NetXtreme BCM5761e Gigabit Ethernet PCIe"},
			{ID: 0x1681, Name: "NetXtreme BCM5761 Gigabit Ethernet PCIe"},
			{ID: 0x1682, Name: "NetXtreme BCM57762 Gigabit Ethernet PCIe"},
			{ID: 0x1683, Name: "NetXtreme BCM57767 Gigabit Ethernet PCIe"},
			{ID: 0x1684, Name: "NetXtreme BCM5764M Gigabit Ethernet PCIe"},
			{ID: 0x1685, Name: "NetXtreme II BCM57500S Gigabit Ethernet"},
			{ID: 0x1686, Name: "NetXtreme BCM57766 Gigabit Ethernet PCIe"},
			{ID: 0x1687, Name: "NetXtreme BCM5762 Gigabit Ethernet PCIe"},
			{ID: 0x1688, Name: "NetXtreme BCM5761 10/100/1000BASE-T Ethernet"},
			{ID: 0x168a, Name: "NetXtreme II BCM57800 1/10 Gigabit Ethernet"},
			{ID: 0x168d, Name: "NetXtreme II BCM57840 10/20 Gigabit Ethernet"},
			{ID: 0x168e, Name: "NetXtreme II BCM57810 10 Gigabit Ethernet"},
			{ID: 0x1690, Name: "NetXtreme BCM57760 Gigabit Ethernet PCIe"},
			{ID: 0x1691, Name: "NetLink BCM57788 Gigabit Ethernet PCIe"},
			{ID: 0x1692, Name: "NetLink BCM57780 Gigabit Ethernet PCIe"},
			{ID: 0x1693, Name: "NetLink BCM5787M Gigabit Ethernet PCI Express"},
			{ID: 0x1694, Name: "NetLink BCM57790 Gigabit Ethernet PCIe"},
			{ID: 0x1696, Name: "NetXtreme BCM5782 Gigabit Ethernet"},
			{ID: 0x1698, Name: "NetLink BCM5784M Gigabit Ethernet PCIe"},
			{ID: 0x1699, Name: "NetLink BCM5785 Gigabit Ethernet"},
			{ID: 0x169a, Name: "NetLink BCM5786 Gigabit Ethernet PCI Express"},
			{ID: 0x169b, Name: "NetLink BCM5787 Gigabit Ethernet PCI Express"},
			{ID: 0x169c, Name: "NetXtreme BCM5788 Gigabit Ethernet"},
			{ID: 0x169d, Name: "NetLink BCM5789 Gigabit Ethernet PCI Express"},
			{ID: 0x16a0, Name: "NetLink BCM5785 Fast Ethernet"},
			{ID: 0x16a1, Name: "BCM57840 NetXtreme II 10 Gigabit Ethernet"},
			{ID: 0x16a2, Name: "BCM57840 NetXtreme II 10/20-Gigabit Ethernet"},
			{ID: 0x16a3, Name: "NetXtreme BCM57786 Gigabit Ethernet PCIe"},
			{ID: 0x16a4, Name: "BCM57840 NetXtreme II Ethernet Multi Function"},
			{ID: 0x16a5, Name: "NetXtreme II BCM57800 1/10 Gigabit Ethernet Multi Function"},
			{ID: 0x16a6, Name: "NetXtreme BCM5702X Gigabit Ethernet"},
			{ID: 0x16a7, Name: "NetXtreme BCM5703X Gigabit Ethernet"},
			{ID: 0x16a8, Name: "NetXtreme BCM5704S Gigabit Ethernet"},
			{ID: 0x16a9, Name: "NetXtreme II BCM57800 1/10 Gigabit Ethernet Virtual Function"},
			{ID: 0x16aa, Name: "NetXtreme II BCM5706S Gigabit Ethernet"},
			{ID: 0x16ab, Name: "NetXtreme II BCM57840 10/20 Gigabit Ethernet Multi Function"},
			{ID: 0x16ac, Name: "NetXtreme II BCM5708S Gigabit Ethernet"},
			{ID: 0x16ad, Name: "NetXtreme II BCM57840 10/20 Gigabit Ethernet Virtual Function"},
			{ID: 0x16ae, Name: "NetXtreme II BCM57810 10 Gigabit Ethernet Multi Function"},
			{ID: 0x16af, Name: "NetXtreme II BCM57810 10 Gigabit Ethernet Virtual Function"},
			{ID: 0x16b0, Name: "NetXtreme BCM57761 Gigabit Ethernet PCIe"},
			{ID: 0x16b1, Name: "NetLink BCM57781 Gigabit Ethernet PCIe"},
			{ID: 0x16b2, Name: "NetLink BCM57791 Gigabit Ethernet PCIe"},
			{ID: 0x16b3, Name: "NetXtreme BCM57786 Gigabit Ethernet PCIe"},
			{ID: 0x16b4, Name: "NetXtreme BCM57765 Gigabit Ethernet PCIe"},
			{ID: 0x16b5, Name: "NetLink BCM57785 Gigabit Ethernet PCIe"},
			{ID: 0x16b6, Name: "NetLink BCM57795 Gigabit Ethernet PCIe"},
			{ID: 0x16b7, Name: "NetXtreme BCM57782 Gigabit Ethernet PCIe"},
			{ID: 0x16bc, Name: "BCM57765/57785 SDXC/MMC Card Reader"},
			{ID: 0x16be, Name: "BCM57765/57785 MS Card Reader"},
			{ID: 0x16bf, Name: "BCM57765/57785 xD-Picture Card Reader"},
			{ID: 0x16c1, Name: "NetXtreme-E RDMA Virtual Function"},
			{ID: 0x16c6, Name: "NetXtreme BCM5702A3 Gigabit Ethernet"},
			{ID: 0x16c7, Name: "NetXtreme BCM5703 Gigabit Ethernet"},
			{ID: 0x16c8, Name: "BCM57301 NetXtreme-C 10Gb Ethernet Controller"},
			{ID: 0x16c9, Name: "BCM57302 NetXtreme-C 10Gb/25Gb Ethernet Controller"},
			{ID: 0x16ca, Name: "BCM57304 NetXtreme-C 10Gb/25Gb/40Gb/50Gb Ethernet Controller"},
			{ID: 0x16cb, Name: "NetXtreme-C Ethernet Virtual Function"},
			{ID: 0x16cc, Name: "BCM57417 NetXtreme-E Ethernet Partition"},
			{ID: 0x16ce, Name: "BCM57311 NetXtreme-C 10Gb RDMA Ethernet Controller"},
			{ID: 0x16cf, Name: "BCM57312 NetXtreme-C 10Gb/25Gb RDMA Ethernet Controller"},
			{ID: 0x16d0, Name: "BCM57402 NetXtreme-E 10Gb Ethernet Controller"},
			{ID: 0x16d1, Name: "BCM57404 NetXtreme-E 10Gb/25Gb Ethernet Controller"},
			{ID: 0x16d2, Name: "BCM57406 NetXtreme-E 10GBASE-T Ethernet Controller"},
			{ID: 0x16d3, Name: "NetXtreme-E Ethernet Virtual Function"},
			{ID: 0x16d4, Name: "BCM57402 NetXtreme-E Ethernet Partition"},
			{ID: 0x16d5, Name: "BCM57407 NetXtreme-E 10GBase-T Ethernet Controller"},
			{ID: 0x16d6, Name: "BCM57412 NetXtreme-E 10Gb RDMA Ethernet Controller"},
			{ID: 0x16d7, Name: "BCM57414 NetXtreme-E 10Gb/25Gb RDMA Ethernet Controller"},
			{ID: 0x16d8, Name: "BCM57416 NetXtreme-E Dual-Media 10G RDMA Ethernet Controller"},
			{ID: 0x16d9, Name: "BCM57417 NetXtreme-E 10GBASE-T RDMA Ethernet Controller"},
			{ID: 0x16dc, Name: "NetXtreme-E Ethernet Virtual Function"},
			{ID: 0x16dd, Name: "NetLink BCM5781 Gigabit Ethernet PCI Express"},
			{ID: 0x16de, Name: "BCM57412 NetXtreme-E Ethernet Partition"},
			{ID: 0x16df, Name: "BCM57314 NetXtreme-C 10Gb/25Gb/40Gb/50Gb RDMA Ethernet Controller"},
			{ID: 0x16e1, Name: "NetXtreme-C Ethernet Virtual Function"},
			{ID: 0x16e2, Name: "BCM57417 NetXtreme-E 10Gb/25Gb RDMA Ethernet Controller"},
			{ID: 0x16e3, Name: "BCM57416 NetXtreme-E 10Gb RDMA Ethernet Controller"},
			{ID: 0x16e5, Name: "NetXtreme-C RDMA Virtual Function"},
			{ID: 0x16e7, Name: "BCM57404 NetXtreme-E Ethernet Partition"},
			{ID: 0x16e8, Name: "BCM57406 NetXtreme-E Ethernet Partition"},
			{ID: 0x16e9, Name: "BCM57407 NetXtreme-E 25Gb Ethernet Controller"},
			{ID: 0x16eb, Name: "BCM57412 NetXtreme-E RDMA Partition"},
			{ID: 0x16ec, Name: "BCM57414 NetXtreme-E Ethernet Partition"},
			{ID: 0x16ed, Name: "BCM57414 NetXtreme-E RDMA Partition"},
			{ID: 0x16ee, Name: "BCM57416 NetXtreme-E Ethernet Partition"},
			{ID: 0x16ef, Name: "BCM57416 NetXtreme-E RDMA Partition"},
			{ID: 0x16f1, Name: "BCM57452 NetXtreme-E 10Gb/25Gb/40Gb/50Gb Ethernet"},
			{ID: 0x16f3, Name: "NetXtreme BCM5727 Gigabit Ethernet PCIe"},
			{ID: 0x16f7, Name: "NetXtreme BCM5753 Gigabit Ethernet PCI Express"},
			{ID: 0x16fd, Name: "NetXtreme BCM5753M Gigabit Ethernet PCI Express"},
			{ID: 0x16fe, Name: "NetXtreme BCM5753F Fast Ethernet PCI Express"},
			{ID: 0x170c, Name: "BCM4401-B0 100Base-TX"},
			{ID: 0x170d, Name: "NetXtreme BCM5901 100Base-TX"},
			{ID: 0x170e, Name: "NetXtreme BCM5901 100Base-TX"},
			{ID: 0x1712, Name: "NetLink BCM5906 Fast Ethernet PCI Express"},
			{ID: 0x1713, Name: "NetLink BCM5906M Fast Ethernet PCI Express"},
			{ID: 0x1750, Name: "BCM57508 NetXtreme-E 10Gb/25Gb/40Gb/50Gb/100Gb/200Gb Ethernet"},
			{ID: 0x1751, Name: "BCM57504 NetXtreme-E 10Gb/25Gb/40Gb/50Gb/100Gb/200Gb Ethernet"},
			{ID: 0x1752, Name: "BCM57502 NetXtreme-E 10Gb/25Gb/40Gb/50Gb Ethernet"},
			{ID: 0x1800, Name: "BCM57502 NetXtreme-E Ethernet Partition"},
			{ID: 0x1801, Name: "BCM57504 NetXtreme-E Ethernet Partition"},
			{ID: 0x1802, Name: "BCM57508 NetXtreme-E Ethernet Partition"},
			{ID: 0x1803, Name: "BCM57502 NetXtreme-E RDMA Partition"},
			{ID: 0x1804, Name: "BCM57504 NetXtreme-E RDMA Partition"},
			{ID: 0x1805, Name: "BCM57508 NetXtreme-E RDMA Partition"},
			{ID: 0x1806, Name: "BCM5750X NetXtreme-E Ethernet Virtual Function"},
			{ID: 0x1807, Name: "BCM5750X NetXtreme-E RDMA Virtual Function"},
			{ID: 0x1808, Name: "BCM5750X NetXtreme-E Ethernet Virtual Function"},
			{ID: 0x1809, Name: "BCM5750X NetXtreme-E RDMA Virtual Function"},
			{ID: 0x2711, Name: "BCM2711 PCIe Bridge"},
			{ID: 0x3352, Name: "BCM3352"},
			{ID: 0x3360, Name: "BCM3360"},
			{ID: 0x4210, Name: "BCM4210 iLine10 HomePNA 2.0"},
			{ID: 0x4211, Name: "BCM4211 iLine10 HomePNA 2.0 + V.90 56k modem"},
			{ID: 0x4212, Name: "BCM4212 v.90 56k modem"},
			{ID: 0x4220, Name: "802-11b/g Wireless PCI controller, packaged as a Linksys WPC54G ver 1.2 PCMCIA card"},
			{ID: 0x4222, Name: "NetXtreme BCM5753M Gigabit Ethernet PCI Express"},
			{ID: 0x4301, Name: "BCM4301 802.11b Wireless LAN Controller"},
			{ID: 0x4305, Name: "BCM4307 V.90 56k Modem"},
			{ID: 0x4306, Name: "BCM4306 802.11bg Wireless LAN controller"},
			{ID: 0x4307, Name: "BCM4306 802.11bg Wireless LAN Controller"},
			{ID: 0x4310, Name: "BCM4310 Chipcommon I/OController"},
			{ID: 0x4311, Name: "BCM4311 802.11b/g WLAN"},
			{ID: 0x4312, Name: "BCM4311 802.11a/b/g"},
			{ID: 0x4313, Name: "BCM4311 802.11a"},
			{ID: 0x4315, Name: "BCM4312 802.11b/g LP-PHY"},
			{ID: 0x4318, Name: "BCM4318 [AirForce One 54g] 802.11g Wireless LAN Controller"},
			{ID: 0x4319, Name: "BCM4318 [AirForce 54g] 802.11a/b/g PCI Express Transceiver"},
			{ID: 0x4320, Name: "BCM4306 802.11b/g Wireless LAN Controller"},
			{ID: 0x4321, Name: "BCM4321 802.11a Wireless Network Controller"},
			{ID: 0x4322, Name: "BCM4322 802.11bgn Wireless Network Controller"},
			{ID: 0x4324, Name: "BCM4309 802.11abg Wireless Network Controller"},
			{ID: 0x4325, Name: "BCM4306 802.11bg Wireless Network Controller"},
			{ID: 0x4326, Name: "BCM4307 Chipcommon I/O Controller?"},
			{ID: 0x4328, Name: "BCM4321 802.11a/b/g/n"},
			{ID: 0x4329, Name: "BCM4321 802.11b/g/n"},
			{ID: 0x432a, Name: "BCM4321 802.11an Wireless Network Controller"},
			{ID: 0x432b, Name: "BCM4322 802.11a/b/g/n Wireless LAN Controller"},
			{ID: 0x432c, Name: "BCM4322 802.11b/g/n"},
			{ID: 0x432d, Name: "BCM4322 802.11an Wireless Network Controller"},
			{ID: 0x4331, Name: "BCM4331 802.11a/b/g/n"},
			{ID: 0x4333, Name: "Serial (EDGE/GPRS modem part of Option GT Combo Edge)"},
			{ID: 0x4344, Name: "EDGE/GPRS data and 802.11b/g combo cardbus [GC89]"},
			{ID: 0x4350, Name: "BCM43222 Wireless Network Adapter"},
			{ID: 0x4351, Name: "BCM43222 802.11abgn Wireless Network Adapter"},
			{ID: 0x4353, Name: "BCM43224 802.11a/b/g/n"},
			{ID: 0x4357, Name: "BCM43225 802.11b/g/n"},
			{ID: 0x4358, Name: "BCM43227 802.11b/g/n"},
			{ID: 0x4359, Name: "BCM43228 802.11a/b/g/n"},
			{ID: 0x4360, Name: "BCM4360 802.11ac Wireless Network Adapter"},
			{ID: 0x4365, Name: "BCM43142 802.11b/g/n"},
			{ID: 0x43a0, Name: "BCM4360 802.11ac Wireless Network Adapter"},
			{ID: 0x43a1, Name: "BCM4360 802.11ac Wireless Network Adapter"},
			{ID: 0x43a2, Name: "BCM4360 802.11ac Wireless Network Adapter"},
			{ID: 0x43a3, Name: "BCM4350 802.11ac Wireless Network Adapter"},
			{ID: 0x43a9, Name: "BCM43217 802.11b/g/n"},
			{ID: 0x43aa, Name: "BCM43131 802.11b/g/n"},
			{ID: 0x43ae, Name: "BCM43162 802.11ac Wireless Network Adapter"},
			{ID: 0x43b1, Name: "BCM4352 802.11ac Wireless Network Adapter"},
			{ID: 0x43ba, Name: "BCM43602 802.11ac Wireless LAN SoC"},
			{ID: 0x43bb, Name: "BCM43602 802.11ac Wireless LAN SoC"},
			{ID: 0x43bc, Name: "BCM43602 802.11ac Wireless LAN SoC"},
			{ID: 0x43d3, Name: "BCM43567 802.11ac Wireless Network Adapter"},
			{ID: 0x43d9, Name: "BCM43570 802.11ac Wireless Network Adapter"},
			{ID: 0x43dc, Name: "BCM4355 802.11ac Wireless LAN SoC"},
			{ID: 0x43df, Name: "BCM4354 802.11ac Wireless LAN SoC"},
			{ID: 0x43e9, Name: "BCM4358 802.11ac Wireless LAN SoC"},
			{ID: 0x43ec, Name: "BCM4356 802.11ac Wireless Network Adapter"},
			{ID: 0x4401, Name: "BCM4401 100Base-T"},
			{ID: 0x4402, Name: "BCM4402 Integrated 10/100BaseT"},
			{ID: 0x4403, Name: "BCM4402 V.90 56k Modem"},
			{ID: 0x4410, Name: "BCM4413 iLine32 HomePNA 2.0"},
			{ID: 0x4411, Name: "BCM4413 V.90 56k modem"},
			{ID: 0x4412, Name: "BCM4412 10/100BaseT"},
			{ID: 0x4415, Name: "BCM4359 802.11ac Dual-Band Wireless Network Controller"},
			{ID: 0x441f, Name: "BCM4361 802.11ac Dual-Band Wireless Network Controller"},
			{ID: 0x4420, Name: "BCM4361 802.11ac 2.4 GHz Wireless Network Controller"},
			{ID: 0x4421, Name: "BCM4361 802.11ac 5 GHz Wireless Network Controller"},
			{ID: 0x4425, Name: "BRCM4378 Wireless Network Adapter"},
			{ID: 0x4430, Name: "BCM44xx CardBus iLine32 HomePNA 2.0"},
			{ID: 0x4432, Name: "BCM4432 CardBus 10/100BaseT"},
			{ID: 0x4464, Name: "BCM4364 802.11ac Wireless Network Adapter"},
			{ID: 0x4488, Name: "BCM4377b Wireless Network Adapter"},
			{ID: 0x4610, Name: "BCM4610 Sentry5 PCI to SB Bridge"},
			{ID: 0x4611, Name: "BCM4610 Sentry5 iLine32 HomePNA 1.0"},
			{ID: 0x4612, Name: "BCM4610 Sentry5 V.90 56k Modem"},
			{ID: 0x4613, Name: "BCM4610 Sentry5 Ethernet Controller"},
			{ID: 0x4614, Name: "BCM4610 Sentry5 External Interface"},
			{ID: 0x4615, Name: "BCM4610 Sentry5 USB Controller"},
			{ID: 0x4704, Name: "BCM4704 PCI to SB Bridge"},
			{ID: 0x4705, Name: "BCM4704 Sentry5 802.11b Wireless LAN Controller"},
			{ID: 0x4706, Name: "BCM4704 Sentry5 Ethernet Controller"},
			{ID: 0x4707, Name: "BCM4704 Sentry5 USB Controller"},
			{ID: 0x4708, Name: "BCM4704 Crypto Accelerator"},
			{ID: 0x4710, Name: "BCM4710 Sentry5 PCI to SB Bridge"},
			{ID: 0x4711, Name: "BCM47xx Sentry5 iLine32 HomePNA 2.0"},
			{ID: 0x4712, Name: "BCM47xx V.92 56k modem"},
			{ID: 0x4713, Name: "Sentry5 Ethernet Controller"},
			{ID: 0x4714, Name: "BCM47xx Sentry5 External Interface"},
			{ID: 0x4715, Name: "BCM47xx Sentry5 USB / Ethernet Controller"},
			{ID: 0x4716, Name: "BCM47xx Sentry5 USB Host Controller"},
			{ID: 0x4717, Name: "BCM47xx Sentry5 USB Device Controller"},
			{ID: 0x4718, Name: "Sentry5 Crypto Accelerator"},
			{ID: 0x4719, Name: "BCM47xx/53xx RoboSwitch Core"},
			{ID: 0x4720, Name: "BCM4712 MIPS CPU"},
			{ID: 0x4727, Name: "BCM4313 802.11bgn Wireless Network Adapter"},
			{ID: 0x5365, Name: "BCM5365P Sentry5 Host Bridge"},
			{ID: 0x5600, Name: "BCM5600 StrataSwitch 24+2 Ethernet Switch Controller"},
			{ID: 0x5605, Name: "BCM5605 StrataSwitch 24+2 Ethernet Switch Controller"},
			{ID: 0x5615, Name: "BCM5615 StrataSwitch 24+2 Ethernet Switch Controller"},
			{ID: 0x5625, Name: "BCM5625 StrataSwitch 24+2 Ethernet Switch Controller"},
			{ID: 0x5645, Name: "BCM5645 StrataSwitch 24+2 Ethernet Switch Controller"},
			{ID: 0x5670, Name: "BCM5670 8-Port 10GE Ethernet Switch Fabric"},
			{ID: 0x5680, Name: "BCM5680 G-Switch 8 Port Gigabit Ethernet Switch Controller"},
			{ID: 0x5690, Name: "BCM5690 12-port Multi-Layer Gigabit Ethernet Switch"},
			{ID: 0x5691, Name: "BCM5691 GE/10GE 8+2 Gigabit Ethernet Switch Controller"},
			{ID: 0x5692, Name: "BCM5692 12-port Multi-Layer Gigabit Ethernet Switch"},
			{ID: 0x5695, Name: "BCM5695 12-port + HiGig Multi-Layer Gigabit Ethernet Switch"},
			{ID: 0x5698, Name: "BCM5698 12-port Multi-Layer Gigabit Ethernet Switch"},
			{ID: 0x5820, Name: "BCM5820 Crypto Accelerator"},
			{ID: 0x5821, Name: "BCM5821 Crypto Accelerator"},
			{ID: 0x5822, Name: "BCM5822 Crypto Accelerator"},
			{ID: 0x5823, Name: "BCM5823 Crypto Accelerator"},
			{ID: 0x5824, Name: "BCM5824 Crypto Accelerator"},
			{ID: 0x5840, Name: "BCM5840 Crypto Accelerator"},
			{ID: 0x5841, Name: "BCM5841 Crypto Accelerator"},
			{ID: 0x5850, Name: "BCM5850 Crypto Accelerator"},
			{ID: 0x5e87, Name: "Valkyrie offload engine"},
			{ID: 0x5e88, Name: "Viper Offload Engine"},
			{ID: 0x8602, Name: "BCM7400/BCM7405 Serial ATA Controller"},
			{ID: 0x9026, Name: "CN99xx [ThunderX2] Integrated USB 3.0 xHCI Host Controller"},
			{ID: 0x9027, Name: "CN99xx [ThunderX2] Integrated AHCI/SATA 3 Host Controller"},
			{ID: 0xa8d8, Name: "BCM43224/5 Wireless Network Adapter"},
			{ID: 0xaa52, Name: "BCM43602 802.11ac Wireless LAN SoC"},
			{ID: 0xb302, Name: "BCM56302 StrataXGS 24x1GE 2x10GE Switch Controller"},
			{ID: 0xb334, Name: "BCM56334 StrataXGS 24x1GE 4x10GE Switch Controller"},
			{ID: 0xb370, Name: "BCM56370 Switch ASIC"},
			{ID: 0xb371, Name: "BCM56371 Switch ASIC"},
			{ID: 0xb372, Name: "BCM56372 Switch ASIC"},
			{ID: 0xb375, Name: "BCM56375 Switch ASIC"},
			{ID: 0xb376, Name: "BCM56376 Switch ASIC"},
			{ID: 0xb377, Name: "BCM56377 Switch ASIC"},
			{ID: 0xb379, Name: "Broadcom BCM56379 Switch ASIC"},
			{ID: 0xb470, Name: "BCM56470 SWITCH ASIC"},
			{ID: 0xb471, Name: "BCM56471 SWITCH ASIC"},
			{ID: 0xb472, Name: "BCM56472 SWITCH ASIC"},
			{ID: 0xb800, Name: "BCM56800 StrataXGS 10GE Switch Controller"},
			{ID: 0xb842, Name: "BCM56842 Trident 10GE Switch Controller"},
			{ID: 0xb850, Name: "Broadcom BCM56850 Switch ASIC"},
			{ID: 0xb880, Name: "BCM56880 Switch ASIC"},
			{ID: 0xb960, Name: "Broadcom BCM56960 Switch ASIC"},
			{ID: 0xb990, Name: "BCM56990 Switch ASIC"},
			{ID: 0xb996, Name: "BCM56996 Tomahawk4G 106G Switch ASIC"},
			{ID: 0xb998, Name: "BCM56998 Tomahawk4GT 106G Switch ASIC"},
			{ID: 0xb999, Name: "BCM56999 Tomahawk4D 106G Switch ASIC"},
			{ID: 0xc909, Name: "BCM78909 Switch ASIC"},
			{ID: 0xd802, Name: "BCM58802 Stingray 50Gb Ethernet SoC"},
			{ID: 0xd804, Name: "BCM58804 Stingray 100Gb Ethernet SoC"},
		},
	},
	{ID: 0x14e5, Name: "Pixelfusion Ltd", Devices: []Device{}},
	{ID: 0x14e6, Name: "SHINING Technology Inc", Devices: []Device{}},
	{ID: 0x14e7, Name: "3CX", Devices: []Device{}},
	{ID: 0x14e8, Name: "RAYCER Inc", Devices: []Device{}},
	{ID: 0x14e9, Name: "GARNETS System CO Ltd", Devices: []Device{}},
	{
		ID: 0x14ea, Name: "Planex Communications, Inc", Devices: []Device{
			{ID: 0xab06, Name: "FNW-3603-TX CardBus Fast Ethernet"},
			{ID: 0xab07, Name: "RTL81xx RealTek Ethernet"},
			{ID: 0xab08, Name: "FNW-3602-TX CardBus Fast Ethernet"},
		},
	},
	{ID: 0x14eb, Name: "SEIKO EPSON Corp", Devices: []Device{}},
	{
		ID: 0x14ec, Name: "Agilent Technologies", Devices: []Device{
			{ID: 0x0000, Name: "Aciris Digitizer (malformed ID)"},
		},
	},
	{ID: 0x14ed, Name: "DATAKINETICS Ltd", Devices: []Device{}},
	{ID: 0x14ee, Name: "MASPRO KENKOH Corp", Devices: []Device{}},
	{ID: 0x14ef, Name: "CARRY Computer ENG. CO Ltd", Devices: []Device{}},
	{ID: 0x14f0, Name: "CANON RESEACH CENTRE FRANCE", Devices: []Device{}},
	{
		ID: 0x14f1, Name: "Conexant Systems, Inc.", Devices: []Device{
			{ID: 0x1002, Name: "HCF 56k Modem"},
			{ID: 0x1003, Name: "HCF 56k Modem"},
			{ID: 0x1004, Name: "HCF 56k Modem"},
			{ID: 0x1005, Name: "HCF 56k Modem"},
			{ID: 0x1006, Name: "HCF 56k Modem"},
			{ID: 0x1022, Name: "HCF 56k Modem"},
			{ID: 0x1023, Name: "HCF 56k Modem"},
			{ID: 0x1024, Name: "HCF 56k Modem"},
			{ID: 0x1025, Name: "HCF 56k Modem"},
			{ID: 0x1026, Name: "HCF 56k Modem"},
			{ID: 0x1032, Name: "HCF 56k Modem"},
			{ID: 0x1033, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1034, Name: "HCF 56k Data/Fax/Voice Modem"},
			{ID: 0x1035, Name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x1036, Name: "HCF 56k Data/Fax/Voice/Spkp Modem"},
			{ID: 0x1052, Name: "HCF 56k Data/Fax Modem (Worldwide)"},
			{ID: 0x1053, Name: "HCF 56k Data/Fax Modem (Worldwide)"},
			{ID: 0x1054, Name: "HCF 56k Data/Fax/Voice Modem (Worldwide)"},
			{ID: 0x1055, Name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (Worldwide)"},
			{ID: 0x1056, Name: "HCF 56k Data/Fax/Voice/Spkp Modem (Worldwide)"},
			{ID: 0x1057, Name: "HCF 56k Data/Fax/Voice/Spkp Modem (Worldwide)"},
			{ID: 0x1059, Name: "HCF 56k Data/Fax/Voice Modem (Worldwide)"},
			{ID: 0x1063, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1064, Name: "HCF 56k Data/Fax/Voice Modem"},
			{ID: 0x1065, Name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x1066, Name: "HCF 56k Data/Fax/Voice/Spkp Modem"},
			{ID: 0x1085, Name: "HCF V90 56k Data/Fax/Voice/Spkp PCI Modem"},
			{ID: 0x10b6, Name: "CX06834-11 HCF V.92 56k Data/Fax/Voice/Spkp Modem"},
			{ID: 0x1433, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1434, Name: "HCF 56k Data/Fax/Voice Modem"},
			{ID: 0x1435, Name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x1436, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1453, Name: "HCF 56k Data/Fax Modem"},
			{ID: 0x1454, Name: "HCF 56k Data/Fax/Voice Modem"},
			{ID: 0x1455, Name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x1456, Name: "HCF 56k Data/Fax/Voice/Spkp Modem"},
			{ID: 0x1610, Name: "ADSL AccessRunner PCI Arbitration Device"},
			{ID: 0x1611, Name: "AccessRunner PCI ADSL Interface Device"},
			{ID: 0x1620, Name: "AccessRunner V2 PCI ADSL Arbitration Device"},
			{ID: 0x1621, Name: "AccessRunner V2 PCI ADSL Interface Device"},
			{ID: 0x1622, Name: "AccessRunner V2 PCI ADSL Yukon WAN Adapter"},
			{ID: 0x1803, Name: "HCF 56k Modem"},
			{ID: 0x1811, Name: "MiniPCI Network Adapter"},
			{ID: 0x1815, Name: "HCF 56k Modem"},
			{ID: 0x1830, Name: "CX861xx Integrated Host Bridge"},
			{ID: 0x2003, Name: "HSF 56k Data/Fax Modem"},
			{ID: 0x2004, Name: "HSF 56k Data/Fax/Voice Modem"},
			{ID: 0x2005, Name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x2006, Name: "HSF 56k Data/Fax/Voice/Spkp Modem"},
			{ID: 0x2013, Name: "HSF 56k Data/Fax Modem"},
			{ID: 0x2014, Name: "HSF 56k Data/Fax/Voice Modem"},
			{ID: 0x2015, Name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem"},
			{ID: 0x2016, Name: "HSF 56k Data/Fax/Voice/Spkp Modem"},
			{ID: 0x2043, Name: "HSF 56k Data/Fax Modem (WorldW SmartDAA)"},
			{ID: 0x2044, Name: "HSF 56k Data/Fax/Voice Modem (WorldW SmartDAA)"},
			{ID: 0x2045, Name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (WorldW SmartDAA)"},
			{ID: 0x2046, Name: "HSF 56k Data/Fax/Voice/Spkp Modem (WorldW SmartDAA)"},
			{ID: 0x2063, Name: "HSF 56k Data/Fax Modem (SmartDAA)"},
			{ID: 0x2064, Name: "HSF 56k Data/Fax/Voice Modem (SmartDAA)"},
			{ID: 0x2065, Name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (SmartDAA)"},
			{ID: 0x2066, Name: "HSF 56k Data/Fax/Voice/Spkp Modem (SmartDAA)"},
			{ID: 0x2093, Name: "HSF 56k Modem"},
			{ID: 0x2143, Name: "HSF 56k Data/Fax/Cell Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2144, Name: "HSF 56k Data/Fax/Voice/Cell Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2145, Name: "HSF 56k Data/Fax/Voice/Spkp (w/HS)/Cell Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2146, Name: "HSF 56k Data/Fax/Voice/Spkp/Cell Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2163, Name: "HSF 56k Data/Fax/Cell Modem (Mob SmartDAA)"},
			{ID: 0x2164, Name: "HSF 56k Data/Fax/Voice/Cell Modem (Mob SmartDAA)"},
			{ID: 0x2165, Name: "HSF 56k Data/Fax/Voice/Spkp (w/HS)/Cell Modem (Mob SmartDAA)"},
			{ID: 0x2166, Name: "HSF 56k Data/Fax/Voice/Spkp/Cell Modem (Mob SmartDAA)"},
			{ID: 0x2343, Name: "HSF 56k Data/Fax CardBus Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2344, Name: "HSF 56k Data/Fax/Voice CardBus Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2345, Name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) CardBus Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2346, Name: "HSF 56k Data/Fax/Voice/Spkp CardBus Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2363, Name: "HSF 56k Data/Fax CardBus Modem (Mob SmartDAA)"},
			{ID: 0x2364, Name: "HSF 56k Data/Fax/Voice CardBus Modem (Mob SmartDAA)"},
			{ID: 0x2365, Name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) CardBus Modem (Mob SmartDAA)"},
			{ID: 0x2366, Name: "HSF 56k Data/Fax/Voice/Spkp CardBus Modem (Mob SmartDAA)"},
			{ID: 0x2443, Name: "HSF 56k Data/Fax Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2444, Name: "HSF 56k Data/Fax/Voice Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2445, Name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2446, Name: "HSF 56k Data/Fax/Voice/Spkp Modem (Mob WorldW SmartDAA)"},
			{ID: 0x2463, Name: "HSF 56k Data/Fax Modem (Mob SmartDAA)"},
			{ID: 0x2464, Name: "HSF 56k Data/Fax/Voice Modem (Mob SmartDAA)"},
			{ID: 0x2465, Name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) Modem (Mob SmartDAA)"},
			{ID: 0x2466, Name: "HSF 56k Data/Fax/Voice/Spkp Modem (Mob SmartDAA)"},
			{ID: 0x2702, Name: "HSFi modem RD01-D270"},
			{ID: 0x2f00, Name: "HSF 56k HSFi Modem"},
			{ID: 0x2f02, Name: "HSF 56k HSFi Data/Fax"},
			{ID: 0x2f11, Name: "HSF 56k HSFi Modem"},
			{ID: 0x2f20, Name: "HSF 56k Data/Fax Modem"},
			{ID: 0x2f30, Name: "SoftV92 SpeakerPhone SoftRing Modem with SmartSP"},
			{ID: 0x2f50, Name: "Conexant SoftK56 Data/Fax Modem"},
			{ID: 0x510f, Name: "Conexant CX 20751/20752"},
			{ID: 0x5b7a, Name: "CX23418 Single-Chip MPEG-2 Encoder with Integrated Analog Video/Broadcast Audio Decoder"},
			{ID: 0x8200, Name: "CX25850"},
			{ID: 0x8234, Name: "RS8234 ATM SAR Controller [ServiceSAR Plus]"},
			{ID: 0x8800, Name: "CX23880/1/2/3 PCI Video and Audio Decoder"},
			{ID: 0x8801, Name: "CX23880/1/2/3 PCI Video and Audio Decoder [Audio Port]"},
			{ID: 0x8802, Name: "CX23880/1/2/3 PCI Video and Audio Decoder [MPEG Port]"},
			{ID: 0x8804, Name: "CX23880/1/2/3 PCI Video and Audio Decoder [IR Port]"},
			{ID: 0x8811, Name: "CX23880/1/2/3 PCI Video and Audio Decoder [Audio Port]"},
			{ID: 0x8852, Name: "CX23885 PCI Video and Audio Decoder"},
			{ID: 0x8880, Name: "CX23887/8 PCIe Broadcast Audio and Video Decoder with 3D Comb"},
		},
	},
	{
		ID: 0x14f2, Name: "MOBILITY Electronics", Devices: []Device{
			{ID: 0x0120, Name: "EV1000 bridge"},
			{ID: 0x0121, Name: "EV1000 Parallel port"},
			{ID: 0x0122, Name: "EV1000 Serial port"},
			{ID: 0x0123, Name: "EV1000 Keyboard controller"},
			{ID: 0x0124, Name: "EV1000 Mouse controller"},
		},
	},
	{
		ID: 0x14f3, Name: "BroadLogic", Devices: []Device{
			{ID: 0x2030, Name: "2030 DVB-S Satellite Receiver"},
			{ID: 0x2035, Name: "2035 DVB-S Satellite Receiver"},
			{ID: 0x2050, Name: "2050 DVB-T Terrestrial (Cable) Receiver"},
			{ID: 0x2060, Name: "2060 ATSC Terrestrial (Cable) Receiver"},
		},
	},
	{ID: 0x14f4, Name: "TOKYO Electronic Industry CO Ltd", Devices: []Device{}},
	{ID: 0x14f5, Name: "SOPAC Ltd", Devices: []Device{}},
	{ID: 0x14f6, Name: "COYOTE Technologies LLC", Devices: []Device{}},
	{ID: 0x14f7, Name: "WOLF Technology Inc", Devices: []Device{}},
	{
		ID: 0x14f8, Name: "AUDIOCODES Inc", Devices: []Device{
			{ID: 0x2077, Name: "TP-240 dual span E1 VoIP PCI card"},
		},
	},
	{ID: 0x14f9, Name: "AG COMMUNICATIONS", Devices: []Device{}},
	{ID: 0x14fa, Name: "WANDEL & GOLTERMANN", Devices: []Device{}},
	{ID: 0x14fb, Name: "TRANSAS MARINE (UK) Ltd", Devices: []Device{}},
	{
		ID: 0x14fc, Name: "Quadrics Ltd", Devices: []Device{
			{ID: 0x0000, Name: "QsNet Elan3 Network Adapter"},
			{ID: 0x0001, Name: "QsNetII Elan4 Network Adapter"},
			{ID: 0x0002, Name: "QsNetIII Elan5 Network Adapter"},
		},
	},
	{ID: 0x14fd, Name: "JAPAN Computer Industry Inc", Devices: []Device{}},
	{ID: 0x14fe, Name: "ARCHTEK TELECOM Corp", Devices: []Device{}},
	{ID: 0x14ff, Name: "TWINHEAD INTERNATIONAL Corp", Devices: []Device{}},
	{
		ID: 0x1500, Name: "DELTA Electronics, Inc", Devices: []Device{
			{ID: 0x1360, Name: "RTL81xx RealTek Ethernet"},
		},
	},
	{ID: 0x1501, Name: "BANKSOFT CANADA Ltd", Devices: []Device{}},
	{ID: 0x1502, Name: "MITSUBISHI ELECTRIC LOGISTICS SUPPORT Co Ltd", Devices: []Device{}},
	{ID: 0x1503, Name: "KAWASAKI LSI USA Inc", Devices: []Device{}},
	{ID: 0x1504, Name: "KAISER Electronics", Devices: []Device{}},
	{ID: 0x1505, Name: "ITA INGENIEURBURO FUR TESTAUFGABEN GmbH", Devices: []Device{}},
	{ID: 0x1506, Name: "CHAMELEON Systems Inc", Devices: []Device{}},
	{
		ID: 0x1507, Name: "Motorola ?? / HTEC", Devices: []Device{
			{ID: 0x0001, Name: "MPC105 [Eagle]"},
			{ID: 0x0002, Name: "MPC106 [Grackle]"},
			{ID: 0x0003, Name: "MPC8240 [Kahlua]"},
			{ID: 0x0100, Name: "MC145575 [HFC-PCI]"},
			{ID: 0x0431, Name: "KTI829c 100VG"},
			{ID: 0x4801, Name: "Raven"},
			{ID: 0x4802, Name: "Falcon"},
			{ID: 0x4803, Name: "Hawk"},
			{ID: 0x4806, Name: "CPX8216"},
		},
	},
	{ID: 0x1508, Name: "HONDA CONNECTORS/MHOTRONICS Inc", Devices: []Device{}},
	{ID: 0x1509, Name: "FIRST INTERNATIONAL Computer Inc", Devices: []Device{}},
	{ID: 0x150a, Name: "FORVUS RESEARCH Inc", Devices: []Device{}},
	{ID: 0x150b, Name: "YAMASHITA Systems Corp", Devices: []Device{}},
	{ID: 0x150c, Name: "KYOPAL CO Ltd", Devices: []Device{}},
	{ID: 0x150d, Name: "WARPSPPED Inc", Devices: []Device{}},
	{ID: 0x150e, Name: "C-PORT Corp", Devices: []Device{}},
	{ID: 0x150f, Name: "INTEC GmbH", Devices: []Device{}},
	{ID: 0x1510, Name: "BEHAVIOR TECH Computer Corp", Devices: []Device{}},
	{ID: 0x1511, Name: "CENTILLIUM Technology Corp", Devices: []Device{}},
	{ID: 0x1512, Name: "ROSUN Technologies Inc", Devices: []Device{}},
	{ID: 0x1513, Name: "Raychem", Devices: []Device{}},
	{ID: 0x1514, Name: "TFL LAN Inc", Devices: []Device{}},
	{ID: 0x1515, Name: "Advent design", Devices: []Device{}},
	{
		ID: 0x1516, Name: "MYSON Technology Inc", Devices: []Device{
			{ID: 0x0800, Name: "MTD-8xx 100/10M Ethernet PCI Adapter"},
			{ID: 0x0803, Name: "SURECOM EP-320X-S 100/10M Ethernet PCI Adapter"},
			{ID: 0x0891, Name: "MTD-8xx 100/10M Ethernet PCI Adapter"},
		},
	},
	{ID: 0x1517, Name: "ECHOTEK Corp", Devices: []Device{}},
	{ID: 0x1518, Name: "Kontron", Devices: []Device{}},
	{ID: 0x1519, Name: "TELEFON AKTIEBOLAGET LM Ericsson", Devices: []Device{}},
	{
		ID: 0x151a, Name: "Globetek", Devices: []Device{
			{ID: 0x1002, Name: "PCI-1002"},
			{ID: 0x1004, Name: "PCI-1004"},
			{ID: 0x1008, Name: "PCI-1008"},
		},
	},
	{ID: 0x151b, Name: "COMBOX Ltd", Devices: []Device{}},
	{
		ID: 0x151c, Name: "DIGITAL AUDIO LABS Inc", Devices: []Device{
			{ID: 0x0003, Name: "Prodif T 2496"},
			{ID: 0x4000, Name: "Prodif 88"},
		},
	},
	{ID: 0x151d, Name: "Fujitsu Computer Products Of America", Devices: []Device{}},
	{ID: 0x151e, Name: "MATRIX Corp", Devices: []Device{}},
	{
		ID: 0x151f, Name: "TOPIC SEMICONDUCTOR Corp", Devices: []Device{
			{ID: 0x0000, Name: "TP560 Data/Fax/Voice 56k modem"},
		},
	},
	{ID: 0x1520, Name: "CHAPLET System Inc", Devices: []Device{}},
	{ID: 0x1521, Name: "BELL Corp", Devices: []Device{}},
	{
		ID: 0x1522, Name: "MainPine Ltd", Devices: []Device{
			{ID: 0x0100, Name: "PCI <-> IOBus Bridge"},
			{ID: 0x4000, Name: "PCI Express UART"},
		},
	},
	{ID: 0x1523, Name: "MUSIC Semiconductors", Devices: []Device{}},
	{
		ID: 0x1524, Name: "ENE Technology Inc", Devices: []Device{
			{ID: 0x0510, Name: "CB710 Memory Card Reader Controller"},
			{ID: 0x0520, Name: "FLASH memory: ENE Technology Inc:"},
			{ID: 0x0530, Name: "ENE PCI Memory Stick Card Reader Controller"},
			{ID: 0x0550, Name: "ENE PCI Secure Digital Card Reader Controller"},
			{ID: 0x0551, Name: "SD/MMC Card Reader Controller"},
			{ID: 0x0610, Name: "PCI Smart Card Reader Controller"},
			{ID: 0x0720, Name: "Memory Stick Card Reader Controller"},
			{ID: 0x0730, Name: "ENE PCI Memory Stick Card Reader Controller"},
			{ID: 0x0750, Name: "ENE PCI SmartMedia / xD Card Reader Controller"},
			{ID: 0x0751, Name: "ENE PCI Secure Digital / MMC Card Reader Controller"},
			{ID: 0x1211, Name: "CB1211 Cardbus Controller"},
			{ID: 0x1225, Name: "CB1225 Cardbus Controller"},
			{ID: 0x1410, Name: "CB1410 Cardbus Controller"},
			{ID: 0x1411, Name: "CB-710/2/4 Cardbus Controller"},
			{ID: 0x1412, Name: "CB-712/4 Cardbus Controller"},
			{ID: 0x1420, Name: "CB1420 Cardbus Controller"},
			{ID: 0x1421, Name: "CB-720/2/4 Cardbus Controller"},
			{ID: 0x1422, Name: "CB-722/4 Cardbus Controller"},
		},
	},
	{ID: 0x1525, Name: "IMPACT Technologies", Devices: []Device{}},
	{ID: 0x1526, Name: "ISS, Inc", Devices: []Device{}},
	{ID: 0x1527, Name: "SOLECTRON", Devices: []Device{}},
	{ID: 0x1528, Name: "ACKSYS", Devices: []Device{}},
	{ID: 0x1529, Name: "ON Semiconductor", Devices: []Device{}},
	{ID: 0x152a, Name: "QUICKTURN DESIGN Systems", Devices: []Device{}},
	{ID: 0x152b, Name: "FLYTECH Technology CO Ltd", Devices: []Device{}},
	{ID: 0x152c, Name: "MACRAIGOR Systems LLC", Devices: []Device{}},
	{ID: 0x152d, Name: "QUANTA Computer Inc", Devices: []Device{}},
	{ID: 0x152e, Name: "MELEC Inc", Devices: []Device{}},
	{ID: 0x152f, Name: "PHILIPS - CRYPTO", Devices: []Device{}},
	{ID: 0x1530, Name: "ACQIS Technology Inc", Devices: []Device{}},
	{ID: 0x1531, Name: "CHRYON Corp", Devices: []Device{}},
	{
		ID: 0x1532, Name: "ECHELON Corp", Devices: []Device{
			{ID: 0x0020, Name: "LonWorks PCLTA-20 PCI LonTalk Adapter"},
		},
	},
	{ID: 0x1533, Name: "BALTIMORE", Devices: []Device{}},
	{ID: 0x1534, Name: "ROAD Corp", Devices: []Device{}},
	{ID: 0x1535, Name: "EVERGREEN Technologies Inc", Devices: []Device{}},
	{ID: 0x1536, Name: "ACTIS Computer", Devices: []Device{}},
	{ID: 0x1537, Name: "DATALEX COMMUNCATIONS", Devices: []Device{}},
	{
		ID: 0x1538, Name: "ARALION Inc", Devices: []Device{
			{ID: 0x0303, Name: "ARS106S Ultra ATA 133/100/66 Host Controller"},
		},
	},
	{ID: 0x1539, Name: "ATELIER INFORMATIQUES et ELECTRONIQUE ETUDES S.A.", Devices: []Device{}},
	{ID: 0x153a, Name: "ONO SOKKI", Devices: []Device{}},
	{
		ID: 0x153b, Name: "TERRATEC Electronic GmbH", Devices: []Device{
			{ID: 0x1144, Name: "Aureon 5.1"},
			{ID: 0x1147, Name: "Aureon 5.1 Sky"},
			{ID: 0x1158, Name: "Philips Semiconductors SAA7134 (rev 01) [Terratec Cinergy 600 TV]"},
		},
	},
	{ID: 0x153c, Name: "ANTAL Electronic", Devices: []Device{}},
	{ID: 0x153d, Name: "FILANET Corp", Devices: []Device{}},
	{ID: 0x153e, Name: "TECHWELL Inc", Devices: []Device{}},
	{
		ID: 0x153f, Name: "MIPS Technologies, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "SOC-it 101 System Controller"},
		},
	},
	{ID: 0x1540, Name: "PROVIDEO MULTIMEDIA Co Ltd", Devices: []Device{}},
	{ID: 0x1541, Name: "MACHONE Communications", Devices: []Device{}},
	{
		ID: 0x1542, Name: "Concurrent Real-Time", Devices: []Device{
			{ID: 0x9260, Name: "RCIM-II Real-Time Clock & Interrupt Module"},
			{ID: 0x9271, Name: "RCIM-III Real-Time Clock & Interrupt Module (PCIe)"},
			{ID: 0x9272, Name: "Pulse Width Modulator Card"},
			{ID: 0x9273, Name: "RCIM-IV Real-Time Clock & Interrupt Module (PCIe)"},
			{ID: 0x9277, Name: "5 Volt Delta Sigma Converter Card"},
			{ID: 0x9278, Name: "10 Volt Delta Sigma Converter Card"},
			{ID: 0x9287, Name: "Analog Output Card"},
			{ID: 0x9290, Name: "FPGA Card"},
			{ID: 0x9300, Name: "Universal Exhaust Gas Oxygen Sensor Simulator"},
			{ID: 0x9310, Name: "Digital Programmable Resistor"},
			{ID: 0x9350, Name: "Analog Input Card"},
		},
	},
	{
		ID: 0x1543, Name: "SILICON Laboratories", Devices: []Device{
			{ID: 0x3052, Name: "Intel 537 [Winmodem]"},
			{ID: 0x4c22, Name: "Si3036 MC'97 DAA"},
		},
	},
	{ID: 0x1544, Name: "DCM DATA Systems", Devices: []Device{}},
	{ID: 0x1545, Name: "VISIONTEK", Devices: []Device{}},
	{ID: 0x1546, Name: "IOI Technology Corp", Devices: []Device{}},
	{ID: 0x1547, Name: "MITUTOYO Corp", Devices: []Device{}},
	{ID: 0x1548, Name: "JET PROPULSION Laboratory", Devices: []Device{}},
	{ID: 0x1549, Name: "INTERCONNECT Systems Solutions", Devices: []Device{}},
	{ID: 0x154a, Name: "MAX Technologies Inc", Devices: []Device{}},
	{ID: 0x154b, Name: "COMPUTEX Co Ltd", Devices: []Device{}},
	{ID: 0x154c, Name: "VISUAL Technology Inc", Devices: []Device{}},
	{ID: 0x154d, Name: "PAN INTERNATIONAL Industrial Corp", Devices: []Device{}},
	{ID: 0x154e, Name: "SERVOTEST Ltd", Devices: []Device{}},
	{ID: 0x154f, Name: "STRATABEAM Technology", Devices: []Device{}},
	{ID: 0x1550, Name: "OPEN NETWORK Co Ltd", Devices: []Device{}},
	{ID: 0x1551, Name: "SMART Electronic DEVELOPMENT GmBH", Devices: []Device{}},
	{ID: 0x1552, Name: "RACAL AIRTECH Ltd", Devices: []Device{}},
	{ID: 0x1553, Name: "CHICONY Electronics Co Ltd", Devices: []Device{}},
	{ID: 0x1554, Name: "PROLINK Microsystems Corp", Devices: []Device{}},
	{ID: 0x1555, Name: "GESYTEC GmBH", Devices: []Device{}},
	{
		ID: 0x1556, Name: "PLDA", Devices: []Device{
			{ID: 0x1100, Name: "PCI Express Core Reference Design"},
			{ID: 0x110f, Name: "PCI Express Core Reference Design Virtual Function"},
			{ID: 0x1110, Name: "XpressRich Reference Design"},
			{ID: 0x1111, Name: "XpressRich-AXI Ref Design"},
			{ID: 0x1112, Name: "QuickPCIe"},
			{ID: 0x1113, Name: "XpressSwitch"},
			{ID: 0x1114, Name: "Inspector"},
			{ID: 0x1115, Name: "XpressLINK Ref Design"},
			{ID: 0x1116, Name: "XpressLINK-SOC Ref Design"},
			{ID: 0xbe00, Name: "PCI Express Bridge"},
		},
	},
	{ID: 0x1557, Name: "MEDIASTAR Co Ltd", Devices: []Device{}},
	{ID: 0x1558, Name: "CLEVO/KAPOK Computer", Devices: []Device{}},
	{ID: 0x1559, Name: "SI LOGIC Ltd", Devices: []Device{}},
	{ID: 0x155a, Name: "INNOMEDIA Inc", Devices: []Device{}},
	{ID: 0x155b, Name: "PROTAC INTERNATIONAL Corp", Devices: []Device{}},
	{ID: 0x155c, Name: "Cemax-Icon Inc", Devices: []Device{}},
	{ID: 0x155d, Name: "Mac System Co Ltd", Devices: []Device{}},
	{ID: 0x155e, Name: "LP Elektronik GmbH", Devices: []Device{}},
	{ID: 0x155f, Name: "Perle Systems Ltd", Devices: []Device{}},
	{ID: 0x1560, Name: "Terayon Communications Systems", Devices: []Device{}},
	{ID: 0x1561, Name: "Viewgraphics Inc", Devices: []Device{}},
	{ID: 0x1562, Name: "Symbol Technologies", Devices: []Device{}},
	{ID: 0x1563, Name: "A-Trend Technology Co Ltd", Devices: []Device{}},
	{ID: 0x1564, Name: "Yamakatsu Electronics Industry Co Ltd", Devices: []Device{}},
	{ID: 0x1565, Name: "Biostar Microtech Int'l Corp", Devices: []Device{}},
	{ID: 0x1566, Name: "Ardent Technologies Inc", Devices: []Device{}},
	{ID: 0x1567, Name: "Jungsoft", Devices: []Device{}},
	{ID: 0x1568, Name: "DDK Electronics Inc", Devices: []Device{}},
	{ID: 0x1569, Name: "Palit Microsystems Inc.", Devices: []Device{}},
	{ID: 0x156a, Name: "Avtec Systems", Devices: []Device{}},
	{ID: 0x156b, Name: "2wire Inc", Devices: []Device{}},
	{ID: 0x156c, Name: "Vidac Electronics GmbH", Devices: []Device{}},
	{ID: 0x156d, Name: "Alpha-Top Corp", Devices: []Device{}},
	{ID: 0x156e, Name: "Alfa Inc", Devices: []Device{}},
	{ID: 0x156f, Name: "M-Systems Flash Disk Pioneers Ltd", Devices: []Device{}},
	{ID: 0x1570, Name: "Lecroy Corp", Devices: []Device{}},
	{
		ID: 0x1571, Name: "Contemporary Controls", Devices: []Device{
			{ID: 0xa001, Name: "CCSI PCI20-485 ARCnet"},
			{ID: 0xa002, Name: "CCSI PCI20-485D ARCnet"},
			{ID: 0xa003, Name: "CCSI PCI20-485X ARCnet"},
			{ID: 0xa004, Name: "CCSI PCI20-CXB ARCnet"},
			{ID: 0xa005, Name: "CCSI PCI20-CXS ARCnet"},
			{ID: 0xa006, Name: "CCSI PCI20-FOG-SMA ARCnet"},
			{ID: 0xa007, Name: "CCSI PCI20-FOG-ST ARCnet"},
			{ID: 0xa008, Name: "CCSI PCI20-TB5 ARCnet"},
			{ID: 0xa009, Name: "CCSI PCI20-5-485 5Mbit ARCnet"},
			{ID: 0xa00a, Name: "CCSI PCI20-5-485D 5Mbit ARCnet"},
			{ID: 0xa00b, Name: "CCSI PCI20-5-485X 5Mbit ARCnet"},
			{ID: 0xa00c, Name: "CCSI PCI20-5-FOG-ST 5Mbit ARCnet"},
			{ID: 0xa00d, Name: "CCSI PCI20-5-FOG-SMA 5Mbit ARCnet"},
			{ID: 0xa201, Name: "CCSI PCI22-485 10Mbit ARCnet"},
			{ID: 0xa202, Name: "CCSI PCI22-485D 10Mbit ARCnet"},
			{ID: 0xa203, Name: "CCSI PCI22-485X 10Mbit ARCnet"},
			{ID: 0xa204, Name: "CCSI PCI22-CHB 10Mbit ARCnet"},
			{ID: 0xa205, Name: "CCSI PCI22-FOG_ST 10Mbit ARCnet"},
			{ID: 0xa206, Name: "CCSI PCI22-THB 10Mbit ARCnet"},
		},
	},
	{ID: 0x1572, Name: "Otis Elevator Company", Devices: []Device{}},
	{ID: 0x1573, Name: "Lattice - Vantis", Devices: []Device{}},
	{ID: 0x1574, Name: "Fairchild Semiconductor", Devices: []Device{}},
	{ID: 0x1575, Name: "Voltaire Advanced Data Security Ltd", Devices: []Device{}},
	{ID: 0x1576, Name: "Viewcast COM", Devices: []Device{}},
	{
		ID: 0x1578, Name: "HITT", Devices: []Device{
			{ID: 0x4d34, Name: "VPMK4 [Video Processor Mk IV]"},
			{ID: 0x5615, Name: "VPMK3 [Video Processor Mk III]"},
		},
	},
	{ID: 0x1579, Name: "Dual Technology Corp", Devices: []Device{}},
	{ID: 0x157a, Name: "Japan Elecronics Ind Inc", Devices: []Device{}},
	{ID: 0x157b, Name: "Star Multimedia Corp", Devices: []Device{}},
	{
		ID: 0x157c, Name: "Eurosoft (UK)", Devices: []Device{
			{ID: 0x8001, Name: "Fix2000 PCI Y2K Compliance Card"},
		},
	},
	{ID: 0x157d, Name: "Gemflex Networks", Devices: []Device{}},
	{ID: 0x157e, Name: "Transition Networks", Devices: []Device{}},
	{ID: 0x157f, Name: "PX Instruments Technology Ltd", Devices: []Device{}},
	{ID: 0x1580, Name: "Primex Aerospace Co", Devices: []Device{}},
	{ID: 0x1581, Name: "SEH Computertechnik GmbH", Devices: []Device{}},
	{ID: 0x1582, Name: "Cytec Corp", Devices: []Device{}},
	{ID: 0x1583, Name: "Inet Technologies Inc", Devices: []Device{}},
	{ID: 0x1584, Name: "Uniwill Computer Corp", Devices: []Device{}},
	{ID: 0x1585, Name: "Logitron", Devices: []Device{}},
	{ID: 0x1586, Name: "Lancast Inc", Devices: []Device{}},
	{ID: 0x1587, Name: "Konica Corp", Devices: []Device{}},
	{ID: 0x1588, Name: "Solidum Systems Corp", Devices: []Device{}},
	{
		ID: 0x1589, Name: "Atlantek Microsystems Pty Ltd", Devices: []Device{
			{ID: 0x0008, Name: "Leutron Vision PicPortExpress CL"},
			{ID: 0x0009, Name: "Leutron Vision PicPortExpress CL Stereo"},
		},
	},
	{ID: 0x158a, Name: "Digalog Systems Inc", Devices: []Device{}},
	{ID: 0x158b, Name: "Allied Data Technologies", Devices: []Device{}},
	{ID: 0x158c, Name: "Hitachi Semiconductor & Devices Sales Co Ltd", Devices: []Device{}},
	{ID: 0x158d, Name: "Point Multimedia Systems", Devices: []Device{}},
	{ID: 0x158e, Name: "Lara Technology Inc", Devices: []Device{}},
	{ID: 0x158f, Name: "Ditect Coop", Devices: []Device{}},
	{
		ID: 0x1590, Name: "Hewlett Packard Enterprise", Devices: []Device{
			{ID: 0x0001, Name: "Eagle Cluster Manager"},
			{ID: 0x0002, Name: "Osprey Cluster Manager"},
			{ID: 0x0003, Name: "Harrier Cluster Manager"},
			{ID: 0xa01d, Name: "FC044X Fibre Channel HBA"},
		},
	},
	{ID: 0x1591, Name: "ARN", Devices: []Device{}},
	{
		ID: 0x1592, Name: "Syba Tech Ltd", Devices: []Device{
			{ID: 0x0781, Name: "Multi-IO Card"},
			{ID: 0x0782, Name: "Parallel Port Card 2xEPP"},
			{ID: 0x0783, Name: "Multi-IO Card"},
			{ID: 0x0785, Name: "Multi-IO Card"},
			{ID: 0x0786, Name: "Multi-IO Card"},
			{ID: 0x0787, Name: "Multi-IO Card"},
			{ID: 0x0788, Name: "Multi-IO Card"},
			{ID: 0x078a, Name: "Multi-IO Card"},
		},
	},
	{ID: 0x1593, Name: "Bops Inc", Devices: []Device{}},
	{ID: 0x1594, Name: "Netgame Ltd", Devices: []Device{}},
	{ID: 0x1595, Name: "Diva Systems Corp", Devices: []Device{}},
	{ID: 0x1596, Name: "Folsom Research Inc", Devices: []Device{}},
	{ID: 0x1597, Name: "Memec Design Services", Devices: []Device{}},
	{ID: 0x1598, Name: "Granite Microsystems", Devices: []Device{}},
	{ID: 0x1599, Name: "Delta Electronics Inc", Devices: []Device{}},
	{ID: 0x159a, Name: "General Instrument", Devices: []Device{}},
	{
		ID: 0x159b, Name: "Faraday Technology Corp", Devices: []Device{
			{ID: 0x4321, Name: "StorLink SL3516 (Gemini) Host Bridge"},
		},
	},
	{ID: 0x159c, Name: "Stratus Computer Systems", Devices: []Device{}},
	{ID: 0x159d, Name: "Ningbo Harrison Electronics Co Ltd", Devices: []Device{}},
	{ID: 0x159e, Name: "A-Max Technology Co Ltd", Devices: []Device{}},
	{ID: 0x159f, Name: "Galea Network Security", Devices: []Device{}},
	{ID: 0x15a0, Name: "Compumaster SRL", Devices: []Device{}},
	{ID: 0x15a1, Name: "Geocast Network Systems", Devices: []Device{}},
	{
		ID: 0x15a2, Name: "Catalyst Enterprises Inc", Devices: []Device{
			{ID: 0x0001, Name: "TA700 PCI Bus Analyzer/Exerciser"},
		},
	},
	{ID: 0x15a3, Name: "Italtel", Devices: []Device{}},
	{ID: 0x15a4, Name: "X-Net OY", Devices: []Device{}},
	{ID: 0x15a5, Name: "Toyota Macs Inc", Devices: []Device{}},
	{ID: 0x15a6, Name: "Sunlight Ultrasound Technologies Ltd", Devices: []Device{}},
	{ID: 0x15a7, Name: "SSE Telecom Inc", Devices: []Device{}},
	{ID: 0x15a8, Name: "Shanghai Communications Technologies Center", Devices: []Device{}},
	{ID: 0x15aa, Name: "Moreton Bay", Devices: []Device{}},
	{ID: 0x15ab, Name: "Bluesteel Networks Inc", Devices: []Device{}},
	{
		ID: 0x15ac, Name: "North Atlantic Instruments", Devices: []Device{
			{ID: 0x6893, Name: "3U OpenVPX Multi-function I/O Board [Model 68C3]"},
		},
	},
	{
		ID: 0x15ad, Name: "VMware", Devices: []Device{
			{ID: 0x0405, Name: "SVGA II Adapter"},
			{ID: 0x0710, Name: "SVGA Adapter"},
			{ID: 0x0720, Name: "VMXNET Ethernet Controller"},
			{ID: 0x0740, Name: "Virtual Machine Communication Interface"},
			{ID: 0x0770, Name: "USB2 EHCI Controller"},
			{ID: 0x0774, Name: "USB1.1 UHCI Controller"},
			{ID: 0x0778, Name: "USB3 xHCI 0.96 Controller"},
			{ID: 0x0779, Name: "USB3 xHCI 1.0 Controller"},
			{ID: 0x0790, Name: "PCI bridge"},
			{ID: 0x07a0, Name: "PCI Express Root Port"},
			{ID: 0x07b0, Name: "VMXNET3 Ethernet Controller"},
			{ID: 0x07c0, Name: "PVSCSI SCSI Controller"},
			{ID: 0x07e0, Name: "SATA AHCI controller"},
			{ID: 0x0801, Name: "Virtual Machine Interface"},
			{ID: 0x0820, Name: "Paravirtual RDMA controller"},
			{ID: 0x1977, Name: "HD Audio Controller"},
		},
	},
	{ID: 0x15ae, Name: "Amersham Pharmacia Biotech", Devices: []Device{}},
	{ID: 0x15b0, Name: "Zoltrix International Ltd", Devices: []Device{}},
	{ID: 0x15b1, Name: "Source Technology Inc", Devices: []Device{}},
	{ID: 0x15b2, Name: "Mosaid Technologies Inc", Devices: []Device{}},
	{
		ID: 0x15b3, Name: "Mellanox Technologies", Devices: []Device{
			{ID: 0x0191, Name: "MT25408 [ConnectX IB Flash Recovery]"},
			{ID: 0x01f6, Name: "MT27500 Family [ConnectX-3 Flash Recovery]"},
			{ID: 0x01f8, Name: "MT27520 Family [ConnectX-3 Pro Flash Recovery]"},
			{ID: 0x01ff, Name: "MT27600 Family [Connect-IB Flash Recovery]"},
			{ID: 0x0209, Name: "MT27700 Family [ConnectX-4 Flash Recovery]"},
			{ID: 0x020b, Name: "MT27710 Family [ConnectX-4 Lx Flash Recovery]"},
			{ID: 0x020d, Name: "MT28800 Family [ConnectX-5 Flash Recovery]"},
			{ID: 0x020f, Name: "MT28908A0 Family [ConnectX-6 Flash Recovery]"},
			{ID: 0x0210, Name: "MT28908A0 Family [ConnectX-6 Secure Flash Recovery]"},
			{ID: 0x0211, Name: "MT416842 Family [BlueField SoC Flash Recovery]"},
			{ID: 0x0212, Name: "MT2892 Family [ConnectX-6 Dx Flash Recovery]"},
			{ID: 0x0213, Name: "MT2892 Family [ConnectX-6 Dx Secure Flash Recovery]"},
			{ID: 0x0214, Name: "MT42822 Family [BlueField-2 SoC Flash Recovery]"},
			{ID: 0x0215, Name: "MT42822 Family [BlueField-2 Secure Flash Recovery]"},
			{ID: 0x0216, Name: "MT2894 Family [ConnectX-6 Lx Flash Recovery]"},
			{ID: 0x0217, Name: "MT2894 Family [ConnectX-6 Lx Secure Flash Recovery]"},
			{ID: 0x0218, Name: "MT2910 Family [ConnectX-7 Flash Recovery]"},
			{ID: 0x0219, Name: "MT2910 Family [ConnectX-7 Secure Flash Recovery]"},
			{ID: 0x021a, Name: "MT43162 Family [BlueField-3 Lx SoC Flash Recovery]"},
			{ID: 0x021b, Name: "MT43162 Family [BlueField-3 Lx Secure Flash Recovery]"},
			{ID: 0x021c, Name: "MT43244 Family [BlueField-3 SoC Flash Recovery]"},
			{ID: 0x021d, Name: "MT43244 Family [BlueField-3 Secure Flash Recovery]"},
			{ID: 0x021e, Name: "CX8 Family [ConnectX-8 Flash Recovery]"},
			{ID: 0x021f, Name: "CX8 Family [ConnectX-8 Secure Flash Recovery]"},
			{ID: 0x0220, Name: "BF4 Family Flash Recovery [BlueField-4 SoC Flash Recovery]"},
			{ID: 0x0221, Name: "BF4 Family Secure Flash Recovery [BlueField-4 Secure Flash Recovery]"},
			{ID: 0x024e, Name: "MT53100 [Spectrum-2, Flash recovery mode]"},
			{ID: 0x024f, Name: "MT53100 [Spectrum-2, Secure Flash recovery mode]"},
			{ID: 0x0250, Name: "Spectrum-3, Flash recovery mode"},
			{ID: 0x0251, Name: "Spectrum-3, Secure Flash recovery mode"},
			{ID: 0x0252, Name: "Amos chiplet"},
			{ID: 0x0253, Name: "Amos GearBox Manager"},
			{ID: 0x0254, Name: "Spectrum-4, Flash recovery mode"},
			{ID: 0x0255, Name: "Spectrum-4 RMA"},
			{ID: 0x0256, Name: "Abir GearBox"},
			{ID: 0x0257, Name: "Quantum-2 in Flash Recovery Mode"},
			{ID: 0x0258, Name: "Quantum-2 RMA"},
			{ID: 0x0259, Name: "Abir Chiplet"},
			{ID: 0x0262, Name: "MT27710 [ConnectX-4 Lx Programmable] EN"},
			{ID: 0x0263, Name: "MT27710 [ConnectX-4 Lx Programmable Virtual Function] EN"},
			{ID: 0x0264, Name: "Innova-2 Flex Burn image"},
			{ID: 0x0270, Name: "Spectrum-4L, Flash recovery mode"},
			{ID: 0x0271, Name: "Spectrum-4L, RMA"},
			{ID: 0x0274, Name: "Spectrum-4C, Flash recovery mode"},
			{ID: 0x0275, Name: "Spectrum-4C RMA"},
			{ID: 0x0281, Name: "NPS-600 Flash Recovery"},
			{ID: 0x1002, Name: "MT25400 Family [ConnectX-2 Virtual Function]"},
			{ID: 0x1003, Name: "MT27500 Family [ConnectX-3]"},
			{ID: 0x1004, Name: "MT27500/MT27520 Family [ConnectX-3/ConnectX-3 Pro Virtual Function]"},
			{ID: 0x1005, Name: "MT27510 Family"},
			{ID: 0x1006, Name: "MT27511 Family"},
			{ID: 0x1007, Name: "MT27520 Family [ConnectX-3 Pro]"},
			{ID: 0x1009, Name: "MT27530 Family"},
			{ID: 0x100a, Name: "MT27531 Family"},
			{ID: 0x100b, Name: "MT27540 Family"},
			{ID: 0x100c, Name: "MT27541 Family"},
			{ID: 0x100d, Name: "MT27550 Family"},
			{ID: 0x100e, Name: "MT27551 Family"},
			{ID: 0x100f, Name: "MT27560 Family"},
			{ID: 0x1010, Name: "MT27561 Family"},
			{ID: 0x1011, Name: "MT27600 [Connect-IB]"},
			{ID: 0x1012, Name: "MT27600 Family [Connect-IB Virtual Function]"},
			{ID: 0x1013, Name: "MT27700 Family [ConnectX-4]"},
			{ID: 0x1014, Name: "MT27700 Family [ConnectX-4 Virtual Function]"},
			{ID: 0x1015, Name: "MT27710 Family [ConnectX-4 Lx]"},
			{ID: 0x1016, Name: "MT27710 Family [ConnectX-4 Lx Virtual Function]"},
			{ID: 0x1017, Name: "MT27800 Family [ConnectX-5]"},
			{ID: 0x1018, Name: "MT27800 Family [ConnectX-5 Virtual Function]"},
			{ID: 0x1019, Name: "MT28800 Family [ConnectX-5 Ex]"},
			{ID: 0x101a, Name: "MT28800 Family [ConnectX-5 Ex Virtual Function]"},
			{ID: 0x101b, Name: "MT28908 Family [ConnectX-6]"},
			{ID: 0x101c, Name: "MT28908 Family [ConnectX-6 Virtual Function]"},
			{ID: 0x101d, Name: "MT2892 Family [ConnectX-6 Dx]"},
			{ID: 0x101e, Name: "ConnectX Family mlx5Gen Virtual Function"},
			{ID: 0x101f, Name: "MT2894 Family [ConnectX-6 Lx]"},
			{ID: 0x1020, Name: "MT28860"},
			{ID: 0x1021, Name: "MT2910 Family [ConnectX-7]"},
			{ID: 0x1023, Name: "CX8 Family [ConnectX-8]"},
			{ID: 0x1974, Name: "MT28800 Family [ConnectX-5 PCIe Bridge]"},
			{ID: 0x1975, Name: "MT416842 Family [BlueField SoC PCIe Bridge]"},
			{ID: 0x1976, Name: "MT28908 Family [ConnectX-6 PCIe Bridge]"},
			{ID: 0x1977, Name: "MT2892 Family [ConnectX-6 Dx PCIe Bridge]"},
			{ID: 0x1978, Name: "MT42822 Family [BlueField-2 SoC PCIe Bridge]"},
			{ID: 0x1979, Name: "MT2910 Family [ConnectX-7 PCIe Bridge]"},
			{ID: 0x197a, Name: "MT43162 Family [BlueField-3 Lx SoC PCIe Bridge]"},
			{ID: 0x197b, Name: "MT43244 Family [BlueField-3 SoC PCIe Bridge]"},
			{ID: 0x197c, Name: "ConnectX/BlueField Family mlx5Gen PCIe Bridge [PCIe Bridge]"},
			{ID: 0x2020, Name: "MT2892 Family [ConnectX-6 Dx Emulated PCIe Bridge]"},
			{ID: 0x2021, Name: "MT42822 Family [BlueField-2 SoC Emulated PCIe Bridge]"},
			{ID: 0x2023, Name: "MT2910 Family [ConnectX-7 Emulated PCIe Bridge]"},
			{ID: 0x2024, Name: "MT43244 Family [BlueField-3 SoC Emulated PCIe Bridge]"},
			{ID: 0x2025, Name: "ConnectX/BlueField Family mlx5Gen Emulated PCIe Bridge [Emulated PCIe Bridge]"},
			{ID: 0x4117, Name: "MT27712A0-FDCF-AE"},
			{ID: 0x5274, Name: "MT21108 InfiniBridge"},
			{ID: 0x5a44, Name: "MT23108 InfiniHost"},
			{ID: 0x5a45, Name: "MT23108 [Infinihost HCA Flash Recovery]"},
			{ID: 0x5a46, Name: "MT23108 PCI Bridge"},
			{ID: 0x5e8c, Name: "MT24204 [InfiniHost III Lx HCA]"},
			{ID: 0x5e8d, Name: "MT25204 [InfiniHost III Lx HCA Flash Recovery]"},
			{ID: 0x6001, Name: "NVMe SNAP Controller"},
			{ID: 0x6274, Name: "MT25204 [InfiniHost III Lx HCA]"},
			{ID: 0x6278, Name: "MT25208 InfiniHost III Ex (Tavor compatibility mode)"},
			{ID: 0x6279, Name: "MT25208 [InfiniHost III Ex HCA Flash Recovery]"},
			{ID: 0x6282, Name: "MT25208 [InfiniHost III Ex]"},
			{ID: 0x6340, Name: "MT25408A0-FCC-SI ConnectX, Dual Port 10Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 2.5GT/s Interface"},
			{ID: 0x634a, Name: "MT25408A0-FCC-DI ConnectX, Dual Port 20Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 2.5GT/s Interface"},
			{ID: 0x6368, Name: "MT25448 [ConnectX EN 10GigE, PCIe 2.0 2.5GT/s]"},
			{ID: 0x6372, Name: "MT25458 ConnectX EN 10GBASE-T PCIe 2.5 GT/s"},
			{ID: 0x6732, Name: "MT25408A0-FCC-GI ConnectX, Dual Port 20Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 5.0GT/s Interface"},
			{ID: 0x673c, Name: "MT25408A0-FCC-QI ConnectX, Dual Port 40Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 5.0GT/s Interface"},
			{ID: 0x6746, Name: "MT26438 [ConnectX VPI PCIe 2.0 5GT/s - IB QDR / 10GigE Virtualization+]"},
			{ID: 0x6750, Name: "MT26448 [ConnectX EN 10GigE, PCIe 2.0 5GT/s]"},
			{ID: 0x675a, Name: "MT26458 ConnectX EN 10GBASE-T PCIe Gen2 5.0 GT/s"},
			{ID: 0x6764, Name: "MT26468 [ConnectX EN 10GigE, PCIe 2.0 5GT/s Virtualization+]"},
			{ID: 0x676e, Name: "MT26478 [ConnectX EN 40GigE, PCIe 2.0 5GT/s]"},
			{ID: 0x6778, Name: "MT26488 [ConnectX VPI PCIe 2.0 5GT/s - IB DDR / 10GigE Virtualization+]"},
			{ID: 0x7101, Name: "NPS-400 configuration and management interface"},
			{ID: 0x7102, Name: "NPS-400 network interface PF"},
			{ID: 0x7103, Name: "NPS-400 network interface VF"},
			{ID: 0x7121, Name: "NPS-600 configuration and management interface"},
			{ID: 0x7122, Name: "NPS-600 network interface PF"},
			{ID: 0x7123, Name: "NPS-600 network interface VF"},
			{ID: 0x8200, Name: "Innova-2 Flex Shell Logic"},
			{ID: 0xa2d0, Name: "MT416842 BlueField SoC Crypto enabled"},
			{ID: 0xa2d1, Name: "MT416842 BlueField SoC Crypto disabled"},
			{ID: 0xa2d2, Name: "MT416842 BlueField integrated ConnectX-5 network controller"},
			{ID: 0xa2d3, Name: "MT416842 BlueField multicore SoC family VF"},
			{ID: 0xa2d4, Name: "MT42822 BlueField-2 SoC Crypto enabled"},
			{ID: 0xa2d5, Name: "MT42822 BlueField-2 SoC Crypto disabled"},
			{ID: 0xa2d6, Name: "MT42822 BlueField-2 integrated ConnectX-6 Dx network controller"},
			{ID: 0xa2d7, Name: "MT43162 BlueField-3 Lx SoC Crypto enabled"},
			{ID: 0xa2d8, Name: "MT43162 BlueField-3 Lx SoC Crypto disabled"},
			{ID: 0xa2d9, Name: "MT43162 BlueField-3 Lx integrated ConnectX-7 network controller"},
			{ID: 0xa2da, Name: "MT43244 BlueField-3 SoC Crypto enabled"},
			{ID: 0xa2db, Name: "MT43244 BlueField-3 SoC Crypto disabled"},
			{ID: 0xa2dc, Name: "MT43244 BlueField-3 integrated ConnectX-7 network controller"},
			{ID: 0xa2dd, Name: "BF4 Family Crypto enabled [BlueField-4 SoC Crypto enabled]"},
			{ID: 0xa2de, Name: "BF4 Family Crypto disabled [BlueField-4 SoC Crypto disabled]"},
			{ID: 0xa2df, Name: "BF4 Family integrated network controller [BlueField-4 integrated network controller]"},
			{ID: 0xc2d2, Name: "MT416842 BlueField SoC management interfac"},
			{ID: 0xc2d3, Name: "MT42822 BlueField-2 SoC Management Interface"},
			{ID: 0xc2d4, Name: "MT43162 BlueField-3 Lx SoC Management Interface"},
			{ID: 0xc2d5, Name: "MT43244 BlueField-3 SoC Management Interface"},
			{ID: 0xc2d6, Name: "BF4 Family Management Interface [BlueField-4 SoC Management Interface]"},
			{ID: 0xc738, Name: "MT51136"},
			{ID: 0xc739, Name: "MT51136 GW"},
			{ID: 0xc838, Name: "MT52236"},
			{ID: 0xc839, Name: "MT52236 router"},
			{ID: 0xcaf1, Name: "ConnectX-4 CAPI Function"},
			{ID: 0xcb84, Name: "MT52100"},
			{ID: 0xcf08, Name: "Switch-IB2"},
			{ID: 0xcf6c, Name: "MT53100 [Spectrum-2]"},
			{ID: 0xcf70, Name: "Spectrum-3"},
			{ID: 0xcf80, Name: "Spectrum-4"},
			{ID: 0xcf82, Name: "Spectrum-4L"},
			{ID: 0xcf84, Name: "Spectrum-4C"},
			{ID: 0xd2f0, Name: "Quantum HDR (200Gbps) switch"},
			{ID: 0xd2f2, Name: "Quantum-2 NDR (400Gbps) switch"},
		},
	},
	{ID: 0x15b4, Name: "CCI/TRIAD", Devices: []Device{}},
	{ID: 0x15b5, Name: "Cimetrics Inc", Devices: []Device{}},
	{
		ID: 0x15b6, Name: "Texas Memory Systems Inc", Devices: []Device{
			{ID: 0x0001, Name: "XP15 DSP Accelerator"},
			{ID: 0x0002, Name: "XP30 DSP Accelerator"},
			{ID: 0x0003, Name: "XP00 Data Acquisition Device"},
			{ID: 0x0004, Name: "XP35 DSP Accelerator"},
			{ID: 0x0007, Name: "XP100 DSP Accelerator [XP100-T0]"},
			{ID: 0x0008, Name: "XP100 DSP Accelerator [XP100-T1]"},
			{ID: 0x0009, Name: "XP100 DSP Accelerator [XP100-E0]"},
			{ID: 0x000a, Name: "XP100 DSP Accelerator [XP100-E1]"},
			{ID: 0x000e, Name: "XP100 DSP Accelerator [XP100-0]"},
			{ID: 0x000f, Name: "XP100 DSP Accelerator [XP100-1]"},
			{ID: 0x0010, Name: "XP100 DSP Accelerator [XP100-P0]"},
			{ID: 0x0011, Name: "XP100 DSP Accelerator [XP100-P1]"},
			{ID: 0x0012, Name: "XP100 DSP Accelerator [XP100-P2]"},
			{ID: 0x0013, Name: "XP100 DSP Accelerator [XP100-P3]"},
			{ID: 0x0014, Name: "RamSan Flash SSD"},
			{ID: 0x0015, Name: "ZBox"},
		},
	},
	{
		ID: 0x15b7, Name: "Sandisk Corp", Devices: []Device{
			{ID: 0x2001, Name: "Skyhawk Series NVME SSD"},
			{ID: 0x5001, Name: "WD Black NVMe SSD"},
			{ID: 0x5002, Name: "WD Black 2018/SN750 / PC SN720 NVMe SSD"},
			{ID: 0x5003, Name: "WD Blue SN500 / PC SN520 NVMe SSD"},
			{ID: 0x5004, Name: "PC SN520 NVMe SSD"},
			{ID: 0x5005, Name: "PC SN520 NVMe SSD"},
			{ID: 0x5006, Name: "WD Black SN750 / PC SN730 NVMe SSD"},
			{ID: 0x5009, Name: "WD Blue SN550 NVMe SSD"},
			{ID: 0x500b, Name: "PC SN530 NVMe SSD"},
			{ID: 0x500d, Name: "WD Ultrastar DC SN340 NVMe SSD"},
			{ID: 0x5011, Name: "WD PC SN810 / Black SN850 NVMe SSD"},
			{ID: 0x501a, Name: "WD Blue SN570 NVMe SSD"},
		},
	},
	{
		ID: 0x15b8, Name: "ADDI-DATA GmbH", Devices: []Device{
			{ID: 0x1001, Name: "APCI1516 SP controller (16 digi outputs)"},
			{ID: 0x1003, Name: "APCI1032 SP controller (32 digi inputs w/ opto coupler)"},
			{ID: 0x1004, Name: "APCI2032 SP controller (32 digi outputs)"},
			{ID: 0x1005, Name: "APCI2200 SP controller (8/16 digi outputs (relay))"},
			{ID: 0x1006, Name: "APCI1564 SP controller (32 digi ins, 32 digi outs)"},
			{ID: 0x100a, Name: "APCI1696 SP controller (96 TTL I/Os)"},
			{ID: 0x3001, Name: "APCI3501 SP controller (analog output board)"},
			{ID: 0x300f, Name: "APCI3600 Noise and vibration measurement board"},
			{ID: 0x7001, Name: "APCI7420 2-port Serial Controller"},
			{ID: 0x7002, Name: "APCI7300 Serial Controller"},
		},
	},
	{ID: 0x15b9, Name: "Maestro Digital Communications", Devices: []Device{}},
	{ID: 0x15ba, Name: "Impacct Technology Corp", Devices: []Device{}},
	{ID: 0x15bb, Name: "Portwell Inc", Devices: []Device{}},
	{
		ID: 0x15bc, Name: "Agilent Technologies", Devices: []Device{
			{ID: 0x0100, Name: "HPFC-5600 Tachyon DX2+ FC"},
			{ID: 0x0103, Name: "QX4 PCI Express quad 4-gigabit Fibre Channel controller"},
			{ID: 0x0105, Name: "Celerity FC-44XS/FC-42XS/FC-41XS/FC-44ES/FC-42ES/FC-41ES"},
			{ID: 0x1100, Name: "E8001-66442 PCI Express CIC"},
			{ID: 0x2922, Name: "64 Bit, 133MHz PCI-X Exerciser & Protocol Checker"},
			{ID: 0x2928, Name: "64 Bit, 66MHz PCI Exerciser & Analyzer"},
			{ID: 0x2929, Name: "64 Bit, 133MHz PCI-X Analyzer & Exerciser"},
		},
	},
	{ID: 0x15bd, Name: "DFI Inc", Devices: []Device{}},
	{ID: 0x15be, Name: "Sola Electronics", Devices: []Device{}},
	{ID: 0x15bf, Name: "High Tech Computer Corp (HTC)", Devices: []Device{}},
	{ID: 0x15c0, Name: "BVM Ltd", Devices: []Device{}},
	{ID: 0x15c1, Name: "Quantel", Devices: []Device{}},
	{ID: 0x15c2, Name: "Newer Technology Inc", Devices: []Device{}},
	{ID: 0x15c3, Name: "Taiwan Mycomp Co Ltd", Devices: []Device{}},
	{ID: 0x15c4, Name: "EVSX Inc", Devices: []Device{}},
	{
		ID: 0x15c5, Name: "Procomp Informatics Ltd", Devices: []Device{
			{ID: 0x8010, Name: "1394b - 1394 Firewire 3-Port Host Adapter Card"},
		},
	},
	{ID: 0x15c6, Name: "Technical University of Budapest", Devices: []Device{}},
	{
		ID: 0x15c7, Name: "Tateyama System Laboratory Co Ltd", Devices: []Device{
			{ID: 0x0349, Name: "Tateyama C-PCI PLC/NC card Rev.01A"},
		},
	},
	{ID: 0x15c8, Name: "Penta Media Co Ltd", Devices: []Device{}},
	{ID: 0x15c9, Name: "Serome Technology Inc", Devices: []Device{}},
	{ID: 0x15ca, Name: "Bitboys OY", Devices: []Device{}},
	{ID: 0x15cb, Name: "AG Electronics Ltd", Devices: []Device{}},
	{ID: 0x15cc, Name: "Hotrail Inc", Devices: []Device{}},
	{ID: 0x15cd, Name: "Dreamtech Co Ltd", Devices: []Device{}},
	{ID: 0x15ce, Name: "Genrad Inc", Devices: []Device{}},
	{
		ID: 0x15cf, Name: "Hilscher GmbH", Devices: []Device{
			{ID: 0x0000, Name: "CIFX 50E-DP(M/S)"},
		},
	},
	{ID: 0x15d1, Name: "Infineon Technologies AG", Devices: []Device{}},
	{ID: 0x15d2, Name: "FIC (First International Computer Inc)", Devices: []Device{}},
	{ID: 0x15d3, Name: "NDS Technologies Israel Ltd", Devices: []Device{}},
	{ID: 0x15d4, Name: "Iwill Corp", Devices: []Device{}},
	{ID: 0x15d5, Name: "Tatung Co", Devices: []Device{}},
	{ID: 0x15d6, Name: "Entridia Corp", Devices: []Device{}},
	{ID: 0x15d7, Name: "Rockwell-Collins Inc", Devices: []Device{}},
	{ID: 0x15d8, Name: "Cybernetics Technology Co Ltd", Devices: []Device{}},
	{ID: 0x15d9, Name: "Super Micro Computer Inc", Devices: []Device{}},
	{ID: 0x15da, Name: "Cyberfirm Inc", Devices: []Device{}},
	{ID: 0x15db, Name: "Applied Computing Systems Inc", Devices: []Device{}},
	{
		ID: 0x15dc, Name: "Litronic Inc", Devices: []Device{
			{ID: 0x0001, Name: "Argus 300 PCI Cryptography Module"},
		},
	},
	{ID: 0x15dd, Name: "Sigmatel Inc", Devices: []Device{}},
	{ID: 0x15de, Name: "Malleable Technologies Inc", Devices: []Device{}},
	{ID: 0x15df, Name: "Infinilink Corp", Devices: []Device{}},
	{ID: 0x15e0, Name: "Cacheflow Inc", Devices: []Device{}},
	{ID: 0x15e1, Name: "Voice Technologies Group Inc", Devices: []Device{}},
	{
		ID: 0x15e2, Name: "Quicknet Technologies Inc", Devices: []Device{
			{ID: 0x0500, Name: "PhoneJack-PCI"},
		},
	},
	{ID: 0x15e3, Name: "Networth Technologies Inc", Devices: []Device{}},
	{ID: 0x15e4, Name: "VSN Systemen BV", Devices: []Device{}},
	{ID: 0x15e5, Name: "Valley technologies Inc", Devices: []Device{}},
	{ID: 0x15e6, Name: "Agere Inc", Devices: []Device{}},
	{ID: 0x15e7, Name: "Get Engineering Corp", Devices: []Device{}},
	{
		ID: 0x15e8, Name: "National Datacomm Corp", Devices: []Device{
			{ID: 0x0130, Name: "Wireless PCI Card"},
			{ID: 0x0131, Name: "NCP130A2 Wireless NIC"},
		},
	},
	{
		ID: 0x15e9, Name: "Pacific Digital Corp", Devices: []Device{
			{ID: 0x1841, Name: "ADMA-100 DiscStaQ ATA Controller"},
		},
	},
	{ID: 0x15ea, Name: "Tokyo Denshi Sekei K.K.", Devices: []Device{}},
	{ID: 0x15eb, Name: "DResearch Digital Media Systems GmbH", Devices: []Device{}},
	{
		ID: 0x15ec, Name: "Beckhoff GmbH", Devices: []Device{
			{ID: 0x3101, Name: "FC3101 Profibus DP 1 Channel PCI"},
			{ID: 0x5102, Name: "FC5102"},
		},
	},
	{ID: 0x15ed, Name: "Macrolink Inc", Devices: []Device{}},
	{ID: 0x15ee, Name: "In Win Development Inc", Devices: []Device{}},
	{ID: 0x15ef, Name: "Intelligent Paradigm Inc", Devices: []Device{}},
	{ID: 0x15f0, Name: "B-Tree Systems Inc", Devices: []Device{}},
	{ID: 0x15f1, Name: "Times N Systems Inc", Devices: []Device{}},
	{ID: 0x15f2, Name: "Diagnostic Instruments Inc", Devices: []Device{}},
	{ID: 0x15f3, Name: "Digitmedia Corp", Devices: []Device{}},
	{ID: 0x15f4, Name: "Valuesoft", Devices: []Device{}},
	{ID: 0x15f5, Name: "Power Micro Research", Devices: []Device{}},
	{ID: 0x15f6, Name: "Extreme Packet Device Inc", Devices: []Device{}},
	{ID: 0x15f7, Name: "Banctec", Devices: []Device{}},
	{ID: 0x15f8, Name: "Koga Electronics Co", Devices: []Device{}},
	{ID: 0x15f9, Name: "Zenith Electronics Corp", Devices: []Device{}},
	{ID: 0x15fa, Name: "J.P. Axzam Corp", Devices: []Device{}},
	{ID: 0x15fb, Name: "Zilog Inc", Devices: []Device{}},
	{ID: 0x15fc, Name: "Techsan Electronics Co Ltd", Devices: []Device{}},
	{ID: 0x15fd, Name: "N-CUBED.NET", Devices: []Device{}},
	{ID: 0x15fe, Name: "Kinpo Electronics Inc", Devices: []Device{}},
	{ID: 0x15ff, Name: "Fastpoint Technologies Inc", Devices: []Device{}},
	{ID: 0x1600, Name: "Northrop Grumman - Canada Ltd", Devices: []Device{}},
	{ID: 0x1601, Name: "Tenta Technology", Devices: []Device{}},
	{ID: 0x1602, Name: "Prosys-tec Inc", Devices: []Device{}},
	{ID: 0x1603, Name: "Nokia Wireless Communications", Devices: []Device{}},
	{ID: 0x1604, Name: "Central System Research Co Ltd", Devices: []Device{}},
	{ID: 0x1605, Name: "Pairgain Technologies", Devices: []Device{}},
	{ID: 0x1606, Name: "Europop AG", Devices: []Device{}},
	{ID: 0x1607, Name: "Lava Semiconductor Manufacturing Inc", Devices: []Device{}},
	{ID: 0x1608, Name: "Automated Wagering International", Devices: []Device{}},
	{ID: 0x1609, Name: "Scimetric Instruments Inc", Devices: []Device{}},
	{ID: 0x1612, Name: "Telesynergy Research Inc.", Devices: []Device{}},
	{
		ID: 0x1618, Name: "Stone Ridge Technology", Devices: []Device{
			{ID: 0x0001, Name: "RDX 11"},
			{ID: 0x0002, Name: "HFT-01"},
			{ID: 0x0400, Name: "FarSync T2P (2 port X.21/V.35/V.24)"},
			{ID: 0x0440, Name: "FarSync T4P (4 port X.21/V.35/V.24)"},
			{ID: 0x0610, Name: "FarSync T1U (1 port X.21/V.35/V.24)"},
			{ID: 0x0620, Name: "FarSync T2U (2 port X.21/V.35/V.24)"},
			{ID: 0x0640, Name: "FarSync T4U (4 port X.21/V.35/V.24)"},
			{ID: 0x1610, Name: "FarSync TE1 (T1,E1)"},
			{ID: 0x2610, Name: "FarSync DSL-S1 (SHDSL)"},
			{ID: 0x3640, Name: "FarSync T4E (4-port X.21/V.35/V.24)"},
			{ID: 0x4620, Name: "FarSync T2Ue PCI Express (2-port X.21/V.35/V.24)"},
			{ID: 0x4640, Name: "FarSync T4Ue PCI Express (4-port X.21/V.35/V.24)"},
		},
	},
	{
		ID: 0x1619, Name: "FarSite Communications Ltd", Devices: []Device{
			{ID: 0x0400, Name: "FarSync T2P (2 port X.21/V.35/V.24)"},
			{ID: 0x0440, Name: "FarSync T4P (4 port X.21/V.35/V.24)"},
			{ID: 0x0610, Name: "FarSync T1U (1 port X.21/V.35/V.24)"},
			{ID: 0x0620, Name: "FarSync T2U (2 port X.21/V.35/V.24)"},
			{ID: 0x0640, Name: "FarSync T4U (4 port X.21/V.35/V.24)"},
			{ID: 0x1610, Name: "FarSync TE1 (T1,E1)"},
			{ID: 0x1612, Name: "FarSync TE1 PCI Express (T1,E1)"},
			{ID: 0x2610, Name: "FarSync DSL-S1 (SHDSL)"},
			{ID: 0x3640, Name: "FarSync T4E (4-port X.21/V.35/V.24)"},
			{ID: 0x4620, Name: "FarSync T2Ue PCI Express (2-port X.21/V.35/V.24)"},
			{ID: 0x4640, Name: "FarSync T4Ue PCI Express (4-port X.21/V.35/V.24)"},
			{ID: 0x5621, Name: "FarSync T2Ee PCI Express (2 port X.21/V.35/V.24)"},
			{ID: 0x5641, Name: "FarSync T4Ee PCI Express (4 port X.21/V.35/V.24)"},
			{ID: 0x6620, Name: "FarSync T2U-PMC PCI Express (2 port X.21/V.35/V.24)"},
		},
	},
	{ID: 0x161f, Name: "Rioworks", Devices: []Device{}},
	{
		ID: 0x1621, Name: "Lynx Studio Technology, Inc.", Devices: []Device{
			{ID: 0x0020, Name: "LynxTWO-A"},
			{ID: 0x0021, Name: "LynxTWO-B"},
			{ID: 0x0022, Name: "LynxTWO-C"},
			{ID: 0x0023, Name: "Lynx L22"},
			{ID: 0x0024, Name: "Lynx AES16"},
			{ID: 0x0025, Name: "Lynx AES16-SRC"},
			{ID: 0x0028, Name: "Lynx AES16e"},
		},
	},
	{
		ID: 0x1626, Name: "TDK Semiconductor Corp.", Devices: []Device{
			{ID: 0x8410, Name: "RTL81xx Fast Ethernet"},
		},
	},
	{
		ID: 0x1629, Name: "Kongsberg Spacetec AS", Devices: []Device{
			{ID: 0x1003, Name: "Format synchronizer v3.0"},
			{ID: 0x1006, Name: "Format synchronizer, model 10500"},
			{ID: 0x1007, Name: "Format synchronizer, model 21000"},
			{ID: 0x2002, Name: "Fast Universal Data Output"},
			{ID: 0x3100, Name: "IO31000 Frame Synchronizer and I/O"},
			{ID: 0x3200, Name: "IO32000 Frame Synchronizer and I/O"},
			{ID: 0x4002, Name: "High Rate Demodulator"},
			{ID: 0x5001, Name: "High Rate FEC"},
			{ID: 0x6001, Name: "High Rate Demodulator and FEC"},
		},
	},
	{ID: 0x1631, Name: "Packard Bell B.V.", Devices: []Device{}},
	{
		ID: 0x1638, Name: "Standard Microsystems Corp [SMC]", Devices: []Device{
			{ID: 0x1100, Name: "SMC2602W EZConnect / Addtron AWA-100 / Eumitcom PCI WL11000"},
		},
	},
	{
		ID: 0x163c, Name: "Smart Link Ltd.", Devices: []Device{
			{ID: 0x3052, Name: "SmartLink SmartPCI562 56K Modem"},
			{ID: 0x5449, Name: "SmartPCI561 Modem"},
		},
	},
	{ID: 0x1641, Name: "MKNet Corp.", Devices: []Device{}},
	{ID: 0x1642, Name: "Bitland(ShenZhen) Information Technology Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1657, Name: "Cavium QLogic", Devices: []Device{
			{ID: 0x0013, Name: "425/825/42B/82B 4Gbps/8Gbps PCIe dual port FC HBA"},
			{ID: 0x0014, Name: "1010/1020/1007/1741 10Gbps CNA"},
			{ID: 0x0017, Name: "415/815/41B/81B 4Gbps/8Gbps PCIe single port FC HBA"},
			{ID: 0x0021, Name: "804 8Gbps FC HBA for HP Bladesystem c-class"},
			{ID: 0x0022, Name: "BR-1860 Fabric Adapter"},
			{ID: 0x0023, Name: "1867/1869 16Gbps FC HBA"},
			{ID: 0x0646, Name: "400 4Gbps PCIe FC HBA"},
		},
	},
	{
		ID: 0x165a, Name: "Epix Inc", Devices: []Device{
			{ID: 0xc100, Name: "PIXCI(R) CL1 Camera Link Video Capture Board [custom QL5232]"},
			{ID: 0xd200, Name: "PIXCI(R) D2X Digital Video Capture Board [custom QL5232]"},
			{ID: 0xd300, Name: "PIXCI(R) D3X Digital Video Capture Board [custom QL5232]"},
			{ID: 0xeb01, Name: "PIXCI(R) EB1 PCI Camera Link Video Capture Board"},
		},
	},
	{
		ID: 0x165c, Name: "Gidel Ltd.", Devices: []Device{
			{ID: 0x5361, Name: "PROCStarII60-1"},
			{ID: 0x5362, Name: "PROCStarII60-2"},
			{ID: 0x5364, Name: "PROCStarII60-4"},
			{ID: 0x5435, Name: "ProcSparkII"},
			{ID: 0x5661, Name: "ProcE60"},
			{ID: 0x56e1, Name: "ProcE180"},
			{ID: 0x5911, Name: "ProcStarIII110-1"},
			{ID: 0x5912, Name: "ProcStarIII110-2"},
			{ID: 0x5913, Name: "ProcStarIII110-3"},
			{ID: 0x5914, Name: "ProcStarIII110-4"},
			{ID: 0x5921, Name: "ProcStarIII150-1"},
			{ID: 0x5922, Name: "ProcStarIII150-2"},
			{ID: 0x5923, Name: "ProcStarIII150-3"},
			{ID: 0x5924, Name: "ProcStarIII150-4"},
			{ID: 0x5931, Name: "ProcStarIII260-1"},
			{ID: 0x5932, Name: "ProcStarIII260-2"},
			{ID: 0x5933, Name: "ProcStarIII260-3"},
			{ID: 0x5934, Name: "ProcStarIII260-4"},
			{ID: 0x5941, Name: "ProcStarIII340-1"},
			{ID: 0x5942, Name: "ProcStarIII340-2"},
			{ID: 0x5943, Name: "ProcStarIII340-3"},
			{ID: 0x5944, Name: "ProcStarIII340-4"},
			{ID: 0x5a01, Name: "ProceIII80"},
			{ID: 0x5a11, Name: "ProceIII110"},
			{ID: 0x5a21, Name: "ProceIII150"},
			{ID: 0x5a31, Name: "ProceIII260"},
			{ID: 0x5a41, Name: "ProceIII340"},
			{ID: 0x5b51, Name: "ProceIV360"},
			{ID: 0x5b61, Name: "ProceIV530"},
			{ID: 0x5b71, Name: "ProceIV820"},
			{ID: 0x5c01, Name: "ProcStarIV80-1"},
			{ID: 0x5c02, Name: "ProcStarIV80-2"},
			{ID: 0x5c03, Name: "ProcStarIV80-3"},
			{ID: 0x5c04, Name: "ProcStarIV80-4"},
			{ID: 0x5c11, Name: "ProcStarIV110-1"},
			{ID: 0x5c12, Name: "ProcStarIV110-2"},
			{ID: 0x5c13, Name: "ProcStarIV110-3"},
			{ID: 0x5c14, Name: "ProcStarIV110-4"},
			{ID: 0x5c51, Name: "ProcStarIV360-1"},
			{ID: 0x5c52, Name: "ProcStarIV360-2"},
			{ID: 0x5c53, Name: "ProcStarIV360-3"},
			{ID: 0x5c54, Name: "ProcStarIV360-4"},
			{ID: 0x5c61, Name: "ProcStarIV530-1"},
			{ID: 0x5c62, Name: "ProcStarIV530-2"},
			{ID: 0x5c63, Name: "ProcStarIV530-3"},
			{ID: 0x5c64, Name: "ProcStarIV530-4"},
			{ID: 0x5c71, Name: "ProcStarIV820-1"},
			{ID: 0x5c72, Name: "ProcStarIV820-2"},
			{ID: 0x5c73, Name: "ProcStarIV820-3"},
			{ID: 0x5c74, Name: "ProcStarIV820-4"},
			{ID: 0x5d01, Name: "Proc10480"},
			{ID: 0x5d11, Name: "Proc104110"},
			{ID: 0x5f01, Name: "ProceV_A3"},
			{ID: 0x5f11, Name: "ProceV_A7"},
			{ID: 0x5f21, Name: "ProceV_AB"},
			{ID: 0x5f31, Name: "ProceV_D5"},
			{ID: 0x5f41, Name: "ProceV_D8"},
			{ID: 0x6732, Name: "Proc6M"},
			{ID: 0x6832, Name: "Proc12M"},
			{ID: 0x7101, Name: "Proc10a_27"},
			{ID: 0x7111, Name: "Proc10a_48"},
			{ID: 0x7121, Name: "Proc10a_66"},
			{ID: 0x7141, Name: "Proc10a_115"},
			{ID: 0x7181, Name: "Proc10a_27S"},
			{ID: 0x7191, Name: "Proc10a_48S"},
			{ID: 0x71a1, Name: "Proc10a_66S"},
			{ID: 0x71b1, Name: "Proc10A"},
			{ID: 0x72b1, Name: "HawkEye"},
			{ID: 0x73b1, Name: "Proc10s"},
		},
	},
	{ID: 0x165d, Name: "Hsing Tech. Enterprise Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x165f, Name: "Linux Media Labs, LLC", Devices: []Device{
			{ID: 0x1020, Name: "LMLM4 MPEG-4 encoder"},
		},
	},
	{ID: 0x1661, Name: "Worldspace Corp.", Devices: []Device{}},
	{
		ID: 0x1668, Name: "Actiontec Electronics Inc", Devices: []Device{
			{ID: 0x0100, Name: "Mini-PCI bridge"},
		},
	},
	{
		ID: 0x166d, Name: "Broadcom Corporation", Devices: []Device{
			{ID: 0x0001, Name: "SiByte BCM1125/1125H/1250 System-on-a-Chip PCI"},
			{ID: 0x0002, Name: "SiByte BCM1125H/1250 System-on-a-Chip HyperTransport"},
			{ID: 0x0012, Name: "SiByte BCM1280/BCM1480 System-on-a-Chip PCI-X"},
			{ID: 0x0014, Name: "Sibyte BCM1280/BCM1480 System-on-a-Chip HyperTransport"},
		},
	},
	{
		ID: 0x1677, Name: "B&R Industrial Automation GmbH", Devices: []Device{
			{ID: 0x104e, Name: "5LS172.6 B&R Dual CAN Interface Card"},
			{ID: 0x12d7, Name: "5LS172.61 B&R Dual CAN Interface Card"},
			{ID: 0x20ad, Name: "5ACPCI.MFIO-K01 Profibus DP / K-Feldbus / COM"},
		},
	},
	{
		ID: 0x1678, Name: "NetEffect", Devices: []Device{
			{ID: 0x0100, Name: "NE020 10Gb Accelerated Ethernet Adapter (iWARP RNIC)"},
		},
	},
	{
		ID: 0x1679, Name: "Tokyo Electron Device Ltd.", Devices: []Device{
			{ID: 0x3000, Name: "SD Standard host controller [Ellen]"},
		},
	},
	{
		ID: 0x167b, Name: "ZyDAS Technology Corp.", Devices: []Device{
			{ID: 0x2102, Name: "ZyDAS ZD1202"},
			{ID: 0x2116, Name: "ZD1212B Wireless Adapter"},
		},
	},
	{
		ID: 0x167d, Name: "Samsung Electro-Mechanics Co., Ltd.", Devices: []Device{
			{ID: 0xa000, Name: "MagicLAN SWL-2210P 802.11b [Intersil ISL3874]"},
		},
	},
	{ID: 0x167e, Name: "ONNTO Corp.", Devices: []Device{}},
	{ID: 0x1681, Name: "Hercules", Devices: []Device{}},
	{
		ID: 0x1682, Name: "XFX Pine Group Inc.", Devices: []Device{
			{ID: 0x5701, Name: "Radeon 5700 XT Thicc III Ultra"},
			{ID: 0xc580, Name: "Radeon RX 580"},
		},
	},
	{
		ID: 0x1688, Name: "CastleNet Technology Inc.", Devices: []Device{
			{ID: 0x1170, Name: "WLAN 802.11b card"},
		},
	},
	{
		ID: 0x168a, Name: "Utimaco IS GmbH", Devices: []Device{
			{ID: 0x2086, Name: "CryptoServer Se-Series Hardware Security Module"},
			{ID: 0xc040, Name: "CryptoServer CSe-Series Hardware Security Module"},
			{ID: 0xc051, Name: "CryptoServer Se-Series Gen2 Hardware Security Module"},
			{ID: 0xc070, Name: "u.trust Anchor Hardware Security Module cs7.2 Series"},
			{ID: 0xc071, Name: "u.trust Anchor Hardware Security Module cs7.3 Series"},
			{ID: 0xc072, Name: "u.trust Anchor Hardware Security Module cs7.3 Series Virtual Function"},
		},
	},
	{
		ID: 0x168c, Name: "Qualcomm Atheros", Devices: []Device{
			{ID: 0x0007, Name: "AR5210 Wireless Network Adapter [AR5000 802.11a]"},
			{ID: 0x0011, Name: "AR5211 Wireless Network Adapter [AR5001A 802.11a]"},
			{ID: 0x0012, Name: "AR5211 Wireless Network Adapter [AR5001X 802.11ab]"},
			{ID: 0x0013, Name: "AR5212/5213/2414 Wireless Network Adapter"},
			{ID: 0x001a, Name: "AR2413/AR2414 Wireless Network Adapter [AR5005G(S) 802.11bg]"},
			{ID: 0x001b, Name: "AR5413/AR5414 Wireless Network Adapter [AR5006X(S) 802.11abg]"},
			{ID: 0x001c, Name: "AR242x / AR542x Wireless Network Adapter (PCI-Express)"},
			{ID: 0x001d, Name: "AR2417 Wireless Network Adapter [AR5007G 802.11bg]"},
			{ID: 0x0020, Name: "AR5513 802.11abg Wireless NIC"},
			{ID: 0x0023, Name: "AR5416 Wireless Network Adapter [AR5008 802.11(a)bgn]"},
			{ID: 0x0024, Name: "AR5418 Wireless Network Adapter [AR5008E 802.11(a)bgn] (PCI-Express)"},
			{ID: 0x0027, Name: "AR9160 Wireless Network Adapter [AR9001 802.11(a)bgn]"},
			{ID: 0x0029, Name: "AR922X Wireless Network Adapter"},
			{ID: 0x002a, Name: "AR928X Wireless Network Adapter (PCI-Express)"},
			{ID: 0x002b, Name: "AR9285 Wireless Network Adapter (PCI-Express)"},
			{ID: 0x002c, Name: "AR2427 802.11bg Wireless Network Adapter (PCI-Express)"},
			{ID: 0x002d, Name: "AR9227 Wireless Network Adapter"},
			{ID: 0x002e, Name: "AR9287 Wireless Network Adapter (PCI-Express)"},
			{ID: 0x0030, Name: "AR93xx Wireless Network Adapter"},
			{ID: 0x0032, Name: "AR9485 Wireless Network Adapter"},
			{ID: 0x0033, Name: "AR958x 802.11abgn Wireless Network Adapter"},
			{ID: 0x0034, Name: "AR9462 Wireless Network Adapter"},
			{ID: 0x0036, Name: "QCA9565 / AR9565 Wireless Network Adapter"},
			{ID: 0x0037, Name: "AR9485 Wireless Network Adapter"},
			{ID: 0x003c, Name: "QCA986x/988x 802.11ac Wireless Network Adapter"},
			{ID: 0x003e, Name: "QCA6174 802.11ac Wireless Network Adapter"},
			{ID: 0x0040, Name: "QCA9980/9990 802.11ac Wireless Network Adapter"},
			{ID: 0x0041, Name: "QCA6164 802.11ac Wireless Network Adapter"},
			{ID: 0x0042, Name: "QCA9377 802.11ac Wireless Network Adapter"},
			{ID: 0x0046, Name: "QCA9984 802.11ac Wave 2 Wireless Network Adapter"},
			{ID: 0x0050, Name: "QCA9887 802.11ac Wireless Network Adapter"},
			{ID: 0x0207, Name: "AR5210 Wireless Network Adapter [AR5000 802.11a]"},
			{ID: 0x1014, Name: "AR5212 802.11abg NIC"},
			{ID: 0x9013, Name: "AR5002X Wireless Network Adapter"},
			{ID: 0xff19, Name: "AR5006X Wireless Network Adapter"},
			{ID: 0xff1b, Name: "AR2425 Wireless Network Adapter [AR5007EG 802.11bg]"},
			{ID: 0xff1c, Name: "AR5008 Wireless Network Adapter"},
			{ID: 0xff1d, Name: "AR922x Wireless Network Adapter"},
		},
	},
	{ID: 0x1695, Name: "EPoX Computer Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x169c, Name: "Netcell Corporation", Devices: []Device{
			{ID: 0x0044, Name: "Revolution Storage Processing Card"},
		},
	},
	{ID: 0x169d, Name: "Club-3D VB (Wrong ID)", Devices: []Device{}},
	{ID: 0x16a5, Name: "Tekram Technology Co.,Ltd.", Devices: []Device{}},
	{
		ID: 0x16ab, Name: "Global Sun Technology Inc", Devices: []Device{
			{ID: 0x1100, Name: "GL24110P"},
			{ID: 0x1101, Name: "PLX9052 PCMCIA-to-PCI Wireless LAN"},
			{ID: 0x1102, Name: "PCMCIA-to-PCI Wireless Network Bridge"},
			{ID: 0x8501, Name: "WL-8305 Wireless LAN PCI Adapter"},
		},
	},
	{
		ID: 0x16ae, Name: "SafeNet Inc", Devices: []Device{
			{ID: 0x0001, Name: "SafeXcel 1140"},
			{ID: 0x000a, Name: "SafeXcel 1841"},
			{ID: 0x1141, Name: "SafeXcel 1141"},
			{ID: 0x1841, Name: "SafeXcel 1842"},
		},
	},
	{ID: 0x16af, Name: "SparkLAN Communications, Inc.", Devices: []Device{}},
	{ID: 0x16b4, Name: "Aspex Semiconductor Ltd", Devices: []Device{}},
	{ID: 0x16b8, Name: "Sonnet Technologies, Inc.", Devices: []Device{}},
	{ID: 0x16be, Name: "Creatix Polymedia GmbH", Devices: []Device{}},
	{
		ID: 0x16c3, Name: "Synopsys, Inc.", Devices: []Device{
			{ID: 0xabcd, Name: "DWC_usb3 / PCIe bridge"},
			{ID: 0xabce, Name: "DWC_usb3"},
			{ID: 0xabcf, Name: "DWC_usb31"},
			{ID: 0xedda, Name: "EPMockUp"},
		},
	},
	{
		ID: 0x16c6, Name: "Micrel-Kendin", Devices: []Device{
			{ID: 0x8695, Name: "Centaur KS8695 ARM processor"},
			{ID: 0x8842, Name: "KSZ8842-PMQL 2-Port Ethernet Switch"},
		},
	},
	{ID: 0x16c8, Name: "Octasic Inc.", Devices: []Device{}},
	{ID: 0x16c9, Name: "EONIC B.V. The Netherlands", Devices: []Device{}},
	{
		ID: 0x16ca, Name: "CENATEK Inc", Devices: []Device{
			{ID: 0x0001, Name: "Rocket Drive DL"},
		},
	},
	{
		ID: 0x16cd, Name: "Advantech Co. Ltd", Devices: []Device{
			{ID: 0x0101, Name: "DirectPCI SRAM for DPX-11x series"},
			{ID: 0x0102, Name: "DirectPCI SRAM for DPX-S/C/E-series"},
			{ID: 0x0103, Name: "DirectPCI ROM for DPX-11x series"},
			{ID: 0x0104, Name: "DirectPCI ROM for DPX-S/C/E-series"},
			{ID: 0x0105, Name: "DirectPCI I/O for DPX-114/DPX-115"},
			{ID: 0x0106, Name: "DirectPCI I/O for DPX-116"},
			{ID: 0x0107, Name: "DirectPCI I/O for DPX-116U"},
			{ID: 0x0108, Name: "DirectPCI I/O for DPX-117"},
			{ID: 0x0109, Name: "DirectPCI I/O for DPX-112"},
			{ID: 0x010a, Name: "DirectPCI I/O for DPX-C/E-series"},
			{ID: 0x010b, Name: "DirectPCI I/O for DPX-S series"},
		},
	},
	{ID: 0x16ce, Name: "Roland Corp.", Devices: []Device{}},
	{
		ID: 0x16d5, Name: "Acromag, Inc.", Devices: []Device{
			{ID: 0x0504, Name: "PMC-DX504 Reconfigurable FPGA with LVDS I/O"},
			{ID: 0x0520, Name: "PMC520 Serial Communication, 232 Octal"},
			{ID: 0x0521, Name: "PMC521 Serial Communication, 422/485 Octal"},
			{ID: 0x1020, Name: "PMC-AX1020 Reconfigurable FPGA with A/D & D/A"},
			{ID: 0x1065, Name: "PMC-AX1065 Reconfigurable FPGA with A/D & D/A"},
			{ID: 0x2004, Name: "PMC-DX2004 Reconfigurable FPGA with LVDS I/O"},
			{ID: 0x2020, Name: "PMC-AX2020 Reconfigurable FPGA with A/D & D/A"},
			{ID: 0x2065, Name: "PMC-AX2065 Reconfigurable FPGA with A/D & D/A"},
			{ID: 0x3020, Name: "PMC-AX3020 Reconfigurable FPGA with A/D & D/A"},
			{ID: 0x3065, Name: "PMC-AX3065 Reconfigurable FPGA with A/D & D/A"},
			{ID: 0x4243, Name: "PMC424, APC424, AcPC424 Digital I/O and Counter Timer Module"},
			{ID: 0x4248, Name: "PMC464, APC464, AcPC464 Digital I/O and Counter Timer Module"},
			{ID: 0x424b, Name: "PMC-DX2002 Reconfigurable FPGA with Differential I/O"},
			{ID: 0x4253, Name: "PMC-DX503 Reconfigurable FPGA with TTL and Differential I/O"},
			{ID: 0x4312, Name: "PMC-CX1002 Reconfigurable Conduction-Cooled FPGA Virtex-II with Differential I/O"},
			{ID: 0x4313, Name: "PMC-CX1003 Reconfigurable Conduction-Cooled FPGA Virtex-II with CMOS and Differential I/O"},
			{ID: 0x4322, Name: "PMC-CX2002 Reconfigurable Conduction-Cooled FPGA Virtex-II with Differential I/O"},
			{ID: 0x4323, Name: "PMC-CX2003 Reconfigurable Conduction-Cooled FPGA Virtex-II with CMOS and Differential I/O"},
			{ID: 0x4350, Name: "PMC-DX501 Reconfigurable Digital I/O Module"},
			{ID: 0x4353, Name: "PMC-DX2003 Reconfigurable FPGA with TTL and Differential I/O"},
			{ID: 0x4357, Name: "PMC-DX502 Reconfigurable Differential I/O Module"},
			{ID: 0x4457, Name: "PMC730, APC730, AcPC730 Multifunction Module"},
			{ID: 0x4471, Name: "XMC730 Multi-function I/O module with front I/O"},
			{ID: 0x4473, Name: "XMC730CC Multi-function I/O module with rear I/O Conduction-cooled"},
			{ID: 0x464d, Name: "PMC408 32-Channel Digital Input/Output Module"},
			{ID: 0x4850, Name: "PMC220-16 12-Bit Analog Output Module"},
			{ID: 0x4a42, Name: "PMC483, APC483, AcPC483 Counter Timer Module"},
			{ID: 0x4a50, Name: "PMC484, APC484, AcPC484 Counter Timer Module"},
			{ID: 0x4a56, Name: "PMC230 16-Bit Analog Output Module"},
			{ID: 0x4b47, Name: "PMC330, APC330, AcPC330 Analog Input Module, 16-bit A/D"},
			{ID: 0x4c40, Name: "PMC-LX40 Reconfigurable Virtex-4 FPGA with plug-in I/O"},
			{ID: 0x4c60, Name: "PMC-LX60 Reconfigurable Virtex-4 FPGA with plug-in I/O"},
			{ID: 0x4d4d, Name: "PMC341, APC341, AcPC341 Analog Input Module, Simultaneous Sample & Hold"},
			{ID: 0x4d4e, Name: "PMC482, APC482, AcPC482 Counter Timer Board"},
			{ID: 0x524d, Name: "PMC-DX2001 Reconfigurable FPGA with TTL I/O"},
			{ID: 0x5335, Name: "PMC-SX35 Reconfigurable Virtex-4 FPGA with plug-in I/O"},
			{ID: 0x5456, Name: "PMC470 48-Channel Digital Input/Output Module"},
			{ID: 0x5601, Name: "PMC-VLX85 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5602, Name: "PMC-VLX110 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5603, Name: "PMC-VSX95 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5604, Name: "PMC-VLX155 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5605, Name: "PMC-VFX70 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5606, Name: "PMC-VLX155-1M Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5701, Name: "PMC-SLX150: Reconfigurable Spartan-6 FPGA with plug-in I/O"},
			{ID: 0x5702, Name: "PMC-SLX150-1M: Reconfigurable Spartan-6 FPGA with plug-in I/O"},
			{ID: 0x5801, Name: "XMC-VLX85 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5802, Name: "XMC-VLX110 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5803, Name: "XMC-VSX95 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5804, Name: "XMC-VLX155 Reconfigurable Virtex-5 FPGA with plug-in I/O"},
			{ID: 0x5807, Name: "XMC-SLX150: Reconfigurable Spartan-6 FPGA with plug-in I/O"},
			{ID: 0x5808, Name: "XMC-SLX150-1M: Reconfigurable Spartan-6 FPGA with plug-in I/O"},
			{ID: 0x5901, Name: "APCe8650 PCI Express IndustryPack Carrier Card"},
			{ID: 0x6301, Name: "XMC Module with user-configurable Virtex-6 FPGA, 240k logic cells, SFP front I/O"},
			{ID: 0x6302, Name: "XMC Module with user-configurable Virtex-6 FPGA, 365k logic cells, SFP front I/O"},
			{ID: 0x6303, Name: "XMC Module with user-configurable Virtex-6 FPGA, 240k logic cells, no front I/O"},
			{ID: 0x6304, Name: "XMC Module with user-configurable Virtex-6 FPGA, 365k logic cells, no front I/O"},
			{ID: 0x7000, Name: "XMC-7K325F: User-configurable Kintex-7 FPGA, 325k logic cells plus SFP front I/O"},
			{ID: 0x7001, Name: "XMC-7K410F: User-configurable Kintex-7 FPGA, 410k logic cells plus SFP front I/O"},
			{ID: 0x7002, Name: "XMC-7K325AX: User-Configurable Kintex-7 FPGA, 325k logic cells with AXM Plug-In I/O"},
			{ID: 0x7003, Name: "XMC-7K410AX: User-Configurable Kintex-7 FPGA, 410k logic cells with AXM Plug-In I/O"},
			{ID: 0x7004, Name: "XMC-7K325CC: User-Configurable Kintex-7 FPGA, 325k logic cells, conduction-cooled"},
			{ID: 0x7005, Name: "XMC-7K410CC: User-Configurable Kintex-7 FPGA, 410k logic cells, conduction-cooled"},
			{ID: 0x7006, Name: "XMC-7A200: User-Configurable Artix-7 FPGA, 200k logic cells with Plug-In I/O"},
			{ID: 0x7007, Name: "XMC-7A200CC: User-Configurable Conduction-Cooled Artix-7 FPGA, with 200k logic cells"},
			{ID: 0x7011, Name: "AP440-1: 32-Channel Isolated Digital Input Module"},
			{ID: 0x7012, Name: "AP440-2: 32-Channel Isolated Digital Input Module"},
			{ID: 0x7013, Name: "AP440-3: 32-Channel Isolated Digital Input Module"},
			{ID: 0x7014, Name: "AP445: 32-Channel Isolated Digital Output Module"},
			{ID: 0x7015, Name: "AP471 48-Channel TTL Level Digital Input/Output Module"},
			{ID: 0x7016, Name: "AP470 48-Channel TTL Level Digital Input/Output Module"},
			{ID: 0x7017, Name: "AP323 16-bit, 20 or 40 Channel Analog Input Module"},
			{ID: 0x7018, Name: "AP408: 32-Channel Digital I/O Module"},
			{ID: 0x7019, Name: "AP341 14-bit, 16-Channel Simultaneous Conversion Analog Input Module"},
			{ID: 0x701a, Name: "AP220-16 12-Bit, 16-Channel Analog Output Module"},
			{ID: 0x701b, Name: "AP231-16 16-Bit, 16-Channel Analog Output Module"},
			{ID: 0x701c, Name: "AP225 12-Bit, 16-Channel Analog Output Module with Waveform Memory"},
			{ID: 0x701d, Name: "AP235 16-Bit, 16-Channel Analog Output Module with Waveform Memory"},
			{ID: 0x7021, Name: "APA7-201 Reconfigurable Artix-7 FPGA module 48 TTL channels"},
			{ID: 0x7022, Name: "APA7-202 Reconfigurable Artix-7 FPGA module 24 RS485 channels"},
			{ID: 0x7023, Name: "APA7-203 Reconfigurable Artix-7 FPGA module 24 TTL & 12 RS485 channels"},
			{ID: 0x7024, Name: "APA7-204 Reconfigurable Artix-7 FPGA module 24 LVDS channels"},
			{ID: 0x7027, Name: "AP418 16-Channel High Voltage Digital Input/Output Module"},
			{ID: 0x7029, Name: "AP342 14-bit, 12-Channel Isolated Simultaneous Conversion Analog Input Module"},
			{ID: 0x702a, Name: "AP226 12-Bit, 8-Channel Isolated Analog Output Module"},
			{ID: 0x702b, Name: "AP236 16-Bit, 8-Channel Isolated Analog Output Module"},
			{ID: 0x702c, Name: "AP560A Module 4 Independent isolated CAN bus channels"},
			{ID: 0x7031, Name: "AP441-1: 32-Channel Isolated Digital Input Module"},
			{ID: 0x7032, Name: "AP441-2: 32-Channel Isolated Digital Input Module"},
			{ID: 0x7033, Name: "AP441-3: 32-Channel Isolated Digital Input Module"},
			{ID: 0x7042, Name: "AP482 Counter Timer Module with TTL Level Input/Output"},
			{ID: 0x7043, Name: "AP483 Counter Timer Module with TTL Level and RS422 Input/Output"},
			{ID: 0x7044, Name: "AP484 Counter Timer Module with RS422 Input/Output"},
			{ID: 0x7051, Name: "APA7-501 Reconfigurable Artix-7 52,160 Cell FPGA module 48 TTL channels"},
			{ID: 0x7052, Name: "APA7-502 Reconfigurable Artix-7 52,160 Cell FPGA module 24 RS485 channels"},
			{ID: 0x7053, Name: "APA7-503 Reconfigurable Artix-7 52,160 Cell FPGA module 24 TTL & 12 RS485 channels"},
			{ID: 0x7054, Name: "APA7-504 Reconfigurable Artix-7 52,160 Cell FPGA module 24 LVDS channels"},
			{ID: 0x7073, Name: "AP730 Multi-function I/O Module 16 Digital I/O 8 Differential Analog In 4 Analog Out"},
		},
	},
	{
		ID: 0x16da, Name: "Advantech Co., Ltd.", Devices: []Device{
			{ID: 0x0011, Name: "INES GPIB-PCI"},
		},
	},
	{ID: 0x16df, Name: "PIKA Technologies Inc.", Devices: []Device{}},
	{ID: 0x16e2, Name: "Geotest-MTS", Devices: []Device{}},
	{
		ID: 0x16e3, Name: "European Space Agency", Devices: []Device{
			{ID: 0x1e0f, Name: "LEON2FT Processor"},
		},
	},
	{
		ID: 0x16e5, Name: "Intellon Corp.", Devices: []Device{
			{ID: 0x6000, Name: "INT6000 Ethernet-to-Powerline Bridge [HomePlug AV]"},
			{ID: 0x6300, Name: "INT6300 Ethernet-to-Powerline Bridge [HomePlug AV]"},
		},
	},
	{
		ID: 0x16ec, Name: "U.S. Robotics", Devices: []Device{
			{ID: 0x00ed, Name: "USR997900"},
			{ID: 0x0116, Name: "USR997902 10/100/1000 Mbps PCI Network Card"},
			{ID: 0x2f00, Name: "USR5660A (USR265660A, USR5660A-BP) 56K PCI Faxmodem"},
			{ID: 0x3685, Name: "Wireless Access PCI Adapter Model 022415"},
			{ID: 0x4320, Name: "USR997904 10/100/1000 64-bit NIC (Marvell Yukon)"},
			{ID: 0xab06, Name: "USR997901A 10/100 Cardbus NIC"},
		},
	},
	{
		ID: 0x16ed, Name: "Sycron N. V.", Devices: []Device{
			{ID: 0x1001, Name: "UMIO communication card"},
		},
	},
	{
		ID: 0x16f2, Name: "ETAS GmbH", Devices: []Device{
			{ID: 0x0200, Name: "I/O board"},
		},
	},
	{ID: 0x16f3, Name: "Jetway Information Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x16f4, Name: "Vweb Corp", Devices: []Device{
			{ID: 0x8000, Name: "VW2010"},
		},
	},
	{ID: 0x16f6, Name: "VideoTele.com, Inc.", Devices: []Device{}},
	{ID: 0x1702, Name: "Internet Machines Corporation (IMC)", Devices: []Device{}},
	{ID: 0x1705, Name: "Digital First, Inc.", Devices: []Device{}},
	{
		ID: 0x170b, Name: "NetOctave", Devices: []Device{
			{ID: 0x0100, Name: "NSP2000-SSL crypto accelerator"},
		},
	},
	{ID: 0x170c, Name: "YottaYotta Inc.", Devices: []Device{}},
	{
		ID: 0x1719, Name: "EZChip Technologies", Devices: []Device{
			{ID: 0x1000, Name: "NPA Access Network Processor Family"},
		},
	},
	{
		ID: 0x1725, Name: "Vitesse Semiconductor", Devices: []Device{
			{ID: 0x7174, Name: "VSC7174 PCI/PCI-X Serial ATA Host Bus Controller"},
		},
	},
	{
		ID: 0x172a, Name: "Accelerated Encryption", Devices: []Device{
			{ID: 0x13c8, Name: "AEP SureWare Runner 1000V3"},
		},
	},
	{ID: 0x1734, Name: "Fujitsu Technology Solutions", Devices: []Device{}},
	{ID: 0x1735, Name: "Aten International Co. Ltd.", Devices: []Device{}},
	{
		ID: 0x1737, Name: "Linksys", Devices: []Device{
			{ID: 0x0029, Name: "WPG54G ver. 4 PCI Card"},
			{ID: 0x1032, Name: "Gigabit Network Adapter"},
			{ID: 0x1064, Name: "Gigabit Network Adapter"},
			{ID: 0xab08, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
			{ID: 0xab09, Name: "21x4x DEC-Tulip compatible 10/100 Ethernet"},
		},
	},
	{
		ID: 0x173b, Name: "Altima (nee Broadcom)", Devices: []Device{
			{ID: 0x0001, Name: "AC1002 PCI Gigabit Ethernet controller"},
			{ID: 0x03e8, Name: "AC1000 Gigabit Ethernet"},
			{ID: 0x03e9, Name: "AC1001 Gigabit Ethernet"},
			{ID: 0x03ea, Name: "AC9100 Gigabit Ethernet"},
			{ID: 0x03eb, Name: "AC1003 Gigabit Ethernet"},
		},
	},
	{
		ID: 0x1743, Name: "Peppercon AG", Devices: []Device{
			{ID: 0x8139, Name: "ROL/F-100 Fast Ethernet Adapter with ROL"},
		},
	},
	{
		ID: 0x1745, Name: "ViXS Systems, Inc.", Devices: []Device{
			{ID: 0x2020, Name: "XCode II Series"},
			{ID: 0x2100, Name: "XCode 2100 Series"},
		},
	},
	{ID: 0x1749, Name: "RLX Technologies", Devices: []Device{}},
	{ID: 0x174b, Name: "PC Partner Limited / Sapphire Technology", Devices: []Device{}},
	{ID: 0x174d, Name: "WellX Telecom SA", Devices: []Device{}},
	{ID: 0x175c, Name: "AudioScience Inc", Devices: []Device{}},
	{ID: 0x175e, Name: "Sanera Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x1760, Name: "TEDIA spol. s r. o.", Devices: []Device{
			{ID: 0x0101, Name: "PCD-7004 Digital Bi-Directional Ports PCI Card"},
			{ID: 0x0102, Name: "PCD-7104 Digital Input & Output PCI Card"},
			{ID: 0x0121, Name: "PCT-7303A PC card with IRC counters"},
			{ID: 0x0122, Name: "PCT-7408A PC card with counters and timers"},
			{ID: 0x0123, Name: "PCT-7424 PCI card with standard counters"},
			{ID: 0x0141, Name: "PCA7208AL - Analog Inputs/Outputs"},
			{ID: 0x0142, Name: "PCA7208AS - Analog inputs/Outputs"},
			{ID: 0x0143, Name: "PCA7408AL - Analog Inputs/Outputs"},
			{ID: 0x0144, Name: "PCA7408AS - Analog Inputs/Outputs"},
			{ID: 0x0145, Name: "PCA-7228AL Multifunction PCI IO card"},
			{ID: 0x0146, Name: "PCA-7228AS Multifunction PCI IO card"},
			{ID: 0x0147, Name: "PCA7428AL Multifunction PCI IO card"},
			{ID: 0x0148, Name: "PCA7428AS Multifunction PCI IO card"},
			{ID: 0x0149, Name: "PCA7228EL Multifunction PCI IO card with isolated analog inputs"},
			{ID: 0x0150, Name: "PCA7428EL Multifunction PCI IO card with isolated analog inputs"},
			{ID: 0x0151, Name: "PCA7628AL - PCI card with analog inputs, counters and DIO"},
			{ID: 0x0152, Name: "PCA7628AS PCI card with analog inputs, outputs, counters and DIO"},
			{ID: 0x0161, Name: "PCA7288A PCI card with analog outputs, counters and DIO"},
			{ID: 0x0180, Name: "PCI1052 Communication card for MicroUnit network"},
			{ID: 0x0214, Name: "PCT-7424C (F0) PC card with standard counters"},
			{ID: 0x0215, Name: "PCT-7424C (F1) PC card with standard counters"},
			{ID: 0x0216, Name: "PCT-7424E (F0) PC card with standard counters"},
			{ID: 0x0217, Name: "PCT-7424E (F1) PC card with standard counters"},
			{ID: 0x0240, Name: "PCA7428CL_F0 - analog Inputs"},
			{ID: 0x0241, Name: "PCA7428CL_F1 - analog Inputs"},
			{ID: 0x0242, Name: "PCA7428CS_F0 - Analog Inputs/Outputs non isolated"},
			{ID: 0x0243, Name: "PCA7428CS_F1 - Analog Inputs/Outputs non isolated"},
			{ID: 0x0244, Name: "PCA7428CE_F0 - Analog Inputs isolated"},
			{ID: 0x0245, Name: "PCA7428CE_F1 - Analog Inputs isolated"},
			{ID: 0x0303, Name: "PCD-7006C Digital Input & Output PCI Card"},
			{ID: 0x0800, Name: "PCD8006 - PCIe digital Inputs/Outputs"},
			{ID: 0x0840, Name: "PCA-8428 General-purpose multifunctional PCIe card with 8 analog inputs and 2 analog outputs"},
			{ID: 0x0841, Name: "PCA-8429 General-purpose multifunctional PCIe card with 8 analog inputs"},
			{ID: 0x0842, Name: "PCA-8438 General-purpose multifunctional PCIe card with 16 analog inputs and 2 analog outputs"},
			{ID: 0x0843, Name: "PCA-8439 General-purpose multifunctional PCIe card with 16 analog inputs"},
			{ID: 0xff00, Name: "CTU CAN FD PCIe Card"},
		},
	},
	{ID: 0x1761, Name: "Pickering Interfaces Ltd", Devices: []Device{}},
	{ID: 0x1771, Name: "InnoVISION Multimedia Ltd.", Devices: []Device{}},
	{ID: 0x1775, Name: "General Electric", Devices: []Device{}},
	{
		ID: 0x177d, Name: "Cavium, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Nitrox XL N1"},
			{ID: 0x0003, Name: "Nitrox XL N1 Lite"},
			{ID: 0x0004, Name: "Octeon (and older) FIPS"},
			{ID: 0x0005, Name: "Octeon CN38XX Network Processor Pass 3.x"},
			{ID: 0x0006, Name: "RoHS"},
			{ID: 0x0010, Name: "CN15XX/CN16XX [Nitrox PX]"},
			{ID: 0x0011, Name: "CNN35XX [Nitrox III]"},
			{ID: 0x0012, Name: "CNN55XX [Nitrox V]"},
			{ID: 0x0020, Name: "Octeon CN31XX Network Processor"},
			{ID: 0x0030, Name: "Octeon CN30XX Network Processor"},
			{ID: 0x0040, Name: "Octeon CN58XX Network Processor"},
			{ID: 0x0050, Name: "Octeon CN57XX Network Processor (CN54XX/CN55XX/CN56XX)"},
			{ID: 0x0070, Name: "Octeon CN50XX Network Processor"},
			{ID: 0x0080, Name: "Octeon CN52XX Network Processor"},
			{ID: 0x0090, Name: "Octeon II CN63XX Network Processor"},
			{ID: 0x0091, Name: "Octeon II CN68XX Network Processor"},
			{ID: 0x0092, Name: "Octeon II CN65XX Network Processor"},
			{ID: 0x0093, Name: "Octeon II CN61XX Network Processor"},
			{ID: 0x0094, Name: "Octeon Fusion CNF71XX Cell processor"},
			{ID: 0x0095, Name: "Octeon III CN78XX Network Processor"},
			{ID: 0x0096, Name: "Octeon III CN70XX Network Processor"},
			{ID: 0x9700, Name: "Octeon III CN73XX Network Processor"},
			{ID: 0x9702, Name: "CN23XX [LiquidIO II] Intelligent Adapter"},
			{ID: 0x9703, Name: "CN23XX [LiquidIO II] NVMe Controller"},
			{ID: 0x9712, Name: "CN23XX [LiquidIO II] SRIOV Virtual Function"},
			{ID: 0x9713, Name: "CN23XX [LiquidIO II] NVMe SRIOV Virtual Function"},
			{ID: 0x9800, Name: "Octeon Fusion CNF75XX Processor"},
			{ID: 0xa001, Name: "ThunderX MRML(Master RML Bridge to RSL devices)"},
			{ID: 0xa002, Name: "THUNDERX PCC Bridge"},
			{ID: 0xa008, Name: "THUNDERX SMMU"},
			{ID: 0xa009, Name: "THUNDERX Generic Interrupt Controller"},
			{ID: 0xa00a, Name: "THUNDERX GPIO Controller"},
			{ID: 0xa00b, Name: "THUNDERX MPI / SPI Controller"},
			{ID: 0xa00c, Name: "THUNDERX MIO-PTP Controller"},
			{ID: 0xa00d, Name: "THUNDERX MIX Network Controller"},
			{ID: 0xa00e, Name: "THUNDERX Reset Controller"},
			{ID: 0xa00f, Name: "THUNDERX UART Controller"},
			{ID: 0xa010, Name: "THUNDERX eMMC/SD Controller"},
			{ID: 0xa011, Name: "THUNDERX MIO-BOOT Controller"},
			{ID: 0xa012, Name: "THUNDERX TWSI / I2C Controller"},
			{ID: 0xa013, Name: "THUNDERX CCPI (Multi-node connect)"},
			{ID: 0xa014, Name: "THUNDERX Voltage Regulator Module"},
			{ID: 0xa015, Name: "THUNDERX PCIe Switch Logic Interface"},
			{ID: 0xa016, Name: "THUNDERX Key Memory"},
			{ID: 0xa017, Name: "THUNDERX GTI (Global System Timers)"},
			{ID: 0xa018, Name: "THUNDERX Random Number Generator"},
			{ID: 0xa019, Name: "THUNDERX DFA"},
			{ID: 0xa01a, Name: "THUNDERX Zip Coprocessor"},
			{ID: 0xa01b, Name: "THUNDERX xHCI USB Controller"},
			{ID: 0xa01c, Name: "THUNDERX AHCI SATA Controller"},
			{ID: 0xa01d, Name: "THUNDERX RAID Coprocessor"},
			{ID: 0xa01e, Name: "THUNDERX Network Interface Controller"},
			{ID: 0xa01f, Name: "THUNDERX Traffic Network Switch"},
			{ID: 0xa020, Name: "THUNDERX PEM (PCI Express Interface)"},
			{ID: 0xa021, Name: "THUNDERX L2C (Level-2 Cache Controller)"},
			{ID: 0xa022, Name: "THUNDERX LMC (DRAM Controller)"},
			{ID: 0xa023, Name: "THUNDERX OCLA (On-Chip Logic Analyzer)"},
			{ID: 0xa024, Name: "THUNDERX OSM"},
			{ID: 0xa025, Name: "THUNDERX GSER (General Serializer/Deserializer)"},
			{ID: 0xa026, Name: "THUNDERX BGX (Common Ethernet Interface)"},
			{ID: 0xa027, Name: "THUNDERX IOBN"},
			{ID: 0xa029, Name: "THUNDERX NCSI (Network Controller Sideband Interface)"},
			{ID: 0xa02a, Name: "ThunderX SGPIO (Serial GPIO controller for SATA disk lights)"},
			{ID: 0xa02b, Name: "THUNDERX SMI / MDIO Controller"},
			{ID: 0xa02c, Name: "THUNDERX DAP (Debug Access Port)"},
			{ID: 0xa02d, Name: "THUNDERX PCIERC (PCIe Root Complex)"},
			{ID: 0xa02e, Name: "ThunderX L2C-TAD (Level 2 cache tag and data)"},
			{ID: 0xa02f, Name: "THUNDERX L2C-CBC"},
			{ID: 0xa030, Name: "THUNDERX L2C-MCI"},
			{ID: 0xa031, Name: "THUNDERX MIO-FUS (Fuse Access Controller)"},
			{ID: 0xa032, Name: "THUNDERX FUSF (Fuse Controller)"},
			{ID: 0xa033, Name: "THUNDERX Random Number Generator virtual function"},
			{ID: 0xa034, Name: "THUNDERX Network Interface Controller virtual function"},
			{ID: 0xa035, Name: "THUNDERX Parallel Bus"},
			{ID: 0xa036, Name: "ThunderX RAD (RAID acceleration engine) virtual function"},
			{ID: 0xa037, Name: "THUNDERX ZIP virtual function"},
			{ID: 0xa040, Name: "THUNDERX CPT Cryptographic Accelerator"},
			{ID: 0xa100, Name: "THUNDERX CN88XX 48 core SoC"},
			{ID: 0xa200, Name: "OCTEON TX CN81XX/CN80XX"},
			{ID: 0xa300, Name: "OCTEON TX CN83XX"},
			{ID: 0xaf00, Name: "CN99xx [ThunderX2] Integrated PCI Host bridge"},
			{ID: 0xaf84, Name: "CN99xx [ThunderX2] Integrated PCI Express RP Bridge"},
		},
	},
	{ID: 0x1787, Name: "Hightech Information System Ltd.", Devices: []Device{}},
	{ID: 0x1789, Name: "Ennyah Technologies Corp.", Devices: []Device{}},
	{
		ID: 0x1796, Name: "Research Centre Juelich", Devices: []Device{
			{ID: 0x0001, Name: "SIS1100 [Gigabit link]"},
			{ID: 0x0002, Name: "HOTlink"},
			{ID: 0x0003, Name: "Counter Timer"},
			{ID: 0x0004, Name: "CAMAC Controller"},
			{ID: 0x0005, Name: "PROFIBUS"},
			{ID: 0x0006, Name: "AMCC HOTlink"},
			{ID: 0x0007, Name: "LVD Cable Bus"},
			{ID: 0x0008, Name: "100MHz, 64bit Sequence Generator based on VirtexII"},
			{ID: 0x0009, Name: "double 14bit-ADC"},
			{ID: 0x000a, Name: "SIS1100 with N110 TDC"},
			{ID: 0x000b, Name: "double 14bit-ADC with memory"},
			{ID: 0x000d, Name: "Synchronisation Slave"},
			{ID: 0x000e, Name: "SIS1100-eCMC"},
			{ID: 0x000f, Name: "TDC (GPX)"},
			{ID: 0x0010, Name: "PCIe Counter Timer"},
			{ID: 0x0011, Name: "SIS1100-e single link"},
			{ID: 0x0012, Name: "SIS1100-e quad link"},
			{ID: 0x0013, Name: "4x2.5GHz SFP to 4 lane PCIe bridge"},
			{ID: 0x0014, Name: "SIS1100 with GPX piggy back"},
			{ID: 0x0015, Name: "SIS8100 [Gigabit link, MicroTCA]"},
			{ID: 0x0016, Name: "SIS1100e with 4 lanes"},
			{ID: 0x0017, Name: "Quad 14bit, 50MHz ADC with 2.5GHz SFP"},
			{ID: 0x0018, Name: "SIS8300 4-lane PCI Express, Micro TCA for Physics ADC"},
			{ID: 0x0019, Name: "SIS SIS8300-Lx MTCA.4 Digitizer"},
			{ID: 0x001a, Name: "100MHz, 64bit Sequence Generator based on VirtexII"},
			{ID: 0x001c, Name: "Quad 16bit, 150MHz ADC with 2.5GHz SFP"},
			{ID: 0x0030, Name: "100MHz, 64bit Sequence Generator based on Spartan6"},
			{ID: 0x0031, Name: "200MHz 64bit Sequence Generator based on Spartan7"},
		},
	},
	{
		ID: 0x1797, Name: "Intersil Techwell", Devices: []Device{
			{ID: 0x5864, Name: "TW5864 multimedia video controller"},
			{ID: 0x6801, Name: "TW6802 multimedia video card"},
			{ID: 0x6802, Name: "TW6802 multimedia other device"},
			{ID: 0x6810, Name: "TW6816 multimedia video controller"},
			{ID: 0x6811, Name: "TW6816 multimedia video controller"},
			{ID: 0x6812, Name: "TW6816 multimedia video controller"},
			{ID: 0x6813, Name: "TW6816 multimedia video controller"},
			{ID: 0x6814, Name: "TW6816 multimedia video controller"},
			{ID: 0x6815, Name: "TW6816 multimedia video controller"},
			{ID: 0x6816, Name: "TW6816 multimedia video controller"},
			{ID: 0x6817, Name: "TW6816 multimedia video controller"},
			{ID: 0x6864, Name: "TW6864 multimedia video controller"},
		},
	},
	{
		ID: 0x1799, Name: "Belkin", Devices: []Device{
			{ID: 0x6001, Name: "F5D6001 Wireless PCI Card [Realtek RTL8180]"},
			{ID: 0x6020, Name: "F5D6020 v3000 Wireless PCMCIA Card [Realtek RTL8180]"},
			{ID: 0x6060, Name: "F5D6060 Wireless PDA Card"},
			{ID: 0x700f, Name: "F5D7000 v7000 Wireless G Desktop Card [Realtek RTL8185]"},
			{ID: 0x701f, Name: "F5D7010 v7000 Wireless G Notebook Card [Realtek RTL8185]"},
		},
	},
	{
		ID: 0x179a, Name: "id Quantique", Devices: []Device{
			{ID: 0x0001, Name: "Quantis PCI 16Mbps"},
		},
	},
	{
		ID: 0x179c, Name: "Data Patterns", Devices: []Device{
			{ID: 0x0557, Name: "DP-PCI-557 [PCI 1553B]"},
			{ID: 0x0566, Name: "DP-PCI-566 [Intelligent PCI 1553B]"},
			{ID: 0x1152, Name: "DP-cPCI-1152 (8-channel Isolated ADC Module)"},
			{ID: 0x5031, Name: "DP-CPCI-5031-Synchro Module"},
			{ID: 0x5112, Name: "DP-cPCI-5112 [MM-Carrier]"},
			{ID: 0x5121, Name: "DP-CPCI-5121-IP Carrier"},
			{ID: 0x5211, Name: "DP-CPCI-5211-IP Carrier"},
			{ID: 0x5679, Name: "AGE Display Module"},
		},
	},
	{
		ID: 0x17a0, Name: "Genesys Logic, Inc", Devices: []Device{
			{ID: 0x7163, Name: "GL9701 PCIe to PCI Bridge"},
			{ID: 0x8083, Name: "GL880 USB 1.1 UHCI controller"},
			{ID: 0x8084, Name: "GL880 USB 2.0 EHCI controller"},
			{ID: 0x9750, Name: "GL9750 SD Host Controller"},
			{ID: 0x9755, Name: "GL9755 SD Host Controller"},
			{ID: 0xe763, Name: "GL9763E eMMC Controller"},
		},
	},
	{
		ID: 0x17aa, Name: "Lenovo", Devices: []Device{
			{ID: 0x3181, Name: "ThinkCentre M75n IoT"},
			{ID: 0x402b, Name: "Intel 82599ES 10Gb 2-port Server Adapter X520-2"},
		},
	},
	{ID: 0x17ab, Name: "Phillips Components", Devices: []Device{}},
	{ID: 0x17af, Name: "Hightech Information System Ltd.", Devices: []Device{}},
	{
		ID: 0x17b3, Name: "Hawking Technologies", Devices: []Device{
			{ID: 0xab08, Name: "PN672TX 10/100 Ethernet"},
		},
	},
	{
		ID: 0x17b4, Name: "Indra Networks, Inc.", Devices: []Device{
			{ID: 0x0011, Name: "WebEnhance 100 GZIP Compression Card"},
			{ID: 0x0012, Name: "WebEnhance 200 GZIP Compression Card"},
			{ID: 0x0015, Name: "WebEnhance 300 GZIP Compression Card"},
			{ID: 0x0016, Name: "StorCompress 300 GZIP Compression Card"},
			{ID: 0x0017, Name: "StorSecure 300 GZIP Compression and AES Encryption Card"},
		},
	},
	{ID: 0x17c0, Name: "Wistron Corp.", Devices: []Device{}},
	{ID: 0x17c2, Name: "Newisys, Inc.", Devices: []Device{}},
	{
		ID: 0x17cb, Name: "Qualcomm", Devices: []Device{
			{ID: 0x0001, Name: "AGN100 802.11 a/b/g True MIMO Wireless Card"},
			{ID: 0x0002, Name: "AGN300 802.11 a/b/g True MIMO Wireless Card"},
			{ID: 0x0105, Name: "MSM8998 PCIe Root Complex"},
			{ID: 0x0108, Name: "SM8150 PCIe Root Complex"},
			{ID: 0x0109, Name: "SA8195P PCIe Root Complex"},
			{ID: 0x0300, Name: "MDM9x35 LTE Modem [Snapdragon X7]"},
			{ID: 0x0301, Name: "MDM9x45 LTE Modem [Snapdragon X12]"},
			{ID: 0x0302, Name: "MDM9x55 LTE Modem [Snapdragon X16]"},
			{ID: 0x0400, Name: "Datacenter Technologies QDF2432 PCI Express Root Port"},
			{ID: 0x0401, Name: "Datacenter Technologies QDF2400 PCI Express Root Port"},
			{ID: 0x1000, Name: "QCS405 PCIe Root Complex"},
			{ID: 0x1101, Name: "QCA6390 Wireless Network Adapter [AX500-DBS (2x2)]"},
			{ID: 0x1103, Name: "Atheros QCNFA765"},
		},
	},
	{
		ID: 0x17cc, Name: "NetChip Technology, Inc", Devices: []Device{
			{ID: 0x2280, Name: "USB 2.0"},
		},
	},
	{ID: 0x17cd, Name: "Cadence Design Systems, Inc.", Devices: []Device{}},
	{ID: 0x17cf, Name: "Z-Com, Inc.", Devices: []Device{}},
	{
		ID: 0x17d3, Name: "Areca Technology Corp.", Devices: []Device{
			{ID: 0x1110, Name: "ARC-1110 4-Port PCI-X to SATA RAID Controller"},
			{ID: 0x1120, Name: "ARC-1120 8-Port PCI-X to SATA RAID Controller"},
			{ID: 0x1130, Name: "ARC-1130 12-Port PCI-X to SATA RAID Controller"},
			{ID: 0x1160, Name: "ARC-1160 16-Port PCI-X to SATA RAID Controller"},
			{ID: 0x1170, Name: "ARC-1170 24-Port PCI-X to SATA RAID Controller"},
			{ID: 0x1201, Name: "ARC-1200 2-Port PCI-Express to SATA II RAID Controller"},
			{ID: 0x1203, Name: "ARC-1203 2/4/8 Port PCIe 2.0 to SATA 6Gb RAID Controller"},
			{ID: 0x1210, Name: "ARC-1210 4-Port PCI-Express to SATA RAID Controller"},
			{ID: 0x1214, Name: "ARC-12x4 PCIe 2.0 to SAS/SATA 6Gb RAID Controller"},
			{ID: 0x1220, Name: "ARC-1220 8-Port PCI-Express to SATA RAID Controller"},
			{ID: 0x1222, Name: "ARC-1222 8-Port PCI-Express to SAS/SATA II RAID Controller"},
			{ID: 0x1230, Name: "ARC-1230 12-Port PCI-Express to SATA RAID Controller"},
			{ID: 0x1260, Name: "ARC-1260 16-Port PCI-Express to SATA RAID Controller"},
			{ID: 0x1280, Name: "ARC-1280/1280ML 24-Port PCI-Express to SATA II RAID Controller"},
			{ID: 0x1300, Name: "ARC-1300ix-16 16-Port PCI-Express to SAS Non-RAID Host Adapter"},
			{ID: 0x1320, Name: "ARC-1320 8/16 Port PCIe 2.0 to SAS/SATA 6Gb Non-RAID Host Adapter"},
			{ID: 0x1330, Name: "ARC-1330 16 Port PCIe 3.0 to SAS/SATA 12Gb Non-RAID Host Adapter"},
			{ID: 0x1680, Name: "ARC-1680 series PCIe to SAS/SATA 3Gb RAID Controller"},
			{ID: 0x1880, Name: "ARC-188x series PCIe 2.0/3.0 to SAS/SATA 6/12Gb RAID Controller"},
			{ID: 0x1884, Name: "ARC-1884 series PCIe 3.0 to SAS/SATA 12/6Gb RAID Controller"},
			{ID: 0x188a, Name: "ARC-1886 series PCIe 4.0 to NVMe/SAS/SATA 16/12/6Gb RAID Controller"},
		},
	},
	{
		ID: 0x17d5, Name: "Exar Corp.", Devices: []Device{
			{ID: 0x5731, Name: "Xframe 10-Gigabit Ethernet PCI-X"},
			{ID: 0x5732, Name: "Xframe II 10-Gigabit Ethernet PCI-X 2.0"},
			{ID: 0x5831, Name: "Xframe 10-Gigabit Ethernet PCI-X"},
			{ID: 0x5832, Name: "Xframe II 10-Gigabit Ethernet PCI-X 2.0"},
			{ID: 0x5833, Name: "X3100 Series 10 Gigabit Ethernet PCIe"},
		},
	},
	{
		ID: 0x17db, Name: "Cray Inc", Devices: []Device{
			{ID: 0x0101, Name: "XT Series [Seastar] 3D Toroidal Router"},
		},
	},
	{ID: 0x17de, Name: "KWorld Computer Co. Ltd.", Devices: []Device{}},
	{
		ID: 0x17df, Name: "Dini Group", Devices: []Device{
			{ID: 0x1864, Name: "Virtex4 PCI Board w/ QL5064 Bridge [DN7000K10PCI/DN8000K10PCI/DN8000K10PSX/NOTUS]"},
			{ID: 0x1865, Name: "Virtex4 ASIC Emulator [DN8000K10PCIe]"},
			{ID: 0x1866, Name: "Virtex4 ASIC Emulator Cable Connection [DN8000K10PCI]"},
			{ID: 0x1867, Name: "Virtex4 ASIC Emulator Cable Connection [DN8000K10PCIe]"},
			{ID: 0x1868, Name: "Virtex4 ASIC Emulator [DN8000K10PCIe-8]"},
			{ID: 0x1900, Name: "Virtex5 PCIe ASIC Emulator [DN9000K10PCIe8T/DN9002K10PCIe8T/DN9200K10PCIe8T/DN7006K10PCIe8T/DN7406K10PCIe8T]"},
			{ID: 0x1901, Name: "Virtex5 PCIe ASIC Emulator Large BARs [DN9000K10PCIe8T/DN9002K10PCIe8T/DN9200K10PCIe8T/DN7006K10PCIe8T/DN7406K10PCIe8T]"},
			{ID: 0x1902, Name: "Virtex5 PCIe ASIC Emulator Low Power [Interceptor]"},
			{ID: 0x1903, Name: "Spartan6 PCIe FPGA Accelerator Board [DNBFCS12PCIe]"},
			{ID: 0x1904, Name: "Virtex6 PCIe ASIC Emulation Board [DNDUALV6_PCIe4]"},
			{ID: 0x1905, Name: "Virtex6 PCIe ASIC Emulation Board [DNV6F6PCIe]"},
			{ID: 0x1906, Name: "Virtex6 PCIe ASIC Emulation Board [DN2076K10]"},
			{ID: 0x1907, Name: "Virtex6 PCIe ASIC Emulation Board [DNV6F2PCIe]"},
			{ID: 0x1908, Name: "Virtex6 PCIe ASIC Emulation Board Large BARs[DNV6F2PCIe]"},
			{ID: 0x1909, Name: "Kintex7 PCIe FPGA Accelerator Board [DNK7F5PCIe]"},
			{ID: 0x190a, Name: "Virtex7 PCIe ASIC Emulation Board [DNV7F1A]"},
			{ID: 0x190b, Name: "Stratix5 PCIe ASIC Emulation Board [DNS5GXF2]"},
			{ID: 0x190c, Name: "Virtex7 PCIe ASIC Emulation Board [DNV7F2A]"},
			{ID: 0x190d, Name: "Virtex7 PCIe ASIC Emulation Board [DNV7F4A]"},
			{ID: 0x190e, Name: "Virtex7 PCIe ASIC Emulation Board [DNV7F2B]"},
			{ID: 0x190f, Name: "KintexUS PCIe MainRef Design [DNPCIE_40G_KU_LL]"},
			{ID: 0x1910, Name: "VirtexUS ASIC Emulation Board [DNVUF4A]"},
			{ID: 0x1911, Name: "VirtexUS PCIe ASIC Emulation Board [DNVU_F2PCIe]"},
			{ID: 0x1912, Name: "KintexUS PCIe MainRef Design [DNPCIe_40G_KU_LL_QSFP]"},
			{ID: 0x1913, Name: "VirtexUS ASIC Emulation Board [DNVUF1A]"},
			{ID: 0x1914, Name: "VirtexUS ASIC Emulation Board [DNVUF2A]"},
			{ID: 0x1915, Name: "Arria10 PCIe MainRef Design [DNPCIe_80G_A10_LL]"},
			{ID: 0x1916, Name: "VirtexUS PCIe Accelerator Board [DNVUF2_HPC_PCIe]"},
			{ID: 0x1917, Name: "UltrascalePlus PCIe Accelerator Board [DNPCIe_400G_VU_LL]"},
			{ID: 0x1918, Name: "VirtexUS+ ASIC Emulation Board [DNVUPF4A]"},
			{ID: 0x1919, Name: "UltrascalePlus PCIe Accelerator Board [DNPCIe_400G_VUP_HBM_LL]"},
			{ID: 0x1a00, Name: "Virtex6 PCIe DMA Netlist Design"},
			{ID: 0x1a01, Name: "Virtex6 PCIe Darklite Design [DNPCIe_HXT_10G_LL]"},
			{ID: 0x1a02, Name: "Virtex7 PCIe DMA Netlist Design"},
			{ID: 0x1a03, Name: "Kintex7 PCIe Darklite Design [DNPCIe_K7_10G_LL]"},
			{ID: 0x1a05, Name: "Stratix5 PCIe Darklite Design [DNS5GX_F2]"},
			{ID: 0x1a06, Name: "VirtexUS PCIe DMA Netlist Design"},
			{ID: 0x1a07, Name: "KintexUS PCIe Darklite Design [DNPCIe_40G_KU_LL]"},
			{ID: 0x1a08, Name: "KintexUS PCIe Darklite Design [DNPCIe_40G_KU_LL_QSFP]"},
			{ID: 0x1a09, Name: "Arria10 PCIe Darklite Design [DNPCIe_80G_A10_LL]"},
			{ID: 0x1a0a, Name: "VirtexUS PCIe Darklite Design [DNVUF2_HPC_PCIe]"},
			{ID: 0x1a0b, Name: "UltrascalePlus PCIe Darklite Design [DNPCIe_400G_VU_LL]"},
			{ID: 0x1a0c, Name: "KintexUS PCIe DRAM Packet Capture Design [DNPCIe_40G_KU_LL]"},
			{ID: 0x1a0d, Name: "KintexUS PCIe DRAM Packet Capture Design [DNPCIe_40G_KU_LL_2QSFP]"},
			{ID: 0x1a0e, Name: "UltrascalePlus PCIe Darklite Design [DNPCIe_400G_VUP_HBM_LL]"},
		},
	},
	{
		ID: 0x17e4, Name: "Sectra AB", Devices: []Device{
			{ID: 0x0001, Name: "KK671 Cardbus encryption board"},
			{ID: 0x0002, Name: "KK672 Cardbus encryption board"},
		},
	},
	{
		ID: 0x17e6, Name: "MaxLinear", Devices: []Device{
			{ID: 0x0010, Name: "EN2010 [c.Link] MoCA Network Controller (Coax, PCI interface)"},
			{ID: 0x0011, Name: "EN2010 [c.Link] MoCA Network Controller (Coax, MPEG interface)"},
			{ID: 0x0021, Name: "EN2210 [c.Link] MoCA Network Controller (Coax)"},
			{ID: 0x0025, Name: "EN2510 [c.Link] MoCA Network Controller (Coax, PCIe interface)"},
			{ID: 0x0027, Name: "EN2710 [c.Link] MoCA 2.0 Network Controller (Coax, PCIe interface)"},
			{ID: 0x3700, Name: "MoCA 2.0 Network Controller (Coax, PCIe interface)"},
			{ID: 0x3710, Name: "MoCA 2.5 Network Controller (Coax, PCIe interface)"},
		},
	},
	{ID: 0x17ee, Name: "Connect Components Ltd", Devices: []Device{}},
	{ID: 0x17f2, Name: "Albatron Corp.", Devices: []Device{}},
	{
		ID: 0x17f3, Name: "RDC Semiconductor, Inc.", Devices: []Device{
			{ID: 0x1010, Name: "R1010 IDE Controller"},
			{ID: 0x1011, Name: "R1011 IDE Controller"},
			{ID: 0x1012, Name: "R1012 IDE Controller"},
			{ID: 0x1031, Name: "PCI/PCI-X to PCI-E Bridge"},
			{ID: 0x1070, Name: "CAN Bus Controller"},
			{ID: 0x1331, Name: "Motion Control Interface"},
			{ID: 0x1930, Name: "Hybrid Function Control Register"},
			{ID: 0x2010, Name: "RDC M2010 VGA-compatible graphics adapter"},
			{ID: 0x2012, Name: "M2012/R3308 VGA-compatible graphics adapter"},
			{ID: 0x2015, Name: "RDC M2015 VGA-compatible graphics adapter"},
			{ID: 0x6011, Name: "R6011 ISA Bridge"},
			{ID: 0x6013, Name: "R6013 ISA Bridge"},
			{ID: 0x6020, Name: "R6020 North Bridge"},
			{ID: 0x6021, Name: "R6021 Host Bridge"},
			{ID: 0x6022, Name: "R6022 Host Bridge"},
			{ID: 0x6023, Name: "R6023 Host Bridge"},
			{ID: 0x6025, Name: "R6025 Host Bridge"},
			{ID: 0x6026, Name: "R6026 Host Bridge"},
			{ID: 0x6030, Name: "R6030 ISA Bridge"},
			{ID: 0x6031, Name: "R6031 ISA Bridge"},
			{ID: 0x6035, Name: "R6035 ISA Bridge"},
			{ID: 0x6036, Name: "R6036 ISA Bridge"},
			{ID: 0x6040, Name: "R6040 MAC Controller"},
			{ID: 0x6060, Name: "R6060 USB 1.1 Controller"},
			{ID: 0x6061, Name: "R6061 USB 2.0 Controller"},
		},
	},
	{ID: 0x17f7, Name: "Topdek Semiconductor Inc.", Devices: []Device{}},
	{ID: 0x17f9, Name: "Gemtek Technology Co., Ltd", Devices: []Device{}},
	{ID: 0x17fc, Name: "IOGEAR, Inc.", Devices: []Device{}},
	{
		ID: 0x17fe, Name: "InProComm Inc.", Devices: []Device{
			{ID: 0x2120, Name: "IPN 2120 802.11b"},
			{ID: 0x2220, Name: "IPN 2220 802.11g"},
		},
	},
	{ID: 0x17ff, Name: "Benq Corporation", Devices: []Device{}},
	{
		ID: 0x1800, Name: "Qualcore Logic Inc.", Devices: []Device{
			{ID: 0x1100, Name: "Nanospeed Trading Gateway"},
		},
	},
	{ID: 0x1803, Name: "ProdaSafe GmbH", Devices: []Device{}},
	{
		ID: 0x1804, Name: "Ralink corp. (wrong ID)", Devices: []Device{
			{ID: 0x3060, Name: "RT3060 Wireless 802.11n 1T/1R"},
		},
	},
	{ID: 0x1805, Name: "Euresys S.A.", Devices: []Device{}},
	{ID: 0x1809, Name: "Lumanate, Inc.", Devices: []Device{}},
	{ID: 0x180c, Name: "IEI Integration Corp", Devices: []Device{}},
	{
		ID: 0x1813, Name: "Ambient Technologies Inc", Devices: []Device{
			{ID: 0x4000, Name: "HaM controllerless modem"},
			{ID: 0x4100, Name: "HaM plus Data Fax Modem"},
		},
	},
	{
		ID: 0x1814, Name: "Ralink corp.", Devices: []Device{
			{ID: 0x0101, Name: "Wireless PCI Adapter RT2400 / RT2460"},
			{ID: 0x0200, Name: "RT2500 802.11g PCI [PC54G2]"},
			{ID: 0x0201, Name: "RT2500 Wireless 802.11bg"},
			{ID: 0x0300, Name: "Wireless Adapter Canyon CN-WF511"},
			{ID: 0x0301, Name: "RT2561/RT61 802.11g PCI"},
			{ID: 0x0302, Name: "RT2561/RT61 rev B 802.11g"},
			{ID: 0x0401, Name: "RT2600 802.11 MIMO"},
			{ID: 0x0601, Name: "RT2800 802.11n PCI"},
			{ID: 0x0681, Name: "RT2890 Wireless 802.11n PCIe"},
			{ID: 0x0701, Name: "RT2760 Wireless 802.11n 1T/2R"},
			{ID: 0x0781, Name: "RT2790 Wireless 802.11n 1T/2R PCIe"},
			{ID: 0x3060, Name: "RT3060 Wireless 802.11n 1T/1R"},
			{ID: 0x3062, Name: "RT3062 Wireless 802.11n 2T/2R"},
			{ID: 0x3090, Name: "RT3090 Wireless 802.11n 1T/1R PCIe"},
			{ID: 0x3091, Name: "RT3091 Wireless 802.11n 1T/2R PCIe"},
			{ID: 0x3092, Name: "RT3092 Wireless 802.11n 2T/2R PCIe"},
			{ID: 0x3290, Name: "RT3290 Wireless 802.11n 1T/1R PCIe"},
			{ID: 0x3298, Name: "RT3290 Bluetooth"},
			{ID: 0x3592, Name: "RT3592 Wireless 802.11abgn 2T/2R PCIe"},
			{ID: 0x359f, Name: "RT3592 PCIe Wireless Network Adapter"},
			{ID: 0x5360, Name: "RT5360 Wireless 802.11n 1T/1R"},
			{ID: 0x5362, Name: "RT5362 PCI 802.11n Wireless Network Adapter"},
			{ID: 0x5390, Name: "RT5390 Wireless 802.11n 1T/1R PCIe"},
			{ID: 0x5392, Name: "RT5392 PCIe Wireless Network Adapter"},
			{ID: 0x539b, Name: "RT5390R 802.11bgn PCIe Wireless Network Adapter"},
			{ID: 0x539f, Name: "RT5390 [802.11 b/g/n 1T1R G-band PCI Express Single Chip]"},
			{ID: 0x5592, Name: "RT5592 PCIe Wireless Network Adapter"},
			{ID: 0xe932, Name: "RT2560F 802.11 b/g PCI"},
		},
	},
	{ID: 0x1815, Name: "Devolo AG", Devices: []Device{}},
	{ID: 0x1820, Name: "InfiniCon Systems Inc.", Devices: []Device{}},
	{
		ID: 0x1822, Name: "Twinhan Technology Co. Ltd", Devices: []Device{
			{ID: 0x4e35, Name: "Mantis DTV PCI Bridge Controller [Ver 1.0]"},
		},
	},
	{
		ID: 0x182d, Name: "SiteCom Europe BV", Devices: []Device{
			{ID: 0x3069, Name: "ISDN PCI DC-105V2"},
			{ID: 0x9790, Name: "WL-121 Wireless Network Adapter 100g+ [Ver.3]"},
		},
	},
	{
		ID: 0x182e, Name: "Raza Microelectronics, Inc.", Devices: []Device{
			{ID: 0x0008, Name: "XLR516 Processor"},
		},
	},
	{
		ID: 0x182f, Name: "Broadcom", Devices: []Device{
			{ID: 0x000b, Name: "BCM5785 [HT1000] SATA (RAID Mode)"},
		},
	},
	{
		ID: 0x1830, Name: "Credence Systems Corporation", Devices: []Device{
			{ID: 0x8000, Name: "CPIn"},
			{ID: 0x8001, Name: "CPId"},
			{ID: 0x8002, Name: "CPIx"},
			{ID: 0x8003, Name: "CPIq"},
		},
	},
	{
		ID: 0x183b, Name: "MikroM GmbH", Devices: []Device{
			{ID: 0x08a7, Name: "MVC100 DVI"},
			{ID: 0x08a8, Name: "MVC101 SDI"},
			{ID: 0x08a9, Name: "MVC102 DVI+Audio"},
			{ID: 0x08b0, Name: "MVC200-DC"},
		},
	},
	{ID: 0x1846, Name: "Alcatel-Lucent", Devices: []Device{}},
	{ID: 0x1849, Name: "ASRock Incorporation", Devices: []Device{}},
	{
		ID: 0x184a, Name: "Thales Computers", Devices: []Device{
			{ID: 0x1100, Name: "MAX II cPLD"},
		},
	},
	{
		ID: 0x1850, Name: "Advantest Corporation", Devices: []Device{
			{ID: 0x0048, Name: "EK220-66401 Computer Interface Card"},
		},
	},
	{ID: 0x1851, Name: "Microtune, Inc.", Devices: []Device{}},
	{ID: 0x1852, Name: "Anritsu Corp.", Devices: []Device{}},
	{ID: 0x1853, Name: "SMSC Automotive Infotainment System Group", Devices: []Device{}},
	{ID: 0x1854, Name: "LG Electronics, Inc.", Devices: []Device{}},
	{
		ID: 0x185b, Name: "Compro Technology, Inc.", Devices: []Device{
			{ID: 0x1489, Name: "VideoMate Vista T100"},
		},
	},
	{ID: 0x185f, Name: "Wistron NeWeb Corp.", Devices: []Device{}},
	{
		ID: 0x1864, Name: "SilverBack", Devices: []Device{
			{ID: 0x2110, Name: "ISNAP 2110"},
		},
	},
	{
		ID: 0x1867, Name: "Topspin Communications", Devices: []Device{
			{ID: 0x5a44, Name: "MT23108 InfiniHost HCA"},
			{ID: 0x5a45, Name: "MT23108 InfiniHost HCA flash recovery"},
			{ID: 0x5a46, Name: "MT23108 InfiniHost HCA bridge"},
			{ID: 0x6278, Name: "MT25208 InfiniHost III Ex (Tavor compatibility mode)"},
			{ID: 0x6282, Name: "MT25208 InfiniHost III Ex"},
		},
	},
	{
		ID: 0x186c, Name: "Humusoft, s.r.o.", Devices: []Device{
			{ID: 0x0612, Name: "AD612 Data Acquisition Device"},
			{ID: 0x0614, Name: "MF614 Multifunction I/O Card"},
			{ID: 0x0622, Name: "AD622 Data Acquisition Device"},
			{ID: 0x0624, Name: "MF624 Multifunction I/O PCI Card"},
			{ID: 0x0625, Name: "MF625 3-phase Motor Driver"},
			{ID: 0x0634, Name: "MF634 Multifunction I/O PCIe Card"},
			{ID: 0x0644, Name: "MF644 Multifunction I/O Thb Card"},
		},
	},
	{ID: 0x186f, Name: "WiNRADiO Communications", Devices: []Device{}},
	{
		ID: 0x1876, Name: "L-3 Communications", Devices: []Device{
			{ID: 0xa101, Name: "VigraWATCH PCI"},
			{ID: 0xa102, Name: "VigraWATCH PMC"},
			{ID: 0xa103, Name: "Vigra I/O"},
		},
	},
	{
		ID: 0x187e, Name: "ZyXEL Communications Corporation", Devices: []Device{
			{ID: 0x3403, Name: "ZyAir G-110 802.11g"},
			{ID: 0x340e, Name: "M-302 802.11g XtremeMIMO"},
		},
	},
	{ID: 0x1885, Name: "Avvida Systems Inc.", Devices: []Device{}},
	{
		ID: 0x1888, Name: "Varisys Ltd", Devices: []Device{
			{ID: 0x0301, Name: "VMFX1 FPGA PMC module"},
			{ID: 0x0601, Name: "VSM2 dual PMC carrier"},
			{ID: 0x0710, Name: "VS14x series PowerPC PCI board"},
			{ID: 0x0720, Name: "VS24x series PowerPC PCI board"},
		},
	},
	{ID: 0x188a, Name: "Ample Communications, Inc", Devices: []Device{}},
	{ID: 0x1890, Name: "Egenera, Inc.", Devices: []Device{}},
	{ID: 0x1894, Name: "KNC One", Devices: []Device{}},
	{
		ID: 0x1896, Name: "B&B Electronics Manufacturing Company, Inc.", Devices: []Device{
			{ID: 0x4202, Name: "MIport 3PCIU2 2-port Serial"},
			{ID: 0x4204, Name: "MIport 3PCIU4 4-port Serial"},
			{ID: 0x4208, Name: "MIport 3PCIU8 8-port Serial"},
			{ID: 0x4211, Name: "MIport 3PCIOU1 1-port Isolated Serial"},
			{ID: 0x4212, Name: "MIport 3PCIOU2 2-port Isolated Serial"},
			{ID: 0x4214, Name: "MIport 3PCIOU4 4-port Isolated Serial"},
			{ID: 0xbb10, Name: "3PCI2 2-Port Serial"},
			{ID: 0xbb11, Name: "3PCIO1 1-Port Isolated Serial"},
		},
	},
	{ID: 0x1897, Name: "AMtek", Devices: []Device{}},
	{ID: 0x18a1, Name: "Astute Networks Inc.", Devices: []Device{}},
	{
		ID: 0x18a2, Name: "Stretch Inc.", Devices: []Device{
			{ID: 0x0002, Name: "VRC6016 16-Channel PCIe DVR Card"},
		},
	},
	{ID: 0x18a3, Name: "AT&T", Devices: []Device{}},
	{
		ID: 0x18ac, Name: "DViCO Corporation", Devices: []Device{
			{ID: 0xd500, Name: "FusionHDTV 5"},
			{ID: 0xd800, Name: "FusionHDTV 3 Gold"},
			{ID: 0xd810, Name: "FusionHDTV 3 Gold-Q"},
			{ID: 0xd820, Name: "FusionHDTV 3 Gold-T"},
			{ID: 0xdb30, Name: "FusionHDTV DVB-T Pro"},
			{ID: 0xdb40, Name: "FusionHDTV DVB-T Hybrid"},
			{ID: 0xdb78, Name: "FusionHDTV DVB-T Dual Express"},
		},
	},
	{
		ID: 0x18b8, Name: "Ammasso", Devices: []Device{
			{ID: 0xb001, Name: "AMSO 1100 iWARP/RDMA Gigabit Ethernet Coprocessor"},
		},
	},
	{ID: 0x18bc, Name: "GeCube Technologies, Inc.", Devices: []Device{}},
	{
		ID: 0x18c3, Name: "Micronas Semiconductor Holding AG", Devices: []Device{
			{ID: 0x0720, Name: "nGene PCI-Express Multimedia Controller"},
		},
	},
	{ID: 0x18c8, Name: "Cray Inc", Devices: []Device{}},
	{ID: 0x18c9, Name: "ARVOO Engineering BV", Devices: []Device{}},
	{
		ID: 0x18ca, Name: "XGI Technology Inc. (eXtreme Graphics Innovation)", Devices: []Device{
			{ID: 0x0020, Name: "Z7/Z9 (XG20 core)"},
			{ID: 0x0021, Name: "Z9s/Z9m (XG21 core)"},
			{ID: 0x0027, Name: "Z11/Z11M"},
			{ID: 0x0040, Name: "Volari V3XT/V5/V8"},
			{ID: 0x0047, Name: "Volari 8300 (chip: XP10, codename: XG47)"},
		},
	},
	{
		ID: 0x18d2, Name: "Sitecom Europe BV (Wrong ID)", Devices: []Device{
			{ID: 0x3069, Name: "DC-105v2 ISDN controller"},
		},
	},
	{ID: 0x18d4, Name: "Celestica", Devices: []Device{}},
	{ID: 0x18d8, Name: "Dialogue Technology Corp.", Devices: []Device{}},
	{
		ID: 0x18dd, Name: "Artimi Inc", Devices: []Device{
			{ID: 0x4c6f, Name: "Artimi RTMI-100 UWB adapter"},
		},
	},
	{ID: 0x18df, Name: "LeWiz Communications", Devices: []Device{}},
	{
		ID: 0x18e6, Name: "MPL AG", Devices: []Device{
			{ID: 0x0001, Name: "OSCI [Octal Serial Communication Interface]"},
		},
	},
	{ID: 0x18eb, Name: "Advance Multimedia Internet Technology, Inc.", Devices: []Device{}},
	{
		ID: 0x18ec, Name: "Cesnet, z.s.p.o.", Devices: []Device{
			{ID: 0x6d05, Name: "ML555"},
			{ID: 0xc006, Name: "COMBO6"},
			{ID: 0xc032, Name: "COMBO-LXT110"},
			{ID: 0xc045, Name: "COMBO6E"},
			{ID: 0xc050, Name: "COMBO-PTM"},
			{ID: 0xc058, Name: "COMBO6X"},
			{ID: 0xc132, Name: "COMBO-LXT155"},
			{ID: 0xc232, Name: "COMBO-FXT100"},
			{ID: 0xc400, Name: "COMBO-400G1"},
		},
	},
	{ID: 0x18ee, Name: "Chenming Mold Ind. Corp.", Devices: []Device{}},
	{ID: 0x18f1, Name: "Spectrum GmbH", Devices: []Device{}},
	{
		ID: 0x18f4, Name: "Napatech A/S", Devices: []Device{
			{ID: 0x0031, Name: "NT20X Network Adapter"},
			{ID: 0x0051, Name: "NT20X Capture Card"},
			{ID: 0x0061, Name: "NT20E Capture Card"},
			{ID: 0x0064, Name: "NT20E Inline Card"},
			{ID: 0x0071, Name: "NT4E Capture Card"},
			{ID: 0x0074, Name: "NT4E Inline Card"},
			{ID: 0x0081, Name: "NT4E 4-port Expansion Card"},
			{ID: 0x0091, Name: "NT20X Capture Card [New Rev]"},
			{ID: 0x00a1, Name: "NT4E-STD Capture Card"},
			{ID: 0x00a4, Name: "NT4E-STD Inline Card"},
			{ID: 0x00b1, Name: "NTBPE Optical Bypass Adapter"},
			{ID: 0x00c5, Name: "NT20E2 Network Adapter 2x10Gb"},
			{ID: 0x00d5, Name: "NT40E2-4 Network Adapter 4x10Gb"},
			{ID: 0x00e5, Name: "NT40E2-1 Network Adapter 1x40Gb"},
			{ID: 0x00f5, Name: "NT4E2-4T-BP Network Adapter 4x1Gb with Electrical Bypass"},
			{ID: 0x0105, Name: "NT4E2-4-PTP Network Adapter 4x1Gb"},
			{ID: 0x0115, Name: "NT20E2-PTP Network Adapter 2x10Gb"},
			{ID: 0x0125, Name: "NT4E2-4-PTP Network Adapter 4x1Gb"},
			{ID: 0x0135, Name: "NT20E2-PTP Network Adapter 2x10Gb"},
			{ID: 0x0145, Name: "NT40E3-4-PTP Network Adapter 4x10Gb"},
			{ID: 0x0155, Name: "NT100E3-1-PTP Network Adapter 1x100Gb"},
			{ID: 0x0165, Name: "NT80E3-2-PTP Network Adapter 2x40Gb"},
			{ID: 0x0175, Name: "NT20E3-2-PTP Network Adapter 2x10Gb"},
			{ID: 0x0185, Name: "NT40A01 Network Adapter"},
			{ID: 0x01a5, Name: "NT200A01 Network Adapter"},
			{ID: 0x01c5, Name: "NT200A02 Network Adapter"},
			{ID: 0x01d5, Name: "NT50B01 Network Adapter"},
			{ID: 0x01e5, Name: "NT100A01 Network Adapter"},
		},
	},
	{
		ID: 0x18f6, Name: "NextIO", Devices: []Device{
			{ID: 0x1000, Name: "[Nexsis] Switch Virtual P2P PCIe Bridge"},
			{ID: 0x1001, Name: "[Texsis] Switch Virtual P2P PCIe Bridge"},
			{ID: 0x1050, Name: "[Nexsis] Switch Virtual P2P PCI Bridge"},
			{ID: 0x1051, Name: "[Texsis] Switch Virtual P2P PCI Bridge"},
			{ID: 0x2000, Name: "[Nexsis] Switch Integrated Mgmt. Endpoint"},
			{ID: 0x2001, Name: "[Texsis] Switch Integrated Mgmt. Endpoint"},
		},
	},
	{
		ID: 0x18f7, Name: "Commtech, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "ESCC-PCI-335 Serial PCI Adapter [Fastcom]"},
			{ID: 0x0002, Name: "422/4-PCI-335 Serial PCI Adapter [Fastcom]"},
			{ID: 0x0003, Name: "232/4-1M-PCI Serial PCI Adapter [Fastcom]"},
			{ID: 0x0004, Name: "422/2-PCI-335 Serial PCI Adapter [Fastcom]"},
			{ID: 0x0005, Name: "IGESCC-PCI-ISO/1 Serial PCI Adapter [Fastcom]"},
			{ID: 0x000a, Name: "232/4-PCI-335 Serial PCI Adapter [Fastcom]"},
			{ID: 0x000b, Name: "232/8-PCI-335 Serial PCI Adapter [Fastcom]"},
			{ID: 0x000f, Name: "FSCC Serial PCI Adapter [Fastcom]"},
			{ID: 0x0010, Name: "GSCC Serial PCI Adapter [Fastcom]"},
			{ID: 0x0011, Name: "QSSB Serial PCI Adapter [Fastcom]"},
			{ID: 0x0014, Name: "SuperFSCC Serial PCI Adapter [Fastcom]"},
			{ID: 0x0015, Name: "SuperFSCC-104-LVDS Serial PC/104+ Adapter [Fastcom]"},
			{ID: 0x0016, Name: "FSCC-232 RS-232 Serial PCI Adapter [Fastcom]"},
			{ID: 0x0017, Name: "SuperFSCC-104 Serial PC/104+ Adapter [Fastcom]"},
			{ID: 0x0018, Name: "SuperFSCC/4 Serial PCI Adapter [Fastcom]"},
			{ID: 0x0019, Name: "SuperFSCC Serial PCI Adapter [Fastcom]"},
			{ID: 0x001a, Name: "SuperFSCC-LVDS Serial PCI Adapter [Fastcom]"},
			{ID: 0x001b, Name: "FSCC/4 Serial PCI Adapter [Fastcom]"},
			{ID: 0x001c, Name: "SuperFSCC/4-LVDS Serial PCI Adapter [Fastcom]"},
			{ID: 0x001d, Name: "FSCC Serial PCI Adapter [Fastcom]"},
			{ID: 0x001e, Name: "SuperFSCC/4 Serial PCIe Adapter [Fastcom]"},
			{ID: 0x001f, Name: "SuperFSCC/4 Serial cPCI Adapter [Fastcom]"},
			{ID: 0x0020, Name: "422/4-PCIe Serial PCIe Adapter [Fastcom]"},
			{ID: 0x0021, Name: "422/8-PCIe Serial PCIe Adapter [Fastcom]"},
			{ID: 0x0022, Name: "SuperFSCC/4-LVDS Serial PCIe Adapter [Fastcom]"},
			{ID: 0x0023, Name: "SuperFSCC/4 Serial cPCI Adapter [Fastcom]"},
			{ID: 0x0025, Name: "SuperFSCC/4-LVDS Serial PCI Adapter [Fastcom]"},
			{ID: 0x0026, Name: "SuperFSCC-LVDS Serial PCI Adapter [Fastcom]"},
			{ID: 0x0027, Name: "FSCC/4 Serial PCIe Adapter [Fastcom]"},
		},
	},
	{ID: 0x18fb, Name: "Resilience Corporation", Devices: []Device{}},
	{
		ID: 0x1904, Name: "Hangzhou Silan Microelectronics Co., Ltd.", Devices: []Device{
			{ID: 0x2031, Name: "SC92031 PCI Fast Ethernet Adapter"},
			{ID: 0x8139, Name: "RTL8139D [Realtek] PCI 10/100BaseTX ethernet adaptor"},
		},
	},
	{ID: 0x1905, Name: "Micronas USA, Inc.", Devices: []Device{}},
	{
		ID: 0x1912, Name: "Renesas Technology Corp.", Devices: []Device{
			{ID: 0x0002, Name: "SH7780 PCI Controller (PCIC)"},
			{ID: 0x0011, Name: "SH7757 PCIe End-Point [PBI]"},
			{ID: 0x0012, Name: "SH7757 PCIe-PCI Bridge [PPB]"},
			{ID: 0x0013, Name: "SH7757 PCIe Switch [PS]"},
			{ID: 0x0014, Name: "uPD720201 USB 3.0 Host Controller"},
			{ID: 0x0015, Name: "uPD720202 USB 3.0 Host Controller"},
			{ID: 0x001a, Name: "SH7758 PCIe-PCI Bridge [PPB]"},
			{ID: 0x001b, Name: "SH7758 PCIe End-Point [PBI]"},
			{ID: 0x001d, Name: "SH7758 PCIe Switch [PS]"},
		},
	},
	{ID: 0x1919, Name: "Soltek Computer Inc.", Devices: []Device{}},
	{
		ID: 0x1923, Name: "Sangoma Technologies Corp.", Devices: []Device{
			{ID: 0x0040, Name: "A200/Remora FXO/FXS Analog AFT card"},
			{ID: 0x0100, Name: "A104d QUAD T1/E1 AFT card"},
			{ID: 0x0300, Name: "A101 single-port T1/E1"},
			{ID: 0x0400, Name: "A104u Quad T1/E1 AFT"},
		},
	},
	{
		ID: 0x1924, Name: "Solarflare Communications", Devices: []Device{
			{ID: 0x0703, Name: "SFC4000 rev A net [Solarstorm]"},
			{ID: 0x0710, Name: "SFC4000 rev B [Solarstorm]"},
			{ID: 0x0803, Name: "SFC9020 10G Ethernet Controller"},
			{ID: 0x0813, Name: "SFL9021 10GBASE-T Ethernet Controller"},
			{ID: 0x0903, Name: "SFC9120 10G Ethernet Controller"},
			{ID: 0x0923, Name: "SFC9140 10/40G Ethernet Controller"},
			{ID: 0x0a03, Name: "SFC9220 10/40G Ethernet Controller"},
			{ID: 0x0b03, Name: "XtremeScale SFC9250 10/25/40/50/100G Ethernet Controller"},
			{ID: 0x1803, Name: "SFC9020 10G Ethernet Controller (Virtual Function)"},
			{ID: 0x1813, Name: "SFL9021 10GBASE-T Ethernet Controller (Virtual Function)"},
			{ID: 0x1903, Name: "SFC9120 10G Ethernet Controller (Virtual Function)"},
			{ID: 0x1923, Name: "SFC9140 10/40G Ethernet Controller (Virtual Function)"},
			{ID: 0x1a03, Name: "SFC9220 10/40G Ethernet Controller (Virtual Function)"},
			{ID: 0x1b03, Name: "XtremeScale SFC9250 10/25/40/50/100G Ethernet Controller (Virtual Function)"},
			{ID: 0x6703, Name: "SFC4000 rev A iSCSI/Onload [Solarstorm]"},
			{ID: 0xc101, Name: "EF1-21022T [EtherFabric]"},
		},
	},
	{
		ID: 0x192a, Name: "BiTMICRO Networks Inc.", Devices: []Device{
			{ID: 0x0008, Name: "RAMPART"},
		},
	},
	{ID: 0x192e, Name: "TransDimension", Devices: []Device{}},
	{
		ID: 0x1931, Name: "Option N.V.", Devices: []Device{
			{ID: 0x000c, Name: "Qualcomm MSM6275 UMTS chip"},
		},
	},
	{ID: 0x1932, Name: "DiBcom", Devices: []Device{}},
	{ID: 0x193c, Name: "MAXIM Integrated Products", Devices: []Device{}},
	{ID: 0x193d, Name: "Hangzhou H3C Technologies Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x193f, Name: "AHA Products Group", Devices: []Device{
			{ID: 0x0001, Name: "AHA36x-PCIX"},
			{ID: 0x0360, Name: "AHA360-PCIe"},
			{ID: 0x0363, Name: "AHA363-PCIe"},
			{ID: 0x0364, Name: "AHA364-PCIe"},
			{ID: 0x0367, Name: "AHA367-PCIe"},
			{ID: 0x0370, Name: "AHA370-PCIe"},
			{ID: 0x0604, Name: "AHA604"},
			{ID: 0x0605, Name: "AHA605"},
			{ID: 0x3641, Name: "AHA3641"},
			{ID: 0x3642, Name: "AHA3642"},
			{ID: 0x6101, Name: "AHA6101"},
			{ID: 0x6102, Name: "AHA6102"},
		},
	},
	{
		ID: 0x1942, Name: "ClearSpeed Technology plc", Devices: []Device{
			{ID: 0xe511, Name: "Advance X620 accelerator card"},
			{ID: 0xe521, Name: "Advance e620 accelerator card"},
		},
	},
	{
		ID: 0x1947, Name: "C-guys, Inc.", Devices: []Device{
			{ID: 0x4743, Name: "CG200 Dual SD/SDIO Host controller device"},
		},
	},
	{ID: 0x1948, Name: "Alpha Networks Inc.", Devices: []Device{}},
	{
		ID: 0x194a, Name: "DapTechnology B.V.", Devices: []Device{
			{ID: 0x1111, Name: "FireSpy3850"},
			{ID: 0x1112, Name: "FireSpy450b"},
			{ID: 0x1113, Name: "FireSpy450bT"},
			{ID: 0x1114, Name: "FireSpy850"},
			{ID: 0x1115, Name: "FireSpy850bT"},
			{ID: 0x1200, Name: "FireTrac 3460bT"},
			{ID: 0x1201, Name: "FireTrac 3460bT (fallback firmware)"},
			{ID: 0x1202, Name: "FireTrac 3460bT"},
			{ID: 0x1203, Name: "FireTrac 3460bT (fallback firmware)"},
		},
	},
	{ID: 0x1954, Name: "One Stop Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x1957, Name: "Freescale Semiconductor Inc", Devices: []Device{
			{ID: 0x0012, Name: "MPC8548E"},
			{ID: 0x0013, Name: "MPC8548"},
			{ID: 0x0014, Name: "MPC8543E"},
			{ID: 0x0015, Name: "MPC8543"},
			{ID: 0x0018, Name: "MPC8547E"},
			{ID: 0x0019, Name: "MPC8545E"},
			{ID: 0x001a, Name: "MPC8545"},
			{ID: 0x0020, Name: "MPC8568E"},
			{ID: 0x0021, Name: "MPC8568"},
			{ID: 0x0022, Name: "MPC8567E"},
			{ID: 0x0023, Name: "MPC8567"},
			{ID: 0x0030, Name: "MPC8533E"},
			{ID: 0x0031, Name: "MPC8533"},
			{ID: 0x0032, Name: "MPC8544E"},
			{ID: 0x0033, Name: "MPC8544"},
			{ID: 0x0040, Name: "MPC8572E"},
			{ID: 0x0041, Name: "MPC8572"},
			{ID: 0x0050, Name: "MPC8536E"},
			{ID: 0x0051, Name: "MPC8536"},
			{ID: 0x0052, Name: "MPC8535E"},
			{ID: 0x0053, Name: "MPC8535"},
			{ID: 0x0060, Name: "MPC8569"},
			{ID: 0x0061, Name: "MPC8569E"},
			{ID: 0x0070, Name: "P2020E"},
			{ID: 0x0071, Name: "P2020"},
			{ID: 0x0078, Name: "P2010E"},
			{ID: 0x0079, Name: "P2010"},
			{ID: 0x0080, Name: "MPC8349E"},
			{ID: 0x0081, Name: "MPC8349"},
			{ID: 0x0082, Name: "MPC8347E TBGA"},
			{ID: 0x0083, Name: "MPC8347 TBGA"},
			{ID: 0x0084, Name: "MPC8347E PBGA"},
			{ID: 0x0085, Name: "MPC8347 PBGA"},
			{ID: 0x0086, Name: "MPC8343E"},
			{ID: 0x0087, Name: "MPC8343"},
			{ID: 0x00b4, Name: "MPC8315E"},
			{ID: 0x00b6, Name: "MPC8314E"},
			{ID: 0x00c2, Name: "MPC8379E"},
			{ID: 0x00c3, Name: "MPC8379"},
			{ID: 0x00c4, Name: "MPC8378E"},
			{ID: 0x00c5, Name: "MPC8378"},
			{ID: 0x00c6, Name: "MPC8377E"},
			{ID: 0x00c7, Name: "MPC8377"},
			{ID: 0x0100, Name: "P1020E"},
			{ID: 0x0101, Name: "P1020"},
			{ID: 0x0102, Name: "P1021E"},
			{ID: 0x0103, Name: "P1021"},
			{ID: 0x0108, Name: "P1011E"},
			{ID: 0x0109, Name: "P1011"},
			{ID: 0x010a, Name: "P1012E"},
			{ID: 0x010b, Name: "P1012"},
			{ID: 0x0110, Name: "P1022E"},
			{ID: 0x0111, Name: "P1022"},
			{ID: 0x0118, Name: "P1013E"},
			{ID: 0x0119, Name: "P1013"},
			{ID: 0x0128, Name: "P1010"},
			{ID: 0x0400, Name: "P4080E"},
			{ID: 0x0401, Name: "P4080"},
			{ID: 0x0408, Name: "P4040E"},
			{ID: 0x0409, Name: "P4040"},
			{ID: 0x041f, Name: "P3041"},
			{ID: 0x0440, Name: "T4240 with security"},
			{ID: 0x0441, Name: "T4240 without security"},
			{ID: 0x0446, Name: "T4160 with security"},
			{ID: 0x0447, Name: "T4160 without security"},
			{ID: 0x0830, Name: "T2080 with security"},
			{ID: 0x0831, Name: "T2080 without security"},
			{ID: 0x0838, Name: "T2081 with security"},
			{ID: 0x0839, Name: "T2081 without security"},
			{ID: 0x580c, Name: "MPC5121e"},
			{ID: 0x7010, Name: "MPC8641 PCI Host Bridge"},
			{ID: 0x7011, Name: "MPC8641D PCI Host Bridge"},
			{ID: 0x7018, Name: "MPC8610"},
			{ID: 0xc006, Name: "MPC8308"},
			{ID: 0xfc02, Name: "RedStone"},
			{ID: 0xfc03, Name: "CFI"},
		},
	},
	{ID: 0x1958, Name: "Faster Technology, LLC.", Devices: []Device{}},
	{
		ID: 0x1959, Name: "PA Semi, Inc", Devices: []Device{
			{ID: 0xa000, Name: "PA6T Core"},
			{ID: 0xa001, Name: "PWRficient Host Bridge"},
			{ID: 0xa002, Name: "PWRficient PCI-Express Port"},
			{ID: 0xa003, Name: "PWRficient SMBus Controller"},
			{ID: 0xa004, Name: "PWRficient 16550 UART"},
			{ID: 0xa005, Name: "PWRficient Gigabit Ethernet"},
			{ID: 0xa006, Name: "PWRficient 10-Gigabit Ethernet"},
			{ID: 0xa007, Name: "PWRficient DMA Controller"},
			{ID: 0xa008, Name: "PWRficient LPC/Localbus Interface"},
			{ID: 0xa009, Name: "PWRficient L2 Cache"},
			{ID: 0xa00a, Name: "PWRficient DDR2 Memory Controller"},
			{ID: 0xa00b, Name: "PWRficient SERDES"},
			{ID: 0xa00c, Name: "PWRficient System/Debug Controller"},
			{ID: 0xa00d, Name: "PWRficient PCI-Express Internal Endpoint"},
		},
	},
	{
		ID: 0x1966, Name: "Orad Hi-Tec Systems", Devices: []Device{
			{ID: 0x1975, Name: "DVG64 family"},
			{ID: 0x1977, Name: "DVG128 family"},
			{ID: 0x1979, Name: "3DVG/UHD3"},
			{ID: 0x1980, Name: "HDV2/UHD2"},
		},
	},
	{
		ID: 0x1969, Name: "Qualcomm Atheros", Devices: []Device{
			{ID: 0x1026, Name: "AR8121/AR8113/AR8114 Gigabit or Fast Ethernet"},
			{ID: 0x1048, Name: "Attansic L1 Gigabit Ethernet"},
			{ID: 0x1062, Name: "AR8132 Fast Ethernet"},
			{ID: 0x1063, Name: "AR8131 Gigabit Ethernet"},
			{ID: 0x1066, Name: "Attansic L2c Gigabit Ethernet"},
			{ID: 0x1067, Name: "Attansic L1c Gigabit Ethernet"},
			{ID: 0x1073, Name: "AR8151 v1.0 Gigabit Ethernet"},
			{ID: 0x1083, Name: "AR8151 v2.0 Gigabit Ethernet"},
			{ID: 0x1090, Name: "AR8162 Fast Ethernet"},
			{ID: 0x1091, Name: "AR8161 Gigabit Ethernet"},
			{ID: 0x10a0, Name: "QCA8172 Fast Ethernet"},
			{ID: 0x10a1, Name: "QCA8171 Gigabit Ethernet"},
			{ID: 0x2048, Name: "Attansic L2 Fast Ethernet"},
			{ID: 0x2060, Name: "AR8152 v1.1 Fast Ethernet"},
			{ID: 0x2062, Name: "AR8152 v2.0 Fast Ethernet"},
			{ID: 0xe091, Name: "Killer E220x Gigabit Ethernet Controller"},
			{ID: 0xe0a1, Name: "Killer E2400 Gigabit Ethernet Controller"},
			{ID: 0xe0b1, Name: "Killer E2500 Gigabit Ethernet Controller"},
		},
	},
	{
		ID: 0x196a, Name: "Sensory Networks Inc.", Devices: []Device{
			{ID: 0x0101, Name: "NodalCore C-1000 Content Classification Accelerator"},
			{ID: 0x0102, Name: "NodalCore C-2000 Content Classification Accelerator"},
			{ID: 0x0105, Name: "NodalCore C-3000 Content Classification Accelerator"},
		},
	},
	{ID: 0x196d, Name: "Club-3D BV", Devices: []Device{}},
	{ID: 0x196e, Name: "PNY", Devices: []Device{}},
	{
		ID: 0x1971, Name: "AGEIA Technologies, Inc.", Devices: []Device{
			{ID: 0x1011, Name: "Physics Processing Unit [PhysX]"},
		},
	},
	{
		ID: 0x1974, Name: "Star Electronics GmbH & Co. KG", Devices: []Device{
			{ID: 0x0009, Name: "FlexCard PMC-II"},
			{ID: 0x0011, Name: "FlexCard PMC-II Ethernet"},
			{ID: 0x0018, Name: "FlexCard PXIe3"},
			{ID: 0x0019, Name: "FlexCard PCIe3"},
			{ID: 0x001a, Name: "FlexCard PXIe Ethernet"},
			{ID: 0x001b, Name: "FlexCard PCIe Ethernet"},
		},
	},
	{ID: 0x1976, Name: "TRENDnet", Devices: []Device{}},
	{ID: 0x1977, Name: "Parsec", Devices: []Device{}},
	{
		ID: 0x197b, Name: "JMicron Technology Corp.", Devices: []Device{
			{ID: 0x0250, Name: "JMC250 PCI Express Gigabit Ethernet Controller"},
			{ID: 0x0260, Name: "JMC260 PCI Express Fast Ethernet Controller"},
			{ID: 0x0368, Name: "JMB368 IDE controller"},
			{ID: 0x0585, Name: "JMB58x AHCI SATA controller"},
			{ID: 0x2360, Name: "JMB360 AHCI Controller"},
			{ID: 0x2361, Name: "JMB361 AHCI/IDE"},
			{ID: 0x2362, Name: "JMB362 SATA Controller"},
			{ID: 0x2363, Name: "JMB363 SATA/IDE Controller"},
			{ID: 0x2364, Name: "JMB364 AHCI Controller"},
			{ID: 0x2365, Name: "JMB365 AHCI/IDE"},
			{ID: 0x2366, Name: "JMB366 AHCI/IDE"},
			{ID: 0x2368, Name: "JMB368 IDE controller"},
			{ID: 0x2369, Name: "JMB369 Serial ATA Controller"},
			{ID: 0x2380, Name: "IEEE 1394 Host Controller"},
			{ID: 0x2381, Name: "Standard SD Host Controller"},
			{ID: 0x2382, Name: "SD/MMC Host Controller"},
			{ID: 0x2383, Name: "MS Host Controller"},
			{ID: 0x2384, Name: "xD Host Controller"},
			{ID: 0x2386, Name: "Standard SD Host Controller"},
			{ID: 0x2387, Name: "SD/MMC Host Controller"},
			{ID: 0x2388, Name: "MS Host Controller"},
			{ID: 0x2389, Name: "xD Host Controller"},
			{ID: 0x2391, Name: "Standard SD Host Controller"},
			{ID: 0x2392, Name: "SD/MMC Host Controller"},
			{ID: 0x2393, Name: "MS Host Controller"},
			{ID: 0x2394, Name: "xD Host Controller"},
		},
	},
	{
		ID: 0x1982, Name: "Distant Early Warning Communications Inc", Devices: []Device{
			{ID: 0x1600, Name: "OX16C954 HOST-A"},
			{ID: 0x16ff, Name: "OX16C954 HOST-B"},
		},
	},
	{
		ID: 0x1987, Name: "Phison Electronics Corporation", Devices: []Device{
			{ID: 0x5007, Name: "E7 NVMe Controller"},
			{ID: 0x5012, Name: "E12 NVMe Controller"},
			{ID: 0x5013, Name: "PS5013 E13 NVMe Controller"},
			{ID: 0x5016, Name: "E16 PCIe4 NVMe Controller"},
			{ID: 0x5018, Name: "E18 PCIe4 NVMe Controller"},
		},
	},
	{
		ID: 0x1989, Name: "Montilio Inc.", Devices: []Device{
			{ID: 0x0001, Name: "RapidFile Bridge"},
			{ID: 0x8001, Name: "RapidFile"},
		},
	},
	{ID: 0x198a, Name: "Nallatech Ltd.", Devices: []Device{}},
	{ID: 0x1993, Name: "Innominate Security Technologies AG", Devices: []Device{}},
	{
		ID: 0x1999, Name: "A-Logics", Devices: []Device{
			{ID: 0xa900, Name: "AM-7209 Video Processor"},
		},
	},
	{ID: 0x199a, Name: "Pulse-LINK, Inc.", Devices: []Device{}},
	{
		ID: 0x199d, Name: "Xsigo Systems", Devices: []Device{
			{ID: 0x8209, Name: "Virtual NIC Device"},
			{ID: 0x890a, Name: "Virtual HBA Device"},
		},
	},
	{
		ID: 0x199f, Name: "Auvitek", Devices: []Device{
			{ID: 0x8501, Name: "AU85X1 PCI REV1.1"},
			{ID: 0x8521, Name: "AU8521 TV card"},
		},
	},
	{
		ID: 0x19a2, Name: "Emulex Corporation", Devices: []Device{
			{ID: 0x0120, Name: "x1 PCIe Gen2 Bridge[Pilot4]"},
			{ID: 0x0200, Name: "BladeEngine 10Gb PCI-E iSCSI adapter"},
			{ID: 0x0201, Name: "BladeEngine 10Gb PCIe Network Adapter"},
			{ID: 0x0211, Name: "BladeEngine2 10Gb Gen2 PCIe Network Adapter"},
			{ID: 0x0212, Name: "BladeEngine2 10Gb Gen2 PCIe iSCSI Adapter"},
			{ID: 0x0221, Name: "BladeEngine3 10Gb Gen2 PCIe Network Adapter"},
			{ID: 0x0222, Name: "BladeEngine3 10Gb Gen2 PCIe iSCSI Adapter"},
			{ID: 0x0700, Name: "OneConnect OCe10100/OCe10102 Series 10 GbE"},
			{ID: 0x0702, Name: "OneConnect 10Gb iSCSI Initiator"},
			{ID: 0x0704, Name: "OneConnect OCe10100/OCe10102 Series 10 GbE CNA"},
			{ID: 0x0710, Name: "OneConnect 10Gb NIC (be3)"},
			{ID: 0x0712, Name: "OneConnect 10Gb iSCSI Initiator (be3)"},
			{ID: 0x0714, Name: "OneConnect 10Gb FCoE Initiator (be3)"},
			{ID: 0x0800, Name: "ServerView iRMC HTI"},
		},
	},
	{ID: 0x19a8, Name: "DAQDATA GmbH", Devices: []Device{}},
	{
		ID: 0x19ac, Name: "Kasten Chase Applied Research", Devices: []Device{
			{ID: 0x0001, Name: "ACA2400 Crypto Accelerator"},
		},
	},
	{
		ID: 0x19ae, Name: "Progeny Systems Corporation", Devices: []Device{
			{ID: 0x0520, Name: "4135 HFT Interface Controller"},
			{ID: 0x0521, Name: "Decimator"},
		},
	},
	{
		ID: 0x19ba, Name: "ZyXEL Communications Corp.", Devices: []Device{
			{ID: 0x2330, Name: "ZyWALL Turbo Card"},
		},
	},
	{ID: 0x19c1, Name: "Exegy Inc.", Devices: []Device{}},
	{ID: 0x19d1, Name: "Motorola Expedience", Devices: []Device{}},
	{ID: 0x19d4, Name: "Quixant Limited", Devices: []Device{}},
	{ID: 0x19da, Name: "ZOTAC International (MCO) Ltd.", Devices: []Device{}},
	{ID: 0x19de, Name: "Pico Computing", Devices: []Device{}},
	{ID: 0x19e2, Name: "Vector Informatik GmbH", Devices: []Device{}},
	{
		ID: 0x19e3, Name: "DDRdrive LLC", Devices: []Device{
			{ID: 0x5801, Name: "DDRdrive X1"},
			{ID: 0x5808, Name: "DDRdrive X8"},
			{ID: 0xdd52, Name: "DDRdrive X1-30"},
		},
	},
	{
		ID: 0x19e5, Name: "Huawei Technologies Co., Ltd.", Devices: []Device{
			{ID: 0x0123, Name: "ES3000 V3 NVMe PCIe SSD"},
			{ID: 0x0200, Name: "Hi1822 Family (2*100GE)"},
			{ID: 0x0202, Name: "Hi1822 Family (2*32G FC)"},
			{ID: 0x0203, Name: "Hi1822 Family (2*16G FC)"},
			{ID: 0x0205, Name: "Hi1822 Family (2*100GE)"},
			{ID: 0x0206, Name: "Hi1822 Family (2*25GE)"},
			{ID: 0x0210, Name: "Hi1822 Family (4*25GE)"},
			{ID: 0x0211, Name: "Hi1822 Family (4*25GE)"},
			{ID: 0x0212, Name: "Hi1822 Family (2*8G FC)"},
			{ID: 0x1710, Name: "iBMA Virtual Network Adapter"},
			{ID: 0x1711, Name: "Hi171x Series [iBMC Intelligent Management system chip w/VGA support]"},
			{ID: 0x1822, Name: "Hi1822 Family (4*25GE)"},
			{ID: 0x3714, Name: "ES3000 V5 NVMe PCIe SSD"},
			{ID: 0x371e, Name: "Hi1822 Family Virtual Bridge"},
			{ID: 0x3754, Name: "ES3000 V6 NVMe PCIe SSD"},
			{ID: 0x375e, Name: "Hi1822 Family Virtual Function"},
			{ID: 0x379e, Name: "Hi1822 Family Virtual Function"},
			{ID: 0xa120, Name: "HiSilicon PCIe Root Port with Gen4"},
			{ID: 0xa121, Name: "HiSilicon PCI-PCI Bridge"},
			{ID: 0xa122, Name: "HiSilicon Embedded DMA Engine"},
			{ID: 0xa124, Name: "HiSilicon Internal SDI Function Engine"},
			{ID: 0xa125, Name: "HiSilicon SDI Network Controller"},
			{ID: 0xa126, Name: "HiSilicon SDI NVMe Storage Controller"},
			{ID: 0xa127, Name: "HiSilicon SDI Accelerator"},
			{ID: 0xa12a, Name: "HiSilicon Add-on PCI-PCI Bridge"},
			{ID: 0xa220, Name: "HNS GE Network Controller"},
			{ID: 0xa221, Name: "HNS GE/10GE/25GE Network Controller"},
			{ID: 0xa222, Name: "HNS GE/10GE/25GE RDMA Network Controller"},
			{ID: 0xa224, Name: "HNS GE/10GE/25GE/50GE RDMA Network Controller"},
			{ID: 0xa226, Name: "HNS GE/10GE/25GE/50GE/100GE RDMA Network Controller"},
			{ID: 0xa22a, Name: "HiSilicon Network For SDI"},
			{ID: 0xa22e, Name: "HNS Network Controller (Virtual Function)"},
			{ID: 0xa22f, Name: "HNS RDMA Network Controller (Virtual Function)"},
			{ID: 0xa230, Name: "HiSilicon SAS 3.0 HBA"},
			{ID: 0xa235, Name: "HiSilicon AHCI HBA"},
			{ID: 0xa238, Name: "HiSilicon USB 3.0 Host Controller"},
			{ID: 0xa239, Name: "HiSilicon USB 2.0 2-port Host Controller"},
			{ID: 0xa23a, Name: "HiSilicon USB 2.0 Host Controller"},
			{ID: 0xa23b, Name: "HiSilicon USB 1.1 Host Controller"},
			{ID: 0xa250, Name: "HiSilicon ZIP Engine"},
			{ID: 0xa251, Name: "HiSilicon ZIP Engine(Virtual Function)"},
			{ID: 0xa255, Name: "HiSilicon SEC Engine"},
			{ID: 0xa256, Name: "HiSilicon SEC Engine(Virtual Function)"},
			{ID: 0xa258, Name: "HiSilicon HPRE Engine"},
			{ID: 0xa259, Name: "HiSilicon HPRE Engine(Virtual Function)"},
			{ID: 0xa25a, Name: "HiSilicon RDE Engine"},
			{ID: 0xa25b, Name: "HiSilicon RDE Engine(Virtual Function)"},
		},
	},
	{
		ID: 0x19e7, Name: "NET (Network Equipment Technologies)", Devices: []Device{
			{ID: 0x1001, Name: "STIX DSP Card"},
			{ID: 0x1002, Name: "STIX - 1 Port T1/E1 Card"},
			{ID: 0x1003, Name: "STIX - 2 Port T1/E1 Card"},
			{ID: 0x1004, Name: "STIX - 4 Port T1/E1 Card"},
			{ID: 0x1005, Name: "STIX - 4 Port FXS Card"},
		},
	},
	{ID: 0x19ee, Name: "Netronome Systems, Inc.", Devices: []Device{}},
	{ID: 0x19f1, Name: "BFG Tech", Devices: []Device{}},
	{ID: 0x19ff, Name: "Eclipse Electronic Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x1a03, Name: "ASPEED Technology, Inc.", Devices: []Device{
			{ID: 0x1150, Name: "AST1150 PCI-to-PCI Bridge"},
			{ID: 0x2000, Name: "ASPEED Graphics Family"},
		},
	},
	{ID: 0x1a05, Name: "deltaww", Devices: []Device{}},
	{
		ID: 0x1a07, Name: "Kvaser AB", Devices: []Device{
			{ID: 0x0006, Name: "CAN interface PC104+ HS/HS"},
			{ID: 0x0007, Name: "CAN interface PCIcanx II HS or HS/HS"},
			{ID: 0x0008, Name: "CAN interface PCIEcan HS or HS/HS"},
			{ID: 0x0009, Name: "CAN interface PCI104 HS/HS"},
		},
	},
	{
		ID: 0x1a08, Name: "Sierra semiconductor", Devices: []Device{
			{ID: 0x0000, Name: "SC15064"},
		},
	},
	{ID: 0x1a0d, Name: "SEAKR Engineering", Devices: []Device{}},
	{
		ID: 0x1a0e, Name: "DekTec Digital Video B.V.", Devices: []Device{
			{ID: 0x083f, Name: "DTA-2111 VHF/UHF Modulator"},
		},
	},
	{
		ID: 0x1a17, Name: "Force10 Networks, Inc.", Devices: []Device{
			{ID: 0x8002, Name: "PB-10GE-2P 10GbE Security Card"},
		},
	},
	{
		ID: 0x1a1d, Name: "GFaI e.V.", Devices: []Device{
			{ID: 0x1a17, Name: "Meta Networks MTP-1G IDPS NIC"},
		},
	},
	{ID: 0x1a1e, Name: "3Leaf Systems, Inc.", Devices: []Device{}},
	{ID: 0x1a22, Name: "Ambric Inc.", Devices: []Device{}},
	{
		ID: 0x1a29, Name: "Fortinet, Inc.", Devices: []Device{
			{ID: 0x4338, Name: "CP8 Content Processor ASIC"},
			{ID: 0x43a0, Name: "CP9 Content Processor ASIC"},
			{ID: 0x4e36, Name: "NP6 Network Processor"},
			{ID: 0x4e37, Name: "NP7 Network Processor"},
		},
	},
	{
		ID: 0x1a2b, Name: "Ascom AG", Devices: []Device{
			{ID: 0x0000, Name: "GESP v1.2"},
			{ID: 0x0001, Name: "GESP v1.3"},
			{ID: 0x0002, Name: "ECOMP v1.3"},
			{ID: 0x0005, Name: "ETP v1.4"},
			{ID: 0x000a, Name: "ETP-104 v1.1"},
			{ID: 0x000e, Name: "DSLP-104 v1.1"},
		},
	},
	{
		ID: 0x1a30, Name: "Lantiq", Devices: []Device{
			{ID: 0x0680, Name: "MtW8171 [Hyperion II]"},
			{ID: 0x0700, Name: "Wave300 PSB8224 [Hyperion III]"},
			{ID: 0x0710, Name: "Wave300 PSB8231 [Hyperion III]"},
		},
	},
	{ID: 0x1a32, Name: "Quanta Microsystems, Inc", Devices: []Device{}},
	{
		ID: 0x1a3b, Name: "AzureWave", Devices: []Device{
			{ID: 0x1112, Name: "AR9285 Wireless Network Adapter (PCI-Express)"},
		},
	},
	{
		ID: 0x1a41, Name: "Tilera Corp.", Devices: []Device{
			{ID: 0x0001, Name: "TILE64 processor"},
			{ID: 0x0002, Name: "TILEPro processor"},
			{ID: 0x0200, Name: "TILE-Gx processor"},
			{ID: 0x0201, Name: "TILE-Gx Processor Virtual Function"},
			{ID: 0x2000, Name: "TILE-Gx PCI Express Root Port"},
		},
	},
	{
		ID: 0x1a4a, Name: "SLAC National Accelerator Lab TID-AIR", Devices: []Device{
			{ID: 0x1000, Name: "MCOR Power Supply Controller"},
			{ID: 0x1010, Name: "AMC EVR - Stockholm Timing Board"},
			{ID: 0x1020, Name: "PGPCard - Gen3 Cameralink Interface"},
			{ID: 0x1030, Name: "PGPCard - Gen3 GIGe Interface"},
			{ID: 0x2000, Name: "PGPCard - 4 Lane"},
			{ID: 0x2001, Name: "PGPCard - 8 Lane Plus EVR"},
			{ID: 0x2010, Name: "PCI-Express EVR"},
			{ID: 0x2011, Name: "PCI-Express EVR - TPR Version"},
			{ID: 0x2020, Name: "PGP-GEN3 PCIe - 8 Lane Plus EVR"},
			{ID: 0x2030, Name: "AXI Stream DAQ PCIe card"},
			{ID: 0x2040, Name: "EXO PCIe TEM"},
			{ID: 0x3000, Name: "COB DTM V1"},
			{ID: 0x3001, Name: "COB DTM V2"},
		},
	},
	{ID: 0x1a51, Name: "Hectronic AB", Devices: []Device{}},
	{
		ID: 0x1a55, Name: "Rohde & Schwarz DVS GmbH", Devices: []Device{
			{ID: 0x0010, Name: "SDStationOEM"},
			{ID: 0x0011, Name: "SDStationOEM II"},
			{ID: 0x0020, Name: "Centaurus"},
			{ID: 0x0021, Name: "Centaurus II"},
			{ID: 0x0022, Name: "Centaurus II LT"},
			{ID: 0x0030, Name: "CLIPSTER-VPU 1.x (Hugo)"},
			{ID: 0x0040, Name: "Hydra Cinema (JPEG)"},
			{ID: 0x0050, Name: "CLIPSTER-VPU 2.x (DigiLab)"},
			{ID: 0x0060, Name: "CLIPSTER-DCI 2.x (HydraX)"},
			{ID: 0x0061, Name: "Atomix"},
			{ID: 0x0062, Name: "Atomix LT"},
			{ID: 0x0063, Name: "Atomix HDMI"},
			{ID: 0x0064, Name: "Atomix STAN"},
			{ID: 0x0065, Name: "Atomix HDMI STAN"},
			{ID: 0x0070, Name: "RED Rocket"},
			{ID: 0x0090, Name: "CinePlay"},
		},
	},
	{ID: 0x1a56, Name: "Rivet Networks", Devices: []Device{}},
	{ID: 0x1a57, Name: "Highly Reliable Systems", Devices: []Device{}},
	{ID: 0x1a58, Name: "Razer USA Ltd.", Devices: []Device{}},
	{ID: 0x1a5d, Name: "Celoxica", Devices: []Device{}},
	{ID: 0x1a5e, Name: "Aprius Inc.", Devices: []Device{}},
	{ID: 0x1a5f, Name: "System TALKS Inc.", Devices: []Device{}},
	{ID: 0x1a68, Name: "VirtenSys Limited", Devices: []Device{}},
	{ID: 0x1a71, Name: "XenSource, Inc.", Devices: []Device{}},
	{
		ID: 0x1a73, Name: "Violin Memory, Inc", Devices: []Device{
			{ID: 0x0001, Name: "Mozart [Memory Appliance 1010]"},
		},
	},
	{ID: 0x1a76, Name: "Wavesat", Devices: []Device{}},
	{ID: 0x1a77, Name: "Lightfleet Corporation", Devices: []Device{}},
	{
		ID: 0x1a78, Name: "Virident Systems Inc.", Devices: []Device{
			{ID: 0x0031, Name: "FlashMAX Drive"},
			{ID: 0x0040, Name: "FlashMAX II"},
			{ID: 0x0041, Name: "FlashMAX II"},
			{ID: 0x0042, Name: "FlashMAX II"},
			{ID: 0x0050, Name: "FlashMAX III"},
		},
	},
	{
		ID: 0x1a84, Name: "Commex Technologies", Devices: []Device{
			{ID: 0x0001, Name: "Vulcan SP HT6210 10-Gigabit Ethernet (rev 02)"},
		},
	},
	{
		ID: 0x1a88, Name: "MEN Mikro Elektronik", Devices: []Device{
			{ID: 0x4d45, Name: "Multifunction IP core"},
		},
	},
	{ID: 0x1a8a, Name: "StarBridge, Inc.", Devices: []Device{}},
	{
		ID: 0x1a8c, Name: "Verigy Pte. Ltd.", Devices: []Device{
			{ID: 0x1100, Name: "E8001-66443 PCI Express CIC"},
		},
	},
	{
		ID: 0x1a8e, Name: "DRS Technologies", Devices: []Device{
			{ID: 0x2090, Name: "Model 2090 PCI Express"},
		},
	},
	{
		ID: 0x1aa8, Name: "Ciprico, Inc.", Devices: []Device{
			{ID: 0x0009, Name: "RAIDCore Controller"},
			{ID: 0x000a, Name: "RAIDCore Controller"},
		},
	},
	{ID: 0x1aae, Name: "Global Velocity, Inc.", Devices: []Device{}},
	{ID: 0x1ab4, Name: "Distributed Management Task Force, Inc. (DMTF)", Devices: []Device{}},
	{
		ID: 0x1ab6, Name: "CalDigit, Inc.", Devices: []Device{
			{ID: 0x6201, Name: "RAID Card"},
		},
	},
	{
		ID: 0x1ab8, Name: "Parallels, Inc.", Devices: []Device{
			{ID: 0x4000, Name: "Virtual Machine Communication Interface"},
			{ID: 0x4005, Name: "Accelerated Virtual Video Adapter"},
			{ID: 0x4006, Name: "Memory Ballooning Controller"},
		},
	},
	{ID: 0x1ab9, Name: "Espia Srl", Devices: []Device{}},
	{
		ID: 0x1ac1, Name: "Global Unichip Corp.", Devices: []Device{
			{ID: 0x089a, Name: "Coral Edge TPU"},
		},
	},
	{ID: 0x1ac8, Name: "Aeroflex Gaisler", Devices: []Device{}},
	{ID: 0x1acc, Name: "Point of View BV", Devices: []Device{}},
	{
		ID: 0x1ad7, Name: "Spectracom Corporation", Devices: []Device{
			{ID: 0x8000, Name: "TSync-PCIe Time Code Processor"},
			{ID: 0x9100, Name: "TPRO-PCI-66U Timecode Reader/Generator"},
		},
	},
	{
		ID: 0x1ade, Name: "Spin Master Ltd.", Devices: []Device{
			{ID: 0x1501, Name: "Swipetech barcode scanner"},
			{ID: 0x3038, Name: "PCIe Video Bridge"},
		},
	},
	{
		ID: 0x1ae0, Name: "Google, Inc.", Devices: []Device{
			{ID: 0x0042, Name: "Compute Engine Virtual Ethernet [gVNIC]"},
			{ID: 0xabcd, Name: "Airbrush Combined Paintbox IPU/Oscar Edge TPU [Pixel Neural Core]"},
		},
	},
	{ID: 0x1ae3, Name: "SANBlaze Technology, Inc.", Devices: []Device{}},
	{
		ID: 0x1ae7, Name: "First Wise Media GmbH", Devices: []Device{
			{ID: 0x0520, Name: "HFC-S PCI A [X-TENSIONS XC-520]"},
		},
	},
	{
		ID: 0x1ae8, Name: "Basler AG", Devices: []Device{
			{ID: 0x0751, Name: "mE5 marathon VCL"},
			{ID: 0x0752, Name: "mE5 marathon AF2"},
			{ID: 0x0753, Name: "mE5 marathon ACX QP"},
			{ID: 0x0754, Name: "mE5 marathon ACL"},
			{ID: 0x0755, Name: "mE5 marathon ACX SP"},
			{ID: 0x0756, Name: "mE5 marathon ACX DP"},
			{ID: 0x0757, Name: "mE5 marathon VCX QP"},
			{ID: 0x0758, Name: "mE5 marathon VF2"},
			{ID: 0x0759, Name: "mE5 marathon VCLx"},
			{ID: 0x0a40, Name: "microEnable IV AD1-CL"},
			{ID: 0x0a41, Name: "microEnable IV VD1-CL"},
			{ID: 0x0a42, Name: "microEnable IV AD4-CL"},
			{ID: 0x0a44, Name: "microEnable IV VD4-CL"},
			{ID: 0x0a45, Name: "microEnable IV AS1-CL"},
			{ID: 0x0a53, Name: "microEnable 5 AQ8-CXP6B"},
			{ID: 0x0a54, Name: "microEnable 5 VQ8-CXP6B"},
			{ID: 0x0a56, Name: "microEnable 5 VQ8-CXP6D"},
			{ID: 0x0a57, Name: "microEnable 5 AQ8-CXP6D"},
			{ID: 0x0a58, Name: "microEnable 5 VD8-CL"},
			{ID: 0x0a5a, Name: "microEnable 5 AD8-CL"},
			{ID: 0x0b52, Name: "mE5 Abacus 4G Base"},
			{ID: 0x0b53, Name: "mE5 Abacus 4G Base II"},
			{ID: 0x0b61, Name: "mE6 Abacus 4TG"},
			{ID: 0x0b63, Name: "CXP-12 Interface Card 1C"},
			{ID: 0x0b64, Name: "CXP-12 Interface Card 4C"},
			{ID: 0x0b65, Name: "CXP-12 Interface Card 2C"},
			{ID: 0x0b66, Name: "CXP-12 LightBridge 2C"},
			{ID: 0x0e42, Name: "microEnable IV AQ4-GE"},
			{ID: 0x0e44, Name: "microEnable IV VQ4-GE"},
		},
	},
	{
		ID: 0x1ae9, Name: "Wilocity Ltd.", Devices: []Device{
			{ID: 0x0101, Name: "Wil6200 PCI Express Upstream Port"},
			{ID: 0x0200, Name: "Wil6200 PCI Express Port"},
			{ID: 0x0201, Name: "Wil6200 Wireless PCI Express Port"},
			{ID: 0x0301, Name: "Wil6200 802.11ad Wireless Network Adapter"},
			{ID: 0x0302, Name: "Wil6200 802.11ad Wireless Network Adapter"},
			{ID: 0x0310, Name: "Wil6200 802.11ad Wireless Network Adapter"},
		},
	},
	{
		ID: 0x1aea, Name: "Alcor Micro", Devices: []Device{
			{ID: 0x6601, Name: "AU6601 PCI-E Flash card reader controller"},
			{ID: 0x6621, Name: "AU6621 PCI-E Flash card reader controller"},
			{ID: 0x6625, Name: "AU6625 PCI-E Flash card reader controller"},
		},
	},
	{ID: 0x1aec, Name: "Wolfson Microelectronics", Devices: []Device{}},
	{
		ID: 0x1aed, Name: "SanDisk", Devices: []Device{
			{ID: 0x1003, Name: "ioDimm3 (v1.2)"},
			{ID: 0x1005, Name: "ioDimm3"},
			{ID: 0x1006, Name: "ioXtreme"},
			{ID: 0x1007, Name: "ioXtreme Pro"},
			{ID: 0x1008, Name: "ioXtreme-2"},
			{ID: 0x2001, Name: "ioDrive2"},
			{ID: 0x3001, Name: "ioMemory FHHL"},
			{ID: 0x3002, Name: "ioMemory HHHL"},
			{ID: 0x3003, Name: "ioMemory Mezzanine"},
		},
	},
	{ID: 0x1aee, Name: "Caustic Graphics Inc.", Devices: []Device{}},
	{
		ID: 0x1af4, Name: "Red Hat, Inc.", Devices: []Device{
			{ID: 0x1000, Name: "Virtio network device"},
			{ID: 0x1001, Name: "Virtio block device"},
			{ID: 0x1002, Name: "Virtio memory balloon"},
			{ID: 0x1003, Name: "Virtio console"},
			{ID: 0x1004, Name: "Virtio SCSI"},
			{ID: 0x1005, Name: "Virtio RNG"},
			{ID: 0x1009, Name: "Virtio filesystem"},
			{ID: 0x1041, Name: "Virtio network device"},
			{ID: 0x1042, Name: "Virtio block device"},
			{ID: 0x1043, Name: "Virtio console"},
			{ID: 0x1044, Name: "Virtio RNG"},
			{ID: 0x1045, Name: "Virtio memory balloon"},
			{ID: 0x1048, Name: "Virtio SCSI"},
			{ID: 0x1049, Name: "Virtio filesystem"},
			{ID: 0x1050, Name: "Virtio GPU"},
			{ID: 0x1052, Name: "Virtio input"},
			{ID: 0x1053, Name: "Virtio socket"},
			{ID: 0x105a, Name: "Virtio file system"},
			{ID: 0x1110, Name: "Inter-VM shared memory"},
		},
	},
	{ID: 0x1af5, Name: "Netezza Corp.", Devices: []Device{}},
	{ID: 0x1afa, Name: "J & W Electronics Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1b03, Name: "Magnum Semiconductor, Inc,", Devices: []Device{
			{ID: 0x6100, Name: "DXT/DXTPro Multiformat Broadcast HD/SD Encoder/Decoder/Transcoder"},
			{ID: 0x7000, Name: "D7 Multiformat Broadcast HD/SD Encoder/Decoder/Transcoder"},
		},
	},
	{ID: 0x1b08, Name: "MSC Technologies GmbH", Devices: []Device{}},
	{ID: 0x1b0a, Name: "Pegatron", Devices: []Device{}},
	{ID: 0x1b13, Name: "Jaton Corp", Devices: []Device{}},
	{
		ID: 0x1b1a, Name: "K&F Computing Research Co.", Devices: []Device{
			{ID: 0x0e70, Name: "GRAPE"},
		},
	},
	{ID: 0x1b1c, Name: "Corsair", Devices: []Device{}},
	{
		ID: 0x1b21, Name: "ASMedia Technology Inc.", Devices: []Device{
			{ID: 0x0611, Name: "ASM1061 SATA IDE Controller"},
			{ID: 0x0612, Name: "ASM1062 Serial ATA Controller"},
			{ID: 0x1040, Name: "ASM1040 XHCI Controller"},
			{ID: 0x1042, Name: "ASM1042 SuperSpeed USB Host Controller"},
			{ID: 0x1080, Name: "ASM1083/1085 PCIe to PCI Bridge"},
			{ID: 0x1142, Name: "ASM1042A USB 3.0 Host Controller"},
			{ID: 0x1182, Name: "ASM1182e 2-Port PCIe x1 Gen2 Packet Switch"},
			{ID: 0x1184, Name: "ASM1184e 4-Port PCIe x1 Gen2 Packet Switch"},
			{ID: 0x1242, Name: "ASM1142 USB 3.1 Host Controller"},
			{ID: 0x1343, Name: "ASM1143 USB 3.1 Host Controller"},
			{ID: 0x2142, Name: "ASM2142 USB 3.1 Host Controller"},
			{ID: 0x2824, Name: "ASM2824 PCIe Gen3 Packet Switch"},
			{ID: 0x3242, Name: "ASM3242 USB 3.2 Host Controller"},
		},
	},
	{
		ID: 0x1b26, Name: "Netcope Technologies, a.s.", Devices: []Device{
			{ID: 0xc132, Name: "COMBO-LXT155"},
			{ID: 0xc1c0, Name: "NFB-100G1-e0"},
			{ID: 0xc1c1, Name: "NFB-100G1-e1"},
			{ID: 0xc250, Name: "NFB-200G2-master"},
			{ID: 0xc251, Name: "NFB-200G2-slave"},
			{ID: 0xc2c0, Name: "NFB-100G2-e0"},
			{ID: 0xc2c1, Name: "NFB-100G2-e1"},
			{ID: 0xcb20, Name: "COMBO-20G"},
			{ID: 0xcb40, Name: "COMBO-40G"},
			{ID: 0xcb80, Name: "NFB-40G2"},
		},
	},
	{ID: 0x1b2c, Name: "Opal-RT Technologies Inc.", Devices: []Device{}},
	{
		ID: 0x1b36, Name: "Red Hat, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "QEMU PCI-PCI bridge"},
			{ID: 0x0002, Name: "QEMU PCI 16550A Adapter"},
			{ID: 0x0003, Name: "QEMU PCI Dual-port 16550A Adapter"},
			{ID: 0x0004, Name: "QEMU PCI Quad-port 16550A Adapter"},
			{ID: 0x0005, Name: "QEMU PCI Test Device"},
			{ID: 0x0006, Name: "PCI Rocker Ethernet switch device"},
			{ID: 0x0007, Name: "PCI SD Card Host Controller Interface"},
			{ID: 0x0008, Name: "QEMU PCIe Host bridge"},
			{ID: 0x0009, Name: "QEMU PCI Expander bridge"},
			{ID: 0x000a, Name: "PCI-PCI bridge (multiseat)"},
			{ID: 0x000b, Name: "QEMU PCIe Expander bridge"},
			{ID: 0x000c, Name: "QEMU PCIe Root port"},
			{ID: 0x000d, Name: "QEMU XHCI Host Controller"},
			{ID: 0x0010, Name: "QEMU NVM Express Controller"},
			{ID: 0x0100, Name: "QXL paravirtual graphic card"},
		},
	},
	{
		ID: 0x1b37, Name: "Signal Processing Devices Sweden AB", Devices: []Device{
			{ID: 0x0001, Name: "ADQ214"},
			{ID: 0x0003, Name: "ADQ114"},
			{ID: 0x0005, Name: "ADQ112"},
			{ID: 0x000e, Name: "ADQ108"},
			{ID: 0x000f, Name: "ADQDSP"},
			{ID: 0x0014, Name: "ADQ412"},
			{ID: 0x0015, Name: "ADQ212"},
			{ID: 0x001b, Name: "SDR14"},
			{ID: 0x001c, Name: "ADQ1600"},
			{ID: 0x001e, Name: "ADQ208"},
			{ID: 0x001f, Name: "DSU"},
			{ID: 0x0020, Name: "ADQ14"},
			{ID: 0x0023, Name: "ADQ7"},
			{ID: 0x0026, Name: "ADQ8"},
			{ID: 0x2014, Name: "TX320"},
			{ID: 0x2019, Name: "S6000"},
		},
	},
	{
		ID: 0x1b39, Name: "sTec, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "S1120 PCIe Accelerator SSD"},
		},
	},
	{
		ID: 0x1b3a, Name: "Westar Display Technologies", Devices: []Device{
			{ID: 0x7589, Name: "HRED J2000 - JPEG 2000 Video Codec Device"},
		},
	},
	{
		ID: 0x1b3e, Name: "Teradata Corp.", Devices: []Device{
			{ID: 0x1fa8, Name: "BYNET BIC2SE/X"},
		},
	},
	{ID: 0x1b40, Name: "Schooner Information Technology, Inc.", Devices: []Device{}},
	{
		ID: 0x1b47, Name: "Numascale AS", Devices: []Device{
			{ID: 0x0601, Name: "NumaChip N601"},
			{ID: 0x0602, Name: "NumaChip N602"},
		},
	},
	{
		ID: 0x1b4b, Name: "Marvell Technology Group Ltd.", Devices: []Device{
			{ID: 0x0100, Name: "88F3700 [Armada 3700 Family] ARM SoC"},
			{ID: 0x0640, Name: "88SE9128 SATA III 6Gb/s RAID Controller"},
			{ID: 0x2241, Name: "88NR2241 Non-Volatile memory controller"},
			{ID: 0x9120, Name: "88SE9120 SATA 6Gb/s Controller"},
			{ID: 0x9123, Name: "88SE9123 PCIe SATA 6.0 Gb/s controller"},
			{ID: 0x9125, Name: "88SE9125 PCIe SATA 6.0 Gb/s controller"},
			{ID: 0x9128, Name: "88SE9128 PCIe SATA 6 Gb/s RAID controller"},
			{ID: 0x9130, Name: "88SE9128 PCIe SATA 6 Gb/s RAID controller with HyperDuo"},
			{ID: 0x9172, Name: "88SE9172 SATA 6Gb/s Controller"},
			{ID: 0x9178, Name: "88SE9170 PCIe SATA 6Gb/s Controller"},
			{ID: 0x917a, Name: "88SE9172 SATA III 6Gb/s RAID Controller"},
			{ID: 0x9182, Name: "88SE9182 PCIe 2.0 x2 2-port SATA 6 Gb/s Controller"},
			{ID: 0x9183, Name: "88SS9183 PCIe SSD Controller"},
			{ID: 0x9192, Name: "88SE9172 SATA III 6Gb/s RAID Controller"},
			{ID: 0x91a0, Name: "88SE912x SATA 6Gb/s Controller [IDE mode]"},
			{ID: 0x91a4, Name: "88SE912x IDE Controller"},
			{ID: 0x9215, Name: "88SE9215 PCIe 2.0 x1 4-port SATA 6 Gb/s Controller"},
			{ID: 0x9220, Name: "88SE9220 PCIe 2.0 x2 2-port SATA 6 Gb/s RAID Controller"},
			{ID: 0x9230, Name: "88SE9230 PCIe 2.0 x2 4-port SATA 6 Gb/s RAID Controller"},
			{ID: 0x9235, Name: "88SE9235 PCIe 2.0 x2 4-port SATA 6 Gb/s Controller"},
			{ID: 0x9445, Name: "88SE9445 PCIe 2.0 x4 4-Port SAS/SATA 6 Gbps RAID Controller"},
			{ID: 0x9480, Name: "88SE9480 SAS/SATA 6Gb/s RAID controller"},
			{ID: 0x9485, Name: "88SE9485 SAS/SATA 6Gb/s controller"},
		},
	},
	{ID: 0x1b4c, Name: "GALAX", Devices: []Device{}},
	{
		ID: 0x1b55, Name: "NetUP Inc.", Devices: []Device{
			{ID: 0x18f6, Name: "Dual DVB Universal CI card"},
			{ID: 0x18f7, Name: "Dual DVB Universal CI card rev 1.4"},
			{ID: 0x2a2c, Name: "Dual DVB-S2-CI card"},
			{ID: 0xe2e4, Name: "Dual DVB-T/C-CI RF card"},
			{ID: 0xe5f4, Name: "MPEG2 and H264 Encoder-Transcoder"},
			{ID: 0xf1c4, Name: "Dual ASI-RX/TX-CI card"},
		},
	},
	{
		ID: 0x1b66, Name: "DELTACAST", Devices: []Device{
			{ID: 0x0007, Name: "DELTA-3G-elp-d"},
		},
	},
	{
		ID: 0x1b6f, Name: "Etron Technology, Inc.", Devices: []Device{
			{ID: 0x7023, Name: "EJ168 USB 3.0 Host Controller"},
			{ID: 0x7052, Name: "EJ188/EJ198 USB 3.0 Host Controller"},
		},
	},
	{
		ID: 0x1b73, Name: "Fresco Logic", Devices: []Device{
			{ID: 0x1000, Name: "FL1000G USB 3.0 Host Controller"},
			{ID: 0x1009, Name: "FL1009 USB 3.0 Host Controller"},
			{ID: 0x1100, Name: "FL1100 USB 3.0 Host Controller"},
		},
	},
	{
		ID: 0x1b74, Name: "OpenVox Communication Co. Ltd.", Devices: []Device{
			{ID: 0x0115, Name: "D115P/D115E Single-port E1/T1 card"},
			{ID: 0xd130, Name: "D130P/D130E Single-port E1/T1 card (3rd GEN)"},
			{ID: 0xd210, Name: "D210P/D210E Dual-port E1/T1 card(2nd generation)"},
			{ID: 0xd230, Name: "D230 Dual-port E1/T1 card (2nd generation)"},
			{ID: 0xd410, Name: "D410/430 Quad-port E1/T1 card"},
			{ID: 0xd430, Name: "D410/430 Quad-port E1/T1 card"},
		},
	},
	{ID: 0x1b79, Name: "Absolute Analysis", Devices: []Device{}},
	{
		ID: 0x1b85, Name: "OCZ Technology Group, Inc.", Devices: []Device{
			{ID: 0x1041, Name: "RevoDrive 3 X2 PCI-Express SSD 240 GB (Marvell Controller)"},
			{ID: 0x6018, Name: "RD400/400A SSD"},
			{ID: 0x8788, Name: "RevoDrive Hybrid"},
		},
	},
	{
		ID: 0x1b94, Name: "Signatec / Dynamic Signals Corp", Devices: []Device{
			{ID: 0xe400, Name: "PX14400 Dual Xilinx Virtex5 based Digitizer"},
		},
	},
	{
		ID: 0x1b96, Name: "Western Digital", Devices: []Device{
			{ID: 0x2200, Name: "Ultrastar DC SN630 NVMe SSD"},
			{ID: 0x2201, Name: "Ultrastar DC SN630 NVMe SSD"},
			{ID: 0x2300, Name: "Ultrastar DC SN840 NVMe SSD"},
			{ID: 0x2400, Name: "Ultrastar DC SN640 NVMe SSD"},
			{ID: 0x2401, Name: "Ultrastar DC SN640 NVMe SSD"},
			{ID: 0x2402, Name: "Ultrastar DC SN640 NVMe SSD"},
			{ID: 0x2404, Name: "Ultrastar DC SN640 NVMe SSD"},
			{ID: 0x2500, Name: "Ultrastar DC SN840 NVMe SSD"},
			{ID: 0x2600, Name: "Ultrastar DC ZN540 ZNS NVMe SSD"},
			{ID: 0x3714, Name: "PC SN730 NVMe SSD"},
			{ID: 0x3734, Name: "PC SN730 NVMe SSD"},
		},
	},
	{ID: 0x1b9a, Name: "XAVi Technologies Corp.", Devices: []Device{}},
	{ID: 0x1baa, Name: "QNAP Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x1bad, Name: "ReFLEX CES", Devices: []Device{
			{ID: 0xc001, Name: "XpressGXA10-LP1150"},
			{ID: 0xc002, Name: "XpressGXA10-LP1151"},
		},
	},
	{
		ID: 0x1bb0, Name: "SimpliVity Corporation", Devices: []Device{
			{ID: 0x0002, Name: "OmniCube Accelerator OA-3000"},
			{ID: 0x0010, Name: "OmniCube Accelerator OA-3000-2"},
		},
	},
	{
		ID: 0x1bb1, Name: "Seagate Technology PLC", Devices: []Device{
			{ID: 0x005d, Name: "Nytro PCIe Flash Storage"},
			{ID: 0x0100, Name: "Nytro Flash Storage"},
			{ID: 0x5012, Name: "FireCuda 510 SSD"},
			{ID: 0x5016, Name: "FireCuda 520 SSD"},
		},
	},
	{
		ID: 0x1bb3, Name: "Bluecherry", Devices: []Device{
			{ID: 0x4304, Name: "BC-04120A MPEG4 4 port video encoder / decoder"},
			{ID: 0x4309, Name: "BC-08240A MPEG4 4 port video encoder / decoder"},
			{ID: 0x4310, Name: "BC-16480A MPEG4 16 port video encoder / decoder"},
			{ID: 0x4e04, Name: "BC-04120A 4 port MPEG4 video encoder / decoder"},
			{ID: 0x4e09, Name: "BC-08240A 8 port MPEG4 video encoder / decoder"},
			{ID: 0x4e10, Name: "BC-16480A 16 port MPEG4 video encoder / decoder"},
			{ID: 0x5304, Name: "BC-H04120A 4 port H.264 video and audio encoder / decoder"},
			{ID: 0x5308, Name: "BC-H08240A 8 port H.264 video and audio encoder / decoder"},
			{ID: 0x5310, Name: "BC-H16480A 16 port H.264 video and audio encoder / decoder"},
		},
	},
	{ID: 0x1bb5, Name: "Quantenna Communications, Inc.", Devices: []Device{}},
	{
		ID: 0x1bbf, Name: "Maxeler Technologies Ltd.", Devices: []Device{
			{ID: 0x0003, Name: "MAX3"},
			{ID: 0x0004, Name: "MAX4"},
		},
	},
	{
		ID: 0x1bc0, Name: "Innodisk Corporation", Devices: []Device{
			{ID: 0x1001, Name: "PCIe 3TG6-P Controller"},
			{ID: 0x1002, Name: "PCIe 3TE6 Controller"},
			{ID: 0x1160, Name: "PCIe 3TE2 Controller"},
			{ID: 0x1321, Name: "PCIe 4TG-P Controller"},
			{ID: 0x1322, Name: "PCIe 4TE Controller"},
			{ID: 0x2262, Name: "PCIe 3TG3-P Controller"},
			{ID: 0x5208, Name: "PCIe 3TE7 Controller"},
			{ID: 0x5216, Name: "PCIe 3TE8 Controller"},
			{ID: 0x5236, Name: "PCIe 4TG2-P Controller"},
		},
	},
	{
		ID: 0x1bcf, Name: "NEC Corporation", Devices: []Device{
			{ID: 0x001c, Name: "Vector Engine 1.0"},
		},
	},
	{
		ID: 0x1bd0, Name: "Astronics Corporation", Devices: []Device{
			{ID: 0x1001, Name: "Mx5 PMC/XMC Databus Interface Card"},
			{ID: 0x1002, Name: "PM1553-5 (PC/104+ MIL-STD-1553 Interface Card)"},
			{ID: 0x1004, Name: "AB3000 Series Rugged Computer"},
			{ID: 0x1005, Name: "PE1000 (Multi-Protocol PCIe/104 Interface Card)"},
			{ID: 0x1006, Name: "webCS Wireless Aircraft Communications Server"},
			{ID: 0x1007, Name: "AB3000 Series Rugged Computer (Series N)"},
			{ID: 0x1008, Name: "ME1000 mPCIe Avionics Interface Card"},
			{ID: 0x100a, Name: "NG1 Series Avionics Converter"},
			{ID: 0x1101, Name: "OmniBus II PCIe Multi-Protocol Interface Card"},
			{ID: 0x1102, Name: "OmniBusBox II Multi-Protocol Interface Core"},
			{ID: 0x1103, Name: "OmniBus II cPCIe/PXIe Multi-Protocol Interface Card"},
			{ID: 0x1200, Name: "NG3 Series Mil-Std-1553 Interface"},
			{ID: 0x1201, Name: "NG3 Series ARINC 429 Interface"},
			{ID: 0x1202, Name: "NG3 Series Avionics Discrete & Serial Interface"},
			{ID: 0x1203, Name: "NG3 Series Avionics Discrete Interface"},
		},
	},
	{
		ID: 0x1bd4, Name: "Inspur Electronic Information Industry Co., Ltd.", Devices: []Device{
			{ID: 0x0911, Name: "Arria10_PCIe_F10A1150"},
		},
	},
	{
		ID: 0x1bee, Name: "IXXAT Automation GmbH", Devices: []Device{
			{ID: 0x0003, Name: "CAN-IB200/PCIe"},
		},
	},
	{
		ID: 0x1bef, Name: "Lantiq", Devices: []Device{
			{ID: 0x0011, Name: "MIPS SoC PCI Express Port"},
		},
	},
	{
		ID: 0x1bf4, Name: "VTI Instruments Corporation", Devices: []Device{
			{ID: 0x0001, Name: "SentinelEX"},
			{ID: 0x7011, Name: "RX0xxx"},
		},
	},
	{ID: 0x1bfd, Name: "EeeTOP", Devices: []Device{}},
	{
		ID: 0x1c09, Name: "CSP, Inc.", Devices: []Device{
			{ID: 0x4254, Name: "10G-PCIE3-8D-2S"},
			{ID: 0x4255, Name: "10G-PCIE3-8D-Q"},
			{ID: 0x4256, Name: "10G-PCIE3-8D-2S"},
			{ID: 0x4258, Name: "10G-PCIE3-8E-2S Network Adapter"},
			{ID: 0x4260, Name: "10G-PCIE3-8E-4S Network Adapter"},
			{ID: 0x4261, Name: "10G-PCIE3-8E-4S Network Adapter"},
			{ID: 0x4262, Name: "10G-PCIE3-8E-4S Network Adapter"},
			{ID: 0x4263, Name: "10G-PCIE3-8E-4S Network Adapter"},
			{ID: 0x4264, Name: "10G-PCIE3-8E-2S Network Adapter"},
			{ID: 0x4265, Name: "10G-PCIE3-8E-2S Network Adapter"},
			{ID: 0x5000, Name: "25G-PCIE3-8A-2S Security Intelligent Adapter"},
			{ID: 0x5001, Name: "25G-PCIE3-8B-2S Security Intelligent Adapter"},
		},
	},
	{
		ID: 0x1c1c, Name: "Symphony", Devices: []Device{
			{ID: 0x0001, Name: "82C101"},
		},
	},
	{
		ID: 0x1c1f, Name: "SoftLab-NSK", Devices: []Device{
			{ID: 0x0015, Name: "FD842"},
			{ID: 0x0019, Name: "FD722"},
			{ID: 0x001a, Name: "FD788"},
			{ID: 0x001b, Name: "FD720"},
			{ID: 0x001c, Name: "FD922"},
			{ID: 0x001d, Name: "Vega"},
			{ID: 0x001f, Name: "FD940"},
		},
	},
	{
		ID: 0x1c28, Name: "Lite-On IT Corp. / Plextor", Devices: []Device{
			{ID: 0x0122, Name: "M6e PCI Express SSD [Marvell 88SS9183]"},
		},
	},
	{
		ID: 0x1c2c, Name: "Silicom Denmark", Devices: []Device{
			{ID: 0x000a, Name: "Capture"},
			{ID: 0x000f, Name: "SmartNIC"},
			{ID: 0x00a0, Name: "FBC4G Capture 4x1Gb [Herculaneum]"},
			{ID: 0x00a1, Name: "FBC4XG Capture 4x10Gb [Ancona]"},
			{ID: 0x00a2, Name: "FBC8XG Capture 8x10Gb [Livorno]"},
			{ID: 0x00a3, Name: "FBC2XG Capture 2x10Gb [Genoa]"},
			{ID: 0x00a4, Name: "FBC4XGG3 Capture 4x10Gb [Livigno]"},
			{ID: 0x00a5, Name: "FBC2XLG Capture 2x40Gb [Livorno]"},
			{ID: 0x00a6, Name: "FBC1CG Capture 1x100Gb"},
			{ID: 0x00a9, Name: "FBC2XGHH Capture 2x10Gb [Latina]"},
			{ID: 0x00ad, Name: "FBC2CGG3HL Capture 2x100Gb [Padua]"},
			{ID: 0x00af, Name: "Capture slave device"},
			{ID: 0x00e0, Name: "PacketMover 2x100Gb [Savona]"},
			{ID: 0x00e1, Name: "PacketMover 2x100Gb [Tivoli]"},
			{ID: 0x00e3, Name: "PacketMover 2x10Gb [Tivoli]"},
			{ID: 0x00e5, Name: "PacketMover 2x10Gb [Corfu]"},
			{ID: 0x1000, Name: "SmartNIC N5010 4x100Gb"},
			{ID: 0x1001, Name: "SmartNIC N5011 w/2xE810 4x100Gb"},
			{ID: 0xa000, Name: "FBC2CGG3 Capture 2x40Gb [Mango_02]"},
			{ID: 0xa001, Name: "FBC2CGG3 Capture 2x100Gb [Mango_02]"},
			{ID: 0xa003, Name: "FBC2CGG3 Capture 16x10Gb [Mango]"},
			{ID: 0xa007, Name: "FBC2CGG3 Capture 2x40Gb [Mango]"},
			{ID: 0xa008, Name: "FBC2CGG3 Capture 2x25Gb [Mango]"},
			{ID: 0xa009, Name: "FBC2CGG3 Capture 16x10Gb [Mango]"},
			{ID: 0xa00a, Name: "FBC2CGG3 Capture 8x10Gb [Mango]"},
			{ID: 0xa00e, Name: "FB2CG Capture 2x100Gb [Savona]"},
			{ID: 0xa00f, Name: "FB2CG Capture 2x40Gb [Savona]"},
			{ID: 0xa010, Name: "FB2CGHH Capture 2x40Gb [Tivoli]"},
			{ID: 0xa011, Name: "FB2CG Capture 2x25Gb [Savona]"},
			{ID: 0xa012, Name: "FB2CG Capture 8x10Gb [Savona]"},
			{ID: 0xa013, Name: "FB2CGHH Capture 2x25Gb [Tivoli]"},
			{ID: 0xa014, Name: "FB2CGHH Capture 8x10Gb [Tivoli]"},
			{ID: 0xa015, Name: "FB2CGHH Capture 2x100Gb [Tivoli]"},
		},
	},
	{ID: 0x1c32, Name: "Highland Technology, Inc.", Devices: []Device{}},
	{ID: 0x1c33, Name: "Daktronics, Inc", Devices: []Device{}},
	{
		ID: 0x1c36, Name: "Annapurna Labs Ltd.", Devices: []Device{
			{ID: 0x0001, Name: "Gigabit Ethernet Adapter"},
			{ID: 0x0002, Name: "SFP+ 10G Ethernet Adapter"},
		},
	},
	{
		ID: 0x1c3b, Name: "Accensus, LLC", Devices: []Device{
			{ID: 0x0200, Name: "Telas2"},
			{ID: 0x0300, Name: "Telas 2.V"},
		},
	},
	{
		ID: 0x1c44, Name: "Enmotus Inc", Devices: []Device{
			{ID: 0x8000, Name: "8000 Storage IO Controller"},
		},
	},
	{
		ID: 0x1c58, Name: "HGST, Inc.", Devices: []Device{
			{ID: 0x0003, Name: "Ultrastar SN100 Series NVMe SSD"},
			{ID: 0x0023, Name: "Ultrastar SN200 Series NVMe SSD"},
		},
	},
	{
		ID: 0x1c5c, Name: "SK hynix", Devices: []Device{
			{ID: 0x1283, Name: "PC300 NVMe Solid State Drive 256GB"},
			{ID: 0x1284, Name: "PC300 NVMe Solid State Drive 512GB"},
			{ID: 0x1285, Name: "PC300 NVMe Solid State Drive 1TB"},
			{ID: 0x1327, Name: "BC501 NVMe Solid State Drive"},
			{ID: 0x1339, Name: "BC511"},
			{ID: 0x1504, Name: "SC300 512GB M.2 2280 SATA Solid State Drive"},
			{ID: 0x1527, Name: "PC401 NVMe Solid State Drive 256GB"},
			{ID: 0x174a, Name: "Gold P31 SSD"},
			{ID: 0x243b, Name: "PE6110 NVMe Solid State Drive"},
			{ID: 0x2839, Name: "PE8000 Series NVMe Solid State Drive"},
		},
	},
	{
		ID: 0x1c5f, Name: "Beijing Memblaze Technology Co. Ltd.", Devices: []Device{
			{ID: 0x000d, Name: "PBlaze5 520/526"},
			{ID: 0x000e, Name: "PBlaze6 6530"},
			{ID: 0x003d, Name: "PBlaze5 920/926"},
			{ID: 0x003e, Name: "PBlaze6 6920"},
			{ID: 0x0540, Name: "PBlaze4 NVMe SSD"},
			{ID: 0x0550, Name: "PBlaze5 700/900"},
			{ID: 0x0555, Name: "PBlaze5 510/516"},
			{ID: 0x0557, Name: "PBlaze5 910/916"},
		},
	},
	{
		ID: 0x1c63, Name: "Science and Research Centre of Computer Technology (JSC \"NICEVT\")", Devices: []Device{
			{ID: 0x0008, Name: "K1927BB1Ya [EC8430] Angara Interconnection Network Adapter"},
		},
	},
	{
		ID: 0x1c7e, Name: "TTTech Computertechnik AG", Devices: []Device{
			{ID: 0x0200, Name: "zFAS Debug Port"},
		},
	},
	{
		ID: 0x1c7f, Name: "Elektrobit Austria GmbH", Devices: []Device{
			{ID: 0x5100, Name: "EB5100"},
		},
	},
	{
		ID: 0x1c8a, Name: "TSF5 Corporation", Devices: []Device{
			{ID: 0x0001, Name: "Hunter PCI Express"},
		},
	},
	{ID: 0x1c8c, Name: "Mobiveil, Inc.", Devices: []Device{}},
	{
		ID: 0x1cb0, Name: "Shannon Systems", Devices: []Device{
			{ID: 0x8266, Name: "SP4 Series SSD"},
			{ID: 0xd000, Name: "Venice NVMe SSD"},
		},
	},
	{ID: 0x1cb1, Name: "Collion UG & Co.KG", Devices: []Device{}},
	{
		ID: 0x1cb5, Name: "Focusrite Audio Engineering Ltd", Devices: []Device{
			{ID: 0x0002, Name: "Clarett"},
		},
	},
	{ID: 0x1cb8, Name: "Dawning Information Industry Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1cc1, Name: "ADATA Technology Co., Ltd.", Devices: []Device{
			{ID: 0x8201, Name: "XPG SX8200 Pro PCIe Gen3x4 M.2 2280 Solid State Drive"},
		},
	},
	{
		ID: 0x1cc4, Name: "Union Memory (Shenzhen)", Devices: []Device{
			{ID: 0x1203, Name: "NVMe SSD Controller UHXXXa series"},
			{ID: 0x17ab, Name: "NVMe 256G SSD device"},
			{ID: 0x6303, Name: "AM630 PCIe 4.0 x4 NVMe SSD Controller"},
		},
	},
	{
		ID: 0x1cc5, Name: "Embedded Intelligence, Inc.", Devices: []Device{
			{ID: 0x0100, Name: "CAN-PCIe-02"},
		},
	},
	{
		ID: 0x1cc7, Name: "Radian Memory Systems Inc.", Devices: []Device{
			{ID: 0x0200, Name: "RMS-200"},
			{ID: 0x0250, Name: "RMS-250"},
		},
	},
	{
		ID: 0x1ccf, Name: "Zoom Corporation", Devices: []Device{
			{ID: 0x0001, Name: "TAC-2 Thunderbolt Audio Converter"},
		},
	},
	{
		ID: 0x1cd2, Name: "SesKion GmbH", Devices: []Device{
			{ID: 0x0301, Name: "Simulyzer-RT CompactPCI Serial DIO-1 card"},
			{ID: 0x0302, Name: "Simulyzer-RT CompactPCI Serial PSI5-ECU-1 card"},
			{ID: 0x0303, Name: "Simulyzer-RT CompactPCI Serial PSI5-SIM-1 card"},
			{ID: 0x0304, Name: "Simulyzer-RT CompactPCI Serial PWR-ANA-1 card"},
			{ID: 0x0305, Name: "Simulyzer-RT CompactPCI Serial CAN-1 card"},
			{ID: 0x0306, Name: "Simulyzer-RT CompactPCI Serial CAN-2 card (CAN-FD)"},
			{ID: 0x0307, Name: "Simulyzer-RT CompactPCI Serial DIO-2 card [Xilinx Zynq UltraScale+]"},
		},
	},
	{
		ID: 0x1cd7, Name: "Nanjing Magewell Electronics Co., Ltd.", Devices: []Device{
			{ID: 0x0010, Name: "Pro Capture Endpoint"},
			{ID: 0x0014, Name: "PRO CAPTURE AIO 4K PLUS"},
			{ID: 0x0017, Name: "PRO CAPTURE AIO 4K"},
			{ID: 0x0051, Name: "Eco Capture Dual HDMI M.2"},
			{ID: 0x0052, Name: "Eco Capture HDMI 4K M.2"},
			{ID: 0x0053, Name: "Eco Capture Dual SDI M.2"},
			{ID: 0x0054, Name: "Eco Capture Quad SDI M.2"},
		},
	},
	{ID: 0x1cdd, Name: "secunet Security Networks AG", Devices: []Device{}},
	{
		ID: 0x1ce4, Name: "Exablaze", Devices: []Device{
			{ID: 0x0001, Name: "ExaNIC X4"},
			{ID: 0x0002, Name: "ExaNIC X2"},
			{ID: 0x0003, Name: "ExaNIC X10"},
			{ID: 0x0004, Name: "ExaNIC X10-GM"},
			{ID: 0x0005, Name: "ExaNIC X40"},
			{ID: 0x0006, Name: "ExaNIC X10-HPT"},
			{ID: 0x0007, Name: "ExaNIC X40"},
			{ID: 0x0008, Name: "ExaNIC V5P"},
			{ID: 0x0009, Name: "ExaNIC X25"},
			{ID: 0x000a, Name: "ExaNIC X100"},
			{ID: 0x000b, Name: "ExaNIC V9P"},
			{ID: 0x000c, Name: "ExaNIC V9P-3"},
			{ID: 0x0100, Name: "ExaDISK FX1"},
		},
	},
	{ID: 0x1cf0, Name: "Akitio", Devices: []Device{}},
	{ID: 0x1cf7, Name: "Subspace Dynamics", Devices: []Device{}},
	{ID: 0x1cfa, Name: "Corsair Memory, Inc", Devices: []Device{}},
	{ID: 0x1d00, Name: "Pure Storage", Devices: []Device{}},
	{ID: 0x1d05, Name: "Tongfang Hongkong Limited", Devices: []Device{}},
	{
		ID: 0x1d0f, Name: "Amazon.com, Inc.", Devices: []Device{
			{ID: 0x8061, Name: "NVMe EBS Controller"},
			{ID: 0xcd01, Name: "NVMe SSD Controller"},
			{ID: 0xec20, Name: "Elastic Network Adapter (ENA)"},
			{ID: 0xefa0, Name: "Elastic Fabric Adapter (EFA)"},
			{ID: 0xefa1, Name: "Elastic Fabric Adapter (EFA)"},
		},
	},
	{
		ID: 0x1d17, Name: "Zhaoxin", Devices: []Device{
			{ID: 0x070f, Name: "ZX-100 PCI Express Root Port"},
			{ID: 0x0710, Name: "ZX-100/ZX-200 PCI Express Root Port"},
			{ID: 0x0711, Name: "ZX-100/ZX-200 PCI Express Root Port"},
			{ID: 0x0712, Name: "ZX-100/ZX-200 PCI Express Root Port"},
			{ID: 0x0713, Name: "ZX-100/ZX-200 PCI Express Root Port"},
			{ID: 0x0714, Name: "ZX-100/ZX-200 PCI Express Root Port"},
			{ID: 0x0715, Name: "ZX-100/ZX-200 PCI Express Root Port"},
			{ID: 0x0716, Name: "ZX-D PCI Express Root Port"},
			{ID: 0x0717, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x0718, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x0719, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x071a, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x071b, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x071c, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x071d, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x071e, Name: "ZX-D/ZX-E PCI Express Root Port"},
			{ID: 0x071f, Name: "ZX-200 Upstream Port of PCI Express Switch"},
			{ID: 0x0720, Name: "ZX-200 PCIE RC6 controller"},
			{ID: 0x0721, Name: "ZX-200 Downstream Port of PCI Express Switch"},
			{ID: 0x0722, Name: "ZX-200 PCIE P2C bridge"},
			{ID: 0x1000, Name: "ZX-D Standard Host Bridge"},
			{ID: 0x1001, Name: "ZX-D/ZX-E Miscellaneous Bus"},
			{ID: 0x1003, Name: "ZX-E Standard Host Bridge"},
			{ID: 0x3001, Name: "ZX-100 Standard Host Bridge"},
			{ID: 0x300a, Name: "ZX-100 Miscellaneous Bus"},
			{ID: 0x3038, Name: "ZX-100/ZX-200/ZX-E Standard Universal PCI to USB Host Controller"},
			{ID: 0x3104, Name: "ZX-100/ZX-200/ZX-E Standard Enhanced PCI to USB Host Controller"},
			{ID: 0x31b0, Name: "ZX-100/ZX-D Standard Host Bridge"},
			{ID: 0x31b1, Name: "ZX-100/ZX-D Standard Host Bridge"},
			{ID: 0x31b2, Name: "ZX-100/ZX-D DRAM Controller"},
			{ID: 0x31b3, Name: "ZX-100/ZX-D Power Management Controller"},
			{ID: 0x31b4, Name: "ZX-100/ZX-D I/O APIC"},
			{ID: 0x31b5, Name: "ZX-100/ZX-D Scratch Device"},
			{ID: 0x31b7, Name: "ZX-100/ZX-D/ZX-E Standard Host Bridge"},
			{ID: 0x31b8, Name: "ZX-100/ZX-D PCI to PCI Bridge"},
			{ID: 0x3288, Name: "ZX-100/ZX-D/ZX-E High Definition Audio Controller"},
			{ID: 0x345b, Name: "ZX-100/ZX-D/ZX-E Miscellaneous Bus"},
			{ID: 0x3a02, Name: "ZX-100 C-320 GPU"},
			{ID: 0x3a03, Name: "ZX-D C-860 GPU"},
			{ID: 0x3a04, Name: "ZX-E C-960 GPU"},
			{ID: 0x9002, Name: "ZX-100/ZX-200 EIDE Controller"},
			{ID: 0x9003, Name: "ZX-100/ZX-E EIDE Controller"},
			{ID: 0x9045, Name: "ZX-100/ZX-D/ZX-E RAID Accelerator 0"},
			{ID: 0x9046, Name: "ZX-D/ZX-E RAID Accelerator 1"},
			{ID: 0x9083, Name: "ZX-100/ZX-200/ZX-E StorX AHCI Controller"},
			{ID: 0x9084, Name: "ZX-100 StorX AHCI Controller"},
			{ID: 0x9100, Name: "ZX-200 Cross bus"},
			{ID: 0x9101, Name: "ZX-200 Traffic Controller"},
			{ID: 0x9141, Name: "ZX-100 High Definition Audio Controller"},
			{ID: 0x9142, Name: "ZX-D High Definition Audio Controller"},
			{ID: 0x9144, Name: "ZX-E High Definition Audio Controller"},
			{ID: 0x9180, Name: "ZX-200 Networking Gigabit Ethernet Adapter"},
			{ID: 0x9202, Name: "ZX-100 USB eXtensible Host Controller"},
			{ID: 0x9203, Name: "ZX-200 USB eXtensible Host Controller"},
			{ID: 0x9204, Name: "ZX-E USB eXtensible Host Controller"},
			{ID: 0x9286, Name: "ZX-D eMMC Host Controller"},
			{ID: 0x9300, Name: "ZX-D/ZX-E eSPI Host Controller"},
			{ID: 0x95d0, Name: "ZX-100 Universal SD Host Controller"},
			{ID: 0xf410, Name: "ZX-100/ZX-D/ZX-E PCI Com Port"},
		},
	},
	{
		ID: 0x1d18, Name: "RME", Devices: []Device{
			{ID: 0x0001, Name: "Fireface UFX+"},
		},
	},
	{
		ID: 0x1d1c, Name: "Barefoot Networks, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Tofino 1"},
			{ID: 0x0010, Name: "Tofino 1"},
			{ID: 0x0100, Name: "Tofino 2"},
			{ID: 0x0110, Name: "Tofino 2"},
		},
	},
	{
		ID: 0x1d1d, Name: "CNEX Labs", Devices: []Device{
			{ID: 0x1f1f, Name: "QEMU NVM Express LightNVM Controller"},
			{ID: 0x2807, Name: "8800 series NVMe SSD"},
		},
	},
	{ID: 0x1d21, Name: "Allo", Devices: []Device{}},
	{
		ID: 0x1d22, Name: "Baidu Technology", Devices: []Device{
			{ID: 0x1380, Name: "Cloud Storage Device"},
			{ID: 0x3684, Name: "Kunlun AI Accelerator"},
			{ID: 0x3685, Name: "Kunlun2 AI Accelerator [VF]"},
		},
	},
	{
		ID: 0x1d26, Name: "Kalray Inc.", Devices: []Device{
			{ID: 0x0040, Name: "Turbocard2 Accelerator"},
			{ID: 0x0080, Name: "Open Network Interface Card 80G"},
			{ID: 0x00c0, Name: "Turbocard3 Accelerator"},
			{ID: 0x0140, Name: "Open Network Interface Card 40G"},
			{ID: 0xe004, Name: "AB01/EMB01 Development Board"},
		},
	},
	{
		ID: 0x1d37, Name: "NovaSparks", Devices: []Device{
			{ID: 0x0013, Name: "PM3"},
			{ID: 0x0014, Name: "PM4"},
			{ID: 0x0015, Name: "PM4edge"},
			{ID: 0x0016, Name: "PM4edge User Device"},
		},
	},
	{ID: 0x1d40, Name: "Techman Electronics (Changshu) Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1d44, Name: "DPT", Devices: []Device{
			{ID: 0xa400, Name: "PM2x24/PM3224"},
		},
	},
	{ID: 0x1d49, Name: "Lenovo", Devices: []Device{}},
	{ID: 0x1d4c, Name: "Diamanti, Inc.", Devices: []Device{}},
	{ID: 0x1d5c, Name: "Fantasia Trading LLC", Devices: []Device{}},
	{ID: 0x1d61, Name: "Technobox, Inc.", Devices: []Device{}},
	{ID: 0x1d62, Name: "Nebbiolo Technologies", Devices: []Device{}},
	{
		ID: 0x1d65, Name: "Imagine Communications Corp.", Devices: []Device{
			{ID: 0x04de, Name: "Taurus/McKinley"},
		},
	},
	{
		ID: 0x1d69, Name: "Celeno Communications", Devices: []Device{
			{ID: 0x2432, Name: "CL2432"},
			{ID: 0x2440, Name: "CL2440"},
		},
	},
	{
		ID: 0x1d6a, Name: "Aquantia Corp.", Devices: []Device{
			{ID: 0x0001, Name: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
			{ID: 0x00b1, Name: "AQC100 10G Ethernet MAC controller [AQtion]"},
			{ID: 0x07b1, Name: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
			{ID: 0x08b1, Name: "AQC108 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
			{ID: 0x11b1, Name: "AQC111 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
			{ID: 0x12b1, Name: "AQC112 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
			{ID: 0x87b1, Name: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
			{ID: 0xd107, Name: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
			{ID: 0xd108, Name: "AQC108 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]"},
		},
	},
	{
		ID: 0x1d6c, Name: "Atomic Rules LLC", Devices: []Device{
			{ID: 0x1001, Name: "A5PL-E1"},
			{ID: 0x1002, Name: "A5PL-E7"},
			{ID: 0x1003, Name: "S5PEDS-AB"},
			{ID: 0x1004, Name: "KC705-K325"},
			{ID: 0x1005, Name: "ZC706-Z045"},
			{ID: 0x1006, Name: "KCU105-KU040"},
			{ID: 0x1007, Name: "XUSP3S-VU095 [Jasper]"},
			{ID: 0x1008, Name: "XUSPL4-VU065 [Mustang UltraScale]"},
			{ID: 0x1009, Name: "XUSPL4-VU3P [Mustang UltraScale+]"},
			{ID: 0x100a, Name: "A10PL4-A10GX115"},
			{ID: 0x100b, Name: "K35-2SFP"},
			{ID: 0x100c, Name: "K35-4SFP"},
			{ID: 0x100d, Name: "AR-ARKA-FX0 [Arkville 32B DPDK Data Mover]"},
			{ID: 0x100e, Name: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover]"},
			{ID: 0x100f, Name: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover for Versal]"},
			{ID: 0x1010, Name: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover for Agilex]"},
			{ID: 0x1011, Name: "AR-MAN-U50 [Manitou Class Accelerator for U50]"},
			{ID: 0x1012, Name: "AR-MAN-U200 [Manitou Class Accelerator for U200]"},
			{ID: 0x1013, Name: "AR-MAN-U250 [Manitou Class Accelerator for U250]"},
			{ID: 0x1014, Name: "AR-MAN-U280 [Manitou Class Accelerator for U280]"},
			{ID: 0x1015, Name: "AR-ARK-BBDEV-FX0 [Arkville 32B DPDK Baseband Device]"},
			{ID: 0x1016, Name: "AR-ARK-BBDEV-FX1 [Arkville 64B DPDK Baseband Device]"},
			{ID: 0x1017, Name: "AR-ARK-FX1 [Arkville 64B Multi-Homed Primary Endpoint]"},
			{ID: 0x1018, Name: "AR-ARK-FX1 [Arkville 64B Multi-Homed Secondary Endpoint]"},
			{ID: 0x1019, Name: "AR-ARK-FX1 [Arkville 64B Multi-Homed Tertiary Endpoint]"},
			{ID: 0x101a, Name: "AR-ARK-SRIOV-FX0 [Arkville 32B Primary Physical Function]"},
			{ID: 0x101b, Name: "AR-ARK-SRIOV-FX1 [Arkville 64B Primary Physical Function]"},
			{ID: 0x101c, Name: "AR-ARK-SRIOV-VF [Arkville Virtual Function]"},
			{ID: 0x101d, Name: "AR-ARK-NIC [Arkville ArkNIC Kernel Path Device]"},
			{ID: 0x101e, Name: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover for Agilex R-Tile]"},
			{ID: 0x4200, Name: "A5PL-E1-10GETI [10 GbE Ethernet Traffic Instrument]"},
		},
	},
	{ID: 0x1d72, Name: "Xiaomi", Devices: []Device{}},
	{
		ID: 0x1d78, Name: "DERA Storage", Devices: []Device{
			{ID: 0x1512, Name: "TAI NVMe Controller"},
		},
	},
	{
		ID: 0x1d7c, Name: "Aerotech, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "HyperWire Adapter"},
		},
	},
	{
		ID: 0x1d82, Name: "NETINT Technologies Inc.", Devices: []Device{
			{ID: 0x0101, Name: "Codensity D400 SSD"},
			{ID: 0x0102, Name: "Codensity D408 PCIe Gen4 NVMe SSD"},
			{ID: 0x0202, Name: "Codensity T408 Video Encoding-Decoding Accelerator"},
		},
	},
	{
		ID: 0x1d87, Name: "Rockchip Electronics Co., Ltd", Devices: []Device{
			{ID: 0x0100, Name: "RK3399 PCI Express Root Port"},
			{ID: 0x1808, Name: "RK1808 Neural Network Processor Card"},
			{ID: 0x3566, Name: "RK3568 Remote Signal Processor"},
		},
	},
	{
		ID: 0x1d89, Name: "YEESTOR Microelectronics Co., Ltd", Devices: []Device{
			{ID: 0x0280, Name: "PCIe NVMe SSD"},
		},
	},
	{ID: 0x1d8f, Name: "Enyx", Devices: []Device{}},
	{ID: 0x1d92, Name: "Abaco Systems Inc.", Devices: []Device{}},
	{ID: 0x1d93, Name: "YADRO", Devices: []Device{}},
	{
		ID: 0x1d94, Name: "Chengdu Haiguang IC Design Co., Ltd.", Devices: []Device{
			{ID: 0x1450, Name: "Root Complex"},
			{ID: 0x1451, Name: "I/O Memory Management Unit"},
			{ID: 0x1452, Name: "PCIe Dummy Host Bridge"},
			{ID: 0x1453, Name: "PCIE GPP Bridge"},
			{ID: 0x1454, Name: "Internal PCIe GPP Bridge 0 to Bus B"},
			{ID: 0x1455, Name: "PCIe Dummy Function"},
			{ID: 0x1456, Name: "PSPCCP Command DMA Processor"},
			{ID: 0x1458, Name: "10 Gb Ethernet Controller Port 0/Port1"},
			{ID: 0x1459, Name: "10 Gb Ethernet Controller Port 2/Port3"},
			{ID: 0x145a, Name: "PCIe Dummy Function"},
			{ID: 0x145b, Name: "PCIE Non-Transparent Bridge"},
			{ID: 0x145c, Name: "USB3 XHCI"},
			{ID: 0x145d, Name: "Switch upstream in PCIe"},
			{ID: 0x145e, Name: "Switch downstream in PCIe"},
			{ID: 0x145f, Name: "USB 3.0 Host controller"},
			{ID: 0x1460, Name: "Data Fabric: Device 18h; Function 0"},
			{ID: 0x1461, Name: "Data Fabric: Device 18h; Function 1"},
			{ID: 0x1462, Name: "Data Fabric: Device 18h; Function 2"},
			{ID: 0x1463, Name: "Data Fabric: Device 18h; Function 3"},
			{ID: 0x1464, Name: "Data Fabric: Device 18h; Function 4"},
			{ID: 0x1465, Name: "Data Fabric: Device 18h; Function 5"},
			{ID: 0x1466, Name: "Data Fabric: Device 18h; Function 6"},
			{ID: 0x1467, Name: "Data Fabric: Device 18h; Function 7"},
			{ID: 0x1468, Name: "NTBCCP"},
			{ID: 0x7901, Name: "FCH SATA Controller [AHCI mode]"},
			{ID: 0x7904, Name: "FCH SATA Controller [AHCI mode]"},
			{ID: 0x7906, Name: "FCH SD Flash Controller"},
			{ID: 0x790b, Name: "FCH SMBus Controller"},
			{ID: 0x790e, Name: "FCH LPC Bridge"},
		},
	},
	{
		ID: 0x1d95, Name: "Graphcore Ltd", Devices: []Device{
			{ID: 0x0001, Name: "Colossus GC2 [C2]"},
			{ID: 0x0002, Name: "Colossus GC1 [S1]"},
		},
	},
	{
		ID: 0x1d97, Name: "Shenzhen Longsys Electronics Co., Ltd.", Devices: []Device{
			{ID: 0x2263, Name: "SM2263EN/SM2263XT-based OEM SSD"},
		},
	},
	{
		ID: 0x1d9b, Name: "Facebook, Inc.", Devices: []Device{
			{ID: 0x0010, Name: "Networking DOM Engine"},
			{ID: 0x0011, Name: "IO Bridge"},
		},
	},
	{ID: 0x1da1, Name: "Teko Telecom S.r.l.", Devices: []Device{}},
	{
		ID: 0x1da2, Name: "Sapphire Technology Limited", Devices: []Device{
			{ID: 0xe26a, Name: "Radeon R7 250"},
		},
	},
	{
		ID: 0x1da3, Name: "Habana Labs Ltd.", Devices: []Device{
			{ID: 0x0001, Name: "HL-1000 AI Inference Accelerator [Goya]"},
			{ID: 0x1000, Name: "HL-2000 AI Training Accelerator [Gaudi]"},
			{ID: 0x1010, Name: "HL-2000 AI Training Accelerator [Gaudi secured]"},
		},
	},
	{ID: 0x1dad, Name: "Fungible", Devices: []Device{}},
	{ID: 0x1db2, Name: "ATP ELECTRONICS INC", Devices: []Device{}},
	{
		ID: 0x1db7, Name: "Phytium Technology Co., Ltd.", Devices: []Device{
			{ID: 0xdc20, Name: "[X100 Series]"},
			{ID: 0xdc21, Name: "VPU Controller [X100 Series]"},
			{ID: 0xdc22, Name: "DC Controller [X100 Series]"},
			{ID: 0xdc23, Name: "I2S/DMA Controller [X100 Series]"},
			{ID: 0xdc26, Name: "SATA Controller [X100 Series]"},
			{ID: 0xdc27, Name: "USB Controller [X100 Series]"},
			{ID: 0xdc29, Name: "NANDFLASH Controller [X100 Series]"},
			{ID: 0xdc2b, Name: "I2S Controller [X100 Series]"},
			{ID: 0xdc2c, Name: "SPIM Controller [X100 Series]"},
			{ID: 0xdc2d, Name: "CAN Controller [X100 Series]"},
			{ID: 0xdc2e, Name: "UART Controller [X100 Series]"},
			{ID: 0xdc2f, Name: "PWM Controller [X100 Series]"},
			{ID: 0xdc30, Name: "MIO Controller [X100 Series]"},
			{ID: 0xdc31, Name: "GPIO Controller [X100 Series]"},
			{ID: 0xdc32, Name: "SMBUS Controller [X100 Series]"},
			{ID: 0xdc34, Name: "PS2 Controller [X100 Series]"},
			{ID: 0xdc35, Name: "LPC Controller [X100 Series]"},
			{ID: 0xdc36, Name: "LDMA Controller [X100 Series]"},
			{ID: 0xdc38, Name: "LSD_CFG Controller [X100 Series]"},
			{ID: 0xdc3a, Name: "SWITCH Controller [X100 Series]"},
			{ID: 0xdc3c, Name: "GPU_DMA Controller [X100 Series]"},
		},
	},
	{ID: 0x1dbb, Name: "NGD Systems, Inc.", Devices: []Device{}},
	{
		ID: 0x1dbf, Name: "Guizhou Huaxintong Semiconductor Technology Co., Ltd", Devices: []Device{
			{ID: 0x0401, Name: "StarDragon4800 PCI Express Root Port"},
		},
	},
	{ID: 0x1dc5, Name: "FADU Inc.", Devices: []Device{}},
	{ID: 0x1dcd, Name: "Liqid Inc.", Devices: []Device{}},
	{ID: 0x1dcf, Name: "Beijing Sinead Technology Co., Ltd.", Devices: []Device{}},
	{ID: 0x1dd3, Name: "Sage Microelectronics Corp.", Devices: []Device{}},
	{
		ID: 0x1dd8, Name: "Pensando Systems", Devices: []Device{
			{ID: 0x0002, Name: "DSC2 Elba Upstream Port"},
			{ID: 0x1000, Name: "DSC Capri Upstream Port"},
			{ID: 0x1001, Name: "DSC Virtual Downstream Port"},
			{ID: 0x1002, Name: "DSC Ethernet Controller"},
			{ID: 0x1003, Name: "DSC Ethernet Controller VF"},
			{ID: 0x1004, Name: "DSC Management Controller"},
			{ID: 0x1005, Name: "DSC NVMe Controller"},
			{ID: 0x1006, Name: "DSC NVMe Controller VF"},
			{ID: 0x1007, Name: "DSC Storage Accelerator"},
		},
	},
	{ID: 0x1ddd, Name: "Thorlabs", Devices: []Device{}},
	{
		ID: 0x1de0, Name: "Groq", Devices: []Device{
			{ID: 0x0000, Name: "TSP100 Tensor Streaming Processor"},
		},
	},
	{
		ID: 0x1de1, Name: "Tekram Technology Co.,Ltd.", Devices: []Device{
			{ID: 0x0391, Name: "TRM-S1040 [DC-315 / DC-395 series]"},
			{ID: 0x2020, Name: "DC-390 Series SCSI Adapter [AMD Am53C974]"},
			{ID: 0x690c, Name: "690c"},
			{ID: 0xdc29, Name: "DC290"},
		},
	},
	{
		ID: 0x1de5, Name: "Eideticom, Inc", Devices: []Device{
			{ID: 0x1000, Name: "IO Memory Controller"},
			{ID: 0x2000, Name: "NoLoad Hardware Development Kit"},
			{ID: 0x3000, Name: "eBPF-based PCIe Accelerator"},
		},
	},
	{
		ID: 0x1ded, Name: "Alibaba (China) Co., Ltd.", Devices: []Device{
			{ID: 0x107f, Name: "Elastic RDMA Adapter"},
			{ID: 0x5007, Name: "Elastic RDMA Adapter"},
			{ID: 0x8000, Name: "M1 Root Port"},
			{ID: 0x8001, Name: "ACC-RCiEP"},
			{ID: 0x8002, Name: "RCiEP VF"},
			{ID: 0x8003, Name: "RCEC PF"},
			{ID: 0x8004, Name: "RCEC VF"},
		},
	},
	{ID: 0x1dee, Name: "Biwin Storage Technology Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1def, Name: "Ampere Computing, LLC", Devices: []Device{
			{ID: 0xe005, Name: "eMAG PCI Express Root Port 0"},
			{ID: 0xe006, Name: "eMAG PCI Express Root Port 1"},
			{ID: 0xe007, Name: "eMAG PCI Express Root Port 2"},
			{ID: 0xe008, Name: "eMAG PCI Express Root Port 3"},
			{ID: 0xe009, Name: "eMAG PCI Express Root Port 4"},
			{ID: 0xe00a, Name: "eMAG PCI Express Root Port 5"},
			{ID: 0xe00b, Name: "eMAG PCI Express Root Port 6"},
			{ID: 0xe00c, Name: "eMAG PCI Express Root Port 7"},
			{ID: 0xe100, Name: "Altra PCI Express Root Complex A"},
			{ID: 0xe101, Name: "Altra PCI Express Root Port a0"},
			{ID: 0xe102, Name: "Altra PCI Express Root Port a1"},
			{ID: 0xe103, Name: "Altra PCI Express Root Port a2"},
			{ID: 0xe104, Name: "Altra PCI Express Root Port a3"},
			{ID: 0xe105, Name: "Altra PCI Express Root Port a4"},
			{ID: 0xe106, Name: "Altra PCI Express Root Port a5"},
			{ID: 0xe107, Name: "Altra PCI Express Root Port a6"},
			{ID: 0xe108, Name: "Altra PCI Express Root Port a7"},
			{ID: 0xe110, Name: "Altra PCI Express Root Complex B"},
			{ID: 0xe111, Name: "Altra PCI Express Root Port b0"},
			{ID: 0xe112, Name: "Altra PCI Express Root Port b1"},
			{ID: 0xe113, Name: "Altra PCI Express Root Port b2"},
			{ID: 0xe114, Name: "Altra PCI Express Root Port b3"},
			{ID: 0xe115, Name: "Altra PCI Express Root Port b4"},
			{ID: 0xe116, Name: "Altra PCI Express Root Port b5"},
			{ID: 0xe117, Name: "Altra PCI Express Root Port b6"},
			{ID: 0xe118, Name: "Altra PCI Express Root Port b7"},
		},
	},
	{
		ID: 0x1df3, Name: "Ethernity Networks", Devices: []Device{
			{ID: 0x0201, Name: "ACE-NIC40 Programmable Network Accelerator"},
			{ID: 0x0202, Name: "ACE-NIC50 Programmable Network Accelerator"},
			{ID: 0x0203, Name: "ACE-NIC100 Programmable Network Accelerator"},
			{ID: 0x0204, Name: "ACE-NIC-NID Programmable Network Accelerator"},
			{ID: 0x0205, Name: "ACE-NIC250 Programmable Network Accelerator"},
			{ID: 0x0206, Name: "ACE-NIC200 Programmable Network Accelerator"},
			{ID: 0x0207, Name: "ACE-NIC50RN Programmable Network Accelerator"},
			{ID: 0x0208, Name: "ACE-NIC100RN Programmable Network Accelerator"},
		},
	},
	{
		ID: 0x1df7, Name: "opencpi.org", Devices: []Device{
			{ID: 0x0001, Name: "ml605"},
			{ID: 0x0002, Name: "alst4"},
			{ID: 0x0003, Name: "alst4x"},
		},
	},
	{
		ID: 0x1dfc, Name: "JSC NT-COM", Devices: []Device{
			{ID: 0x1181, Name: "TDM 8 Port E1/T1/J1 Adapter"},
		},
	},
	{
		ID: 0x1e0f, Name: "KIOXIA Corporation", Devices: []Device{
			{ID: 0x0007, Name: "NVMe SSD Controller Cx6"},
			{ID: 0x0009, Name: "NVMe SSD"},
		},
	},
	{ID: 0x1e17, Name: "Arnold & Richter Cine Technik GmbH & Co. Betriebs KG", Devices: []Device{}},
	{
		ID: 0x1e24, Name: "Squirrels Research Labs", Devices: []Device{
			{ID: 0x0101, Name: "Acorn CLE-101"},
			{ID: 0x0215, Name: "Acorn CLE-215"},
			{ID: 0x021f, Name: "Acorn CLE-215+"},
			{ID: 0x1525, Name: "Xilinx BCU-1525"},
			{ID: 0x1533, Name: "ForestKitten 33"},
			{ID: 0x1633, Name: "JCM33"},
			{ID: 0x1635, Name: "JCM35"},
		},
	},
	{ID: 0x1e26, Name: "Fujitsu Client Computing Limited", Devices: []Device{}},
	{
		ID: 0x1e36, Name: "Shanghai Enflame Technology Co. Ltd", Devices: []Device{
			{ID: 0x0001, Name: "T10 [CloudBlazer]"},
			{ID: 0x0002, Name: "T11 [CloudBlazer]"},
			{ID: 0x0003, Name: "T10(QSFP-DD) [CloudBlazer]"},
			{ID: 0x0021, Name: "T20(32GB) [CloudBlazer]"},
			{ID: 0x0022, Name: "T20(64GB) [CloudBlazer]"},
			{ID: 0x0023, Name: "T21(32GB) [CloudBlazer]"},
			{ID: 0x0024, Name: "T21(64GB) [CloudBlazer]"},
			{ID: 0x8001, Name: "I20 [CloudBlazer]"},
			{ID: 0x8011, Name: "I10 [CloudBlazer]"},
			{ID: 0x8012, Name: "I10L [CloudBlazer]"},
		},
	},
	{
		ID: 0x1e38, Name: "Blaize, Inc", Devices: []Device{
			{ID: 0x0102, Name: "Xplorer X1600"},
		},
	},
	{ID: 0x1e39, Name: "MEDION AG", Devices: []Device{}},
	{
		ID: 0x1e3b, Name: "Shenzhen DAPU Microelectronics Co., Ltd", Devices: []Device{
			{ID: 0x0600, Name: "NVMe SSD Controller DPU600"},
			{ID: 0x1098, Name: "Haishen NVMe SSD"},
		},
	},
	{ID: 0x1e3d, Name: "Burlywood, Inc", Devices: []Device{}},
	{
		ID: 0x1e49, Name: "Yangtze Memory Technologies Co.,Ltd", Devices: []Device{
			{ID: 0x0041, Name: "ZHITAI TiPro7000"},
			{ID: 0x1013, Name: "PC210"},
		},
	},
	{
		ID: 0x1e4b, Name: "MAXIO Technology (Hangzhou) Ltd.", Devices: []Device{
			{ID: 0x1001, Name: "NVMe SSD Controller MAP1001"},
			{ID: 0x1002, Name: "NVMe SSD Controller MAP1002"},
			{ID: 0x1003, Name: "NVMe SSD Controller MAP1003"},
			{ID: 0x1201, Name: "NVMe SSD Controller MAP1201"},
			{ID: 0x1202, Name: "NVMe SSD Controller MAP1202"},
			{ID: 0x1601, Name: "NVMe SSD Controller MAP1601"},
		},
	},
	{
		ID: 0x1e4c, Name: "GSI Technology", Devices: []Device{
			{ID: 0x0010, Name: "APU [Leda]"},
		},
	},
	{
		ID: 0x1e57, Name: "Beijing Panyi Technology Co., Ltd", Devices: []Device{
			{ID: 0x0100, Name: "The device has already been deleted."},
		},
	},
	{
		ID: 0x1e59, Name: "Oxford Nanopore Technologies", Devices: []Device{
			{ID: 0x0001, Name: "MinION Mk1C"},
		},
	},
	{
		ID: 0x1e60, Name: "Hailo Technologies Ltd.", Devices: []Device{
			{ID: 0x2864, Name: "Hailo-8 AI Processor"},
		},
	},
	{ID: 0x1e68, Name: "Jiangsu Xinsheng Intelligent Technology Co., Ltd", Devices: []Device{}},
	{ID: 0x1e6b, Name: "Axiado Corp.", Devices: []Device{}},
	{ID: 0x1e7b, Name: "Dataland", Devices: []Device{}},
	{
		ID: 0x1e7c, Name: "Brainchip Inc", Devices: []Device{
			{ID: 0xbca1, Name: "AKD1000 Neural Network Coprocessor [Akida]"},
		},
	},
	{
		ID: 0x1e81, Name: "Ramaxel Technology(Shenzhen) Limited", Devices: []Device{
			{ID: 0x1203, Name: "NVMe SSD Controller UHXXXa series"},
		},
	},
	{ID: 0x1e85, Name: "Heitec AG", Devices: []Device{}},
	{
		ID: 0x1e89, Name: "ID Quantique SA", Devices: []Device{
			{ID: 0x0002, Name: "Quantis-PCIe-40M"},
			{ID: 0x0003, Name: "Quantis-PCIe-240M"},
		},
	},
	{ID: 0x1e94, Name: "Calian SED", Devices: []Device{}},
	{
		ID: 0x1e95, Name: "Solid State Storage Technology Corporation", Devices: []Device{
			{ID: 0x1002, Name: "NVMe Datacenter LJ1 SSD [3DNAND, Rainier Controller]"},
		},
	},
	{ID: 0x1e9f, Name: "Lynxi Technologies Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x1ea0, Name: "Tencent Technology (Shenzhen) Company Limited", Devices: []Device{
			{ID: 0x2a16, Name: "Cloud Intelligent Inference Controller"},
			{ID: 0x2a18, Name: "Video Transcode Controller"},
		},
	},
	{
		ID: 0x1ea7, Name: "Intelliprop, Inc", Devices: []Device{
			{ID: 0x223a, Name: "Typhon+ PCIe to Gen-Z Bridge"},
			{ID: 0x224a, Name: "IPA-PE224A CXL to Gen-Z Bridge [Sphinx]"},
		},
	},
	{
		ID: 0x1eab, Name: "Hefei DATANG Storage Technology Co.,LTD.", Devices: []Device{
			{ID: 0x300a, Name: "NVMe SSD Controller 300A"},
			{ID: 0x300b, Name: "NVMe SSD Controller 300B"},
		},
	},
	{
		ID: 0x1eac, Name: "Quectel Wireless Solutions Co., Ltd.", Devices: []Device{
			{ID: 0x1001, Name: "EM120R-GL LTE Modem"},
			{ID: 0x1002, Name: "EM160R-GL LTE Modem"},
		},
	},
	{ID: 0x1eae, Name: "XFX Limited", Devices: []Device{}},
	{
		ID: 0x1eb1, Name: "VeriSilicon Inc", Devices: []Device{
			{ID: 0x1001, Name: "Video Accelerator"},
		},
	},
	{
		ID: 0x1ebd, Name: "EMERGETECH Company Ltd.", Devices: []Device{
			{ID: 0x0101, Name: "Seirios 2063 Video Codec"},
		},
	},
	{
		ID: 0x1ed2, Name: "FuriosaAI, Inc.", Devices: []Device{
			{ID: 0x0000, Name: "Warboy"},
		},
	},
	{ID: 0x1ed3, Name: "Yeston", Devices: []Device{}},
	{
		ID: 0x1ed5, Name: "Moore Threads Technology Co.,Ltd", Devices: []Device{
			{ID: 0x0101, Name: "MTT S30"},
		},
	},
	{
		ID: 0x1ed8, Name: "Digiteq Automotive", Devices: []Device{
			{ID: 0x0101, Name: "FG4 PCIe Frame Grabber"},
		},
	},
	{ID: 0x1ed9, Name: "Myrtle.ai", Devices: []Device{}},
	{ID: 0x1ee9, Name: "SUSE LLC", Devices: []Device{}},
	{
		ID: 0x1eec, Name: "Viscore Technologies Ltd", Devices: []Device{
			{ID: 0x0102, Name: "VSE250231S Dual-port 10Gb/25Gb Ethernet PCIe"},
			{ID: 0x1eec, Name: "VSE250231S Dual-port 10Gb/25Gb Ethernet PCIe"},
		},
	},
	{ID: 0x1efb, Name: "Flexxon Pte Ltd", Devices: []Device{}},
	{ID: 0x1f02, Name: "Beijing Dayu Technology", Devices: []Device{}},
	{
		ID: 0x1f03, Name: "Shenzhen Shichuangyi Electronics Co., Ltd", Devices: []Device{
			{ID: 0x1202, Name: "MAP1202-Based NVMe SSD"},
			{ID: 0x2262, Name: "SM2262EN-based OEM SSD"},
			{ID: 0x2263, Name: "SM2263XT-Base NVMe SSD"},
			{ID: 0x5216, Name: "IG5216-based NVMe SSD"},
			{ID: 0x5220, Name: "IG5220-Based NVMe SSD"},
			{ID: 0x5236, Name: "IG5236-Based NVMe SSD"},
			{ID: 0x5636, Name: "IG5636-Based NVMe SSD"},
		},
	},
	{
		ID: 0x1fab, Name: "Unifabrix Ltd.", Devices: []Device{
			{ID: 0x0000, Name: "Nexus Alpha IVPU"},
		},
	},
	{
		ID: 0x1fc0, Name: "Ascom (Finland) Oy", Devices: []Device{
			{ID: 0x0300, Name: "E2200 Dual E1/Rawpipe Card"},
			{ID: 0x0301, Name: "C5400 SHDSL/E1 Card"},
		},
	},
	{
		ID: 0x1fc1, Name: "QLogic, Corp.", Devices: []Device{
			{ID: 0x000d, Name: "IBA6110 InfiniBand HCA"},
			{ID: 0x0010, Name: "IBA6120 InfiniBand HCA"},
		},
	},
	{
		ID: 0x1fc9, Name: "Tehuti Networks Ltd.", Devices: []Device{
			{ID: 0x3009, Name: "10-Giga TOE SmartNIC"},
			{ID: 0x3010, Name: "10-Giga TOE SmartNIC"},
			{ID: 0x3014, Name: "10-Giga TOE SmartNIC 2-Port"},
			{ID: 0x3110, Name: "10-Giga TOE Single Port SmartNIC"},
			{ID: 0x3114, Name: "10-Giga TOE Dual Port Low Profile SmartNIC"},
			{ID: 0x3310, Name: "10-Giga TOE SFP+ Single Port SmartNIC"},
			{ID: 0x3314, Name: "10-Giga TOE Dual Port Low Profile SmartNIC"},
			{ID: 0x4010, Name: "TN4010 Clean SROM"},
			{ID: 0x4020, Name: "TN9030 10GbE CX4 Ethernet Adapter"},
			{ID: 0x4022, Name: "TN9310 10GbE SFP+ Ethernet Adapter"},
			{ID: 0x4024, Name: "TN9210 10GBase-T Ethernet Adapter"},
			{ID: 0x4025, Name: "TN9510 10GBase-T/NBASE-T Ethernet Adapter"},
			{ID: 0x4026, Name: "TN9610 10GbE SFP+ Ethernet Adapter"},
			{ID: 0x4027, Name: "TN9710P 10GBase-T/NBASE-T Ethernet Adapter"},
			{ID: 0x4527, Name: "TN9710Q 5GBase-T/NBASE-T Ethernet Adapter"},
		},
	},
	{
		ID: 0x1fcc, Name: "StreamLabs", Devices: []Device{
			{ID: 0xf416, Name: "MS416"},
			{ID: 0xfb01, Name: "MH4LM"},
		},
	},
	{
		ID: 0x1fce, Name: "Cognio Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Spectrum Analyzer PC Card (SAgE)"},
		},
	},
	{
		ID: 0x1fd4, Name: "SUNIX Co., Ltd.", Devices: []Device{
			{ID: 0x0001, Name: "Matrix multiport serial adapter"},
			{ID: 0x1999, Name: "Multiport serial controller"},
		},
	},
	{
		ID: 0x2000, Name: "Smart Link Ltd.", Devices: []Device{
			{ID: 0x2800, Name: "SmartPCI2800 V.92 PCI Soft DFT"},
		},
	},
	{ID: 0x2001, Name: "Temporal Research Ltd", Devices: []Device{}},
	{
		ID: 0x2003, Name: "Smart Link Ltd.", Devices: []Device{
			{ID: 0x8800, Name: "LM-I56N"},
		},
	},
	{ID: 0x2004, Name: "Smart Link Ltd.", Devices: []Device{}},
	{ID: 0x2048, Name: "Beijing SpaceControl Technology Co.Ltd", Devices: []Device{}},
	{ID: 0x20f4, Name: "TRENDnet", Devices: []Device{}},
	{ID: 0x2116, Name: "ZyDAS Technology Corp.", Devices: []Device{}},
	{ID: 0x21b4, Name: "Hunan Goke Microelectronics Co., Ltd", Devices: []Device{}},
	{ID: 0x21c3, Name: "21st Century Computer Corp.", Devices: []Device{}},
	{
		ID: 0x22b8, Name: "Flex-Logix Technologies", Devices: []Device{
			{ID: 0x22a0, Name: "Flex Logix InferX X1 Inference Accelerator"},
		},
	},
	{ID: 0x22db, Name: "Missing Link Electronics, Inc.", Devices: []Device{}},
	{ID: 0x2304, Name: "Colorgraphic Communications Corp.", Devices: []Device{}},
	{
		ID: 0x2348, Name: "Racore", Devices: []Device{
			{ID: 0x2010, Name: "8142 100VG/AnyLAN"},
		},
	},
	{
		ID: 0x2646, Name: "Kingston Technology Company, Inc.", Devices: []Device{
			{ID: 0x0010, Name: "HyperX Predator PCIe AHCI SSD"},
			{ID: 0x2262, Name: "KC2000 NVMe SSD"},
			{ID: 0x2263, Name: "A2000 NVMe SSD"},
			{ID: 0x5008, Name: "U-SNS8154P3 NVMe SSD"},
			{ID: 0x500d, Name: "OM3PDP3 NVMe SSD"},
			{ID: 0x500e, Name: "SNVS2000G [NV1 NVMe PCIe SSD 2TB]"},
		},
	},
	{ID: 0x270b, Name: "Xantel Corporation", Devices: []Device{}},
	{ID: 0x270f, Name: "Chaintech Computer Co. Ltd", Devices: []Device{}},
	{ID: 0x2711, Name: "AVID Technology Inc.", Devices: []Device{}},
	{
		ID: 0x2955, Name: "Connectix Virtual PC", Devices: []Device{
			{ID: 0x6e61, Name: "OHCI USB 1.1 controller"},
		},
	},
	{ID: 0x2a15, Name: "3D Vision(???)", Devices: []Device{}},
	{ID: 0x2a18, Name: "Video Transcode Controller", Devices: []Device{}},
	{ID: 0x2bd8, Name: "ROPEX Industrie-Elektronik GmbH", Devices: []Device{}},
	{ID: 0x3000, Name: "Hansol Electronics Inc.", Devices: []Device{}},
	{ID: 0x3112, Name: "Satelco Ingenieria S.A.", Devices: []Device{}},
	{ID: 0x3130, Name: "AUDIOTRAK", Devices: []Device{}},
	{ID: 0x3142, Name: "Post Impression Systems.", Devices: []Device{}},
	{
		ID: 0x31ab, Name: "Zonet", Devices: []Device{
			{ID: 0x1faa, Name: "ZEW1602 802.11b/g Wireless Adapter"},
		},
	},
	{
		ID: 0x3388, Name: "Hint Corp", Devices: []Device{
			{ID: 0x0013, Name: "HiNT HC4 PCI to ISDN bridge, Multimedia audio controller"},
			{ID: 0x0014, Name: "HiNT HC4 PCI to ISDN bridge, Network controller"},
			{ID: 0x0020, Name: "HB6 Universal PCI-PCI bridge (transparent mode)"},
			{ID: 0x0021, Name: "HB6 Universal PCI-PCI bridge (non-transparent mode)"},
			{ID: 0x0022, Name: "HiNT HB4 PCI-PCI Bridge (PCI6150)"},
			{ID: 0x0026, Name: "HB2 PCI-PCI Bridge"},
			{ID: 0x1014, Name: "AudioTrak Maya"},
			{ID: 0x1018, Name: "Audiotrak INCA88"},
			{ID: 0x1019, Name: "Miditrak 2120"},
			{ID: 0x101a, Name: "E.Band [AudioTrak Inca88]"},
			{ID: 0x101b, Name: "E.Band [AudioTrak Inca88]"},
			{ID: 0x8011, Name: "VXPro II Chipset"},
			{ID: 0x8012, Name: "VXPro II Chipset"},
			{ID: 0x8013, Name: "VXPro II IDE"},
			{ID: 0xa103, Name: "Blackmagic Design DeckLink HD Pro"},
		},
	},
	{ID: 0x3411, Name: "Quantum Designs (H.K.) Inc", Devices: []Device{}},
	{
		ID: 0x3442, Name: "Bihl+Wiedemann GmbH", Devices: []Device{
			{ID: 0x1783, Name: "AS-i 3.0 cPCI Master"},
			{ID: 0x1922, Name: "AS-i 3.0 PCI Master"},
		},
	},
	{ID: 0x3475, Name: "Arista Networks, Inc.", Devices: []Device{}},
	{ID: 0x34ba, Name: "Ice Lake-LP PCI Express Root Port #3", Devices: []Device{}},
	{ID: 0x3513, Name: "ARCOM Control Systems Ltd", Devices: []Device{}},
	{
		ID: 0x37d9, Name: "ITD Firm ltd.", Devices: []Device{
			{ID: 0x1138, Name: "SCHD-PH-8 Phase detector"},
			{ID: 0x1140, Name: "VR-12-PCI"},
			{ID: 0x1141, Name: "PCI-485(422)"},
			{ID: 0x1142, Name: "PCI-CAN2"},
		},
	},
	{ID: 0x3842, Name: "eVga.com. Corp.", Devices: []Device{}},
	{ID: 0x38ef, Name: "4Links", Devices: []Device{}},
	{
		ID: 0x3d3d, Name: "3DLabs", Devices: []Device{
			{ID: 0x0001, Name: "GLINT 300SX"},
			{ID: 0x0002, Name: "GLINT 500TX"},
			{ID: 0x0003, Name: "GLINT Delta"},
			{ID: 0x0004, Name: "Permedia"},
			{ID: 0x0005, Name: "Permedia"},
			{ID: 0x0006, Name: "GLINT MX"},
			{ID: 0x0007, Name: "3D Extreme"},
			{ID: 0x0008, Name: "GLINT Gamma G1"},
			{ID: 0x0009, Name: "Permedia II 2D+3D"},
			{ID: 0x000a, Name: "GLINT R3"},
			{ID: 0x000c, Name: "GLINT R3 [Oxygen VX1]"},
			{ID: 0x000d, Name: "GLint R4 rev A"},
			{ID: 0x000e, Name: "GLINT Gamma G2"},
			{ID: 0x0011, Name: "GLint R4 rev B"},
			{ID: 0x0012, Name: "GLint R5 rev A"},
			{ID: 0x0013, Name: "GLint R5 rev B"},
			{ID: 0x0020, Name: "VP10 visual processor"},
			{ID: 0x0022, Name: "VP10 visual processor"},
			{ID: 0x0024, Name: "VP9 visual processor"},
			{ID: 0x002c, Name: "Wildcat Realizm 100/200"},
			{ID: 0x0030, Name: "Wildcat Realizm 800"},
			{ID: 0x0032, Name: "Wildcat Realizm 500"},
			{ID: 0x0100, Name: "Permedia II 2D+3D"},
			{ID: 0x07a1, Name: "Wildcat III 6210"},
			{ID: 0x07a2, Name: "Sun XVR-500 Graphics Accelerator"},
			{ID: 0x07a3, Name: "Wildcat IV 7210"},
			{ID: 0x1004, Name: "Permedia"},
			{ID: 0x3d04, Name: "Permedia"},
			{ID: 0xffff, Name: "Glint VGA"},
		},
	},
	{
		ID: 0x4005, Name: "Avance Logic Inc.", Devices: []Device{
			{ID: 0x0300, Name: "ALS300 PCI Audio Device"},
			{ID: 0x0308, Name: "ALS300+ PCI Audio Device"},
			{ID: 0x0309, Name: "PCI Input Controller"},
			{ID: 0x1064, Name: "ALG-2064"},
			{ID: 0x2064, Name: "ALG-2064i"},
			{ID: 0x2128, Name: "ALG-2364A GUI Accelerator"},
			{ID: 0x2301, Name: "ALG-2301"},
			{ID: 0x2302, Name: "ALG-2302"},
			{ID: 0x2303, Name: "AVG-2302 GUI Accelerator"},
			{ID: 0x2364, Name: "ALG-2364A"},
			{ID: 0x2464, Name: "ALG-2464"},
			{ID: 0x2501, Name: "ALG-2564A/25128A"},
			{ID: 0x4000, Name: "ALS4000 Audio Chipset"},
			{ID: 0x4710, Name: "ALC200/200P"},
		},
	},
	{
		ID: 0x4033, Name: "Addtron Technology Co, Inc.", Devices: []Device{
			{ID: 0x1360, Name: "RTL8139 Ethernet"},
		},
	},
	{
		ID: 0x4040, Name: "NetXen Incorporated", Devices: []Device{
			{ID: 0x0001, Name: "NXB-10GXSR 10-Gigabit Ethernet PCIe Adapter with SR-XFP optical interface"},
			{ID: 0x0002, Name: "NXB-10GCX4 10-Gigabit Ethernet PCIe Adapter with CX4 copper interface"},
			{ID: 0x0003, Name: "NXB-4GCU Quad Gigabit Ethernet PCIe Adapter with 1000-BASE-T interface"},
			{ID: 0x0004, Name: "BladeCenter-H 10-Gigabit Ethernet High Speed Daughter Card"},
			{ID: 0x0005, Name: "NetXen Dual Port 10GbE Multifunction Adapter for c-Class"},
			{ID: 0x0024, Name: "XG Mgmt"},
			{ID: 0x0025, Name: "XG Mgmt"},
			{ID: 0x0100, Name: "NX3031 Multifunction 1/10-Gigabit Server Adapter"},
		},
	},
	{ID: 0x4143, Name: "Digital Equipment Corp", Devices: []Device{}},
	{
		ID: 0x4144, Name: "Alpha Data", Devices: []Device{
			{ID: 0x0044, Name: "ADM-XRCIIPro"},
		},
	},
	{
		ID: 0x4150, Name: "ONA Electroerosion", Devices: []Device{
			{ID: 0x0001, Name: "PCI32TLITE FILSTRUP1 PCI to VME Bridge Controller"},
			{ID: 0x0006, Name: "PCI32TLITE UART 16550 Opencores"},
			{ID: 0x0007, Name: "PCI32TLITE CAN Controller Opencores"},
		},
	},
	{ID: 0x415a, Name: "Auzentech, Inc.", Devices: []Device{}},
	{
		ID: 0x416c, Name: "Aladdin Knowledge Systems", Devices: []Device{
			{ID: 0x0100, Name: "AladdinCARD"},
			{ID: 0x0200, Name: "CPC"},
		},
	},
	{ID: 0x4242, Name: "Universall Answer Generators", Devices: []Device{}},
	{ID: 0x4254, Name: "DVBSky", Devices: []Device{}},
	{ID: 0x4321, Name: "Tata Power Strategic Electronics Division", Devices: []Device{}},
	{
		ID: 0x4348, Name: "WCH.CN", Devices: []Device{
			{ID: 0x2273, Name: "CH351 PCI Dual Serial Port Controller"},
			{ID: 0x3253, Name: "CH352 PCI Dual Serial Port Controller"},
			{ID: 0x3453, Name: "CH353 PCI Quad Serial Port Controller"},
			{ID: 0x5053, Name: "CH352 PCI Serial and Parallel Port Controller"},
			{ID: 0x7053, Name: "CH353 PCI Dual Serial and Parallel Ports Controller"},
			{ID: 0x7073, Name: "CH356 PCI Quad Serial and Parallel Ports Controller"},
			{ID: 0x7173, Name: "CH355 PCI Quad Serial Port Controller"},
		},
	},
	{ID: 0x434e, Name: "Cornelis Networks", Devices: []Device{}},
	{
		ID: 0x4444, Name: "Internext Compression Inc", Devices: []Device{
			{ID: 0x0016, Name: "iTVC16 (CX23416) Video Decoder"},
			{ID: 0x0803, Name: "iTVC15 (CX23415) Video Decoder"},
		},
	},
	{ID: 0x4468, Name: "Bridgeport machines", Devices: []Device{}},
	{ID: 0x4594, Name: "Cogetec Informatique Inc", Devices: []Device{}},
	{ID: 0x45fb, Name: "Baldor Electric Company", Devices: []Device{}},
	{
		ID: 0x4624, Name: "Budker Institute of Nuclear Physics", Devices: []Device{
			{ID: 0xadc1, Name: "ADC200ME High speed ADC"},
			{ID: 0xde01, Name: "DL200ME High resolution delay line PCI based card"},
			{ID: 0xde02, Name: "DL200ME Middle resolution delay line PCI based card"},
		},
	},
	{ID: 0x4651, Name: "TXIC", Devices: []Device{}},
	{ID: 0x4680, Name: "Umax Computer Corp", Devices: []Device{}},
	{ID: 0x4843, Name: "Hercules Computer Technology Inc", Devices: []Device{}},
	{
		ID: 0x4916, Name: "RedCreek Communications Inc", Devices: []Device{
			{ID: 0x1960, Name: "RedCreek PCI adapter"},
		},
	},
	{ID: 0x4943, Name: "Growth Networks", Devices: []Device{}},
	{
		ID: 0x494f, Name: "ACCES I/O Products, Inc.", Devices: []Device{
			{ID: 0x0508, Name: "PCI-IDO-16A FET Output Card"},
			{ID: 0x0518, Name: "PCI-IDO-32A FET Output Card"},
			{ID: 0x0520, Name: "PCI-IDO-48 FET Output Card"},
			{ID: 0x0521, Name: "PCI-IDO-48A FET Output Card"},
			{ID: 0x0703, Name: "PCIe-RO-4 Electromechanical Relay Output Card"},
			{ID: 0x07d0, Name: "PCIe-IDO-24 FET Output Card"},
			{ID: 0x0920, Name: "PCI-IDI-48 Isolated Digital Input Card"},
			{ID: 0x0bd0, Name: "PCIe-IDI-24 Isolated Digital Input Card"},
			{ID: 0x0c50, Name: "PCI-DIO-24H 1x 8255 Digital Input / Output Card"},
			{ID: 0x0c51, Name: "PCI-DIO-24D 1x 8255 Digital Input / Output Card"},
			{ID: 0x0c52, Name: "PCIe-DIO-24 1x 8255 Digital Input / Output Card"},
			{ID: 0x0c53, Name: "PCIe-DIO-24H 8255 Digital Input / Output Card"},
			{ID: 0x0c57, Name: "mPCIe-DIO-24 8255 Digital Input / Output Card"},
			{ID: 0x0c60, Name: "PCI-DIO-48H 8255 Digital Input / Output Card"},
			{ID: 0x0c61, Name: "PCIe-DIO-48 8255 Digital Input / Output Card"},
			{ID: 0x0c62, Name: "P104-DIO-48 8255 Digital Input / Output Card"},
			{ID: 0x0c68, Name: "PCI-DIO-72 8255 Digital Input / Output Card"},
			{ID: 0x0c69, Name: "P104-DIO-96 8255 Digital Input / Output Card"},
			{ID: 0x0c70, Name: "PCI-DIO-96 8255 Digital Input / Output Card"},
			{ID: 0x0c78, Name: "PCI-DIO-120 8255 Digital Input / Output Card"},
			{ID: 0x0dc8, Name: "PCI-IDIO-16 Isolated Digital Input / FET Output Card"},
			{ID: 0x0e50, Name: "PCI-DIO-24S 8255 Digital Input / Output Card"},
			{ID: 0x0e51, Name: "PCI-DIO-24H(C) 8255 Digital Input / Output Card"},
			{ID: 0x0e52, Name: "PCI-DIO-24D(C) 8255 Digital Input / Output Card"},
			{ID: 0x0e53, Name: "PCIe-DIO-24S 8255 Digital Input / Output Card"},
			{ID: 0x0e54, Name: "PCIe-DIO-24HS 8255 Digital Input / Output Card"},
			{ID: 0x0e55, Name: "PCIe-DIO-24DC 8255 Digital Input / Output Card"},
			{ID: 0x0e56, Name: "PCIe-DIO-24DCS 8255 Digital Input / Output Card"},
			{ID: 0x0e57, Name: "mPCIe-DIO-24S 8255 Digital Input / Output Card"},
			{ID: 0x0e60, Name: "PCI-DIO-48S 2x 8255 Digital Input / Output Card"},
			{ID: 0x0e61, Name: "PCIe-DIO-48S 2x 8255 Digital Input / Output Card"},
			{ID: 0x0e62, Name: "P104-DIO-48S 2x 8255 Digital Input / Output Card"},
			{ID: 0x0f00, Name: "PCI-IIRO-8 Isolated Digital / Relay Output Card"},
			{ID: 0x0f01, Name: "LPCI-IIRO-8 Isolated Digital / Relay Output Card"},
			{ID: 0x0f02, Name: "PCIe-IIRO-8 Isolated Digital / Relay Output Card"},
			{ID: 0x0f08, Name: "PCI-IIRO-16 Isolated Digital / Relay Output Card"},
			{ID: 0x0f09, Name: "PCIe-IIRO-16 Isolated Digital / Relay Output Card"},
			{ID: 0x0fc0, Name: "PCIe-IDIO-12 Isolated Digital Input / FET Output Card"},
			{ID: 0x0fc1, Name: "PCIe-IDI-12 Isolated Digital Input Card"},
			{ID: 0x0fc2, Name: "PCIe-IDO-12 FET Output Card"},
			{ID: 0x0fd0, Name: "PCIe-IDIO-24 Isolated Digital Input / FET Output Card"},
			{ID: 0x1050, Name: "PCI-422/485-2 2x RS422/RS484 Card"},
			{ID: 0x1051, Name: "PCIe-COM-2SRJ 2x RS422/RS484 Card w/RJ45 Connectors"},
			{ID: 0x1052, Name: "104I-COM-2S 2x RS422/RS484 PCI/104 Board"},
			{ID: 0x1053, Name: "mPCIe-COM-2S 2x RS422/RS484 PCI Express Mini Card"},
			{ID: 0x1058, Name: "PCI-COM422/4 4x RS422 Card"},
			{ID: 0x1059, Name: "PCI-COM485/4 4x RS485 Card"},
			{ID: 0x105a, Name: "PCIe-COM422-4 4x RS422 Card"},
			{ID: 0x105b, Name: "PCIe-COM485-4 4x RS485 Card"},
			{ID: 0x105c, Name: "PCIe-COM-4SRJ 4x RS422/RS485 Card w/RJ45 Connectors"},
			{ID: 0x105d, Name: "104I-COM-4S 4x RS422/RS484 PCI/104 Board"},
			{ID: 0x105e, Name: "mPCIe-COM-4S 4x RS422/RS484 PCI Express Mini Card"},
			{ID: 0x1068, Name: "PCI-COM422/8 8x RS422 Card"},
			{ID: 0x1069, Name: "PCI-COM485/8 8x RS485 Card"},
			{ID: 0x106a, Name: "PCIe-COM422-8 8x RS422 Card"},
			{ID: 0x106b, Name: "PCIe-COM485-8 8x RS485 Card"},
			{ID: 0x106c, Name: "104I-COM-8S 8x RS422/RS485 PCI/104 Board"},
			{ID: 0x1088, Name: "PCI-COM232/1 1x RS232 Card"},
			{ID: 0x1090, Name: "PCI-COM232/2 2x RS232 Card"},
			{ID: 0x1091, Name: "PCIe-COM232-2RJ 2x RS232 Card w/RJ45 Connectors"},
			{ID: 0x1093, Name: "mPCIe-COM232-2 2x RS232 PCI Express Mini Card"},
			{ID: 0x1098, Name: "PCIe-COM232-4 4x RS232 Card"},
			{ID: 0x1099, Name: "PCIe-COM232-4RJ 4x RS232 Card w/RJ45 Connectors"},
			{ID: 0x109b, Name: "mPCIe-COM232-4 4x RS232 PCI Express Mini Card"},
			{ID: 0x10a8, Name: "P104-COM232-8 8x RS232 PC-104+ Board"},
			{ID: 0x10a9, Name: "PCIe-COM232-8 8x RS232 Card"},
			{ID: 0x10c9, Name: "PCI-COM-1S 1x RS422/RS485 Card"},
			{ID: 0x10d0, Name: "PCI-COM2S 2x RS422/RS485 Card"},
			{ID: 0x10d1, Name: "PCIe-COM-2SMRJ 2x RS232/RS422/RS485 Card w/RJ45 Connectors"},
			{ID: 0x10d2, Name: "104I-COM-2SM 2x RS232/RS422/RS485 PCI/104 Board"},
			{ID: 0x10d3, Name: "mPCIe-COM-2SM 2x RS232/RS422/RS485 PCI Express Mini Card"},
			{ID: 0x10d8, Name: "PCI-COM-4SM 4x RS232/RS422/RS485 Card"},
			{ID: 0x10d9, Name: "PCIe-COM-4SM 4x RS232/RS422/RS485 Card"},
			{ID: 0x10da, Name: "PCIe-COM-4SMRJ 4x RS232/RS422/RS485 Card w/RJ45 Connectors"},
			{ID: 0x10db, Name: "104I-COM-4SM 4x RS232/RS422/RS485 PCI/104 Board"},
			{ID: 0x10dc, Name: "mPCIe-COM-4SM 4x RS232/RS422/RS485 PCI Express Mini Card"},
			{ID: 0x10e8, Name: "PCI-COM-8SM 8x RS232/RS422/RS485 Card"},
			{ID: 0x10e9, Name: "PCIe-COM-8SM 8x RS232/RS422/RS485 Card"},
			{ID: 0x10ea, Name: "104I-COM-8SM 8x RS232/RS422/RS485 PCI-104 Board"},
			{ID: 0x1108, Name: "mPCIe-ICM485-1 1x Isolated RS485 PCI Express Mini Card"},
			{ID: 0x1110, Name: "mPCIe-ICM422-2 2x Isolated RS422 PCI Express Mini Card"},
			{ID: 0x1111, Name: "mPCIe-ICM485-2 2x Isolated RS485 PCI Express Mini Card"},
			{ID: 0x1118, Name: "mPCIe-ICM422-4 4x Isolated RS422 PCI Express Mini Card"},
			{ID: 0x1119, Name: "mPCIe-ICM485-4 4x Isolated RS485 PCI Express Mini Card"},
			{ID: 0x1148, Name: "PCI-ICM-1S 1x Isolated RS422/RS485 Card"},
			{ID: 0x1150, Name: "PCI-ICM-2S 2x Isolated RS422/RS485 Card"},
			{ID: 0x1152, Name: "PCIe-ICM-2S 2x Isolated RS422/RS485 Card"},
			{ID: 0x1158, Name: "PCI-ICM422/4 4x Isolated RS422 Card"},
			{ID: 0x1159, Name: "PCI-ICM485/4 4x Isolated RS485 Card"},
			{ID: 0x115a, Name: "PCIe-ICM-4S 4x Isolated RS422/RS485 Card"},
			{ID: 0x1190, Name: "PCIe-ICM232-2 2x Isolated RS232 Card"},
			{ID: 0x1191, Name: "mPCIe-ICM232-2 2x Isolated RS232 PCI Express Mini Card"},
			{ID: 0x1198, Name: "PCIe-ICM232-4 4x Isolated RS232 Card"},
			{ID: 0x1199, Name: "mPCIe-ICM232-4 4x Isolated RS422 PCI Express Mini Card"},
			{ID: 0x11d0, Name: "PCIe-ICM-2SM 2x Isolated RS232/RS422/RS485 Card"},
			{ID: 0x11d8, Name: "PCIe-ICM-4SM 4x Isolated RS232/RS422/RS485 Card"},
			{ID: 0x1250, Name: "PCI-WDG-2S Watchdog and 2x Serial Card"},
			{ID: 0x12d0, Name: "PCI-WDG-IMPAC"},
			{ID: 0x2230, Name: "PCI-QUAD-8 8x Quadrature Input Card"},
			{ID: 0x2231, Name: "PCI-QUAD-4 4x Quadrature Input Card"},
			{ID: 0x22c0, Name: "PCI-WDG-CSM Watchdog Card"},
			{ID: 0x25c0, Name: "P104-WDG-E Watchdog PC/104+ Board"},
			{ID: 0x2c50, Name: "PCI-DIO-96CT 96x Digital Input / Output Card"},
			{ID: 0x2c58, Name: "PCI-DIO-96C3 96x Digital Input / Output Card w/3x 8254 Counter Card"},
			{ID: 0x2ee0, Name: "PCIe-DIO24S-CTR12 24x Digital Input / Output Card w/4x 8254 Counter Card"},
			{ID: 0x2fc0, Name: "P104-WDG-CSM Watchdog PC/104+ Board"},
			{ID: 0x2fc1, Name: "P104-WDG-CSMA Advanced Watchdog PC/104+ Board"},
			{ID: 0x5ed0, Name: "PCI-DAC"},
			{ID: 0x6c90, Name: "PCI-DA12-2 2x 12-bit Analog Output Card"},
			{ID: 0x6c98, Name: "PCI-DA12-4 4x 12-bit Analog Output Card"},
			{ID: 0x6ca0, Name: "PCI-DA12-6 6x 12-bit Analog Output Card"},
			{ID: 0x6ca8, Name: "PCI-DA12-8 8x 12-bit Analog Output Card"},
			{ID: 0x6ca9, Name: "PCI-DA12-8V"},
			{ID: 0x6cb0, Name: "PCI-DA12-16 16x 12-bit Analog Output Card"},
			{ID: 0x6cb1, Name: "PCI-DA12-16V"},
			{ID: 0x8ef0, Name: "P104-FAS16-16"},
			{ID: 0xaca8, Name: "PCI-AI12-16 12-bit 100kHz Analog Input Card"},
			{ID: 0xaca9, Name: "PCI-AI12-16A 12-bit 100kHz Analog Input w/FIFO Card"},
			{ID: 0xeca8, Name: "PCI-AIO12-16 12-bit 100kHz Analog Input w/2x Analog Output and FIFO Card"},
			{ID: 0xecaa, Name: "PCI-A12-16A 12-bit 100kHz Analog Input w/2x Analog Output and FIFO Card"},
			{ID: 0xece8, Name: "LPCI-A16-16A 16-bit 500kHz Analog Input low-profile Card"},
			{ID: 0xece9, Name: "LPCI-AIO16A 16-bit 500kHz Analog Input low-profile Card"},
		},
	},
	{ID: 0x4978, Name: "Axil Computer Inc", Devices: []Device{}},
	{
		ID: 0x4a14, Name: "NetVin", Devices: []Device{
			{ID: 0x5000, Name: "NV5000SC"},
		},
	},
	{ID: 0x4b10, Name: "Buslogic Inc.", Devices: []Device{}},
	{ID: 0x4c48, Name: "LUNG HWA Electronics", Devices: []Device{}},
	{ID: 0x4c52, Name: "LR-Link", Devices: []Device{}},
	{
		ID: 0x4c53, Name: "SBS Technologies", Devices: []Device{
			{ID: 0x0000, Name: "PLUSTEST device"},
			{ID: 0x0001, Name: "PLUSTEST-MM device"},
		},
	},
	{ID: 0x4ca1, Name: "Seanix Technology Inc", Devices: []Device{}},
	{
		ID: 0x4d51, Name: "MediaQ Inc.", Devices: []Device{
			{ID: 0x0200, Name: "MQ-200"},
		},
	},
	{ID: 0x4d54, Name: "Microtechnica Co Ltd", Devices: []Device{}},
	{
		ID: 0x4d56, Name: "MATRIX VISION GmbH", Devices: []Device{
			{ID: 0x0000, Name: "[mvHYPERION-CLe/CLb] CameraLink PCI Express x1 Frame Grabber"},
			{ID: 0x0001, Name: "[mvHYPERION-CLf/CLm] CameraLink PCI Express x4 Frame Grabber"},
			{ID: 0x0010, Name: "[mvHYPERION-16R16/-32R16] 16 Video Channel PCI Express x4 Frame Grabber"},
			{ID: 0x0020, Name: "[mvHYPERION-HD-SDI] HD-SDI PCI Express x4 Frame Grabber"},
			{ID: 0x0030, Name: "[mvHYPERION-HD-SDI-Merger] HD-SDI PCI Express x4 Frame Grabber"},
			{ID: 0x7012, Name: "[mvBlueNAOS BVS CA-BN] PCIe Gen1 x2 Camera"},
			{ID: 0x7014, Name: "[mvBlueNAOS BVS CA-BN] PCIe Gen1 x4 Camera"},
			{ID: 0x7022, Name: "[mvBlueNAOS BVS CA-BN] PCIe Gen2 x2 Camera"},
			{ID: 0x7024, Name: "[mvBlueNAOS BVS CA-BN] PCIe Gen2 x4 Camera"},
		},
	},
	{
		ID: 0x4ddc, Name: "ILC Data Device Corp", Devices: []Device{
			{ID: 0x0100, Name: "DD-42924I5-300 (ARINC 429 Data Bus)"},
			{ID: 0x0300, Name: "SB-3620 Motion Feedback Device"},
			{ID: 0x0340, Name: "SB-3623 Motion Feedback Device"},
			{ID: 0x0400, Name: "SB-3622 Motion Feedback Device"},
			{ID: 0x0500, Name: "SB-3621 Motion Feedback Device"},
			{ID: 0x0510, Name: "SB-3624 Motion Feedback Device"},
			{ID: 0x0801, Name: "BU-65570I1 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0802, Name: "BU-65570I2 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0811, Name: "BU-65572I1 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0812, Name: "BU-65572I2 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0881, Name: "BU-65570T1 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0882, Name: "BU-65570T2 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0891, Name: "BU-65572T1 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0892, Name: "BU-65572T2 MIL-STD-1553 Test and Simulation"},
			{ID: 0x0901, Name: "BU-65565C1 MIL-STD-1553 Data Bus"},
			{ID: 0x0902, Name: "BU-65565C2 MIL-STD-1553 Data Bus"},
			{ID: 0x0903, Name: "BU-65565C3 MIL-STD-1553 Data Bus"},
			{ID: 0x0904, Name: "BU-65565C4 MIL-STD-1553 Data Bus"},
			{ID: 0x0b01, Name: "BU-65569I1 MIL-STD-1553 Data Bus"},
			{ID: 0x0b02, Name: "BU-65569I2 MIL-STD-1553 Data Bus"},
			{ID: 0x0b03, Name: "BU-65569I3 MIL-STD-1553 Data Bus"},
			{ID: 0x0b04, Name: "BU-65569I4 MIL-STD-1553 Data Bus"},
			{ID: 0x0d01, Name: "SB-3641 Motion Feedback Device"},
			{ID: 0x0d10, Name: "SB-365x Motion Feedback Device"},
			{ID: 0x2f00, Name: "SB-3642 Motion Feedback Device"},
			{ID: 0x3000, Name: "SB-3644 Motion Feedback Device"},
		},
	},
	{
		ID: 0x5045, Name: "University of Toronto", Devices: []Device{
			{ID: 0x4243, Name: "BLASTbus PCI Interface Card v1"},
		},
	},
	{
		ID: 0x5046, Name: "GemTek Technology Corporation", Devices: []Device{
			{ID: 0x1001, Name: "PCI Radio"},
		},
	},
	{
		ID: 0x5053, Name: "Voyetra Technologies", Devices: []Device{
			{ID: 0x2010, Name: "Daytona Audio Adapter"},
		},
	},
	{ID: 0x50b2, Name: "TerraTec Electronic GmbH", Devices: []Device{}},
	{ID: 0x5136, Name: "S S Technologies", Devices: []Device{}},
	{ID: 0x5143, Name: "Qualcomm Inc", Devices: []Device{}},
	{
		ID: 0x5145, Name: "Ensoniq (Old)", Devices: []Device{
			{ID: 0x3031, Name: "Concert AudioPCI"},
		},
	},
	{
		ID: 0x5168, Name: "Animation Technologies Inc.", Devices: []Device{
			{ID: 0x0300, Name: "FlyDVB-S"},
			{ID: 0x0301, Name: "FlyDVB-T"},
		},
	},
	{
		ID: 0x5301, Name: "Alliance Semiconductor Corp.", Devices: []Device{
			{ID: 0x0001, Name: "ProMotion aT3D"},
		},
	},
	{
		ID: 0x5333, Name: "S3 Graphics Ltd.", Devices: []Device{
			{ID: 0x0551, Name: "Plato/PX (system)"},
			{ID: 0x5631, Name: "86c325 [ViRGE]"},
			{ID: 0x8800, Name: "86c866 [Vision 866]"},
			{ID: 0x8801, Name: "86c964 [Vision 964]"},
			{ID: 0x8810, Name: "86c764_0 [Trio 32 vers 0]"},
			{ID: 0x8811, Name: "86c764/765 [Trio32/64/64V+]"},
			{ID: 0x8812, Name: "86cM65 [Aurora64V+]"},
			{ID: 0x8813, Name: "86c764_3 [Trio 32/64 vers 3]"},
			{ID: 0x8814, Name: "86c767 [Trio 64UV+]"},
			{ID: 0x8815, Name: "86cM65 [Aurora 128]"},
			{ID: 0x883d, Name: "86c988 [ViRGE/VX]"},
			{ID: 0x8870, Name: "FireGL"},
			{ID: 0x8880, Name: "86c868 [Vision 868 VRAM] vers 0"},
			{ID: 0x8881, Name: "86c868 [Vision 868 VRAM] vers 1"},
			{ID: 0x8882, Name: "86c868 [Vision 868 VRAM] vers 2"},
			{ID: 0x8883, Name: "86c868 [Vision 868 VRAM] vers 3"},
			{ID: 0x88b0, Name: "86c928 [Vision 928 VRAM] vers 0"},
			{ID: 0x88b1, Name: "86c928 [Vision 928 VRAM] vers 1"},
			{ID: 0x88b2, Name: "86c928 [Vision 928 VRAM] vers 2"},
			{ID: 0x88b3, Name: "86c928 [Vision 928 VRAM] vers 3"},
			{ID: 0x88c0, Name: "86c864 [Vision 864 DRAM] vers 0"},
			{ID: 0x88c1, Name: "86c864 [Vision 864 DRAM] vers 1"},
			{ID: 0x88c2, Name: "86c864 [Vision 864-P DRAM] vers 2"},
			{ID: 0x88c3, Name: "86c864 [Vision 864-P DRAM] vers 3"},
			{ID: 0x88d0, Name: "86c964 [Vision 964 VRAM] vers 0"},
			{ID: 0x88d1, Name: "86c964 [Vision 964 VRAM] vers 1"},
			{ID: 0x88d2, Name: "86c964 [Vision 964-P VRAM] vers 2"},
			{ID: 0x88d3, Name: "86c964 [Vision 964-P VRAM] vers 3"},
			{ID: 0x88f0, Name: "86c968 [Vision 968 VRAM] rev 0"},
			{ID: 0x88f1, Name: "86c968 [Vision 968 VRAM] rev 1"},
			{ID: 0x88f2, Name: "86c968 [Vision 968 VRAM] rev 2"},
			{ID: 0x88f3, Name: "86c968 [Vision 968 VRAM] rev 3"},
			{ID: 0x8900, Name: "86c755 [Trio 64V2/DX]"},
			{ID: 0x8901, Name: "86c775/86c785 [Trio 64V2/DX or /GX]"},
			{ID: 0x8902, Name: "Plato/PX"},
			{ID: 0x8903, Name: "Trio 3D business multimedia"},
			{ID: 0x8904, Name: "86c365, 86c366 [Trio 3D]"},
			{ID: 0x8905, Name: "Trio 64V+ family"},
			{ID: 0x8906, Name: "Trio 64V+ family"},
			{ID: 0x8907, Name: "Trio 64V+ family"},
			{ID: 0x8908, Name: "Trio 64V+ family"},
			{ID: 0x8909, Name: "Trio 64V+ family"},
			{ID: 0x890a, Name: "Trio 64V+ family"},
			{ID: 0x890b, Name: "Trio 64V+ family"},
			{ID: 0x890c, Name: "Trio 64V+ family"},
			{ID: 0x890d, Name: "Trio 64V+ family"},
			{ID: 0x890e, Name: "Trio 64V+ family"},
			{ID: 0x890f, Name: "Trio 64V+ family"},
			{ID: 0x8a01, Name: "86c375 [ViRGE/DX] or 86c385 [ViRGE/GX]"},
			{ID: 0x8a10, Name: "ViRGE/GX2"},
			{ID: 0x8a13, Name: "86c360 [Trio 3D/1X], 86c362, 86c368 [Trio 3D/2X]"},
			{ID: 0x8a20, Name: "86c794 [Savage 3D]"},
			{ID: 0x8a21, Name: "86c390 [Savage 3D/MV]"},
			{ID: 0x8a22, Name: "Savage 4"},
			{ID: 0x8a23, Name: "Savage 4"},
			{ID: 0x8a25, Name: "ProSavage PM133"},
			{ID: 0x8a26, Name: "ProSavage KM133"},
			{ID: 0x8c00, Name: "ViRGE/M3"},
			{ID: 0x8c01, Name: "ViRGE/MX"},
			{ID: 0x8c02, Name: "ViRGE/MX+"},
			{ID: 0x8c03, Name: "ViRGE/MX+MV"},
			{ID: 0x8c10, Name: "86C270-294 [SavageMX-MV]"},
			{ID: 0x8c11, Name: "82C270-294 [SavageMX]"},
			{ID: 0x8c12, Name: "86C270-294 [SavageIX-MV]"},
			{ID: 0x8c13, Name: "86C270-294 [SavageIX]"},
			{ID: 0x8c22, Name: "SuperSavage MX/128"},
			{ID: 0x8c24, Name: "SuperSavage MX/64"},
			{ID: 0x8c26, Name: "SuperSavage MX/64C"},
			{ID: 0x8c2a, Name: "SuperSavage IX/128 SDR"},
			{ID: 0x8c2b, Name: "SuperSavage IX/128 DDR"},
			{ID: 0x8c2c, Name: "SuperSavage IX/64 SDR"},
			{ID: 0x8c2d, Name: "SuperSavage IX/64 DDR"},
			{ID: 0x8c2e, Name: "SuperSavage IX/C SDR"},
			{ID: 0x8c2f, Name: "SuperSavage IX/C DDR"},
			{ID: 0x8d01, Name: "86C380 [ProSavageDDR K4M266]"},
			{ID: 0x8d02, Name: "VT8636A [ProSavage KN133] AGP4X VGA Controller (TwisterK)"},
			{ID: 0x8d03, Name: "VT8751 [ProSavageDDR P4M266]"},
			{ID: 0x8d04, Name: "VT8375 [ProSavage8 KM266/KL266]"},
			{ID: 0x8e00, Name: "DeltaChrome"},
			{ID: 0x8e26, Name: "ProSavage"},
			{ID: 0x8e40, Name: "2300E Graphics Processor"},
			{ID: 0x8e48, Name: "Matrix [Chrome S25 / S27]"},
			{ID: 0x9043, Name: "Chrome 430 GT"},
			{ID: 0x9045, Name: "Chrome 430 ULP / 435 ULP / 440 GTX"},
			{ID: 0x9060, Name: "Chrome 530 GT"},
			{ID: 0x9102, Name: "86C410 [Savage 2000]"},
			{ID: 0xca00, Name: "SonicVibes"},
		},
	},
	{ID: 0x5431, Name: "AuzenTech, Inc.", Devices: []Device{}},
	{
		ID: 0x544c, Name: "Teralogic Inc", Devices: []Device{
			{ID: 0x0350, Name: "TL880-based HDTV/ATSC tuner"},
		},
	},
	{
		ID: 0x544d, Name: "TBS Technologies", Devices: []Device{
			{ID: 0x6178, Name: "DVB Tuner PCIe Card"},
		},
	},
	{
		ID: 0x5452, Name: "SCANLAB AG", Devices: []Device{
			{ID: 0x3443, Name: "RTC4"},
		},
	},
	{
		ID: 0x5455, Name: "Technische Universitaet Berlin", Devices: []Device{
			{ID: 0x4458, Name: "S5933"},
		},
	},
	{ID: 0x5456, Name: "GoTView", Devices: []Device{}},
	{ID: 0x5519, Name: "Cnet Technologies, Inc.", Devices: []Device{}},
	{
		ID: 0x5544, Name: "Dunord Technologies", Devices: []Device{
			{ID: 0x0001, Name: "I-30xx Scanner Interface"},
		},
	},
	{
		ID: 0x5555, Name: "Genroco, Inc", Devices: []Device{
			{ID: 0x0003, Name: "TURBOstor HFP-832 [HiPPI NIC]"},
			{ID: 0x3b00, Name: "Epiphan DVI2PCIe video capture card"},
		},
	},
	{ID: 0x5646, Name: "Vector Fabrics BV", Devices: []Device{}},
	{ID: 0x5654, Name: "VoiceTronix Pty Ltd", Devices: []Device{}},
	{ID: 0x5678, Name: "Dawicontrol Computersysteme GmbH", Devices: []Device{}},
	{ID: 0x5700, Name: "Netpower", Devices: []Device{}},
	{ID: 0x5845, Name: "X-ES, Inc.", Devices: []Device{}},
	{ID: 0x584d, Name: "AuzenTech Co., Ltd.", Devices: []Device{}},
	{
		ID: 0x5851, Name: "Exacq Technologies", Devices: []Device{
			{ID: 0x8008, Name: "tDVR8008 8-port video capture card"},
			{ID: 0x8016, Name: "tDVR8016 16-chan video capture card"},
			{ID: 0x8032, Name: "tDVR8032 32-chan video capture card"},
		},
	},
	{
		ID: 0x5853, Name: "XenSource, Inc.", Devices: []Device{
			{ID: 0x0001, Name: "Xen Platform Device"},
			{ID: 0xc000, Name: "Citrix XenServer PCI Device for Windows Update"},
			{ID: 0xc110, Name: "Virtualized HID"},
			{ID: 0xc147, Name: "Virtualized Graphics Device"},
			{ID: 0xc200, Name: "XCP-ng Project PCI Device for Windows Update"},
		},
	},
	{ID: 0x5854, Name: "GoTView", Devices: []Device{}},
	{ID: 0x5ace, Name: "Beholder International Ltd.", Devices: []Device{}},
	{ID: 0x6205, Name: "TBS Technologies (wrong ID)", Devices: []Device{}},
	{ID: 0x6209, Name: "TBS Technologies (wrong ID)", Devices: []Device{}},
	{
		ID: 0x631c, Name: "SmartInfra Ltd", Devices: []Device{
			{ID: 0x1652, Name: "PXI-1652 Signal Generator"},
			{ID: 0x2504, Name: "PXI-2504 Signal Interrogator"},
		},
	},
	{ID: 0x6356, Name: "UltraStor", Devices: []Device{}},
	{
		ID: 0x6374, Name: "c't Magazin fuer Computertechnik", Devices: []Device{
			{ID: 0x6773, Name: "GPPCI"},
		},
	},
	{ID: 0x6409, Name: "Logitec Corp.", Devices: []Device{}},
	{
		ID: 0x6549, Name: "Teradici Corp.", Devices: []Device{
			{ID: 0x1200, Name: "TERA1200 PC-over-IP Host"},
		},
	},
	{
		ID: 0x6666, Name: "Decision Computer International Co.", Devices: []Device{
			{ID: 0x0001, Name: "PCCOM4"},
			{ID: 0x0002, Name: "PCCOM8"},
			{ID: 0x0004, Name: "PCCOM2"},
			{ID: 0x0101, Name: "PCI 8255/8254 I/O Card"},
			{ID: 0x0200, Name: "12-bit AD/DA Card"},
			{ID: 0x0201, Name: "14-bit AD/DA Card"},
			{ID: 0x1011, Name: "Industrial Card"},
			{ID: 0x1021, Name: "8 photo couple 8 relay Card"},
			{ID: 0x1022, Name: "4 photo couple 4 relay Card"},
			{ID: 0x1025, Name: "16 photo couple 16 relay Card"},
			{ID: 0x4000, Name: "WatchDog Card"},
		},
	},
	{
		ID: 0x6688, Name: "Zycoo Co., Ltd", Devices: []Device{
			{ID: 0x1200, Name: "CooVox TDM Analog Module"},
			{ID: 0x1400, Name: "CooVOX TDM GSM Module"},
			{ID: 0x1600, Name: "CooVOX TDM E1/T1 Module"},
			{ID: 0x1800, Name: "CooVOX TDM BRI Module"},
		},
	},
	{
		ID: 0x6766, Name: "Glenfly Tech Co., Ltd.", Devices: []Device{
			{ID: 0x3d00, Name: "Arise-GT-10C0"},
			{ID: 0x3d02, Name: "Arise 1020"},
			{ID: 0x3d40, Name: "Arise-GT-10C0 High Definition Audio Controller"},
			{ID: 0x3d41, Name: "Arise 1020 High Definition Audio Controller"},
		},
	},
	{ID: 0x6900, Name: "Red Hat, Inc.", Devices: []Device{}},
	{
		ID: 0x7063, Name: "pcHDTV", Devices: []Device{
			{ID: 0x2000, Name: "HD-2000"},
			{ID: 0x3000, Name: "HD-3000"},
			{ID: 0x5500, Name: "HD5500 HDTV"},
		},
	},
	{ID: 0x7284, Name: "HT OMEGA Inc.", Devices: []Device{}},
	{
		ID: 0x7357, Name: "IOxOS Technologies SA", Devices: []Device{
			{ID: 0x7910, Name: "7910 [Althea]"},
		},
	},
	{
		ID: 0x7401, Name: "EndRun Technologies", Devices: []Device{
			{ID: 0xe100, Name: "PTP3100 PCIe PTP Slave Clock"},
		},
	},
	{ID: 0x7470, Name: "TP-LINK Technologies Co., Ltd.", Devices: []Device{}},
	{ID: 0x7604, Name: "O.N. Electronic Co Ltd.", Devices: []Device{}},
	{ID: 0x7bde, Name: "MIDAC Corporation", Devices: []Device{}},
	{ID: 0x7fed, Name: "PowerTV", Devices: []Device{}},
	{
		ID: 0x8008, Name: "Quancom Electronic GmbH", Devices: []Device{
			{ID: 0x0010, Name: "WDOG1 [PCI-Watchdog 1]"},
			{ID: 0x0011, Name: "PWDOG2 [PCI-Watchdog 2]"},
			{ID: 0x0015, Name: "Clock77/PCI & Clock77/PCIe (DCF-77 receiver)"},
		},
	},
	{ID: 0x807d, Name: "Asustek Computer, Inc.", Devices: []Device{}},
	{
		ID: 0x8086, Name: "Intel Corporation", Devices: []Device{
			{ID: 0x0007, Name: "82379AB"},
			{ID: 0x0008, Name: "Extended Express System Support Controller"},
			{ID: 0x0039, Name: "21145 Fast Ethernet"},
			{ID: 0x0040, Name: "Core Processor DRAM Controller"},
			{ID: 0x0041, Name: "Core Processor PCI Express x16 Root Port"},
			{ID: 0x0042, Name: "Core Processor Integrated Graphics Controller"},
			{ID: 0x0043, Name: "Core Processor Secondary PCI Express Root Port"},
			{ID: 0x0044, Name: "Core Processor DRAM Controller"},
			{ID: 0x0045, Name: "Core Processor PCI Express x16 Root Port"},
			{ID: 0x0046, Name: "Core Processor Integrated Graphics Controller"},
			{ID: 0x0047, Name: "Core Processor Secondary PCI Express Root Port"},
			{ID: 0x0048, Name: "Core Processor DRAM Controller"},
			{ID: 0x0049, Name: "Core Processor PCI Express x16 Root Port"},
			{ID: 0x004a, Name: "Core Processor Integrated Graphics Controller"},
			{ID: 0x004b, Name: "Core Processor Secondary PCI Express Root Port"},
			{ID: 0x0050, Name: "Core Processor Thermal Management Controller"},
			{ID: 0x0069, Name: "Core Processor DRAM Controller"},
			{ID: 0x0082, Name: "Centrino Advanced-N 6205 [Taylor Peak]"},
			{ID: 0x0083, Name: "Centrino Wireless-N 1000 [Condor Peak]"},
			{ID: 0x0084, Name: "Centrino Wireless-N 1000 [Condor Peak]"},
			{ID: 0x0085, Name: "Centrino Advanced-N 6205 [Taylor Peak]"},
			{ID: 0x0087, Name: "Centrino Advanced-N + WiMAX 6250 [Kilmer Peak]"},
			{ID: 0x0089, Name: "Centrino Advanced-N + WiMAX 6250 [Kilmer Peak]"},
			{ID: 0x008a, Name: "Centrino Wireless-N 1030 [Rainbow Peak]"},
			{ID: 0x008b, Name: "Centrino Wireless-N 1030 [Rainbow Peak]"},
			{ID: 0x0090, Name: "Centrino Advanced-N 6230 [Rainbow Peak]"},
			{ID: 0x0091, Name: "Centrino Advanced-N 6230 [Rainbow Peak]"},
			{ID: 0x0100, Name: "2nd Generation Core Processor Family DRAM Controller"},
			{ID: 0x0101, Name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port"},
			{ID: 0x0102, Name: "2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0104, Name: "2nd Generation Core Processor Family DRAM Controller"},
			{ID: 0x0105, Name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port"},
			{ID: 0x0106, Name: "2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0108, Name: "Xeon E3-1200 Processor Family DRAM Controller"},
			{ID: 0x0109, Name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port"},
			{ID: 0x010a, Name: "Xeon E3-1200 Processor Family Integrated Graphics Controller"},
			{ID: 0x010b, Name: "Xeon E3-1200/2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x010c, Name: "Xeon E3-1200/2nd Generation Core Processor Family DRAM Controller"},
			{ID: 0x010d, Name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port"},
			{ID: 0x010e, Name: "Xeon E3-1200/2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0112, Name: "2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0116, Name: "2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0122, Name: "2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0126, Name: "2nd Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0150, Name: "Xeon E3-1200 v2/3rd Gen Core processor DRAM Controller"},
			{ID: 0x0151, Name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port"},
			{ID: 0x0152, Name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller"},
			{ID: 0x0153, Name: "3rd Gen Core Processor Thermal Subsystem"},
			{ID: 0x0154, Name: "3rd Gen Core processor DRAM Controller"},
			{ID: 0x0155, Name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port"},
			{ID: 0x0156, Name: "3rd Gen Core processor Graphics Controller"},
			{ID: 0x0158, Name: "Xeon E3-1200 v2/Ivy Bridge DRAM Controller"},
			{ID: 0x0159, Name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port"},
			{ID: 0x015a, Name: "Xeon E3-1200 v2/Ivy Bridge Graphics Controller"},
			{ID: 0x015c, Name: "Xeon E3-1200 v2/3rd Gen Core processor DRAM Controller"},
			{ID: 0x015d, Name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port"},
			{ID: 0x015e, Name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller"},
			{ID: 0x0162, Name: "IvyBridge GT2 [HD Graphics 4000]"},
			{ID: 0x0166, Name: "3rd Gen Core processor Graphics Controller"},
			{ID: 0x016a, Name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller"},
			{ID: 0x0172, Name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller"},
			{ID: 0x0176, Name: "3rd Gen Core processor Graphics Controller"},
			{ID: 0x0201, Name: "Arctic Sound"},
			{ID: 0x0284, Name: "Comet Lake PCH-LP LPC Premium Controller/eSPI Controller"},
			{ID: 0x02a3, Name: "Comet Lake PCH-LP SMBus Host Controller"},
			{ID: 0x02a4, Name: "Comet Lake SPI (flash) Controller"},
			{ID: 0x02a6, Name: "Comet Lake North Peak"},
			{ID: 0x02b0, Name: "Comet Lake PCI Express Root Port #9"},
			{ID: 0x02b1, Name: "Comet Lake PCI Express Root Port #10"},
			{ID: 0x02b3, Name: "Comet Lake PCI Express Root Port #12"},
			{ID: 0x02b4, Name: "Comet Lake PCI Express Root Port #13"},
			{ID: 0x02b8, Name: "Comet Lake PCI Express Root Port #1"},
			{ID: 0x02bc, Name: "Comet Lake PCI Express Root Port #5"},
			{ID: 0x02c5, Name: "Comet Lake Serial IO I2C Host Controller"},
			{ID: 0x02c8, Name: "Comet Lake PCH-LP cAVS"},
			{ID: 0x02d3, Name: "Comet Lake SATA AHCI Controller"},
			{ID: 0x02e0, Name: "Comet Lake Management Engine Interface"},
			{ID: 0x02e8, Name: "Serial IO I2C Host Controller"},
			{ID: 0x02e9, Name: "Comet Lake Serial IO I2C Host Controller"},
			{ID: 0x02ea, Name: "Comet Lake PCH-LP LPSS: I2C Controller #2"},
			{ID: 0x02ed, Name: "Comet Lake PCH-LP USB 3.1 xHCI Host Controller"},
			{ID: 0x02ef, Name: "Comet Lake PCH-LP Shared SRAM"},
			{ID: 0x02f0, Name: "Comet Lake PCH-LP CNVi WiFi"},
			{ID: 0x02f5, Name: "Comet Lake PCH-LP SCS3"},
			{ID: 0x02f9, Name: "Comet Lake Thermal Subsytem"},
			{ID: 0x02fc, Name: "Comet Lake Integrated Sensor Solution"},
			{ID: 0x0309, Name: "80303 I/O Processor PCI-to-PCI Bridge"},
			{ID: 0x030d, Name: "80312 I/O Companion Chip PCI-to-PCI Bridge"},
			{ID: 0x0326, Name: "6700/6702PXH I/OxAPIC Interrupt Controller A"},
			{ID: 0x0327, Name: "6700PXH I/OxAPIC Interrupt Controller B"},
			{ID: 0x0329, Name: "6700PXH PCI Express-to-PCI Bridge A"},
			{ID: 0x032a, Name: "6700PXH PCI Express-to-PCI Bridge B"},
			{ID: 0x032c, Name: "6702PXH PCI Express-to-PCI Bridge A"},
			{ID: 0x0330, Name: "80332 [Dobson] I/O processor (A-Segment Bridge)"},
			{ID: 0x0331, Name: "80332 [Dobson] I/O processor (A-Segment IOAPIC)"},
			{ID: 0x0332, Name: "80332 [Dobson] I/O processor (B-Segment Bridge)"},
			{ID: 0x0333, Name: "80332 [Dobson] I/O processor (B-Segment IOAPIC)"},
			{ID: 0x0334, Name: "80332 [Dobson] I/O processor (ATU)"},
			{ID: 0x0335, Name: "80331 [Lindsay] I/O processor (PCI-X Bridge)"},
			{ID: 0x0336, Name: "80331 [Lindsay] I/O processor (ATU)"},
			{ID: 0x0340, Name: "41210 [Lanai] Serial to Parallel PCI Bridge (A-Segment Bridge)"},
			{ID: 0x0341, Name: "41210 [Lanai] Serial to Parallel PCI Bridge (B-Segment Bridge)"},
			{ID: 0x0370, Name: "80333 Segment-A PCIe Express to PCI-X bridge"},
			{ID: 0x0371, Name: "80333 A-Bus IOAPIC"},
			{ID: 0x0372, Name: "80333 Segment-B PCIe Express to PCI-X bridge"},
			{ID: 0x0373, Name: "80333 B-Bus IOAPIC"},
			{ID: 0x0374, Name: "80333 Address Translation Unit"},
			{ID: 0x0402, Name: "Xeon E3-1200 v3/4th Gen Core Processor Integrated Graphics Controller"},
			{ID: 0x0406, Name: "Haswell Integrated Graphics Controller"},
			{ID: 0x040a, Name: "Xeon E3-1200 v3 Processor Integrated Graphics Controller"},
			{ID: 0x0412, Name: "Xeon E3-1200 v3/4th Gen Core Processor Integrated Graphics Controller"},
			{ID: 0x0416, Name: "4th Gen Core Processor Integrated Graphics Controller"},
			{ID: 0x041a, Name: "Xeon E3-1200 v3 Processor Integrated Graphics Controller"},
			{ID: 0x041e, Name: "4th Generation Core Processor Family Integrated Graphics Controller"},
			{ID: 0x0434, Name: "DH89XXCC Series QAT"},
			{ID: 0x0435, Name: "DH895XCC Series QAT"},
			{ID: 0x0436, Name: "DH8900CC Null Device"},
			{ID: 0x0438, Name: "DH8900CC Series Gigabit Network Connection"},
			{ID: 0x043a, Name: "DH8900CC Series Gigabit Fiber Network Connection"},
			{ID: 0x043c, Name: "DH8900CC Series Gigabit Backplane Network Connection"},
			{ID: 0x0440, Name: "DH8900CC Series Gigabit SFP Network Connection"},
			{ID: 0x0442, Name: "DH89XXCC Series QAT Virtual Function"},
			{ID: 0x0443, Name: "DH895XCC Series QAT Virtual Function"},
			{ID: 0x0482, Name: "82375EB/SB PCI to EISA Bridge"},
			{ID: 0x0483, Name: "82424TX/ZX [Saturn] CPU to PCI bridge"},
			{ID: 0x0484, Name: "82378ZB/IB, 82379AB (SIO, SIO.A) PCI to ISA Bridge"},
			{ID: 0x0486, Name: "82425EX/ZX [Aries] PCIset with ISA bridge"},
			{ID: 0x04a3, Name: "82434LX/NX [Mercury/Neptune] Processor to PCI bridge"},
			{ID: 0x04d0, Name: "82437FX [Triton FX]"},
			{ID: 0x0500, Name: "E8870 Processor bus control"},
			{ID: 0x0501, Name: "E8870 Memory controller"},
			{ID: 0x0502, Name: "E8870 Scalability Port 0"},
			{ID: 0x0503, Name: "E8870 Scalability Port 1"},
			{ID: 0x0510, Name: "E8870IO Hub Interface Port 0 registers (8-bit compatibility port)"},
			{ID: 0x0511, Name: "E8870IO Hub Interface Port 1 registers"},
			{ID: 0x0512, Name: "E8870IO Hub Interface Port 2 registers"},
			{ID: 0x0513, Name: "E8870IO Hub Interface Port 3 registers"},
			{ID: 0x0514, Name: "E8870IO Hub Interface Port 4 registers"},
			{ID: 0x0515, Name: "E8870IO General SIOH registers"},
			{ID: 0x0516, Name: "E8870IO RAS registers"},
			{ID: 0x0530, Name: "E8870SP Scalability Port 0 registers"},
			{ID: 0x0531, Name: "E8870SP Scalability Port 1 registers"},
			{ID: 0x0532, Name: "E8870SP Scalability Port 2 registers"},
			{ID: 0x0533, Name: "E8870SP Scalability Port 3 registers"},
			{ID: 0x0534, Name: "E8870SP Scalability Port 4 registers"},
			{ID: 0x0535, Name: "E8870SP Scalability Port 5 registers"},
			{ID: 0x0536, Name: "E8870SP Interleave registers 0 and 1"},
			{ID: 0x0537, Name: "E8870SP Interleave registers 2 and 3"},
			{ID: 0x0600, Name: "RAID Controller"},
			{ID: 0x061f, Name: "80303 I/O Processor"},
			{ID: 0x0684, Name: "H470 Chipset LPC/eSPI Controller"},
			{ID: 0x0687, Name: "Q470 Chipset LPC/eSPI Controller"},
			{ID: 0x068d, Name: "Comet Lake LPC Controller"},
			{ID: 0x06a3, Name: "Comet Lake PCH SMBus Controller"},
			{ID: 0x06a4, Name: "Comet Lake PCH SPI Controller"},
			{ID: 0x06a8, Name: "Comet Lake PCH Serial IO UART Host Controller #0"},
			{ID: 0x06a9, Name: "Comet Lake PCH Serial IO UART Host Controller #1"},
			{ID: 0x06aa, Name: "Comet Lake PCH Serial IO SPI Controller #0"},
			{ID: 0x06ab, Name: "Comet Lake PCH Serial IO SPI Controller #1"},
			{ID: 0x06ac, Name: "Comet Lake PCI Express Root Port #21"},
			{ID: 0x06b0, Name: "Comet Lake PCI Express Root Port #9"},
			{ID: 0x06bd, Name: "Comet Lake PCIe Port #6"},
			{ID: 0x06c0, Name: "Comet Lake PCI Express Root Port #17"},
			{ID: 0x06c8, Name: "Comet Lake PCH cAVS"},
			{ID: 0x06d2, Name: "Comet Lake SATA AHCI Controller"},
			{ID: 0x06d6, Name: "Comet Lake PCH-H RAID"},
			{ID: 0x06d7, Name: "Comet Lake PCH-H RAID"},
			{ID: 0x06e0, Name: "Comet Lake HECI Controller"},
			{ID: 0x06e3, Name: "Comet Lake Keyboard and Text (KT) Redirection"},
			{ID: 0x06e8, Name: "Comet Lake PCH Serial IO I2C Controller #0"},
			{ID: 0x06e9, Name: "Comet Lake PCH Serial IO I2C Controller #1"},
			{ID: 0x06ea, Name: "Comet Lake PCH Serial IO I2C Controller #2"},
			{ID: 0x06eb, Name: "Comet Lake PCH Serial IO I2C Controller #3"},
			{ID: 0x06ed, Name: "Comet Lake USB 3.1 xHCI Host Controller"},
			{ID: 0x06ef, Name: "Comet Lake PCH Shared SRAM"},
			{ID: 0x06f0, Name: "Comet Lake PCH CNVi WiFi"},
			{ID: 0x06f9, Name: "Comet Lake PCH Thermal Controller"},
			{ID: 0x06fb, Name: "Comet Lake PCH Serial IO SPI Controller #2"},
			{ID: 0x0700, Name: "CE Media Processor A/V Bridge"},
			{ID: 0x0701, Name: "CE Media Processor NAND Flash Controller"},
			{ID: 0x0703, Name: "CE Media Processor Media Control Unit 1"},
			{ID: 0x0704, Name: "CE Media Processor Video Capture Interface"},
			{ID: 0x0707, Name: "CE Media Processor SPI Slave"},
			{ID: 0x0708, Name: "Atom Processor CE 4100"},
			{ID: 0x0709, Name: "Atom Processor CE 4200"},
			{ID: 0x0800, Name: "Moorestown SPI Ctrl 0"},
			{ID: 0x0801, Name: "Moorestown SPI Ctrl 1"},
			{ID: 0x0802, Name: "Moorestown I2C 0"},
			{ID: 0x0803, Name: "Moorestown I2C 1"},
			{ID: 0x0804, Name: "Moorestown I2C 2"},
			{ID: 0x0805, Name: "Moorestown Keyboard Ctrl"},
			{ID: 0x0806, Name: "Moorestown USB Ctrl"},
			{ID: 0x0807, Name: "Moorestown SD Host Ctrl 0"},
			{ID: 0x0808, Name: "Moorestown SD Host Ctrl 1"},
			{ID: 0x0809, Name: "Moorestown NAND Ctrl"},
			{ID: 0x080a, Name: "Moorestown Audio Ctrl"},
			{ID: 0x080b, Name: "Moorestown ISP"},
			{ID: 0x080c, Name: "Moorestown Security Controller"},
			{ID: 0x080d, Name: "Moorestown External Displays"},
			{ID: 0x080e, Name: "Moorestown SCU IPC"},
			{ID: 0x080f, Name: "Moorestown GPIO Controller"},
			{ID: 0x0810, Name: "Moorestown Power Management Unit"},
			{ID: 0x0811, Name: "Moorestown OTG Ctrl"},
			{ID: 0x0812, Name: "Moorestown SPI Ctrl 2"},
			{ID: 0x0813, Name: "Moorestown SC DMA"},
			{ID: 0x0814, Name: "Moorestown LPE DMA"},
			{ID: 0x0815, Name: "Moorestown SSP0"},
			{ID: 0x0817, Name: "Medfield Serial IO I2C Controller #3"},
			{ID: 0x0818, Name: "Medfield Serial IO I2C Controller #4"},
			{ID: 0x0819, Name: "Medfield Serial IO I2C Controller #5"},
			{ID: 0x081a, Name: "Medfield GPIO Controller [Core]"},
			{ID: 0x081b, Name: "Medfield Serial IO HSUART Controller #1"},
			{ID: 0x081c, Name: "Medfield Serial IO HSUART Controller #2"},
			{ID: 0x081d, Name: "Medfield Serial IO HSUART Controller #3"},
			{ID: 0x081e, Name: "Medfield Serial IO HSUART DMA Controller"},
			{ID: 0x081f, Name: "Medfield GPIO Controller [AON]"},
			{ID: 0x0820, Name: "Medfield SD Host Controller"},
			{ID: 0x0821, Name: "Medfield SDIO Controller #1"},
			{ID: 0x0822, Name: "Medfield SDIO Controller #2"},
			{ID: 0x0823, Name: "Medfield eMMC Controller #0"},
			{ID: 0x0824, Name: "Medfield eMMC Controller #1"},
			{ID: 0x0827, Name: "Medfield Serial IO DMA Controller"},
			{ID: 0x0828, Name: "Medfield Power Management Unit"},
			{ID: 0x0829, Name: "Medfield USB Device Controller (OTG)"},
			{ID: 0x082a, Name: "Medfield SCU IPC"},
			{ID: 0x082c, Name: "Medfield Serial IO I2C Controller #0"},
			{ID: 0x082d, Name: "Medfield Serial IO I2C Controller #1"},
			{ID: 0x082e, Name: "Medfield Serial IO I2C Controller #2"},
			{ID: 0x0885, Name: "Centrino Wireless-N + WiMAX 6150"},
			{ID: 0x0886, Name: "Centrino Wireless-N + WiMAX 6150"},
			{ID: 0x0887, Name: "Centrino Wireless-N 2230"},
			{ID: 0x0888, Name: "Centrino Wireless-N 2230"},
			{ID: 0x088e, Name: "Centrino Advanced-N 6235"},
			{ID: 0x088f, Name: "Centrino Advanced-N 6235"},
			{ID: 0x0890, Name: "Centrino Wireless-N 2200"},
			{ID: 0x0891, Name: "Centrino Wireless-N 2200"},
			{ID: 0x0892, Name: "Centrino Wireless-N 135"},
			{ID: 0x0893, Name: "Centrino Wireless-N 135"},
			{ID: 0x0894, Name: "Centrino Wireless-N 105"},
			{ID: 0x0895, Name: "Centrino Wireless-N 105"},
			{ID: 0x0896, Name: "Centrino Wireless-N 130"},
			{ID: 0x0897, Name: "Centrino Wireless-N 130"},
			{ID: 0x08a7, Name: "Quark SoC X1000 SDIO / eMMC Controller"},
			{ID: 0x08ae, Name: "Centrino Wireless-N 100"},
			{ID: 0x08af, Name: "Centrino Wireless-N 100"},
			{ID: 0x08b1, Name: "Wireless 7260"},
			{ID: 0x08b2, Name: "Wireless 7260"},
			{ID: 0x08b3, Name: "Wireless 3160"},
			{ID: 0x08b4, Name: "Wireless 3160"},
			{ID: 0x08cf, Name: "Atom Processor Z2760 Integrated Graphics Controller"},
			{ID: 0x0931, Name: "Atom Processor CE 2600 [Puma 6]"},
			{ID: 0x0934, Name: "Quark SoC X1000 I2C Controller and GPIO Controller"},
			{ID: 0x0935, Name: "Quark SoC X1000 SPI Controller"},
			{ID: 0x0936, Name: "Quark SoC X1000 HS-UART"},
			{ID: 0x0937, Name: "Quark SoC X1000 10/100 Ethernet MAC"},
			{ID: 0x0939, Name: "Quark SoC X1000 USB EHCI Host Controller / USB 2.0 Device"},
			{ID: 0x093a, Name: "Quark SoC X1000 USB OHCI Host Controller"},
			{ID: 0x0953, Name: "PCIe Data Center SSD"},
			{ID: 0x0958, Name: "Quark SoC X1000 Host Bridge"},
			{ID: 0x095a, Name: "Wireless 7265"},
			{ID: 0x095b, Name: "Wireless 7265"},
			{ID: 0x095e, Name: "Quark SoC X1000 Legacy Bridge"},
			{ID: 0x0960, Name: "80960RP (i960RP) Microprocessor/Bridge"},
			{ID: 0x0962, Name: "80960RM (i960RM) Bridge"},
			{ID: 0x0964, Name: "80960RP (i960RP) Microprocessor/Bridge"},
			{ID: 0x0a03, Name: "Haswell-ULT Thermal Subsystem"},
			{ID: 0x0a04, Name: "Haswell-ULT DRAM Controller"},
			{ID: 0x0a06, Name: "Haswell-ULT Integrated Graphics Controller"},
			{ID: 0x0a0c, Name: "Haswell-ULT HD Audio Controller"},
			{ID: 0x0a16, Name: "Haswell-ULT Integrated Graphics Controller"},
			{ID: 0x0a22, Name: "Haswell-ULT Integrated Graphics Controller"},
			{ID: 0x0a26, Name: "Haswell-ULT Integrated Graphics Controller"},
			{ID: 0x0a2a, Name: "Haswell-ULT Integrated Graphics Controller"},
			{ID: 0x0a2e, Name: "Haswell-ULT Integrated Graphics Controller"},
			{ID: 0x0a53, Name: "DC P3520 SSD"},
			{ID: 0x0a54, Name: "NVMe Datacenter SSD [3DNAND, Beta Rock Controller]"},
			{ID: 0x0a55, Name: "NVMe DC SSD [3DNAND, Beta Rock Controller]"},
			{ID: 0x0b26, Name: "Thunderbolt 4 Bridge [Goshen Ridge 2020]"},
			{ID: 0x0b27, Name: "Thunderbolt 4 USB Controller [Goshen Ridge 2020]"},
			{ID: 0x0b60, Name: "NVMe DC SSD [3DNAND, Sentinel Rock Controller]"},
			{ID: 0x0bd0, Name: "Ponte Vecchio 2T"},
			{ID: 0x0bd5, Name: "Ponte Vecchio 1T"},
			{ID: 0x0be0, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be1, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be2, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be3, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be4, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be5, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be6, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be7, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be8, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0be9, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0bea, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0beb, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0bec, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0bed, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0bee, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0bef, Name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller"},
			{ID: 0x0bf0, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0bf1, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0bf2, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0bf3, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0bf4, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0bf5, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0bf6, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0bf7, Name: "Atom Processor D2xxx/N2xxx DRAM Controller"},
			{ID: 0x0c00, Name: "4th Gen Core Processor DRAM Controller"},
			{ID: 0x0c01, Name: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x16 Controller"},
			{ID: 0x0c04, Name: "Xeon E3-1200 v3/4th Gen Core Processor DRAM Controller"},
			{ID: 0x0c05, Name: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x8 Controller"},
			{ID: 0x0c08, Name: "Xeon E3-1200 v3 Processor DRAM Controller"},
			{ID: 0x0c09, Name: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x4 Controller"},
			{ID: 0x0c0c, Name: "Xeon E3-1200 v3/4th Gen Core Processor HD Audio Controller"},
			{ID: 0x0c40, Name: "Atom Processor CE 5300"},
			{ID: 0x0c46, Name: "Atom Processor S1200 PCI Express Root Port 1"},
			{ID: 0x0c47, Name: "Atom Processor S1200 PCI Express Root Port 2"},
			{ID: 0x0c48, Name: "Atom Processor S1200 PCI Express Root Port 3"},
			{ID: 0x0c49, Name: "Atom Processor S1200 PCI Express Root Port 4"},
			{ID: 0x0c4e, Name: "Atom Processor S1200 NTB Primary"},
			{ID: 0x0c50, Name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device"},
			{ID: 0x0c51, Name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device"},
			{ID: 0x0c52, Name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device"},
			{ID: 0x0c53, Name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device"},
			{ID: 0x0c54, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c55, Name: "Atom Processor S1200 DFX 1"},
			{ID: 0x0c56, Name: "Atom Processor S1200 DFX 2"},
			{ID: 0x0c59, Name: "Atom Processor S1200 SMBus 2.0 Controller 0"},
			{ID: 0x0c5a, Name: "Atom Processor S1200 SMBus 2.0 Controller 1"},
			{ID: 0x0c5b, Name: "Atom Processor S1200 SMBus Controller 2"},
			{ID: 0x0c5c, Name: "Atom Processor S1200 SMBus Controller 3"},
			{ID: 0x0c5d, Name: "Atom Processor S1200 SMBus Controller 4"},
			{ID: 0x0c5e, Name: "Atom Processor S1200 SMBus Controller 5"},
			{ID: 0x0c5f, Name: "Atom Processor S1200 UART"},
			{ID: 0x0c60, Name: "Atom Processor S1200 Integrated Legacy Bus"},
			{ID: 0x0c70, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c71, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c72, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c73, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c74, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c75, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c76, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c77, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c78, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c79, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c7a, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c7b, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c7c, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c7d, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c7e, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0c7f, Name: "Atom Processor S1200 Internal"},
			{ID: 0x0cf8, Name: "Ethernet Controller X710 Intel(R) FPGA Programmable Acceleration Card N3000 for Networking"},
			{ID: 0x0d00, Name: "Crystal Well DRAM Controller"},
			{ID: 0x0d01, Name: "Crystal Well PCI Express x16 Controller"},
			{ID: 0x0d04, Name: "Crystal Well DRAM Controller"},
			{ID: 0x0d05, Name: "Crystal Well PCI Express x8 Controller"},
			{ID: 0x0d09, Name: "Crystal Well PCI Express x4 Controller"},
			{ID: 0x0d0c, Name: "Crystal Well HD Audio Controller"},
			{ID: 0x0d16, Name: "Crystal Well Integrated Graphics Controller"},
			{ID: 0x0d26, Name: "Crystal Well Integrated Graphics Controller"},
			{ID: 0x0d36, Name: "Crystal Well Integrated Graphics Controller"},
			{ID: 0x0d4c, Name: "Ethernet Connection (11) I219-LM"},
			{ID: 0x0d4d, Name: "Ethernet Connection (11) I219-V"},
			{ID: 0x0d4e, Name: "Ethernet Connection (10) I219-LM"},
			{ID: 0x0d4f, Name: "Ethernet Connection (10) I219-V"},
			{ID: 0x0d53, Name: "Ethernet Connection (12) I219-LM"},
			{ID: 0x0d55, Name: "Ethernet Connection (12) I219-V"},
			{ID: 0x0d58, Name: "Ethernet Controller XXV710 Intel(R) FPGA Programmable Acceleration Card N3000 for Networking"},
			{ID: 0x0d9f, Name: "Ethernet Controller (2) I225-IT"},
			{ID: 0x0dd2, Name: "Ethernet Network Adapter I710"},
			{ID: 0x0e00, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DMI2"},
			{ID: 0x0e01, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port in DMI2 Mode"},
			{ID: 0x0e02, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 1a"},
			{ID: 0x0e03, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 1b"},
			{ID: 0x0e04, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2a"},
			{ID: 0x0e05, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2b"},
			{ID: 0x0e06, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2c"},
			{ID: 0x0e07, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2d"},
			{ID: 0x0e08, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3a"},
			{ID: 0x0e09, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3b"},
			{ID: 0x0e0a, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3c"},
			{ID: 0x0e0b, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3d"},
			{ID: 0x0e10, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers"},
			{ID: 0x0e13, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers"},
			{ID: 0x0e17, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers"},
			{ID: 0x0e18, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers"},
			{ID: 0x0e1c, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers"},
			{ID: 0x0e1d, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe"},
			{ID: 0x0e1e, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers"},
			{ID: 0x0e1f, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers"},
			{ID: 0x0e20, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 0"},
			{ID: 0x0e21, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 1"},
			{ID: 0x0e22, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 2"},
			{ID: 0x0e23, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 3"},
			{ID: 0x0e24, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 4"},
			{ID: 0x0e25, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 5"},
			{ID: 0x0e26, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 6"},
			{ID: 0x0e27, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 7"},
			{ID: 0x0e28, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 VTd/Memory Map/Misc"},
			{ID: 0x0e29, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Memory Hotplug"},
			{ID: 0x0e2a, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO RAS"},
			{ID: 0x0e2c, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 IOAPIC"},
			{ID: 0x0e2e, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 CBDMA"},
			{ID: 0x0e2f, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 CBDMA"},
			{ID: 0x0e30, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 0"},
			{ID: 0x0e32, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 0"},
			{ID: 0x0e33, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1"},
			{ID: 0x0e34, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe"},
			{ID: 0x0e36, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring"},
			{ID: 0x0e37, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring"},
			{ID: 0x0e38, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 1"},
			{ID: 0x0e3a, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 2"},
			{ID: 0x0e3e, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring"},
			{ID: 0x0e3f, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring"},
			{ID: 0x0e40, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 2"},
			{ID: 0x0e41, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers"},
			{ID: 0x0e43, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 2"},
			{ID: 0x0e44, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 2"},
			{ID: 0x0e45, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register"},
			{ID: 0x0e47, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register"},
			{ID: 0x0e60, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 1"},
			{ID: 0x0e68, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Target Address/Thermal Registers"},
			{ID: 0x0e6a, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers"},
			{ID: 0x0e6b, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers"},
			{ID: 0x0e6c, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers"},
			{ID: 0x0e6d, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers"},
			{ID: 0x0e71, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 RAS Registers"},
			{ID: 0x0e74, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe"},
			{ID: 0x0e75, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe"},
			{ID: 0x0e77, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers"},
			{ID: 0x0e79, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 RAS Registers"},
			{ID: 0x0e7d, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers"},
			{ID: 0x0e7f, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers"},
			{ID: 0x0e80, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 0"},
			{ID: 0x0e81, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers"},
			{ID: 0x0e83, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 0"},
			{ID: 0x0e84, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 0"},
			{ID: 0x0e85, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register"},
			{ID: 0x0e87, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Registers"},
			{ID: 0x0e90, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1"},
			{ID: 0x0e93, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1"},
			{ID: 0x0e94, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 1"},
			{ID: 0x0e95, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register"},
			{ID: 0x0ea0, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 0"},
			{ID: 0x0ea8, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Target Address/Thermal Registers"},
			{ID: 0x0eaa, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers"},
			{ID: 0x0eab, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers"},
			{ID: 0x0eac, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers"},
			{ID: 0x0ead, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers"},
			{ID: 0x0eae, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers"},
			{ID: 0x0eaf, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers"},
			{ID: 0x0eb0, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 0"},
			{ID: 0x0eb1, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 1"},
			{ID: 0x0eb2, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 0"},
			{ID: 0x0eb3, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 1"},
			{ID: 0x0eb4, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 2"},
			{ID: 0x0eb5, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 3"},
			{ID: 0x0eb6, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 2"},
			{ID: 0x0eb7, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 3"},
			{ID: 0x0ebc, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers"},
			{ID: 0x0ebe, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers"},
			{ID: 0x0ebf, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers"},
			{ID: 0x0ec0, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 0"},
			{ID: 0x0ec1, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 1"},
			{ID: 0x0ec2, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 2"},
			{ID: 0x0ec3, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 3"},
			{ID: 0x0ec4, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 4"},
			{ID: 0x0ec8, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 System Address Decoder"},
			{ID: 0x0ec9, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Broadcast Registers"},
			{ID: 0x0eca, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Broadcast Registers"},
			{ID: 0x0ed8, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0ed9, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0edc, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0edd, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0ede, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0edf, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0ee0, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee1, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee2, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee3, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee4, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee5, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee6, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee7, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee8, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ee9, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0eea, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0eeb, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0eec, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0eed, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0eee, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers"},
			{ID: 0x0ef0, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 0"},
			{ID: 0x0ef1, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 1"},
			{ID: 0x0ef2, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 0"},
			{ID: 0x0ef3, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 1"},
			{ID: 0x0ef4, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 2"},
			{ID: 0x0ef5, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 3"},
			{ID: 0x0ef6, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 2"},
			{ID: 0x0ef7, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 3"},
			{ID: 0x0ef8, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0ef9, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0efa, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0efb, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0efc, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0efd, Name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO"},
			{ID: 0x0f00, Name: "Atom Processor Z36xxx/Z37xxx Series SoC Transaction Register"},
			{ID: 0x0f04, Name: "Atom Processor Z36xxx/Z37xxx Series High Definition Audio Controller"},
			{ID: 0x0f06, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 DMA Controller"},
			{ID: 0x0f08, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 PWM Controller"},
			{ID: 0x0f09, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 PWM Controller"},
			{ID: 0x0f0a, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 HSUART Controller #1"},
			{ID: 0x0f0c, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 HSUART Controller #2"},
			{ID: 0x0f0e, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 SPI Controller"},
			{ID: 0x0f12, Name: "Atom Processor E3800/CE2700 Series SMBus Controller"},
			{ID: 0x0f14, Name: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller"},
			{ID: 0x0f15, Name: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller"},
			{ID: 0x0f16, Name: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller"},
			{ID: 0x0f18, Name: "Atom Processor Z36xxx/Z37xxx Series Trusted Execution Engine"},
			{ID: 0x0f1c, Name: "Atom Processor Z36xxx/Z37xxx Series Power Control Unit"},
			{ID: 0x0f20, Name: "Atom Processor E3800 Series SATA IDE Controller"},
			{ID: 0x0f21, Name: "Atom Processor E3800 Series SATA IDE Controller"},
			{ID: 0x0f22, Name: "Atom Processor E3800 Series SATA AHCI Controller"},
			{ID: 0x0f23, Name: "Atom Processor E3800 Series SATA AHCI Controller"},
			{ID: 0x0f28, Name: "Atom Processor Z36xxx/Z37xxx Series LPE Audio Controller"},
			{ID: 0x0f31, Name: "Atom Processor Z36xxx/Z37xxx Series Graphics & Display"},
			{ID: 0x0f34, Name: "Atom Processor Z36xxx/Z37xxx Series USB EHCI"},
			{ID: 0x0f35, Name: "Atom Processor Z36xxx/Z37xxx, Celeron N2000 Series USB xHCI"},
			{ID: 0x0f37, Name: "Atom Processor Z36xxx/Z37xxx Series OTG USB Device"},
			{ID: 0x0f38, Name: "Atom Processor Z36xxx/Z37xxx Series Camera ISP"},
			{ID: 0x0f40, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 DMA Controller"},
			{ID: 0x0f41, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #1"},
			{ID: 0x0f42, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #2"},
			{ID: 0x0f43, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #3"},
			{ID: 0x0f44, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #4"},
			{ID: 0x0f45, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #5"},
			{ID: 0x0f46, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #6"},
			{ID: 0x0f47, Name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #7"},
			{ID: 0x0f48, Name: "Atom Processor E3800 Series PCI Express Root Port 1"},
			{ID: 0x0f4a, Name: "Atom Processor E3800 Series PCI Express Root Port 2"},
			{ID: 0x0f4c, Name: "Atom Processor E3800 Series PCI Express Root Port 3"},
			{ID: 0x0f4e, Name: "Atom Processor E3800 Series PCI Express Root Port 4"},
			{ID: 0x0f50, Name: "Atom Processor E3800 Series eMMC 4.5 Controller"},
			{ID: 0x1000, Name: "82542 Gigabit Ethernet Controller (Fiber)"},
			{ID: 0x1001, Name: "82543GC Gigabit Ethernet Controller (Fiber)"},
			{ID: 0x1002, Name: "Pro 100 LAN+Modem 56 Cardbus II"},
			{ID: 0x1004, Name: "82543GC Gigabit Ethernet Controller (Copper)"},
			{ID: 0x1008, Name: "82544EI Gigabit Ethernet Controller (Copper)"},
			{ID: 0x1009, Name: "82544EI Gigabit Ethernet Controller (Fiber)"},
			{ID: 0x100a, Name: "82540EM Gigabit Ethernet Controller"},
			{ID: 0x100c, Name: "82544GC Gigabit Ethernet Controller (Copper)"},
			{ID: 0x100d, Name: "82544GC Gigabit Ethernet Controller (LOM)"},
			{ID: 0x100e, Name: "82540EM Gigabit Ethernet Controller"},
			{ID: 0x100f, Name: "82545EM Gigabit Ethernet Controller (Copper)"},
			{ID: 0x1010, Name: "82546EB Gigabit Ethernet Controller (Copper)"},
			{ID: 0x1011, Name: "82545EM Gigabit Ethernet Controller (Fiber)"},
			{ID: 0x1012, Name: "82546EB Gigabit Ethernet Controller (Fiber)"},
			{ID: 0x1013, Name: "82541EI Gigabit Ethernet Controller"},
			{ID: 0x1014, Name: "82541ER Gigabit Ethernet Controller"},
			{ID: 0x1015, Name: "82540EM Gigabit Ethernet Controller (LOM)"},
			{ID: 0x1016, Name: "82540EP Gigabit Ethernet Controller (Mobile)"},
			{ID: 0x1017, Name: "82540EP Gigabit Ethernet Controller"},
			{ID: 0x1018, Name: "82541EI Gigabit Ethernet Controller"},
			{ID: 0x1019, Name: "82547EI Gigabit Ethernet Controller"},
			{ID: 0x101a, Name: "82547EI Gigabit Ethernet Controller (Mobile)"},
			{ID: 0x101d, Name: "82546EB Gigabit Ethernet Controller"},
			{ID: 0x101e, Name: "82540EP Gigabit Ethernet Controller (Mobile)"},
			{ID: 0x101f, Name: "Ethernet Controller V710 for 5GBASE-T"},
			{ID: 0x1026, Name: "82545GM Gigabit Ethernet Controller"},
			{ID: 0x1027, Name: "82545GM Gigabit Ethernet Controller"},
			{ID: 0x1028, Name: "82545GM Gigabit Ethernet Controller"},
			{ID: 0x1029, Name: "82559 Ethernet Controller"},
			{ID: 0x1030, Name: "82559 InBusiness 10/100"},
			{ID: 0x1031, Name: "82801CAM (ICH3) PRO/100 VE (LOM) Ethernet Controller"},
			{ID: 0x1032, Name: "82801CAM (ICH3) PRO/100 VE Ethernet Controller"},
			{ID: 0x1033, Name: "82801CAM (ICH3) PRO/100 VM (LOM) Ethernet Controller"},
			{ID: 0x1034, Name: "82801CAM (ICH3) PRO/100 VM Ethernet Controller"},
			{ID: 0x1035, Name: "82801CAM (ICH3)/82562EH (LOM) Ethernet Controller"},
			{ID: 0x1036, Name: "82801CAM (ICH3) 82562EH Ethernet Controller"},
			{ID: 0x1037, Name: "82801CAM (ICH3) Chipset Ethernet Controller"},
			{ID: 0x1038, Name: "82801CAM (ICH3) PRO/100 VM (KM) Ethernet Controller"},
			{ID: 0x1039, Name: "82801DB PRO/100 VE (LOM) Ethernet Controller"},
			{ID: 0x103a, Name: "82801DB PRO/100 VE (CNR) Ethernet Controller"},
			{ID: 0x103b, Name: "82801DB PRO/100 VM (LOM) Ethernet Controller"},
			{ID: 0x103c, Name: "82801DB PRO/100 VM (CNR) Ethernet Controller"},
			{ID: 0x103d, Name: "82801DB PRO/100 VE (MOB) Ethernet Controller"},
			{ID: 0x103e, Name: "82801DB PRO/100 VM (MOB) Ethernet Controller"},
			{ID: 0x1040, Name: "536EP Data Fax Modem"},
			{ID: 0x1043, Name: "PRO/Wireless LAN 2100 3B Mini PCI Adapter"},
			{ID: 0x1048, Name: "82597EX 10GbE Ethernet Controller"},
			{ID: 0x1049, Name: "82566MM Gigabit Network Connection"},
			{ID: 0x104a, Name: "82566DM Gigabit Network Connection"},
			{ID: 0x104b, Name: "82566DC Gigabit Network Connection"},
			{ID: 0x104c, Name: "82562V 10/100 Network Connection"},
			{ID: 0x104d, Name: "82566MC Gigabit Network Connection"},
			{ID: 0x104e, Name: "Ethernet Controller X710 for 10 Gigabit SFP+"},
			{ID: 0x104f, Name: "Ethernet Controller X710 for 10 Gigabit backplane"},
			{ID: 0x1050, Name: "82562EZ 10/100 Ethernet Controller"},
			{ID: 0x1051, Name: "82801EB/ER (ICH5/ICH5R) integrated LAN Controller"},
			{ID: 0x1052, Name: "PRO/100 VM Network Connection"},
			{ID: 0x1053, Name: "PRO/100 VM Network Connection"},
			{ID: 0x1054, Name: "PRO/100 VE Network Connection"},
			{ID: 0x1055, Name: "PRO/100 VM Network Connection"},
			{ID: 0x1056, Name: "PRO/100 VE Network Connection"},
			{ID: 0x1057, Name: "PRO/100 VE Network Connection"},
			{ID: 0x1059, Name: "82551QM Ethernet Controller"},
			{ID: 0x105b, Name: "82546GB Gigabit Ethernet Controller (Copper)"},
			{ID: 0x105e, Name: "82571EB/82571GB Gigabit Ethernet Controller D0/D1 (copper applications)"},
			{ID: 0x105f, Name: "82571EB Gigabit Ethernet Controller"},
			{ID: 0x1060, Name: "82571EB Gigabit Ethernet Controller"},
			{ID: 0x1064, Name: "82562ET/EZ/GT/GZ - PRO/100 VE (LOM) Ethernet Controller"},
			{ID: 0x1065, Name: "82562ET/EZ/GT/GZ - PRO/100 VE Ethernet Controller"},
			{ID: 0x1066, Name: "82562 EM/EX/GX - PRO/100 VM (LOM) Ethernet Controller"},
			{ID: 0x1067, Name: "82562 EM/EX/GX - PRO/100 VM Ethernet Controller"},
			{ID: 0x1068, Name: "82562ET/EZ/GT/GZ - PRO/100 VE (LOM) Ethernet Controller Mobile"},
			{ID: 0x1069, Name: "82562EM/EX/GX - PRO/100 VM (LOM) Ethernet Controller Mobile"},
			{ID: 0x106a, Name: "82562G - PRO/100 VE (LOM) Ethernet Controller"},
			{ID: 0x106b, Name: "82562G - PRO/100 VE Ethernet Controller Mobile"},
			{ID: 0x1075, Name: "82547GI Gigabit Ethernet Controller"},
			{ID: 0x1076, Name: "82541GI Gigabit Ethernet Controller"},
			{ID: 0x1077, Name: "82541GI Gigabit Ethernet Controller"},
			{ID: 0x1078, Name: "82541ER Gigabit Ethernet Controller"},
			{ID: 0x1079, Name: "82546GB Gigabit Ethernet Controller"},
			{ID: 0x107a, Name: "82546GB Gigabit Ethernet Controller"},
			{ID: 0x107b, Name: "82546GB Gigabit Ethernet Controller"},
			{ID: 0x107c, Name: "82541PI Gigabit Ethernet Controller"},
			{ID: 0x107d, Name: "82572EI Gigabit Ethernet Controller (Copper)"},
			{ID: 0x107e, Name: "82572EI Gigabit Ethernet Controller (Fiber)"},
			{ID: 0x107f, Name: "82572EI Gigabit Ethernet Controller"},
			{ID: 0x1080, Name: "FA82537EP 56K V.92 Data/Fax Modem PCI"},
			{ID: 0x1081, Name: "631xESB/632xESB LAN Controller Copper"},
			{ID: 0x1082, Name: "631xESB/632xESB LAN Controller fiber"},
			{ID: 0x1083, Name: "631xESB/632xESB LAN Controller SERDES"},
			{ID: 0x1084, Name: "631xESB/632xESB IDE Redirection"},
			{ID: 0x1085, Name: "631xESB/632xESB Serial Port Redirection"},
			{ID: 0x1086, Name: "631xESB/632xESB IPMI/KCS0"},
			{ID: 0x1087, Name: "631xESB/632xESB UHCI Redirection"},
			{ID: 0x1089, Name: "631xESB/632xESB BT"},
			{ID: 0x108a, Name: "82546GB Gigabit Ethernet Controller"},
			{ID: 0x108b, Name: "82573V Gigabit Ethernet Controller (Copper)"},
			{ID: 0x108c, Name: "82573E Gigabit Ethernet Controller (Copper)"},
			{ID: 0x108e, Name: "82573E KCS (Active Management)"},
			{ID: 0x108f, Name: "Active Management Technology - SOL"},
			{ID: 0x1091, Name: "PRO/100 VM Network Connection"},
			{ID: 0x1092, Name: "PRO/100 VE Network Connection"},
			{ID: 0x1093, Name: "PRO/100 VM Network Connection"},
			{ID: 0x1094, Name: "PRO/100 VE Network Connection"},
			{ID: 0x1095, Name: "PRO/100 VE Network Connection"},
			{ID: 0x1096, Name: "80003ES2LAN Gigabit Ethernet Controller (Copper)"},
			{ID: 0x1097, Name: "631xESB/632xESB DPT LAN Controller (Fiber)"},
			{ID: 0x1098, Name: "80003ES2LAN Gigabit Ethernet Controller (Serdes)"},
			{ID: 0x1099, Name: "82546GB Gigabit Ethernet Controller (Copper)"},
			{ID: 0x109a, Name: "82573L Gigabit Ethernet Controller"},
			{ID: 0x109b, Name: "82546GB PRO/1000 GF Quad Port Server Adapter"},
			{ID: 0x109e, Name: "82597EX 10GbE Ethernet Controller"},
			{ID: 0x10a0, Name: "82571EB PRO/1000 AT Quad Port Bypass Adapter"},
			{ID: 0x10a1, Name: "82571EB PRO/1000 AF Quad Port Bypass Adapter"},
			{ID: 0x10a4, Name: "82571EB Gigabit Ethernet Controller"},
			{ID: 0x10a5, Name: "82571EB Gigabit Ethernet Controller (Fiber)"},
			{ID: 0x10a6, Name: "82599EB 10-Gigabit Dummy Function"},
			{ID: 0x10a7, Name: "82575EB Gigabit Network Connection"},
			{ID: 0x10a9, Name: "82575EB Gigabit Backplane Connection"},
			{ID: 0x10b0, Name: "82573L PRO/1000 PL Network Connection"},
			{ID: 0x10b2, Name: "82573V PRO/1000 PM Network Connection"},
			{ID: 0x10b3, Name: "82573E PRO/1000 PM Network Connection"},
			{ID: 0x10b4, Name: "82573L PRO/1000 PL Network Connection"},
			{ID: 0x10b5, Name: "82546GB Gigabit Ethernet Controller (Copper)"},
			{ID: 0x10b6, Name: "82598 10GbE PCI-Express Ethernet Controller"},
			{ID: 0x10b9, Name: "82572EI Gigabit Ethernet Controller (Copper)"},
			{ID: 0x10ba, Name: "80003ES2LAN Gigabit Ethernet Controller (Copper)"},
			{ID: 0x10bb, Name: "80003ES2LAN Gigabit Ethernet Controller (Serdes)"},
			{ID: 0x10bc, Name: "82571EB/82571GB Gigabit Ethernet Controller (Copper)"},
			{ID: 0x10bd, Name: "82566DM-2 Gigabit Network Connection"},
			{ID: 0x10bf, Name: "82567LF Gigabit Network Connection"},
			{ID: 0x10c0, Name: "82562V-2 10/100 Network Connection"},
			{ID: 0x10c2, Name: "82562G-2 10/100 Network Connection"},
			{ID: 0x10c3, Name: "82562GT-2 10/100 Network Connection"},
			{ID: 0x10c4, Name: "82562GT 10/100 Network Connection"},
			{ID: 0x10c5, Name: "82562G 10/100 Network Connection"},
			{ID: 0x10c6, Name: "82598EB 10-Gigabit AF Dual Port Network Connection"},
			{ID: 0x10c7, Name: "82598EB 10-Gigabit AF Network Connection"},
			{ID: 0x10c8, Name: "82598EB 10-Gigabit AT Network Connection"},
			{ID: 0x10c9, Name: "82576 Gigabit Network Connection"},
			{ID: 0x10ca, Name: "82576 Virtual Function"},
			{ID: 0x10cb, Name: "82567V Gigabit Network Connection"},
			{ID: 0x10cc, Name: "82567LM-2 Gigabit Network Connection"},
			{ID: 0x10cd, Name: "82567LF-2 Gigabit Network Connection"},
			{ID: 0x10ce, Name: "82567V-2 Gigabit Network Connection"},
			{ID: 0x10d3, Name: "82574L Gigabit Network Connection"},
			{ID: 0x10d4, Name: "Matrox Concord GE (customized Intel 82574)"},
			{ID: 0x10d5, Name: "82571PT Gigabit PT Quad Port Server ExpressModule"},
			{ID: 0x10d6, Name: "82575GB Gigabit Network Connection"},
			{ID: 0x10d8, Name: "82599EB 10 Gigabit Unprogrammed"},
			{ID: 0x10d9, Name: "82571EB Dual Port Gigabit Mezzanine Adapter"},
			{ID: 0x10da, Name: "82571EB Quad Port Gigabit Mezzanine Adapter"},
			{ID: 0x10db, Name: "82598EB 10-Gigabit Dual Port Network Connection"},
			{ID: 0x10dd, Name: "82598EB 10-Gigabit AT CX4 Network Connection"},
			{ID: 0x10de, Name: "82567LM-3 Gigabit Network Connection"},
			{ID: 0x10df, Name: "82567LF-3 Gigabit Network Connection"},
			{ID: 0x10e1, Name: "82598EB 10-Gigabit AF Dual Port Network Connection"},
			{ID: 0x10e2, Name: "82575GB Gigabit Network Connection"},
			{ID: 0x10e5, Name: "82567LM-4 Gigabit Network Connection"},
			{ID: 0x10e6, Name: "82576 Gigabit Network Connection"},
			{ID: 0x10e7, Name: "82576 Gigabit Network Connection"},
			{ID: 0x10e8, Name: "82576 Gigabit Network Connection"},
			{ID: 0x10ea, Name: "82577LM Gigabit Network Connection"},
			{ID: 0x10eb, Name: "82577LC Gigabit Network Connection"},
			{ID: 0x10ec, Name: "82598EB 10-Gigabit AT CX4 Network Connection"},
			{ID: 0x10ed, Name: "82599 Ethernet Controller Virtual Function"},
			{ID: 0x10ef, Name: "82578DM Gigabit Network Connection"},
			{ID: 0x10f0, Name: "82578DC Gigabit Network Connection"},
			{ID: 0x10f1, Name: "82598EB 10-Gigabit AF Dual Port Network Connection"},
			{ID: 0x10f4, Name: "82598EB 10-Gigabit AF Network Connection"},
			{ID: 0x10f5, Name: "82567LM Gigabit Network Connection"},
			{ID: 0x10f6, Name: "82574L Gigabit Network Connection"},
			{ID: 0x10f7, Name: "10 Gigabit BR KX4 Dual Port Network Connection"},
			{ID: 0x10f8, Name: "82599 10 Gigabit Dual Port Backplane Connection"},
			{ID: 0x10f9, Name: "82599 10 Gigabit Dual Port Network Connection"},
			{ID: 0x10fb, Name: "82599ES 10-Gigabit SFI/SFP+ Network Connection"},
			{ID: 0x10fc, Name: "82599 10 Gigabit Dual Port Network Connection"},
			{ID: 0x10fe, Name: "82552 10/100 Network Connection"},
			{ID: 0x1107, Name: "PRO/1000 MF Server Adapter (LX)"},
			{ID: 0x1130, Name: "82815 815 Chipset Host Bridge and Memory Controller Hub"},
			{ID: 0x1131, Name: "82815 815 Chipset AGP Bridge"},
			{ID: 0x1132, Name: "82815 Chipset Graphics Controller (CGC)"},
			{ID: 0x1136, Name: "Thunderbolt 4 Bridge [Maple Ridge 4C 2020]"},
			{ID: 0x1137, Name: "Thunderbolt 4 NHI [Maple Ridge 4C 2020]"},
			{ID: 0x1138, Name: "Thunderbolt 4 USB Controller [Maple Ridge 4C 2020]"},
			{ID: 0x1161, Name: "82806AA PCI64 Hub Advanced Programmable Interrupt Controller"},
			{ID: 0x1162, Name: "Xscale 80200 Big Endian Companion Chip"},
			{ID: 0x1190, Name: "Merrifield SD/SDIO/eMMC Controller"},
			{ID: 0x1191, Name: "Merrifield Serial IO HSUART Controller"},
			{ID: 0x1192, Name: "Merrifield Serial IO HSUART DMA Controller"},
			{ID: 0x1194, Name: "Merrifield Serial IO SPI Controller"},
			{ID: 0x1195, Name: "Merrifield Serial IO I2C Controller"},
			{ID: 0x1196, Name: "Merrifield Serial IO I2C Controller"},
			{ID: 0x1199, Name: "Merrifield GPIO Controller"},
			{ID: 0x119e, Name: "Merrifield USB Device Controller (OTG)"},
			{ID: 0x11a0, Name: "Merrifield SCU IPC"},
			{ID: 0x11a1, Name: "Merrifield Power Management Unit"},
			{ID: 0x11a2, Name: "Merrifield Serial IO DMA Controller"},
			{ID: 0x11a5, Name: "Merrifield Serial IO PWM Controller"},
			{ID: 0x11c3, Name: "Quark SoC X1000 PCIe Root Port 0"},
			{ID: 0x11c4, Name: "Quark SoC X1000 PCIe Root Port 1"},
			{ID: 0x1200, Name: "IXP1200 Network Processor"},
			{ID: 0x1209, Name: "8255xER/82551IT Fast Ethernet Controller"},
			{ID: 0x1221, Name: "82092AA PCI to PCMCIA Bridge"},
			{ID: 0x1222, Name: "82092AA IDE Controller"},
			{ID: 0x1223, Name: "SAA7116"},
			{ID: 0x1225, Name: "82452KX/GX [Orion]"},
			{ID: 0x1226, Name: "82596 PRO/10 PCI"},
			{ID: 0x1227, Name: "82865 EtherExpress PRO/100A"},
			{ID: 0x1228, Name: "82556 EtherExpress PRO/100 Smart"},
			{ID: 0x1229, Name: "82557/8/9/0/1 Ethernet Pro 100"},
			{ID: 0x122d, Name: "430FX - 82437FX TSC [Triton I]"},
			{ID: 0x122e, Name: "82371FB PIIX ISA [Triton I]"},
			{ID: 0x1230, Name: "82371FB PIIX IDE [Triton I]"},
			{ID: 0x1231, Name: "DSVD Modem"},
			{ID: 0x1234, Name: "430MX - 82371MX Mobile PCI I/O IDE Xcelerator (MPIIX)"},
			{ID: 0x1235, Name: "430MX - 82437MX Mob. System Ctrlr (MTSC) & 82438MX Data Path (MTDP)"},
			{ID: 0x1237, Name: "440FX - 82441FX PMC [Natoma]"},
			{ID: 0x1239, Name: "82371FB PIIX IDE Interface"},
			{ID: 0x123b, Name: "82380PB PCI to PCI Docking Bridge"},
			{ID: 0x123c, Name: "82380AB (MISA) Mobile PCI-to-ISA Bridge"},
			{ID: 0x123d, Name: "683053 Programmable Interrupt Device"},
			{ID: 0x123e, Name: "82466GX (IHPC) Integrated Hot-Plug Controller (hidden mode)"},
			{ID: 0x123f, Name: "82466GX Integrated Hot-Plug Controller (IHPC)"},
			{ID: 0x1240, Name: "82752 (752) AGP Graphics Accelerator"},
			{ID: 0x124b, Name: "82380FB (MPCI2) Mobile Docking Controller"},
			{ID: 0x124c, Name: "Ethernet Connection E823-L for backplane"},
			{ID: 0x124d, Name: "Ethernet Connection E823-L for SFP"},
			{ID: 0x124e, Name: "Ethernet Connection E823-L/X557-AT 10GBASE-T"},
			{ID: 0x124f, Name: "Ethernet Connection E823-L 1GbE"},
			{ID: 0x1250, Name: "430HX - 82439HX TXC [Triton II]"},
			{ID: 0x1360, Name: "82806AA PCI64 Hub PCI Bridge"},
			{ID: 0x1361, Name: "82806AA PCI64 Hub Controller (HRes)"},
			{ID: 0x1460, Name: "82870P2 P64H2 Hub PCI Bridge"},
			{ID: 0x1461, Name: "82870P2 P64H2 I/OxAPIC"},
			{ID: 0x1462, Name: "82870P2 P64H2 Hot Plug Controller"},
			{ID: 0x1501, Name: "82567V-3 Gigabit Network Connection"},
			{ID: 0x1502, Name: "82579LM Gigabit Network Connection (Lewisville)"},
			{ID: 0x1503, Name: "82579V Gigabit Network Connection"},
			{ID: 0x1507, Name: "Ethernet Express Module X520-P2"},
			{ID: 0x1508, Name: "82598EB Gigabit BX Network Connection"},
			{ID: 0x1509, Name: "82580 Gigabit Network Connection"},
			{ID: 0x150a, Name: "82576NS Gigabit Network Connection"},
			{ID: 0x150b, Name: "82598EB 10-Gigabit AT2 Server Adapter"},
			{ID: 0x150c, Name: "82583V Gigabit Network Connection"},
			{ID: 0x150d, Name: "82576 Gigabit Backplane Connection"},
			{ID: 0x150e, Name: "82580 Gigabit Network Connection"},
			{ID: 0x150f, Name: "82580 Gigabit Fiber Network Connection"},
			{ID: 0x1510, Name: "82580 Gigabit Backplane Connection"},
			{ID: 0x1511, Name: "82580 Gigabit SFP Connection"},
			{ID: 0x1513, Name: "CV82524 Thunderbolt Controller [Light Ridge 4C 2010]"},
			{ID: 0x1514, Name: "Ethernet X520 10GbE Dual Port KX4 Mezz"},
			{ID: 0x1515, Name: "X540 Ethernet Controller Virtual Function"},
			{ID: 0x1516, Name: "82580 Gigabit Network Connection"},
			{ID: 0x1517, Name: "82599ES 10 Gigabit Network Connection"},
			{ID: 0x1518, Name: "82576NS SerDes Gigabit Network Connection"},
			{ID: 0x151a, Name: "DSL2310 Thunderbolt Controller [Eagle Ridge 2C 2011]"},
			{ID: 0x151b, Name: "CVL2510 Thunderbolt Controller [Light Peak 2C 2010]"},
			{ID: 0x151c, Name: "82599 10 Gigabit TN Network Connection"},
			{ID: 0x151d, Name: "Ethernet Connection E823-L for QSFP"},
			{ID: 0x1520, Name: "I350 Ethernet Controller Virtual Function"},
			{ID: 0x1521, Name: "I350 Gigabit Network Connection"},
			{ID: 0x1522, Name: "I350 Gigabit Fiber Network Connection"},
			{ID: 0x1523, Name: "I350 Gigabit Backplane Connection"},
			{ID: 0x1524, Name: "I350 Gigabit Connection"},
			{ID: 0x1525, Name: "82567V-4 Gigabit Network Connection"},
			{ID: 0x1526, Name: "82576 Gigabit Network Connection"},
			{ID: 0x1527, Name: "82580 Gigabit Fiber Network Connection"},
			{ID: 0x1528, Name: "Ethernet Controller 10-Gigabit X540-AT2"},
			{ID: 0x1529, Name: "82599 10 Gigabit Dual Port Network Connection with FCoE"},
			{ID: 0x152a, Name: "82599 10 Gigabit Dual Port Backplane Connection with FCoE"},
			{ID: 0x152e, Name: "82599 Virtual Function"},
			{ID: 0x152f, Name: "I350 Virtual Function"},
			{ID: 0x1530, Name: "X540 Virtual Function"},
			{ID: 0x1531, Name: "I210 Gigabit Unprogrammed"},
			{ID: 0x1533, Name: "I210 Gigabit Network Connection"},
			{ID: 0x1536, Name: "I210 Gigabit Fiber Network Connection"},
			{ID: 0x1537, Name: "I210 Gigabit Backplane Connection"},
			{ID: 0x1538, Name: "I210 Gigabit Network Connection"},
			{ID: 0x1539, Name: "I211 Gigabit Network Connection"},
			{ID: 0x153a, Name: "Ethernet Connection I217-LM"},
			{ID: 0x153b, Name: "Ethernet Connection I217-V"},
			{ID: 0x1547, Name: "DSL3510 Thunderbolt Controller [Cactus Ridge 4C 2012]"},
			{ID: 0x1548, Name: "DSL3310 Thunderbolt Controller [Cactus Ridge 2C 2012]"},
			{ID: 0x1549, Name: "DSL2210 Thunderbolt Controller [Port Ridge 1C 2011]"},
			{ID: 0x154a, Name: "Ethernet Server Adapter X520-4"},
			{ID: 0x154c, Name: "Ethernet Virtual Function 700 Series"},
			{ID: 0x154d, Name: "Ethernet 10G 2P X520 Adapter"},
			{ID: 0x1557, Name: "82599 10 Gigabit Network Connection"},
			{ID: 0x1558, Name: "Ethernet Converged Network Adapter X520-Q1"},
			{ID: 0x1559, Name: "Ethernet Connection I218-V"},
			{ID: 0x155a, Name: "Ethernet Connection I218-LM"},
			{ID: 0x155c, Name: "Ethernet Server Bypass Adapter"},
			{ID: 0x155d, Name: "Ethernet Server Bypass Adapter"},
			{ID: 0x1560, Name: "Ethernet Controller X540"},
			{ID: 0x1563, Name: "Ethernet Controller 10G X550T"},
			{ID: 0x1564, Name: "X550 Virtual Function"},
			{ID: 0x1565, Name: "X550 Virtual Function"},
			{ID: 0x1566, Name: "DSL4410 Thunderbolt NHI [Redwood Ridge 2C 2013]"},
			{ID: 0x1567, Name: "DSL4410 Thunderbolt Bridge [Redwood Ridge 2C 2013]"},
			{ID: 0x1568, Name: "DSL4510 Thunderbolt NHI [Redwood Ridge 4C 2013]"},
			{ID: 0x1569, Name: "DSL4510 Thunderbolt Bridge [Redwood Ridge 4C 2013]"},
			{ID: 0x156a, Name: "DSL5320 Thunderbolt 2 NHI [Falcon Ridge 2C 2013]"},
			{ID: 0x156b, Name: "DSL5320 Thunderbolt 2 Bridge [Falcon Ridge 2C 2013]"},
			{ID: 0x156c, Name: "DSL5520 Thunderbolt 2 NHI [Falcon Ridge 4C 2013]"},
			{ID: 0x156d, Name: "DSL5520 Thunderbolt 2 Bridge [Falcon Ridge 4C 2013]"},
			{ID: 0x156f, Name: "Ethernet Connection I219-LM"},
			{ID: 0x1570, Name: "Ethernet Connection I219-V"},
			{ID: 0x1571, Name: "Ethernet Virtual Function 700 Series"},
			{ID: 0x1572, Name: "Ethernet Controller X710 for 10GbE SFP+"},
			{ID: 0x1574, Name: "Ethernet Controller XL710 Emulation"},
			{ID: 0x1575, Name: "DSL6340 Thunderbolt 3 NHI [Alpine Ridge 2C 2015]"},
			{ID: 0x1576, Name: "DSL6340 Thunderbolt 3 Bridge [Alpine Ridge 2C 2015]"},
			{ID: 0x1577, Name: "DSL6540 Thunderbolt 3 NHI [Alpine Ridge 4C 2015]"},
			{ID: 0x1578, Name: "DSL6540 Thunderbolt 3 Bridge [Alpine Ridge 4C 2015]"},
			{ID: 0x157b, Name: "I210 Gigabit Network Connection"},
			{ID: 0x157c, Name: "I210 Gigabit Backplane Connection"},
			{ID: 0x157d, Name: "DSL5110 Thunderbolt 2 NHI (Low Power) [Win Ridge 2C 2014]"},
			{ID: 0x157e, Name: "DSL5110 Thunderbolt 2 Bridge (Low Power) [Win Ridge 2C 2014]"},
			{ID: 0x1580, Name: "Ethernet Controller XL710 for 40GbE backplane"},
			{ID: 0x1581, Name: "Ethernet Controller X710 for 10GbE backplane"},
			{ID: 0x1583, Name: "Ethernet Controller XL710 for 40GbE QSFP+"},
			{ID: 0x1584, Name: "Ethernet Controller XL710 for 40GbE QSFP+"},
			{ID: 0x1585, Name: "Ethernet Controller X710 for 10GbE QSFP+"},
			{ID: 0x1586, Name: "Ethernet Controller X710 for 10GBASE-T"},
			{ID: 0x1587, Name: "Ethernet Controller XL710 for 20GbE backplane"},
			{ID: 0x1588, Name: "Ethernet Controller XL710 for 20GbE backplane"},
			{ID: 0x1589, Name: "Ethernet Controller X710/X557-AT 10GBASE-T"},
			{ID: 0x158a, Name: "Ethernet Controller XXV710 for 25GbE backplane"},
			{ID: 0x158b, Name: "Ethernet Controller XXV710 for 25GbE SFP28"},
			{ID: 0x1591, Name: "Ethernet Controller E810-C for backplane"},
			{ID: 0x1592, Name: "Ethernet Controller E810-C for QSFP"},
			{ID: 0x1593, Name: "Ethernet Controller E810-C for SFP"},
			{ID: 0x1599, Name: "Ethernet Controller E810-XXV for backplane"},
			{ID: 0x159a, Name: "Ethernet Controller E810-XXV for QSFP"},
			{ID: 0x159b, Name: "Ethernet Controller E810-XXV for SFP"},
			{ID: 0x15a0, Name: "Ethernet Connection (2) I218-LM"},
			{ID: 0x15a1, Name: "Ethernet Connection (2) I218-V"},
			{ID: 0x15a2, Name: "Ethernet Connection (3) I218-LM"},
			{ID: 0x15a3, Name: "Ethernet Connection (3) I218-V"},
			{ID: 0x15a4, Name: "Ethernet Switch FM10000 Host Interface"},
			{ID: 0x15a5, Name: "Ethernet Switch FM10000 Host Virtual Interface"},
			{ID: 0x15a8, Name: "Ethernet Connection X552 Virtual Function"},
			{ID: 0x15a9, Name: "X552 Virtual Function"},
			{ID: 0x15aa, Name: "Ethernet Connection X552 10 GbE Backplane"},
			{ID: 0x15ab, Name: "Ethernet Connection X552 10 GbE Backplane"},
			{ID: 0x15ac, Name: "Ethernet Connection X552 10 GbE SFP+"},
			{ID: 0x15ad, Name: "Ethernet Connection X552/X557-AT 10GBASE-T"},
			{ID: 0x15ae, Name: "Ethernet Connection X552 1000BASE-T"},
			{ID: 0x15b0, Name: "Ethernet Connection X552 Backplane"},
			{ID: 0x15b4, Name: "X553 Virtual Function"},
			{ID: 0x15b5, Name: "DSL6340 USB 3.1 Controller [Alpine Ridge]"},
			{ID: 0x15b6, Name: "DSL6540 USB 3.1 Controller [Alpine Ridge]"},
			{ID: 0x15b7, Name: "Ethernet Connection (2) I219-LM"},
			{ID: 0x15b8, Name: "Ethernet Connection (2) I219-V"},
			{ID: 0x15b9, Name: "Ethernet Connection (3) I219-LM"},
			{ID: 0x15bb, Name: "Ethernet Connection (7) I219-LM"},
			{ID: 0x15bc, Name: "Ethernet Connection (7) I219-V"},
			{ID: 0x15bd, Name: "Ethernet Connection (6) I219-LM"},
			{ID: 0x15be, Name: "Ethernet Connection (6) I219-V"},
			{ID: 0x15bf, Name: "JHL6240 Thunderbolt 3 NHI (Low Power) [Alpine Ridge LP 2016]"},
			{ID: 0x15c0, Name: "JHL6240 Thunderbolt 3 Bridge (Low Power) [Alpine Ridge LP 2016]"},
			{ID: 0x15c1, Name: "JHL6240 Thunderbolt 3 USB 3.1 Controller (Low Power) [Alpine Ridge LP 2016]"},
			{ID: 0x15c2, Name: "Ethernet Connection X553 Backplane"},
			{ID: 0x15c3, Name: "Ethernet Connection X553 Backplane"},
			{ID: 0x15c4, Name: "Ethernet Connection X553 10 GbE SFP+"},
			{ID: 0x15c5, Name: "X553 Virtual Function"},
			{ID: 0x15c6, Name: "Ethernet Connection X553 1GbE"},
			{ID: 0x15c7, Name: "Ethernet Connection X553 1GbE"},
			{ID: 0x15c8, Name: "Ethernet Connection X553/X557-AT 10GBASE-T"},
			{ID: 0x15ce, Name: "Ethernet Connection X553 10 GbE SFP+"},
			{ID: 0x15d0, Name: "Ethernet SDI Adapter"},
			{ID: 0x15d1, Name: "Ethernet Controller 10G X550T"},
			{ID: 0x15d2, Name: "JHL6540 Thunderbolt 3 NHI (C step) [Alpine Ridge 4C 2016]"},
			{ID: 0x15d3, Name: "JHL6540 Thunderbolt 3 Bridge (C step) [Alpine Ridge 4C 2016]"},
			{ID: 0x15d4, Name: "JHL6540 Thunderbolt 3 USB Controller (C step) [Alpine Ridge 4C 2016]"},
			{ID: 0x15d5, Name: "Ethernet SDI Adapter FM10420-25GbE-DA2"},
			{ID: 0x15d6, Name: "Ethernet Connection (5) I219-V"},
			{ID: 0x15d7, Name: "Ethernet Connection (4) I219-LM"},
			{ID: 0x15d8, Name: "Ethernet Connection (4) I219-V"},
			{ID: 0x15d9, Name: "JHL6340 Thunderbolt 3 NHI (C step) [Alpine Ridge 2C 2016]"},
			{ID: 0x15da, Name: "JHL6340 Thunderbolt 3 Bridge (C step) [Alpine Ridge 2C 2016]"},
			{ID: 0x15db, Name: "JHL6340 Thunderbolt 3 USB 3.1 Controller (C step) [Alpine Ridge 2C 2016]"},
			{ID: 0x15df, Name: "Ethernet Connection (8) I219-LM"},
			{ID: 0x15e0, Name: "Ethernet Connection (8) I219-V"},
			{ID: 0x15e1, Name: "Ethernet Connection (9) I219-LM"},
			{ID: 0x15e2, Name: "Ethernet Connection (9) I219-V"},
			{ID: 0x15e3, Name: "Ethernet Connection (5) I219-LM"},
			{ID: 0x15e4, Name: "Ethernet Connection X553 1GbE"},
			{ID: 0x15e5, Name: "Ethernet Connection X553 1GbE"},
			{ID: 0x15e7, Name: "JHL7540 Thunderbolt 3 Bridge [Titan Ridge 2C 2018]"},
			{ID: 0x15e8, Name: "JHL7540 Thunderbolt 3 NHI [Titan Ridge 2C 2018]"},
			{ID: 0x15e9, Name: "JHL7540 Thunderbolt 3 USB Controller [Titan Ridge 2C 2018]"},
			{ID: 0x15ea, Name: "JHL7540 Thunderbolt 3 Bridge [Titan Ridge 4C 2018]"},
			{ID: 0x15eb, Name: "JHL7540 Thunderbolt 3 NHI [Titan Ridge 4C 2018]"},
			{ID: 0x15ec, Name: "JHL7540 Thunderbolt 3 USB Controller [Titan Ridge 4C 2018]"},
			{ID: 0x15ef, Name: "JHL7540 Thunderbolt 3 Bridge [Titan Ridge DD 2018]"},
			{ID: 0x15f0, Name: "JHL7540 Thunderbolt 3 USB Controller [Titan Ridge DD 2018]"},
			{ID: 0x15f2, Name: "Ethernet Controller I225-LM"},
			{ID: 0x15f3, Name: "Ethernet Controller I225-V"},
			{ID: 0x15f4, Name: "Ethernet Connection (15) I219-LM"},
			{ID: 0x15f5, Name: "Ethernet Connection (15) I219-V"},
			{ID: 0x15f6, Name: "I210 Gigabit Ethernet Connection"},
			{ID: 0x15f9, Name: "Ethernet Connection (14) I219-LM"},
			{ID: 0x15fa, Name: "Ethernet Connection (14) I219-V"},
			{ID: 0x15fb, Name: "Ethernet Connection (13) I219-LM"},
			{ID: 0x15fc, Name: "Ethernet Connection (13) I219-V"},
			{ID: 0x15ff, Name: "Ethernet Controller X710 for 10GBASE-T"},
			{ID: 0x1600, Name: "Broadwell-U Host Bridge -OPI"},
			{ID: 0x1601, Name: "Broadwell-U PCI Express x16 Controller"},
			{ID: 0x1602, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x1603, Name: "Broadwell-U Processor Thermal Subsystem"},
			{ID: 0x1604, Name: "Broadwell-U Host Bridge -OPI"},
			{ID: 0x1605, Name: "Broadwell-U PCI Express x8 Controller"},
			{ID: 0x1606, Name: "HD Graphics"},
			{ID: 0x1607, Name: "Broadwell-U CHAPS Device"},
			{ID: 0x1608, Name: "Broadwell-U Host Bridge -OPI"},
			{ID: 0x1609, Name: "Broadwell-U x4 PCIe"},
			{ID: 0x160a, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x160b, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x160c, Name: "Broadwell-U Audio Controller"},
			{ID: 0x160d, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x160e, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x160f, Name: "Broadwell-U SoftSKU"},
			{ID: 0x1610, Name: "Broadwell-U Host Bridge - DMI"},
			{ID: 0x1612, Name: "HD Graphics 5600"},
			{ID: 0x1614, Name: "Broadwell-U Host Bridge - DMI"},
			{ID: 0x1616, Name: "HD Graphics 5500"},
			{ID: 0x1618, Name: "Broadwell-U Host Bridge - DMI"},
			{ID: 0x161a, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x161b, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x161d, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x161e, Name: "HD Graphics 5300"},
			{ID: 0x1622, Name: "Iris Pro Graphics 6200"},
			{ID: 0x1626, Name: "HD Graphics 6000"},
			{ID: 0x162a, Name: "Iris Pro Graphics P6300"},
			{ID: 0x162b, Name: "Iris Graphics 6100"},
			{ID: 0x162d, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x162e, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x1632, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x1636, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x163a, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x163b, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x163d, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x163e, Name: "Broadwell-U Integrated Graphics"},
			{ID: 0x1889, Name: "Ethernet Adaptive Virtual Function"},
			{ID: 0x1890, Name: "Ethernet Connection E822-C for backplane"},
			{ID: 0x1891, Name: "Ethernet Connection E822-C for QSFP"},
			{ID: 0x1892, Name: "Ethernet Connection E822-C for SFP"},
			{ID: 0x1893, Name: "Ethernet Connection E822-C/X557-AT 10GBASE-T"},
			{ID: 0x1894, Name: "Ethernet Connection E822-C 1GbE"},
			{ID: 0x1897, Name: "Ethernet Connection E822-L for backplane"},
			{ID: 0x1898, Name: "Ethernet Connection E822-L for SFP"},
			{ID: 0x1899, Name: "Ethernet Connection E822-L/X557-AT 10GBASE-T"},
			{ID: 0x189a, Name: "Ethernet Connection E822-L 1GbE"},
			{ID: 0x18a0, Name: "C4xxx Series QAT"},
			{ID: 0x18a1, Name: "C4XXX Series QAT Virtual Function"},
			{ID: 0x18ee, Name: "200xx Series QAT"},
			{ID: 0x18ef, Name: "200xx Series QAT Virtual Function"},
			{ID: 0x1900, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x1901, Name: "6th-10th Gen Core Processor PCIe Controller (x16)"},
			{ID: 0x1902, Name: "HD Graphics 510"},
			{ID: 0x1903, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Thermal Subsystem"},
			{ID: 0x1904, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x1905, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor PCIe Controller (x8)"},
			{ID: 0x1906, Name: "HD Graphics 510"},
			{ID: 0x1908, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x1909, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor PCIe Controller (x4)"},
			{ID: 0x190c, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x190f, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x1910, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x1911, Name: "Xeon E3-1200 v5/v6 / E3-1500 v5 / 6th/7th/8th Gen Core Processor Gaussian Mixture Model"},
			{ID: 0x1912, Name: "HD Graphics 530"},
			{ID: 0x1916, Name: "Skylake GT2 [HD Graphics 520]"},
			{ID: 0x1918, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x1919, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Imaging Unit"},
			{ID: 0x191b, Name: "HD Graphics 530"},
			{ID: 0x191d, Name: "HD Graphics P530"},
			{ID: 0x191e, Name: "HD Graphics 515"},
			{ID: 0x191f, Name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers"},
			{ID: 0x1921, Name: "HD Graphics 520"},
			{ID: 0x1926, Name: "Iris Graphics 540"},
			{ID: 0x1927, Name: "Iris Graphics 550"},
			{ID: 0x192b, Name: "Iris Graphics 555"},
			{ID: 0x192d, Name: "Iris Graphics P555"},
			{ID: 0x1932, Name: "Iris Pro Graphics 580"},
			{ID: 0x193a, Name: "Iris Pro Graphics P580"},
			{ID: 0x193b, Name: "Iris Pro Graphics 580"},
			{ID: 0x193d, Name: "Iris Pro Graphics P580"},
			{ID: 0x1960, Name: "80960RP (i960RP) Microprocessor"},
			{ID: 0x1962, Name: "80960RM (i960RM) Microprocessor"},
			{ID: 0x1964, Name: "80960RN (i960RN) Microprocessor"},
			{ID: 0x1980, Name: "Atom Processor C3000 Series System Agent"},
			{ID: 0x19a1, Name: "Atom Processor C3000 Series Error Registers"},
			{ID: 0x19a2, Name: "Atom Processor C3000 Series Root Complex Event Collector"},
			{ID: 0x19a3, Name: "Atom Processor C3000 Series Integrated QAT Root Port"},
			{ID: 0x19a4, Name: "Atom Processor C3000 Series PCI Express Root Port #0"},
			{ID: 0x19a5, Name: "Atom Processor C3000 Series PCI Express Root Port #1"},
			{ID: 0x19a6, Name: "Atom Processor C3000 Series PCI Express Root Port #2"},
			{ID: 0x19a7, Name: "Atom Processor C3000 Series PCI Express Root Port #3"},
			{ID: 0x19a8, Name: "Atom Processor C3000 Series PCI Express Root Port #4"},
			{ID: 0x19a9, Name: "Atom Processor C3000 Series PCI Express Root Port #5"},
			{ID: 0x19aa, Name: "Atom Processor C3000 Series PCI Express Root Port #6"},
			{ID: 0x19ab, Name: "Atom Processor C3000 Series PCI Express Root Port #7"},
			{ID: 0x19ac, Name: "Atom Processor C3000 Series SMBus Contoller - Host"},
			{ID: 0x19b0, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19b1, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19b2, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19b3, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19b4, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19b5, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19b6, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19b7, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19be, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19bf, Name: "Atom Processor C3000 Series SATA Controller 0"},
			{ID: 0x19c0, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19c1, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19c2, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19c3, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19c4, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19c5, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19c6, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19c7, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19ce, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19cf, Name: "Atom Processor C3000 Series SATA Controller 1"},
			{ID: 0x19d0, Name: "Atom Processor C3000 Series USB 3.0 xHCI Controller"},
			{ID: 0x19d1, Name: "Atom Processor C3000 Series Integrated LAN Root Port #0"},
			{ID: 0x19d2, Name: "Atom Processor C3000 Series Integrated LAN Root Port #1"},
			{ID: 0x19d3, Name: "Atom Processor C3000 Series ME HECI 1"},
			{ID: 0x19d4, Name: "Atom Processor C3000 Series ME HECI 2"},
			{ID: 0x19d5, Name: "Atom Processor C3000 Series ME KT Controller"},
			{ID: 0x19d6, Name: "Atom Processor C3000 Series ME HECI 3"},
			{ID: 0x19d8, Name: "Atom Processor C3000 Series HSUART Controller"},
			{ID: 0x19dc, Name: "Atom Processor C3000 Series LPC or eSPI"},
			{ID: 0x19dd, Name: "Atom Processor C3000 Series Primary to Side Band (P2SB) Bridge"},
			{ID: 0x19de, Name: "Atom Processor C3000 Series Power Management Controller"},
			{ID: 0x19df, Name: "Atom Processor C3000 Series SMBus controller"},
			{ID: 0x19e0, Name: "Atom Processor C3000 Series SPI Controller"},
			{ID: 0x19e2, Name: "Atom Processor C3000 Series QuickAssist Technology"},
			{ID: 0x19e3, Name: "Atom Processor C3000 Series QuickAssist Technology Virtual Function"},
			{ID: 0x1a1c, Name: "Ethernet Connection (17) I219-LM"},
			{ID: 0x1a1d, Name: "Ethernet Connection (17) I219-V"},
			{ID: 0x1a1e, Name: "Ethernet Connection (16) I219-LM"},
			{ID: 0x1a1f, Name: "Ethernet Connection (16) I219-V"},
			{ID: 0x1a21, Name: "82840 840 [Carmel] Chipset Host Bridge (Hub A)"},
			{ID: 0x1a23, Name: "82840 840 [Carmel] Chipset AGP Bridge"},
			{ID: 0x1a24, Name: "82840 840 [Carmel] Chipset PCI Bridge (Hub B)"},
			{ID: 0x1a30, Name: "82845 845 [Brookdale] Chipset Host Bridge"},
			{ID: 0x1a31, Name: "82845 845 [Brookdale] Chipset AGP Bridge"},
			{ID: 0x1a38, Name: "5000 Series Chipset DMA Engine"},
			{ID: 0x1a48, Name: "82597EX 10GbE Ethernet Controller"},
			{ID: 0x1b48, Name: "82597EX 10GbE Ethernet Controller"},
			{ID: 0x1c00, Name: "6 Series/C200 Series Chipset Family Desktop SATA Controller (IDE mode, ports 0-3)"},
			{ID: 0x1c01, Name: "6 Series/C200 Series Chipset Family Mobile SATA Controller (IDE mode, ports 0-3)"},
			{ID: 0x1c02, Name: "6 Series/C200 Series Chipset Family 6 port Desktop SATA AHCI Controller"},
			{ID: 0x1c03, Name: "6 Series/C200 Series Chipset Family 6 port Mobile SATA AHCI Controller"},
			{ID: 0x1c04, Name: "6 Series/C200 Series Desktop SATA RAID Controller"},
			{ID: 0x1c05, Name: "6 Series/C200 Series Mobile SATA RAID Controller"},
			{ID: 0x1c06, Name: "Z68 Express Chipset SATA RAID Controller"},
			{ID: 0x1c08, Name: "6 Series/C200 Series Chipset Family Desktop SATA Controller (IDE mode, ports 4-5)"},
			{ID: 0x1c09, Name: "6 Series/C200 Series Chipset Family Mobile SATA Controller (IDE mode, ports 4-5)"},
			{ID: 0x1c10, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 1"},
			{ID: 0x1c12, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 2"},
			{ID: 0x1c14, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 3"},
			{ID: 0x1c16, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 4"},
			{ID: 0x1c18, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 5"},
			{ID: 0x1c1a, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 6"},
			{ID: 0x1c1c, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 7"},
			{ID: 0x1c1e, Name: "6 Series/C200 Series Chipset Family PCI Express Root Port 8"},
			{ID: 0x1c20, Name: "6 Series/C200 Series Chipset Family High Definition Audio Controller"},
			{ID: 0x1c22, Name: "6 Series/C200 Series Chipset Family SMBus Controller"},
			{ID: 0x1c24, Name: "6 Series/C200 Series Chipset Family Thermal Management Controller"},
			{ID: 0x1c25, Name: "6 Series/C200 Series Chipset Family DMI to PCI Bridge"},
			{ID: 0x1c26, Name: "6 Series/C200 Series Chipset Family USB Enhanced Host Controller #1"},
			{ID: 0x1c27, Name: "6 Series/C200 Series Chipset Family USB Universal Host Controller #1"},
			{ID: 0x1c2c, Name: "6 Series/C200 Series Chipset Family USB Universal Host Controller #5"},
			{ID: 0x1c2d, Name: "6 Series/C200 Series Chipset Family USB Enhanced Host Controller #2"},
			{ID: 0x1c33, Name: "6 Series/C200 Series Chipset Family LAN Controller"},
			{ID: 0x1c35, Name: "6 Series/C200 Series Chipset Family VECI Controller"},
			{ID: 0x1c3a, Name: "6 Series/C200 Series Chipset Family MEI Controller #1"},
			{ID: 0x1c3b, Name: "6 Series/C200 Series Chipset Family MEI Controller #2"},
			{ID: 0x1c3c, Name: "6 Series/C200 Series Chipset Family IDE-r Controller"},
			{ID: 0x1c3d, Name: "6 Series/C200 Series Chipset Family KT Controller"},
			{ID: 0x1c40, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c41, Name: "Mobile SFF 6 Series Chipset Family LPC Controller"},
			{ID: 0x1c42, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c43, Name: "Mobile 6 Series Chipset Family LPC Controller"},
			{ID: 0x1c44, Name: "Z68 Express Chipset LPC Controller"},
			{ID: 0x1c45, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c46, Name: "P67 Express Chipset LPC Controller"},
			{ID: 0x1c47, Name: "UM67 Express Chipset LPC Controller"},
			{ID: 0x1c48, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c49, Name: "HM65 Express Chipset LPC Controller"},
			{ID: 0x1c4a, Name: "H67 Express Chipset LPC Controller"},
			{ID: 0x1c4b, Name: "HM67 Express Chipset LPC Controller"},
			{ID: 0x1c4c, Name: "Q65 Express Chipset LPC Controller"},
			{ID: 0x1c4d, Name: "QS67 Express Chipset LPC Controller"},
			{ID: 0x1c4e, Name: "Q67 Express Chipset LPC Controller"},
			{ID: 0x1c4f, Name: "QM67 Express Chipset LPC Controller"},
			{ID: 0x1c50, Name: "B65 Express Chipset LPC Controller"},
			{ID: 0x1c51, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c52, Name: "C202 Chipset LPC Controller"},
			{ID: 0x1c53, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c54, Name: "C204 Chipset LPC Controller"},
			{ID: 0x1c55, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c56, Name: "C206 Chipset LPC Controller"},
			{ID: 0x1c57, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c58, Name: "Upgraded B65 Express Chipset LPC Controller"},
			{ID: 0x1c59, Name: "Upgraded HM67 Express Chipset LPC Controller"},
			{ID: 0x1c5a, Name: "Upgraded Q67 Express Chipset LPC Controller"},
			{ID: 0x1c5b, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c5c, Name: "H61 Express Chipset LPC Controller"},
			{ID: 0x1c5d, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c5e, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1c5f, Name: "6 Series/C200 Series Chipset Family LPC Controller"},
			{ID: 0x1d00, Name: "C600/X79 series chipset 4-Port SATA IDE Controller"},
			{ID: 0x1d02, Name: "C600/X79 series chipset 6-Port SATA AHCI Controller"},
			{ID: 0x1d04, Name: "C600/X79 series chipset SATA RAID Controller"},
			{ID: 0x1d06, Name: "C600/X79 series chipset SATA Premium RAID Controller"},
			{ID: 0x1d08, Name: "C600/X79 series chipset 2-Port SATA IDE Controller"},
			{ID: 0x1d10, Name: "C600/X79 series chipset PCI Express Root Port 1"},
			{ID: 0x1d11, Name: "C600/X79 series chipset PCI Express Root Port 1"},
			{ID: 0x1d12, Name: "C600/X79 series chipset PCI Express Root Port 2"},
			{ID: 0x1d13, Name: "C600/X79 series chipset PCI Express Root Port 2"},
			{ID: 0x1d14, Name: "C600/X79 series chipset PCI Express Root Port 3"},
			{ID: 0x1d15, Name: "C600/X79 series chipset PCI Express Root Port 3"},
			{ID: 0x1d16, Name: "C600/X79 series chipset PCI Express Root Port 4"},
			{ID: 0x1d17, Name: "C600/X79 series chipset PCI Express Root Port 4"},
			{ID: 0x1d18, Name: "C600/X79 series chipset PCI Express Root Port 5"},
			{ID: 0x1d19, Name: "C600/X79 series chipset PCI Express Root Port 5"},
			{ID: 0x1d1a, Name: "C600/X79 series chipset PCI Express Root Port 6"},
			{ID: 0x1d1b, Name: "C600/X79 series chipset PCI Express Root Port 6"},
			{ID: 0x1d1c, Name: "C600/X79 series chipset PCI Express Root Port 7"},
			{ID: 0x1d1d, Name: "C600/X79 series chipset PCI Express Root Port 7"},
			{ID: 0x1d1e, Name: "C600/X79 series chipset PCI Express Root Port 8"},
			{ID: 0x1d1f, Name: "C600/X79 series chipset PCI Express Root Port 8"},
			{ID: 0x1d20, Name: "C600/X79 series chipset High Definition Audio Controller"},
			{ID: 0x1d22, Name: "C600/X79 series chipset SMBus Host Controller"},
			{ID: 0x1d24, Name: "C600/X79 series chipset Thermal Management Controller"},
			{ID: 0x1d25, Name: "C600/X79 series chipset DMI to PCI Bridge"},
			{ID: 0x1d26, Name: "C600/X79 series chipset USB2 Enhanced Host Controller #1"},
			{ID: 0x1d2d, Name: "C600/X79 series chipset USB2 Enhanced Host Controller #2"},
			{ID: 0x1d33, Name: "C600/X79 series chipset LAN Controller"},
			{ID: 0x1d35, Name: "C600/X79 series chipset VECI Controller"},
			{ID: 0x1d3a, Name: "C600/X79 series chipset MEI Controller #1"},
			{ID: 0x1d3b, Name: "C600/X79 series chipset MEI Controller #2"},
			{ID: 0x1d3c, Name: "C600/X79 series chipset IDE-r Controller"},
			{ID: 0x1d3d, Name: "C600/X79 series chipset KT Controller"},
			{ID: 0x1d3e, Name: "C600/X79 series chipset PCI Express Virtual Root Port"},
			{ID: 0x1d3f, Name: "C608/C606/X79 series chipset PCI Express Virtual Switch Port"},
			{ID: 0x1d40, Name: "C600/X79 series chipset LPC Controller"},
			{ID: 0x1d41, Name: "C600/X79 series chipset LPC Controller"},
			{ID: 0x1d50, Name: "C608 chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d54, Name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d55, Name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d58, Name: "C606 chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d59, Name: "C604/X79 series chipset 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d5a, Name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit"},
			{ID: 0x1d5b, Name: "C602 chipset 4-Port SATA Storage Control Unit"},
			{ID: 0x1d5c, Name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d5d, Name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d5e, Name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit"},
			{ID: 0x1d5f, Name: "C600/X79 series chipset 4-Port SATA Storage Control Unit"},
			{ID: 0x1d60, Name: "C608 chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d64, Name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d65, Name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d68, Name: "C606 chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d69, Name: "C604/X79 series chipset 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d6a, Name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit"},
			{ID: 0x1d6b, Name: "C602 chipset 4-Port SATA Storage Control Unit"},
			{ID: 0x1d6c, Name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d6d, Name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit"},
			{ID: 0x1d6e, Name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit"},
			{ID: 0x1d6f, Name: "C600/X79 series chipset 4-Port SATA Storage Control Unit"},
			{ID: 0x1d70, Name: "C600/X79 series chipset SMBus Controller 0"},
			{ID: 0x1d71, Name: "C608/C606/X79 series chipset SMBus Controller 1"},
			{ID: 0x1d72, Name: "C608 chipset SMBus Controller 2"},
			{ID: 0x1d74, Name: "C608/C606/X79 series chipset PCI Express Upstream Port"},
			{ID: 0x1d76, Name: "C600/X79 series chipset Multi-Function Glue"},
			{ID: 0x1e00, Name: "7 Series/C210 Series Chipset Family 4-port SATA Controller [IDE mode]"},
			{ID: 0x1e01, Name: "7 Series Chipset Family 4-port SATA Controller [IDE mode]"},
			{ID: 0x1e02, Name: "7 Series/C210 Series Chipset Family 6-port SATA Controller [AHCI mode]"},
			{ID: 0x1e03, Name: "7 Series Chipset Family 6-port SATA Controller [AHCI mode]"},
			{ID: 0x1e04, Name: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]"},
			{ID: 0x1e05, Name: "7 Series Chipset SATA Controller [RAID mode]"},
			{ID: 0x1e06, Name: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]"},
			{ID: 0x1e07, Name: "7 Series Chipset Family SATA Controller [RAID mode]"},
			{ID: 0x1e08, Name: "7 Series/C210 Series Chipset Family 2-port SATA Controller [IDE mode]"},
			{ID: 0x1e09, Name: "7 Series Chipset Family 2-port SATA Controller [IDE mode]"},
			{ID: 0x1e0e, Name: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]"},
			{ID: 0x1e10, Name: "7 Series/C216 Chipset Family PCI Express Root Port 1"},
			{ID: 0x1e12, Name: "7 Series/C210 Series Chipset Family PCI Express Root Port 2"},
			{ID: 0x1e14, Name: "7 Series/C210 Series Chipset Family PCI Express Root Port 3"},
			{ID: 0x1e16, Name: "7 Series/C216 Chipset Family PCI Express Root Port 4"},
			{ID: 0x1e18, Name: "7 Series/C210 Series Chipset Family PCI Express Root Port 5"},
			{ID: 0x1e1a, Name: "7 Series/C210 Series Chipset Family PCI Express Root Port 6"},
			{ID: 0x1e1c, Name: "7 Series/C210 Series Chipset Family PCI Express Root Port 7"},
			{ID: 0x1e1e, Name: "7 Series/C210 Series Chipset Family PCI Express Root Port 8"},
			{ID: 0x1e20, Name: "7 Series/C216 Chipset Family High Definition Audio Controller"},
			{ID: 0x1e22, Name: "7 Series/C216 Chipset Family SMBus Controller"},
			{ID: 0x1e24, Name: "7 Series/C210 Series Chipset Family Thermal Management Controller"},
			{ID: 0x1e25, Name: "7 Series/C210 Series Chipset Family DMI to PCI Bridge"},
			{ID: 0x1e26, Name: "7 Series/C216 Chipset Family USB Enhanced Host Controller #1"},
			{ID: 0x1e2d, Name: "7 Series/C216 Chipset Family USB Enhanced Host Controller #2"},
			{ID: 0x1e31, Name: "7 Series/C210 Series Chipset Family USB xHCI Host Controller"},
			{ID: 0x1e33, Name: "7 Series/C210 Series Chipset Family LAN Controller"},
			{ID: 0x1e3a, Name: "7 Series/C216 Chipset Family MEI Controller #1"},
			{ID: 0x1e3b, Name: "7 Series/C210 Series Chipset Family MEI Controller #2"},
			{ID: 0x1e3c, Name: "7 Series/C210 Series Chipset Family IDE-r Controller"},
			{ID: 0x1e3d, Name: "7 Series/C210 Series Chipset Family KT Controller"},
			{ID: 0x1e41, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e42, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e43, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e44, Name: "Z77 Express Chipset LPC Controller"},
			{ID: 0x1e45, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e46, Name: "Z75 Express Chipset LPC Controller"},
			{ID: 0x1e47, Name: "Q77 Express Chipset LPC Controller"},
			{ID: 0x1e48, Name: "Q75 Express Chipset LPC Controller"},
			{ID: 0x1e49, Name: "B75 Express Chipset LPC Controller"},
			{ID: 0x1e4a, Name: "H77 Express Chipset LPC Controller"},
			{ID: 0x1e4b, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e4c, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e4d, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e4e, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e4f, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e50, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e51, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e52, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e53, Name: "C216 Series Chipset LPC Controller"},
			{ID: 0x1e54, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e55, Name: "QM77 Express Chipset LPC Controller"},
			{ID: 0x1e56, Name: "QS77 Express Chipset LPC Controller"},
			{ID: 0x1e57, Name: "HM77 Express Chipset LPC Controller"},
			{ID: 0x1e58, Name: "UM77 Express Chipset LPC Controller"},
			{ID: 0x1e59, Name: "HM76 Express Chipset LPC Controller"},
			{ID: 0x1e5a, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e5b, Name: "UM77 Express Chipset LPC Controller"},
			{ID: 0x1e5c, Name: "7 Series Chipset Family LPC Controller"},
			{ID: 0x1e5d, Name: "HM75 Express Chipset LPC Controller"},
			{ID: 0x1e5e, Name: "HM70 Express Chipset LPC Controller"},
			{ID: 0x1e5f, Name: "NM70 Express Chipset LPC Controller"},
			{ID: 0x1f00, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f01, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f02, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f03, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f04, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f05, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f06, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f07, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f08, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f09, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f0a, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f0b, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f0c, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f0d, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f0e, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f0f, Name: "Atom processor C2000 SoC Transaction Router"},
			{ID: 0x1f10, Name: "Atom processor C2000 PCIe Root Port 1"},
			{ID: 0x1f11, Name: "Atom processor C2000 PCIe Root Port 2"},
			{ID: 0x1f12, Name: "Atom processor C2000 PCIe Root Port 3"},
			{ID: 0x1f13, Name: "Atom processor C2000 PCIe Root Port 4"},
			{ID: 0x1f14, Name: "Atom processor C2000 RAS"},
			{ID: 0x1f15, Name: "Atom processor C2000 SMBus 2.0"},
			{ID: 0x1f16, Name: "Atom processor C2000 RCEC"},
			{ID: 0x1f18, Name: "Atom processor C2000 QAT"},
			{ID: 0x1f19, Name: "Atom processor C2000 QAT"},
			{ID: 0x1f20, Name: "Atom processor C2000 4-Port IDE SATA2 Controller"},
			{ID: 0x1f21, Name: "Atom processor C2000 4-Port IDE SATA2 Controller"},
			{ID: 0x1f22, Name: "Atom processor C2000 AHCI SATA2 Controller"},
			{ID: 0x1f23, Name: "Atom processor C2000 AHCI SATA2 Controller"},
			{ID: 0x1f24, Name: "Atom processor C2000 RAID SATA2 Controller"},
			{ID: 0x1f25, Name: "Atom processor C2000 RAID SATA2 Controller"},
			{ID: 0x1f26, Name: "Atom processor C2000 RAID SATA2 Controller"},
			{ID: 0x1f27, Name: "Atom processor C2000 RAID SATA2 Controller"},
			{ID: 0x1f2c, Name: "Atom processor C2000 USB Enhanced Host Controller"},
			{ID: 0x1f2e, Name: "Atom processor C2000 RAID SATA2 Controller"},
			{ID: 0x1f2f, Name: "Atom processor C2000 RAID SATA2 Controller"},
			{ID: 0x1f30, Name: "Atom processor C2000 2-Port IDE SATA3 Controller"},
			{ID: 0x1f31, Name: "Atom processor C2000 2-Port IDE SATA3 Controller"},
			{ID: 0x1f32, Name: "Atom processor C2000 AHCI SATA3 Controller"},
			{ID: 0x1f33, Name: "Atom processor C2000 AHCI SATA3 Controller"},
			{ID: 0x1f34, Name: "Atom processor C2000 RAID SATA3 Controller"},
			{ID: 0x1f35, Name: "Atom processor C2000 RAID SATA3 Controller"},
			{ID: 0x1f36, Name: "Atom processor C2000 RAID SATA3 Controller"},
			{ID: 0x1f37, Name: "Atom processor C2000 RAID SATA3 Controller"},
			{ID: 0x1f38, Name: "Atom processor C2000 PCU"},
			{ID: 0x1f39, Name: "Atom processor C2000 PCU"},
			{ID: 0x1f3a, Name: "Atom processor C2000 PCU"},
			{ID: 0x1f3b, Name: "Atom processor C2000 PCU"},
			{ID: 0x1f3c, Name: "Atom processor C2000 PCU SMBus"},
			{ID: 0x1f3d, Name: "Atom Processor C2000 PECI SMBus"},
			{ID: 0x1f3e, Name: "Atom processor C2000 RAID SATA3 Controller"},
			{ID: 0x1f3f, Name: "Atom processor C2000 RAID SATA3 Controller"},
			{ID: 0x1f40, Name: "Ethernet Connection I354 1.0 GbE Backplane"},
			{ID: 0x1f41, Name: "Ethernet Connection I354"},
			{ID: 0x1f42, Name: "Atom processor C2000 GbE"},
			{ID: 0x1f44, Name: "Atom processor C2000 GbE Virtual Function"},
			{ID: 0x1f45, Name: "Ethernet Connection I354 2.5 GbE Backplane"},
			{ID: 0x2014, Name: "Sky Lake-E Ubox Registers"},
			{ID: 0x2015, Name: "Sky Lake-E Ubox Registers"},
			{ID: 0x2016, Name: "Sky Lake-E Ubox Registers"},
			{ID: 0x2018, Name: "Sky Lake-E M2PCI Registers"},
			{ID: 0x201a, Name: "Sky Lake-E Non-Transparent Bridge Registers"},
			{ID: 0x201c, Name: "Sky Lake-E Non-Transparent Bridge Registers"},
			{ID: 0x201d, Name: "Volume Management Device NVMe RAID Controller"},
			{ID: 0x2020, Name: "Sky Lake-E DMI3 Registers"},
			{ID: 0x2021, Name: "Sky Lake-E CBDMA Registers"},
			{ID: 0x2024, Name: "Sky Lake-E MM/Vt-d Configuration Registers"},
			{ID: 0x2025, Name: "Sky Lake-E RAS"},
			{ID: 0x2026, Name: "Sky Lake-E IOAPIC"},
			{ID: 0x2030, Name: "Sky Lake-E PCI Express Root Port A"},
			{ID: 0x2031, Name: "Sky Lake-E PCI Express Root Port B"},
			{ID: 0x2032, Name: "Sky Lake-E PCI Express Root Port C"},
			{ID: 0x2033, Name: "Sky Lake-E PCI Express Root Port D"},
			{ID: 0x2034, Name: "Sky Lake-E VT-d"},
			{ID: 0x2035, Name: "Sky Lake-E RAS Configuration Registers"},
			{ID: 0x2036, Name: "Sky Lake-E IOxAPIC Configuration Registers"},
			{ID: 0x2040, Name: "Sky Lake-E Integrated Memory Controller"},
			{ID: 0x2041, Name: "Sky Lake-E Integrated Memory Controller"},
			{ID: 0x2042, Name: "Sky Lake-E Integrated Memory Controller"},
			{ID: 0x2043, Name: "Sky Lake-E Integrated Memory Controller"},
			{ID: 0x2044, Name: "Sky Lake-E Integrated Memory Controller"},
			{ID: 0x2045, Name: "Sky Lake-E LM Channel 1"},
			{ID: 0x2046, Name: "Sky Lake-E LMS Channel 1"},
			{ID: 0x2047, Name: "Sky Lake-E LMDP Channel 1"},
			{ID: 0x2048, Name: "Sky Lake-E DECS Channel 2"},
			{ID: 0x2049, Name: "Sky Lake-E LM Channel 2"},
			{ID: 0x204a, Name: "Sky Lake-E LMS Channel 2"},
			{ID: 0x204b, Name: "Sky Lake-E LMDP Channel 2"},
			{ID: 0x204c, Name: "Sky Lake-E M3KTI Registers"},
			{ID: 0x204d, Name: "Sky Lake-E M3KTI Registers"},
			{ID: 0x204e, Name: "Sky Lake-E M3KTI Registers"},
			{ID: 0x2054, Name: "Sky Lake-E CHA Registers"},
			{ID: 0x2055, Name: "Sky Lake-E CHA Registers"},
			{ID: 0x2056, Name: "Sky Lake-E CHA Registers"},
			{ID: 0x2057, Name: "Sky Lake-E CHA Registers"},
			{ID: 0x2058, Name: "Sky Lake-E KTI 0"},
			{ID: 0x2059, Name: "Sky Lake-E UPI Registers"},
			{ID: 0x2066, Name: "Sky Lake-E Integrated Memory Controller"},
			{ID: 0x2068, Name: "Sky Lake-E DDRIO Registers"},
			{ID: 0x2069, Name: "Sky Lake-E DDRIO Registers"},
			{ID: 0x206a, Name: "Sky Lake-E IOxAPIC Configuration Registers"},
			{ID: 0x206e, Name: "Sky Lake-E DDRIO Registers"},
			{ID: 0x206f, Name: "Sky Lake-E DDRIO Registers"},
			{ID: 0x2078, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x207a, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2080, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2081, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2082, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2083, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2084, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2085, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2086, Name: "Sky Lake-E PCU Registers"},
			{ID: 0x2088, Name: "Sky Lake-E DDRIO Registers"},
			{ID: 0x208d, Name: "Sky Lake-E CHA Registers"},
			{ID: 0x208e, Name: "Sky Lake-E CHA Registers"},
			{ID: 0x2241, Name: "Larrabee"},
			{ID: 0x2250, Name: "Xeon Phi coprocessor 5100 series"},
			{ID: 0x225c, Name: "Xeon Phi coprocessor SE10/7120 series"},
			{ID: 0x225d, Name: "Xeon Phi coprocessor 3120 series"},
			{ID: 0x225e, Name: "Xeon Phi coprocessor 31S1"},
			{ID: 0x2262, Name: "Xeon Phi coprocessor 7220"},
			{ID: 0x2280, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SoC Transaction Register"},
			{ID: 0x2284, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series High Definition Audio Controller"},
			{ID: 0x2286, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 DMA Controller"},
			{ID: 0x228a, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 HSUART Controller #1"},
			{ID: 0x228c, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 HSUART Controller #2"},
			{ID: 0x2292, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx SMBus Controller"},
			{ID: 0x2294, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series MMC Controller"},
			{ID: 0x2295, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SDIO Controller"},
			{ID: 0x2296, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SD Controller"},
			{ID: 0x2298, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Trusted Execution Engine"},
			{ID: 0x229c, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCU"},
			{ID: 0x22a3, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SATA Controller"},
			{ID: 0x22a4, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SATA AHCI Controller"},
			{ID: 0x22a8, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Low Power Engine Audio"},
			{ID: 0x22b0, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Integrated Graphics Controller"},
			{ID: 0x22b1, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Integrated Graphics Controller"},
			{ID: 0x22b5, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series USB xHCI Controller"},
			{ID: 0x22b8, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Imaging Unit"},
			{ID: 0x22c0, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 DMA Controller"},
			{ID: 0x22c1, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #1"},
			{ID: 0x22c2, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #2"},
			{ID: 0x22c3, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #3"},
			{ID: 0x22c4, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #4"},
			{ID: 0x22c5, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #5"},
			{ID: 0x22c6, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #6"},
			{ID: 0x22c7, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #7"},
			{ID: 0x22c8, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #1"},
			{ID: 0x22ca, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #2"},
			{ID: 0x22cc, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #3"},
			{ID: 0x22ce, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #4"},
			{ID: 0x22dc, Name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Power Management Controller"},
			{ID: 0x2310, Name: "DH89xxCC LPC Controller"},
			{ID: 0x2323, Name: "DH89xxCC 4 Port SATA AHCI Controller"},
			{ID: 0x2330, Name: "DH89xxCC SMBus Controller"},
			{ID: 0x2331, Name: "DH89xxCC Chap Counter"},
			{ID: 0x2332, Name: "DH89xxCC Thermal Subsystem"},
			{ID: 0x2334, Name: "DH89xxCC USB2 Enhanced Host Controller #1"},
			{ID: 0x2335, Name: "DH89xxCC USB2 Enhanced Host Controller #1"},
			{ID: 0x2342, Name: "DH89xxCC PCI Express Root Port #1"},
			{ID: 0x2343, Name: "DH89xxCC PCI Express Root Port #1"},
			{ID: 0x2344, Name: "DH89xxCC PCI Express Root Port #2"},
			{ID: 0x2345, Name: "DH89xxCC PCI Express Root Port #2"},
			{ID: 0x2346, Name: "DH89xxCC PCI Express Root Port #3"},
			{ID: 0x2347, Name: "DH89xxCC PCI Express Root Port #3"},
			{ID: 0x2348, Name: "DH89xxCC PCI Express Root Port #4"},
			{ID: 0x2349, Name: "DH89xxCC PCI Express Root Port #4"},
			{ID: 0x2360, Name: "DH89xxCC Watchdog Timer"},
			{ID: 0x2364, Name: "DH89xxCC MEI 0"},
			{ID: 0x2365, Name: "DH89xxCC MEI 1"},
			{ID: 0x2390, Name: "DH895XCC Series LPC Controller"},
			{ID: 0x23a1, Name: "DH895XCC Series 2-Port SATA Controller [IDE Mode]"},
			{ID: 0x23a3, Name: "DH895XCC Series 4-Port SATA Controller [AHCI Mode]"},
			{ID: 0x23a6, Name: "DH895XCC Series 2-Port SATA Controller [IDE Mode]"},
			{ID: 0x23b0, Name: "DH895XCC Series SMBus Controller"},
			{ID: 0x23b1, Name: "DH895XCC Series CHAP Counter"},
			{ID: 0x23b2, Name: "DH895XCC Series Thermal Management Controller"},
			{ID: 0x23b4, Name: "DH895XCC Series USB2 Enhanced Host Controller #1"},
			{ID: 0x23b5, Name: "DH895XCC Series USB2 Enhanced Host Controller #1"},
			{ID: 0x23c2, Name: "DH895XCC Series PCI Express Root Port #1"},
			{ID: 0x23c3, Name: "DH895XCC Series PCI Express Root Port #1"},
			{ID: 0x23c4, Name: "DH895XCC Series PCI Express Root Port #2"},
			{ID: 0x23c5, Name: "DH895XCC Series PCI Express Root Port #2"},
			{ID: 0x23c6, Name: "CDH895XCC Series PCI Express Root Port #3"},
			{ID: 0x23c7, Name: "DH895XCC Series PCI Express Root Port #3"},
			{ID: 0x23c8, Name: "DH895XCC Series PCI Express Root Port #4"},
			{ID: 0x23c9, Name: "DH895XCC Series PCI Express Root Port #4"},
			{ID: 0x23e0, Name: "DH895XCC Series Watchdog Timer"},
			{ID: 0x23e4, Name: "DH895XCC Series MEI Controller #1"},
			{ID: 0x23e5, Name: "DH895XCC Series MEI Controller #2"},
			{ID: 0x2410, Name: "82801AA ISA Bridge (LPC)"},
			{ID: 0x2411, Name: "82801AA IDE Controller"},
			{ID: 0x2412, Name: "82801AA USB Controller"},
			{ID: 0x2413, Name: "82801AA SMBus Controller"},
			{ID: 0x2415, Name: "82801AA AC'97 Audio Controller"},
			{ID: 0x2416, Name: "82801AA AC'97 Modem Controller"},
			{ID: 0x2418, Name: "82801AA PCI Bridge"},
			{ID: 0x2420, Name: "82801AB ISA Bridge (LPC)"},
			{ID: 0x2421, Name: "82801AB IDE Controller"},
			{ID: 0x2422, Name: "82801AB USB Controller"},
			{ID: 0x2423, Name: "82801AB SMBus Controller"},
			{ID: 0x2425, Name: "82801AB AC'97 Audio Controller"},
			{ID: 0x2426, Name: "82801AB AC'97 Modem Controller"},
			{ID: 0x2428, Name: "82801AB PCI Bridge"},
			{ID: 0x2440, Name: "82801BA ISA Bridge (LPC)"},
			{ID: 0x2442, Name: "82801BA/BAM UHCI USB 1.1 Controller #1"},
			{ID: 0x2443, Name: "82801BA/BAM SMBus Controller"},
			{ID: 0x2444, Name: "82801BA/BAM UHCI USB 1.1 Controller #2"},
			{ID: 0x2445, Name: "82801BA/BAM AC'97 Audio Controller"},
			{ID: 0x2446, Name: "82801BA/BAM AC'97 Modem Controller"},
			{ID: 0x2448, Name: "82801 Mobile PCI Bridge"},
			{ID: 0x2449, Name: "82801BA/BAM/CA/CAM Ethernet Controller"},
			{ID: 0x244a, Name: "82801BAM IDE U100 Controller"},
			{ID: 0x244b, Name: "82801BA IDE U100 Controller"},
			{ID: 0x244c, Name: "82801BAM ISA Bridge (LPC)"},
			{ID: 0x244e, Name: "82801 PCI Bridge"},
			{ID: 0x2450, Name: "82801E ISA Bridge (LPC)"},
			{ID: 0x2452, Name: "82801E USB Controller"},
			{ID: 0x2453, Name: "82801E SMBus Controller"},
			{ID: 0x2459, Name: "82801E Ethernet Controller 0"},
			{ID: 0x245b, Name: "82801E IDE U100 Controller"},
			{ID: 0x245d, Name: "82801E Ethernet Controller 1"},
			{ID: 0x245e, Name: "82801E PCI Bridge"},
			{ID: 0x2480, Name: "82801CA LPC Interface Controller"},
			{ID: 0x2482, Name: "82801CA/CAM USB Controller #1"},
			{ID: 0x2483, Name: "82801CA/CAM SMBus Controller"},
			{ID: 0x2484, Name: "82801CA/CAM USB Controller #2"},
			{ID: 0x2485, Name: "82801CA/CAM AC'97 Audio Controller"},
			{ID: 0x2486, Name: "82801CA/CAM AC'97 Modem Controller"},
			{ID: 0x2487, Name: "82801CA/CAM USB Controller #3"},
			{ID: 0x248a, Name: "82801CAM IDE U100 Controller"},
			{ID: 0x248b, Name: "82801CA Ultra ATA Storage Controller"},
			{ID: 0x248c, Name: "82801CAM ISA Bridge (LPC)"},
			{ID: 0x24c0, Name: "82801DB/DBL (ICH4/ICH4-L) LPC Interface Bridge"},
			{ID: 0x24c1, Name: "82801DBL (ICH4-L) IDE Controller"},
			{ID: 0x24c2, Name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #1"},
			{ID: 0x24c3, Name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) SMBus Controller"},
			{ID: 0x24c4, Name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #2"},
			{ID: 0x24c5, Name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) AC'97 Audio Controller"},
			{ID: 0x24c6, Name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) AC'97 Modem Controller"},
			{ID: 0x24c7, Name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #3"},
			{ID: 0x24ca, Name: "82801DBM (ICH4-M) IDE Controller"},
			{ID: 0x24cb, Name: "82801DB (ICH4) IDE Controller"},
			{ID: 0x24cc, Name: "82801DBM (ICH4-M) LPC Interface Bridge"},
			{ID: 0x24cd, Name: "82801DB/DBM (ICH4/ICH4-M) USB2 EHCI Controller"},
			{ID: 0x24d0, Name: "82801EB/ER (ICH5/ICH5R) LPC Interface Bridge"},
			{ID: 0x24d1, Name: "82801EB (ICH5) SATA Controller"},
			{ID: 0x24d2, Name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #1"},
			{ID: 0x24d3, Name: "82801EB/ER (ICH5/ICH5R) SMBus Controller"},
			{ID: 0x24d4, Name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #2"},
			{ID: 0x24d5, Name: "82801EB/ER (ICH5/ICH5R) AC'97 Audio Controller"},
			{ID: 0x24d6, Name: "82801EB/ER (ICH5/ICH5R) AC'97 Modem Controller"},
			{ID: 0x24d7, Name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #3"},
			{ID: 0x24db, Name: "82801EB/ER (ICH5/ICH5R) IDE Controller"},
			{ID: 0x24dc, Name: "82801EB (ICH5) LPC Interface Bridge"},
			{ID: 0x24dd, Name: "82801EB/ER (ICH5/ICH5R) USB2 EHCI Controller"},
			{ID: 0x24de, Name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #4"},
			{ID: 0x24df, Name: "82801ER (ICH5R) SATA Controller"},
			{ID: 0x24f0, Name: "Omni-Path HFI Silicon 100 Series [discrete]"},
			{ID: 0x24f1, Name: "Omni-Path HFI Silicon 100 Series [integrated]"},
			{ID: 0x24f3, Name: "Wireless 8260"},
			{ID: 0x24f4, Name: "Wireless 8260"},
			{ID: 0x24fb, Name: "Dual Band Wireless-AC 3168NGW [Stone Peak]"},
			{ID: 0x24fd, Name: "Wireless 8265 / 8275"},
			{ID: 0x2500, Name: "82820 820 (Camino) Chipset Host Bridge (MCH)"},
			{ID: 0x2501, Name: "82820 820 (Camino) Chipset Host Bridge (MCH)"},
			{ID: 0x250b, Name: "82820 820 (Camino) Chipset Host Bridge"},
			{ID: 0x250f, Name: "82820 820 (Camino) Chipset AGP Bridge"},
			{ID: 0x2520, Name: "82805AA MTH Memory Translator Hub"},
			{ID: 0x2521, Name: "82804AA MRH-S Memory Repeater Hub for SDRAM"},
			{ID: 0x2522, Name: "NVMe Optane Memory Series"},
			{ID: 0x2526, Name: "Wireless-AC 9260"},
			{ID: 0x2530, Name: "82850 850 (Tehama) Chipset Host Bridge (MCH)"},
			{ID: 0x2531, Name: "82860 860 (Wombat) Chipset Host Bridge (MCH)"},
			{ID: 0x2532, Name: "82850 850 (Tehama) Chipset AGP Bridge"},
			{ID: 0x2533, Name: "82860 860 (Wombat) Chipset AGP Bridge"},
			{ID: 0x2534, Name: "82860 860 (Wombat) Chipset PCI Bridge"},
			{ID: 0x2540, Name: "E7500 Memory Controller Hub"},
			{ID: 0x2541, Name: "E7500/E7501 Host RASUM Controller"},
			{ID: 0x2543, Name: "E7500/E7501 Hub Interface B PCI-to-PCI Bridge"},
			{ID: 0x2544, Name: "E7500/E7501 Hub Interface B RASUM Controller"},
			{ID: 0x2545, Name: "E7500/E7501 Hub Interface C PCI-to-PCI Bridge"},
			{ID: 0x2546, Name: "E7500/E7501 Hub Interface C RASUM Controller"},
			{ID: 0x2547, Name: "E7500/E7501 Hub Interface D PCI-to-PCI Bridge"},
			{ID: 0x2548, Name: "E7500/E7501 Hub Interface D RASUM Controller"},
			{ID: 0x254c, Name: "E7501 Memory Controller Hub"},
			{ID: 0x2550, Name: "E7505 Memory Controller Hub"},
			{ID: 0x2551, Name: "E7505/E7205 Series RAS Controller"},
			{ID: 0x2552, Name: "E7505/E7205 PCI-to-AGP Bridge"},
			{ID: 0x2553, Name: "E7505 Hub Interface B PCI-to-PCI Bridge"},
			{ID: 0x2554, Name: "E7505 Hub Interface B PCI-to-PCI Bridge RAS Controller"},
			{ID: 0x255d, Name: "E7205 Memory Controller Hub"},
			{ID: 0x2560, Name: "82845G/GL[Brookdale-G]/GE/PE DRAM Controller/Host-Hub Interface"},
			{ID: 0x2561, Name: "82845G/GL[Brookdale-G]/GE/PE Host-to-AGP Bridge"},
			{ID: 0x2562, Name: "82845G/GL[Brookdale-G]/GE Chipset Integrated Graphics Device"},
			{ID: 0x2570, Name: "82865G/PE/P DRAM Controller/Host-Hub Interface"},
			{ID: 0x2571, Name: "82865G/PE/P AGP Bridge"},
			{ID: 0x2572, Name: "82865G Integrated Graphics Controller"},
			{ID: 0x2573, Name: "82865G/PE/P PCI to CSA Bridge"},
			{ID: 0x2576, Name: "82865G/PE/P Processor to I/O Memory Interface"},
			{ID: 0x2578, Name: "82875P/E7210 Memory Controller Hub"},
			{ID: 0x2579, Name: "82875P Processor to AGP Controller"},
			{ID: 0x257b, Name: "82875P/E7210 Processor to PCI to CSA Bridge"},
			{ID: 0x257e, Name: "82875P/E7210 Processor to I/O Memory Interface"},
			{ID: 0x2580, Name: "82915G/P/GV/GL/PL/910GL Memory Controller Hub"},
			{ID: 0x2581, Name: "82915G/P/GV/GL/PL/910GL PCI Express Root Port"},
			{ID: 0x2582, Name: "82915G/GV/910GL Integrated Graphics Controller"},
			{ID: 0x2584, Name: "82925X/XE Memory Controller Hub"},
			{ID: 0x2585, Name: "82925X/XE PCI Express Root Port"},
			{ID: 0x2588, Name: "E7220/E7221 Memory Controller Hub"},
			{ID: 0x2589, Name: "E7220/E7221 PCI Express Root Port"},
			{ID: 0x258a, Name: "E7221 Integrated Graphics Controller"},
			{ID: 0x2590, Name: "Mobile 915GM/PM/GMS/910GML Express Processor to DRAM Controller"},
			{ID: 0x2591, Name: "Mobile 915GM/PM Express PCI Express Root Port"},
			{ID: 0x2592, Name: "Mobile 915GM/GMS/910GML Express Graphics Controller"},
			{ID: 0x25a1, Name: "6300ESB LPC Interface Controller"},
			{ID: 0x25a2, Name: "6300ESB PATA Storage Controller"},
			{ID: 0x25a3, Name: "6300ESB SATA Storage Controller"},
			{ID: 0x25a4, Name: "6300ESB SMBus Controller"},
			{ID: 0x25a6, Name: "6300ESB AC'97 Audio Controller"},
			{ID: 0x25a7, Name: "6300ESB AC'97 Modem Controller"},
			{ID: 0x25a9, Name: "6300ESB USB Universal Host Controller"},
			{ID: 0x25aa, Name: "6300ESB USB Universal Host Controller"},
			{ID: 0x25ab, Name: "6300ESB Watchdog Timer"},
			{ID: 0x25ac, Name: "6300ESB I/O Advanced Programmable Interrupt Controller"},
			{ID: 0x25ad, Name: "6300ESB USB2 Enhanced Host Controller"},
			{ID: 0x25ae, Name: "6300ESB 64-bit PCI-X Bridge"},
			{ID: 0x25b0, Name: "6300ESB SATA RAID Controller"},
			{ID: 0x25c0, Name: "5000X Chipset Memory Controller Hub"},
			{ID: 0x25d0, Name: "5000Z Chipset Memory Controller Hub"},
			{ID: 0x25d4, Name: "5000V Chipset Memory Controller Hub"},
			{ID: 0x25d8, Name: "5000P Chipset Memory Controller Hub"},
			{ID: 0x25e2, Name: "5000 Series Chipset PCI Express x4 Port 2"},
			{ID: 0x25e3, Name: "5000 Series Chipset PCI Express x4 Port 3"},
			{ID: 0x25e4, Name: "5000 Series Chipset PCI Express x4 Port 4"},
			{ID: 0x25e5, Name: "5000 Series Chipset PCI Express x4 Port 5"},
			{ID: 0x25e6, Name: "5000 Series Chipset PCI Express x4 Port 6"},
			{ID: 0x25e7, Name: "5000 Series Chipset PCI Express x4 Port 7"},
			{ID: 0x25f0, Name: "5000 Series Chipset FSB Registers"},
			{ID: 0x25f1, Name: "5000 Series Chipset Reserved Registers"},
			{ID: 0x25f3, Name: "5000 Series Chipset Reserved Registers"},
			{ID: 0x25f5, Name: "5000 Series Chipset FBD Registers"},
			{ID: 0x25f6, Name: "5000 Series Chipset FBD Registers"},
			{ID: 0x25f7, Name: "5000 Series Chipset PCI Express x8 Port 2-3"},
			{ID: 0x25f8, Name: "5000 Series Chipset PCI Express x8 Port 4-5"},
			{ID: 0x25f9, Name: "5000 Series Chipset PCI Express x8 Port 6-7"},
			{ID: 0x25fa, Name: "5000X Chipset PCI Express x16 Port 4-7"},
			{ID: 0x2600, Name: "E8500/E8501 Hub Interface 1.5"},
			{ID: 0x2601, Name: "E8500/E8501 PCI Express x4 Port D"},
			{ID: 0x2602, Name: "E8500/E8501 PCI Express x4 Port C0"},
			{ID: 0x2603, Name: "E8500/E8501 PCI Express x4 Port C1"},
			{ID: 0x2604, Name: "E8500/E8501 PCI Express x4 Port B0"},
			{ID: 0x2605, Name: "E8500/E8501 PCI Express x4 Port B1"},
			{ID: 0x2606, Name: "E8500/E8501 PCI Express x4 Port A0"},
			{ID: 0x2607, Name: "E8500/E8501 PCI Express x4 Port A1"},
			{ID: 0x2608, Name: "E8500/E8501 PCI Express x8 Port C"},
			{ID: 0x2609, Name: "E8500/E8501 PCI Express x8 Port B"},
			{ID: 0x260a, Name: "E8500/E8501 PCI Express x8 Port A"},
			{ID: 0x260c, Name: "E8500/E8501 IMI Registers"},
			{ID: 0x2610, Name: "E8500/E8501 FSB Registers"},
			{ID: 0x2611, Name: "E8500/E8501 Address Mapping Registers"},
			{ID: 0x2612, Name: "E8500/E8501 RAS Registers"},
			{ID: 0x2613, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x2614, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x2615, Name: "E8500/E8501 Miscellaneous Registers"},
			{ID: 0x2617, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x2618, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x2619, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x261a, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x261b, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x261c, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x261d, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x261e, Name: "E8500/E8501 Reserved Registers"},
			{ID: 0x2620, Name: "E8500/E8501 eXternal Memory Bridge"},
			{ID: 0x2621, Name: "E8500/E8501 XMB Miscellaneous Registers"},
			{ID: 0x2622, Name: "E8500/E8501 XMB Memory Interleaving Registers"},
			{ID: 0x2623, Name: "E8500/E8501 XMB DDR Initialization and Calibration"},
			{ID: 0x2624, Name: "E8500/E8501 XMB Reserved Registers"},
			{ID: 0x2625, Name: "E8500/E8501 XMB Reserved Registers"},
			{ID: 0x2626, Name: "E8500/E8501 XMB Reserved Registers"},
			{ID: 0x2627, Name: "E8500/E8501 XMB Reserved Registers"},
			{ID: 0x2640, Name: "82801FB/FR (ICH6/ICH6R) LPC Interface Bridge"},
			{ID: 0x2641, Name: "82801FBM (ICH6M) LPC Interface Bridge"},
			{ID: 0x2642, Name: "82801FW/FRW (ICH6W/ICH6RW) LPC Interface Bridge"},
			{ID: 0x2651, Name: "82801FB/FW (ICH6/ICH6W) SATA Controller"},
			{ID: 0x2652, Name: "82801FR/FRW (ICH6R/ICH6RW) SATA Controller"},
			{ID: 0x2653, Name: "82801FBM (ICH6M) SATA Controller"},
			{ID: 0x2658, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #1"},
			{ID: 0x2659, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #2"},
			{ID: 0x265a, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #3"},
			{ID: 0x265b, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #4"},
			{ID: 0x265c, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB2 EHCI Controller"},
			{ID: 0x2660, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 1"},
			{ID: 0x2662, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 2"},
			{ID: 0x2664, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 3"},
			{ID: 0x2666, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 4"},
			{ID: 0x2668, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) High Definition Audio Controller"},
			{ID: 0x266a, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) SMBus Controller"},
			{ID: 0x266c, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) LAN Controller"},
			{ID: 0x266d, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) AC'97 Modem Controller"},
			{ID: 0x266e, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) AC'97 Audio Controller"},
			{ID: 0x266f, Name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) IDE Controller"},
			{ID: 0x2670, Name: "631xESB/632xESB/3100 Chipset LPC Interface Controller"},
			{ID: 0x2680, Name: "631xESB/632xESB/3100 Chipset SATA IDE Controller"},
			{ID: 0x2681, Name: "631xESB/632xESB SATA AHCI Controller"},
			{ID: 0x2682, Name: "631xESB/632xESB SATA RAID Controller"},
			{ID: 0x2683, Name: "631xESB/632xESB SATA RAID Controller"},
			{ID: 0x2688, Name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #1"},
			{ID: 0x2689, Name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #2"},
			{ID: 0x268a, Name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #3"},
			{ID: 0x268b, Name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #4"},
			{ID: 0x268c, Name: "631xESB/632xESB/3100 Chipset EHCI USB2 Controller"},
			{ID: 0x2690, Name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 1"},
			{ID: 0x2692, Name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 2"},
			{ID: 0x2694, Name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 3"},
			{ID: 0x2696, Name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 4"},
			{ID: 0x2698, Name: "631xESB/632xESB AC '97 Audio Controller"},
			{ID: 0x2699, Name: "631xESB/632xESB AC '97 Modem Controller"},
			{ID: 0x269a, Name: "631xESB/632xESB High Definition Audio Controller"},
			{ID: 0x269b, Name: "631xESB/632xESB/3100 Chipset SMBus Controller"},
			{ID: 0x269e, Name: "631xESB/632xESB IDE Controller"},
			{ID: 0x2700, Name: "Optane SSD 900P Series"},
			{ID: 0x2701, Name: "NVMe Datacenter SSD [Optane]"},
			{ID: 0x2723, Name: "Wi-Fi 6 AX200"},
			{ID: 0x2725, Name: "Wi-Fi 6 AX210/AX211/AX411 160MHz"},
			{ID: 0x2770, Name: "82945G/GZ/P/PL Memory Controller Hub"},
			{ID: 0x2771, Name: "82945G/GZ/P/PL PCI Express Root Port"},
			{ID: 0x2772, Name: "82945G/GZ Integrated Graphics Controller"},
			{ID: 0x2774, Name: "82955X Memory Controller Hub"},
			{ID: 0x2775, Name: "82955X PCI Express Root Port"},
			{ID: 0x2776, Name: "82945G/GZ Integrated Graphics Controller"},
			{ID: 0x2778, Name: "E7230/3000/3010 Memory Controller Hub"},
			{ID: 0x2779, Name: "E7230/3000/3010 PCI Express Root Port"},
			{ID: 0x277a, Name: "82975X/3010 PCI Express Root Port"},
			{ID: 0x277c, Name: "82975X Memory Controller Hub"},
			{ID: 0x277d, Name: "82975X PCI Express Root Port"},
			{ID: 0x2780, Name: "82915G/GV/GL/910GL [Grantsdale] Graphics Device"},
			{ID: 0x2782, Name: "82915G Integrated Graphics Controller"},
			{ID: 0x2792, Name: "Mobile 915GM/GMS/910GML Express Graphics Controller"},
			{ID: 0x27a0, Name: "Mobile 945GM/PM/GMS, 943/940GML and 945GT Express Memory Controller Hub"},
			{ID: 0x27a1, Name: "Mobile 945GM/PM/GMS, 943/940GML and 945GT Express PCI Express Root Port"},
			{ID: 0x27a2, Name: "Mobile 945GM/GMS, 943/940GML Express Integrated Graphics Controller"},
			{ID: 0x27a6, Name: "Mobile 945GM/GMS/GME, 943/940GML Express Integrated Graphics Controller"},
			{ID: 0x27ac, Name: "Mobile 945GSE Express Memory Controller Hub"},
			{ID: 0x27ad, Name: "Mobile 945GSE Express PCI Express Root Port"},
			{ID: 0x27ae, Name: "Mobile 945GSE Express Integrated Graphics Controller"},
			{ID: 0x27b0, Name: "82801GH (ICH7DH) LPC Interface Bridge"},
			{ID: 0x27b8, Name: "82801GB/GR (ICH7 Family) LPC Interface Bridge"},
			{ID: 0x27b9, Name: "82801GBM (ICH7-M) LPC Interface Bridge"},
			{ID: 0x27bc, Name: "NM10 Family LPC Controller"},
			{ID: 0x27bd, Name: "82801GHM (ICH7-M DH) LPC Interface Bridge"},
			{ID: 0x27c0, Name: "NM10/ICH7 Family SATA Controller [IDE mode]"},
			{ID: 0x27c1, Name: "NM10/ICH7 Family SATA Controller [AHCI mode]"},
			{ID: 0x27c3, Name: "82801GR/GDH (ICH7R/ICH7DH) SATA Controller [RAID mode]"},
			{ID: 0x27c4, Name: "82801GBM/GHM (ICH7-M Family) SATA Controller [IDE mode]"},
			{ID: 0x27c5, Name: "82801GBM/GHM (ICH7-M Family) SATA Controller [AHCI mode]"},
			{ID: 0x27c6, Name: "82801GHM (ICH7-M DH) SATA Controller [RAID mode]"},
			{ID: 0x27c8, Name: "NM10/ICH7 Family USB UHCI Controller #1"},
			{ID: 0x27c9, Name: "NM10/ICH7 Family USB UHCI Controller #2"},
			{ID: 0x27ca, Name: "NM10/ICH7 Family USB UHCI Controller #3"},
			{ID: 0x27cb, Name: "NM10/ICH7 Family USB UHCI Controller #4"},
			{ID: 0x27cc, Name: "NM10/ICH7 Family USB2 EHCI Controller"},
			{ID: 0x27d0, Name: "NM10/ICH7 Family PCI Express Port 1"},
			{ID: 0x27d2, Name: "NM10/ICH7 Family PCI Express Port 2"},
			{ID: 0x27d4, Name: "NM10/ICH7 Family PCI Express Port 3"},
			{ID: 0x27d6, Name: "NM10/ICH7 Family PCI Express Port 4"},
			{ID: 0x27d8, Name: "NM10/ICH7 Family High Definition Audio Controller"},
			{ID: 0x27da, Name: "NM10/ICH7 Family SMBus Controller"},
			{ID: 0x27dc, Name: "NM10/ICH7 Family LAN Controller"},
			{ID: 0x27dd, Name: "82801G (ICH7 Family) AC'97 Modem Controller"},
			{ID: 0x27de, Name: "82801G (ICH7 Family) AC'97 Audio Controller"},
			{ID: 0x27df, Name: "82801G (ICH7 Family) IDE Controller"},
			{ID: 0x27e0, Name: "82801GR/GH/GHM (ICH7 Family) PCI Express Port 5"},
			{ID: 0x27e2, Name: "82801GR/GH/GHM (ICH7 Family) PCI Express Port 6"},
			{ID: 0x2810, Name: "82801HB/HR (ICH8/R) LPC Interface Controller"},
			{ID: 0x2811, Name: "82801HEM (ICH8M-E) LPC Interface Controller"},
			{ID: 0x2812, Name: "82801HH (ICH8DH) LPC Interface Controller"},
			{ID: 0x2814, Name: "82801HO (ICH8DO) LPC Interface Controller"},
			{ID: 0x2815, Name: "82801HM (ICH8M) LPC Interface Controller"},
			{ID: 0x2820, Name: "82801H (ICH8 Family) 4 port SATA Controller [IDE mode]"},
			{ID: 0x2821, Name: "82801HR/HO/HH (ICH8R/DO/DH) 6 port SATA Controller [AHCI mode]"},
			{ID: 0x2822, Name: "SATA Controller [RAID mode]"},
			{ID: 0x2823, Name: "C610/X99 series chipset sSATA Controller [RAID mode]"},
			{ID: 0x2824, Name: "82801HB (ICH8) 4 port SATA Controller [AHCI mode]"},
			{ID: 0x2825, Name: "82801HR/HO/HH (ICH8R/DO/DH) 2 port SATA Controller [IDE mode]"},
			{ID: 0x2826, Name: "C600/X79 series chipset SATA RAID Controller"},
			{ID: 0x2827, Name: "C610/X99 series chipset sSATA Controller [RAID mode]"},
			{ID: 0x2828, Name: "82801HM/HEM (ICH8M/ICH8M-E) SATA Controller [IDE mode]"},
			{ID: 0x2829, Name: "82801HM/HEM (ICH8M/ICH8M-E) SATA Controller [AHCI mode]"},
			{ID: 0x282a, Name: "82801 Mobile SATA Controller [RAID mode]"},
			{ID: 0x2830, Name: "82801H (ICH8 Family) USB UHCI Controller #1"},
			{ID: 0x2831, Name: "82801H (ICH8 Family) USB UHCI Controller #2"},
			{ID: 0x2832, Name: "82801H (ICH8 Family) USB UHCI Controller #3"},
			{ID: 0x2833, Name: "82801H (ICH8 Family) USB UHCI Controller #4"},
			{ID: 0x2834, Name: "82801H (ICH8 Family) USB UHCI Controller #4"},
			{ID: 0x2835, Name: "82801H (ICH8 Family) USB UHCI Controller #5"},
			{ID: 0x2836, Name: "82801H (ICH8 Family) USB2 EHCI Controller #1"},
			{ID: 0x283a, Name: "82801H (ICH8 Family) USB2 EHCI Controller #2"},
			{ID: 0x283e, Name: "82801H (ICH8 Family) SMBus Controller"},
			{ID: 0x283f, Name: "82801H (ICH8 Family) PCI Express Port 1"},
			{ID: 0x2841, Name: "82801H (ICH8 Family) PCI Express Port 2"},
			{ID: 0x2843, Name: "82801H (ICH8 Family) PCI Express Port 3"},
			{ID: 0x2845, Name: "82801H (ICH8 Family) PCI Express Port 4"},
			{ID: 0x2847, Name: "82801H (ICH8 Family) PCI Express Port 5"},
			{ID: 0x2849, Name: "82801H (ICH8 Family) PCI Express Port 6"},
			{ID: 0x284b, Name: "82801H (ICH8 Family) HD Audio Controller"},
			{ID: 0x284f, Name: "82801H (ICH8 Family) Thermal Reporting Device"},
			{ID: 0x2850, Name: "82801HM/HEM (ICH8M/ICH8M-E) IDE Controller"},
			{ID: 0x28c0, Name: "Volume Management Device NVMe RAID Controller"},
			{ID: 0x2912, Name: "82801IH (ICH9DH) LPC Interface Controller"},
			{ID: 0x2914, Name: "82801IO (ICH9DO) LPC Interface Controller"},
			{ID: 0x2916, Name: "82801IR (ICH9R) LPC Interface Controller"},
			{ID: 0x2917, Name: "ICH9M-E LPC Interface Controller"},
			{ID: 0x2918, Name: "82801IB (ICH9) LPC Interface Controller"},
			{ID: 0x2919, Name: "ICH9M LPC Interface Controller"},
			{ID: 0x2920, Name: "82801IR/IO/IH (ICH9R/DO/DH) 4 port SATA Controller [IDE mode]"},
			{ID: 0x2921, Name: "82801IB (ICH9) 2 port SATA Controller [IDE mode]"},
			{ID: 0x2922, Name: "82801IR/IO/IH (ICH9R/DO/DH) 6 port SATA Controller [AHCI mode]"},
			{ID: 0x2923, Name: "82801IB (ICH9) 4 port SATA Controller [AHCI mode]"},
			{ID: 0x2925, Name: "82801IR/IO (ICH9R/DO) SATA Controller [RAID mode]"},
			{ID: 0x2926, Name: "82801I (ICH9 Family) 2 port SATA Controller [IDE mode]"},
			{ID: 0x2928, Name: "82801IBM/IEM (ICH9M/ICH9M-E) 2 port SATA Controller [IDE mode]"},
			{ID: 0x2929, Name: "82801IBM/IEM (ICH9M/ICH9M-E) 4 port SATA Controller [AHCI mode]"},
			{ID: 0x292c, Name: "82801IEM (ICH9M-E) SATA Controller [RAID mode]"},
			{ID: 0x292d, Name: "82801IBM/IEM (ICH9M/ICH9M-E) 2 port SATA Controller [IDE mode]"},
			{ID: 0x2930, Name: "82801I (ICH9 Family) SMBus Controller"},
			{ID: 0x2932, Name: "82801I (ICH9 Family) Thermal Subsystem"},
			{ID: 0x2934, Name: "82801I (ICH9 Family) USB UHCI Controller #1"},
			{ID: 0x2935, Name: "82801I (ICH9 Family) USB UHCI Controller #2"},
			{ID: 0x2936, Name: "82801I (ICH9 Family) USB UHCI Controller #3"},
			{ID: 0x2937, Name: "82801I (ICH9 Family) USB UHCI Controller #4"},
			{ID: 0x2938, Name: "82801I (ICH9 Family) USB UHCI Controller #5"},
			{ID: 0x2939, Name: "82801I (ICH9 Family) USB UHCI Controller #6"},
			{ID: 0x293a, Name: "82801I (ICH9 Family) USB2 EHCI Controller #1"},
			{ID: 0x293c, Name: "82801I (ICH9 Family) USB2 EHCI Controller #2"},
			{ID: 0x293e, Name: "82801I (ICH9 Family) HD Audio Controller"},
			{ID: 0x2940, Name: "82801I (ICH9 Family) PCI Express Port 1"},
			{ID: 0x2942, Name: "82801I (ICH9 Family) PCI Express Port 2"},
			{ID: 0x2944, Name: "82801I (ICH9 Family) PCI Express Port 3"},
			{ID: 0x2946, Name: "82801I (ICH9 Family) PCI Express Port 4"},
			{ID: 0x2948, Name: "82801I (ICH9 Family) PCI Express Port 5"},
			{ID: 0x294a, Name: "82801I (ICH9 Family) PCI Express Port 6"},
			{ID: 0x294c, Name: "82566DC-2 Gigabit Network Connection"},
			{ID: 0x2970, Name: "82946GZ/PL/GL Memory Controller Hub"},
			{ID: 0x2971, Name: "82946GZ/PL/GL PCI Express Root Port"},
			{ID: 0x2972, Name: "82946GZ/GL Integrated Graphics Controller"},
			{ID: 0x2973, Name: "82946GZ/GL Integrated Graphics Controller"},
			{ID: 0x2974, Name: "82946GZ/GL HECI Controller"},
			{ID: 0x2975, Name: "82946GZ/GL HECI Controller"},
			{ID: 0x2976, Name: "82946GZ/GL PT IDER Controller"},
			{ID: 0x2977, Name: "82946GZ/GL KT Controller"},
			{ID: 0x2980, Name: "82G35 Express DRAM Controller"},
			{ID: 0x2981, Name: "82G35 Express PCI Express Root Port"},
			{ID: 0x2982, Name: "82G35 Express Integrated Graphics Controller"},
			{ID: 0x2983, Name: "82G35 Express Integrated Graphics Controller"},
			{ID: 0x2984, Name: "82G35 Express HECI Controller"},
			{ID: 0x2990, Name: "82Q963/Q965 Memory Controller Hub"},
			{ID: 0x2991, Name: "82Q963/Q965 PCI Express Root Port"},
			{ID: 0x2992, Name: "82Q963/Q965 Integrated Graphics Controller"},
			{ID: 0x2993, Name: "82Q963/Q965 Integrated Graphics Controller"},
			{ID: 0x2994, Name: "82Q963/Q965 HECI Controller"},
			{ID: 0x2995, Name: "82Q963/Q965 HECI Controller"},
			{ID: 0x2996, Name: "82Q963/Q965 PT IDER Controller"},
			{ID: 0x2997, Name: "82Q963/Q965 KT Controller"},
			{ID: 0x29a0, Name: "82P965/G965 Memory Controller Hub"},
			{ID: 0x29a1, Name: "82P965/G965 PCI Express Root Port"},
			{ID: 0x29a2, Name: "82G965 Integrated Graphics Controller"},
			{ID: 0x29a3, Name: "82G965 Integrated Graphics Controller"},
			{ID: 0x29a4, Name: "82P965/G965 HECI Controller"},
			{ID: 0x29a5, Name: "82P965/G965 HECI Controller"},
			{ID: 0x29a6, Name: "82P965/G965 PT IDER Controller"},
			{ID: 0x29a7, Name: "82P965/G965 KT Controller"},
			{ID: 0x29b0, Name: "82Q35 Express DRAM Controller"},
			{ID: 0x29b1, Name: "82Q35 Express PCI Express Root Port"},
			{ID: 0x29b2, Name: "82Q35 Express Integrated Graphics Controller"},
			{ID: 0x29b3, Name: "82Q35 Express Integrated Graphics Controller"},
			{ID: 0x29b4, Name: "82Q35 Express MEI Controller"},
			{ID: 0x29b5, Name: "82Q35 Express MEI Controller"},
			{ID: 0x29b6, Name: "82Q35 Express PT IDER Controller"},
			{ID: 0x29b7, Name: "82Q35 Express Serial KT Controller"},
			{ID: 0x29c0, Name: "82G33/G31/P35/P31 Express DRAM Controller"},
			{ID: 0x29c1, Name: "82G33/G31/P35/P31 Express PCI Express Root Port"},
			{ID: 0x29c2, Name: "82G33/G31 Express Integrated Graphics Controller"},
			{ID: 0x29c3, Name: "82G33/G31 Express Integrated Graphics Controller"},
			{ID: 0x29c4, Name: "82G33/G31/P35/P31 Express MEI Controller"},
			{ID: 0x29c5, Name: "82G33/G31/P35/P31 Express MEI Controller"},
			{ID: 0x29c6, Name: "82G33/G31/P35/P31 Express PT IDER Controller"},
			{ID: 0x29c7, Name: "82G33/G31/P35/P31 Express Serial KT Controller"},
			{ID: 0x29cf, Name: "Virtual HECI Controller"},
			{ID: 0x29d0, Name: "82Q33 Express DRAM Controller"},
			{ID: 0x29d1, Name: "82Q33 Express PCI Express Root Port"},
			{ID: 0x29d2, Name: "82Q33 Express Integrated Graphics Controller"},
			{ID: 0x29d3, Name: "82Q33 Express Integrated Graphics Controller"},
			{ID: 0x29d4, Name: "82Q33 Express MEI Controller"},
			{ID: 0x29d5, Name: "82Q33 Express MEI Controller"},
			{ID: 0x29d6, Name: "82Q33 Express PT IDER Controller"},
			{ID: 0x29d7, Name: "82Q33 Express Serial KT Controller"},
			{ID: 0x29e0, Name: "82X38/X48 Express DRAM Controller"},
			{ID: 0x29e1, Name: "82X38/X48 Express Host-Primary PCI Express Bridge"},
			{ID: 0x29e4, Name: "82X38/X48 Express MEI Controller"},
			{ID: 0x29e5, Name: "82X38/X48 Express MEI Controller"},
			{ID: 0x29e6, Name: "82X38/X48 Express PT IDER Controller"},
			{ID: 0x29e7, Name: "82X38/X48 Express Serial KT Controller"},
			{ID: 0x29e9, Name: "82X38/X48 Express Host-Secondary PCI Express Bridge"},
			{ID: 0x29f0, Name: "3200/3210 Chipset DRAM Controller"},
			{ID: 0x29f1, Name: "3200/3210 Chipset Host-Primary PCI Express Bridge"},
			{ID: 0x29f4, Name: "3200/3210 Chipset MEI Controller"},
			{ID: 0x29f5, Name: "3200/3210 Chipset MEI Controller"},
			{ID: 0x29f6, Name: "3200/3210 Chipset PT IDER Controller"},
			{ID: 0x29f7, Name: "3200/3210 Chipset Serial KT Controller"},
			{ID: 0x29f9, Name: "3210 Chipset Host-Secondary PCI Express Bridge"},
			{ID: 0x2a00, Name: "Mobile PM965/GM965/GL960 Memory Controller Hub"},
			{ID: 0x2a01, Name: "Mobile PM965/GM965/GL960 PCI Express Root Port"},
			{ID: 0x2a02, Name: "Mobile GM965/GL960 Integrated Graphics Controller (primary)"},
			{ID: 0x2a03, Name: "Mobile GM965/GL960 Integrated Graphics Controller (secondary)"},
			{ID: 0x2a04, Name: "Mobile PM965/GM965 MEI Controller"},
			{ID: 0x2a05, Name: "Mobile PM965/GM965 MEI Controller"},
			{ID: 0x2a06, Name: "Mobile PM965/GM965 PT IDER Controller"},
			{ID: 0x2a07, Name: "Mobile PM965/GM965 KT Controller"},
			{ID: 0x2a10, Name: "Mobile GME965/GLE960 Memory Controller Hub"},
			{ID: 0x2a11, Name: "Mobile GME965/GLE960 PCI Express Root Port"},
			{ID: 0x2a12, Name: "Mobile GME965/GLE960 Integrated Graphics Controller"},
			{ID: 0x2a13, Name: "Mobile GME965/GLE960 Integrated Graphics Controller"},
			{ID: 0x2a14, Name: "Mobile GME965/GLE960 MEI Controller"},
			{ID: 0x2a15, Name: "Mobile GME965/GLE960 MEI Controller"},
			{ID: 0x2a16, Name: "Mobile GME965/GLE960 PT IDER Controller"},
			{ID: 0x2a17, Name: "Mobile GME965/GLE960 KT Controller"},
			{ID: 0x2a40, Name: "Mobile 4 Series Chipset Memory Controller Hub"},
			{ID: 0x2a41, Name: "Mobile 4 Series Chipset PCI Express Graphics Port"},
			{ID: 0x2a42, Name: "Mobile 4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2a43, Name: "Mobile 4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2a44, Name: "Mobile 4 Series Chipset MEI Controller"},
			{ID: 0x2a45, Name: "Mobile 4 Series Chipset MEI Controller"},
			{ID: 0x2a46, Name: "Mobile 4 Series Chipset PT IDER Controller"},
			{ID: 0x2a47, Name: "Mobile 4 Series Chipset AMT SOL Redirection"},
			{ID: 0x2a50, Name: "Cantiga MEI Controller"},
			{ID: 0x2a51, Name: "Cantiga MEI Controller"},
			{ID: 0x2a52, Name: "Cantiga PT IDER Controller"},
			{ID: 0x2a53, Name: "Cantiga AMT SOL Redirection"},
			{ID: 0x2b00, Name: "Xeon Processor E7 Product Family System Configuration Controller 1"},
			{ID: 0x2b02, Name: "Xeon Processor E7 Product Family System Configuration Controller 2"},
			{ID: 0x2b04, Name: "Xeon Processor E7 Product Family Power Controller"},
			{ID: 0x2b08, Name: "Xeon Processor E7 Product Family Caching Agent 0"},
			{ID: 0x2b0c, Name: "Xeon Processor E7 Product Family Caching Agent 1"},
			{ID: 0x2b10, Name: "Xeon Processor E7 Product Family QPI Home Agent 0"},
			{ID: 0x2b13, Name: "Xeon Processor E7 Product Family Memory Controller 0c"},
			{ID: 0x2b14, Name: "Xeon Processor E7 Product Family Memory Controller 0a"},
			{ID: 0x2b16, Name: "Xeon Processor E7 Product Family Memory Controller 0b"},
			{ID: 0x2b18, Name: "Xeon Processor E7 Product Family QPI Home Agent 1"},
			{ID: 0x2b1b, Name: "Xeon Processor E7 Product Family Memory Controller 1c"},
			{ID: 0x2b1c, Name: "Xeon Processor E7 Product Family Memory Controller 1a"},
			{ID: 0x2b1e, Name: "Xeon Processor E7 Product Family Memory Controller 1b"},
			{ID: 0x2b20, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 0"},
			{ID: 0x2b22, Name: "Xeon Processor E7 Product Family System Configuration Controller 3"},
			{ID: 0x2b24, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 1"},
			{ID: 0x2b28, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 2"},
			{ID: 0x2b2a, Name: "Xeon Processor E7 Product Family System Configuration Controller 4"},
			{ID: 0x2b2c, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 3"},
			{ID: 0x2b30, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 4"},
			{ID: 0x2b34, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 5"},
			{ID: 0x2b38, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 6"},
			{ID: 0x2b3c, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 7"},
			{ID: 0x2b40, Name: "Xeon Processor E7 Product Family QPI Router Port 0-1"},
			{ID: 0x2b42, Name: "Xeon Processor E7 Product Family QPI Router Port 2-3"},
			{ID: 0x2b44, Name: "Xeon Processor E7 Product Family QPI Router Port 4-5"},
			{ID: 0x2b46, Name: "Xeon Processor E7 Product Family QPI Router Port 6-7"},
			{ID: 0x2b48, Name: "Xeon Processor E7 Product Family Test and Debug 0"},
			{ID: 0x2b4c, Name: "Xeon Processor E7 Product Family Test and Debug 1"},
			{ID: 0x2b50, Name: "Xeon Processor E7 Product Family QPI Physical Port 0: REUT control/status"},
			{ID: 0x2b52, Name: "Xeon Processor E7 Product Family QPI Physical Port 0: Misc. control/status"},
			{ID: 0x2b54, Name: "Xeon Processor E7 Product Family QPI Physical Port 1: REUT control/status"},
			{ID: 0x2b56, Name: "Xeon Processor E7 Product Family QPI Physical Port 1: Misc. control/status"},
			{ID: 0x2b58, Name: "Xeon Processor E7 Product Family QPI Physical Port 2: REUT control/status"},
			{ID: 0x2b5a, Name: "Xeon Processor E7 Product Family QPI Physical Port 2: Misc. control/status"},
			{ID: 0x2b5c, Name: "Xeon Processor E7 Product Family QPI Physical Port 3: REUT control/status"},
			{ID: 0x2b5e, Name: "Xeon Processor E7 Product Family QPI Physical Port 3: Misc. control/status"},
			{ID: 0x2b60, Name: "Xeon Processor E7 Product Family SMI Physical Port 0: REUT control/status"},
			{ID: 0x2b62, Name: "Xeon Processor E7 Product Family SMI Physical Port 0: Misc control/status"},
			{ID: 0x2b64, Name: "Xeon Processor E7 Product Family SMI Physical Port 1: REUT control/status"},
			{ID: 0x2b66, Name: "Xeon Processor E7 Product Family SMI Physical Port 1: Misc control/status"},
			{ID: 0x2b68, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 8"},
			{ID: 0x2b6c, Name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 9"},
			{ID: 0x2b80, Name: "Atom CE2700 Series [Puma 7]"},
			{ID: 0x2b98, Name: "Puma 7 Trusted Execution Engine"},
			{ID: 0x2bb5, Name: "Puma 7 xHCI Controller"},
			{ID: 0x2bb7, Name: "Puma 7 USB Device Controller (OTG)"},
			{ID: 0x2bdc, Name: "Puma 7 Thermal"},
			{ID: 0x2be2, Name: "Puma 7 Security Processor"},
			{ID: 0x2c01, Name: "Xeon 5500/Core i7 QuickPath Architecture System Address Decoder"},
			{ID: 0x2c10, Name: "Xeon 5500/Core i7 QPI Link 0"},
			{ID: 0x2c11, Name: "Xeon 5500/Core i7 QPI Physical 0"},
			{ID: 0x2c14, Name: "Xeon 5500/Core i7 QPI Link 1"},
			{ID: 0x2c15, Name: "Xeon 5500/Core i7 QPI Physical 1"},
			{ID: 0x2c18, Name: "Xeon 5500/Core i7 Integrated Memory Controller"},
			{ID: 0x2c19, Name: "Xeon 5500/Core i7 Integrated Memory Controller Target Address Decoder"},
			{ID: 0x2c1a, Name: "Xeon 5500/Core i7 Integrated Memory Controller RAS Registers"},
			{ID: 0x2c1c, Name: "Xeon 5500/Core i7 Integrated Memory Controller Test Registers"},
			{ID: 0x2c20, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Control Registers"},
			{ID: 0x2c21, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Address Registers"},
			{ID: 0x2c22, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Rank Registers"},
			{ID: 0x2c23, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Thermal Control Registers"},
			{ID: 0x2c28, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Control Registers"},
			{ID: 0x2c29, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Address Registers"},
			{ID: 0x2c2a, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Rank Registers"},
			{ID: 0x2c2b, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Thermal Control Registers"},
			{ID: 0x2c30, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Control Registers"},
			{ID: 0x2c31, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Address Registers"},
			{ID: 0x2c32, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Rank Registers"},
			{ID: 0x2c33, Name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Thermal Control Registers"},
			{ID: 0x2c40, Name: "Xeon 5500/Core i7 QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c41, Name: "Xeon 5500/Core i7 QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c50, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c51, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c52, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c53, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c54, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c55, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c56, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c57, Name: "Core Processor QuickPath Architecture Generic Non-Core Registers"},
			{ID: 0x2c58, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c59, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c5a, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c5b, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c5c, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c5d, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c5e, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c5f, Name: "Xeon C5500/C3500 QPI Generic Non-core Registers"},
			{ID: 0x2c61, Name: "Core Processor QuickPath Architecture Generic Non-core Registers"},
			{ID: 0x2c62, Name: "Core Processor QuickPath Architecture Generic Non-core Registers"},
			{ID: 0x2c70, Name: "Xeon 5600 Series QuickPath Architecture Generic Non-core Registers"},
			{ID: 0x2c81, Name: "Core Processor QuickPath Architecture System Address Decoder"},
			{ID: 0x2c90, Name: "Core Processor QPI Link 0"},
			{ID: 0x2c91, Name: "Core Processor QPI Physical 0"},
			{ID: 0x2c98, Name: "Core Processor Integrated Memory Controller"},
			{ID: 0x2c99, Name: "Core Processor Integrated Memory Controller Target Address Decoder"},
			{ID: 0x2c9a, Name: "Core Processor Integrated Memory Controller Test Registers"},
			{ID: 0x2c9c, Name: "Core Processor Integrated Memory Controller Test Registers"},
			{ID: 0x2ca0, Name: "Core Processor Integrated Memory Controller Channel 0 Control Registers"},
			{ID: 0x2ca1, Name: "Core Processor Integrated Memory Controller Channel 0 Address Registers"},
			{ID: 0x2ca2, Name: "Core Processor Integrated Memory Controller Channel 0 Rank Registers"},
			{ID: 0x2ca3, Name: "Core Processor Integrated Memory Controller Channel 0 Thermal Control Registers"},
			{ID: 0x2ca8, Name: "Core Processor Integrated Memory Controller Channel 1 Control Registers"},
			{ID: 0x2ca9, Name: "Core Processor Integrated Memory Controller Channel 1 Address Registers"},
			{ID: 0x2caa, Name: "Core Processor Integrated Memory Controller Channel 1 Rank Registers"},
			{ID: 0x2cab, Name: "Core Processor Integrated Memory Controller Channel 1 Thermal Control Registers"},
			{ID: 0x2cc1, Name: "Xeon C5500/C3500 QPI System Address Decoder"},
			{ID: 0x2cd0, Name: "Xeon C5500/C3500 QPI Link 0"},
			{ID: 0x2cd1, Name: "Xeon C5500/C3500 QPI Physical 0"},
			{ID: 0x2cd4, Name: "Xeon C5500/C3500 QPI Link 1"},
			{ID: 0x2cd5, Name: "Xeon C5500/C3500 QPI Physical 1"},
			{ID: 0x2cd8, Name: "Xeon C5500/C3500 Integrated Memory Controller Registers"},
			{ID: 0x2cd9, Name: "Xeon C5500/C3500 Integrated Memory Controller Target Address Decoder"},
			{ID: 0x2cda, Name: "Xeon C5500/C3500 Integrated Memory Controller RAS Registers"},
			{ID: 0x2cdc, Name: "Xeon C5500/C3500 Integrated Memory Controller Test Registers"},
			{ID: 0x2ce0, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Control"},
			{ID: 0x2ce1, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Address"},
			{ID: 0x2ce2, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Rank"},
			{ID: 0x2ce3, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Thermal Control"},
			{ID: 0x2ce8, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Control"},
			{ID: 0x2ce9, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Address"},
			{ID: 0x2cea, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Rank"},
			{ID: 0x2ceb, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Thermal Control"},
			{ID: 0x2cf0, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Control"},
			{ID: 0x2cf1, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Address"},
			{ID: 0x2cf2, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Rank"},
			{ID: 0x2cf3, Name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Thermal Control"},
			{ID: 0x2d01, Name: "Core Processor QuickPath Architecture System Address Decoder"},
			{ID: 0x2d10, Name: "Core Processor QPI Link 0"},
			{ID: 0x2d11, Name: "1st Generation Core i3/5/7 Processor QPI Physical 0"},
			{ID: 0x2d12, Name: "1st Generation Core i3/5/7 Processor Reserved"},
			{ID: 0x2d13, Name: "1st Generation Core i3/5/7 Processor Reserved"},
			{ID: 0x2d81, Name: "Xeon 5600 Series QuickPath Architecture System Address Decoder"},
			{ID: 0x2d90, Name: "Xeon 5600 Series QPI Link 0"},
			{ID: 0x2d91, Name: "Xeon 5600 Series QPI Physical 0"},
			{ID: 0x2d92, Name: "Xeon 5600 Series Mirror Port Link 0"},
			{ID: 0x2d93, Name: "Xeon 5600 Series Mirror Port Link 1"},
			{ID: 0x2d94, Name: "Xeon 5600 Series QPI Link 1"},
			{ID: 0x2d95, Name: "Xeon 5600 Series QPI Physical 1"},
			{ID: 0x2d98, Name: "Xeon 5600 Series Integrated Memory Controller Registers"},
			{ID: 0x2d99, Name: "Xeon 5600 Series Integrated Memory Controller Target Address Decoder"},
			{ID: 0x2d9a, Name: "Xeon 5600 Series Integrated Memory Controller RAS Registers"},
			{ID: 0x2d9c, Name: "Xeon 5600 Series Integrated Memory Controller Test Registers"},
			{ID: 0x2da0, Name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Control"},
			{ID: 0x2da1, Name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Address"},
			{ID: 0x2da2, Name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Rank"},
			{ID: 0x2da3, Name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Thermal Control"},
			{ID: 0x2da8, Name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Control"},
			{ID: 0x2da9, Name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Address"},
			{ID: 0x2daa, Name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Rank"},
			{ID: 0x2dab, Name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Thermal Control"},
			{ID: 0x2db0, Name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Control"},
			{ID: 0x2db1, Name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Address"},
			{ID: 0x2db2, Name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Rank"},
			{ID: 0x2db3, Name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Thermal Control"},
			{ID: 0x2e00, Name: "4 Series Chipset DRAM Controller"},
			{ID: 0x2e01, Name: "4 Series Chipset PCI Express Root Port"},
			{ID: 0x2e02, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e03, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e04, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e05, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e06, Name: "4 Series Chipset PT IDER Controller"},
			{ID: 0x2e07, Name: "4 Series Chipset Serial KT Controller"},
			{ID: 0x2e10, Name: "4 Series Chipset DRAM Controller"},
			{ID: 0x2e11, Name: "4 Series Chipset PCI Express Root Port"},
			{ID: 0x2e12, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e13, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e14, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e15, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e16, Name: "4 Series Chipset PT IDER Controller"},
			{ID: 0x2e17, Name: "4 Series Chipset Serial KT Controller"},
			{ID: 0x2e20, Name: "4 Series Chipset DRAM Controller"},
			{ID: 0x2e21, Name: "4 Series Chipset PCI Express Root Port"},
			{ID: 0x2e22, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e23, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e24, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e25, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e26, Name: "4 Series Chipset PT IDER Controller"},
			{ID: 0x2e27, Name: "4 Series Chipset Serial KT Controller"},
			{ID: 0x2e29, Name: "4 Series Chipset PCI Express Root Port"},
			{ID: 0x2e30, Name: "4 Series Chipset DRAM Controller"},
			{ID: 0x2e31, Name: "4 Series Chipset PCI Express Root Port"},
			{ID: 0x2e32, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e33, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e34, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e35, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e36, Name: "4 Series Chipset PT IDER Controller"},
			{ID: 0x2e37, Name: "4 Series Chipset Serial KT Controller"},
			{ID: 0x2e40, Name: "4 Series Chipset DRAM Controller"},
			{ID: 0x2e41, Name: "4 Series Chipset PCI Express Root Port"},
			{ID: 0x2e42, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e43, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e44, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e45, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e46, Name: "4 Series Chipset PT IDER Controller"},
			{ID: 0x2e47, Name: "4 Series Chipset Serial KT Controller"},
			{ID: 0x2e50, Name: "CE Media Processor CE3100"},
			{ID: 0x2e52, Name: "CE Media Processor Clock and Reset Controller"},
			{ID: 0x2e58, Name: "CE Media Processor Interrupt Controller"},
			{ID: 0x2e5a, Name: "CE Media Processor CE3100 A/V Bridge"},
			{ID: 0x2e5b, Name: "Graphics Media Accelerator 500 Graphics"},
			{ID: 0x2e5c, Name: "CE Media Processor Video Decoder"},
			{ID: 0x2e5d, Name: "CE Media Processor Transport Stream Interface"},
			{ID: 0x2e5e, Name: "CE Media Processor Transport Stream Processor 0"},
			{ID: 0x2e5f, Name: "CE Media Processor Audio DSP"},
			{ID: 0x2e60, Name: "CE Media Processor Audio Interfaces"},
			{ID: 0x2e61, Name: "CE Media Processor Video Display Controller"},
			{ID: 0x2e62, Name: "CE Media Processor Video Processing Unit"},
			{ID: 0x2e63, Name: "CE Media Processor HDMI Tx Interface"},
			{ID: 0x2e64, Name: "Atom CE2600/3100/4100/4200/5300 Security Processor"},
			{ID: 0x2e65, Name: "CE Media Processor Expansion Bus Interface"},
			{ID: 0x2e66, Name: "CE Media Processor UART"},
			{ID: 0x2e67, Name: "CE Media Processor General Purpose I/Os"},
			{ID: 0x2e68, Name: "CE Media Processor I2C Interface"},
			{ID: 0x2e69, Name: "CE Media Processor Smart Card Interface"},
			{ID: 0x2e6a, Name: "CE Media Processor SPI Master Interface"},
			{ID: 0x2e6e, Name: "CE Media Processor Gigabit Ethernet Controller"},
			{ID: 0x2e6f, Name: "CE Media Processor Media Timing Unit"},
			{ID: 0x2e70, Name: "CE Media Processor USB"},
			{ID: 0x2e71, Name: "CE Media Processor SATA"},
			{ID: 0x2e73, Name: "CE Media Processor CE3100 PCI Express"},
			{ID: 0x2e90, Name: "4 Series Chipset DRAM Controller"},
			{ID: 0x2e91, Name: "4 Series Chipset PCI Express Root Port"},
			{ID: 0x2e92, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e93, Name: "4 Series Chipset Integrated Graphics Controller"},
			{ID: 0x2e94, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e95, Name: "4 Series Chipset HECI Controller"},
			{ID: 0x2e96, Name: "4 Series Chipset PT IDER Controller"},
			{ID: 0x2f00, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMI2"},
			{ID: 0x2f01, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 0"},
			{ID: 0x2f02, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 1"},
			{ID: 0x2f03, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 1"},
			{ID: 0x2f04, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2"},
			{ID: 0x2f05, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2"},
			{ID: 0x2f06, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2"},
			{ID: 0x2f07, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2"},
			{ID: 0x2f08, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3"},
			{ID: 0x2f09, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3"},
			{ID: 0x2f0a, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3"},
			{ID: 0x2f0b, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3"},
			{ID: 0x2f0d, Name: "Haswell Xeon Non-Transparent Bridge (Back-to-back)"},
			{ID: 0x2f0e, Name: "Haswell Xeon Non-Transparent Bridge (Primary Side)"},
			{ID: 0x2f0f, Name: "Haswell Xeon Non-Transparent Bridge (Secondary Side)"},
			{ID: 0x2f10, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f11, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f12, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f13, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f14, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f15, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f16, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f17, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f18, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f19, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f1a, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f1b, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f1c, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug"},
			{ID: 0x2f1d, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCIe Ring Interface"},
			{ID: 0x2f1e, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers"},
			{ID: 0x2f1f, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers"},
			{ID: 0x2f20, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 0"},
			{ID: 0x2f21, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 1"},
			{ID: 0x2f22, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 2"},
			{ID: 0x2f23, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 3"},
			{ID: 0x2f24, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 4"},
			{ID: 0x2f25, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 5"},
			{ID: 0x2f26, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 6"},
			{ID: 0x2f27, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 7"},
			{ID: 0x2f28, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Address Map, VTd_Misc, System Management"},
			{ID: 0x2f29, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Hot Plug"},
			{ID: 0x2f2a, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 RAS, Control Status and Global Errors"},
			{ID: 0x2f2c, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 I/O APIC"},
			{ID: 0x2f2e, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 RAID 5/6"},
			{ID: 0x2f2f, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 RAID 5/6"},
			{ID: 0x2f30, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0"},
			{ID: 0x2f32, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0"},
			{ID: 0x2f33, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1"},
			{ID: 0x2f34, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCIe Ring Interface"},
			{ID: 0x2f36, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring"},
			{ID: 0x2f37, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring"},
			{ID: 0x2f38, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1"},
			{ID: 0x2f39, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 I/O Performance Monitoring"},
			{ID: 0x2f3a, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2"},
			{ID: 0x2f3e, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring"},
			{ID: 0x2f3f, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring"},
			{ID: 0x2f40, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2"},
			{ID: 0x2f41, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring"},
			{ID: 0x2f43, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2"},
			{ID: 0x2f45, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug"},
			{ID: 0x2f46, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug"},
			{ID: 0x2f47, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug"},
			{ID: 0x2f60, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1"},
			{ID: 0x2f68, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Target Address, Thermal & RAS Registers"},
			{ID: 0x2f6a, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder"},
			{ID: 0x2f6b, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder"},
			{ID: 0x2f6c, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder"},
			{ID: 0x2f6d, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder"},
			{ID: 0x2f6e, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Channel 2/3 Broadcast"},
			{ID: 0x2f6f, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Global Broadcast"},
			{ID: 0x2f70, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0 Debug"},
			{ID: 0x2f71, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Target Address, Thermal & RAS Registers"},
			{ID: 0x2f76, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 E3 QPI Link Debug"},
			{ID: 0x2f78, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1 Debug"},
			{ID: 0x2f79, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Target Address, Thermal & RAS Registers"},
			{ID: 0x2f7d, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers"},
			{ID: 0x2f7e, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 E3 QPI Link Debug"},
			{ID: 0x2f80, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0"},
			{ID: 0x2f81, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring"},
			{ID: 0x2f83, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0"},
			{ID: 0x2f85, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug"},
			{ID: 0x2f86, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug"},
			{ID: 0x2f87, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug"},
			{ID: 0x2f88, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 VCU"},
			{ID: 0x2f8a, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 VCU"},
			{ID: 0x2f90, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1"},
			{ID: 0x2f93, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1"},
			{ID: 0x2f95, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1 Debug"},
			{ID: 0x2f96, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1 Debug"},
			{ID: 0x2f98, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2f99, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2f9a, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2f9c, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2fa0, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0"},
			{ID: 0x2fa8, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Target Address, Thermal & RAS Registers"},
			{ID: 0x2faa, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder"},
			{ID: 0x2fab, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder"},
			{ID: 0x2fac, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder"},
			{ID: 0x2fad, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder"},
			{ID: 0x2fae, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Channel 0/1 Broadcast"},
			{ID: 0x2faf, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Global Broadcast"},
			{ID: 0x2fb0, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 0 Thermal Control"},
			{ID: 0x2fb1, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 1 Thermal Control"},
			{ID: 0x2fb2, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 0 ERROR Registers"},
			{ID: 0x2fb3, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 1 ERROR Registers"},
			{ID: 0x2fb4, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 2 Thermal Control"},
			{ID: 0x2fb5, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 3 Thermal Control"},
			{ID: 0x2fb6, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 2 ERROR Registers"},
			{ID: 0x2fb7, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 3 ERROR Registers"},
			{ID: 0x2fb8, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3"},
			{ID: 0x2fb9, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3"},
			{ID: 0x2fba, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3"},
			{ID: 0x2fbb, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3"},
			{ID: 0x2fbc, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1"},
			{ID: 0x2fbd, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1"},
			{ID: 0x2fbe, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1"},
			{ID: 0x2fbf, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1"},
			{ID: 0x2fc0, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2fc1, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2fc2, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2fc3, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2fc4, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2fc5, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit"},
			{ID: 0x2fd0, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 0 Thermal Control"},
			{ID: 0x2fd1, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 1 Thermal Control"},
			{ID: 0x2fd2, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 0 ERROR Registers"},
			{ID: 0x2fd3, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 1 ERROR Registers"},
			{ID: 0x2fd4, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 2 Thermal Control"},
			{ID: 0x2fd5, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 3 Thermal Control"},
			{ID: 0x2fd6, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 2 ERROR Registers"},
			{ID: 0x2fd7, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 3 ERROR Registers"},
			{ID: 0x2fe0, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe1, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe2, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe3, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe4, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe5, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe6, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe7, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe8, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fe9, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fea, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2feb, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fec, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fed, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fee, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2fef, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff0, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff1, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff2, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff3, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff4, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff5, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff6, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff7, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers"},
			{ID: 0x2ff8, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent"},
			{ID: 0x2ff9, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent"},
			{ID: 0x2ffa, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent"},
			{ID: 0x2ffb, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent"},
			{ID: 0x2ffc, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers"},
			{ID: 0x2ffd, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers"},
			{ID: 0x2ffe, Name: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers"},
			{ID: 0x3140, Name: "Easel/Monette Hill Image Processor [Pixel Visual Core]"},
			{ID: 0x3165, Name: "Wireless 3165"},
			{ID: 0x3166, Name: "Dual Band Wireless-AC 3165 Plus Bluetooth"},
			{ID: 0x3184, Name: "GeminiLake [UHD Graphics 605]"},
			{ID: 0x3185, Name: "GeminiLake [UHD Graphics 600]"},
			{ID: 0x318c, Name: "Celeron/Pentium Silver Processor Dynamic Platform and Thermal Framework Processor Participant"},
			{ID: 0x318e, Name: "Celeron/Pentium Silver Processor NorthPeak"},
			{ID: 0x3190, Name: "Celeron/Pentium Silver Processor Gaussian Mixture Model"},
			{ID: 0x3192, Name: "Gemini Lake P2SB"},
			{ID: 0x3197, Name: "Celeron/Pentium Silver Processor PCI-default ISA-bridge"},
			{ID: 0x3198, Name: "Celeron/Pentium Silver Processor High Definition Audio"},
			{ID: 0x319a, Name: "Celeron/Pentium Silver Processor Trusted Execution Engine Interface"},
			{ID: 0x31a2, Name: "Celeron/Pentium Silver Processor Integrated Sensor Solution"},
			{ID: 0x31a8, Name: "Celeron/Pentium Silver Processor USB 3.0 xHCI Controller"},
			{ID: 0x31ac, Name: "Celeron/Pentium Silver Processor Serial IO I2C Host Controller"},
			{ID: 0x31ae, Name: "Celeron/Pentium Silver Processor Serial IO I2C Host Controller"},
			{ID: 0x31bc, Name: "Celeron/Pentium Silver Processor Serial IO UART Host Controller"},
			{ID: 0x31be, Name: "Celeron/Pentium Silver Processor Serial IO UART Host Controller"},
			{ID: 0x31c0, Name: "Celeron/Pentium Silver Processor Serial IO UART Host Controller"},
			{ID: 0x31c2, Name: "Celeron/Pentium Silver Processor Serial IO SPI Host Controller"},
			{ID: 0x31c4, Name: "Celeron/Pentium Silver Processor Serial IO SPI Host Controller"},
			{ID: 0x31c6, Name: "Celeron/Pentium Silver Processor Serial IO SPI Host Controller"},
			{ID: 0x31cc, Name: "Celeron/Pentium Silver Processor SDA Standard Compliant SD Host Controller"},
			{ID: 0x31d4, Name: "Celeron/Pentium Silver Processor Gaussian Mixture Model"},
			{ID: 0x31d6, Name: "Gemini Lake PCI Express Root Port"},
			{ID: 0x31d7, Name: "Gemini Lake PCI Express Root Port"},
			{ID: 0x31d8, Name: "Gemini Lake PCI Express Root Port"},
			{ID: 0x31d9, Name: "Gemini Lake PCI Express Root Port"},
			{ID: 0x31da, Name: "Gemini Lake PCI Express Root Port"},
			{ID: 0x31db, Name: "Gemini Lake PCI Express Root Port"},
			{ID: 0x31dc, Name: "Gemini Lake PCH CNVi WiFi"},
			{ID: 0x31e3, Name: "Celeron/Pentium Silver Processor SATA Controller"},
			{ID: 0x31e8, Name: "Celeron/Pentium Silver Processor LPC Controller"},
			{ID: 0x31ee, Name: "Celeron/Pentium Silver Processor Serial IO UART Host Controller"},
			{ID: 0x31f0, Name: "Gemini Lake Host Bridge"},
			{ID: 0x3200, Name: "GD31244 PCI-X SATA HBA"},
			{ID: 0x3310, Name: "IOP348 I/O Processor"},
			{ID: 0x3313, Name: "IOP348 I/O Processor (SL8e) in IOC Mode SAS/SATA"},
			{ID: 0x331b, Name: "IOP348 I/O Processor (SL8x) in IOC Mode SAS/SATA"},
			{ID: 0x3331, Name: "IOC340 I/O Controller (VV8e) SAS/SATA"},
			{ID: 0x3339, Name: "IOC340 I/O Controller (VV8x) SAS/SATA"},
			{ID: 0x3340, Name: "82855PM Processor to I/O Controller"},
			{ID: 0x3341, Name: "82855PM Processor to AGP Controller"},
			{ID: 0x3363, Name: "IOC340 I/O Controller in IOC Mode SAS/SATA"},
			{ID: 0x3382, Name: "81342 [Chevelon] I/O Processor (ATUe)"},
			{ID: 0x33c3, Name: "IOP348 I/O Processor (SL8De) in IOC Mode SAS/SATA"},
			{ID: 0x33cb, Name: "IOP348 I/O Processor (SL8Dx) in IOC Mode SAS/SATA"},
			{ID: 0x3400, Name: "5520/5500/X58 I/O Hub to ESI Port"},
			{ID: 0x3401, Name: "5520/5500/X58 I/O Hub to ESI Port"},
			{ID: 0x3402, Name: "5520/5500/X58 I/O Hub to ESI Port"},
			{ID: 0x3403, Name: "5500 I/O Hub to ESI Port"},
			{ID: 0x3404, Name: "5520/5500/X58 I/O Hub to ESI Port"},
			{ID: 0x3405, Name: "5520/5500/X58 I/O Hub to ESI Port"},
			{ID: 0x3406, Name: "5520 I/O Hub to ESI Port"},
			{ID: 0x3407, Name: "5520/5500/X58 I/O Hub to ESI Port"},
			{ID: 0x3408, Name: "5520/5500/X58 I/O Hub PCI Express Root Port 1"},
			{ID: 0x3409, Name: "5520/5500/X58 I/O Hub PCI Express Root Port 2"},
			{ID: 0x340a, Name: "5520/5500/X58 I/O Hub PCI Express Root Port 3"},
			{ID: 0x340b, Name: "5520/X58 I/O Hub PCI Express Root Port 4"},
			{ID: 0x340c, Name: "5520/X58 I/O Hub PCI Express Root Port 5"},
			{ID: 0x340d, Name: "5520/X58 I/O Hub PCI Express Root Port 6"},
			{ID: 0x340e, Name: "5520/5500/X58 I/O Hub PCI Express Root Port 7"},
			{ID: 0x340f, Name: "5520/5500/X58 I/O Hub PCI Express Root Port 8"},
			{ID: 0x3410, Name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 9"},
			{ID: 0x3411, Name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 10"},
			{ID: 0x3418, Name: "7500/5520/5500/X58 Physical Layer Port 0"},
			{ID: 0x3419, Name: "7500/5520/5500 Physical Layer Port 1"},
			{ID: 0x3420, Name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 0"},
			{ID: 0x3421, Name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 0"},
			{ID: 0x3422, Name: "7500/5520/5500/X58 I/O Hub GPIO and Scratch Pad Registers"},
			{ID: 0x3423, Name: "7500/5520/5500/X58 I/O Hub Control Status and RAS Registers"},
			{ID: 0x3425, Name: "7500/5520/5500/X58 Physical and Link Layer Registers Port 0"},
			{ID: 0x3426, Name: "7500/5520/5500/X58 Routing and Protocol Layer Registers Port 0"},
			{ID: 0x3427, Name: "7500/5520/5500 Physical and Link Layer Registers Port 1"},
			{ID: 0x3428, Name: "7500/5520/5500 Routing & Protocol Layer Register Port 1"},
			{ID: 0x3429, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x342a, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x342b, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x342c, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x342d, Name: "7500/5520/5500/X58 I/O Hub I/OxAPIC Interrupt Controller"},
			{ID: 0x342e, Name: "7500/5520/5500/X58 I/O Hub System Management Registers"},
			{ID: 0x342f, Name: "7500/5520/5500/X58 Trusted Execution Technology Registers"},
			{ID: 0x3430, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x3431, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x3432, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x3433, Name: "5520/5500/X58 Chipset QuickData Technology Device"},
			{ID: 0x3438, Name: "7500/5520/5500/X58 I/O Hub Throttle Registers"},
			{ID: 0x3482, Name: "Ice Lake-LP LPC Controller"},
			{ID: 0x34a3, Name: "Ice Lake-LP SMBus Controller"},
			{ID: 0x34a4, Name: "Ice Lake-LP SPI Controller"},
			{ID: 0x34a8, Name: "Ice Lake-LP Serial IO UART Controller #0"},
			{ID: 0x34a9, Name: "Ice Lake-LP Serial IO UART Controller #1"},
			{ID: 0x34aa, Name: "Ice Lake-LP Serial IO SPI Controller #0"},
			{ID: 0x34ab, Name: "Ice Lake-LP Serial IO SPI Controller #1"},
			{ID: 0x34b0, Name: "Ice Lake-LP PCI Express Root Port #9"},
			{ID: 0x34b7, Name: "Ice Lake-LP PCI Express Root Port #16"},
			{ID: 0x34ba, Name: "Ice Lake-LP PCI Express Root Port #3"},
			{ID: 0x34bc, Name: "Ice Lake-LP PCI Express Root Port #5"},
			{ID: 0x34c5, Name: "Ice Lake-LP Serial IO I2c Controller #4"},
			{ID: 0x34c6, Name: "Ice Lake-LP Serial IO I2c Controller #5"},
			{ID: 0x34c8, Name: "Ice Lake-LP Smart Sound Technology Audio Controller"},
			{ID: 0x34d3, Name: "Ice Lake-LP SATA Controller [AHCI mode]"},
			{ID: 0x34e0, Name: "Ice Lake-LP Management Engine"},
			{ID: 0x34e8, Name: "Ice Lake-LP Serial IO I2C Controller #0"},
			{ID: 0x34e9, Name: "Ice Lake-LP Serial IO I2C Controller #1"},
			{ID: 0x34ea, Name: "Ice Lake-LP Serial IO I2C Controller #2"},
			{ID: 0x34eb, Name: "Ice Lake-LP Serial IO I2C Controller #3"},
			{ID: 0x34ed, Name: "Ice Lake-LP USB 3.1 xHCI Host Controller"},
			{ID: 0x34ef, Name: "Ice Lake-LP DRAM Controller"},
			{ID: 0x34f0, Name: "Ice Lake-LP PCH CNVi WiFi"},
			{ID: 0x34f8, Name: "Ice Lake-LP SD Controller"},
			{ID: 0x34fc, Name: "Ice Lake-LP Integrated Sensor Solution"},
			{ID: 0x3500, Name: "6311ESB/6321ESB PCI Express Upstream Port"},
			{ID: 0x3501, Name: "6310ESB PCI Express Upstream Port"},
			{ID: 0x3504, Name: "6311ESB/6321ESB I/OxAPIC Interrupt Controller"},
			{ID: 0x3505, Name: "6310ESB I/OxAPIC Interrupt Controller"},
			{ID: 0x350c, Name: "6311ESB/6321ESB PCI Express to PCI-X Bridge"},
			{ID: 0x350d, Name: "6310ESB PCI Express to PCI-X Bridge"},
			{ID: 0x3510, Name: "6311ESB/6321ESB PCI Express Downstream Port E1"},
			{ID: 0x3511, Name: "6310ESB PCI Express Downstream Port E1"},
			{ID: 0x3514, Name: "6311ESB/6321ESB PCI Express Downstream Port E2"},
			{ID: 0x3515, Name: "6310ESB PCI Express Downstream Port E2"},
			{ID: 0x3518, Name: "6311ESB/6321ESB PCI Express Downstream Port E3"},
			{ID: 0x3519, Name: "6310ESB PCI Express Downstream Port E3"},
			{ID: 0x3575, Name: "82830M/MG/MP Host Bridge"},
			{ID: 0x3576, Name: "82830M/MP AGP Bridge"},
			{ID: 0x3577, Name: "82830M/MG Integrated Graphics Controller"},
			{ID: 0x3578, Name: "82830M/MG/MP Host Bridge"},
			{ID: 0x3580, Name: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller"},
			{ID: 0x3581, Name: "82852/82855 GM/GME/PM/GMV Processor to AGP Controller"},
			{ID: 0x3582, Name: "82852/855GM Integrated Graphics Device"},
			{ID: 0x3584, Name: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller"},
			{ID: 0x3585, Name: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller"},
			{ID: 0x358c, Name: "82854 GMCH"},
			{ID: 0x358e, Name: "82854 GMCH Integrated Graphics Device"},
			{ID: 0x3590, Name: "E7520 Memory Controller Hub"},
			{ID: 0x3591, Name: "E7525/E7520 Error Reporting Registers"},
			{ID: 0x3592, Name: "E7320 Memory Controller Hub"},
			{ID: 0x3593, Name: "E7320 Error Reporting Registers"},
			{ID: 0x3594, Name: "E7520 DMA Controller"},
			{ID: 0x3595, Name: "E7525/E7520/E7320 PCI Express Port A"},
			{ID: 0x3596, Name: "E7525/E7520/E7320 PCI Express Port A1"},
			{ID: 0x3597, Name: "E7525/E7520 PCI Express Port B"},
			{ID: 0x3598, Name: "E7520 PCI Express Port B1"},
			{ID: 0x3599, Name: "E7520 PCI Express Port C"},
			{ID: 0x359a, Name: "E7520 PCI Express Port C1"},
			{ID: 0x359b, Name: "E7525/E7520/E7320 Extended Configuration Registers"},
			{ID: 0x359e, Name: "E7525 Memory Controller Hub"},
			{ID: 0x35b0, Name: "3100 Chipset Memory I/O Controller Hub"},
			{ID: 0x35b1, Name: "3100 DRAM Controller Error Reporting Registers"},
			{ID: 0x35b5, Name: "3100 Chipset Enhanced DMA Controller"},
			{ID: 0x35b6, Name: "3100 Chipset PCI Express Port A"},
			{ID: 0x35b7, Name: "3100 Chipset PCI Express Port A1"},
			{ID: 0x35c8, Name: "3100 Extended Configuration Test Overflow Registers"},
			{ID: 0x3600, Name: "7300 Chipset Memory Controller Hub"},
			{ID: 0x3604, Name: "7300 Chipset PCI Express Port 1"},
			{ID: 0x3605, Name: "7300 Chipset PCI Express Port 2"},
			{ID: 0x3606, Name: "7300 Chipset PCI Express Port 3"},
			{ID: 0x3607, Name: "7300 Chipset PCI Express Port 4"},
			{ID: 0x3608, Name: "7300 Chipset PCI Express Port 5"},
			{ID: 0x3609, Name: "7300 Chipset PCI Express Port 6"},
			{ID: 0x360a, Name: "7300 Chipset PCI Express Port 7"},
			{ID: 0x360b, Name: "7300 Chipset QuickData Technology Device"},
			{ID: 0x360c, Name: "7300 Chipset FSB Registers"},
			{ID: 0x360d, Name: "7300 Chipset Snoop Filter Registers"},
			{ID: 0x360e, Name: "7300 Chipset Debug and Miscellaneous Registers"},
			{ID: 0x360f, Name: "7300 Chipset FBD Branch 0 Registers"},
			{ID: 0x3610, Name: "7300 Chipset FBD Branch 1 Registers"},
			{ID: 0x3700, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3701, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3702, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3703, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3704, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3705, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3706, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3707, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3708, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3709, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x370a, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x370b, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x370c, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x370d, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x370e, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x370f, Name: "Xeon C5500/C3500 DMI"},
			{ID: 0x3710, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3711, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3712, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3713, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3714, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3715, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3716, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3717, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3718, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x3719, Name: "Xeon C5500/C3500 CB3 DMA"},
			{ID: 0x371a, Name: "Xeon C5500/C3500 QPI Link"},
			{ID: 0x371b, Name: "Xeon C5500/C3500 QPI Routing and Protocol"},
			{ID: 0x371d, Name: "Xeon C5500/C3500 QPI Routing and Protocol"},
			{ID: 0x3720, Name: "Xeon C5500/C3500 PCI Express Root Port 0"},
			{ID: 0x3721, Name: "Xeon C5500/C3500 PCI Express Root Port 1"},
			{ID: 0x3722, Name: "Xeon C5500/C3500 PCI Express Root Port 2"},
			{ID: 0x3723, Name: "Xeon C5500/C3500 PCI Express Root Port 3"},
			{ID: 0x3724, Name: "Xeon C5500/C3500 PCI Express Root Port 4"},
			{ID: 0x3725, Name: "Xeon C5500/C3500 NTB Primary"},
			{ID: 0x3726, Name: "Xeon C5500/C3500 NTB Primary"},
			{ID: 0x3727, Name: "Xeon C5500/C3500 NTB Secondary"},
			{ID: 0x3728, Name: "Xeon C5500/C3500 Core"},
			{ID: 0x3729, Name: "Xeon C5500/C3500 Core"},
			{ID: 0x372a, Name: "Xeon C5500/C3500 Core"},
			{ID: 0x372b, Name: "Xeon C5500/C3500 Core"},
			{ID: 0x372c, Name: "Xeon C5500/C3500 Reserved"},
			{ID: 0x373f, Name: "Xeon C5500/C3500 IOxAPIC"},
			{ID: 0x37c8, Name: "C62x Chipset QuickAssist Technology"},
			{ID: 0x37c9, Name: "C62x Chipset QuickAssist Technology Virtual Function"},
			{ID: 0x37cc, Name: "Ethernet Connection X722"},
			{ID: 0x37cd, Name: "Ethernet Virtual Function 700 Series"},
			{ID: 0x37ce, Name: "Ethernet Connection X722 for 10GbE backplane"},
			{ID: 0x37cf, Name: "Ethernet Connection X722 for 10GbE QSFP+"},
			{ID: 0x37d0, Name: "Ethernet Connection X722 for 10GbE SFP+"},
			{ID: 0x37d1, Name: "Ethernet Connection X722 for 1GbE"},
			{ID: 0x37d2, Name: "Ethernet Connection X722 for 10GBASE-T"},
			{ID: 0x37d3, Name: "Ethernet Connection X722 for 10GbE SFP+"},
			{ID: 0x37d4, Name: "Ethernet Connect