// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// DO NOT EDIT: this file is automatically generated by docgen
package main

import (
	"github.com/projectdiscovery/yamldoc-go/encoder"
)

var (
	JobDoc             encoder.Doc
	InternalOptionsDoc encoder.Doc
)

func init() {
	JobDoc.Type = "Job"
	JobDoc.Comments[encoder.LineComment] = "Job is a single job to be executed by apollo."
	JobDoc.Description = "Job is a single job to be executed by apollo.\n\nA job contains providers and deployments required to be done\nand some steps to be taken to achieve a desired scan.\n\nA job is just an input and is immutable. The state of a job\nis maintained in other variables instead of the Job struct.\n"
	JobDoc.Fields = make([]encoder.Doc, 5)
	JobDoc.Fields[0].Name = "name"
	JobDoc.Fields[0].Type = "string"
	JobDoc.Fields[0].Note = ""
	JobDoc.Fields[0].Description = "Name of the Job"
	JobDoc.Fields[0].Comments[encoder.LineComment] = "Name of the Job"

	JobDoc.Fields[0].AddExample("Name Example", "443-httpx-internet-wide")
	JobDoc.Fields[1].Name = "key"
	JobDoc.Fields[1].Type = "string"
	JobDoc.Fields[1].Note = ""
	JobDoc.Fields[1].Description = "Key contains a key input of a certain type"
	JobDoc.Fields[1].Comments[encoder.LineComment] = "Key contains a key input of a certain type"
	JobDoc.Fields[1].Values = []string{
		"dns",
		"http",
		"headless",
	}
	JobDoc.Fields[2].Name = "description"
	JobDoc.Fields[2].Type = "string"
	JobDoc.Fields[2].Note = ""
	JobDoc.Fields[2].Description = "Description contains a description of the job"
	JobDoc.Fields[2].Comments[encoder.LineComment] = "Description contains a description of the job"

	JobDoc.Fields[2].AddExample("Description Example", "Runs masscan on port 443 followed by httpx")
	JobDoc.Fields[3].Name = "providers"
	JobDoc.Fields[3].Type = "map[string]map[string]string"
	JobDoc.Fields[3].Note = ""
	JobDoc.Fields[3].Description = "Providers contains a list of infrastructure providers\nfor the current scan."
	JobDoc.Fields[3].Comments[encoder.LineComment] = "Providers contains a list of infrastructure providers"

	JobDoc.Fields[3].AddExample("Providers Example", exampleProvider)
	JobDoc.Fields[4].Name = "internal-options"
	JobDoc.Fields[4].Type = "InternalOptions"
	JobDoc.Fields[4].Note = ""
	JobDoc.Fields[4].Description = "InternalOptions contains internal configuration options for scheduler"
	JobDoc.Fields[4].Comments[encoder.LineComment] = "InternalOptions contains internal configuration options for scheduler"

	JobDoc.Fields[4].AddExample("InternalOptions Example", exampleInternalOptions)

	InternalOptionsDoc.Type = "InternalOptions"
	InternalOptionsDoc.Comments[encoder.LineComment] = "InternalOptions contains internal configuration options for scheduler"
	InternalOptionsDoc.Description = "InternalOptions contains internal configuration options for scheduler"

	InternalOptionsDoc.AddExample("InternalOptions Example", exampleInternalOptions)
	InternalOptionsDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Job",
			FieldName: "internal-options",
		},
	}
	InternalOptionsDoc.Fields = make([]encoder.Doc, 2)
	InternalOptionsDoc.Fields[0].Name = "bulk-size"
	InternalOptionsDoc.Fields[0].Type = "int"
	InternalOptionsDoc.Fields[0].Note = ""
	InternalOptionsDoc.Fields[0].Description = "BulkSize is the number of items to process per node at once."
	InternalOptionsDoc.Fields[0].Comments[encoder.LineComment] = "BulkSize is the number of items to process per node at once."

	InternalOptionsDoc.Fields[0].AddExample("BulkSize Example", 10000)
	InternalOptionsDoc.Fields[1].Name = "scheduling-workers"
	InternalOptionsDoc.Fields[1].Type = "int"
	InternalOptionsDoc.Fields[1].Note = ""
	InternalOptionsDoc.Fields[1].Description = "SchedulingWorkers is the number of scheduling workers to use for ssh."
	InternalOptionsDoc.Fields[1].Comments[encoder.LineComment] = "SchedulingWorkers is the number of scheduling workers to use for ssh."

	InternalOptionsDoc.Fields[1].AddExample("SchedulingWorkers Example", 10)
}

func (Job) Doc() *encoder.Doc {
	return &JobDoc
}

func (InternalOptions) Doc() *encoder.Doc {
	return &InternalOptionsDoc
}

// GetConfigurationDoc returns documentation for the file types_doc.go.
func GetConfigurationDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "Configuration",
		Description: "go:generate docgen types.go types_doc.go Configuration\n",
		Structs: []*encoder.Doc{
			&JobDoc,
			&InternalOptionsDoc,
		},
	}
}
