// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ModelPackage Details of the vulnerable package found
type ModelPackage struct {

	// Name of the package
	Name *string `mandatory:"true" json:"name"`

	// Package version
	Version *string `mandatory:"true" json:"version"`

	// Package type
	Type ModelPackageTypeEnum `mandatory:"true" json:"type"`

	// Package version in which the CVE was fixed
	CveFixVersion *string `mandatory:"false" json:"cveFixVersion"`

	// Disk locations where package was found
	Locations []string `mandatory:"false" json:"locations"`
}

func (m ModelPackage) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ModelPackage) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingModelPackageTypeEnum(string(m.Type)); !ok && m.Type != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Type: %s. Supported values are: %s.", m.Type, strings.Join(GetModelPackageTypeEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ModelPackageTypeEnum Enum with underlying type: string
type ModelPackageTypeEnum string

// Set of constants representing the allowable values for ModelPackageTypeEnum
const (
	ModelPackageTypeJava        ModelPackageTypeEnum = "JAVA"
	ModelPackageTypeApk         ModelPackageTypeEnum = "APK"
	ModelPackageTypeRpm         ModelPackageTypeEnum = "RPM"
	ModelPackageTypeDeb         ModelPackageTypeEnum = "DEB"
	ModelPackageTypeGo          ModelPackageTypeEnum = "GO"
	ModelPackageTypeNpm         ModelPackageTypeEnum = "NPM"
	ModelPackageTypePython      ModelPackageTypeEnum = "PYTHON"
	ModelPackageTypeRust        ModelPackageTypeEnum = "RUST"
	ModelPackageTypePhpComposer ModelPackageTypeEnum = "PHP_COMPOSER"
	ModelPackageTypeGem         ModelPackageTypeEnum = "GEM"
	ModelPackageTypeMsrcKb      ModelPackageTypeEnum = "MSRC_KB"
)

var mappingModelPackageTypeEnum = map[string]ModelPackageTypeEnum{
	"JAVA":         ModelPackageTypeJava,
	"APK":          ModelPackageTypeApk,
	"RPM":          ModelPackageTypeRpm,
	"DEB":          ModelPackageTypeDeb,
	"GO":           ModelPackageTypeGo,
	"NPM":          ModelPackageTypeNpm,
	"PYTHON":       ModelPackageTypePython,
	"RUST":         ModelPackageTypeRust,
	"PHP_COMPOSER": ModelPackageTypePhpComposer,
	"GEM":          ModelPackageTypeGem,
	"MSRC_KB":      ModelPackageTypeMsrcKb,
}

var mappingModelPackageTypeEnumLowerCase = map[string]ModelPackageTypeEnum{
	"java":         ModelPackageTypeJava,
	"apk":          ModelPackageTypeApk,
	"rpm":          ModelPackageTypeRpm,
	"deb":          ModelPackageTypeDeb,
	"go":           ModelPackageTypeGo,
	"npm":          ModelPackageTypeNpm,
	"python":       ModelPackageTypePython,
	"rust":         ModelPackageTypeRust,
	"php_composer": ModelPackageTypePhpComposer,
	"gem":          ModelPackageTypeGem,
	"msrc_kb":      ModelPackageTypeMsrcKb,
}

// GetModelPackageTypeEnumValues Enumerates the set of values for ModelPackageTypeEnum
func GetModelPackageTypeEnumValues() []ModelPackageTypeEnum {
	values := make([]ModelPackageTypeEnum, 0)
	for _, v := range mappingModelPackageTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetModelPackageTypeEnumStringValues Enumerates the set of values in String for ModelPackageTypeEnum
func GetModelPackageTypeEnumStringValues() []string {
	return []string{
		"JAVA",
		"APK",
		"RPM",
		"DEB",
		"GO",
		"NPM",
		"PYTHON",
		"RUST",
		"PHP_COMPOSER",
		"GEM",
		"MSRC_KB",
	}
}

// GetMappingModelPackageTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingModelPackageTypeEnum(val string) (ModelPackageTypeEnum, bool) {
	enum, ok := mappingModelPackageTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
