// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListContainerScanResultsRequest wrapper for the ListContainerScanResults operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListContainerScanResults.go.html to see an example of how to use ListContainerScanResultsRequest.
type ListContainerScanResultsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// Repository name
	Repository *string `mandatory:"false" contributesTo:"query" name:"repository"`

	// Image name
	Image *string `mandatory:"false" contributesTo:"query" name:"image"`

	// When listing with one or more filters, whether to include subcompartments for the compartmentId being listed for. Does nothing if no filters are present in the query.
	AreSubcompartmentsIncluded *bool `mandatory:"false" contributesTo:"query" name:"areSubcompartmentsIncluded"`

	// Parameter to filter by highestProblemSeverity for scan results
	HighestProblemSeverity ListContainerScanResultsHighestProblemSeverityEnum `mandatory:"false" contributesTo:"query" name:"highestProblemSeverity" omitEmpty:"true"`

	// Date and time on or after which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedGreaterThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedGreaterThanOrEqualTo"`

	// Date and time on or before which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedLessThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedLessThanOrEqualTo"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListContainerScanResultsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeStarted is default.
	SortBy ListContainerScanResultsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A flag to return only the latest scan result of an instance.
	IsLatestOnly *bool `mandatory:"false" contributesTo:"query" name:"isLatestOnly"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListContainerScanResultsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListContainerScanResultsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListContainerScanResultsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListContainerScanResultsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListContainerScanResultsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListContainerScanResultsHighestProblemSeverityEnum(string(request.HighestProblemSeverity)); !ok && request.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", request.HighestProblemSeverity, strings.Join(GetListContainerScanResultsHighestProblemSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListContainerScanResultsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListContainerScanResultsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListContainerScanResultsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListContainerScanResultsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListContainerScanResultsResponse wrapper for the ListContainerScanResults operation
type ListContainerScanResultsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of ContainerScanResultSummaryCollection instances
	ContainerScanResultSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListContainerScanResultsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListContainerScanResultsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListContainerScanResultsHighestProblemSeverityEnum Enum with underlying type: string
type ListContainerScanResultsHighestProblemSeverityEnum string

// Set of constants representing the allowable values for ListContainerScanResultsHighestProblemSeverityEnum
const (
	ListContainerScanResultsHighestProblemSeverityNone     ListContainerScanResultsHighestProblemSeverityEnum = "NONE"
	ListContainerScanResultsHighestProblemSeverityLow      ListContainerScanResultsHighestProblemSeverityEnum = "LOW"
	ListContainerScanResultsHighestProblemSeverityMedium   ListContainerScanResultsHighestProblemSeverityEnum = "MEDIUM"
	ListContainerScanResultsHighestProblemSeverityHigh     ListContainerScanResultsHighestProblemSeverityEnum = "HIGH"
	ListContainerScanResultsHighestProblemSeverityCritical ListContainerScanResultsHighestProblemSeverityEnum = "CRITICAL"
)

var mappingListContainerScanResultsHighestProblemSeverityEnum = map[string]ListContainerScanResultsHighestProblemSeverityEnum{
	"NONE":     ListContainerScanResultsHighestProblemSeverityNone,
	"LOW":      ListContainerScanResultsHighestProblemSeverityLow,
	"MEDIUM":   ListContainerScanResultsHighestProblemSeverityMedium,
	"HIGH":     ListContainerScanResultsHighestProblemSeverityHigh,
	"CRITICAL": ListContainerScanResultsHighestProblemSeverityCritical,
}

var mappingListContainerScanResultsHighestProblemSeverityEnumLowerCase = map[string]ListContainerScanResultsHighestProblemSeverityEnum{
	"none":     ListContainerScanResultsHighestProblemSeverityNone,
	"low":      ListContainerScanResultsHighestProblemSeverityLow,
	"medium":   ListContainerScanResultsHighestProblemSeverityMedium,
	"high":     ListContainerScanResultsHighestProblemSeverityHigh,
	"critical": ListContainerScanResultsHighestProblemSeverityCritical,
}

// GetListContainerScanResultsHighestProblemSeverityEnumValues Enumerates the set of values for ListContainerScanResultsHighestProblemSeverityEnum
func GetListContainerScanResultsHighestProblemSeverityEnumValues() []ListContainerScanResultsHighestProblemSeverityEnum {
	values := make([]ListContainerScanResultsHighestProblemSeverityEnum, 0)
	for _, v := range mappingListContainerScanResultsHighestProblemSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanResultsHighestProblemSeverityEnumStringValues Enumerates the set of values in String for ListContainerScanResultsHighestProblemSeverityEnum
func GetListContainerScanResultsHighestProblemSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListContainerScanResultsHighestProblemSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanResultsHighestProblemSeverityEnum(val string) (ListContainerScanResultsHighestProblemSeverityEnum, bool) {
	enum, ok := mappingListContainerScanResultsHighestProblemSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListContainerScanResultsSortOrderEnum Enum with underlying type: string
type ListContainerScanResultsSortOrderEnum string

// Set of constants representing the allowable values for ListContainerScanResultsSortOrderEnum
const (
	ListContainerScanResultsSortOrderAsc  ListContainerScanResultsSortOrderEnum = "ASC"
	ListContainerScanResultsSortOrderDesc ListContainerScanResultsSortOrderEnum = "DESC"
)

var mappingListContainerScanResultsSortOrderEnum = map[string]ListContainerScanResultsSortOrderEnum{
	"ASC":  ListContainerScanResultsSortOrderAsc,
	"DESC": ListContainerScanResultsSortOrderDesc,
}

var mappingListContainerScanResultsSortOrderEnumLowerCase = map[string]ListContainerScanResultsSortOrderEnum{
	"asc":  ListContainerScanResultsSortOrderAsc,
	"desc": ListContainerScanResultsSortOrderDesc,
}

// GetListContainerScanResultsSortOrderEnumValues Enumerates the set of values for ListContainerScanResultsSortOrderEnum
func GetListContainerScanResultsSortOrderEnumValues() []ListContainerScanResultsSortOrderEnum {
	values := make([]ListContainerScanResultsSortOrderEnum, 0)
	for _, v := range mappingListContainerScanResultsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanResultsSortOrderEnumStringValues Enumerates the set of values in String for ListContainerScanResultsSortOrderEnum
func GetListContainerScanResultsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListContainerScanResultsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanResultsSortOrderEnum(val string) (ListContainerScanResultsSortOrderEnum, bool) {
	enum, ok := mappingListContainerScanResultsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListContainerScanResultsSortByEnum Enum with underlying type: string
type ListContainerScanResultsSortByEnum string

// Set of constants representing the allowable values for ListContainerScanResultsSortByEnum
const (
	ListContainerScanResultsSortByTimestarted            ListContainerScanResultsSortByEnum = "timeStarted"
	ListContainerScanResultsSortByProblemcount           ListContainerScanResultsSortByEnum = "problemCount"
	ListContainerScanResultsSortByHighestproblemseverity ListContainerScanResultsSortByEnum = "highestProblemSeverity"
)

var mappingListContainerScanResultsSortByEnum = map[string]ListContainerScanResultsSortByEnum{
	"timeStarted":            ListContainerScanResultsSortByTimestarted,
	"problemCount":           ListContainerScanResultsSortByProblemcount,
	"highestProblemSeverity": ListContainerScanResultsSortByHighestproblemseverity,
}

var mappingListContainerScanResultsSortByEnumLowerCase = map[string]ListContainerScanResultsSortByEnum{
	"timestarted":            ListContainerScanResultsSortByTimestarted,
	"problemcount":           ListContainerScanResultsSortByProblemcount,
	"highestproblemseverity": ListContainerScanResultsSortByHighestproblemseverity,
}

// GetListContainerScanResultsSortByEnumValues Enumerates the set of values for ListContainerScanResultsSortByEnum
func GetListContainerScanResultsSortByEnumValues() []ListContainerScanResultsSortByEnum {
	values := make([]ListContainerScanResultsSortByEnum, 0)
	for _, v := range mappingListContainerScanResultsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanResultsSortByEnumStringValues Enumerates the set of values in String for ListContainerScanResultsSortByEnum
func GetListContainerScanResultsSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"problemCount",
		"highestProblemSeverity",
	}
}

// GetMappingListContainerScanResultsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanResultsSortByEnum(val string) (ListContainerScanResultsSortByEnum, bool) {
	enum, ok := mappingListContainerScanResultsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
