// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// ContainerScanResultSortByEnum Enum with underlying type: string
type ContainerScanResultSortByEnum string

// Set of constants representing the allowable values for ContainerScanResultSortByEnum
const (
	ContainerScanResultSortByTimeStarted            ContainerScanResultSortByEnum = "timeStarted"
	ContainerScanResultSortByProblemCount           ContainerScanResultSortByEnum = "problemCount"
	ContainerScanResultSortByHighestProblemSeverity ContainerScanResultSortByEnum = "highestProblemSeverity"
)

var mappingContainerScanResultSortByEnum = map[string]ContainerScanResultSortByEnum{
	"timeStarted":            ContainerScanResultSortByTimeStarted,
	"problemCount":           ContainerScanResultSortByProblemCount,
	"highestProblemSeverity": ContainerScanResultSortByHighestProblemSeverity,
}

var mappingContainerScanResultSortByEnumLowerCase = map[string]ContainerScanResultSortByEnum{
	"timestarted":            ContainerScanResultSortByTimeStarted,
	"problemcount":           ContainerScanResultSortByProblemCount,
	"highestproblemseverity": ContainerScanResultSortByHighestProblemSeverity,
}

// GetContainerScanResultSortByEnumValues Enumerates the set of values for ContainerScanResultSortByEnum
func GetContainerScanResultSortByEnumValues() []ContainerScanResultSortByEnum {
	values := make([]ContainerScanResultSortByEnum, 0)
	for _, v := range mappingContainerScanResultSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetContainerScanResultSortByEnumStringValues Enumerates the set of values in String for ContainerScanResultSortByEnum
func GetContainerScanResultSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"problemCount",
		"highestProblemSeverity",
	}
}

// GetMappingContainerScanResultSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingContainerScanResultSortByEnum(val string) (ContainerScanResultSortByEnum, bool) {
	enum, ok := mappingContainerScanResultSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
