// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Network Monitoring API
//
// Use the Network Monitoring API to troubleshoot routing and security issues for resources such as virtual cloud networks (VCNs) and compute instances. For more information, see the console
// documentation for the Network Path Analyzer (https://docs.oracle.com/iaas/Content/Network/Concepts/path_analyzer.htm) tool.
//

package vnmonitoring

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DrgCustomerResource The IPSEC / FC / RPC info returned in DrgCustomerResponse
type DrgCustomerResource struct {

	// OCID of the IPSEC / FC / RPC
	Id *string `mandatory:"false" json:"id"`

	// The friendly name of the node.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// the compartment id of the DRG
	CompartmentId *string `mandatory:"false" json:"compartmentId"`

	// the lifeCycleState of the IPSEC / FC / RPC
	State *string `mandatory:"false" json:"state"`
}

func (m DrgCustomerResource) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DrgCustomerResource) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
