// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// OCI Control Center Demand Signal API
//
// Use the OCI Control Center Demand Signal API to manage Demand Signals.
//

package demandsignal

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// OccDemandSignalValue The Value of Demand Signal for particular month.
type OccDemandSignalValue struct {

	// The date of the Demand Signal Value.
	TimeExpected *common.SDKTime `mandatory:"true" json:"timeExpected"`

	// The Demand Signal Value.
	Value *float32 `mandatory:"true" json:"value"`

	// Space provided for users to make comments regarding the value.
	Comments *string `mandatory:"false" json:"comments"`
}

func (m OccDemandSignalValue) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m OccDemandSignalValue) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
