// Code generated by NodeGenerator. DO NOT EDIT.

// Package node is a generated by the generator.
package node

import (
	"sync/atomic"
	"unsafe"
)

// BRW is a cache entry that provide the following features:
//
// 1. Base
//
// 2. Refresh
//
// 3. Weight
type BRW[K comparable, V any] struct {
	key           K
	value         V
	prev          *BRW[K, V]
	next          *BRW[K, V]
	refreshableAt atomic.Int64
	weight        uint32
	state         atomic.Uint32
	queueType     uint8
}

// NewBRW creates a new BRW.
func NewBRW[K comparable, V any](key K, value V, expiresAt, refreshableAt int64, weight uint32) Node[K, V] {
	n := &BRW[K, V]{
		key:    key,
		value:  value,
		weight: weight,
	}
	n.refreshableAt.Store(refreshableAt)
	n.state.Store(aliveState)

	return n
}

// CastPointerToBRW casts a pointer to BRW.
func CastPointerToBRW[K comparable, V any](ptr unsafe.Pointer) Node[K, V] {
	return (*BRW[K, V])(ptr)
}

func (n *BRW[K, V]) Key() K {
	return n.key
}

func (n *BRW[K, V]) Value() V {
	return n.value
}

func (n *BRW[K, V]) AsPointer() unsafe.Pointer {
	return unsafe.Pointer(n)
}

func (n *BRW[K, V]) Prev() Node[K, V] {
	return n.prev
}

func (n *BRW[K, V]) SetPrev(v Node[K, V]) {
	if v == nil {
		n.prev = nil
		return
	}
	n.prev = (*BRW[K, V])(v.AsPointer())
}

func (n *BRW[K, V]) Next() Node[K, V] {
	return n.next
}

func (n *BRW[K, V]) SetNext(v Node[K, V]) {
	if v == nil {
		n.next = nil
		return
	}
	n.next = (*BRW[K, V])(v.AsPointer())
}

func (n *BRW[K, V]) PrevExp() Node[K, V] {
	panic("not implemented")
}

func (n *BRW[K, V]) SetPrevExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BRW[K, V]) NextExp() Node[K, V] {
	panic("not implemented")
}

func (n *BRW[K, V]) SetNextExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BRW[K, V]) HasExpired(now int64) bool {
	return false
}

func (n *BRW[K, V]) ExpiresAt() int64 {
	panic("not implemented")
}

func (n *BRW[K, V]) CASExpiresAt(old, new int64) bool {
	panic("not implemented")
}

func (n *BRW[K, V]) SetExpiresAt(new int64) {
	panic("not implemented")
}

func (n *BRW[K, V]) RefreshableAt() int64 {
	return n.refreshableAt.Load()
}

func (n *BRW[K, V]) CASRefreshableAt(old, new int64) bool {
	return n.refreshableAt.CompareAndSwap(old, new)
}

func (n *BRW[K, V]) SetRefreshableAt(new int64) {
	n.refreshableAt.Store(new)
}

func (n *BRW[K, V]) IsFresh(now int64) bool {
	return n.IsAlive() && n.RefreshableAt() > now
}

func (n *BRW[K, V]) Weight() uint32 {
	return n.weight
}

func (n *BRW[K, V]) IsAlive() bool {
	return n.state.Load() == aliveState
}

func (n *BRW[K, V]) IsRetired() bool {
	return n.state.Load() == retiredState
}

func (n *BRW[K, V]) Retire() {
	n.state.Store(retiredState)
}

func (n *BRW[K, V]) IsDead() bool {
	return n.state.Load() == deadState
}

func (n *BRW[K, V]) Die() {
	n.state.Store(deadState)
}

func (n *BRW[K, V]) GetQueueType() uint8 {
	return n.queueType
}

func (n *BRW[K, V]) SetQueueType(queueType uint8) {
	n.queueType = queueType
}

func (n *BRW[K, V]) InWindow() bool {
	return n.GetQueueType() == InWindowQueue
}

func (n *BRW[K, V]) MakeWindow() {
	n.SetQueueType(InWindowQueue)
}

func (n *BRW[K, V]) InMainProbation() bool {
	return n.GetQueueType() == InMainProbationQueue
}

func (n *BRW[K, V]) MakeMainProbation() {
	n.SetQueueType(InMainProbationQueue)
}

func (n *BRW[K, V]) InMainProtected() bool {
	return n.GetQueueType() == InMainProtectedQueue
}

func (n *BRW[K, V]) MakeMainProtected() {
	n.SetQueueType(InMainProtectedQueue)
}
