# Changelog

## [v0.25.0](https://github.com/go-swagger/go-swagger/tree/v0.25.0) (2020-07-18)

[Full Changelog](https://github.com/go-swagger/go-swagger/compare/v0.24.0...v0.25.0)

**Implemented enhancements:**

- importing struct with x-go-type generates client code which doesnt compile [\#2224](https://github.com/go-swagger/go-swagger/issues/2224)

**Fixed bugs:**

- file parameter with maxLength: not enough arguments in call to "github.com/go-openapi/errors".ExceedsMaximum [\#2342](https://github.com/go-swagger/go-swagger/issues/2342)
- Missing models during client generation [\#2306](https://github.com/go-swagger/go-swagger/issues/2306)
- Server generation with --name api produces empty strings [\#2293](https://github.com/go-swagger/go-swagger/issues/2293)
- Custom principal import is missing from generated server code [\#2283](https://github.com/go-swagger/go-swagger/issues/2283)
- "generate operation" returns "no operations were selected" [\#2280](https://github.com/go-swagger/go-swagger/issues/2280)
- "generate operation" error "the required flag `-n, --name' was not specified" [\#2279](https://github.com/go-swagger/go-swagger/issues/2279)
- Generate model may panic on some specs [\#2161](https://github.com/go-swagger/go-swagger/issues/2161)
- swagger diff --dest="${DEST}": Is not writing output to "${DEST}" [\#2103](https://github.com/go-swagger/go-swagger/issues/2103)
- Models not importing x-go-type for one of properties [\#1897](https://github.com/go-swagger/go-swagger/issues/1897)

**Closed issues:**

- Strange error while swagger generate server! [\#2358](https://github.com/go-swagger/go-swagger/issues/2358)
- generate operation does not take model package parameter [\#2355](https://github.com/go-swagger/go-swagger/issues/2355)
- Duplicate struct field generated [\#2352](https://github.com/go-swagger/go-swagger/issues/2352)
- structures for response errors [\#2351](https://github.com/go-swagger/go-swagger/issues/2351)
- swagger:meta - $ref on description [\#2349](https://github.com/go-swagger/go-swagger/issues/2349)
- Add warning to documentation for swagger:meta [\#2335](https://github.com/go-swagger/go-swagger/issues/2335)
- how to add property `in:formData` for struct's all field [\#2323](https://github.com/go-swagger/go-swagger/issues/2323)
- 0.24.0: too many arguments in call to "github.com/go-openapi/errors".Required [\#2319](https://github.com/go-swagger/go-swagger/issues/2319)
- Build fails with latest go-openapi/errors [\#2315](https://github.com/go-swagger/go-swagger/issues/2315)
- Raw request body is empty if we try get it inside handler function [\#2310](https://github.com/go-swagger/go-swagger/issues/2310)
- not yet registered swag [\#2291](https://github.com/go-swagger/go-swagger/issues/2291)

**Merged pull requests:**

- adds swaggerui middleware as default /docs site [\#2359](https://github.com/go-swagger/go-swagger/pull/2359) ([casualjim](https://github.com/casualjim))
- Adding ModelPackage option to generate operation [\#2356](https://github.com/go-swagger/go-swagger/pull/2356) ([rodriguise](https://github.com/rodriguise))
- Added a way to override the different authenticator functions in [\#2354](https://github.com/go-swagger/go-swagger/pull/2354) ([ronniel1](https://github.com/ronniel1))
- Improve client response error message when status code not recognized [\#2348](https://github.com/go-swagger/go-swagger/pull/2348) ([minitauros](https://github.com/minitauros))
- fixed missing broken templates after the breaking change in go-openapi/errors [\#2345](https://github.com/go-swagger/go-swagger/pull/2345) ([fredbi](https://github.com/fredbi))
- removed unused template [\#2343](https://github.com/go-swagger/go-swagger/pull/2343) ([fredbi](https://github.com/fredbi))
- fix imports of external types, when used as dependency in properties, items, etc [\#2341](https://github.com/go-swagger/go-swagger/pull/2341) ([fredbi](https://github.com/fredbi))
- enhanced external types: more options to x-go-type [\#2340](https://github.com/go-swagger/go-swagger/pull/2340) ([fredbi](https://github.com/fredbi))
- fixed merging issues that caused linting/goimport failures [\#2339](https://github.com/go-swagger/go-swagger/pull/2339) ([fredbi](https://github.com/fredbi))
- Add NOTE in swagger:meta for adhering to godoc standard [\#2338](https://github.com/go-swagger/go-swagger/pull/2338) ([AymanArif](https://github.com/AymanArif))
- refactored generator tests for readability [\#2337](https://github.com/go-swagger/go-swagger/pull/2337) ([fredbi](https://github.com/fredbi))
- fix edge case with panic in models because of invalid additionalProperties or AllOf schema [\#2336](https://github.com/go-swagger/go-swagger/pull/2336) ([fredbi](https://github.com/fredbi))
- Enhanced generate model CLI: accepts definitions only specs, deprecates some options [\#2333](https://github.com/go-swagger/go-swagger/pull/2333) ([fredbi](https://github.com/fredbi))
- Refactored CLI diff commands and associated tests [\#2332](https://github.com/go-swagger/go-swagger/pull/2332) ([fredbi](https://github.com/fredbi))
- Fix linting again [\#2329](https://github.com/go-swagger/go-swagger/pull/2329) ([fredbi](https://github.com/fredbi))
- more aggressive name deconflicting for inline \(anonymous\) models generated in the operations package [\#2328](https://github.com/go-swagger/go-swagger/pull/2328) ([fredbi](https://github.com/fredbi))
- filter out empty args passed by CLI to select operations [\#2327](https://github.com/go-swagger/go-swagger/pull/2327) ([fredbi](https://github.com/fredbi))
- re-enacted CI-based linting [\#2326](https://github.com/go-swagger/go-swagger/pull/2326) ([fredbi](https://github.com/fredbi))
- fixed broken imports when specifying principal in external package [\#2325](https://github.com/go-swagger/go-swagger/pull/2325) ([fredbi](https://github.com/fredbi))
- fix\(generator\): fixed generated API name when terminated with suffix "api" [\#2322](https://github.com/go-swagger/go-swagger/pull/2322) ([fredbi](https://github.com/fredbi))
- feature: strict responders option [\#2312](https://github.com/go-swagger/go-swagger/pull/2312) ([onokonem](https://github.com/onokonem))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
