# Change Log

## [0.15.0](https://github.com/go-swagger/go-swagger/tree/0.15.0) (2018-07-11)
[Full Changelog](https://github.com/go-swagger/go-swagger/compare/0.14.0...0.15.0)

**Implemented enhancements:**

- Fail to generate model: unhandled type to resolve JSON pointer [\#1602](https://github.com/go-swagger/go-swagger/issues/1602)
- Suggestion: Implement golangci on go-swagger? [\#1576](https://github.com/go-swagger/go-swagger/issues/1576)
- Improve spec preprocessing : flatten vs expand [\#1572](https://github.com/go-swagger/go-swagger/issues/1572)
- Produces application/pdf ignored [\#1284](https://github.com/go-swagger/go-swagger/issues/1284)
- swagger json, title and possibly other constants in a separate package [\#1169](https://github.com/go-swagger/go-swagger/issues/1169)
- Debug prints regorganization [\#634](https://github.com/go-swagger/go-swagger/issues/634)

**Fixed bugs:**

- Tuple unmarshaller fails on nil fields [\#1571](https://github.com/go-swagger/go-swagger/issues/1571)
- Deadlock issue in shutdown function under restapi [\#1565](https://github.com/go-swagger/go-swagger/issues/1565)
- Models: Invalid pointer redirect [\#1562](https://github.com/go-swagger/go-swagger/issues/1562)
- Broken code is generated with --skip-flatten [\#1559](https://github.com/go-swagger/go-swagger/issues/1559)
- Rendering and validation of maps in body [\#1556](https://github.com/go-swagger/go-swagger/issues/1556)
- Base64 validation wrongly performed after decoding the string field [\#1548](https://github.com/go-swagger/go-swagger/issues/1548)
- Model definition not included when response definition has an external $ref containing a schema $ref [\#1429](https://github.com/go-swagger/go-swagger/issues/1429)
- Client Generator hangs on swagger with circular dependencies. [\#957](https://github.com/go-swagger/go-swagger/issues/957)
- repeated resolve of remote ref fails [\#908](https://github.com/go-swagger/go-swagger/issues/908)
- Override struct type in json struct tag? [\#543](https://github.com/go-swagger/go-swagger/issues/543)

**Closed issues:**

- Stack overflow error in swagger validate [\#1614](https://github.com/go-swagger/go-swagger/issues/1614)
- server execution on linux does not appear to call server.ConfigureFlags\(\) in main.go [\#1584](https://github.com/go-swagger/go-swagger/issues/1584)
- Question: Accessing parsed command-line arguments in configureAPI method [\#1581](https://github.com/go-swagger/go-swagger/issues/1581)
- Error "Cannot find file" on transpile todo example yml to Go server code on windows. [\#1554](https://github.com/go-swagger/go-swagger/issues/1554)
- Json Generation Issues [\#1553](https://github.com/go-swagger/go-swagger/issues/1553)
- Security & Nullable fields [\#1546](https://github.com/go-swagger/go-swagger/issues/1546)
- swagger:parameters won't generate in spec when inside a function [\#1545](https://github.com/go-swagger/go-swagger/issues/1545)
- Polymorphism does not support --skip-flatten [\#1516](https://github.com/go-swagger/go-swagger/issues/1516)
- Bug in oauth2 example [\#1496](https://github.com/go-swagger/go-swagger/issues/1496)
- contributing guidelines lack development instructions [\#1484](https://github.com/go-swagger/go-swagger/issues/1484)
- Missing strfmt import [\#1480](https://github.com/go-swagger/go-swagger/issues/1480)
- The commit number of command `swagger version` is wrong v0.12.0 [\#1297](https://github.com/go-swagger/go-swagger/issues/1297)
- Fail to include import "github.com/go-openapi/validate" in first go generate [\#824](https://github.com/go-swagger/go-swagger/issues/824)
- it appears that vendoring breaks client generation assumption [\#785](https://github.com/go-swagger/go-swagger/issues/785)

**Merged pull requests:**

- Fixes \#1614 [\#1615](https://github.com/go-swagger/go-swagger/pull/1615) ([fredbi](https://github.com/fredbi))
- Feature/x-order [\#1612](https://github.com/go-swagger/go-swagger/pull/1612) ([liber-takano](https://github.com/liber-takano))
- Update vendor 20180710 [\#1608](https://github.com/go-swagger/go-swagger/pull/1608) ([fredbi](https://github.com/fredbi))
- Document contribution guidelines [\#1607](https://github.com/go-swagger/go-swagger/pull/1607) ([fredbi](https://github.com/fredbi))
- Review doc site [\#1604](https://github.com/go-swagger/go-swagger/pull/1604) ([fredbi](https://github.com/fredbi))
- regen examples [\#1600](https://github.com/go-swagger/go-swagger/pull/1600) ([fredbi](https://github.com/fredbi))
- Update vendor - keep up to date with go-openapi repo [\#1599](https://github.com/go-swagger/go-swagger/pull/1599) ([fredbi](https://github.com/fredbi))
- Refactor debug code [\#1598](https://github.com/go-swagger/go-swagger/pull/1598) ([fredbi](https://github.com/fredbi))
- Fix some linting and mispelling issues [\#1597](https://github.com/go-swagger/go-swagger/pull/1597) ([fredbi](https://github.com/fredbi))
- Validation of string with format "byte" [\#1593](https://github.com/go-swagger/go-swagger/pull/1593) ([fredbi](https://github.com/fredbi))
- Tuple serializer [\#1592](https://github.com/go-swagger/go-swagger/pull/1592) ([fredbi](https://github.com/fredbi))
- Add go report card and golangci badges [\#1590](https://github.com/go-swagger/go-swagger/pull/1590) ([fredbi](https://github.com/fredbi))
- Doc for new flatten [\#1589](https://github.com/go-swagger/go-swagger/pull/1589) ([fredbi](https://github.com/fredbi))
- Minimal flatten [\#1588](https://github.com/go-swagger/go-swagger/pull/1588) ([fredbi](https://github.com/fredbi))
- Add license scan report and status [\#1586](https://github.com/go-swagger/go-swagger/pull/1586) ([fossabot](https://github.com/fossabot))
- Update vendor 20180630 [\#1585](https://github.com/go-swagger/go-swagger/pull/1585) ([fredbi](https://github.com/fredbi))
- Create .golangci.yml [\#1578](https://github.com/go-swagger/go-swagger/pull/1578) ([JonKohler](https://github.com/JonKohler))
- Update README.md to add Nutanix to the list [\#1577](https://github.com/go-swagger/go-swagger/pull/1577) ([JonKohler](https://github.com/JonKohler))
- Replace tylerb/graceful with inbuilt methods Go 1.8 onwards - new request [\#1574](https://github.com/go-swagger/go-swagger/pull/1574) ([tortuoise](https://github.com/tortuoise))
- fix: Shutdown method didn't shutdown all the schemes [\#1569](https://github.com/go-swagger/go-swagger/pull/1569) ([dreamlover](https://github.com/dreamlover))
- Anonymous body parameters and responses [\#1568](https://github.com/go-swagger/go-swagger/pull/1568) ([fredbi](https://github.com/fredbi))
- swagger:type Documentation [\#1567](https://github.com/go-swagger/go-swagger/pull/1567) ([nathanwilk7](https://github.com/nathanwilk7))
- Render and validate maps in body parameters [\#1566](https://github.com/go-swagger/go-swagger/pull/1566) ([fredbi](https://github.com/fredbi))
- Fix typo in clone command [\#1564](https://github.com/go-swagger/go-swagger/pull/1564) ([dbmalkovsky](https://github.com/dbmalkovsky))
- Generate consumer/producer handlers that are not whitelisted [\#1557](https://github.com/go-swagger/go-swagger/pull/1557) ([Xzya](https://github.com/Xzya))
- Doc dependencies requirement [\#1555](https://github.com/go-swagger/go-swagger/pull/1555) ([fredbi](https://github.com/fredbi))
- Allow parameter code generation when struct is inside a function. [\#1550](https://github.com/go-swagger/go-swagger/pull/1550) ([josephspurrier](https://github.com/josephspurrier))

\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*