// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewElapseParams creates a new ElapseParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewElapseParams() *ElapseParams {
	return &ElapseParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewElapseParamsWithTimeout creates a new ElapseParams object
// with the ability to set a timeout on a request.
func NewElapseParamsWithTimeout(timeout time.Duration) *ElapseParams {
	return &ElapseParams{
		timeout: timeout,
	}
}

// NewElapseParamsWithContext creates a new ElapseParams object
// with the ability to set a context for a request.
func NewElapseParamsWithContext(ctx context.Context) *ElapseParams {
	return &ElapseParams{
		Context: ctx,
	}
}

// NewElapseParamsWithHTTPClient creates a new ElapseParams object
// with the ability to set a custom HTTPClient for a request.
func NewElapseParamsWithHTTPClient(client *http.Client) *ElapseParams {
	return &ElapseParams{
		HTTPClient: client,
	}
}

/*
ElapseParams contains all the parameters to send to the API endpoint

	for the elapse operation.

	Typically these are written to a http.Request.
*/
type ElapseParams struct {

	/* Length.

	   How many seconds to count down
	*/
	Length int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the elapse params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ElapseParams) WithDefaults() *ElapseParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the elapse params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ElapseParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the elapse params
func (o *ElapseParams) WithTimeout(timeout time.Duration) *ElapseParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the elapse params
func (o *ElapseParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the elapse params
func (o *ElapseParams) WithContext(ctx context.Context) *ElapseParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the elapse params
func (o *ElapseParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the elapse params
func (o *ElapseParams) WithHTTPClient(client *http.Client) *ElapseParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the elapse params
func (o *ElapseParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLength adds the length to the elapse params
func (o *ElapseParams) WithLength(length int64) *ElapseParams {
	o.SetLength(length)
	return o
}

// SetLength adds the length to the elapse params
func (o *ElapseParams) SetLength(length int64) {
	o.Length = length
}

// WriteToRequest writes these params to a swagger request
func (o *ElapseParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param length
	if err := r.SetPathParam("length", swag.FormatInt64(o.Length)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
