// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type RepresentativeInfoReason string

const (
	RepresentativeInfoReasonUnknown           RepresentativeInfoReason = ""
	RepresentativeInfoReasonProtocolPortCount RepresentativeInfoReason = "protocol_port_count"
	RepresentativeInfoReasonIncapsula         RepresentativeInfoReason = "incapsula"
	RepresentativeInfoReasonZscaler           RepresentativeInfoReason = "zscaler"
)

func (e RepresentativeInfoReason) ToPointer() *RepresentativeInfoReason {
	return &e
}
func (e *RepresentativeInfoReason) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "protocol_port_count":
		fallthrough
	case "incapsula":
		fallthrough
	case "zscaler":
		*e = RepresentativeInfoReason(v)
		return nil
	default:
		return fmt.Errorf("invalid value for RepresentativeInfoReason: %v", v)
	}
}

type RepresentativeInfo struct {
	ExcludedPorts    []int                     `json:"excluded_ports,omitempty"`
	Reason           *RepresentativeInfoReason `json:"reason,omitempty"`
	RepresentedPorts []int                     `json:"represented_ports,omitempty"`
	SampledPort      *int                      `json:"sampled_port,omitempty"`
}

func (o *RepresentativeInfo) GetExcludedPorts() []int {
	if o == nil {
		return nil
	}
	return o.ExcludedPorts
}

func (o *RepresentativeInfo) GetReason() *RepresentativeInfoReason {
	if o == nil {
		return nil
	}
	return o.Reason
}

func (o *RepresentativeInfo) GetRepresentedPorts() []int {
	if o == nil {
		return nil
	}
	return o.RepresentedPorts
}

func (o *RepresentativeInfo) GetSampledPort() *int {
	if o == nil {
		return nil
	}
	return o.SampledPort
}
