// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

type Redis struct {
	// The architecture bits (32 or 64) the Redis server used to build.
	ArchBits *string `json:"arch_bits,omitempty"`
	// The response from the AUTH command, if sent.
	AuthResponse *string `json:"auth_response,omitempty"`
	// The Build ID of the Redis server.
	BuildID *string `json:"build_id,omitempty"`
	// The list of commands actually sent to the server, serialized in inline format, like 'PING' or 'AUTH somePassword'.
	Commands []string `json:"commands,omitempty"`
	// The total number of commands processed by the server.
	CommandsProcessed *int `json:"commands_processed,omitempty"`
	// The total number of connections accepted by the server.
	ConnectionsReceived *int `json:"connections_received,omitempty"`
	// The version of the GCC compiler used to compile the Redis server.
	GccVersion *string `json:"gcc_version,omitempty"`
	// The Sha-1 Git commit hash the Redis server used.
	GitSha1 *string `json:"git_sha1,omitempty"`
	// The response from the INFO command. Should be a series of key:value pairs separated by CRLFs.
	InfoResponse map[string]string `json:"info_response,omitempty"`
	// Major is the version's major number.
	Major *int `json:"major,omitempty"`
	// The memory allocator.
	MemAllocator *string `json:"mem_allocator,omitempty"`
	// Minor is the version's major number.
	Minor *int `json:"minor,omitempty"`
	// The mode the Redis server is running (standalone or cluster), read from the the info_response (if available).
	Mode *string `json:"mode,omitempty"`
	// The response from the NONEXISTENT command.
	NonexistentResponse *string `json:"nonexistent_response,omitempty"`
	// The OS the Redis server is running, read from the the info_response (if available).
	Os *string `json:"os,omitempty"`
	// Patchlevel is the version's patchlevel number.
	PatchLevel *int `json:"patch_level,omitempty"`
	// The response from the PING command; should either be "PONG" or an authentication error.
	PingResponse *string `json:"ping_response,omitempty"`
	// The response to the QUIT command.
	QuitResponse *string `json:"quit_response,omitempty"`
	// The raw output returned by the server for each command sent; the indices match those of commands.
	RawCommandOutput []RedisRawOutput `json:"raw_command_output,omitempty"`
	// The number of seconds since Redis server start.
	Uptime *int `json:"uptime,omitempty"`
	// The total number of bytes allocated by Redis using its allocator.
	UsedMemory *int `json:"used_memory,omitempty"`
}

func (o *Redis) GetArchBits() *string {
	if o == nil {
		return nil
	}
	return o.ArchBits
}

func (o *Redis) GetAuthResponse() *string {
	if o == nil {
		return nil
	}
	return o.AuthResponse
}

func (o *Redis) GetBuildID() *string {
	if o == nil {
		return nil
	}
	return o.BuildID
}

func (o *Redis) GetCommands() []string {
	if o == nil {
		return nil
	}
	return o.Commands
}

func (o *Redis) GetCommandsProcessed() *int {
	if o == nil {
		return nil
	}
	return o.CommandsProcessed
}

func (o *Redis) GetConnectionsReceived() *int {
	if o == nil {
		return nil
	}
	return o.ConnectionsReceived
}

func (o *Redis) GetGccVersion() *string {
	if o == nil {
		return nil
	}
	return o.GccVersion
}

func (o *Redis) GetGitSha1() *string {
	if o == nil {
		return nil
	}
	return o.GitSha1
}

func (o *Redis) GetInfoResponse() map[string]string {
	if o == nil {
		return nil
	}
	return o.InfoResponse
}

func (o *Redis) GetMajor() *int {
	if o == nil {
		return nil
	}
	return o.Major
}

func (o *Redis) GetMemAllocator() *string {
	if o == nil {
		return nil
	}
	return o.MemAllocator
}

func (o *Redis) GetMinor() *int {
	if o == nil {
		return nil
	}
	return o.Minor
}

func (o *Redis) GetMode() *string {
	if o == nil {
		return nil
	}
	return o.Mode
}

func (o *Redis) GetNonexistentResponse() *string {
	if o == nil {
		return nil
	}
	return o.NonexistentResponse
}

func (o *Redis) GetOs() *string {
	if o == nil {
		return nil
	}
	return o.Os
}

func (o *Redis) GetPatchLevel() *int {
	if o == nil {
		return nil
	}
	return o.PatchLevel
}

func (o *Redis) GetPingResponse() *string {
	if o == nil {
		return nil
	}
	return o.PingResponse
}

func (o *Redis) GetQuitResponse() *string {
	if o == nil {
		return nil
	}
	return o.QuitResponse
}

func (o *Redis) GetRawCommandOutput() []RedisRawOutput {
	if o == nil {
		return nil
	}
	return o.RawCommandOutput
}

func (o *Redis) GetUptime() *int {
	if o == nil {
		return nil
	}
	return o.Uptime
}

func (o *Redis) GetUsedMemory() *int {
	if o == nil {
		return nil
	}
	return o.UsedMemory
}
