#!/bin/sh

# This test makes sure that we can load a previously saved bundle.
#
# The bundle is the .tgz, it is generated by the make_bundle.sh script, which
# requires `opa` to be in PATH.

set -e
set -u
set -x

if [ ! -f ./bundle.tar.gz ] ; then
	echo "no ./bundle.tar.gz, maybe you need to run make_bundle.sh?" 1>&2
	exit 1
fi

rm -f ./actual.txt
trap "rm -f ./actual.txt" EXIT

"$RQ" --v0-compatible --raw --bundle ./bundle.tar.gz 'data.main.likes_hiking' | sort > actual.txt
diff expect.txt actual.txt

# Also make sure that the RQ_REGO_V0 env var is respected.
RQ_REGO_V0=true "$RQ" --raw --bundle ./bundle.tar.gz 'data.main.likes_hiking' | sort > actual.txt
diff expect.txt actual.txt
